"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from datetime import datetime
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        ActionsArtifactAndLogRetentionResponse,
        ActionsEnterprisePermissions,
        ActionsForkPrContributorApproval,
        ActionsForkPrWorkflowsPrivateRepos,
        AnnouncementBanner,
        AuditLogEvent,
        AuditLogStreamKey,
        AuthenticationToken,
        CustomProperty,
        EnterpriseSecurityAnalysisSettings,
        EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
        EnterprisesEnterpriseActionsPermissionsSelfHostedRunnersGetResponse200,
        EnterprisesEnterpriseActionsRunnerGroupsGetResponse200,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        EnterprisesEnterpriseActionsRunnersGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseNetworkConfigurationsGetResponse200,
        GetAuditLogStreamConfig,
        GetAuditLogStreamConfigsItems,
        GetConsumedLicenses,
        GetLicenseSyncStatus,
        NetworkConfiguration,
        NetworkSettings,
        PushRuleBypassRequest,
        RulesetVersion,
        RulesetVersionWithState,
        Runner,
        RunnerApplication,
        RunnerGroupsEnterprise,
        ScimEnterpriseGroupList,
        ScimEnterpriseGroupResponse,
        ScimEnterpriseUserList,
        ScimEnterpriseUserResponse,
        SelectedActions,
    )
    from ..types import (
        ActionsArtifactAndLogRetentionResponseType,
        ActionsArtifactAndLogRetentionType,
        ActionsEnterprisePermissionsType,
        ActionsForkPrContributorApprovalType,
        ActionsForkPrWorkflowsPrivateReposRequestType,
        ActionsForkPrWorkflowsPrivateReposType,
        AmazonS3AccessKeysConfigType,
        AmazonS3OidcConfigType,
        AnnouncementBannerType,
        AnnouncementType,
        AuditLogEventType,
        AuditLogStreamKeyType,
        AuthenticationTokenType,
        AzureBlobConfigType,
        AzureHubConfigType,
        CustomPropertySetPayloadType,
        CustomPropertyType,
        DatadogConfigType,
        EnterpriseSecurityAnalysisSettingsType,
        EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200Type,
        EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType,
        EnterprisesEnterpriseActionsPermissionsPutBodyType,
        EnterprisesEnterpriseActionsPermissionsSelfHostedRunnersGetResponse200Type,
        EnterprisesEnterpriseActionsPermissionsSelfHostedRunnersPutBodyType,
        EnterprisesEnterpriseActionsRunnerGroupsGetResponse200Type,
        EnterprisesEnterpriseActionsRunnerGroupsPostBodyType,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200Type,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200Type,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
        EnterprisesEnterpriseActionsRunnersGetResponse200Type,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200Type,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType,
        EnterprisesEnterpriseAuditLogStreamsPostBodyType,
        EnterprisesEnterpriseAuditLogStreamsStreamIdPutBodyType,
        EnterprisesEnterpriseCodeSecurityAndAnalysisPatchBodyType,
        EnterprisesEnterpriseNetworkConfigurationsGetResponse200Type,
        EnterprisesEnterpriseNetworkConfigurationsNetworkConfigurationIdPatchBodyType,
        EnterprisesEnterpriseNetworkConfigurationsPostBodyType,
        EnterprisesEnterprisePropertiesSchemaPatchBodyType,
        GetAuditLogStreamConfigsItemsType,
        GetAuditLogStreamConfigType,
        GetConsumedLicensesType,
        GetLicenseSyncStatusType,
        GoogleCloudConfigType,
        GroupPropMembersItemsType,
        GroupType,
        HecConfigType,
        NetworkConfigurationType,
        NetworkSettingsType,
        PatchSchemaPropOperationsItemsType,
        PatchSchemaType,
        PushRuleBypassRequestType,
        RulesetVersionType,
        RulesetVersionWithStateType,
        RunnerApplicationType,
        RunnerGroupsEnterpriseType,
        RunnerType,
        ScimEnterpriseGroupListType,
        ScimEnterpriseGroupResponseType,
        ScimEnterpriseUserListType,
        ScimEnterpriseUserResponseType,
        SelectedActionsType,
        SplunkConfigType,
        UserEmailsItemsType,
        UserNameType,
        UserRoleItemsType,
        UserType,
    )


class EnterpriseAdminClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def get_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsEnterprisePermissions, ActionsEnterprisePermissionsType]:
        """enterprise-admin/get-github-actions-permissions-enterprise

        GET /enterprises/{enterprise}/actions/permissions

        Gets the GitHub Actions permissions policy for organizations and allowed actions and reusable workflows in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-github-actions-permissions-for-an-enterprise
        """

        from ..models import ActionsEnterprisePermissions

        url = f"/enterprises/{enterprise}/actions/permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsEnterprisePermissions,
        )

    async def async_get_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsEnterprisePermissions, ActionsEnterprisePermissionsType]:
        """enterprise-admin/get-github-actions-permissions-enterprise

        GET /enterprises/{enterprise}/actions/permissions

        Gets the GitHub Actions permissions policy for organizations and allowed actions and reusable workflows in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-github-actions-permissions-for-an-enterprise
        """

        from ..models import ActionsEnterprisePermissions

        url = f"/enterprises/{enterprise}/actions/permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsEnterprisePermissions,
        )

    @overload
    def set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsPermissionsPutBodyType,
    ) -> Response: ...

    @overload
    def set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        enabled_organizations: Literal["all", "none", "selected"],
        allowed_actions: Missing[Literal["all", "local_only", "selected"]] = UNSET,
    ) -> Response: ...

    def set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[EnterprisesEnterpriseActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-admin/set-github-actions-permissions-enterprise

        PUT /enterprises/{enterprise}/actions/permissions

        Sets the GitHub Actions permissions policy for organizations and allowed actions and reusable workflows in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-github-actions-permissions-for-an-enterprise
        """

        from ..models import EnterprisesEnterpriseActionsPermissionsPutBody

        url = f"/enterprises/{enterprise}/actions/permissions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsPermissionsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsPermissionsPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        enabled_organizations: Literal["all", "none", "selected"],
        allowed_actions: Missing[Literal["all", "local_only", "selected"]] = UNSET,
    ) -> Response: ...

    async def async_set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[EnterprisesEnterpriseActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-admin/set-github-actions-permissions-enterprise

        PUT /enterprises/{enterprise}/actions/permissions

        Sets the GitHub Actions permissions policy for organizations and allowed actions and reusable workflows in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-github-actions-permissions-for-an-enterprise
        """

        from ..models import EnterprisesEnterpriseActionsPermissionsPutBody

        url = f"/enterprises/{enterprise}/actions/permissions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsPermissionsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def get_artifact_and_log_retention_settings(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsArtifactAndLogRetentionResponse,
        ActionsArtifactAndLogRetentionResponseType,
    ]:
        """enterprise-admin/get-artifact-and-log-retention-settings

        GET /enterprises/{enterprise}/actions/permissions/artifact-and-log-retention

        Gets artifact and log retention settings for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-artifact-and-log-retention-settings-for-an-enterprise
        """

        from ..models import ActionsArtifactAndLogRetentionResponse, BasicError

        url = (
            f"/enterprises/{enterprise}/actions/permissions/artifact-and-log-retention"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsArtifactAndLogRetentionResponse,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_artifact_and_log_retention_settings(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsArtifactAndLogRetentionResponse,
        ActionsArtifactAndLogRetentionResponseType,
    ]:
        """enterprise-admin/get-artifact-and-log-retention-settings

        GET /enterprises/{enterprise}/actions/permissions/artifact-and-log-retention

        Gets artifact and log retention settings for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-artifact-and-log-retention-settings-for-an-enterprise
        """

        from ..models import ActionsArtifactAndLogRetentionResponse, BasicError

        url = (
            f"/enterprises/{enterprise}/actions/permissions/artifact-and-log-retention"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsArtifactAndLogRetentionResponse,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_artifact_and_log_retention_settings(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsArtifactAndLogRetentionType,
    ) -> Response: ...

    @overload
    def set_artifact_and_log_retention_settings(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        days: int,
    ) -> Response: ...

    def set_artifact_and_log_retention_settings(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsArtifactAndLogRetentionType] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-admin/set-artifact-and-log-retention-settings

        PUT /enterprises/{enterprise}/actions/permissions/artifact-and-log-retention

        Sets artifact and log retention settings for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-artifact-and-log-retention-settings-for-an-enterprise
        """

        from ..models import ActionsArtifactAndLogRetention, BasicError, ValidationError

        url = (
            f"/enterprises/{enterprise}/actions/permissions/artifact-and-log-retention"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsArtifactAndLogRetention, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_artifact_and_log_retention_settings(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsArtifactAndLogRetentionType,
    ) -> Response: ...

    @overload
    async def async_set_artifact_and_log_retention_settings(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        days: int,
    ) -> Response: ...

    async def async_set_artifact_and_log_retention_settings(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsArtifactAndLogRetentionType] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-admin/set-artifact-and-log-retention-settings

        PUT /enterprises/{enterprise}/actions/permissions/artifact-and-log-retention

        Sets artifact and log retention settings for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-artifact-and-log-retention-settings-for-an-enterprise
        """

        from ..models import ActionsArtifactAndLogRetention, BasicError, ValidationError

        url = (
            f"/enterprises/{enterprise}/actions/permissions/artifact-and-log-retention"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsArtifactAndLogRetention, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_fork_pr_contributor_approval_permissions(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsForkPrContributorApproval, ActionsForkPrContributorApprovalType
    ]:
        """enterprise-admin/get-fork-pr-contributor-approval-permissions

        GET /enterprises/{enterprise}/actions/permissions/fork-pr-contributor-approval

        Gets the fork PR contributor approval policy for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-fork-pr-contributor-approval-permissions-for-an-enterprise
        """

        from ..models import ActionsForkPrContributorApproval, BasicError

        url = f"/enterprises/{enterprise}/actions/permissions/fork-pr-contributor-approval"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsForkPrContributorApproval,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_fork_pr_contributor_approval_permissions(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsForkPrContributorApproval, ActionsForkPrContributorApprovalType
    ]:
        """enterprise-admin/get-fork-pr-contributor-approval-permissions

        GET /enterprises/{enterprise}/actions/permissions/fork-pr-contributor-approval

        Gets the fork PR contributor approval policy for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-fork-pr-contributor-approval-permissions-for-an-enterprise
        """

        from ..models import ActionsForkPrContributorApproval, BasicError

        url = f"/enterprises/{enterprise}/actions/permissions/fork-pr-contributor-approval"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsForkPrContributorApproval,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_fork_pr_contributor_approval_permissions(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsForkPrContributorApprovalType,
    ) -> Response: ...

    @overload
    def set_fork_pr_contributor_approval_permissions(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        approval_policy: Literal[
            "first_time_contributors_new_to_github",
            "first_time_contributors",
            "all_external_contributors",
        ],
    ) -> Response: ...

    def set_fork_pr_contributor_approval_permissions(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsForkPrContributorApprovalType] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-admin/set-fork-pr-contributor-approval-permissions

        PUT /enterprises/{enterprise}/actions/permissions/fork-pr-contributor-approval

        Sets the fork PR contributor approval policy for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-fork-pr-contributor-approval-permissions-for-an-enterprise
        """

        from ..models import (
            ActionsForkPrContributorApproval,
            BasicError,
            ValidationError,
        )

        url = f"/enterprises/{enterprise}/actions/permissions/fork-pr-contributor-approval"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsForkPrContributorApproval, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_fork_pr_contributor_approval_permissions(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsForkPrContributorApprovalType,
    ) -> Response: ...

    @overload
    async def async_set_fork_pr_contributor_approval_permissions(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        approval_policy: Literal[
            "first_time_contributors_new_to_github",
            "first_time_contributors",
            "all_external_contributors",
        ],
    ) -> Response: ...

    async def async_set_fork_pr_contributor_approval_permissions(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsForkPrContributorApprovalType] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-admin/set-fork-pr-contributor-approval-permissions

        PUT /enterprises/{enterprise}/actions/permissions/fork-pr-contributor-approval

        Sets the fork PR contributor approval policy for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-fork-pr-contributor-approval-permissions-for-an-enterprise
        """

        from ..models import (
            ActionsForkPrContributorApproval,
            BasicError,
            ValidationError,
        )

        url = f"/enterprises/{enterprise}/actions/permissions/fork-pr-contributor-approval"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsForkPrContributorApproval, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_private_repo_fork_pr_workflows_settings(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsForkPrWorkflowsPrivateRepos, ActionsForkPrWorkflowsPrivateReposType
    ]:
        """enterprise-admin/get-private-repo-fork-pr-workflows-settings

        GET /enterprises/{enterprise}/actions/permissions/fork-pr-workflows-private-repos

        Gets the settings for whether workflows from fork pull requests can run on private repositories in an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-private-repo-fork-pr-workflow-settings-for-an-enterprise
        """

        from ..models import ActionsForkPrWorkflowsPrivateRepos, BasicError

        url = f"/enterprises/{enterprise}/actions/permissions/fork-pr-workflows-private-repos"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsForkPrWorkflowsPrivateRepos,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_private_repo_fork_pr_workflows_settings(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsForkPrWorkflowsPrivateRepos, ActionsForkPrWorkflowsPrivateReposType
    ]:
        """enterprise-admin/get-private-repo-fork-pr-workflows-settings

        GET /enterprises/{enterprise}/actions/permissions/fork-pr-workflows-private-repos

        Gets the settings for whether workflows from fork pull requests can run on private repositories in an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-private-repo-fork-pr-workflow-settings-for-an-enterprise
        """

        from ..models import ActionsForkPrWorkflowsPrivateRepos, BasicError

        url = f"/enterprises/{enterprise}/actions/permissions/fork-pr-workflows-private-repos"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsForkPrWorkflowsPrivateRepos,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_private_repo_fork_pr_workflows_settings(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsForkPrWorkflowsPrivateReposRequestType,
    ) -> Response: ...

    @overload
    def set_private_repo_fork_pr_workflows_settings(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        run_workflows_from_fork_pull_requests: bool,
        send_write_tokens_to_workflows: Missing[bool] = UNSET,
        send_secrets_and_variables: Missing[bool] = UNSET,
        require_approval_for_fork_pr_workflows: Missing[bool] = UNSET,
    ) -> Response: ...

    def set_private_repo_fork_pr_workflows_settings(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsForkPrWorkflowsPrivateReposRequestType] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-admin/set-private-repo-fork-pr-workflows-settings

        PUT /enterprises/{enterprise}/actions/permissions/fork-pr-workflows-private-repos

        Sets the settings for whether workflows from fork pull requests can run on private repositories in an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-private-repo-fork-pr-workflow-settings-for-an-enterprise
        """

        from ..models import (
            ActionsForkPrWorkflowsPrivateReposRequest,
            BasicError,
            ValidationError,
        )

        url = f"/enterprises/{enterprise}/actions/permissions/fork-pr-workflows-private-repos"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsForkPrWorkflowsPrivateReposRequest, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_private_repo_fork_pr_workflows_settings(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsForkPrWorkflowsPrivateReposRequestType,
    ) -> Response: ...

    @overload
    async def async_set_private_repo_fork_pr_workflows_settings(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        run_workflows_from_fork_pull_requests: bool,
        send_write_tokens_to_workflows: Missing[bool] = UNSET,
        send_secrets_and_variables: Missing[bool] = UNSET,
        require_approval_for_fork_pr_workflows: Missing[bool] = UNSET,
    ) -> Response: ...

    async def async_set_private_repo_fork_pr_workflows_settings(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsForkPrWorkflowsPrivateReposRequestType] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-admin/set-private-repo-fork-pr-workflows-settings

        PUT /enterprises/{enterprise}/actions/permissions/fork-pr-workflows-private-repos

        Sets the settings for whether workflows from fork pull requests can run on private repositories in an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-private-repo-fork-pr-workflow-settings-for-an-enterprise
        """

        from ..models import (
            ActionsForkPrWorkflowsPrivateReposRequest,
            BasicError,
            ValidationError,
        )

        url = f"/enterprises/{enterprise}/actions/permissions/fork-pr-workflows-private-repos"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsForkPrWorkflowsPrivateReposRequest, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
        EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200Type,
    ]:
        """enterprise-admin/list-selected-organizations-enabled-github-actions-enterprise

        GET /enterprises/{enterprise}/actions/permissions/organizations

        Lists the organizations that are selected to have GitHub Actions enabled in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#list-selected-organizations-enabled-for-github-actions-in-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/permissions/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
        )

    async def async_list_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
        EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200Type,
    ]:
        """enterprise-admin/list-selected-organizations-enabled-github-actions-enterprise

        GET /enterprises/{enterprise}/actions/permissions/organizations

        Lists the organizations that are selected to have GitHub Actions enabled in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#list-selected-organizations-enabled-for-github-actions-in-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/permissions/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
        )

    @overload
    def set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType,
    ) -> Response: ...

    @overload
    def set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_organization_ids: list[int],
    ) -> Response: ...

    def set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-admin/set-selected-organizations-enabled-github-actions-enterprise

        PUT /enterprises/{enterprise}/actions/permissions/organizations

        Replaces the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-selected-organizations-enabled-for-github-actions-in-an-enterprise
        """

        from ..models import EnterprisesEnterpriseActionsPermissionsOrganizationsPutBody

        url = f"/enterprises/{enterprise}/actions/permissions/organizations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsPermissionsOrganizationsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_organization_ids: list[int],
    ) -> Response: ...

    async def async_set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-admin/set-selected-organizations-enabled-github-actions-enterprise

        PUT /enterprises/{enterprise}/actions/permissions/organizations

        Replaces the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-selected-organizations-enabled-for-github-actions-in-an-enterprise
        """

        from ..models import EnterprisesEnterpriseActionsPermissionsOrganizationsPutBody

        url = f"/enterprises/{enterprise}/actions/permissions/organizations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsPermissionsOrganizationsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def enable_selected_organization_github_actions_enterprise(
        self,
        enterprise: str,
        org_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/enable-selected-organization-github-actions-enterprise

        PUT /enterprises/{enterprise}/actions/permissions/organizations/{org_id}

        Adds an organization to the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#enable-a-selected-organization-for-github-actions-in-an-enterprise
        """

        url = f"/enterprises/{enterprise}/actions/permissions/organizations/{org_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_enable_selected_organization_github_actions_enterprise(
        self,
        enterprise: str,
        org_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/enable-selected-organization-github-actions-enterprise

        PUT /enterprises/{enterprise}/actions/permissions/organizations/{org_id}

        Adds an organization to the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#enable-a-selected-organization-for-github-actions-in-an-enterprise
        """

        url = f"/enterprises/{enterprise}/actions/permissions/organizations/{org_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def disable_selected_organization_github_actions_enterprise(
        self,
        enterprise: str,
        org_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/disable-selected-organization-github-actions-enterprise

        DELETE /enterprises/{enterprise}/actions/permissions/organizations/{org_id}

        Removes an organization from the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#disable-a-selected-organization-for-github-actions-in-an-enterprise
        """

        url = f"/enterprises/{enterprise}/actions/permissions/organizations/{org_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_disable_selected_organization_github_actions_enterprise(
        self,
        enterprise: str,
        org_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/disable-selected-organization-github-actions-enterprise

        DELETE /enterprises/{enterprise}/actions/permissions/organizations/{org_id}

        Removes an organization from the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#disable-a-selected-organization-for-github-actions-in-an-enterprise
        """

        url = f"/enterprises/{enterprise}/actions/permissions/organizations/{org_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def get_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SelectedActions, SelectedActionsType]:
        """enterprise-admin/get-allowed-actions-enterprise

        GET /enterprises/{enterprise}/actions/permissions/selected-actions

        Gets the selected actions and reusable workflows that are allowed in an enterprise. To use this endpoint, the enterprise permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-allowed-actions-and-reusable-workflows-for-an-enterprise
        """

        from ..models import SelectedActions

        url = f"/enterprises/{enterprise}/actions/permissions/selected-actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SelectedActions,
        )

    async def async_get_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SelectedActions, SelectedActionsType]:
        """enterprise-admin/get-allowed-actions-enterprise

        GET /enterprises/{enterprise}/actions/permissions/selected-actions

        Gets the selected actions and reusable workflows that are allowed in an enterprise. To use this endpoint, the enterprise permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-allowed-actions-and-reusable-workflows-for-an-enterprise
        """

        from ..models import SelectedActions

        url = f"/enterprises/{enterprise}/actions/permissions/selected-actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SelectedActions,
        )

    @overload
    def set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: SelectedActionsType,
    ) -> Response: ...

    @overload
    def set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        github_owned_allowed: Missing[bool] = UNSET,
        verified_allowed: Missing[bool] = UNSET,
        patterns_allowed: Missing[list[str]] = UNSET,
    ) -> Response: ...

    def set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[SelectedActionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-admin/set-allowed-actions-enterprise

        PUT /enterprises/{enterprise}/actions/permissions/selected-actions

        Sets the actions and reusable workflows that are allowed in an enterprise. To use this endpoint, the enterprise permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-allowed-actions-and-reusable-workflows-for-an-enterprise
        """

        from ..models import SelectedActions

        url = f"/enterprises/{enterprise}/actions/permissions/selected-actions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(SelectedActions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: SelectedActionsType,
    ) -> Response: ...

    @overload
    async def async_set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        github_owned_allowed: Missing[bool] = UNSET,
        verified_allowed: Missing[bool] = UNSET,
        patterns_allowed: Missing[list[str]] = UNSET,
    ) -> Response: ...

    async def async_set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[SelectedActionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-admin/set-allowed-actions-enterprise

        PUT /enterprises/{enterprise}/actions/permissions/selected-actions

        Sets the actions and reusable workflows that are allowed in an enterprise. To use this endpoint, the enterprise permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-allowed-actions-and-reusable-workflows-for-an-enterprise
        """

        from ..models import SelectedActions

        url = f"/enterprises/{enterprise}/actions/permissions/selected-actions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(SelectedActions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def get_self_hosted_runners_permissions(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsPermissionsSelfHostedRunnersGetResponse200,
        EnterprisesEnterpriseActionsPermissionsSelfHostedRunnersGetResponse200Type,
    ]:
        """enterprise-admin/get-self-hosted-runners-permissions

        GET /enterprises/{enterprise}/actions/permissions/self-hosted-runners

        Gets the settings for whether organizations in the enterprise are allowed to manage self-hosted runners at the repository level.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-self-hosted-runners-permissions-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsPermissionsSelfHostedRunnersGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/permissions/self-hosted-runners"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsPermissionsSelfHostedRunnersGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_self_hosted_runners_permissions(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsPermissionsSelfHostedRunnersGetResponse200,
        EnterprisesEnterpriseActionsPermissionsSelfHostedRunnersGetResponse200Type,
    ]:
        """enterprise-admin/get-self-hosted-runners-permissions

        GET /enterprises/{enterprise}/actions/permissions/self-hosted-runners

        Gets the settings for whether organizations in the enterprise are allowed to manage self-hosted runners at the repository level.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-self-hosted-runners-permissions-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsPermissionsSelfHostedRunnersGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/permissions/self-hosted-runners"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsPermissionsSelfHostedRunnersGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_self_hosted_runners_permissions(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsPermissionsSelfHostedRunnersPutBodyType,
    ) -> Response: ...

    @overload
    def set_self_hosted_runners_permissions(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        disable_self_hosted_runners_for_all_orgs: bool,
    ) -> Response: ...

    def set_self_hosted_runners_permissions(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseActionsPermissionsSelfHostedRunnersPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-admin/set-self-hosted-runners-permissions

        PUT /enterprises/{enterprise}/actions/permissions/self-hosted-runners

        Sets the settings for whether organizations in the enterprise are allowed to manage self-hosted runners at the repository level.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-self-hosted-runners-permissions-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsPermissionsSelfHostedRunnersPutBody,
            ValidationError,
        )

        url = f"/enterprises/{enterprise}/actions/permissions/self-hosted-runners"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsPermissionsSelfHostedRunnersPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_self_hosted_runners_permissions(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsPermissionsSelfHostedRunnersPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_self_hosted_runners_permissions(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        disable_self_hosted_runners_for_all_orgs: bool,
    ) -> Response: ...

    async def async_set_self_hosted_runners_permissions(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseActionsPermissionsSelfHostedRunnersPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-admin/set-self-hosted-runners-permissions

        PUT /enterprises/{enterprise}/actions/permissions/self-hosted-runners

        Sets the settings for whether organizations in the enterprise are allowed to manage self-hosted runners at the repository level.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-self-hosted-runners-permissions-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsPermissionsSelfHostedRunnersPutBody,
            ValidationError,
        )

        url = f"/enterprises/{enterprise}/actions/permissions/self-hosted-runners"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsPermissionsSelfHostedRunnersPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_self_hosted_runner_groups_for_enterprise(
        self,
        enterprise: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        visible_to_organization: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnerGroupsGetResponse200,
        EnterprisesEnterpriseActionsRunnerGroupsGetResponse200Type,
    ]:
        """enterprise-admin/list-self-hosted-runner-groups-for-enterprise

        GET /enterprises/{enterprise}/actions/runner-groups

        Lists all self-hosted runner groups for an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-self-hosted-runner-groups-for-an-enterprise
        """

        from ..models import EnterprisesEnterpriseActionsRunnerGroupsGetResponse200

        url = f"/enterprises/{enterprise}/actions/runner-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "visible_to_organization": visible_to_organization,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnerGroupsGetResponse200,
        )

    async def async_list_self_hosted_runner_groups_for_enterprise(
        self,
        enterprise: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        visible_to_organization: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnerGroupsGetResponse200,
        EnterprisesEnterpriseActionsRunnerGroupsGetResponse200Type,
    ]:
        """enterprise-admin/list-self-hosted-runner-groups-for-enterprise

        GET /enterprises/{enterprise}/actions/runner-groups

        Lists all self-hosted runner groups for an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-self-hosted-runner-groups-for-an-enterprise
        """

        from ..models import EnterprisesEnterpriseActionsRunnerGroupsGetResponse200

        url = f"/enterprises/{enterprise}/actions/runner-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "visible_to_organization": visible_to_organization,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnerGroupsGetResponse200,
        )

    @overload
    def create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsRunnerGroupsPostBodyType,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]: ...

    @overload
    def create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        visibility: Missing[Literal["selected", "all"]] = UNSET,
        selected_organization_ids: Missing[list[int]] = UNSET,
        runners: Missing[list[int]] = UNSET,
        allows_public_repositories: Missing[bool] = UNSET,
        restricted_to_workflows: Missing[bool] = UNSET,
        selected_workflows: Missing[list[str]] = UNSET,
        network_configuration_id: Missing[str] = UNSET,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]: ...

    def create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[EnterprisesEnterpriseActionsRunnerGroupsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]:
        """enterprise-admin/create-self-hosted-runner-group-for-enterprise

        POST /enterprises/{enterprise}/actions/runner-groups

        Creates a new self-hosted runner group for an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#create-a-self-hosted-runner-group-for-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsPostBody,
            RunnerGroupsEnterprise,
        )

        url = f"/enterprises/{enterprise}/actions/runner-groups"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnerGroupsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RunnerGroupsEnterprise,
        )

    @overload
    async def async_create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsRunnerGroupsPostBodyType,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]: ...

    @overload
    async def async_create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        visibility: Missing[Literal["selected", "all"]] = UNSET,
        selected_organization_ids: Missing[list[int]] = UNSET,
        runners: Missing[list[int]] = UNSET,
        allows_public_repositories: Missing[bool] = UNSET,
        restricted_to_workflows: Missing[bool] = UNSET,
        selected_workflows: Missing[list[str]] = UNSET,
        network_configuration_id: Missing[str] = UNSET,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]: ...

    async def async_create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[EnterprisesEnterpriseActionsRunnerGroupsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]:
        """enterprise-admin/create-self-hosted-runner-group-for-enterprise

        POST /enterprises/{enterprise}/actions/runner-groups

        Creates a new self-hosted runner group for an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#create-a-self-hosted-runner-group-for-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsPostBody,
            RunnerGroupsEnterprise,
        )

        url = f"/enterprises/{enterprise}/actions/runner-groups"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnerGroupsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RunnerGroupsEnterprise,
        )

    def get_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]:
        """enterprise-admin/get-self-hosted-runner-group-for-enterprise

        GET /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}

        Gets a specific self-hosted runner group for an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#get-a-self-hosted-runner-group-for-an-enterprise
        """

        from ..models import RunnerGroupsEnterprise

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RunnerGroupsEnterprise,
        )

    async def async_get_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]:
        """enterprise-admin/get-self-hosted-runner-group-for-enterprise

        GET /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}

        Gets a specific self-hosted runner group for an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#get-a-self-hosted-runner-group-for-an-enterprise
        """

        from ..models import RunnerGroupsEnterprise

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RunnerGroupsEnterprise,
        )

    def delete_self_hosted_runner_group_from_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/delete-self-hosted-runner-group-from-enterprise

        DELETE /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}

        Deletes a self-hosted runner group for an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#delete-a-self-hosted-runner-group-from-an-enterprise
        """

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_self_hosted_runner_group_from_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/delete-self-hosted-runner-group-from-enterprise

        DELETE /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}

        Deletes a self-hosted runner group for an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#delete-a-self-hosted-runner-group-from-an-enterprise
        """

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    def update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType
        ] = UNSET,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]: ...

    @overload
    def update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        visibility: Missing[Literal["selected", "all"]] = UNSET,
        allows_public_repositories: Missing[bool] = UNSET,
        restricted_to_workflows: Missing[bool] = UNSET,
        selected_workflows: Missing[list[str]] = UNSET,
        network_configuration_id: Missing[Union[str, None]] = UNSET,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]: ...

    def update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]:
        """enterprise-admin/update-self-hosted-runner-group-for-enterprise

        PATCH /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}

        Updates the `name` and `visibility` of a self-hosted runner group in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#update-a-self-hosted-runner-group-for-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBody,
            RunnerGroupsEnterprise,
        )

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RunnerGroupsEnterprise,
        )

    @overload
    async def async_update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType
        ] = UNSET,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]: ...

    @overload
    async def async_update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        visibility: Missing[Literal["selected", "all"]] = UNSET,
        allows_public_repositories: Missing[bool] = UNSET,
        restricted_to_workflows: Missing[bool] = UNSET,
        selected_workflows: Missing[list[str]] = UNSET,
        network_configuration_id: Missing[Union[str, None]] = UNSET,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]: ...

    async def async_update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]:
        """enterprise-admin/update-self-hosted-runner-group-for-enterprise

        PATCH /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}

        Updates the `name` and `visibility` of a self-hosted runner group in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#update-a-self-hosted-runner-group-for-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBody,
            RunnerGroupsEnterprise,
        )

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RunnerGroupsEnterprise,
        )

    def list_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200Type,
    ]:
        """enterprise-admin/list-org-access-to-self-hosted-runner-group-in-enterprise

        GET /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations

        Lists the organizations with access to a self-hosted runner group.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-organization-access-to-a-self-hosted-runner-group-in-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
        )

    async def async_list_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200Type,
    ]:
        """enterprise-admin/list-org-access-to-self-hosted-runner-group-in-enterprise

        GET /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations

        Lists the organizations with access to a self-hosted runner group.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-organization-access-to-a-self-hosted-runner-group-in-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
        )

    @overload
    def set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType,
    ) -> Response: ...

    @overload
    def set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_organization_ids: list[int],
    ) -> Response: ...

    def set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-admin/set-org-access-to-self-hosted-runner-group-in-enterprise

        PUT /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations

        Replaces the list of organizations that have access to a self-hosted runner configured in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#set-organization-access-for-a-self-hosted-runner-group-in-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBody,
        )

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_organization_ids: list[int],
    ) -> Response: ...

    async def async_set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-admin/set-org-access-to-self-hosted-runner-group-in-enterprise

        PUT /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations

        Replaces the list of organizations that have access to a self-hosted runner configured in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#set-organization-access-for-a-self-hosted-runner-group-in-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBody,
        )

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def add_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        org_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/add-org-access-to-self-hosted-runner-group-in-enterprise

        PUT /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}

        Adds an organization to the list of selected organizations that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an enterprise](#create-a-self-hosted-runner-group-for-an-enterprise)."

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#add-organization-access-to-a-self-hosted-runner-group-in-an-enterprise
        """

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_add_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        org_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/add-org-access-to-self-hosted-runner-group-in-enterprise

        PUT /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}

        Adds an organization to the list of selected organizations that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an enterprise](#create-a-self-hosted-runner-group-for-an-enterprise)."

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#add-organization-access-to-a-self-hosted-runner-group-in-an-enterprise
        """

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def remove_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        org_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/remove-org-access-to-self-hosted-runner-group-in-enterprise

        DELETE /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}

        Removes an organization from the list of selected organizations that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an enterprise](#create-a-self-hosted-runner-group-for-an-enterprise)."

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#remove-organization-access-to-a-self-hosted-runner-group-in-an-enterprise
        """

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_remove_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        org_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/remove-org-access-to-self-hosted-runner-group-in-enterprise

        DELETE /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}

        Removes an organization from the list of selected organizations that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an enterprise](#create-a-self-hosted-runner-group-for-an-enterprise)."

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#remove-organization-access-to-a-self-hosted-runner-group-in-an-enterprise
        """

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200Type,
    ]:
        """enterprise-admin/list-self-hosted-runners-in-group-for-enterprise

        GET /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners

        Lists the self-hosted runners that are in a specific enterprise group.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-self-hosted-runners-in-a-group-for-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

        url = (
            f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners"
        )

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200Type,
    ]:
        """enterprise-admin/list-self-hosted-runners-in-group-for-enterprise

        GET /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners

        Lists the self-hosted runners that are in a specific enterprise group.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-self-hosted-runners-in-a-group-for-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

        url = (
            f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners"
        )

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

    @overload
    def set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
    ) -> Response: ...

    @overload
    def set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        runners: list[int],
    ) -> Response: ...

    def set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-admin/set-self-hosted-runners-in-group-for-enterprise

        PUT /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners

        Replaces the list of self-hosted runners that are part of an enterprise runner group.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#set-self-hosted-runners-in-a-group-for-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBody,
        )

        url = (
            f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        runners: list[int],
    ) -> Response: ...

    async def async_set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-admin/set-self-hosted-runners-in-group-for-enterprise

        PUT /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners

        Replaces the list of self-hosted runners that are part of an enterprise runner group.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#set-self-hosted-runners-in-a-group-for-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBody,
        )

        url = (
            f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def add_self_hosted_runner_to_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/add-self-hosted-runner-to-group-for-enterprise

        PUT /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}

        Adds a self-hosted runner to a runner group configured in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#add-a-self-hosted-runner-to-a-group-for-an-enterprise
        """

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_add_self_hosted_runner_to_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/add-self-hosted-runner-to-group-for-enterprise

        PUT /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}

        Adds a self-hosted runner to a runner group configured in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#add-a-self-hosted-runner-to-a-group-for-an-enterprise
        """

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def remove_self_hosted_runner_from_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/remove-self-hosted-runner-from-group-for-enterprise

        DELETE /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}

        Removes a self-hosted runner from a group configured in an enterprise. The runner is then returned to the default group.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#remove-a-self-hosted-runner-from-a-group-for-an-enterprise
        """

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_remove_self_hosted_runner_from_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/remove-self-hosted-runner-from-group-for-enterprise

        DELETE /enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}

        Removes a self-hosted runner from a group configured in an enterprise. The runner is then returned to the default group.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#remove-a-self-hosted-runner-from-a-group-for-an-enterprise
        """

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_self_hosted_runners_for_enterprise(
        self,
        enterprise: str,
        *,
        name: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGetResponse200,
        EnterprisesEnterpriseActionsRunnersGetResponse200Type,
    ]:
        """enterprise-admin/list-self-hosted-runners-for-enterprise

        GET /enterprises/{enterprise}/actions/runners

        Lists all self-hosted runners configured for an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-self-hosted-runners-for-an-enterprise
        """

        from ..models import EnterprisesEnterpriseActionsRunnersGetResponse200

        url = f"/enterprises/{enterprise}/actions/runners"

        params = {
            "name": name,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_for_enterprise(
        self,
        enterprise: str,
        *,
        name: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGetResponse200,
        EnterprisesEnterpriseActionsRunnersGetResponse200Type,
    ]:
        """enterprise-admin/list-self-hosted-runners-for-enterprise

        GET /enterprises/{enterprise}/actions/runners

        Lists all self-hosted runners configured for an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-self-hosted-runners-for-an-enterprise
        """

        from ..models import EnterprisesEnterpriseActionsRunnersGetResponse200

        url = f"/enterprises/{enterprise}/actions/runners"

        params = {
            "name": name,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersGetResponse200,
        )

    def list_runner_applications_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RunnerApplication], list[RunnerApplicationType]]:
        """enterprise-admin/list-runner-applications-for-enterprise

        GET /enterprises/{enterprise}/actions/runners/downloads

        Lists binaries for the runner application that you can download and run.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-runner-applications-for-an-enterprise
        """

        from ..models import RunnerApplication

        url = f"/enterprises/{enterprise}/actions/runners/downloads"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RunnerApplication],
        )

    async def async_list_runner_applications_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RunnerApplication], list[RunnerApplicationType]]:
        """enterprise-admin/list-runner-applications-for-enterprise

        GET /enterprises/{enterprise}/actions/runners/downloads

        Lists binaries for the runner application that you can download and run.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-runner-applications-for-an-enterprise
        """

        from ..models import RunnerApplication

        url = f"/enterprises/{enterprise}/actions/runners/downloads"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RunnerApplication],
        )

    def create_registration_token_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[AuthenticationToken, AuthenticationTokenType]:
        """enterprise-admin/create-registration-token-for-enterprise

        POST /enterprises/{enterprise}/actions/runners/registration-token

        Returns a token that you can pass to the `config` script. The token expires after one hour.

        Example using registration token:

        Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.

        ```
        ./config.sh --url https://github.com/enterprises/octo-enterprise --token TOKEN
        ```

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-registration-token-for-an-enterprise
        """

        from ..models import AuthenticationToken

        url = f"/enterprises/{enterprise}/actions/runners/registration-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AuthenticationToken,
        )

    async def async_create_registration_token_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[AuthenticationToken, AuthenticationTokenType]:
        """enterprise-admin/create-registration-token-for-enterprise

        POST /enterprises/{enterprise}/actions/runners/registration-token

        Returns a token that you can pass to the `config` script. The token expires after one hour.

        Example using registration token:

        Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.

        ```
        ./config.sh --url https://github.com/enterprises/octo-enterprise --token TOKEN
        ```

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-registration-token-for-an-enterprise
        """

        from ..models import AuthenticationToken

        url = f"/enterprises/{enterprise}/actions/runners/registration-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AuthenticationToken,
        )

    def create_remove_token_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[AuthenticationToken, AuthenticationTokenType]:
        """enterprise-admin/create-remove-token-for-enterprise

        POST /enterprises/{enterprise}/actions/runners/remove-token

        Returns a token that you can pass to the `config` script to remove a self-hosted runner from an enterprise. The token expires after one hour.

        Example using remove token:

        To remove your self-hosted runner from an enterprise, replace `TOKEN` with the remove token provided by this
        endpoint.

        ```
        ./config.sh remove --token TOKEN
        ```

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-remove-token-for-an-enterprise
        """

        from ..models import AuthenticationToken

        url = f"/enterprises/{enterprise}/actions/runners/remove-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AuthenticationToken,
        )

    async def async_create_remove_token_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[AuthenticationToken, AuthenticationTokenType]:
        """enterprise-admin/create-remove-token-for-enterprise

        POST /enterprises/{enterprise}/actions/runners/remove-token

        Returns a token that you can pass to the `config` script to remove a self-hosted runner from an enterprise. The token expires after one hour.

        Example using remove token:

        To remove your self-hosted runner from an enterprise, replace `TOKEN` with the remove token provided by this
        endpoint.

        ```
        ./config.sh remove --token TOKEN
        ```

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-remove-token-for-an-enterprise
        """

        from ..models import AuthenticationToken

        url = f"/enterprises/{enterprise}/actions/runners/remove-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AuthenticationToken,
        )

    def get_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Runner, RunnerType]:
        """enterprise-admin/get-self-hosted-runner-for-enterprise

        GET /enterprises/{enterprise}/actions/runners/{runner_id}

        Gets a specific self-hosted runner configured in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#get-a-self-hosted-runner-for-an-enterprise
        """

        from ..models import Runner

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Runner,
        )

    async def async_get_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Runner, RunnerType]:
        """enterprise-admin/get-self-hosted-runner-for-enterprise

        GET /enterprises/{enterprise}/actions/runners/{runner_id}

        Gets a specific self-hosted runner configured in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#get-a-self-hosted-runner-for-an-enterprise
        """

        from ..models import Runner

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Runner,
        )

    def delete_self_hosted_runner_from_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/delete-self-hosted-runner-from-enterprise

        DELETE /enterprises/{enterprise}/actions/runners/{runner_id}

        Forces the removal of a self-hosted runner from an enterprise. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#delete-a-self-hosted-runner-from-an-enterprise
        """

        from ..models import ValidationErrorSimple

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    async def async_delete_self_hosted_runner_from_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/delete-self-hosted-runner-from-enterprise

        DELETE /enterprises/{enterprise}/actions/runners/{runner_id}

        Forces the removal of a self-hosted runner from an enterprise. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#delete-a-self-hosted-runner-from-an-enterprise
        """

        from ..models import ValidationErrorSimple

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    def list_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """enterprise-admin/list-labels-for-self-hosted-runner-for-enterprise

        GET /enterprises/{enterprise}/actions/runners/{runner_id}/labels

        Lists all labels for a self-hosted runner configured in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-labels-for-a-self-hosted-runner-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """enterprise-admin/list-labels-for-self-hosted-runner-for-enterprise

        GET /enterprises/{enterprise}/actions/runners/{runner_id}/labels

        Lists all labels for a self-hosted runner configured in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-labels-for-a-self-hosted-runner-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    @overload
    def set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        labels: list[str],
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    def set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """enterprise-admin/set-custom-labels-for-self-hosted-runner-for-enterprise

        PUT /enterprises/{enterprise}/actions/runners/{runner_id}/labels

        Remove all previous custom labels and set the new custom labels for a specific
        self-hosted runner configured in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#set-custom-labels-for-a-self-hosted-runner-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBody,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        labels: list[str],
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    async def async_set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """enterprise-admin/set-custom-labels-for-self-hosted-runner-for-enterprise

        PUT /enterprises/{enterprise}/actions/runners/{runner_id}/labels

        Remove all previous custom labels and set the new custom labels for a specific
        self-hosted runner configured in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#set-custom-labels-for-a-self-hosted-runner-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBody,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    @overload
    def add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        labels: list[str],
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    def add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """enterprise-admin/add-custom-labels-to-self-hosted-runner-for-enterprise

        POST /enterprises/{enterprise}/actions/runners/{runner_id}/labels

        Add custom labels to a self-hosted runner configured in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#add-custom-labels-to-a-self-hosted-runner-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBody,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        labels: list[str],
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    async def async_add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """enterprise-admin/add-custom-labels-to-self-hosted-runner-for-enterprise

        POST /enterprises/{enterprise}/actions/runners/{runner_id}/labels

        Add custom labels to a self-hosted runner configured in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#add-custom-labels-to-a-self-hosted-runner-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBody,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def remove_all_custom_labels_from_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200Type,
    ]:
        """enterprise-admin/remove-all-custom-labels-from-self-hosted-runner-for-enterprise

        DELETE /enterprises/{enterprise}/actions/runners/{runner_id}/labels

        Remove all custom labels from a self-hosted runner configured in an
        enterprise. Returns the remaining read-only labels from the runner.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-all-custom-labels-from-a-self-hosted-runner-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_remove_all_custom_labels_from_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200Type,
    ]:
        """enterprise-admin/remove-all-custom-labels-from-self-hosted-runner-for-enterprise

        DELETE /enterprises/{enterprise}/actions/runners/{runner_id}/labels

        Remove all custom labels from a self-hosted runner configured in an
        enterprise. Returns the remaining read-only labels from the runner.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-all-custom-labels-from-a-self-hosted-runner-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def remove_custom_label_from_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """enterprise-admin/remove-custom-label-from-self-hosted-runner-for-enterprise

        DELETE /enterprises/{enterprise}/actions/runners/{runner_id}/labels/{name}

        Remove a custom label from a self-hosted runner configured
        in an enterprise. Returns the remaining labels from the runner.

        This endpoint returns a `404 Not Found` status if the custom label is not
        present on the runner.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-a-custom-label-from-a-self-hosted-runner-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_remove_custom_label_from_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """enterprise-admin/remove-custom-label-from-self-hosted-runner-for-enterprise

        DELETE /enterprises/{enterprise}/actions/runners/{runner_id}/labels/{name}

        Remove a custom label from a self-hosted runner configured
        in an enterprise. Returns the remaining labels from the runner.

        This endpoint returns a `404 Not Found` status if the custom label is not
        present on the runner.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-a-custom-label-from-a-self-hosted-runner-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_announcement_banner_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]:
        """announcement-banners/get-announcement-banner-for-enterprise

        GET /enterprises/{enterprise}/announcement

        Gets the announcement banner currently set for the enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/announcement-banners/enterprises#get-announcement-banner-for-enterprise
        """

        from ..models import AnnouncementBanner

        url = f"/enterprises/{enterprise}/announcement"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AnnouncementBanner,
        )

    async def async_get_announcement_banner_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]:
        """announcement-banners/get-announcement-banner-for-enterprise

        GET /enterprises/{enterprise}/announcement

        Gets the announcement banner currently set for the enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/announcement-banners/enterprises#get-announcement-banner-for-enterprise
        """

        from ..models import AnnouncementBanner

        url = f"/enterprises/{enterprise}/announcement"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AnnouncementBanner,
        )

    def remove_announcement_banner_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """announcement-banners/remove-announcement-banner-for-enterprise

        DELETE /enterprises/{enterprise}/announcement

        Removes the announcement banner currently set for the enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/announcement-banners/enterprises#remove-announcement-banner-from-enterprise
        """

        url = f"/enterprises/{enterprise}/announcement"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_remove_announcement_banner_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """announcement-banners/remove-announcement-banner-for-enterprise

        DELETE /enterprises/{enterprise}/announcement

        Removes the announcement banner currently set for the enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/announcement-banners/enterprises#remove-announcement-banner-from-enterprise
        """

        url = f"/enterprises/{enterprise}/announcement"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    def set_announcement_banner_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: AnnouncementType,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]: ...

    @overload
    def set_announcement_banner_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        announcement: Union[str, None],
        expires_at: Missing[Union[datetime, None]] = UNSET,
        user_dismissible: Missing[Union[bool, None]] = UNSET,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]: ...

    def set_announcement_banner_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[AnnouncementType] = UNSET,
        **kwargs,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]:
        """announcement-banners/set-announcement-banner-for-enterprise

        PATCH /enterprises/{enterprise}/announcement

        Sets the announcement banner to display for the enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/announcement-banners/enterprises#set-announcement-banner-for-enterprise
        """

        from ..models import Announcement, AnnouncementBanner

        url = f"/enterprises/{enterprise}/announcement"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Announcement, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AnnouncementBanner,
        )

    @overload
    async def async_set_announcement_banner_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: AnnouncementType,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]: ...

    @overload
    async def async_set_announcement_banner_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        announcement: Union[str, None],
        expires_at: Missing[Union[datetime, None]] = UNSET,
        user_dismissible: Missing[Union[bool, None]] = UNSET,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]: ...

    async def async_set_announcement_banner_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[AnnouncementType] = UNSET,
        **kwargs,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]:
        """announcement-banners/set-announcement-banner-for-enterprise

        PATCH /enterprises/{enterprise}/announcement

        Sets the announcement banner to display for the enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/announcement-banners/enterprises#set-announcement-banner-for-enterprise
        """

        from ..models import Announcement, AnnouncementBanner

        url = f"/enterprises/{enterprise}/announcement"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Announcement, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AnnouncementBanner,
        )

    def get_audit_log(
        self,
        enterprise: str,
        *,
        phrase: Missing[str] = UNSET,
        include: Missing[Literal["web", "git", "all"]] = UNSET,
        after: Missing[str] = UNSET,
        before: Missing[str] = UNSET,
        order: Missing[Literal["desc", "asc"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[AuditLogEvent], list[AuditLogEventType]]:
        """enterprise-admin/get-audit-log

        GET /enterprises/{enterprise}/audit-log

        Gets the audit log for an enterprise.

        This endpoint has a rate limit of 1,750 queries per hour per user and IP address. If your integration receives a rate limit error (typically a 403 or 429 response), it should wait before making another request to the GitHub API. For more information, see "[Rate limits for the REST API](https://docs.github.com/enterprise-cloud@latest//rest/using-the-rest-api/rate-limits-for-the-rest-api)" and "[Best practices for integrators](https://docs.github.com/enterprise-cloud@latest//rest/guides/best-practices-for-integrators)."

        The authenticated user must be an enterprise admin to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `read:audit_log` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#get-the-audit-log-for-an-enterprise
        """

        from ..models import AuditLogEvent

        url = f"/enterprises/{enterprise}/audit-log"

        params = {
            "phrase": phrase,
            "include": include,
            "after": after,
            "before": before,
            "order": order,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[AuditLogEvent],
        )

    async def async_get_audit_log(
        self,
        enterprise: str,
        *,
        phrase: Missing[str] = UNSET,
        include: Missing[Literal["web", "git", "all"]] = UNSET,
        after: Missing[str] = UNSET,
        before: Missing[str] = UNSET,
        order: Missing[Literal["desc", "asc"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[AuditLogEvent], list[AuditLogEventType]]:
        """enterprise-admin/get-audit-log

        GET /enterprises/{enterprise}/audit-log

        Gets the audit log for an enterprise.

        This endpoint has a rate limit of 1,750 queries per hour per user and IP address. If your integration receives a rate limit error (typically a 403 or 429 response), it should wait before making another request to the GitHub API. For more information, see "[Rate limits for the REST API](https://docs.github.com/enterprise-cloud@latest//rest/using-the-rest-api/rate-limits-for-the-rest-api)" and "[Best practices for integrators](https://docs.github.com/enterprise-cloud@latest//rest/guides/best-practices-for-integrators)."

        The authenticated user must be an enterprise admin to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `read:audit_log` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#get-the-audit-log-for-an-enterprise
        """

        from ..models import AuditLogEvent

        url = f"/enterprises/{enterprise}/audit-log"

        params = {
            "phrase": phrase,
            "include": include,
            "after": after,
            "before": before,
            "order": order,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[AuditLogEvent],
        )

    def get_audit_log_stream_key(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[AuditLogStreamKey, AuditLogStreamKeyType]:
        """enterprise-admin/get-audit-log-stream-key

        GET /enterprises/{enterprise}/audit-log/stream-key

        Retrieves the audit log streaming public key for encrypting secrets.

        When using this endpoint, you must encrypt the credentials following the same encryption steps as outlined in the guide on encrypting secrets. See "[Encrypting secrets for the REST API](/rest/guides/encrypting-secrets-for-the-rest-api)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#get-the-audit-log-stream-key-for-encrypting-secrets
        """

        from ..models import AuditLogStreamKey

        url = f"/enterprises/{enterprise}/audit-log/stream-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AuditLogStreamKey,
        )

    async def async_get_audit_log_stream_key(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[AuditLogStreamKey, AuditLogStreamKeyType]:
        """enterprise-admin/get-audit-log-stream-key

        GET /enterprises/{enterprise}/audit-log/stream-key

        Retrieves the audit log streaming public key for encrypting secrets.

        When using this endpoint, you must encrypt the credentials following the same encryption steps as outlined in the guide on encrypting secrets. See "[Encrypting secrets for the REST API](/rest/guides/encrypting-secrets-for-the-rest-api)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#get-the-audit-log-stream-key-for-encrypting-secrets
        """

        from ..models import AuditLogStreamKey

        url = f"/enterprises/{enterprise}/audit-log/stream-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AuditLogStreamKey,
        )

    def get_audit_log_streams(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[GetAuditLogStreamConfigsItems], list[GetAuditLogStreamConfigsItemsType]
    ]:
        """enterprise-admin/get-audit-log-streams

        GET /enterprises/{enterprise}/audit-log/streams

        Lists the configured audit log streaming configurations for an enterprise.
        This only lists configured streams for supported providers.

        When using this endpoint, you must encrypt the credentials following the same encryption steps as outlined in the guide on encrypting secrets. See "[Encrypting secrets for the REST API](/rest/guides/encrypting-secrets-for-the-rest-api)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#list-audit-log-stream-configurations-for-an-enterprise
        """

        from ..models import GetAuditLogStreamConfigsItems

        url = f"/enterprises/{enterprise}/audit-log/streams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[GetAuditLogStreamConfigsItems],
        )

    async def async_get_audit_log_streams(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[GetAuditLogStreamConfigsItems], list[GetAuditLogStreamConfigsItemsType]
    ]:
        """enterprise-admin/get-audit-log-streams

        GET /enterprises/{enterprise}/audit-log/streams

        Lists the configured audit log streaming configurations for an enterprise.
        This only lists configured streams for supported providers.

        When using this endpoint, you must encrypt the credentials following the same encryption steps as outlined in the guide on encrypting secrets. See "[Encrypting secrets for the REST API](/rest/guides/encrypting-secrets-for-the-rest-api)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#list-audit-log-stream-configurations-for-an-enterprise
        """

        from ..models import GetAuditLogStreamConfigsItems

        url = f"/enterprises/{enterprise}/audit-log/streams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[GetAuditLogStreamConfigsItems],
        )

    @overload
    def create_audit_log_stream(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseAuditLogStreamsPostBodyType,
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]: ...

    @overload
    def create_audit_log_stream(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        enabled: bool,
        stream_type: Literal[
            "Azure Blob Storage",
            "Azure Event Hubs",
            "Amazon S3",
            "Splunk",
            "HTTPS Event Collector",
            "Google Cloud Storage",
            "Datadog",
        ],
        vendor_specific: Union[
            AzureBlobConfigType,
            AzureHubConfigType,
            AmazonS3OidcConfigType,
            AmazonS3AccessKeysConfigType,
            SplunkConfigType,
            HecConfigType,
            GoogleCloudConfigType,
            DatadogConfigType,
        ],
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]: ...

    def create_audit_log_stream(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[EnterprisesEnterpriseAuditLogStreamsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]:
        """enterprise-admin/create-audit-log-stream

        POST /enterprises/{enterprise}/audit-log/streams

        Creates an audit log streaming configuration for any of the supported streaming endpoints: Azure Blob Storage, Azure Event Hubs, Amazon S3, Splunk, Google Cloud Storage, Datadog.

        When using this endpoint, you must encrypt the credentials following the same encryption steps as outlined in the guide on encrypting secrets. See "[Encrypting secrets for the REST API](/rest/guides/encrypting-secrets-for-the-rest-api)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#create-an-audit-log-streaming-configuration-for-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseAuditLogStreamsPostBody,
            GetAuditLogStreamConfig,
        )

        url = f"/enterprises/{enterprise}/audit-log/streams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseAuditLogStreamsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetAuditLogStreamConfig,
        )

    @overload
    async def async_create_audit_log_stream(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseAuditLogStreamsPostBodyType,
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]: ...

    @overload
    async def async_create_audit_log_stream(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        enabled: bool,
        stream_type: Literal[
            "Azure Blob Storage",
            "Azure Event Hubs",
            "Amazon S3",
            "Splunk",
            "HTTPS Event Collector",
            "Google Cloud Storage",
            "Datadog",
        ],
        vendor_specific: Union[
            AzureBlobConfigType,
            AzureHubConfigType,
            AmazonS3OidcConfigType,
            AmazonS3AccessKeysConfigType,
            SplunkConfigType,
            HecConfigType,
            GoogleCloudConfigType,
            DatadogConfigType,
        ],
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]: ...

    async def async_create_audit_log_stream(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[EnterprisesEnterpriseAuditLogStreamsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]:
        """enterprise-admin/create-audit-log-stream

        POST /enterprises/{enterprise}/audit-log/streams

        Creates an audit log streaming configuration for any of the supported streaming endpoints: Azure Blob Storage, Azure Event Hubs, Amazon S3, Splunk, Google Cloud Storage, Datadog.

        When using this endpoint, you must encrypt the credentials following the same encryption steps as outlined in the guide on encrypting secrets. See "[Encrypting secrets for the REST API](/rest/guides/encrypting-secrets-for-the-rest-api)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#create-an-audit-log-streaming-configuration-for-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseAuditLogStreamsPostBody,
            GetAuditLogStreamConfig,
        )

        url = f"/enterprises/{enterprise}/audit-log/streams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseAuditLogStreamsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetAuditLogStreamConfig,
        )

    def get_one_audit_log_stream(
        self,
        enterprise: str,
        stream_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]:
        """enterprise-admin/get-one-audit-log-stream

        GET /enterprises/{enterprise}/audit-log/streams/{stream_id}

        Lists one audit log stream configuration via a stream ID.

        When using this endpoint, you must encrypt the credentials following the same encryption steps as outlined in the guide on encrypting secrets. See "[Encrypting secrets for the REST API](/rest/guides/encrypting-secrets-for-the-rest-api)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#list-one-audit-log-streaming-configuration-via-a-stream-id
        """

        from ..models import GetAuditLogStreamConfig

        url = f"/enterprises/{enterprise}/audit-log/streams/{stream_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetAuditLogStreamConfig,
        )

    async def async_get_one_audit_log_stream(
        self,
        enterprise: str,
        stream_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]:
        """enterprise-admin/get-one-audit-log-stream

        GET /enterprises/{enterprise}/audit-log/streams/{stream_id}

        Lists one audit log stream configuration via a stream ID.

        When using this endpoint, you must encrypt the credentials following the same encryption steps as outlined in the guide on encrypting secrets. See "[Encrypting secrets for the REST API](/rest/guides/encrypting-secrets-for-the-rest-api)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#list-one-audit-log-streaming-configuration-via-a-stream-id
        """

        from ..models import GetAuditLogStreamConfig

        url = f"/enterprises/{enterprise}/audit-log/streams/{stream_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetAuditLogStreamConfig,
        )

    @overload
    def update_audit_log_stream(
        self,
        enterprise: str,
        stream_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseAuditLogStreamsStreamIdPutBodyType,
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]: ...

    @overload
    def update_audit_log_stream(
        self,
        enterprise: str,
        stream_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        enabled: bool,
        stream_type: Literal[
            "Azure Blob Storage",
            "Azure Event Hubs",
            "Amazon S3",
            "Splunk",
            "HTTPS Event Collector",
            "Google Cloud Storage",
            "Datadog",
        ],
        vendor_specific: Union[
            AzureBlobConfigType,
            AzureHubConfigType,
            AmazonS3OidcConfigType,
            AmazonS3AccessKeysConfigType,
            SplunkConfigType,
            HecConfigType,
            GoogleCloudConfigType,
            DatadogConfigType,
        ],
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]: ...

    def update_audit_log_stream(
        self,
        enterprise: str,
        stream_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[EnterprisesEnterpriseAuditLogStreamsStreamIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]:
        """enterprise-admin/update-audit-log-stream

        PUT /enterprises/{enterprise}/audit-log/streams/{stream_id}

        Updates an existing audit log stream configuration for an enterprise.

        When using this endpoint, you must encrypt the credentials following the same encryption steps as outlined in the guide on encrypting secrets. See "[Encrypting secrets for the REST API](/rest/guides/encrypting-secrets-for-the-rest-api)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#update-an-existing-audit-log-stream-configuration
        """

        from ..models import (
            EnterprisesEnterpriseAuditLogStreamsStreamIdPutBody,
            EnterprisesEnterpriseAuditLogStreamsStreamIdPutResponse422,
            GetAuditLogStreamConfig,
        )

        url = f"/enterprises/{enterprise}/audit-log/streams/{stream_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseAuditLogStreamsStreamIdPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetAuditLogStreamConfig,
            error_models={
                "422": EnterprisesEnterpriseAuditLogStreamsStreamIdPutResponse422,
            },
        )

    @overload
    async def async_update_audit_log_stream(
        self,
        enterprise: str,
        stream_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseAuditLogStreamsStreamIdPutBodyType,
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]: ...

    @overload
    async def async_update_audit_log_stream(
        self,
        enterprise: str,
        stream_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        enabled: bool,
        stream_type: Literal[
            "Azure Blob Storage",
            "Azure Event Hubs",
            "Amazon S3",
            "Splunk",
            "HTTPS Event Collector",
            "Google Cloud Storage",
            "Datadog",
        ],
        vendor_specific: Union[
            AzureBlobConfigType,
            AzureHubConfigType,
            AmazonS3OidcConfigType,
            AmazonS3AccessKeysConfigType,
            SplunkConfigType,
            HecConfigType,
            GoogleCloudConfigType,
            DatadogConfigType,
        ],
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]: ...

    async def async_update_audit_log_stream(
        self,
        enterprise: str,
        stream_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[EnterprisesEnterpriseAuditLogStreamsStreamIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]:
        """enterprise-admin/update-audit-log-stream

        PUT /enterprises/{enterprise}/audit-log/streams/{stream_id}

        Updates an existing audit log stream configuration for an enterprise.

        When using this endpoint, you must encrypt the credentials following the same encryption steps as outlined in the guide on encrypting secrets. See "[Encrypting secrets for the REST API](/rest/guides/encrypting-secrets-for-the-rest-api)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#update-an-existing-audit-log-stream-configuration
        """

        from ..models import (
            EnterprisesEnterpriseAuditLogStreamsStreamIdPutBody,
            EnterprisesEnterpriseAuditLogStreamsStreamIdPutResponse422,
            GetAuditLogStreamConfig,
        )

        url = f"/enterprises/{enterprise}/audit-log/streams/{stream_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseAuditLogStreamsStreamIdPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetAuditLogStreamConfig,
            error_models={
                "422": EnterprisesEnterpriseAuditLogStreamsStreamIdPutResponse422,
            },
        )

    def delete_audit_log_stream(
        self,
        enterprise: str,
        stream_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/delete-audit-log-stream

        DELETE /enterprises/{enterprise}/audit-log/streams/{stream_id}

        Deletes an existing audit log stream configuration for an enterprise.

        When using this endpoint, you must encrypt the credentials following the same encryption steps as outlined in the guide on encrypting secrets. See "[Encrypting secrets for the REST API](/rest/guides/encrypting-secrets-for-the-rest-api)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#delete-an-audit-log-streaming-configuration-for-an-enterprise
        """

        url = f"/enterprises/{enterprise}/audit-log/streams/{stream_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_audit_log_stream(
        self,
        enterprise: str,
        stream_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/delete-audit-log-stream

        DELETE /enterprises/{enterprise}/audit-log/streams/{stream_id}

        Deletes an existing audit log stream configuration for an enterprise.

        When using this endpoint, you must encrypt the credentials following the same encryption steps as outlined in the guide on encrypting secrets. See "[Encrypting secrets for the REST API](/rest/guides/encrypting-secrets-for-the-rest-api)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#delete-an-audit-log-streaming-configuration-for-an-enterprise
        """

        url = f"/enterprises/{enterprise}/audit-log/streams/{stream_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_push_bypass_requests(
        self,
        enterprise: str,
        *,
        organization_name: Missing[str] = UNSET,
        reviewer: Missing[str] = UNSET,
        requester: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        request_status: Missing[
            Literal[
                "completed",
                "cancelled",
                "approved",
                "expired",
                "deleted",
                "denied",
                "open",
                "all",
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[PushRuleBypassRequest], list[PushRuleBypassRequestType]]:
        """enterprise-admin/list-push-bypass-requests

        GET /enterprises/{enterprise}/bypass-requests/push-rules

        Lists the requests made by users of a repository to bypass push protection rules within an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/bypass-requests#list-push-rule-bypass-requests-within-an-enterprise
        """

        from ..models import BasicError, PushRuleBypassRequest

        url = f"/enterprises/{enterprise}/bypass-requests/push-rules"

        params = {
            "organization_name": organization_name,
            "reviewer": reviewer,
            "requester": requester,
            "time_period": time_period,
            "request_status": request_status,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[PushRuleBypassRequest],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_list_push_bypass_requests(
        self,
        enterprise: str,
        *,
        organization_name: Missing[str] = UNSET,
        reviewer: Missing[str] = UNSET,
        requester: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        request_status: Missing[
            Literal[
                "completed",
                "cancelled",
                "approved",
                "expired",
                "deleted",
                "denied",
                "open",
                "all",
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[PushRuleBypassRequest], list[PushRuleBypassRequestType]]:
        """enterprise-admin/list-push-bypass-requests

        GET /enterprises/{enterprise}/bypass-requests/push-rules

        Lists the requests made by users of a repository to bypass push protection rules within an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/bypass-requests#list-push-rule-bypass-requests-within-an-enterprise
        """

        from ..models import BasicError, PushRuleBypassRequest

        url = f"/enterprises/{enterprise}/bypass-requests/push-rules"

        params = {
            "organization_name": organization_name,
            "reviewer": reviewer,
            "requester": requester,
            "time_period": time_period,
            "request_status": request_status,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[PushRuleBypassRequest],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_security_analysis_settings_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterpriseSecurityAnalysisSettings, EnterpriseSecurityAnalysisSettingsType
    ]:
        """DEPRECATED secret-scanning/get-security-analysis-settings-for-enterprise

        GET /enterprises/{enterprise}/code_security_and_analysis

        > [!WARNING]
        > **Closing down notice:** The ability to fetch code security and analysis settings for an enterprise is closing down. Please use [code security configurations](https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations) instead. For more information, see the [changelog](https://github.blog/changelog/2024-09-27-upcoming-replacement-of-enterprise-code-security-enablement-ui-and-apis).

        Gets code security and analysis settings for the specified enterprise.

        The authenticated user must be an administrator of the enterprise in order to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/code-security-and-analysis#get-code-security-and-analysis-features-for-an-enterprise
        """

        from ..models import BasicError, EnterpriseSecurityAnalysisSettings

        url = f"/enterprises/{enterprise}/code_security_and_analysis"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterpriseSecurityAnalysisSettings,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_security_analysis_settings_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterpriseSecurityAnalysisSettings, EnterpriseSecurityAnalysisSettingsType
    ]:
        """DEPRECATED secret-scanning/get-security-analysis-settings-for-enterprise

        GET /enterprises/{enterprise}/code_security_and_analysis

        > [!WARNING]
        > **Closing down notice:** The ability to fetch code security and analysis settings for an enterprise is closing down. Please use [code security configurations](https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations) instead. For more information, see the [changelog](https://github.blog/changelog/2024-09-27-upcoming-replacement-of-enterprise-code-security-enablement-ui-and-apis).

        Gets code security and analysis settings for the specified enterprise.

        The authenticated user must be an administrator of the enterprise in order to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/code-security-and-analysis#get-code-security-and-analysis-features-for-an-enterprise
        """

        from ..models import BasicError, EnterpriseSecurityAnalysisSettings

        url = f"/enterprises/{enterprise}/code_security_and_analysis"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterpriseSecurityAnalysisSettings,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def patch_security_analysis_settings_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseCodeSecurityAndAnalysisPatchBodyType
        ] = UNSET,
    ) -> Response: ...

    @overload
    def patch_security_analysis_settings_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        advanced_security_enabled_for_new_repositories: Missing[bool] = UNSET,
        advanced_security_enabled_new_user_namespace_repos: Missing[bool] = UNSET,
        dependabot_alerts_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_push_protection_enabled_for_new_repositories: Missing[
            bool
        ] = UNSET,
        secret_scanning_push_protection_custom_link: Missing[Union[str, None]] = UNSET,
        secret_scanning_non_provider_patterns_enabled_for_new_repositories: Missing[
            Union[bool, None]
        ] = UNSET,
    ) -> Response: ...

    def patch_security_analysis_settings_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseCodeSecurityAndAnalysisPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED secret-scanning/patch-security-analysis-settings-for-enterprise

        PATCH /enterprises/{enterprise}/code_security_and_analysis

        > [!WARNING]
        > **Closing down notice:** The ability to update code security and analysis settings for an enterprise is closing down. Please use [code security configurations](https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations) instead. For more information, see the [changelog](https://github.blog/changelog/2024-09-27-upcoming-replacement-of-enterprise-code-security-enablement-ui-and-apis).

        Updates the settings for advanced security, Dependabot alerts, secret scanning, and push protection for new repositories in an enterprise.

        The authenticated user must be an administrator of the enterprise to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/code-security-and-analysis#update-code-security-and-analysis-features-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeSecurityAndAnalysisPatchBody,
        )

        url = f"/enterprises/{enterprise}/code_security_and_analysis"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseCodeSecurityAndAnalysisPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_patch_security_analysis_settings_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseCodeSecurityAndAnalysisPatchBodyType
        ] = UNSET,
    ) -> Response: ...

    @overload
    async def async_patch_security_analysis_settings_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        advanced_security_enabled_for_new_repositories: Missing[bool] = UNSET,
        advanced_security_enabled_new_user_namespace_repos: Missing[bool] = UNSET,
        dependabot_alerts_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_push_protection_enabled_for_new_repositories: Missing[
            bool
        ] = UNSET,
        secret_scanning_push_protection_custom_link: Missing[Union[str, None]] = UNSET,
        secret_scanning_non_provider_patterns_enabled_for_new_repositories: Missing[
            Union[bool, None]
        ] = UNSET,
    ) -> Response: ...

    async def async_patch_security_analysis_settings_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseCodeSecurityAndAnalysisPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED secret-scanning/patch-security-analysis-settings-for-enterprise

        PATCH /enterprises/{enterprise}/code_security_and_analysis

        > [!WARNING]
        > **Closing down notice:** The ability to update code security and analysis settings for an enterprise is closing down. Please use [code security configurations](https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations) instead. For more information, see the [changelog](https://github.blog/changelog/2024-09-27-upcoming-replacement-of-enterprise-code-security-enablement-ui-and-apis).

        Updates the settings for advanced security, Dependabot alerts, secret scanning, and push protection for new repositories in an enterprise.

        The authenticated user must be an administrator of the enterprise to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/code-security-and-analysis#update-code-security-and-analysis-features-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeSecurityAndAnalysisPatchBody,
        )

        url = f"/enterprises/{enterprise}/code_security_and_analysis"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseCodeSecurityAndAnalysisPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    def get_consumed_licenses(
        self,
        enterprise: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GetConsumedLicenses, GetConsumedLicensesType]:
        """enterprise-admin/get-consumed-licenses

        GET /enterprises/{enterprise}/consumed-licenses

        Lists the license consumption information for all users, including those from connected servers, associated with an enterprise.

        The authenticated user must be an enterprise admin to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/license#list-enterprise-consumed-licenses
        """

        from ..models import GetConsumedLicenses

        url = f"/enterprises/{enterprise}/consumed-licenses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetConsumedLicenses,
        )

    async def async_get_consumed_licenses(
        self,
        enterprise: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GetConsumedLicenses, GetConsumedLicensesType]:
        """enterprise-admin/get-consumed-licenses

        GET /enterprises/{enterprise}/consumed-licenses

        Lists the license consumption information for all users, including those from connected servers, associated with an enterprise.

        The authenticated user must be an enterprise admin to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/license#list-enterprise-consumed-licenses
        """

        from ..models import GetConsumedLicenses

        url = f"/enterprises/{enterprise}/consumed-licenses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetConsumedLicenses,
        )

    def get_license_sync_status(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GetLicenseSyncStatus, GetLicenseSyncStatusType]:
        """enterprise-admin/get-license-sync-status

        GET /enterprises/{enterprise}/license-sync-status

        Gets information about the status of a license sync job for an enterprise.

        The authenticated user must be an enterprise admin to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/license#get-a-license-sync-status
        """

        from ..models import GetLicenseSyncStatus

        url = f"/enterprises/{enterprise}/license-sync-status"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetLicenseSyncStatus,
        )

    async def async_get_license_sync_status(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GetLicenseSyncStatus, GetLicenseSyncStatusType]:
        """enterprise-admin/get-license-sync-status

        GET /enterprises/{enterprise}/license-sync-status

        Gets information about the status of a license sync job for an enterprise.

        The authenticated user must be an enterprise admin to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/license#get-a-license-sync-status
        """

        from ..models import GetLicenseSyncStatus

        url = f"/enterprises/{enterprise}/license-sync-status"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetLicenseSyncStatus,
        )

    def list_network_configurations_for_enterprise(
        self,
        enterprise: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseNetworkConfigurationsGetResponse200,
        EnterprisesEnterpriseNetworkConfigurationsGetResponse200Type,
    ]:
        """hosted-compute/list-network-configurations-for-enterprise

        GET /enterprises/{enterprise}/network-configurations

        Lists all hosted compute network configurations configured in an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/network-configurations#list-hosted-compute-network-configurations-for-an-enterprise
        """

        from ..models import EnterprisesEnterpriseNetworkConfigurationsGetResponse200

        url = f"/enterprises/{enterprise}/network-configurations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseNetworkConfigurationsGetResponse200,
        )

    async def async_list_network_configurations_for_enterprise(
        self,
        enterprise: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseNetworkConfigurationsGetResponse200,
        EnterprisesEnterpriseNetworkConfigurationsGetResponse200Type,
    ]:
        """hosted-compute/list-network-configurations-for-enterprise

        GET /enterprises/{enterprise}/network-configurations

        Lists all hosted compute network configurations configured in an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/network-configurations#list-hosted-compute-network-configurations-for-an-enterprise
        """

        from ..models import EnterprisesEnterpriseNetworkConfigurationsGetResponse200

        url = f"/enterprises/{enterprise}/network-configurations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseNetworkConfigurationsGetResponse200,
        )

    @overload
    def create_network_configuration_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseNetworkConfigurationsPostBodyType,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]: ...

    @overload
    def create_network_configuration_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        compute_service: Missing[Literal["none", "actions"]] = UNSET,
        network_settings_ids: list[str],
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]: ...

    def create_network_configuration_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[EnterprisesEnterpriseNetworkConfigurationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]:
        """hosted-compute/create-network-configuration-for-enterprise

        POST /enterprises/{enterprise}/network-configurations

        Creates a hosted compute network configuration for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/network-configurations#create-a-hosted-compute-network-configuration-for-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseNetworkConfigurationsPostBody,
            NetworkConfiguration,
        )

        url = f"/enterprises/{enterprise}/network-configurations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseNetworkConfigurationsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=NetworkConfiguration,
        )

    @overload
    async def async_create_network_configuration_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseNetworkConfigurationsPostBodyType,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]: ...

    @overload
    async def async_create_network_configuration_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        compute_service: Missing[Literal["none", "actions"]] = UNSET,
        network_settings_ids: list[str],
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]: ...

    async def async_create_network_configuration_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[EnterprisesEnterpriseNetworkConfigurationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]:
        """hosted-compute/create-network-configuration-for-enterprise

        POST /enterprises/{enterprise}/network-configurations

        Creates a hosted compute network configuration for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/network-configurations#create-a-hosted-compute-network-configuration-for-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseNetworkConfigurationsPostBody,
            NetworkConfiguration,
        )

        url = f"/enterprises/{enterprise}/network-configurations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseNetworkConfigurationsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=NetworkConfiguration,
        )

    def get_network_configuration_for_enterprise(
        self,
        enterprise: str,
        network_configuration_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]:
        """hosted-compute/get-network-configuration-for-enterprise

        GET /enterprises/{enterprise}/network-configurations/{network_configuration_id}

        Gets a hosted compute network configuration configured in an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/network-configurations#get-a-hosted-compute-network-configuration-for-an-enterprise
        """

        from ..models import NetworkConfiguration

        url = f"/enterprises/{enterprise}/network-configurations/{network_configuration_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=NetworkConfiguration,
        )

    async def async_get_network_configuration_for_enterprise(
        self,
        enterprise: str,
        network_configuration_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]:
        """hosted-compute/get-network-configuration-for-enterprise

        GET /enterprises/{enterprise}/network-configurations/{network_configuration_id}

        Gets a hosted compute network configuration configured in an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/network-configurations#get-a-hosted-compute-network-configuration-for-an-enterprise
        """

        from ..models import NetworkConfiguration

        url = f"/enterprises/{enterprise}/network-configurations/{network_configuration_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=NetworkConfiguration,
        )

    def delete_network_configuration_from_enterprise(
        self,
        enterprise: str,
        network_configuration_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """hosted-compute/delete-network-configuration-from-enterprise

        DELETE /enterprises/{enterprise}/network-configurations/{network_configuration_id}

        Deletes a hosted compute network configuration from an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/network-configurations#delete-a-hosted-compute-network-configuration-from-an-enterprise
        """

        url = f"/enterprises/{enterprise}/network-configurations/{network_configuration_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_network_configuration_from_enterprise(
        self,
        enterprise: str,
        network_configuration_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """hosted-compute/delete-network-configuration-from-enterprise

        DELETE /enterprises/{enterprise}/network-configurations/{network_configuration_id}

        Deletes a hosted compute network configuration from an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/network-configurations#delete-a-hosted-compute-network-configuration-from-an-enterprise
        """

        url = f"/enterprises/{enterprise}/network-configurations/{network_configuration_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    def update_network_configuration_for_enterprise(
        self,
        enterprise: str,
        network_configuration_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseNetworkConfigurationsNetworkConfigurationIdPatchBodyType,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]: ...

    @overload
    def update_network_configuration_for_enterprise(
        self,
        enterprise: str,
        network_configuration_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        compute_service: Missing[Literal["none", "actions"]] = UNSET,
        network_settings_ids: Missing[list[str]] = UNSET,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]: ...

    def update_network_configuration_for_enterprise(
        self,
        enterprise: str,
        network_configuration_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseNetworkConfigurationsNetworkConfigurationIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]:
        """hosted-compute/update-network-configuration-for-enterprise

        PATCH /enterprises/{enterprise}/network-configurations/{network_configuration_id}

        Updates a hosted compute network configuration for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/network-configurations#update-a-hosted-compute-network-configuration-for-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseNetworkConfigurationsNetworkConfigurationIdPatchBody,
            NetworkConfiguration,
        )

        url = f"/enterprises/{enterprise}/network-configurations/{network_configuration_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseNetworkConfigurationsNetworkConfigurationIdPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=NetworkConfiguration,
        )

    @overload
    async def async_update_network_configuration_for_enterprise(
        self,
        enterprise: str,
        network_configuration_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseNetworkConfigurationsNetworkConfigurationIdPatchBodyType,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]: ...

    @overload
    async def async_update_network_configuration_for_enterprise(
        self,
        enterprise: str,
        network_configuration_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        compute_service: Missing[Literal["none", "actions"]] = UNSET,
        network_settings_ids: Missing[list[str]] = UNSET,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]: ...

    async def async_update_network_configuration_for_enterprise(
        self,
        enterprise: str,
        network_configuration_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseNetworkConfigurationsNetworkConfigurationIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]:
        """hosted-compute/update-network-configuration-for-enterprise

        PATCH /enterprises/{enterprise}/network-configurations/{network_configuration_id}

        Updates a hosted compute network configuration for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/network-configurations#update-a-hosted-compute-network-configuration-for-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseNetworkConfigurationsNetworkConfigurationIdPatchBody,
            NetworkConfiguration,
        )

        url = f"/enterprises/{enterprise}/network-configurations/{network_configuration_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseNetworkConfigurationsNetworkConfigurationIdPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=NetworkConfiguration,
        )

    def get_network_settings_for_enterprise(
        self,
        enterprise: str,
        network_settings_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[NetworkSettings, NetworkSettingsType]:
        """hosted-compute/get-network-settings-for-enterprise

        GET /enterprises/{enterprise}/network-settings/{network_settings_id}

        Gets a hosted compute network settings resource configured for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/network-configurations#get-a-hosted-compute-network-settings-resource-for-an-enterprise
        """

        from ..models import NetworkSettings

        url = f"/enterprises/{enterprise}/network-settings/{network_settings_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=NetworkSettings,
        )

    async def async_get_network_settings_for_enterprise(
        self,
        enterprise: str,
        network_settings_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[NetworkSettings, NetworkSettingsType]:
        """hosted-compute/get-network-settings-for-enterprise

        GET /enterprises/{enterprise}/network-settings/{network_settings_id}

        Gets a hosted compute network settings resource configured for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/network-configurations#get-a-hosted-compute-network-settings-resource-for-an-enterprise
        """

        from ..models import NetworkSettings

        url = f"/enterprises/{enterprise}/network-settings/{network_settings_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=NetworkSettings,
        )

    def get_enterprise_custom_properties(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]:
        """enterprise-admin/get-enterprise-custom-properties

        GET /enterprises/{enterprise}/properties/schema

        Gets all custom properties defined for an enterprise.
        Enterprise members can read these properties.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#get-custom-properties-for-an-enterprise
        """

        from ..models import BasicError, CustomProperty

        url = f"/enterprises/{enterprise}/properties/schema"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CustomProperty],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_enterprise_custom_properties(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]:
        """enterprise-admin/get-enterprise-custom-properties

        GET /enterprises/{enterprise}/properties/schema

        Gets all custom properties defined for an enterprise.
        Enterprise members can read these properties.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#get-custom-properties-for-an-enterprise
        """

        from ..models import BasicError, CustomProperty

        url = f"/enterprises/{enterprise}/properties/schema"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CustomProperty],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_or_update_enterprise_custom_properties(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterprisePropertiesSchemaPatchBodyType,
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]: ...

    @overload
    def create_or_update_enterprise_custom_properties(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        properties: list[CustomPropertyType],
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]: ...

    def create_or_update_enterprise_custom_properties(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[EnterprisesEnterprisePropertiesSchemaPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]:
        """enterprise-admin/create-or-update-enterprise-custom-properties

        PATCH /enterprises/{enterprise}/properties/schema

        Creates new or updates existing custom properties defined for an enterprise in a batch.

        If the property already exists, the existing property will be replaced with the new values.
        Missing optional values will fall back to default values, previous values will be overwritten.
        E.g. if a property exists with `values_editable_by: org_and_repo_actors` and it's updated without specifying `values_editable_by`, it will be updated to default value `org_actors`.

        To use this endpoint, the authenticated user must be an administrator for the enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#create-or-update-custom-properties-for-an-enterprise
        """

        from ..models import (
            BasicError,
            CustomProperty,
            EnterprisesEnterprisePropertiesSchemaPatchBody,
        )

        url = f"/enterprises/{enterprise}/properties/schema"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterprisePropertiesSchemaPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CustomProperty],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_or_update_enterprise_custom_properties(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterprisePropertiesSchemaPatchBodyType,
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]: ...

    @overload
    async def async_create_or_update_enterprise_custom_properties(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        properties: list[CustomPropertyType],
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]: ...

    async def async_create_or_update_enterprise_custom_properties(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[EnterprisesEnterprisePropertiesSchemaPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]:
        """enterprise-admin/create-or-update-enterprise-custom-properties

        PATCH /enterprises/{enterprise}/properties/schema

        Creates new or updates existing custom properties defined for an enterprise in a batch.

        If the property already exists, the existing property will be replaced with the new values.
        Missing optional values will fall back to default values, previous values will be overwritten.
        E.g. if a property exists with `values_editable_by: org_and_repo_actors` and it's updated without specifying `values_editable_by`, it will be updated to default value `org_actors`.

        To use this endpoint, the authenticated user must be an administrator for the enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#create-or-update-custom-properties-for-an-enterprise
        """

        from ..models import (
            BasicError,
            CustomProperty,
            EnterprisesEnterprisePropertiesSchemaPatchBody,
        )

        url = f"/enterprises/{enterprise}/properties/schema"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterprisePropertiesSchemaPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CustomProperty],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def promote_custom_property_to_enterprise(
        self,
        enterprise: str,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CustomProperty, CustomPropertyType]:
        """enterprise-admin/promote-custom-property-to-enterprise

        PUT /enterprises/{enterprise}/properties/schema/organizations/{org}/{custom_property_name}/promote

        Promotes an existing organization custom property to an enterprise.

        To use this endpoint, the authenticated user must be an administrator for the enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#promote-a-custom-property-to-an-enterprise
        """

        from ..models import BasicError, CustomProperty

        url = f"/enterprises/{enterprise}/properties/schema/organizations/{org}/{custom_property_name}/promote"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_promote_custom_property_to_enterprise(
        self,
        enterprise: str,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CustomProperty, CustomPropertyType]:
        """enterprise-admin/promote-custom-property-to-enterprise

        PUT /enterprises/{enterprise}/properties/schema/organizations/{org}/{custom_property_name}/promote

        Promotes an existing organization custom property to an enterprise.

        To use this endpoint, the authenticated user must be an administrator for the enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#promote-a-custom-property-to-an-enterprise
        """

        from ..models import BasicError, CustomProperty

        url = f"/enterprises/{enterprise}/properties/schema/organizations/{org}/{custom_property_name}/promote"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def get_enterprise_custom_property(
        self,
        enterprise: str,
        custom_property_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CustomProperty, CustomPropertyType]:
        """enterprise-admin/get-enterprise-custom-property

        GET /enterprises/{enterprise}/properties/schema/{custom_property_name}

        Gets a custom property that is defined for an enterprise.
        Enterprise members can read these properties.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#get-a-custom-property-for-an-enterprise
        """

        from ..models import BasicError, CustomProperty

        url = f"/enterprises/{enterprise}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_enterprise_custom_property(
        self,
        enterprise: str,
        custom_property_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CustomProperty, CustomPropertyType]:
        """enterprise-admin/get-enterprise-custom-property

        GET /enterprises/{enterprise}/properties/schema/{custom_property_name}

        Gets a custom property that is defined for an enterprise.
        Enterprise members can read these properties.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#get-a-custom-property-for-an-enterprise
        """

        from ..models import BasicError, CustomProperty

        url = f"/enterprises/{enterprise}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_or_update_enterprise_custom_property(
        self,
        enterprise: str,
        custom_property_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: CustomPropertySetPayloadType,
    ) -> Response[CustomProperty, CustomPropertyType]: ...

    @overload
    def create_or_update_enterprise_custom_property(
        self,
        enterprise: str,
        custom_property_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        value_type: Literal["string", "single_select", "multi_select", "true_false"],
        required: Missing[bool] = UNSET,
        default_value: Missing[Union[str, list[str], None]] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        allowed_values: Missing[Union[list[str], None]] = UNSET,
        values_editable_by: Missing[
            Union[None, Literal["org_actors", "org_and_repo_actors"]]
        ] = UNSET,
    ) -> Response[CustomProperty, CustomPropertyType]: ...

    def create_or_update_enterprise_custom_property(
        self,
        enterprise: str,
        custom_property_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[CustomPropertySetPayloadType] = UNSET,
        **kwargs,
    ) -> Response[CustomProperty, CustomPropertyType]:
        """enterprise-admin/create-or-update-enterprise-custom-property

        PUT /enterprises/{enterprise}/properties/schema/{custom_property_name}

        Creates a new or updates an existing custom property that is defined for an enterprise.

        To use this endpoint, the authenticated user must be an administrator for the enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#create-or-update-a-custom-property-for-an-enterprise
        """

        from ..models import BasicError, CustomProperty, CustomPropertySetPayload

        url = f"/enterprises/{enterprise}/properties/schema/{custom_property_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(CustomPropertySetPayload, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_or_update_enterprise_custom_property(
        self,
        enterprise: str,
        custom_property_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: CustomPropertySetPayloadType,
    ) -> Response[CustomProperty, CustomPropertyType]: ...

    @overload
    async def async_create_or_update_enterprise_custom_property(
        self,
        enterprise: str,
        custom_property_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        value_type: Literal["string", "single_select", "multi_select", "true_false"],
        required: Missing[bool] = UNSET,
        default_value: Missing[Union[str, list[str], None]] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        allowed_values: Missing[Union[list[str], None]] = UNSET,
        values_editable_by: Missing[
            Union[None, Literal["org_actors", "org_and_repo_actors"]]
        ] = UNSET,
    ) -> Response[CustomProperty, CustomPropertyType]: ...

    async def async_create_or_update_enterprise_custom_property(
        self,
        enterprise: str,
        custom_property_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[CustomPropertySetPayloadType] = UNSET,
        **kwargs,
    ) -> Response[CustomProperty, CustomPropertyType]:
        """enterprise-admin/create-or-update-enterprise-custom-property

        PUT /enterprises/{enterprise}/properties/schema/{custom_property_name}

        Creates a new or updates an existing custom property that is defined for an enterprise.

        To use this endpoint, the authenticated user must be an administrator for the enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#create-or-update-a-custom-property-for-an-enterprise
        """

        from ..models import BasicError, CustomProperty, CustomPropertySetPayload

        url = f"/enterprises/{enterprise}/properties/schema/{custom_property_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(CustomPropertySetPayload, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def remove_enterprise_custom_property(
        self,
        enterprise: str,
        custom_property_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/remove-enterprise-custom-property

        DELETE /enterprises/{enterprise}/properties/schema/{custom_property_name}

        Remove a custom property that is defined for an enterprise.

        To use this endpoint, the authenticated user must be an administrator for the enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#remove-a-custom-property-for-an-enterprise
        """

        from ..models import BasicError

        url = f"/enterprises/{enterprise}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_remove_enterprise_custom_property(
        self,
        enterprise: str,
        custom_property_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/remove-enterprise-custom-property

        DELETE /enterprises/{enterprise}/properties/schema/{custom_property_name}

        Remove a custom property that is defined for an enterprise.

        To use this endpoint, the authenticated user must be an administrator for the enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#remove-a-custom-property-for-an-enterprise
        """

        from ..models import BasicError

        url = f"/enterprises/{enterprise}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def get_enterprise_ruleset_history(
        self,
        enterprise: str,
        ruleset_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RulesetVersion], list[RulesetVersionType]]:
        """enterprise-admin/get-enterprise-ruleset-history

        GET /enterprises/{enterprise}/rulesets/{ruleset_id}/history

        Get the history of an enterprise ruleset.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/rules#get-enterprise-ruleset-history
        """

        from ..models import BasicError, RulesetVersion

        url = f"/enterprises/{enterprise}/rulesets/{ruleset_id}/history"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RulesetVersion],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_enterprise_ruleset_history(
        self,
        enterprise: str,
        ruleset_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RulesetVersion], list[RulesetVersionType]]:
        """enterprise-admin/get-enterprise-ruleset-history

        GET /enterprises/{enterprise}/rulesets/{ruleset_id}/history

        Get the history of an enterprise ruleset.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/rules#get-enterprise-ruleset-history
        """

        from ..models import BasicError, RulesetVersion

        url = f"/enterprises/{enterprise}/rulesets/{ruleset_id}/history"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RulesetVersion],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_enterprise_ruleset_version(
        self,
        enterprise: str,
        ruleset_id: int,
        version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RulesetVersionWithState, RulesetVersionWithStateType]:
        """enterprise-admin/get-enterprise-ruleset-version

        GET /enterprises/{enterprise}/rulesets/{ruleset_id}/history/{version_id}

        Get a version of an enterprise ruleset.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/rules#get-enterprise-ruleset-version
        """

        from ..models import BasicError, RulesetVersionWithState

        url = f"/enterprises/{enterprise}/rulesets/{ruleset_id}/history/{version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RulesetVersionWithState,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_enterprise_ruleset_version(
        self,
        enterprise: str,
        ruleset_id: int,
        version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RulesetVersionWithState, RulesetVersionWithStateType]:
        """enterprise-admin/get-enterprise-ruleset-version

        GET /enterprises/{enterprise}/rulesets/{ruleset_id}/history/{version_id}

        Get a version of an enterprise ruleset.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/rules#get-enterprise-ruleset-version
        """

        from ..models import BasicError, RulesetVersionWithState

        url = f"/enterprises/{enterprise}/rulesets/{ruleset_id}/history/{version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RulesetVersionWithState,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def post_security_product_enablement_for_enterprise(
        self,
        enterprise: str,
        security_product: Literal[
            "advanced_security",
            "advanced_security_user_namespace",
            "dependabot_alerts",
            "secret_scanning",
            "secret_scanning_push_protection",
            "secret_scanning_non_provider_patterns",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED secret-scanning/post-security-product-enablement-for-enterprise

        POST /enterprises/{enterprise}/{security_product}/{enablement}

        > [!WARNING]
        > **Closing down notice:** The ability to enable or disable a security feature for an enterprise is closing down. Please use [code security configurations](https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations) instead. For more information, see the [changelog](https://github.blog/changelog/2024-09-27-upcoming-replacement-of-enterprise-code-security-enablement-ui-and-apis).

        Enables or disables the specified security feature for all repositories in an enterprise.

        The authenticated user must be an administrator of the enterprise to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/code-security-and-analysis#enable-or-disable-a-security-feature
        """

        from ..models import BasicError

        url = f"/enterprises/{enterprise}/{security_product}/{enablement}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    async def async_post_security_product_enablement_for_enterprise(
        self,
        enterprise: str,
        security_product: Literal[
            "advanced_security",
            "advanced_security_user_namespace",
            "dependabot_alerts",
            "secret_scanning",
            "secret_scanning_push_protection",
            "secret_scanning_non_provider_patterns",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED secret-scanning/post-security-product-enablement-for-enterprise

        POST /enterprises/{enterprise}/{security_product}/{enablement}

        > [!WARNING]
        > **Closing down notice:** The ability to enable or disable a security feature for an enterprise is closing down. Please use [code security configurations](https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations) instead. For more information, see the [changelog](https://github.blog/changelog/2024-09-27-upcoming-replacement-of-enterprise-code-security-enablement-ui-and-apis).

        Enables or disables the specified security feature for all repositories in an enterprise.

        The authenticated user must be an administrator of the enterprise to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/code-security-and-analysis#enable-or-disable-a-security-feature
        """

        from ..models import BasicError

        url = f"/enterprises/{enterprise}/{security_product}/{enablement}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    def list_provisioned_groups_enterprise(
        self,
        enterprise: str,
        *,
        filter_: Missing[str] = UNSET,
        excluded_attributes: Missing[str] = UNSET,
        start_index: Missing[int] = UNSET,
        count: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ScimEnterpriseGroupList, ScimEnterpriseGroupListType]:
        """enterprise-admin/list-provisioned-groups-enterprise

        GET /scim/v2/enterprises/{enterprise}/Groups

        Lists provisioned SCIM groups in an enterprise.

        You can improve query search time by using the `excludedAttributes` query parameter with a value of `members` to exclude members from the response.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#list-provisioned-scim-groups-for-an-enterprise
        """

        from ..models import ScimEnterpriseGroupList, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups"

        params = {
            "filter": filter_,
            "excludedAttributes": excluded_attributes,
            "startIndex": start_index,
            "count": count,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimEnterpriseGroupList,
            error_models={
                "400": ScimError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    async def async_list_provisioned_groups_enterprise(
        self,
        enterprise: str,
        *,
        filter_: Missing[str] = UNSET,
        excluded_attributes: Missing[str] = UNSET,
        start_index: Missing[int] = UNSET,
        count: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ScimEnterpriseGroupList, ScimEnterpriseGroupListType]:
        """enterprise-admin/list-provisioned-groups-enterprise

        GET /scim/v2/enterprises/{enterprise}/Groups

        Lists provisioned SCIM groups in an enterprise.

        You can improve query search time by using the `excludedAttributes` query parameter with a value of `members` to exclude members from the response.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#list-provisioned-scim-groups-for-an-enterprise
        """

        from ..models import ScimEnterpriseGroupList, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups"

        params = {
            "filter": filter_,
            "excludedAttributes": excluded_attributes,
            "startIndex": start_index,
            "count": count,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimEnterpriseGroupList,
            error_models={
                "400": ScimError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    def provision_enterprise_group(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: GroupType,
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]: ...

    @overload
    def provision_enterprise_group(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        schemas: list[Literal["urn:ietf:params:scim:schemas:core:2.0:Group"]],
        external_id: str,
        display_name: str,
        members: list[GroupPropMembersItemsType],
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]: ...

    def provision_enterprise_group(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[GroupType] = UNSET,
        **kwargs,
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]:
        """enterprise-admin/provision-enterprise-group

        POST /scim/v2/enterprises/{enterprise}/Groups

        Creates a SCIM group for an enterprise.

        When members are part of the group provisioning payload, they're designated as external group members. Providers are responsible for maintaining a mapping between the `externalId` and `id` for each user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#provision-a-scim-enterprise-group
        """

        from ..models import Group, ScimEnterpriseGroupResponse, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Group, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimEnterpriseGroupResponse,
            error_models={
                "400": ScimError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    async def async_provision_enterprise_group(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: GroupType,
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]: ...

    @overload
    async def async_provision_enterprise_group(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        schemas: list[Literal["urn:ietf:params:scim:schemas:core:2.0:Group"]],
        external_id: str,
        display_name: str,
        members: list[GroupPropMembersItemsType],
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]: ...

    async def async_provision_enterprise_group(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[GroupType] = UNSET,
        **kwargs,
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]:
        """enterprise-admin/provision-enterprise-group

        POST /scim/v2/enterprises/{enterprise}/Groups

        Creates a SCIM group for an enterprise.

        When members are part of the group provisioning payload, they're designated as external group members. Providers are responsible for maintaining a mapping between the `externalId` and `id` for each user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#provision-a-scim-enterprise-group
        """

        from ..models import Group, ScimEnterpriseGroupResponse, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Group, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimEnterpriseGroupResponse,
            error_models={
                "400": ScimError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    def get_provisioning_information_for_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        excluded_attributes: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]:
        """enterprise-admin/get-provisioning-information-for-enterprise-group

        GET /scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}

        Gets information about a SCIM group.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#get-scim-provisioning-information-for-an-enterprise-group
        """

        from ..models import BasicError, ScimEnterpriseGroupResponse, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        params = {
            "excludedAttributes": excluded_attributes,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimEnterpriseGroupResponse,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    async def async_get_provisioning_information_for_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        excluded_attributes: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]:
        """enterprise-admin/get-provisioning-information-for-enterprise-group

        GET /scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}

        Gets information about a SCIM group.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#get-scim-provisioning-information-for-an-enterprise-group
        """

        from ..models import BasicError, ScimEnterpriseGroupResponse, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        params = {
            "excludedAttributes": excluded_attributes,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimEnterpriseGroupResponse,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    def set_information_for_provisioned_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: GroupType,
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]: ...

    @overload
    def set_information_for_provisioned_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        schemas: list[Literal["urn:ietf:params:scim:schemas:core:2.0:Group"]],
        external_id: str,
        display_name: str,
        members: list[GroupPropMembersItemsType],
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]: ...

    def set_information_for_provisioned_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[GroupType] = UNSET,
        **kwargs,
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]:
        """enterprise-admin/set-information-for-provisioned-enterprise-group

        PUT /scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}

        Replaces an existing provisioned group’s information.

        You must provide all the information required for the group as if you were provisioning it for the first time. Any existing group information that you don't provide will be removed, including group membership. If you want to only update a specific attribute, use the [Update an attribute for a SCIM enterprise group](#update-an-attribute-for-a-scim-enterprise-group) endpoint instead.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#set-scim-information-for-a-provisioned-enterprise-group
        """

        from ..models import BasicError, Group, ScimEnterpriseGroupResponse, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Group, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimEnterpriseGroupResponse,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    async def async_set_information_for_provisioned_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: GroupType,
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]: ...

    @overload
    async def async_set_information_for_provisioned_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        schemas: list[Literal["urn:ietf:params:scim:schemas:core:2.0:Group"]],
        external_id: str,
        display_name: str,
        members: list[GroupPropMembersItemsType],
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]: ...

    async def async_set_information_for_provisioned_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[GroupType] = UNSET,
        **kwargs,
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]:
        """enterprise-admin/set-information-for-provisioned-enterprise-group

        PUT /scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}

        Replaces an existing provisioned group’s information.

        You must provide all the information required for the group as if you were provisioning it for the first time. Any existing group information that you don't provide will be removed, including group membership. If you want to only update a specific attribute, use the [Update an attribute for a SCIM enterprise group](#update-an-attribute-for-a-scim-enterprise-group) endpoint instead.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#set-scim-information-for-a-provisioned-enterprise-group
        """

        from ..models import BasicError, Group, ScimEnterpriseGroupResponse, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Group, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimEnterpriseGroupResponse,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    def delete_scim_group_from_enterprise(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/delete-scim-group-from-enterprise

        DELETE /scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}

        Deletes a SCIM group from an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#delete-a-scim-group-from-an-enterprise
        """

        from ..models import BasicError, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    async def async_delete_scim_group_from_enterprise(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/delete-scim-group-from-enterprise

        DELETE /scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}

        Deletes a SCIM group from an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#delete-a-scim-group-from-an-enterprise
        """

        from ..models import BasicError, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    def update_attribute_for_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: PatchSchemaType,
    ) -> Response: ...

    @overload
    def update_attribute_for_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        operations: list[PatchSchemaPropOperationsItemsType],
        schemas: list[Literal["urn:ietf:params:scim:api:messages:2.0:PatchOp"]],
    ) -> Response: ...

    def update_attribute_for_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[PatchSchemaType] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-admin/update-attribute-for-enterprise-group

        PATCH /scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}

        Update a provisioned group’s individual attributes.

        To modify a group's values, you'll need to use a specific Operations JSON format which must include at least one of the following operations: add, remove, or replace. For examples and more information on this SCIM format, consult the [SCIM specification](https://tools.ietf.org/html/rfc7644#section-3.5.2). The update function can also be used to add group memberships.

        You can submit group memberships individually or in batches for improved efficiency.

        > [!NOTE]
        > Memberships are referenced via a local user id. Ensure users are created before referencing them here.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#update-an-attribute-for-a-scim-enterprise-group
        """

        from ..models import BasicError, PatchSchema, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(PatchSchema, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    async def async_update_attribute_for_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: PatchSchemaType,
    ) -> Response: ...

    @overload
    async def async_update_attribute_for_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        operations: list[PatchSchemaPropOperationsItemsType],
        schemas: list[Literal["urn:ietf:params:scim:api:messages:2.0:PatchOp"]],
    ) -> Response: ...

    async def async_update_attribute_for_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[PatchSchemaType] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-admin/update-attribute-for-enterprise-group

        PATCH /scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}

        Update a provisioned group’s individual attributes.

        To modify a group's values, you'll need to use a specific Operations JSON format which must include at least one of the following operations: add, remove, or replace. For examples and more information on this SCIM format, consult the [SCIM specification](https://tools.ietf.org/html/rfc7644#section-3.5.2). The update function can also be used to add group memberships.

        You can submit group memberships individually or in batches for improved efficiency.

        > [!NOTE]
        > Memberships are referenced via a local user id. Ensure users are created before referencing them here.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#update-an-attribute-for-a-scim-enterprise-group
        """

        from ..models import BasicError, PatchSchema, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(PatchSchema, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    def list_provisioned_identities_enterprise(
        self,
        enterprise: str,
        *,
        filter_: Missing[str] = UNSET,
        start_index: Missing[int] = UNSET,
        count: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ScimEnterpriseUserList, ScimEnterpriseUserListType]:
        """enterprise-admin/list-provisioned-identities-enterprise

        GET /scim/v2/enterprises/{enterprise}/Users

        Lists provisioned SCIM enterprise members.

        When you remove a user with a SCIM-provisioned external identity from an enterprise using a `patch` with `active` flag to `false`, the user's metadata remains intact. This means they can potentially re-join the enterprise later. Although, while suspended, the user can't sign in. If you want to ensure the user can't re-join in the future, use the delete request. Only users who weren't permanently deleted will appear in the result list.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#list-scim-provisioned-identities-for-an-enterprise
        """

        from ..models import ScimEnterpriseUserList, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Users"

        params = {
            "filter": filter_,
            "startIndex": start_index,
            "count": count,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimEnterpriseUserList,
            error_models={
                "400": ScimError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    async def async_list_provisioned_identities_enterprise(
        self,
        enterprise: str,
        *,
        filter_: Missing[str] = UNSET,
        start_index: Missing[int] = UNSET,
        count: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ScimEnterpriseUserList, ScimEnterpriseUserListType]:
        """enterprise-admin/list-provisioned-identities-enterprise

        GET /scim/v2/enterprises/{enterprise}/Users

        Lists provisioned SCIM enterprise members.

        When you remove a user with a SCIM-provisioned external identity from an enterprise using a `patch` with `active` flag to `false`, the user's metadata remains intact. This means they can potentially re-join the enterprise later. Although, while suspended, the user can't sign in. If you want to ensure the user can't re-join in the future, use the delete request. Only users who weren't permanently deleted will appear in the result list.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#list-scim-provisioned-identities-for-an-enterprise
        """

        from ..models import ScimEnterpriseUserList, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Users"

        params = {
            "filter": filter_,
            "startIndex": start_index,
            "count": count,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimEnterpriseUserList,
            error_models={
                "400": ScimError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    def provision_enterprise_user(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UserType,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    @overload
    def provision_enterprise_user(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        schemas: list[Literal["urn:ietf:params:scim:schemas:core:2.0:User"]],
        external_id: str,
        active: bool,
        user_name: str,
        name: Missing[UserNameType] = UNSET,
        display_name: str,
        emails: list[UserEmailsItemsType],
        roles: Missing[list[UserRoleItemsType]] = UNSET,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    def provision_enterprise_user(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserType] = UNSET,
        **kwargs,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]:
        """enterprise-admin/provision-enterprise-user

        POST /scim/v2/enterprises/{enterprise}/Users

        Creates an external identity for a new SCIM enterprise user.

        SCIM is responsible for user provisioning, not authentication. The actual user authentication is handled by SAML. However, with SCIM enabled, users must first be provisioned via SCIM before they can sign in through SAML.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#provision-a-scim-enterprise-user
        """

        from ..models import ScimEnterpriseUserResponse, ScimError, User

        url = f"/scim/v2/enterprises/{enterprise}/Users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(User, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimEnterpriseUserResponse,
            error_models={
                "400": ScimError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    async def async_provision_enterprise_user(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UserType,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    @overload
    async def async_provision_enterprise_user(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        schemas: list[Literal["urn:ietf:params:scim:schemas:core:2.0:User"]],
        external_id: str,
        active: bool,
        user_name: str,
        name: Missing[UserNameType] = UNSET,
        display_name: str,
        emails: list[UserEmailsItemsType],
        roles: Missing[list[UserRoleItemsType]] = UNSET,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    async def async_provision_enterprise_user(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserType] = UNSET,
        **kwargs,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]:
        """enterprise-admin/provision-enterprise-user

        POST /scim/v2/enterprises/{enterprise}/Users

        Creates an external identity for a new SCIM enterprise user.

        SCIM is responsible for user provisioning, not authentication. The actual user authentication is handled by SAML. However, with SCIM enabled, users must first be provisioned via SCIM before they can sign in through SAML.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#provision-a-scim-enterprise-user
        """

        from ..models import ScimEnterpriseUserResponse, ScimError, User

        url = f"/scim/v2/enterprises/{enterprise}/Users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(User, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimEnterpriseUserResponse,
            error_models={
                "400": ScimError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    def get_provisioning_information_for_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]:
        """enterprise-admin/get-provisioning-information-for-enterprise-user

        GET /scim/v2/enterprises/{enterprise}/Users/{scim_user_id}

        Gets information about a SCIM user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#get-scim-provisioning-information-for-an-enterprise-user
        """

        from ..models import BasicError, ScimEnterpriseUserResponse, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimEnterpriseUserResponse,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    async def async_get_provisioning_information_for_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]:
        """enterprise-admin/get-provisioning-information-for-enterprise-user

        GET /scim/v2/enterprises/{enterprise}/Users/{scim_user_id}

        Gets information about a SCIM user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#get-scim-provisioning-information-for-an-enterprise-user
        """

        from ..models import BasicError, ScimEnterpriseUserResponse, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimEnterpriseUserResponse,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    def set_information_for_provisioned_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UserType,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    @overload
    def set_information_for_provisioned_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        schemas: list[Literal["urn:ietf:params:scim:schemas:core:2.0:User"]],
        external_id: str,
        active: bool,
        user_name: str,
        name: Missing[UserNameType] = UNSET,
        display_name: str,
        emails: list[UserEmailsItemsType],
        roles: Missing[list[UserRoleItemsType]] = UNSET,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    def set_information_for_provisioned_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserType] = UNSET,
        **kwargs,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]:
        """enterprise-admin/set-information-for-provisioned-enterprise-user

        PUT /scim/v2/enterprises/{enterprise}/Users/{scim_user_id}

        Replaces an existing provisioned user's information.

        You must supply complete user information, just as you would when provisioning them initially. Any previously existing data not provided will be deleted. To update only a specific attribute, refer to the [Update an attribute for a SCIM user](#update-an-attribute-for-a-scim-enterprise-user) endpoint.

        > [!WARNING]
        > Setting `active: false` will suspend a user, and their handle and email will be obfuscated.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#set-scim-information-for-a-provisioned-enterprise-user
        """

        from ..models import BasicError, ScimEnterpriseUserResponse, ScimError, User

        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(User, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimEnterpriseUserResponse,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    async def async_set_information_for_provisioned_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UserType,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    @overload
    async def async_set_information_for_provisioned_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        schemas: list[Literal["urn:ietf:params:scim:schemas:core:2.0:User"]],
        external_id: str,
        active: bool,
        user_name: str,
        name: Missing[UserNameType] = UNSET,
        display_name: str,
        emails: list[UserEmailsItemsType],
        roles: Missing[list[UserRoleItemsType]] = UNSET,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    async def async_set_information_for_provisioned_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserType] = UNSET,
        **kwargs,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]:
        """enterprise-admin/set-information-for-provisioned-enterprise-user

        PUT /scim/v2/enterprises/{enterprise}/Users/{scim_user_id}

        Replaces an existing provisioned user's information.

        You must supply complete user information, just as you would when provisioning them initially. Any previously existing data not provided will be deleted. To update only a specific attribute, refer to the [Update an attribute for a SCIM user](#update-an-attribute-for-a-scim-enterprise-user) endpoint.

        > [!WARNING]
        > Setting `active: false` will suspend a user, and their handle and email will be obfuscated.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#set-scim-information-for-a-provisioned-enterprise-user
        """

        from ..models import BasicError, ScimEnterpriseUserResponse, ScimError, User

        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(User, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimEnterpriseUserResponse,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    def delete_user_from_enterprise(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/delete-user-from-enterprise

        DELETE /scim/v2/enterprises/{enterprise}/Users/{scim_user_id}

        Suspends a SCIM user permanently from an enterprise. This action will: remove all the user's data,  anonymize their login, email, and display name, erase all external identity SCIM attributes, delete the user's emails, avatar, PATs, SSH keys, OAuth authorizations, GPG keys, and SAML mappings. This action is irreversible.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#delete-a-scim-user-from-an-enterprise
        """

        from ..models import BasicError, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    async def async_delete_user_from_enterprise(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-admin/delete-user-from-enterprise

        DELETE /scim/v2/enterprises/{enterprise}/Users/{scim_user_id}

        Suspends a SCIM user permanently from an enterprise. This action will: remove all the user's data,  anonymize their login, email, and display name, erase all external identity SCIM attributes, delete the user's emails, avatar, PATs, SSH keys, OAuth authorizations, GPG keys, and SAML mappings. This action is irreversible.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#delete-a-scim-user-from-an-enterprise
        """

        from ..models import BasicError, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    def update_attribute_for_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: PatchSchemaType,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    @overload
    def update_attribute_for_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        operations: list[PatchSchemaPropOperationsItemsType],
        schemas: list[Literal["urn:ietf:params:scim:api:messages:2.0:PatchOp"]],
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    def update_attribute_for_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[PatchSchemaType] = UNSET,
        **kwargs,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]:
        """enterprise-admin/update-attribute-for-enterprise-user

        PATCH /scim/v2/enterprises/{enterprise}/Users/{scim_user_id}

        Update a provisioned user's individual attributes.

        To modify a user's attributes, you'll need to provide a `Operations` JSON formatted request that includes at least one of the following actions: add, remove, or replace. For specific examples and more information on the SCIM operations format, please refer to the [SCIM specification](https://tools.ietf.org/html/rfc7644#section-3.5.2).

        > [!NOTE]
        > Complex SCIM `path` selectors that include filters are not supported. For example, a `path` selector defined as `"path": "emails[type eq \"work\"]"` will be ineffective.

        > [!WARNING]
        > Setting `active: false` will suspend a user, and their handle and email will be obfuscated.
        > ```
        > {
        >   "Operations":[{
        >     "op":"replace",
        >     "value":{
        >       "active":false
        >     }
        >   }]
        > }
        > ```

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#update-an-attribute-for-a-scim-enterprise-user
        """

        from ..models import (
            BasicError,
            PatchSchema,
            ScimEnterpriseUserResponse,
            ScimError,
        )

        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(PatchSchema, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimEnterpriseUserResponse,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    async def async_update_attribute_for_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: PatchSchemaType,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    @overload
    async def async_update_attribute_for_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        operations: list[PatchSchemaPropOperationsItemsType],
        schemas: list[Literal["urn:ietf:params:scim:api:messages:2.0:PatchOp"]],
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    async def async_update_attribute_for_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[PatchSchemaType] = UNSET,
        **kwargs,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]:
        """enterprise-admin/update-attribute-for-enterprise-user

        PATCH /scim/v2/enterprises/{enterprise}/Users/{scim_user_id}

        Update a provisioned user's individual attributes.

        To modify a user's attributes, you'll need to provide a `Operations` JSON formatted request that includes at least one of the following actions: add, remove, or replace. For specific examples and more information on the SCIM operations format, please refer to the [SCIM specification](https://tools.ietf.org/html/rfc7644#section-3.5.2).

        > [!NOTE]
        > Complex SCIM `path` selectors that include filters are not supported. For example, a `path` selector defined as `"path": "emails[type eq \"work\"]"` will be ineffective.

        > [!WARNING]
        > Setting `active: false` will suspend a user, and their handle and email will be obfuscated.
        > ```
        > {
        >   "Operations":[{
        >     "op":"replace",
        >     "value":{
        >       "active":false
        >     }
        >   }]
        > }
        > ```

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#update-an-attribute-for-a-scim-enterprise-user
        """

        from ..models import (
            BasicError,
            PatchSchema,
            ScimEnterpriseUserResponse,
            ScimError,
        )

        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(PatchSchema, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimEnterpriseUserResponse,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )
