"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import Reaction
    from ..types import (
        OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType,
        OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBodyType,
        ReactionType,
        ReposOwnerRepoCommentsCommentIdReactionsPostBodyType,
        ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBodyType,
        ReposOwnerRepoIssuesIssueNumberReactionsPostBodyType,
        ReposOwnerRepoPullsCommentsCommentIdReactionsPostBodyType,
        ReposOwnerRepoReleasesReleaseIdReactionsPostBodyType,
        TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType,
        TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBodyType,
    )


class ReactionsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Reaction], list[ReactionType]]:
        """reactions/list-for-team-discussion-comment-in-org

        GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions

        List the reactions to a [team discussion comment](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#get-a-discussion-comment).

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-a-team-discussion-comment
        """

        from ..models import Reaction

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Reaction],
        )

    async def async_list_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Reaction], list[ReactionType]]:
        """reactions/list-for-team-discussion-comment-in-org

        GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions

        List the reactions to a [team discussion comment](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#get-a-discussion-comment).

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-a-team-discussion-comment
        """

        from ..models import Reaction

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Reaction],
        )

    @overload
    def create_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType,
    ) -> Response[Reaction, ReactionType]: ...

    @overload
    def create_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction, ReactionType]: ...

    def create_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction, ReactionType]:
        """reactions/create-for-team-discussion-comment-in-org

        POST /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions

        Create a reaction to a [team discussion comment](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#get-a-discussion-comment).

        A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-a-team-discussion-comment
        """

        from ..models import (
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
            Reaction,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Reaction,
        )

    @overload
    async def async_create_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType,
    ) -> Response[Reaction, ReactionType]: ...

    @overload
    async def async_create_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction, ReactionType]: ...

    async def async_create_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction, ReactionType]:
        """reactions/create-for-team-discussion-comment-in-org

        POST /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions

        Create a reaction to a [team discussion comment](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#get-a-discussion-comment).

        A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-a-team-discussion-comment
        """

        from ..models import (
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
            Reaction,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Reaction,
        )

    def delete_for_team_discussion_comment(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        reaction_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """reactions/delete-for-team-discussion-comment

        DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}

        > [!NOTE]
        > You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions/:reaction_id`.

        Delete a reaction to a [team discussion comment](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#get-a-discussion-comment).

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#delete-team-discussion-comment-reaction
        """

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_for_team_discussion_comment(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        reaction_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """reactions/delete-for-team-discussion-comment

        DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}

        > [!NOTE]
        > You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions/:reaction_id`.

        Delete a reaction to a [team discussion comment](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#get-a-discussion-comment).

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#delete-team-discussion-comment-reaction
        """

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Reaction], list[ReactionType]]:
        """reactions/list-for-team-discussion-in-org

        GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions

        List the reactions to a [team discussion](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#get-a-discussion).

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-a-team-discussion
        """

        from ..models import Reaction

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Reaction],
        )

    async def async_list_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Reaction], list[ReactionType]]:
        """reactions/list-for-team-discussion-in-org

        GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions

        List the reactions to a [team discussion](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#get-a-discussion).

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-a-team-discussion
        """

        from ..models import Reaction

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Reaction],
        )

    @overload
    def create_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBodyType,
    ) -> Response[Reaction, ReactionType]: ...

    @overload
    def create_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction, ReactionType]: ...

    def create_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction, ReactionType]:
        """reactions/create-for-team-discussion-in-org

        POST /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions

        Create a reaction to a [team discussion](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#get-a-discussion).

        A response with an HTTP `200` status means that you already added the reaction type to this team discussion.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-a-team-discussion
        """

        from ..models import (
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBody,
            Reaction,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Reaction,
        )

    @overload
    async def async_create_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBodyType,
    ) -> Response[Reaction, ReactionType]: ...

    @overload
    async def async_create_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction, ReactionType]: ...

    async def async_create_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction, ReactionType]:
        """reactions/create-for-team-discussion-in-org

        POST /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions

        Create a reaction to a [team discussion](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#get-a-discussion).

        A response with an HTTP `200` status means that you already added the reaction type to this team discussion.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-a-team-discussion
        """

        from ..models import (
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBody,
            Reaction,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Reaction,
        )

    def delete_for_team_discussion(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        reaction_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """reactions/delete-for-team-discussion

        DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}

        > [!NOTE]
        > You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions/:reaction_id`.

        Delete a reaction to a [team discussion](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#get-a-discussion).

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#delete-team-discussion-reaction
        """

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_for_team_discussion(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        reaction_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """reactions/delete-for-team-discussion

        DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}

        > [!NOTE]
        > You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions/:reaction_id`.

        Delete a reaction to a [team discussion](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#get-a-discussion).

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#delete-team-discussion-reaction
        """

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Reaction], list[ReactionType]]:
        """reactions/list-for-commit-comment

        GET /repos/{owner}/{repo}/comments/{comment_id}/reactions

        List the reactions to a [commit comment](https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#get-a-commit-comment).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-a-commit-comment
        """

        from ..models import BasicError, Reaction

        url = f"/repos/{owner}/{repo}/comments/{comment_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Reaction], list[ReactionType]]:
        """reactions/list-for-commit-comment

        GET /repos/{owner}/{repo}/comments/{comment_id}/reactions

        List the reactions to a [commit comment](https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#get-a-commit-comment).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-a-commit-comment
        """

        from ..models import BasicError, Reaction

        url = f"/repos/{owner}/{repo}/comments/{comment_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoCommentsCommentIdReactionsPostBodyType,
    ) -> Response[Reaction, ReactionType]: ...

    @overload
    def create_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction, ReactionType]: ...

    def create_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoCommentsCommentIdReactionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Reaction, ReactionType]:
        """reactions/create-for-commit-comment

        POST /repos/{owner}/{repo}/comments/{comment_id}/reactions

        Create a reaction to a [commit comment](https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#get-a-commit-comment). A response with an HTTP `200` status means that you already added the reaction type to this commit comment.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-a-commit-comment
        """

        from ..models import (
            Reaction,
            ReposOwnerRepoCommentsCommentIdReactionsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/comments/{comment_id}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoCommentsCommentIdReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoCommentsCommentIdReactionsPostBodyType,
    ) -> Response[Reaction, ReactionType]: ...

    @overload
    async def async_create_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction, ReactionType]: ...

    async def async_create_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoCommentsCommentIdReactionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Reaction, ReactionType]:
        """reactions/create-for-commit-comment

        POST /repos/{owner}/{repo}/comments/{comment_id}/reactions

        Create a reaction to a [commit comment](https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#get-a-commit-comment). A response with an HTTP `200` status means that you already added the reaction type to this commit comment.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-a-commit-comment
        """

        from ..models import (
            Reaction,
            ReposOwnerRepoCommentsCommentIdReactionsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/comments/{comment_id}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoCommentsCommentIdReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    def delete_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        reaction_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """reactions/delete-for-commit-comment

        DELETE /repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}

        > [!NOTE]
        > You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/comments/:comment_id/reactions/:reaction_id`.

        Delete a reaction to a [commit comment](https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#get-a-commit-comment).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#delete-a-commit-comment-reaction
        """

        url = f"/repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        reaction_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """reactions/delete-for-commit-comment

        DELETE /repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}

        > [!NOTE]
        > You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/comments/:comment_id/reactions/:reaction_id`.

        Delete a reaction to a [commit comment](https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#get-a-commit-comment).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#delete-a-commit-comment-reaction
        """

        url = f"/repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Reaction], list[ReactionType]]:
        """reactions/list-for-issue-comment

        GET /repos/{owner}/{repo}/issues/comments/{comment_id}/reactions

        List the reactions to an [issue comment](https://docs.github.com/enterprise-cloud@latest//rest/issues/comments#get-an-issue-comment).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-an-issue-comment
        """

        from ..models import BasicError, Reaction

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Reaction], list[ReactionType]]:
        """reactions/list-for-issue-comment

        GET /repos/{owner}/{repo}/issues/comments/{comment_id}/reactions

        List the reactions to an [issue comment](https://docs.github.com/enterprise-cloud@latest//rest/issues/comments#get-an-issue-comment).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-an-issue-comment
        """

        from ..models import BasicError, Reaction

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBodyType,
    ) -> Response[Reaction, ReactionType]: ...

    @overload
    def create_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction, ReactionType]: ...

    def create_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction, ReactionType]:
        """reactions/create-for-issue-comment

        POST /repos/{owner}/{repo}/issues/comments/{comment_id}/reactions

        Create a reaction to an [issue comment](https://docs.github.com/enterprise-cloud@latest//rest/issues/comments#get-an-issue-comment). A response with an HTTP `200` status means that you already added the reaction type to this issue comment.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-an-issue-comment
        """

        from ..models import (
            Reaction,
            ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBodyType,
    ) -> Response[Reaction, ReactionType]: ...

    @overload
    async def async_create_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction, ReactionType]: ...

    async def async_create_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction, ReactionType]:
        """reactions/create-for-issue-comment

        POST /repos/{owner}/{repo}/issues/comments/{comment_id}/reactions

        Create a reaction to an [issue comment](https://docs.github.com/enterprise-cloud@latest//rest/issues/comments#get-an-issue-comment). A response with an HTTP `200` status means that you already added the reaction type to this issue comment.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-an-issue-comment
        """

        from ..models import (
            Reaction,
            ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    def delete_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        reaction_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """reactions/delete-for-issue-comment

        DELETE /repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}

        > [!NOTE]
        > You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/issues/comments/:comment_id/reactions/:reaction_id`.

        Delete a reaction to an [issue comment](https://docs.github.com/enterprise-cloud@latest//rest/issues/comments#get-an-issue-comment).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#delete-an-issue-comment-reaction
        """

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        reaction_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """reactions/delete-for-issue-comment

        DELETE /repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}

        > [!NOTE]
        > You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/issues/comments/:comment_id/reactions/:reaction_id`.

        Delete a reaction to an [issue comment](https://docs.github.com/enterprise-cloud@latest//rest/issues/comments#get-an-issue-comment).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#delete-an-issue-comment-reaction
        """

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Reaction], list[ReactionType]]:
        """reactions/list-for-issue

        GET /repos/{owner}/{repo}/issues/{issue_number}/reactions

        List the reactions to an [issue](https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#get-an-issue).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-an-issue
        """

        from ..models import BasicError, Reaction

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Reaction],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    async def async_list_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Reaction], list[ReactionType]]:
        """reactions/list-for-issue

        GET /repos/{owner}/{repo}/issues/{issue_number}/reactions

        List the reactions to an [issue](https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#get-an-issue).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-an-issue
        """

        from ..models import BasicError, Reaction

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Reaction],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    def create_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoIssuesIssueNumberReactionsPostBodyType,
    ) -> Response[Reaction, ReactionType]: ...

    @overload
    def create_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction, ReactionType]: ...

    def create_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoIssuesIssueNumberReactionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Reaction, ReactionType]:
        """reactions/create-for-issue

        POST /repos/{owner}/{repo}/issues/{issue_number}/reactions

        Create a reaction to an [issue](https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#get-an-issue). A response with an HTTP `200` status means that you already added the reaction type to this issue.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-an-issue
        """

        from ..models import (
            Reaction,
            ReposOwnerRepoIssuesIssueNumberReactionsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoIssuesIssueNumberReactionsPostBodyType,
    ) -> Response[Reaction, ReactionType]: ...

    @overload
    async def async_create_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction, ReactionType]: ...

    async def async_create_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoIssuesIssueNumberReactionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Reaction, ReactionType]:
        """reactions/create-for-issue

        POST /repos/{owner}/{repo}/issues/{issue_number}/reactions

        Create a reaction to an [issue](https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#get-an-issue). A response with an HTTP `200` status means that you already added the reaction type to this issue.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-an-issue
        """

        from ..models import (
            Reaction,
            ReposOwnerRepoIssuesIssueNumberReactionsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    def delete_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        reaction_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """reactions/delete-for-issue

        DELETE /repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}

        > [!NOTE]
        > You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/issues/:issue_number/reactions/:reaction_id`.

        Delete a reaction to an [issue](https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#get-an-issue).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#delete-an-issue-reaction
        """

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        reaction_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """reactions/delete-for-issue

        DELETE /repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}

        > [!NOTE]
        > You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/issues/:issue_number/reactions/:reaction_id`.

        Delete a reaction to an [issue](https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#get-an-issue).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#delete-an-issue-reaction
        """

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Reaction], list[ReactionType]]:
        """reactions/list-for-pull-request-review-comment

        GET /repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions

        List the reactions to a [pull request review comment](https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#get-a-review-comment-for-a-pull-request).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-a-pull-request-review-comment
        """

        from ..models import BasicError, Reaction

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Reaction], list[ReactionType]]:
        """reactions/list-for-pull-request-review-comment

        GET /repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions

        List the reactions to a [pull request review comment](https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#get-a-review-comment-for-a-pull-request).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-a-pull-request-review-comment
        """

        from ..models import BasicError, Reaction

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPullsCommentsCommentIdReactionsPostBodyType,
    ) -> Response[Reaction, ReactionType]: ...

    @overload
    def create_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction, ReactionType]: ...

    def create_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoPullsCommentsCommentIdReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction, ReactionType]:
        """reactions/create-for-pull-request-review-comment

        POST /repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions

        Create a reaction to a [pull request review comment](https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#get-a-review-comment-for-a-pull-request). A response with an HTTP `200` status means that you already added the reaction type to this pull request review comment.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-a-pull-request-review-comment
        """

        from ..models import (
            Reaction,
            ReposOwnerRepoPullsCommentsCommentIdReactionsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsCommentsCommentIdReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPullsCommentsCommentIdReactionsPostBodyType,
    ) -> Response[Reaction, ReactionType]: ...

    @overload
    async def async_create_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction, ReactionType]: ...

    async def async_create_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoPullsCommentsCommentIdReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction, ReactionType]:
        """reactions/create-for-pull-request-review-comment

        POST /repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions

        Create a reaction to a [pull request review comment](https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#get-a-review-comment-for-a-pull-request). A response with an HTTP `200` status means that you already added the reaction type to this pull request review comment.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-a-pull-request-review-comment
        """

        from ..models import (
            Reaction,
            ReposOwnerRepoPullsCommentsCommentIdReactionsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsCommentsCommentIdReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    def delete_for_pull_request_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        reaction_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """reactions/delete-for-pull-request-comment

        DELETE /repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}

        > [!NOTE]
        > You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/pulls/comments/:comment_id/reactions/:reaction_id.`

        Delete a reaction to a [pull request review comment](https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#get-a-review-comment-for-a-pull-request).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#delete-a-pull-request-comment-reaction
        """

        url = (
            f"/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_for_pull_request_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        reaction_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """reactions/delete-for-pull-request-comment

        DELETE /repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}

        > [!NOTE]
        > You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/pulls/comments/:comment_id/reactions/:reaction_id.`

        Delete a reaction to a [pull request review comment](https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#get-a-review-comment-for-a-pull-request).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#delete-a-pull-request-comment-reaction
        """

        url = (
            f"/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        content: Missing[
            Literal["+1", "laugh", "heart", "hooray", "rocket", "eyes"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Reaction], list[ReactionType]]:
        """reactions/list-for-release

        GET /repos/{owner}/{repo}/releases/{release_id}/reactions

        List the reactions to a [release](https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#get-a-release).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-a-release
        """

        from ..models import BasicError, Reaction

        url = f"/repos/{owner}/{repo}/releases/{release_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        content: Missing[
            Literal["+1", "laugh", "heart", "hooray", "rocket", "eyes"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Reaction], list[ReactionType]]:
        """reactions/list-for-release

        GET /repos/{owner}/{repo}/releases/{release_id}/reactions

        List the reactions to a [release](https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#get-a-release).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-a-release
        """

        from ..models import BasicError, Reaction

        url = f"/repos/{owner}/{repo}/releases/{release_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoReleasesReleaseIdReactionsPostBodyType,
    ) -> Response[Reaction, ReactionType]: ...

    @overload
    def create_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content: Literal["+1", "laugh", "heart", "hooray", "rocket", "eyes"],
    ) -> Response[Reaction, ReactionType]: ...

    def create_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoReleasesReleaseIdReactionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Reaction, ReactionType]:
        """reactions/create-for-release

        POST /repos/{owner}/{repo}/releases/{release_id}/reactions

        Create a reaction to a [release](https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#get-a-release). A response with a `Status: 200 OK` means that you already added the reaction type to this release.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-a-release
        """

        from ..models import (
            Reaction,
            ReposOwnerRepoReleasesReleaseIdReactionsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/releases/{release_id}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoReleasesReleaseIdReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoReleasesReleaseIdReactionsPostBodyType,
    ) -> Response[Reaction, ReactionType]: ...

    @overload
    async def async_create_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content: Literal["+1", "laugh", "heart", "hooray", "rocket", "eyes"],
    ) -> Response[Reaction, ReactionType]: ...

    async def async_create_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoReleasesReleaseIdReactionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Reaction, ReactionType]:
        """reactions/create-for-release

        POST /repos/{owner}/{repo}/releases/{release_id}/reactions

        Create a reaction to a [release](https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#get-a-release). A response with a `Status: 200 OK` means that you already added the reaction type to this release.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-a-release
        """

        from ..models import (
            Reaction,
            ReposOwnerRepoReleasesReleaseIdReactionsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/releases/{release_id}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoReleasesReleaseIdReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    def delete_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        reaction_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """reactions/delete-for-release

        DELETE /repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}

        > [!NOTE]
        > You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/releases/:release_id/reactions/:reaction_id`.

        Delete a reaction to a [release](https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#get-a-release).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#delete-a-release-reaction
        """

        url = f"/repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        reaction_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """reactions/delete-for-release

        DELETE /repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}

        > [!NOTE]
        > You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/releases/:release_id/reactions/:reaction_id`.

        Delete a reaction to a [release](https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#get-a-release).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#delete-a-release-reaction
        """

        url = f"/repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Reaction], list[ReactionType]]:
        """DEPRECATED reactions/list-for-team-discussion-comment-legacy

        GET /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion comment`](https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-a-team-discussion-comment) endpoint.

        List the reactions to a [team discussion comment](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#get-a-discussion-comment).

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-a-team-discussion-comment-legacy
        """

        from ..models import Reaction

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Reaction],
        )

    async def async_list_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Reaction], list[ReactionType]]:
        """DEPRECATED reactions/list-for-team-discussion-comment-legacy

        GET /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion comment`](https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-a-team-discussion-comment) endpoint.

        List the reactions to a [team discussion comment](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#get-a-discussion-comment).

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-a-team-discussion-comment-legacy
        """

        from ..models import Reaction

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Reaction],
        )

    @overload
    def create_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType,
    ) -> Response[Reaction, ReactionType]: ...

    @overload
    def create_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction, ReactionType]: ...

    def create_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction, ReactionType]:
        """DEPRECATED reactions/create-for-team-discussion-comment-legacy

        POST /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Create reaction for a team discussion comment](https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-a-team-discussion-comment)" endpoint.

        Create a reaction to a [team discussion comment](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#get-a-discussion-comment).

        A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-a-team-discussion-comment-legacy
        """

        from ..models import (
            Reaction,
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Reaction,
        )

    @overload
    async def async_create_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType,
    ) -> Response[Reaction, ReactionType]: ...

    @overload
    async def async_create_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction, ReactionType]: ...

    async def async_create_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction, ReactionType]:
        """DEPRECATED reactions/create-for-team-discussion-comment-legacy

        POST /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Create reaction for a team discussion comment](https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-a-team-discussion-comment)" endpoint.

        Create a reaction to a [team discussion comment](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#get-a-discussion-comment).

        A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-a-team-discussion-comment-legacy
        """

        from ..models import (
            Reaction,
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Reaction,
        )

    def list_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Reaction], list[ReactionType]]:
        """DEPRECATED reactions/list-for-team-discussion-legacy

        GET /teams/{team_id}/discussions/{discussion_number}/reactions

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion`](https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-a-team-discussion) endpoint.

        List the reactions to a [team discussion](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#get-a-discussion).

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-a-team-discussion-legacy
        """

        from ..models import Reaction

        url = f"/teams/{team_id}/discussions/{discussion_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Reaction],
        )

    async def async_list_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Reaction], list[ReactionType]]:
        """DEPRECATED reactions/list-for-team-discussion-legacy

        GET /teams/{team_id}/discussions/{discussion_number}/reactions

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion`](https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-a-team-discussion) endpoint.

        List the reactions to a [team discussion](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#get-a-discussion).

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#list-reactions-for-a-team-discussion-legacy
        """

        from ..models import Reaction

        url = f"/teams/{team_id}/discussions/{discussion_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Reaction],
        )

    @overload
    def create_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBodyType,
    ) -> Response[Reaction, ReactionType]: ...

    @overload
    def create_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction, ReactionType]: ...

    def create_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction, ReactionType]:
        """DEPRECATED reactions/create-for-team-discussion-legacy

        POST /teams/{team_id}/discussions/{discussion_number}/reactions

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create reaction for a team discussion`](https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-a-team-discussion) endpoint.

        Create a reaction to a [team discussion](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#get-a-discussion).

        A response with an HTTP `200` status means that you already added the reaction type to this team discussion.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-a-team-discussion-legacy
        """

        from ..models import (
            Reaction,
            TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Reaction,
        )

    @overload
    async def async_create_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBodyType,
    ) -> Response[Reaction, ReactionType]: ...

    @overload
    async def async_create_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction, ReactionType]: ...

    async def async_create_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction, ReactionType]:
        """DEPRECATED reactions/create-for-team-discussion-legacy

        POST /teams/{team_id}/discussions/{discussion_number}/reactions

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create reaction for a team discussion`](https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-a-team-discussion) endpoint.

        Create a reaction to a [team discussion](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#get-a-discussion).

        A response with an HTTP `200` status means that you already added the reaction type to this team discussion.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/reactions/reactions#create-reaction-for-a-team-discussion-legacy
        """

        from ..models import (
            Reaction,
            TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Reaction,
        )
