"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        ActionsBillingUsage,
        AdvancedSecurityActiveCommitters,
        BillingUsageReport,
        BillingUsageReportUser,
        CombinedBillingUsage,
        DeleteCostCenter,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
        GetAllCostCenters,
        GetCostCenter,
        PackagesBillingUsage,
    )
    from ..types import (
        ActionsBillingUsageType,
        AdvancedSecurityActiveCommittersType,
        BillingUsageReportType,
        BillingUsageReportUserType,
        CombinedBillingUsageType,
        DeleteCostCenterType,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdPatchBodyType,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBodyType,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200Type,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBodyType,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200Type,
        EnterprisesEnterpriseSettingsBillingCostCentersPostBodyType,
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200Type,
        GetAllCostCentersType,
        GetCostCenterType,
        PackagesBillingUsageType,
    )


class BillingClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def get_github_actions_billing_ghe(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsBillingUsage, ActionsBillingUsageType]:
        """billing/get-github-actions-billing-ghe

        GET /enterprises/{enterprise}/settings/billing/actions

        Gets the summary of the free and paid GitHub Actions minutes used.

        Paid minutes only apply to workflows in private repositories that use GitHub-hosted runners. Minutes used is listed for each GitHub-hosted runner operating system. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".

        The authenticated user must be an enterprise admin.

        > [!NOTE]
        > This endpoint is available to enterprise customers who are using the legacy billing platform.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-github-actions-billing-for-an-enterprise
        """

        from ..models import ActionsBillingUsage

        url = f"/enterprises/{enterprise}/settings/billing/actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsBillingUsage,
        )

    async def async_get_github_actions_billing_ghe(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsBillingUsage, ActionsBillingUsageType]:
        """billing/get-github-actions-billing-ghe

        GET /enterprises/{enterprise}/settings/billing/actions

        Gets the summary of the free and paid GitHub Actions minutes used.

        Paid minutes only apply to workflows in private repositories that use GitHub-hosted runners. Minutes used is listed for each GitHub-hosted runner operating system. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".

        The authenticated user must be an enterprise admin.

        > [!NOTE]
        > This endpoint is available to enterprise customers who are using the legacy billing platform.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-github-actions-billing-for-an-enterprise
        """

        from ..models import ActionsBillingUsage

        url = f"/enterprises/{enterprise}/settings/billing/actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsBillingUsage,
        )

    def get_github_advanced_security_billing_ghe(
        self,
        enterprise: str,
        *,
        advanced_security_product: Missing[
            Literal["code_security", "secret_protection"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        AdvancedSecurityActiveCommitters, AdvancedSecurityActiveCommittersType
    ]:
        """billing/get-github-advanced-security-billing-ghe

        GET /enterprises/{enterprise}/settings/billing/advanced-security

        Gets the GitHub Advanced Security active committers for an enterprise per repository.

        Each distinct user login across all repositories is counted as a single Advanced Security seat, so the `total_advanced_security_committers` is not the sum of active_users for each repository.

        The total number of repositories with committer information is tracked by the `total_count` field.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-github-advanced-security-active-committers-for-an-enterprise
        """

        from ..models import AdvancedSecurityActiveCommitters

        url = f"/enterprises/{enterprise}/settings/billing/advanced-security"

        params = {
            "advanced_security_product": advanced_security_product,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AdvancedSecurityActiveCommitters,
        )

    async def async_get_github_advanced_security_billing_ghe(
        self,
        enterprise: str,
        *,
        advanced_security_product: Missing[
            Literal["code_security", "secret_protection"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        AdvancedSecurityActiveCommitters, AdvancedSecurityActiveCommittersType
    ]:
        """billing/get-github-advanced-security-billing-ghe

        GET /enterprises/{enterprise}/settings/billing/advanced-security

        Gets the GitHub Advanced Security active committers for an enterprise per repository.

        Each distinct user login across all repositories is counted as a single Advanced Security seat, so the `total_advanced_security_committers` is not the sum of active_users for each repository.

        The total number of repositories with committer information is tracked by the `total_count` field.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-github-advanced-security-active-committers-for-an-enterprise
        """

        from ..models import AdvancedSecurityActiveCommitters

        url = f"/enterprises/{enterprise}/settings/billing/advanced-security"

        params = {
            "advanced_security_product": advanced_security_product,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AdvancedSecurityActiveCommitters,
        )

    def get_all_cost_centers(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GetAllCostCenters, GetAllCostCentersType]:
        """billing/get-all-cost-centers

        GET /enterprises/{enterprise}/settings/billing/cost-centers

        Gets a list of all the cost centers for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-all-cost-centers-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            GetAllCostCenters,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetAllCostCenters,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_all_cost_centers(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GetAllCostCenters, GetAllCostCentersType]:
        """billing/get-all-cost-centers

        GET /enterprises/{enterprise}/settings/billing/cost-centers

        Gets a list of all the cost centers for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-all-cost-centers-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            GetAllCostCenters,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetAllCostCenters,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def create_cost_center(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseSettingsBillingCostCentersPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200Type,
    ]: ...

    @overload
    def create_cost_center(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200Type,
    ]: ...

    def create_cost_center(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingCostCentersPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200Type,
    ]:
        """billing/create-cost-center

        POST /enterprises/{enterprise}/settings/billing/cost-centers

        Creates a new cost center for an enterprise. The authenticated user must be an enterprise admin.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#create-a-new-cost-center
        """

        from ..models import (
            EnterprisesEnterpriseSettingsBillingCostCentersPostBody,
            EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingCostCentersPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
            error_models={},
        )

    @overload
    async def async_create_cost_center(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseSettingsBillingCostCentersPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200Type,
    ]: ...

    @overload
    async def async_create_cost_center(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200Type,
    ]: ...

    async def async_create_cost_center(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingCostCentersPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200Type,
    ]:
        """billing/create-cost-center

        POST /enterprises/{enterprise}/settings/billing/cost-centers

        Creates a new cost center for an enterprise. The authenticated user must be an enterprise admin.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#create-a-new-cost-center
        """

        from ..models import (
            EnterprisesEnterpriseSettingsBillingCostCentersPostBody,
            EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingCostCentersPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
            error_models={},
        )

    def get_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GetCostCenter, GetCostCenterType]:
        """billing/get-cost-center

        GET /enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}

        Gets a cost center by ID. The authenticated user must be an enterprise admin.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-a-cost-center-by-id
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            GetCostCenter,
        )

        url = (
            f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetCostCenter,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GetCostCenter, GetCostCenterType]:
        """billing/get-cost-center

        GET /enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}

        Gets a cost center by ID. The authenticated user must be an enterprise admin.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-a-cost-center-by-id
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            GetCostCenter,
        )

        url = (
            f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetCostCenter,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def delete_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DeleteCostCenter, DeleteCostCenterType]:
        """billing/delete-cost-center

        DELETE /enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}

        Archieves a cost center by ID. The authenticated user must be an enterprise admin.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#delete-a-cost-center
        """

        from ..models import (
            BasicError,
            DeleteCostCenter,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = (
            f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeleteCostCenter,
            error_models={
                "400": BasicError,
                "404": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_delete_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DeleteCostCenter, DeleteCostCenterType]:
        """billing/delete-cost-center

        DELETE /enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}

        Archieves a cost center by ID. The authenticated user must be an enterprise admin.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#delete-a-cost-center
        """

        from ..models import (
            BasicError,
            DeleteCostCenter,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = (
            f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeleteCostCenter,
            error_models={
                "400": BasicError,
                "404": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def update_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdPatchBodyType,
    ) -> Response[GetCostCenter, GetCostCenterType]: ...

    @overload
    def update_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
    ) -> Response[GetCostCenter, GetCostCenterType]: ...

    def update_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[GetCostCenter, GetCostCenterType]:
        """billing/update-cost-center

        PATCH /enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}

        Updates an existing cost center name.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#update-a-cost-center-name
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdPatchBody,
            GetCostCenter,
        )

        url = (
            f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetCostCenter,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_update_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdPatchBodyType,
    ) -> Response[GetCostCenter, GetCostCenterType]: ...

    @overload
    async def async_update_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
    ) -> Response[GetCostCenter, GetCostCenterType]: ...

    async def async_update_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[GetCostCenter, GetCostCenterType]:
        """billing/update-cost-center

        PATCH /enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}

        Updates an existing cost center name.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#update-a-cost-center-name
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdPatchBody,
            GetCostCenter,
        )

        url = (
            f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetCostCenter,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def add_resource_to_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBodyType,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200Type,
    ]: ...

    @overload
    def add_resource_to_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        users: Missing[list[str]] = UNSET,
        organizations: Missing[list[str]] = UNSET,
        repositories: Missing[list[str]] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200Type,
    ]: ...

    def add_resource_to_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200Type,
    ]:
        """billing/add-resource-to-cost-center

        POST /enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}/resource

        Adds resources to a cost center.

        The usage for the resources will be charged to the cost center's budget. The authenticated user must be an enterprise admin in order to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#add-resources-to-a-cost-center
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBody,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}/resource"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "409": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_add_resource_to_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBodyType,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200Type,
    ]: ...

    @overload
    async def async_add_resource_to_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        users: Missing[list[str]] = UNSET,
        organizations: Missing[list[str]] = UNSET,
        repositories: Missing[list[str]] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200Type,
    ]: ...

    async def async_add_resource_to_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200Type,
    ]:
        """billing/add-resource-to-cost-center

        POST /enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}/resource

        Adds resources to a cost center.

        The usage for the resources will be charged to the cost center's budget. The authenticated user must be an enterprise admin in order to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#add-resources-to-a-cost-center
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBody,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}/resource"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "409": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def remove_resource_from_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBodyType,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200Type,
    ]: ...

    @overload
    def remove_resource_from_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        users: Missing[list[str]] = UNSET,
        organizations: Missing[list[str]] = UNSET,
        repositories: Missing[list[str]] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200Type,
    ]: ...

    def remove_resource_from_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200Type,
    ]:
        """billing/remove-resource-from-cost-center

        DELETE /enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}/resource

        Remove resources from a cost center.

        The usage for the resources will no longer be charged to the cost center's budget. The authenticated user must be an enterprise admin in order to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#remove-resources-from-a-cost-center
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBody,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}/resource"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_remove_resource_from_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBodyType,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200Type,
    ]: ...

    @overload
    async def async_remove_resource_from_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        users: Missing[list[str]] = UNSET,
        organizations: Missing[list[str]] = UNSET,
        repositories: Missing[list[str]] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200Type,
    ]: ...

    async def async_remove_resource_from_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200Type,
    ]:
        """billing/remove-resource-from-cost-center

        DELETE /enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}/resource

        Remove resources from a cost center.

        The usage for the resources will no longer be charged to the cost center's budget. The authenticated user must be an enterprise admin in order to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#remove-resources-from-a-cost-center
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBody,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}/resource"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_github_packages_billing_ghe(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PackagesBillingUsage, PackagesBillingUsageType]:
        """billing/get-github-packages-billing-ghe

        GET /enterprises/{enterprise}/settings/billing/packages

        Gets the free and paid storage used for GitHub Packages in gigabytes.

        Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."

        The authenticated user must be an enterprise admin.

        > [!NOTE]
        > This endpoint is available to enterprise customers who are using the legacy billing platform.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-github-packages-billing-for-an-enterprise
        """

        from ..models import PackagesBillingUsage

        url = f"/enterprises/{enterprise}/settings/billing/packages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PackagesBillingUsage,
        )

    async def async_get_github_packages_billing_ghe(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PackagesBillingUsage, PackagesBillingUsageType]:
        """billing/get-github-packages-billing-ghe

        GET /enterprises/{enterprise}/settings/billing/packages

        Gets the free and paid storage used for GitHub Packages in gigabytes.

        Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."

        The authenticated user must be an enterprise admin.

        > [!NOTE]
        > This endpoint is available to enterprise customers who are using the legacy billing platform.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-github-packages-billing-for-an-enterprise
        """

        from ..models import PackagesBillingUsage

        url = f"/enterprises/{enterprise}/settings/billing/packages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PackagesBillingUsage,
        )

    def get_shared_storage_billing_ghe(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CombinedBillingUsage, CombinedBillingUsageType]:
        """billing/get-shared-storage-billing-ghe

        GET /enterprises/{enterprise}/settings/billing/shared-storage

        Gets the estimated paid and estimated total storage used for GitHub Actions and GitHub Packages.

        Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."

        The authenticated user must be an enterprise admin.

        > [!NOTE]
        > This endpoint is available to enterprise customers who are using the legacy billing platform.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-shared-storage-billing-for-an-enterprise
        """

        from ..models import CombinedBillingUsage

        url = f"/enterprises/{enterprise}/settings/billing/shared-storage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CombinedBillingUsage,
        )

    async def async_get_shared_storage_billing_ghe(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CombinedBillingUsage, CombinedBillingUsageType]:
        """billing/get-shared-storage-billing-ghe

        GET /enterprises/{enterprise}/settings/billing/shared-storage

        Gets the estimated paid and estimated total storage used for GitHub Actions and GitHub Packages.

        Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."

        The authenticated user must be an enterprise admin.

        > [!NOTE]
        > This endpoint is available to enterprise customers who are using the legacy billing platform.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-shared-storage-billing-for-an-enterprise
        """

        from ..models import CombinedBillingUsage

        url = f"/enterprises/{enterprise}/settings/billing/shared-storage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CombinedBillingUsage,
        )

    def get_github_billing_usage_report_ghe(
        self,
        enterprise: str,
        *,
        year: Missing[int] = UNSET,
        month: Missing[int] = UNSET,
        day: Missing[int] = UNSET,
        hour: Missing[int] = UNSET,
        cost_center_id: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[BillingUsageReport, BillingUsageReportType]:
        """billing/get-github-billing-usage-report-ghe

        GET /enterprises/{enterprise}/settings/billing/usage

        Gets a report of usage by cost center for an enterprise. To use this endpoint, you must be an administrator or billing manager of the enterprise. By default this endpoint will return usage that does not have a cost center.

        **Note:** This endpoint is only available to enterprises with access to the enhanced billing platform. For more information, see "[About the enhanced billing platform for enterprises](https://docs.github.com/enterprise-cloud@latest//billing/using-the-enhanced-billing-platform-for-enterprises/about-the-enhanced-billing-platform-for-enterprises#how-do-i-know-if-i-can-access-the-enhanced-billing-platform)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-billing-usage-report-for-an-enterprise
        """

        from ..models import (
            BasicError,
            BillingUsageReport,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/enterprises/{enterprise}/settings/billing/usage"

        params = {
            "year": year,
            "month": month,
            "day": day,
            "hour": hour,
            "cost_center_id": cost_center_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BillingUsageReport,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_github_billing_usage_report_ghe(
        self,
        enterprise: str,
        *,
        year: Missing[int] = UNSET,
        month: Missing[int] = UNSET,
        day: Missing[int] = UNSET,
        hour: Missing[int] = UNSET,
        cost_center_id: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[BillingUsageReport, BillingUsageReportType]:
        """billing/get-github-billing-usage-report-ghe

        GET /enterprises/{enterprise}/settings/billing/usage

        Gets a report of usage by cost center for an enterprise. To use this endpoint, you must be an administrator or billing manager of the enterprise. By default this endpoint will return usage that does not have a cost center.

        **Note:** This endpoint is only available to enterprises with access to the enhanced billing platform. For more information, see "[About the enhanced billing platform for enterprises](https://docs.github.com/enterprise-cloud@latest//billing/using-the-enhanced-billing-platform-for-enterprises/about-the-enhanced-billing-platform-for-enterprises#how-do-i-know-if-i-can-access-the-enhanced-billing-platform)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-billing-usage-report-for-an-enterprise
        """

        from ..models import (
            BasicError,
            BillingUsageReport,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/enterprises/{enterprise}/settings/billing/usage"

        params = {
            "year": year,
            "month": month,
            "day": day,
            "hour": hour,
            "cost_center_id": cost_center_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BillingUsageReport,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_github_billing_usage_report_org(
        self,
        org: str,
        *,
        year: Missing[int] = UNSET,
        month: Missing[int] = UNSET,
        day: Missing[int] = UNSET,
        hour: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[BillingUsageReport, BillingUsageReportType]:
        """billing/get-github-billing-usage-report-org

        GET /organizations/{org}/settings/billing/usage

        Gets a report of the total usage for an organization. To use this endpoint, you must be an administrator of an organization within an enterprise or an organization account.

        **Note:** This endpoint is only available to organizations with access to the enhanced billing platform. For more information, see "[About the enhanced billing platform](https://docs.github.com/enterprise-cloud@latest//billing/using-the-new-billing-platform)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/enhanced-billing#get-billing-usage-report-for-an-organization
        """

        from ..models import (
            BasicError,
            BillingUsageReport,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/organizations/{org}/settings/billing/usage"

        params = {
            "year": year,
            "month": month,
            "day": day,
            "hour": hour,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BillingUsageReport,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_github_billing_usage_report_org(
        self,
        org: str,
        *,
        year: Missing[int] = UNSET,
        month: Missing[int] = UNSET,
        day: Missing[int] = UNSET,
        hour: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[BillingUsageReport, BillingUsageReportType]:
        """billing/get-github-billing-usage-report-org

        GET /organizations/{org}/settings/billing/usage

        Gets a report of the total usage for an organization. To use this endpoint, you must be an administrator of an organization within an enterprise or an organization account.

        **Note:** This endpoint is only available to organizations with access to the enhanced billing platform. For more information, see "[About the enhanced billing platform](https://docs.github.com/enterprise-cloud@latest//billing/using-the-new-billing-platform)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/enhanced-billing#get-billing-usage-report-for-an-organization
        """

        from ..models import (
            BasicError,
            BillingUsageReport,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/organizations/{org}/settings/billing/usage"

        params = {
            "year": year,
            "month": month,
            "day": day,
            "hour": hour,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BillingUsageReport,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_github_actions_billing_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsBillingUsage, ActionsBillingUsageType]:
        """billing/get-github-actions-billing-org

        GET /orgs/{org}/settings/billing/actions

        Gets the summary of the free and paid GitHub Actions minutes used.

        Paid minutes only apply to workflows in private repositories that use GitHub-hosted runners. Minutes used is listed for each GitHub-hosted runner operating system. Any job re-runs are also included in the usage. The usage returned includes any minute multipliers for macOS and Windows runners, and is rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".

        OAuth app tokens and personal access tokens (classic) need the `repo` or `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-actions-billing-for-an-organization
        """

        from ..models import ActionsBillingUsage

        url = f"/orgs/{org}/settings/billing/actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsBillingUsage,
        )

    async def async_get_github_actions_billing_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsBillingUsage, ActionsBillingUsageType]:
        """billing/get-github-actions-billing-org

        GET /orgs/{org}/settings/billing/actions

        Gets the summary of the free and paid GitHub Actions minutes used.

        Paid minutes only apply to workflows in private repositories that use GitHub-hosted runners. Minutes used is listed for each GitHub-hosted runner operating system. Any job re-runs are also included in the usage. The usage returned includes any minute multipliers for macOS and Windows runners, and is rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".

        OAuth app tokens and personal access tokens (classic) need the `repo` or `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-actions-billing-for-an-organization
        """

        from ..models import ActionsBillingUsage

        url = f"/orgs/{org}/settings/billing/actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsBillingUsage,
        )

    def get_github_advanced_security_billing_org(
        self,
        org: str,
        *,
        advanced_security_product: Missing[
            Literal["code_security", "secret_protection"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        AdvancedSecurityActiveCommitters, AdvancedSecurityActiveCommittersType
    ]:
        """billing/get-github-advanced-security-billing-org

        GET /orgs/{org}/settings/billing/advanced-security

        Gets the GitHub Advanced Security active committers for an organization per repository.

        Each distinct user login across all repositories is counted as a single Advanced Security seat, so the `total_advanced_security_committers` is not the sum of advanced_security_committers for each repository.

        If this organization defers to an enterprise for billing, the `total_advanced_security_committers` returned from the organization API may include some users that are in more than one organization, so they will only consume a single Advanced Security seat at the enterprise level.

        The total number of repositories with committer information is tracked by the `total_count` field.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-advanced-security-active-committers-for-an-organization
        """

        from ..models import AdvancedSecurityActiveCommitters

        url = f"/orgs/{org}/settings/billing/advanced-security"

        params = {
            "advanced_security_product": advanced_security_product,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AdvancedSecurityActiveCommitters,
        )

    async def async_get_github_advanced_security_billing_org(
        self,
        org: str,
        *,
        advanced_security_product: Missing[
            Literal["code_security", "secret_protection"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        AdvancedSecurityActiveCommitters, AdvancedSecurityActiveCommittersType
    ]:
        """billing/get-github-advanced-security-billing-org

        GET /orgs/{org}/settings/billing/advanced-security

        Gets the GitHub Advanced Security active committers for an organization per repository.

        Each distinct user login across all repositories is counted as a single Advanced Security seat, so the `total_advanced_security_committers` is not the sum of advanced_security_committers for each repository.

        If this organization defers to an enterprise for billing, the `total_advanced_security_committers` returned from the organization API may include some users that are in more than one organization, so they will only consume a single Advanced Security seat at the enterprise level.

        The total number of repositories with committer information is tracked by the `total_count` field.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-advanced-security-active-committers-for-an-organization
        """

        from ..models import AdvancedSecurityActiveCommitters

        url = f"/orgs/{org}/settings/billing/advanced-security"

        params = {
            "advanced_security_product": advanced_security_product,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AdvancedSecurityActiveCommitters,
        )

    def get_github_packages_billing_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PackagesBillingUsage, PackagesBillingUsageType]:
        """billing/get-github-packages-billing-org

        GET /orgs/{org}/settings/billing/packages

        Gets the free and paid storage used for GitHub Packages in gigabytes.

        Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."

        OAuth app tokens and personal access tokens (classic) need the `repo` or `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-packages-billing-for-an-organization
        """

        from ..models import PackagesBillingUsage

        url = f"/orgs/{org}/settings/billing/packages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PackagesBillingUsage,
        )

    async def async_get_github_packages_billing_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PackagesBillingUsage, PackagesBillingUsageType]:
        """billing/get-github-packages-billing-org

        GET /orgs/{org}/settings/billing/packages

        Gets the free and paid storage used for GitHub Packages in gigabytes.

        Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."

        OAuth app tokens and personal access tokens (classic) need the `repo` or `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-packages-billing-for-an-organization
        """

        from ..models import PackagesBillingUsage

        url = f"/orgs/{org}/settings/billing/packages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PackagesBillingUsage,
        )

    def get_shared_storage_billing_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CombinedBillingUsage, CombinedBillingUsageType]:
        """billing/get-shared-storage-billing-org

        GET /orgs/{org}/settings/billing/shared-storage

        Gets the estimated paid and estimated total storage used for GitHub Actions and GitHub Packages.

        Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."

        OAuth app tokens and personal access tokens (classic) need the `repo` or `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-shared-storage-billing-for-an-organization
        """

        from ..models import CombinedBillingUsage

        url = f"/orgs/{org}/settings/billing/shared-storage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CombinedBillingUsage,
        )

    async def async_get_shared_storage_billing_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CombinedBillingUsage, CombinedBillingUsageType]:
        """billing/get-shared-storage-billing-org

        GET /orgs/{org}/settings/billing/shared-storage

        Gets the estimated paid and estimated total storage used for GitHub Actions and GitHub Packages.

        Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."

        OAuth app tokens and personal access tokens (classic) need the `repo` or `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-shared-storage-billing-for-an-organization
        """

        from ..models import CombinedBillingUsage

        url = f"/orgs/{org}/settings/billing/shared-storage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CombinedBillingUsage,
        )

    def get_github_actions_billing_user(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsBillingUsage, ActionsBillingUsageType]:
        """billing/get-github-actions-billing-user

        GET /users/{username}/settings/billing/actions

        Gets the summary of the free and paid GitHub Actions minutes used.

        Paid minutes only apply to workflows in private repositories that use GitHub-hosted runners. Minutes used is listed for each GitHub-hosted runner operating system. Any job re-runs are also included in the usage. The usage returned includes any minute multipliers for macOS and Windows runners, and is rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".

        OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-actions-billing-for-a-user
        """

        from ..models import ActionsBillingUsage

        url = f"/users/{username}/settings/billing/actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsBillingUsage,
        )

    async def async_get_github_actions_billing_user(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsBillingUsage, ActionsBillingUsageType]:
        """billing/get-github-actions-billing-user

        GET /users/{username}/settings/billing/actions

        Gets the summary of the free and paid GitHub Actions minutes used.

        Paid minutes only apply to workflows in private repositories that use GitHub-hosted runners. Minutes used is listed for each GitHub-hosted runner operating system. Any job re-runs are also included in the usage. The usage returned includes any minute multipliers for macOS and Windows runners, and is rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".

        OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-actions-billing-for-a-user
        """

        from ..models import ActionsBillingUsage

        url = f"/users/{username}/settings/billing/actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsBillingUsage,
        )

    def get_github_packages_billing_user(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PackagesBillingUsage, PackagesBillingUsageType]:
        """billing/get-github-packages-billing-user

        GET /users/{username}/settings/billing/packages

        Gets the free and paid storage used for GitHub Packages in gigabytes.

        Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."

        OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-packages-billing-for-a-user
        """

        from ..models import PackagesBillingUsage

        url = f"/users/{username}/settings/billing/packages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PackagesBillingUsage,
        )

    async def async_get_github_packages_billing_user(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PackagesBillingUsage, PackagesBillingUsageType]:
        """billing/get-github-packages-billing-user

        GET /users/{username}/settings/billing/packages

        Gets the free and paid storage used for GitHub Packages in gigabytes.

        Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."

        OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-packages-billing-for-a-user
        """

        from ..models import PackagesBillingUsage

        url = f"/users/{username}/settings/billing/packages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PackagesBillingUsage,
        )

    def get_shared_storage_billing_user(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CombinedBillingUsage, CombinedBillingUsageType]:
        """billing/get-shared-storage-billing-user

        GET /users/{username}/settings/billing/shared-storage

        Gets the estimated paid and estimated total storage used for GitHub Actions and GitHub Packages.

        Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."

        OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-shared-storage-billing-for-a-user
        """

        from ..models import CombinedBillingUsage

        url = f"/users/{username}/settings/billing/shared-storage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CombinedBillingUsage,
        )

    async def async_get_shared_storage_billing_user(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CombinedBillingUsage, CombinedBillingUsageType]:
        """billing/get-shared-storage-billing-user

        GET /users/{username}/settings/billing/shared-storage

        Gets the estimated paid and estimated total storage used for GitHub Actions and GitHub Packages.

        Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."

        OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-shared-storage-billing-for-a-user
        """

        from ..models import CombinedBillingUsage

        url = f"/users/{username}/settings/billing/shared-storage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CombinedBillingUsage,
        )

    def get_github_billing_usage_report_user(
        self,
        username: str,
        *,
        year: Missing[int] = UNSET,
        month: Missing[int] = UNSET,
        day: Missing[int] = UNSET,
        hour: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[BillingUsageReportUser, BillingUsageReportUserType]:
        """billing/get-github-billing-usage-report-user

        GET /users/{username}/settings/billing/usage

        Gets a report of the total usage for a user.

        **Note:** This endpoint is only available to users with access to the enhanced billing platform.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/enhanced-billing#get-billing-usage-report-for-a-user
        """

        from ..models import (
            BasicError,
            BillingUsageReportUser,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/users/{username}/settings/billing/usage"

        params = {
            "year": year,
            "month": month,
            "day": day,
            "hour": hour,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BillingUsageReportUser,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_github_billing_usage_report_user(
        self,
        username: str,
        *,
        year: Missing[int] = UNSET,
        month: Missing[int] = UNSET,
        day: Missing[int] = UNSET,
        hour: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[BillingUsageReportUser, BillingUsageReportUserType]:
        """billing/get-github-billing-usage-report-user

        GET /users/{username}/settings/billing/usage

        Gets a report of the total usage for a user.

        **Note:** This endpoint is only available to users with access to the enhanced billing platform.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/enhanced-billing#get-billing-usage-report-for-a-user
        """

        from ..models import (
            BasicError,
            BillingUsageReportUser,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/users/{username}/settings/billing/usage"

        params = {
            "year": year,
            "month": month,
            "day": day,
            "hour": hour,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BillingUsageReportUser,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )
