"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from typing import Literal

from pydantic import Field

from githubkit.compat import ExtraGitHubModel, GitHubModel, model_rebuild
from githubkit.typing import Missing
from githubkit.utils import UNSET


class CopilotOrganizationDetails(ExtraGitHubModel):
    """Copilot Organization Details

    Information about the seat breakdown and policies set for an organization with a
    Copilot Business or Copilot Enterprise subscription.
    """

    seat_breakdown: CopilotOrganizationSeatBreakdown = Field(
        title="Copilot Seat Breakdown",
        description="The breakdown of Copilot Business seats for the organization.",
    )
    public_code_suggestions: Literal["allow", "block", "unconfigured"] = Field(
        description="The organization policy for allowing or blocking suggestions matching public code (duplication detection filter)."
    )
    ide_chat: Missing[Literal["enabled", "disabled", "unconfigured"]] = Field(
        default=UNSET,
        description="The organization policy for allowing or disallowing Copilot Chat in the IDE.",
    )
    platform_chat: Missing[Literal["enabled", "disabled", "unconfigured"]] = Field(
        default=UNSET,
        description="The organization policy for allowing or disallowing Copilot features on GitHub.com.",
    )
    cli: Missing[Literal["enabled", "disabled", "unconfigured"]] = Field(
        default=UNSET,
        description="The organization policy for allowing or disallowing Copilot in the CLI.",
    )
    seat_management_setting: Literal[
        "assign_all", "assign_selected", "disabled", "unconfigured"
    ] = Field(description="The mode of assigning new seats.")
    plan_type: Missing[Literal["business", "enterprise"]] = Field(
        default=UNSET,
        description="The Copilot plan of the organization, or the parent enterprise, when applicable.",
    )


class CopilotOrganizationSeatBreakdown(GitHubModel):
    """Copilot Seat Breakdown

    The breakdown of Copilot Business seats for the organization.
    """

    total: Missing[int] = Field(
        default=UNSET,
        description="The total number of seats being billed for the organization as of the current billing cycle.",
    )
    added_this_cycle: Missing[int] = Field(
        default=UNSET, description="Seats added during the current billing cycle."
    )
    pending_cancellation: Missing[int] = Field(
        default=UNSET,
        description="The number of seats that are pending cancellation at the end of the current billing cycle.",
    )
    pending_invitation: Missing[int] = Field(
        default=UNSET,
        description="The number of users who have been invited to receive a Copilot seat through this organization.",
    )
    active_this_cycle: Missing[int] = Field(
        default=UNSET,
        description="The number of seats that have used Copilot during the current billing cycle.",
    )
    inactive_this_cycle: Missing[int] = Field(
        default=UNSET,
        description="The number of seats that have not used Copilot during the current billing cycle.",
    )


model_rebuild(CopilotOrganizationDetails)
model_rebuild(CopilotOrganizationSeatBreakdown)

__all__ = (
    "CopilotOrganizationDetails",
    "CopilotOrganizationSeatBreakdown",
)
