"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from typing import Literal, Union

from pydantic import Field

from githubkit.compat import GitHubModel, model_rebuild
from githubkit.typing import Missing
from githubkit.utils import UNSET


class SecretScanningPatternConfiguration(GitHubModel):
    """Secret scanning pattern configuration

    A collection of secret scanning patterns and their settings related to push
    protection.
    """

    pattern_config_version: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="The version of the entity. This is used to confirm you're updating the current version of the entity and mitigate unintentionally overriding someone else's update.",
    )
    provider_pattern_overrides: Missing[list[SecretScanningPatternOverride]] = Field(
        default=UNSET, description="Overrides for partner patterns."
    )
    custom_pattern_overrides: Missing[list[SecretScanningPatternOverride]] = Field(
        default=UNSET,
        description="Overrides for custom patterns defined by the organization.",
    )


class SecretScanningPatternOverride(GitHubModel):
    """SecretScanningPatternOverride"""

    token_type: Missing[str] = Field(
        default=UNSET, description="The ID of the pattern."
    )
    custom_pattern_version: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="The version of this pattern if it's a custom pattern.",
    )
    slug: Missing[str] = Field(default=UNSET, description="The slug of the pattern.")
    display_name: Missing[str] = Field(
        default=UNSET, description="The user-friendly name for the pattern."
    )
    alert_total: Missing[int] = Field(
        default=UNSET,
        description="The total number of alerts generated by this pattern.",
    )
    alert_total_percentage: Missing[int] = Field(
        default=UNSET,
        description="The percentage of all alerts that this pattern represents, rounded to the nearest integer.",
    )
    false_positives: Missing[int] = Field(
        default=UNSET,
        description="The number of false positive alerts generated by this pattern.",
    )
    false_positive_rate: Missing[int] = Field(
        default=UNSET,
        description="The percentage of alerts from this pattern that are false positives, rounded to the nearest integer.",
    )
    bypass_rate: Missing[int] = Field(
        default=UNSET,
        description="The percentage of blocks for this pattern that were bypassed, rounded to the nearest integer.",
    )
    default_setting: Missing[Literal["disabled", "enabled"]] = Field(
        default=UNSET,
        description="The default push protection setting for this pattern.",
    )
    enterprise_setting: Missing[
        Union[None, Literal["not-set", "disabled", "enabled"]]
    ] = Field(
        default=UNSET,
        description="The push protection setting for this pattern set at the enterprise level. Only present for partner patterns when the organization has a parent enterprise.",
    )
    setting: Missing[Literal["not-set", "disabled", "enabled"]] = Field(
        default=UNSET,
        description="The current push protection setting for this pattern. If this is `not-set`, then it inherits either the enterprise setting if it exists or the default setting.",
    )


model_rebuild(SecretScanningPatternConfiguration)
model_rebuild(SecretScanningPatternOverride)

__all__ = (
    "SecretScanningPatternConfiguration",
    "SecretScanningPatternOverride",
)
