"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import SimpleUser
    from ..types import (
        EnterprisesEnterpriseTeamsEnterpriseTeamMembershipsAddPostBodyType,
        EnterprisesEnterpriseTeamsEnterpriseTeamMembershipsRemovePostBodyType,
        SimpleUserType,
    )


class EnterpriseTeamMembershipsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """enterprise-team-memberships/list

        GET /enterprises/{enterprise}/teams/{enterprise-team}/memberships

        Lists all team members in an enterprise team.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-team-members#list-members-in-an-enterprise-team
        """

        from ..models import SimpleUser

        url = f"/enterprises/{enterprise}/teams/{enterprise_team}/memberships"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
        )

    async def async_list(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """enterprise-team-memberships/list

        GET /enterprises/{enterprise}/teams/{enterprise-team}/memberships

        Lists all team members in an enterprise team.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-team-members#list-members-in-an-enterprise-team
        """

        from ..models import SimpleUser

        url = f"/enterprises/{enterprise}/teams/{enterprise_team}/memberships"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
        )

    @overload
    def bulk_add(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseTeamsEnterpriseTeamMembershipsAddPostBodyType,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    @overload
    def bulk_add(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        usernames: list[str],
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    def bulk_add(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseTeamsEnterpriseTeamMembershipsAddPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """enterprise-team-memberships/bulk-add

        POST /enterprises/{enterprise}/teams/{enterprise-team}/memberships/add

        Add multiple team members to an enterprise team.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-team-members#bulk-add-team-members
        """

        from ..models import (
            EnterprisesEnterpriseTeamsEnterpriseTeamMembershipsAddPostBody,
            SimpleUser,
        )

        url = f"/enterprises/{enterprise}/teams/{enterprise_team}/memberships/add"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseTeamsEnterpriseTeamMembershipsAddPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
        )

    @overload
    async def async_bulk_add(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseTeamsEnterpriseTeamMembershipsAddPostBodyType,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    @overload
    async def async_bulk_add(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        usernames: list[str],
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    async def async_bulk_add(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseTeamsEnterpriseTeamMembershipsAddPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """enterprise-team-memberships/bulk-add

        POST /enterprises/{enterprise}/teams/{enterprise-team}/memberships/add

        Add multiple team members to an enterprise team.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-team-members#bulk-add-team-members
        """

        from ..models import (
            EnterprisesEnterpriseTeamsEnterpriseTeamMembershipsAddPostBody,
            SimpleUser,
        )

        url = f"/enterprises/{enterprise}/teams/{enterprise_team}/memberships/add"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseTeamsEnterpriseTeamMembershipsAddPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
        )

    @overload
    def bulk_remove(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseTeamsEnterpriseTeamMembershipsRemovePostBodyType,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    @overload
    def bulk_remove(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        usernames: list[str],
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    def bulk_remove(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseTeamsEnterpriseTeamMembershipsRemovePostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """enterprise-team-memberships/bulk-remove

        POST /enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove

        Remove multiple team members from an enterprise team.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-team-members#bulk-remove-team-members
        """

        from ..models import (
            EnterprisesEnterpriseTeamsEnterpriseTeamMembershipsRemovePostBody,
            SimpleUser,
        )

        url = f"/enterprises/{enterprise}/teams/{enterprise_team}/memberships/remove"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseTeamsEnterpriseTeamMembershipsRemovePostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
        )

    @overload
    async def async_bulk_remove(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseTeamsEnterpriseTeamMembershipsRemovePostBodyType,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    @overload
    async def async_bulk_remove(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        usernames: list[str],
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    async def async_bulk_remove(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseTeamsEnterpriseTeamMembershipsRemovePostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """enterprise-team-memberships/bulk-remove

        POST /enterprises/{enterprise}/teams/{enterprise-team}/memberships/remove

        Remove multiple team members from an enterprise team.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-team-members#bulk-remove-team-members
        """

        from ..models import (
            EnterprisesEnterpriseTeamsEnterpriseTeamMembershipsRemovePostBody,
            SimpleUser,
        )

        url = f"/enterprises/{enterprise}/teams/{enterprise_team}/memberships/remove"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseTeamsEnterpriseTeamMembershipsRemovePostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
        )

    def get(
        self,
        enterprise: str,
        enterprise_team: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SimpleUser, SimpleUserType]:
        """enterprise-team-memberships/get

        GET /enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}

        Returns whether the user is a member of the enterprise team.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-team-members#get-enterprise-team-membership
        """

        from ..models import SimpleUser

        url = (
            f"/enterprises/{enterprise}/teams/{enterprise_team}/memberships/{username}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SimpleUser,
        )

    async def async_get(
        self,
        enterprise: str,
        enterprise_team: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SimpleUser, SimpleUserType]:
        """enterprise-team-memberships/get

        GET /enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}

        Returns whether the user is a member of the enterprise team.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-team-members#get-enterprise-team-membership
        """

        from ..models import SimpleUser

        url = (
            f"/enterprises/{enterprise}/teams/{enterprise_team}/memberships/{username}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SimpleUser,
        )

    def add(
        self,
        enterprise: str,
        enterprise_team: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SimpleUser, SimpleUserType]:
        """enterprise-team-memberships/add

        PUT /enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}

        Add a team member to an enterprise team.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-team-members#add-team-member
        """

        from ..models import SimpleUser

        url = (
            f"/enterprises/{enterprise}/teams/{enterprise_team}/memberships/{username}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SimpleUser,
        )

    async def async_add(
        self,
        enterprise: str,
        enterprise_team: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SimpleUser, SimpleUserType]:
        """enterprise-team-memberships/add

        PUT /enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}

        Add a team member to an enterprise team.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-team-members#add-team-member
        """

        from ..models import SimpleUser

        url = (
            f"/enterprises/{enterprise}/teams/{enterprise_team}/memberships/{username}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SimpleUser,
        )

    def remove(
        self,
        enterprise: str,
        enterprise_team: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-team-memberships/remove

        DELETE /enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}

        Remove membership of a specific user from a particular team in an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-team-members#remove-team-membership
        """

        from ..models import BasicError

        url = (
            f"/enterprises/{enterprise}/teams/{enterprise_team}/memberships/{username}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
            },
        )

    async def async_remove(
        self,
        enterprise: str,
        enterprise_team: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-team-memberships/remove

        DELETE /enterprises/{enterprise}/teams/{enterprise-team}/memberships/{username}

        Remove membership of a specific user from a particular team in an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-team-members#remove-team-membership
        """

        from ..models import BasicError

        url = (
            f"/enterprises/{enterprise}/teams/{enterprise_team}/memberships/{username}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
            },
        )
