"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        ActionsArtifactAndLogRetentionResponse,
        ActionsCacheList,
        ActionsCacheUsageByRepository,
        ActionsCacheUsageOrgEnterprise,
        ActionsForkPrContributorApproval,
        ActionsForkPrWorkflowsPrivateRepos,
        ActionsGetDefaultWorkflowPermissions,
        ActionsHostedRunner,
        ActionsHostedRunnerLimits,
        ActionsOrganizationPermissions,
        ActionsPublicKey,
        ActionsRepositoryPermissions,
        ActionsSecret,
        ActionsVariable,
        ActionsWorkflowAccessToRepository,
        Artifact,
        AuthenticationToken,
        Deployment,
        EmptyObject,
        EnterprisesEnterpriseActionsHostedRunnersGetResponse200,
        EnterprisesEnterpriseActionsHostedRunnersImagesGithubOwnedGetResponse200,
        EnterprisesEnterpriseActionsHostedRunnersImagesPartnerGetResponse200,
        EnterprisesEnterpriseActionsHostedRunnersMachineSizesGetResponse200,
        EnterprisesEnterpriseActionsHostedRunnersPlatformsGetResponse200,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnvironmentApprovals,
        Job,
        OidcCustomSubRepo,
        OrganizationActionsSecret,
        OrganizationActionsVariable,
        OrgsOrgActionsCacheUsageByRepositoryGetResponse200,
        OrgsOrgActionsHostedRunnersGetResponse200,
        OrgsOrgActionsHostedRunnersImagesGithubOwnedGetResponse200,
        OrgsOrgActionsHostedRunnersImagesPartnerGetResponse200,
        OrgsOrgActionsHostedRunnersMachineSizesGetResponse200,
        OrgsOrgActionsHostedRunnersPlatformsGetResponse200,
        OrgsOrgActionsPermissionsRepositoriesGetResponse200,
        OrgsOrgActionsPermissionsSelfHostedRunnersRepositoriesGetResponse200,
        OrgsOrgActionsRunnerGroupsGetResponse200,
        OrgsOrgActionsRunnerGroupsRunnerGroupIdHostedRunnersGetResponse200,
        OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200,
        OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        OrgsOrgActionsRunnersGetResponse200,
        OrgsOrgActionsSecretsGetResponse200,
        OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200,
        OrgsOrgActionsVariablesGetResponse200,
        OrgsOrgActionsVariablesNameRepositoriesGetResponse200,
        PendingDeployment,
        ReposOwnerRepoActionsArtifactsGetResponse200,
        ReposOwnerRepoActionsOrganizationSecretsGetResponse200,
        ReposOwnerRepoActionsOrganizationVariablesGetResponse200,
        ReposOwnerRepoActionsRunnersGetResponse200,
        ReposOwnerRepoActionsRunsGetResponse200,
        ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200,
        ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
        ReposOwnerRepoActionsRunsRunIdJobsGetResponse200,
        ReposOwnerRepoActionsSecretsGetResponse200,
        ReposOwnerRepoActionsVariablesGetResponse200,
        ReposOwnerRepoActionsWorkflowsGetResponse200,
        ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameSecretsGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameVariablesGetResponse200,
        Runner,
        RunnerApplication,
        RunnerGroupsOrg,
        SelectedActions,
        SelfHostedRunnersSettings,
        Workflow,
        WorkflowRun,
        WorkflowRunUsage,
        WorkflowUsage,
    )
    from ..types import (
        ActionsArtifactAndLogRetentionResponseType,
        ActionsArtifactAndLogRetentionType,
        ActionsCacheListType,
        ActionsCacheUsageByRepositoryType,
        ActionsCacheUsageOrgEnterpriseType,
        ActionsForkPrContributorApprovalType,
        ActionsForkPrWorkflowsPrivateReposRequestType,
        ActionsForkPrWorkflowsPrivateReposType,
        ActionsGetDefaultWorkflowPermissionsType,
        ActionsHostedRunnerLimitsType,
        ActionsHostedRunnerType,
        ActionsOidcCustomIssuerPolicyForEnterpriseType,
        ActionsOrganizationPermissionsType,
        ActionsPublicKeyType,
        ActionsRepositoryPermissionsType,
        ActionsSecretType,
        ActionsSetDefaultWorkflowPermissionsType,
        ActionsVariableType,
        ActionsWorkflowAccessToRepositoryType,
        ArtifactType,
        AuthenticationTokenType,
        DeploymentType,
        EmptyObjectType,
        EnterprisesEnterpriseActionsHostedRunnersGetResponse200Type,
        EnterprisesEnterpriseActionsHostedRunnersHostedRunnerIdPatchBodyType,
        EnterprisesEnterpriseActionsHostedRunnersImagesGithubOwnedGetResponse200Type,
        EnterprisesEnterpriseActionsHostedRunnersImagesPartnerGetResponse200Type,
        EnterprisesEnterpriseActionsHostedRunnersMachineSizesGetResponse200Type,
        EnterprisesEnterpriseActionsHostedRunnersPlatformsGetResponse200Type,
        EnterprisesEnterpriseActionsHostedRunnersPostBodyPropImageType,
        EnterprisesEnterpriseActionsHostedRunnersPostBodyType,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostBodyType,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201Type,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200Type,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
        EnvironmentApprovalsType,
        JobType,
        OidcCustomSubRepoType,
        OrganizationActionsSecretType,
        OrganizationActionsVariableType,
        OrgsOrgActionsCacheUsageByRepositoryGetResponse200Type,
        OrgsOrgActionsHostedRunnersGetResponse200Type,
        OrgsOrgActionsHostedRunnersHostedRunnerIdPatchBodyType,
        OrgsOrgActionsHostedRunnersImagesGithubOwnedGetResponse200Type,
        OrgsOrgActionsHostedRunnersImagesPartnerGetResponse200Type,
        OrgsOrgActionsHostedRunnersMachineSizesGetResponse200Type,
        OrgsOrgActionsHostedRunnersPlatformsGetResponse200Type,
        OrgsOrgActionsHostedRunnersPostBodyPropImageType,
        OrgsOrgActionsHostedRunnersPostBodyType,
        OrgsOrgActionsPermissionsPutBodyType,
        OrgsOrgActionsPermissionsRepositoriesGetResponse200Type,
        OrgsOrgActionsPermissionsRepositoriesPutBodyType,
        OrgsOrgActionsPermissionsSelfHostedRunnersPutBodyType,
        OrgsOrgActionsPermissionsSelfHostedRunnersRepositoriesGetResponse200Type,
        OrgsOrgActionsPermissionsSelfHostedRunnersRepositoriesPutBodyType,
        OrgsOrgActionsRunnerGroupsGetResponse200Type,
        OrgsOrgActionsRunnerGroupsPostBodyType,
        OrgsOrgActionsRunnerGroupsRunnerGroupIdHostedRunnersGetResponse200Type,
        OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBodyType,
        OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200Type,
        OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBodyType,
        OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200Type,
        OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
        OrgsOrgActionsRunnersGenerateJitconfigPostBodyType,
        OrgsOrgActionsRunnersGetResponse200Type,
        OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType,
        OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType,
        OrgsOrgActionsSecretsGetResponse200Type,
        OrgsOrgActionsSecretsSecretNamePutBodyType,
        OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200Type,
        OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType,
        OrgsOrgActionsVariablesGetResponse200Type,
        OrgsOrgActionsVariablesNamePatchBodyType,
        OrgsOrgActionsVariablesNameRepositoriesGetResponse200Type,
        OrgsOrgActionsVariablesNameRepositoriesPutBodyType,
        OrgsOrgActionsVariablesPostBodyType,
        PendingDeploymentType,
        ReposOwnerRepoActionsArtifactsGetResponse200Type,
        ReposOwnerRepoActionsJobsJobIdRerunPostBodyType,
        ReposOwnerRepoActionsOidcCustomizationSubPutBodyType,
        ReposOwnerRepoActionsOrganizationSecretsGetResponse200Type,
        ReposOwnerRepoActionsOrganizationVariablesGetResponse200Type,
        ReposOwnerRepoActionsPermissionsPutBodyType,
        ReposOwnerRepoActionsRunnersGenerateJitconfigPostBodyType,
        ReposOwnerRepoActionsRunnersGetResponse200Type,
        ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType,
        ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType,
        ReposOwnerRepoActionsRunsGetResponse200Type,
        ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200Type,
        ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200Type,
        ReposOwnerRepoActionsRunsRunIdJobsGetResponse200Type,
        ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType,
        ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType,
        ReposOwnerRepoActionsRunsRunIdRerunPostBodyType,
        ReposOwnerRepoActionsSecretsGetResponse200Type,
        ReposOwnerRepoActionsSecretsSecretNamePutBodyType,
        ReposOwnerRepoActionsVariablesGetResponse200Type,
        ReposOwnerRepoActionsVariablesNamePatchBodyType,
        ReposOwnerRepoActionsVariablesPostBodyType,
        ReposOwnerRepoActionsWorkflowsGetResponse200Type,
        ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputsType,
        ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType,
        ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200Type,
        ReposOwnerRepoEnvironmentsEnvironmentNameSecretsGetResponse200Type,
        ReposOwnerRepoEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType,
        ReposOwnerRepoEnvironmentsEnvironmentNameVariablesGetResponse200Type,
        ReposOwnerRepoEnvironmentsEnvironmentNameVariablesNamePatchBodyType,
        ReposOwnerRepoEnvironmentsEnvironmentNameVariablesPostBodyType,
        ReviewCustomGatesCommentRequiredType,
        ReviewCustomGatesStateRequiredType,
        RunnerApplicationType,
        RunnerGroupsOrgType,
        RunnerType,
        SelectedActionsType,
        SelfHostedRunnersSettingsType,
        WorkflowRunType,
        WorkflowRunUsageType,
        WorkflowType,
        WorkflowUsageType,
    )


class ActionsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def get_actions_cache_usage_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsCacheUsageOrgEnterprise, ActionsCacheUsageOrgEnterpriseType]:
        """actions/get-actions-cache-usage-for-enterprise

        GET /enterprises/{enterprise}/actions/cache/usage

        Gets the total GitHub Actions cache usage for an enterprise.
        The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.

        OAuth tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#get-github-actions-cache-usage-for-an-enterprise
        """

        from ..models import ActionsCacheUsageOrgEnterprise

        url = f"/enterprises/{enterprise}/actions/cache/usage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsCacheUsageOrgEnterprise,
        )

    async def async_get_actions_cache_usage_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsCacheUsageOrgEnterprise, ActionsCacheUsageOrgEnterpriseType]:
        """actions/get-actions-cache-usage-for-enterprise

        GET /enterprises/{enterprise}/actions/cache/usage

        Gets the total GitHub Actions cache usage for an enterprise.
        The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.

        OAuth tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#get-github-actions-cache-usage-for-an-enterprise
        """

        from ..models import ActionsCacheUsageOrgEnterprise

        url = f"/enterprises/{enterprise}/actions/cache/usage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsCacheUsageOrgEnterprise,
        )

    def list_hosted_runners_for_enterprise(
        self,
        enterprise: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsHostedRunnersGetResponse200,
        EnterprisesEnterpriseActionsHostedRunnersGetResponse200Type,
    ]:
        """actions/list-hosted-runners-for-enterprise

        GET /enterprises/{enterprise}/actions/hosted-runners

        Lists all GitHub-hosted runners configured in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#list-github-hosted-runners-for-an-enterprise
        """

        from ..models import EnterprisesEnterpriseActionsHostedRunnersGetResponse200

        url = f"/enterprises/{enterprise}/actions/hosted-runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsHostedRunnersGetResponse200,
        )

    async def async_list_hosted_runners_for_enterprise(
        self,
        enterprise: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsHostedRunnersGetResponse200,
        EnterprisesEnterpriseActionsHostedRunnersGetResponse200Type,
    ]:
        """actions/list-hosted-runners-for-enterprise

        GET /enterprises/{enterprise}/actions/hosted-runners

        Lists all GitHub-hosted runners configured in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#list-github-hosted-runners-for-an-enterprise
        """

        from ..models import EnterprisesEnterpriseActionsHostedRunnersGetResponse200

        url = f"/enterprises/{enterprise}/actions/hosted-runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsHostedRunnersGetResponse200,
        )

    @overload
    def create_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsHostedRunnersPostBodyType,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]: ...

    @overload
    def create_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        image: EnterprisesEnterpriseActionsHostedRunnersPostBodyPropImageType,
        size: str,
        runner_group_id: int,
        maximum_runners: Missing[int] = UNSET,
        enable_static_ip: Missing[bool] = UNSET,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]: ...

    def create_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[EnterprisesEnterpriseActionsHostedRunnersPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]:
        """actions/create-hosted-runner-for-enterprise

        POST /enterprises/{enterprise}/actions/hosted-runners

        Creates a GitHub-hosted runner for an enterprise.
        OAuth tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#create-a-github-hosted-runner-for-an-enterprise
        """

        from ..models import (
            ActionsHostedRunner,
            EnterprisesEnterpriseActionsHostedRunnersPostBody,
        )

        url = f"/enterprises/{enterprise}/actions/hosted-runners"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsHostedRunnersPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsHostedRunner,
        )

    @overload
    async def async_create_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsHostedRunnersPostBodyType,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]: ...

    @overload
    async def async_create_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        image: EnterprisesEnterpriseActionsHostedRunnersPostBodyPropImageType,
        size: str,
        runner_group_id: int,
        maximum_runners: Missing[int] = UNSET,
        enable_static_ip: Missing[bool] = UNSET,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]: ...

    async def async_create_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[EnterprisesEnterpriseActionsHostedRunnersPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]:
        """actions/create-hosted-runner-for-enterprise

        POST /enterprises/{enterprise}/actions/hosted-runners

        Creates a GitHub-hosted runner for an enterprise.
        OAuth tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#create-a-github-hosted-runner-for-an-enterprise
        """

        from ..models import (
            ActionsHostedRunner,
            EnterprisesEnterpriseActionsHostedRunnersPostBody,
        )

        url = f"/enterprises/{enterprise}/actions/hosted-runners"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsHostedRunnersPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsHostedRunner,
        )

    def get_hosted_runners_github_owned_images_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsHostedRunnersImagesGithubOwnedGetResponse200,
        EnterprisesEnterpriseActionsHostedRunnersImagesGithubOwnedGetResponse200Type,
    ]:
        """actions/get-hosted-runners-github-owned-images-for-enterprise

        GET /enterprises/{enterprise}/actions/hosted-runners/images/github-owned

        Get the list of GitHub-owned images available for GitHub-hosted runners for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-github-owned-images-for-github-hosted-runners-in-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsHostedRunnersImagesGithubOwnedGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/hosted-runners/images/github-owned"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsHostedRunnersImagesGithubOwnedGetResponse200,
        )

    async def async_get_hosted_runners_github_owned_images_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsHostedRunnersImagesGithubOwnedGetResponse200,
        EnterprisesEnterpriseActionsHostedRunnersImagesGithubOwnedGetResponse200Type,
    ]:
        """actions/get-hosted-runners-github-owned-images-for-enterprise

        GET /enterprises/{enterprise}/actions/hosted-runners/images/github-owned

        Get the list of GitHub-owned images available for GitHub-hosted runners for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-github-owned-images-for-github-hosted-runners-in-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsHostedRunnersImagesGithubOwnedGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/hosted-runners/images/github-owned"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsHostedRunnersImagesGithubOwnedGetResponse200,
        )

    def get_hosted_runners_partner_images_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsHostedRunnersImagesPartnerGetResponse200,
        EnterprisesEnterpriseActionsHostedRunnersImagesPartnerGetResponse200Type,
    ]:
        """actions/get-hosted-runners-partner-images-for-enterprise

        GET /enterprises/{enterprise}/actions/hosted-runners/images/partner

        Get the list of partner images available for GitHub-hosted runners for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-partner-images-for-github-hosted-runners-in-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsHostedRunnersImagesPartnerGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/hosted-runners/images/partner"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsHostedRunnersImagesPartnerGetResponse200,
        )

    async def async_get_hosted_runners_partner_images_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsHostedRunnersImagesPartnerGetResponse200,
        EnterprisesEnterpriseActionsHostedRunnersImagesPartnerGetResponse200Type,
    ]:
        """actions/get-hosted-runners-partner-images-for-enterprise

        GET /enterprises/{enterprise}/actions/hosted-runners/images/partner

        Get the list of partner images available for GitHub-hosted runners for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-partner-images-for-github-hosted-runners-in-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsHostedRunnersImagesPartnerGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/hosted-runners/images/partner"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsHostedRunnersImagesPartnerGetResponse200,
        )

    def get_hosted_runners_limits_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsHostedRunnerLimits, ActionsHostedRunnerLimitsType]:
        """actions/get-hosted-runners-limits-for-enterprise

        GET /enterprises/{enterprise}/actions/hosted-runners/limits

        Get the GitHub-hosted runners limits for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-limits-on-github-hosted-runners-for-an-enterprise
        """

        from ..models import ActionsHostedRunnerLimits

        url = f"/enterprises/{enterprise}/actions/hosted-runners/limits"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsHostedRunnerLimits,
        )

    async def async_get_hosted_runners_limits_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsHostedRunnerLimits, ActionsHostedRunnerLimitsType]:
        """actions/get-hosted-runners-limits-for-enterprise

        GET /enterprises/{enterprise}/actions/hosted-runners/limits

        Get the GitHub-hosted runners limits for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-limits-on-github-hosted-runners-for-an-enterprise
        """

        from ..models import ActionsHostedRunnerLimits

        url = f"/enterprises/{enterprise}/actions/hosted-runners/limits"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsHostedRunnerLimits,
        )

    def get_hosted_runners_machine_specs_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsHostedRunnersMachineSizesGetResponse200,
        EnterprisesEnterpriseActionsHostedRunnersMachineSizesGetResponse200Type,
    ]:
        """actions/get-hosted-runners-machine-specs-for-enterprise

        GET /enterprises/{enterprise}/actions/hosted-runners/machine-sizes

        Get the list of machine specs available for GitHub-hosted runners for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-github-hosted-runners-machine-specs-for-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsHostedRunnersMachineSizesGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/hosted-runners/machine-sizes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsHostedRunnersMachineSizesGetResponse200,
        )

    async def async_get_hosted_runners_machine_specs_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsHostedRunnersMachineSizesGetResponse200,
        EnterprisesEnterpriseActionsHostedRunnersMachineSizesGetResponse200Type,
    ]:
        """actions/get-hosted-runners-machine-specs-for-enterprise

        GET /enterprises/{enterprise}/actions/hosted-runners/machine-sizes

        Get the list of machine specs available for GitHub-hosted runners for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-github-hosted-runners-machine-specs-for-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsHostedRunnersMachineSizesGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/hosted-runners/machine-sizes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsHostedRunnersMachineSizesGetResponse200,
        )

    def get_hosted_runners_platforms_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsHostedRunnersPlatformsGetResponse200,
        EnterprisesEnterpriseActionsHostedRunnersPlatformsGetResponse200Type,
    ]:
        """actions/get-hosted-runners-platforms-for-enterprise

        GET /enterprises/{enterprise}/actions/hosted-runners/platforms

        Get the list of platforms available for GitHub-hosted runners for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-platforms-for-github-hosted-runners-in-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsHostedRunnersPlatformsGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/hosted-runners/platforms"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsHostedRunnersPlatformsGetResponse200,
        )

    async def async_get_hosted_runners_platforms_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsHostedRunnersPlatformsGetResponse200,
        EnterprisesEnterpriseActionsHostedRunnersPlatformsGetResponse200Type,
    ]:
        """actions/get-hosted-runners-platforms-for-enterprise

        GET /enterprises/{enterprise}/actions/hosted-runners/platforms

        Get the list of platforms available for GitHub-hosted runners for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-platforms-for-github-hosted-runners-in-an-enterprise
        """

        from ..models import (
            EnterprisesEnterpriseActionsHostedRunnersPlatformsGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/hosted-runners/platforms"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsHostedRunnersPlatformsGetResponse200,
        )

    def get_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        hosted_runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]:
        """actions/get-hosted-runner-for-enterprise

        GET /enterprises/{enterprise}/actions/hosted-runners/{hosted_runner_id}

        Gets a GitHub-hosted runner configured in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-a-github-hosted-runner-for-an-enterprise
        """

        from ..models import ActionsHostedRunner

        url = f"/enterprises/{enterprise}/actions/hosted-runners/{hosted_runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsHostedRunner,
        )

    async def async_get_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        hosted_runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]:
        """actions/get-hosted-runner-for-enterprise

        GET /enterprises/{enterprise}/actions/hosted-runners/{hosted_runner_id}

        Gets a GitHub-hosted runner configured in an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-a-github-hosted-runner-for-an-enterprise
        """

        from ..models import ActionsHostedRunner

        url = f"/enterprises/{enterprise}/actions/hosted-runners/{hosted_runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsHostedRunner,
        )

    def delete_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        hosted_runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]:
        """actions/delete-hosted-runner-for-enterprise

        DELETE /enterprises/{enterprise}/actions/hosted-runners/{hosted_runner_id}

        Deletes a GitHub-hosted runner for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#delete-a-github-hosted-runner-for-an-enterprise
        """

        from ..models import ActionsHostedRunner

        url = f"/enterprises/{enterprise}/actions/hosted-runners/{hosted_runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsHostedRunner,
        )

    async def async_delete_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        hosted_runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]:
        """actions/delete-hosted-runner-for-enterprise

        DELETE /enterprises/{enterprise}/actions/hosted-runners/{hosted_runner_id}

        Deletes a GitHub-hosted runner for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#delete-a-github-hosted-runner-for-an-enterprise
        """

        from ..models import ActionsHostedRunner

        url = f"/enterprises/{enterprise}/actions/hosted-runners/{hosted_runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsHostedRunner,
        )

    @overload
    def update_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        hosted_runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsHostedRunnersHostedRunnerIdPatchBodyType,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]: ...

    @overload
    def update_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        hosted_runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        runner_group_id: Missing[int] = UNSET,
        maximum_runners: Missing[int] = UNSET,
        enable_static_ip: Missing[bool] = UNSET,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]: ...

    def update_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        hosted_runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseActionsHostedRunnersHostedRunnerIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]:
        """actions/update-hosted-runner-for-enterprise

        PATCH /enterprises/{enterprise}/actions/hosted-runners/{hosted_runner_id}

        Updates a GitHub-hosted runner for an enterprise.
        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#update-a-github-hosted-runner-for-an-enterprise
        """

        from ..models import (
            ActionsHostedRunner,
            EnterprisesEnterpriseActionsHostedRunnersHostedRunnerIdPatchBody,
        )

        url = f"/enterprises/{enterprise}/actions/hosted-runners/{hosted_runner_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsHostedRunnersHostedRunnerIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsHostedRunner,
        )

    @overload
    async def async_update_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        hosted_runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsHostedRunnersHostedRunnerIdPatchBodyType,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]: ...

    @overload
    async def async_update_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        hosted_runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        runner_group_id: Missing[int] = UNSET,
        maximum_runners: Missing[int] = UNSET,
        enable_static_ip: Missing[bool] = UNSET,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]: ...

    async def async_update_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        hosted_runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseActionsHostedRunnersHostedRunnerIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]:
        """actions/update-hosted-runner-for-enterprise

        PATCH /enterprises/{enterprise}/actions/hosted-runners/{hosted_runner_id}

        Updates a GitHub-hosted runner for an enterprise.
        OAuth app tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#update-a-github-hosted-runner-for-an-enterprise
        """

        from ..models import (
            ActionsHostedRunner,
            EnterprisesEnterpriseActionsHostedRunnersHostedRunnerIdPatchBody,
        )

        url = f"/enterprises/{enterprise}/actions/hosted-runners/{hosted_runner_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsHostedRunnersHostedRunnerIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsHostedRunner,
        )

    @overload
    def set_actions_oidc_custom_issuer_policy_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsOidcCustomIssuerPolicyForEnterpriseType,
    ) -> Response: ...

    @overload
    def set_actions_oidc_custom_issuer_policy_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        include_enterprise_slug: Missing[bool] = UNSET,
    ) -> Response: ...

    def set_actions_oidc_custom_issuer_policy_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsOidcCustomIssuerPolicyForEnterpriseType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-actions-oidc-custom-issuer-policy-for-enterprise

        PUT /enterprises/{enterprise}/actions/oidc/customization/issuer

        Sets the GitHub Actions OpenID Connect (OIDC) custom issuer policy for an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/oidc#set-the-github-actions-oidc-custom-issuer-policy-for-an-enterprise
        """

        from ..models import ActionsOidcCustomIssuerPolicyForEnterprise

        url = f"/enterprises/{enterprise}/actions/oidc/customization/issuer"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ActionsOidcCustomIssuerPolicyForEnterprise, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_set_actions_oidc_custom_issuer_policy_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsOidcCustomIssuerPolicyForEnterpriseType,
    ) -> Response: ...

    @overload
    async def async_set_actions_oidc_custom_issuer_policy_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        include_enterprise_slug: Missing[bool] = UNSET,
    ) -> Response: ...

    async def async_set_actions_oidc_custom_issuer_policy_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsOidcCustomIssuerPolicyForEnterpriseType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-actions-oidc-custom-issuer-policy-for-enterprise

        PUT /enterprises/{enterprise}/actions/oidc/customization/issuer

        Sets the GitHub Actions OpenID Connect (OIDC) custom issuer policy for an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/oidc#set-the-github-actions-oidc-custom-issuer-policy-for-an-enterprise
        """

        from ..models import ActionsOidcCustomIssuerPolicyForEnterprise

        url = f"/enterprises/{enterprise}/actions/oidc/customization/issuer"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ActionsOidcCustomIssuerPolicyForEnterprise, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def get_github_actions_default_workflow_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsGetDefaultWorkflowPermissions, ActionsGetDefaultWorkflowPermissionsType
    ]:
        """actions/get-github-actions-default-workflow-permissions-enterprise

        GET /enterprises/{enterprise}/actions/permissions/workflow

        Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an enterprise,
        as well as whether GitHub Actions can submit approving pull request reviews. For more information, see
        "[Enforcing a policy for workflow permissions in your enterprise](https://docs.github.com/enterprise-cloud@latest//admin/policies/enforcing-policies-for-your-enterprise/enforcing-policies-for-github-actions-in-your-enterprise#enforcing-a-policy-for-workflow-permissions-in-your-enterprise)."

        OAuth tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-default-workflow-permissions-for-an-enterprise
        """

        from ..models import ActionsGetDefaultWorkflowPermissions

        url = f"/enterprises/{enterprise}/actions/permissions/workflow"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    async def async_get_github_actions_default_workflow_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsGetDefaultWorkflowPermissions, ActionsGetDefaultWorkflowPermissionsType
    ]:
        """actions/get-github-actions-default-workflow-permissions-enterprise

        GET /enterprises/{enterprise}/actions/permissions/workflow

        Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an enterprise,
        as well as whether GitHub Actions can submit approving pull request reviews. For more information, see
        "[Enforcing a policy for workflow permissions in your enterprise](https://docs.github.com/enterprise-cloud@latest//admin/policies/enforcing-policies-for-your-enterprise/enforcing-policies-for-github-actions-in-your-enterprise#enforcing-a-policy-for-workflow-permissions-in-your-enterprise)."

        OAuth tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-default-workflow-permissions-for-an-enterprise
        """

        from ..models import ActionsGetDefaultWorkflowPermissions

        url = f"/enterprises/{enterprise}/actions/permissions/workflow"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    @overload
    def set_github_actions_default_workflow_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsSetDefaultWorkflowPermissionsType,
    ) -> Response: ...

    @overload
    def set_github_actions_default_workflow_permissions_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        default_workflow_permissions: Missing[Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Missing[bool] = UNSET,
    ) -> Response: ...

    def set_github_actions_default_workflow_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-github-actions-default-workflow-permissions-enterprise

        PUT /enterprises/{enterprise}/actions/permissions/workflow

        Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an enterprise, and sets
        whether GitHub Actions can submit approving pull request reviews. For more information, see
        "[Enforcing a policy for workflow permissions in your enterprise](https://docs.github.com/enterprise-cloud@latest//admin/policies/enforcing-policies-for-your-enterprise/enforcing-policies-for-github-actions-in-your-enterprise#enforcing-a-policy-for-workflow-permissions-in-your-enterprise)."

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-default-workflow-permissions-for-an-enterprise
        """

        from ..models import ActionsSetDefaultWorkflowPermissions

        url = f"/enterprises/{enterprise}/actions/permissions/workflow"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsSetDefaultWorkflowPermissions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_set_github_actions_default_workflow_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsSetDefaultWorkflowPermissionsType,
    ) -> Response: ...

    @overload
    async def async_set_github_actions_default_workflow_permissions_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        default_workflow_permissions: Missing[Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Missing[bool] = UNSET,
    ) -> Response: ...

    async def async_set_github_actions_default_workflow_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-github-actions-default-workflow-permissions-enterprise

        PUT /enterprises/{enterprise}/actions/permissions/workflow

        Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an enterprise, and sets
        whether GitHub Actions can submit approving pull request reviews. For more information, see
        "[Enforcing a policy for workflow permissions in your enterprise](https://docs.github.com/enterprise-cloud@latest//admin/policies/enforcing-policies-for-your-enterprise/enforcing-policies-for-github-actions-in-your-enterprise#enforcing-a-policy-for-workflow-permissions-in-your-enterprise)."

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-default-workflow-permissions-for-an-enterprise
        """

        from ..models import ActionsSetDefaultWorkflowPermissions

        url = f"/enterprises/{enterprise}/actions/permissions/workflow"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsSetDefaultWorkflowPermissions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    def generate_runner_jitconfig_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201Type,
    ]: ...

    @overload
    def generate_runner_jitconfig_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        runner_group_id: int,
        labels: list[str],
        work_folder: Missing[str] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201Type,
    ]: ...

    def generate_runner_jitconfig_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201Type,
    ]:
        """actions/generate-runner-jitconfig-for-enterprise

        POST /enterprises/{enterprise}/actions/runners/generate-jitconfig

        Generates a configuration that can be passed to the runner application at startup.

        OAuth tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-configuration-for-a-just-in-time-runner-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostBody,
            EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/actions/runners/generate-jitconfig"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
                "409": BasicError,
            },
        )

    @overload
    async def async_generate_runner_jitconfig_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201Type,
    ]: ...

    @overload
    async def async_generate_runner_jitconfig_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        runner_group_id: int,
        labels: list[str],
        work_folder: Missing[str] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201Type,
    ]: ...

    async def async_generate_runner_jitconfig_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201Type,
    ]:
        """actions/generate-runner-jitconfig-for-enterprise

        POST /enterprises/{enterprise}/actions/runners/generate-jitconfig

        Generates a configuration that can be passed to the runner application at startup.

        OAuth tokens and personal access tokens (classic) need the `manage_runners:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-configuration-for-a-just-in-time-runner-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostBody,
            EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/actions/runners/generate-jitconfig"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
                "409": BasicError,
            },
        )

    def get_actions_cache_usage_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsCacheUsageOrgEnterprise, ActionsCacheUsageOrgEnterpriseType]:
        """actions/get-actions-cache-usage-for-org

        GET /orgs/{org}/actions/cache/usage

        Gets the total GitHub Actions cache usage for an organization.
        The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.

        OAuth tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#get-github-actions-cache-usage-for-an-organization
        """

        from ..models import ActionsCacheUsageOrgEnterprise

        url = f"/orgs/{org}/actions/cache/usage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsCacheUsageOrgEnterprise,
        )

    async def async_get_actions_cache_usage_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsCacheUsageOrgEnterprise, ActionsCacheUsageOrgEnterpriseType]:
        """actions/get-actions-cache-usage-for-org

        GET /orgs/{org}/actions/cache/usage

        Gets the total GitHub Actions cache usage for an organization.
        The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.

        OAuth tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#get-github-actions-cache-usage-for-an-organization
        """

        from ..models import ActionsCacheUsageOrgEnterprise

        url = f"/orgs/{org}/actions/cache/usage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsCacheUsageOrgEnterprise,
        )

    def get_actions_cache_usage_by_repo_for_org(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsCacheUsageByRepositoryGetResponse200,
        OrgsOrgActionsCacheUsageByRepositoryGetResponse200Type,
    ]:
        """actions/get-actions-cache-usage-by-repo-for-org

        GET /orgs/{org}/actions/cache/usage-by-repository

        Lists repositories and their GitHub Actions cache usage for an organization.
        The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.

        OAuth tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#list-repositories-with-github-actions-cache-usage-for-an-organization
        """

        from ..models import OrgsOrgActionsCacheUsageByRepositoryGetResponse200

        url = f"/orgs/{org}/actions/cache/usage-by-repository"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsCacheUsageByRepositoryGetResponse200,
        )

    async def async_get_actions_cache_usage_by_repo_for_org(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsCacheUsageByRepositoryGetResponse200,
        OrgsOrgActionsCacheUsageByRepositoryGetResponse200Type,
    ]:
        """actions/get-actions-cache-usage-by-repo-for-org

        GET /orgs/{org}/actions/cache/usage-by-repository

        Lists repositories and their GitHub Actions cache usage for an organization.
        The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.

        OAuth tokens and personal access tokens (classic) need the `read:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#list-repositories-with-github-actions-cache-usage-for-an-organization
        """

        from ..models import OrgsOrgActionsCacheUsageByRepositoryGetResponse200

        url = f"/orgs/{org}/actions/cache/usage-by-repository"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsCacheUsageByRepositoryGetResponse200,
        )

    def list_hosted_runners_for_org(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsHostedRunnersGetResponse200,
        OrgsOrgActionsHostedRunnersGetResponse200Type,
    ]:
        """actions/list-hosted-runners-for-org

        GET /orgs/{org}/actions/hosted-runners

        Lists all GitHub-hosted runners configured in an organization.

        OAuth app tokens and personal access tokens (classic) need the `manage_runner:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#list-github-hosted-runners-for-an-organization
        """

        from ..models import OrgsOrgActionsHostedRunnersGetResponse200

        url = f"/orgs/{org}/actions/hosted-runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsHostedRunnersGetResponse200,
        )

    async def async_list_hosted_runners_for_org(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsHostedRunnersGetResponse200,
        OrgsOrgActionsHostedRunnersGetResponse200Type,
    ]:
        """actions/list-hosted-runners-for-org

        GET /orgs/{org}/actions/hosted-runners

        Lists all GitHub-hosted runners configured in an organization.

        OAuth app tokens and personal access tokens (classic) need the `manage_runner:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#list-github-hosted-runners-for-an-organization
        """

        from ..models import OrgsOrgActionsHostedRunnersGetResponse200

        url = f"/orgs/{org}/actions/hosted-runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsHostedRunnersGetResponse200,
        )

    @overload
    def create_hosted_runner_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsHostedRunnersPostBodyType,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]: ...

    @overload
    def create_hosted_runner_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        image: OrgsOrgActionsHostedRunnersPostBodyPropImageType,
        size: str,
        runner_group_id: int,
        maximum_runners: Missing[int] = UNSET,
        enable_static_ip: Missing[bool] = UNSET,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]: ...

    def create_hosted_runner_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsHostedRunnersPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]:
        """actions/create-hosted-runner-for-org

        POST /orgs/{org}/actions/hosted-runners

        Creates a GitHub-hosted runner for an organization.
        OAuth tokens and personal access tokens (classic) need the `manage_runners:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#create-a-github-hosted-runner-for-an-organization
        """

        from ..models import ActionsHostedRunner, OrgsOrgActionsHostedRunnersPostBody

        url = f"/orgs/{org}/actions/hosted-runners"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsHostedRunnersPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsHostedRunner,
        )

    @overload
    async def async_create_hosted_runner_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsHostedRunnersPostBodyType,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]: ...

    @overload
    async def async_create_hosted_runner_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        image: OrgsOrgActionsHostedRunnersPostBodyPropImageType,
        size: str,
        runner_group_id: int,
        maximum_runners: Missing[int] = UNSET,
        enable_static_ip: Missing[bool] = UNSET,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]: ...

    async def async_create_hosted_runner_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsHostedRunnersPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]:
        """actions/create-hosted-runner-for-org

        POST /orgs/{org}/actions/hosted-runners

        Creates a GitHub-hosted runner for an organization.
        OAuth tokens and personal access tokens (classic) need the `manage_runners:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#create-a-github-hosted-runner-for-an-organization
        """

        from ..models import ActionsHostedRunner, OrgsOrgActionsHostedRunnersPostBody

        url = f"/orgs/{org}/actions/hosted-runners"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsHostedRunnersPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsHostedRunner,
        )

    def get_hosted_runners_github_owned_images_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsHostedRunnersImagesGithubOwnedGetResponse200,
        OrgsOrgActionsHostedRunnersImagesGithubOwnedGetResponse200Type,
    ]:
        """actions/get-hosted-runners-github-owned-images-for-org

        GET /orgs/{org}/actions/hosted-runners/images/github-owned

        Get the list of GitHub-owned images available for GitHub-hosted runners for an organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-github-owned-images-for-github-hosted-runners-in-an-organization
        """

        from ..models import OrgsOrgActionsHostedRunnersImagesGithubOwnedGetResponse200

        url = f"/orgs/{org}/actions/hosted-runners/images/github-owned"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsHostedRunnersImagesGithubOwnedGetResponse200,
        )

    async def async_get_hosted_runners_github_owned_images_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsHostedRunnersImagesGithubOwnedGetResponse200,
        OrgsOrgActionsHostedRunnersImagesGithubOwnedGetResponse200Type,
    ]:
        """actions/get-hosted-runners-github-owned-images-for-org

        GET /orgs/{org}/actions/hosted-runners/images/github-owned

        Get the list of GitHub-owned images available for GitHub-hosted runners for an organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-github-owned-images-for-github-hosted-runners-in-an-organization
        """

        from ..models import OrgsOrgActionsHostedRunnersImagesGithubOwnedGetResponse200

        url = f"/orgs/{org}/actions/hosted-runners/images/github-owned"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsHostedRunnersImagesGithubOwnedGetResponse200,
        )

    def get_hosted_runners_partner_images_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsHostedRunnersImagesPartnerGetResponse200,
        OrgsOrgActionsHostedRunnersImagesPartnerGetResponse200Type,
    ]:
        """actions/get-hosted-runners-partner-images-for-org

        GET /orgs/{org}/actions/hosted-runners/images/partner

        Get the list of partner images available for GitHub-hosted runners for an organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-partner-images-for-github-hosted-runners-in-an-organization
        """

        from ..models import OrgsOrgActionsHostedRunnersImagesPartnerGetResponse200

        url = f"/orgs/{org}/actions/hosted-runners/images/partner"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsHostedRunnersImagesPartnerGetResponse200,
        )

    async def async_get_hosted_runners_partner_images_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsHostedRunnersImagesPartnerGetResponse200,
        OrgsOrgActionsHostedRunnersImagesPartnerGetResponse200Type,
    ]:
        """actions/get-hosted-runners-partner-images-for-org

        GET /orgs/{org}/actions/hosted-runners/images/partner

        Get the list of partner images available for GitHub-hosted runners for an organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-partner-images-for-github-hosted-runners-in-an-organization
        """

        from ..models import OrgsOrgActionsHostedRunnersImagesPartnerGetResponse200

        url = f"/orgs/{org}/actions/hosted-runners/images/partner"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsHostedRunnersImagesPartnerGetResponse200,
        )

    def get_hosted_runners_limits_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsHostedRunnerLimits, ActionsHostedRunnerLimitsType]:
        """actions/get-hosted-runners-limits-for-org

        GET /orgs/{org}/actions/hosted-runners/limits

        Get the GitHub-hosted runners limits for an organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-limits-on-github-hosted-runners-for-an-organization
        """

        from ..models import ActionsHostedRunnerLimits

        url = f"/orgs/{org}/actions/hosted-runners/limits"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsHostedRunnerLimits,
        )

    async def async_get_hosted_runners_limits_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsHostedRunnerLimits, ActionsHostedRunnerLimitsType]:
        """actions/get-hosted-runners-limits-for-org

        GET /orgs/{org}/actions/hosted-runners/limits

        Get the GitHub-hosted runners limits for an organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-limits-on-github-hosted-runners-for-an-organization
        """

        from ..models import ActionsHostedRunnerLimits

        url = f"/orgs/{org}/actions/hosted-runners/limits"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsHostedRunnerLimits,
        )

    def get_hosted_runners_machine_specs_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsHostedRunnersMachineSizesGetResponse200,
        OrgsOrgActionsHostedRunnersMachineSizesGetResponse200Type,
    ]:
        """actions/get-hosted-runners-machine-specs-for-org

        GET /orgs/{org}/actions/hosted-runners/machine-sizes

        Get the list of machine specs available for GitHub-hosted runners for an organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-github-hosted-runners-machine-specs-for-an-organization
        """

        from ..models import OrgsOrgActionsHostedRunnersMachineSizesGetResponse200

        url = f"/orgs/{org}/actions/hosted-runners/machine-sizes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsHostedRunnersMachineSizesGetResponse200,
        )

    async def async_get_hosted_runners_machine_specs_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsHostedRunnersMachineSizesGetResponse200,
        OrgsOrgActionsHostedRunnersMachineSizesGetResponse200Type,
    ]:
        """actions/get-hosted-runners-machine-specs-for-org

        GET /orgs/{org}/actions/hosted-runners/machine-sizes

        Get the list of machine specs available for GitHub-hosted runners for an organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-github-hosted-runners-machine-specs-for-an-organization
        """

        from ..models import OrgsOrgActionsHostedRunnersMachineSizesGetResponse200

        url = f"/orgs/{org}/actions/hosted-runners/machine-sizes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsHostedRunnersMachineSizesGetResponse200,
        )

    def get_hosted_runners_platforms_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsHostedRunnersPlatformsGetResponse200,
        OrgsOrgActionsHostedRunnersPlatformsGetResponse200Type,
    ]:
        """actions/get-hosted-runners-platforms-for-org

        GET /orgs/{org}/actions/hosted-runners/platforms

        Get the list of platforms available for GitHub-hosted runners for an organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-platforms-for-github-hosted-runners-in-an-organization
        """

        from ..models import OrgsOrgActionsHostedRunnersPlatformsGetResponse200

        url = f"/orgs/{org}/actions/hosted-runners/platforms"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsHostedRunnersPlatformsGetResponse200,
        )

    async def async_get_hosted_runners_platforms_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsHostedRunnersPlatformsGetResponse200,
        OrgsOrgActionsHostedRunnersPlatformsGetResponse200Type,
    ]:
        """actions/get-hosted-runners-platforms-for-org

        GET /orgs/{org}/actions/hosted-runners/platforms

        Get the list of platforms available for GitHub-hosted runners for an organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-platforms-for-github-hosted-runners-in-an-organization
        """

        from ..models import OrgsOrgActionsHostedRunnersPlatformsGetResponse200

        url = f"/orgs/{org}/actions/hosted-runners/platforms"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsHostedRunnersPlatformsGetResponse200,
        )

    def get_hosted_runner_for_org(
        self,
        org: str,
        hosted_runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]:
        """actions/get-hosted-runner-for-org

        GET /orgs/{org}/actions/hosted-runners/{hosted_runner_id}

        Gets a GitHub-hosted runner configured in an organization.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-a-github-hosted-runner-for-an-organization
        """

        from ..models import ActionsHostedRunner

        url = f"/orgs/{org}/actions/hosted-runners/{hosted_runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsHostedRunner,
        )

    async def async_get_hosted_runner_for_org(
        self,
        org: str,
        hosted_runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]:
        """actions/get-hosted-runner-for-org

        GET /orgs/{org}/actions/hosted-runners/{hosted_runner_id}

        Gets a GitHub-hosted runner configured in an organization.

        OAuth app tokens and personal access tokens (classic) need the `manage_runners:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#get-a-github-hosted-runner-for-an-organization
        """

        from ..models import ActionsHostedRunner

        url = f"/orgs/{org}/actions/hosted-runners/{hosted_runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsHostedRunner,
        )

    def delete_hosted_runner_for_org(
        self,
        org: str,
        hosted_runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]:
        """actions/delete-hosted-runner-for-org

        DELETE /orgs/{org}/actions/hosted-runners/{hosted_runner_id}

        Deletes a GitHub-hosted runner for an organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#delete-a-github-hosted-runner-for-an-organization
        """

        from ..models import ActionsHostedRunner

        url = f"/orgs/{org}/actions/hosted-runners/{hosted_runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsHostedRunner,
        )

    async def async_delete_hosted_runner_for_org(
        self,
        org: str,
        hosted_runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]:
        """actions/delete-hosted-runner-for-org

        DELETE /orgs/{org}/actions/hosted-runners/{hosted_runner_id}

        Deletes a GitHub-hosted runner for an organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#delete-a-github-hosted-runner-for-an-organization
        """

        from ..models import ActionsHostedRunner

        url = f"/orgs/{org}/actions/hosted-runners/{hosted_runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsHostedRunner,
        )

    @overload
    def update_hosted_runner_for_org(
        self,
        org: str,
        hosted_runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsHostedRunnersHostedRunnerIdPatchBodyType,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]: ...

    @overload
    def update_hosted_runner_for_org(
        self,
        org: str,
        hosted_runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        runner_group_id: Missing[int] = UNSET,
        maximum_runners: Missing[int] = UNSET,
        enable_static_ip: Missing[bool] = UNSET,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]: ...

    def update_hosted_runner_for_org(
        self,
        org: str,
        hosted_runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsHostedRunnersHostedRunnerIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]:
        """actions/update-hosted-runner-for-org

        PATCH /orgs/{org}/actions/hosted-runners/{hosted_runner_id}

        Updates a GitHub-hosted runner for an organization.
        OAuth app tokens and personal access tokens (classic) need the `manage_runners:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#update-a-github-hosted-runner-for-an-organization
        """

        from ..models import (
            ActionsHostedRunner,
            OrgsOrgActionsHostedRunnersHostedRunnerIdPatchBody,
        )

        url = f"/orgs/{org}/actions/hosted-runners/{hosted_runner_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsHostedRunnersHostedRunnerIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsHostedRunner,
        )

    @overload
    async def async_update_hosted_runner_for_org(
        self,
        org: str,
        hosted_runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsHostedRunnersHostedRunnerIdPatchBodyType,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]: ...

    @overload
    async def async_update_hosted_runner_for_org(
        self,
        org: str,
        hosted_runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        runner_group_id: Missing[int] = UNSET,
        maximum_runners: Missing[int] = UNSET,
        enable_static_ip: Missing[bool] = UNSET,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]: ...

    async def async_update_hosted_runner_for_org(
        self,
        org: str,
        hosted_runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsHostedRunnersHostedRunnerIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ActionsHostedRunner, ActionsHostedRunnerType]:
        """actions/update-hosted-runner-for-org

        PATCH /orgs/{org}/actions/hosted-runners/{hosted_runner_id}

        Updates a GitHub-hosted runner for an organization.
        OAuth app tokens and personal access tokens (classic) need the `manage_runners:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/hosted-runners#update-a-github-hosted-runner-for-an-organization
        """

        from ..models import (
            ActionsHostedRunner,
            OrgsOrgActionsHostedRunnersHostedRunnerIdPatchBody,
        )

        url = f"/orgs/{org}/actions/hosted-runners/{hosted_runner_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsHostedRunnersHostedRunnerIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsHostedRunner,
        )

    def get_github_actions_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsOrganizationPermissions, ActionsOrganizationPermissionsType]:
        """actions/get-github-actions-permissions-organization

        GET /orgs/{org}/actions/permissions

        Gets the GitHub Actions permissions policy for repositories and allowed actions and reusable workflows in an organization.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-github-actions-permissions-for-an-organization
        """

        from ..models import ActionsOrganizationPermissions

        url = f"/orgs/{org}/actions/permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsOrganizationPermissions,
        )

    async def async_get_github_actions_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsOrganizationPermissions, ActionsOrganizationPermissionsType]:
        """actions/get-github-actions-permissions-organization

        GET /orgs/{org}/actions/permissions

        Gets the GitHub Actions permissions policy for repositories and allowed actions and reusable workflows in an organization.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-github-actions-permissions-for-an-organization
        """

        from ..models import ActionsOrganizationPermissions

        url = f"/orgs/{org}/actions/permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsOrganizationPermissions,
        )

    @overload
    def set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsPermissionsPutBodyType,
    ) -> Response: ...

    @overload
    def set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        enabled_repositories: Literal["all", "none", "selected"],
        allowed_actions: Missing[Literal["all", "local_only", "selected"]] = UNSET,
        sha_pinning_required: Missing[bool] = UNSET,
    ) -> Response: ...

    def set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-github-actions-permissions-organization

        PUT /orgs/{org}/actions/permissions

        Sets the GitHub Actions permissions policy for repositories and allowed actions in an organization.

        If the organization belongs to an enterprise that has set restrictive permissions at the enterprise level, such as `allowed_actions` to `selected` actions, then you cannot override them for the organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-github-actions-permissions-for-an-organization
        """

        from ..models import OrgsOrgActionsPermissionsPutBody

        url = f"/orgs/{org}/actions/permissions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsPermissionsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsPermissionsPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        enabled_repositories: Literal["all", "none", "selected"],
        allowed_actions: Missing[Literal["all", "local_only", "selected"]] = UNSET,
        sha_pinning_required: Missing[bool] = UNSET,
    ) -> Response: ...

    async def async_set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-github-actions-permissions-organization

        PUT /orgs/{org}/actions/permissions

        Sets the GitHub Actions permissions policy for repositories and allowed actions in an organization.

        If the organization belongs to an enterprise that has set restrictive permissions at the enterprise level, such as `allowed_actions` to `selected` actions, then you cannot override them for the organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-github-actions-permissions-for-an-organization
        """

        from ..models import OrgsOrgActionsPermissionsPutBody

        url = f"/orgs/{org}/actions/permissions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsPermissionsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def get_artifact_and_log_retention_settings_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsArtifactAndLogRetentionResponse,
        ActionsArtifactAndLogRetentionResponseType,
    ]:
        """actions/get-artifact-and-log-retention-settings-organization

        GET /orgs/{org}/actions/permissions/artifact-and-log-retention

        Gets artifact and log retention settings for an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-artifact-and-log-retention-settings-for-an-organization
        """

        from ..models import ActionsArtifactAndLogRetentionResponse, BasicError

        url = f"/orgs/{org}/actions/permissions/artifact-and-log-retention"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsArtifactAndLogRetentionResponse,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_artifact_and_log_retention_settings_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsArtifactAndLogRetentionResponse,
        ActionsArtifactAndLogRetentionResponseType,
    ]:
        """actions/get-artifact-and-log-retention-settings-organization

        GET /orgs/{org}/actions/permissions/artifact-and-log-retention

        Gets artifact and log retention settings for an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-artifact-and-log-retention-settings-for-an-organization
        """

        from ..models import ActionsArtifactAndLogRetentionResponse, BasicError

        url = f"/orgs/{org}/actions/permissions/artifact-and-log-retention"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsArtifactAndLogRetentionResponse,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def set_artifact_and_log_retention_settings_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsArtifactAndLogRetentionType,
    ) -> Response: ...

    @overload
    def set_artifact_and_log_retention_settings_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        days: int,
    ) -> Response: ...

    def set_artifact_and_log_retention_settings_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsArtifactAndLogRetentionType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-artifact-and-log-retention-settings-organization

        PUT /orgs/{org}/actions/permissions/artifact-and-log-retention

        Sets artifact and log retention settings for an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-artifact-and-log-retention-settings-for-an-organization
        """

        from ..models import ActionsArtifactAndLogRetention, BasicError, ValidationError

        url = f"/orgs/{org}/actions/permissions/artifact-and-log-retention"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsArtifactAndLogRetention, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_artifact_and_log_retention_settings_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsArtifactAndLogRetentionType,
    ) -> Response: ...

    @overload
    async def async_set_artifact_and_log_retention_settings_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        days: int,
    ) -> Response: ...

    async def async_set_artifact_and_log_retention_settings_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsArtifactAndLogRetentionType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-artifact-and-log-retention-settings-organization

        PUT /orgs/{org}/actions/permissions/artifact-and-log-retention

        Sets artifact and log retention settings for an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-artifact-and-log-retention-settings-for-an-organization
        """

        from ..models import ActionsArtifactAndLogRetention, BasicError, ValidationError

        url = f"/orgs/{org}/actions/permissions/artifact-and-log-retention"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsArtifactAndLogRetention, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "422": ValidationError,
            },
        )

    def get_fork_pr_contributor_approval_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsForkPrContributorApproval, ActionsForkPrContributorApprovalType
    ]:
        """actions/get-fork-pr-contributor-approval-permissions-organization

        GET /orgs/{org}/actions/permissions/fork-pr-contributor-approval

        Gets the fork PR contributor approval policy for an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-fork-pr-contributor-approval-permissions-for-an-organization
        """

        from ..models import ActionsForkPrContributorApproval, BasicError

        url = f"/orgs/{org}/actions/permissions/fork-pr-contributor-approval"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsForkPrContributorApproval,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_fork_pr_contributor_approval_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsForkPrContributorApproval, ActionsForkPrContributorApprovalType
    ]:
        """actions/get-fork-pr-contributor-approval-permissions-organization

        GET /orgs/{org}/actions/permissions/fork-pr-contributor-approval

        Gets the fork PR contributor approval policy for an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-fork-pr-contributor-approval-permissions-for-an-organization
        """

        from ..models import ActionsForkPrContributorApproval, BasicError

        url = f"/orgs/{org}/actions/permissions/fork-pr-contributor-approval"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsForkPrContributorApproval,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_fork_pr_contributor_approval_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsForkPrContributorApprovalType,
    ) -> Response: ...

    @overload
    def set_fork_pr_contributor_approval_permissions_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        approval_policy: Literal[
            "first_time_contributors_new_to_github",
            "first_time_contributors",
            "all_external_contributors",
        ],
    ) -> Response: ...

    def set_fork_pr_contributor_approval_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsForkPrContributorApprovalType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-fork-pr-contributor-approval-permissions-organization

        PUT /orgs/{org}/actions/permissions/fork-pr-contributor-approval

        Sets the fork PR contributor approval policy for an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-fork-pr-contributor-approval-permissions-for-an-organization
        """

        from ..models import (
            ActionsForkPrContributorApproval,
            BasicError,
            ValidationError,
        )

        url = f"/orgs/{org}/actions/permissions/fork-pr-contributor-approval"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsForkPrContributorApproval, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_fork_pr_contributor_approval_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsForkPrContributorApprovalType,
    ) -> Response: ...

    @overload
    async def async_set_fork_pr_contributor_approval_permissions_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        approval_policy: Literal[
            "first_time_contributors_new_to_github",
            "first_time_contributors",
            "all_external_contributors",
        ],
    ) -> Response: ...

    async def async_set_fork_pr_contributor_approval_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsForkPrContributorApprovalType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-fork-pr-contributor-approval-permissions-organization

        PUT /orgs/{org}/actions/permissions/fork-pr-contributor-approval

        Sets the fork PR contributor approval policy for an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-fork-pr-contributor-approval-permissions-for-an-organization
        """

        from ..models import (
            ActionsForkPrContributorApproval,
            BasicError,
            ValidationError,
        )

        url = f"/orgs/{org}/actions/permissions/fork-pr-contributor-approval"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsForkPrContributorApproval, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_private_repo_fork_pr_workflows_settings_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsForkPrWorkflowsPrivateRepos, ActionsForkPrWorkflowsPrivateReposType
    ]:
        """actions/get-private-repo-fork-pr-workflows-settings-organization

        GET /orgs/{org}/actions/permissions/fork-pr-workflows-private-repos

        Gets the settings for whether workflows from fork pull requests can run on private repositories in an organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-private-repo-fork-pr-workflow-settings-for-an-organization
        """

        from ..models import ActionsForkPrWorkflowsPrivateRepos, BasicError

        url = f"/orgs/{org}/actions/permissions/fork-pr-workflows-private-repos"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsForkPrWorkflowsPrivateRepos,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_private_repo_fork_pr_workflows_settings_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsForkPrWorkflowsPrivateRepos, ActionsForkPrWorkflowsPrivateReposType
    ]:
        """actions/get-private-repo-fork-pr-workflows-settings-organization

        GET /orgs/{org}/actions/permissions/fork-pr-workflows-private-repos

        Gets the settings for whether workflows from fork pull requests can run on private repositories in an organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-private-repo-fork-pr-workflow-settings-for-an-organization
        """

        from ..models import ActionsForkPrWorkflowsPrivateRepos, BasicError

        url = f"/orgs/{org}/actions/permissions/fork-pr-workflows-private-repos"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsForkPrWorkflowsPrivateRepos,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def set_private_repo_fork_pr_workflows_settings_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsForkPrWorkflowsPrivateReposRequestType,
    ) -> Response: ...

    @overload
    def set_private_repo_fork_pr_workflows_settings_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        run_workflows_from_fork_pull_requests: bool,
        send_write_tokens_to_workflows: Missing[bool] = UNSET,
        send_secrets_and_variables: Missing[bool] = UNSET,
        require_approval_for_fork_pr_workflows: Missing[bool] = UNSET,
    ) -> Response: ...

    def set_private_repo_fork_pr_workflows_settings_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsForkPrWorkflowsPrivateReposRequestType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-private-repo-fork-pr-workflows-settings-organization

        PUT /orgs/{org}/actions/permissions/fork-pr-workflows-private-repos

        Sets the settings for whether workflows from fork pull requests can run on private repositories in an organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-private-repo-fork-pr-workflow-settings-for-an-organization
        """

        from ..models import (
            ActionsForkPrWorkflowsPrivateReposRequest,
            BasicError,
            ValidationError,
        )

        url = f"/orgs/{org}/actions/permissions/fork-pr-workflows-private-repos"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsForkPrWorkflowsPrivateReposRequest, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_private_repo_fork_pr_workflows_settings_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsForkPrWorkflowsPrivateReposRequestType,
    ) -> Response: ...

    @overload
    async def async_set_private_repo_fork_pr_workflows_settings_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        run_workflows_from_fork_pull_requests: bool,
        send_write_tokens_to_workflows: Missing[bool] = UNSET,
        send_secrets_and_variables: Missing[bool] = UNSET,
        require_approval_for_fork_pr_workflows: Missing[bool] = UNSET,
    ) -> Response: ...

    async def async_set_private_repo_fork_pr_workflows_settings_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsForkPrWorkflowsPrivateReposRequestType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-private-repo-fork-pr-workflows-settings-organization

        PUT /orgs/{org}/actions/permissions/fork-pr-workflows-private-repos

        Sets the settings for whether workflows from fork pull requests can run on private repositories in an organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-private-repo-fork-pr-workflow-settings-for-an-organization
        """

        from ..models import (
            ActionsForkPrWorkflowsPrivateReposRequest,
            BasicError,
            ValidationError,
        )

        url = f"/orgs/{org}/actions/permissions/fork-pr-workflows-private-repos"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsForkPrWorkflowsPrivateReposRequest, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsPermissionsRepositoriesGetResponse200,
        OrgsOrgActionsPermissionsRepositoriesGetResponse200Type,
    ]:
        """actions/list-selected-repositories-enabled-github-actions-organization

        GET /orgs/{org}/actions/permissions/repositories

        Lists the selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#list-selected-repositories-enabled-for-github-actions-in-an-organization
        """

        from ..models import OrgsOrgActionsPermissionsRepositoriesGetResponse200

        url = f"/orgs/{org}/actions/permissions/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsPermissionsRepositoriesGetResponse200,
        )

    async def async_list_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsPermissionsRepositoriesGetResponse200,
        OrgsOrgActionsPermissionsRepositoriesGetResponse200Type,
    ]:
        """actions/list-selected-repositories-enabled-github-actions-organization

        GET /orgs/{org}/actions/permissions/repositories

        Lists the selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#list-selected-repositories-enabled-for-github-actions-in-an-organization
        """

        from ..models import OrgsOrgActionsPermissionsRepositoriesGetResponse200

        url = f"/orgs/{org}/actions/permissions/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsPermissionsRepositoriesGetResponse200,
        )

    @overload
    def set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsPermissionsRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    def set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_repository_ids: list[int],
    ) -> Response: ...

    def set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsPermissionsRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-selected-repositories-enabled-github-actions-organization

        PUT /orgs/{org}/actions/permissions/repositories

        Replaces the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."


        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-selected-repositories-enabled-for-github-actions-in-an-organization
        """

        from ..models import OrgsOrgActionsPermissionsRepositoriesPutBody

        url = f"/orgs/{org}/actions/permissions/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsPermissionsRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsPermissionsRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_repository_ids: list[int],
    ) -> Response: ...

    async def async_set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsPermissionsRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-selected-repositories-enabled-github-actions-organization

        PUT /orgs/{org}/actions/permissions/repositories

        Replaces the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."


        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-selected-repositories-enabled-for-github-actions-in-an-organization
        """

        from ..models import OrgsOrgActionsPermissionsRepositoriesPutBody

        url = f"/orgs/{org}/actions/permissions/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsPermissionsRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def enable_selected_repository_github_actions_organization(
        self,
        org: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/enable-selected-repository-github-actions-organization

        PUT /orgs/{org}/actions/permissions/repositories/{repository_id}

        Adds a repository to the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#enable-a-selected-repository-for-github-actions-in-an-organization
        """

        url = f"/orgs/{org}/actions/permissions/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_enable_selected_repository_github_actions_organization(
        self,
        org: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/enable-selected-repository-github-actions-organization

        PUT /orgs/{org}/actions/permissions/repositories/{repository_id}

        Adds a repository to the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#enable-a-selected-repository-for-github-actions-in-an-organization
        """

        url = f"/orgs/{org}/actions/permissions/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def disable_selected_repository_github_actions_organization(
        self,
        org: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/disable-selected-repository-github-actions-organization

        DELETE /orgs/{org}/actions/permissions/repositories/{repository_id}

        Removes a repository from the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#disable-a-selected-repository-for-github-actions-in-an-organization
        """

        url = f"/orgs/{org}/actions/permissions/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_disable_selected_repository_github_actions_organization(
        self,
        org: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/disable-selected-repository-github-actions-organization

        DELETE /orgs/{org}/actions/permissions/repositories/{repository_id}

        Removes a repository from the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#disable-a-selected-repository-for-github-actions-in-an-organization
        """

        url = f"/orgs/{org}/actions/permissions/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def get_allowed_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SelectedActions, SelectedActionsType]:
        """actions/get-allowed-actions-organization

        GET /orgs/{org}/actions/permissions/selected-actions

        Gets the selected actions and reusable workflows that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-allowed-actions-and-reusable-workflows-for-an-organization
        """

        from ..models import SelectedActions

        url = f"/orgs/{org}/actions/permissions/selected-actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SelectedActions,
        )

    async def async_get_allowed_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SelectedActions, SelectedActionsType]:
        """actions/get-allowed-actions-organization

        GET /orgs/{org}/actions/permissions/selected-actions

        Gets the selected actions and reusable workflows that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-allowed-actions-and-reusable-workflows-for-an-organization
        """

        from ..models import SelectedActions

        url = f"/orgs/{org}/actions/permissions/selected-actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SelectedActions,
        )

    @overload
    def set_allowed_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[SelectedActionsType] = UNSET,
    ) -> Response: ...

    @overload
    def set_allowed_actions_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        github_owned_allowed: Missing[bool] = UNSET,
        verified_allowed: Missing[bool] = UNSET,
        patterns_allowed: Missing[list[str]] = UNSET,
    ) -> Response: ...

    def set_allowed_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[SelectedActionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-allowed-actions-organization

        PUT /orgs/{org}/actions/permissions/selected-actions

        Sets the actions that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."

        If the organization belongs to an enterprise that has `selected` actions set at the enterprise level, then you cannot override any of the enterprise's allowed actions settings.

        To use the `patterns_allowed` setting for private repositories, the organization must belong to an enterprise. If the organization does not belong to an enterprise, then the `patterns_allowed` setting only applies to public repositories in the organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-allowed-actions-and-reusable-workflows-for-an-organization
        """

        from ..models import SelectedActions

        url = f"/orgs/{org}/actions/permissions/selected-actions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(SelectedActions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_set_allowed_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[SelectedActionsType] = UNSET,
    ) -> Response: ...

    @overload
    async def async_set_allowed_actions_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        github_owned_allowed: Missing[bool] = UNSET,
        verified_allowed: Missing[bool] = UNSET,
        patterns_allowed: Missing[list[str]] = UNSET,
    ) -> Response: ...

    async def async_set_allowed_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[SelectedActionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-allowed-actions-organization

        PUT /orgs/{org}/actions/permissions/selected-actions

        Sets the actions that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."

        If the organization belongs to an enterprise that has `selected` actions set at the enterprise level, then you cannot override any of the enterprise's allowed actions settings.

        To use the `patterns_allowed` setting for private repositories, the organization must belong to an enterprise. If the organization does not belong to an enterprise, then the `patterns_allowed` setting only applies to public repositories in the organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-allowed-actions-and-reusable-workflows-for-an-organization
        """

        from ..models import SelectedActions

        url = f"/orgs/{org}/actions/permissions/selected-actions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(SelectedActions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def get_self_hosted_runners_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SelfHostedRunnersSettings, SelfHostedRunnersSettingsType]:
        """actions/get-self-hosted-runners-permissions-organization

        GET /orgs/{org}/actions/permissions/self-hosted-runners

        Gets the settings for self-hosted runners for an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-self-hosted-runners-settings-for-an-organization
        """

        from ..models import BasicError, SelfHostedRunnersSettings

        url = f"/orgs/{org}/actions/permissions/self-hosted-runners"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SelfHostedRunnersSettings,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_self_hosted_runners_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SelfHostedRunnersSettings, SelfHostedRunnersSettingsType]:
        """actions/get-self-hosted-runners-permissions-organization

        GET /orgs/{org}/actions/permissions/self-hosted-runners

        Gets the settings for self-hosted runners for an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-self-hosted-runners-settings-for-an-organization
        """

        from ..models import BasicError, SelfHostedRunnersSettings

        url = f"/orgs/{org}/actions/permissions/self-hosted-runners"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SelfHostedRunnersSettings,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def set_self_hosted_runners_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsPermissionsSelfHostedRunnersPutBodyType,
    ) -> Response: ...

    @overload
    def set_self_hosted_runners_permissions_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        enabled_repositories: Literal["all", "selected", "none"],
    ) -> Response: ...

    def set_self_hosted_runners_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsPermissionsSelfHostedRunnersPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-self-hosted-runners-permissions-organization

        PUT /orgs/{org}/actions/permissions/self-hosted-runners

        Sets the settings for self-hosted runners for an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-self-hosted-runners-settings-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgActionsPermissionsSelfHostedRunnersPutBody,
            ValidationError,
        )

        url = f"/orgs/{org}/actions/permissions/self-hosted-runners"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsPermissionsSelfHostedRunnersPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_self_hosted_runners_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsPermissionsSelfHostedRunnersPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_self_hosted_runners_permissions_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        enabled_repositories: Literal["all", "selected", "none"],
    ) -> Response: ...

    async def async_set_self_hosted_runners_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsPermissionsSelfHostedRunnersPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-self-hosted-runners-permissions-organization

        PUT /orgs/{org}/actions/permissions/self-hosted-runners

        Sets the settings for self-hosted runners for an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-self-hosted-runners-settings-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgActionsPermissionsSelfHostedRunnersPutBody,
            ValidationError,
        )

        url = f"/orgs/{org}/actions/permissions/self-hosted-runners"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsPermissionsSelfHostedRunnersPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "422": ValidationError,
            },
        )

    def list_selected_repositories_self_hosted_runners_organization(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsPermissionsSelfHostedRunnersRepositoriesGetResponse200,
        OrgsOrgActionsPermissionsSelfHostedRunnersRepositoriesGetResponse200Type,
    ]:
        """actions/list-selected-repositories-self-hosted-runners-organization

        GET /orgs/{org}/actions/permissions/self-hosted-runners/repositories

        Lists repositories that are allowed to use self-hosted runners in an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#list-repositories-allowed-to-use-self-hosted-runners-in-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgActionsPermissionsSelfHostedRunnersRepositoriesGetResponse200,
        )

        url = f"/orgs/{org}/actions/permissions/self-hosted-runners/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsPermissionsSelfHostedRunnersRepositoriesGetResponse200,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_selected_repositories_self_hosted_runners_organization(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsPermissionsSelfHostedRunnersRepositoriesGetResponse200,
        OrgsOrgActionsPermissionsSelfHostedRunnersRepositoriesGetResponse200Type,
    ]:
        """actions/list-selected-repositories-self-hosted-runners-organization

        GET /orgs/{org}/actions/permissions/self-hosted-runners/repositories

        Lists repositories that are allowed to use self-hosted runners in an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#list-repositories-allowed-to-use-self-hosted-runners-in-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgActionsPermissionsSelfHostedRunnersRepositoriesGetResponse200,
        )

        url = f"/orgs/{org}/actions/permissions/self-hosted-runners/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsPermissionsSelfHostedRunnersRepositoriesGetResponse200,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def set_selected_repositories_self_hosted_runners_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsPermissionsSelfHostedRunnersRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    def set_selected_repositories_self_hosted_runners_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_repository_ids: list[int],
    ) -> Response: ...

    def set_selected_repositories_self_hosted_runners_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            OrgsOrgActionsPermissionsSelfHostedRunnersRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-selected-repositories-self-hosted-runners-organization

        PUT /orgs/{org}/actions/permissions/self-hosted-runners/repositories

        Sets repositories that are allowed to use self-hosted runners in an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-repositories-allowed-to-use-self-hosted-runners-in-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgActionsPermissionsSelfHostedRunnersRepositoriesPutBody,
            ValidationError,
        )

        url = f"/orgs/{org}/actions/permissions/self-hosted-runners/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsPermissionsSelfHostedRunnersRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_selected_repositories_self_hosted_runners_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsPermissionsSelfHostedRunnersRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_selected_repositories_self_hosted_runners_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_repository_ids: list[int],
    ) -> Response: ...

    async def async_set_selected_repositories_self_hosted_runners_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            OrgsOrgActionsPermissionsSelfHostedRunnersRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-selected-repositories-self-hosted-runners-organization

        PUT /orgs/{org}/actions/permissions/self-hosted-runners/repositories

        Sets repositories that are allowed to use self-hosted runners in an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-repositories-allowed-to-use-self-hosted-runners-in-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgActionsPermissionsSelfHostedRunnersRepositoriesPutBody,
            ValidationError,
        )

        url = f"/orgs/{org}/actions/permissions/self-hosted-runners/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsPermissionsSelfHostedRunnersRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def enable_selected_repository_self_hosted_runners_organization(
        self,
        org: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/enable-selected-repository-self-hosted-runners-organization

        PUT /orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}

        Adds a repository to the list of repositories that are allowed to use self-hosted runners in an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#add-a-repository-to-the-list-of-repositories-allowed-to-use-self-hosted-runners-in-an-organization
        """

        from ..models import BasicError, ValidationError

        url = f"/orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "422": ValidationError,
            },
        )

    async def async_enable_selected_repository_self_hosted_runners_organization(
        self,
        org: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/enable-selected-repository-self-hosted-runners-organization

        PUT /orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}

        Adds a repository to the list of repositories that are allowed to use self-hosted runners in an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#add-a-repository-to-the-list-of-repositories-allowed-to-use-self-hosted-runners-in-an-organization
        """

        from ..models import BasicError, ValidationError

        url = f"/orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "422": ValidationError,
            },
        )

    def disable_selected_repository_self_hosted_runners_organization(
        self,
        org: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/disable-selected-repository-self-hosted-runners-organization

        DELETE /orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}

        Removes a repository from the list of repositories that are allowed to use self-hosted runners in an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#remove-a-repository-from-the-list-of-repositories-allowed-to-use-self-hosted-runners-in-an-organization
        """

        from ..models import BasicError, ValidationError

        url = f"/orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "422": ValidationError,
            },
        )

    async def async_disable_selected_repository_self_hosted_runners_organization(
        self,
        org: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/disable-selected-repository-self-hosted-runners-organization

        DELETE /orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}

        Removes a repository from the list of repositories that are allowed to use self-hosted runners in an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope or the "Actions policies" fine-grained permission to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#remove-a-repository-from-the-list-of-repositories-allowed-to-use-self-hosted-runners-in-an-organization
        """

        from ..models import BasicError, ValidationError

        url = f"/orgs/{org}/actions/permissions/self-hosted-runners/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "422": ValidationError,
            },
        )

    def get_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsGetDefaultWorkflowPermissions, ActionsGetDefaultWorkflowPermissionsType
    ]:
        """actions/get-github-actions-default-workflow-permissions-organization

        GET /orgs/{org}/actions/permissions/workflow

        Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an organization,
        as well as whether GitHub Actions can submit approving pull request reviews. For more information, see
        "[Setting the permissions of the GITHUB_TOKEN for your organization](https://docs.github.com/enterprise-cloud@latest//organizations/managing-organization-settings/disabling-or-limiting-github-actions-for-your-organization#setting-the-permissions-of-the-github_token-for-your-organization)."

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-default-workflow-permissions-for-an-organization
        """

        from ..models import ActionsGetDefaultWorkflowPermissions

        url = f"/orgs/{org}/actions/permissions/workflow"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    async def async_get_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsGetDefaultWorkflowPermissions, ActionsGetDefaultWorkflowPermissionsType
    ]:
        """actions/get-github-actions-default-workflow-permissions-organization

        GET /orgs/{org}/actions/permissions/workflow

        Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an organization,
        as well as whether GitHub Actions can submit approving pull request reviews. For more information, see
        "[Setting the permissions of the GITHUB_TOKEN for your organization](https://docs.github.com/enterprise-cloud@latest//organizations/managing-organization-settings/disabling-or-limiting-github-actions-for-your-organization#setting-the-permissions-of-the-github_token-for-your-organization)."

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-default-workflow-permissions-for-an-organization
        """

        from ..models import ActionsGetDefaultWorkflowPermissions

        url = f"/orgs/{org}/actions/permissions/workflow"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    @overload
    def set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
    ) -> Response: ...

    @overload
    def set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        default_workflow_permissions: Missing[Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Missing[bool] = UNSET,
    ) -> Response: ...

    def set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-github-actions-default-workflow-permissions-organization

        PUT /orgs/{org}/actions/permissions/workflow

        Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an organization, and sets if GitHub Actions
        can submit approving pull request reviews. For more information, see
        "[Setting the permissions of the GITHUB_TOKEN for your organization](https://docs.github.com/enterprise-cloud@latest//organizations/managing-organization-settings/disabling-or-limiting-github-actions-for-your-organization#setting-the-permissions-of-the-github_token-for-your-organization)."

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-default-workflow-permissions-for-an-organization
        """

        from ..models import ActionsSetDefaultWorkflowPermissions

        url = f"/orgs/{org}/actions/permissions/workflow"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsSetDefaultWorkflowPermissions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    @overload
    async def async_set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
    ) -> Response: ...

    @overload
    async def async_set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        default_workflow_permissions: Missing[Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Missing[bool] = UNSET,
    ) -> Response: ...

    async def async_set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-github-actions-default-workflow-permissions-organization

        PUT /orgs/{org}/actions/permissions/workflow

        Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an organization, and sets if GitHub Actions
        can submit approving pull request reviews. For more information, see
        "[Setting the permissions of the GITHUB_TOKEN for your organization](https://docs.github.com/enterprise-cloud@latest//organizations/managing-organization-settings/disabling-or-limiting-github-actions-for-your-organization#setting-the-permissions-of-the-github_token-for-your-organization)."

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-default-workflow-permissions-for-an-organization
        """

        from ..models import ActionsSetDefaultWorkflowPermissions

        url = f"/orgs/{org}/actions/permissions/workflow"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsSetDefaultWorkflowPermissions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    def list_self_hosted_runner_groups_for_org(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        visible_to_repository: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsRunnerGroupsGetResponse200,
        OrgsOrgActionsRunnerGroupsGetResponse200Type,
    ]:
        """actions/list-self-hosted-runner-groups-for-org

        GET /orgs/{org}/actions/runner-groups

        Lists all self-hosted runner groups configured in an organization and inherited from an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-self-hosted-runner-groups-for-an-organization
        """

        from ..models import OrgsOrgActionsRunnerGroupsGetResponse200

        url = f"/orgs/{org}/actions/runner-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "visible_to_repository": visible_to_repository,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsRunnerGroupsGetResponse200,
        )

    async def async_list_self_hosted_runner_groups_for_org(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        visible_to_repository: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsRunnerGroupsGetResponse200,
        OrgsOrgActionsRunnerGroupsGetResponse200Type,
    ]:
        """actions/list-self-hosted-runner-groups-for-org

        GET /orgs/{org}/actions/runner-groups

        Lists all self-hosted runner groups configured in an organization and inherited from an enterprise.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-self-hosted-runner-groups-for-an-organization
        """

        from ..models import OrgsOrgActionsRunnerGroupsGetResponse200

        url = f"/orgs/{org}/actions/runner-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "visible_to_repository": visible_to_repository,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsRunnerGroupsGetResponse200,
        )

    @overload
    def create_self_hosted_runner_group_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsRunnerGroupsPostBodyType,
    ) -> Response[RunnerGroupsOrg, RunnerGroupsOrgType]: ...

    @overload
    def create_self_hosted_runner_group_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        visibility: Missing[Literal["selected", "all", "private"]] = UNSET,
        selected_repository_ids: Missing[list[int]] = UNSET,
        runners: Missing[list[int]] = UNSET,
        allows_public_repositories: Missing[bool] = UNSET,
        restricted_to_workflows: Missing[bool] = UNSET,
        selected_workflows: Missing[list[str]] = UNSET,
        network_configuration_id: Missing[str] = UNSET,
    ) -> Response[RunnerGroupsOrg, RunnerGroupsOrgType]: ...

    def create_self_hosted_runner_group_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsRunnerGroupsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RunnerGroupsOrg, RunnerGroupsOrgType]:
        """actions/create-self-hosted-runner-group-for-org

        POST /orgs/{org}/actions/runner-groups

        Creates a new self-hosted runner group for an organization.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#create-a-self-hosted-runner-group-for-an-organization
        """

        from ..models import OrgsOrgActionsRunnerGroupsPostBody, RunnerGroupsOrg

        url = f"/orgs/{org}/actions/runner-groups"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsRunnerGroupsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RunnerGroupsOrg,
        )

    @overload
    async def async_create_self_hosted_runner_group_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsRunnerGroupsPostBodyType,
    ) -> Response[RunnerGroupsOrg, RunnerGroupsOrgType]: ...

    @overload
    async def async_create_self_hosted_runner_group_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        visibility: Missing[Literal["selected", "all", "private"]] = UNSET,
        selected_repository_ids: Missing[list[int]] = UNSET,
        runners: Missing[list[int]] = UNSET,
        allows_public_repositories: Missing[bool] = UNSET,
        restricted_to_workflows: Missing[bool] = UNSET,
        selected_workflows: Missing[list[str]] = UNSET,
        network_configuration_id: Missing[str] = UNSET,
    ) -> Response[RunnerGroupsOrg, RunnerGroupsOrgType]: ...

    async def async_create_self_hosted_runner_group_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsRunnerGroupsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RunnerGroupsOrg, RunnerGroupsOrgType]:
        """actions/create-self-hosted-runner-group-for-org

        POST /orgs/{org}/actions/runner-groups

        Creates a new self-hosted runner group for an organization.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#create-a-self-hosted-runner-group-for-an-organization
        """

        from ..models import OrgsOrgActionsRunnerGroupsPostBody, RunnerGroupsOrg

        url = f"/orgs/{org}/actions/runner-groups"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsRunnerGroupsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RunnerGroupsOrg,
        )

    def get_self_hosted_runner_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RunnerGroupsOrg, RunnerGroupsOrgType]:
        """actions/get-self-hosted-runner-group-for-org

        GET /orgs/{org}/actions/runner-groups/{runner_group_id}

        Gets a specific self-hosted runner group for an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#get-a-self-hosted-runner-group-for-an-organization
        """

        from ..models import RunnerGroupsOrg

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RunnerGroupsOrg,
        )

    async def async_get_self_hosted_runner_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RunnerGroupsOrg, RunnerGroupsOrgType]:
        """actions/get-self-hosted-runner-group-for-org

        GET /orgs/{org}/actions/runner-groups/{runner_group_id}

        Gets a specific self-hosted runner group for an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#get-a-self-hosted-runner-group-for-an-organization
        """

        from ..models import RunnerGroupsOrg

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RunnerGroupsOrg,
        )

    def delete_self_hosted_runner_group_from_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-self-hosted-runner-group-from-org

        DELETE /orgs/{org}/actions/runner-groups/{runner_group_id}

        Deletes a self-hosted runner group for an organization.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#delete-a-self-hosted-runner-group-from-an-organization
        """

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_self_hosted_runner_group_from_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-self-hosted-runner-group-from-org

        DELETE /orgs/{org}/actions/runner-groups/{runner_group_id}

        Deletes a self-hosted runner group for an organization.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#delete-a-self-hosted-runner-group-from-an-organization
        """

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    def update_self_hosted_runner_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBodyType,
    ) -> Response[RunnerGroupsOrg, RunnerGroupsOrgType]: ...

    @overload
    def update_self_hosted_runner_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        visibility: Missing[Literal["selected", "all", "private"]] = UNSET,
        allows_public_repositories: Missing[bool] = UNSET,
        restricted_to_workflows: Missing[bool] = UNSET,
        selected_workflows: Missing[list[str]] = UNSET,
        network_configuration_id: Missing[Union[str, None]] = UNSET,
    ) -> Response[RunnerGroupsOrg, RunnerGroupsOrgType]: ...

    def update_self_hosted_runner_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[RunnerGroupsOrg, RunnerGroupsOrgType]:
        """actions/update-self-hosted-runner-group-for-org

        PATCH /orgs/{org}/actions/runner-groups/{runner_group_id}

        Updates the `name` and `visibility` of a self-hosted runner group in an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#update-a-self-hosted-runner-group-for-an-organization
        """

        from ..models import (
            OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBody,
            RunnerGroupsOrg,
        )

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RunnerGroupsOrg,
        )

    @overload
    async def async_update_self_hosted_runner_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBodyType,
    ) -> Response[RunnerGroupsOrg, RunnerGroupsOrgType]: ...

    @overload
    async def async_update_self_hosted_runner_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        visibility: Missing[Literal["selected", "all", "private"]] = UNSET,
        allows_public_repositories: Missing[bool] = UNSET,
        restricted_to_workflows: Missing[bool] = UNSET,
        selected_workflows: Missing[list[str]] = UNSET,
        network_configuration_id: Missing[Union[str, None]] = UNSET,
    ) -> Response[RunnerGroupsOrg, RunnerGroupsOrgType]: ...

    async def async_update_self_hosted_runner_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[RunnerGroupsOrg, RunnerGroupsOrgType]:
        """actions/update-self-hosted-runner-group-for-org

        PATCH /orgs/{org}/actions/runner-groups/{runner_group_id}

        Updates the `name` and `visibility` of a self-hosted runner group in an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#update-a-self-hosted-runner-group-for-an-organization
        """

        from ..models import (
            OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBody,
            RunnerGroupsOrg,
        )

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RunnerGroupsOrg,
        )

    def list_github_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsRunnerGroupsRunnerGroupIdHostedRunnersGetResponse200,
        OrgsOrgActionsRunnerGroupsRunnerGroupIdHostedRunnersGetResponse200Type,
    ]:
        """actions/list-github-hosted-runners-in-group-for-org

        GET /orgs/{org}/actions/runner-groups/{runner_group_id}/hosted-runners

        Lists the GitHub-hosted runners in an organization group.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-github-hosted-runners-in-a-group-for-an-organization
        """

        from ..models import (
            OrgsOrgActionsRunnerGroupsRunnerGroupIdHostedRunnersGetResponse200,
        )

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/hosted-runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsRunnerGroupsRunnerGroupIdHostedRunnersGetResponse200,
        )

    async def async_list_github_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsRunnerGroupsRunnerGroupIdHostedRunnersGetResponse200,
        OrgsOrgActionsRunnerGroupsRunnerGroupIdHostedRunnersGetResponse200Type,
    ]:
        """actions/list-github-hosted-runners-in-group-for-org

        GET /orgs/{org}/actions/runner-groups/{runner_group_id}/hosted-runners

        Lists the GitHub-hosted runners in an organization group.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-github-hosted-runners-in-a-group-for-an-organization
        """

        from ..models import (
            OrgsOrgActionsRunnerGroupsRunnerGroupIdHostedRunnersGetResponse200,
        )

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/hosted-runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsRunnerGroupsRunnerGroupIdHostedRunnersGetResponse200,
        )

    def list_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200,
        OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200Type,
    ]:
        """actions/list-repo-access-to-self-hosted-runner-group-in-org

        GET /orgs/{org}/actions/runner-groups/{runner_group_id}/repositories

        Lists the repositories with access to a self-hosted runner group configured in an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-repository-access-to-a-self-hosted-runner-group-in-an-organization
        """

        from ..models import (
            OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200,
        )

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200,
        )

    async def async_list_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200,
        OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200Type,
    ]:
        """actions/list-repo-access-to-self-hosted-runner-group-in-org

        GET /orgs/{org}/actions/runner-groups/{runner_group_id}/repositories

        Lists the repositories with access to a self-hosted runner group configured in an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-repository-access-to-a-self-hosted-runner-group-in-an-organization
        """

        from ..models import (
            OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200,
        )

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200,
        )

    @overload
    def set_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    def set_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_repository_ids: list[int],
    ) -> Response: ...

    def set_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-repo-access-to-self-hosted-runner-group-in-org

        PUT /orgs/{org}/actions/runner-groups/{runner_group_id}/repositories

        Replaces the list of repositories that have access to a self-hosted runner group configured in an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#set-repository-access-for-a-self-hosted-runner-group-in-an-organization
        """

        from ..models import OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBody

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_set_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_repository_ids: list[int],
    ) -> Response: ...

    async def async_set_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-repo-access-to-self-hosted-runner-group-in-org

        PUT /orgs/{org}/actions/runner-groups/{runner_group_id}/repositories

        Replaces the list of repositories that have access to a self-hosted runner group configured in an organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#set-repository-access-for-a-self-hosted-runner-group-in-an-organization
        """

        from ..models import OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBody

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def add_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/add-repo-access-to-self-hosted-runner-group-in-org

        PUT /orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}

        Adds a repository to the list of repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#add-repository-access-to-a-self-hosted-runner-group-in-an-organization
        """

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_add_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/add-repo-access-to-self-hosted-runner-group-in-org

        PUT /orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}

        Adds a repository to the list of repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#add-repository-access-to-a-self-hosted-runner-group-in-an-organization
        """

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def remove_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/remove-repo-access-to-self-hosted-runner-group-in-org

        DELETE /orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}

        Removes a repository from the list of selected repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#remove-repository-access-to-a-self-hosted-runner-group-in-an-organization
        """

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_remove_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/remove-repo-access-to-self-hosted-runner-group-in-org

        DELETE /orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}

        Removes a repository from the list of selected repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#remove-repository-access-to-a-self-hosted-runner-group-in-an-organization
        """

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_self_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200Type,
    ]:
        """actions/list-self-hosted-runners-in-group-for-org

        GET /orgs/{org}/actions/runner-groups/{runner_group_id}/runners

        Lists self-hosted runners that are in a specific organization group.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-self-hosted-runners-in-a-group-for-an-organization
        """

        from ..models import (
            OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200Type,
    ]:
        """actions/list-self-hosted-runners-in-group-for-org

        GET /orgs/{org}/actions/runner-groups/{runner_group_id}/runners

        Lists self-hosted runners that are in a specific organization group.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-self-hosted-runners-in-a-group-for-an-organization
        """

        from ..models import (
            OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

    @overload
    def set_self_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
    ) -> Response: ...

    @overload
    def set_self_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        runners: list[int],
    ) -> Response: ...

    def set_self_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-self-hosted-runners-in-group-for-org

        PUT /orgs/{org}/actions/runner-groups/{runner_group_id}/runners

        Replaces the list of self-hosted runners that are part of an organization runner group.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#set-self-hosted-runners-in-a-group-for-an-organization
        """

        from ..models import OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBody

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_set_self_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_self_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        runners: list[int],
    ) -> Response: ...

    async def async_set_self_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-self-hosted-runners-in-group-for-org

        PUT /orgs/{org}/actions/runner-groups/{runner_group_id}/runners

        Replaces the list of self-hosted runners that are part of an organization runner group.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#set-self-hosted-runners-in-a-group-for-an-organization
        """

        from ..models import OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBody

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def add_self_hosted_runner_to_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/add-self-hosted-runner-to-group-for-org

        PUT /orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}

        Adds a self-hosted runner to a runner group configured in an organization.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#add-a-self-hosted-runner-to-a-group-for-an-organization
        """

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_add_self_hosted_runner_to_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/add-self-hosted-runner-to-group-for-org

        PUT /orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}

        Adds a self-hosted runner to a runner group configured in an organization.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#add-a-self-hosted-runner-to-a-group-for-an-organization
        """

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def remove_self_hosted_runner_from_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/remove-self-hosted-runner-from-group-for-org

        DELETE /orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}

        Removes a self-hosted runner from a group configured in an organization. The runner is then returned to the default group.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#remove-a-self-hosted-runner-from-a-group-for-an-organization
        """

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_remove_self_hosted_runner_from_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/remove-self-hosted-runner-from-group-for-org

        DELETE /orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}

        Removes a self-hosted runner from a group configured in an organization. The runner is then returned to the default group.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#remove-a-self-hosted-runner-from-a-group-for-an-organization
        """

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_self_hosted_runners_for_org(
        self,
        org: str,
        *,
        name: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsRunnersGetResponse200, OrgsOrgActionsRunnersGetResponse200Type
    ]:
        """actions/list-self-hosted-runners-for-org

        GET /orgs/{org}/actions/runners

        Lists all self-hosted runners configured in an organization.

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-self-hosted-runners-for-an-organization
        """

        from ..models import OrgsOrgActionsRunnersGetResponse200

        url = f"/orgs/{org}/actions/runners"

        params = {
            "name": name,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_for_org(
        self,
        org: str,
        *,
        name: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsRunnersGetResponse200, OrgsOrgActionsRunnersGetResponse200Type
    ]:
        """actions/list-self-hosted-runners-for-org

        GET /orgs/{org}/actions/runners

        Lists all self-hosted runners configured in an organization.

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-self-hosted-runners-for-an-organization
        """

        from ..models import OrgsOrgActionsRunnersGetResponse200

        url = f"/orgs/{org}/actions/runners"

        params = {
            "name": name,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsRunnersGetResponse200,
        )

    def list_runner_applications_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RunnerApplication], list[RunnerApplicationType]]:
        """actions/list-runner-applications-for-org

        GET /orgs/{org}/actions/runners/downloads

        Lists binaries for the runner application that you can download and run.

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.  If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-runner-applications-for-an-organization
        """

        from ..models import RunnerApplication

        url = f"/orgs/{org}/actions/runners/downloads"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RunnerApplication],
        )

    async def async_list_runner_applications_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RunnerApplication], list[RunnerApplicationType]]:
        """actions/list-runner-applications-for-org

        GET /orgs/{org}/actions/runners/downloads

        Lists binaries for the runner application that you can download and run.

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.  If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-runner-applications-for-an-organization
        """

        from ..models import RunnerApplication

        url = f"/orgs/{org}/actions/runners/downloads"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RunnerApplication],
        )

    @overload
    def generate_runner_jitconfig_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsRunnersGenerateJitconfigPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201Type,
    ]: ...

    @overload
    def generate_runner_jitconfig_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        runner_group_id: int,
        labels: list[str],
        work_folder: Missing[str] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201Type,
    ]: ...

    def generate_runner_jitconfig_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsRunnersGenerateJitconfigPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201Type,
    ]:
        """actions/generate-runner-jitconfig-for-org

        POST /orgs/{org}/actions/runners/generate-jitconfig

        Generates a configuration that can be passed to the runner application at startup.

        The authenticated user must have admin access to the organization.

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-configuration-for-a-just-in-time-runner-for-an-organization
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
            OrgsOrgActionsRunnersGenerateJitconfigPostBody,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}/actions/runners/generate-jitconfig"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnersGenerateJitconfigPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
                "409": BasicError,
            },
        )

    @overload
    async def async_generate_runner_jitconfig_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsRunnersGenerateJitconfigPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201Type,
    ]: ...

    @overload
    async def async_generate_runner_jitconfig_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        runner_group_id: int,
        labels: list[str],
        work_folder: Missing[str] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201Type,
    ]: ...

    async def async_generate_runner_jitconfig_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsRunnersGenerateJitconfigPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201Type,
    ]:
        """actions/generate-runner-jitconfig-for-org

        POST /orgs/{org}/actions/runners/generate-jitconfig

        Generates a configuration that can be passed to the runner application at startup.

        The authenticated user must have admin access to the organization.

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-configuration-for-a-just-in-time-runner-for-an-organization
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
            OrgsOrgActionsRunnersGenerateJitconfigPostBody,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}/actions/runners/generate-jitconfig"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnersGenerateJitconfigPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
                "409": BasicError,
            },
        )

    def create_registration_token_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[AuthenticationToken, AuthenticationTokenType]:
        """actions/create-registration-token-for-org

        POST /orgs/{org}/actions/runners/registration-token

        Returns a token that you can pass to the `config` script. The token expires after one hour.

        For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to configure your self-hosted runner:

        ```
        ./config.sh --url https://github.com/octo-org --token TOKEN
        ```

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-registration-token-for-an-organization
        """

        from ..models import AuthenticationToken

        url = f"/orgs/{org}/actions/runners/registration-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AuthenticationToken,
        )

    async def async_create_registration_token_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[AuthenticationToken, AuthenticationTokenType]:
        """actions/create-registration-token-for-org

        POST /orgs/{org}/actions/runners/registration-token

        Returns a token that you can pass to the `config` script. The token expires after one hour.

        For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to configure your self-hosted runner:

        ```
        ./config.sh --url https://github.com/octo-org --token TOKEN
        ```

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-registration-token-for-an-organization
        """

        from ..models import AuthenticationToken

        url = f"/orgs/{org}/actions/runners/registration-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AuthenticationToken,
        )

    def create_remove_token_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[AuthenticationToken, AuthenticationTokenType]:
        """actions/create-remove-token-for-org

        POST /orgs/{org}/actions/runners/remove-token

        Returns a token that you can pass to the `config` script to remove a self-hosted runner from an organization. The token expires after one hour.

        For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to remove your self-hosted runner from an organization:

        ```
        ./config.sh remove --token TOKEN
        ```

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-remove-token-for-an-organization
        """

        from ..models import AuthenticationToken

        url = f"/orgs/{org}/actions/runners/remove-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AuthenticationToken,
        )

    async def async_create_remove_token_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[AuthenticationToken, AuthenticationTokenType]:
        """actions/create-remove-token-for-org

        POST /orgs/{org}/actions/runners/remove-token

        Returns a token that you can pass to the `config` script to remove a self-hosted runner from an organization. The token expires after one hour.

        For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to remove your self-hosted runner from an organization:

        ```
        ./config.sh remove --token TOKEN
        ```

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-remove-token-for-an-organization
        """

        from ..models import AuthenticationToken

        url = f"/orgs/{org}/actions/runners/remove-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AuthenticationToken,
        )

    def get_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Runner, RunnerType]:
        """actions/get-self-hosted-runner-for-org

        GET /orgs/{org}/actions/runners/{runner_id}

        Gets a specific self-hosted runner configured in an organization.

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#get-a-self-hosted-runner-for-an-organization
        """

        from ..models import Runner

        url = f"/orgs/{org}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Runner,
        )

    async def async_get_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Runner, RunnerType]:
        """actions/get-self-hosted-runner-for-org

        GET /orgs/{org}/actions/runners/{runner_id}

        Gets a specific self-hosted runner configured in an organization.

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#get-a-self-hosted-runner-for-an-organization
        """

        from ..models import Runner

        url = f"/orgs/{org}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Runner,
        )

    def delete_self_hosted_runner_from_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-self-hosted-runner-from-org

        DELETE /orgs/{org}/actions/runners/{runner_id}

        Forces the removal of a self-hosted runner from an organization. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#delete-a-self-hosted-runner-from-an-organization
        """

        from ..models import ValidationErrorSimple

        url = f"/orgs/{org}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    async def async_delete_self_hosted_runner_from_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-self-hosted-runner-from-org

        DELETE /orgs/{org}/actions/runners/{runner_id}

        Forces the removal of a self-hosted runner from an organization. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#delete-a-self-hosted-runner-from-an-organization
        """

        from ..models import ValidationErrorSimple

        url = f"/orgs/{org}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    def list_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """actions/list-labels-for-self-hosted-runner-for-org

        GET /orgs/{org}/actions/runners/{runner_id}/labels

        Lists all labels for a self-hosted runner configured in an organization.

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-labels-for-a-self-hosted-runner-for-an-organization
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """actions/list-labels-for-self-hosted-runner-for-org

        GET /orgs/{org}/actions/runners/{runner_id}/labels

        Lists all labels for a self-hosted runner configured in an organization.

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-labels-for-a-self-hosted-runner-for-an-organization
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    @overload
    def set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        labels: list[str],
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    def set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """actions/set-custom-labels-for-self-hosted-runner-for-org

        PUT /orgs/{org}/actions/runners/{runner_id}/labels

        Remove all previous custom labels and set the new custom labels for a specific
        self-hosted runner configured in an organization.

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#set-custom-labels-for-a-self-hosted-runner-for-an-organization
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            OrgsOrgActionsRunnersRunnerIdLabelsPutBody,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnersRunnerIdLabelsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        labels: list[str],
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    async def async_set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """actions/set-custom-labels-for-self-hosted-runner-for-org

        PUT /orgs/{org}/actions/runners/{runner_id}/labels

        Remove all previous custom labels and set the new custom labels for a specific
        self-hosted runner configured in an organization.

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#set-custom-labels-for-a-self-hosted-runner-for-an-organization
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            OrgsOrgActionsRunnersRunnerIdLabelsPutBody,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnersRunnerIdLabelsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    @overload
    def add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        labels: list[str],
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    def add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """actions/add-custom-labels-to-self-hosted-runner-for-org

        POST /orgs/{org}/actions/runners/{runner_id}/labels

        Adds custom labels to a self-hosted runner configured in an organization.

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#add-custom-labels-to-a-self-hosted-runner-for-an-organization
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            OrgsOrgActionsRunnersRunnerIdLabelsPostBody,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnersRunnerIdLabelsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        labels: list[str],
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    async def async_add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """actions/add-custom-labels-to-self-hosted-runner-for-org

        POST /orgs/{org}/actions/runners/{runner_id}/labels

        Adds custom labels to a self-hosted runner configured in an organization.

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#add-custom-labels-to-a-self-hosted-runner-for-an-organization
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            OrgsOrgActionsRunnersRunnerIdLabelsPostBody,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnersRunnerIdLabelsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def remove_all_custom_labels_from_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200Type,
    ]:
        """actions/remove-all-custom-labels-from-self-hosted-runner-for-org

        DELETE /orgs/{org}/actions/runners/{runner_id}/labels

        Remove all custom labels from a self-hosted runner configured in an
        organization. Returns the remaining read-only labels from the runner.

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-all-custom-labels-from-a-self-hosted-runner-for-an-organization
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
        )

        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_remove_all_custom_labels_from_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200Type,
    ]:
        """actions/remove-all-custom-labels-from-self-hosted-runner-for-org

        DELETE /orgs/{org}/actions/runners/{runner_id}/labels

        Remove all custom labels from a self-hosted runner configured in an
        organization. Returns the remaining read-only labels from the runner.

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-all-custom-labels-from-a-self-hosted-runner-for-an-organization
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
        )

        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def remove_custom_label_from_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """actions/remove-custom-label-from-self-hosted-runner-for-org

        DELETE /orgs/{org}/actions/runners/{runner_id}/labels/{name}

        Remove a custom label from a self-hosted runner configured
        in an organization. Returns the remaining labels from the runner.

        This endpoint returns a `404 Not Found` status if the custom label is not
        present on the runner.

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-a-custom-label-from-a-self-hosted-runner-for-an-organization
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}/actions/runners/{runner_id}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_remove_custom_label_from_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """actions/remove-custom-label-from-self-hosted-runner-for-org

        DELETE /orgs/{org}/actions/runners/{runner_id}/labels/{name}

        Remove a custom label from a self-hosted runner configured
        in an organization. Returns the remaining labels from the runner.

        This endpoint returns a `404 Not Found` status if the custom label is not
        present on the runner.

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-a-custom-label-from-a-self-hosted-runner-for-an-organization
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}/actions/runners/{runner_id}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_org_secrets(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsSecretsGetResponse200, OrgsOrgActionsSecretsGetResponse200Type
    ]:
        """actions/list-org-secrets

        GET /orgs/{org}/actions/secrets

        Lists all secrets available in an organization without revealing their
        encrypted values.

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#list-organization-secrets
        """

        from ..models import OrgsOrgActionsSecretsGetResponse200

        url = f"/orgs/{org}/actions/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsSecretsGetResponse200,
        )

    async def async_list_org_secrets(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsSecretsGetResponse200, OrgsOrgActionsSecretsGetResponse200Type
    ]:
        """actions/list-org-secrets

        GET /orgs/{org}/actions/secrets

        Lists all secrets available in an organization without revealing their
        encrypted values.

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#list-organization-secrets
        """

        from ..models import OrgsOrgActionsSecretsGetResponse200

        url = f"/orgs/{org}/actions/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsSecretsGetResponse200,
        )

    def get_org_public_key(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsPublicKey, ActionsPublicKeyType]:
        """actions/get-org-public-key

        GET /orgs/{org}/actions/secrets/public-key

        Gets your public key, which you need to encrypt secrets. You need to
        encrypt a secret before you can create or update secrets.

        The authenticated user must have collaborator access to a repository to create, update, or read secrets.

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-an-organization-public-key
        """

        from ..models import ActionsPublicKey

        url = f"/orgs/{org}/actions/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsPublicKey,
        )

    async def async_get_org_public_key(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsPublicKey, ActionsPublicKeyType]:
        """actions/get-org-public-key

        GET /orgs/{org}/actions/secrets/public-key

        Gets your public key, which you need to encrypt secrets. You need to
        encrypt a secret before you can create or update secrets.

        The authenticated user must have collaborator access to a repository to create, update, or read secrets.

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-an-organization-public-key
        """

        from ..models import ActionsPublicKey

        url = f"/orgs/{org}/actions/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsPublicKey,
        )

    def get_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrganizationActionsSecret, OrganizationActionsSecretType]:
        """actions/get-org-secret

        GET /orgs/{org}/actions/secrets/{secret_name}

        Gets a single organization secret without revealing its encrypted value.

        The authenticated user must have collaborator access to a repository to create, update, or read secrets

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-an-organization-secret
        """

        from ..models import OrganizationActionsSecret

        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrganizationActionsSecret,
        )

    async def async_get_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrganizationActionsSecret, OrganizationActionsSecretType]:
        """actions/get-org-secret

        GET /orgs/{org}/actions/secrets/{secret_name}

        Gets a single organization secret without revealing its encrypted value.

        The authenticated user must have collaborator access to a repository to create, update, or read secrets

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-an-organization-secret
        """

        from ..models import OrganizationActionsSecret

        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrganizationActionsSecret,
        )

    @overload
    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        encrypted_value: str,
        key_id: str,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[list[int]] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/create-or-update-org-secret

        PUT /orgs/{org}/actions/secrets/{secret_name}

        Creates or updates an organization secret with an encrypted value. Encrypt your secret using
        [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/enterprise-cloud@latest//rest/guides/encrypting-secrets-for-the-rest-api)."

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#create-or-update-an-organization-secret
        """

        from ..models import EmptyObject, OrgsOrgActionsSecretsSecretNamePutBody

        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsSecretsSecretNamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    @overload
    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        encrypted_value: str,
        key_id: str,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[list[int]] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/create-or-update-org-secret

        PUT /orgs/{org}/actions/secrets/{secret_name}

        Creates or updates an organization secret with an encrypted value. Encrypt your secret using
        [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/enterprise-cloud@latest//rest/guides/encrypting-secrets-for-the-rest-api)."

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#create-or-update-an-organization-secret
        """

        from ..models import EmptyObject, OrgsOrgActionsSecretsSecretNamePutBody

        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsSecretsSecretNamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    def delete_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-org-secret

        DELETE /orgs/{org}/actions/secrets/{secret_name}

        Deletes a secret in an organization using the secret name.

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#delete-an-organization-secret
        """

        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-org-secret

        DELETE /orgs/{org}/actions/secrets/{secret_name}

        Deletes a secret in an organization using the secret name.

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#delete-an-organization-secret
        """

        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200,
        OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200Type,
    ]:
        """actions/list-selected-repos-for-org-secret

        GET /orgs/{org}/actions/secrets/{secret_name}/repositories

        Lists all repositories that have been selected when the `visibility`
        for repository access to a secret is set to `selected`.

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#list-selected-repositories-for-an-organization-secret
        """

        from ..models import OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200

        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200,
        )

    async def async_list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200,
        OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200Type,
    ]:
        """actions/list-selected-repos-for-org-secret

        GET /orgs/{org}/actions/secrets/{secret_name}/repositories

        Lists all repositories that have been selected when the `visibility`
        for repository access to a secret is set to `selected`.

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#list-selected-repositories-for-an-organization-secret
        """

        from ..models import OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200

        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200,
        )

    @overload
    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_repository_ids: list[int],
    ) -> Response: ...

    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-selected-repos-for-org-secret

        PUT /orgs/{org}/actions/secrets/{secret_name}/repositories

        Replaces all repositories for an organization secret when the `visibility`
        for repository access is set to `selected`. The visibility is set when you [Create
        or update an organization secret](https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#create-or-update-an-organization-secret).

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#set-selected-repositories-for-an-organization-secret
        """

        from ..models import OrgsOrgActionsSecretsSecretNameRepositoriesPutBody

        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsSecretsSecretNameRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_repository_ids: list[int],
    ) -> Response: ...

    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-selected-repos-for-org-secret

        PUT /orgs/{org}/actions/secrets/{secret_name}/repositories

        Replaces all repositories for an organization secret when the `visibility`
        for repository access is set to `selected`. The visibility is set when you [Create
        or update an organization secret](https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#create-or-update-an-organization-secret).

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#set-selected-repositories-for-an-organization-secret
        """

        from ..models import OrgsOrgActionsSecretsSecretNameRepositoriesPutBody

        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsSecretsSecretNameRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/add-selected-repo-to-org-secret

        PUT /orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}

        Adds a repository to an organization secret when the `visibility` for
        repository access is set to `selected`. For more information about setting the visibility, see [Create or
        update an organization secret](https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#create-or-update-an-organization-secret).

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#add-selected-repository-to-an-organization-secret
        """

        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    async def async_add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/add-selected-repo-to-org-secret

        PUT /orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}

        Adds a repository to an organization secret when the `visibility` for
        repository access is set to `selected`. For more information about setting the visibility, see [Create or
        update an organization secret](https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#create-or-update-an-organization-secret).

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#add-selected-repository-to-an-organization-secret
        """

        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    def remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/remove-selected-repo-from-org-secret

        DELETE /orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}

        Removes a repository from an organization secret when the `visibility`
        for repository access is set to `selected`. The visibility is set when you [Create
        or update an organization secret](https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#create-or-update-an-organization-secret).

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#remove-selected-repository-from-an-organization-secret
        """

        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    async def async_remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/remove-selected-repo-from-org-secret

        DELETE /orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}

        Removes a repository from an organization secret when the `visibility`
        for repository access is set to `selected`. The visibility is set when you [Create
        or update an organization secret](https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#create-or-update-an-organization-secret).

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#remove-selected-repository-from-an-organization-secret
        """

        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    def list_org_variables(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsVariablesGetResponse200, OrgsOrgActionsVariablesGetResponse200Type
    ]:
        """actions/list-org-variables

        GET /orgs/{org}/actions/variables

        Lists all organization variables.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#list-organization-variables
        """

        from ..models import OrgsOrgActionsVariablesGetResponse200

        url = f"/orgs/{org}/actions/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsVariablesGetResponse200,
        )

    async def async_list_org_variables(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsVariablesGetResponse200, OrgsOrgActionsVariablesGetResponse200Type
    ]:
        """actions/list-org-variables

        GET /orgs/{org}/actions/variables

        Lists all organization variables.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#list-organization-variables
        """

        from ..models import OrgsOrgActionsVariablesGetResponse200

        url = f"/orgs/{org}/actions/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsVariablesGetResponse200,
        )

    @overload
    def create_org_variable(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsVariablesPostBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    def create_org_variable(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        value: str,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[list[int]] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    def create_org_variable(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsVariablesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/create-org-variable

        POST /orgs/{org}/actions/variables

        Creates an organization variable that you can reference in a GitHub Actions workflow.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#create-an-organization-variable
        """

        from ..models import EmptyObject, OrgsOrgActionsVariablesPostBody

        url = f"/orgs/{org}/actions/variables"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsVariablesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    @overload
    async def async_create_org_variable(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsVariablesPostBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    async def async_create_org_variable(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        value: str,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[list[int]] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    async def async_create_org_variable(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsVariablesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/create-org-variable

        POST /orgs/{org}/actions/variables

        Creates an organization variable that you can reference in a GitHub Actions workflow.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#create-an-organization-variable
        """

        from ..models import EmptyObject, OrgsOrgActionsVariablesPostBody

        url = f"/orgs/{org}/actions/variables"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsVariablesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    def get_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrganizationActionsVariable, OrganizationActionsVariableType]:
        """actions/get-org-variable

        GET /orgs/{org}/actions/variables/{name}

        Gets a specific variable in an organization.

        The authenticated user must have collaborator access to a repository to create, update, or read variables.

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#get-an-organization-variable
        """

        from ..models import OrganizationActionsVariable

        url = f"/orgs/{org}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrganizationActionsVariable,
        )

    async def async_get_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrganizationActionsVariable, OrganizationActionsVariableType]:
        """actions/get-org-variable

        GET /orgs/{org}/actions/variables/{name}

        Gets a specific variable in an organization.

        The authenticated user must have collaborator access to a repository to create, update, or read variables.

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#get-an-organization-variable
        """

        from ..models import OrganizationActionsVariable

        url = f"/orgs/{org}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrganizationActionsVariable,
        )

    def delete_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-org-variable

        DELETE /orgs/{org}/actions/variables/{name}

        Deletes an organization variable using the variable name.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#delete-an-organization-variable
        """

        url = f"/orgs/{org}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-org-variable

        DELETE /orgs/{org}/actions/variables/{name}

        Deletes an organization variable using the variable name.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth tokens and personal access tokens (classic) need the`admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#delete-an-organization-variable
        """

        url = f"/orgs/{org}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    def update_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsVariablesNamePatchBodyType,
    ) -> Response: ...

    @overload
    def update_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        value: Missing[str] = UNSET,
        visibility: Missing[Literal["all", "private", "selected"]] = UNSET,
        selected_repository_ids: Missing[list[int]] = UNSET,
    ) -> Response: ...

    def update_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsVariablesNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/update-org-variable

        PATCH /orgs/{org}/actions/variables/{name}

        Updates an organization variable that you can reference in a GitHub Actions workflow.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#update-an-organization-variable
        """

        from ..models import OrgsOrgActionsVariablesNamePatchBody

        url = f"/orgs/{org}/actions/variables/{name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsVariablesNamePatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_update_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsVariablesNamePatchBodyType,
    ) -> Response: ...

    @overload
    async def async_update_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        value: Missing[str] = UNSET,
        visibility: Missing[Literal["all", "private", "selected"]] = UNSET,
        selected_repository_ids: Missing[list[int]] = UNSET,
    ) -> Response: ...

    async def async_update_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsVariablesNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/update-org-variable

        PATCH /orgs/{org}/actions/variables/{name}

        Updates an organization variable that you can reference in a GitHub Actions workflow.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#update-an-organization-variable
        """

        from ..models import OrgsOrgActionsVariablesNamePatchBody

        url = f"/orgs/{org}/actions/variables/{name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsVariablesNamePatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsVariablesNameRepositoriesGetResponse200,
        OrgsOrgActionsVariablesNameRepositoriesGetResponse200Type,
    ]:
        """actions/list-selected-repos-for-org-variable

        GET /orgs/{org}/actions/variables/{name}/repositories

        Lists all repositories that can access an organization variable
        that is available to selected repositories.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#list-selected-repositories-for-an-organization-variable
        """

        from ..models import OrgsOrgActionsVariablesNameRepositoriesGetResponse200

        url = f"/orgs/{org}/actions/variables/{name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsVariablesNameRepositoriesGetResponse200,
            error_models={},
        )

    async def async_list_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgActionsVariablesNameRepositoriesGetResponse200,
        OrgsOrgActionsVariablesNameRepositoriesGetResponse200Type,
    ]:
        """actions/list-selected-repos-for-org-variable

        GET /orgs/{org}/actions/variables/{name}/repositories

        Lists all repositories that can access an organization variable
        that is available to selected repositories.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#list-selected-repositories-for-an-organization-variable
        """

        from ..models import OrgsOrgActionsVariablesNameRepositoriesGetResponse200

        url = f"/orgs/{org}/actions/variables/{name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgActionsVariablesNameRepositoriesGetResponse200,
            error_models={},
        )

    @overload
    def set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsVariablesNameRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    def set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_repository_ids: list[int],
    ) -> Response: ...

    def set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsVariablesNameRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-selected-repos-for-org-variable

        PUT /orgs/{org}/actions/variables/{name}/repositories

        Replaces all repositories for an organization variable that is available
        to selected repositories. Organization variables that are available to selected
        repositories have their `visibility` field set to `selected`.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#set-selected-repositories-for-an-organization-variable
        """

        from ..models import OrgsOrgActionsVariablesNameRepositoriesPutBody

        url = f"/orgs/{org}/actions/variables/{name}/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsVariablesNameRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    @overload
    async def async_set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgActionsVariablesNameRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_repository_ids: list[int],
    ) -> Response: ...

    async def async_set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgActionsVariablesNameRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-selected-repos-for-org-variable

        PUT /orgs/{org}/actions/variables/{name}/repositories

        Replaces all repositories for an organization variable that is available
        to selected repositories. Organization variables that are available to selected
        repositories have their `visibility` field set to `selected`.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#set-selected-repositories-for-an-organization-variable
        """

        from ..models import OrgsOrgActionsVariablesNameRepositoriesPutBody

        url = f"/orgs/{org}/actions/variables/{name}/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsVariablesNameRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    def add_selected_repo_to_org_variable(
        self,
        org: str,
        name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/add-selected-repo-to-org-variable

        PUT /orgs/{org}/actions/variables/{name}/repositories/{repository_id}

        Adds a repository to an organization variable that is available to selected repositories.
        Organization variables that are available to selected repositories have their `visibility` field set to `selected`.

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#add-selected-repository-to-an-organization-variable
        """

        url = f"/orgs/{org}/actions/variables/{name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    async def async_add_selected_repo_to_org_variable(
        self,
        org: str,
        name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/add-selected-repo-to-org-variable

        PUT /orgs/{org}/actions/variables/{name}/repositories/{repository_id}

        Adds a repository to an organization variable that is available to selected repositories.
        Organization variables that are available to selected repositories have their `visibility` field set to `selected`.

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#add-selected-repository-to-an-organization-variable
        """

        url = f"/orgs/{org}/actions/variables/{name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    def remove_selected_repo_from_org_variable(
        self,
        org: str,
        name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/remove-selected-repo-from-org-variable

        DELETE /orgs/{org}/actions/variables/{name}/repositories/{repository_id}

        Removes a repository from an organization variable that is
        available to selected repositories. Organization variables that are available to
        selected repositories have their `visibility` field set to `selected`.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#remove-selected-repository-from-an-organization-variable
        """

        url = f"/orgs/{org}/actions/variables/{name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    async def async_remove_selected_repo_from_org_variable(
        self,
        org: str,
        name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/remove-selected-repo-from-org-variable

        DELETE /orgs/{org}/actions/variables/{name}/repositories/{repository_id}

        Removes a repository from an organization variable that is
        available to selected repositories. Organization variables that are available to
        selected repositories have their `visibility` field set to `selected`.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint. If the repository is private, the `repo` scope is also required.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#remove-selected-repository-from-an-organization-variable
        """

        url = f"/orgs/{org}/actions/variables/{name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    def list_artifacts_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        name: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsArtifactsGetResponse200,
        ReposOwnerRepoActionsArtifactsGetResponse200Type,
    ]:
        """actions/list-artifacts-for-repo

        GET /repos/{owner}/{repo}/actions/artifacts

        Lists all artifacts for a repository.

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/artifacts#list-artifacts-for-a-repository
        """

        from ..models import ReposOwnerRepoActionsArtifactsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/artifacts"

        params = {
            "per_page": per_page,
            "page": page,
            "name": name,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsArtifactsGetResponse200,
        )

    async def async_list_artifacts_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        name: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsArtifactsGetResponse200,
        ReposOwnerRepoActionsArtifactsGetResponse200Type,
    ]:
        """actions/list-artifacts-for-repo

        GET /repos/{owner}/{repo}/actions/artifacts

        Lists all artifacts for a repository.

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/artifacts#list-artifacts-for-a-repository
        """

        from ..models import ReposOwnerRepoActionsArtifactsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/artifacts"

        params = {
            "per_page": per_page,
            "page": page,
            "name": name,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsArtifactsGetResponse200,
        )

    def get_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Artifact, ArtifactType]:
        """actions/get-artifact

        GET /repos/{owner}/{repo}/actions/artifacts/{artifact_id}

        Gets a specific artifact for a workflow run.

        Anyone with read access to the repository can use this endpoint.

        If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/artifacts#get-an-artifact
        """

        from ..models import Artifact

        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Artifact,
        )

    async def async_get_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Artifact, ArtifactType]:
        """actions/get-artifact

        GET /repos/{owner}/{repo}/actions/artifacts/{artifact_id}

        Gets a specific artifact for a workflow run.

        Anyone with read access to the repository can use this endpoint.

        If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/artifacts#get-an-artifact
        """

        from ..models import Artifact

        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Artifact,
        )

    def delete_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-artifact

        DELETE /repos/{owner}/{repo}/actions/artifacts/{artifact_id}

        Deletes an artifact for a workflow run.
        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/artifacts#delete-an-artifact
        """

        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-artifact

        DELETE /repos/{owner}/{repo}/actions/artifacts/{artifact_id}

        Deletes an artifact for a workflow run.
        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/artifacts#delete-an-artifact
        """

        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def download_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        archive_format: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/download-artifact

        GET /repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}

        Gets a redirect URL to download an archive for a repository. This URL expires after 1 minute. Look for `Location:` in
        the response header to find the URL for the download. The `:archive_format` must be `zip`.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/artifacts#download-an-artifact
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "410": BasicError,
            },
        )

    async def async_download_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        archive_format: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/download-artifact

        GET /repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}

        Gets a redirect URL to download an archive for a repository. This URL expires after 1 minute. Look for `Location:` in
        the response header to find the URL for the download. The `:archive_format` must be `zip`.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/artifacts#download-an-artifact
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "410": BasicError,
            },
        )

    def get_actions_cache_usage(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsCacheUsageByRepository, ActionsCacheUsageByRepositoryType]:
        """actions/get-actions-cache-usage

        GET /repos/{owner}/{repo}/actions/cache/usage

        Gets GitHub Actions cache usage for a repository.
        The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.

        Anyone with read access to the repository can use this endpoint.

        If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#get-github-actions-cache-usage-for-a-repository
        """

        from ..models import ActionsCacheUsageByRepository

        url = f"/repos/{owner}/{repo}/actions/cache/usage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsCacheUsageByRepository,
        )

    async def async_get_actions_cache_usage(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsCacheUsageByRepository, ActionsCacheUsageByRepositoryType]:
        """actions/get-actions-cache-usage

        GET /repos/{owner}/{repo}/actions/cache/usage

        Gets GitHub Actions cache usage for a repository.
        The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.

        Anyone with read access to the repository can use this endpoint.

        If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#get-github-actions-cache-usage-for-a-repository
        """

        from ..models import ActionsCacheUsageByRepository

        url = f"/repos/{owner}/{repo}/actions/cache/usage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsCacheUsageByRepository,
        )

    def get_actions_cache_list(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        ref: Missing[str] = UNSET,
        key: Missing[str] = UNSET,
        sort: Missing[
            Literal["created_at", "last_accessed_at", "size_in_bytes"]
        ] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsCacheList, ActionsCacheListType]:
        """actions/get-actions-cache-list

        GET /repos/{owner}/{repo}/actions/caches

        Lists the GitHub Actions caches for a repository.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#list-github-actions-caches-for-a-repository
        """

        from ..models import ActionsCacheList

        url = f"/repos/{owner}/{repo}/actions/caches"

        params = {
            "per_page": per_page,
            "page": page,
            "ref": ref,
            "key": key,
            "sort": sort,
            "direction": direction,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsCacheList,
        )

    async def async_get_actions_cache_list(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        ref: Missing[str] = UNSET,
        key: Missing[str] = UNSET,
        sort: Missing[
            Literal["created_at", "last_accessed_at", "size_in_bytes"]
        ] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsCacheList, ActionsCacheListType]:
        """actions/get-actions-cache-list

        GET /repos/{owner}/{repo}/actions/caches

        Lists the GitHub Actions caches for a repository.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#list-github-actions-caches-for-a-repository
        """

        from ..models import ActionsCacheList

        url = f"/repos/{owner}/{repo}/actions/caches"

        params = {
            "per_page": per_page,
            "page": page,
            "ref": ref,
            "key": key,
            "sort": sort,
            "direction": direction,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsCacheList,
        )

    def delete_actions_cache_by_key(
        self,
        owner: str,
        repo: str,
        *,
        key: str,
        ref: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsCacheList, ActionsCacheListType]:
        """actions/delete-actions-cache-by-key

        DELETE /repos/{owner}/{repo}/actions/caches

        Deletes one or more GitHub Actions caches for a repository, using a complete cache key. By default, all caches that match the provided key are deleted, but you can optionally provide a Git ref to restrict deletions to caches that match both the provided key and the Git ref.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#delete-github-actions-caches-for-a-repository-using-a-cache-key
        """

        from ..models import ActionsCacheList

        url = f"/repos/{owner}/{repo}/actions/caches"

        params = {
            "key": key,
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsCacheList,
        )

    async def async_delete_actions_cache_by_key(
        self,
        owner: str,
        repo: str,
        *,
        key: str,
        ref: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsCacheList, ActionsCacheListType]:
        """actions/delete-actions-cache-by-key

        DELETE /repos/{owner}/{repo}/actions/caches

        Deletes one or more GitHub Actions caches for a repository, using a complete cache key. By default, all caches that match the provided key are deleted, but you can optionally provide a Git ref to restrict deletions to caches that match both the provided key and the Git ref.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#delete-github-actions-caches-for-a-repository-using-a-cache-key
        """

        from ..models import ActionsCacheList

        url = f"/repos/{owner}/{repo}/actions/caches"

        params = {
            "key": key,
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsCacheList,
        )

    def delete_actions_cache_by_id(
        self,
        owner: str,
        repo: str,
        cache_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-actions-cache-by-id

        DELETE /repos/{owner}/{repo}/actions/caches/{cache_id}

        Deletes a GitHub Actions cache for a repository, using a cache ID.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#delete-a-github-actions-cache-for-a-repository-using-a-cache-id
        """

        url = f"/repos/{owner}/{repo}/actions/caches/{cache_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_actions_cache_by_id(
        self,
        owner: str,
        repo: str,
        cache_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-actions-cache-by-id

        DELETE /repos/{owner}/{repo}/actions/caches/{cache_id}

        Deletes a GitHub Actions cache for a repository, using a cache ID.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#delete-a-github-actions-cache-for-a-repository-using-a-cache-id
        """

        url = f"/repos/{owner}/{repo}/actions/caches/{cache_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def get_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Job, JobType]:
        """actions/get-job-for-workflow-run

        GET /repos/{owner}/{repo}/actions/jobs/{job_id}

        Gets a specific job in a workflow run.

        Anyone with read access to the repository can use this endpoint.

        If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-jobs#get-a-job-for-a-workflow-run
        """

        from ..models import Job

        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Job,
        )

    async def async_get_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Job, JobType]:
        """actions/get-job-for-workflow-run

        GET /repos/{owner}/{repo}/actions/jobs/{job_id}

        Gets a specific job in a workflow run.

        Anyone with read access to the repository can use this endpoint.

        If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-jobs#get-a-job-for-a-workflow-run
        """

        from ..models import Job

        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Job,
        )

    def download_job_logs_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/download-job-logs-for-workflow-run

        GET /repos/{owner}/{repo}/actions/jobs/{job_id}/logs

        Gets a redirect URL to download a plain text file of logs for a workflow job. This link expires after 1 minute. Look
        for `Location:` in the response header to find the URL for the download.

        Anyone with read access to the repository can use this endpoint.

        If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-jobs#download-job-logs-for-a-workflow-run
        """

        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_download_job_logs_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/download-job-logs-for-workflow-run

        GET /repos/{owner}/{repo}/actions/jobs/{job_id}/logs

        Gets a redirect URL to download a plain text file of logs for a workflow job. This link expires after 1 minute. Look
        for `Location:` in the response header to find the URL for the download.

        Anyone with read access to the repository can use this endpoint.

        If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-jobs#download-job-logs-for-a-workflow-run
        """

        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    def re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoActionsJobsJobIdRerunPostBodyType, None]
        ] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    def re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        enable_debug_logging: Missing[bool] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    def re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoActionsJobsJobIdRerunPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/re-run-job-for-workflow-run

        POST /repos/{owner}/{repo}/actions/jobs/{job_id}/rerun

        Re-run a job and its dependent jobs in a workflow run.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#re-run-a-job-from-a-workflow-run
        """

        from typing import Union

        from ..models import (
            BasicError,
            EmptyObject,
            ReposOwnerRepoActionsJobsJobIdRerunPostBody,
        )

        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}/rerun"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoActionsJobsJobIdRerunPostBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    async def async_re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoActionsJobsJobIdRerunPostBodyType, None]
        ] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    async def async_re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        enable_debug_logging: Missing[bool] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    async def async_re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoActionsJobsJobIdRerunPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/re-run-job-for-workflow-run

        POST /repos/{owner}/{repo}/actions/jobs/{job_id}/rerun

        Re-run a job and its dependent jobs in a workflow run.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#re-run-a-job-from-a-workflow-run
        """

        from typing import Union

        from ..models import (
            BasicError,
            EmptyObject,
            ReposOwnerRepoActionsJobsJobIdRerunPostBody,
        )

        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}/rerun"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoActionsJobsJobIdRerunPostBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
            error_models={
                "403": BasicError,
            },
        )

    def get_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OidcCustomSubRepo, OidcCustomSubRepoType]:
        """actions/get-custom-oidc-sub-claim-for-repo

        GET /repos/{owner}/{repo}/actions/oidc/customization/sub

        Gets the customization template for an OpenID Connect (OIDC) subject claim.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/oidc#get-the-customization-template-for-an-oidc-subject-claim-for-a-repository
        """

        from ..models import BasicError, OidcCustomSubRepo

        url = f"/repos/{owner}/{repo}/actions/oidc/customization/sub"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OidcCustomSubRepo,
            error_models={
                "400": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OidcCustomSubRepo, OidcCustomSubRepoType]:
        """actions/get-custom-oidc-sub-claim-for-repo

        GET /repos/{owner}/{repo}/actions/oidc/customization/sub

        Gets the customization template for an OpenID Connect (OIDC) subject claim.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/oidc#get-the-customization-template-for-an-oidc-subject-claim-for-a-repository
        """

        from ..models import BasicError, OidcCustomSubRepo

        url = f"/repos/{owner}/{repo}/actions/oidc/customization/sub"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OidcCustomSubRepo,
            error_models={
                "400": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoActionsOidcCustomizationSubPutBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    def set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        use_default: bool,
        include_claim_keys: Missing[list[str]] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    def set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoActionsOidcCustomizationSubPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/set-custom-oidc-sub-claim-for-repo

        PUT /repos/{owner}/{repo}/actions/oidc/customization/sub

        Sets the customization template and `opt-in` or `opt-out` flag for an OpenID Connect (OIDC) subject claim for a repository.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/oidc#set-the-customization-template-for-an-oidc-subject-claim-for-a-repository
        """

        from ..models import (
            BasicError,
            EmptyObject,
            ReposOwnerRepoActionsOidcCustomizationSubPutBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/actions/oidc/customization/sub"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsOidcCustomizationSubPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "400": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoActionsOidcCustomizationSubPutBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    async def async_set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        use_default: bool,
        include_claim_keys: Missing[list[str]] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    async def async_set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoActionsOidcCustomizationSubPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/set-custom-oidc-sub-claim-for-repo

        PUT /repos/{owner}/{repo}/actions/oidc/customization/sub

        Sets the customization template and `opt-in` or `opt-out` flag for an OpenID Connect (OIDC) subject claim for a repository.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/oidc#set-the-customization-template-for-an-oidc-subject-claim-for-a-repository
        """

        from ..models import (
            BasicError,
            EmptyObject,
            ReposOwnerRepoActionsOidcCustomizationSubPutBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/actions/oidc/customization/sub"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsOidcCustomizationSubPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "400": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_repo_organization_secrets(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsOrganizationSecretsGetResponse200,
        ReposOwnerRepoActionsOrganizationSecretsGetResponse200Type,
    ]:
        """actions/list-repo-organization-secrets

        GET /repos/{owner}/{repo}/actions/organization-secrets

        Lists all organization secrets shared with a repository without revealing their encrypted
        values.

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#list-repository-organization-secrets
        """

        from ..models import ReposOwnerRepoActionsOrganizationSecretsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/organization-secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsOrganizationSecretsGetResponse200,
        )

    async def async_list_repo_organization_secrets(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsOrganizationSecretsGetResponse200,
        ReposOwnerRepoActionsOrganizationSecretsGetResponse200Type,
    ]:
        """actions/list-repo-organization-secrets

        GET /repos/{owner}/{repo}/actions/organization-secrets

        Lists all organization secrets shared with a repository without revealing their encrypted
        values.

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#list-repository-organization-secrets
        """

        from ..models import ReposOwnerRepoActionsOrganizationSecretsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/organization-secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsOrganizationSecretsGetResponse200,
        )

    def list_repo_organization_variables(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsOrganizationVariablesGetResponse200,
        ReposOwnerRepoActionsOrganizationVariablesGetResponse200Type,
    ]:
        """actions/list-repo-organization-variables

        GET /repos/{owner}/{repo}/actions/organization-variables

        Lists all organization variables shared with a repository.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#list-repository-organization-variables
        """

        from ..models import ReposOwnerRepoActionsOrganizationVariablesGetResponse200

        url = f"/repos/{owner}/{repo}/actions/organization-variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsOrganizationVariablesGetResponse200,
        )

    async def async_list_repo_organization_variables(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsOrganizationVariablesGetResponse200,
        ReposOwnerRepoActionsOrganizationVariablesGetResponse200Type,
    ]:
        """actions/list-repo-organization-variables

        GET /repos/{owner}/{repo}/actions/organization-variables

        Lists all organization variables shared with a repository.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#list-repository-organization-variables
        """

        from ..models import ReposOwnerRepoActionsOrganizationVariablesGetResponse200

        url = f"/repos/{owner}/{repo}/actions/organization-variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsOrganizationVariablesGetResponse200,
        )

    def get_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsRepositoryPermissions, ActionsRepositoryPermissionsType]:
        """actions/get-github-actions-permissions-repository

        GET /repos/{owner}/{repo}/actions/permissions

        Gets the GitHub Actions permissions policy for a repository, including whether GitHub Actions is enabled and the actions and reusable workflows allowed to run in the repository.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-github-actions-permissions-for-a-repository
        """

        from ..models import ActionsRepositoryPermissions

        url = f"/repos/{owner}/{repo}/actions/permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsRepositoryPermissions,
        )

    async def async_get_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsRepositoryPermissions, ActionsRepositoryPermissionsType]:
        """actions/get-github-actions-permissions-repository

        GET /repos/{owner}/{repo}/actions/permissions

        Gets the GitHub Actions permissions policy for a repository, including whether GitHub Actions is enabled and the actions and reusable workflows allowed to run in the repository.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-github-actions-permissions-for-a-repository
        """

        from ..models import ActionsRepositoryPermissions

        url = f"/repos/{owner}/{repo}/actions/permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsRepositoryPermissions,
        )

    @overload
    def set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoActionsPermissionsPutBodyType,
    ) -> Response: ...

    @overload
    def set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        enabled: bool,
        allowed_actions: Missing[Literal["all", "local_only", "selected"]] = UNSET,
        sha_pinning_required: Missing[bool] = UNSET,
    ) -> Response: ...

    def set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-github-actions-permissions-repository

        PUT /repos/{owner}/{repo}/actions/permissions

        Sets the GitHub Actions permissions policy for enabling GitHub Actions and allowed actions in the repository.

        If the repository belongs to an organization or enterprise that has set restrictive permissions at the organization or enterprise levels, such as `allowed_actions` to `selected` actions, then you cannot override them for the repository.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-github-actions-permissions-for-a-repository
        """

        from ..models import ReposOwnerRepoActionsPermissionsPutBody

        url = f"/repos/{owner}/{repo}/actions/permissions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoActionsPermissionsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoActionsPermissionsPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        enabled: bool,
        allowed_actions: Missing[Literal["all", "local_only", "selected"]] = UNSET,
        sha_pinning_required: Missing[bool] = UNSET,
    ) -> Response: ...

    async def async_set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-github-actions-permissions-repository

        PUT /repos/{owner}/{repo}/actions/permissions

        Sets the GitHub Actions permissions policy for enabling GitHub Actions and allowed actions in the repository.

        If the repository belongs to an organization or enterprise that has set restrictive permissions at the organization or enterprise levels, such as `allowed_actions` to `selected` actions, then you cannot override them for the repository.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-github-actions-permissions-for-a-repository
        """

        from ..models import ReposOwnerRepoActionsPermissionsPutBody

        url = f"/repos/{owner}/{repo}/actions/permissions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoActionsPermissionsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def get_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsWorkflowAccessToRepository, ActionsWorkflowAccessToRepositoryType
    ]:
        """actions/get-workflow-access-to-repository

        GET /repos/{owner}/{repo}/actions/permissions/access

        Gets the level of access that workflows outside of the repository have to actions and reusable workflows in the repository.
        This endpoint only applies to internal and private repositories.
        For more information, see "[Allowing access to components in a private repository](https://docs.github.com/enterprise-cloud@latest//repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-a-private-repository)" and
        "[Allowing access to components in an internal repository](https://docs.github.com/enterprise-cloud@latest//repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-an-internal-repository)."

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-the-level-of-access-for-workflows-outside-of-the-repository
        """

        from ..models import ActionsWorkflowAccessToRepository

        url = f"/repos/{owner}/{repo}/actions/permissions/access"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsWorkflowAccessToRepository,
        )

    async def async_get_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsWorkflowAccessToRepository, ActionsWorkflowAccessToRepositoryType
    ]:
        """actions/get-workflow-access-to-repository

        GET /repos/{owner}/{repo}/actions/permissions/access

        Gets the level of access that workflows outside of the repository have to actions and reusable workflows in the repository.
        This endpoint only applies to internal and private repositories.
        For more information, see "[Allowing access to components in a private repository](https://docs.github.com/enterprise-cloud@latest//repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-a-private-repository)" and
        "[Allowing access to components in an internal repository](https://docs.github.com/enterprise-cloud@latest//repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-an-internal-repository)."

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-the-level-of-access-for-workflows-outside-of-the-repository
        """

        from ..models import ActionsWorkflowAccessToRepository

        url = f"/repos/{owner}/{repo}/actions/permissions/access"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsWorkflowAccessToRepository,
        )

    @overload
    def set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsWorkflowAccessToRepositoryType,
    ) -> Response: ...

    @overload
    def set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        access_level: Literal["none", "user", "organization", "enterprise"],
    ) -> Response: ...

    def set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsWorkflowAccessToRepositoryType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-workflow-access-to-repository

        PUT /repos/{owner}/{repo}/actions/permissions/access

        Sets the level of access that workflows outside of the repository have to actions and reusable workflows in the repository.
        This endpoint only applies to internal and private repositories.
        For more information, see "[Allowing access to components in a private repository](https://docs.github.com/enterprise-cloud@latest//repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-a-private-repository)" and
        "[Allowing access to components in an internal repository](https://docs.github.com/enterprise-cloud@latest//repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-an-internal-repository)."

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-the-level-of-access-for-workflows-outside-of-the-repository
        """

        from ..models import ActionsWorkflowAccessToRepository

        url = f"/repos/{owner}/{repo}/actions/permissions/access"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsWorkflowAccessToRepository, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsWorkflowAccessToRepositoryType,
    ) -> Response: ...

    @overload
    async def async_set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        access_level: Literal["none", "user", "organization", "enterprise"],
    ) -> Response: ...

    async def async_set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsWorkflowAccessToRepositoryType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-workflow-access-to-repository

        PUT /repos/{owner}/{repo}/actions/permissions/access

        Sets the level of access that workflows outside of the repository have to actions and reusable workflows in the repository.
        This endpoint only applies to internal and private repositories.
        For more information, see "[Allowing access to components in a private repository](https://docs.github.com/enterprise-cloud@latest//repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-a-private-repository)" and
        "[Allowing access to components in an internal repository](https://docs.github.com/enterprise-cloud@latest//repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-an-internal-repository)."

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-the-level-of-access-for-workflows-outside-of-the-repository
        """

        from ..models import ActionsWorkflowAccessToRepository

        url = f"/repos/{owner}/{repo}/actions/permissions/access"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsWorkflowAccessToRepository, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def get_artifact_and_log_retention_settings_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsArtifactAndLogRetentionResponse,
        ActionsArtifactAndLogRetentionResponseType,
    ]:
        """actions/get-artifact-and-log-retention-settings-repository

        GET /repos/{owner}/{repo}/actions/permissions/artifact-and-log-retention

        Gets artifact and log retention settings for a repository.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-artifact-and-log-retention-settings-for-a-repository
        """

        from ..models import ActionsArtifactAndLogRetentionResponse, BasicError

        url = f"/repos/{owner}/{repo}/actions/permissions/artifact-and-log-retention"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsArtifactAndLogRetentionResponse,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_artifact_and_log_retention_settings_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsArtifactAndLogRetentionResponse,
        ActionsArtifactAndLogRetentionResponseType,
    ]:
        """actions/get-artifact-and-log-retention-settings-repository

        GET /repos/{owner}/{repo}/actions/permissions/artifact-and-log-retention

        Gets artifact and log retention settings for a repository.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-artifact-and-log-retention-settings-for-a-repository
        """

        from ..models import ActionsArtifactAndLogRetentionResponse, BasicError

        url = f"/repos/{owner}/{repo}/actions/permissions/artifact-and-log-retention"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsArtifactAndLogRetentionResponse,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_artifact_and_log_retention_settings_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsArtifactAndLogRetentionType,
    ) -> Response: ...

    @overload
    def set_artifact_and_log_retention_settings_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        days: int,
    ) -> Response: ...

    def set_artifact_and_log_retention_settings_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsArtifactAndLogRetentionType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-artifact-and-log-retention-settings-repository

        PUT /repos/{owner}/{repo}/actions/permissions/artifact-and-log-retention

        Sets artifact and log retention settings for a repository.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-artifact-and-log-retention-settings-for-a-repository
        """

        from ..models import ActionsArtifactAndLogRetention, BasicError, ValidationError

        url = f"/repos/{owner}/{repo}/actions/permissions/artifact-and-log-retention"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsArtifactAndLogRetention, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_artifact_and_log_retention_settings_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsArtifactAndLogRetentionType,
    ) -> Response: ...

    @overload
    async def async_set_artifact_and_log_retention_settings_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        days: int,
    ) -> Response: ...

    async def async_set_artifact_and_log_retention_settings_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsArtifactAndLogRetentionType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-artifact-and-log-retention-settings-repository

        PUT /repos/{owner}/{repo}/actions/permissions/artifact-and-log-retention

        Sets artifact and log retention settings for a repository.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-artifact-and-log-retention-settings-for-a-repository
        """

        from ..models import ActionsArtifactAndLogRetention, BasicError, ValidationError

        url = f"/repos/{owner}/{repo}/actions/permissions/artifact-and-log-retention"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsArtifactAndLogRetention, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_fork_pr_contributor_approval_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsForkPrContributorApproval, ActionsForkPrContributorApprovalType
    ]:
        """actions/get-fork-pr-contributor-approval-permissions-repository

        GET /repos/{owner}/{repo}/actions/permissions/fork-pr-contributor-approval

        Gets the fork PR contributor approval policy for a repository.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-fork-pr-contributor-approval-permissions-for-a-repository
        """

        from ..models import ActionsForkPrContributorApproval, BasicError

        url = f"/repos/{owner}/{repo}/actions/permissions/fork-pr-contributor-approval"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsForkPrContributorApproval,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_fork_pr_contributor_approval_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsForkPrContributorApproval, ActionsForkPrContributorApprovalType
    ]:
        """actions/get-fork-pr-contributor-approval-permissions-repository

        GET /repos/{owner}/{repo}/actions/permissions/fork-pr-contributor-approval

        Gets the fork PR contributor approval policy for a repository.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-fork-pr-contributor-approval-permissions-for-a-repository
        """

        from ..models import ActionsForkPrContributorApproval, BasicError

        url = f"/repos/{owner}/{repo}/actions/permissions/fork-pr-contributor-approval"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsForkPrContributorApproval,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_fork_pr_contributor_approval_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsForkPrContributorApprovalType,
    ) -> Response: ...

    @overload
    def set_fork_pr_contributor_approval_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        approval_policy: Literal[
            "first_time_contributors_new_to_github",
            "first_time_contributors",
            "all_external_contributors",
        ],
    ) -> Response: ...

    def set_fork_pr_contributor_approval_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsForkPrContributorApprovalType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-fork-pr-contributor-approval-permissions-repository

        PUT /repos/{owner}/{repo}/actions/permissions/fork-pr-contributor-approval

        Sets the fork PR contributor approval policy for a repository.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-fork-pr-contributor-approval-permissions-for-a-repository
        """

        from ..models import (
            ActionsForkPrContributorApproval,
            BasicError,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/actions/permissions/fork-pr-contributor-approval"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsForkPrContributorApproval, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_fork_pr_contributor_approval_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsForkPrContributorApprovalType,
    ) -> Response: ...

    @overload
    async def async_set_fork_pr_contributor_approval_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        approval_policy: Literal[
            "first_time_contributors_new_to_github",
            "first_time_contributors",
            "all_external_contributors",
        ],
    ) -> Response: ...

    async def async_set_fork_pr_contributor_approval_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsForkPrContributorApprovalType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-fork-pr-contributor-approval-permissions-repository

        PUT /repos/{owner}/{repo}/actions/permissions/fork-pr-contributor-approval

        Sets the fork PR contributor approval policy for a repository.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-fork-pr-contributor-approval-permissions-for-a-repository
        """

        from ..models import (
            ActionsForkPrContributorApproval,
            BasicError,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/actions/permissions/fork-pr-contributor-approval"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsForkPrContributorApproval, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_private_repo_fork_pr_workflows_settings_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsForkPrWorkflowsPrivateRepos, ActionsForkPrWorkflowsPrivateReposType
    ]:
        """actions/get-private-repo-fork-pr-workflows-settings-repository

        GET /repos/{owner}/{repo}/actions/permissions/fork-pr-workflows-private-repos

        Gets the settings for whether workflows from fork pull requests can run on a private repository.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-private-repo-fork-pr-workflow-settings-for-a-repository
        """

        from ..models import ActionsForkPrWorkflowsPrivateRepos, BasicError

        url = (
            f"/repos/{owner}/{repo}/actions/permissions/fork-pr-workflows-private-repos"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsForkPrWorkflowsPrivateRepos,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_private_repo_fork_pr_workflows_settings_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsForkPrWorkflowsPrivateRepos, ActionsForkPrWorkflowsPrivateReposType
    ]:
        """actions/get-private-repo-fork-pr-workflows-settings-repository

        GET /repos/{owner}/{repo}/actions/permissions/fork-pr-workflows-private-repos

        Gets the settings for whether workflows from fork pull requests can run on a private repository.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-private-repo-fork-pr-workflow-settings-for-a-repository
        """

        from ..models import ActionsForkPrWorkflowsPrivateRepos, BasicError

        url = (
            f"/repos/{owner}/{repo}/actions/permissions/fork-pr-workflows-private-repos"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsForkPrWorkflowsPrivateRepos,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def set_private_repo_fork_pr_workflows_settings_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsForkPrWorkflowsPrivateReposRequestType,
    ) -> Response: ...

    @overload
    def set_private_repo_fork_pr_workflows_settings_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        run_workflows_from_fork_pull_requests: bool,
        send_write_tokens_to_workflows: Missing[bool] = UNSET,
        send_secrets_and_variables: Missing[bool] = UNSET,
        require_approval_for_fork_pr_workflows: Missing[bool] = UNSET,
    ) -> Response: ...

    def set_private_repo_fork_pr_workflows_settings_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsForkPrWorkflowsPrivateReposRequestType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-private-repo-fork-pr-workflows-settings-repository

        PUT /repos/{owner}/{repo}/actions/permissions/fork-pr-workflows-private-repos

        Sets the settings for whether workflows from fork pull requests can run on a private repository.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-private-repo-fork-pr-workflow-settings-for-a-repository
        """

        from ..models import (
            ActionsForkPrWorkflowsPrivateReposRequest,
            BasicError,
            ValidationError,
        )

        url = (
            f"/repos/{owner}/{repo}/actions/permissions/fork-pr-workflows-private-repos"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsForkPrWorkflowsPrivateReposRequest, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_private_repo_fork_pr_workflows_settings_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsForkPrWorkflowsPrivateReposRequestType,
    ) -> Response: ...

    @overload
    async def async_set_private_repo_fork_pr_workflows_settings_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        run_workflows_from_fork_pull_requests: bool,
        send_write_tokens_to_workflows: Missing[bool] = UNSET,
        send_secrets_and_variables: Missing[bool] = UNSET,
        require_approval_for_fork_pr_workflows: Missing[bool] = UNSET,
    ) -> Response: ...

    async def async_set_private_repo_fork_pr_workflows_settings_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsForkPrWorkflowsPrivateReposRequestType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-private-repo-fork-pr-workflows-settings-repository

        PUT /repos/{owner}/{repo}/actions/permissions/fork-pr-workflows-private-repos

        Sets the settings for whether workflows from fork pull requests can run on a private repository.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-private-repo-fork-pr-workflow-settings-for-a-repository
        """

        from ..models import (
            ActionsForkPrWorkflowsPrivateReposRequest,
            BasicError,
            ValidationError,
        )

        url = (
            f"/repos/{owner}/{repo}/actions/permissions/fork-pr-workflows-private-repos"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsForkPrWorkflowsPrivateReposRequest, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SelectedActions, SelectedActionsType]:
        """actions/get-allowed-actions-repository

        GET /repos/{owner}/{repo}/actions/permissions/selected-actions

        Gets the settings for selected actions and reusable workflows that are allowed in a repository. To use this endpoint, the repository policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-allowed-actions-and-reusable-workflows-for-a-repository
        """

        from ..models import SelectedActions

        url = f"/repos/{owner}/{repo}/actions/permissions/selected-actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SelectedActions,
        )

    async def async_get_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SelectedActions, SelectedActionsType]:
        """actions/get-allowed-actions-repository

        GET /repos/{owner}/{repo}/actions/permissions/selected-actions

        Gets the settings for selected actions and reusable workflows that are allowed in a repository. To use this endpoint, the repository policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-allowed-actions-and-reusable-workflows-for-a-repository
        """

        from ..models import SelectedActions

        url = f"/repos/{owner}/{repo}/actions/permissions/selected-actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SelectedActions,
        )

    @overload
    def set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[SelectedActionsType] = UNSET,
    ) -> Response: ...

    @overload
    def set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        github_owned_allowed: Missing[bool] = UNSET,
        verified_allowed: Missing[bool] = UNSET,
        patterns_allowed: Missing[list[str]] = UNSET,
    ) -> Response: ...

    def set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[SelectedActionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-allowed-actions-repository

        PUT /repos/{owner}/{repo}/actions/permissions/selected-actions

        Sets the actions that are allowed in a repository. To use this endpoint, the repository permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."

        If the repository belongs to an organization or enterprise that has `selected` actions set at the organization or enterprise levels, then you cannot override any of the allowed actions settings and reusable workflows settings.

        To use the `patterns_allowed` setting for private repositories, the repository must belong to an enterprise. If the repository does not belong to an enterprise, then the `patterns_allowed` setting only applies to public repositories.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-allowed-actions-and-reusable-workflows-for-a-repository
        """

        from ..models import SelectedActions

        url = f"/repos/{owner}/{repo}/actions/permissions/selected-actions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(SelectedActions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[SelectedActionsType] = UNSET,
    ) -> Response: ...

    @overload
    async def async_set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        github_owned_allowed: Missing[bool] = UNSET,
        verified_allowed: Missing[bool] = UNSET,
        patterns_allowed: Missing[list[str]] = UNSET,
    ) -> Response: ...

    async def async_set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[SelectedActionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-allowed-actions-repository

        PUT /repos/{owner}/{repo}/actions/permissions/selected-actions

        Sets the actions that are allowed in a repository. To use this endpoint, the repository permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."

        If the repository belongs to an organization or enterprise that has `selected` actions set at the organization or enterprise levels, then you cannot override any of the allowed actions settings and reusable workflows settings.

        To use the `patterns_allowed` setting for private repositories, the repository must belong to an enterprise. If the repository does not belong to an enterprise, then the `patterns_allowed` setting only applies to public repositories.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-allowed-actions-and-reusable-workflows-for-a-repository
        """

        from ..models import SelectedActions

        url = f"/repos/{owner}/{repo}/actions/permissions/selected-actions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(SelectedActions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def get_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsGetDefaultWorkflowPermissions, ActionsGetDefaultWorkflowPermissionsType
    ]:
        """actions/get-github-actions-default-workflow-permissions-repository

        GET /repos/{owner}/{repo}/actions/permissions/workflow

        Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in a repository,
        as well as if GitHub Actions can submit approving pull request reviews.
        For more information, see "[Setting the permissions of the GITHUB_TOKEN for your repository](https://docs.github.com/enterprise-cloud@latest//repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#setting-the-permissions-of-the-github_token-for-your-repository)."

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-default-workflow-permissions-for-a-repository
        """

        from ..models import ActionsGetDefaultWorkflowPermissions

        url = f"/repos/{owner}/{repo}/actions/permissions/workflow"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    async def async_get_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ActionsGetDefaultWorkflowPermissions, ActionsGetDefaultWorkflowPermissionsType
    ]:
        """actions/get-github-actions-default-workflow-permissions-repository

        GET /repos/{owner}/{repo}/actions/permissions/workflow

        Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in a repository,
        as well as if GitHub Actions can submit approving pull request reviews.
        For more information, see "[Setting the permissions of the GITHUB_TOKEN for your repository](https://docs.github.com/enterprise-cloud@latest//repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#setting-the-permissions-of-the-github_token-for-your-repository)."

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-default-workflow-permissions-for-a-repository
        """

        from ..models import ActionsGetDefaultWorkflowPermissions

        url = f"/repos/{owner}/{repo}/actions/permissions/workflow"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    @overload
    def set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsSetDefaultWorkflowPermissionsType,
    ) -> Response: ...

    @overload
    def set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        default_workflow_permissions: Missing[Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Missing[bool] = UNSET,
    ) -> Response: ...

    def set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-github-actions-default-workflow-permissions-repository

        PUT /repos/{owner}/{repo}/actions/permissions/workflow

        Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in a repository, and sets if GitHub Actions
        can submit approving pull request reviews.
        For more information, see "[Setting the permissions of the GITHUB_TOKEN for your repository](https://docs.github.com/enterprise-cloud@latest//repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#setting-the-permissions-of-the-github_token-for-your-repository)."

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-default-workflow-permissions-for-a-repository
        """

        from ..models import ActionsSetDefaultWorkflowPermissions

        url = f"/repos/{owner}/{repo}/actions/permissions/workflow"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsSetDefaultWorkflowPermissions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    @overload
    async def async_set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ActionsSetDefaultWorkflowPermissionsType,
    ) -> Response: ...

    @overload
    async def async_set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        default_workflow_permissions: Missing[Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Missing[bool] = UNSET,
    ) -> Response: ...

    async def async_set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/set-github-actions-default-workflow-permissions-repository

        PUT /repos/{owner}/{repo}/actions/permissions/workflow

        Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in a repository, and sets if GitHub Actions
        can submit approving pull request reviews.
        For more information, see "[Setting the permissions of the GITHUB_TOKEN for your repository](https://docs.github.com/enterprise-cloud@latest//repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#setting-the-permissions-of-the-github_token-for-your-repository)."

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-default-workflow-permissions-for-a-repository
        """

        from ..models import ActionsSetDefaultWorkflowPermissions

        url = f"/repos/{owner}/{repo}/actions/permissions/workflow"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsSetDefaultWorkflowPermissions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    def list_self_hosted_runners_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        name: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsRunnersGetResponse200,
        ReposOwnerRepoActionsRunnersGetResponse200Type,
    ]:
        """actions/list-self-hosted-runners-for-repo

        GET /repos/{owner}/{repo}/actions/runners

        Lists all self-hosted runners configured in a repository.

        Authenticated users must have admin access to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-self-hosted-runners-for-a-repository
        """

        from ..models import ReposOwnerRepoActionsRunnersGetResponse200

        url = f"/repos/{owner}/{repo}/actions/runners"

        params = {
            "name": name,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        name: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsRunnersGetResponse200,
        ReposOwnerRepoActionsRunnersGetResponse200Type,
    ]:
        """actions/list-self-hosted-runners-for-repo

        GET /repos/{owner}/{repo}/actions/runners

        Lists all self-hosted runners configured in a repository.

        Authenticated users must have admin access to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-self-hosted-runners-for-a-repository
        """

        from ..models import ReposOwnerRepoActionsRunnersGetResponse200

        url = f"/repos/{owner}/{repo}/actions/runners"

        params = {
            "name": name,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsRunnersGetResponse200,
        )

    def list_runner_applications_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RunnerApplication], list[RunnerApplicationType]]:
        """actions/list-runner-applications-for-repo

        GET /repos/{owner}/{repo}/actions/runners/downloads

        Lists binaries for the runner application that you can download and run.

        Authenticated users must have admin access to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-runner-applications-for-a-repository
        """

        from ..models import RunnerApplication

        url = f"/repos/{owner}/{repo}/actions/runners/downloads"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RunnerApplication],
        )

    async def async_list_runner_applications_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RunnerApplication], list[RunnerApplicationType]]:
        """actions/list-runner-applications-for-repo

        GET /repos/{owner}/{repo}/actions/runners/downloads

        Lists binaries for the runner application that you can download and run.

        Authenticated users must have admin access to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-runner-applications-for-a-repository
        """

        from ..models import RunnerApplication

        url = f"/repos/{owner}/{repo}/actions/runners/downloads"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RunnerApplication],
        )

    @overload
    def generate_runner_jitconfig_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoActionsRunnersGenerateJitconfigPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201Type,
    ]: ...

    @overload
    def generate_runner_jitconfig_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        runner_group_id: int,
        labels: list[str],
        work_folder: Missing[str] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201Type,
    ]: ...

    def generate_runner_jitconfig_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoActionsRunnersGenerateJitconfigPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201Type,
    ]:
        """actions/generate-runner-jitconfig-for-repo

        POST /repos/{owner}/{repo}/actions/runners/generate-jitconfig

        Generates a configuration that can be passed to the runner application at startup.

        The authenticated user must have admin access to the repository.

        OAuth tokens and personal access tokens (classic) need the`repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-configuration-for-a-just-in-time-runner-for-a-repository
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
            ReposOwnerRepoActionsRunnersGenerateJitconfigPostBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/generate-jitconfig"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsRunnersGenerateJitconfigPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
                "409": BasicError,
            },
        )

    @overload
    async def async_generate_runner_jitconfig_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoActionsRunnersGenerateJitconfigPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201Type,
    ]: ...

    @overload
    async def async_generate_runner_jitconfig_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        runner_group_id: int,
        labels: list[str],
        work_folder: Missing[str] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201Type,
    ]: ...

    async def async_generate_runner_jitconfig_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoActionsRunnersGenerateJitconfigPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201Type,
    ]:
        """actions/generate-runner-jitconfig-for-repo

        POST /repos/{owner}/{repo}/actions/runners/generate-jitconfig

        Generates a configuration that can be passed to the runner application at startup.

        The authenticated user must have admin access to the repository.

        OAuth tokens and personal access tokens (classic) need the`repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-configuration-for-a-just-in-time-runner-for-a-repository
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
            ReposOwnerRepoActionsRunnersGenerateJitconfigPostBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/generate-jitconfig"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsRunnersGenerateJitconfigPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
                "409": BasicError,
            },
        )

    def create_registration_token_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[AuthenticationToken, AuthenticationTokenType]:
        """actions/create-registration-token-for-repo

        POST /repos/{owner}/{repo}/actions/runners/registration-token

        Returns a token that you can pass to the `config` script. The token expires after one hour.

        For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to configure your self-hosted runner:

        ```
        ./config.sh --url https://github.com/octo-org --token TOKEN
        ```

        Authenticated users must have admin access to the repository to use this endpoint.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-registration-token-for-a-repository
        """

        from ..models import AuthenticationToken

        url = f"/repos/{owner}/{repo}/actions/runners/registration-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AuthenticationToken,
        )

    async def async_create_registration_token_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[AuthenticationToken, AuthenticationTokenType]:
        """actions/create-registration-token-for-repo

        POST /repos/{owner}/{repo}/actions/runners/registration-token

        Returns a token that you can pass to the `config` script. The token expires after one hour.

        For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to configure your self-hosted runner:

        ```
        ./config.sh --url https://github.com/octo-org --token TOKEN
        ```

        Authenticated users must have admin access to the repository to use this endpoint.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-registration-token-for-a-repository
        """

        from ..models import AuthenticationToken

        url = f"/repos/{owner}/{repo}/actions/runners/registration-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AuthenticationToken,
        )

    def create_remove_token_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[AuthenticationToken, AuthenticationTokenType]:
        """actions/create-remove-token-for-repo

        POST /repos/{owner}/{repo}/actions/runners/remove-token

        Returns a token that you can pass to the `config` script to remove a self-hosted runner from an repository. The token expires after one hour.

        For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to remove your self-hosted runner from an organization:

        ```
        ./config.sh remove --token TOKEN
        ```

        Authenticated users must have admin access to the repository to use this endpoint.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-remove-token-for-a-repository
        """

        from ..models import AuthenticationToken

        url = f"/repos/{owner}/{repo}/actions/runners/remove-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AuthenticationToken,
        )

    async def async_create_remove_token_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[AuthenticationToken, AuthenticationTokenType]:
        """actions/create-remove-token-for-repo

        POST /repos/{owner}/{repo}/actions/runners/remove-token

        Returns a token that you can pass to the `config` script to remove a self-hosted runner from an repository. The token expires after one hour.

        For example, you can replace `TOKEN` in the following example with the registration token provided by this endpoint to remove your self-hosted runner from an organization:

        ```
        ./config.sh remove --token TOKEN
        ```

        Authenticated users must have admin access to the repository to use this endpoint.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-remove-token-for-a-repository
        """

        from ..models import AuthenticationToken

        url = f"/repos/{owner}/{repo}/actions/runners/remove-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AuthenticationToken,
        )

    def get_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Runner, RunnerType]:
        """actions/get-self-hosted-runner-for-repo

        GET /repos/{owner}/{repo}/actions/runners/{runner_id}

        Gets a specific self-hosted runner configured in a repository.

        Authenticated users must have admin access to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#get-a-self-hosted-runner-for-a-repository
        """

        from ..models import Runner

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Runner,
        )

    async def async_get_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Runner, RunnerType]:
        """actions/get-self-hosted-runner-for-repo

        GET /repos/{owner}/{repo}/actions/runners/{runner_id}

        Gets a specific self-hosted runner configured in a repository.

        Authenticated users must have admin access to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#get-a-self-hosted-runner-for-a-repository
        """

        from ..models import Runner

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Runner,
        )

    def delete_self_hosted_runner_from_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-self-hosted-runner-from-repo

        DELETE /repos/{owner}/{repo}/actions/runners/{runner_id}

        Forces the removal of a self-hosted runner from a repository. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.

        Authenticated users must have admin access to the repository to use this endpoint.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#delete-a-self-hosted-runner-from-a-repository
        """

        from ..models import ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    async def async_delete_self_hosted_runner_from_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-self-hosted-runner-from-repo

        DELETE /repos/{owner}/{repo}/actions/runners/{runner_id}

        Forces the removal of a self-hosted runner from a repository. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.

        Authenticated users must have admin access to the repository to use this endpoint.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#delete-a-self-hosted-runner-from-a-repository
        """

        from ..models import ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    def list_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """actions/list-labels-for-self-hosted-runner-for-repo

        GET /repos/{owner}/{repo}/actions/runners/{runner_id}/labels

        Lists all labels for a self-hosted runner configured in a repository.

        Authenticated users must have admin access to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-labels-for-a-self-hosted-runner-for-a-repository
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """actions/list-labels-for-self-hosted-runner-for-repo

        GET /repos/{owner}/{repo}/actions/runners/{runner_id}/labels

        Lists all labels for a self-hosted runner configured in a repository.

        Authenticated users must have admin access to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-labels-for-a-self-hosted-runner-for-a-repository
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    @overload
    def set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        labels: list[str],
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    def set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """actions/set-custom-labels-for-self-hosted-runner-for-repo

        PUT /repos/{owner}/{repo}/actions/runners/{runner_id}/labels

        Remove all previous custom labels and set the new custom labels for a specific
        self-hosted runner configured in a repository.

        Authenticated users must have admin access to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#set-custom-labels-for-a-self-hosted-runner-for-a-repository
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        labels: list[str],
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    async def async_set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """actions/set-custom-labels-for-self-hosted-runner-for-repo

        PUT /repos/{owner}/{repo}/actions/runners/{runner_id}/labels

        Remove all previous custom labels and set the new custom labels for a specific
        self-hosted runner configured in a repository.

        Authenticated users must have admin access to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#set-custom-labels-for-a-self-hosted-runner-for-a-repository
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    @overload
    def add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        labels: list[str],
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    def add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """actions/add-custom-labels-to-self-hosted-runner-for-repo

        POST /repos/{owner}/{repo}/actions/runners/{runner_id}/labels

        Adds custom labels to a self-hosted runner configured in a repository.

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#add-custom-labels-to-a-self-hosted-runner-for-a-repository
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        labels: list[str],
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    async def async_add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """actions/add-custom-labels-to-self-hosted-runner-for-repo

        POST /repos/{owner}/{repo}/actions/runners/{runner_id}/labels

        Adds custom labels to a self-hosted runner configured in a repository.

        Authenticated users must have admin access to the organization to use this endpoint.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#add-custom-labels-to-a-self-hosted-runner-for-a-repository
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def remove_all_custom_labels_from_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200Type,
    ]:
        """actions/remove-all-custom-labels-from-self-hosted-runner-for-repo

        DELETE /repos/{owner}/{repo}/actions/runners/{runner_id}/labels

        Remove all custom labels from a self-hosted runner configured in a
        repository. Returns the remaining read-only labels from the runner.

        Authenticated users must have admin access to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-all-custom-labels-from-a-self-hosted-runner-for-a-repository
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_remove_all_custom_labels_from_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200Type,
    ]:
        """actions/remove-all-custom-labels-from-self-hosted-runner-for-repo

        DELETE /repos/{owner}/{repo}/actions/runners/{runner_id}/labels

        Remove all custom labels from a self-hosted runner configured in a
        repository. Returns the remaining read-only labels from the runner.

        Authenticated users must have admin access to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-all-custom-labels-from-a-self-hosted-runner-for-a-repository
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def remove_custom_label_from_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """actions/remove-custom-label-from-self-hosted-runner-for-repo

        DELETE /repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}

        Remove a custom label from a self-hosted runner configured
        in a repository. Returns the remaining labels from the runner.

        This endpoint returns a `404 Not Found` status if the custom label is not
        present on the runner.

        Authenticated users must have admin access to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-a-custom-label-from-a-self-hosted-runner-for-a-repository
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_remove_custom_label_from_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """actions/remove-custom-label-from-self-hosted-runner-for-repo

        DELETE /repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}

        Remove a custom label from a self-hosted runner configured
        in a repository. Returns the remaining labels from the runner.

        This endpoint returns a `404 Not Found` status if the custom label is not
        present on the runner.

        Authenticated users must have admin access to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-a-custom-label-from-a-self-hosted-runner-for-a-repository
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_workflow_runs_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        actor: Missing[str] = UNSET,
        branch: Missing[str] = UNSET,
        event: Missing[str] = UNSET,
        status: Missing[
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
                "pending",
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        created: Missing[str] = UNSET,
        exclude_pull_requests: Missing[bool] = UNSET,
        check_suite_id: Missing[int] = UNSET,
        head_sha: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsRunsGetResponse200,
        ReposOwnerRepoActionsRunsGetResponse200Type,
    ]:
        """actions/list-workflow-runs-for-repo

        GET /repos/{owner}/{repo}/actions/runs

        Lists all workflow runs for a repository. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-rest-api#parameters).

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        This endpoint will return up to 1,000 results for each search when using the following parameters: `actor`, `branch`, `check_suite_id`, `created`, `event`, `head_sha`, `status`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#list-workflow-runs-for-a-repository
        """

        from ..models import ReposOwnerRepoActionsRunsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
            "head_sha": head_sha,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsRunsGetResponse200,
        )

    async def async_list_workflow_runs_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        actor: Missing[str] = UNSET,
        branch: Missing[str] = UNSET,
        event: Missing[str] = UNSET,
        status: Missing[
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
                "pending",
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        created: Missing[str] = UNSET,
        exclude_pull_requests: Missing[bool] = UNSET,
        check_suite_id: Missing[int] = UNSET,
        head_sha: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsRunsGetResponse200,
        ReposOwnerRepoActionsRunsGetResponse200Type,
    ]:
        """actions/list-workflow-runs-for-repo

        GET /repos/{owner}/{repo}/actions/runs

        Lists all workflow runs for a repository. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-rest-api#parameters).

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        This endpoint will return up to 1,000 results for each search when using the following parameters: `actor`, `branch`, `check_suite_id`, `created`, `event`, `head_sha`, `status`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#list-workflow-runs-for-a-repository
        """

        from ..models import ReposOwnerRepoActionsRunsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
            "head_sha": head_sha,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsRunsGetResponse200,
        )

    def get_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        exclude_pull_requests: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[WorkflowRun, WorkflowRunType]:
        """actions/get-workflow-run

        GET /repos/{owner}/{repo}/actions/runs/{run_id}

        Gets a specific workflow run.

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#get-a-workflow-run
        """

        from ..models import WorkflowRun

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}"

        params = {
            "exclude_pull_requests": exclude_pull_requests,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=WorkflowRun,
        )

    async def async_get_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        exclude_pull_requests: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[WorkflowRun, WorkflowRunType]:
        """actions/get-workflow-run

        GET /repos/{owner}/{repo}/actions/runs/{run_id}

        Gets a specific workflow run.

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#get-a-workflow-run
        """

        from ..models import WorkflowRun

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}"

        params = {
            "exclude_pull_requests": exclude_pull_requests,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=WorkflowRun,
        )

    def delete_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-workflow-run

        DELETE /repos/{owner}/{repo}/actions/runs/{run_id}

        Deletes a specific workflow run.

        Anyone with write access to the repository can use this endpoint.

        If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#delete-a-workflow-run
        """

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-workflow-run

        DELETE /repos/{owner}/{repo}/actions/runs/{run_id}

        Deletes a specific workflow run.

        Anyone with write access to the repository can use this endpoint.

        If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#delete-a-workflow-run
        """

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def get_reviews_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[EnvironmentApprovals], list[EnvironmentApprovalsType]]:
        """actions/get-reviews-for-run

        GET /repos/{owner}/{repo}/actions/runs/{run_id}/approvals

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#get-the-review-history-for-a-workflow-run
        """

        from ..models import EnvironmentApprovals

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/approvals"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[EnvironmentApprovals],
        )

    async def async_get_reviews_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[EnvironmentApprovals], list[EnvironmentApprovalsType]]:
        """actions/get-reviews-for-run

        GET /repos/{owner}/{repo}/actions/runs/{run_id}/approvals

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#get-the-review-history-for-a-workflow-run
        """

        from ..models import EnvironmentApprovals

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/approvals"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[EnvironmentApprovals],
        )

    def approve_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/approve-workflow-run

        POST /repos/{owner}/{repo}/actions/runs/{run_id}/approve

        Approves a workflow run for a pull request from a public fork of a first time contributor. For more information, see ["Approving workflow runs from public forks](https://docs.github.com/enterprise-cloud@latest//actions/managing-workflow-runs/approving-workflow-runs-from-public-forks)."

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#approve-a-workflow-run-for-a-fork-pull-request
        """

        from ..models import BasicError, EmptyObject

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/approve"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_approve_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/approve-workflow-run

        POST /repos/{owner}/{repo}/actions/runs/{run_id}/approve

        Approves a workflow run for a pull request from a public fork of a first time contributor. For more information, see ["Approving workflow runs from public forks](https://docs.github.com/enterprise-cloud@latest//actions/managing-workflow-runs/approving-workflow-runs-from-public-forks)."

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#approve-a-workflow-run-for-a-fork-pull-request
        """

        from ..models import BasicError, EmptyObject

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/approve"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_workflow_run_artifacts(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        name: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200,
        ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200Type,
    ]:
        """actions/list-workflow-run-artifacts

        GET /repos/{owner}/{repo}/actions/runs/{run_id}/artifacts

        Lists artifacts for a workflow run.

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/artifacts#list-workflow-run-artifacts
        """

        from ..models import ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/artifacts"

        params = {
            "per_page": per_page,
            "page": page,
            "name": name,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200,
        )

    async def async_list_workflow_run_artifacts(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        name: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200,
        ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200Type,
    ]:
        """actions/list-workflow-run-artifacts

        GET /repos/{owner}/{repo}/actions/runs/{run_id}/artifacts

        Lists artifacts for a workflow run.

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/artifacts#list-workflow-run-artifacts
        """

        from ..models import ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/artifacts"

        params = {
            "per_page": per_page,
            "page": page,
            "name": name,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200,
        )

    def get_workflow_run_attempt(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        *,
        exclude_pull_requests: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[WorkflowRun, WorkflowRunType]:
        """actions/get-workflow-run-attempt

        GET /repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}

        Gets a specific workflow run attempt.

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#get-a-workflow-run-attempt
        """

        from ..models import WorkflowRun

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}"

        params = {
            "exclude_pull_requests": exclude_pull_requests,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=WorkflowRun,
        )

    async def async_get_workflow_run_attempt(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        *,
        exclude_pull_requests: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[WorkflowRun, WorkflowRunType]:
        """actions/get-workflow-run-attempt

        GET /repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}

        Gets a specific workflow run attempt.

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#get-a-workflow-run-attempt
        """

        from ..models import WorkflowRun

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}"

        params = {
            "exclude_pull_requests": exclude_pull_requests,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=WorkflowRun,
        )

    def list_jobs_for_workflow_run_attempt(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
        ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200Type,
    ]:
        """actions/list-jobs-for-workflow-run-attempt

        GET /repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs

        Lists jobs for a specific workflow run attempt. You can use parameters to narrow the list of results. For more information
        about using parameters, see [Parameters](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-rest-api#parameters).

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint  with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-jobs#list-jobs-for-a-workflow-run-attempt
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_jobs_for_workflow_run_attempt(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
        ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200Type,
    ]:
        """actions/list-jobs-for-workflow-run-attempt

        GET /repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs

        Lists jobs for a specific workflow run attempt. You can use parameters to narrow the list of results. For more information
        about using parameters, see [Parameters](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-rest-api#parameters).

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint  with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-jobs#list-jobs-for-a-workflow-run-attempt
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def download_workflow_run_attempt_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/download-workflow-run-attempt-logs

        GET /repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs

        Gets a redirect URL to download an archive of log files for a specific workflow run attempt. This link expires after
        1 minute. Look for `Location:` in the response header to find the URL for the download.

        Anyone with read access to the repository can use this endpoint.

        If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#download-workflow-run-attempt-logs
        """

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_download_workflow_run_attempt_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/download-workflow-run-attempt-logs

        GET /repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs

        Gets a redirect URL to download an archive of log files for a specific workflow run attempt. This link expires after
        1 minute. Look for `Location:` in the response header to find the URL for the download.

        Anyone with read access to the repository can use this endpoint.

        If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#download-workflow-run-attempt-logs
        """

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def cancel_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/cancel-workflow-run

        POST /repos/{owner}/{repo}/actions/runs/{run_id}/cancel

        Cancels a workflow run using its `id`.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#cancel-a-workflow-run
        """

        from ..models import BasicError, EmptyObject

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/cancel"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
            error_models={
                "409": BasicError,
            },
        )

    async def async_cancel_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/cancel-workflow-run

        POST /repos/{owner}/{repo}/actions/runs/{run_id}/cancel

        Cancels a workflow run using its `id`.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#cancel-a-workflow-run
        """

        from ..models import BasicError, EmptyObject

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/cancel"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
            error_models={
                "409": BasicError,
            },
        )

    @overload
    def review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            ReviewCustomGatesCommentRequiredType, ReviewCustomGatesStateRequiredType
        ],
    ) -> Response: ...

    @overload
    def review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        environment_name: str,
        comment: str,
    ) -> Response: ...

    @overload
    def review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        environment_name: str,
        state: Literal["approved", "rejected"],
        comment: Missing[str] = UNSET,
    ) -> Response: ...

    def review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReviewCustomGatesCommentRequiredType, ReviewCustomGatesStateRequiredType
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/review-custom-gates-for-run

        POST /repos/{owner}/{repo}/actions/runs/{run_id}/deployment_protection_rule

        Approve or reject custom deployment protection rules provided by a GitHub App for a workflow run. For more information, see "[Using environments for deployment](https://docs.github.com/enterprise-cloud@latest//actions/deployment/targeting-different-environments/using-environments-for-deployment)."

        > [!NOTE]
        > GitHub Apps can only review their own custom deployment protection rules. To approve or reject pending deployments that are waiting for review from a specific person or team, see [`POST /repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments`](/rest/actions/workflow-runs#review-pending-deployments-for-a-workflow-run).

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#review-custom-deployment-protection-rules-for-a-workflow-run
        """

        from typing import Union

        from ..models import (
            ReviewCustomGatesCommentRequired,
            ReviewCustomGatesStateRequired,
        )

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/deployment_protection_rule"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReviewCustomGatesCommentRequired, ReviewCustomGatesStateRequired],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            ReviewCustomGatesCommentRequiredType, ReviewCustomGatesStateRequiredType
        ],
    ) -> Response: ...

    @overload
    async def async_review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        environment_name: str,
        comment: str,
    ) -> Response: ...

    @overload
    async def async_review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        environment_name: str,
        state: Literal["approved", "rejected"],
        comment: Missing[str] = UNSET,
    ) -> Response: ...

    async def async_review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReviewCustomGatesCommentRequiredType, ReviewCustomGatesStateRequiredType
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/review-custom-gates-for-run

        POST /repos/{owner}/{repo}/actions/runs/{run_id}/deployment_protection_rule

        Approve or reject custom deployment protection rules provided by a GitHub App for a workflow run. For more information, see "[Using environments for deployment](https://docs.github.com/enterprise-cloud@latest//actions/deployment/targeting-different-environments/using-environments-for-deployment)."

        > [!NOTE]
        > GitHub Apps can only review their own custom deployment protection rules. To approve or reject pending deployments that are waiting for review from a specific person or team, see [`POST /repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments`](/rest/actions/workflow-runs#review-pending-deployments-for-a-workflow-run).

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#review-custom-deployment-protection-rules-for-a-workflow-run
        """

        from typing import Union

        from ..models import (
            ReviewCustomGatesCommentRequired,
            ReviewCustomGatesStateRequired,
        )

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/deployment_protection_rule"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReviewCustomGatesCommentRequired, ReviewCustomGatesStateRequired],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def force_cancel_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/force-cancel-workflow-run

        POST /repos/{owner}/{repo}/actions/runs/{run_id}/force-cancel

        Cancels a workflow run and bypasses conditions that would otherwise cause a workflow execution to continue, such as an `always()` condition on a job.
        You should only use this endpoint to cancel a workflow run when the workflow run is not responding to [`POST /repos/{owner}/{repo}/actions/runs/{run_id}/cancel`](/rest/actions/workflow-runs#cancel-a-workflow-run).

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#force-cancel-a-workflow-run
        """

        from ..models import BasicError, EmptyObject

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/force-cancel"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
            error_models={
                "409": BasicError,
            },
        )

    async def async_force_cancel_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/force-cancel-workflow-run

        POST /repos/{owner}/{repo}/actions/runs/{run_id}/force-cancel

        Cancels a workflow run and bypasses conditions that would otherwise cause a workflow execution to continue, such as an `always()` condition on a job.
        You should only use this endpoint to cancel a workflow run when the workflow run is not responding to [`POST /repos/{owner}/{repo}/actions/runs/{run_id}/cancel`](/rest/actions/workflow-runs#cancel-a-workflow-run).

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#force-cancel-a-workflow-run
        """

        from ..models import BasicError, EmptyObject

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/force-cancel"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
            error_models={
                "409": BasicError,
            },
        )

    def list_jobs_for_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        filter_: Missing[Literal["latest", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsRunsRunIdJobsGetResponse200,
        ReposOwnerRepoActionsRunsRunIdJobsGetResponse200Type,
    ]:
        """actions/list-jobs-for-workflow-run

        GET /repos/{owner}/{repo}/actions/runs/{run_id}/jobs

        Lists jobs for a workflow run. You can use parameters to narrow the list of results. For more information
        about using parameters, see [Parameters](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-rest-api#parameters).

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-jobs#list-jobs-for-a-workflow-run
        """

        from ..models import ReposOwnerRepoActionsRunsRunIdJobsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/jobs"

        params = {
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsRunsRunIdJobsGetResponse200,
        )

    async def async_list_jobs_for_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        filter_: Missing[Literal["latest", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsRunsRunIdJobsGetResponse200,
        ReposOwnerRepoActionsRunsRunIdJobsGetResponse200Type,
    ]:
        """actions/list-jobs-for-workflow-run

        GET /repos/{owner}/{repo}/actions/runs/{run_id}/jobs

        Lists jobs for a workflow run. You can use parameters to narrow the list of results. For more information
        about using parameters, see [Parameters](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-rest-api#parameters).

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-jobs#list-jobs-for-a-workflow-run
        """

        from ..models import ReposOwnerRepoActionsRunsRunIdJobsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/jobs"

        params = {
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsRunsRunIdJobsGetResponse200,
        )

    def download_workflow_run_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/download-workflow-run-logs

        GET /repos/{owner}/{repo}/actions/runs/{run_id}/logs

        Gets a redirect URL to download an archive of log files for a workflow run. This link expires after 1 minute. Look for
        `Location:` in the response header to find the URL for the download.

        Anyone with read access to the repository can use this endpoint.

        If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#download-workflow-run-logs
        """

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_download_workflow_run_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/download-workflow-run-logs

        GET /repos/{owner}/{repo}/actions/runs/{run_id}/logs

        Gets a redirect URL to download an archive of log files for a workflow run. This link expires after 1 minute. Look for
        `Location:` in the response header to find the URL for the download.

        Anyone with read access to the repository can use this endpoint.

        If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#download-workflow-run-logs
        """

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def delete_workflow_run_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-workflow-run-logs

        DELETE /repos/{owner}/{repo}/actions/runs/{run_id}/logs

        Deletes all logs for a workflow run.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#delete-workflow-run-logs
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "500": BasicError,
            },
        )

    async def async_delete_workflow_run_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-workflow-run-logs

        DELETE /repos/{owner}/{repo}/actions/runs/{run_id}/logs

        Deletes all logs for a workflow run.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#delete-workflow-run-logs
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "500": BasicError,
            },
        )

    def get_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[PendingDeployment], list[PendingDeploymentType]]:
        """actions/get-pending-deployments-for-run

        GET /repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments

        Get all deployment environments for a workflow run that are waiting for protection rules to pass.

        Anyone with read access to the repository can use this endpoint.

        If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#get-pending-deployments-for-a-workflow-run
        """

        from ..models import PendingDeployment

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[PendingDeployment],
        )

    async def async_get_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[PendingDeployment], list[PendingDeploymentType]]:
        """actions/get-pending-deployments-for-run

        GET /repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments

        Get all deployment environments for a workflow run that are waiting for protection rules to pass.

        Anyone with read access to the repository can use this endpoint.

        If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#get-pending-deployments-for-a-workflow-run
        """

        from ..models import PendingDeployment

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[PendingDeployment],
        )

    @overload
    def review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType,
    ) -> Response[list[Deployment], list[DeploymentType]]: ...

    @overload
    def review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        environment_ids: list[int],
        state: Literal["approved", "rejected"],
        comment: str,
    ) -> Response[list[Deployment], list[DeploymentType]]: ...

    def review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Deployment], list[DeploymentType]]:
        """actions/review-pending-deployments-for-run

        POST /repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments

        Approve or reject pending deployments that are waiting on approval by a required reviewer.

        Required reviewers with read access to the repository contents and deployments can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#review-pending-deployments-for-a-workflow-run
        """

        from ..models import (
            Deployment,
            ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody,
        )

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Deployment],
        )

    @overload
    async def async_review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType,
    ) -> Response[list[Deployment], list[DeploymentType]]: ...

    @overload
    async def async_review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        environment_ids: list[int],
        state: Literal["approved", "rejected"],
        comment: str,
    ) -> Response[list[Deployment], list[DeploymentType]]: ...

    async def async_review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Deployment], list[DeploymentType]]:
        """actions/review-pending-deployments-for-run

        POST /repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments

        Approve or reject pending deployments that are waiting on approval by a required reviewer.

        Required reviewers with read access to the repository contents and deployments can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#review-pending-deployments-for-a-workflow-run
        """

        from ..models import (
            Deployment,
            ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody,
        )

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Deployment],
        )

    @overload
    def re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunPostBodyType, None]
        ] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    def re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        enable_debug_logging: Missing[bool] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    def re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/re-run-workflow

        POST /repos/{owner}/{repo}/actions/runs/{run_id}/rerun

        Re-runs your workflow run using its `id`.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#re-run-a-workflow
        """

        from typing import Union

        from ..models import EmptyObject, ReposOwnerRepoActionsRunsRunIdRerunPostBody

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/rerun"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoActionsRunsRunIdRerunPostBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    @overload
    async def async_re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunPostBodyType, None]
        ] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    async def async_re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        enable_debug_logging: Missing[bool] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    async def async_re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/re-run-workflow

        POST /repos/{owner}/{repo}/actions/runs/{run_id}/rerun

        Re-runs your workflow run using its `id`.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#re-run-a-workflow
        """

        from typing import Union

        from ..models import EmptyObject, ReposOwnerRepoActionsRunsRunIdRerunPostBody

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/rerun"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoActionsRunsRunIdRerunPostBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    @overload
    def re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType, None]
        ] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    def re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        enable_debug_logging: Missing[bool] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    def re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/re-run-workflow-failed-jobs

        POST /repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs

        Re-run all of the failed jobs and their dependent jobs in a workflow run using the `id` of the workflow run.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#re-run-failed-jobs-from-a-workflow-run
        """

        from typing import Union

        from ..models import (
            EmptyObject,
            ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBody,
        )

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    @overload
    async def async_re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType, None]
        ] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    async def async_re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        enable_debug_logging: Missing[bool] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    async def async_re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/re-run-workflow-failed-jobs

        POST /repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs

        Re-run all of the failed jobs and their dependent jobs in a workflow run using the `id` of the workflow run.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#re-run-failed-jobs-from-a-workflow-run
        """

        from typing import Union

        from ..models import (
            EmptyObject,
            ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBody,
        )

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    def get_workflow_run_usage(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[WorkflowRunUsage, WorkflowRunUsageType]:
        """actions/get-workflow-run-usage

        GET /repos/{owner}/{repo}/actions/runs/{run_id}/timing

        > [!WARNING]
        > This endpoint is in the process of closing down. Refer to "[Actions Get workflow usage and Get workflow run usage endpoints closing down](https://github.blog/changelog/2025-02-02-actions-get-workflow-usage-and-get-workflow-run-usage-endpoints-closing-down/)" for more information.

        Gets the number of billable minutes and total run time for a specific workflow run. Billable minutes only apply to workflows in private repositories that use GitHub Enterprise Cloud-hosted runners. Usage is listed for each GitHub Enterprise Cloud-hosted runner operating system in milliseconds. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#get-workflow-run-usage
        """

        from ..models import WorkflowRunUsage

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/timing"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=WorkflowRunUsage,
        )

    async def async_get_workflow_run_usage(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[WorkflowRunUsage, WorkflowRunUsageType]:
        """actions/get-workflow-run-usage

        GET /repos/{owner}/{repo}/actions/runs/{run_id}/timing

        > [!WARNING]
        > This endpoint is in the process of closing down. Refer to "[Actions Get workflow usage and Get workflow run usage endpoints closing down](https://github.blog/changelog/2025-02-02-actions-get-workflow-usage-and-get-workflow-run-usage-endpoints-closing-down/)" for more information.

        Gets the number of billable minutes and total run time for a specific workflow run. Billable minutes only apply to workflows in private repositories that use GitHub Enterprise Cloud-hosted runners. Usage is listed for each GitHub Enterprise Cloud-hosted runner operating system in milliseconds. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#get-workflow-run-usage
        """

        from ..models import WorkflowRunUsage

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/timing"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=WorkflowRunUsage,
        )

    def list_repo_secrets(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsSecretsGetResponse200,
        ReposOwnerRepoActionsSecretsGetResponse200Type,
    ]:
        """actions/list-repo-secrets

        GET /repos/{owner}/{repo}/actions/secrets

        Lists all secrets available in a repository without revealing their encrypted
        values.

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#list-repository-secrets
        """

        from ..models import ReposOwnerRepoActionsSecretsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsSecretsGetResponse200,
        )

    async def async_list_repo_secrets(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsSecretsGetResponse200,
        ReposOwnerRepoActionsSecretsGetResponse200Type,
    ]:
        """actions/list-repo-secrets

        GET /repos/{owner}/{repo}/actions/secrets

        Lists all secrets available in a repository without revealing their encrypted
        values.

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#list-repository-secrets
        """

        from ..models import ReposOwnerRepoActionsSecretsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsSecretsGetResponse200,
        )

    def get_repo_public_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsPublicKey, ActionsPublicKeyType]:
        """actions/get-repo-public-key

        GET /repos/{owner}/{repo}/actions/secrets/public-key

        Gets your public key, which you need to encrypt secrets. You need to
        encrypt a secret before you can create or update secrets.

        Anyone with read access to the repository can use this endpoint.

        If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-a-repository-public-key
        """

        from ..models import ActionsPublicKey

        url = f"/repos/{owner}/{repo}/actions/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsPublicKey,
        )

    async def async_get_repo_public_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsPublicKey, ActionsPublicKeyType]:
        """actions/get-repo-public-key

        GET /repos/{owner}/{repo}/actions/secrets/public-key

        Gets your public key, which you need to encrypt secrets. You need to
        encrypt a secret before you can create or update secrets.

        Anyone with read access to the repository can use this endpoint.

        If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-a-repository-public-key
        """

        from ..models import ActionsPublicKey

        url = f"/repos/{owner}/{repo}/actions/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsPublicKey,
        )

    def get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsSecret, ActionsSecretType]:
        """actions/get-repo-secret

        GET /repos/{owner}/{repo}/actions/secrets/{secret_name}

        Gets a single repository secret without revealing its encrypted value.

        The authenticated user must have collaborator access to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-a-repository-secret
        """

        from ..models import ActionsSecret

        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsSecret,
        )

    async def async_get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsSecret, ActionsSecretType]:
        """actions/get-repo-secret

        GET /repos/{owner}/{repo}/actions/secrets/{secret_name}

        Gets a single repository secret without revealing its encrypted value.

        The authenticated user must have collaborator access to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-a-repository-secret
        """

        from ..models import ActionsSecret

        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsSecret,
        )

    @overload
    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoActionsSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        encrypted_value: str,
        key_id: str,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoActionsSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/create-or-update-repo-secret

        PUT /repos/{owner}/{repo}/actions/secrets/{secret_name}

        Creates or updates a repository secret with an encrypted value. Encrypt your secret using
        [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/enterprise-cloud@latest//rest/guides/encrypting-secrets-for-the-rest-api)."

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#create-or-update-a-repository-secret
        """

        from ..models import EmptyObject, ReposOwnerRepoActionsSecretsSecretNamePutBody

        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsSecretsSecretNamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    @overload
    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoActionsSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        encrypted_value: str,
        key_id: str,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoActionsSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/create-or-update-repo-secret

        PUT /repos/{owner}/{repo}/actions/secrets/{secret_name}

        Creates or updates a repository secret with an encrypted value. Encrypt your secret using
        [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/enterprise-cloud@latest//rest/guides/encrypting-secrets-for-the-rest-api)."

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#create-or-update-a-repository-secret
        """

        from ..models import EmptyObject, ReposOwnerRepoActionsSecretsSecretNamePutBody

        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsSecretsSecretNamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    def delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-repo-secret

        DELETE /repos/{owner}/{repo}/actions/secrets/{secret_name}

        Deletes a secret in a repository using the secret name.

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#delete-a-repository-secret
        """

        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-repo-secret

        DELETE /repos/{owner}/{repo}/actions/secrets/{secret_name}

        Deletes a secret in a repository using the secret name.

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#delete-a-repository-secret
        """

        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_repo_variables(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsVariablesGetResponse200,
        ReposOwnerRepoActionsVariablesGetResponse200Type,
    ]:
        """actions/list-repo-variables

        GET /repos/{owner}/{repo}/actions/variables

        Lists all repository variables.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#list-repository-variables
        """

        from ..models import ReposOwnerRepoActionsVariablesGetResponse200

        url = f"/repos/{owner}/{repo}/actions/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsVariablesGetResponse200,
        )

    async def async_list_repo_variables(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsVariablesGetResponse200,
        ReposOwnerRepoActionsVariablesGetResponse200Type,
    ]:
        """actions/list-repo-variables

        GET /repos/{owner}/{repo}/actions/variables

        Lists all repository variables.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#list-repository-variables
        """

        from ..models import ReposOwnerRepoActionsVariablesGetResponse200

        url = f"/repos/{owner}/{repo}/actions/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsVariablesGetResponse200,
        )

    @overload
    def create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoActionsVariablesPostBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    def create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        value: str,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    def create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoActionsVariablesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/create-repo-variable

        POST /repos/{owner}/{repo}/actions/variables

        Creates a repository variable that you can reference in a GitHub Actions workflow.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#create-a-repository-variable
        """

        from ..models import EmptyObject, ReposOwnerRepoActionsVariablesPostBody

        url = f"/repos/{owner}/{repo}/actions/variables"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoActionsVariablesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    @overload
    async def async_create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoActionsVariablesPostBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    async def async_create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        value: str,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    async def async_create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoActionsVariablesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/create-repo-variable

        POST /repos/{owner}/{repo}/actions/variables

        Creates a repository variable that you can reference in a GitHub Actions workflow.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#create-a-repository-variable
        """

        from ..models import EmptyObject, ReposOwnerRepoActionsVariablesPostBody

        url = f"/repos/{owner}/{repo}/actions/variables"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoActionsVariablesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    def get_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsVariable, ActionsVariableType]:
        """actions/get-repo-variable

        GET /repos/{owner}/{repo}/actions/variables/{name}

        Gets a specific variable in a repository.

        The authenticated user must have collaborator access to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#get-a-repository-variable
        """

        from ..models import ActionsVariable

        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsVariable,
        )

    async def async_get_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsVariable, ActionsVariableType]:
        """actions/get-repo-variable

        GET /repos/{owner}/{repo}/actions/variables/{name}

        Gets a specific variable in a repository.

        The authenticated user must have collaborator access to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#get-a-repository-variable
        """

        from ..models import ActionsVariable

        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsVariable,
        )

    def delete_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-repo-variable

        DELETE /repos/{owner}/{repo}/actions/variables/{name}

        Deletes a repository variable using the variable name.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#delete-a-repository-variable
        """

        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-repo-variable

        DELETE /repos/{owner}/{repo}/actions/variables/{name}

        Deletes a repository variable using the variable name.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#delete-a-repository-variable
        """

        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    def update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoActionsVariablesNamePatchBodyType,
    ) -> Response: ...

    @overload
    def update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        value: Missing[str] = UNSET,
    ) -> Response: ...

    def update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoActionsVariablesNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/update-repo-variable

        PATCH /repos/{owner}/{repo}/actions/variables/{name}

        Updates a repository variable that you can reference in a GitHub Actions workflow.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#update-a-repository-variable
        """

        from ..models import ReposOwnerRepoActionsVariablesNamePatchBody

        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsVariablesNamePatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoActionsVariablesNamePatchBodyType,
    ) -> Response: ...

    @overload
    async def async_update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        value: Missing[str] = UNSET,
    ) -> Response: ...

    async def async_update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoActionsVariablesNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/update-repo-variable

        PATCH /repos/{owner}/{repo}/actions/variables/{name}

        Updates a repository variable that you can reference in a GitHub Actions workflow.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#update-a-repository-variable
        """

        from ..models import ReposOwnerRepoActionsVariablesNamePatchBody

        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsVariablesNamePatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_repo_workflows(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsWorkflowsGetResponse200,
        ReposOwnerRepoActionsWorkflowsGetResponse200Type,
    ]:
        """actions/list-repo-workflows

        GET /repos/{owner}/{repo}/actions/workflows

        Lists the workflows in a repository.

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#list-repository-workflows
        """

        from ..models import ReposOwnerRepoActionsWorkflowsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/workflows"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsWorkflowsGetResponse200,
        )

    async def async_list_repo_workflows(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsWorkflowsGetResponse200,
        ReposOwnerRepoActionsWorkflowsGetResponse200Type,
    ]:
        """actions/list-repo-workflows

        GET /repos/{owner}/{repo}/actions/workflows

        Lists the workflows in a repository.

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#list-repository-workflows
        """

        from ..models import ReposOwnerRepoActionsWorkflowsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/workflows"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsWorkflowsGetResponse200,
        )

    def get_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Workflow, WorkflowType]:
        """actions/get-workflow

        GET /repos/{owner}/{repo}/actions/workflows/{workflow_id}

        Gets a specific workflow. You can replace `workflow_id` with the workflow
        file name. For example, you could use `main.yaml`.

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#get-a-workflow
        """

        from ..models import Workflow

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Workflow,
        )

    async def async_get_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Workflow, WorkflowType]:
        """actions/get-workflow

        GET /repos/{owner}/{repo}/actions/workflows/{workflow_id}

        Gets a specific workflow. You can replace `workflow_id` with the workflow
        file name. For example, you could use `main.yaml`.

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#get-a-workflow
        """

        from ..models import Workflow

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Workflow,
        )

    def disable_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/disable-workflow

        PUT /repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable

        Disables a workflow and sets the `state` of the workflow to `disabled_manually`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#disable-a-workflow
        """

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_disable_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/disable-workflow

        PUT /repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable

        Disables a workflow and sets the `state` of the workflow to `disabled_manually`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#disable-a-workflow
        """

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    def create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType,
    ) -> Response: ...

    @overload
    def create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        ref: str,
        inputs: Missing[
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputsType
        ] = UNSET,
    ) -> Response: ...

    def create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/create-workflow-dispatch

        POST /repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches

        You can use this endpoint to manually trigger a GitHub Actions workflow run. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.

        You must configure your GitHub Actions workflow to run when the [`workflow_dispatch` webhook](/developers/webhooks-and-events/webhook-events-and-payloads#workflow_dispatch) event occurs. The `inputs` are configured in the workflow file. For more information about how to configure the `workflow_dispatch` event in the workflow file, see "[Events that trigger workflows](/actions/reference/events-that-trigger-workflows#workflow_dispatch)."

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#create-a-workflow-dispatch-event
        """

        from ..models import ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType,
    ) -> Response: ...

    @overload
    async def async_create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        ref: str,
        inputs: Missing[
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputsType
        ] = UNSET,
    ) -> Response: ...

    async def async_create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/create-workflow-dispatch

        POST /repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches

        You can use this endpoint to manually trigger a GitHub Actions workflow run. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.

        You must configure your GitHub Actions workflow to run when the [`workflow_dispatch` webhook](/developers/webhooks-and-events/webhook-events-and-payloads#workflow_dispatch) event occurs. The `inputs` are configured in the workflow file. For more information about how to configure the `workflow_dispatch` event in the workflow file, see "[Events that trigger workflows](/actions/reference/events-that-trigger-workflows#workflow_dispatch)."

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#create-a-workflow-dispatch-event
        """

        from ..models import ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def enable_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/enable-workflow

        PUT /repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable

        Enables a workflow and sets the `state` of the workflow to `active`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#enable-a-workflow
        """

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_enable_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/enable-workflow

        PUT /repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable

        Enables a workflow and sets the `state` of the workflow to `active`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#enable-a-workflow
        """

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_workflow_runs(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        actor: Missing[str] = UNSET,
        branch: Missing[str] = UNSET,
        event: Missing[str] = UNSET,
        status: Missing[
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
                "pending",
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        created: Missing[str] = UNSET,
        exclude_pull_requests: Missing[bool] = UNSET,
        check_suite_id: Missing[int] = UNSET,
        head_sha: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200,
        ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200Type,
    ]:
        """actions/list-workflow-runs

        GET /repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs

        List all workflow runs for a workflow. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-rest-api#parameters).

        Anyone with read access to the repository can use this endpoint

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        This endpoint will return up to 1,000 results for each search when using the following parameters: `actor`, `branch`, `check_suite_id`, `created`, `event`, `head_sha`, `status`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#list-workflow-runs-for-a-workflow
        """

        from ..models import ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
            "head_sha": head_sha,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200,
        )

    async def async_list_workflow_runs(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        actor: Missing[str] = UNSET,
        branch: Missing[str] = UNSET,
        event: Missing[str] = UNSET,
        status: Missing[
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
                "pending",
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        created: Missing[str] = UNSET,
        exclude_pull_requests: Missing[bool] = UNSET,
        check_suite_id: Missing[int] = UNSET,
        head_sha: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200,
        ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200Type,
    ]:
        """actions/list-workflow-runs

        GET /repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs

        List all workflow runs for a workflow. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-rest-api#parameters).

        Anyone with read access to the repository can use this endpoint

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        This endpoint will return up to 1,000 results for each search when using the following parameters: `actor`, `branch`, `check_suite_id`, `created`, `event`, `head_sha`, `status`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#list-workflow-runs-for-a-workflow
        """

        from ..models import ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
            "head_sha": head_sha,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200,
        )

    def get_workflow_usage(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[WorkflowUsage, WorkflowUsageType]:
        """actions/get-workflow-usage

        GET /repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing

        > [!WARNING]
        > This endpoint is in the process of closing down. Refer to "[Actions Get workflow usage and Get workflow run usage endpoints closing down](https://github.blog/changelog/2025-02-02-actions-get-workflow-usage-and-get-workflow-run-usage-endpoints-closing-down/)" for more information.

        Gets the number of billable minutes used by a specific workflow during the current billing cycle. Billable minutes only apply to workflows in private repositories that use GitHub Enterprise Cloud-hosted runners. Usage is listed for each GitHub Enterprise Cloud-hosted runner operating system in milliseconds. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".

        You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#get-workflow-usage
        """

        from ..models import WorkflowUsage

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=WorkflowUsage,
        )

    async def async_get_workflow_usage(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[WorkflowUsage, WorkflowUsageType]:
        """actions/get-workflow-usage

        GET /repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing

        > [!WARNING]
        > This endpoint is in the process of closing down. Refer to "[Actions Get workflow usage and Get workflow run usage endpoints closing down](https://github.blog/changelog/2025-02-02-actions-get-workflow-usage-and-get-workflow-run-usage-endpoints-closing-down/)" for more information.

        Gets the number of billable minutes used by a specific workflow during the current billing cycle. Billable minutes only apply to workflows in private repositories that use GitHub Enterprise Cloud-hosted runners. Usage is listed for each GitHub Enterprise Cloud-hosted runner operating system in milliseconds. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".

        You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#get-workflow-usage
        """

        from ..models import WorkflowUsage

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=WorkflowUsage,
        )

    def list_environment_secrets(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameSecretsGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameSecretsGetResponse200Type,
    ]:
        """actions/list-environment-secrets

        GET /repos/{owner}/{repo}/environments/{environment_name}/secrets

        Lists all secrets available in an environment without revealing their
        encrypted values.

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#list-environment-secrets
        """

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameSecretsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameSecretsGetResponse200,
        )

    async def async_list_environment_secrets(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameSecretsGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameSecretsGetResponse200Type,
    ]:
        """actions/list-environment-secrets

        GET /repos/{owner}/{repo}/environments/{environment_name}/secrets

        Lists all secrets available in an environment without revealing their
        encrypted values.

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#list-environment-secrets
        """

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameSecretsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameSecretsGetResponse200,
        )

    def get_environment_public_key(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsPublicKey, ActionsPublicKeyType]:
        """actions/get-environment-public-key

        GET /repos/{owner}/{repo}/environments/{environment_name}/secrets/public-key

        Get the public key for an environment, which you need to encrypt environment
        secrets. You need to encrypt a secret before you can create or update secrets.

        Anyone with read access to the repository can use this endpoint.

        If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-an-environment-public-key
        """

        from ..models import ActionsPublicKey

        url = (
            f"/repos/{owner}/{repo}/environments/{environment_name}/secrets/public-key"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsPublicKey,
        )

    async def async_get_environment_public_key(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsPublicKey, ActionsPublicKeyType]:
        """actions/get-environment-public-key

        GET /repos/{owner}/{repo}/environments/{environment_name}/secrets/public-key

        Get the public key for an environment, which you need to encrypt environment
        secrets. You need to encrypt a secret before you can create or update secrets.

        Anyone with read access to the repository can use this endpoint.

        If the repository is private, OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-an-environment-public-key
        """

        from ..models import ActionsPublicKey

        url = (
            f"/repos/{owner}/{repo}/environments/{environment_name}/secrets/public-key"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsPublicKey,
        )

    def get_environment_secret(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsSecret, ActionsSecretType]:
        """actions/get-environment-secret

        GET /repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}

        Gets a single environment secret without revealing its encrypted value.

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-an-environment-secret
        """

        from ..models import ActionsSecret

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsSecret,
        )

    async def async_get_environment_secret(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsSecret, ActionsSecretType]:
        """actions/get-environment-secret

        GET /repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}

        Gets a single environment secret without revealing its encrypted value.

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-an-environment-secret
        """

        from ..models import ActionsSecret

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsSecret,
        )

    @overload
    def create_or_update_environment_secret(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    def create_or_update_environment_secret(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        encrypted_value: str,
        key_id: str,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    def create_or_update_environment_secret(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/create-or-update-environment-secret

        PUT /repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}

        Creates or updates an environment secret with an encrypted value. Encrypt your secret using
        [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/enterprise-cloud@latest//rest/guides/encrypting-secrets-for-the-rest-api)."

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#create-or-update-an-environment-secret
        """

        from ..models import (
            EmptyObject,
            ReposOwnerRepoEnvironmentsEnvironmentNameSecretsSecretNamePutBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoEnvironmentsEnvironmentNameSecretsSecretNamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    @overload
    async def async_create_or_update_environment_secret(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    async def async_create_or_update_environment_secret(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        encrypted_value: str,
        key_id: str,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    async def async_create_or_update_environment_secret(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/create-or-update-environment-secret

        PUT /repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}

        Creates or updates an environment secret with an encrypted value. Encrypt your secret using
        [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/enterprise-cloud@latest//rest/guides/encrypting-secrets-for-the-rest-api)."

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#create-or-update-an-environment-secret
        """

        from ..models import (
            EmptyObject,
            ReposOwnerRepoEnvironmentsEnvironmentNameSecretsSecretNamePutBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoEnvironmentsEnvironmentNameSecretsSecretNamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    def delete_environment_secret(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-environment-secret

        DELETE /repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}

        Deletes a secret in an environment using the secret name.

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#delete-an-environment-secret
        """

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_environment_secret(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-environment-secret

        DELETE /repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}

        Deletes a secret in an environment using the secret name.

        Authenticated users must have collaborator access to a repository to create, update, or read secrets.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#delete-an-environment-secret
        """

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_environment_variables(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameVariablesGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameVariablesGetResponse200Type,
    ]:
        """actions/list-environment-variables

        GET /repos/{owner}/{repo}/environments/{environment_name}/variables

        Lists all environment variables.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#list-environment-variables
        """

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameVariablesGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameVariablesGetResponse200,
        )

    async def async_list_environment_variables(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameVariablesGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameVariablesGetResponse200Type,
    ]:
        """actions/list-environment-variables

        GET /repos/{owner}/{repo}/environments/{environment_name}/variables

        Lists all environment variables.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#list-environment-variables
        """

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameVariablesGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameVariablesGetResponse200,
        )

    @overload
    def create_environment_variable(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoEnvironmentsEnvironmentNameVariablesPostBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    def create_environment_variable(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        value: str,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    def create_environment_variable(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoEnvironmentsEnvironmentNameVariablesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/create-environment-variable

        POST /repos/{owner}/{repo}/environments/{environment_name}/variables

        Create an environment variable that you can reference in a GitHub Actions workflow.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#create-an-environment-variable
        """

        from ..models import (
            EmptyObject,
            ReposOwnerRepoEnvironmentsEnvironmentNameVariablesPostBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/variables"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoEnvironmentsEnvironmentNameVariablesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    @overload
    async def async_create_environment_variable(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoEnvironmentsEnvironmentNameVariablesPostBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    async def async_create_environment_variable(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        value: str,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    async def async_create_environment_variable(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoEnvironmentsEnvironmentNameVariablesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """actions/create-environment-variable

        POST /repos/{owner}/{repo}/environments/{environment_name}/variables

        Create an environment variable that you can reference in a GitHub Actions workflow.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#create-an-environment-variable
        """

        from ..models import (
            EmptyObject,
            ReposOwnerRepoEnvironmentsEnvironmentNameVariablesPostBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/variables"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoEnvironmentsEnvironmentNameVariablesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    def get_environment_variable(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsVariable, ActionsVariableType]:
        """actions/get-environment-variable

        GET /repos/{owner}/{repo}/environments/{environment_name}/variables/{name}

        Gets a specific variable in an environment.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#get-an-environment-variable
        """

        from ..models import ActionsVariable

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsVariable,
        )

    async def async_get_environment_variable(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ActionsVariable, ActionsVariableType]:
        """actions/get-environment-variable

        GET /repos/{owner}/{repo}/environments/{environment_name}/variables/{name}

        Gets a specific variable in an environment.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#get-an-environment-variable
        """

        from ..models import ActionsVariable

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ActionsVariable,
        )

    def delete_environment_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-environment-variable

        DELETE /repos/{owner}/{repo}/environments/{environment_name}/variables/{name}

        Deletes an environment variable using the variable name.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#delete-an-environment-variable
        """

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_environment_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """actions/delete-environment-variable

        DELETE /repos/{owner}/{repo}/environments/{environment_name}/variables/{name}

        Deletes an environment variable using the variable name.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#delete-an-environment-variable
        """

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    def update_environment_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoEnvironmentsEnvironmentNameVariablesNamePatchBodyType,
    ) -> Response: ...

    @overload
    def update_environment_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        environment_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        value: Missing[str] = UNSET,
    ) -> Response: ...

    def update_environment_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoEnvironmentsEnvironmentNameVariablesNamePatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/update-environment-variable

        PATCH /repos/{owner}/{repo}/environments/{environment_name}/variables/{name}

        Updates an environment variable that you can reference in a GitHub Actions workflow.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#update-an-environment-variable
        """

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameVariablesNamePatchBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/variables/{name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoEnvironmentsEnvironmentNameVariablesNamePatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_update_environment_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoEnvironmentsEnvironmentNameVariablesNamePatchBodyType,
    ) -> Response: ...

    @overload
    async def async_update_environment_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        environment_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        value: Missing[str] = UNSET,
    ) -> Response: ...

    async def async_update_environment_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoEnvironmentsEnvironmentNameVariablesNamePatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """actions/update-environment-variable

        PATCH /repos/{owner}/{repo}/environments/{environment_name}/variables/{name}

        Updates an environment variable that you can reference in a GitHub Actions workflow.

        Authenticated users must have collaborator access to a repository to create, update, or read variables.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#update-an-environment-variable
        """

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameVariablesNamePatchBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/variables/{name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoEnvironmentsEnvironmentNameVariablesNamePatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )
