"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from datetime import datetime
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import CampaignSummary
    from ..types import (
        CampaignSummaryType,
        OrgsOrgCampaignsCampaignNumberPatchBodyType,
        OrgsOrgCampaignsPostBodyPropCodeScanningAlertsItemsType,
        OrgsOrgCampaignsPostBodyType,
    )


class CampaignsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_org_campaigns(
        self,
        org: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        state: Missing[Literal["open", "closed"]] = UNSET,
        sort: Missing[Literal["created", "updated", "ends_at", "published"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CampaignSummary], list[CampaignSummaryType]]:
        """campaigns/list-org-campaigns

        GET /orgs/{org}/campaigns

        Lists campaigns in an organization.

        The authenticated user must be an owner or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/campaigns/campaigns#list-campaigns-for-an-organization
        """

        from ..models import (
            BasicError,
            CampaignSummary,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/orgs/{org}/campaigns"

        params = {
            "page": page,
            "per_page": per_page,
            "direction": direction,
            "state": state,
            "sort": sort,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CampaignSummary],
            error_models={
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_list_org_campaigns(
        self,
        org: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        state: Missing[Literal["open", "closed"]] = UNSET,
        sort: Missing[Literal["created", "updated", "ends_at", "published"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CampaignSummary], list[CampaignSummaryType]]:
        """campaigns/list-org-campaigns

        GET /orgs/{org}/campaigns

        Lists campaigns in an organization.

        The authenticated user must be an owner or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/campaigns/campaigns#list-campaigns-for-an-organization
        """

        from ..models import (
            BasicError,
            CampaignSummary,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/orgs/{org}/campaigns"

        params = {
            "page": page,
            "per_page": per_page,
            "direction": direction,
            "state": state,
            "sort": sort,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CampaignSummary],
            error_models={
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def create_campaign(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCampaignsPostBodyType,
    ) -> Response[CampaignSummary, CampaignSummaryType]: ...

    @overload
    def create_campaign(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        description: str,
        managers: Missing[list[str]] = UNSET,
        team_managers: Missing[list[str]] = UNSET,
        ends_at: datetime,
        contact_link: Missing[Union[str, None]] = UNSET,
        code_scanning_alerts: list[
            OrgsOrgCampaignsPostBodyPropCodeScanningAlertsItemsType
        ],
        generate_issues: Missing[bool] = UNSET,
    ) -> Response[CampaignSummary, CampaignSummaryType]: ...

    def create_campaign(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgCampaignsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[CampaignSummary, CampaignSummaryType]:
        """campaigns/create-campaign

        POST /orgs/{org}/campaigns

        Create a campaign for an organization.

        The authenticated user must be an owner or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.

        Fine-grained tokens must have the "Code scanning alerts" repository permissions (read) on all repositories included
        in the campaign.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/campaigns/campaigns#create-a-campaign-for-an-organization
        """

        from ..models import (
            BasicError,
            CampaignSummary,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            OrgsOrgCampaignsPostBody,
        )

        url = f"/orgs/{org}/campaigns"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgCampaignsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CampaignSummary,
            error_models={
                "400": BasicError,
                "404": BasicError,
                "422": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_create_campaign(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCampaignsPostBodyType,
    ) -> Response[CampaignSummary, CampaignSummaryType]: ...

    @overload
    async def async_create_campaign(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        description: str,
        managers: Missing[list[str]] = UNSET,
        team_managers: Missing[list[str]] = UNSET,
        ends_at: datetime,
        contact_link: Missing[Union[str, None]] = UNSET,
        code_scanning_alerts: list[
            OrgsOrgCampaignsPostBodyPropCodeScanningAlertsItemsType
        ],
        generate_issues: Missing[bool] = UNSET,
    ) -> Response[CampaignSummary, CampaignSummaryType]: ...

    async def async_create_campaign(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgCampaignsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[CampaignSummary, CampaignSummaryType]:
        """campaigns/create-campaign

        POST /orgs/{org}/campaigns

        Create a campaign for an organization.

        The authenticated user must be an owner or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.

        Fine-grained tokens must have the "Code scanning alerts" repository permissions (read) on all repositories included
        in the campaign.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/campaigns/campaigns#create-a-campaign-for-an-organization
        """

        from ..models import (
            BasicError,
            CampaignSummary,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            OrgsOrgCampaignsPostBody,
        )

        url = f"/orgs/{org}/campaigns"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgCampaignsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CampaignSummary,
            error_models={
                "400": BasicError,
                "404": BasicError,
                "422": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_campaign_summary(
        self,
        org: str,
        campaign_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CampaignSummary, CampaignSummaryType]:
        """campaigns/get-campaign-summary

        GET /orgs/{org}/campaigns/{campaign_number}

        Gets a campaign for an organization.

        The authenticated user must be an owner or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/campaigns/campaigns#get-a-campaign-for-an-organization
        """

        from ..models import (
            BasicError,
            CampaignSummary,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/orgs/{org}/campaigns/{campaign_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CampaignSummary,
            error_models={
                "404": BasicError,
                "422": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_campaign_summary(
        self,
        org: str,
        campaign_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CampaignSummary, CampaignSummaryType]:
        """campaigns/get-campaign-summary

        GET /orgs/{org}/campaigns/{campaign_number}

        Gets a campaign for an organization.

        The authenticated user must be an owner or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/campaigns/campaigns#get-a-campaign-for-an-organization
        """

        from ..models import (
            BasicError,
            CampaignSummary,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/orgs/{org}/campaigns/{campaign_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CampaignSummary,
            error_models={
                "404": BasicError,
                "422": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def delete_campaign(
        self,
        org: str,
        campaign_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """campaigns/delete-campaign

        DELETE /orgs/{org}/campaigns/{campaign_number}

        Deletes a campaign in an organization.

        The authenticated user must be an owner or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/campaigns/campaigns#delete-a-campaign-for-an-organization
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/orgs/{org}/campaigns/{campaign_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_delete_campaign(
        self,
        org: str,
        campaign_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """campaigns/delete-campaign

        DELETE /orgs/{org}/campaigns/{campaign_number}

        Deletes a campaign in an organization.

        The authenticated user must be an owner or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/campaigns/campaigns#delete-a-campaign-for-an-organization
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/orgs/{org}/campaigns/{campaign_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def update_campaign(
        self,
        org: str,
        campaign_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCampaignsCampaignNumberPatchBodyType,
    ) -> Response[CampaignSummary, CampaignSummaryType]: ...

    @overload
    def update_campaign(
        self,
        org: str,
        campaign_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        managers: Missing[list[str]] = UNSET,
        team_managers: Missing[list[str]] = UNSET,
        ends_at: Missing[datetime] = UNSET,
        contact_link: Missing[Union[str, None]] = UNSET,
        state: Missing[Literal["open", "closed"]] = UNSET,
    ) -> Response[CampaignSummary, CampaignSummaryType]: ...

    def update_campaign(
        self,
        org: str,
        campaign_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgCampaignsCampaignNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[CampaignSummary, CampaignSummaryType]:
        """campaigns/update-campaign

        PATCH /orgs/{org}/campaigns/{campaign_number}

        Updates a campaign in an organization.

        The authenticated user must be an owner or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/campaigns/campaigns#update-a-campaign
        """

        from ..models import (
            BasicError,
            CampaignSummary,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            OrgsOrgCampaignsCampaignNumberPatchBody,
        )

        url = f"/orgs/{org}/campaigns/{campaign_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgCampaignsCampaignNumberPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CampaignSummary,
            error_models={
                "400": BasicError,
                "404": BasicError,
                "422": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_update_campaign(
        self,
        org: str,
        campaign_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCampaignsCampaignNumberPatchBodyType,
    ) -> Response[CampaignSummary, CampaignSummaryType]: ...

    @overload
    async def async_update_campaign(
        self,
        org: str,
        campaign_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        managers: Missing[list[str]] = UNSET,
        team_managers: Missing[list[str]] = UNSET,
        ends_at: Missing[datetime] = UNSET,
        contact_link: Missing[Union[str, None]] = UNSET,
        state: Missing[Literal["open", "closed"]] = UNSET,
    ) -> Response[CampaignSummary, CampaignSummaryType]: ...

    async def async_update_campaign(
        self,
        org: str,
        campaign_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgCampaignsCampaignNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[CampaignSummary, CampaignSummaryType]:
        """campaigns/update-campaign

        PATCH /orgs/{org}/campaigns/{campaign_number}

        Updates a campaign in an organization.

        The authenticated user must be an owner or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/campaigns/campaigns#update-a-campaign
        """

        from ..models import (
            BasicError,
            CampaignSummary,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            OrgsOrgCampaignsCampaignNumberPatchBody,
        )

        url = f"/orgs/{org}/campaigns/{campaign_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgCampaignsCampaignNumberPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CampaignSummary,
            error_models={
                "400": BasicError,
                "404": BasicError,
                "422": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )
