"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        Project,
        ProjectCard,
        ProjectCollaboratorPermission,
        ProjectColumn,
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201,
        SimpleUser,
    )
    from ..types import (
        OrgsOrgProjectsPostBodyType,
        ProjectCardType,
        ProjectCollaboratorPermissionType,
        ProjectColumnType,
        ProjectsColumnsCardsCardIdMovesPostBodyType,
        ProjectsColumnsCardsCardIdMovesPostResponse201Type,
        ProjectsColumnsCardsCardIdPatchBodyType,
        ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
        ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
        ProjectsColumnsColumnIdMovesPostBodyType,
        ProjectsColumnsColumnIdMovesPostResponse201Type,
        ProjectsColumnsColumnIdPatchBodyType,
        ProjectsProjectIdCollaboratorsUsernamePutBodyType,
        ProjectsProjectIdColumnsPostBodyType,
        ProjectsProjectIdPatchBodyType,
        ProjectType,
        ReposOwnerRepoProjectsPostBodyType,
        SimpleUserType,
        UserProjectsPostBodyType,
    )


class ProjectsClassicClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_for_org(
        self,
        org: str,
        *,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Project], list[ProjectType]]:
        """DEPRECATED projects-classic/list-for-org

        GET /orgs/{org}/projects

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/projects#list-organization-projects
        """

        from ..models import Project, ValidationErrorSimple

        url = f"/orgs/{org}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Project],
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_for_org(
        self,
        org: str,
        *,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Project], list[ProjectType]]:
        """DEPRECATED projects-classic/list-for-org

        GET /orgs/{org}/projects

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/projects#list-organization-projects
        """

        from ..models import Project, ValidationErrorSimple

        url = f"/orgs/{org}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Project],
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def create_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgProjectsPostBodyType,
    ) -> Response[Project, ProjectType]: ...

    @overload
    def create_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        body: Missing[str] = UNSET,
    ) -> Response[Project, ProjectType]: ...

    def create_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgProjectsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Project, ProjectType]:
        """DEPRECATED projects-classic/create-for-org

        POST /orgs/{org}/projects

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/projects#create-an-organization-project
        """

        from ..models import (
            BasicError,
            OrgsOrgProjectsPostBody,
            Project,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}/projects"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgProjectsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Project,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_create_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgProjectsPostBodyType,
    ) -> Response[Project, ProjectType]: ...

    @overload
    async def async_create_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        body: Missing[str] = UNSET,
    ) -> Response[Project, ProjectType]: ...

    async def async_create_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgProjectsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Project, ProjectType]:
        """DEPRECATED projects-classic/create-for-org

        POST /orgs/{org}/projects

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/projects#create-an-organization-project
        """

        from ..models import (
            BasicError,
            OrgsOrgProjectsPostBody,
            Project,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}/projects"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgProjectsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Project,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectCard, ProjectCardType]:
        """DEPRECATED projects-classic/get-card

        GET /projects/columns/cards/{card_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#get-a-project-card
        """

        from ..models import BasicError, ProjectCard

        url = f"/projects/columns/cards/{card_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectCard, ProjectCardType]:
        """DEPRECATED projects-classic/get-card

        GET /projects/columns/cards/{card_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#get-a-project-card
        """

        from ..models import BasicError, ProjectCard

        url = f"/projects/columns/cards/{card_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    def delete_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED projects-classic/delete-card

        DELETE /projects/columns/cards/{card_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#delete-a-project-card
        """

        from ..models import BasicError, ProjectsColumnsCardsCardIdDeleteResponse403

        url = f"/projects/columns/cards/{card_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": ProjectsColumnsCardsCardIdDeleteResponse403,
                "401": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED projects-classic/delete-card

        DELETE /projects/columns/cards/{card_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#delete-a-project-card
        """

        from ..models import BasicError, ProjectsColumnsCardsCardIdDeleteResponse403

        url = f"/projects/columns/cards/{card_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": ProjectsColumnsCardsCardIdDeleteResponse403,
                "401": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsCardsCardIdPatchBodyType] = UNSET,
    ) -> Response[ProjectCard, ProjectCardType]: ...

    @overload
    def update_card(
        self,
        card_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        note: Missing[Union[str, None]] = UNSET,
        archived: Missing[bool] = UNSET,
    ) -> Response[ProjectCard, ProjectCardType]: ...

    def update_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsCardsCardIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectCard, ProjectCardType]:
        """DEPRECATED projects-classic/update-card

        PATCH /projects/columns/cards/{card_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#update-an-existing-project-card
        """

        from ..models import (
            BasicError,
            ProjectCard,
            ProjectsColumnsCardsCardIdPatchBody,
            ValidationErrorSimple,
        )

        url = f"/projects/columns/cards/{card_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsCardsCardIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_update_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsCardsCardIdPatchBodyType] = UNSET,
    ) -> Response[ProjectCard, ProjectCardType]: ...

    @overload
    async def async_update_card(
        self,
        card_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        note: Missing[Union[str, None]] = UNSET,
        archived: Missing[bool] = UNSET,
    ) -> Response[ProjectCard, ProjectCardType]: ...

    async def async_update_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsCardsCardIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectCard, ProjectCardType]:
        """DEPRECATED projects-classic/update-card

        PATCH /projects/columns/cards/{card_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#update-an-existing-project-card
        """

        from ..models import (
            BasicError,
            ProjectCard,
            ProjectsColumnsCardsCardIdPatchBody,
            ValidationErrorSimple,
        )

        url = f"/projects/columns/cards/{card_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsCardsCardIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def move_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ProjectsColumnsCardsCardIdMovesPostBodyType,
    ) -> Response[
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsCardsCardIdMovesPostResponse201Type,
    ]: ...

    @overload
    def move_card(
        self,
        card_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        position: str,
        column_id: Missing[int] = UNSET,
    ) -> Response[
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsCardsCardIdMovesPostResponse201Type,
    ]: ...

    def move_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsCardsCardIdMovesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsCardsCardIdMovesPostResponse201Type,
    ]:
        """DEPRECATED projects-classic/move-card

        POST /projects/columns/cards/{card_id}/moves

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#move-a-project-card
        """

        from ..models import (
            BasicError,
            ProjectsColumnsCardsCardIdMovesPostBody,
            ProjectsColumnsCardsCardIdMovesPostResponse201,
            ProjectsColumnsCardsCardIdMovesPostResponse403,
            ProjectsColumnsCardsCardIdMovesPostResponse503,
            ValidationError,
        )

        url = f"/projects/columns/cards/{card_id}/moves"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsCardsCardIdMovesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsColumnsCardsCardIdMovesPostResponse201,
            error_models={
                "403": ProjectsColumnsCardsCardIdMovesPostResponse403,
                "401": BasicError,
                "503": ProjectsColumnsCardsCardIdMovesPostResponse503,
                "422": ValidationError,
            },
        )

    @overload
    async def async_move_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ProjectsColumnsCardsCardIdMovesPostBodyType,
    ) -> Response[
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsCardsCardIdMovesPostResponse201Type,
    ]: ...

    @overload
    async def async_move_card(
        self,
        card_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        position: str,
        column_id: Missing[int] = UNSET,
    ) -> Response[
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsCardsCardIdMovesPostResponse201Type,
    ]: ...

    async def async_move_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsCardsCardIdMovesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsCardsCardIdMovesPostResponse201Type,
    ]:
        """DEPRECATED projects-classic/move-card

        POST /projects/columns/cards/{card_id}/moves

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#move-a-project-card
        """

        from ..models import (
            BasicError,
            ProjectsColumnsCardsCardIdMovesPostBody,
            ProjectsColumnsCardsCardIdMovesPostResponse201,
            ProjectsColumnsCardsCardIdMovesPostResponse403,
            ProjectsColumnsCardsCardIdMovesPostResponse503,
            ValidationError,
        )

        url = f"/projects/columns/cards/{card_id}/moves"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsCardsCardIdMovesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsColumnsCardsCardIdMovesPostResponse201,
            error_models={
                "403": ProjectsColumnsCardsCardIdMovesPostResponse403,
                "401": BasicError,
                "503": ProjectsColumnsCardsCardIdMovesPostResponse503,
                "422": ValidationError,
            },
        )

    def get_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectColumn, ProjectColumnType]:
        """DEPRECATED projects-classic/get-column

        GET /projects/columns/{column_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/columns#get-a-project-column
        """

        from ..models import BasicError, ProjectColumn

        url = f"/projects/columns/{column_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectColumn, ProjectColumnType]:
        """DEPRECATED projects-classic/get-column

        GET /projects/columns/{column_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/columns#get-a-project-column
        """

        from ..models import BasicError, ProjectColumn

        url = f"/projects/columns/{column_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "401": BasicError,
            },
        )

    def delete_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED projects-classic/delete-column

        DELETE /projects/columns/{column_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/columns#delete-a-project-column
        """

        from ..models import BasicError

        url = f"/projects/columns/{column_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED projects-classic/delete-column

        DELETE /projects/columns/{column_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/columns#delete-a-project-column
        """

        from ..models import BasicError

        url = f"/projects/columns/{column_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def update_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ProjectsColumnsColumnIdPatchBodyType,
    ) -> Response[ProjectColumn, ProjectColumnType]: ...

    @overload
    def update_column(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
    ) -> Response[ProjectColumn, ProjectColumnType]: ...

    def update_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsColumnIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectColumn, ProjectColumnType]:
        """DEPRECATED projects-classic/update-column

        PATCH /projects/columns/{column_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/columns#update-an-existing-project-column
        """

        from ..models import BasicError, ProjectColumn, ProjectsColumnsColumnIdPatchBody

        url = f"/projects/columns/{column_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsColumnIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_update_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ProjectsColumnsColumnIdPatchBodyType,
    ) -> Response[ProjectColumn, ProjectColumnType]: ...

    @overload
    async def async_update_column(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
    ) -> Response[ProjectColumn, ProjectColumnType]: ...

    async def async_update_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsColumnIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectColumn, ProjectColumnType]:
        """DEPRECATED projects-classic/update-column

        PATCH /projects/columns/{column_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/columns#update-an-existing-project-column
        """

        from ..models import BasicError, ProjectColumn, ProjectsColumnsColumnIdPatchBody

        url = f"/projects/columns/{column_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsColumnIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_cards(
        self,
        column_id: int,
        *,
        archived_state: Missing[Literal["all", "archived", "not_archived"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectCard], list[ProjectCardType]]:
        """DEPRECATED projects-classic/list-cards

        GET /projects/columns/{column_id}/cards

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#list-project-cards
        """

        from ..models import BasicError, ProjectCard

        url = f"/projects/columns/{column_id}/cards"

        params = {
            "archived_state": archived_state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectCard],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_cards(
        self,
        column_id: int,
        *,
        archived_state: Missing[Literal["all", "archived", "not_archived"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectCard], list[ProjectCardType]]:
        """DEPRECATED projects-classic/list-cards

        GET /projects/columns/{column_id}/cards

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#list-project-cards
        """

        from ..models import BasicError, ProjectCard

        url = f"/projects/columns/{column_id}/cards"

        params = {
            "archived_state": archived_state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectCard],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_card(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
            ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
        ],
    ) -> Response[ProjectCard, ProjectCardType]: ...

    @overload
    def create_card(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        note: Union[str, None],
    ) -> Response[ProjectCard, ProjectCardType]: ...

    @overload
    def create_card(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content_id: int,
        content_type: str,
    ) -> Response[ProjectCard, ProjectCardType]: ...

    def create_card(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
                ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[ProjectCard, ProjectCardType]:
        """DEPRECATED projects-classic/create-card

        POST /projects/columns/{column_id}/cards

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#create-a-project-card
        """

        from typing import Union

        from ..models import (
            BasicError,
            ProjectCard,
            ProjectsColumnsColumnIdCardsPostBodyOneof0,
            ProjectsColumnsColumnIdCardsPostBodyOneof1,
            ProjectsColumnsColumnIdCardsPostResponse503,
            ValidationError,
            ValidationErrorSimple,
        )

        url = f"/projects/columns/{column_id}/cards"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ProjectsColumnsColumnIdCardsPostBodyOneof0,
                    ProjectsColumnsColumnIdCardsPostBodyOneof1,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": Union[ValidationError, ValidationErrorSimple],
                "503": ProjectsColumnsColumnIdCardsPostResponse503,
            },
        )

    @overload
    async def async_create_card(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
            ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
        ],
    ) -> Response[ProjectCard, ProjectCardType]: ...

    @overload
    async def async_create_card(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        note: Union[str, None],
    ) -> Response[ProjectCard, ProjectCardType]: ...

    @overload
    async def async_create_card(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content_id: int,
        content_type: str,
    ) -> Response[ProjectCard, ProjectCardType]: ...

    async def async_create_card(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
                ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[ProjectCard, ProjectCardType]:
        """DEPRECATED projects-classic/create-card

        POST /projects/columns/{column_id}/cards

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#create-a-project-card
        """

        from typing import Union

        from ..models import (
            BasicError,
            ProjectCard,
            ProjectsColumnsColumnIdCardsPostBodyOneof0,
            ProjectsColumnsColumnIdCardsPostBodyOneof1,
            ProjectsColumnsColumnIdCardsPostResponse503,
            ValidationError,
            ValidationErrorSimple,
        )

        url = f"/projects/columns/{column_id}/cards"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ProjectsColumnsColumnIdCardsPostBodyOneof0,
                    ProjectsColumnsColumnIdCardsPostBodyOneof1,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": Union[ValidationError, ValidationErrorSimple],
                "503": ProjectsColumnsColumnIdCardsPostResponse503,
            },
        )

    @overload
    def move_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ProjectsColumnsColumnIdMovesPostBodyType,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201Type,
    ]: ...

    @overload
    def move_column(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        position: str,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201Type,
    ]: ...

    def move_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsColumnIdMovesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201Type,
    ]:
        """DEPRECATED projects-classic/move-column

        POST /projects/columns/{column_id}/moves

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/columns#move-a-project-column
        """

        from ..models import (
            BasicError,
            ProjectsColumnsColumnIdMovesPostBody,
            ProjectsColumnsColumnIdMovesPostResponse201,
            ValidationErrorSimple,
        )

        url = f"/projects/columns/{column_id}/moves"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsColumnIdMovesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsColumnsColumnIdMovesPostResponse201,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "401": BasicError,
            },
        )

    @overload
    async def async_move_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ProjectsColumnsColumnIdMovesPostBodyType,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201Type,
    ]: ...

    @overload
    async def async_move_column(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        position: str,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201Type,
    ]: ...

    async def async_move_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsColumnIdMovesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201Type,
    ]:
        """DEPRECATED projects-classic/move-column

        POST /projects/columns/{column_id}/moves

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/columns#move-a-project-column
        """

        from ..models import (
            BasicError,
            ProjectsColumnsColumnIdMovesPostBody,
            ProjectsColumnsColumnIdMovesPostResponse201,
            ValidationErrorSimple,
        )

        url = f"/projects/columns/{column_id}/moves"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsColumnIdMovesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsColumnsColumnIdMovesPostResponse201,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "401": BasicError,
            },
        )

    def get(
        self,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Project, ProjectType]:
        """DEPRECATED projects-classic/get

        GET /projects/{project_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/projects#get-a-project
        """

        from ..models import BasicError, Project

        url = f"/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Project,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get(
        self,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Project, ProjectType]:
        """DEPRECATED projects-classic/get

        GET /projects/{project_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/projects#get-a-project
        """

        from ..models import BasicError, Project

        url = f"/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Project,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete(
        self,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED projects-classic/delete

        DELETE /projects/{project_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/projects#delete-a-project
        """

        from ..models import BasicError, ProjectsProjectIdDeleteResponse403

        url = f"/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": ProjectsProjectIdDeleteResponse403,
                "401": BasicError,
                "410": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete(
        self,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED projects-classic/delete

        DELETE /projects/{project_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/projects#delete-a-project
        """

        from ..models import BasicError, ProjectsProjectIdDeleteResponse403

        url = f"/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": ProjectsProjectIdDeleteResponse403,
                "401": BasicError,
                "410": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update(
        self,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsProjectIdPatchBodyType] = UNSET,
    ) -> Response[Project, ProjectType]: ...

    @overload
    def update(
        self,
        project_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        body: Missing[Union[str, None]] = UNSET,
        state: Missing[str] = UNSET,
        organization_permission: Missing[
            Literal["read", "write", "admin", "none"]
        ] = UNSET,
        private: Missing[bool] = UNSET,
    ) -> Response[Project, ProjectType]: ...

    def update(
        self,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsProjectIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Project, ProjectType]:
        """DEPRECATED projects-classic/update

        PATCH /projects/{project_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/projects#update-a-project
        """

        from ..models import (
            BasicError,
            Project,
            ProjectsProjectIdPatchBody,
            ProjectsProjectIdPatchResponse403,
            ValidationErrorSimple,
        )

        url = f"/projects/{project_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsProjectIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Project,
            error_models={
                "403": ProjectsProjectIdPatchResponse403,
                "401": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_update(
        self,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsProjectIdPatchBodyType] = UNSET,
    ) -> Response[Project, ProjectType]: ...

    @overload
    async def async_update(
        self,
        project_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        body: Missing[Union[str, None]] = UNSET,
        state: Missing[str] = UNSET,
        organization_permission: Missing[
            Literal["read", "write", "admin", "none"]
        ] = UNSET,
        private: Missing[bool] = UNSET,
    ) -> Response[Project, ProjectType]: ...

    async def async_update(
        self,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsProjectIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Project, ProjectType]:
        """DEPRECATED projects-classic/update

        PATCH /projects/{project_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/projects#update-a-project
        """

        from ..models import (
            BasicError,
            Project,
            ProjectsProjectIdPatchBody,
            ProjectsProjectIdPatchResponse403,
            ValidationErrorSimple,
        )

        url = f"/projects/{project_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsProjectIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Project,
            error_models={
                "403": ProjectsProjectIdPatchResponse403,
                "401": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_collaborators(
        self,
        project_id: int,
        *,
        affiliation: Missing[Literal["outside", "direct", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """DEPRECATED projects-classic/list-collaborators

        GET /projects/{project_id}/collaborators

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/collaborators#list-project-collaborators
        """

        from ..models import BasicError, SimpleUser, ValidationError

        url = f"/projects/{project_id}/collaborators"

        params = {
            "affiliation": affiliation,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_collaborators(
        self,
        project_id: int,
        *,
        affiliation: Missing[Literal["outside", "direct", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """DEPRECATED projects-classic/list-collaborators

        GET /projects/{project_id}/collaborators

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/collaborators#list-project-collaborators
        """

        from ..models import BasicError, SimpleUser, ValidationError

        url = f"/projects/{project_id}/collaborators"

        params = {
            "affiliation": affiliation,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
    ) -> Response: ...

    @overload
    def add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> Response: ...

    def add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED projects-classic/add-collaborator

        PUT /projects/{project_id}/collaborators/{username}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/collaborators#add-project-collaborator
        """

        from typing import Union

        from ..models import (
            BasicError,
            ProjectsProjectIdCollaboratorsUsernamePutBody,
            ValidationError,
        )

        url = f"/projects/{project_id}/collaborators/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ProjectsProjectIdCollaboratorsUsernamePutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
    ) -> Response: ...

    @overload
    async def async_add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> Response: ...

    async def async_add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED projects-classic/add-collaborator

        PUT /projects/{project_id}/collaborators/{username}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/collaborators#add-project-collaborator
        """

        from typing import Union

        from ..models import (
            BasicError,
            ProjectsProjectIdCollaboratorsUsernamePutBody,
            ValidationError,
        )

        url = f"/projects/{project_id}/collaborators/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ProjectsProjectIdCollaboratorsUsernamePutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def remove_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED projects-classic/remove-collaborator

        DELETE /projects/{project_id}/collaborators/{username}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/collaborators#remove-user-as-a-collaborator
        """

        from ..models import BasicError, ValidationError

        url = f"/projects/{project_id}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "401": BasicError,
            },
        )

    async def async_remove_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED projects-classic/remove-collaborator

        DELETE /projects/{project_id}/collaborators/{username}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/collaborators#remove-user-as-a-collaborator
        """

        from ..models import BasicError, ValidationError

        url = f"/projects/{project_id}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "401": BasicError,
            },
        )

    def get_permission_for_user(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectCollaboratorPermission, ProjectCollaboratorPermissionType]:
        """DEPRECATED projects-classic/get-permission-for-user

        GET /projects/{project_id}/collaborators/{username}/permission

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/collaborators#get-project-permission-for-a-user
        """

        from ..models import BasicError, ProjectCollaboratorPermission, ValidationError

        url = f"/projects/{project_id}/collaborators/{username}/permission"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectCollaboratorPermission,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_permission_for_user(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectCollaboratorPermission, ProjectCollaboratorPermissionType]:
        """DEPRECATED projects-classic/get-permission-for-user

        GET /projects/{project_id}/collaborators/{username}/permission

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/collaborators#get-project-permission-for-a-user
        """

        from ..models import BasicError, ProjectCollaboratorPermission, ValidationError

        url = f"/projects/{project_id}/collaborators/{username}/permission"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectCollaboratorPermission,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_columns(
        self,
        project_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectColumn], list[ProjectColumnType]]:
        """DEPRECATED projects-classic/list-columns

        GET /projects/{project_id}/columns

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/columns#list-project-columns
        """

        from ..models import BasicError, ProjectColumn

        url = f"/projects/{project_id}/columns"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectColumn],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_columns(
        self,
        project_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectColumn], list[ProjectColumnType]]:
        """DEPRECATED projects-classic/list-columns

        GET /projects/{project_id}/columns

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/columns#list-project-columns
        """

        from ..models import BasicError, ProjectColumn

        url = f"/projects/{project_id}/columns"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectColumn],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_column(
        self,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ProjectsProjectIdColumnsPostBodyType,
    ) -> Response[ProjectColumn, ProjectColumnType]: ...

    @overload
    def create_column(
        self,
        project_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
    ) -> Response[ProjectColumn, ProjectColumnType]: ...

    def create_column(
        self,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsProjectIdColumnsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectColumn, ProjectColumnType]:
        """DEPRECATED projects-classic/create-column

        POST /projects/{project_id}/columns

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/columns#create-a-project-column
        """

        from ..models import (
            BasicError,
            ProjectColumn,
            ProjectsProjectIdColumnsPostBody,
            ValidationErrorSimple,
        )

        url = f"/projects/{project_id}/columns"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsProjectIdColumnsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "401": BasicError,
            },
        )

    @overload
    async def async_create_column(
        self,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ProjectsProjectIdColumnsPostBodyType,
    ) -> Response[ProjectColumn, ProjectColumnType]: ...

    @overload
    async def async_create_column(
        self,
        project_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
    ) -> Response[ProjectColumn, ProjectColumnType]: ...

    async def async_create_column(
        self,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsProjectIdColumnsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectColumn, ProjectColumnType]:
        """DEPRECATED projects-classic/create-column

        POST /projects/{project_id}/columns

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/columns#create-a-project-column
        """

        from ..models import (
            BasicError,
            ProjectColumn,
            ProjectsProjectIdColumnsPostBody,
            ValidationErrorSimple,
        )

        url = f"/projects/{project_id}/columns"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsProjectIdColumnsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "401": BasicError,
            },
        )

    def list_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Project], list[ProjectType]]:
        """DEPRECATED projects-classic/list-for-repo

        GET /repos/{owner}/{repo}/projects

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/projects#list-repository-projects
        """

        from ..models import BasicError, Project, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Project],
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Project], list[ProjectType]]:
        """DEPRECATED projects-classic/list-for-repo

        GET /repos/{owner}/{repo}/projects

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/projects#list-repository-projects
        """

        from ..models import BasicError, Project, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Project],
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def create_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoProjectsPostBodyType,
    ) -> Response[Project, ProjectType]: ...

    @overload
    def create_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        body: Missing[str] = UNSET,
    ) -> Response[Project, ProjectType]: ...

    def create_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoProjectsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Project, ProjectType]:
        """DEPRECATED projects-classic/create-for-repo

        POST /repos/{owner}/{repo}/projects

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/projects#create-a-repository-project
        """

        from ..models import (
            BasicError,
            Project,
            ReposOwnerRepoProjectsPostBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/projects"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoProjectsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Project,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_create_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoProjectsPostBodyType,
    ) -> Response[Project, ProjectType]: ...

    @overload
    async def async_create_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        body: Missing[str] = UNSET,
    ) -> Response[Project, ProjectType]: ...

    async def async_create_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoProjectsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Project, ProjectType]:
        """DEPRECATED projects-classic/create-for-repo

        POST /repos/{owner}/{repo}/projects

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/projects#create-a-repository-project
        """

        from ..models import (
            BasicError,
            Project,
            ReposOwnerRepoProjectsPostBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/projects"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoProjectsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Project,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def create_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UserProjectsPostBodyType,
    ) -> Response[Project, ProjectType]: ...

    @overload
    def create_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        body: Missing[Union[str, None]] = UNSET,
    ) -> Response[Project, ProjectType]: ...

    def create_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserProjectsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Project, ProjectType]:
        """DEPRECATED projects-classic/create-for-authenticated-user

        POST /user/projects

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/projects#create-a-user-project
        """

        from ..models import (
            BasicError,
            Project,
            UserProjectsPostBody,
            ValidationErrorSimple,
        )

        url = "/user/projects"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserProjectsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Project,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UserProjectsPostBodyType,
    ) -> Response[Project, ProjectType]: ...

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        body: Missing[Union[str, None]] = UNSET,
    ) -> Response[Project, ProjectType]: ...

    async def async_create_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserProjectsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Project, ProjectType]:
        """DEPRECATED projects-classic/create-for-authenticated-user

        POST /user/projects

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/projects#create-a-user-project
        """

        from ..models import (
            BasicError,
            Project,
            UserProjectsPostBody,
            ValidationErrorSimple,
        )

        url = "/user/projects"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserProjectsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Project,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_for_user(
        self,
        username: str,
        *,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Project], list[ProjectType]]:
        """DEPRECATED projects-classic/list-for-user

        GET /users/{username}/projects

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/projects#list-user-projects
        """

        from ..models import Project, ValidationError

        url = f"/users/{username}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Project],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_for_user(
        self,
        username: str,
        *,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Project], list[ProjectType]]:
        """DEPRECATED projects-classic/list-for-user

        GET /users/{username}/projects

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/projects#list-user-projects
        """

        from ..models import Project, ValidationError

        url = f"/users/{username}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Project],
            error_models={
                "422": ValidationError,
            },
        )
