"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from datetime import datetime
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        Commit,
        DiffEntry,
        PullRequest,
        PullRequestMergeResult,
        PullRequestReview,
        PullRequestReviewComment,
        PullRequestReviewRequest,
        PullRequestSimple,
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
        ReviewComment,
    )
    from ..types import (
        CommitType,
        DiffEntryType,
        PullRequestMergeResultType,
        PullRequestReviewCommentType,
        PullRequestReviewRequestType,
        PullRequestReviewType,
        PullRequestSimpleType,
        PullRequestType,
        ReposOwnerRepoPullsCommentsCommentIdPatchBodyType,
        ReposOwnerRepoPullsPostBodyType,
        ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType,
        ReposOwnerRepoPullsPullNumberCommentsPostBodyType,
        ReposOwnerRepoPullsPullNumberMergePutBodyType,
        ReposOwnerRepoPullsPullNumberPatchBodyType,
        ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType,
        ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0Type,
        ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1Type,
        ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItemsType,
        ReposOwnerRepoPullsPullNumberReviewsPostBodyType,
        ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType,
        ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType,
        ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType,
        ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType,
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202Type,
        ReviewCommentType,
    )


class PullsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list(
        self,
        owner: str,
        repo: str,
        *,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        head: Missing[str] = UNSET,
        base: Missing[str] = UNSET,
        sort: Missing[
            Literal["created", "updated", "popularity", "long-running"]
        ] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[PullRequestSimple], list[PullRequestSimpleType]]:
        """pulls/list

        GET /repos/{owner}/{repo}/pulls

        Lists pull requests in a specified repository.

        Draft pull requests are available in public repositories with GitHub
        Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing
        plans, and in public and private repositories with GitHub Team and GitHub Enterprise
        Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)
        in the GitHub Help documentation.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/pulls#list-pull-requests
        """

        from ..models import PullRequestSimple, ValidationError

        url = f"/repos/{owner}/{repo}/pulls"

        params = {
            "state": state,
            "head": head,
            "base": base,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[PullRequestSimple],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list(
        self,
        owner: str,
        repo: str,
        *,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        head: Missing[str] = UNSET,
        base: Missing[str] = UNSET,
        sort: Missing[
            Literal["created", "updated", "popularity", "long-running"]
        ] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[PullRequestSimple], list[PullRequestSimpleType]]:
        """pulls/list

        GET /repos/{owner}/{repo}/pulls

        Lists pull requests in a specified repository.

        Draft pull requests are available in public repositories with GitHub
        Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing
        plans, and in public and private repositories with GitHub Team and GitHub Enterprise
        Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)
        in the GitHub Help documentation.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/pulls#list-pull-requests
        """

        from ..models import PullRequestSimple, ValidationError

        url = f"/repos/{owner}/{repo}/pulls"

        params = {
            "state": state,
            "head": head,
            "base": base,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[PullRequestSimple],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPullsPostBodyType,
    ) -> Response[PullRequest, PullRequestType]: ...

    @overload
    def create(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        title: Missing[str] = UNSET,
        head: str,
        head_repo: Missing[str] = UNSET,
        base: str,
        body: Missing[str] = UNSET,
        maintainer_can_modify: Missing[bool] = UNSET,
        draft: Missing[bool] = UNSET,
        issue: Missing[int] = UNSET,
    ) -> Response[PullRequest, PullRequestType]: ...

    def create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPullsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequest, PullRequestType]:
        """pulls/create

        POST /repos/{owner}/{repo}/pulls

        Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.

        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/pulls#create-a-pull-request
        """

        from ..models import (
            BasicError,
            PullRequest,
            ReposOwnerRepoPullsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoPullsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequest,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPullsPostBodyType,
    ) -> Response[PullRequest, PullRequestType]: ...

    @overload
    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        title: Missing[str] = UNSET,
        head: str,
        head_repo: Missing[str] = UNSET,
        base: str,
        body: Missing[str] = UNSET,
        maintainer_can_modify: Missing[bool] = UNSET,
        draft: Missing[bool] = UNSET,
        issue: Missing[int] = UNSET,
    ) -> Response[PullRequest, PullRequestType]: ...

    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPullsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequest, PullRequestType]:
        """pulls/create

        POST /repos/{owner}/{repo}/pulls

        Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.

        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/pulls#create-a-pull-request
        """

        from ..models import (
            BasicError,
            PullRequest,
            ReposOwnerRepoPullsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoPullsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequest,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_review_comments_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        sort: Missing[Literal["created", "updated", "created_at"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[PullRequestReviewComment], list[PullRequestReviewCommentType]]:
        """pulls/list-review-comments-for-repo

        GET /repos/{owner}/{repo}/pulls/comments

        Lists review comments for all pull requests in a repository. By default,
        review comments are in ascending order by ID.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/comments#list-review-comments-in-a-repository
        """

        from ..models import PullRequestReviewComment

        url = f"/repos/{owner}/{repo}/pulls/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[PullRequestReviewComment],
        )

    async def async_list_review_comments_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        sort: Missing[Literal["created", "updated", "created_at"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[PullRequestReviewComment], list[PullRequestReviewCommentType]]:
        """pulls/list-review-comments-for-repo

        GET /repos/{owner}/{repo}/pulls/comments

        Lists review comments for all pull requests in a repository. By default,
        review comments are in ascending order by ID.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/comments#list-review-comments-in-a-repository
        """

        from ..models import PullRequestReviewComment

        url = f"/repos/{owner}/{repo}/pulls/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[PullRequestReviewComment],
        )

    def get_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]:
        """pulls/get-review-comment

        GET /repos/{owner}/{repo}/pulls/comments/{comment_id}

        Provides details for a specified review comment.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/comments#get-a-review-comment-for-a-pull-request
        """

        from ..models import BasicError, PullRequestReviewComment

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReviewComment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]:
        """pulls/get-review-comment

        GET /repos/{owner}/{repo}/pulls/comments/{comment_id}

        Provides details for a specified review comment.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/comments#get-a-review-comment-for-a-pull-request
        """

        from ..models import BasicError, PullRequestReviewComment

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReviewComment,
            error_models={
                "404": BasicError,
            },
        )

    def delete_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """pulls/delete-review-comment

        DELETE /repos/{owner}/{repo}/pulls/comments/{comment_id}

        Deletes a review comment.

        See also: https://docs.github.com/rest/pulls/comments#delete-a-review-comment-for-a-pull-request
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """pulls/delete-review-comment

        DELETE /repos/{owner}/{repo}/pulls/comments/{comment_id}

        Deletes a review comment.

        See also: https://docs.github.com/rest/pulls/comments#delete-a-review-comment-for-a-pull-request
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPullsCommentsCommentIdPatchBodyType,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    @overload
    def update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        body: str,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    def update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPullsCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]:
        """pulls/update-review-comment

        PATCH /repos/{owner}/{repo}/pulls/comments/{comment_id}

        Edits the content of a specified review comment.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/comments#update-a-review-comment-for-a-pull-request
        """

        from ..models import (
            PullRequestReviewComment,
            ReposOwnerRepoPullsCommentsCommentIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsCommentsCommentIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReviewComment,
        )

    @overload
    async def async_update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPullsCommentsCommentIdPatchBodyType,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    @overload
    async def async_update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        body: str,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    async def async_update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPullsCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]:
        """pulls/update-review-comment

        PATCH /repos/{owner}/{repo}/pulls/comments/{comment_id}

        Edits the content of a specified review comment.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/comments#update-a-review-comment-for-a-pull-request
        """

        from ..models import (
            PullRequestReviewComment,
            ReposOwnerRepoPullsCommentsCommentIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsCommentsCommentIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReviewComment,
        )

    def get(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PullRequest, PullRequestType]:
        """pulls/get

        GET /repos/{owner}/{repo}/pulls/{pull_number}

        Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Lists details of a pull request by providing its number.

        When you get, [create](https://docs.github.com/rest/pulls/pulls/#create-a-pull-request), or [edit](https://docs.github.com/rest/pulls/pulls#update-a-pull-request) a pull request, GitHub creates a merge commit to test whether the pull request can be automatically merged into the base branch. This test commit is not added to the base branch or the head branch. You can review the status of the test commit using the `mergeable` key. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".

        The value of the `mergeable` attribute can be `true`, `false`, or `null`. If the value is `null`, then GitHub has started a background job to compute the mergeability. After giving the job time to complete, resubmit the request. When the job finishes, you will see a non-`null` value for the `mergeable` attribute in the response. If `mergeable` is `true`, then `merge_commit_sha` will be the SHA of the _test_ merge commit.

        The value of the `merge_commit_sha` attribute changes depending on the state of the pull request. Before merging a pull request, the `merge_commit_sha` attribute holds the SHA of the _test_ merge commit. After merging a pull request, the `merge_commit_sha` attribute changes depending on how you merged the pull request:

        *   If merged as a [merge commit](https://docs.github.com/articles/about-merge-methods-on-github/), `merge_commit_sha` represents the SHA of the merge commit.
        *   If merged via a [squash](https://docs.github.com/articles/about-merge-methods-on-github/#squashing-your-merge-commits), `merge_commit_sha` represents the SHA of the squashed commit on the base branch.
        *   If [rebased](https://docs.github.com/articles/about-merge-methods-on-github/#rebasing-and-merging-your-commits), `merge_commit_sha` represents the commit that the base branch was updated to.

        Pass the appropriate [media type](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types) to fetch diff and patch formats.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
        - **`application/vnd.github.diff`**: For more information, see "[git-diff](https://git-scm.com/docs/git-diff)" in the Git documentation. If a diff is corrupt, contact us through the [GitHub Support portal](https://support.github.com/). Include the repository name and pull request ID in your message.

        See also: https://docs.github.com/rest/pulls/pulls#get-a-pull-request
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            PullRequest,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequest,
            error_models={
                "404": BasicError,
                "406": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    async def async_get(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PullRequest, PullRequestType]:
        """pulls/get

        GET /repos/{owner}/{repo}/pulls/{pull_number}

        Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Lists details of a pull request by providing its number.

        When you get, [create](https://docs.github.com/rest/pulls/pulls/#create-a-pull-request), or [edit](https://docs.github.com/rest/pulls/pulls#update-a-pull-request) a pull request, GitHub creates a merge commit to test whether the pull request can be automatically merged into the base branch. This test commit is not added to the base branch or the head branch. You can review the status of the test commit using the `mergeable` key. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".

        The value of the `mergeable` attribute can be `true`, `false`, or `null`. If the value is `null`, then GitHub has started a background job to compute the mergeability. After giving the job time to complete, resubmit the request. When the job finishes, you will see a non-`null` value for the `mergeable` attribute in the response. If `mergeable` is `true`, then `merge_commit_sha` will be the SHA of the _test_ merge commit.

        The value of the `merge_commit_sha` attribute changes depending on the state of the pull request. Before merging a pull request, the `merge_commit_sha` attribute holds the SHA of the _test_ merge commit. After merging a pull request, the `merge_commit_sha` attribute changes depending on how you merged the pull request:

        *   If merged as a [merge commit](https://docs.github.com/articles/about-merge-methods-on-github/), `merge_commit_sha` represents the SHA of the merge commit.
        *   If merged via a [squash](https://docs.github.com/articles/about-merge-methods-on-github/#squashing-your-merge-commits), `merge_commit_sha` represents the SHA of the squashed commit on the base branch.
        *   If [rebased](https://docs.github.com/articles/about-merge-methods-on-github/#rebasing-and-merging-your-commits), `merge_commit_sha` represents the commit that the base branch was updated to.

        Pass the appropriate [media type](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types) to fetch diff and patch formats.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.
        - **`application/vnd.github.diff`**: For more information, see "[git-diff](https://git-scm.com/docs/git-diff)" in the Git documentation. If a diff is corrupt, contact us through the [GitHub Support portal](https://support.github.com/). Include the repository name and pull request ID in your message.

        See also: https://docs.github.com/rest/pulls/pulls#get-a-pull-request
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            PullRequest,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequest,
            error_models={
                "404": BasicError,
                "406": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPullsPullNumberPatchBodyType] = UNSET,
    ) -> Response[PullRequest, PullRequestType]: ...

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        state: Missing[Literal["open", "closed"]] = UNSET,
        base: Missing[str] = UNSET,
        maintainer_can_modify: Missing[bool] = UNSET,
    ) -> Response[PullRequest, PullRequestType]: ...

    def update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPullsPullNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequest, PullRequestType]:
        """pulls/update

        PATCH /repos/{owner}/{repo}/pulls/{pull_number}

        Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/pulls#update-a-pull-request
        """

        from ..models import (
            BasicError,
            PullRequest,
            ReposOwnerRepoPullsPullNumberPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoPullsPullNumberPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequest,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPullsPullNumberPatchBodyType] = UNSET,
    ) -> Response[PullRequest, PullRequestType]: ...

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        state: Missing[Literal["open", "closed"]] = UNSET,
        base: Missing[str] = UNSET,
        maintainer_can_modify: Missing[bool] = UNSET,
    ) -> Response[PullRequest, PullRequestType]: ...

    async def async_update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPullsPullNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequest, PullRequestType]:
        """pulls/update

        PATCH /repos/{owner}/{repo}/pulls/{pull_number}

        Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/pulls#update-a-pull-request
        """

        from ..models import (
            BasicError,
            PullRequest,
            ReposOwnerRepoPullsPullNumberPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoPullsPullNumberPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequest,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def list_review_comments(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[PullRequestReviewComment], list[PullRequestReviewCommentType]]:
        """pulls/list-review-comments

        GET /repos/{owner}/{repo}/pulls/{pull_number}/comments

        Lists all review comments for a specified pull request. By default, review comments
        are in ascending order by ID.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/comments#list-review-comments-on-a-pull-request
        """

        from ..models import PullRequestReviewComment

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[PullRequestReviewComment],
        )

    async def async_list_review_comments(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[PullRequestReviewComment], list[PullRequestReviewCommentType]]:
        """pulls/list-review-comments

        GET /repos/{owner}/{repo}/pulls/{pull_number}/comments

        Lists all review comments for a specified pull request. By default, review comments
        are in ascending order by ID.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/comments#list-review-comments-on-a-pull-request
        """

        from ..models import PullRequestReviewComment

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[PullRequestReviewComment],
        )

    @overload
    def create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPullsPullNumberCommentsPostBodyType,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    @overload
    def create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        body: str,
        commit_id: str,
        path: str,
        position: Missing[int] = UNSET,
        side: Missing[Literal["LEFT", "RIGHT"]] = UNSET,
        line: Missing[int] = UNSET,
        start_line: Missing[int] = UNSET,
        start_side: Missing[Literal["LEFT", "RIGHT", "side"]] = UNSET,
        in_reply_to: Missing[int] = UNSET,
        subject_type: Missing[Literal["line", "file"]] = UNSET,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    def create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPullsPullNumberCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]:
        """pulls/create-review-comment

        POST /repos/{owner}/{repo}/pulls/{pull_number}/comments

        Creates a review comment on the diff of a specified pull request. To add a regular comment to a pull request timeline, see "[Create an issue comment](https://docs.github.com/rest/issues/comments#create-an-issue-comment)."

        If your comment applies to more than one line in the pull request diff, you should use the parameters `line`, `side`, and optionally `start_line` and `start_side` in your request.

        The `position` parameter is closing down. If you use `position`, the `line`, `side`, `start_line`, and `start_side` parameters are not required.

        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
        and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/comments#create-a-review-comment-for-a-pull-request
        """

        from ..models import (
            BasicError,
            PullRequestReviewComment,
            ReposOwnerRepoPullsPullNumberCommentsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberCommentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReviewComment,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPullsPullNumberCommentsPostBodyType,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    @overload
    async def async_create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        body: str,
        commit_id: str,
        path: str,
        position: Missing[int] = UNSET,
        side: Missing[Literal["LEFT", "RIGHT"]] = UNSET,
        line: Missing[int] = UNSET,
        start_line: Missing[int] = UNSET,
        start_side: Missing[Literal["LEFT", "RIGHT", "side"]] = UNSET,
        in_reply_to: Missing[int] = UNSET,
        subject_type: Missing[Literal["line", "file"]] = UNSET,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    async def async_create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPullsPullNumberCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]:
        """pulls/create-review-comment

        POST /repos/{owner}/{repo}/pulls/{pull_number}/comments

        Creates a review comment on the diff of a specified pull request. To add a regular comment to a pull request timeline, see "[Create an issue comment](https://docs.github.com/rest/issues/comments#create-an-issue-comment)."

        If your comment applies to more than one line in the pull request diff, you should use the parameters `line`, `side`, and optionally `start_line` and `start_side` in your request.

        The `position` parameter is closing down. If you use `position`, the `line`, `side`, `start_line`, and `start_side` parameters are not required.

        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
        and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/comments#create-a-review-comment-for-a-pull-request
        """

        from ..models import (
            BasicError,
            PullRequestReviewComment,
            ReposOwnerRepoPullsPullNumberCommentsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberCommentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReviewComment,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    def create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    @overload
    def create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        body: str,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    def create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]:
        """pulls/create-reply-for-review-comment

        POST /repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies

        Creates a reply to a review comment for a pull request. For the `comment_id`, provide the ID of the review comment you are replying to. This must be the ID of a _top-level review comment_, not a reply to that comment. Replies to replies are not supported.

        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
        and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/comments#create-a-reply-for-a-review-comment
        """

        from ..models import (
            BasicError,
            PullRequestReviewComment,
            ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReviewComment,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    @overload
    async def async_create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        body: str,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    async def async_create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]:
        """pulls/create-reply-for-review-comment

        POST /repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies

        Creates a reply to a review comment for a pull request. For the `comment_id`, provide the ID of the review comment you are replying to. This must be the ID of a _top-level review comment_, not a reply to that comment. Replies to replies are not supported.

        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
        and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/comments#create-a-reply-for-a-review-comment
        """

        from ..models import (
            BasicError,
            PullRequestReviewComment,
            ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReviewComment,
            error_models={
                "404": BasicError,
            },
        )

    def list_commits(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Commit], list[CommitType]]:
        """pulls/list-commits

        GET /repos/{owner}/{repo}/pulls/{pull_number}/commits

        Lists a maximum of 250 commits for a pull request. To receive a complete
        commit list for pull requests with more than 250 commits, use the [List commits](https://docs.github.com/rest/commits/commits#list-commits)
        endpoint.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/pulls#list-commits-on-a-pull-request
        """

        from ..models import Commit

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/commits"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Commit],
        )

    async def async_list_commits(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Commit], list[CommitType]]:
        """pulls/list-commits

        GET /repos/{owner}/{repo}/pulls/{pull_number}/commits

        Lists a maximum of 250 commits for a pull request. To receive a complete
        commit list for pull requests with more than 250 commits, use the [List commits](https://docs.github.com/rest/commits/commits#list-commits)
        endpoint.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/pulls#list-commits-on-a-pull-request
        """

        from ..models import Commit

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/commits"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Commit],
        )

    def list_files(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[DiffEntry], list[DiffEntryType]]:
        """pulls/list-files

        GET /repos/{owner}/{repo}/pulls/{pull_number}/files

        Lists the files in a specified pull request.

        > [!NOTE]
        > Responses include a maximum of 3000 files. The paginated response returns 30 files per page by default.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/pulls#list-pull-requests-files
        """

        from ..models import (
            BasicError,
            DiffEntry,
            EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/files"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[DiffEntry],
            error_models={
                "422": ValidationError,
                "500": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    async def async_list_files(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[DiffEntry], list[DiffEntryType]]:
        """pulls/list-files

        GET /repos/{owner}/{repo}/pulls/{pull_number}/files

        Lists the files in a specified pull request.

        > [!NOTE]
        > Responses include a maximum of 3000 files. The paginated response returns 30 files per page by default.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/pulls#list-pull-requests-files
        """

        from ..models import (
            BasicError,
            DiffEntry,
            EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/files"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[DiffEntry],
            error_models={
                "422": ValidationError,
                "500": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    def check_if_merged(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """pulls/check-if-merged

        GET /repos/{owner}/{repo}/pulls/{pull_number}/merge

        Checks if a pull request has been merged into the base branch. The HTTP status of the response indicates whether or not the pull request has been merged; the response body is empty.

        See also: https://docs.github.com/rest/pulls/pulls#check-if-a-pull-request-has-been-merged
        """

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/merge"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    async def async_check_if_merged(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """pulls/check-if-merged

        GET /repos/{owner}/{repo}/pulls/{pull_number}/merge

        Checks if a pull request has been merged into the base branch. The HTTP status of the response indicates whether or not the pull request has been merged; the response body is empty.

        See also: https://docs.github.com/rest/pulls/pulls#check-if-a-pull-request-has-been-merged
        """

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/merge"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    @overload
    def merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberMergePutBodyType, None]
        ] = UNSET,
    ) -> Response[PullRequestMergeResult, PullRequestMergeResultType]: ...

    @overload
    def merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        commit_title: Missing[str] = UNSET,
        commit_message: Missing[str] = UNSET,
        sha: Missing[str] = UNSET,
        merge_method: Missing[Literal["merge", "squash", "rebase"]] = UNSET,
    ) -> Response[PullRequestMergeResult, PullRequestMergeResultType]: ...

    def merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberMergePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestMergeResult, PullRequestMergeResultType]:
        """pulls/merge

        PUT /repos/{owner}/{repo}/pulls/{pull_number}/merge

        Merges a pull request into the base branch.
        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."

        See also: https://docs.github.com/rest/pulls/pulls#merge-a-pull-request
        """

        from typing import Union

        from ..models import (
            BasicError,
            PullRequestMergeResult,
            ReposOwnerRepoPullsPullNumberMergePutBody,
            ReposOwnerRepoPullsPullNumberMergePutResponse405,
            ReposOwnerRepoPullsPullNumberMergePutResponse409,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/merge"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoPullsPullNumberMergePutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestMergeResult,
            error_models={
                "405": ReposOwnerRepoPullsPullNumberMergePutResponse405,
                "409": ReposOwnerRepoPullsPullNumberMergePutResponse409,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberMergePutBodyType, None]
        ] = UNSET,
    ) -> Response[PullRequestMergeResult, PullRequestMergeResultType]: ...

    @overload
    async def async_merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        commit_title: Missing[str] = UNSET,
        commit_message: Missing[str] = UNSET,
        sha: Missing[str] = UNSET,
        merge_method: Missing[Literal["merge", "squash", "rebase"]] = UNSET,
    ) -> Response[PullRequestMergeResult, PullRequestMergeResultType]: ...

    async def async_merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberMergePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestMergeResult, PullRequestMergeResultType]:
        """pulls/merge

        PUT /repos/{owner}/{repo}/pulls/{pull_number}/merge

        Merges a pull request into the base branch.
        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."

        See also: https://docs.github.com/rest/pulls/pulls#merge-a-pull-request
        """

        from typing import Union

        from ..models import (
            BasicError,
            PullRequestMergeResult,
            ReposOwnerRepoPullsPullNumberMergePutBody,
            ReposOwnerRepoPullsPullNumberMergePutResponse405,
            ReposOwnerRepoPullsPullNumberMergePutResponse409,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/merge"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoPullsPullNumberMergePutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestMergeResult,
            error_models={
                "405": ReposOwnerRepoPullsPullNumberMergePutResponse405,
                "409": ReposOwnerRepoPullsPullNumberMergePutResponse409,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PullRequestReviewRequest, PullRequestReviewRequestType]:
        """pulls/list-requested-reviewers

        GET /repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers

        Gets the users or teams whose review is requested for a pull request. Once a requested reviewer submits a review, they are no longer considered a requested reviewer. Their review will instead be returned by the [List reviews for a pull request](https://docs.github.com/rest/pulls/reviews#list-reviews-for-a-pull-request) operation.

        See also: https://docs.github.com/rest/pulls/review-requests#get-all-requested-reviewers-for-a-pull-request
        """

        from ..models import PullRequestReviewRequest

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReviewRequest,
        )

    async def async_list_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PullRequestReviewRequest, PullRequestReviewRequestType]:
        """pulls/list-requested-reviewers

        GET /repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers

        Gets the users or teams whose review is requested for a pull request. Once a requested reviewer submits a review, they are no longer considered a requested reviewer. Their review will instead be returned by the [List reviews for a pull request](https://docs.github.com/rest/pulls/reviews#list-reviews-for-a-pull-request) operation.

        See also: https://docs.github.com/rest/pulls/review-requests#get-all-requested-reviewers-for-a-pull-request
        """

        from ..models import PullRequestReviewRequest

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReviewRequest,
        )

    @overload
    def request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0Type,
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1Type,
            ]
        ] = UNSET,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]: ...

    @overload
    def request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        reviewers: list[str],
        team_reviewers: Missing[list[str]] = UNSET,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]: ...

    @overload
    def request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        reviewers: Missing[list[str]] = UNSET,
        team_reviewers: list[str],
    ) -> Response[PullRequestSimple, PullRequestSimpleType]: ...

    def request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0Type,
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]:
        """pulls/request-reviewers

        POST /repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers

        Requests reviews for a pull request from a given set of users and/or teams.
        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."

        See also: https://docs.github.com/rest/pulls/review-requests#request-reviewers-for-a-pull-request
        """

        from typing import Union

        from ..models import (
            BasicError,
            PullRequestSimple,
            ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0,
            ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0,
                    ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestSimple,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    async def async_request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0Type,
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1Type,
            ]
        ] = UNSET,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]: ...

    @overload
    async def async_request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        reviewers: list[str],
        team_reviewers: Missing[list[str]] = UNSET,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]: ...

    @overload
    async def async_request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        reviewers: Missing[list[str]] = UNSET,
        team_reviewers: list[str],
    ) -> Response[PullRequestSimple, PullRequestSimpleType]: ...

    async def async_request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0Type,
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]:
        """pulls/request-reviewers

        POST /repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers

        Requests reviews for a pull request from a given set of users and/or teams.
        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."

        See also: https://docs.github.com/rest/pulls/review-requests#request-reviewers-for-a-pull-request
        """

        from typing import Union

        from ..models import (
            BasicError,
            PullRequestSimple,
            ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0,
            ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0,
                    ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestSimple,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    def remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]: ...

    @overload
    def remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        reviewers: list[str],
        team_reviewers: Missing[list[str]] = UNSET,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]: ...

    def remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]:
        """pulls/remove-requested-reviewers

        DELETE /repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers

        Removes review requests from a pull request for a given set of users and/or teams.

        See also: https://docs.github.com/rest/pulls/review-requests#remove-requested-reviewers-from-a-pull-request
        """

        from ..models import (
            PullRequestSimple,
            ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestSimple,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]: ...

    @overload
    async def async_remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        reviewers: list[str],
        team_reviewers: Missing[list[str]] = UNSET,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]: ...

    async def async_remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]:
        """pulls/remove-requested-reviewers

        DELETE /repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers

        Removes review requests from a pull request for a given set of users and/or teams.

        See also: https://docs.github.com/rest/pulls/review-requests#remove-requested-reviewers-from-a-pull-request
        """

        from ..models import (
            PullRequestSimple,
            ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestSimple,
            error_models={
                "422": ValidationError,
            },
        )

    def list_reviews(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[PullRequestReview], list[PullRequestReviewType]]:
        """pulls/list-reviews

        GET /repos/{owner}/{repo}/pulls/{pull_number}/reviews

        Lists all reviews for a specified pull request. The list of reviews returns in chronological order.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/reviews#list-reviews-for-a-pull-request
        """

        from ..models import PullRequestReview

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[PullRequestReview],
        )

    async def async_list_reviews(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[PullRequestReview], list[PullRequestReviewType]]:
        """pulls/list-reviews

        GET /repos/{owner}/{repo}/pulls/{pull_number}/reviews

        Lists all reviews for a specified pull request. The list of reviews returns in chronological order.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/reviews#list-reviews-for-a-pull-request
        """

        from ..models import PullRequestReview

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[PullRequestReview],
        )

    @overload
    def create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsPostBodyType] = UNSET,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    @overload
    def create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        commit_id: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        event: Missing[Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"]] = UNSET,
        comments: Missing[
            list[ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItemsType]
        ] = UNSET,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    def create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """pulls/create-review

        POST /repos/{owner}/{repo}/pulls/{pull_number}/reviews

        Creates a review on a specified pull request.

        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."

        Pull request reviews created in the `PENDING` state are not submitted and therefore do not include the `submitted_at` property in the response. To create a pending review for a pull request, leave the `event` parameter blank. For more information about submitting a `PENDING` review, see "[Submit a review for a pull request](https://docs.github.com/rest/pulls/reviews#submit-a-review-for-a-pull-request)."

        > [!NOTE]
        > To comment on a specific line in a file, you need to first determine the position of that line in the diff. To see a pull request diff, add the `application/vnd.github.v3.diff` media type to the `Accept` header of a call to the [Get a pull request](https://docs.github.com/rest/pulls/pulls#get-a-pull-request) endpoint.

        The `position` value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/reviews#create-a-review-for-a-pull-request
        """

        from ..models import (
            BasicError,
            PullRequestReview,
            ReposOwnerRepoPullsPullNumberReviewsPostBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberReviewsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
                "403": BasicError,
            },
        )

    @overload
    async def async_create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsPostBodyType] = UNSET,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    @overload
    async def async_create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        commit_id: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        event: Missing[Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"]] = UNSET,
        comments: Missing[
            list[ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItemsType]
        ] = UNSET,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    async def async_create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """pulls/create-review

        POST /repos/{owner}/{repo}/pulls/{pull_number}/reviews

        Creates a review on a specified pull request.

        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."

        Pull request reviews created in the `PENDING` state are not submitted and therefore do not include the `submitted_at` property in the response. To create a pending review for a pull request, leave the `event` parameter blank. For more information about submitting a `PENDING` review, see "[Submit a review for a pull request](https://docs.github.com/rest/pulls/reviews#submit-a-review-for-a-pull-request)."

        > [!NOTE]
        > To comment on a specific line in a file, you need to first determine the position of that line in the diff. To see a pull request diff, add the `application/vnd.github.v3.diff` media type to the `Accept` header of a call to the [Get a pull request](https://docs.github.com/rest/pulls/pulls#get-a-pull-request) endpoint.

        The `position` value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/reviews#create-a-review-for-a-pull-request
        """

        from ..models import (
            BasicError,
            PullRequestReview,
            ReposOwnerRepoPullsPullNumberReviewsPostBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberReviewsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
                "403": BasicError,
            },
        )

    def get_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """pulls/get-review

        GET /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}

        Retrieves a pull request review by its ID.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/reviews#get-a-review-for-a-pull-request
        """

        from ..models import BasicError, PullRequestReview

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """pulls/get-review

        GET /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}

        Retrieves a pull request review by its ID.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/reviews#get-a-review-for-a-pull-request
        """

        from ..models import BasicError, PullRequestReview

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    @overload
    def update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        body: str,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    def update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """pulls/update-review

        PUT /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}

        Updates the contents of a specified review summary comment.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/reviews#update-a-review-for-a-pull-request
        """

        from ..models import (
            PullRequestReview,
            ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    @overload
    async def async_update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        body: str,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    async def async_update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """pulls/update-review

        PUT /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}

        Updates the contents of a specified review summary comment.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/reviews#update-a-review-for-a-pull-request
        """

        from ..models import (
            PullRequestReview,
            ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    def delete_pending_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """pulls/delete-pending-review

        DELETE /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}

        Deletes a pull request review that has not been submitted. Submitted reviews cannot be deleted.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/reviews#delete-a-pending-review-for-a-pull-request
        """

        from ..models import BasicError, PullRequestReview, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    async def async_delete_pending_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """pulls/delete-pending-review

        DELETE /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}

        Deletes a pull request review that has not been submitted. Submitted reviews cannot be deleted.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/reviews#delete-a-pending-review-for-a-pull-request
        """

        from ..models import BasicError, PullRequestReview, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    def list_comments_for_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ReviewComment], list[ReviewCommentType]]:
        """pulls/list-comments-for-review

        GET /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments

        Lists comments for a specific pull request review.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/reviews#list-comments-for-a-pull-request-review
        """

        from ..models import BasicError, ReviewComment

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ReviewComment],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_comments_for_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ReviewComment], list[ReviewCommentType]]:
        """pulls/list-comments-for-review

        GET /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments

        Lists comments for a specific pull request review.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/reviews#list-comments-for-a-pull-request-review
        """

        from ..models import BasicError, ReviewComment

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ReviewComment],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    @overload
    def dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        message: str,
        event: Missing[Literal["DISMISS"]] = UNSET,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    def dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """pulls/dismiss-review

        PUT /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals

        Dismisses a specified review on a pull request.

        > [!NOTE]
        > To dismiss a pull request review on a [protected branch](https://docs.github.com/rest/branches/branch-protection), you must be a repository administrator or be included in the list of people or teams who can dismiss pull request reviews.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/reviews#dismiss-a-review-for-a-pull-request
        """

        from ..models import (
            BasicError,
            PullRequestReview,
            ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody,
            ValidationErrorSimple,
        )

        url = (
            f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    @overload
    async def async_dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        message: str,
        event: Missing[Literal["DISMISS"]] = UNSET,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    async def async_dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """pulls/dismiss-review

        PUT /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals

        Dismisses a specified review on a pull request.

        > [!NOTE]
        > To dismiss a pull request review on a [protected branch](https://docs.github.com/rest/branches/branch-protection), you must be a repository administrator or be included in the list of people or teams who can dismiss pull request reviews.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/reviews#dismiss-a-review-for-a-pull-request
        """

        from ..models import (
            BasicError,
            PullRequestReview,
            ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody,
            ValidationErrorSimple,
        )

        url = (
            f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    @overload
    def submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        body: Missing[str] = UNSET,
        event: Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"],
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    def submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """pulls/submit-review

        POST /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events

        Submits a pending review for a pull request. For more information about creating a pending review for a pull request, see "[Create a review for a pull request](https://docs.github.com/rest/pulls/reviews#create-a-review-for-a-pull-request)."

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/reviews#submit-a-review-for-a-pull-request
        """

        from ..models import (
            BasicError,
            PullRequestReview,
            ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
                "403": BasicError,
            },
        )

    @overload
    async def async_submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    @overload
    async def async_submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        body: Missing[str] = UNSET,
        event: Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"],
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    async def async_submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """pulls/submit-review

        POST /repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events

        Submits a pending review for a pull request. For more information about creating a pending review for a pull request, see "[Create a review for a pull request](https://docs.github.com/rest/pulls/reviews#create-a-review-for-a-pull-request)."

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/pulls/reviews#submit-a-review-for-a-pull-request
        """

        from ..models import (
            BasicError,
            PullRequestReview,
            ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
                "403": BasicError,
            },
        )

    @overload
    def update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType, None]
        ] = UNSET,
    ) -> Response[
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202Type,
    ]: ...

    @overload
    def update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        expected_head_sha: Missing[str] = UNSET,
    ) -> Response[
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202Type,
    ]: ...

    def update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202Type,
    ]:
        """pulls/update-branch

        PUT /repos/{owner}/{repo}/pulls/{pull_number}/update-branch

        Updates the pull request branch with the latest upstream changes by merging HEAD from the base branch into the pull request branch.
        Note: If making a request on behalf of a GitHub App you must also have permissions to write the contents of the head repository.

        See also: https://docs.github.com/rest/pulls/pulls#update-a-pull-request-branch
        """

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoPullsPullNumberUpdateBranchPutBody,
            ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/update-branch"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType, None]
        ] = UNSET,
    ) -> Response[
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202Type,
    ]: ...

    @overload
    async def async_update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        expected_head_sha: Missing[str] = UNSET,
    ) -> Response[
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202Type,
    ]: ...

    async def async_update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202Type,
    ]:
        """pulls/update-branch

        PUT /repos/{owner}/{repo}/pulls/{pull_number}/update-branch

        Updates the pull request branch with the latest upstream changes by merging HEAD from the base branch into the pull request branch.
        Note: If making a request on behalf of a GitHub App you must also have permissions to write the contents of the head repository.

        See also: https://docs.github.com/rest/pulls/pulls#update-a-pull-request-branch
        """

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoPullsPullNumberUpdateBranchPutBody,
            ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/update-branch"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )
