"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        FullRepository,
        GlobalAdvisory,
        RepositoryAdvisory,
    )
    from ..types import (
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
        FullRepositoryType,
        GlobalAdvisoryType,
        PrivateVulnerabilityReportCreatePropVulnerabilitiesItemsType,
        PrivateVulnerabilityReportCreateType,
        RepositoryAdvisoryCreatePropCreditsItemsType,
        RepositoryAdvisoryCreatePropVulnerabilitiesItemsType,
        RepositoryAdvisoryCreateType,
        RepositoryAdvisoryType,
        RepositoryAdvisoryUpdatePropCreditsItemsType,
        RepositoryAdvisoryUpdatePropVulnerabilitiesItemsType,
        RepositoryAdvisoryUpdateType,
    )


class SecurityAdvisoriesClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_global_advisories(
        self,
        *,
        ghsa_id: Missing[str] = UNSET,
        type: Missing[Literal["reviewed", "malware", "unreviewed"]] = UNSET,
        cve_id: Missing[str] = UNSET,
        ecosystem: Missing[
            Literal[
                "rubygems",
                "npm",
                "pip",
                "maven",
                "nuget",
                "composer",
                "go",
                "rust",
                "erlang",
                "actions",
                "pub",
                "other",
                "swift",
            ]
        ] = UNSET,
        severity: Missing[
            Literal["unknown", "low", "medium", "high", "critical"]
        ] = UNSET,
        cwes: Missing[Union[str, list[str]]] = UNSET,
        is_withdrawn: Missing[bool] = UNSET,
        affects: Missing[Union[str, list[str]]] = UNSET,
        published: Missing[str] = UNSET,
        updated: Missing[str] = UNSET,
        modified: Missing[str] = UNSET,
        epss_percentage: Missing[str] = UNSET,
        epss_percentile: Missing[str] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        sort: Missing[
            Literal["updated", "published", "epss_percentage", "epss_percentile"]
        ] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[GlobalAdvisory], list[GlobalAdvisoryType]]:
        """security-advisories/list-global-advisories

        GET /advisories

        Lists all global security advisories that match the specified parameters. If no other parameters are defined, the request will return only GitHub-reviewed advisories that are not malware.

        By default, all responses will exclude advisories for malware, because malware are not standard vulnerabilities. To list advisories for malware, you must include the `type` parameter in your request, with the value `malware`. For more information about the different types of security advisories, see "[About the GitHub Advisory database](https://docs.github.com/code-security/security-advisories/global-security-advisories/about-the-github-advisory-database#about-types-of-security-advisories)."

        See also: https://docs.github.com/rest/security-advisories/global-advisories#list-global-security-advisories
        """

        from ..models import BasicError, GlobalAdvisory, ValidationErrorSimple

        url = "/advisories"

        params = {
            "ghsa_id": ghsa_id,
            "type": type,
            "cve_id": cve_id,
            "ecosystem": ecosystem,
            "severity": severity,
            "cwes": cwes,
            "is_withdrawn": is_withdrawn,
            "affects": affects,
            "published": published,
            "updated": updated,
            "modified": modified,
            "epss_percentage": epss_percentage,
            "epss_percentile": epss_percentile,
            "before": before,
            "after": after,
            "direction": direction,
            "per_page": per_page,
            "sort": sort,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[GlobalAdvisory],
            error_models={
                "429": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_global_advisories(
        self,
        *,
        ghsa_id: Missing[str] = UNSET,
        type: Missing[Literal["reviewed", "malware", "unreviewed"]] = UNSET,
        cve_id: Missing[str] = UNSET,
        ecosystem: Missing[
            Literal[
                "rubygems",
                "npm",
                "pip",
                "maven",
                "nuget",
                "composer",
                "go",
                "rust",
                "erlang",
                "actions",
                "pub",
                "other",
                "swift",
            ]
        ] = UNSET,
        severity: Missing[
            Literal["unknown", "low", "medium", "high", "critical"]
        ] = UNSET,
        cwes: Missing[Union[str, list[str]]] = UNSET,
        is_withdrawn: Missing[bool] = UNSET,
        affects: Missing[Union[str, list[str]]] = UNSET,
        published: Missing[str] = UNSET,
        updated: Missing[str] = UNSET,
        modified: Missing[str] = UNSET,
        epss_percentage: Missing[str] = UNSET,
        epss_percentile: Missing[str] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        sort: Missing[
            Literal["updated", "published", "epss_percentage", "epss_percentile"]
        ] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[GlobalAdvisory], list[GlobalAdvisoryType]]:
        """security-advisories/list-global-advisories

        GET /advisories

        Lists all global security advisories that match the specified parameters. If no other parameters are defined, the request will return only GitHub-reviewed advisories that are not malware.

        By default, all responses will exclude advisories for malware, because malware are not standard vulnerabilities. To list advisories for malware, you must include the `type` parameter in your request, with the value `malware`. For more information about the different types of security advisories, see "[About the GitHub Advisory database](https://docs.github.com/code-security/security-advisories/global-security-advisories/about-the-github-advisory-database#about-types-of-security-advisories)."

        See also: https://docs.github.com/rest/security-advisories/global-advisories#list-global-security-advisories
        """

        from ..models import BasicError, GlobalAdvisory, ValidationErrorSimple

        url = "/advisories"

        params = {
            "ghsa_id": ghsa_id,
            "type": type,
            "cve_id": cve_id,
            "ecosystem": ecosystem,
            "severity": severity,
            "cwes": cwes,
            "is_withdrawn": is_withdrawn,
            "affects": affects,
            "published": published,
            "updated": updated,
            "modified": modified,
            "epss_percentage": epss_percentage,
            "epss_percentile": epss_percentile,
            "before": before,
            "after": after,
            "direction": direction,
            "per_page": per_page,
            "sort": sort,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[GlobalAdvisory],
            error_models={
                "429": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_global_advisory(
        self,
        ghsa_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GlobalAdvisory, GlobalAdvisoryType]:
        """security-advisories/get-global-advisory

        GET /advisories/{ghsa_id}

        Gets a global security advisory using its GitHub Security Advisory (GHSA) identifier.

        See also: https://docs.github.com/rest/security-advisories/global-advisories#get-a-global-security-advisory
        """

        from ..models import BasicError, GlobalAdvisory

        url = f"/advisories/{ghsa_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GlobalAdvisory,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_global_advisory(
        self,
        ghsa_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GlobalAdvisory, GlobalAdvisoryType]:
        """security-advisories/get-global-advisory

        GET /advisories/{ghsa_id}

        Gets a global security advisory using its GitHub Security Advisory (GHSA) identifier.

        See also: https://docs.github.com/rest/security-advisories/global-advisories#get-a-global-security-advisory
        """

        from ..models import BasicError, GlobalAdvisory

        url = f"/advisories/{ghsa_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GlobalAdvisory,
            error_models={
                "404": BasicError,
            },
        )

    def list_org_repository_advisories(
        self,
        org: str,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        sort: Missing[Literal["created", "updated", "published"]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        state: Missing[Literal["triage", "draft", "published", "closed"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RepositoryAdvisory], list[RepositoryAdvisoryType]]:
        """security-advisories/list-org-repository-advisories

        GET /orgs/{org}/security-advisories

        Lists repository security advisories for an organization.

        The authenticated user must be an owner or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.

        See also: https://docs.github.com/rest/security-advisories/repository-advisories#list-repository-security-advisories-for-an-organization
        """

        from ..models import BasicError, RepositoryAdvisory

        url = f"/orgs/{org}/security-advisories"

        params = {
            "direction": direction,
            "sort": sort,
            "before": before,
            "after": after,
            "per_page": per_page,
            "state": state,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RepositoryAdvisory],
            error_models={
                "400": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_org_repository_advisories(
        self,
        org: str,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        sort: Missing[Literal["created", "updated", "published"]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        state: Missing[Literal["triage", "draft", "published", "closed"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RepositoryAdvisory], list[RepositoryAdvisoryType]]:
        """security-advisories/list-org-repository-advisories

        GET /orgs/{org}/security-advisories

        Lists repository security advisories for an organization.

        The authenticated user must be an owner or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.

        See also: https://docs.github.com/rest/security-advisories/repository-advisories#list-repository-security-advisories-for-an-organization
        """

        from ..models import BasicError, RepositoryAdvisory

        url = f"/orgs/{org}/security-advisories"

        params = {
            "direction": direction,
            "sort": sort,
            "before": before,
            "after": after,
            "per_page": per_page,
            "state": state,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RepositoryAdvisory],
            error_models={
                "400": BasicError,
                "404": BasicError,
            },
        )

    def list_repository_advisories(
        self,
        owner: str,
        repo: str,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        sort: Missing[Literal["created", "updated", "published"]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        state: Missing[Literal["triage", "draft", "published", "closed"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RepositoryAdvisory], list[RepositoryAdvisoryType]]:
        """security-advisories/list-repository-advisories

        GET /repos/{owner}/{repo}/security-advisories

        Lists security advisories in a repository.

        The authenticated user can access unpublished security advisories from a repository if they are a security manager or administrator of that repository, or if they are a collaborator on any security advisory.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:read` scope to to get a published security advisory in a private repository, or any unpublished security advisory that the authenticated user has access to.

        See also: https://docs.github.com/rest/security-advisories/repository-advisories#list-repository-security-advisories
        """

        from ..models import BasicError, RepositoryAdvisory

        url = f"/repos/{owner}/{repo}/security-advisories"

        params = {
            "direction": direction,
            "sort": sort,
            "before": before,
            "after": after,
            "per_page": per_page,
            "state": state,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RepositoryAdvisory],
            error_models={
                "400": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_repository_advisories(
        self,
        owner: str,
        repo: str,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        sort: Missing[Literal["created", "updated", "published"]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        state: Missing[Literal["triage", "draft", "published", "closed"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RepositoryAdvisory], list[RepositoryAdvisoryType]]:
        """security-advisories/list-repository-advisories

        GET /repos/{owner}/{repo}/security-advisories

        Lists security advisories in a repository.

        The authenticated user can access unpublished security advisories from a repository if they are a security manager or administrator of that repository, or if they are a collaborator on any security advisory.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:read` scope to to get a published security advisory in a private repository, or any unpublished security advisory that the authenticated user has access to.

        See also: https://docs.github.com/rest/security-advisories/repository-advisories#list-repository-security-advisories
        """

        from ..models import BasicError, RepositoryAdvisory

        url = f"/repos/{owner}/{repo}/security-advisories"

        params = {
            "direction": direction,
            "sort": sort,
            "before": before,
            "after": after,
            "per_page": per_page,
            "state": state,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RepositoryAdvisory],
            error_models={
                "400": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_repository_advisory(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: RepositoryAdvisoryCreateType,
    ) -> Response[RepositoryAdvisory, RepositoryAdvisoryType]: ...

    @overload
    def create_repository_advisory(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        summary: str,
        description: str,
        cve_id: Missing[Union[str, None]] = UNSET,
        vulnerabilities: list[RepositoryAdvisoryCreatePropVulnerabilitiesItemsType],
        cwe_ids: Missing[Union[list[str], None]] = UNSET,
        credits_: Missing[
            Union[list[RepositoryAdvisoryCreatePropCreditsItemsType], None]
        ] = UNSET,
        severity: Missing[
            Union[None, Literal["critical", "high", "medium", "low"]]
        ] = UNSET,
        cvss_vector_string: Missing[Union[str, None]] = UNSET,
        start_private_fork: Missing[bool] = UNSET,
    ) -> Response[RepositoryAdvisory, RepositoryAdvisoryType]: ...

    def create_repository_advisory(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[RepositoryAdvisoryCreateType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryAdvisory, RepositoryAdvisoryType]:
        """security-advisories/create-repository-advisory

        POST /repos/{owner}/{repo}/security-advisories

        Creates a new repository security advisory.

        In order to create a draft repository security advisory, the authenticated user must be a security manager or administrator of that repository.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.

        See also: https://docs.github.com/rest/security-advisories/repository-advisories#create-a-repository-security-advisory
        """

        from ..models import (
            BasicError,
            RepositoryAdvisory,
            RepositoryAdvisoryCreate,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/security-advisories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(RepositoryAdvisoryCreate, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryAdvisory,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_repository_advisory(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: RepositoryAdvisoryCreateType,
    ) -> Response[RepositoryAdvisory, RepositoryAdvisoryType]: ...

    @overload
    async def async_create_repository_advisory(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        summary: str,
        description: str,
        cve_id: Missing[Union[str, None]] = UNSET,
        vulnerabilities: list[RepositoryAdvisoryCreatePropVulnerabilitiesItemsType],
        cwe_ids: Missing[Union[list[str], None]] = UNSET,
        credits_: Missing[
            Union[list[RepositoryAdvisoryCreatePropCreditsItemsType], None]
        ] = UNSET,
        severity: Missing[
            Union[None, Literal["critical", "high", "medium", "low"]]
        ] = UNSET,
        cvss_vector_string: Missing[Union[str, None]] = UNSET,
        start_private_fork: Missing[bool] = UNSET,
    ) -> Response[RepositoryAdvisory, RepositoryAdvisoryType]: ...

    async def async_create_repository_advisory(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[RepositoryAdvisoryCreateType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryAdvisory, RepositoryAdvisoryType]:
        """security-advisories/create-repository-advisory

        POST /repos/{owner}/{repo}/security-advisories

        Creates a new repository security advisory.

        In order to create a draft repository security advisory, the authenticated user must be a security manager or administrator of that repository.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.

        See also: https://docs.github.com/rest/security-advisories/repository-advisories#create-a-repository-security-advisory
        """

        from ..models import (
            BasicError,
            RepositoryAdvisory,
            RepositoryAdvisoryCreate,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/security-advisories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(RepositoryAdvisoryCreate, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryAdvisory,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    def create_private_vulnerability_report(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: PrivateVulnerabilityReportCreateType,
    ) -> Response[RepositoryAdvisory, RepositoryAdvisoryType]: ...

    @overload
    def create_private_vulnerability_report(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        summary: str,
        description: str,
        vulnerabilities: Missing[
            Union[
                list[PrivateVulnerabilityReportCreatePropVulnerabilitiesItemsType], None
            ]
        ] = UNSET,
        cwe_ids: Missing[Union[list[str], None]] = UNSET,
        severity: Missing[
            Union[None, Literal["critical", "high", "medium", "low"]]
        ] = UNSET,
        cvss_vector_string: Missing[Union[str, None]] = UNSET,
        start_private_fork: Missing[bool] = UNSET,
    ) -> Response[RepositoryAdvisory, RepositoryAdvisoryType]: ...

    def create_private_vulnerability_report(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[PrivateVulnerabilityReportCreateType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryAdvisory, RepositoryAdvisoryType]:
        """security-advisories/create-private-vulnerability-report

        POST /repos/{owner}/{repo}/security-advisories/reports

        Report a security vulnerability to the maintainers of the repository.
        See "[Privately reporting a security vulnerability](https://docs.github.com/code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability)" for more information about private vulnerability reporting.

        See also: https://docs.github.com/rest/security-advisories/repository-advisories#privately-report-a-security-vulnerability
        """

        from ..models import (
            BasicError,
            PrivateVulnerabilityReportCreate,
            RepositoryAdvisory,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/security-advisories/reports"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(PrivateVulnerabilityReportCreate, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryAdvisory,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_private_vulnerability_report(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: PrivateVulnerabilityReportCreateType,
    ) -> Response[RepositoryAdvisory, RepositoryAdvisoryType]: ...

    @overload
    async def async_create_private_vulnerability_report(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        summary: str,
        description: str,
        vulnerabilities: Missing[
            Union[
                list[PrivateVulnerabilityReportCreatePropVulnerabilitiesItemsType], None
            ]
        ] = UNSET,
        cwe_ids: Missing[Union[list[str], None]] = UNSET,
        severity: Missing[
            Union[None, Literal["critical", "high", "medium", "low"]]
        ] = UNSET,
        cvss_vector_string: Missing[Union[str, None]] = UNSET,
        start_private_fork: Missing[bool] = UNSET,
    ) -> Response[RepositoryAdvisory, RepositoryAdvisoryType]: ...

    async def async_create_private_vulnerability_report(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[PrivateVulnerabilityReportCreateType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryAdvisory, RepositoryAdvisoryType]:
        """security-advisories/create-private-vulnerability-report

        POST /repos/{owner}/{repo}/security-advisories/reports

        Report a security vulnerability to the maintainers of the repository.
        See "[Privately reporting a security vulnerability](https://docs.github.com/code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability)" for more information about private vulnerability reporting.

        See also: https://docs.github.com/rest/security-advisories/repository-advisories#privately-report-a-security-vulnerability
        """

        from ..models import (
            BasicError,
            PrivateVulnerabilityReportCreate,
            RepositoryAdvisory,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/security-advisories/reports"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(PrivateVulnerabilityReportCreate, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryAdvisory,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_repository_advisory(
        self,
        owner: str,
        repo: str,
        ghsa_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RepositoryAdvisory, RepositoryAdvisoryType]:
        """security-advisories/get-repository-advisory

        GET /repos/{owner}/{repo}/security-advisories/{ghsa_id}

        Get a repository security advisory using its GitHub Security Advisory (GHSA) identifier.

        Anyone can access any published security advisory on a public repository.

        The authenticated user can access an unpublished security advisory from a repository if they are a security manager or administrator of that repository, or if they are a
        collaborator on the security advisory.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:read` scope to to get a published security advisory in a private repository, or any unpublished security advisory that the authenticated user has access to.

        See also: https://docs.github.com/rest/security-advisories/repository-advisories#get-a-repository-security-advisory
        """

        from ..models import BasicError, RepositoryAdvisory

        url = f"/repos/{owner}/{repo}/security-advisories/{ghsa_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryAdvisory,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_repository_advisory(
        self,
        owner: str,
        repo: str,
        ghsa_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RepositoryAdvisory, RepositoryAdvisoryType]:
        """security-advisories/get-repository-advisory

        GET /repos/{owner}/{repo}/security-advisories/{ghsa_id}

        Get a repository security advisory using its GitHub Security Advisory (GHSA) identifier.

        Anyone can access any published security advisory on a public repository.

        The authenticated user can access an unpublished security advisory from a repository if they are a security manager or administrator of that repository, or if they are a
        collaborator on the security advisory.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:read` scope to to get a published security advisory in a private repository, or any unpublished security advisory that the authenticated user has access to.

        See also: https://docs.github.com/rest/security-advisories/repository-advisories#get-a-repository-security-advisory
        """

        from ..models import BasicError, RepositoryAdvisory

        url = f"/repos/{owner}/{repo}/security-advisories/{ghsa_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryAdvisory,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update_repository_advisory(
        self,
        owner: str,
        repo: str,
        ghsa_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: RepositoryAdvisoryUpdateType,
    ) -> Response[RepositoryAdvisory, RepositoryAdvisoryType]: ...

    @overload
    def update_repository_advisory(
        self,
        owner: str,
        repo: str,
        ghsa_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        summary: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        cve_id: Missing[Union[str, None]] = UNSET,
        vulnerabilities: Missing[
            list[RepositoryAdvisoryUpdatePropVulnerabilitiesItemsType]
        ] = UNSET,
        cwe_ids: Missing[Union[list[str], None]] = UNSET,
        credits_: Missing[
            Union[list[RepositoryAdvisoryUpdatePropCreditsItemsType], None]
        ] = UNSET,
        severity: Missing[
            Union[None, Literal["critical", "high", "medium", "low"]]
        ] = UNSET,
        cvss_vector_string: Missing[Union[str, None]] = UNSET,
        state: Missing[Literal["published", "closed", "draft"]] = UNSET,
        collaborating_users: Missing[Union[list[str], None]] = UNSET,
        collaborating_teams: Missing[Union[list[str], None]] = UNSET,
    ) -> Response[RepositoryAdvisory, RepositoryAdvisoryType]: ...

    def update_repository_advisory(
        self,
        owner: str,
        repo: str,
        ghsa_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[RepositoryAdvisoryUpdateType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryAdvisory, RepositoryAdvisoryType]:
        """security-advisories/update-repository-advisory

        PATCH /repos/{owner}/{repo}/security-advisories/{ghsa_id}

        Update a repository security advisory using its GitHub Security Advisory (GHSA) identifier.

        In order to update any security advisory, the authenticated user must be a security manager or administrator of that repository,
        or a collaborator on the repository security advisory.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.

        See also: https://docs.github.com/rest/security-advisories/repository-advisories#update-a-repository-security-advisory
        """

        from ..models import (
            BasicError,
            RepositoryAdvisory,
            RepositoryAdvisoryUpdate,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/security-advisories/{ghsa_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(RepositoryAdvisoryUpdate, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryAdvisory,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_repository_advisory(
        self,
        owner: str,
        repo: str,
        ghsa_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: RepositoryAdvisoryUpdateType,
    ) -> Response[RepositoryAdvisory, RepositoryAdvisoryType]: ...

    @overload
    async def async_update_repository_advisory(
        self,
        owner: str,
        repo: str,
        ghsa_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        summary: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        cve_id: Missing[Union[str, None]] = UNSET,
        vulnerabilities: Missing[
            list[RepositoryAdvisoryUpdatePropVulnerabilitiesItemsType]
        ] = UNSET,
        cwe_ids: Missing[Union[list[str], None]] = UNSET,
        credits_: Missing[
            Union[list[RepositoryAdvisoryUpdatePropCreditsItemsType], None]
        ] = UNSET,
        severity: Missing[
            Union[None, Literal["critical", "high", "medium", "low"]]
        ] = UNSET,
        cvss_vector_string: Missing[Union[str, None]] = UNSET,
        state: Missing[Literal["published", "closed", "draft"]] = UNSET,
        collaborating_users: Missing[Union[list[str], None]] = UNSET,
        collaborating_teams: Missing[Union[list[str], None]] = UNSET,
    ) -> Response[RepositoryAdvisory, RepositoryAdvisoryType]: ...

    async def async_update_repository_advisory(
        self,
        owner: str,
        repo: str,
        ghsa_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[RepositoryAdvisoryUpdateType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryAdvisory, RepositoryAdvisoryType]:
        """security-advisories/update-repository-advisory

        PATCH /repos/{owner}/{repo}/security-advisories/{ghsa_id}

        Update a repository security advisory using its GitHub Security Advisory (GHSA) identifier.

        In order to update any security advisory, the authenticated user must be a security manager or administrator of that repository,
        or a collaborator on the repository security advisory.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.

        See also: https://docs.github.com/rest/security-advisories/repository-advisories#update-a-repository-security-advisory
        """

        from ..models import (
            BasicError,
            RepositoryAdvisory,
            RepositoryAdvisoryUpdate,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/security-advisories/{ghsa_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(RepositoryAdvisoryUpdate, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryAdvisory,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def create_repository_advisory_cve_request(
        self,
        owner: str,
        repo: str,
        ghsa_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """security-advisories/create-repository-advisory-cve-request

        POST /repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve

        If you want a CVE identification number for the security vulnerability in your project, and don't already have one, you can request a CVE identification number from GitHub. For more information see "[Requesting a CVE identification number](https://docs.github.com/code-security/security-advisories/repository-security-advisories/publishing-a-repository-security-advisory#requesting-a-cve-identification-number-optional)."

        You may request a CVE for public repositories, but cannot do so for private repositories.

        In order to request a CVE for a repository security advisory, the authenticated user must be a security manager or administrator of that repository.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.

        See also: https://docs.github.com/rest/security-advisories/repository-advisories#request-a-cve-for-a-repository-security-advisory
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_create_repository_advisory_cve_request(
        self,
        owner: str,
        repo: str,
        ghsa_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """security-advisories/create-repository-advisory-cve-request

        POST /repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve

        If you want a CVE identification number for the security vulnerability in your project, and don't already have one, you can request a CVE identification number from GitHub. For more information see "[Requesting a CVE identification number](https://docs.github.com/code-security/security-advisories/repository-security-advisories/publishing-a-repository-security-advisory#requesting-a-cve-identification-number-optional)."

        You may request a CVE for public repositories, but cannot do so for private repositories.

        In order to request a CVE for a repository security advisory, the authenticated user must be a security manager or administrator of that repository.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `repository_advisories:write` scope to use this endpoint.

        See also: https://docs.github.com/rest/security-advisories/repository-advisories#request-a-cve-for-a-repository-security-advisory
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/security-advisories/{ghsa_id}/cve"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def create_fork(
        self,
        owner: str,
        repo: str,
        ghsa_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[FullRepository, FullRepositoryType]:
        """security-advisories/create-fork

        POST /repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks

        Create a temporary private fork to collaborate on fixing a security vulnerability in your repository.

        > [!NOTE]
        > Forking a repository happens asynchronously. You may have to wait up to 5 minutes before you can access the fork.

        See also: https://docs.github.com/rest/security-advisories/repository-advisories#create-a-temporary-private-fork
        """

        from ..models import BasicError, FullRepository, ValidationError

        url = f"/repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=FullRepository,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_create_fork(
        self,
        owner: str,
        repo: str,
        ghsa_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[FullRepository, FullRepositoryType]:
        """security-advisories/create-fork

        POST /repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks

        Create a temporary private fork to collaborate on fixing a security vulnerability in your repository.

        > [!NOTE]
        > Forking a repository happens asynchronously. You may have to wait up to 5 minutes before you can access the fork.

        See also: https://docs.github.com/rest/security-advisories/repository-advisories#create-a-temporary-private-fork
        """

        from ..models import BasicError, FullRepository, ValidationError

        url = f"/repos/{owner}/{repo}/security-advisories/{ghsa_id}/forks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=FullRepository,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )
