"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from datetime import date

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        CopilotOrganizationDetails,
        CopilotSeatDetails,
        CopilotUsageMetrics1DayReport,
        CopilotUsageMetrics28DayReport,
        CopilotUsageMetricsDay,
        EnterprisesEnterpriseCopilotBillingSeatsGetResponse200,
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteResponse200,
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostResponse201,
        EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteResponse200,
        EnterprisesEnterpriseCopilotBillingSelectedUsersPostResponse201,
        EnterprisesEnterpriseMembersUsernameCopilotGetResponse200,
        OrgsOrgCopilotBillingSeatsGetResponse200,
        OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200,
        OrgsOrgCopilotBillingSelectedTeamsPostResponse201,
        OrgsOrgCopilotBillingSelectedUsersDeleteResponse200,
        OrgsOrgCopilotBillingSelectedUsersPostResponse201,
    )
    from ..types import (
        CopilotOrganizationDetailsType,
        CopilotSeatDetailsType,
        CopilotUsageMetrics1DayReportType,
        CopilotUsageMetrics28DayReportType,
        CopilotUsageMetricsDayType,
        EnterprisesEnterpriseCopilotBillingSeatsGetResponse200Type,
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteBodyType,
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteResponse200Type,
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostBodyType,
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostResponse201Type,
        EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteBodyType,
        EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteResponse200Type,
        EnterprisesEnterpriseCopilotBillingSelectedUsersPostBodyType,
        EnterprisesEnterpriseCopilotBillingSelectedUsersPostResponse201Type,
        EnterprisesEnterpriseMembersUsernameCopilotGetResponse200Type,
        OrgsOrgCopilotBillingSeatsGetResponse200Type,
        OrgsOrgCopilotBillingSelectedTeamsDeleteBodyType,
        OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200Type,
        OrgsOrgCopilotBillingSelectedTeamsPostBodyType,
        OrgsOrgCopilotBillingSelectedTeamsPostResponse201Type,
        OrgsOrgCopilotBillingSelectedUsersDeleteBodyType,
        OrgsOrgCopilotBillingSelectedUsersDeleteResponse200Type,
        OrgsOrgCopilotBillingSelectedUsersPostBodyType,
        OrgsOrgCopilotBillingSelectedUsersPostResponse201Type,
    )


class CopilotClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_copilot_seats_for_enterprise(
        self,
        enterprise: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSeatsGetResponse200,
        EnterprisesEnterpriseCopilotBillingSeatsGetResponse200Type,
    ]:
        """copilot/list-copilot-seats-for-enterprise

        GET /enterprises/{enterprise}/copilot/billing/seats

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Lists all Copilot seats currently being billed for across organizations or enterprise teams for an enterprise with a Copilot Business or Copilot Enterprise subscription.

        Users with access through multiple organizations or enterprise teams will only be counted toward `total_seats` once.

        For each organization or enterprise team which grants Copilot access to a user, a seat detail object will appear in the `seats` array.
        Each seat object contains information about the assigned user's most recent Copilot activity. Users must have
        telemetry enabled in their IDE for Copilot in the IDE activity to be reflected in `last_activity_at`. For more information about activity data,
        see [Metrics data properties for GitHub Copilot](https://docs.github.com/enterprise-cloud@latest//copilot/reference/metrics-data).

        Only enterprise owners and billing managers can view assigned Copilot seats across their child organizations or enterprise teams.

        Personal access tokens (classic) need either the `manage_billing:copilot` or `read:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#list-all-copilot-seat-assignments-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCopilotBillingSeatsGetResponse200,
        )

        url = f"/enterprises/{enterprise}/copilot/billing/seats"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseCopilotBillingSeatsGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_copilot_seats_for_enterprise(
        self,
        enterprise: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSeatsGetResponse200,
        EnterprisesEnterpriseCopilotBillingSeatsGetResponse200Type,
    ]:
        """copilot/list-copilot-seats-for-enterprise

        GET /enterprises/{enterprise}/copilot/billing/seats

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Lists all Copilot seats currently being billed for across organizations or enterprise teams for an enterprise with a Copilot Business or Copilot Enterprise subscription.

        Users with access through multiple organizations or enterprise teams will only be counted toward `total_seats` once.

        For each organization or enterprise team which grants Copilot access to a user, a seat detail object will appear in the `seats` array.
        Each seat object contains information about the assigned user's most recent Copilot activity. Users must have
        telemetry enabled in their IDE for Copilot in the IDE activity to be reflected in `last_activity_at`. For more information about activity data,
        see [Metrics data properties for GitHub Copilot](https://docs.github.com/enterprise-cloud@latest//copilot/reference/metrics-data).

        Only enterprise owners and billing managers can view assigned Copilot seats across their child organizations or enterprise teams.

        Personal access tokens (classic) need either the `manage_billing:copilot` or `read:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#list-all-copilot-seat-assignments-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCopilotBillingSeatsGetResponse200,
        )

        url = f"/enterprises/{enterprise}/copilot/billing/seats"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseCopilotBillingSeatsGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def add_copilot_seats_for_enterprise_teams(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostResponse201,
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostResponse201Type,
    ]: ...

    @overload
    def add_copilot_seats_for_enterprise_teams(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_enterprise_teams: list[str],
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostResponse201,
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostResponse201Type,
    ]: ...

    def add_copilot_seats_for_enterprise_teams(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostResponse201,
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostResponse201Type,
    ]:
        """copilot/add-copilot-seats-for-enterprise-teams

        POST /enterprises/{enterprise}/copilot/billing/selected_enterprise_teams

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Purchases a GitHub Copilot seat for all users within each specified enterprise team. The enterprise will be billed accordingly.

        Only enterprise owners can purchase Copilot seats for their enterprise members.

        The response contains the total number of new seats that were created and existing seats that were refreshed.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#add-enterprise-teams-to-the-copilot-subscription-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostBody,
            EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostResponse201,
        )

        url = f"/enterprises/{enterprise}/copilot/billing/selected_enterprise_teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostResponse201,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_add_copilot_seats_for_enterprise_teams(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostResponse201,
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostResponse201Type,
    ]: ...

    @overload
    async def async_add_copilot_seats_for_enterprise_teams(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_enterprise_teams: list[str],
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostResponse201,
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostResponse201Type,
    ]: ...

    async def async_add_copilot_seats_for_enterprise_teams(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostResponse201,
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostResponse201Type,
    ]:
        """copilot/add-copilot-seats-for-enterprise-teams

        POST /enterprises/{enterprise}/copilot/billing/selected_enterprise_teams

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Purchases a GitHub Copilot seat for all users within each specified enterprise team. The enterprise will be billed accordingly.

        Only enterprise owners can purchase Copilot seats for their enterprise members.

        The response contains the total number of new seats that were created and existing seats that were refreshed.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#add-enterprise-teams-to-the-copilot-subscription-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostBody,
            EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostResponse201,
        )

        url = f"/enterprises/{enterprise}/copilot/billing/selected_enterprise_teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsPostResponse201,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def cancel_copilot_seats_for_enterprise_teams(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteBodyType,
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteResponse200,
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteResponse200Type,
    ]: ...

    @overload
    def cancel_copilot_seats_for_enterprise_teams(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_enterprise_teams: list[str],
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteResponse200,
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteResponse200Type,
    ]: ...

    def cancel_copilot_seats_for_enterprise_teams(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteResponse200,
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteResponse200Type,
    ]:
        """copilot/cancel-copilot-seats-for-enterprise-teams

        DELETE /enterprises/{enterprise}/copilot/billing/selected_enterprise_teams

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Sets seats for all members of each enterprise team specified to "pending cancellation".
        This will cause the members of the specified enterprise team(s) to lose access to GitHub Copilot at the end of the current billing cycle unless they retain access through another enterprise team.

        Only enterprise owners can cancel Copilot seats for their enterprise members.

        The response contains the total number of seats set to "pending cancellation".

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#remove-enterprise-teams-from-the-copilot-subscription-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteBody,
            EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteResponse200,
        )

        url = f"/enterprises/{enterprise}/copilot/billing/selected_enterprise_teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_cancel_copilot_seats_for_enterprise_teams(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteBodyType,
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteResponse200,
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteResponse200Type,
    ]: ...

    @overload
    async def async_cancel_copilot_seats_for_enterprise_teams(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_enterprise_teams: list[str],
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteResponse200,
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteResponse200Type,
    ]: ...

    async def async_cancel_copilot_seats_for_enterprise_teams(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteResponse200,
        EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteResponse200Type,
    ]:
        """copilot/cancel-copilot-seats-for-enterprise-teams

        DELETE /enterprises/{enterprise}/copilot/billing/selected_enterprise_teams

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Sets seats for all members of each enterprise team specified to "pending cancellation".
        This will cause the members of the specified enterprise team(s) to lose access to GitHub Copilot at the end of the current billing cycle unless they retain access through another enterprise team.

        Only enterprise owners can cancel Copilot seats for their enterprise members.

        The response contains the total number of seats set to "pending cancellation".

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#remove-enterprise-teams-from-the-copilot-subscription-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteBody,
            EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteResponse200,
        )

        url = f"/enterprises/{enterprise}/copilot/billing/selected_enterprise_teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseCopilotBillingSelectedEnterpriseTeamsDeleteResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def add_copilot_seats_for_enterprise_users(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseCopilotBillingSelectedUsersPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedUsersPostResponse201,
        EnterprisesEnterpriseCopilotBillingSelectedUsersPostResponse201Type,
    ]: ...

    @overload
    def add_copilot_seats_for_enterprise_users(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_usernames: list[str],
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedUsersPostResponse201,
        EnterprisesEnterpriseCopilotBillingSelectedUsersPostResponse201Type,
    ]: ...

    def add_copilot_seats_for_enterprise_users(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseCopilotBillingSelectedUsersPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedUsersPostResponse201,
        EnterprisesEnterpriseCopilotBillingSelectedUsersPostResponse201Type,
    ]:
        """copilot/add-copilot-seats-for-enterprise-users

        POST /enterprises/{enterprise}/copilot/billing/selected_users

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Purchases a GitHub Copilot seat for each user specified.
        The enterprise will be billed accordingly.

        Only enterprise owners can purchase Copilot seats for their enterprise members.

        The response contains the total number of new seats that were created and existing seats that were refreshed.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#add-users-to-the-copilot-subscription-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCopilotBillingSelectedUsersPostBody,
            EnterprisesEnterpriseCopilotBillingSelectedUsersPostResponse201,
        )

        url = f"/enterprises/{enterprise}/copilot/billing/selected_users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseCopilotBillingSelectedUsersPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseCopilotBillingSelectedUsersPostResponse201,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_add_copilot_seats_for_enterprise_users(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseCopilotBillingSelectedUsersPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedUsersPostResponse201,
        EnterprisesEnterpriseCopilotBillingSelectedUsersPostResponse201Type,
    ]: ...

    @overload
    async def async_add_copilot_seats_for_enterprise_users(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_usernames: list[str],
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedUsersPostResponse201,
        EnterprisesEnterpriseCopilotBillingSelectedUsersPostResponse201Type,
    ]: ...

    async def async_add_copilot_seats_for_enterprise_users(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseCopilotBillingSelectedUsersPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedUsersPostResponse201,
        EnterprisesEnterpriseCopilotBillingSelectedUsersPostResponse201Type,
    ]:
        """copilot/add-copilot-seats-for-enterprise-users

        POST /enterprises/{enterprise}/copilot/billing/selected_users

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Purchases a GitHub Copilot seat for each user specified.
        The enterprise will be billed accordingly.

        Only enterprise owners can purchase Copilot seats for their enterprise members.

        The response contains the total number of new seats that were created and existing seats that were refreshed.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#add-users-to-the-copilot-subscription-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCopilotBillingSelectedUsersPostBody,
            EnterprisesEnterpriseCopilotBillingSelectedUsersPostResponse201,
        )

        url = f"/enterprises/{enterprise}/copilot/billing/selected_users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseCopilotBillingSelectedUsersPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseCopilotBillingSelectedUsersPostResponse201,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def cancel_copilot_seats_for_enterprise_users(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteBodyType,
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteResponse200,
        EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteResponse200Type,
    ]: ...

    @overload
    def cancel_copilot_seats_for_enterprise_users(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_usernames: list[str],
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteResponse200,
        EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteResponse200Type,
    ]: ...

    def cancel_copilot_seats_for_enterprise_users(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteResponse200,
        EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteResponse200Type,
    ]:
        """copilot/cancel-copilot-seats-for-enterprise-users

        DELETE /enterprises/{enterprise}/copilot/billing/selected_users

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Sets seats for all users specified to "pending cancellation".
        This will cause the specified users to lose access to GitHub Copilot at the end of the current billing cycle unless they retain access through team or organization membership.

        Only enterprise owners can cancel Copilot seats for their enterprise members.

        The response contains the total number of seats set to "pending cancellation".

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#remove-users-from-the-copilot-subscription-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteBody,
            EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteResponse200,
        )

        url = f"/enterprises/{enterprise}/copilot/billing/selected_users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_cancel_copilot_seats_for_enterprise_users(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteBodyType,
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteResponse200,
        EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteResponse200Type,
    ]: ...

    @overload
    async def async_cancel_copilot_seats_for_enterprise_users(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_usernames: list[str],
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteResponse200,
        EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteResponse200Type,
    ]: ...

    async def async_cancel_copilot_seats_for_enterprise_users(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteResponse200,
        EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteResponse200Type,
    ]:
        """copilot/cancel-copilot-seats-for-enterprise-users

        DELETE /enterprises/{enterprise}/copilot/billing/selected_users

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Sets seats for all users specified to "pending cancellation".
        This will cause the specified users to lose access to GitHub Copilot at the end of the current billing cycle unless they retain access through team or organization membership.

        Only enterprise owners can cancel Copilot seats for their enterprise members.

        The response contains the total number of seats set to "pending cancellation".

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#remove-users-from-the-copilot-subscription-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteBody,
            EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteResponse200,
        )

        url = f"/enterprises/{enterprise}/copilot/billing/selected_users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseCopilotBillingSelectedUsersDeleteResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def copilot_metrics_for_enterprise(
        self,
        enterprise: str,
        *,
        since: Missing[str] = UNSET,
        until: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CopilotUsageMetricsDay], list[CopilotUsageMetricsDayType]]:
        """copilot/copilot-metrics-for-enterprise

        GET /enterprises/{enterprise}/copilot/metrics

        Use this endpoint to see a breakdown of aggregated metrics for various GitHub Copilot features. See the response schema tab for detailed metrics definitions.

        The response contains metrics for up to 100 days prior. Metrics are processed once per day for the previous day,
        and the response will only include data up until yesterday. In order for an end user to be counted towards these metrics,
        they must have telemetry enabled in their IDE.

        To access this endpoint, the Copilot Metrics API access policy must be enabled or set to "no policy" for the enterprise within GitHub settings.
        Only enterprise owners and billing managers can view Copilot metrics for the enterprise.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-metrics#get-copilot-metrics-for-an-enterprise
        """

        from ..models import BasicError, CopilotUsageMetricsDay

        url = f"/enterprises/{enterprise}/copilot/metrics"

        params = {
            "since": since,
            "until": until,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CopilotUsageMetricsDay],
            error_models={
                "500": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": BasicError,
            },
        )

    async def async_copilot_metrics_for_enterprise(
        self,
        enterprise: str,
        *,
        since: Missing[str] = UNSET,
        until: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CopilotUsageMetricsDay], list[CopilotUsageMetricsDayType]]:
        """copilot/copilot-metrics-for-enterprise

        GET /enterprises/{enterprise}/copilot/metrics

        Use this endpoint to see a breakdown of aggregated metrics for various GitHub Copilot features. See the response schema tab for detailed metrics definitions.

        The response contains metrics for up to 100 days prior. Metrics are processed once per day for the previous day,
        and the response will only include data up until yesterday. In order for an end user to be counted towards these metrics,
        they must have telemetry enabled in their IDE.

        To access this endpoint, the Copilot Metrics API access policy must be enabled or set to "no policy" for the enterprise within GitHub settings.
        Only enterprise owners and billing managers can view Copilot metrics for the enterprise.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-metrics#get-copilot-metrics-for-an-enterprise
        """

        from ..models import BasicError, CopilotUsageMetricsDay

        url = f"/enterprises/{enterprise}/copilot/metrics"

        params = {
            "since": since,
            "until": until,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CopilotUsageMetricsDay],
            error_models={
                "500": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": BasicError,
            },
        )

    def copilot_enterprise_one_day_usage_metrics(
        self,
        enterprise: str,
        *,
        day: date,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CopilotUsageMetrics1DayReport, CopilotUsageMetrics1DayReportType]:
        """copilot/copilot-enterprise-one-day-usage-metrics

        GET /enterprises/{enterprise}/copilot/metrics/reports/enterprise-1-day

        Use this endpoint to retrieve download links for the Copilot enterprise usage metrics report for a specific day. The report provides comprehensive usage data for Copilot features across the enterprise.

        The report contains aggregated metrics for the specified day, including usage statistics for various Copilot features, user engagement data, and feature adoption metrics. Reports are generated daily and made available for download through signed URLs with a limited expiration time.

        The response includes download links to the report files, along with the specific date of the report. The report covers a complete day for which data has been processed. Reports are available starting from October 10, 2025, and historical data can be accessed for up to 1 year from the current date.

        Only enterprise owners and billing managers can retrieve Copilot metrics reports for the enterprise. OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-metrics#get-copilot-enterprise-usage-metrics-for-a-specific-day
        """

        from ..models import BasicError, CopilotUsageMetrics1DayReport

        url = f"/enterprises/{enterprise}/copilot/metrics/reports/enterprise-1-day"

        params = {
            "day": day,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CopilotUsageMetrics1DayReport,
            error_models={
                "500": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_copilot_enterprise_one_day_usage_metrics(
        self,
        enterprise: str,
        *,
        day: date,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CopilotUsageMetrics1DayReport, CopilotUsageMetrics1DayReportType]:
        """copilot/copilot-enterprise-one-day-usage-metrics

        GET /enterprises/{enterprise}/copilot/metrics/reports/enterprise-1-day

        Use this endpoint to retrieve download links for the Copilot enterprise usage metrics report for a specific day. The report provides comprehensive usage data for Copilot features across the enterprise.

        The report contains aggregated metrics for the specified day, including usage statistics for various Copilot features, user engagement data, and feature adoption metrics. Reports are generated daily and made available for download through signed URLs with a limited expiration time.

        The response includes download links to the report files, along with the specific date of the report. The report covers a complete day for which data has been processed. Reports are available starting from October 10, 2025, and historical data can be accessed for up to 1 year from the current date.

        Only enterprise owners and billing managers can retrieve Copilot metrics reports for the enterprise. OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-metrics#get-copilot-enterprise-usage-metrics-for-a-specific-day
        """

        from ..models import BasicError, CopilotUsageMetrics1DayReport

        url = f"/enterprises/{enterprise}/copilot/metrics/reports/enterprise-1-day"

        params = {
            "day": day,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CopilotUsageMetrics1DayReport,
            error_models={
                "500": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def copilot_enterprise_usage_metrics(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CopilotUsageMetrics28DayReport, CopilotUsageMetrics28DayReportType]:
        """copilot/copilot-enterprise-usage-metrics

        GET /enterprises/{enterprise}/copilot/metrics/reports/enterprise-28-day/latest

        Use this endpoint to retrieve download links for the latest 28-day enterprise Copilot usage metrics report. The report provides comprehensive usage data for Copilot features across the enterprise.

        The report contains aggregated metrics for the previous 28 days, including usage statistics for various Copilot features, user engagement data, and feature adoption metrics. Reports are generated daily and made available for download through signed URLs with a limited expiration time.

        The response includes download links to the report files, along with the specific date range covered by the report. The report covers a complete 28-day period ending on the most recent day for which data has been processed.

        Only enterprise owners and billing managers can retrieve Copilot metrics reports for the enterprise. OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-metrics#get-copilot-enterprise-usage-metrics
        """

        from ..models import BasicError, CopilotUsageMetrics28DayReport

        url = f"/enterprises/{enterprise}/copilot/metrics/reports/enterprise-28-day/latest"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CopilotUsageMetrics28DayReport,
            error_models={
                "500": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_copilot_enterprise_usage_metrics(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CopilotUsageMetrics28DayReport, CopilotUsageMetrics28DayReportType]:
        """copilot/copilot-enterprise-usage-metrics

        GET /enterprises/{enterprise}/copilot/metrics/reports/enterprise-28-day/latest

        Use this endpoint to retrieve download links for the latest 28-day enterprise Copilot usage metrics report. The report provides comprehensive usage data for Copilot features across the enterprise.

        The report contains aggregated metrics for the previous 28 days, including usage statistics for various Copilot features, user engagement data, and feature adoption metrics. Reports are generated daily and made available for download through signed URLs with a limited expiration time.

        The response includes download links to the report files, along with the specific date range covered by the report. The report covers a complete 28-day period ending on the most recent day for which data has been processed.

        Only enterprise owners and billing managers can retrieve Copilot metrics reports for the enterprise. OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-metrics#get-copilot-enterprise-usage-metrics
        """

        from ..models import BasicError, CopilotUsageMetrics28DayReport

        url = f"/enterprises/{enterprise}/copilot/metrics/reports/enterprise-28-day/latest"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CopilotUsageMetrics28DayReport,
            error_models={
                "500": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def copilot_users_one_day_usage_metrics(
        self,
        enterprise: str,
        *,
        day: date,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CopilotUsageMetrics1DayReport, CopilotUsageMetrics1DayReportType]:
        """copilot/copilot-users-one-day-usage-metrics

        GET /enterprises/{enterprise}/copilot/metrics/reports/users-1-day

        Use this endpoint to retrieve download links for the Copilot user usage metrics report for a specific day. The report provides detailed user-level usage data and engagement metrics for Copilot features across the enterprise.

        The report contains user-specific metrics for the specified day, including individual user engagement statistics, feature usage patterns, and adoption metrics broken down by user. This report allows enterprise administrators to analyze Copilot usage at the user level to understand adoption patterns and identify opportunities for increased engagement.

        Reports are generated daily and made available for download through signed URLs with a limited expiration time. The response includes download links to the report files, along with the specific date of the report. The report covers a complete day for which data has been processed. Reports are available starting from October 10, 2025, and historical data can be accessed for up to 1 year from the current date.

        Only enterprise owners and billing managers can retrieve Copilot user metrics reports for the enterprise. OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-metrics#get-copilot-users-usage-metrics-for-a-specific-day
        """

        from ..models import BasicError, CopilotUsageMetrics1DayReport

        url = f"/enterprises/{enterprise}/copilot/metrics/reports/users-1-day"

        params = {
            "day": day,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CopilotUsageMetrics1DayReport,
            error_models={
                "500": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_copilot_users_one_day_usage_metrics(
        self,
        enterprise: str,
        *,
        day: date,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CopilotUsageMetrics1DayReport, CopilotUsageMetrics1DayReportType]:
        """copilot/copilot-users-one-day-usage-metrics

        GET /enterprises/{enterprise}/copilot/metrics/reports/users-1-day

        Use this endpoint to retrieve download links for the Copilot user usage metrics report for a specific day. The report provides detailed user-level usage data and engagement metrics for Copilot features across the enterprise.

        The report contains user-specific metrics for the specified day, including individual user engagement statistics, feature usage patterns, and adoption metrics broken down by user. This report allows enterprise administrators to analyze Copilot usage at the user level to understand adoption patterns and identify opportunities for increased engagement.

        Reports are generated daily and made available for download through signed URLs with a limited expiration time. The response includes download links to the report files, along with the specific date of the report. The report covers a complete day for which data has been processed. Reports are available starting from October 10, 2025, and historical data can be accessed for up to 1 year from the current date.

        Only enterprise owners and billing managers can retrieve Copilot user metrics reports for the enterprise. OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-metrics#get-copilot-users-usage-metrics-for-a-specific-day
        """

        from ..models import BasicError, CopilotUsageMetrics1DayReport

        url = f"/enterprises/{enterprise}/copilot/metrics/reports/users-1-day"

        params = {
            "day": day,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CopilotUsageMetrics1DayReport,
            error_models={
                "500": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def copilot_users_usage_metrics(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CopilotUsageMetrics28DayReport, CopilotUsageMetrics28DayReportType]:
        """copilot/copilot-users-usage-metrics

        GET /enterprises/{enterprise}/copilot/metrics/reports/users-28-day/latest

        Use this endpoint to retrieve download links for the latest 28-day enterprise users Copilot usage metrics report. The report provides detailed user-level usage data and engagement metrics for Copilot features across the enterprise.

        The report contains user-specific metrics for the previous 28 days, including individual user engagement statistics, feature usage patterns, and adoption metrics broken down by user. This report allows enterprise administrators to analyze Copilot usage at the user level to understand adoption patterns and identify opportunities for increased engagement.

        Reports are generated daily and made available for download through signed URLs with a limited expiration time. The response includes download links to the report files, along with the specific date range covered by the report. The report covers a complete 28-day period ending on the most recent day for which data has been processed.

        Only enterprise owners and billing managers can retrieve Copilot users metrics reports for the enterprise. OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-metrics#get-copilot-users-usage-metrics
        """

        from ..models import BasicError, CopilotUsageMetrics28DayReport

        url = f"/enterprises/{enterprise}/copilot/metrics/reports/users-28-day/latest"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CopilotUsageMetrics28DayReport,
            error_models={
                "500": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_copilot_users_usage_metrics(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CopilotUsageMetrics28DayReport, CopilotUsageMetrics28DayReportType]:
        """copilot/copilot-users-usage-metrics

        GET /enterprises/{enterprise}/copilot/metrics/reports/users-28-day/latest

        Use this endpoint to retrieve download links for the latest 28-day enterprise users Copilot usage metrics report. The report provides detailed user-level usage data and engagement metrics for Copilot features across the enterprise.

        The report contains user-specific metrics for the previous 28 days, including individual user engagement statistics, feature usage patterns, and adoption metrics broken down by user. This report allows enterprise administrators to analyze Copilot usage at the user level to understand adoption patterns and identify opportunities for increased engagement.

        Reports are generated daily and made available for download through signed URLs with a limited expiration time. The response includes download links to the report files, along with the specific date range covered by the report. The report covers a complete 28-day period ending on the most recent day for which data has been processed.

        Only enterprise owners and billing managers can retrieve Copilot users metrics reports for the enterprise. OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-metrics#get-copilot-users-usage-metrics
        """

        from ..models import BasicError, CopilotUsageMetrics28DayReport

        url = f"/enterprises/{enterprise}/copilot/metrics/reports/users-28-day/latest"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CopilotUsageMetrics28DayReport,
            error_models={
                "500": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def get_copilot_seat_details_for_enterprise_user(
        self,
        enterprise: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseMembersUsernameCopilotGetResponse200,
        EnterprisesEnterpriseMembersUsernameCopilotGetResponse200Type,
    ]:
        """copilot/get-copilot-seat-details-for-enterprise-user

        GET /enterprises/{enterprise}/members/{username}/copilot

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Gets the GitHub Copilot seat details for a member of an enterprise who currently has access to GitHub Copilot.

        The seat object contains information about the user's most recent Copilot activity. Users must have telemetry enabled in their IDE for Copilot in the IDE activity to be reflected in `last_activity_at`.

        Only enterprise owners can view Copilot seat assignment details for members of their enterprise.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:org` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#get-copilot-seat-assignment-details-for-an-enterprise-user
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseMembersUsernameCopilotGetResponse200,
        )

        url = f"/enterprises/{enterprise}/members/{username}/copilot"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseMembersUsernameCopilotGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_copilot_seat_details_for_enterprise_user(
        self,
        enterprise: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        EnterprisesEnterpriseMembersUsernameCopilotGetResponse200,
        EnterprisesEnterpriseMembersUsernameCopilotGetResponse200Type,
    ]:
        """copilot/get-copilot-seat-details-for-enterprise-user

        GET /enterprises/{enterprise}/members/{username}/copilot

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Gets the GitHub Copilot seat details for a member of an enterprise who currently has access to GitHub Copilot.

        The seat object contains information about the user's most recent Copilot activity. Users must have telemetry enabled in their IDE for Copilot in the IDE activity to be reflected in `last_activity_at`.

        Only enterprise owners can view Copilot seat assignment details for members of their enterprise.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:org` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#get-copilot-seat-assignment-details-for-an-enterprise-user
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseMembersUsernameCopilotGetResponse200,
        )

        url = f"/enterprises/{enterprise}/members/{username}/copilot"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseMembersUsernameCopilotGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def copilot_metrics_for_enterprise_team(
        self,
        enterprise: str,
        team_slug: str,
        *,
        since: Missing[str] = UNSET,
        until: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CopilotUsageMetricsDay], list[CopilotUsageMetricsDayType]]:
        """copilot/copilot-metrics-for-enterprise-team

        GET /enterprises/{enterprise}/team/{team_slug}/copilot/metrics

        > [!NOTE]
        > This endpoint is only applicable to dedicated enterprise accounts for Copilot Business. See "[About enterprise accounts for Copilot Business](https://docs.github.com/enterprise-cloud@latest//admin/copilot-business-only/about-enterprise-accounts-for-copilot-business)."

        Use this endpoint to see a breakdown of aggregated metrics for various GitHub Copilot features. See the response schema tab for detailed metrics definitions.

        The response contains metrics for up to 100 days prior. Metrics are processed once per day for the previous day,
        and the response will only include data up until yesterday. In order for an end user to be counted towards these metrics,
        they must have telemetry enabled in their IDE.

        > [!NOTE]
        > This endpoint will only return results for a given day if the enterprise team had **five or more members with active Copilot licenses** on that day, as evaluated at the end of that day.

        To access this endpoint, the Copilot Metrics API access policy must be enabled or set to "no policy" for the enterprise within GitHub settings.
        Only owners and billing managers for the enterprise that contains the enterprise team can view Copilot metrics for the enterprise team.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-metrics#get-copilot-metrics-for-an-enterprise-team
        """

        from ..models import BasicError, CopilotUsageMetricsDay

        url = f"/enterprises/{enterprise}/team/{team_slug}/copilot/metrics"

        params = {
            "since": since,
            "until": until,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CopilotUsageMetricsDay],
            error_models={
                "500": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": BasicError,
            },
        )

    async def async_copilot_metrics_for_enterprise_team(
        self,
        enterprise: str,
        team_slug: str,
        *,
        since: Missing[str] = UNSET,
        until: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CopilotUsageMetricsDay], list[CopilotUsageMetricsDayType]]:
        """copilot/copilot-metrics-for-enterprise-team

        GET /enterprises/{enterprise}/team/{team_slug}/copilot/metrics

        > [!NOTE]
        > This endpoint is only applicable to dedicated enterprise accounts for Copilot Business. See "[About enterprise accounts for Copilot Business](https://docs.github.com/enterprise-cloud@latest//admin/copilot-business-only/about-enterprise-accounts-for-copilot-business)."

        Use this endpoint to see a breakdown of aggregated metrics for various GitHub Copilot features. See the response schema tab for detailed metrics definitions.

        The response contains metrics for up to 100 days prior. Metrics are processed once per day for the previous day,
        and the response will only include data up until yesterday. In order for an end user to be counted towards these metrics,
        they must have telemetry enabled in their IDE.

        > [!NOTE]
        > This endpoint will only return results for a given day if the enterprise team had **five or more members with active Copilot licenses** on that day, as evaluated at the end of that day.

        To access this endpoint, the Copilot Metrics API access policy must be enabled or set to "no policy" for the enterprise within GitHub settings.
        Only owners and billing managers for the enterprise that contains the enterprise team can view Copilot metrics for the enterprise team.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-metrics#get-copilot-metrics-for-an-enterprise-team
        """

        from ..models import BasicError, CopilotUsageMetricsDay

        url = f"/enterprises/{enterprise}/team/{team_slug}/copilot/metrics"

        params = {
            "since": since,
            "until": until,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CopilotUsageMetricsDay],
            error_models={
                "500": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": BasicError,
            },
        )

    def get_copilot_organization_details(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CopilotOrganizationDetails, CopilotOrganizationDetailsType]:
        """copilot/get-copilot-organization-details

        GET /orgs/{org}/copilot/billing

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Gets information about an organization's Copilot subscription, including seat breakdown
        and feature policies. To configure these settings, go to your organization's settings on GitHub.com.
        For more information, see "[Managing policies for Copilot in your organization](https://docs.github.com/enterprise-cloud@latest//copilot/managing-copilot/managing-policies-for-copilot-business-in-your-organization)."

        Only organization owners can view details about the organization's Copilot Business or Copilot Enterprise subscription.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:org` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#get-copilot-seat-information-and-settings-for-an-organization
        """

        from ..models import BasicError, CopilotOrganizationDetails

        url = f"/orgs/{org}/copilot/billing"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CopilotOrganizationDetails,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_copilot_organization_details(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CopilotOrganizationDetails, CopilotOrganizationDetailsType]:
        """copilot/get-copilot-organization-details

        GET /orgs/{org}/copilot/billing

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Gets information about an organization's Copilot subscription, including seat breakdown
        and feature policies. To configure these settings, go to your organization's settings on GitHub.com.
        For more information, see "[Managing policies for Copilot in your organization](https://docs.github.com/enterprise-cloud@latest//copilot/managing-copilot/managing-policies-for-copilot-business-in-your-organization)."

        Only organization owners can view details about the organization's Copilot Business or Copilot Enterprise subscription.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:org` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#get-copilot-seat-information-and-settings-for-an-organization
        """

        from ..models import BasicError, CopilotOrganizationDetails

        url = f"/orgs/{org}/copilot/billing"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CopilotOrganizationDetails,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_copilot_seats(
        self,
        org: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgCopilotBillingSeatsGetResponse200,
        OrgsOrgCopilotBillingSeatsGetResponse200Type,
    ]:
        """copilot/list-copilot-seats

        GET /orgs/{org}/copilot/billing/seats

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Lists all Copilot seats for which an organization with a Copilot Business or Copilot Enterprise subscription is currently being billed.
        Only organization owners can view assigned seats.

        Each seat object contains information about the assigned user's most recent Copilot activity. Users must have telemetry enabled in their IDE for Copilot in the IDE activity to be reflected in `last_activity_at`.
        For more information about activity data, see [Metrics data properties for GitHub Copilot](https://docs.github.com/enterprise-cloud@latest//copilot/reference/metrics-data).

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:org` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#list-all-copilot-seat-assignments-for-an-organization
        """

        from ..models import BasicError, OrgsOrgCopilotBillingSeatsGetResponse200

        url = f"/orgs/{org}/copilot/billing/seats"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgCopilotBillingSeatsGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_copilot_seats(
        self,
        org: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgCopilotBillingSeatsGetResponse200,
        OrgsOrgCopilotBillingSeatsGetResponse200Type,
    ]:
        """copilot/list-copilot-seats

        GET /orgs/{org}/copilot/billing/seats

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Lists all Copilot seats for which an organization with a Copilot Business or Copilot Enterprise subscription is currently being billed.
        Only organization owners can view assigned seats.

        Each seat object contains information about the assigned user's most recent Copilot activity. Users must have telemetry enabled in their IDE for Copilot in the IDE activity to be reflected in `last_activity_at`.
        For more information about activity data, see [Metrics data properties for GitHub Copilot](https://docs.github.com/enterprise-cloud@latest//copilot/reference/metrics-data).

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:org` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#list-all-copilot-seat-assignments-for-an-organization
        """

        from ..models import BasicError, OrgsOrgCopilotBillingSeatsGetResponse200

        url = f"/orgs/{org}/copilot/billing/seats"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgCopilotBillingSeatsGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def add_copilot_seats_for_teams(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCopilotBillingSelectedTeamsPostBodyType,
    ) -> Response[
        OrgsOrgCopilotBillingSelectedTeamsPostResponse201,
        OrgsOrgCopilotBillingSelectedTeamsPostResponse201Type,
    ]: ...

    @overload
    def add_copilot_seats_for_teams(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_teams: list[str],
    ) -> Response[
        OrgsOrgCopilotBillingSelectedTeamsPostResponse201,
        OrgsOrgCopilotBillingSelectedTeamsPostResponse201Type,
    ]: ...

    def add_copilot_seats_for_teams(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgCopilotBillingSelectedTeamsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        OrgsOrgCopilotBillingSelectedTeamsPostResponse201,
        OrgsOrgCopilotBillingSelectedTeamsPostResponse201Type,
    ]:
        """copilot/add-copilot-seats-for-teams

        POST /orgs/{org}/copilot/billing/selected_teams

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Purchases a GitHub Copilot seat for all users within each specified team.
        The organization will be billed for each seat based on the organization's Copilot plan. For more information about Copilot pricing, see "[About billing for GitHub Copilot in your organization](https://docs.github.com/enterprise-cloud@latest//copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-the-copilot-subscription-for-your-organization/about-billing-for-github-copilot-in-your-organization)."

        Only organization owners can purchase Copilot seats for their organization members. The organization must have a Copilot Business or Copilot Enterprise subscription and a configured suggestion matching policy.
        For more information about setting up a Copilot subscription, see "[Subscribing to Copilot for your organization](https://docs.github.com/enterprise-cloud@latest//copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-the-copilot-subscription-for-your-organization/subscribing-to-copilot-for-your-organization)."
        For more information about setting a suggestion matching policy, see "[Managing policies for Copilot in your organization](https://docs.github.com/enterprise-cloud@latest//copilot/managing-copilot/managing-github-copilot-in-your-organization/setting-policies-for-copilot-in-your-organization/managing-policies-for-copilot-in-your-organization#policies-for-suggestion-matching)."

        The response contains the total number of new seats that were created and existing seats that were refreshed.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:org` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#add-teams-to-the-copilot-subscription-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgCopilotBillingSelectedTeamsPostBody,
            OrgsOrgCopilotBillingSelectedTeamsPostResponse201,
        )

        url = f"/orgs/{org}/copilot/billing/selected_teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCopilotBillingSelectedTeamsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgCopilotBillingSelectedTeamsPostResponse201,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_add_copilot_seats_for_teams(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCopilotBillingSelectedTeamsPostBodyType,
    ) -> Response[
        OrgsOrgCopilotBillingSelectedTeamsPostResponse201,
        OrgsOrgCopilotBillingSelectedTeamsPostResponse201Type,
    ]: ...

    @overload
    async def async_add_copilot_seats_for_teams(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_teams: list[str],
    ) -> Response[
        OrgsOrgCopilotBillingSelectedTeamsPostResponse201,
        OrgsOrgCopilotBillingSelectedTeamsPostResponse201Type,
    ]: ...

    async def async_add_copilot_seats_for_teams(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgCopilotBillingSelectedTeamsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        OrgsOrgCopilotBillingSelectedTeamsPostResponse201,
        OrgsOrgCopilotBillingSelectedTeamsPostResponse201Type,
    ]:
        """copilot/add-copilot-seats-for-teams

        POST /orgs/{org}/copilot/billing/selected_teams

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Purchases a GitHub Copilot seat for all users within each specified team.
        The organization will be billed for each seat based on the organization's Copilot plan. For more information about Copilot pricing, see "[About billing for GitHub Copilot in your organization](https://docs.github.com/enterprise-cloud@latest//copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-the-copilot-subscription-for-your-organization/about-billing-for-github-copilot-in-your-organization)."

        Only organization owners can purchase Copilot seats for their organization members. The organization must have a Copilot Business or Copilot Enterprise subscription and a configured suggestion matching policy.
        For more information about setting up a Copilot subscription, see "[Subscribing to Copilot for your organization](https://docs.github.com/enterprise-cloud@latest//copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-the-copilot-subscription-for-your-organization/subscribing-to-copilot-for-your-organization)."
        For more information about setting a suggestion matching policy, see "[Managing policies for Copilot in your organization](https://docs.github.com/enterprise-cloud@latest//copilot/managing-copilot/managing-github-copilot-in-your-organization/setting-policies-for-copilot-in-your-organization/managing-policies-for-copilot-in-your-organization#policies-for-suggestion-matching)."

        The response contains the total number of new seats that were created and existing seats that were refreshed.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:org` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#add-teams-to-the-copilot-subscription-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgCopilotBillingSelectedTeamsPostBody,
            OrgsOrgCopilotBillingSelectedTeamsPostResponse201,
        )

        url = f"/orgs/{org}/copilot/billing/selected_teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCopilotBillingSelectedTeamsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgCopilotBillingSelectedTeamsPostResponse201,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def cancel_copilot_seat_assignment_for_teams(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCopilotBillingSelectedTeamsDeleteBodyType,
    ) -> Response[
        OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200,
        OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200Type,
    ]: ...

    @overload
    def cancel_copilot_seat_assignment_for_teams(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_teams: list[str],
    ) -> Response[
        OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200,
        OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200Type,
    ]: ...

    def cancel_copilot_seat_assignment_for_teams(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgCopilotBillingSelectedTeamsDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200,
        OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200Type,
    ]:
        """copilot/cancel-copilot-seat-assignment-for-teams

        DELETE /orgs/{org}/copilot/billing/selected_teams

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Sets seats for all members of each team specified to "pending cancellation".
        This will cause the members of the specified team(s) to lose access to GitHub Copilot at the end of the current billing cycle unless they retain access through another team.
        For more information about disabling access to Copilot, see "[Revoking access to Copilot for members of your organization](https://docs.github.com/enterprise-cloud@latest//copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-access-to-github-copilot-in-your-organization/revoking-access-to-copilot-for-members-of-your-organization)."

        Only organization owners can cancel Copilot seats for their organization members.

        The response contains the total number of seats set to "pending cancellation".

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:org` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#remove-teams-from-the-copilot-subscription-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgCopilotBillingSelectedTeamsDeleteBody,
            OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200,
        )

        url = f"/orgs/{org}/copilot/billing/selected_teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCopilotBillingSelectedTeamsDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_cancel_copilot_seat_assignment_for_teams(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCopilotBillingSelectedTeamsDeleteBodyType,
    ) -> Response[
        OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200,
        OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200Type,
    ]: ...

    @overload
    async def async_cancel_copilot_seat_assignment_for_teams(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_teams: list[str],
    ) -> Response[
        OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200,
        OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200Type,
    ]: ...

    async def async_cancel_copilot_seat_assignment_for_teams(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgCopilotBillingSelectedTeamsDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200,
        OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200Type,
    ]:
        """copilot/cancel-copilot-seat-assignment-for-teams

        DELETE /orgs/{org}/copilot/billing/selected_teams

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Sets seats for all members of each team specified to "pending cancellation".
        This will cause the members of the specified team(s) to lose access to GitHub Copilot at the end of the current billing cycle unless they retain access through another team.
        For more information about disabling access to Copilot, see "[Revoking access to Copilot for members of your organization](https://docs.github.com/enterprise-cloud@latest//copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-access-to-github-copilot-in-your-organization/revoking-access-to-copilot-for-members-of-your-organization)."

        Only organization owners can cancel Copilot seats for their organization members.

        The response contains the total number of seats set to "pending cancellation".

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:org` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#remove-teams-from-the-copilot-subscription-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgCopilotBillingSelectedTeamsDeleteBody,
            OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200,
        )

        url = f"/orgs/{org}/copilot/billing/selected_teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCopilotBillingSelectedTeamsDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def add_copilot_seats_for_users(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCopilotBillingSelectedUsersPostBodyType,
    ) -> Response[
        OrgsOrgCopilotBillingSelectedUsersPostResponse201,
        OrgsOrgCopilotBillingSelectedUsersPostResponse201Type,
    ]: ...

    @overload
    def add_copilot_seats_for_users(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_usernames: list[str],
    ) -> Response[
        OrgsOrgCopilotBillingSelectedUsersPostResponse201,
        OrgsOrgCopilotBillingSelectedUsersPostResponse201Type,
    ]: ...

    def add_copilot_seats_for_users(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgCopilotBillingSelectedUsersPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        OrgsOrgCopilotBillingSelectedUsersPostResponse201,
        OrgsOrgCopilotBillingSelectedUsersPostResponse201Type,
    ]:
        """copilot/add-copilot-seats-for-users

        POST /orgs/{org}/copilot/billing/selected_users

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Purchases a GitHub Copilot seat for each user specified.
        The organization will be billed for each seat based on the organization's Copilot plan. For more information about Copilot pricing, see "[About billing for GitHub Copilot in your organization](https://docs.github.com/enterprise-cloud@latest//copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-the-copilot-subscription-for-your-organization/about-billing-for-github-copilot-in-your-organization)."

        Only organization owners can purchase Copilot seats for their organization members. The organization must have a Copilot Business or Copilot Enterprise subscription and a configured suggestion matching policy.
        For more information about setting up a Copilot subscription, see "[Subscribing to Copilot for your organization](https://docs.github.com/enterprise-cloud@latest//copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-the-copilot-subscription-for-your-organization/subscribing-to-copilot-for-your-organization)."
        For more information about setting a suggestion matching policy, see "[Managing policies for Copilot in your organization](https://docs.github.com/enterprise-cloud@latest//copilot/managing-copilot/managing-github-copilot-in-your-organization/setting-policies-for-copilot-in-your-organization/managing-policies-for-copilot-in-your-organization#policies-for-suggestion-matching)."

        The response contains the total number of new seats that were created and existing seats that were refreshed.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:org` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#add-users-to-the-copilot-subscription-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgCopilotBillingSelectedUsersPostBody,
            OrgsOrgCopilotBillingSelectedUsersPostResponse201,
        )

        url = f"/orgs/{org}/copilot/billing/selected_users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCopilotBillingSelectedUsersPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgCopilotBillingSelectedUsersPostResponse201,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_add_copilot_seats_for_users(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCopilotBillingSelectedUsersPostBodyType,
    ) -> Response[
        OrgsOrgCopilotBillingSelectedUsersPostResponse201,
        OrgsOrgCopilotBillingSelectedUsersPostResponse201Type,
    ]: ...

    @overload
    async def async_add_copilot_seats_for_users(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_usernames: list[str],
    ) -> Response[
        OrgsOrgCopilotBillingSelectedUsersPostResponse201,
        OrgsOrgCopilotBillingSelectedUsersPostResponse201Type,
    ]: ...

    async def async_add_copilot_seats_for_users(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgCopilotBillingSelectedUsersPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        OrgsOrgCopilotBillingSelectedUsersPostResponse201,
        OrgsOrgCopilotBillingSelectedUsersPostResponse201Type,
    ]:
        """copilot/add-copilot-seats-for-users

        POST /orgs/{org}/copilot/billing/selected_users

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Purchases a GitHub Copilot seat for each user specified.
        The organization will be billed for each seat based on the organization's Copilot plan. For more information about Copilot pricing, see "[About billing for GitHub Copilot in your organization](https://docs.github.com/enterprise-cloud@latest//copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-the-copilot-subscription-for-your-organization/about-billing-for-github-copilot-in-your-organization)."

        Only organization owners can purchase Copilot seats for their organization members. The organization must have a Copilot Business or Copilot Enterprise subscription and a configured suggestion matching policy.
        For more information about setting up a Copilot subscription, see "[Subscribing to Copilot for your organization](https://docs.github.com/enterprise-cloud@latest//copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-the-copilot-subscription-for-your-organization/subscribing-to-copilot-for-your-organization)."
        For more information about setting a suggestion matching policy, see "[Managing policies for Copilot in your organization](https://docs.github.com/enterprise-cloud@latest//copilot/managing-copilot/managing-github-copilot-in-your-organization/setting-policies-for-copilot-in-your-organization/managing-policies-for-copilot-in-your-organization#policies-for-suggestion-matching)."

        The response contains the total number of new seats that were created and existing seats that were refreshed.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:org` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#add-users-to-the-copilot-subscription-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgCopilotBillingSelectedUsersPostBody,
            OrgsOrgCopilotBillingSelectedUsersPostResponse201,
        )

        url = f"/orgs/{org}/copilot/billing/selected_users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCopilotBillingSelectedUsersPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgCopilotBillingSelectedUsersPostResponse201,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def cancel_copilot_seat_assignment_for_users(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCopilotBillingSelectedUsersDeleteBodyType,
    ) -> Response[
        OrgsOrgCopilotBillingSelectedUsersDeleteResponse200,
        OrgsOrgCopilotBillingSelectedUsersDeleteResponse200Type,
    ]: ...

    @overload
    def cancel_copilot_seat_assignment_for_users(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_usernames: list[str],
    ) -> Response[
        OrgsOrgCopilotBillingSelectedUsersDeleteResponse200,
        OrgsOrgCopilotBillingSelectedUsersDeleteResponse200Type,
    ]: ...

    def cancel_copilot_seat_assignment_for_users(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgCopilotBillingSelectedUsersDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        OrgsOrgCopilotBillingSelectedUsersDeleteResponse200,
        OrgsOrgCopilotBillingSelectedUsersDeleteResponse200Type,
    ]:
        """copilot/cancel-copilot-seat-assignment-for-users

        DELETE /orgs/{org}/copilot/billing/selected_users

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Sets seats for all users specified to "pending cancellation".
        This will cause the specified users to lose access to GitHub Copilot at the end of the current billing cycle unless they retain access through team membership.
        For more information about disabling access to Copilot, see "[Revoking access to Copilot for members of your organization](https://docs.github.com/enterprise-cloud@latest//copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-access-to-github-copilot-in-your-organization/revoking-access-to-copilot-for-members-of-your-organization)."

        Only organization owners can cancel Copilot seats for their organization members.

        The response contains the total number of seats set to "pending cancellation".

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:org` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#remove-users-from-the-copilot-subscription-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgCopilotBillingSelectedUsersDeleteBody,
            OrgsOrgCopilotBillingSelectedUsersDeleteResponse200,
        )

        url = f"/orgs/{org}/copilot/billing/selected_users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCopilotBillingSelectedUsersDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgCopilotBillingSelectedUsersDeleteResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_cancel_copilot_seat_assignment_for_users(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCopilotBillingSelectedUsersDeleteBodyType,
    ) -> Response[
        OrgsOrgCopilotBillingSelectedUsersDeleteResponse200,
        OrgsOrgCopilotBillingSelectedUsersDeleteResponse200Type,
    ]: ...

    @overload
    async def async_cancel_copilot_seat_assignment_for_users(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_usernames: list[str],
    ) -> Response[
        OrgsOrgCopilotBillingSelectedUsersDeleteResponse200,
        OrgsOrgCopilotBillingSelectedUsersDeleteResponse200Type,
    ]: ...

    async def async_cancel_copilot_seat_assignment_for_users(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgCopilotBillingSelectedUsersDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        OrgsOrgCopilotBillingSelectedUsersDeleteResponse200,
        OrgsOrgCopilotBillingSelectedUsersDeleteResponse200Type,
    ]:
        """copilot/cancel-copilot-seat-assignment-for-users

        DELETE /orgs/{org}/copilot/billing/selected_users

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Sets seats for all users specified to "pending cancellation".
        This will cause the specified users to lose access to GitHub Copilot at the end of the current billing cycle unless they retain access through team membership.
        For more information about disabling access to Copilot, see "[Revoking access to Copilot for members of your organization](https://docs.github.com/enterprise-cloud@latest//copilot/managing-copilot/managing-github-copilot-in-your-organization/managing-access-to-github-copilot-in-your-organization/revoking-access-to-copilot-for-members-of-your-organization)."

        Only organization owners can cancel Copilot seats for their organization members.

        The response contains the total number of seats set to "pending cancellation".

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `admin:org` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#remove-users-from-the-copilot-subscription-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgCopilotBillingSelectedUsersDeleteBody,
            OrgsOrgCopilotBillingSelectedUsersDeleteResponse200,
        )

        url = f"/orgs/{org}/copilot/billing/selected_users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCopilotBillingSelectedUsersDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgCopilotBillingSelectedUsersDeleteResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def copilot_metrics_for_organization(
        self,
        org: str,
        *,
        since: Missing[str] = UNSET,
        until: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CopilotUsageMetricsDay], list[CopilotUsageMetricsDayType]]:
        """copilot/copilot-metrics-for-organization

        GET /orgs/{org}/copilot/metrics

        Use this endpoint to see a breakdown of aggregated metrics for various GitHub Copilot features. See the response schema tab for detailed metrics definitions.

        > [!NOTE]
        > This endpoint will only return results for a given day if the organization contained **five or more members with active Copilot licenses** on that day, as evaluated at the end of that day.

        The response contains metrics for up to 100 days prior. Metrics are processed once per day for the previous day,
        and the response will only include data up until yesterday. In order for an end user to be counted towards these metrics,
        they must have telemetry enabled in their IDE.

        To access this endpoint, the Copilot Metrics API access policy must be enabled for the organization.
        Only organization owners and owners and billing managers of the parent enterprise can view Copilot metrics.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot`, `read:org`, or `read:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-metrics#get-copilot-metrics-for-an-organization
        """

        from ..models import BasicError, CopilotUsageMetricsDay

        url = f"/orgs/{org}/copilot/metrics"

        params = {
            "since": since,
            "until": until,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CopilotUsageMetricsDay],
            error_models={
                "500": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": BasicError,
            },
        )

    async def async_copilot_metrics_for_organization(
        self,
        org: str,
        *,
        since: Missing[str] = UNSET,
        until: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CopilotUsageMetricsDay], list[CopilotUsageMetricsDayType]]:
        """copilot/copilot-metrics-for-organization

        GET /orgs/{org}/copilot/metrics

        Use this endpoint to see a breakdown of aggregated metrics for various GitHub Copilot features. See the response schema tab for detailed metrics definitions.

        > [!NOTE]
        > This endpoint will only return results for a given day if the organization contained **five or more members with active Copilot licenses** on that day, as evaluated at the end of that day.

        The response contains metrics for up to 100 days prior. Metrics are processed once per day for the previous day,
        and the response will only include data up until yesterday. In order for an end user to be counted towards these metrics,
        they must have telemetry enabled in their IDE.

        To access this endpoint, the Copilot Metrics API access policy must be enabled for the organization.
        Only organization owners and owners and billing managers of the parent enterprise can view Copilot metrics.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot`, `read:org`, or `read:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-metrics#get-copilot-metrics-for-an-organization
        """

        from ..models import BasicError, CopilotUsageMetricsDay

        url = f"/orgs/{org}/copilot/metrics"

        params = {
            "since": since,
            "until": until,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CopilotUsageMetricsDay],
            error_models={
                "500": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": BasicError,
            },
        )

    def get_copilot_seat_details_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CopilotSeatDetails, CopilotSeatDetailsType]:
        """copilot/get-copilot-seat-details-for-user

        GET /orgs/{org}/members/{username}/copilot

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Gets the GitHub Copilot seat details for a member of an organization who currently has access to GitHub Copilot.

        The seat object contains information about the user's most recent Copilot activity. Users must have telemetry enabled in their IDE for Copilot in the IDE activity to be reflected in `last_activity_at`.
        For more information about activity data, see [Metrics data properties for GitHub Copilot](https://docs.github.com/enterprise-cloud@latest//copilot/reference/metrics-data).

        Only organization owners can view Copilot seat assignment details for members of their organization.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:org` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#get-copilot-seat-assignment-details-for-a-user
        """

        from ..models import BasicError, CopilotSeatDetails

        url = f"/orgs/{org}/members/{username}/copilot"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CopilotSeatDetails,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_copilot_seat_details_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CopilotSeatDetails, CopilotSeatDetailsType]:
        """copilot/get-copilot-seat-details-for-user

        GET /orgs/{org}/members/{username}/copilot

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Gets the GitHub Copilot seat details for a member of an organization who currently has access to GitHub Copilot.

        The seat object contains information about the user's most recent Copilot activity. Users must have telemetry enabled in their IDE for Copilot in the IDE activity to be reflected in `last_activity_at`.
        For more information about activity data, see [Metrics data properties for GitHub Copilot](https://docs.github.com/enterprise-cloud@latest//copilot/reference/metrics-data).

        Only organization owners can view Copilot seat assignment details for members of their organization.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot` or `read:org` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-user-management#get-copilot-seat-assignment-details-for-a-user
        """

        from ..models import BasicError, CopilotSeatDetails

        url = f"/orgs/{org}/members/{username}/copilot"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CopilotSeatDetails,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def copilot_metrics_for_team(
        self,
        org: str,
        team_slug: str,
        *,
        since: Missing[str] = UNSET,
        until: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CopilotUsageMetricsDay], list[CopilotUsageMetricsDayType]]:
        """copilot/copilot-metrics-for-team

        GET /orgs/{org}/team/{team_slug}/copilot/metrics

        Use this endpoint to see a breakdown of aggregated metrics for various GitHub Copilot features. See the response schema tab for detailed metrics definitions.

        > [!NOTE]
        > This endpoint will only return results for a given day if the team had **five or more members with active Copilot licenses** on that day, as evaluated at the end of that day.

        The response contains metrics for up to 100 days prior. Metrics are processed once per day for the previous day,
        and the response will only include data up until yesterday. In order for an end user to be counted towards these metrics,
        they must have telemetry enabled in their IDE.

        To access this endpoint, the Copilot Metrics API access policy must be enabled for the organization containing the team within GitHub settings.
        Only organization owners for the organization that contains this team and owners and billing managers of the parent enterprise can view Copilot metrics for a team.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot`, `read:org`, or `read:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-metrics#get-copilot-metrics-for-a-team
        """

        from ..models import BasicError, CopilotUsageMetricsDay

        url = f"/orgs/{org}/team/{team_slug}/copilot/metrics"

        params = {
            "since": since,
            "until": until,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CopilotUsageMetricsDay],
            error_models={
                "500": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": BasicError,
            },
        )

    async def async_copilot_metrics_for_team(
        self,
        org: str,
        team_slug: str,
        *,
        since: Missing[str] = UNSET,
        until: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CopilotUsageMetricsDay], list[CopilotUsageMetricsDayType]]:
        """copilot/copilot-metrics-for-team

        GET /orgs/{org}/team/{team_slug}/copilot/metrics

        Use this endpoint to see a breakdown of aggregated metrics for various GitHub Copilot features. See the response schema tab for detailed metrics definitions.

        > [!NOTE]
        > This endpoint will only return results for a given day if the team had **five or more members with active Copilot licenses** on that day, as evaluated at the end of that day.

        The response contains metrics for up to 100 days prior. Metrics are processed once per day for the previous day,
        and the response will only include data up until yesterday. In order for an end user to be counted towards these metrics,
        they must have telemetry enabled in their IDE.

        To access this endpoint, the Copilot Metrics API access policy must be enabled for the organization containing the team within GitHub settings.
        Only organization owners for the organization that contains this team and owners and billing managers of the parent enterprise can view Copilot metrics for a team.

        OAuth app tokens and personal access tokens (classic) need either the `manage_billing:copilot`, `read:org`, or `read:enterprise` scopes to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/copilot/copilot-metrics#get-copilot-metrics-for-a-team
        """

        from ..models import BasicError, CopilotUsageMetricsDay

        url = f"/orgs/{org}/team/{team_slug}/copilot/metrics"

        params = {
            "since": since,
            "until": until,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CopilotUsageMetricsDay],
            error_models={
                "500": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": BasicError,
            },
        )
