"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        ProjectsV2,
        ProjectsV2Field,
        ProjectsV2ItemSimple,
        ProjectsV2ItemWithContent,
    )
    from ..types import (
        OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBodyPropFieldsItemsType,
        OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBodyType,
        OrgsOrgProjectsV2ProjectNumberItemsPostBodyType,
        ProjectsV2FieldType,
        ProjectsV2ItemSimpleType,
        ProjectsV2ItemWithContentType,
        ProjectsV2Type,
        UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBodyPropFieldsItemsType,
        UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBodyType,
        UsersUsernameProjectsV2ProjectNumberItemsPostBodyType,
    )


class ProjectsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_for_org(
        self,
        org: str,
        *,
        q: Missing[str] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectsV2], list[ProjectsV2Type]]:
        """projects/list-for-org

        GET /orgs/{org}/projectsV2

        List all projects owned by a specific organization accessible by the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#list-projects-for-organization
        """

        from ..models import BasicError, ProjectsV2

        url = f"/orgs/{org}/projectsV2"

        params = {
            "q": q,
            "before": before,
            "after": after,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_for_org(
        self,
        org: str,
        *,
        q: Missing[str] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectsV2], list[ProjectsV2Type]]:
        """projects/list-for-org

        GET /orgs/{org}/projectsV2

        List all projects owned by a specific organization accessible by the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#list-projects-for-organization
        """

        from ..models import BasicError, ProjectsV2

        url = f"/orgs/{org}/projectsV2"

        params = {
            "q": q,
            "before": before,
            "after": after,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_for_org(
        self,
        project_number: int,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2, ProjectsV2Type]:
        """projects/get-for-org

        GET /orgs/{org}/projectsV2/{project_number}

        Get a specific organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#get-project-for-organization
        """

        from ..models import BasicError, ProjectsV2

        url = f"/orgs/{org}/projectsV2/{project_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_for_org(
        self,
        project_number: int,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2, ProjectsV2Type]:
        """projects/get-for-org

        GET /orgs/{org}/projectsV2/{project_number}

        Get a specific organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#get-project-for-organization
        """

        from ..models import BasicError, ProjectsV2

        url = f"/orgs/{org}/projectsV2/{project_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_fields_for_org(
        self,
        project_number: int,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectsV2Field], list[ProjectsV2FieldType]]:
        """projects/list-fields-for-org

        GET /orgs/{org}/projectsV2/{project_number}/fields

        List all fields for a specific organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/fields#list-project-fields-for-organization
        """

        from ..models import BasicError, ProjectsV2Field

        url = f"/orgs/{org}/projectsV2/{project_number}/fields"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2Field],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_fields_for_org(
        self,
        project_number: int,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectsV2Field], list[ProjectsV2FieldType]]:
        """projects/list-fields-for-org

        GET /orgs/{org}/projectsV2/{project_number}/fields

        List all fields for a specific organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/fields#list-project-fields-for-organization
        """

        from ..models import BasicError, ProjectsV2Field

        url = f"/orgs/{org}/projectsV2/{project_number}/fields"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2Field],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_field_for_org(
        self,
        project_number: int,
        field_id: int,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2Field, ProjectsV2FieldType]:
        """projects/get-field-for-org

        GET /orgs/{org}/projectsV2/{project_number}/fields/{field_id}

        Get a specific field for an organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/fields#get-project-field-for-organization
        """

        from ..models import BasicError, ProjectsV2Field

        url = f"/orgs/{org}/projectsV2/{project_number}/fields/{field_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2Field,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_field_for_org(
        self,
        project_number: int,
        field_id: int,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2Field, ProjectsV2FieldType]:
        """projects/get-field-for-org

        GET /orgs/{org}/projectsV2/{project_number}/fields/{field_id}

        Get a specific field for an organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/fields#get-project-field-for-organization
        """

        from ..models import BasicError, ProjectsV2Field

        url = f"/orgs/{org}/projectsV2/{project_number}/fields/{field_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2Field,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_items_for_org(
        self,
        project_number: int,
        org: str,
        *,
        q: Missing[str] = UNSET,
        fields: Missing[Union[str, list[str]]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectsV2ItemWithContent], list[ProjectsV2ItemWithContentType]]:
        """projects/list-items-for-org

        GET /orgs/{org}/projectsV2/{project_number}/items

        List all items for a specific organization-owned project accessible by the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#list-items-for-an-organization-owned-project
        """

        from ..models import BasicError, ProjectsV2ItemWithContent

        url = f"/orgs/{org}/projectsV2/{project_number}/items"

        params = {
            "q": q,
            "fields": fields,
            "before": before,
            "after": after,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2ItemWithContent],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_items_for_org(
        self,
        project_number: int,
        org: str,
        *,
        q: Missing[str] = UNSET,
        fields: Missing[Union[str, list[str]]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectsV2ItemWithContent], list[ProjectsV2ItemWithContentType]]:
        """projects/list-items-for-org

        GET /orgs/{org}/projectsV2/{project_number}/items

        List all items for a specific organization-owned project accessible by the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#list-items-for-an-organization-owned-project
        """

        from ..models import BasicError, ProjectsV2ItemWithContent

        url = f"/orgs/{org}/projectsV2/{project_number}/items"

        params = {
            "q": q,
            "fields": fields,
            "before": before,
            "after": after,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2ItemWithContent],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def add_item_for_org(
        self,
        org: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgProjectsV2ProjectNumberItemsPostBodyType,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleType]: ...

    @overload
    def add_item_for_org(
        self,
        org: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        type: Literal["Issue", "PullRequest"],
        id: int,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleType]: ...

    def add_item_for_org(
        self,
        org: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgProjectsV2ProjectNumberItemsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleType]:
        """projects/add-item-for-org

        POST /orgs/{org}/projectsV2/{project_number}/items

        Add an issue or pull request item to the specified organization owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#add-item-to-organization-owned-project
        """

        from ..models import (
            BasicError,
            OrgsOrgProjectsV2ProjectNumberItemsPostBody,
            ProjectsV2ItemSimple,
        )

        url = f"/orgs/{org}/projectsV2/{project_number}/items"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgProjectsV2ProjectNumberItemsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemSimple,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_add_item_for_org(
        self,
        org: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgProjectsV2ProjectNumberItemsPostBodyType,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleType]: ...

    @overload
    async def async_add_item_for_org(
        self,
        org: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        type: Literal["Issue", "PullRequest"],
        id: int,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleType]: ...

    async def async_add_item_for_org(
        self,
        org: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgProjectsV2ProjectNumberItemsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleType]:
        """projects/add-item-for-org

        POST /orgs/{org}/projectsV2/{project_number}/items

        Add an issue or pull request item to the specified organization owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#add-item-to-organization-owned-project
        """

        from ..models import (
            BasicError,
            OrgsOrgProjectsV2ProjectNumberItemsPostBody,
            ProjectsV2ItemSimple,
        )

        url = f"/orgs/{org}/projectsV2/{project_number}/items"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgProjectsV2ProjectNumberItemsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemSimple,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_org_item(
        self,
        project_number: int,
        org: str,
        item_id: int,
        *,
        fields: Missing[Union[str, list[str]]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentType]:
        """projects/get-org-item

        GET /orgs/{org}/projectsV2/{project_number}/items/{item_id}

        Get a specific item from an organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#get-an-item-for-an-organization-owned-project
        """

        from ..models import BasicError, ProjectsV2ItemWithContent

        url = f"/orgs/{org}/projectsV2/{project_number}/items/{item_id}"

        params = {
            "fields": fields,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemWithContent,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_org_item(
        self,
        project_number: int,
        org: str,
        item_id: int,
        *,
        fields: Missing[Union[str, list[str]]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentType]:
        """projects/get-org-item

        GET /orgs/{org}/projectsV2/{project_number}/items/{item_id}

        Get a specific item from an organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#get-an-item-for-an-organization-owned-project
        """

        from ..models import BasicError, ProjectsV2ItemWithContent

        url = f"/orgs/{org}/projectsV2/{project_number}/items/{item_id}"

        params = {
            "fields": fields,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemWithContent,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_item_for_org(
        self,
        project_number: int,
        org: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """projects/delete-item-for-org

        DELETE /orgs/{org}/projectsV2/{project_number}/items/{item_id}

        Delete a specific item from an organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#delete-project-item-for-organization
        """

        from ..models import BasicError

        url = f"/orgs/{org}/projectsV2/{project_number}/items/{item_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_item_for_org(
        self,
        project_number: int,
        org: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """projects/delete-item-for-org

        DELETE /orgs/{org}/projectsV2/{project_number}/items/{item_id}

        Delete a specific item from an organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#delete-project-item-for-organization
        """

        from ..models import BasicError

        url = f"/orgs/{org}/projectsV2/{project_number}/items/{item_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def update_item_for_org(
        self,
        project_number: int,
        org: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBodyType,
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentType]: ...

    @overload
    def update_item_for_org(
        self,
        project_number: int,
        org: str,
        item_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        fields: list[
            OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBodyPropFieldsItemsType
        ],
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentType]: ...

    def update_item_for_org(
        self,
        project_number: int,
        org: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentType]:
        """projects/update-item-for-org

        PATCH /orgs/{org}/projectsV2/{project_number}/items/{item_id}

        Update a specific item in an organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#update-project-item-for-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBody,
            ProjectsV2ItemWithContent,
            ValidationError,
        )

        url = f"/orgs/{org}/projectsV2/{project_number}/items/{item_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemWithContent,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_item_for_org(
        self,
        project_number: int,
        org: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBodyType,
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentType]: ...

    @overload
    async def async_update_item_for_org(
        self,
        project_number: int,
        org: str,
        item_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        fields: list[
            OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBodyPropFieldsItemsType
        ],
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentType]: ...

    async def async_update_item_for_org(
        self,
        project_number: int,
        org: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentType]:
        """projects/update-item-for-org

        PATCH /orgs/{org}/projectsV2/{project_number}/items/{item_id}

        Update a specific item in an organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#update-project-item-for-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBody,
            ProjectsV2ItemWithContent,
            ValidationError,
        )

        url = f"/orgs/{org}/projectsV2/{project_number}/items/{item_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemWithContent,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_for_user(
        self,
        username: str,
        *,
        q: Missing[str] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectsV2], list[ProjectsV2Type]]:
        """projects/list-for-user

        GET /users/{username}/projectsV2

        List all projects owned by a specific user accessible by the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#list-projects-for-user
        """

        from ..models import BasicError, ProjectsV2

        url = f"/users/{username}/projectsV2"

        params = {
            "q": q,
            "before": before,
            "after": after,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_for_user(
        self,
        username: str,
        *,
        q: Missing[str] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectsV2], list[ProjectsV2Type]]:
        """projects/list-for-user

        GET /users/{username}/projectsV2

        List all projects owned by a specific user accessible by the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#list-projects-for-user
        """

        from ..models import BasicError, ProjectsV2

        url = f"/users/{username}/projectsV2"

        params = {
            "q": q,
            "before": before,
            "after": after,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_for_user(
        self,
        project_number: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2, ProjectsV2Type]:
        """projects/get-for-user

        GET /users/{username}/projectsV2/{project_number}

        Get a specific user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#get-project-for-user
        """

        from ..models import BasicError, ProjectsV2

        url = f"/users/{username}/projectsV2/{project_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_for_user(
        self,
        project_number: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2, ProjectsV2Type]:
        """projects/get-for-user

        GET /users/{username}/projectsV2/{project_number}

        Get a specific user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#get-project-for-user
        """

        from ..models import BasicError, ProjectsV2

        url = f"/users/{username}/projectsV2/{project_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_fields_for_user(
        self,
        project_number: int,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectsV2Field], list[ProjectsV2FieldType]]:
        """projects/list-fields-for-user

        GET /users/{username}/projectsV2/{project_number}/fields

        List all fields for a specific user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/fields#list-project-fields-for-user
        """

        from ..models import BasicError, ProjectsV2Field

        url = f"/users/{username}/projectsV2/{project_number}/fields"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2Field],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_fields_for_user(
        self,
        project_number: int,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectsV2Field], list[ProjectsV2FieldType]]:
        """projects/list-fields-for-user

        GET /users/{username}/projectsV2/{project_number}/fields

        List all fields for a specific user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/fields#list-project-fields-for-user
        """

        from ..models import BasicError, ProjectsV2Field

        url = f"/users/{username}/projectsV2/{project_number}/fields"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2Field],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_field_for_user(
        self,
        project_number: int,
        field_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2Field, ProjectsV2FieldType]:
        """projects/get-field-for-user

        GET /users/{username}/projectsV2/{project_number}/fields/{field_id}

        Get a specific field for a user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/fields#get-project-field-for-user
        """

        from ..models import BasicError, ProjectsV2Field

        url = f"/users/{username}/projectsV2/{project_number}/fields/{field_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2Field,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_field_for_user(
        self,
        project_number: int,
        field_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2Field, ProjectsV2FieldType]:
        """projects/get-field-for-user

        GET /users/{username}/projectsV2/{project_number}/fields/{field_id}

        Get a specific field for a user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/fields#get-project-field-for-user
        """

        from ..models import BasicError, ProjectsV2Field

        url = f"/users/{username}/projectsV2/{project_number}/fields/{field_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2Field,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_items_for_user(
        self,
        project_number: int,
        username: str,
        *,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        q: Missing[str] = UNSET,
        fields: Missing[Union[str, list[str]]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectsV2ItemWithContent], list[ProjectsV2ItemWithContentType]]:
        """projects/list-items-for-user

        GET /users/{username}/projectsV2/{project_number}/items

        List all items for a specific user-owned project accessible by the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#list-items-for-a-user-owned-project
        """

        from ..models import BasicError, ProjectsV2ItemWithContent

        url = f"/users/{username}/projectsV2/{project_number}/items"

        params = {
            "before": before,
            "after": after,
            "per_page": per_page,
            "q": q,
            "fields": fields,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2ItemWithContent],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_items_for_user(
        self,
        project_number: int,
        username: str,
        *,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        q: Missing[str] = UNSET,
        fields: Missing[Union[str, list[str]]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectsV2ItemWithContent], list[ProjectsV2ItemWithContentType]]:
        """projects/list-items-for-user

        GET /users/{username}/projectsV2/{project_number}/items

        List all items for a specific user-owned project accessible by the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#list-items-for-a-user-owned-project
        """

        from ..models import BasicError, ProjectsV2ItemWithContent

        url = f"/users/{username}/projectsV2/{project_number}/items"

        params = {
            "before": before,
            "after": after,
            "per_page": per_page,
            "q": q,
            "fields": fields,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2ItemWithContent],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def add_item_for_user(
        self,
        username: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UsersUsernameProjectsV2ProjectNumberItemsPostBodyType,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleType]: ...

    @overload
    def add_item_for_user(
        self,
        username: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        type: Literal["Issue", "PullRequest"],
        id: int,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleType]: ...

    def add_item_for_user(
        self,
        username: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UsersUsernameProjectsV2ProjectNumberItemsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleType]:
        """projects/add-item-for-user

        POST /users/{username}/projectsV2/{project_number}/items

        Add an issue or pull request item to the specified user owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#add-item-to-user-owned-project
        """

        from ..models import (
            BasicError,
            ProjectsV2ItemSimple,
            UsersUsernameProjectsV2ProjectNumberItemsPostBody,
        )

        url = f"/users/{username}/projectsV2/{project_number}/items"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                UsersUsernameProjectsV2ProjectNumberItemsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemSimple,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_add_item_for_user(
        self,
        username: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UsersUsernameProjectsV2ProjectNumberItemsPostBodyType,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleType]: ...

    @overload
    async def async_add_item_for_user(
        self,
        username: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        type: Literal["Issue", "PullRequest"],
        id: int,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleType]: ...

    async def async_add_item_for_user(
        self,
        username: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UsersUsernameProjectsV2ProjectNumberItemsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleType]:
        """projects/add-item-for-user

        POST /users/{username}/projectsV2/{project_number}/items

        Add an issue or pull request item to the specified user owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#add-item-to-user-owned-project
        """

        from ..models import (
            BasicError,
            ProjectsV2ItemSimple,
            UsersUsernameProjectsV2ProjectNumberItemsPostBody,
        )

        url = f"/users/{username}/projectsV2/{project_number}/items"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                UsersUsernameProjectsV2ProjectNumberItemsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemSimple,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_user_item(
        self,
        project_number: int,
        username: str,
        item_id: int,
        *,
        fields: Missing[Union[str, list[str]]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentType]:
        """projects/get-user-item

        GET /users/{username}/projectsV2/{project_number}/items/{item_id}

        Get a specific item from a user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#get-an-item-for-a-user-owned-project
        """

        from ..models import BasicError, ProjectsV2ItemWithContent

        url = f"/users/{username}/projectsV2/{project_number}/items/{item_id}"

        params = {
            "fields": fields,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemWithContent,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_user_item(
        self,
        project_number: int,
        username: str,
        item_id: int,
        *,
        fields: Missing[Union[str, list[str]]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentType]:
        """projects/get-user-item

        GET /users/{username}/projectsV2/{project_number}/items/{item_id}

        Get a specific item from a user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#get-an-item-for-a-user-owned-project
        """

        from ..models import BasicError, ProjectsV2ItemWithContent

        url = f"/users/{username}/projectsV2/{project_number}/items/{item_id}"

        params = {
            "fields": fields,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemWithContent,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_item_for_user(
        self,
        project_number: int,
        username: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """projects/delete-item-for-user

        DELETE /users/{username}/projectsV2/{project_number}/items/{item_id}

        Delete a specific item from a user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#delete-project-item-for-user
        """

        from ..models import BasicError

        url = f"/users/{username}/projectsV2/{project_number}/items/{item_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_item_for_user(
        self,
        project_number: int,
        username: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """projects/delete-item-for-user

        DELETE /users/{username}/projectsV2/{project_number}/items/{item_id}

        Delete a specific item from a user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#delete-project-item-for-user
        """

        from ..models import BasicError

        url = f"/users/{username}/projectsV2/{project_number}/items/{item_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def update_item_for_user(
        self,
        project_number: int,
        username: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBodyType,
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentType]: ...

    @overload
    def update_item_for_user(
        self,
        project_number: int,
        username: str,
        item_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        fields: list[
            UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBodyPropFieldsItemsType
        ],
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentType]: ...

    def update_item_for_user(
        self,
        project_number: int,
        username: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentType]:
        """projects/update-item-for-user

        PATCH /users/{username}/projectsV2/{project_number}/items/{item_id}

        Update a specific item in a user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#update-project-item-for-user
        """

        from ..models import (
            BasicError,
            ProjectsV2ItemWithContent,
            UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBody,
            ValidationError,
        )

        url = f"/users/{username}/projectsV2/{project_number}/items/{item_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemWithContent,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_item_for_user(
        self,
        project_number: int,
        username: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBodyType,
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentType]: ...

    @overload
    async def async_update_item_for_user(
        self,
        project_number: int,
        username: str,
        item_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        fields: list[
            UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBodyPropFieldsItemsType
        ],
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentType]: ...

    async def async_update_item_for_user(
        self,
        project_number: int,
        username: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentType]:
        """projects/update-item-for-user

        PATCH /users/{username}/projectsV2/{project_number}/items/{item_id}

        Update a specific item in a user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#update-project-item-for-user
        """

        from ..models import (
            BasicError,
            ProjectsV2ItemWithContent,
            UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBody,
            ValidationError,
        )

        url = f"/users/{username}/projectsV2/{project_number}/items/{item_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemWithContent,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )
