"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        DependabotAlert,
        DependabotAlertWithRepository,
        DependabotPublicKey,
        DependabotRepositoryAccessDetails,
        DependabotSecret,
        EmptyObject,
        OrganizationDependabotSecret,
        OrgsOrgDependabotSecretsGetResponse200,
        OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200,
        ReposOwnerRepoDependabotSecretsGetResponse200,
    )
    from ..types import (
        DependabotAlertType,
        DependabotAlertWithRepositoryType,
        DependabotPublicKeyType,
        DependabotRepositoryAccessDetailsType,
        DependabotSecretType,
        EmptyObjectType,
        OrganizationDependabotSecretType,
        OrganizationsOrgDependabotRepositoryAccessDefaultLevelPutBodyType,
        OrganizationsOrgDependabotRepositoryAccessPatchBodyType,
        OrgsOrgDependabotSecretsGetResponse200Type,
        OrgsOrgDependabotSecretsSecretNamePutBodyType,
        OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200Type,
        OrgsOrgDependabotSecretsSecretNameRepositoriesPutBodyType,
        ReposOwnerRepoDependabotAlertsAlertNumberPatchBodyType,
        ReposOwnerRepoDependabotSecretsGetResponse200Type,
        ReposOwnerRepoDependabotSecretsSecretNamePutBodyType,
    )


class DependabotClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_alerts_for_enterprise(
        self,
        enterprise: str,
        *,
        state: Missing[str] = UNSET,
        severity: Missing[str] = UNSET,
        ecosystem: Missing[str] = UNSET,
        package: Missing[str] = UNSET,
        epss_percentage: Missing[str] = UNSET,
        has: Missing[Union[str, list[Literal["patch"]]]] = UNSET,
        scope: Missing[Literal["development", "runtime"]] = UNSET,
        sort: Missing[Literal["created", "updated", "epss_percentage"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[DependabotAlertWithRepository], list[DependabotAlertWithRepositoryType]
    ]:
        """dependabot/list-alerts-for-enterprise

        GET /enterprises/{enterprise}/dependabot/alerts

        Lists Dependabot alerts for repositories that are owned by the specified enterprise.

        The authenticated user must be a member of the enterprise to use this endpoint.

        Alerts are only returned for organizations in the enterprise for which you are an organization owner or a security manager. For more information about security managers, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/alerts#list-dependabot-alerts-for-an-enterprise
        """

        from ..models import (
            BasicError,
            DependabotAlertWithRepository,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/dependabot/alerts"

        params = {
            "state": state,
            "severity": severity,
            "ecosystem": ecosystem,
            "package": package,
            "epss_percentage": epss_percentage,
            "has": has,
            "scope": scope,
            "sort": sort,
            "direction": direction,
            "before": before,
            "after": after,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[DependabotAlertWithRepository],
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_alerts_for_enterprise(
        self,
        enterprise: str,
        *,
        state: Missing[str] = UNSET,
        severity: Missing[str] = UNSET,
        ecosystem: Missing[str] = UNSET,
        package: Missing[str] = UNSET,
        epss_percentage: Missing[str] = UNSET,
        has: Missing[Union[str, list[Literal["patch"]]]] = UNSET,
        scope: Missing[Literal["development", "runtime"]] = UNSET,
        sort: Missing[Literal["created", "updated", "epss_percentage"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[DependabotAlertWithRepository], list[DependabotAlertWithRepositoryType]
    ]:
        """dependabot/list-alerts-for-enterprise

        GET /enterprises/{enterprise}/dependabot/alerts

        Lists Dependabot alerts for repositories that are owned by the specified enterprise.

        The authenticated user must be a member of the enterprise to use this endpoint.

        Alerts are only returned for organizations in the enterprise for which you are an organization owner or a security manager. For more information about security managers, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/alerts#list-dependabot-alerts-for-an-enterprise
        """

        from ..models import (
            BasicError,
            DependabotAlertWithRepository,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/dependabot/alerts"

        params = {
            "state": state,
            "severity": severity,
            "ecosystem": ecosystem,
            "package": package,
            "epss_percentage": epss_percentage,
            "has": has,
            "scope": scope,
            "sort": sort,
            "direction": direction,
            "before": before,
            "after": after,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[DependabotAlertWithRepository],
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def repository_access_for_org(
        self,
        org: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        DependabotRepositoryAccessDetails, DependabotRepositoryAccessDetailsType
    ]:
        """dependabot/repository-access-for-org

        GET /organizations/{org}/dependabot/repository-access

        Lists repositories that organization admins have allowed Dependabot to access when updating dependencies.
        > [!NOTE]
        >    This operation supports both server-to-server and user-to-server access.
        Unauthorized users will not see the existence of this endpoint.

        See also: https://docs.github.com/rest/dependabot/repository-access#lists-the-repositories-dependabot-can-access-in-an-organization
        """

        from ..models import BasicError, DependabotRepositoryAccessDetails

        url = f"/organizations/{org}/dependabot/repository-access"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DependabotRepositoryAccessDetails,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_repository_access_for_org(
        self,
        org: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        DependabotRepositoryAccessDetails, DependabotRepositoryAccessDetailsType
    ]:
        """dependabot/repository-access-for-org

        GET /organizations/{org}/dependabot/repository-access

        Lists repositories that organization admins have allowed Dependabot to access when updating dependencies.
        > [!NOTE]
        >    This operation supports both server-to-server and user-to-server access.
        Unauthorized users will not see the existence of this endpoint.

        See also: https://docs.github.com/rest/dependabot/repository-access#lists-the-repositories-dependabot-can-access-in-an-organization
        """

        from ..models import BasicError, DependabotRepositoryAccessDetails

        url = f"/organizations/{org}/dependabot/repository-access"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DependabotRepositoryAccessDetails,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update_repository_access_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrganizationsOrgDependabotRepositoryAccessPatchBodyType,
    ) -> Response: ...

    @overload
    def update_repository_access_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        repository_ids_to_add: Missing[list[int]] = UNSET,
        repository_ids_to_remove: Missing[list[int]] = UNSET,
    ) -> Response: ...

    def update_repository_access_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrganizationsOrgDependabotRepositoryAccessPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """dependabot/update-repository-access-for-org

        PATCH /organizations/{org}/dependabot/repository-access

        Updates repositories according to the list of repositories that organization admins have given Dependabot access to when they've updated dependencies.

        > [!NOTE]
        >    This operation supports both server-to-server and user-to-server access.
        Unauthorized users will not see the existence of this endpoint.

        **Example request body:**
        ```json
        {
          "repository_ids_to_add": [123, 456],
          "repository_ids_to_remove": [789]
        }
        ```

        See also: https://docs.github.com/rest/dependabot/repository-access#updates-dependabots-repository-access-list-for-an-organization
        """

        from ..models import (
            BasicError,
            OrganizationsOrgDependabotRepositoryAccessPatchBody,
        )

        url = f"/organizations/{org}/dependabot/repository-access"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrganizationsOrgDependabotRepositoryAccessPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_repository_access_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrganizationsOrgDependabotRepositoryAccessPatchBodyType,
    ) -> Response: ...

    @overload
    async def async_update_repository_access_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        repository_ids_to_add: Missing[list[int]] = UNSET,
        repository_ids_to_remove: Missing[list[int]] = UNSET,
    ) -> Response: ...

    async def async_update_repository_access_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrganizationsOrgDependabotRepositoryAccessPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """dependabot/update-repository-access-for-org

        PATCH /organizations/{org}/dependabot/repository-access

        Updates repositories according to the list of repositories that organization admins have given Dependabot access to when they've updated dependencies.

        > [!NOTE]
        >    This operation supports both server-to-server and user-to-server access.
        Unauthorized users will not see the existence of this endpoint.

        **Example request body:**
        ```json
        {
          "repository_ids_to_add": [123, 456],
          "repository_ids_to_remove": [789]
        }
        ```

        See also: https://docs.github.com/rest/dependabot/repository-access#updates-dependabots-repository-access-list-for-an-organization
        """

        from ..models import (
            BasicError,
            OrganizationsOrgDependabotRepositoryAccessPatchBody,
        )

        url = f"/organizations/{org}/dependabot/repository-access"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrganizationsOrgDependabotRepositoryAccessPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def set_repository_access_default_level(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrganizationsOrgDependabotRepositoryAccessDefaultLevelPutBodyType,
    ) -> Response: ...

    @overload
    def set_repository_access_default_level(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        default_level: Literal["public", "internal"],
    ) -> Response: ...

    def set_repository_access_default_level(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            OrganizationsOrgDependabotRepositoryAccessDefaultLevelPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """dependabot/set-repository-access-default-level

        PUT /organizations/{org}/dependabot/repository-access/default-level

        Sets the default level of repository access Dependabot will have while performing an update.  Available values are:
        - 'public' - Dependabot will only have access to public repositories, unless access is explicitly granted to non-public repositories.
        - 'internal' - Dependabot will only have access to public and internal repositories, unless access is explicitly granted to private repositories.

        Unauthorized users will not see the existence of this endpoint.

        This operation supports both server-to-server and user-to-server access.

        See also: https://docs.github.com/rest/dependabot/repository-access#set-the-default-repository-access-level-for-dependabot
        """

        from ..models import (
            BasicError,
            OrganizationsOrgDependabotRepositoryAccessDefaultLevelPutBody,
        )

        url = f"/organizations/{org}/dependabot/repository-access/default-level"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrganizationsOrgDependabotRepositoryAccessDefaultLevelPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_set_repository_access_default_level(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrganizationsOrgDependabotRepositoryAccessDefaultLevelPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_repository_access_default_level(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        default_level: Literal["public", "internal"],
    ) -> Response: ...

    async def async_set_repository_access_default_level(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            OrganizationsOrgDependabotRepositoryAccessDefaultLevelPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """dependabot/set-repository-access-default-level

        PUT /organizations/{org}/dependabot/repository-access/default-level

        Sets the default level of repository access Dependabot will have while performing an update.  Available values are:
        - 'public' - Dependabot will only have access to public repositories, unless access is explicitly granted to non-public repositories.
        - 'internal' - Dependabot will only have access to public and internal repositories, unless access is explicitly granted to private repositories.

        Unauthorized users will not see the existence of this endpoint.

        This operation supports both server-to-server and user-to-server access.

        See also: https://docs.github.com/rest/dependabot/repository-access#set-the-default-repository-access-level-for-dependabot
        """

        from ..models import (
            BasicError,
            OrganizationsOrgDependabotRepositoryAccessDefaultLevelPutBody,
        )

        url = f"/organizations/{org}/dependabot/repository-access/default-level"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrganizationsOrgDependabotRepositoryAccessDefaultLevelPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_alerts_for_org(
        self,
        org: str,
        *,
        state: Missing[str] = UNSET,
        severity: Missing[str] = UNSET,
        ecosystem: Missing[str] = UNSET,
        package: Missing[str] = UNSET,
        epss_percentage: Missing[str] = UNSET,
        artifact_registry_url: Missing[str] = UNSET,
        artifact_registry: Missing[str] = UNSET,
        has: Missing[Union[str, list[Literal["patch", "deployment"]]]] = UNSET,
        runtime_risk: Missing[str] = UNSET,
        scope: Missing[Literal["development", "runtime"]] = UNSET,
        sort: Missing[Literal["created", "updated", "epss_percentage"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[DependabotAlertWithRepository], list[DependabotAlertWithRepositoryType]
    ]:
        """dependabot/list-alerts-for-org

        GET /orgs/{org}/dependabot/alerts

        Lists Dependabot alerts for an organization.

        The authenticated user must be an owner or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/rest/dependabot/alerts#list-dependabot-alerts-for-an-organization
        """

        from ..models import (
            BasicError,
            DependabotAlertWithRepository,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}/dependabot/alerts"

        params = {
            "state": state,
            "severity": severity,
            "ecosystem": ecosystem,
            "package": package,
            "epss_percentage": epss_percentage,
            "artifact_registry_url": artifact_registry_url,
            "artifact_registry": artifact_registry,
            "has": has,
            "runtime_risk": runtime_risk,
            "scope": scope,
            "sort": sort,
            "direction": direction,
            "before": before,
            "after": after,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[DependabotAlertWithRepository],
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_alerts_for_org(
        self,
        org: str,
        *,
        state: Missing[str] = UNSET,
        severity: Missing[str] = UNSET,
        ecosystem: Missing[str] = UNSET,
        package: Missing[str] = UNSET,
        epss_percentage: Missing[str] = UNSET,
        artifact_registry_url: Missing[str] = UNSET,
        artifact_registry: Missing[str] = UNSET,
        has: Missing[Union[str, list[Literal["patch", "deployment"]]]] = UNSET,
        runtime_risk: Missing[str] = UNSET,
        scope: Missing[Literal["development", "runtime"]] = UNSET,
        sort: Missing[Literal["created", "updated", "epss_percentage"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[DependabotAlertWithRepository], list[DependabotAlertWithRepositoryType]
    ]:
        """dependabot/list-alerts-for-org

        GET /orgs/{org}/dependabot/alerts

        Lists Dependabot alerts for an organization.

        The authenticated user must be an owner or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/rest/dependabot/alerts#list-dependabot-alerts-for-an-organization
        """

        from ..models import (
            BasicError,
            DependabotAlertWithRepository,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}/dependabot/alerts"

        params = {
            "state": state,
            "severity": severity,
            "ecosystem": ecosystem,
            "package": package,
            "epss_percentage": epss_percentage,
            "artifact_registry_url": artifact_registry_url,
            "artifact_registry": artifact_registry,
            "has": has,
            "runtime_risk": runtime_risk,
            "scope": scope,
            "sort": sort,
            "direction": direction,
            "before": before,
            "after": after,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[DependabotAlertWithRepository],
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_org_secrets(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgDependabotSecretsGetResponse200,
        OrgsOrgDependabotSecretsGetResponse200Type,
    ]:
        """dependabot/list-org-secrets

        GET /orgs/{org}/dependabot/secrets

        Lists all secrets available in an organization without revealing their
        encrypted values.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#list-organization-secrets
        """

        from ..models import OrgsOrgDependabotSecretsGetResponse200

        url = f"/orgs/{org}/dependabot/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgDependabotSecretsGetResponse200,
        )

    async def async_list_org_secrets(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgDependabotSecretsGetResponse200,
        OrgsOrgDependabotSecretsGetResponse200Type,
    ]:
        """dependabot/list-org-secrets

        GET /orgs/{org}/dependabot/secrets

        Lists all secrets available in an organization without revealing their
        encrypted values.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#list-organization-secrets
        """

        from ..models import OrgsOrgDependabotSecretsGetResponse200

        url = f"/orgs/{org}/dependabot/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgDependabotSecretsGetResponse200,
        )

    def get_org_public_key(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DependabotPublicKey, DependabotPublicKeyType]:
        """dependabot/get-org-public-key

        GET /orgs/{org}/dependabot/secrets/public-key

        Gets your public key, which you need to encrypt secrets. You need to
        encrypt a secret before you can create or update secrets.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#get-an-organization-public-key
        """

        from ..models import DependabotPublicKey

        url = f"/orgs/{org}/dependabot/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DependabotPublicKey,
        )

    async def async_get_org_public_key(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DependabotPublicKey, DependabotPublicKeyType]:
        """dependabot/get-org-public-key

        GET /orgs/{org}/dependabot/secrets/public-key

        Gets your public key, which you need to encrypt secrets. You need to
        encrypt a secret before you can create or update secrets.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#get-an-organization-public-key
        """

        from ..models import DependabotPublicKey

        url = f"/orgs/{org}/dependabot/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DependabotPublicKey,
        )

    def get_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrganizationDependabotSecret, OrganizationDependabotSecretType]:
        """dependabot/get-org-secret

        GET /orgs/{org}/dependabot/secrets/{secret_name}

        Gets a single organization secret without revealing its encrypted value.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#get-an-organization-secret
        """

        from ..models import OrganizationDependabotSecret

        url = f"/orgs/{org}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrganizationDependabotSecret,
        )

    async def async_get_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrganizationDependabotSecret, OrganizationDependabotSecretType]:
        """dependabot/get-org-secret

        GET /orgs/{org}/dependabot/secrets/{secret_name}

        Gets a single organization secret without revealing its encrypted value.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#get-an-organization-secret
        """

        from ..models import OrganizationDependabotSecret

        url = f"/orgs/{org}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrganizationDependabotSecret,
        )

    @overload
    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgDependabotSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[list[Union[int, str]]] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgDependabotSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """dependabot/create-or-update-org-secret

        PUT /orgs/{org}/dependabot/secrets/{secret_name}

        Creates or updates an organization secret with an encrypted value. Encrypt your secret using
        [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#create-or-update-an-organization-secret
        """

        from ..models import EmptyObject, OrgsOrgDependabotSecretsSecretNamePutBody

        url = f"/orgs/{org}/dependabot/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgDependabotSecretsSecretNamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    @overload
    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgDependabotSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[list[Union[int, str]]] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgDependabotSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """dependabot/create-or-update-org-secret

        PUT /orgs/{org}/dependabot/secrets/{secret_name}

        Creates or updates an organization secret with an encrypted value. Encrypt your secret using
        [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#create-or-update-an-organization-secret
        """

        from ..models import EmptyObject, OrgsOrgDependabotSecretsSecretNamePutBody

        url = f"/orgs/{org}/dependabot/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgDependabotSecretsSecretNamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    def delete_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """dependabot/delete-org-secret

        DELETE /orgs/{org}/dependabot/secrets/{secret_name}

        Deletes a secret in an organization using the secret name.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#delete-an-organization-secret
        """

        url = f"/orgs/{org}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """dependabot/delete-org-secret

        DELETE /orgs/{org}/dependabot/secrets/{secret_name}

        Deletes a secret in an organization using the secret name.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#delete-an-organization-secret
        """

        url = f"/orgs/{org}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200,
        OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200Type,
    ]:
        """dependabot/list-selected-repos-for-org-secret

        GET /orgs/{org}/dependabot/secrets/{secret_name}/repositories

        Lists all repositories that have been selected when the `visibility`
        for repository access to a secret is set to `selected`.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#list-selected-repositories-for-an-organization-secret
        """

        from ..models import (
            OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200,
        )

        url = f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200,
        )

    async def async_list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200,
        OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200Type,
    ]:
        """dependabot/list-selected-repos-for-org-secret

        GET /orgs/{org}/dependabot/secrets/{secret_name}/repositories

        Lists all repositories that have been selected when the `visibility`
        for repository access to a secret is set to `selected`.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#list-selected-repositories-for-an-organization-secret
        """

        from ..models import (
            OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200,
        )

        url = f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200,
        )

    @overload
    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgDependabotSecretsSecretNameRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_repository_ids: list[int],
    ) -> Response: ...

    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            OrgsOrgDependabotSecretsSecretNameRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """dependabot/set-selected-repos-for-org-secret

        PUT /orgs/{org}/dependabot/secrets/{secret_name}/repositories

        Replaces all repositories for an organization secret when the `visibility`
        for repository access is set to `selected`. The visibility is set when you [Create
        or update an organization secret](https://docs.github.com/rest/dependabot/secrets#create-or-update-an-organization-secret).

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#set-selected-repositories-for-an-organization-secret
        """

        from ..models import OrgsOrgDependabotSecretsSecretNameRepositoriesPutBody

        url = f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgDependabotSecretsSecretNameRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgDependabotSecretsSecretNameRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_repository_ids: list[int],
    ) -> Response: ...

    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            OrgsOrgDependabotSecretsSecretNameRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """dependabot/set-selected-repos-for-org-secret

        PUT /orgs/{org}/dependabot/secrets/{secret_name}/repositories

        Replaces all repositories for an organization secret when the `visibility`
        for repository access is set to `selected`. The visibility is set when you [Create
        or update an organization secret](https://docs.github.com/rest/dependabot/secrets#create-or-update-an-organization-secret).

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#set-selected-repositories-for-an-organization-secret
        """

        from ..models import OrgsOrgDependabotSecretsSecretNameRepositoriesPutBody

        url = f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgDependabotSecretsSecretNameRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """dependabot/add-selected-repo-to-org-secret

        PUT /orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}

        Adds a repository to an organization secret when the `visibility` for
        repository access is set to `selected`. The visibility is set when you [Create or
        update an organization secret](https://docs.github.com/rest/dependabot/secrets#create-or-update-an-organization-secret).

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#add-selected-repository-to-an-organization-secret
        """

        url = (
            f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    async def async_add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """dependabot/add-selected-repo-to-org-secret

        PUT /orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}

        Adds a repository to an organization secret when the `visibility` for
        repository access is set to `selected`. The visibility is set when you [Create or
        update an organization secret](https://docs.github.com/rest/dependabot/secrets#create-or-update-an-organization-secret).

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#add-selected-repository-to-an-organization-secret
        """

        url = (
            f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    def remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """dependabot/remove-selected-repo-from-org-secret

        DELETE /orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}

        Removes a repository from an organization secret when the `visibility`
        for repository access is set to `selected`. The visibility is set when you [Create
        or update an organization secret](https://docs.github.com/rest/dependabot/secrets#create-or-update-an-organization-secret).

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#remove-selected-repository-from-an-organization-secret
        """

        url = (
            f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    async def async_remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """dependabot/remove-selected-repo-from-org-secret

        DELETE /orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}

        Removes a repository from an organization secret when the `visibility`
        for repository access is set to `selected`. The visibility is set when you [Create
        or update an organization secret](https://docs.github.com/rest/dependabot/secrets#create-or-update-an-organization-secret).

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#remove-selected-repository-from-an-organization-secret
        """

        url = (
            f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    def list_alerts_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        state: Missing[str] = UNSET,
        severity: Missing[str] = UNSET,
        ecosystem: Missing[str] = UNSET,
        package: Missing[str] = UNSET,
        manifest: Missing[str] = UNSET,
        epss_percentage: Missing[str] = UNSET,
        has: Missing[Union[str, list[Literal["patch"]]]] = UNSET,
        scope: Missing[Literal["development", "runtime"]] = UNSET,
        sort: Missing[Literal["created", "updated", "epss_percentage"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[DependabotAlert], list[DependabotAlertType]]:
        """dependabot/list-alerts-for-repo

        GET /repos/{owner}/{repo}/dependabot/alerts

        OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/rest/dependabot/alerts#list-dependabot-alerts-for-a-repository
        """

        from ..models import BasicError, DependabotAlert, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/dependabot/alerts"

        params = {
            "state": state,
            "severity": severity,
            "ecosystem": ecosystem,
            "package": package,
            "manifest": manifest,
            "epss_percentage": epss_percentage,
            "has": has,
            "scope": scope,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[DependabotAlert],
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_alerts_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        state: Missing[str] = UNSET,
        severity: Missing[str] = UNSET,
        ecosystem: Missing[str] = UNSET,
        package: Missing[str] = UNSET,
        manifest: Missing[str] = UNSET,
        epss_percentage: Missing[str] = UNSET,
        has: Missing[Union[str, list[Literal["patch"]]]] = UNSET,
        scope: Missing[Literal["development", "runtime"]] = UNSET,
        sort: Missing[Literal["created", "updated", "epss_percentage"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[DependabotAlert], list[DependabotAlertType]]:
        """dependabot/list-alerts-for-repo

        GET /repos/{owner}/{repo}/dependabot/alerts

        OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/rest/dependabot/alerts#list-dependabot-alerts-for-a-repository
        """

        from ..models import BasicError, DependabotAlert, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/dependabot/alerts"

        params = {
            "state": state,
            "severity": severity,
            "ecosystem": ecosystem,
            "package": package,
            "manifest": manifest,
            "epss_percentage": epss_percentage,
            "has": has,
            "scope": scope,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[DependabotAlert],
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DependabotAlert, DependabotAlertType]:
        """dependabot/get-alert

        GET /repos/{owner}/{repo}/dependabot/alerts/{alert_number}

        OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/rest/dependabot/alerts#get-a-dependabot-alert
        """

        from ..models import BasicError, DependabotAlert

        url = f"/repos/{owner}/{repo}/dependabot/alerts/{alert_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DependabotAlert,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DependabotAlert, DependabotAlertType]:
        """dependabot/get-alert

        GET /repos/{owner}/{repo}/dependabot/alerts/{alert_number}

        OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/rest/dependabot/alerts#get-a-dependabot-alert
        """

        from ..models import BasicError, DependabotAlert

        url = f"/repos/{owner}/{repo}/dependabot/alerts/{alert_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DependabotAlert,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoDependabotAlertsAlertNumberPatchBodyType,
    ) -> Response[DependabotAlert, DependabotAlertType]: ...

    @overload
    def update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        state: Literal["dismissed", "open"],
        dismissed_reason: Missing[
            Literal[
                "fix_started",
                "inaccurate",
                "no_bandwidth",
                "not_used",
                "tolerable_risk",
            ]
        ] = UNSET,
        dismissed_comment: Missing[str] = UNSET,
    ) -> Response[DependabotAlert, DependabotAlertType]: ...

    def update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoDependabotAlertsAlertNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[DependabotAlert, DependabotAlertType]:
        """dependabot/update-alert

        PATCH /repos/{owner}/{repo}/dependabot/alerts/{alert_number}

        The authenticated user must have access to security alerts for the repository to use this endpoint. For more information, see "[Granting access to security alerts](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-security-and-analysis-settings-for-your-repository#granting-access-to-security-alerts)."

        OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/rest/dependabot/alerts#update-a-dependabot-alert
        """

        from ..models import (
            BasicError,
            DependabotAlert,
            ReposOwnerRepoDependabotAlertsAlertNumberPatchBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/dependabot/alerts/{alert_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoDependabotAlertsAlertNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DependabotAlert,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoDependabotAlertsAlertNumberPatchBodyType,
    ) -> Response[DependabotAlert, DependabotAlertType]: ...

    @overload
    async def async_update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        state: Literal["dismissed", "open"],
        dismissed_reason: Missing[
            Literal[
                "fix_started",
                "inaccurate",
                "no_bandwidth",
                "not_used",
                "tolerable_risk",
            ]
        ] = UNSET,
        dismissed_comment: Missing[str] = UNSET,
    ) -> Response[DependabotAlert, DependabotAlertType]: ...

    async def async_update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoDependabotAlertsAlertNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[DependabotAlert, DependabotAlertType]:
        """dependabot/update-alert

        PATCH /repos/{owner}/{repo}/dependabot/alerts/{alert_number}

        The authenticated user must have access to security alerts for the repository to use this endpoint. For more information, see "[Granting access to security alerts](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-security-and-analysis-settings-for-your-repository#granting-access-to-security-alerts)."

        OAuth app tokens and personal access tokens (classic) need the `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/rest/dependabot/alerts#update-a-dependabot-alert
        """

        from ..models import (
            BasicError,
            DependabotAlert,
            ReposOwnerRepoDependabotAlertsAlertNumberPatchBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/dependabot/alerts/{alert_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoDependabotAlertsAlertNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DependabotAlert,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_repo_secrets(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoDependabotSecretsGetResponse200,
        ReposOwnerRepoDependabotSecretsGetResponse200Type,
    ]:
        """dependabot/list-repo-secrets

        GET /repos/{owner}/{repo}/dependabot/secrets

        Lists all secrets available in a repository without revealing their encrypted
        values.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#list-repository-secrets
        """

        from ..models import ReposOwnerRepoDependabotSecretsGetResponse200

        url = f"/repos/{owner}/{repo}/dependabot/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoDependabotSecretsGetResponse200,
        )

    async def async_list_repo_secrets(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoDependabotSecretsGetResponse200,
        ReposOwnerRepoDependabotSecretsGetResponse200Type,
    ]:
        """dependabot/list-repo-secrets

        GET /repos/{owner}/{repo}/dependabot/secrets

        Lists all secrets available in a repository without revealing their encrypted
        values.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#list-repository-secrets
        """

        from ..models import ReposOwnerRepoDependabotSecretsGetResponse200

        url = f"/repos/{owner}/{repo}/dependabot/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoDependabotSecretsGetResponse200,
        )

    def get_repo_public_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DependabotPublicKey, DependabotPublicKeyType]:
        """dependabot/get-repo-public-key

        GET /repos/{owner}/{repo}/dependabot/secrets/public-key

        Gets your public key, which you need to encrypt secrets. You need to
        encrypt a secret before you can create or update secrets. Anyone with read access
        to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint if the repository is private.

        See also: https://docs.github.com/rest/dependabot/secrets#get-a-repository-public-key
        """

        from ..models import DependabotPublicKey

        url = f"/repos/{owner}/{repo}/dependabot/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DependabotPublicKey,
        )

    async def async_get_repo_public_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DependabotPublicKey, DependabotPublicKeyType]:
        """dependabot/get-repo-public-key

        GET /repos/{owner}/{repo}/dependabot/secrets/public-key

        Gets your public key, which you need to encrypt secrets. You need to
        encrypt a secret before you can create or update secrets. Anyone with read access
        to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint if the repository is private.

        See also: https://docs.github.com/rest/dependabot/secrets#get-a-repository-public-key
        """

        from ..models import DependabotPublicKey

        url = f"/repos/{owner}/{repo}/dependabot/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DependabotPublicKey,
        )

    def get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DependabotSecret, DependabotSecretType]:
        """dependabot/get-repo-secret

        GET /repos/{owner}/{repo}/dependabot/secrets/{secret_name}

        Gets a single repository secret without revealing its encrypted value.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#get-a-repository-secret
        """

        from ..models import DependabotSecret

        url = f"/repos/{owner}/{repo}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DependabotSecret,
        )

    async def async_get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DependabotSecret, DependabotSecretType]:
        """dependabot/get-repo-secret

        GET /repos/{owner}/{repo}/dependabot/secrets/{secret_name}

        Gets a single repository secret without revealing its encrypted value.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#get-a-repository-secret
        """

        from ..models import DependabotSecret

        url = f"/repos/{owner}/{repo}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DependabotSecret,
        )

    @overload
    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoDependabotSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoDependabotSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """dependabot/create-or-update-repo-secret

        PUT /repos/{owner}/{repo}/dependabot/secrets/{secret_name}

        Creates or updates a repository secret with an encrypted value. Encrypt your secret using
        [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#create-or-update-a-repository-secret
        """

        from ..models import (
            EmptyObject,
            ReposOwnerRepoDependabotSecretsSecretNamePutBody,
        )

        url = f"/repos/{owner}/{repo}/dependabot/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoDependabotSecretsSecretNamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    @overload
    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoDependabotSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoDependabotSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """dependabot/create-or-update-repo-secret

        PUT /repos/{owner}/{repo}/dependabot/secrets/{secret_name}

        Creates or updates a repository secret with an encrypted value. Encrypt your secret using
        [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#create-or-update-a-repository-secret
        """

        from ..models import (
            EmptyObject,
            ReposOwnerRepoDependabotSecretsSecretNamePutBody,
        )

        url = f"/repos/{owner}/{repo}/dependabot/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoDependabotSecretsSecretNamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    def delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """dependabot/delete-repo-secret

        DELETE /repos/{owner}/{repo}/dependabot/secrets/{secret_name}

        Deletes a secret in a repository using the secret name.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#delete-a-repository-secret
        """

        url = f"/repos/{owner}/{repo}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """dependabot/delete-repo-secret

        DELETE /repos/{owner}/{repo}/dependabot/secrets/{secret_name}

        Deletes a secret in a repository using the secret name.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/dependabot/secrets#delete-a-repository-secret
        """

        url = f"/repos/{owner}/{repo}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )
