"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import OrganizationSimple
    from ..types import (
        EnterprisesEnterpriseTeamsEnterpriseTeamOrganizationsAddPostBodyType,
        EnterprisesEnterpriseTeamsEnterpriseTeamOrganizationsRemovePostBodyType,
        OrganizationSimpleType,
    )


class EnterpriseTeamOrganizationsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def get_assignments(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[OrganizationSimple], list[OrganizationSimpleType]]:
        """enterprise-team-organizations/get-assignments

        GET /enterprises/{enterprise}/teams/{enterprise-team}/organizations

        Get all organizations assigned to an enterprise team

        See also: https://docs.github.com/rest/enterprise-teams/enterprise-team-organizations#get-organization-assignments
        """

        from ..models import OrganizationSimple

        url = f"/enterprises/{enterprise}/teams/{enterprise_team}/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrganizationSimple],
        )

    async def async_get_assignments(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[OrganizationSimple], list[OrganizationSimpleType]]:
        """enterprise-team-organizations/get-assignments

        GET /enterprises/{enterprise}/teams/{enterprise-team}/organizations

        Get all organizations assigned to an enterprise team

        See also: https://docs.github.com/rest/enterprise-teams/enterprise-team-organizations#get-organization-assignments
        """

        from ..models import OrganizationSimple

        url = f"/enterprises/{enterprise}/teams/{enterprise_team}/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrganizationSimple],
        )

    @overload
    def bulk_add(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseTeamsEnterpriseTeamOrganizationsAddPostBodyType,
    ) -> Response[list[OrganizationSimple], list[OrganizationSimpleType]]: ...

    @overload
    def bulk_add(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        organization_slugs: list[str],
    ) -> Response[list[OrganizationSimple], list[OrganizationSimpleType]]: ...

    def bulk_add(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseTeamsEnterpriseTeamOrganizationsAddPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[OrganizationSimple], list[OrganizationSimpleType]]:
        """enterprise-team-organizations/bulk-add

        POST /enterprises/{enterprise}/teams/{enterprise-team}/organizations/add

        Assign an enterprise team to multiple organizations.

        See also: https://docs.github.com/rest/enterprise-teams/enterprise-team-organizations#add-organization-assignments
        """

        from ..models import (
            EnterprisesEnterpriseTeamsEnterpriseTeamOrganizationsAddPostBody,
            OrganizationSimple,
        )

        url = f"/enterprises/{enterprise}/teams/{enterprise_team}/organizations/add"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseTeamsEnterpriseTeamOrganizationsAddPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrganizationSimple],
        )

    @overload
    async def async_bulk_add(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseTeamsEnterpriseTeamOrganizationsAddPostBodyType,
    ) -> Response[list[OrganizationSimple], list[OrganizationSimpleType]]: ...

    @overload
    async def async_bulk_add(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        organization_slugs: list[str],
    ) -> Response[list[OrganizationSimple], list[OrganizationSimpleType]]: ...

    async def async_bulk_add(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseTeamsEnterpriseTeamOrganizationsAddPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[OrganizationSimple], list[OrganizationSimpleType]]:
        """enterprise-team-organizations/bulk-add

        POST /enterprises/{enterprise}/teams/{enterprise-team}/organizations/add

        Assign an enterprise team to multiple organizations.

        See also: https://docs.github.com/rest/enterprise-teams/enterprise-team-organizations#add-organization-assignments
        """

        from ..models import (
            EnterprisesEnterpriseTeamsEnterpriseTeamOrganizationsAddPostBody,
            OrganizationSimple,
        )

        url = f"/enterprises/{enterprise}/teams/{enterprise_team}/organizations/add"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseTeamsEnterpriseTeamOrganizationsAddPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrganizationSimple],
        )

    @overload
    def bulk_remove(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseTeamsEnterpriseTeamOrganizationsRemovePostBodyType,
    ) -> Response: ...

    @overload
    def bulk_remove(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        organization_slugs: list[str],
    ) -> Response: ...

    def bulk_remove(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseTeamsEnterpriseTeamOrganizationsRemovePostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-team-organizations/bulk-remove

        POST /enterprises/{enterprise}/teams/{enterprise-team}/organizations/remove

        Unassign an enterprise team from multiple organizations.

        See also: https://docs.github.com/rest/enterprise-teams/enterprise-team-organizations#remove-organization-assignments
        """

        from ..models import (
            EnterprisesEnterpriseTeamsEnterpriseTeamOrganizationsRemovePostBody,
        )

        url = f"/enterprises/{enterprise}/teams/{enterprise_team}/organizations/remove"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseTeamsEnterpriseTeamOrganizationsRemovePostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_bulk_remove(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseTeamsEnterpriseTeamOrganizationsRemovePostBodyType,
    ) -> Response: ...

    @overload
    async def async_bulk_remove(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        organization_slugs: list[str],
    ) -> Response: ...

    async def async_bulk_remove(
        self,
        enterprise: str,
        enterprise_team: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseTeamsEnterpriseTeamOrganizationsRemovePostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """enterprise-team-organizations/bulk-remove

        POST /enterprises/{enterprise}/teams/{enterprise-team}/organizations/remove

        Unassign an enterprise team from multiple organizations.

        See also: https://docs.github.com/rest/enterprise-teams/enterprise-team-organizations#remove-organization-assignments
        """

        from ..models import (
            EnterprisesEnterpriseTeamsEnterpriseTeamOrganizationsRemovePostBody,
        )

        url = f"/enterprises/{enterprise}/teams/{enterprise_team}/organizations/remove"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseTeamsEnterpriseTeamOrganizationsRemovePostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def get_assignment(
        self,
        enterprise: str,
        enterprise_team: str,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrganizationSimple, OrganizationSimpleType]:
        """enterprise-team-organizations/get-assignment

        GET /enterprises/{enterprise}/teams/{enterprise-team}/organizations/{org}

        Check if an enterprise team is assigned to an organization

        See also: https://docs.github.com/rest/enterprise-teams/enterprise-team-organizations#get-organization-assignment
        """

        from ..models import OrganizationSimple

        url = f"/enterprises/{enterprise}/teams/{enterprise_team}/organizations/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrganizationSimple,
            error_models={},
        )

    async def async_get_assignment(
        self,
        enterprise: str,
        enterprise_team: str,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrganizationSimple, OrganizationSimpleType]:
        """enterprise-team-organizations/get-assignment

        GET /enterprises/{enterprise}/teams/{enterprise-team}/organizations/{org}

        Check if an enterprise team is assigned to an organization

        See also: https://docs.github.com/rest/enterprise-teams/enterprise-team-organizations#get-organization-assignment
        """

        from ..models import OrganizationSimple

        url = f"/enterprises/{enterprise}/teams/{enterprise_team}/organizations/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrganizationSimple,
            error_models={},
        )

    def add(
        self,
        enterprise: str,
        enterprise_team: str,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrganizationSimple, OrganizationSimpleType]:
        """enterprise-team-organizations/add

        PUT /enterprises/{enterprise}/teams/{enterprise-team}/organizations/{org}

        Assign an enterprise team to an organization.

        See also: https://docs.github.com/rest/enterprise-teams/enterprise-team-organizations#add-an-organization-assignment
        """

        from ..models import OrganizationSimple

        url = f"/enterprises/{enterprise}/teams/{enterprise_team}/organizations/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrganizationSimple,
        )

    async def async_add(
        self,
        enterprise: str,
        enterprise_team: str,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrganizationSimple, OrganizationSimpleType]:
        """enterprise-team-organizations/add

        PUT /enterprises/{enterprise}/teams/{enterprise-team}/organizations/{org}

        Assign an enterprise team to an organization.

        See also: https://docs.github.com/rest/enterprise-teams/enterprise-team-organizations#add-an-organization-assignment
        """

        from ..models import OrganizationSimple

        url = f"/enterprises/{enterprise}/teams/{enterprise_team}/organizations/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrganizationSimple,
        )

    def delete(
        self,
        enterprise: str,
        enterprise_team: str,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-team-organizations/delete

        DELETE /enterprises/{enterprise}/teams/{enterprise-team}/organizations/{org}

        Unassign an enterprise team from an organization.

        See also: https://docs.github.com/rest/enterprise-teams/enterprise-team-organizations#delete-an-organization-assignment
        """

        url = f"/enterprises/{enterprise}/teams/{enterprise_team}/organizations/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete(
        self,
        enterprise: str,
        enterprise_team: str,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-team-organizations/delete

        DELETE /enterprises/{enterprise}/teams/{enterprise-team}/organizations/{org}

        Unassign an enterprise team from an organization.

        See also: https://docs.github.com/rest/enterprise-teams/enterprise-team-organizations#delete-an-organization-assignment
        """

        url = f"/enterprises/{enterprise}/teams/{enterprise_team}/organizations/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )
