"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional
from weakref import ref

from githubkit.typing import Missing
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        SearchCodeGetResponse200,
        SearchCommitsGetResponse200,
        SearchIssuesGetResponse200,
        SearchLabelsGetResponse200,
        SearchRepositoriesGetResponse200,
        SearchTopicsGetResponse200,
        SearchUsersGetResponse200,
    )
    from ..types import (
        SearchCodeGetResponse200Type,
        SearchCommitsGetResponse200Type,
        SearchIssuesGetResponse200Type,
        SearchLabelsGetResponse200Type,
        SearchRepositoriesGetResponse200Type,
        SearchTopicsGetResponse200Type,
        SearchUsersGetResponse200Type,
    )


class SearchClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def code(
        self,
        *,
        q: str,
        sort: Missing[Literal["indexed"]] = UNSET,
        order: Missing[Literal["desc", "asc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SearchCodeGetResponse200, SearchCodeGetResponse200Type]:
        """search/code

        GET /search/code

        Searches for query terms inside of a file. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).

        When searching for code, you can get text match metadata for the file **content** and file **path** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).

        For example, if you want to find the definition of the `addClass` function inside [jQuery](https://github.com/jquery/jquery) repository, your query would look something like this:

        `q=addClass+in:file+language:js+repo:jquery/jquery`

        This query searches for the keyword `addClass` within a file's contents. The query limits the search to files where the language is JavaScript in the `jquery/jquery` repository.

        Considerations for code search:

        Due to the complexity of searching code, there are a few restrictions on how searches are performed:

        *   Only the _default branch_ is considered. In most cases, this will be the `master` branch.
        *   Only files smaller than 384 KB are searchable.
        *   You must always include at least one search term when searching source code. For example, searching for [`language:go`](https://github.com/search?utf8=%E2%9C%93&q=language%3Ago&type=Code) is not valid, while [`amazing
        language:go`](https://github.com/search?utf8=%E2%9C%93&q=amazing+language%3Ago&type=Code) is.

        This endpoint requires you to authenticate and limits you to 10 requests per minute.

        See also: https://docs.github.com/rest/search/search#search-code
        """

        from ..models import (
            BasicError,
            EventsGetResponse503,
            SearchCodeGetResponse200,
            ValidationError,
        )

        url = "/search/code"

        params = {
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SearchCodeGetResponse200,
            error_models={
                "503": EventsGetResponse503,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_code(
        self,
        *,
        q: str,
        sort: Missing[Literal["indexed"]] = UNSET,
        order: Missing[Literal["desc", "asc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SearchCodeGetResponse200, SearchCodeGetResponse200Type]:
        """search/code

        GET /search/code

        Searches for query terms inside of a file. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).

        When searching for code, you can get text match metadata for the file **content** and file **path** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).

        For example, if you want to find the definition of the `addClass` function inside [jQuery](https://github.com/jquery/jquery) repository, your query would look something like this:

        `q=addClass+in:file+language:js+repo:jquery/jquery`

        This query searches for the keyword `addClass` within a file's contents. The query limits the search to files where the language is JavaScript in the `jquery/jquery` repository.

        Considerations for code search:

        Due to the complexity of searching code, there are a few restrictions on how searches are performed:

        *   Only the _default branch_ is considered. In most cases, this will be the `master` branch.
        *   Only files smaller than 384 KB are searchable.
        *   You must always include at least one search term when searching source code. For example, searching for [`language:go`](https://github.com/search?utf8=%E2%9C%93&q=language%3Ago&type=Code) is not valid, while [`amazing
        language:go`](https://github.com/search?utf8=%E2%9C%93&q=amazing+language%3Ago&type=Code) is.

        This endpoint requires you to authenticate and limits you to 10 requests per minute.

        See also: https://docs.github.com/rest/search/search#search-code
        """

        from ..models import (
            BasicError,
            EventsGetResponse503,
            SearchCodeGetResponse200,
            ValidationError,
        )

        url = "/search/code"

        params = {
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SearchCodeGetResponse200,
            error_models={
                "503": EventsGetResponse503,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def commits(
        self,
        *,
        q: str,
        sort: Missing[Literal["author-date", "committer-date"]] = UNSET,
        order: Missing[Literal["desc", "asc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SearchCommitsGetResponse200, SearchCommitsGetResponse200Type]:
        """search/commits

        GET /search/commits

        Find commits via various criteria on the default branch (usually `main`). This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).

        When searching for commits, you can get text match metadata for the **message** field when you provide the `text-match` media type. For more details about how to receive highlighted search results, see [Text match
        metadata](https://docs.github.com/rest/search/search#text-match-metadata).

        For example, if you want to find commits related to CSS in the [octocat/Spoon-Knife](https://github.com/octocat/Spoon-Knife) repository. Your query would look something like this:

        `q=repo:octocat/Spoon-Knife+css`

        See also: https://docs.github.com/rest/search/search#search-commits
        """

        from ..models import SearchCommitsGetResponse200

        url = "/search/commits"

        params = {
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SearchCommitsGetResponse200,
        )

    async def async_commits(
        self,
        *,
        q: str,
        sort: Missing[Literal["author-date", "committer-date"]] = UNSET,
        order: Missing[Literal["desc", "asc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SearchCommitsGetResponse200, SearchCommitsGetResponse200Type]:
        """search/commits

        GET /search/commits

        Find commits via various criteria on the default branch (usually `main`). This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).

        When searching for commits, you can get text match metadata for the **message** field when you provide the `text-match` media type. For more details about how to receive highlighted search results, see [Text match
        metadata](https://docs.github.com/rest/search/search#text-match-metadata).

        For example, if you want to find commits related to CSS in the [octocat/Spoon-Knife](https://github.com/octocat/Spoon-Knife) repository. Your query would look something like this:

        `q=repo:octocat/Spoon-Knife+css`

        See also: https://docs.github.com/rest/search/search#search-commits
        """

        from ..models import SearchCommitsGetResponse200

        url = "/search/commits"

        params = {
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SearchCommitsGetResponse200,
        )

    def issues_and_pull_requests(
        self,
        *,
        q: str,
        sort: Missing[
            Literal[
                "comments",
                "reactions",
                "reactions-+1",
                "reactions--1",
                "reactions-smile",
                "reactions-thinking_face",
                "reactions-heart",
                "reactions-tada",
                "interactions",
                "created",
                "updated",
            ]
        ] = UNSET,
        order: Missing[Literal["desc", "asc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        advanced_search: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SearchIssuesGetResponse200, SearchIssuesGetResponse200Type]:
        """search/issues-and-pull-requests

        GET /search/issues

        Find issues by state and keyword. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).

        When searching for issues, you can get text match metadata for the issue **title**, issue **body**, and issue **comment body** fields when you pass the `text-match` media type. For more details about how to receive highlighted
        search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).

        For example, if you want to find the oldest unresolved Python bugs on Windows. Your query might look something like this.

        `q=windows+label:bug+language:python+state:open&sort=created&order=asc`

        This query searches for the keyword `windows`, within any open issue that is labeled as `bug`. The search runs across repositories whose primary language is Python. The results are sorted by creation date in ascending order, which means the oldest issues appear first in the search results.

        > [!NOTE]
        > For requests made by GitHub Apps with a user access token, you can't retrieve a combination of issues and pull requests in a single query. Requests that don't include the `is:issue` or `is:pull-request` qualifier will receive an HTTP `422 Unprocessable Entity` response. To get results for both issues and pull requests, you must send separate queries for issues and pull requests. For more information about the `is` qualifier, see "[Searching only issues or pull requests](https://docs.github.com/github/searching-for-information-on-github/searching-issues-and-pull-requests#search-only-issues-or-pull-requests)."

        See also: https://docs.github.com/rest/search/search#search-issues-and-pull-requests
        """

        from ..models import (
            BasicError,
            EventsGetResponse503,
            SearchIssuesGetResponse200,
            ValidationError,
        )

        url = "/search/issues"

        params = {
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
            "advanced_search": advanced_search,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SearchIssuesGetResponse200,
            error_models={
                "503": EventsGetResponse503,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_issues_and_pull_requests(
        self,
        *,
        q: str,
        sort: Missing[
            Literal[
                "comments",
                "reactions",
                "reactions-+1",
                "reactions--1",
                "reactions-smile",
                "reactions-thinking_face",
                "reactions-heart",
                "reactions-tada",
                "interactions",
                "created",
                "updated",
            ]
        ] = UNSET,
        order: Missing[Literal["desc", "asc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        advanced_search: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SearchIssuesGetResponse200, SearchIssuesGetResponse200Type]:
        """search/issues-and-pull-requests

        GET /search/issues

        Find issues by state and keyword. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).

        When searching for issues, you can get text match metadata for the issue **title**, issue **body**, and issue **comment body** fields when you pass the `text-match` media type. For more details about how to receive highlighted
        search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).

        For example, if you want to find the oldest unresolved Python bugs on Windows. Your query might look something like this.

        `q=windows+label:bug+language:python+state:open&sort=created&order=asc`

        This query searches for the keyword `windows`, within any open issue that is labeled as `bug`. The search runs across repositories whose primary language is Python. The results are sorted by creation date in ascending order, which means the oldest issues appear first in the search results.

        > [!NOTE]
        > For requests made by GitHub Apps with a user access token, you can't retrieve a combination of issues and pull requests in a single query. Requests that don't include the `is:issue` or `is:pull-request` qualifier will receive an HTTP `422 Unprocessable Entity` response. To get results for both issues and pull requests, you must send separate queries for issues and pull requests. For more information about the `is` qualifier, see "[Searching only issues or pull requests](https://docs.github.com/github/searching-for-information-on-github/searching-issues-and-pull-requests#search-only-issues-or-pull-requests)."

        See also: https://docs.github.com/rest/search/search#search-issues-and-pull-requests
        """

        from ..models import (
            BasicError,
            EventsGetResponse503,
            SearchIssuesGetResponse200,
            ValidationError,
        )

        url = "/search/issues"

        params = {
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
            "advanced_search": advanced_search,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SearchIssuesGetResponse200,
            error_models={
                "503": EventsGetResponse503,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def labels(
        self,
        *,
        repository_id: int,
        q: str,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        order: Missing[Literal["desc", "asc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SearchLabelsGetResponse200, SearchLabelsGetResponse200Type]:
        """search/labels

        GET /search/labels

        Find labels in a repository with names or descriptions that match search keywords. Returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).

        When searching for labels, you can get text match metadata for the label **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).

        For example, if you want to find labels in the `linguist` repository that match `bug`, `defect`, or `enhancement`. Your query might look like this:

        `q=bug+defect+enhancement&repository_id=64778136`

        The labels that best match the query appear first in the search results.

        See also: https://docs.github.com/rest/search/search#search-labels
        """

        from ..models import BasicError, SearchLabelsGetResponse200, ValidationError

        url = "/search/labels"

        params = {
            "repository_id": repository_id,
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SearchLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    async def async_labels(
        self,
        *,
        repository_id: int,
        q: str,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        order: Missing[Literal["desc", "asc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SearchLabelsGetResponse200, SearchLabelsGetResponse200Type]:
        """search/labels

        GET /search/labels

        Find labels in a repository with names or descriptions that match search keywords. Returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).

        When searching for labels, you can get text match metadata for the label **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).

        For example, if you want to find labels in the `linguist` repository that match `bug`, `defect`, or `enhancement`. Your query might look like this:

        `q=bug+defect+enhancement&repository_id=64778136`

        The labels that best match the query appear first in the search results.

        See also: https://docs.github.com/rest/search/search#search-labels
        """

        from ..models import BasicError, SearchLabelsGetResponse200, ValidationError

        url = "/search/labels"

        params = {
            "repository_id": repository_id,
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SearchLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def repos(
        self,
        *,
        q: str,
        sort: Missing[
            Literal["stars", "forks", "help-wanted-issues", "updated"]
        ] = UNSET,
        order: Missing[Literal["desc", "asc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        SearchRepositoriesGetResponse200, SearchRepositoriesGetResponse200Type
    ]:
        """search/repos

        GET /search/repositories

        Find repositories via various criteria. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).

        When searching for repositories, you can get text match metadata for the **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).

        For example, if you want to search for popular Tetris repositories written in assembly code, your query might look like this:

        `q=tetris+language:assembly&sort=stars&order=desc`

        This query searches for repositories with the word `tetris` in the name, the description, or the README. The results are limited to repositories where the primary language is assembly. The results are sorted by stars in descending order, so that the most popular repositories appear first in the search results.

        See also: https://docs.github.com/rest/search/search#search-repositories
        """

        from ..models import (
            EventsGetResponse503,
            SearchRepositoriesGetResponse200,
            ValidationError,
        )

        url = "/search/repositories"

        params = {
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SearchRepositoriesGetResponse200,
            error_models={
                "503": EventsGetResponse503,
                "422": ValidationError,
            },
        )

    async def async_repos(
        self,
        *,
        q: str,
        sort: Missing[
            Literal["stars", "forks", "help-wanted-issues", "updated"]
        ] = UNSET,
        order: Missing[Literal["desc", "asc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        SearchRepositoriesGetResponse200, SearchRepositoriesGetResponse200Type
    ]:
        """search/repos

        GET /search/repositories

        Find repositories via various criteria. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).

        When searching for repositories, you can get text match metadata for the **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).

        For example, if you want to search for popular Tetris repositories written in assembly code, your query might look like this:

        `q=tetris+language:assembly&sort=stars&order=desc`

        This query searches for repositories with the word `tetris` in the name, the description, or the README. The results are limited to repositories where the primary language is assembly. The results are sorted by stars in descending order, so that the most popular repositories appear first in the search results.

        See also: https://docs.github.com/rest/search/search#search-repositories
        """

        from ..models import (
            EventsGetResponse503,
            SearchRepositoriesGetResponse200,
            ValidationError,
        )

        url = "/search/repositories"

        params = {
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SearchRepositoriesGetResponse200,
            error_models={
                "503": EventsGetResponse503,
                "422": ValidationError,
            },
        )

    def topics(
        self,
        *,
        q: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SearchTopicsGetResponse200, SearchTopicsGetResponse200Type]:
        r"""search/topics

        GET /search/topics

        Find topics via various criteria. Results are sorted by best match. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api). See "[Searching topics](https://docs.github.com/articles/searching-topics/)" for a detailed list of qualifiers.

        When searching for topics, you can get text match metadata for the topic's **short\_description**, **description**, **name**, or **display\_name** field when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).

        For example, if you want to search for topics related to Ruby that are featured on https://github.com/topics. Your query might look like this:

        `q=ruby+is:featured`

        This query searches for topics with the keyword `ruby` and limits the results to find only topics that are featured. The topics that are the best match for the query appear first in the search results.

        See also: https://docs.github.com/rest/search/search#search-topics
        """

        from ..models import SearchTopicsGetResponse200

        url = "/search/topics"

        params = {
            "q": q,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SearchTopicsGetResponse200,
        )

    async def async_topics(
        self,
        *,
        q: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SearchTopicsGetResponse200, SearchTopicsGetResponse200Type]:
        r"""search/topics

        GET /search/topics

        Find topics via various criteria. Results are sorted by best match. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api). See "[Searching topics](https://docs.github.com/articles/searching-topics/)" for a detailed list of qualifiers.

        When searching for topics, you can get text match metadata for the topic's **short\_description**, **description**, **name**, or **display\_name** field when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).

        For example, if you want to search for topics related to Ruby that are featured on https://github.com/topics. Your query might look like this:

        `q=ruby+is:featured`

        This query searches for topics with the keyword `ruby` and limits the results to find only topics that are featured. The topics that are the best match for the query appear first in the search results.

        See also: https://docs.github.com/rest/search/search#search-topics
        """

        from ..models import SearchTopicsGetResponse200

        url = "/search/topics"

        params = {
            "q": q,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SearchTopicsGetResponse200,
        )

    def users(
        self,
        *,
        q: str,
        sort: Missing[Literal["followers", "repositories", "joined"]] = UNSET,
        order: Missing[Literal["desc", "asc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SearchUsersGetResponse200, SearchUsersGetResponse200Type]:
        """search/users

        GET /search/users

        Find users via various criteria. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).

        When searching for users, you can get text match metadata for the issue **login**, public **email**, and **name** fields when you pass the `text-match` media type. For more details about highlighting search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata). For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).

        For example, if you're looking for a list of popular users, you might try this query:

        `q=tom+repos:%3E42+followers:%3E1000`

        This query searches for users with the name `tom`. The results are restricted to users with more than 42 repositories and over 1,000 followers.

        This endpoint does not accept authentication and will only include publicly visible users. As an alternative, you can use the GraphQL API. The GraphQL API requires authentication and will return private users, including Enterprise Managed Users (EMUs), that you are authorized to view. For more information, see "[GraphQL Queries](https://docs.github.com/graphql/reference/queries#search)."

        See also: https://docs.github.com/rest/search/search#search-users
        """

        from ..models import (
            EventsGetResponse503,
            SearchUsersGetResponse200,
            ValidationError,
        )

        url = "/search/users"

        params = {
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SearchUsersGetResponse200,
            error_models={
                "503": EventsGetResponse503,
                "422": ValidationError,
            },
        )

    async def async_users(
        self,
        *,
        q: str,
        sort: Missing[Literal["followers", "repositories", "joined"]] = UNSET,
        order: Missing[Literal["desc", "asc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SearchUsersGetResponse200, SearchUsersGetResponse200Type]:
        """search/users

        GET /search/users

        Find users via various criteria. This method returns up to 100 results [per page](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api).

        When searching for users, you can get text match metadata for the issue **login**, public **email**, and **name** fields when you pass the `text-match` media type. For more details about highlighting search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata). For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/search/search#text-match-metadata).

        For example, if you're looking for a list of popular users, you might try this query:

        `q=tom+repos:%3E42+followers:%3E1000`

        This query searches for users with the name `tom`. The results are restricted to users with more than 42 repositories and over 1,000 followers.

        This endpoint does not accept authentication and will only include publicly visible users. As an alternative, you can use the GraphQL API. The GraphQL API requires authentication and will return private users, including Enterprise Managed Users (EMUs), that you are authorized to view. For more information, see "[GraphQL Queries](https://docs.github.com/graphql/reference/queries#search)."

        See also: https://docs.github.com/rest/search/search#search-users
        """

        from ..models import (
            EventsGetResponse503,
            SearchUsersGetResponse200,
            ValidationError,
        )

        url = "/search/users"

        params = {
            "q": q,
            "sort": sort,
            "order": order,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SearchUsersGetResponse200,
            error_models={
                "503": EventsGetResponse503,
                "422": ValidationError,
            },
        )
