"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Optional
from weakref import ref

from githubkit.typing import Missing
from githubkit.utils import UNSET, exclude_unset, parse_query_params

if TYPE_CHECKING:
    from datetime import date

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import ApiOverview, Root
    from ..types import ApiOverviewTypeForResponse, RootTypeForResponse


class MetaClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def root(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Root, RootTypeForResponse]:
        """meta/root

        GET /

        Get Hypermedia links to resources accessible in GitHub's REST API

        See also: https://docs.github.com/enterprise-cloud@latest//rest/meta/meta#github-api-root
        """

        from ..models import Root

        url = "/"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Root,
        )

    async def async_root(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Root, RootTypeForResponse]:
        """meta/root

        GET /

        Get Hypermedia links to resources accessible in GitHub's REST API

        See also: https://docs.github.com/enterprise-cloud@latest//rest/meta/meta#github-api-root
        """

        from ..models import Root

        url = "/"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Root,
        )

    def get(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ApiOverview, ApiOverviewTypeForResponse]:
        """meta/get

        GET /meta

        Returns meta information about GitHub, including a list of GitHub's IP addresses. For more information, see "[About GitHub's IP addresses](https://docs.github.com/enterprise-cloud@latest//articles/about-github-s-ip-addresses/)."

        The API's response also includes a list of GitHub's domain names.

        The values shown in the documentation's response are example values. You must always query the API directly to get the latest values.

        > [!NOTE]
        > This endpoint returns both IPv4 and IPv6 addresses. However, not all features support IPv6. You should refer to the specific documentation for each feature to determine if IPv6 is supported.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/meta/meta#get-apiname-meta-information
        """

        from ..models import ApiOverview

        url = "/meta"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ApiOverview,
        )

    async def async_get(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ApiOverview, ApiOverviewTypeForResponse]:
        """meta/get

        GET /meta

        Returns meta information about GitHub, including a list of GitHub's IP addresses. For more information, see "[About GitHub's IP addresses](https://docs.github.com/enterprise-cloud@latest//articles/about-github-s-ip-addresses/)."

        The API's response also includes a list of GitHub's domain names.

        The values shown in the documentation's response are example values. You must always query the API directly to get the latest values.

        > [!NOTE]
        > This endpoint returns both IPv4 and IPv6 addresses. However, not all features support IPv6. You should refer to the specific documentation for each feature to determine if IPv6 is supported.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/meta/meta#get-apiname-meta-information
        """

        from ..models import ApiOverview

        url = "/meta"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ApiOverview,
        )

    def get_octocat(
        self,
        *,
        s: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[str, str]:
        """meta/get-octocat

        GET /octocat

        Get the octocat as ASCII art

        See also: https://docs.github.com/enterprise-cloud@latest//rest/meta/meta#get-octocat
        """

        url = "/octocat"

        params = {
            "s": s,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=str,
        )

    async def async_get_octocat(
        self,
        *,
        s: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[str, str]:
        """meta/get-octocat

        GET /octocat

        Get the octocat as ASCII art

        See also: https://docs.github.com/enterprise-cloud@latest//rest/meta/meta#get-octocat
        """

        url = "/octocat"

        params = {
            "s": s,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=str,
        )

    def get_all_versions(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[date], list[str]]:
        """meta/get-all-versions

        GET /versions

        Get all supported GitHub Enterprise Cloud API versions.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/meta/meta#get-all-api-versions
        """

        from datetime import date

        from ..models import BasicError

        url = "/versions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[date],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_all_versions(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[date], list[str]]:
        """meta/get-all-versions

        GET /versions

        Get all supported GitHub Enterprise Cloud API versions.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/meta/meta#get-all-api-versions
        """

        from datetime import date

        from ..models import BasicError

        url = "/versions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[date],
            error_models={
                "404": BasicError,
            },
        )

    def get_zen(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[str, str]:
        """meta/get-zen

        GET /zen

        Get a random sentence from the Zen of GitHub

        See also: https://docs.github.com/enterprise-cloud@latest//rest/meta/meta#get-the-zen-of-github
        """

        url = "/zen"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=str,
        )

    async def async_get_zen(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[str, str]:
        """meta/get-zen

        GET /zen

        Get a random sentence from the Zen of GitHub

        See also: https://docs.github.com/enterprise-cloud@latest//rest/meta/meta#get-the-zen-of-github
        """

        url = "/zen"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=str,
        )
