"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset, parse_query_params

if TYPE_CHECKING:
    from datetime import datetime
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import BaseGist, GistComment, GistCommit, GistSimple
    from ..types import (
        BaseGistTypeForResponse,
        GistCommentTypeForResponse,
        GistCommitTypeForResponse,
        GistsGistIdCommentsCommentIdPatchBodyType,
        GistsGistIdCommentsPostBodyType,
        GistsGistIdPatchBodyPropFilesType,
        GistsGistIdPatchBodyType,
        GistSimpleTypeForResponse,
        GistsPostBodyPropFilesType,
        GistsPostBodyType,
    )


class GistsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list(
        self,
        *,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[BaseGist], list[BaseGistTypeForResponse]]:
        """gists/list

        GET /gists

        Lists the authenticated user's gists or if called anonymously, this endpoint returns all public gists:

        See also: https://docs.github.com/rest/gists/gists#list-gists-for-the-authenticated-user
        """

        from ..models import BaseGist, BasicError

        url = "/gists"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[BaseGist],
            error_models={
                "403": BasicError,
            },
        )

    async def async_list(
        self,
        *,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[BaseGist], list[BaseGistTypeForResponse]]:
        """gists/list

        GET /gists

        Lists the authenticated user's gists or if called anonymously, this endpoint returns all public gists:

        See also: https://docs.github.com/rest/gists/gists#list-gists-for-the-authenticated-user
        """

        from ..models import BaseGist, BasicError

        url = "/gists"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[BaseGist],
            error_models={
                "403": BasicError,
            },
        )

    @overload
    def create(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: GistsPostBodyType,
    ) -> Response[GistSimple, GistSimpleTypeForResponse]: ...

    @overload
    def create(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        description: Missing[str] = UNSET,
        files: GistsPostBodyPropFilesType,
        public: Missing[Union[bool, Literal["true", "false"]]] = UNSET,
    ) -> Response[GistSimple, GistSimpleTypeForResponse]: ...

    def create(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[GistsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GistSimple, GistSimpleTypeForResponse]:
        """gists/create

        POST /gists

        Allows you to add a new gist with one or more files.

        > [!NOTE]
        > Don't name your files "gistfile" with a numerical suffix. This is the format of the automatic naming scheme that Gist uses internally.

        See also: https://docs.github.com/rest/gists/gists#create-a-gist
        """

        from ..models import BasicError, GistSimple, GistsPostBody, ValidationError

        url = "/gists"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(GistsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GistSimple,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: GistsPostBodyType,
    ) -> Response[GistSimple, GistSimpleTypeForResponse]: ...

    @overload
    async def async_create(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        description: Missing[str] = UNSET,
        files: GistsPostBodyPropFilesType,
        public: Missing[Union[bool, Literal["true", "false"]]] = UNSET,
    ) -> Response[GistSimple, GistSimpleTypeForResponse]: ...

    async def async_create(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[GistsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GistSimple, GistSimpleTypeForResponse]:
        """gists/create

        POST /gists

        Allows you to add a new gist with one or more files.

        > [!NOTE]
        > Don't name your files "gistfile" with a numerical suffix. This is the format of the automatic naming scheme that Gist uses internally.

        See also: https://docs.github.com/rest/gists/gists#create-a-gist
        """

        from ..models import BasicError, GistSimple, GistsPostBody, ValidationError

        url = "/gists"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(GistsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GistSimple,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_public(
        self,
        *,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[BaseGist], list[BaseGistTypeForResponse]]:
        """gists/list-public

        GET /gists/public

        List public gists sorted by most recently updated to least recently updated.

        Note: With [pagination](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api), you can fetch up to 3000 gists. For example, you can fetch 100 pages with 30 gists per page or 30 pages with 100 gists per page.

        See also: https://docs.github.com/rest/gists/gists#list-public-gists
        """

        from ..models import BaseGist, BasicError, ValidationError

        url = "/gists/public"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[BaseGist],
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_list_public(
        self,
        *,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[BaseGist], list[BaseGistTypeForResponse]]:
        """gists/list-public

        GET /gists/public

        List public gists sorted by most recently updated to least recently updated.

        Note: With [pagination](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api), you can fetch up to 3000 gists. For example, you can fetch 100 pages with 30 gists per page or 30 pages with 100 gists per page.

        See also: https://docs.github.com/rest/gists/gists#list-public-gists
        """

        from ..models import BaseGist, BasicError, ValidationError

        url = "/gists/public"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[BaseGist],
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def list_starred(
        self,
        *,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[BaseGist], list[BaseGistTypeForResponse]]:
        """gists/list-starred

        GET /gists/starred

        List the authenticated user's starred gists:

        See also: https://docs.github.com/rest/gists/gists#list-starred-gists
        """

        from ..models import BaseGist, BasicError

        url = "/gists/starred"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[BaseGist],
            error_models={
                "401": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_starred(
        self,
        *,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[BaseGist], list[BaseGistTypeForResponse]]:
        """gists/list-starred

        GET /gists/starred

        List the authenticated user's starred gists:

        See also: https://docs.github.com/rest/gists/gists#list-starred-gists
        """

        from ..models import BaseGist, BasicError

        url = "/gists/starred"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[BaseGist],
            error_models={
                "401": BasicError,
                "403": BasicError,
            },
        )

    def get(
        self,
        gist_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GistSimple, GistSimpleTypeForResponse]:
        """gists/get

        GET /gists/{gist_id}

        Gets a specified gist.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.

        See also: https://docs.github.com/rest/gists/gists#get-a-gist
        """

        from ..models import BasicError, GistsGistIdGetResponse403, GistSimple

        url = f"/gists/{gist_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GistSimple,
            error_models={
                "403": GistsGistIdGetResponse403,
                "404": BasicError,
            },
        )

    async def async_get(
        self,
        gist_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GistSimple, GistSimpleTypeForResponse]:
        """gists/get

        GET /gists/{gist_id}

        Gets a specified gist.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.

        See also: https://docs.github.com/rest/gists/gists#get-a-gist
        """

        from ..models import BasicError, GistsGistIdGetResponse403, GistSimple

        url = f"/gists/{gist_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GistSimple,
            error_models={
                "403": GistsGistIdGetResponse403,
                "404": BasicError,
            },
        )

    def delete(
        self,
        gist_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """gists/delete

        DELETE /gists/{gist_id}

        See also: https://docs.github.com/rest/gists/gists#delete-a-gist
        """

        from ..models import BasicError

        url = f"/gists/{gist_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_delete(
        self,
        gist_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """gists/delete

        DELETE /gists/{gist_id}

        See also: https://docs.github.com/rest/gists/gists#delete-a-gist
        """

        from ..models import BasicError

        url = f"/gists/{gist_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def update(
        self,
        gist_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[GistsGistIdPatchBodyType, None],
    ) -> Response[GistSimple, GistSimpleTypeForResponse]: ...

    @overload
    def update(
        self,
        gist_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        description: Missing[str] = UNSET,
        files: Missing[GistsGistIdPatchBodyPropFilesType] = UNSET,
    ) -> Response[GistSimple, GistSimpleTypeForResponse]: ...

    def update(
        self,
        gist_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[Union[GistsGistIdPatchBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[GistSimple, GistSimpleTypeForResponse]:
        """gists/update

        PATCH /gists/{gist_id}

        Allows you to update a gist's description and to update, delete, or rename gist files. Files
        from the previous version of the gist that aren't explicitly changed during an edit
        are unchanged.

        At least one of `description` or `files` is required.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.

        See also: https://docs.github.com/rest/gists/gists#update-a-gist
        """

        from typing import Union

        from ..models import (
            BasicError,
            GistsGistIdPatchBody,
            GistSimple,
            ValidationError,
        )

        url = f"/gists/{gist_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Union[GistsGistIdPatchBody, None], json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GistSimple,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update(
        self,
        gist_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[GistsGistIdPatchBodyType, None],
    ) -> Response[GistSimple, GistSimpleTypeForResponse]: ...

    @overload
    async def async_update(
        self,
        gist_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        description: Missing[str] = UNSET,
        files: Missing[GistsGistIdPatchBodyPropFilesType] = UNSET,
    ) -> Response[GistSimple, GistSimpleTypeForResponse]: ...

    async def async_update(
        self,
        gist_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[Union[GistsGistIdPatchBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[GistSimple, GistSimpleTypeForResponse]:
        """gists/update

        PATCH /gists/{gist_id}

        Allows you to update a gist's description and to update, delete, or rename gist files. Files
        from the previous version of the gist that aren't explicitly changed during an edit
        are unchanged.

        At least one of `description` or `files` is required.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.

        See also: https://docs.github.com/rest/gists/gists#update-a-gist
        """

        from typing import Union

        from ..models import (
            BasicError,
            GistsGistIdPatchBody,
            GistSimple,
            ValidationError,
        )

        url = f"/gists/{gist_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Union[GistsGistIdPatchBody, None], json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GistSimple,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_comments(
        self,
        gist_id: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[GistComment], list[GistCommentTypeForResponse]]:
        """gists/list-comments

        GET /gists/{gist_id}/comments

        Lists the comments on a gist.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.

        See also: https://docs.github.com/rest/gists/comments#list-gist-comments
        """

        from ..models import BasicError, GistComment

        url = f"/gists/{gist_id}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[GistComment],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_comments(
        self,
        gist_id: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[GistComment], list[GistCommentTypeForResponse]]:
        """gists/list-comments

        GET /gists/{gist_id}/comments

        Lists the comments on a gist.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.

        See also: https://docs.github.com/rest/gists/comments#list-gist-comments
        """

        from ..models import BasicError, GistComment

        url = f"/gists/{gist_id}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[GistComment],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def create_comment(
        self,
        gist_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: GistsGistIdCommentsPostBodyType,
    ) -> Response[GistComment, GistCommentTypeForResponse]: ...

    @overload
    def create_comment(
        self,
        gist_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        body: str,
    ) -> Response[GistComment, GistCommentTypeForResponse]: ...

    def create_comment(
        self,
        gist_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[GistsGistIdCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GistComment, GistCommentTypeForResponse]:
        """gists/create-comment

        POST /gists/{gist_id}/comments

        Creates a comment on a gist.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.

        See also: https://docs.github.com/rest/gists/comments#create-a-gist-comment
        """

        from ..models import BasicError, GistComment, GistsGistIdCommentsPostBody

        url = f"/gists/{gist_id}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(GistsGistIdCommentsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GistComment,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create_comment(
        self,
        gist_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: GistsGistIdCommentsPostBodyType,
    ) -> Response[GistComment, GistCommentTypeForResponse]: ...

    @overload
    async def async_create_comment(
        self,
        gist_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        body: str,
    ) -> Response[GistComment, GistCommentTypeForResponse]: ...

    async def async_create_comment(
        self,
        gist_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[GistsGistIdCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GistComment, GistCommentTypeForResponse]:
        """gists/create-comment

        POST /gists/{gist_id}/comments

        Creates a comment on a gist.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.

        See also: https://docs.github.com/rest/gists/comments#create-a-gist-comment
        """

        from ..models import BasicError, GistComment, GistsGistIdCommentsPostBody

        url = f"/gists/{gist_id}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(GistsGistIdCommentsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GistComment,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def get_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GistComment, GistCommentTypeForResponse]:
        """gists/get-comment

        GET /gists/{gist_id}/comments/{comment_id}

        Gets a comment on a gist.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.

        See also: https://docs.github.com/rest/gists/comments#get-a-gist-comment
        """

        from ..models import BasicError, GistComment, GistsGistIdGetResponse403

        url = f"/gists/{gist_id}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GistComment,
            error_models={
                "404": BasicError,
                "403": GistsGistIdGetResponse403,
            },
        )

    async def async_get_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GistComment, GistCommentTypeForResponse]:
        """gists/get-comment

        GET /gists/{gist_id}/comments/{comment_id}

        Gets a comment on a gist.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.

        See also: https://docs.github.com/rest/gists/comments#get-a-gist-comment
        """

        from ..models import BasicError, GistComment, GistsGistIdGetResponse403

        url = f"/gists/{gist_id}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GistComment,
            error_models={
                "404": BasicError,
                "403": GistsGistIdGetResponse403,
            },
        )

    def delete_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """gists/delete-comment

        DELETE /gists/{gist_id}/comments/{comment_id}

        See also: https://docs.github.com/rest/gists/comments#delete-a-gist-comment
        """

        from ..models import BasicError

        url = f"/gists/{gist_id}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_delete_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """gists/delete-comment

        DELETE /gists/{gist_id}/comments/{comment_id}

        See also: https://docs.github.com/rest/gists/comments#delete-a-gist-comment
        """

        from ..models import BasicError

        url = f"/gists/{gist_id}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def update_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: GistsGistIdCommentsCommentIdPatchBodyType,
    ) -> Response[GistComment, GistCommentTypeForResponse]: ...

    @overload
    def update_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        body: str,
    ) -> Response[GistComment, GistCommentTypeForResponse]: ...

    def update_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[GistsGistIdCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[GistComment, GistCommentTypeForResponse]:
        """gists/update-comment

        PATCH /gists/{gist_id}/comments/{comment_id}

        Updates a comment on a gist.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.

        See also: https://docs.github.com/rest/gists/comments#update-a-gist-comment
        """

        from ..models import (
            BasicError,
            GistComment,
            GistsGistIdCommentsCommentIdPatchBody,
        )

        url = f"/gists/{gist_id}/comments/{comment_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(GistsGistIdCommentsCommentIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GistComment,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_update_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: GistsGistIdCommentsCommentIdPatchBodyType,
    ) -> Response[GistComment, GistCommentTypeForResponse]: ...

    @overload
    async def async_update_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        body: str,
    ) -> Response[GistComment, GistCommentTypeForResponse]: ...

    async def async_update_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[GistsGistIdCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[GistComment, GistCommentTypeForResponse]:
        """gists/update-comment

        PATCH /gists/{gist_id}/comments/{comment_id}

        Updates a comment on a gist.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.

        See also: https://docs.github.com/rest/gists/comments#update-a-gist-comment
        """

        from ..models import (
            BasicError,
            GistComment,
            GistsGistIdCommentsCommentIdPatchBody,
        )

        url = f"/gists/{gist_id}/comments/{comment_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(GistsGistIdCommentsCommentIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GistComment,
            error_models={
                "404": BasicError,
            },
        )

    def list_commits(
        self,
        gist_id: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[GistCommit], list[GistCommitTypeForResponse]]:
        """gists/list-commits

        GET /gists/{gist_id}/commits

        See also: https://docs.github.com/rest/gists/gists#list-gist-commits
        """

        from ..models import BasicError, GistCommit

        url = f"/gists/{gist_id}/commits"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[GistCommit],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_commits(
        self,
        gist_id: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[GistCommit], list[GistCommitTypeForResponse]]:
        """gists/list-commits

        GET /gists/{gist_id}/commits

        See also: https://docs.github.com/rest/gists/gists#list-gist-commits
        """

        from ..models import BasicError, GistCommit

        url = f"/gists/{gist_id}/commits"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[GistCommit],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_forks(
        self,
        gist_id: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[GistSimple], list[GistSimpleTypeForResponse]]:
        """gists/list-forks

        GET /gists/{gist_id}/forks

        See also: https://docs.github.com/rest/gists/gists#list-gist-forks
        """

        from ..models import BasicError, GistSimple

        url = f"/gists/{gist_id}/forks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[GistSimple],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_forks(
        self,
        gist_id: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[GistSimple], list[GistSimpleTypeForResponse]]:
        """gists/list-forks

        GET /gists/{gist_id}/forks

        See also: https://docs.github.com/rest/gists/gists#list-gist-forks
        """

        from ..models import BasicError, GistSimple

        url = f"/gists/{gist_id}/forks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[GistSimple],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def fork(
        self,
        gist_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[BaseGist, BaseGistTypeForResponse]:
        """gists/fork

        POST /gists/{gist_id}/forks

        See also: https://docs.github.com/rest/gists/gists#fork-a-gist
        """

        from ..models import BaseGist, BasicError, ValidationError

        url = f"/gists/{gist_id}/forks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BaseGist,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_fork(
        self,
        gist_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[BaseGist, BaseGistTypeForResponse]:
        """gists/fork

        POST /gists/{gist_id}/forks

        See also: https://docs.github.com/rest/gists/gists#fork-a-gist
        """

        from ..models import BaseGist, BasicError, ValidationError

        url = f"/gists/{gist_id}/forks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BaseGist,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def check_is_starred(
        self,
        gist_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """gists/check-is-starred

        GET /gists/{gist_id}/star

        See also: https://docs.github.com/rest/gists/gists#check-if-a-gist-is-starred
        """

        from ..models import BasicError, GistsGistIdStarGetResponse404

        url = f"/gists/{gist_id}/star"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": GistsGistIdStarGetResponse404,
                "403": BasicError,
            },
        )

    async def async_check_is_starred(
        self,
        gist_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """gists/check-is-starred

        GET /gists/{gist_id}/star

        See also: https://docs.github.com/rest/gists/gists#check-if-a-gist-is-starred
        """

        from ..models import BasicError, GistsGistIdStarGetResponse404

        url = f"/gists/{gist_id}/star"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": GistsGistIdStarGetResponse404,
                "403": BasicError,
            },
        )

    def star(
        self,
        gist_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """gists/star

        PUT /gists/{gist_id}/star

        Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."

        See also: https://docs.github.com/rest/gists/gists#star-a-gist
        """

        from ..models import BasicError

        url = f"/gists/{gist_id}/star"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_star(
        self,
        gist_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """gists/star

        PUT /gists/{gist_id}/star

        Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."

        See also: https://docs.github.com/rest/gists/gists#star-a-gist
        """

        from ..models import BasicError

        url = f"/gists/{gist_id}/star"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def unstar(
        self,
        gist_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """gists/unstar

        DELETE /gists/{gist_id}/star

        See also: https://docs.github.com/rest/gists/gists#unstar-a-gist
        """

        from ..models import BasicError

        url = f"/gists/{gist_id}/star"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_unstar(
        self,
        gist_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """gists/unstar

        DELETE /gists/{gist_id}/star

        See also: https://docs.github.com/rest/gists/gists#unstar-a-gist
        """

        from ..models import BasicError

        url = f"/gists/{gist_id}/star"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def get_revision(
        self,
        gist_id: str,
        sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GistSimple, GistSimpleTypeForResponse]:
        """gists/get-revision

        GET /gists/{gist_id}/{sha}

        Gets a specified gist revision.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.

        See also: https://docs.github.com/rest/gists/gists#get-a-gist-revision
        """

        from ..models import BasicError, GistSimple, ValidationError

        url = f"/gists/{gist_id}/{sha}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GistSimple,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_get_revision(
        self,
        gist_id: str,
        sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GistSimple, GistSimpleTypeForResponse]:
        """gists/get-revision

        GET /gists/{gist_id}/{sha}

        Gets a specified gist revision.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw markdown. This is the default if you do not pass any specific media type.
        - **`application/vnd.github.base64+json`**: Returns the base64-encoded contents. This can be useful if your gist contains any invalid UTF-8 sequences.

        See also: https://docs.github.com/rest/gists/gists#get-a-gist-revision
        """

        from ..models import BasicError, GistSimple, ValidationError

        url = f"/gists/{gist_id}/{sha}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GistSimple,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_for_user(
        self,
        username: str,
        *,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[BaseGist], list[BaseGistTypeForResponse]]:
        """gists/list-for-user

        GET /users/{username}/gists

        Lists public gists for the specified user:

        See also: https://docs.github.com/rest/gists/gists#list-gists-for-a-user
        """

        from ..models import BaseGist, ValidationError

        url = f"/users/{username}/gists"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[BaseGist],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_for_user(
        self,
        username: str,
        *,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[BaseGist], list[BaseGistTypeForResponse]]:
        """gists/list-for-user

        GET /users/{username}/gists

        Lists public gists for the specified user:

        See also: https://docs.github.com/rest/gists/gists#list-gists-for-a-user
        """

        from ..models import BaseGist, ValidationError

        url = f"/users/{username}/gists"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[BaseGist],
            error_models={
                "422": ValidationError,
            },
        )
