"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from typing_extensions import deprecated
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset, parse_query_params

if TYPE_CHECKING:
    from datetime import datetime
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        ApiInsightsRouteStatsItems,
        ApiInsightsSubjectStatsItems,
        ApiInsightsSummaryStats,
        ApiInsightsTimeStatsItems,
        ApiInsightsUserStatsItems,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        CustomProperty,
        CustomPropertyValue,
        HookDelivery,
        HookDeliveryItem,
        ImmutableReleasesOrganizationSettings,
        IssueType,
        MinimalRepository,
        OrganizationFull,
        OrganizationInvitation,
        OrganizationProgrammaticAccessGrant,
        OrganizationProgrammaticAccessGrantRequest,
        OrganizationRole,
        OrganizationSimple,
        OrgHook,
        OrgMembership,
        OrgRepoCustomPropertyValues,
        OrgsOrgArtifactsMetadataStorageRecordPostResponse200,
        OrgsOrgArtifactsSubjectDigestMetadataStorageRecordsGetResponse200,
        OrgsOrgAttestationsBulkListPostResponse200,
        OrgsOrgAttestationsRepositoriesGetResponse200Items,
        OrgsOrgAttestationsSubjectDigestGetResponse200,
        OrgsOrgInstallationsGetResponse200,
        OrgsOrgOrganizationRolesGetResponse200,
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        OrgsOrgSettingsImmutableReleasesRepositoriesGetResponse200,
        RulesetVersion,
        RulesetVersionWithState,
        SimpleUser,
        Team,
        TeamRoleAssignment,
        TeamSimple,
        UserRoleAssignment,
        WebhookConfig,
    )
    from ..types import (
        ApiInsightsRouteStatsItemsTypeForResponse,
        ApiInsightsSubjectStatsItemsTypeForResponse,
        ApiInsightsSummaryStatsTypeForResponse,
        ApiInsightsTimeStatsItemsTypeForResponse,
        ApiInsightsUserStatsItemsTypeForResponse,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
        CustomPropertySetPayloadType,
        CustomPropertyType,
        CustomPropertyTypeForResponse,
        CustomPropertyValueType,
        CustomPropertyValueTypeForResponse,
        HookDeliveryItemTypeForResponse,
        HookDeliveryTypeForResponse,
        ImmutableReleasesOrganizationSettingsTypeForResponse,
        IssueTypeTypeForResponse,
        MinimalRepositoryTypeForResponse,
        OrganizationCreateIssueTypeType,
        OrganizationFullTypeForResponse,
        OrganizationInvitationTypeForResponse,
        OrganizationProgrammaticAccessGrantRequestTypeForResponse,
        OrganizationProgrammaticAccessGrantTypeForResponse,
        OrganizationRoleTypeForResponse,
        OrganizationSimpleTypeForResponse,
        OrganizationsOrgOrgPropertiesValuesPatchBodyType,
        OrganizationUpdateIssueTypeType,
        OrgHookTypeForResponse,
        OrgMembershipTypeForResponse,
        OrgRepoCustomPropertyValuesTypeForResponse,
        OrgsOrgArtifactsMetadataStorageRecordPostBodyType,
        OrgsOrgArtifactsMetadataStorageRecordPostResponse200TypeForResponse,
        OrgsOrgArtifactsSubjectDigestMetadataStorageRecordsGetResponse200TypeForResponse,
        OrgsOrgAttestationsBulkListPostBodyType,
        OrgsOrgAttestationsBulkListPostResponse200TypeForResponse,
        OrgsOrgAttestationsDeleteRequestPostBodyOneof0Type,
        OrgsOrgAttestationsDeleteRequestPostBodyOneof1Type,
        OrgsOrgAttestationsRepositoriesGetResponse200ItemsTypeForResponse,
        OrgsOrgAttestationsSubjectDigestGetResponse200TypeForResponse,
        OrgsOrgHooksHookIdConfigPatchBodyType,
        OrgsOrgHooksHookIdPatchBodyPropConfigType,
        OrgsOrgHooksHookIdPatchBodyType,
        OrgsOrgHooksPostBodyPropConfigType,
        OrgsOrgHooksPostBodyType,
        OrgsOrgInstallationsGetResponse200TypeForResponse,
        OrgsOrgInvitationsPostBodyType,
        OrgsOrgMembershipsUsernamePutBodyType,
        OrgsOrgOrganizationRolesGetResponse200TypeForResponse,
        OrgsOrgOutsideCollaboratorsUsernamePutBodyType,
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202TypeForResponse,
        OrgsOrgPatchBodyType,
        OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBodyType,
        OrgsOrgPersonalAccessTokenRequestsPostBodyType,
        OrgsOrgPersonalAccessTokensPatIdPostBodyType,
        OrgsOrgPersonalAccessTokensPostBodyType,
        OrgsOrgPropertiesSchemaPatchBodyType,
        OrgsOrgPropertiesValuesPatchBodyType,
        OrgsOrgSecurityProductEnablementPostBodyType,
        OrgsOrgSettingsImmutableReleasesPutBodyType,
        OrgsOrgSettingsImmutableReleasesRepositoriesGetResponse200TypeForResponse,
        OrgsOrgSettingsImmutableReleasesRepositoriesPutBodyType,
        RulesetVersionTypeForResponse,
        RulesetVersionWithStateTypeForResponse,
        SimpleUserTypeForResponse,
        TeamRoleAssignmentTypeForResponse,
        TeamSimpleTypeForResponse,
        TeamTypeForResponse,
        UserMembershipsOrgsOrgPatchBodyType,
        UserRoleAssignmentTypeForResponse,
        WebhookConfigTypeForResponse,
    )


class OrgsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list(
        self,
        *,
        since: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[OrganizationSimple], list[OrganizationSimpleTypeForResponse]]:
        """orgs/list

        GET /organizations

        Lists all organizations, in the order that they were created.

        > [!NOTE]
        > Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers) to get the URL for the next page of organizations.

        See also: https://docs.github.com/rest/orgs/orgs#list-organizations
        """

        from ..models import OrganizationSimple

        url = "/organizations"

        params = {
            "since": since,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrganizationSimple],
        )

    async def async_list(
        self,
        *,
        since: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[OrganizationSimple], list[OrganizationSimpleTypeForResponse]]:
        """orgs/list

        GET /organizations

        Lists all organizations, in the order that they were created.

        > [!NOTE]
        > Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers) to get the URL for the next page of organizations.

        See also: https://docs.github.com/rest/orgs/orgs#list-organizations
        """

        from ..models import OrganizationSimple

        url = "/organizations"

        params = {
            "since": since,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrganizationSimple],
        )

    def custom_properties_for_orgs_get_organization_values(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CustomPropertyValue], list[CustomPropertyValueTypeForResponse]]:
        """orgs/custom-properties-for-orgs-get-organization-values

        GET /organizations/{org}/org-properties/values

        Gets all custom property values that are set for an organization.

        The organization must belong to an enterprise.

        Access requirements:
        - Organization admins
        - OAuth tokens and personal access tokens (classic) with the `read:org` scope
        - Actors with the organization-level "read custom properties for an organization" fine-grained permission or above

        See also: https://docs.github.com/rest/orgs/custom-properties-for-orgs#get-all-custom-property-values-for-an-organization
        """

        from ..models import BasicError, CustomPropertyValue

        url = f"/organizations/{org}/org-properties/values"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CustomPropertyValue],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_custom_properties_for_orgs_get_organization_values(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CustomPropertyValue], list[CustomPropertyValueTypeForResponse]]:
        """orgs/custom-properties-for-orgs-get-organization-values

        GET /organizations/{org}/org-properties/values

        Gets all custom property values that are set for an organization.

        The organization must belong to an enterprise.

        Access requirements:
        - Organization admins
        - OAuth tokens and personal access tokens (classic) with the `read:org` scope
        - Actors with the organization-level "read custom properties for an organization" fine-grained permission or above

        See also: https://docs.github.com/rest/orgs/custom-properties-for-orgs#get-all-custom-property-values-for-an-organization
        """

        from ..models import BasicError, CustomPropertyValue

        url = f"/organizations/{org}/org-properties/values"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CustomPropertyValue],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def custom_properties_for_orgs_create_or_update_organization_values(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrganizationsOrgOrgPropertiesValuesPatchBodyType,
    ) -> Response: ...

    @overload
    def custom_properties_for_orgs_create_or_update_organization_values(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        properties: list[CustomPropertyValueType],
    ) -> Response: ...

    def custom_properties_for_orgs_create_or_update_organization_values(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrganizationsOrgOrgPropertiesValuesPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """orgs/custom-properties-for-orgs-create-or-update-organization-values

        PATCH /organizations/{org}/org-properties/values

        Create new or update existing custom property values for an organization.
        To remove a custom property value from an organization, set the property value to `null`.

        The organization must belong to an enterprise.

        Access requirements:
        - Organization admins
        - OAuth tokens and personal access tokens (classic) with the `admin:org` scope
        - Actors with the organization-level "edit custom properties for an organization" fine-grained permission

        See also: https://docs.github.com/rest/orgs/custom-properties-for-orgs#create-or-update-custom-property-values-for-an-organization
        """

        from ..models import (
            BasicError,
            OrganizationsOrgOrgPropertiesValuesPatchBody,
            ValidationError,
        )

        url = f"/organizations/{org}/org-properties/values"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrganizationsOrgOrgPropertiesValuesPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_custom_properties_for_orgs_create_or_update_organization_values(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrganizationsOrgOrgPropertiesValuesPatchBodyType,
    ) -> Response: ...

    @overload
    async def async_custom_properties_for_orgs_create_or_update_organization_values(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        properties: list[CustomPropertyValueType],
    ) -> Response: ...

    async def async_custom_properties_for_orgs_create_or_update_organization_values(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrganizationsOrgOrgPropertiesValuesPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """orgs/custom-properties-for-orgs-create-or-update-organization-values

        PATCH /organizations/{org}/org-properties/values

        Create new or update existing custom property values for an organization.
        To remove a custom property value from an organization, set the property value to `null`.

        The organization must belong to an enterprise.

        Access requirements:
        - Organization admins
        - OAuth tokens and personal access tokens (classic) with the `admin:org` scope
        - Actors with the organization-level "edit custom properties for an organization" fine-grained permission

        See also: https://docs.github.com/rest/orgs/custom-properties-for-orgs#create-or-update-custom-property-values-for-an-organization
        """

        from ..models import (
            BasicError,
            OrganizationsOrgOrgPropertiesValuesPatchBody,
            ValidationError,
        )

        url = f"/organizations/{org}/org-properties/values"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrganizationsOrgOrgPropertiesValuesPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrganizationFull, OrganizationFullTypeForResponse]:
        """orgs/get

        GET /orgs/{org}

        Gets information about an organization.

        When the value of `two_factor_requirement_enabled` is `true`, the organization requires all members, billing managers, outside collaborators, guest collaborators, repository collaborators, or everyone with access to any repository within the organization to enable [two-factor authentication](https://docs.github.com/articles/securing-your-account-with-two-factor-authentication-2fa/).

        To see the full details about an organization, the authenticated user must be an organization owner.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to see the full details about an organization.

        To see information about an organization's GitHub plan, GitHub Apps need the `Organization plan` permission.

        See also: https://docs.github.com/rest/orgs/orgs#get-an-organization
        """

        from ..models import BasicError, OrganizationFull

        url = f"/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrganizationFull,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrganizationFull, OrganizationFullTypeForResponse]:
        """orgs/get

        GET /orgs/{org}

        Gets information about an organization.

        When the value of `two_factor_requirement_enabled` is `true`, the organization requires all members, billing managers, outside collaborators, guest collaborators, repository collaborators, or everyone with access to any repository within the organization to enable [two-factor authentication](https://docs.github.com/articles/securing-your-account-with-two-factor-authentication-2fa/).

        To see the full details about an organization, the authenticated user must be an organization owner.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to see the full details about an organization.

        To see information about an organization's GitHub plan, GitHub Apps need the `Organization plan` permission.

        See also: https://docs.github.com/rest/orgs/orgs#get-an-organization
        """

        from ..models import BasicError, OrganizationFull

        url = f"/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrganizationFull,
            error_models={
                "404": BasicError,
            },
        )

    def delete(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
    ]:
        """orgs/delete

        DELETE /orgs/{org}

        Deletes an organization and all its repositories.

        The organization login will be unavailable for 90 days after deletion.

        Please review the Terms of Service regarding account deletion before using this endpoint:

        https://docs.github.com/site-policy/github-terms/github-terms-of-service

        See also: https://docs.github.com/rest/orgs/orgs#delete-an-organization
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
        )

        url = f"/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_delete(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
    ]:
        """orgs/delete

        DELETE /orgs/{org}

        Deletes an organization and all its repositories.

        The organization login will be unavailable for 90 days after deletion.

        Please review the Terms of Service regarding account deletion before using this endpoint:

        https://docs.github.com/site-policy/github-terms/github-terms-of-service

        See also: https://docs.github.com/rest/orgs/orgs#delete-an-organization
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
        )

        url = f"/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def update(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgPatchBodyType] = UNSET,
    ) -> Response[OrganizationFull, OrganizationFullTypeForResponse]: ...

    @overload
    def update(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        billing_email: Missing[str] = UNSET,
        company: Missing[str] = UNSET,
        email: Missing[str] = UNSET,
        twitter_username: Missing[str] = UNSET,
        location: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        has_organization_projects: Missing[bool] = UNSET,
        has_repository_projects: Missing[bool] = UNSET,
        default_repository_permission: Missing[
            Literal["read", "write", "admin", "none"]
        ] = UNSET,
        members_can_create_repositories: Missing[bool] = UNSET,
        members_can_create_internal_repositories: Missing[bool] = UNSET,
        members_can_create_private_repositories: Missing[bool] = UNSET,
        members_can_create_public_repositories: Missing[bool] = UNSET,
        members_allowed_repository_creation_type: Missing[
            Literal["all", "private", "none"]
        ] = UNSET,
        members_can_create_pages: Missing[bool] = UNSET,
        members_can_create_public_pages: Missing[bool] = UNSET,
        members_can_create_private_pages: Missing[bool] = UNSET,
        members_can_fork_private_repositories: Missing[bool] = UNSET,
        web_commit_signoff_required: Missing[bool] = UNSET,
        blog: Missing[str] = UNSET,
        advanced_security_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependabot_alerts_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependabot_security_updates_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependency_graph_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_push_protection_enabled_for_new_repositories: Missing[
            bool
        ] = UNSET,
        secret_scanning_push_protection_custom_link_enabled: Missing[bool] = UNSET,
        secret_scanning_push_protection_custom_link: Missing[str] = UNSET,
        deploy_keys_enabled_for_repositories: Missing[bool] = UNSET,
    ) -> Response[OrganizationFull, OrganizationFullTypeForResponse]: ...

    def update(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrganizationFull, OrganizationFullTypeForResponse]:
        """orgs/update

        PATCH /orgs/{org}

        > [!WARNING]
        > **Closing down notice:** GitHub will replace and discontinue `members_allowed_repository_creation_type` in favor of more granular permissions. The new input parameters are `members_can_create_public_repositories`, `members_can_create_private_repositories` for all organizations and `members_can_create_internal_repositories` for organizations associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see the [blog post](https://developer.github.com/changes/2019-12-03-internal-visibility-changes).

        > [!WARNING]
        > **Closing down notice:** Code security product enablement for new repositories through the organization API is closing down. Please use [code security configurations](https://docs.github.com/rest/code-security/configurations#set-a-code-security-configuration-as-a-default-for-an-organization) to set defaults instead. For more information on setting a default security configuration, see the [changelog](https://github.blog/changelog/2024-07-09-sunsetting-security-settings-defaults-parameters-in-the-organizations-rest-api/).

        Updates the organization's profile and member privileges.

        The authenticated user must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` or `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/orgs#update-an-organization
        """

        from typing import Union

        from ..models import (
            BasicError,
            OrganizationFull,
            OrgsOrgPatchBody,
            ValidationError,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrganizationFull,
            error_models={
                "422": Union[ValidationError, ValidationErrorSimple],
                "409": BasicError,
            },
        )

    @overload
    async def async_update(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgPatchBodyType] = UNSET,
    ) -> Response[OrganizationFull, OrganizationFullTypeForResponse]: ...

    @overload
    async def async_update(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        billing_email: Missing[str] = UNSET,
        company: Missing[str] = UNSET,
        email: Missing[str] = UNSET,
        twitter_username: Missing[str] = UNSET,
        location: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        has_organization_projects: Missing[bool] = UNSET,
        has_repository_projects: Missing[bool] = UNSET,
        default_repository_permission: Missing[
            Literal["read", "write", "admin", "none"]
        ] = UNSET,
        members_can_create_repositories: Missing[bool] = UNSET,
        members_can_create_internal_repositories: Missing[bool] = UNSET,
        members_can_create_private_repositories: Missing[bool] = UNSET,
        members_can_create_public_repositories: Missing[bool] = UNSET,
        members_allowed_repository_creation_type: Missing[
            Literal["all", "private", "none"]
        ] = UNSET,
        members_can_create_pages: Missing[bool] = UNSET,
        members_can_create_public_pages: Missing[bool] = UNSET,
        members_can_create_private_pages: Missing[bool] = UNSET,
        members_can_fork_private_repositories: Missing[bool] = UNSET,
        web_commit_signoff_required: Missing[bool] = UNSET,
        blog: Missing[str] = UNSET,
        advanced_security_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependabot_alerts_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependabot_security_updates_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependency_graph_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_push_protection_enabled_for_new_repositories: Missing[
            bool
        ] = UNSET,
        secret_scanning_push_protection_custom_link_enabled: Missing[bool] = UNSET,
        secret_scanning_push_protection_custom_link: Missing[str] = UNSET,
        deploy_keys_enabled_for_repositories: Missing[bool] = UNSET,
    ) -> Response[OrganizationFull, OrganizationFullTypeForResponse]: ...

    async def async_update(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrganizationFull, OrganizationFullTypeForResponse]:
        """orgs/update

        PATCH /orgs/{org}

        > [!WARNING]
        > **Closing down notice:** GitHub will replace and discontinue `members_allowed_repository_creation_type` in favor of more granular permissions. The new input parameters are `members_can_create_public_repositories`, `members_can_create_private_repositories` for all organizations and `members_can_create_internal_repositories` for organizations associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see the [blog post](https://developer.github.com/changes/2019-12-03-internal-visibility-changes).

        > [!WARNING]
        > **Closing down notice:** Code security product enablement for new repositories through the organization API is closing down. Please use [code security configurations](https://docs.github.com/rest/code-security/configurations#set-a-code-security-configuration-as-a-default-for-an-organization) to set defaults instead. For more information on setting a default security configuration, see the [changelog](https://github.blog/changelog/2024-07-09-sunsetting-security-settings-defaults-parameters-in-the-organizations-rest-api/).

        Updates the organization's profile and member privileges.

        The authenticated user must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` or `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/orgs#update-an-organization
        """

        from typing import Union

        from ..models import (
            BasicError,
            OrganizationFull,
            OrgsOrgPatchBody,
            ValidationError,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrganizationFull,
            error_models={
                "422": Union[ValidationError, ValidationErrorSimple],
                "409": BasicError,
            },
        )

    @overload
    def create_artifact_storage_record(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgArtifactsMetadataStorageRecordPostBodyType,
    ) -> Response[
        OrgsOrgArtifactsMetadataStorageRecordPostResponse200,
        OrgsOrgArtifactsMetadataStorageRecordPostResponse200TypeForResponse,
    ]: ...

    @overload
    def create_artifact_storage_record(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        digest: str,
        version: Missing[str] = UNSET,
        artifact_url: Missing[str] = UNSET,
        path: Missing[str] = UNSET,
        registry_url: str,
        repository: Missing[str] = UNSET,
        status: Missing[Literal["active", "eol", "deleted"]] = UNSET,
        github_repository: Missing[str] = UNSET,
    ) -> Response[
        OrgsOrgArtifactsMetadataStorageRecordPostResponse200,
        OrgsOrgArtifactsMetadataStorageRecordPostResponse200TypeForResponse,
    ]: ...

    def create_artifact_storage_record(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgArtifactsMetadataStorageRecordPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        OrgsOrgArtifactsMetadataStorageRecordPostResponse200,
        OrgsOrgArtifactsMetadataStorageRecordPostResponse200TypeForResponse,
    ]:
        """orgs/create-artifact-storage-record

        POST /orgs/{org}/artifacts/metadata/storage-record

        Create metadata storage records for artifacts associated with an organization.
        This endpoint will create a new artifact storage record on behalf of any artifact matching the provided digest and
        associated with a repository owned by the organization.

        See also: https://docs.github.com/rest/orgs/artifact-metadata#create-artifact-metadata-storage-record
        """

        from ..models import (
            OrgsOrgArtifactsMetadataStorageRecordPostBody,
            OrgsOrgArtifactsMetadataStorageRecordPostResponse200,
        )

        url = f"/orgs/{org}/artifacts/metadata/storage-record"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgArtifactsMetadataStorageRecordPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgArtifactsMetadataStorageRecordPostResponse200,
        )

    @overload
    async def async_create_artifact_storage_record(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgArtifactsMetadataStorageRecordPostBodyType,
    ) -> Response[
        OrgsOrgArtifactsMetadataStorageRecordPostResponse200,
        OrgsOrgArtifactsMetadataStorageRecordPostResponse200TypeForResponse,
    ]: ...

    @overload
    async def async_create_artifact_storage_record(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        digest: str,
        version: Missing[str] = UNSET,
        artifact_url: Missing[str] = UNSET,
        path: Missing[str] = UNSET,
        registry_url: str,
        repository: Missing[str] = UNSET,
        status: Missing[Literal["active", "eol", "deleted"]] = UNSET,
        github_repository: Missing[str] = UNSET,
    ) -> Response[
        OrgsOrgArtifactsMetadataStorageRecordPostResponse200,
        OrgsOrgArtifactsMetadataStorageRecordPostResponse200TypeForResponse,
    ]: ...

    async def async_create_artifact_storage_record(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgArtifactsMetadataStorageRecordPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        OrgsOrgArtifactsMetadataStorageRecordPostResponse200,
        OrgsOrgArtifactsMetadataStorageRecordPostResponse200TypeForResponse,
    ]:
        """orgs/create-artifact-storage-record

        POST /orgs/{org}/artifacts/metadata/storage-record

        Create metadata storage records for artifacts associated with an organization.
        This endpoint will create a new artifact storage record on behalf of any artifact matching the provided digest and
        associated with a repository owned by the organization.

        See also: https://docs.github.com/rest/orgs/artifact-metadata#create-artifact-metadata-storage-record
        """

        from ..models import (
            OrgsOrgArtifactsMetadataStorageRecordPostBody,
            OrgsOrgArtifactsMetadataStorageRecordPostResponse200,
        )

        url = f"/orgs/{org}/artifacts/metadata/storage-record"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgArtifactsMetadataStorageRecordPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgArtifactsMetadataStorageRecordPostResponse200,
        )

    def list_artifact_storage_records(
        self,
        org: str,
        subject_digest: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgArtifactsSubjectDigestMetadataStorageRecordsGetResponse200,
        OrgsOrgArtifactsSubjectDigestMetadataStorageRecordsGetResponse200TypeForResponse,
    ]:
        """orgs/list-artifact-storage-records

        GET /orgs/{org}/artifacts/{subject_digest}/metadata/storage-records

        List a collection of artifact storage records with a given subject digest that are associated with repositories owned by an organization.

        The collection of storage records returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `content:read` permission is required.

        See also: https://docs.github.com/rest/orgs/artifact-metadata#list-artifact-storage-records
        """

        from ..models import (
            OrgsOrgArtifactsSubjectDigestMetadataStorageRecordsGetResponse200,
        )

        url = f"/orgs/{org}/artifacts/{subject_digest}/metadata/storage-records"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgArtifactsSubjectDigestMetadataStorageRecordsGetResponse200,
        )

    async def async_list_artifact_storage_records(
        self,
        org: str,
        subject_digest: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgArtifactsSubjectDigestMetadataStorageRecordsGetResponse200,
        OrgsOrgArtifactsSubjectDigestMetadataStorageRecordsGetResponse200TypeForResponse,
    ]:
        """orgs/list-artifact-storage-records

        GET /orgs/{org}/artifacts/{subject_digest}/metadata/storage-records

        List a collection of artifact storage records with a given subject digest that are associated with repositories owned by an organization.

        The collection of storage records returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `content:read` permission is required.

        See also: https://docs.github.com/rest/orgs/artifact-metadata#list-artifact-storage-records
        """

        from ..models import (
            OrgsOrgArtifactsSubjectDigestMetadataStorageRecordsGetResponse200,
        )

        url = f"/orgs/{org}/artifacts/{subject_digest}/metadata/storage-records"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgArtifactsSubjectDigestMetadataStorageRecordsGetResponse200,
        )

    @overload
    def list_attestations_bulk(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgAttestationsBulkListPostBodyType,
    ) -> Response[
        OrgsOrgAttestationsBulkListPostResponse200,
        OrgsOrgAttestationsBulkListPostResponse200TypeForResponse,
    ]: ...

    @overload
    def list_attestations_bulk(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        subject_digests: list[str],
        predicate_type: Missing[str] = UNSET,
    ) -> Response[
        OrgsOrgAttestationsBulkListPostResponse200,
        OrgsOrgAttestationsBulkListPostResponse200TypeForResponse,
    ]: ...

    def list_attestations_bulk(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgAttestationsBulkListPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        OrgsOrgAttestationsBulkListPostResponse200,
        OrgsOrgAttestationsBulkListPostResponse200TypeForResponse,
    ]:
        """orgs/list-attestations-bulk

        POST /orgs/{org}/attestations/bulk-list

        List a collection of artifact attestations associated with any entry in a list of subject digests owned by an organization.

        The collection of attestations returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `attestations:read` permission is required.

        **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).

        See also: https://docs.github.com/rest/orgs/attestations#list-attestations-by-bulk-subject-digests
        """

        from ..models import (
            OrgsOrgAttestationsBulkListPostBody,
            OrgsOrgAttestationsBulkListPostResponse200,
        )

        url = f"/orgs/{org}/attestations/bulk-list"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgAttestationsBulkListPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            params=exclude_unset(parse_query_params(params)),
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgAttestationsBulkListPostResponse200,
        )

    @overload
    async def async_list_attestations_bulk(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgAttestationsBulkListPostBodyType,
    ) -> Response[
        OrgsOrgAttestationsBulkListPostResponse200,
        OrgsOrgAttestationsBulkListPostResponse200TypeForResponse,
    ]: ...

    @overload
    async def async_list_attestations_bulk(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        subject_digests: list[str],
        predicate_type: Missing[str] = UNSET,
    ) -> Response[
        OrgsOrgAttestationsBulkListPostResponse200,
        OrgsOrgAttestationsBulkListPostResponse200TypeForResponse,
    ]: ...

    async def async_list_attestations_bulk(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgAttestationsBulkListPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        OrgsOrgAttestationsBulkListPostResponse200,
        OrgsOrgAttestationsBulkListPostResponse200TypeForResponse,
    ]:
        """orgs/list-attestations-bulk

        POST /orgs/{org}/attestations/bulk-list

        List a collection of artifact attestations associated with any entry in a list of subject digests owned by an organization.

        The collection of attestations returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `attestations:read` permission is required.

        **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).

        See also: https://docs.github.com/rest/orgs/attestations#list-attestations-by-bulk-subject-digests
        """

        from ..models import (
            OrgsOrgAttestationsBulkListPostBody,
            OrgsOrgAttestationsBulkListPostResponse200,
        )

        url = f"/orgs/{org}/attestations/bulk-list"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgAttestationsBulkListPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            params=exclude_unset(parse_query_params(params)),
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgAttestationsBulkListPostResponse200,
        )

    @overload
    def delete_attestations_bulk(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            OrgsOrgAttestationsDeleteRequestPostBodyOneof0Type,
            OrgsOrgAttestationsDeleteRequestPostBodyOneof1Type,
        ],
    ) -> Response: ...

    @overload
    def delete_attestations_bulk(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        subject_digests: list[str],
    ) -> Response: ...

    @overload
    def delete_attestations_bulk(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        attestation_ids: list[int],
    ) -> Response: ...

    def delete_attestations_bulk(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                OrgsOrgAttestationsDeleteRequestPostBodyOneof0Type,
                OrgsOrgAttestationsDeleteRequestPostBodyOneof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """orgs/delete-attestations-bulk

        POST /orgs/{org}/attestations/delete-request

        Delete artifact attestations in bulk by either subject digests or unique ID.

        See also: https://docs.github.com/rest/orgs/attestations#delete-attestations-in-bulk
        """

        from typing import Union

        from ..models import (
            BasicError,
            OrgsOrgAttestationsDeleteRequestPostBodyOneof0,
            OrgsOrgAttestationsDeleteRequestPostBodyOneof1,
        )

        url = f"/orgs/{org}/attestations/delete-request"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    OrgsOrgAttestationsDeleteRequestPostBodyOneof0,
                    OrgsOrgAttestationsDeleteRequestPostBodyOneof1,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_delete_attestations_bulk(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            OrgsOrgAttestationsDeleteRequestPostBodyOneof0Type,
            OrgsOrgAttestationsDeleteRequestPostBodyOneof1Type,
        ],
    ) -> Response: ...

    @overload
    async def async_delete_attestations_bulk(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        subject_digests: list[str],
    ) -> Response: ...

    @overload
    async def async_delete_attestations_bulk(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        attestation_ids: list[int],
    ) -> Response: ...

    async def async_delete_attestations_bulk(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                OrgsOrgAttestationsDeleteRequestPostBodyOneof0Type,
                OrgsOrgAttestationsDeleteRequestPostBodyOneof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """orgs/delete-attestations-bulk

        POST /orgs/{org}/attestations/delete-request

        Delete artifact attestations in bulk by either subject digests or unique ID.

        See also: https://docs.github.com/rest/orgs/attestations#delete-attestations-in-bulk
        """

        from typing import Union

        from ..models import (
            BasicError,
            OrgsOrgAttestationsDeleteRequestPostBodyOneof0,
            OrgsOrgAttestationsDeleteRequestPostBodyOneof1,
        )

        url = f"/orgs/{org}/attestations/delete-request"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    OrgsOrgAttestationsDeleteRequestPostBodyOneof0,
                    OrgsOrgAttestationsDeleteRequestPostBodyOneof1,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    def delete_attestations_by_subject_digest(
        self,
        org: str,
        subject_digest: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/delete-attestations-by-subject-digest

        DELETE /orgs/{org}/attestations/digest/{subject_digest}

        Delete an artifact attestation by subject digest.

        See also: https://docs.github.com/rest/orgs/attestations#delete-attestations-by-subject-digest
        """

        from ..models import BasicError

        url = f"/orgs/{org}/attestations/digest/{subject_digest}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_attestations_by_subject_digest(
        self,
        org: str,
        subject_digest: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/delete-attestations-by-subject-digest

        DELETE /orgs/{org}/attestations/digest/{subject_digest}

        Delete an artifact attestation by subject digest.

        See also: https://docs.github.com/rest/orgs/attestations#delete-attestations-by-subject-digest
        """

        from ..models import BasicError

        url = f"/orgs/{org}/attestations/digest/{subject_digest}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    def list_attestation_repositories(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        predicate_type: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[OrgsOrgAttestationsRepositoriesGetResponse200Items],
        list[OrgsOrgAttestationsRepositoriesGetResponse200ItemsTypeForResponse],
    ]:
        """orgs/list-attestation-repositories

        GET /orgs/{org}/attestations/repositories

        List repositories owned by the provided organization that have created at least one attested artifact
        Results will be sorted in ascending order by repository ID

        See also: https://docs.github.com/rest/orgs/attestations#list-attestation-repositories
        """

        from ..models import OrgsOrgAttestationsRepositoriesGetResponse200Items

        url = f"/orgs/{org}/attestations/repositories"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
            "predicate_type": predicate_type,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrgsOrgAttestationsRepositoriesGetResponse200Items],
        )

    async def async_list_attestation_repositories(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        predicate_type: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[OrgsOrgAttestationsRepositoriesGetResponse200Items],
        list[OrgsOrgAttestationsRepositoriesGetResponse200ItemsTypeForResponse],
    ]:
        """orgs/list-attestation-repositories

        GET /orgs/{org}/attestations/repositories

        List repositories owned by the provided organization that have created at least one attested artifact
        Results will be sorted in ascending order by repository ID

        See also: https://docs.github.com/rest/orgs/attestations#list-attestation-repositories
        """

        from ..models import OrgsOrgAttestationsRepositoriesGetResponse200Items

        url = f"/orgs/{org}/attestations/repositories"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
            "predicate_type": predicate_type,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrgsOrgAttestationsRepositoriesGetResponse200Items],
        )

    def delete_attestations_by_id(
        self,
        org: str,
        attestation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/delete-attestations-by-id

        DELETE /orgs/{org}/attestations/{attestation_id}

        Delete an artifact attestation by unique ID that is associated with a repository owned by an org.

        See also: https://docs.github.com/rest/orgs/attestations#delete-attestations-by-id
        """

        from ..models import BasicError

        url = f"/orgs/{org}/attestations/{attestation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_attestations_by_id(
        self,
        org: str,
        attestation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/delete-attestations-by-id

        DELETE /orgs/{org}/attestations/{attestation_id}

        Delete an artifact attestation by unique ID that is associated with a repository owned by an org.

        See also: https://docs.github.com/rest/orgs/attestations#delete-attestations-by-id
        """

        from ..models import BasicError

        url = f"/orgs/{org}/attestations/{attestation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_attestations(
        self,
        org: str,
        subject_digest: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        predicate_type: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgAttestationsSubjectDigestGetResponse200,
        OrgsOrgAttestationsSubjectDigestGetResponse200TypeForResponse,
    ]:
        """orgs/list-attestations

        GET /orgs/{org}/attestations/{subject_digest}

        List a collection of artifact attestations with a given subject digest that are associated with repositories owned by an organization.

        The collection of attestations returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `attestations:read` permission is required.

        **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).

        See also: https://docs.github.com/rest/orgs/attestations#list-attestations
        """

        from ..models import OrgsOrgAttestationsSubjectDigestGetResponse200

        url = f"/orgs/{org}/attestations/{subject_digest}"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
            "predicate_type": predicate_type,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgAttestationsSubjectDigestGetResponse200,
        )

    async def async_list_attestations(
        self,
        org: str,
        subject_digest: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        predicate_type: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgAttestationsSubjectDigestGetResponse200,
        OrgsOrgAttestationsSubjectDigestGetResponse200TypeForResponse,
    ]:
        """orgs/list-attestations

        GET /orgs/{org}/attestations/{subject_digest}

        List a collection of artifact attestations with a given subject digest that are associated with repositories owned by an organization.

        The collection of attestations returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `attestations:read` permission is required.

        **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).

        See also: https://docs.github.com/rest/orgs/attestations#list-attestations
        """

        from ..models import OrgsOrgAttestationsSubjectDigestGetResponse200

        url = f"/orgs/{org}/attestations/{subject_digest}"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
            "predicate_type": predicate_type,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgAttestationsSubjectDigestGetResponse200,
        )

    def list_blocked_users(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SimpleUser], list[SimpleUserTypeForResponse]]:
        """orgs/list-blocked-users

        GET /orgs/{org}/blocks

        List the users blocked by an organization.

        See also: https://docs.github.com/rest/orgs/blocking#list-users-blocked-by-an-organization
        """

        from ..models import SimpleUser

        url = f"/orgs/{org}/blocks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
        )

    async def async_list_blocked_users(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SimpleUser], list[SimpleUserTypeForResponse]]:
        """orgs/list-blocked-users

        GET /orgs/{org}/blocks

        List the users blocked by an organization.

        See also: https://docs.github.com/rest/orgs/blocking#list-users-blocked-by-an-organization
        """

        from ..models import SimpleUser

        url = f"/orgs/{org}/blocks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
        )

    def check_blocked_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/check-blocked-user

        GET /orgs/{org}/blocks/{username}

        Returns a 204 if the given user is blocked by the given organization. Returns a 404 if the organization is not blocking the user, or if the user account has been identified as spam by GitHub.

        See also: https://docs.github.com/rest/orgs/blocking#check-if-a-user-is-blocked-by-an-organization
        """

        from ..models import BasicError

        url = f"/orgs/{org}/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    async def async_check_blocked_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/check-blocked-user

        GET /orgs/{org}/blocks/{username}

        Returns a 204 if the given user is blocked by the given organization. Returns a 404 if the organization is not blocking the user, or if the user account has been identified as spam by GitHub.

        See also: https://docs.github.com/rest/orgs/blocking#check-if-a-user-is-blocked-by-an-organization
        """

        from ..models import BasicError

        url = f"/orgs/{org}/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    def block_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/block-user

        PUT /orgs/{org}/blocks/{username}

        Blocks the given user on behalf of the specified organization and returns a 204. If the organization cannot block the given user a 422 is returned.

        See also: https://docs.github.com/rest/orgs/blocking#block-a-user-from-an-organization
        """

        from ..models import ValidationError

        url = f"/orgs/{org}/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": ValidationError,
            },
        )

    async def async_block_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/block-user

        PUT /orgs/{org}/blocks/{username}

        Blocks the given user on behalf of the specified organization and returns a 204. If the organization cannot block the given user a 422 is returned.

        See also: https://docs.github.com/rest/orgs/blocking#block-a-user-from-an-organization
        """

        from ..models import ValidationError

        url = f"/orgs/{org}/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": ValidationError,
            },
        )

    def unblock_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/unblock-user

        DELETE /orgs/{org}/blocks/{username}

        Unblocks the given user on behalf of the specified organization.

        See also: https://docs.github.com/rest/orgs/blocking#unblock-a-user-from-an-organization
        """

        url = f"/orgs/{org}/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_unblock_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/unblock-user

        DELETE /orgs/{org}/blocks/{username}

        Unblocks the given user on behalf of the specified organization.

        See also: https://docs.github.com/rest/orgs/blocking#unblock-a-user-from-an-organization
        """

        url = f"/orgs/{org}/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_failed_invitations(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[OrganizationInvitation], list[OrganizationInvitationTypeForResponse]
    ]:
        """orgs/list-failed-invitations

        GET /orgs/{org}/failed_invitations

        The return hash contains `failed_at` and `failed_reason` fields which represent the time at which the invitation failed and the reason for the failure.

        See also: https://docs.github.com/rest/orgs/members#list-failed-organization-invitations
        """

        from ..models import BasicError, OrganizationInvitation

        url = f"/orgs/{org}/failed_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrganizationInvitation],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_failed_invitations(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[OrganizationInvitation], list[OrganizationInvitationTypeForResponse]
    ]:
        """orgs/list-failed-invitations

        GET /orgs/{org}/failed_invitations

        The return hash contains `failed_at` and `failed_reason` fields which represent the time at which the invitation failed and the reason for the failure.

        See also: https://docs.github.com/rest/orgs/members#list-failed-organization-invitations
        """

        from ..models import BasicError, OrganizationInvitation

        url = f"/orgs/{org}/failed_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrganizationInvitation],
            error_models={
                "404": BasicError,
            },
        )

    def list_webhooks(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[OrgHook], list[OrgHookTypeForResponse]]:
        """orgs/list-webhooks

        GET /orgs/{org}/hooks

        List webhooks for an organization.

        The authenticated user must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
        webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#list-organization-webhooks
        """

        from ..models import BasicError, OrgHook

        url = f"/orgs/{org}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrgHook],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_webhooks(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[OrgHook], list[OrgHookTypeForResponse]]:
        """orgs/list-webhooks

        GET /orgs/{org}/hooks

        List webhooks for an organization.

        The authenticated user must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
        webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#list-organization-webhooks
        """

        from ..models import BasicError, OrgHook

        url = f"/orgs/{org}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrgHook],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_webhook(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgHooksPostBodyType,
    ) -> Response[OrgHook, OrgHookTypeForResponse]: ...

    @overload
    def create_webhook(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        config: OrgsOrgHooksPostBodyPropConfigType,
        events: Missing[list[str]] = UNSET,
        active: Missing[bool] = UNSET,
    ) -> Response[OrgHook, OrgHookTypeForResponse]: ...

    def create_webhook(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgHooksPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgHook, OrgHookTypeForResponse]:
        """orgs/create-webhook

        POST /orgs/{org}/hooks

        Create a hook that posts payloads in JSON format.

        You must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or
        edit webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#create-an-organization-webhook
        """

        from ..models import BasicError, OrgHook, OrgsOrgHooksPostBody, ValidationError

        url = f"/orgs/{org}/hooks"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgHooksPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgHook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_webhook(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgHooksPostBodyType,
    ) -> Response[OrgHook, OrgHookTypeForResponse]: ...

    @overload
    async def async_create_webhook(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        config: OrgsOrgHooksPostBodyPropConfigType,
        events: Missing[list[str]] = UNSET,
        active: Missing[bool] = UNSET,
    ) -> Response[OrgHook, OrgHookTypeForResponse]: ...

    async def async_create_webhook(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgHooksPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgHook, OrgHookTypeForResponse]:
        """orgs/create-webhook

        POST /orgs/{org}/hooks

        Create a hook that posts payloads in JSON format.

        You must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or
        edit webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#create-an-organization-webhook
        """

        from ..models import BasicError, OrgHook, OrgsOrgHooksPostBody, ValidationError

        url = f"/orgs/{org}/hooks"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgHooksPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgHook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrgHook, OrgHookTypeForResponse]:
        """orgs/get-webhook

        GET /orgs/{org}/hooks/{hook_id}

        Returns a webhook configured in an organization. To get only the webhook
        `config` properties, see "[Get a webhook configuration for an organization](/rest/orgs/webhooks#get-a-webhook-configuration-for-an-organization).

        You must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
        webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#get-an-organization-webhook
        """

        from ..models import BasicError, OrgHook

        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgHook,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrgHook, OrgHookTypeForResponse]:
        """orgs/get-webhook

        GET /orgs/{org}/hooks/{hook_id}

        Returns a webhook configured in an organization. To get only the webhook
        `config` properties, see "[Get a webhook configuration for an organization](/rest/orgs/webhooks#get-a-webhook-configuration-for-an-organization).

        You must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
        webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#get-an-organization-webhook
        """

        from ..models import BasicError, OrgHook

        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgHook,
            error_models={
                "404": BasicError,
            },
        )

    def delete_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/delete-webhook

        DELETE /orgs/{org}/hooks/{hook_id}

        Delete a webhook for an organization.

        The authenticated user must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
        webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#delete-an-organization-webhook
        """

        from ..models import BasicError

        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/delete-webhook

        DELETE /orgs/{org}/hooks/{hook_id}

        Delete a webhook for an organization.

        The authenticated user must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
        webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#delete-an-organization-webhook
        """

        from ..models import BasicError

        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgHooksHookIdPatchBodyType] = UNSET,
    ) -> Response[OrgHook, OrgHookTypeForResponse]: ...

    @overload
    def update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        config: Missing[OrgsOrgHooksHookIdPatchBodyPropConfigType] = UNSET,
        events: Missing[list[str]] = UNSET,
        active: Missing[bool] = UNSET,
        name: Missing[str] = UNSET,
    ) -> Response[OrgHook, OrgHookTypeForResponse]: ...

    def update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgHooksHookIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgHook, OrgHookTypeForResponse]:
        """orgs/update-webhook

        PATCH /orgs/{org}/hooks/{hook_id}

        Updates a webhook configured in an organization. When you update a webhook,
        the `secret` will be overwritten. If you previously had a `secret` set, you must
        provide the same `secret` or set a new `secret` or the secret will be removed. If
        you are only updating individual webhook `config` properties, use "[Update a webhook
        configuration for an organization](/rest/orgs/webhooks#update-a-webhook-configuration-for-an-organization)".

        You must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
        webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#update-an-organization-webhook
        """

        from ..models import (
            BasicError,
            OrgHook,
            OrgsOrgHooksHookIdPatchBody,
            ValidationError,
        )

        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgHooksHookIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgHook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgHooksHookIdPatchBodyType] = UNSET,
    ) -> Response[OrgHook, OrgHookTypeForResponse]: ...

    @overload
    async def async_update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        config: Missing[OrgsOrgHooksHookIdPatchBodyPropConfigType] = UNSET,
        events: Missing[list[str]] = UNSET,
        active: Missing[bool] = UNSET,
        name: Missing[str] = UNSET,
    ) -> Response[OrgHook, OrgHookTypeForResponse]: ...

    async def async_update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgHooksHookIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgHook, OrgHookTypeForResponse]:
        """orgs/update-webhook

        PATCH /orgs/{org}/hooks/{hook_id}

        Updates a webhook configured in an organization. When you update a webhook,
        the `secret` will be overwritten. If you previously had a `secret` set, you must
        provide the same `secret` or set a new `secret` or the secret will be removed. If
        you are only updating individual webhook `config` properties, use "[Update a webhook
        configuration for an organization](/rest/orgs/webhooks#update-a-webhook-configuration-for-an-organization)".

        You must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
        webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#update-an-organization-webhook
        """

        from ..models import (
            BasicError,
            OrgHook,
            OrgsOrgHooksHookIdPatchBody,
            ValidationError,
        )

        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgHooksHookIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgHook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[WebhookConfig, WebhookConfigTypeForResponse]:
        """orgs/get-webhook-config-for-org

        GET /orgs/{org}/hooks/{hook_id}/config

        Returns the webhook configuration for an organization. To get more information about the webhook, including the `active` state and `events`, use "[Get an organization webhook ](/rest/orgs/webhooks#get-an-organization-webhook)."

        You must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
        webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#get-a-webhook-configuration-for-an-organization
        """

        from ..models import WebhookConfig

        url = f"/orgs/{org}/hooks/{hook_id}/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=WebhookConfig,
        )

    async def async_get_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[WebhookConfig, WebhookConfigTypeForResponse]:
        """orgs/get-webhook-config-for-org

        GET /orgs/{org}/hooks/{hook_id}/config

        Returns the webhook configuration for an organization. To get more information about the webhook, including the `active` state and `events`, use "[Get an organization webhook ](/rest/orgs/webhooks#get-an-organization-webhook)."

        You must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
        webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#get-a-webhook-configuration-for-an-organization
        """

        from ..models import WebhookConfig

        url = f"/orgs/{org}/hooks/{hook_id}/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=WebhookConfig,
        )

    @overload
    def update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgHooksHookIdConfigPatchBodyType] = UNSET,
    ) -> Response[WebhookConfig, WebhookConfigTypeForResponse]: ...

    @overload
    def update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        url: Missing[str] = UNSET,
        content_type: Missing[str] = UNSET,
        secret: Missing[str] = UNSET,
        insecure_ssl: Missing[Union[str, float]] = UNSET,
    ) -> Response[WebhookConfig, WebhookConfigTypeForResponse]: ...

    def update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgHooksHookIdConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[WebhookConfig, WebhookConfigTypeForResponse]:
        """orgs/update-webhook-config-for-org

        PATCH /orgs/{org}/hooks/{hook_id}/config

        Updates the webhook configuration for an organization. To update more information about the webhook, including the `active` state and `events`, use "[Update an organization webhook ](/rest/orgs/webhooks#update-an-organization-webhook)."

        You must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
        webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#update-a-webhook-configuration-for-an-organization
        """

        from ..models import OrgsOrgHooksHookIdConfigPatchBody, WebhookConfig

        url = f"/orgs/{org}/hooks/{hook_id}/config"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgHooksHookIdConfigPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=WebhookConfig,
        )

    @overload
    async def async_update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgHooksHookIdConfigPatchBodyType] = UNSET,
    ) -> Response[WebhookConfig, WebhookConfigTypeForResponse]: ...

    @overload
    async def async_update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        url: Missing[str] = UNSET,
        content_type: Missing[str] = UNSET,
        secret: Missing[str] = UNSET,
        insecure_ssl: Missing[Union[str, float]] = UNSET,
    ) -> Response[WebhookConfig, WebhookConfigTypeForResponse]: ...

    async def async_update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgHooksHookIdConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[WebhookConfig, WebhookConfigTypeForResponse]:
        """orgs/update-webhook-config-for-org

        PATCH /orgs/{org}/hooks/{hook_id}/config

        Updates the webhook configuration for an organization. To update more information about the webhook, including the `active` state and `events`, use "[Update an organization webhook ](/rest/orgs/webhooks#update-an-organization-webhook)."

        You must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
        webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#update-a-webhook-configuration-for-an-organization
        """

        from ..models import OrgsOrgHooksHookIdConfigPatchBody, WebhookConfig

        url = f"/orgs/{org}/hooks/{hook_id}/config"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgHooksHookIdConfigPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=WebhookConfig,
        )

    def list_webhook_deliveries(
        self,
        org: str,
        hook_id: int,
        *,
        per_page: Missing[int] = UNSET,
        cursor: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[HookDeliveryItem], list[HookDeliveryItemTypeForResponse]]:
        """orgs/list-webhook-deliveries

        GET /orgs/{org}/hooks/{hook_id}/deliveries

        Returns a list of webhook deliveries for a webhook configured in an organization.

        You must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
        webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#list-deliveries-for-an-organization-webhook
        """

        from ..models import BasicError, HookDeliveryItem, ValidationError

        url = f"/orgs/{org}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_webhook_deliveries(
        self,
        org: str,
        hook_id: int,
        *,
        per_page: Missing[int] = UNSET,
        cursor: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[HookDeliveryItem], list[HookDeliveryItemTypeForResponse]]:
        """orgs/list-webhook-deliveries

        GET /orgs/{org}/hooks/{hook_id}/deliveries

        Returns a list of webhook deliveries for a webhook configured in an organization.

        You must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
        webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#list-deliveries-for-an-organization-webhook
        """

        from ..models import BasicError, HookDeliveryItem, ValidationError

        url = f"/orgs/{org}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def get_webhook_delivery(
        self,
        org: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[HookDelivery, HookDeliveryTypeForResponse]:
        """orgs/get-webhook-delivery

        GET /orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}

        Returns a delivery for a webhook configured in an organization.

        You must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
        webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#get-a-webhook-delivery-for-an-organization-webhook
        """

        from ..models import BasicError, HookDelivery, ValidationError

        url = f"/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_webhook_delivery(
        self,
        org: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[HookDelivery, HookDeliveryTypeForResponse]:
        """orgs/get-webhook-delivery

        GET /orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}

        Returns a delivery for a webhook configured in an organization.

        You must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
        webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#get-a-webhook-delivery-for-an-organization-webhook
        """

        from ..models import BasicError, HookDelivery, ValidationError

        url = f"/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def redeliver_webhook_delivery(
        self,
        org: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
    ]:
        """orgs/redeliver-webhook-delivery

        POST /orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts

        Redeliver a delivery for a webhook configured in an organization.

        You must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
        webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#redeliver-a-delivery-for-an-organization-webhook
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            ValidationError,
        )

        url = f"/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_redeliver_webhook_delivery(
        self,
        org: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
    ]:
        """orgs/redeliver-webhook-delivery

        POST /orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts

        Redeliver a delivery for a webhook configured in an organization.

        You must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
        webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#redeliver-a-delivery-for-an-organization-webhook
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            ValidationError,
        )

        url = f"/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def ping_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/ping-webhook

        POST /orgs/{org}/hooks/{hook_id}/pings

        This will trigger a [ping event](https://docs.github.com/webhooks/#ping-event)
        to be sent to the hook.

        You must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
        webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#ping-an-organization-webhook
        """

        from ..models import BasicError

        url = f"/orgs/{org}/hooks/{hook_id}/pings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    async def async_ping_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/ping-webhook

        POST /orgs/{org}/hooks/{hook_id}/pings

        This will trigger a [ping event](https://docs.github.com/webhooks/#ping-event)
        to be sent to the hook.

        You must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need `admin:org_hook` scope. OAuth apps cannot list, view, or edit
        webhooks that they did not create and users cannot list, view, or edit webhooks that were created by OAuth apps.

        See also: https://docs.github.com/rest/orgs/webhooks#ping-an-organization-webhook
        """

        from ..models import BasicError

        url = f"/orgs/{org}/hooks/{hook_id}/pings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    def get_route_stats_by_actor(
        self,
        org: str,
        actor_type: Literal[
            "installation",
            "classic_pat",
            "fine_grained_pat",
            "oauth_app",
            "github_app_user_to_server",
        ],
        actor_id: int,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        sort: Missing[
            list[
                Literal[
                    "last_rate_limited_timestamp",
                    "last_request_timestamp",
                    "rate_limited_request_count",
                    "http_method",
                    "api_route",
                    "total_request_count",
                ]
            ]
        ] = UNSET,
        api_route_substring: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[ApiInsightsRouteStatsItems],
        list[ApiInsightsRouteStatsItemsTypeForResponse],
    ]:
        """api-insights/get-route-stats-by-actor

        GET /orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}

        Get API request count statistics for an actor broken down by route within a specified time frame.

        See also: https://docs.github.com/rest/orgs/api-insights#get-route-stats-by-actor
        """

        from ..models import ApiInsightsRouteStatsItems

        url = f"/orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "page": page,
            "per_page": per_page,
            "direction": direction,
            "sort": sort,
            "api_route_substring": api_route_substring,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ApiInsightsRouteStatsItems],
        )

    async def async_get_route_stats_by_actor(
        self,
        org: str,
        actor_type: Literal[
            "installation",
            "classic_pat",
            "fine_grained_pat",
            "oauth_app",
            "github_app_user_to_server",
        ],
        actor_id: int,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        sort: Missing[
            list[
                Literal[
                    "last_rate_limited_timestamp",
                    "last_request_timestamp",
                    "rate_limited_request_count",
                    "http_method",
                    "api_route",
                    "total_request_count",
                ]
            ]
        ] = UNSET,
        api_route_substring: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[ApiInsightsRouteStatsItems],
        list[ApiInsightsRouteStatsItemsTypeForResponse],
    ]:
        """api-insights/get-route-stats-by-actor

        GET /orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}

        Get API request count statistics for an actor broken down by route within a specified time frame.

        See also: https://docs.github.com/rest/orgs/api-insights#get-route-stats-by-actor
        """

        from ..models import ApiInsightsRouteStatsItems

        url = f"/orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "page": page,
            "per_page": per_page,
            "direction": direction,
            "sort": sort,
            "api_route_substring": api_route_substring,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ApiInsightsRouteStatsItems],
        )

    def get_subject_stats(
        self,
        org: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        sort: Missing[
            list[
                Literal[
                    "last_rate_limited_timestamp",
                    "last_request_timestamp",
                    "rate_limited_request_count",
                    "subject_name",
                    "total_request_count",
                ]
            ]
        ] = UNSET,
        subject_name_substring: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[ApiInsightsSubjectStatsItems],
        list[ApiInsightsSubjectStatsItemsTypeForResponse],
    ]:
        """api-insights/get-subject-stats

        GET /orgs/{org}/insights/api/subject-stats

        Get API request statistics for all subjects within an organization within a specified time frame. Subjects can be users or GitHub Apps.

        See also: https://docs.github.com/rest/orgs/api-insights#get-subject-stats
        """

        from ..models import ApiInsightsSubjectStatsItems

        url = f"/orgs/{org}/insights/api/subject-stats"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "page": page,
            "per_page": per_page,
            "direction": direction,
            "sort": sort,
            "subject_name_substring": subject_name_substring,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ApiInsightsSubjectStatsItems],
        )

    async def async_get_subject_stats(
        self,
        org: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        sort: Missing[
            list[
                Literal[
                    "last_rate_limited_timestamp",
                    "last_request_timestamp",
                    "rate_limited_request_count",
                    "subject_name",
                    "total_request_count",
                ]
            ]
        ] = UNSET,
        subject_name_substring: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[ApiInsightsSubjectStatsItems],
        list[ApiInsightsSubjectStatsItemsTypeForResponse],
    ]:
        """api-insights/get-subject-stats

        GET /orgs/{org}/insights/api/subject-stats

        Get API request statistics for all subjects within an organization within a specified time frame. Subjects can be users or GitHub Apps.

        See also: https://docs.github.com/rest/orgs/api-insights#get-subject-stats
        """

        from ..models import ApiInsightsSubjectStatsItems

        url = f"/orgs/{org}/insights/api/subject-stats"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "page": page,
            "per_page": per_page,
            "direction": direction,
            "sort": sort,
            "subject_name_substring": subject_name_substring,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ApiInsightsSubjectStatsItems],
        )

    def get_summary_stats(
        self,
        org: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ApiInsightsSummaryStats, ApiInsightsSummaryStatsTypeForResponse]:
        """api-insights/get-summary-stats

        GET /orgs/{org}/insights/api/summary-stats

        Get overall statistics of API requests made within an organization by all users and apps within a specified time frame.

        See also: https://docs.github.com/rest/orgs/api-insights#get-summary-stats
        """

        from ..models import ApiInsightsSummaryStats

        url = f"/orgs/{org}/insights/api/summary-stats"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ApiInsightsSummaryStats,
        )

    async def async_get_summary_stats(
        self,
        org: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ApiInsightsSummaryStats, ApiInsightsSummaryStatsTypeForResponse]:
        """api-insights/get-summary-stats

        GET /orgs/{org}/insights/api/summary-stats

        Get overall statistics of API requests made within an organization by all users and apps within a specified time frame.

        See also: https://docs.github.com/rest/orgs/api-insights#get-summary-stats
        """

        from ..models import ApiInsightsSummaryStats

        url = f"/orgs/{org}/insights/api/summary-stats"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ApiInsightsSummaryStats,
        )

    def get_summary_stats_by_user(
        self,
        org: str,
        user_id: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ApiInsightsSummaryStats, ApiInsightsSummaryStatsTypeForResponse]:
        """api-insights/get-summary-stats-by-user

        GET /orgs/{org}/insights/api/summary-stats/users/{user_id}

        Get overall statistics of API requests within the organization for a user.

        See also: https://docs.github.com/rest/orgs/api-insights#get-summary-stats-by-user
        """

        from ..models import ApiInsightsSummaryStats

        url = f"/orgs/{org}/insights/api/summary-stats/users/{user_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ApiInsightsSummaryStats,
        )

    async def async_get_summary_stats_by_user(
        self,
        org: str,
        user_id: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ApiInsightsSummaryStats, ApiInsightsSummaryStatsTypeForResponse]:
        """api-insights/get-summary-stats-by-user

        GET /orgs/{org}/insights/api/summary-stats/users/{user_id}

        Get overall statistics of API requests within the organization for a user.

        See also: https://docs.github.com/rest/orgs/api-insights#get-summary-stats-by-user
        """

        from ..models import ApiInsightsSummaryStats

        url = f"/orgs/{org}/insights/api/summary-stats/users/{user_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ApiInsightsSummaryStats,
        )

    def get_summary_stats_by_actor(
        self,
        org: str,
        actor_type: Literal[
            "installation",
            "classic_pat",
            "fine_grained_pat",
            "oauth_app",
            "github_app_user_to_server",
        ],
        actor_id: int,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ApiInsightsSummaryStats, ApiInsightsSummaryStatsTypeForResponse]:
        """api-insights/get-summary-stats-by-actor

        GET /orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}

        Get overall statistics of API requests within the organization made by a specific actor. Actors can be GitHub App installations, OAuth apps or other tokens on behalf of a user.

        See also: https://docs.github.com/rest/orgs/api-insights#get-summary-stats-by-actor
        """

        from ..models import ApiInsightsSummaryStats

        url = f"/orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ApiInsightsSummaryStats,
        )

    async def async_get_summary_stats_by_actor(
        self,
        org: str,
        actor_type: Literal[
            "installation",
            "classic_pat",
            "fine_grained_pat",
            "oauth_app",
            "github_app_user_to_server",
        ],
        actor_id: int,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ApiInsightsSummaryStats, ApiInsightsSummaryStatsTypeForResponse]:
        """api-insights/get-summary-stats-by-actor

        GET /orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}

        Get overall statistics of API requests within the organization made by a specific actor. Actors can be GitHub App installations, OAuth apps or other tokens on behalf of a user.

        See also: https://docs.github.com/rest/orgs/api-insights#get-summary-stats-by-actor
        """

        from ..models import ApiInsightsSummaryStats

        url = f"/orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ApiInsightsSummaryStats,
        )

    def get_time_stats(
        self,
        org: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        timestamp_increment: str,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[ApiInsightsTimeStatsItems], list[ApiInsightsTimeStatsItemsTypeForResponse]
    ]:
        """api-insights/get-time-stats

        GET /orgs/{org}/insights/api/time-stats

        Get the number of API requests and rate-limited requests made within an organization over a specified time period.

        See also: https://docs.github.com/rest/orgs/api-insights#get-time-stats
        """

        from ..models import ApiInsightsTimeStatsItems

        url = f"/orgs/{org}/insights/api/time-stats"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "timestamp_increment": timestamp_increment,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ApiInsightsTimeStatsItems],
        )

    async def async_get_time_stats(
        self,
        org: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        timestamp_increment: str,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[ApiInsightsTimeStatsItems], list[ApiInsightsTimeStatsItemsTypeForResponse]
    ]:
        """api-insights/get-time-stats

        GET /orgs/{org}/insights/api/time-stats

        Get the number of API requests and rate-limited requests made within an organization over a specified time period.

        See also: https://docs.github.com/rest/orgs/api-insights#get-time-stats
        """

        from ..models import ApiInsightsTimeStatsItems

        url = f"/orgs/{org}/insights/api/time-stats"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "timestamp_increment": timestamp_increment,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ApiInsightsTimeStatsItems],
        )

    def get_time_stats_by_user(
        self,
        org: str,
        user_id: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        timestamp_increment: str,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[ApiInsightsTimeStatsItems], list[ApiInsightsTimeStatsItemsTypeForResponse]
    ]:
        """api-insights/get-time-stats-by-user

        GET /orgs/{org}/insights/api/time-stats/users/{user_id}

        Get the number of API requests and rate-limited requests made within an organization by a specific user over a specified time period.

        See also: https://docs.github.com/rest/orgs/api-insights#get-time-stats-by-user
        """

        from ..models import ApiInsightsTimeStatsItems

        url = f"/orgs/{org}/insights/api/time-stats/users/{user_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "timestamp_increment": timestamp_increment,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ApiInsightsTimeStatsItems],
        )

    async def async_get_time_stats_by_user(
        self,
        org: str,
        user_id: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        timestamp_increment: str,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[ApiInsightsTimeStatsItems], list[ApiInsightsTimeStatsItemsTypeForResponse]
    ]:
        """api-insights/get-time-stats-by-user

        GET /orgs/{org}/insights/api/time-stats/users/{user_id}

        Get the number of API requests and rate-limited requests made within an organization by a specific user over a specified time period.

        See also: https://docs.github.com/rest/orgs/api-insights#get-time-stats-by-user
        """

        from ..models import ApiInsightsTimeStatsItems

        url = f"/orgs/{org}/insights/api/time-stats/users/{user_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "timestamp_increment": timestamp_increment,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ApiInsightsTimeStatsItems],
        )

    def get_time_stats_by_actor(
        self,
        org: str,
        actor_type: Literal[
            "installation",
            "classic_pat",
            "fine_grained_pat",
            "oauth_app",
            "github_app_user_to_server",
        ],
        actor_id: int,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        timestamp_increment: str,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[ApiInsightsTimeStatsItems], list[ApiInsightsTimeStatsItemsTypeForResponse]
    ]:
        """api-insights/get-time-stats-by-actor

        GET /orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}

        Get the number of API requests and rate-limited requests made within an organization by a specific actor within a specified time period.

        See also: https://docs.github.com/rest/orgs/api-insights#get-time-stats-by-actor
        """

        from ..models import ApiInsightsTimeStatsItems

        url = f"/orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "timestamp_increment": timestamp_increment,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ApiInsightsTimeStatsItems],
        )

    async def async_get_time_stats_by_actor(
        self,
        org: str,
        actor_type: Literal[
            "installation",
            "classic_pat",
            "fine_grained_pat",
            "oauth_app",
            "github_app_user_to_server",
        ],
        actor_id: int,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        timestamp_increment: str,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[ApiInsightsTimeStatsItems], list[ApiInsightsTimeStatsItemsTypeForResponse]
    ]:
        """api-insights/get-time-stats-by-actor

        GET /orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}

        Get the number of API requests and rate-limited requests made within an organization by a specific actor within a specified time period.

        See also: https://docs.github.com/rest/orgs/api-insights#get-time-stats-by-actor
        """

        from ..models import ApiInsightsTimeStatsItems

        url = f"/orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "timestamp_increment": timestamp_increment,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ApiInsightsTimeStatsItems],
        )

    def get_user_stats(
        self,
        org: str,
        user_id: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        sort: Missing[
            list[
                Literal[
                    "last_rate_limited_timestamp",
                    "last_request_timestamp",
                    "rate_limited_request_count",
                    "subject_name",
                    "total_request_count",
                ]
            ]
        ] = UNSET,
        actor_name_substring: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[ApiInsightsUserStatsItems], list[ApiInsightsUserStatsItemsTypeForResponse]
    ]:
        """api-insights/get-user-stats

        GET /orgs/{org}/insights/api/user-stats/{user_id}

        Get API usage statistics within an organization for a user broken down by the type of access.

        See also: https://docs.github.com/rest/orgs/api-insights#get-user-stats
        """

        from ..models import ApiInsightsUserStatsItems

        url = f"/orgs/{org}/insights/api/user-stats/{user_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "page": page,
            "per_page": per_page,
            "direction": direction,
            "sort": sort,
            "actor_name_substring": actor_name_substring,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ApiInsightsUserStatsItems],
        )

    async def async_get_user_stats(
        self,
        org: str,
        user_id: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        sort: Missing[
            list[
                Literal[
                    "last_rate_limited_timestamp",
                    "last_request_timestamp",
                    "rate_limited_request_count",
                    "subject_name",
                    "total_request_count",
                ]
            ]
        ] = UNSET,
        actor_name_substring: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[ApiInsightsUserStatsItems], list[ApiInsightsUserStatsItemsTypeForResponse]
    ]:
        """api-insights/get-user-stats

        GET /orgs/{org}/insights/api/user-stats/{user_id}

        Get API usage statistics within an organization for a user broken down by the type of access.

        See also: https://docs.github.com/rest/orgs/api-insights#get-user-stats
        """

        from ..models import ApiInsightsUserStatsItems

        url = f"/orgs/{org}/insights/api/user-stats/{user_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "page": page,
            "per_page": per_page,
            "direction": direction,
            "sort": sort,
            "actor_name_substring": actor_name_substring,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ApiInsightsUserStatsItems],
        )

    def list_app_installations(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgInstallationsGetResponse200,
        OrgsOrgInstallationsGetResponse200TypeForResponse,
    ]:
        """orgs/list-app-installations

        GET /orgs/{org}/installations

        Lists all GitHub Apps in an organization. The installation count includes
        all GitHub Apps installed on repositories in the organization.

        The authenticated user must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:read` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/orgs#list-app-installations-for-an-organization
        """

        from ..models import OrgsOrgInstallationsGetResponse200

        url = f"/orgs/{org}/installations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgInstallationsGetResponse200,
        )

    async def async_list_app_installations(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgInstallationsGetResponse200,
        OrgsOrgInstallationsGetResponse200TypeForResponse,
    ]:
        """orgs/list-app-installations

        GET /orgs/{org}/installations

        Lists all GitHub Apps in an organization. The installation count includes
        all GitHub Apps installed on repositories in the organization.

        The authenticated user must be an organization owner to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:read` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/orgs#list-app-installations-for-an-organization
        """

        from ..models import OrgsOrgInstallationsGetResponse200

        url = f"/orgs/{org}/installations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgInstallationsGetResponse200,
        )

    def list_pending_invitations(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        role: Missing[
            Literal[
                "all", "admin", "direct_member", "billing_manager", "hiring_manager"
            ]
        ] = UNSET,
        invitation_source: Missing[Literal["all", "member", "scim"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[OrganizationInvitation], list[OrganizationInvitationTypeForResponse]
    ]:
        """orgs/list-pending-invitations

        GET /orgs/{org}/invitations

        The return hash contains a `role` field which refers to the Organization
        Invitation role and will be one of the following values: `direct_member`, `admin`,
        `billing_manager`, or `hiring_manager`. If the invitee is not a GitHub
        member, the `login` field in the return hash will be `null`.

        See also: https://docs.github.com/rest/orgs/members#list-pending-organization-invitations
        """

        from ..models import BasicError, OrganizationInvitation

        url = f"/orgs/{org}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
            "role": role,
            "invitation_source": invitation_source,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrganizationInvitation],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_pending_invitations(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        role: Missing[
            Literal[
                "all", "admin", "direct_member", "billing_manager", "hiring_manager"
            ]
        ] = UNSET,
        invitation_source: Missing[Literal["all", "member", "scim"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[OrganizationInvitation], list[OrganizationInvitationTypeForResponse]
    ]:
        """orgs/list-pending-invitations

        GET /orgs/{org}/invitations

        The return hash contains a `role` field which refers to the Organization
        Invitation role and will be one of the following values: `direct_member`, `admin`,
        `billing_manager`, or `hiring_manager`. If the invitee is not a GitHub
        member, the `login` field in the return hash will be `null`.

        See also: https://docs.github.com/rest/orgs/members#list-pending-organization-invitations
        """

        from ..models import BasicError, OrganizationInvitation

        url = f"/orgs/{org}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
            "role": role,
            "invitation_source": invitation_source,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrganizationInvitation],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_invitation(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgInvitationsPostBodyType] = UNSET,
    ) -> Response[OrganizationInvitation, OrganizationInvitationTypeForResponse]: ...

    @overload
    def create_invitation(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        invitee_id: Missing[int] = UNSET,
        email: Missing[str] = UNSET,
        role: Missing[
            Literal["admin", "direct_member", "billing_manager", "reinstate"]
        ] = UNSET,
        team_ids: Missing[list[int]] = UNSET,
    ) -> Response[OrganizationInvitation, OrganizationInvitationTypeForResponse]: ...

    def create_invitation(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgInvitationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrganizationInvitation, OrganizationInvitationTypeForResponse]:
        """orgs/create-invitation

        POST /orgs/{org}/invitations

        Invite people to an organization by using their GitHub user ID or their email address. In order to create invitations in an organization, the authenticated user must be an organization owner.

        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
        and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."

        See also: https://docs.github.com/rest/orgs/members#create-an-organization-invitation
        """

        from ..models import (
            BasicError,
            OrganizationInvitation,
            OrgsOrgInvitationsPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/invitations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgInvitationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrganizationInvitation,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_invitation(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgInvitationsPostBodyType] = UNSET,
    ) -> Response[OrganizationInvitation, OrganizationInvitationTypeForResponse]: ...

    @overload
    async def async_create_invitation(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        invitee_id: Missing[int] = UNSET,
        email: Missing[str] = UNSET,
        role: Missing[
            Literal["admin", "direct_member", "billing_manager", "reinstate"]
        ] = UNSET,
        team_ids: Missing[list[int]] = UNSET,
    ) -> Response[OrganizationInvitation, OrganizationInvitationTypeForResponse]: ...

    async def async_create_invitation(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgInvitationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrganizationInvitation, OrganizationInvitationTypeForResponse]:
        """orgs/create-invitation

        POST /orgs/{org}/invitations

        Invite people to an organization by using their GitHub user ID or their email address. In order to create invitations in an organization, the authenticated user must be an organization owner.

        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)"
        and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."

        See also: https://docs.github.com/rest/orgs/members#create-an-organization-invitation
        """

        from ..models import (
            BasicError,
            OrganizationInvitation,
            OrgsOrgInvitationsPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/invitations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgInvitationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrganizationInvitation,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def cancel_invitation(
        self,
        org: str,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/cancel-invitation

        DELETE /orgs/{org}/invitations/{invitation_id}

        Cancel an organization invitation. In order to cancel an organization invitation, the authenticated user must be an organization owner.

        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications).

        See also: https://docs.github.com/rest/orgs/members#cancel-an-organization-invitation
        """

        from ..models import BasicError, ValidationError

        url = f"/orgs/{org}/invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_cancel_invitation(
        self,
        org: str,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/cancel-invitation

        DELETE /orgs/{org}/invitations/{invitation_id}

        Cancel an organization invitation. In order to cancel an organization invitation, the authenticated user must be an organization owner.

        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications).

        See also: https://docs.github.com/rest/orgs/members#cancel-an-organization-invitation
        """

        from ..models import BasicError, ValidationError

        url = f"/orgs/{org}/invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_invitation_teams(
        self,
        org: str,
        invitation_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Team], list[TeamTypeForResponse]]:
        """orgs/list-invitation-teams

        GET /orgs/{org}/invitations/{invitation_id}/teams

        List all teams associated with an invitation. In order to see invitations in an organization, the authenticated user must be an organization owner.

        See also: https://docs.github.com/rest/orgs/members#list-organization-invitation-teams
        """

        from ..models import BasicError, Team

        url = f"/orgs/{org}/invitations/{invitation_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Team],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_invitation_teams(
        self,
        org: str,
        invitation_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Team], list[TeamTypeForResponse]]:
        """orgs/list-invitation-teams

        GET /orgs/{org}/invitations/{invitation_id}/teams

        List all teams associated with an invitation. In order to see invitations in an organization, the authenticated user must be an organization owner.

        See also: https://docs.github.com/rest/orgs/members#list-organization-invitation-teams
        """

        from ..models import BasicError, Team

        url = f"/orgs/{org}/invitations/{invitation_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Team],
            error_models={
                "404": BasicError,
            },
        )

    def list_issue_types(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[Union[IssueType, None]], list[Union[IssueTypeTypeForResponse, None]]
    ]:
        """orgs/list-issue-types

        GET /orgs/{org}/issue-types

        Lists all issue types for an organization. OAuth app tokens and personal access tokens (classic) need the read:org scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/issue-types#list-issue-types-for-an-organization
        """

        from typing import Union

        from ..models import BasicError, IssueType

        url = f"/orgs/{org}/issue-types"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Union[IssueType, None]],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_issue_types(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[Union[IssueType, None]], list[Union[IssueTypeTypeForResponse, None]]
    ]:
        """orgs/list-issue-types

        GET /orgs/{org}/issue-types

        Lists all issue types for an organization. OAuth app tokens and personal access tokens (classic) need the read:org scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/issue-types#list-issue-types-for-an-organization
        """

        from typing import Union

        from ..models import BasicError, IssueType

        url = f"/orgs/{org}/issue-types"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Union[IssueType, None]],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_issue_type(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrganizationCreateIssueTypeType,
    ) -> Response[Union[IssueType, None], Union[IssueTypeTypeForResponse, None]]: ...

    @overload
    def create_issue_type(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        is_enabled: bool,
        description: Missing[Union[str, None]] = UNSET,
        color: Missing[
            Union[
                None,
                Literal[
                    "gray", "blue", "green", "yellow", "orange", "red", "pink", "purple"
                ],
            ]
        ] = UNSET,
    ) -> Response[Union[IssueType, None], Union[IssueTypeTypeForResponse, None]]: ...

    def create_issue_type(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrganizationCreateIssueTypeType] = UNSET,
        **kwargs,
    ) -> Response[Union[IssueType, None], Union[IssueTypeTypeForResponse, None]]:
        """orgs/create-issue-type

        POST /orgs/{org}/issue-types

        Create a new issue type for an organization.

        You can find out more about issue types in [Managing issue types in an organization](https://docs.github.com/issues/tracking-your-work-with-issues/configuring-issues/managing-issue-types-in-an-organization).

        To use this endpoint, the authenticated user must be an administrator for the organization. OAuth app tokens and
        personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/issue-types#create-issue-type-for-an-organization
        """

        from typing import Union

        from ..models import (
            BasicError,
            IssueType,
            OrganizationCreateIssueType,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}/issue-types"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrganizationCreateIssueType, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Union[IssueType, None],
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_create_issue_type(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrganizationCreateIssueTypeType,
    ) -> Response[Union[IssueType, None], Union[IssueTypeTypeForResponse, None]]: ...

    @overload
    async def async_create_issue_type(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        is_enabled: bool,
        description: Missing[Union[str, None]] = UNSET,
        color: Missing[
            Union[
                None,
                Literal[
                    "gray", "blue", "green", "yellow", "orange", "red", "pink", "purple"
                ],
            ]
        ] = UNSET,
    ) -> Response[Union[IssueType, None], Union[IssueTypeTypeForResponse, None]]: ...

    async def async_create_issue_type(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrganizationCreateIssueTypeType] = UNSET,
        **kwargs,
    ) -> Response[Union[IssueType, None], Union[IssueTypeTypeForResponse, None]]:
        """orgs/create-issue-type

        POST /orgs/{org}/issue-types

        Create a new issue type for an organization.

        You can find out more about issue types in [Managing issue types in an organization](https://docs.github.com/issues/tracking-your-work-with-issues/configuring-issues/managing-issue-types-in-an-organization).

        To use this endpoint, the authenticated user must be an administrator for the organization. OAuth app tokens and
        personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/issue-types#create-issue-type-for-an-organization
        """

        from typing import Union

        from ..models import (
            BasicError,
            IssueType,
            OrganizationCreateIssueType,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}/issue-types"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrganizationCreateIssueType, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Union[IssueType, None],
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def update_issue_type(
        self,
        org: str,
        issue_type_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrganizationUpdateIssueTypeType,
    ) -> Response[Union[IssueType, None], Union[IssueTypeTypeForResponse, None]]: ...

    @overload
    def update_issue_type(
        self,
        org: str,
        issue_type_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        is_enabled: bool,
        description: Missing[Union[str, None]] = UNSET,
        color: Missing[
            Union[
                None,
                Literal[
                    "gray", "blue", "green", "yellow", "orange", "red", "pink", "purple"
                ],
            ]
        ] = UNSET,
    ) -> Response[Union[IssueType, None], Union[IssueTypeTypeForResponse, None]]: ...

    def update_issue_type(
        self,
        org: str,
        issue_type_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrganizationUpdateIssueTypeType] = UNSET,
        **kwargs,
    ) -> Response[Union[IssueType, None], Union[IssueTypeTypeForResponse, None]]:
        """orgs/update-issue-type

        PUT /orgs/{org}/issue-types/{issue_type_id}

        Updates an issue type for an organization.

        You can find out more about issue types in [Managing issue types in an organization](https://docs.github.com/issues/tracking-your-work-with-issues/configuring-issues/managing-issue-types-in-an-organization).

        To use this endpoint, the authenticated user must be an administrator for the organization. OAuth app tokens and
        personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/issue-types#update-issue-type-for-an-organization
        """

        from typing import Union

        from ..models import (
            BasicError,
            IssueType,
            OrganizationUpdateIssueType,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}/issue-types/{issue_type_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrganizationUpdateIssueType, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Union[IssueType, None],
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_update_issue_type(
        self,
        org: str,
        issue_type_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrganizationUpdateIssueTypeType,
    ) -> Response[Union[IssueType, None], Union[IssueTypeTypeForResponse, None]]: ...

    @overload
    async def async_update_issue_type(
        self,
        org: str,
        issue_type_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        is_enabled: bool,
        description: Missing[Union[str, None]] = UNSET,
        color: Missing[
            Union[
                None,
                Literal[
                    "gray", "blue", "green", "yellow", "orange", "red", "pink", "purple"
                ],
            ]
        ] = UNSET,
    ) -> Response[Union[IssueType, None], Union[IssueTypeTypeForResponse, None]]: ...

    async def async_update_issue_type(
        self,
        org: str,
        issue_type_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrganizationUpdateIssueTypeType] = UNSET,
        **kwargs,
    ) -> Response[Union[IssueType, None], Union[IssueTypeTypeForResponse, None]]:
        """orgs/update-issue-type

        PUT /orgs/{org}/issue-types/{issue_type_id}

        Updates an issue type for an organization.

        You can find out more about issue types in [Managing issue types in an organization](https://docs.github.com/issues/tracking-your-work-with-issues/configuring-issues/managing-issue-types-in-an-organization).

        To use this endpoint, the authenticated user must be an administrator for the organization. OAuth app tokens and
        personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/issue-types#update-issue-type-for-an-organization
        """

        from typing import Union

        from ..models import (
            BasicError,
            IssueType,
            OrganizationUpdateIssueType,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}/issue-types/{issue_type_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrganizationUpdateIssueType, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Union[IssueType, None],
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def delete_issue_type(
        self,
        org: str,
        issue_type_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/delete-issue-type

        DELETE /orgs/{org}/issue-types/{issue_type_id}

        Deletes an issue type for an organization.

        You can find out more about issue types in [Managing issue types in an organization](https://docs.github.com/issues/tracking-your-work-with-issues/configuring-issues/managing-issue-types-in-an-organization).

        To use this endpoint, the authenticated user must be an administrator for the organization. OAuth app tokens and
        personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/issue-types#delete-issue-type-for-an-organization
        """

        from ..models import BasicError, ValidationErrorSimple

        url = f"/orgs/{org}/issue-types/{issue_type_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    async def async_delete_issue_type(
        self,
        org: str,
        issue_type_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/delete-issue-type

        DELETE /orgs/{org}/issue-types/{issue_type_id}

        Deletes an issue type for an organization.

        You can find out more about issue types in [Managing issue types in an organization](https://docs.github.com/issues/tracking-your-work-with-issues/configuring-issues/managing-issue-types-in-an-organization).

        To use this endpoint, the authenticated user must be an administrator for the organization. OAuth app tokens and
        personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/issue-types#delete-issue-type-for-an-organization
        """

        from ..models import BasicError, ValidationErrorSimple

        url = f"/orgs/{org}/issue-types/{issue_type_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    def list_members(
        self,
        org: str,
        *,
        filter_: Missing[Literal["2fa_disabled", "2fa_insecure", "all"]] = UNSET,
        role: Missing[Literal["all", "admin", "member"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SimpleUser], list[SimpleUserTypeForResponse]]:
        """orgs/list-members

        GET /orgs/{org}/members

        List all users who are members of an organization. If the authenticated user is also a member of this organization then both concealed and public members will be returned.

        See also: https://docs.github.com/rest/orgs/members#list-organization-members
        """

        from ..models import SimpleUser, ValidationError

        url = f"/orgs/{org}/members"

        params = {
            "filter": filter_,
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_members(
        self,
        org: str,
        *,
        filter_: Missing[Literal["2fa_disabled", "2fa_insecure", "all"]] = UNSET,
        role: Missing[Literal["all", "admin", "member"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SimpleUser], list[SimpleUserTypeForResponse]]:
        """orgs/list-members

        GET /orgs/{org}/members

        List all users who are members of an organization. If the authenticated user is also a member of this organization then both concealed and public members will be returned.

        See also: https://docs.github.com/rest/orgs/members#list-organization-members
        """

        from ..models import SimpleUser, ValidationError

        url = f"/orgs/{org}/members"

        params = {
            "filter": filter_,
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    def check_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/check-membership-for-user

        GET /orgs/{org}/members/{username}

        Check if a user is, publicly or privately, a member of the organization.

        See also: https://docs.github.com/rest/orgs/members#check-organization-membership-for-a-user
        """

        url = f"/orgs/{org}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    async def async_check_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/check-membership-for-user

        GET /orgs/{org}/members/{username}

        Check if a user is, publicly or privately, a member of the organization.

        See also: https://docs.github.com/rest/orgs/members#check-organization-membership-for-a-user
        """

        url = f"/orgs/{org}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    def remove_member(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/remove-member

        DELETE /orgs/{org}/members/{username}

        Removing a user from this list will remove them from all teams and they will no longer have any access to the organization's repositories.

        > [!NOTE]
        > If a user has both direct membership in the organization as well as indirect membership via an enterprise team, only their direct membership will be removed. Their indirect membership via an enterprise team remains until the user is removed from the enterprise team.

        See also: https://docs.github.com/rest/orgs/members#remove-an-organization-member
        """

        from ..models import BasicError

        url = f"/orgs/{org}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
            },
        )

    async def async_remove_member(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/remove-member

        DELETE /orgs/{org}/members/{username}

        Removing a user from this list will remove them from all teams and they will no longer have any access to the organization's repositories.

        > [!NOTE]
        > If a user has both direct membership in the organization as well as indirect membership via an enterprise team, only their direct membership will be removed. Their indirect membership via an enterprise team remains until the user is removed from the enterprise team.

        See also: https://docs.github.com/rest/orgs/members#remove-an-organization-member
        """

        from ..models import BasicError

        url = f"/orgs/{org}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
            },
        )

    def get_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrgMembership, OrgMembershipTypeForResponse]:
        """orgs/get-membership-for-user

        GET /orgs/{org}/memberships/{username}

        In order to get a user's membership with an organization, the authenticated user must be an organization member. The `state` parameter in the response can be used to identify the user's membership status.

        See also: https://docs.github.com/rest/orgs/members#get-organization-membership-for-a-user
        """

        from ..models import BasicError, OrgMembership

        url = f"/orgs/{org}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgMembership,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_get_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrgMembership, OrgMembershipTypeForResponse]:
        """orgs/get-membership-for-user

        GET /orgs/{org}/memberships/{username}

        In order to get a user's membership with an organization, the authenticated user must be an organization member. The `state` parameter in the response can be used to identify the user's membership status.

        See also: https://docs.github.com/rest/orgs/members#get-organization-membership-for-a-user
        """

        from ..models import BasicError, OrgMembership

        url = f"/orgs/{org}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgMembership,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgMembershipsUsernamePutBodyType] = UNSET,
    ) -> Response[OrgMembership, OrgMembershipTypeForResponse]: ...

    @overload
    def set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        role: Missing[Literal["admin", "member"]] = UNSET,
    ) -> Response[OrgMembership, OrgMembershipTypeForResponse]: ...

    def set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgMembership, OrgMembershipTypeForResponse]:
        """orgs/set-membership-for-user

        PUT /orgs/{org}/memberships/{username}

        Only authenticated organization owners can add a member to the organization or update the member's role.

        *   If the authenticated user is _adding_ a member to the organization, the invited user will receive an email inviting them to the organization. The user's [membership status](https://docs.github.com/rest/orgs/members#get-organization-membership-for-a-user) will be `pending` until they accept the invitation.

        *   Authenticated users can _update_ a user's membership by passing the `role` parameter. If the authenticated user changes a member's role to `admin`, the affected user will receive an email notifying them that they've been made an organization owner. If the authenticated user changes an owner's role to `member`, no email will be sent.

        **Rate limits**

        To prevent abuse, organization owners are limited to creating 50 organization invitations for an organization within a 24 hour period. If the organization is more than one month old or on a paid plan, the limit is 500 invitations per 24 hour period.

        See also: https://docs.github.com/rest/orgs/members#set-organization-membership-for-a-user
        """

        from ..models import (
            BasicError,
            OrgMembership,
            OrgsOrgMembershipsUsernamePutBody,
            ValidationError,
        )

        url = f"/orgs/{org}/memberships/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgMembershipsUsernamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgMembership,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgMembershipsUsernamePutBodyType] = UNSET,
    ) -> Response[OrgMembership, OrgMembershipTypeForResponse]: ...

    @overload
    async def async_set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        role: Missing[Literal["admin", "member"]] = UNSET,
    ) -> Response[OrgMembership, OrgMembershipTypeForResponse]: ...

    async def async_set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgMembership, OrgMembershipTypeForResponse]:
        """orgs/set-membership-for-user

        PUT /orgs/{org}/memberships/{username}

        Only authenticated organization owners can add a member to the organization or update the member's role.

        *   If the authenticated user is _adding_ a member to the organization, the invited user will receive an email inviting them to the organization. The user's [membership status](https://docs.github.com/rest/orgs/members#get-organization-membership-for-a-user) will be `pending` until they accept the invitation.

        *   Authenticated users can _update_ a user's membership by passing the `role` parameter. If the authenticated user changes a member's role to `admin`, the affected user will receive an email notifying them that they've been made an organization owner. If the authenticated user changes an owner's role to `member`, no email will be sent.

        **Rate limits**

        To prevent abuse, organization owners are limited to creating 50 organization invitations for an organization within a 24 hour period. If the organization is more than one month old or on a paid plan, the limit is 500 invitations per 24 hour period.

        See also: https://docs.github.com/rest/orgs/members#set-organization-membership-for-a-user
        """

        from ..models import (
            BasicError,
            OrgMembership,
            OrgsOrgMembershipsUsernamePutBody,
            ValidationError,
        )

        url = f"/orgs/{org}/memberships/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgMembershipsUsernamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgMembership,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def remove_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/remove-membership-for-user

        DELETE /orgs/{org}/memberships/{username}

        In order to remove a user's membership with an organization, the authenticated user must be an organization owner.

        If the specified user is an active member of the organization, this will remove them from the organization. If the specified user has been invited to the organization, this will cancel their invitation. The specified user will receive an email notification in both cases.

        > [!NOTE]
        > If a user has both direct membership in the organization as well as indirect membership via an enterprise team, only their direct membership will be removed. Their indirect membership via an enterprise team remains until the user is removed from the enterprise team.

        See also: https://docs.github.com/rest/orgs/members#remove-organization-membership-for-a-user
        """

        from ..models import BasicError

        url = f"/orgs/{org}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_remove_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/remove-membership-for-user

        DELETE /orgs/{org}/memberships/{username}

        In order to remove a user's membership with an organization, the authenticated user must be an organization owner.

        If the specified user is an active member of the organization, this will remove them from the organization. If the specified user has been invited to the organization, this will cancel their invitation. The specified user will receive an email notification in both cases.

        > [!NOTE]
        > If a user has both direct membership in the organization as well as indirect membership via an enterprise team, only their direct membership will be removed. Their indirect membership via an enterprise team remains until the user is removed from the enterprise team.

        See also: https://docs.github.com/rest/orgs/members#remove-organization-membership-for-a-user
        """

        from ..models import BasicError

        url = f"/orgs/{org}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_org_roles(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgOrganizationRolesGetResponse200,
        OrgsOrgOrganizationRolesGetResponse200TypeForResponse,
    ]:
        """orgs/list-org-roles

        GET /orgs/{org}/organization-roles

        Lists the organization roles available in this organization. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."

        To use this endpoint, the authenticated user must be one of:

        - An administrator for the organization.
        - A user, or a user on a team, with the fine-grained permissions of `read_organization_custom_org_role` in the organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/organization-roles#get-all-organization-roles-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgOrganizationRolesGetResponse200,
            ValidationError,
        )

        url = f"/orgs/{org}/organization-roles"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgOrganizationRolesGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_org_roles(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgOrganizationRolesGetResponse200,
        OrgsOrgOrganizationRolesGetResponse200TypeForResponse,
    ]:
        """orgs/list-org-roles

        GET /orgs/{org}/organization-roles

        Lists the organization roles available in this organization. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."

        To use this endpoint, the authenticated user must be one of:

        - An administrator for the organization.
        - A user, or a user on a team, with the fine-grained permissions of `read_organization_custom_org_role` in the organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/organization-roles#get-all-organization-roles-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgOrganizationRolesGetResponse200,
            ValidationError,
        )

        url = f"/orgs/{org}/organization-roles"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgOrganizationRolesGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def revoke_all_org_roles_team(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/revoke-all-org-roles-team

        DELETE /orgs/{org}/organization-roles/teams/{team_slug}

        Removes all assigned organization roles from a team. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."

        The authenticated user must be an administrator for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/organization-roles#remove-all-organization-roles-for-a-team
        """

        url = f"/orgs/{org}/organization-roles/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_revoke_all_org_roles_team(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/revoke-all-org-roles-team

        DELETE /orgs/{org}/organization-roles/teams/{team_slug}

        Removes all assigned organization roles from a team. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."

        The authenticated user must be an administrator for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/organization-roles#remove-all-organization-roles-for-a-team
        """

        url = f"/orgs/{org}/organization-roles/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def assign_team_to_org_role(
        self,
        org: str,
        team_slug: str,
        role_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/assign-team-to-org-role

        PUT /orgs/{org}/organization-roles/teams/{team_slug}/{role_id}

        Assigns an organization role to a team in an organization. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."

        The authenticated user must be an administrator for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/organization-roles#assign-an-organization-role-to-a-team
        """

        url = f"/orgs/{org}/organization-roles/teams/{team_slug}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    async def async_assign_team_to_org_role(
        self,
        org: str,
        team_slug: str,
        role_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/assign-team-to-org-role

        PUT /orgs/{org}/organization-roles/teams/{team_slug}/{role_id}

        Assigns an organization role to a team in an organization. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."

        The authenticated user must be an administrator for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/organization-roles#assign-an-organization-role-to-a-team
        """

        url = f"/orgs/{org}/organization-roles/teams/{team_slug}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    def revoke_org_role_team(
        self,
        org: str,
        team_slug: str,
        role_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/revoke-org-role-team

        DELETE /orgs/{org}/organization-roles/teams/{team_slug}/{role_id}

        Removes an organization role from a team. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."

        The authenticated user must be an administrator for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/organization-roles#remove-an-organization-role-from-a-team
        """

        url = f"/orgs/{org}/organization-roles/teams/{team_slug}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_revoke_org_role_team(
        self,
        org: str,
        team_slug: str,
        role_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/revoke-org-role-team

        DELETE /orgs/{org}/organization-roles/teams/{team_slug}/{role_id}

        Removes an organization role from a team. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."

        The authenticated user must be an administrator for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/organization-roles#remove-an-organization-role-from-a-team
        """

        url = f"/orgs/{org}/organization-roles/teams/{team_slug}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def revoke_all_org_roles_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/revoke-all-org-roles-user

        DELETE /orgs/{org}/organization-roles/users/{username}

        Revokes all assigned organization roles from a user. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."

        The authenticated user must be an administrator for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/organization-roles#remove-all-organization-roles-for-a-user
        """

        url = f"/orgs/{org}/organization-roles/users/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_revoke_all_org_roles_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/revoke-all-org-roles-user

        DELETE /orgs/{org}/organization-roles/users/{username}

        Revokes all assigned organization roles from a user. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."

        The authenticated user must be an administrator for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/organization-roles#remove-all-organization-roles-for-a-user
        """

        url = f"/orgs/{org}/organization-roles/users/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def assign_user_to_org_role(
        self,
        org: str,
        username: str,
        role_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/assign-user-to-org-role

        PUT /orgs/{org}/organization-roles/users/{username}/{role_id}

        Assigns an organization role to a member of an organization. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."

        The authenticated user must be an administrator for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/organization-roles#assign-an-organization-role-to-a-user
        """

        url = f"/orgs/{org}/organization-roles/users/{username}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    async def async_assign_user_to_org_role(
        self,
        org: str,
        username: str,
        role_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/assign-user-to-org-role

        PUT /orgs/{org}/organization-roles/users/{username}/{role_id}

        Assigns an organization role to a member of an organization. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."

        The authenticated user must be an administrator for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/organization-roles#assign-an-organization-role-to-a-user
        """

        url = f"/orgs/{org}/organization-roles/users/{username}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    def revoke_org_role_user(
        self,
        org: str,
        username: str,
        role_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/revoke-org-role-user

        DELETE /orgs/{org}/organization-roles/users/{username}/{role_id}

        Remove an organization role from a user. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."

        The authenticated user must be an administrator for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/organization-roles#remove-an-organization-role-from-a-user
        """

        url = f"/orgs/{org}/organization-roles/users/{username}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_revoke_org_role_user(
        self,
        org: str,
        username: str,
        role_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/revoke-org-role-user

        DELETE /orgs/{org}/organization-roles/users/{username}/{role_id}

        Remove an organization role from a user. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."

        The authenticated user must be an administrator for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/organization-roles#remove-an-organization-role-from-a-user
        """

        url = f"/orgs/{org}/organization-roles/users/{username}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def get_org_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrganizationRole, OrganizationRoleTypeForResponse]:
        """orgs/get-org-role

        GET /orgs/{org}/organization-roles/{role_id}

        Gets an organization role that is available to this organization. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."

        To use this endpoint, the authenticated user must be one of:

        - An administrator for the organization.
        - A user, or a user on a team, with the fine-grained permissions of `read_organization_custom_org_role` in the organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/organization-roles#get-an-organization-role
        """

        from ..models import BasicError, OrganizationRole, ValidationError

        url = f"/orgs/{org}/organization-roles/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrganizationRole,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_org_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrganizationRole, OrganizationRoleTypeForResponse]:
        """orgs/get-org-role

        GET /orgs/{org}/organization-roles/{role_id}

        Gets an organization role that is available to this organization. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."

        To use this endpoint, the authenticated user must be one of:

        - An administrator for the organization.
        - A user, or a user on a team, with the fine-grained permissions of `read_organization_custom_org_role` in the organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/organization-roles#get-an-organization-role
        """

        from ..models import BasicError, OrganizationRole, ValidationError

        url = f"/orgs/{org}/organization-roles/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrganizationRole,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_org_role_teams(
        self,
        org: str,
        role_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[TeamRoleAssignment], list[TeamRoleAssignmentTypeForResponse]]:
        """orgs/list-org-role-teams

        GET /orgs/{org}/organization-roles/{role_id}/teams

        Lists the teams that are assigned to an organization role. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."

        To use this endpoint, you must be an administrator for the organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/organization-roles#list-teams-that-are-assigned-to-an-organization-role
        """

        from ..models import TeamRoleAssignment

        url = f"/orgs/{org}/organization-roles/{role_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[TeamRoleAssignment],
            error_models={},
        )

    async def async_list_org_role_teams(
        self,
        org: str,
        role_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[TeamRoleAssignment], list[TeamRoleAssignmentTypeForResponse]]:
        """orgs/list-org-role-teams

        GET /orgs/{org}/organization-roles/{role_id}/teams

        Lists the teams that are assigned to an organization role. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."

        To use this endpoint, you must be an administrator for the organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/organization-roles#list-teams-that-are-assigned-to-an-organization-role
        """

        from ..models import TeamRoleAssignment

        url = f"/orgs/{org}/organization-roles/{role_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[TeamRoleAssignment],
            error_models={},
        )

    def list_org_role_users(
        self,
        org: str,
        role_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[UserRoleAssignment], list[UserRoleAssignmentTypeForResponse]]:
        """orgs/list-org-role-users

        GET /orgs/{org}/organization-roles/{role_id}/users

        Lists organization members that are assigned to an organization role. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."

        To use this endpoint, you must be an administrator for the organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/organization-roles#list-users-that-are-assigned-to-an-organization-role
        """

        from ..models import UserRoleAssignment

        url = f"/orgs/{org}/organization-roles/{role_id}/users"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[UserRoleAssignment],
            error_models={},
        )

    async def async_list_org_role_users(
        self,
        org: str,
        role_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[UserRoleAssignment], list[UserRoleAssignmentTypeForResponse]]:
        """orgs/list-org-role-users

        GET /orgs/{org}/organization-roles/{role_id}/users

        Lists organization members that are assigned to an organization role. For more information on organization roles, see "[Using organization roles](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/using-organization-roles)."

        To use this endpoint, you must be an administrator for the organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/organization-roles#list-users-that-are-assigned-to-an-organization-role
        """

        from ..models import UserRoleAssignment

        url = f"/orgs/{org}/organization-roles/{role_id}/users"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[UserRoleAssignment],
            error_models={},
        )

    def list_outside_collaborators(
        self,
        org: str,
        *,
        filter_: Missing[Literal["2fa_disabled", "2fa_insecure", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SimpleUser], list[SimpleUserTypeForResponse]]:
        """orgs/list-outside-collaborators

        GET /orgs/{org}/outside_collaborators

        List all users who are outside collaborators of an organization.

        See also: https://docs.github.com/rest/orgs/outside-collaborators#list-outside-collaborators-for-an-organization
        """

        from ..models import SimpleUser

        url = f"/orgs/{org}/outside_collaborators"

        params = {
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
        )

    async def async_list_outside_collaborators(
        self,
        org: str,
        *,
        filter_: Missing[Literal["2fa_disabled", "2fa_insecure", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SimpleUser], list[SimpleUserTypeForResponse]]:
        """orgs/list-outside-collaborators

        GET /orgs/{org}/outside_collaborators

        List all users who are outside collaborators of an organization.

        See also: https://docs.github.com/rest/orgs/outside-collaborators#list-outside-collaborators-for-an-organization
        """

        from ..models import SimpleUser

        url = f"/orgs/{org}/outside_collaborators"

        params = {
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
        )

    @overload
    def convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgOutsideCollaboratorsUsernamePutBodyType] = UNSET,
    ) -> Response[
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202TypeForResponse,
    ]: ...

    @overload
    def convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        async_: Missing[bool] = UNSET,
    ) -> Response[
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202TypeForResponse,
    ]: ...

    def convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgOutsideCollaboratorsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202TypeForResponse,
    ]:
        """orgs/convert-member-to-outside-collaborator

        PUT /orgs/{org}/outside_collaborators/{username}

        When an organization member is converted to an outside collaborator, they'll only have access to the repositories that their current team membership allows. The user will no longer be a member of the organization. For more information, see "[Converting an organization member to an outside collaborator](https://docs.github.com/articles/converting-an-organization-member-to-an-outside-collaborator/)". Converting an organization member to an outside collaborator may be restricted by enterprise administrators. For more information, see "[Enforcing repository management policies in your enterprise](https://docs.github.com/admin/policies/enforcing-policies-for-your-enterprise/enforcing-repository-management-policies-in-your-enterprise#enforcing-a-policy-for-inviting-outside-collaborators-to-repositories)."

        See also: https://docs.github.com/rest/orgs/outside-collaborators#convert-an-organization-member-to-outside-collaborator
        """

        from ..models import (
            BasicError,
            OrgsOrgOutsideCollaboratorsUsernamePutBody,
            OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        )

        url = f"/orgs/{org}/outside_collaborators/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgOutsideCollaboratorsUsernamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgOutsideCollaboratorsUsernamePutBodyType] = UNSET,
    ) -> Response[
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202TypeForResponse,
    ]: ...

    @overload
    async def async_convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        async_: Missing[bool] = UNSET,
    ) -> Response[
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202TypeForResponse,
    ]: ...

    async def async_convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgOutsideCollaboratorsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202TypeForResponse,
    ]:
        """orgs/convert-member-to-outside-collaborator

        PUT /orgs/{org}/outside_collaborators/{username}

        When an organization member is converted to an outside collaborator, they'll only have access to the repositories that their current team membership allows. The user will no longer be a member of the organization. For more information, see "[Converting an organization member to an outside collaborator](https://docs.github.com/articles/converting-an-organization-member-to-an-outside-collaborator/)". Converting an organization member to an outside collaborator may be restricted by enterprise administrators. For more information, see "[Enforcing repository management policies in your enterprise](https://docs.github.com/admin/policies/enforcing-policies-for-your-enterprise/enforcing-repository-management-policies-in-your-enterprise#enforcing-a-policy-for-inviting-outside-collaborators-to-repositories)."

        See also: https://docs.github.com/rest/orgs/outside-collaborators#convert-an-organization-member-to-outside-collaborator
        """

        from ..models import (
            BasicError,
            OrgsOrgOutsideCollaboratorsUsernamePutBody,
            OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        )

        url = f"/orgs/{org}/outside_collaborators/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgOutsideCollaboratorsUsernamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
            error_models={
                "404": BasicError,
            },
        )

    def remove_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/remove-outside-collaborator

        DELETE /orgs/{org}/outside_collaborators/{username}

        Removing a user from this list will remove them from all the organization's repositories.

        See also: https://docs.github.com/rest/orgs/outside-collaborators#remove-outside-collaborator-from-an-organization
        """

        from ..models import OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422

        url = f"/orgs/{org}/outside_collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422,
            },
        )

    async def async_remove_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/remove-outside-collaborator

        DELETE /orgs/{org}/outside_collaborators/{username}

        Removing a user from this list will remove them from all the organization's repositories.

        See also: https://docs.github.com/rest/orgs/outside-collaborators#remove-outside-collaborator-from-an-organization
        """

        from ..models import OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422

        url = f"/orgs/{org}/outside_collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422,
            },
        )

    def list_pat_grant_requests(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        sort: Missing[Literal["created_at"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        owner: Missing[list[str]] = UNSET,
        repository: Missing[str] = UNSET,
        permission: Missing[str] = UNSET,
        last_used_before: Missing[datetime] = UNSET,
        last_used_after: Missing[datetime] = UNSET,
        token_id: Missing[list[str]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[OrganizationProgrammaticAccessGrantRequest],
        list[OrganizationProgrammaticAccessGrantRequestTypeForResponse],
    ]:
        """orgs/list-pat-grant-requests

        GET /orgs/{org}/personal-access-token-requests

        Lists requests from organization members to access organization resources with a fine-grained personal access token.

        Only GitHub Apps can use this endpoint.

        See also: https://docs.github.com/rest/orgs/personal-access-tokens#list-requests-to-access-organization-resources-with-fine-grained-personal-access-tokens
        """

        from ..models import (
            BasicError,
            OrganizationProgrammaticAccessGrantRequest,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-token-requests"

        params = {
            "per_page": per_page,
            "page": page,
            "sort": sort,
            "direction": direction,
            "owner": owner,
            "repository": repository,
            "permission": permission,
            "last_used_before": last_used_before,
            "last_used_after": last_used_after,
            "token_id": token_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrganizationProgrammaticAccessGrantRequest],
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_pat_grant_requests(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        sort: Missing[Literal["created_at"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        owner: Missing[list[str]] = UNSET,
        repository: Missing[str] = UNSET,
        permission: Missing[str] = UNSET,
        last_used_before: Missing[datetime] = UNSET,
        last_used_after: Missing[datetime] = UNSET,
        token_id: Missing[list[str]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[OrganizationProgrammaticAccessGrantRequest],
        list[OrganizationProgrammaticAccessGrantRequestTypeForResponse],
    ]:
        """orgs/list-pat-grant-requests

        GET /orgs/{org}/personal-access-token-requests

        Lists requests from organization members to access organization resources with a fine-grained personal access token.

        Only GitHub Apps can use this endpoint.

        See also: https://docs.github.com/rest/orgs/personal-access-tokens#list-requests-to-access-organization-resources-with-fine-grained-personal-access-tokens
        """

        from ..models import (
            BasicError,
            OrganizationProgrammaticAccessGrantRequest,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-token-requests"

        params = {
            "per_page": per_page,
            "page": page,
            "sort": sort,
            "direction": direction,
            "owner": owner,
            "repository": repository,
            "permission": permission,
            "last_used_before": last_used_before,
            "last_used_after": last_used_after,
            "token_id": token_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrganizationProgrammaticAccessGrantRequest],
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgPersonalAccessTokenRequestsPostBodyType,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
    ]: ...

    @overload
    def review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        pat_request_ids: Missing[list[int]] = UNSET,
        action: Literal["approve", "deny"],
        reason: Missing[Union[str, None]] = UNSET,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
    ]: ...

    def review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgPersonalAccessTokenRequestsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
    ]:
        """orgs/review-pat-grant-requests-in-bulk

        POST /orgs/{org}/personal-access-token-requests

        Approves or denies multiple pending requests to access organization resources via a fine-grained personal access token.

        Only GitHub Apps can use this endpoint.

        See also: https://docs.github.com/rest/orgs/personal-access-tokens#review-requests-to-access-organization-resources-with-fine-grained-personal-access-tokens
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            OrgsOrgPersonalAccessTokenRequestsPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-token-requests"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgPersonalAccessTokenRequestsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    async def async_review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgPersonalAccessTokenRequestsPostBodyType,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
    ]: ...

    @overload
    async def async_review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        pat_request_ids: Missing[list[int]] = UNSET,
        action: Literal["approve", "deny"],
        reason: Missing[Union[str, None]] = UNSET,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
    ]: ...

    async def async_review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgPersonalAccessTokenRequestsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
    ]:
        """orgs/review-pat-grant-requests-in-bulk

        POST /orgs/{org}/personal-access-token-requests

        Approves or denies multiple pending requests to access organization resources via a fine-grained personal access token.

        Only GitHub Apps can use this endpoint.

        See also: https://docs.github.com/rest/orgs/personal-access-tokens#review-requests-to-access-organization-resources-with-fine-grained-personal-access-tokens
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            OrgsOrgPersonalAccessTokenRequestsPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-token-requests"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgPersonalAccessTokenRequestsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBodyType,
    ) -> Response: ...

    @overload
    def review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        action: Literal["approve", "deny"],
        reason: Missing[Union[str, None]] = UNSET,
    ) -> Response: ...

    def review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """orgs/review-pat-grant-request

        POST /orgs/{org}/personal-access-token-requests/{pat_request_id}

        Approves or denies a pending request to access organization resources via a fine-grained personal access token.

        Only GitHub Apps can use this endpoint.

        See also: https://docs.github.com/rest/orgs/personal-access-tokens#review-a-request-to-access-organization-resources-with-a-fine-grained-personal-access-token
        """

        from ..models import (
            BasicError,
            OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-token-requests/{pat_request_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    async def async_review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBodyType,
    ) -> Response: ...

    @overload
    async def async_review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        action: Literal["approve", "deny"],
        reason: Missing[Union[str, None]] = UNSET,
    ) -> Response: ...

    async def async_review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """orgs/review-pat-grant-request

        POST /orgs/{org}/personal-access-token-requests/{pat_request_id}

        Approves or denies a pending request to access organization resources via a fine-grained personal access token.

        Only GitHub Apps can use this endpoint.

        See also: https://docs.github.com/rest/orgs/personal-access-tokens#review-a-request-to-access-organization-resources-with-a-fine-grained-personal-access-token
        """

        from ..models import (
            BasicError,
            OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-token-requests/{pat_request_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_pat_grant_request_repositories(
        self,
        org: str,
        pat_request_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryTypeForResponse]]:
        """orgs/list-pat-grant-request-repositories

        GET /orgs/{org}/personal-access-token-requests/{pat_request_id}/repositories

        Lists the repositories a fine-grained personal access token request is requesting access to.

        Only GitHub Apps can use this endpoint.

        See also: https://docs.github.com/rest/orgs/personal-access-tokens#list-repositories-requested-to-be-accessed-by-a-fine-grained-personal-access-token
        """

        from ..models import BasicError, MinimalRepository

        url = (
            f"/orgs/{org}/personal-access-token-requests/{pat_request_id}/repositories"
        )

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[MinimalRepository],
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_pat_grant_request_repositories(
        self,
        org: str,
        pat_request_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryTypeForResponse]]:
        """orgs/list-pat-grant-request-repositories

        GET /orgs/{org}/personal-access-token-requests/{pat_request_id}/repositories

        Lists the repositories a fine-grained personal access token request is requesting access to.

        Only GitHub Apps can use this endpoint.

        See also: https://docs.github.com/rest/orgs/personal-access-tokens#list-repositories-requested-to-be-accessed-by-a-fine-grained-personal-access-token
        """

        from ..models import BasicError, MinimalRepository

        url = (
            f"/orgs/{org}/personal-access-token-requests/{pat_request_id}/repositories"
        )

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[MinimalRepository],
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_pat_grants(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        sort: Missing[Literal["created_at"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        owner: Missing[list[str]] = UNSET,
        repository: Missing[str] = UNSET,
        permission: Missing[str] = UNSET,
        last_used_before: Missing[datetime] = UNSET,
        last_used_after: Missing[datetime] = UNSET,
        token_id: Missing[list[str]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[OrganizationProgrammaticAccessGrant],
        list[OrganizationProgrammaticAccessGrantTypeForResponse],
    ]:
        """orgs/list-pat-grants

        GET /orgs/{org}/personal-access-tokens

        Lists approved fine-grained personal access tokens owned by organization members that can access organization resources.

        Only GitHub Apps can use this endpoint.

        See also: https://docs.github.com/rest/orgs/personal-access-tokens#list-fine-grained-personal-access-tokens-with-access-to-organization-resources
        """

        from ..models import (
            BasicError,
            OrganizationProgrammaticAccessGrant,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-tokens"

        params = {
            "per_page": per_page,
            "page": page,
            "sort": sort,
            "direction": direction,
            "owner": owner,
            "repository": repository,
            "permission": permission,
            "last_used_before": last_used_before,
            "last_used_after": last_used_after,
            "token_id": token_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrganizationProgrammaticAccessGrant],
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_pat_grants(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        sort: Missing[Literal["created_at"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        owner: Missing[list[str]] = UNSET,
        repository: Missing[str] = UNSET,
        permission: Missing[str] = UNSET,
        last_used_before: Missing[datetime] = UNSET,
        last_used_after: Missing[datetime] = UNSET,
        token_id: Missing[list[str]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[OrganizationProgrammaticAccessGrant],
        list[OrganizationProgrammaticAccessGrantTypeForResponse],
    ]:
        """orgs/list-pat-grants

        GET /orgs/{org}/personal-access-tokens

        Lists approved fine-grained personal access tokens owned by organization members that can access organization resources.

        Only GitHub Apps can use this endpoint.

        See also: https://docs.github.com/rest/orgs/personal-access-tokens#list-fine-grained-personal-access-tokens-with-access-to-organization-resources
        """

        from ..models import (
            BasicError,
            OrganizationProgrammaticAccessGrant,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-tokens"

        params = {
            "per_page": per_page,
            "page": page,
            "sort": sort,
            "direction": direction,
            "owner": owner,
            "repository": repository,
            "permission": permission,
            "last_used_before": last_used_before,
            "last_used_after": last_used_after,
            "token_id": token_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrganizationProgrammaticAccessGrant],
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def update_pat_accesses(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgPersonalAccessTokensPostBodyType,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
    ]: ...

    @overload
    def update_pat_accesses(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        action: Literal["revoke"],
        pat_ids: list[int],
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
    ]: ...

    def update_pat_accesses(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgPersonalAccessTokensPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
    ]:
        """orgs/update-pat-accesses

        POST /orgs/{org}/personal-access-tokens

        Updates the access organization members have to organization resources via fine-grained personal access tokens. Limited to revoking a token's existing access.

        Only GitHub Apps can use this endpoint.

        See also: https://docs.github.com/rest/orgs/personal-access-tokens#update-the-access-to-organization-resources-via-fine-grained-personal-access-tokens
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            OrgsOrgPersonalAccessTokensPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-tokens"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPersonalAccessTokensPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_pat_accesses(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgPersonalAccessTokensPostBodyType,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
    ]: ...

    @overload
    async def async_update_pat_accesses(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        action: Literal["revoke"],
        pat_ids: list[int],
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
    ]: ...

    async def async_update_pat_accesses(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgPersonalAccessTokensPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
    ]:
        """orgs/update-pat-accesses

        POST /orgs/{org}/personal-access-tokens

        Updates the access organization members have to organization resources via fine-grained personal access tokens. Limited to revoking a token's existing access.

        Only GitHub Apps can use this endpoint.

        See also: https://docs.github.com/rest/orgs/personal-access-tokens#update-the-access-to-organization-resources-via-fine-grained-personal-access-tokens
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            OrgsOrgPersonalAccessTokensPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-tokens"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPersonalAccessTokensPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    def update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgPersonalAccessTokensPatIdPostBodyType,
    ) -> Response: ...

    @overload
    def update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        action: Literal["revoke"],
    ) -> Response: ...

    def update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgPersonalAccessTokensPatIdPostBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """orgs/update-pat-access

        POST /orgs/{org}/personal-access-tokens/{pat_id}

        Updates the access an organization member has to organization resources via a fine-grained personal access token. Limited to revoking the token's existing access. Limited to revoking a token's existing access.

        Only GitHub Apps can use this endpoint.

        See also: https://docs.github.com/rest/orgs/personal-access-tokens#update-the-access-a-fine-grained-personal-access-token-has-to-organization-resources
        """

        from ..models import (
            BasicError,
            OrgsOrgPersonalAccessTokensPatIdPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-tokens/{pat_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPersonalAccessTokensPatIdPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgPersonalAccessTokensPatIdPostBodyType,
    ) -> Response: ...

    @overload
    async def async_update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        action: Literal["revoke"],
    ) -> Response: ...

    async def async_update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgPersonalAccessTokensPatIdPostBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """orgs/update-pat-access

        POST /orgs/{org}/personal-access-tokens/{pat_id}

        Updates the access an organization member has to organization resources via a fine-grained personal access token. Limited to revoking the token's existing access. Limited to revoking a token's existing access.

        Only GitHub Apps can use this endpoint.

        See also: https://docs.github.com/rest/orgs/personal-access-tokens#update-the-access-a-fine-grained-personal-access-token-has-to-organization-resources
        """

        from ..models import (
            BasicError,
            OrgsOrgPersonalAccessTokensPatIdPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-tokens/{pat_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPersonalAccessTokensPatIdPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_pat_grant_repositories(
        self,
        org: str,
        pat_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryTypeForResponse]]:
        """orgs/list-pat-grant-repositories

        GET /orgs/{org}/personal-access-tokens/{pat_id}/repositories

        Lists the repositories a fine-grained personal access token has access to.

        Only GitHub Apps can use this endpoint.

        See also: https://docs.github.com/rest/orgs/personal-access-tokens#list-repositories-a-fine-grained-personal-access-token-has-access-to
        """

        from ..models import BasicError, MinimalRepository

        url = f"/orgs/{org}/personal-access-tokens/{pat_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[MinimalRepository],
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_pat_grant_repositories(
        self,
        org: str,
        pat_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryTypeForResponse]]:
        """orgs/list-pat-grant-repositories

        GET /orgs/{org}/personal-access-tokens/{pat_id}/repositories

        Lists the repositories a fine-grained personal access token has access to.

        Only GitHub Apps can use this endpoint.

        See also: https://docs.github.com/rest/orgs/personal-access-tokens#list-repositories-a-fine-grained-personal-access-token-has-access-to
        """

        from ..models import BasicError, MinimalRepository

        url = f"/orgs/{org}/personal-access-tokens/{pat_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[MinimalRepository],
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def custom_properties_for_repos_get_organization_definitions(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CustomProperty], list[CustomPropertyTypeForResponse]]:
        """orgs/custom-properties-for-repos-get-organization-definitions

        GET /orgs/{org}/properties/schema

        Gets all custom properties defined for an organization.
        Organization members can read these properties.

        See also: https://docs.github.com/rest/orgs/custom-properties#get-all-custom-properties-for-an-organization
        """

        from ..models import BasicError, CustomProperty

        url = f"/orgs/{org}/properties/schema"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CustomProperty],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_custom_properties_for_repos_get_organization_definitions(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CustomProperty], list[CustomPropertyTypeForResponse]]:
        """orgs/custom-properties-for-repos-get-organization-definitions

        GET /orgs/{org}/properties/schema

        Gets all custom properties defined for an organization.
        Organization members can read these properties.

        See also: https://docs.github.com/rest/orgs/custom-properties#get-all-custom-properties-for-an-organization
        """

        from ..models import BasicError, CustomProperty

        url = f"/orgs/{org}/properties/schema"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CustomProperty],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def custom_properties_for_repos_create_or_update_organization_definitions(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgPropertiesSchemaPatchBodyType,
    ) -> Response[list[CustomProperty], list[CustomPropertyTypeForResponse]]: ...

    @overload
    def custom_properties_for_repos_create_or_update_organization_definitions(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        properties: list[CustomPropertyType],
    ) -> Response[list[CustomProperty], list[CustomPropertyTypeForResponse]]: ...

    def custom_properties_for_repos_create_or_update_organization_definitions(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgPropertiesSchemaPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[list[CustomProperty], list[CustomPropertyTypeForResponse]]:
        """orgs/custom-properties-for-repos-create-or-update-organization-definitions

        PATCH /orgs/{org}/properties/schema

        Creates new or updates existing custom properties defined for an organization in a batch.

        If the property already exists, the existing property will be replaced with the new values.
        Missing optional values will fall back to default values, previous values will be overwritten.
        E.g. if a property exists with `values_editable_by: org_and_repo_actors` and it's updated without specifying `values_editable_by`, it will be updated to default value `org_actors`.

        To use this endpoint, the authenticated user must be one of:
          - An administrator for the organization.
          - A user, or a user on a team, with the fine-grained permission of `custom_properties_org_definitions_manager` in the organization.

        See also: https://docs.github.com/rest/orgs/custom-properties#create-or-update-custom-properties-for-an-organization
        """

        from ..models import (
            BasicError,
            CustomProperty,
            OrgsOrgPropertiesSchemaPatchBody,
        )

        url = f"/orgs/{org}/properties/schema"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPropertiesSchemaPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CustomProperty],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_custom_properties_for_repos_create_or_update_organization_definitions(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgPropertiesSchemaPatchBodyType,
    ) -> Response[list[CustomProperty], list[CustomPropertyTypeForResponse]]: ...

    @overload
    async def async_custom_properties_for_repos_create_or_update_organization_definitions(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        properties: list[CustomPropertyType],
    ) -> Response[list[CustomProperty], list[CustomPropertyTypeForResponse]]: ...

    async def async_custom_properties_for_repos_create_or_update_organization_definitions(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgPropertiesSchemaPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[list[CustomProperty], list[CustomPropertyTypeForResponse]]:
        """orgs/custom-properties-for-repos-create-or-update-organization-definitions

        PATCH /orgs/{org}/properties/schema

        Creates new or updates existing custom properties defined for an organization in a batch.

        If the property already exists, the existing property will be replaced with the new values.
        Missing optional values will fall back to default values, previous values will be overwritten.
        E.g. if a property exists with `values_editable_by: org_and_repo_actors` and it's updated without specifying `values_editable_by`, it will be updated to default value `org_actors`.

        To use this endpoint, the authenticated user must be one of:
          - An administrator for the organization.
          - A user, or a user on a team, with the fine-grained permission of `custom_properties_org_definitions_manager` in the organization.

        See also: https://docs.github.com/rest/orgs/custom-properties#create-or-update-custom-properties-for-an-organization
        """

        from ..models import (
            BasicError,
            CustomProperty,
            OrgsOrgPropertiesSchemaPatchBody,
        )

        url = f"/orgs/{org}/properties/schema"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPropertiesSchemaPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CustomProperty],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def custom_properties_for_repos_get_organization_definition(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CustomProperty, CustomPropertyTypeForResponse]:
        """orgs/custom-properties-for-repos-get-organization-definition

        GET /orgs/{org}/properties/schema/{custom_property_name}

        Gets a custom property that is defined for an organization.
        Organization members can read these properties.

        See also: https://docs.github.com/rest/orgs/custom-properties#get-a-custom-property-for-an-organization
        """

        from ..models import BasicError, CustomProperty

        url = f"/orgs/{org}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_custom_properties_for_repos_get_organization_definition(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CustomProperty, CustomPropertyTypeForResponse]:
        """orgs/custom-properties-for-repos-get-organization-definition

        GET /orgs/{org}/properties/schema/{custom_property_name}

        Gets a custom property that is defined for an organization.
        Organization members can read these properties.

        See also: https://docs.github.com/rest/orgs/custom-properties#get-a-custom-property-for-an-organization
        """

        from ..models import BasicError, CustomProperty

        url = f"/orgs/{org}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def custom_properties_for_repos_create_or_update_organization_definition(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: CustomPropertySetPayloadType,
    ) -> Response[CustomProperty, CustomPropertyTypeForResponse]: ...

    @overload
    def custom_properties_for_repos_create_or_update_organization_definition(
        self,
        org: str,
        custom_property_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        value_type: Literal["string", "single_select", "multi_select", "true_false"],
        required: Missing[bool] = UNSET,
        default_value: Missing[Union[str, list[str], None]] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        allowed_values: Missing[Union[list[str], None]] = UNSET,
        values_editable_by: Missing[
            Union[None, Literal["org_actors", "org_and_repo_actors"]]
        ] = UNSET,
    ) -> Response[CustomProperty, CustomPropertyTypeForResponse]: ...

    def custom_properties_for_repos_create_or_update_organization_definition(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[CustomPropertySetPayloadType] = UNSET,
        **kwargs,
    ) -> Response[CustomProperty, CustomPropertyTypeForResponse]:
        """orgs/custom-properties-for-repos-create-or-update-organization-definition

        PUT /orgs/{org}/properties/schema/{custom_property_name}

        Creates a new or updates an existing custom property that is defined for an organization.

        To use this endpoint, the authenticated user must be one of:
        - An administrator for the organization.
        - A user, or a user on a team, with the fine-grained permission of `custom_properties_org_definitions_manager` in the organization.

        See also: https://docs.github.com/rest/orgs/custom-properties#create-or-update-a-custom-property-for-an-organization
        """

        from ..models import BasicError, CustomProperty, CustomPropertySetPayload

        url = f"/orgs/{org}/properties/schema/{custom_property_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(CustomPropertySetPayload, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_custom_properties_for_repos_create_or_update_organization_definition(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: CustomPropertySetPayloadType,
    ) -> Response[CustomProperty, CustomPropertyTypeForResponse]: ...

    @overload
    async def async_custom_properties_for_repos_create_or_update_organization_definition(
        self,
        org: str,
        custom_property_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        value_type: Literal["string", "single_select", "multi_select", "true_false"],
        required: Missing[bool] = UNSET,
        default_value: Missing[Union[str, list[str], None]] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        allowed_values: Missing[Union[list[str], None]] = UNSET,
        values_editable_by: Missing[
            Union[None, Literal["org_actors", "org_and_repo_actors"]]
        ] = UNSET,
    ) -> Response[CustomProperty, CustomPropertyTypeForResponse]: ...

    async def async_custom_properties_for_repos_create_or_update_organization_definition(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[CustomPropertySetPayloadType] = UNSET,
        **kwargs,
    ) -> Response[CustomProperty, CustomPropertyTypeForResponse]:
        """orgs/custom-properties-for-repos-create-or-update-organization-definition

        PUT /orgs/{org}/properties/schema/{custom_property_name}

        Creates a new or updates an existing custom property that is defined for an organization.

        To use this endpoint, the authenticated user must be one of:
        - An administrator for the organization.
        - A user, or a user on a team, with the fine-grained permission of `custom_properties_org_definitions_manager` in the organization.

        See also: https://docs.github.com/rest/orgs/custom-properties#create-or-update-a-custom-property-for-an-organization
        """

        from ..models import BasicError, CustomProperty, CustomPropertySetPayload

        url = f"/orgs/{org}/properties/schema/{custom_property_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(CustomPropertySetPayload, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def custom_properties_for_repos_delete_organization_definition(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/custom-properties-for-repos-delete-organization-definition

        DELETE /orgs/{org}/properties/schema/{custom_property_name}

        Removes a custom property that is defined for an organization.

        To use this endpoint, the authenticated user must be one of:
          - An administrator for the organization.
          - A user, or a user on a team, with the fine-grained permission of `custom_properties_org_definitions_manager` in the organization.

        See also: https://docs.github.com/rest/orgs/custom-properties#remove-a-custom-property-for-an-organization
        """

        from ..models import BasicError

        url = f"/orgs/{org}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_custom_properties_for_repos_delete_organization_definition(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/custom-properties-for-repos-delete-organization-definition

        DELETE /orgs/{org}/properties/schema/{custom_property_name}

        Removes a custom property that is defined for an organization.

        To use this endpoint, the authenticated user must be one of:
          - An administrator for the organization.
          - A user, or a user on a team, with the fine-grained permission of `custom_properties_org_definitions_manager` in the organization.

        See also: https://docs.github.com/rest/orgs/custom-properties#remove-a-custom-property-for-an-organization
        """

        from ..models import BasicError

        url = f"/orgs/{org}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def custom_properties_for_repos_get_organization_values(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        repository_query: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[OrgRepoCustomPropertyValues],
        list[OrgRepoCustomPropertyValuesTypeForResponse],
    ]:
        """orgs/custom-properties-for-repos-get-organization-values

        GET /orgs/{org}/properties/values

        Lists organization repositories with all of their custom property values.
        Organization members can read these properties.

        See also: https://docs.github.com/rest/orgs/custom-properties#list-custom-property-values-for-organization-repositories
        """

        from ..models import BasicError, OrgRepoCustomPropertyValues

        url = f"/orgs/{org}/properties/values"

        params = {
            "per_page": per_page,
            "page": page,
            "repository_query": repository_query,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrgRepoCustomPropertyValues],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_custom_properties_for_repos_get_organization_values(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        repository_query: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[OrgRepoCustomPropertyValues],
        list[OrgRepoCustomPropertyValuesTypeForResponse],
    ]:
        """orgs/custom-properties-for-repos-get-organization-values

        GET /orgs/{org}/properties/values

        Lists organization repositories with all of their custom property values.
        Organization members can read these properties.

        See also: https://docs.github.com/rest/orgs/custom-properties#list-custom-property-values-for-organization-repositories
        """

        from ..models import BasicError, OrgRepoCustomPropertyValues

        url = f"/orgs/{org}/properties/values"

        params = {
            "per_page": per_page,
            "page": page,
            "repository_query": repository_query,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrgRepoCustomPropertyValues],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def custom_properties_for_repos_create_or_update_organization_values(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgPropertiesValuesPatchBodyType,
    ) -> Response: ...

    @overload
    def custom_properties_for_repos_create_or_update_organization_values(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        repository_names: list[str],
        properties: list[CustomPropertyValueType],
    ) -> Response: ...

    def custom_properties_for_repos_create_or_update_organization_values(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgPropertiesValuesPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """orgs/custom-properties-for-repos-create-or-update-organization-values

        PATCH /orgs/{org}/properties/values

        Create new or update existing custom property values for repositories in a batch that belong to an organization.
        Each target repository will have its custom property values updated to match the values provided in the request.

        A maximum of 30 repositories can be updated in a single request.

        Using a value of `null` for a custom property will remove or 'unset' the property value from the repository.

        To use this endpoint, the authenticated user must be one of:
          - An administrator for the organization.
          - A user, or a user on a team, with the fine-grained permission of `custom_properties_org_values_editor` in the organization.

        See also: https://docs.github.com/rest/orgs/custom-properties#create-or-update-custom-property-values-for-organization-repositories
        """

        from ..models import (
            BasicError,
            OrgsOrgPropertiesValuesPatchBody,
            ValidationError,
        )

        url = f"/orgs/{org}/properties/values"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPropertiesValuesPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_custom_properties_for_repos_create_or_update_organization_values(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgPropertiesValuesPatchBodyType,
    ) -> Response: ...

    @overload
    async def async_custom_properties_for_repos_create_or_update_organization_values(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        repository_names: list[str],
        properties: list[CustomPropertyValueType],
    ) -> Response: ...

    async def async_custom_properties_for_repos_create_or_update_organization_values(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgPropertiesValuesPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """orgs/custom-properties-for-repos-create-or-update-organization-values

        PATCH /orgs/{org}/properties/values

        Create new or update existing custom property values for repositories in a batch that belong to an organization.
        Each target repository will have its custom property values updated to match the values provided in the request.

        A maximum of 30 repositories can be updated in a single request.

        Using a value of `null` for a custom property will remove or 'unset' the property value from the repository.

        To use this endpoint, the authenticated user must be one of:
          - An administrator for the organization.
          - A user, or a user on a team, with the fine-grained permission of `custom_properties_org_values_editor` in the organization.

        See also: https://docs.github.com/rest/orgs/custom-properties#create-or-update-custom-property-values-for-organization-repositories
        """

        from ..models import (
            BasicError,
            OrgsOrgPropertiesValuesPatchBody,
            ValidationError,
        )

        url = f"/orgs/{org}/properties/values"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPropertiesValuesPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_public_members(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SimpleUser], list[SimpleUserTypeForResponse]]:
        """orgs/list-public-members

        GET /orgs/{org}/public_members

        Members of an organization can choose to have their membership publicized or not.

        See also: https://docs.github.com/rest/orgs/members#list-public-organization-members
        """

        from ..models import SimpleUser

        url = f"/orgs/{org}/public_members"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
        )

    async def async_list_public_members(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SimpleUser], list[SimpleUserTypeForResponse]]:
        """orgs/list-public-members

        GET /orgs/{org}/public_members

        Members of an organization can choose to have their membership publicized or not.

        See also: https://docs.github.com/rest/orgs/members#list-public-organization-members
        """

        from ..models import SimpleUser

        url = f"/orgs/{org}/public_members"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
        )

    def check_public_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/check-public-membership-for-user

        GET /orgs/{org}/public_members/{username}

        Check if the provided user is a public member of the organization.

        See also: https://docs.github.com/rest/orgs/members#check-public-organization-membership-for-a-user
        """

        url = f"/orgs/{org}/public_members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    async def async_check_public_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/check-public-membership-for-user

        GET /orgs/{org}/public_members/{username}

        Check if the provided user is a public member of the organization.

        See also: https://docs.github.com/rest/orgs/members#check-public-organization-membership-for-a-user
        """

        url = f"/orgs/{org}/public_members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    def set_public_membership_for_authenticated_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/set-public-membership-for-authenticated-user

        PUT /orgs/{org}/public_members/{username}

        The user can publicize their own membership. (A user cannot publicize the membership for another user.)

        Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."

        See also: https://docs.github.com/rest/orgs/members#set-public-organization-membership-for-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/orgs/{org}/public_members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
            },
        )

    async def async_set_public_membership_for_authenticated_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/set-public-membership-for-authenticated-user

        PUT /orgs/{org}/public_members/{username}

        The user can publicize their own membership. (A user cannot publicize the membership for another user.)

        Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."

        See also: https://docs.github.com/rest/orgs/members#set-public-organization-membership-for-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/orgs/{org}/public_members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
            },
        )

    def remove_public_membership_for_authenticated_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/remove-public-membership-for-authenticated-user

        DELETE /orgs/{org}/public_members/{username}

        Removes the public membership for the authenticated user from the specified organization, unless public visibility is enforced by default.

        See also: https://docs.github.com/rest/orgs/members#remove-public-organization-membership-for-the-authenticated-user
        """

        url = f"/orgs/{org}/public_members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_remove_public_membership_for_authenticated_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/remove-public-membership-for-authenticated-user

        DELETE /orgs/{org}/public_members/{username}

        Removes the public membership for the authenticated user from the specified organization, unless public visibility is enforced by default.

        See also: https://docs.github.com/rest/orgs/members#remove-public-organization-membership-for-the-authenticated-user
        """

        url = f"/orgs/{org}/public_members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def get_org_ruleset_history(
        self,
        org: str,
        ruleset_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RulesetVersion], list[RulesetVersionTypeForResponse]]:
        """orgs/get-org-ruleset-history

        GET /orgs/{org}/rulesets/{ruleset_id}/history

        Get the history of an organization ruleset.

        See also: https://docs.github.com/rest/orgs/rules#get-organization-ruleset-history
        """

        from ..models import BasicError, RulesetVersion

        url = f"/orgs/{org}/rulesets/{ruleset_id}/history"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RulesetVersion],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_org_ruleset_history(
        self,
        org: str,
        ruleset_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RulesetVersion], list[RulesetVersionTypeForResponse]]:
        """orgs/get-org-ruleset-history

        GET /orgs/{org}/rulesets/{ruleset_id}/history

        Get the history of an organization ruleset.

        See also: https://docs.github.com/rest/orgs/rules#get-organization-ruleset-history
        """

        from ..models import BasicError, RulesetVersion

        url = f"/orgs/{org}/rulesets/{ruleset_id}/history"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RulesetVersion],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_org_ruleset_version(
        self,
        org: str,
        ruleset_id: int,
        version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RulesetVersionWithState, RulesetVersionWithStateTypeForResponse]:
        """orgs/get-org-ruleset-version

        GET /orgs/{org}/rulesets/{ruleset_id}/history/{version_id}

        Get a version of an organization ruleset.

        See also: https://docs.github.com/rest/orgs/rules#get-organization-ruleset-version
        """

        from ..models import BasicError, RulesetVersionWithState

        url = f"/orgs/{org}/rulesets/{ruleset_id}/history/{version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RulesetVersionWithState,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_org_ruleset_version(
        self,
        org: str,
        ruleset_id: int,
        version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RulesetVersionWithState, RulesetVersionWithStateTypeForResponse]:
        """orgs/get-org-ruleset-version

        GET /orgs/{org}/rulesets/{ruleset_id}/history/{version_id}

        Get a version of an organization ruleset.

        See also: https://docs.github.com/rest/orgs/rules#get-organization-ruleset-version
        """

        from ..models import BasicError, RulesetVersionWithState

        url = f"/orgs/{org}/rulesets/{ruleset_id}/history/{version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RulesetVersionWithState,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def list_security_manager_teams(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[TeamSimple], list[TeamSimpleTypeForResponse]]:
        """DEPRECATED orgs/list-security-manager-teams

        GET /orgs/{org}/security-managers

        > [!WARNING]
        > **Closing down notice:** This operation is closing down and will be removed starting January 1, 2026. Please use the "[Organization Roles](https://docs.github.com/rest/orgs/organization-roles)" endpoints instead.

        See also: https://docs.github.com/rest/orgs/security-managers#list-security-manager-teams
        """

        from ..models import TeamSimple

        url = f"/orgs/{org}/security-managers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[TeamSimple],
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_list_security_manager_teams(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[TeamSimple], list[TeamSimpleTypeForResponse]]:
        """DEPRECATED orgs/list-security-manager-teams

        GET /orgs/{org}/security-managers

        > [!WARNING]
        > **Closing down notice:** This operation is closing down and will be removed starting January 1, 2026. Please use the "[Organization Roles](https://docs.github.com/rest/orgs/organization-roles)" endpoints instead.

        See also: https://docs.github.com/rest/orgs/security-managers#list-security-manager-teams
        """

        from ..models import TeamSimple

        url = f"/orgs/{org}/security-managers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[TeamSimple],
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def add_security_manager_team(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED orgs/add-security-manager-team

        PUT /orgs/{org}/security-managers/teams/{team_slug}

        > [!WARNING]
        > **Closing down notice:** This operation is closing down and will be removed starting January 1, 2026. Please use the "[Organization Roles](https://docs.github.com/rest/orgs/organization-roles)" endpoints instead.

        See also: https://docs.github.com/rest/orgs/security-managers#add-a-security-manager-team
        """

        url = f"/orgs/{org}/security-managers/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_add_security_manager_team(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED orgs/add-security-manager-team

        PUT /orgs/{org}/security-managers/teams/{team_slug}

        > [!WARNING]
        > **Closing down notice:** This operation is closing down and will be removed starting January 1, 2026. Please use the "[Organization Roles](https://docs.github.com/rest/orgs/organization-roles)" endpoints instead.

        See also: https://docs.github.com/rest/orgs/security-managers#add-a-security-manager-team
        """

        url = f"/orgs/{org}/security-managers/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def remove_security_manager_team(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED orgs/remove-security-manager-team

        DELETE /orgs/{org}/security-managers/teams/{team_slug}

        > [!WARNING]
        > **Closing down notice:** This operation is closing down and will be removed starting January 1, 2026. Please use the "[Organization Roles](https://docs.github.com/rest/orgs/organization-roles)" endpoints instead.

        See also: https://docs.github.com/rest/orgs/security-managers#remove-a-security-manager-team
        """

        url = f"/orgs/{org}/security-managers/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_remove_security_manager_team(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED orgs/remove-security-manager-team

        DELETE /orgs/{org}/security-managers/teams/{team_slug}

        > [!WARNING]
        > **Closing down notice:** This operation is closing down and will be removed starting January 1, 2026. Please use the "[Organization Roles](https://docs.github.com/rest/orgs/organization-roles)" endpoints instead.

        See also: https://docs.github.com/rest/orgs/security-managers#remove-a-security-manager-team
        """

        url = f"/orgs/{org}/security-managers/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def get_immutable_releases_settings(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ImmutableReleasesOrganizationSettings,
        ImmutableReleasesOrganizationSettingsTypeForResponse,
    ]:
        """orgs/get-immutable-releases-settings

        GET /orgs/{org}/settings/immutable-releases

        Gets the immutable releases policy for repositories in an organization.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/orgs#get-immutable-releases-settings-for-an-organization
        """

        from ..models import ImmutableReleasesOrganizationSettings

        url = f"/orgs/{org}/settings/immutable-releases"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ImmutableReleasesOrganizationSettings,
        )

    async def async_get_immutable_releases_settings(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ImmutableReleasesOrganizationSettings,
        ImmutableReleasesOrganizationSettingsTypeForResponse,
    ]:
        """orgs/get-immutable-releases-settings

        GET /orgs/{org}/settings/immutable-releases

        Gets the immutable releases policy for repositories in an organization.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/orgs#get-immutable-releases-settings-for-an-organization
        """

        from ..models import ImmutableReleasesOrganizationSettings

        url = f"/orgs/{org}/settings/immutable-releases"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ImmutableReleasesOrganizationSettings,
        )

    @overload
    def set_immutable_releases_settings(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgSettingsImmutableReleasesPutBodyType,
    ) -> Response: ...

    @overload
    def set_immutable_releases_settings(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        enforced_repositories: Literal["all", "none", "selected"],
        selected_repository_ids: Missing[list[int]] = UNSET,
    ) -> Response: ...

    def set_immutable_releases_settings(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgSettingsImmutableReleasesPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """orgs/set-immutable-releases-settings

        PUT /orgs/{org}/settings/immutable-releases

        Sets the immutable releases policy for repositories in an organization.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/orgs#set-immutable-releases-settings-for-an-organization
        """

        from ..models import OrgsOrgSettingsImmutableReleasesPutBody

        url = f"/orgs/{org}/settings/immutable-releases"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgSettingsImmutableReleasesPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_set_immutable_releases_settings(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgSettingsImmutableReleasesPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_immutable_releases_settings(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        enforced_repositories: Literal["all", "none", "selected"],
        selected_repository_ids: Missing[list[int]] = UNSET,
    ) -> Response: ...

    async def async_set_immutable_releases_settings(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgSettingsImmutableReleasesPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """orgs/set-immutable-releases-settings

        PUT /orgs/{org}/settings/immutable-releases

        Sets the immutable releases policy for repositories in an organization.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/orgs#set-immutable-releases-settings-for-an-organization
        """

        from ..models import OrgsOrgSettingsImmutableReleasesPutBody

        url = f"/orgs/{org}/settings/immutable-releases"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgSettingsImmutableReleasesPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def get_immutable_releases_settings_repositories(
        self,
        org: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgSettingsImmutableReleasesRepositoriesGetResponse200,
        OrgsOrgSettingsImmutableReleasesRepositoriesGetResponse200TypeForResponse,
    ]:
        """orgs/get-immutable-releases-settings-repositories

        GET /orgs/{org}/settings/immutable-releases/repositories

        List all of the repositories that have been selected for immutable releases enforcement in an organization.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/orgs#list-selected-repositories-for-immutable-releases-enforcement
        """

        from ..models import OrgsOrgSettingsImmutableReleasesRepositoriesGetResponse200

        url = f"/orgs/{org}/settings/immutable-releases/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgSettingsImmutableReleasesRepositoriesGetResponse200,
        )

    async def async_get_immutable_releases_settings_repositories(
        self,
        org: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgSettingsImmutableReleasesRepositoriesGetResponse200,
        OrgsOrgSettingsImmutableReleasesRepositoriesGetResponse200TypeForResponse,
    ]:
        """orgs/get-immutable-releases-settings-repositories

        GET /orgs/{org}/settings/immutable-releases/repositories

        List all of the repositories that have been selected for immutable releases enforcement in an organization.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/orgs#list-selected-repositories-for-immutable-releases-enforcement
        """

        from ..models import OrgsOrgSettingsImmutableReleasesRepositoriesGetResponse200

        url = f"/orgs/{org}/settings/immutable-releases/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgSettingsImmutableReleasesRepositoriesGetResponse200,
        )

    @overload
    def set_immutable_releases_settings_repositories(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgSettingsImmutableReleasesRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    def set_immutable_releases_settings_repositories(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_repository_ids: list[int],
    ) -> Response: ...

    def set_immutable_releases_settings_repositories(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgSettingsImmutableReleasesRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """orgs/set-immutable-releases-settings-repositories

        PUT /orgs/{org}/settings/immutable-releases/repositories

        Replaces all repositories that have been selected for immutable releases enforcement in an organization. To use this endpoint, the organization immutable releases policy for `enforced_repositories` must be configured to `selected`.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/orgs#set-selected-repositories-for-immutable-releases-enforcement
        """

        from ..models import OrgsOrgSettingsImmutableReleasesRepositoriesPutBody

        url = f"/orgs/{org}/settings/immutable-releases/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgSettingsImmutableReleasesRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    async def async_set_immutable_releases_settings_repositories(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgSettingsImmutableReleasesRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_immutable_releases_settings_repositories(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_repository_ids: list[int],
    ) -> Response: ...

    async def async_set_immutable_releases_settings_repositories(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgSettingsImmutableReleasesRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """orgs/set-immutable-releases-settings-repositories

        PUT /orgs/{org}/settings/immutable-releases/repositories

        Replaces all repositories that have been selected for immutable releases enforcement in an organization. To use this endpoint, the organization immutable releases policy for `enforced_repositories` must be configured to `selected`.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/orgs#set-selected-repositories-for-immutable-releases-enforcement
        """

        from ..models import OrgsOrgSettingsImmutableReleasesRepositoriesPutBody

        url = f"/orgs/{org}/settings/immutable-releases/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgSettingsImmutableReleasesRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
        )

    def enable_selected_repository_immutable_releases_organization(
        self,
        org: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/enable-selected-repository-immutable-releases-organization

        PUT /orgs/{org}/settings/immutable-releases/repositories/{repository_id}

        Adds a repository to the list of selected repositories that are enforced for immutable releases in an organization. To use this endpoint, the organization immutable releases policy for `enforced_repositories` must be configured to `selected`.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/orgs#enable-a-selected-repository-for-immutable-releases-in-an-organization
        """

        url = f"/orgs/{org}/settings/immutable-releases/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_enable_selected_repository_immutable_releases_organization(
        self,
        org: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/enable-selected-repository-immutable-releases-organization

        PUT /orgs/{org}/settings/immutable-releases/repositories/{repository_id}

        Adds a repository to the list of selected repositories that are enforced for immutable releases in an organization. To use this endpoint, the organization immutable releases policy for `enforced_repositories` must be configured to `selected`.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/orgs#enable-a-selected-repository-for-immutable-releases-in-an-organization
        """

        url = f"/orgs/{org}/settings/immutable-releases/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def disable_selected_repository_immutable_releases_organization(
        self,
        org: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/disable-selected-repository-immutable-releases-organization

        DELETE /orgs/{org}/settings/immutable-releases/repositories/{repository_id}

        Removes a repository from the list of selected repositories that are enforced for immutable releases in an organization. To use this endpoint, the organization immutable releases policy for `enforced_repositories` must be configured to `selected`.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/orgs#disable-a-selected-repository-for-immutable-releases-in-an-organization
        """

        url = f"/orgs/{org}/settings/immutable-releases/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_disable_selected_repository_immutable_releases_organization(
        self,
        org: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """orgs/disable-selected-repository-immutable-releases-organization

        DELETE /orgs/{org}/settings/immutable-releases/repositories/{repository_id}

        Removes a repository from the list of selected repositories that are enforced for immutable releases in an organization. To use this endpoint, the organization immutable releases policy for `enforced_repositories` must be configured to `selected`.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/orgs#disable-a-selected-repository-for-immutable-releases-in-an-organization
        """

        url = f"/orgs/{org}/settings/immutable-releases/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "code_scanning_default_setup",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgSecurityProductEnablementPostBodyType] = UNSET,
    ) -> Response: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "code_scanning_default_setup",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        query_suite: Missing[Literal["default", "extended"]] = UNSET,
    ) -> Response: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "code_scanning_default_setup",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgSecurityProductEnablementPostBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED orgs/enable-or-disable-security-product-on-all-org-repos

        POST /orgs/{org}/{security_product}/{enablement}

        > [!WARNING]
        > **Closing down notice:** The ability to enable or disable a security feature for all eligible repositories in an organization is closing down. Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead. For more information, see the [changelog](https://github.blog/changelog/2024-07-22-deprecation-of-api-endpoint-to-enable-or-disable-a-security-feature-for-an-organization/).

        Enables or disables the specified security feature for all eligible repositories in an organization. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."

        The authenticated user must be an organization owner or be member of a team with the security manager role to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org`, `write:org`, or `repo` scopes to use this endpoint.

        See also: https://docs.github.com/rest/orgs/orgs#enable-or-disable-a-security-feature-for-an-organization
        """

        from ..models import OrgsOrgSecurityProductEnablementPostBody

        url = f"/orgs/{org}/{security_product}/{enablement}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgSecurityProductEnablementPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "code_scanning_default_setup",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgSecurityProductEnablementPostBodyType] = UNSET,
    ) -> Response: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "code_scanning_default_setup",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        query_suite: Missing[Literal["default", "extended"]] = UNSET,
    ) -> Response: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "code_scanning_default_setup",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgSecurityProductEnablementPostBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED orgs/enable-or-disable-security-product-on-all-org-repos

        POST /orgs/{org}/{security_product}/{enablement}

        > [!WARNING]
        > **Closing down notice:** The ability to enable or disable a security feature for all eligible repositories in an organization is closing down. Please use [code security configurations](https://docs.github.com/rest/code-security/configurations) instead. For more information, see the [changelog](https://github.blog/changelog/2024-07-22-deprecation-of-api-endpoint-to-enable-or-disable-a-security-feature-for-an-organization/).

        Enables or disables the specified security feature for all eligible repositories in an organization. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."

        The authenticated user must be an organization owner or be member of a team with the security manager role to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:org`, `write:org`, or `repo` scopes to use this endpoint.

        See also: https://docs.github.com/rest/orgs/orgs#enable-or-disable-a-security-feature-for-an-organization
        """

        from ..models import OrgsOrgSecurityProductEnablementPostBody

        url = f"/orgs/{org}/{security_product}/{enablement}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgSecurityProductEnablementPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    def list_memberships_for_authenticated_user(
        self,
        *,
        state: Missing[Literal["active", "pending"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[OrgMembership], list[OrgMembershipTypeForResponse]]:
        """orgs/list-memberships-for-authenticated-user

        GET /user/memberships/orgs

        Lists all of the authenticated user's organization memberships.

        See also: https://docs.github.com/rest/orgs/members#list-organization-memberships-for-the-authenticated-user
        """

        from ..models import BasicError, OrgMembership, ValidationError

        url = "/user/memberships/orgs"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrgMembership],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_memberships_for_authenticated_user(
        self,
        *,
        state: Missing[Literal["active", "pending"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[OrgMembership], list[OrgMembershipTypeForResponse]]:
        """orgs/list-memberships-for-authenticated-user

        GET /user/memberships/orgs

        Lists all of the authenticated user's organization memberships.

        See also: https://docs.github.com/rest/orgs/members#list-organization-memberships-for-the-authenticated-user
        """

        from ..models import BasicError, OrgMembership, ValidationError

        url = "/user/memberships/orgs"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrgMembership],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def get_membership_for_authenticated_user(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrgMembership, OrgMembershipTypeForResponse]:
        """orgs/get-membership-for-authenticated-user

        GET /user/memberships/orgs/{org}

        If the authenticated user is an active or pending member of the organization, this endpoint will return the user's membership. If the authenticated user is not affiliated with the organization, a `404` is returned. This endpoint will return a `403` if the request is made by a GitHub App that is blocked by the organization.

        See also: https://docs.github.com/rest/orgs/members#get-an-organization-membership-for-the-authenticated-user
        """

        from ..models import BasicError, OrgMembership

        url = f"/user/memberships/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgMembership,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_membership_for_authenticated_user(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrgMembership, OrgMembershipTypeForResponse]:
        """orgs/get-membership-for-authenticated-user

        GET /user/memberships/orgs/{org}

        If the authenticated user is an active or pending member of the organization, this endpoint will return the user's membership. If the authenticated user is not affiliated with the organization, a `404` is returned. This endpoint will return a `403` if the request is made by a GitHub App that is blocked by the organization.

        See also: https://docs.github.com/rest/orgs/members#get-an-organization-membership-for-the-authenticated-user
        """

        from ..models import BasicError, OrgMembership

        url = f"/user/memberships/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgMembership,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UserMembershipsOrgsOrgPatchBodyType,
    ) -> Response[OrgMembership, OrgMembershipTypeForResponse]: ...

    @overload
    def update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        state: Literal["active"],
    ) -> Response[OrgMembership, OrgMembershipTypeForResponse]: ...

    def update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserMembershipsOrgsOrgPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgMembership, OrgMembershipTypeForResponse]:
        """orgs/update-membership-for-authenticated-user

        PATCH /user/memberships/orgs/{org}

        Converts the authenticated user to an active member of the organization, if that user has a pending invitation from the organization.

        See also: https://docs.github.com/rest/orgs/members#update-an-organization-membership-for-the-authenticated-user
        """

        from ..models import (
            BasicError,
            OrgMembership,
            UserMembershipsOrgsOrgPatchBody,
            ValidationError,
        )

        url = f"/user/memberships/orgs/{org}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserMembershipsOrgsOrgPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgMembership,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UserMembershipsOrgsOrgPatchBodyType,
    ) -> Response[OrgMembership, OrgMembershipTypeForResponse]: ...

    @overload
    async def async_update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        state: Literal["active"],
    ) -> Response[OrgMembership, OrgMembershipTypeForResponse]: ...

    async def async_update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserMembershipsOrgsOrgPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgMembership, OrgMembershipTypeForResponse]:
        """orgs/update-membership-for-authenticated-user

        PATCH /user/memberships/orgs/{org}

        Converts the authenticated user to an active member of the organization, if that user has a pending invitation from the organization.

        See also: https://docs.github.com/rest/orgs/members#update-an-organization-membership-for-the-authenticated-user
        """

        from ..models import (
            BasicError,
            OrgMembership,
            UserMembershipsOrgsOrgPatchBody,
            ValidationError,
        )

        url = f"/user/memberships/orgs/{org}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserMembershipsOrgsOrgPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgMembership,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[OrganizationSimple], list[OrganizationSimpleTypeForResponse]]:
        """orgs/list-for-authenticated-user

        GET /user/orgs

        List organizations for the authenticated user.

        For OAuth app tokens and personal access tokens (classic), this endpoint only lists organizations that your authorization allows you to operate on in some way (e.g., you can list teams with `read:org` scope, you can publicize your organization membership with `user` scope, etc.). Therefore, this API requires at least `user` or `read:org` scope for OAuth app tokens and personal access tokens (classic). Requests with insufficient scope will receive a `403 Forbidden` response.

        > [!NOTE]
        > Requests using a fine-grained access token will receive a `200 Success` response with an empty list.

        See also: https://docs.github.com/rest/orgs/orgs#list-organizations-for-the-authenticated-user
        """

        from ..models import BasicError, OrganizationSimple

        url = "/user/orgs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrganizationSimple],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[OrganizationSimple], list[OrganizationSimpleTypeForResponse]]:
        """orgs/list-for-authenticated-user

        GET /user/orgs

        List organizations for the authenticated user.

        For OAuth app tokens and personal access tokens (classic), this endpoint only lists organizations that your authorization allows you to operate on in some way (e.g., you can list teams with `read:org` scope, you can publicize your organization membership with `user` scope, etc.). Therefore, this API requires at least `user` or `read:org` scope for OAuth app tokens and personal access tokens (classic). Requests with insufficient scope will receive a `403 Forbidden` response.

        > [!NOTE]
        > Requests using a fine-grained access token will receive a `200 Success` response with an empty list.

        See also: https://docs.github.com/rest/orgs/orgs#list-organizations-for-the-authenticated-user
        """

        from ..models import BasicError, OrganizationSimple

        url = "/user/orgs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrganizationSimple],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[OrganizationSimple], list[OrganizationSimpleTypeForResponse]]:
        """orgs/list-for-user

        GET /users/{username}/orgs

        List [public organization memberships](https://docs.github.com/articles/publicizing-or-concealing-organization-membership) for the specified user.

        This method only lists _public_ memberships, regardless of authentication. If you need to fetch all of the organization memberships (public and private) for the authenticated user, use the [List organizations for the authenticated user](https://docs.github.com/rest/orgs/orgs#list-organizations-for-the-authenticated-user) API instead.

        See also: https://docs.github.com/rest/orgs/orgs#list-organizations-for-a-user
        """

        from ..models import OrganizationSimple

        url = f"/users/{username}/orgs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrganizationSimple],
        )

    async def async_list_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[OrganizationSimple], list[OrganizationSimpleTypeForResponse]]:
        """orgs/list-for-user

        GET /users/{username}/orgs

        List [public organization memberships](https://docs.github.com/articles/publicizing-or-concealing-organization-membership) for the specified user.

        This method only lists _public_ memberships, regardless of authentication. If you need to fetch all of the organization memberships (public and private) for the authenticated user, use the [List organizations for the authenticated user](https://docs.github.com/rest/orgs/orgs#list-organizations-for-the-authenticated-user) API instead.

        See also: https://docs.github.com/rest/orgs/orgs#list-organizations-for-a-user
        """

        from ..models import OrganizationSimple

        url = f"/users/{username}/orgs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrganizationSimple],
        )
