"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from typing_extensions import deprecated
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset, parse_query_params

if TYPE_CHECKING:
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        ProjectCollaboratorPermission,
        ProjectColumn,
        ProjectsColumnsColumnIdMovesPostResponse201,
        SimpleUser,
    )
    from ..types import (
        ProjectCollaboratorPermissionTypeForResponse,
        ProjectColumnTypeForResponse,
        ProjectsColumnsColumnIdMovesPostBodyType,
        ProjectsColumnsColumnIdMovesPostResponse201TypeForResponse,
        ProjectsColumnsColumnIdPatchBodyType,
        ProjectsProjectIdCollaboratorsUsernamePutBodyType,
        SimpleUserTypeForResponse,
    )


class ProjectsClassicClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def get_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectColumn, ProjectColumnTypeForResponse]:
        """DEPRECATED projects-classic/get-column

        GET /projects/columns/{column_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/rest/projects-classic/columns#get-a-project-column
        """

        from ..models import BasicError, ProjectColumn

        url = f"/projects/columns/{column_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "401": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_get_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectColumn, ProjectColumnTypeForResponse]:
        """DEPRECATED projects-classic/get-column

        GET /projects/columns/{column_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/rest/projects-classic/columns#get-a-project-column
        """

        from ..models import BasicError, ProjectColumn

        url = f"/projects/columns/{column_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "401": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def delete_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED projects-classic/delete-column

        DELETE /projects/columns/{column_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/rest/projects-classic/columns#delete-a-project-column
        """

        from ..models import BasicError

        url = f"/projects/columns/{column_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_delete_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED projects-classic/delete-column

        DELETE /projects/columns/{column_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/rest/projects-classic/columns#delete-a-project-column
        """

        from ..models import BasicError

        url = f"/projects/columns/{column_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def update_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ProjectsColumnsColumnIdPatchBodyType,
    ) -> Response[ProjectColumn, ProjectColumnTypeForResponse]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def update_column(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
    ) -> Response[ProjectColumn, ProjectColumnTypeForResponse]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def update_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsColumnIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectColumn, ProjectColumnTypeForResponse]:
        """DEPRECATED projects-classic/update-column

        PATCH /projects/columns/{column_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/rest/projects-classic/columns#update-an-existing-project-column
        """

        from ..models import BasicError, ProjectColumn, ProjectsColumnsColumnIdPatchBody

        url = f"/projects/columns/{column_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsColumnIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_update_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ProjectsColumnsColumnIdPatchBodyType,
    ) -> Response[ProjectColumn, ProjectColumnTypeForResponse]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_update_column(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
    ) -> Response[ProjectColumn, ProjectColumnTypeForResponse]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_update_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsColumnIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectColumn, ProjectColumnTypeForResponse]:
        """DEPRECATED projects-classic/update-column

        PATCH /projects/columns/{column_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/rest/projects-classic/columns#update-an-existing-project-column
        """

        from ..models import BasicError, ProjectColumn, ProjectsColumnsColumnIdPatchBody

        url = f"/projects/columns/{column_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsColumnIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def move_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ProjectsColumnsColumnIdMovesPostBodyType,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201TypeForResponse,
    ]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def move_column(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        position: str,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201TypeForResponse,
    ]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def move_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsColumnIdMovesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201TypeForResponse,
    ]:
        """DEPRECATED projects-classic/move-column

        POST /projects/columns/{column_id}/moves

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/rest/projects-classic/columns#move-a-project-column
        """

        from ..models import (
            BasicError,
            ProjectsColumnsColumnIdMovesPostBody,
            ProjectsColumnsColumnIdMovesPostResponse201,
            ValidationErrorSimple,
        )

        url = f"/projects/columns/{column_id}/moves"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsColumnIdMovesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsColumnsColumnIdMovesPostResponse201,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "401": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_move_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ProjectsColumnsColumnIdMovesPostBodyType,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201TypeForResponse,
    ]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_move_column(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        position: str,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201TypeForResponse,
    ]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_move_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsColumnIdMovesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201TypeForResponse,
    ]:
        """DEPRECATED projects-classic/move-column

        POST /projects/columns/{column_id}/moves

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/rest/projects-classic/columns#move-a-project-column
        """

        from ..models import (
            BasicError,
            ProjectsColumnsColumnIdMovesPostBody,
            ProjectsColumnsColumnIdMovesPostResponse201,
            ValidationErrorSimple,
        )

        url = f"/projects/columns/{column_id}/moves"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsColumnIdMovesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsColumnsColumnIdMovesPostResponse201,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "401": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def list_collaborators(
        self,
        project_id: int,
        *,
        affiliation: Missing[Literal["outside", "direct", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SimpleUser], list[SimpleUserTypeForResponse]]:
        """DEPRECATED projects-classic/list-collaborators

        GET /projects/{project_id}/collaborators

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/rest/projects-classic/collaborators#list-project-collaborators
        """

        from ..models import BasicError, SimpleUser, ValidationError

        url = f"/projects/{project_id}/collaborators"

        params = {
            "affiliation": affiliation,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_list_collaborators(
        self,
        project_id: int,
        *,
        affiliation: Missing[Literal["outside", "direct", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SimpleUser], list[SimpleUserTypeForResponse]]:
        """DEPRECATED projects-classic/list-collaborators

        GET /projects/{project_id}/collaborators

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/rest/projects-classic/collaborators#list-project-collaborators
        """

        from ..models import BasicError, SimpleUser, ValidationError

        url = f"/projects/{project_id}/collaborators"

        params = {
            "affiliation": affiliation,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
    ) -> Response: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> Response: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED projects-classic/add-collaborator

        PUT /projects/{project_id}/collaborators/{username}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/rest/projects-classic/collaborators#add-project-collaborator
        """

        from typing import Union

        from ..models import (
            BasicError,
            ProjectsProjectIdCollaboratorsUsernamePutBody,
            ValidationError,
        )

        url = f"/projects/{project_id}/collaborators/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ProjectsProjectIdCollaboratorsUsernamePutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
    ) -> Response: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> Response: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED projects-classic/add-collaborator

        PUT /projects/{project_id}/collaborators/{username}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/rest/projects-classic/collaborators#add-project-collaborator
        """

        from typing import Union

        from ..models import (
            BasicError,
            ProjectsProjectIdCollaboratorsUsernamePutBody,
            ValidationError,
        )

        url = f"/projects/{project_id}/collaborators/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ProjectsProjectIdCollaboratorsUsernamePutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def remove_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED projects-classic/remove-collaborator

        DELETE /projects/{project_id}/collaborators/{username}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/rest/projects-classic/collaborators#remove-user-as-a-collaborator
        """

        from ..models import BasicError, ValidationError

        url = f"/projects/{project_id}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "401": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_remove_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED projects-classic/remove-collaborator

        DELETE /projects/{project_id}/collaborators/{username}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/rest/projects-classic/collaborators#remove-user-as-a-collaborator
        """

        from ..models import BasicError, ValidationError

        url = f"/projects/{project_id}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "401": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def get_permission_for_user(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ProjectCollaboratorPermission, ProjectCollaboratorPermissionTypeForResponse
    ]:
        """DEPRECATED projects-classic/get-permission-for-user

        GET /projects/{project_id}/collaborators/{username}/permission

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/rest/projects-classic/collaborators#get-project-permission-for-a-user
        """

        from ..models import BasicError, ProjectCollaboratorPermission, ValidationError

        url = f"/projects/{project_id}/collaborators/{username}/permission"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectCollaboratorPermission,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_get_permission_for_user(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ProjectCollaboratorPermission, ProjectCollaboratorPermissionTypeForResponse
    ]:
        """DEPRECATED projects-classic/get-permission-for-user

        GET /projects/{project_id}/collaborators/{username}/permission

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/rest/projects-classic/collaborators#get-project-permission-for-a-user
        """

        from ..models import BasicError, ProjectCollaboratorPermission, ValidationError

        url = f"/projects/{project_id}/collaborators/{username}/permission"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectCollaboratorPermission,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )
