"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from typing import Literal

from pydantic import Field

from githubkit.compat import GitHubModel, model_rebuild
from githubkit.typing import Missing
from githubkit.utils import UNSET


class RepositoryRulePullRequestPropParameters(GitHubModel):
    """RepositoryRulePullRequestPropParameters"""

    allowed_merge_methods: Missing[list[Literal["merge", "squash", "rebase"]]] = Field(
        default=UNSET,
        description="Array of allowed merge methods. Allowed values include `merge`, `squash`, and `rebase`. At least one option must be enabled.",
    )
    automatic_copilot_code_review_enabled: Missing[bool] = Field(
        default=UNSET,
        description="Request Copilot code review for new pull requests automatically if the author has access to Copilot code review.",
    )
    dismiss_stale_reviews_on_push: bool = Field(
        description="New, reviewable commits pushed will dismiss previous pull request review approvals."
    )
    require_code_owner_review: bool = Field(
        description="Require an approving review in pull requests that modify files that have a designated code owner."
    )
    require_last_push_approval: bool = Field(
        description="Whether the most recent reviewable push must be approved by someone other than the person who pushed it."
    )
    required_approving_review_count: int = Field(
        le=10.0,
        description="The number of approving reviews that are required before a pull request can be merged.",
    )
    required_review_thread_resolution: bool = Field(
        description="All conversations on code must be resolved before a pull request can be merged."
    )
    required_reviewers: Missing[
        list[RepositoryRuleParamsRequiredReviewerConfiguration]
    ] = Field(
        default=UNSET,
        description="> [!NOTE]\n> `required_reviewers` is in beta and subject to change.\n\nA collection of reviewers and associated file patterns. Each reviewer has a list of file patterns which determine the files that reviewer is required to review.",
    )


class RepositoryRuleParamsRequiredReviewerConfiguration(GitHubModel):
    """RequiredReviewerConfiguration

    A reviewing team, and file patterns describing which files they must approve
    changes to.
    """

    file_patterns: list[str] = Field(
        description="Array of file patterns. Pull requests which change matching files must be approved by the specified team. File patterns use fnmatch syntax."
    )
    minimum_approvals: int = Field(
        description="Minimum number of approvals required from the specified team. If set to zero, the team will be added to the pull request but approval is optional."
    )
    reviewer: RepositoryRuleParamsReviewer = Field(
        title="Reviewer", description="A required reviewing team"
    )


class RepositoryRuleParamsReviewer(GitHubModel):
    """Reviewer

    A required reviewing team
    """

    id: int = Field(
        description="ID of the reviewer which must review changes to matching files."
    )
    type: Literal["Team"] = Field(description="The type of the reviewer")


model_rebuild(RepositoryRulePullRequestPropParameters)
model_rebuild(RepositoryRuleParamsRequiredReviewerConfiguration)
model_rebuild(RepositoryRuleParamsReviewer)

__all__ = (
    "RepositoryRuleParamsRequiredReviewerConfiguration",
    "RepositoryRuleParamsReviewer",
    "RepositoryRulePullRequestPropParameters",
)
