"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..types import MarkdownPostBodyType


class MarkdownClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    @overload
    def render(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: MarkdownPostBodyType,
    ) -> Response[str, str]: ...

    @overload
    def render(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        text: str,
        mode: Missing[Literal["markdown", "gfm"]] = UNSET,
        context: Missing[str] = UNSET,
    ) -> Response[str, str]: ...

    def render(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[MarkdownPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[str, str]:
        """markdown/render

        POST /markdown

        Depending on what is rendered in the Markdown, you may need to provide additional token scopes for labels, such as `issues:read` or `pull_requests:read`.

        See also: https://docs.github.com/rest/markdown/markdown#render-a-markdown-document
        """

        from ..models import MarkdownPostBody

        url = "/markdown"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(MarkdownPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=str,
        )

    @overload
    async def async_render(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: MarkdownPostBodyType,
    ) -> Response[str, str]: ...

    @overload
    async def async_render(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        text: str,
        mode: Missing[Literal["markdown", "gfm"]] = UNSET,
        context: Missing[str] = UNSET,
    ) -> Response[str, str]: ...

    async def async_render(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[MarkdownPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[str, str]:
        """markdown/render

        POST /markdown

        Depending on what is rendered in the Markdown, you may need to provide additional token scopes for labels, such as `issues:read` or `pull_requests:read`.

        See also: https://docs.github.com/rest/markdown/markdown#render-a-markdown-document
        """

        from ..models import MarkdownPostBody

        url = "/markdown"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(MarkdownPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=str,
        )

    def render_raw(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: str,
    ) -> Response[str, str]:
        """markdown/render-raw

        POST /markdown/raw

        You must send Markdown as plain text (using a `Content-Type` header of `text/plain` or `text/x-markdown`) to this endpoint, rather than using JSON format. In raw mode, [GitHub Flavored Markdown](https://github.github.com/gfm/) is not supported and Markdown will be rendered in plain format like a README.md file. Markdown content must be 400 KB or less.

        See also: https://docs.github.com/rest/markdown/markdown#render-a-markdown-document-in-raw-mode
        """

        url = "/markdown/raw"

        headers = {
            "Content-Type": "text/plain",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        content = data

        return self._github.request(
            "POST",
            url,
            content=exclude_unset(content),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=str,
        )

    async def async_render_raw(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: str,
    ) -> Response[str, str]:
        """markdown/render-raw

        POST /markdown/raw

        You must send Markdown as plain text (using a `Content-Type` header of `text/plain` or `text/x-markdown`) to this endpoint, rather than using JSON format. In raw mode, [GitHub Flavored Markdown](https://github.github.com/gfm/) is not supported and Markdown will be rendered in plain format like a README.md file. Markdown content must be 400 KB or less.

        See also: https://docs.github.com/rest/markdown/markdown#render-a-markdown-document-in-raw-mode
        """

        url = "/markdown/raw"

        headers = {
            "Content-Type": "text/plain",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        content = data

        return await self._github.arequest(
            "POST",
            url,
            content=exclude_unset(content),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=str,
        )
