"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset, parse_query_params

if TYPE_CHECKING:
    from typing import Literal

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import Blob, GitCommit, GitRef, GitTag, GitTree, ShortBlob
    from ..types import (
        BlobTypeForResponse,
        GitCommitTypeForResponse,
        GitRefTypeForResponse,
        GitTagTypeForResponse,
        GitTreeTypeForResponse,
        ReposOwnerRepoGitBlobsPostBodyType,
        ReposOwnerRepoGitCommitsPostBodyPropAuthorType,
        ReposOwnerRepoGitCommitsPostBodyPropCommitterType,
        ReposOwnerRepoGitCommitsPostBodyType,
        ReposOwnerRepoGitRefsPostBodyType,
        ReposOwnerRepoGitRefsRefPatchBodyType,
        ReposOwnerRepoGitTagsPostBodyPropTaggerType,
        ReposOwnerRepoGitTagsPostBodyType,
        ReposOwnerRepoGitTreesPostBodyPropTreeItemsType,
        ReposOwnerRepoGitTreesPostBodyType,
        ShortBlobTypeForResponse,
    )


class GitClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    @overload
    def create_blob(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoGitBlobsPostBodyType,
    ) -> Response[ShortBlob, ShortBlobTypeForResponse]: ...

    @overload
    def create_blob(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content: str,
        encoding: Missing[str] = UNSET,
    ) -> Response[ShortBlob, ShortBlobTypeForResponse]: ...

    def create_blob(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoGitBlobsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ShortBlob, ShortBlobTypeForResponse]:
        """git/create-blob

        POST /repos/{owner}/{repo}/git/blobs

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/blobs#create-a-blob
        """

        from typing import Union

        from ..models import (
            BasicError,
            RepositoryRuleViolationError,
            ReposOwnerRepoGitBlobsPostBody,
            ShortBlob,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/git/blobs"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoGitBlobsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ShortBlob,
            error_models={
                "404": BasicError,
                "409": BasicError,
                "403": BasicError,
                "422": Union[ValidationError, RepositoryRuleViolationError],
            },
        )

    @overload
    async def async_create_blob(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoGitBlobsPostBodyType,
    ) -> Response[ShortBlob, ShortBlobTypeForResponse]: ...

    @overload
    async def async_create_blob(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content: str,
        encoding: Missing[str] = UNSET,
    ) -> Response[ShortBlob, ShortBlobTypeForResponse]: ...

    async def async_create_blob(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoGitBlobsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ShortBlob, ShortBlobTypeForResponse]:
        """git/create-blob

        POST /repos/{owner}/{repo}/git/blobs

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/blobs#create-a-blob
        """

        from typing import Union

        from ..models import (
            BasicError,
            RepositoryRuleViolationError,
            ReposOwnerRepoGitBlobsPostBody,
            ShortBlob,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/git/blobs"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoGitBlobsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ShortBlob,
            error_models={
                "404": BasicError,
                "409": BasicError,
                "403": BasicError,
                "422": Union[ValidationError, RepositoryRuleViolationError],
            },
        )

    def get_blob(
        self,
        owner: str,
        repo: str,
        file_sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Blob, BlobTypeForResponse]:
        """git/get-blob

        GET /repos/{owner}/{repo}/git/blobs/{file_sha}

        The `content` in the response will always be Base64 encoded.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-cloud@latest//rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw blob data.
        - **`application/vnd.github+json`**: Returns a JSON representation of the blob with `content` as a base64 encoded string. This is the default if no media type is specified.

        **Note** This endpoint supports blobs up to 100 megabytes in size.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/blobs#get-a-blob
        """

        from ..models import BasicError, Blob, ValidationError

        url = f"/repos/{owner}/{repo}/git/blobs/{file_sha}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Blob,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "409": BasicError,
            },
        )

    async def async_get_blob(
        self,
        owner: str,
        repo: str,
        file_sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Blob, BlobTypeForResponse]:
        """git/get-blob

        GET /repos/{owner}/{repo}/git/blobs/{file_sha}

        The `content` in the response will always be Base64 encoded.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/enterprise-cloud@latest//rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw blob data.
        - **`application/vnd.github+json`**: Returns a JSON representation of the blob with `content` as a base64 encoded string. This is the default if no media type is specified.

        **Note** This endpoint supports blobs up to 100 megabytes in size.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/blobs#get-a-blob
        """

        from ..models import BasicError, Blob, ValidationError

        url = f"/repos/{owner}/{repo}/git/blobs/{file_sha}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Blob,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "409": BasicError,
            },
        )

    @overload
    def create_commit(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoGitCommitsPostBodyType,
    ) -> Response[GitCommit, GitCommitTypeForResponse]: ...

    @overload
    def create_commit(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        message: str,
        tree: str,
        parents: Missing[list[str]] = UNSET,
        author: Missing[ReposOwnerRepoGitCommitsPostBodyPropAuthorType] = UNSET,
        committer: Missing[ReposOwnerRepoGitCommitsPostBodyPropCommitterType] = UNSET,
        signature: Missing[str] = UNSET,
    ) -> Response[GitCommit, GitCommitTypeForResponse]: ...

    def create_commit(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoGitCommitsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GitCommit, GitCommitTypeForResponse]:
        """git/create-commit

        POST /repos/{owner}/{repo}/git/commits

        Creates a new Git [commit object](https://git-scm.com/book/en/v2/Git-Internals-Git-Objects).

        **Signature verification object**

        The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:

        | Name | Type | Description |
        | ---- | ---- | ----------- |
        | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
        | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in the table below. |
        | `signature` | `string` | The signature that was extracted from the commit. |
        | `payload` | `string` | The value that was signed. |
        | `verified_at` | `string` | The date the signature was verified by GitHub. |

        These are the possible values for `reason` in the `verification` object:

        | Value | Description |
        | ----- | ----------- |
        | `expired_key` | The key that made the signature is expired. |
        | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
        | `gpgverify_error` | There was an error communicating with the signature verification service. |
        | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
        | `unsigned` | The object does not include a signature. |
        | `unknown_signature_type` | A non-PGP signature was found in the commit. |
        | `no_user` | No user was associated with the `committer` email address in the commit. |
        | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
        | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
        | `unknown_key` | The key that made the signature has not been registered with any user's account. |
        | `malformed_signature` | There was an error parsing the signature. |
        | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
        | `valid` | None of the above errors applied, so the signature is considered to be verified. |

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/commits#create-a-commit
        """

        from ..models import (
            BasicError,
            GitCommit,
            ReposOwnerRepoGitCommitsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/git/commits"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoGitCommitsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GitCommit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    @overload
    async def async_create_commit(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoGitCommitsPostBodyType,
    ) -> Response[GitCommit, GitCommitTypeForResponse]: ...

    @overload
    async def async_create_commit(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        message: str,
        tree: str,
        parents: Missing[list[str]] = UNSET,
        author: Missing[ReposOwnerRepoGitCommitsPostBodyPropAuthorType] = UNSET,
        committer: Missing[ReposOwnerRepoGitCommitsPostBodyPropCommitterType] = UNSET,
        signature: Missing[str] = UNSET,
    ) -> Response[GitCommit, GitCommitTypeForResponse]: ...

    async def async_create_commit(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoGitCommitsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GitCommit, GitCommitTypeForResponse]:
        """git/create-commit

        POST /repos/{owner}/{repo}/git/commits

        Creates a new Git [commit object](https://git-scm.com/book/en/v2/Git-Internals-Git-Objects).

        **Signature verification object**

        The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:

        | Name | Type | Description |
        | ---- | ---- | ----------- |
        | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
        | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in the table below. |
        | `signature` | `string` | The signature that was extracted from the commit. |
        | `payload` | `string` | The value that was signed. |
        | `verified_at` | `string` | The date the signature was verified by GitHub. |

        These are the possible values for `reason` in the `verification` object:

        | Value | Description |
        | ----- | ----------- |
        | `expired_key` | The key that made the signature is expired. |
        | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
        | `gpgverify_error` | There was an error communicating with the signature verification service. |
        | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
        | `unsigned` | The object does not include a signature. |
        | `unknown_signature_type` | A non-PGP signature was found in the commit. |
        | `no_user` | No user was associated with the `committer` email address in the commit. |
        | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
        | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
        | `unknown_key` | The key that made the signature has not been registered with any user's account. |
        | `malformed_signature` | There was an error parsing the signature. |
        | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
        | `valid` | None of the above errors applied, so the signature is considered to be verified. |

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/commits#create-a-commit
        """

        from ..models import (
            BasicError,
            GitCommit,
            ReposOwnerRepoGitCommitsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/git/commits"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoGitCommitsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GitCommit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    def get_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GitCommit, GitCommitTypeForResponse]:
        """git/get-commit

        GET /repos/{owner}/{repo}/git/commits/{commit_sha}

        Gets a Git [commit object](https://git-scm.com/book/en/v2/Git-Internals-Git-Objects).

        To get the contents of a commit, see "[Get a commit](/rest/commits/commits#get-a-commit)."

        **Signature verification object**

        The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:

        | Name | Type | Description |
        | ---- | ---- | ----------- |
        | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
        | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in the table below. |
        | `signature` | `string` | The signature that was extracted from the commit. |
        | `payload` | `string` | The value that was signed. |
        | `verified_at` | `string` | The date the signature was verified by GitHub. |

        These are the possible values for `reason` in the `verification` object:

        | Value | Description |
        | ----- | ----------- |
        | `expired_key` | The key that made the signature is expired. |
        | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
        | `gpgverify_error` | There was an error communicating with the signature verification service. |
        | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
        | `unsigned` | The object does not include a signature. |
        | `unknown_signature_type` | A non-PGP signature was found in the commit. |
        | `no_user` | No user was associated with the `committer` email address in the commit. |
        | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
        | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
        | `unknown_key` | The key that made the signature has not been registered with any user's account. |
        | `malformed_signature` | There was an error parsing the signature. |
        | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
        | `valid` | None of the above errors applied, so the signature is considered to be verified. |

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/commits#get-a-commit-object
        """

        from ..models import BasicError, GitCommit

        url = f"/repos/{owner}/{repo}/git/commits/{commit_sha}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GitCommit,
            error_models={
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_get_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GitCommit, GitCommitTypeForResponse]:
        """git/get-commit

        GET /repos/{owner}/{repo}/git/commits/{commit_sha}

        Gets a Git [commit object](https://git-scm.com/book/en/v2/Git-Internals-Git-Objects).

        To get the contents of a commit, see "[Get a commit](/rest/commits/commits#get-a-commit)."

        **Signature verification object**

        The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:

        | Name | Type | Description |
        | ---- | ---- | ----------- |
        | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
        | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in the table below. |
        | `signature` | `string` | The signature that was extracted from the commit. |
        | `payload` | `string` | The value that was signed. |
        | `verified_at` | `string` | The date the signature was verified by GitHub. |

        These are the possible values for `reason` in the `verification` object:

        | Value | Description |
        | ----- | ----------- |
        | `expired_key` | The key that made the signature is expired. |
        | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
        | `gpgverify_error` | There was an error communicating with the signature verification service. |
        | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
        | `unsigned` | The object does not include a signature. |
        | `unknown_signature_type` | A non-PGP signature was found in the commit. |
        | `no_user` | No user was associated with the `committer` email address in the commit. |
        | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
        | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
        | `unknown_key` | The key that made the signature has not been registered with any user's account. |
        | `malformed_signature` | There was an error parsing the signature. |
        | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
        | `valid` | None of the above errors applied, so the signature is considered to be verified. |

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/commits#get-a-commit-object
        """

        from ..models import BasicError, GitCommit

        url = f"/repos/{owner}/{repo}/git/commits/{commit_sha}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GitCommit,
            error_models={
                "404": BasicError,
                "409": BasicError,
            },
        )

    def list_matching_refs(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[GitRef], list[GitRefTypeForResponse]]:
        """git/list-matching-refs

        GET /repos/{owner}/{repo}/git/matching-refs/{ref}

        Returns an array of references from your Git database that match the supplied name. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't exist in the repository, but existing refs start with `:ref`, they will be returned as an array.

        When you use this endpoint without providing a `:ref`, it will return an array of all the references from your Git database, including notes and stashes if they exist on the server. Anything in the namespace is returned, not just `heads` and `tags`.

        > [!NOTE]
        > You need to explicitly [request a pull request](https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".

        If you request matching references for a branch named `feature` but the branch `feature` doesn't exist, the response can still include other matching head refs that start with the word `feature`, such as `featureA` and `featureB`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/refs#list-matching-references
        """

        from ..models import BasicError, GitRef

        url = f"/repos/{owner}/{repo}/git/matching-refs/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[GitRef],
            error_models={
                "409": BasicError,
            },
        )

    async def async_list_matching_refs(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[GitRef], list[GitRefTypeForResponse]]:
        """git/list-matching-refs

        GET /repos/{owner}/{repo}/git/matching-refs/{ref}

        Returns an array of references from your Git database that match the supplied name. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't exist in the repository, but existing refs start with `:ref`, they will be returned as an array.

        When you use this endpoint without providing a `:ref`, it will return an array of all the references from your Git database, including notes and stashes if they exist on the server. Anything in the namespace is returned, not just `heads` and `tags`.

        > [!NOTE]
        > You need to explicitly [request a pull request](https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".

        If you request matching references for a branch named `feature` but the branch `feature` doesn't exist, the response can still include other matching head refs that start with the word `feature`, such as `featureA` and `featureB`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/refs#list-matching-references
        """

        from ..models import BasicError, GitRef

        url = f"/repos/{owner}/{repo}/git/matching-refs/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[GitRef],
            error_models={
                "409": BasicError,
            },
        )

    def get_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GitRef, GitRefTypeForResponse]:
        """git/get-ref

        GET /repos/{owner}/{repo}/git/ref/{ref}

        Returns a single reference from your Git database. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't match an existing ref, a `404` is returned.

        > [!NOTE]
        > You need to explicitly [request a pull request](https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/refs#get-a-reference
        """

        from ..models import BasicError, GitRef

        url = f"/repos/{owner}/{repo}/git/ref/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GitRef,
            error_models={
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_get_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GitRef, GitRefTypeForResponse]:
        """git/get-ref

        GET /repos/{owner}/{repo}/git/ref/{ref}

        Returns a single reference from your Git database. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't match an existing ref, a `404` is returned.

        > [!NOTE]
        > You need to explicitly [request a pull request](https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/refs#get-a-reference
        """

        from ..models import BasicError, GitRef

        url = f"/repos/{owner}/{repo}/git/ref/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GitRef,
            error_models={
                "404": BasicError,
                "409": BasicError,
            },
        )

    @overload
    def create_ref(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoGitRefsPostBodyType,
    ) -> Response[GitRef, GitRefTypeForResponse]: ...

    @overload
    def create_ref(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        ref: str,
        sha: str,
    ) -> Response[GitRef, GitRefTypeForResponse]: ...

    def create_ref(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoGitRefsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GitRef, GitRefTypeForResponse]:
        """git/create-ref

        POST /repos/{owner}/{repo}/git/refs

        Creates a reference for your repository. You are unable to create new references for empty repositories, even if the commit SHA-1 hash used exists. Empty repositories are repositories without branches.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/refs#create-a-reference
        """

        from ..models import (
            BasicError,
            GitRef,
            ReposOwnerRepoGitRefsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/git/refs"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoGitRefsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GitRef,
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    @overload
    async def async_create_ref(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoGitRefsPostBodyType,
    ) -> Response[GitRef, GitRefTypeForResponse]: ...

    @overload
    async def async_create_ref(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        ref: str,
        sha: str,
    ) -> Response[GitRef, GitRefTypeForResponse]: ...

    async def async_create_ref(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoGitRefsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GitRef, GitRefTypeForResponse]:
        """git/create-ref

        POST /repos/{owner}/{repo}/git/refs

        Creates a reference for your repository. You are unable to create new references for empty repositories, even if the commit SHA-1 hash used exists. Empty repositories are repositories without branches.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/refs#create-a-reference
        """

        from ..models import (
            BasicError,
            GitRef,
            ReposOwnerRepoGitRefsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/git/refs"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoGitRefsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GitRef,
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    def delete_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """git/delete-ref

        DELETE /repos/{owner}/{repo}/git/refs/{ref}

        Deletes the provided reference.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/refs#delete-a-reference
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/git/refs/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "409": BasicError,
            },
        )

    async def async_delete_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """git/delete-ref

        DELETE /repos/{owner}/{repo}/git/refs/{ref}

        Deletes the provided reference.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/refs#delete-a-reference
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/git/refs/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "409": BasicError,
            },
        )

    @overload
    def update_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoGitRefsRefPatchBodyType,
    ) -> Response[GitRef, GitRefTypeForResponse]: ...

    @overload
    def update_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        sha: str,
        force: Missing[bool] = UNSET,
    ) -> Response[GitRef, GitRefTypeForResponse]: ...

    def update_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoGitRefsRefPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[GitRef, GitRefTypeForResponse]:
        """git/update-ref

        PATCH /repos/{owner}/{repo}/git/refs/{ref}

        Updates the provided reference to point to a new SHA. For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/refs#update-a-reference
        """

        from ..models import (
            BasicError,
            GitRef,
            ReposOwnerRepoGitRefsRefPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/git/refs/{ref}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoGitRefsRefPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GitRef,
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    @overload
    async def async_update_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoGitRefsRefPatchBodyType,
    ) -> Response[GitRef, GitRefTypeForResponse]: ...

    @overload
    async def async_update_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        sha: str,
        force: Missing[bool] = UNSET,
    ) -> Response[GitRef, GitRefTypeForResponse]: ...

    async def async_update_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoGitRefsRefPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[GitRef, GitRefTypeForResponse]:
        """git/update-ref

        PATCH /repos/{owner}/{repo}/git/refs/{ref}

        Updates the provided reference to point to a new SHA. For more information, see "[Git References](https://git-scm.com/book/en/v2/Git-Internals-Git-References)" in the Git documentation.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/refs#update-a-reference
        """

        from ..models import (
            BasicError,
            GitRef,
            ReposOwnerRepoGitRefsRefPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/git/refs/{ref}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoGitRefsRefPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GitRef,
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    @overload
    def create_tag(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoGitTagsPostBodyType,
    ) -> Response[GitTag, GitTagTypeForResponse]: ...

    @overload
    def create_tag(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        tag: str,
        message: str,
        object_: str,
        type: Literal["commit", "tree", "blob"],
        tagger: Missing[ReposOwnerRepoGitTagsPostBodyPropTaggerType] = UNSET,
    ) -> Response[GitTag, GitTagTypeForResponse]: ...

    def create_tag(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoGitTagsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GitTag, GitTagTypeForResponse]:
        """git/create-tag

        POST /repos/{owner}/{repo}/git/tags

        Note that creating a tag object does not create the reference that makes a tag in Git. If you want to create an annotated tag in Git, you have to do this call to create the tag object, and then [create](https://docs.github.com/enterprise-cloud@latest//rest/git/refs#create-a-reference) the `refs/tags/[tag]` reference. If you want to create a lightweight tag, you only have to [create](https://docs.github.com/enterprise-cloud@latest//rest/git/refs#create-a-reference) the tag reference - this call would be unnecessary.

        **Signature verification object**

        The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:

        | Name | Type | Description |
        | ---- | ---- | ----------- |
        | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
        | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
        | `signature` | `string` | The signature that was extracted from the commit. |
        | `payload` | `string` | The value that was signed. |
        | `verified_at` | `string` | The date the signature was verified by GitHub. |

        These are the possible values for `reason` in the `verification` object:

        | Value | Description |
        | ----- | ----------- |
        | `expired_key` | The key that made the signature is expired. |
        | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
        | `gpgverify_error` | There was an error communicating with the signature verification service. |
        | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
        | `unsigned` | The object does not include a signature. |
        | `unknown_signature_type` | A non-PGP signature was found in the commit. |
        | `no_user` | No user was associated with the `committer` email address in the commit. |
        | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
        | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
        | `unknown_key` | The key that made the signature has not been registered with any user's account. |
        | `malformed_signature` | There was an error parsing the signature. |
        | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
        | `valid` | None of the above errors applied, so the signature is considered to be verified. |

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/tags#create-a-tag-object
        """

        from ..models import (
            BasicError,
            GitTag,
            ReposOwnerRepoGitTagsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/git/tags"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoGitTagsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GitTag,
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    @overload
    async def async_create_tag(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoGitTagsPostBodyType,
    ) -> Response[GitTag, GitTagTypeForResponse]: ...

    @overload
    async def async_create_tag(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        tag: str,
        message: str,
        object_: str,
        type: Literal["commit", "tree", "blob"],
        tagger: Missing[ReposOwnerRepoGitTagsPostBodyPropTaggerType] = UNSET,
    ) -> Response[GitTag, GitTagTypeForResponse]: ...

    async def async_create_tag(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoGitTagsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GitTag, GitTagTypeForResponse]:
        """git/create-tag

        POST /repos/{owner}/{repo}/git/tags

        Note that creating a tag object does not create the reference that makes a tag in Git. If you want to create an annotated tag in Git, you have to do this call to create the tag object, and then [create](https://docs.github.com/enterprise-cloud@latest//rest/git/refs#create-a-reference) the `refs/tags/[tag]` reference. If you want to create a lightweight tag, you only have to [create](https://docs.github.com/enterprise-cloud@latest//rest/git/refs#create-a-reference) the tag reference - this call would be unnecessary.

        **Signature verification object**

        The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:

        | Name | Type | Description |
        | ---- | ---- | ----------- |
        | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
        | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
        | `signature` | `string` | The signature that was extracted from the commit. |
        | `payload` | `string` | The value that was signed. |
        | `verified_at` | `string` | The date the signature was verified by GitHub. |

        These are the possible values for `reason` in the `verification` object:

        | Value | Description |
        | ----- | ----------- |
        | `expired_key` | The key that made the signature is expired. |
        | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
        | `gpgverify_error` | There was an error communicating with the signature verification service. |
        | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
        | `unsigned` | The object does not include a signature. |
        | `unknown_signature_type` | A non-PGP signature was found in the commit. |
        | `no_user` | No user was associated with the `committer` email address in the commit. |
        | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
        | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
        | `unknown_key` | The key that made the signature has not been registered with any user's account. |
        | `malformed_signature` | There was an error parsing the signature. |
        | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
        | `valid` | None of the above errors applied, so the signature is considered to be verified. |

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/tags#create-a-tag-object
        """

        from ..models import (
            BasicError,
            GitTag,
            ReposOwnerRepoGitTagsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/git/tags"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoGitTagsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GitTag,
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    def get_tag(
        self,
        owner: str,
        repo: str,
        tag_sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GitTag, GitTagTypeForResponse]:
        """git/get-tag

        GET /repos/{owner}/{repo}/git/tags/{tag_sha}

        **Signature verification object**

        The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:

        | Name | Type | Description |
        | ---- | ---- | ----------- |
        | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
        | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
        | `signature` | `string` | The signature that was extracted from the commit. |
        | `payload` | `string` | The value that was signed. |
        | `verified_at` | `string` | The date the signature was verified by GitHub. |

        These are the possible values for `reason` in the `verification` object:

        | Value | Description |
        | ----- | ----------- |
        | `expired_key` | The key that made the signature is expired. |
        | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
        | `gpgverify_error` | There was an error communicating with the signature verification service. |
        | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
        | `unsigned` | The object does not include a signature. |
        | `unknown_signature_type` | A non-PGP signature was found in the commit. |
        | `no_user` | No user was associated with the `committer` email address in the commit. |
        | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
        | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
        | `unknown_key` | The key that made the signature has not been registered with any user's account. |
        | `malformed_signature` | There was an error parsing the signature. |
        | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
        | `valid` | None of the above errors applied, so the signature is considered to be verified. |

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/tags#get-a-tag
        """

        from ..models import BasicError, GitTag

        url = f"/repos/{owner}/{repo}/git/tags/{tag_sha}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GitTag,
            error_models={
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_get_tag(
        self,
        owner: str,
        repo: str,
        tag_sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GitTag, GitTagTypeForResponse]:
        """git/get-tag

        GET /repos/{owner}/{repo}/git/tags/{tag_sha}

        **Signature verification object**

        The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:

        | Name | Type | Description |
        | ---- | ---- | ----------- |
        | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
        | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
        | `signature` | `string` | The signature that was extracted from the commit. |
        | `payload` | `string` | The value that was signed. |
        | `verified_at` | `string` | The date the signature was verified by GitHub. |

        These are the possible values for `reason` in the `verification` object:

        | Value | Description |
        | ----- | ----------- |
        | `expired_key` | The key that made the signature is expired. |
        | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
        | `gpgverify_error` | There was an error communicating with the signature verification service. |
        | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
        | `unsigned` | The object does not include a signature. |
        | `unknown_signature_type` | A non-PGP signature was found in the commit. |
        | `no_user` | No user was associated with the `committer` email address in the commit. |
        | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
        | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
        | `unknown_key` | The key that made the signature has not been registered with any user's account. |
        | `malformed_signature` | There was an error parsing the signature. |
        | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
        | `valid` | None of the above errors applied, so the signature is considered to be verified. |

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/tags#get-a-tag
        """

        from ..models import BasicError, GitTag

        url = f"/repos/{owner}/{repo}/git/tags/{tag_sha}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GitTag,
            error_models={
                "404": BasicError,
                "409": BasicError,
            },
        )

    @overload
    def create_tree(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoGitTreesPostBodyType,
    ) -> Response[GitTree, GitTreeTypeForResponse]: ...

    @overload
    def create_tree(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        tree: list[ReposOwnerRepoGitTreesPostBodyPropTreeItemsType],
        base_tree: Missing[str] = UNSET,
    ) -> Response[GitTree, GitTreeTypeForResponse]: ...

    def create_tree(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoGitTreesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GitTree, GitTreeTypeForResponse]:
        """git/create-tree

        POST /repos/{owner}/{repo}/git/trees

        The tree creation API accepts nested entries. If you specify both a tree and a nested path modifying that tree, this endpoint will overwrite the contents of the tree with the new path contents, and create a new tree structure.

        If you use this endpoint to add, delete, or modify the file contents in a tree, you will need to commit the tree and then update a branch to point to the commit. For more information see "[Create a commit](https://docs.github.com/enterprise-cloud@latest//rest/git/commits#create-a-commit)" and "[Update a reference](https://docs.github.com/enterprise-cloud@latest//rest/git/refs#update-a-reference)."

        Returns an error if you try to delete a file that does not exist.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/trees#create-a-tree
        """

        from ..models import (
            BasicError,
            GitTree,
            ReposOwnerRepoGitTreesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/git/trees"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoGitTreesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GitTree,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "409": BasicError,
            },
        )

    @overload
    async def async_create_tree(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoGitTreesPostBodyType,
    ) -> Response[GitTree, GitTreeTypeForResponse]: ...

    @overload
    async def async_create_tree(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        tree: list[ReposOwnerRepoGitTreesPostBodyPropTreeItemsType],
        base_tree: Missing[str] = UNSET,
    ) -> Response[GitTree, GitTreeTypeForResponse]: ...

    async def async_create_tree(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoGitTreesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GitTree, GitTreeTypeForResponse]:
        """git/create-tree

        POST /repos/{owner}/{repo}/git/trees

        The tree creation API accepts nested entries. If you specify both a tree and a nested path modifying that tree, this endpoint will overwrite the contents of the tree with the new path contents, and create a new tree structure.

        If you use this endpoint to add, delete, or modify the file contents in a tree, you will need to commit the tree and then update a branch to point to the commit. For more information see "[Create a commit](https://docs.github.com/enterprise-cloud@latest//rest/git/commits#create-a-commit)" and "[Update a reference](https://docs.github.com/enterprise-cloud@latest//rest/git/refs#update-a-reference)."

        Returns an error if you try to delete a file that does not exist.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/trees#create-a-tree
        """

        from ..models import (
            BasicError,
            GitTree,
            ReposOwnerRepoGitTreesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/git/trees"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoGitTreesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GitTree,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "409": BasicError,
            },
        )

    def get_tree(
        self,
        owner: str,
        repo: str,
        tree_sha: str,
        *,
        recursive: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GitTree, GitTreeTypeForResponse]:
        """git/get-tree

        GET /repos/{owner}/{repo}/git/trees/{tree_sha}

        Returns a single tree using the SHA1 value or ref name for that tree.

        If `truncated` is `true` in the response then the number of items in the `tree` array exceeded our maximum limit. If you need to fetch more items, use the non-recursive method of fetching trees, and fetch one sub-tree at a time.

        > [!NOTE]
        > The limit for the `tree` array is 100,000 entries with a maximum size of 7 MB when using the `recursive` parameter.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/trees#get-a-tree
        """

        from ..models import BasicError, GitTree, ValidationError

        url = f"/repos/{owner}/{repo}/git/trees/{tree_sha}"

        params = {
            "recursive": recursive,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GitTree,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_get_tree(
        self,
        owner: str,
        repo: str,
        tree_sha: str,
        *,
        recursive: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GitTree, GitTreeTypeForResponse]:
        """git/get-tree

        GET /repos/{owner}/{repo}/git/trees/{tree_sha}

        Returns a single tree using the SHA1 value or ref name for that tree.

        If `truncated` is `true` in the response then the number of items in the `tree` array exceeded our maximum limit. If you need to fetch more items, use the non-recursive method of fetching trees, and fetch one sub-tree at a time.

        > [!NOTE]
        > The limit for the `tree` array is 100,000 entries with a maximum size of 7 MB when using the `recursive` parameter.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/git/trees#get-a-tree
        """

        from ..models import BasicError, GitTree, ValidationError

        url = f"/repos/{owner}/{repo}/git/trees/{tree_sha}"

        params = {
            "recursive": recursive,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GitTree,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
            },
        )
