"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from typing_extensions import deprecated
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset, parse_query_params

if TYPE_CHECKING:
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        ProjectCard,
        ProjectCollaboratorPermission,
        ProjectColumn,
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201,
        SimpleUser,
    )
    from ..types import (
        ProjectCardTypeForResponse,
        ProjectCollaboratorPermissionTypeForResponse,
        ProjectColumnTypeForResponse,
        ProjectsColumnsCardsCardIdMovesPostBodyType,
        ProjectsColumnsCardsCardIdMovesPostResponse201TypeForResponse,
        ProjectsColumnsCardsCardIdPatchBodyType,
        ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
        ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
        ProjectsColumnsColumnIdMovesPostBodyType,
        ProjectsColumnsColumnIdMovesPostResponse201TypeForResponse,
        ProjectsColumnsColumnIdPatchBodyType,
        ProjectsProjectIdCollaboratorsUsernamePutBodyType,
        SimpleUserTypeForResponse,
    )


class ProjectsClassicClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def get_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectCard, ProjectCardTypeForResponse]:
        """DEPRECATED projects-classic/get-card

        GET /projects/columns/cards/{card_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#get-a-project-card
        """

        from ..models import BasicError, ProjectCard

        url = f"/projects/columns/cards/{card_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_get_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectCard, ProjectCardTypeForResponse]:
        """DEPRECATED projects-classic/get-card

        GET /projects/columns/cards/{card_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#get-a-project-card
        """

        from ..models import BasicError, ProjectCard

        url = f"/projects/columns/cards/{card_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def delete_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED projects-classic/delete-card

        DELETE /projects/columns/cards/{card_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#delete-a-project-card
        """

        from ..models import BasicError, ProjectsColumnsCardsCardIdDeleteResponse403

        url = f"/projects/columns/cards/{card_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": ProjectsColumnsCardsCardIdDeleteResponse403,
                "401": BasicError,
                "404": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_delete_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED projects-classic/delete-card

        DELETE /projects/columns/cards/{card_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#delete-a-project-card
        """

        from ..models import BasicError, ProjectsColumnsCardsCardIdDeleteResponse403

        url = f"/projects/columns/cards/{card_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": ProjectsColumnsCardsCardIdDeleteResponse403,
                "401": BasicError,
                "404": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def update_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsCardsCardIdPatchBodyType] = UNSET,
    ) -> Response[ProjectCard, ProjectCardTypeForResponse]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def update_card(
        self,
        card_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        note: Missing[Union[str, None]] = UNSET,
        archived: Missing[bool] = UNSET,
    ) -> Response[ProjectCard, ProjectCardTypeForResponse]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def update_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsCardsCardIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectCard, ProjectCardTypeForResponse]:
        """DEPRECATED projects-classic/update-card

        PATCH /projects/columns/cards/{card_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#update-an-existing-project-card
        """

        from ..models import (
            BasicError,
            ProjectCard,
            ProjectsColumnsCardsCardIdPatchBody,
            ValidationErrorSimple,
        )

        url = f"/projects/columns/cards/{card_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsCardsCardIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_update_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsCardsCardIdPatchBodyType] = UNSET,
    ) -> Response[ProjectCard, ProjectCardTypeForResponse]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_update_card(
        self,
        card_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        note: Missing[Union[str, None]] = UNSET,
        archived: Missing[bool] = UNSET,
    ) -> Response[ProjectCard, ProjectCardTypeForResponse]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_update_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsCardsCardIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectCard, ProjectCardTypeForResponse]:
        """DEPRECATED projects-classic/update-card

        PATCH /projects/columns/cards/{card_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#update-an-existing-project-card
        """

        from ..models import (
            BasicError,
            ProjectCard,
            ProjectsColumnsCardsCardIdPatchBody,
            ValidationErrorSimple,
        )

        url = f"/projects/columns/cards/{card_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsCardsCardIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def move_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ProjectsColumnsCardsCardIdMovesPostBodyType,
    ) -> Response[
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsCardsCardIdMovesPostResponse201TypeForResponse,
    ]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def move_card(
        self,
        card_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        position: str,
        column_id: Missing[int] = UNSET,
    ) -> Response[
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsCardsCardIdMovesPostResponse201TypeForResponse,
    ]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def move_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsCardsCardIdMovesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsCardsCardIdMovesPostResponse201TypeForResponse,
    ]:
        """DEPRECATED projects-classic/move-card

        POST /projects/columns/cards/{card_id}/moves

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#move-a-project-card
        """

        from ..models import (
            BasicError,
            ProjectsColumnsCardsCardIdMovesPostBody,
            ProjectsColumnsCardsCardIdMovesPostResponse201,
            ProjectsColumnsCardsCardIdMovesPostResponse403,
            ProjectsColumnsCardsCardIdMovesPostResponse503,
            ValidationError,
        )

        url = f"/projects/columns/cards/{card_id}/moves"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsCardsCardIdMovesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsColumnsCardsCardIdMovesPostResponse201,
            error_models={
                "403": ProjectsColumnsCardsCardIdMovesPostResponse403,
                "401": BasicError,
                "503": ProjectsColumnsCardsCardIdMovesPostResponse503,
                "422": ValidationError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_move_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ProjectsColumnsCardsCardIdMovesPostBodyType,
    ) -> Response[
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsCardsCardIdMovesPostResponse201TypeForResponse,
    ]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_move_card(
        self,
        card_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        position: str,
        column_id: Missing[int] = UNSET,
    ) -> Response[
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsCardsCardIdMovesPostResponse201TypeForResponse,
    ]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_move_card(
        self,
        card_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsCardsCardIdMovesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsCardsCardIdMovesPostResponse201TypeForResponse,
    ]:
        """DEPRECATED projects-classic/move-card

        POST /projects/columns/cards/{card_id}/moves

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#move-a-project-card
        """

        from ..models import (
            BasicError,
            ProjectsColumnsCardsCardIdMovesPostBody,
            ProjectsColumnsCardsCardIdMovesPostResponse201,
            ProjectsColumnsCardsCardIdMovesPostResponse403,
            ProjectsColumnsCardsCardIdMovesPostResponse503,
            ValidationError,
        )

        url = f"/projects/columns/cards/{card_id}/moves"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsCardsCardIdMovesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsColumnsCardsCardIdMovesPostResponse201,
            error_models={
                "403": ProjectsColumnsCardsCardIdMovesPostResponse403,
                "401": BasicError,
                "503": ProjectsColumnsCardsCardIdMovesPostResponse503,
                "422": ValidationError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def get_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectColumn, ProjectColumnTypeForResponse]:
        """DEPRECATED projects-classic/get-column

        GET /projects/columns/{column_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/columns#get-a-project-column
        """

        from ..models import BasicError, ProjectColumn

        url = f"/projects/columns/{column_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "401": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_get_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectColumn, ProjectColumnTypeForResponse]:
        """DEPRECATED projects-classic/get-column

        GET /projects/columns/{column_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/columns#get-a-project-column
        """

        from ..models import BasicError, ProjectColumn

        url = f"/projects/columns/{column_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "401": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def delete_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED projects-classic/delete-column

        DELETE /projects/columns/{column_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/columns#delete-a-project-column
        """

        from ..models import BasicError

        url = f"/projects/columns/{column_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_delete_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED projects-classic/delete-column

        DELETE /projects/columns/{column_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/columns#delete-a-project-column
        """

        from ..models import BasicError

        url = f"/projects/columns/{column_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def update_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ProjectsColumnsColumnIdPatchBodyType,
    ) -> Response[ProjectColumn, ProjectColumnTypeForResponse]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def update_column(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
    ) -> Response[ProjectColumn, ProjectColumnTypeForResponse]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def update_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsColumnIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectColumn, ProjectColumnTypeForResponse]:
        """DEPRECATED projects-classic/update-column

        PATCH /projects/columns/{column_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/columns#update-an-existing-project-column
        """

        from ..models import BasicError, ProjectColumn, ProjectsColumnsColumnIdPatchBody

        url = f"/projects/columns/{column_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsColumnIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_update_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ProjectsColumnsColumnIdPatchBodyType,
    ) -> Response[ProjectColumn, ProjectColumnTypeForResponse]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_update_column(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
    ) -> Response[ProjectColumn, ProjectColumnTypeForResponse]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_update_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsColumnIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectColumn, ProjectColumnTypeForResponse]:
        """DEPRECATED projects-classic/update-column

        PATCH /projects/columns/{column_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/columns#update-an-existing-project-column
        """

        from ..models import BasicError, ProjectColumn, ProjectsColumnsColumnIdPatchBody

        url = f"/projects/columns/{column_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsColumnIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def list_cards(
        self,
        column_id: int,
        *,
        archived_state: Missing[Literal["all", "archived", "not_archived"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectCard], list[ProjectCardTypeForResponse]]:
        """DEPRECATED projects-classic/list-cards

        GET /projects/columns/{column_id}/cards

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#list-project-cards
        """

        from ..models import BasicError, ProjectCard

        url = f"/projects/columns/{column_id}/cards"

        params = {
            "archived_state": archived_state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectCard],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_list_cards(
        self,
        column_id: int,
        *,
        archived_state: Missing[Literal["all", "archived", "not_archived"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectCard], list[ProjectCardTypeForResponse]]:
        """DEPRECATED projects-classic/list-cards

        GET /projects/columns/{column_id}/cards

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#list-project-cards
        """

        from ..models import BasicError, ProjectCard

        url = f"/projects/columns/{column_id}/cards"

        params = {
            "archived_state": archived_state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectCard],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def create_card(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
            ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
        ],
    ) -> Response[ProjectCard, ProjectCardTypeForResponse]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def create_card(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        note: Union[str, None],
    ) -> Response[ProjectCard, ProjectCardTypeForResponse]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def create_card(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content_id: int,
        content_type: str,
    ) -> Response[ProjectCard, ProjectCardTypeForResponse]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def create_card(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
                ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[ProjectCard, ProjectCardTypeForResponse]:
        """DEPRECATED projects-classic/create-card

        POST /projects/columns/{column_id}/cards

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#create-a-project-card
        """

        from typing import Union

        from ..models import (
            BasicError,
            ProjectCard,
            ProjectsColumnsColumnIdCardsPostBodyOneof0,
            ProjectsColumnsColumnIdCardsPostBodyOneof1,
            ProjectsColumnsColumnIdCardsPostResponse503,
            ValidationError,
            ValidationErrorSimple,
        )

        url = f"/projects/columns/{column_id}/cards"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ProjectsColumnsColumnIdCardsPostBodyOneof0,
                    ProjectsColumnsColumnIdCardsPostBodyOneof1,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": Union[ValidationError, ValidationErrorSimple],
                "503": ProjectsColumnsColumnIdCardsPostResponse503,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_create_card(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
            ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
        ],
    ) -> Response[ProjectCard, ProjectCardTypeForResponse]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_create_card(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        note: Union[str, None],
    ) -> Response[ProjectCard, ProjectCardTypeForResponse]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_create_card(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        content_id: int,
        content_type: str,
    ) -> Response[ProjectCard, ProjectCardTypeForResponse]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_create_card(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
                ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[ProjectCard, ProjectCardTypeForResponse]:
        """DEPRECATED projects-classic/create-card

        POST /projects/columns/{column_id}/cards

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/cards#create-a-project-card
        """

        from typing import Union

        from ..models import (
            BasicError,
            ProjectCard,
            ProjectsColumnsColumnIdCardsPostBodyOneof0,
            ProjectsColumnsColumnIdCardsPostBodyOneof1,
            ProjectsColumnsColumnIdCardsPostResponse503,
            ValidationError,
            ValidationErrorSimple,
        )

        url = f"/projects/columns/{column_id}/cards"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ProjectsColumnsColumnIdCardsPostBodyOneof0,
                    ProjectsColumnsColumnIdCardsPostBodyOneof1,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": Union[ValidationError, ValidationErrorSimple],
                "503": ProjectsColumnsColumnIdCardsPostResponse503,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def move_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ProjectsColumnsColumnIdMovesPostBodyType,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201TypeForResponse,
    ]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def move_column(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        position: str,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201TypeForResponse,
    ]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def move_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsColumnIdMovesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201TypeForResponse,
    ]:
        """DEPRECATED projects-classic/move-column

        POST /projects/columns/{column_id}/moves

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/columns#move-a-project-column
        """

        from ..models import (
            BasicError,
            ProjectsColumnsColumnIdMovesPostBody,
            ProjectsColumnsColumnIdMovesPostResponse201,
            ValidationErrorSimple,
        )

        url = f"/projects/columns/{column_id}/moves"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsColumnIdMovesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsColumnsColumnIdMovesPostResponse201,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "401": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_move_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ProjectsColumnsColumnIdMovesPostBodyType,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201TypeForResponse,
    ]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_move_column(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        position: str,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201TypeForResponse,
    ]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_move_column(
        self,
        column_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ProjectsColumnsColumnIdMovesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201TypeForResponse,
    ]:
        """DEPRECATED projects-classic/move-column

        POST /projects/columns/{column_id}/moves

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/columns#move-a-project-column
        """

        from ..models import (
            BasicError,
            ProjectsColumnsColumnIdMovesPostBody,
            ProjectsColumnsColumnIdMovesPostResponse201,
            ValidationErrorSimple,
        )

        url = f"/projects/columns/{column_id}/moves"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsColumnIdMovesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsColumnsColumnIdMovesPostResponse201,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "401": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def list_collaborators(
        self,
        project_id: int,
        *,
        affiliation: Missing[Literal["outside", "direct", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SimpleUser], list[SimpleUserTypeForResponse]]:
        """DEPRECATED projects-classic/list-collaborators

        GET /projects/{project_id}/collaborators

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/collaborators#list-project-collaborators
        """

        from ..models import BasicError, SimpleUser, ValidationError

        url = f"/projects/{project_id}/collaborators"

        params = {
            "affiliation": affiliation,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_list_collaborators(
        self,
        project_id: int,
        *,
        affiliation: Missing[Literal["outside", "direct", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SimpleUser], list[SimpleUserTypeForResponse]]:
        """DEPRECATED projects-classic/list-collaborators

        GET /projects/{project_id}/collaborators

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/collaborators#list-project-collaborators
        """

        from ..models import BasicError, SimpleUser, ValidationError

        url = f"/projects/{project_id}/collaborators"

        params = {
            "affiliation": affiliation,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
    ) -> Response: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> Response: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED projects-classic/add-collaborator

        PUT /projects/{project_id}/collaborators/{username}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/collaborators#add-project-collaborator
        """

        from typing import Union

        from ..models import (
            BasicError,
            ProjectsProjectIdCollaboratorsUsernamePutBody,
            ValidationError,
        )

        url = f"/projects/{project_id}/collaborators/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ProjectsProjectIdCollaboratorsUsernamePutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
    ) -> Response: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> Response: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED projects-classic/add-collaborator

        PUT /projects/{project_id}/collaborators/{username}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/collaborators#add-project-collaborator
        """

        from typing import Union

        from ..models import (
            BasicError,
            ProjectsProjectIdCollaboratorsUsernamePutBody,
            ValidationError,
        )

        url = f"/projects/{project_id}/collaborators/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ProjectsProjectIdCollaboratorsUsernamePutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def remove_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED projects-classic/remove-collaborator

        DELETE /projects/{project_id}/collaborators/{username}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/collaborators#remove-user-as-a-collaborator
        """

        from ..models import BasicError, ValidationError

        url = f"/projects/{project_id}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "401": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_remove_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED projects-classic/remove-collaborator

        DELETE /projects/{project_id}/collaborators/{username}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/collaborators#remove-user-as-a-collaborator
        """

        from ..models import BasicError, ValidationError

        url = f"/projects/{project_id}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "401": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def get_permission_for_user(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ProjectCollaboratorPermission, ProjectCollaboratorPermissionTypeForResponse
    ]:
        """DEPRECATED projects-classic/get-permission-for-user

        GET /projects/{project_id}/collaborators/{username}/permission

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/collaborators#get-project-permission-for-a-user
        """

        from ..models import BasicError, ProjectCollaboratorPermission, ValidationError

        url = f"/projects/{project_id}/collaborators/{username}/permission"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectCollaboratorPermission,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_get_permission_for_user(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ProjectCollaboratorPermission, ProjectCollaboratorPermissionTypeForResponse
    ]:
        """DEPRECATED projects-classic/get-permission-for-user

        GET /projects/{project_id}/collaborators/{username}/permission

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects-classic/collaborators#get-project-permission-for-a-user
        """

        from ..models import BasicError, ProjectCollaboratorPermission, ValidationError

        url = f"/projects/{project_id}/collaborators/{username}/permission"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectCollaboratorPermission,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )
