"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

import datetime as _dt
from typing import Literal, Union

from pydantic import Field

from githubkit.compat import GitHubModel, model_rebuild
from githubkit.typing import Missing
from githubkit.utils import UNSET

from .group_0003 import SimpleUser


class ProjectsV2Item(GitHubModel):
    """Projects v2 Item

    An item belonging to a project
    """

    id: float = Field(description="The unique identifier of the project item.")
    node_id: Missing[str] = Field(
        default=UNSET, description="The node ID of the project item."
    )
    project_node_id: Missing[str] = Field(
        default=UNSET, description="The node ID of the project that contains this item."
    )
    content_node_id: str = Field(
        description="The node ID of the content represented by this item."
    )
    content_type: Literal["Issue", "PullRequest", "DraftIssue"] = Field(
        title="Projects v2 Item Content Type",
        description="The type of content tracked in a project item",
    )
    creator: Missing[SimpleUser] = Field(
        default=UNSET, title="Simple User", description="A GitHub user."
    )
    created_at: _dt.datetime = Field(description="The time when the item was created.")
    updated_at: _dt.datetime = Field(
        description="The time when the item was last updated."
    )
    archived_at: Union[_dt.datetime, None] = Field(
        description="The time when the item was archived."
    )


model_rebuild(ProjectsV2Item)

__all__ = ("ProjectsV2Item",)
