"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset, parse_query_params

if TYPE_CHECKING:
    from typing import Literal

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        AdvancedSecurityActiveCommitters,
        BillingPremiumRequestUsageReportGhe,
        BillingUsageReport,
        BillingUsageSummaryReportGhe,
        CreateBudget,
        DeleteBudget,
        DeleteCostCenter,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
        GetAllBudgets,
        GetAllCostCenters,
        GetBudget,
        GetCostCenter,
        UpdateBudget,
    )
    from ..types import (
        AdvancedSecurityActiveCommittersTypeForResponse,
        BillingPremiumRequestUsageReportGheTypeForResponse,
        BillingUsageReportTypeForResponse,
        BillingUsageSummaryReportGheTypeForResponse,
        CreateBudgetTypeForResponse,
        DeleteBudgetTypeForResponse,
        DeleteCostCenterTypeForResponse,
        EnterprisesEnterpriseSettingsBillingBudgetsBudgetIdPatchBodyPropBudgetAlertingType,
        EnterprisesEnterpriseSettingsBillingBudgetsBudgetIdPatchBodyType,
        EnterprisesEnterpriseSettingsBillingBudgetsPostBodyPropBudgetAlertingType,
        EnterprisesEnterpriseSettingsBillingBudgetsPostBodyType,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdPatchBodyType,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBodyType,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200TypeForResponse,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBodyType,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200TypeForResponse,
        EnterprisesEnterpriseSettingsBillingCostCentersPostBodyType,
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200TypeForResponse,
        GetAllBudgetsTypeForResponse,
        GetAllCostCentersTypeForResponse,
        GetBudgetTypeForResponse,
        GetCostCenterTypeForResponse,
        UpdateBudgetTypeForResponse,
    )


class BillingClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def get_github_advanced_security_billing_ghe(
        self,
        enterprise: str,
        *,
        advanced_security_product: Missing[
            Literal["code_security", "secret_protection"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        AdvancedSecurityActiveCommitters,
        AdvancedSecurityActiveCommittersTypeForResponse,
    ]:
        """billing/get-github-advanced-security-billing-ghe

        GET /enterprises/{enterprise}/settings/billing/advanced-security

        Gets the GitHub Advanced Security active committers for an enterprise per repository. The authenticated user must be an enterprise admin or billing manager.

        Each distinct user login across all repositories is counted as a single Advanced Security seat, so the `total_advanced_security_committers` is not the sum of active_users for each repository.

        The total number of repositories with committer information is tracked by the `total_count` field.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/licensing#get-github-advanced-security-active-committers-for-an-enterprise
        """

        from ..models import AdvancedSecurityActiveCommitters

        url = f"/enterprises/{enterprise}/settings/billing/advanced-security"

        params = {
            "advanced_security_product": advanced_security_product,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AdvancedSecurityActiveCommitters,
        )

    async def async_get_github_advanced_security_billing_ghe(
        self,
        enterprise: str,
        *,
        advanced_security_product: Missing[
            Literal["code_security", "secret_protection"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        AdvancedSecurityActiveCommitters,
        AdvancedSecurityActiveCommittersTypeForResponse,
    ]:
        """billing/get-github-advanced-security-billing-ghe

        GET /enterprises/{enterprise}/settings/billing/advanced-security

        Gets the GitHub Advanced Security active committers for an enterprise per repository. The authenticated user must be an enterprise admin or billing manager.

        Each distinct user login across all repositories is counted as a single Advanced Security seat, so the `total_advanced_security_committers` is not the sum of active_users for each repository.

        The total number of repositories with committer information is tracked by the `total_count` field.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/licensing#get-github-advanced-security-active-committers-for-an-enterprise
        """

        from ..models import AdvancedSecurityActiveCommitters

        url = f"/enterprises/{enterprise}/settings/billing/advanced-security"

        params = {
            "advanced_security_product": advanced_security_product,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AdvancedSecurityActiveCommitters,
        )

    def get_all_budgets(
        self,
        enterprise: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        page_size: Missing[int] = UNSET,
        scope: Missing[
            Literal["enterprise", "organization", "repository", "cost-center"]
        ] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GetAllBudgets, GetAllBudgetsTypeForResponse]:
        """billing/get-all-budgets

        GET /enterprises/{enterprise}/settings/billing/budgets

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Gets all budgets for an enterprise. The authenticated user must be an enterprise admin or billing manager.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/budgets#get-all-budgets
        """

        from ..models import BasicError, GetAllBudgets

        url = f"/enterprises/{enterprise}/settings/billing/budgets"

        params = {
            "page": page,
            "per_page": per_page,
            "page_size": page_size,
            "scope": scope,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetAllBudgets,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_get_all_budgets(
        self,
        enterprise: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        page_size: Missing[int] = UNSET,
        scope: Missing[
            Literal["enterprise", "organization", "repository", "cost-center"]
        ] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GetAllBudgets, GetAllBudgetsTypeForResponse]:
        """billing/get-all-budgets

        GET /enterprises/{enterprise}/settings/billing/budgets

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Gets all budgets for an enterprise. The authenticated user must be an enterprise admin or billing manager.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/budgets#get-all-budgets
        """

        from ..models import BasicError, GetAllBudgets

        url = f"/enterprises/{enterprise}/settings/billing/budgets"

        params = {
            "page": page,
            "per_page": per_page,
            "page_size": page_size,
            "scope": scope,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetAllBudgets,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def create_budget(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseSettingsBillingBudgetsPostBodyType,
    ) -> Response[CreateBudget, CreateBudgetTypeForResponse]: ...

    @overload
    def create_budget(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        budget_amount: int,
        prevent_further_usage: bool,
        budget_alerting: EnterprisesEnterpriseSettingsBillingBudgetsPostBodyPropBudgetAlertingType,
        budget_scope: Literal[
            "enterprise", "organization", "repository", "cost_center"
        ],
        budget_entity_name: Missing[str] = UNSET,
        budget_type: Literal["ProductPricing", "SkuPricing"],
        budget_product_sku: Missing[str] = UNSET,
    ) -> Response[CreateBudget, CreateBudgetTypeForResponse]: ...

    def create_budget(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[EnterprisesEnterpriseSettingsBillingBudgetsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[CreateBudget, CreateBudgetTypeForResponse]:
        """billing/create-budget

        POST /enterprises/{enterprise}/settings/billing/budgets

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Creates a new budget for an enterprise. The authenticated user must be an enterprise admin, organization admin, or billing manager of the enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/budgets#create-a-budget
        """

        from ..models import (
            BasicError,
            CreateBudget,
            EnterprisesEnterpriseSettingsBillingBudgetsPostBody,
            ValidationError,
        )

        url = f"/enterprises/{enterprise}/settings/billing/budgets"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingBudgetsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CreateBudget,
            error_models={
                "400": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    @overload
    async def async_create_budget(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseSettingsBillingBudgetsPostBodyType,
    ) -> Response[CreateBudget, CreateBudgetTypeForResponse]: ...

    @overload
    async def async_create_budget(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        budget_amount: int,
        prevent_further_usage: bool,
        budget_alerting: EnterprisesEnterpriseSettingsBillingBudgetsPostBodyPropBudgetAlertingType,
        budget_scope: Literal[
            "enterprise", "organization", "repository", "cost_center"
        ],
        budget_entity_name: Missing[str] = UNSET,
        budget_type: Literal["ProductPricing", "SkuPricing"],
        budget_product_sku: Missing[str] = UNSET,
    ) -> Response[CreateBudget, CreateBudgetTypeForResponse]: ...

    async def async_create_budget(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[EnterprisesEnterpriseSettingsBillingBudgetsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[CreateBudget, CreateBudgetTypeForResponse]:
        """billing/create-budget

        POST /enterprises/{enterprise}/settings/billing/budgets

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Creates a new budget for an enterprise. The authenticated user must be an enterprise admin, organization admin, or billing manager of the enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/budgets#create-a-budget
        """

        from ..models import (
            BasicError,
            CreateBudget,
            EnterprisesEnterpriseSettingsBillingBudgetsPostBody,
            ValidationError,
        )

        url = f"/enterprises/{enterprise}/settings/billing/budgets"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingBudgetsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CreateBudget,
            error_models={
                "400": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    def get_budget(
        self,
        enterprise: str,
        budget_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GetBudget, GetBudgetTypeForResponse]:
        """billing/get-budget

        GET /enterprises/{enterprise}/settings/billing/budgets/{budget_id}

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Gets a budget by ID. The authenticated user must be an enterprise admin or billing manager.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/budgets#get-a-budget-by-id
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            GetBudget,
        )

        url = f"/enterprises/{enterprise}/settings/billing/budgets/{budget_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetBudget,
            error_models={
                "400": BasicError,
                "404": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_budget(
        self,
        enterprise: str,
        budget_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GetBudget, GetBudgetTypeForResponse]:
        """billing/get-budget

        GET /enterprises/{enterprise}/settings/billing/budgets/{budget_id}

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Gets a budget by ID. The authenticated user must be an enterprise admin or billing manager.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/budgets#get-a-budget-by-id
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            GetBudget,
        )

        url = f"/enterprises/{enterprise}/settings/billing/budgets/{budget_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetBudget,
            error_models={
                "400": BasicError,
                "404": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def delete_budget(
        self,
        enterprise: str,
        budget_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DeleteBudget, DeleteBudgetTypeForResponse]:
        """billing/delete-budget

        DELETE /enterprises/{enterprise}/settings/billing/budgets/{budget_id}

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Deletes a budget by ID. The authenticated user must be an enterprise admin.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/budgets#delete-a-budget
        """

        from ..models import (
            BasicError,
            DeleteBudget,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/enterprises/{enterprise}/settings/billing/budgets/{budget_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeleteBudget,
            error_models={
                "400": BasicError,
                "404": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_delete_budget(
        self,
        enterprise: str,
        budget_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DeleteBudget, DeleteBudgetTypeForResponse]:
        """billing/delete-budget

        DELETE /enterprises/{enterprise}/settings/billing/budgets/{budget_id}

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Deletes a budget by ID. The authenticated user must be an enterprise admin.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/budgets#delete-a-budget
        """

        from ..models import (
            BasicError,
            DeleteBudget,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/enterprises/{enterprise}/settings/billing/budgets/{budget_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeleteBudget,
            error_models={
                "400": BasicError,
                "404": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def update_budget(
        self,
        enterprise: str,
        budget_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseSettingsBillingBudgetsBudgetIdPatchBodyType,
    ) -> Response[UpdateBudget, UpdateBudgetTypeForResponse]: ...

    @overload
    def update_budget(
        self,
        enterprise: str,
        budget_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        budget_amount: Missing[int] = UNSET,
        prevent_further_usage: Missing[bool] = UNSET,
        budget_alerting: Missing[
            EnterprisesEnterpriseSettingsBillingBudgetsBudgetIdPatchBodyPropBudgetAlertingType
        ] = UNSET,
        budget_scope: Missing[
            Literal["enterprise", "organization", "repository", "cost_center"]
        ] = UNSET,
        budget_entity_name: Missing[str] = UNSET,
        budget_type: Missing[Literal["ProductPricing", "SkuPricing"]] = UNSET,
        budget_product_sku: Missing[str] = UNSET,
    ) -> Response[UpdateBudget, UpdateBudgetTypeForResponse]: ...

    def update_budget(
        self,
        enterprise: str,
        budget_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingBudgetsBudgetIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[UpdateBudget, UpdateBudgetTypeForResponse]:
        """billing/update-budget

        PATCH /enterprises/{enterprise}/settings/billing/budgets/{budget_id}

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Updates an existing budget for an enterprise. The authenticated user must be an enterprise admin, organization admin, or billing manager of the enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/budgets#update-a-budget
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseSettingsBillingBudgetsBudgetIdPatchBody,
            UpdateBudget,
            ValidationError,
        )

        url = f"/enterprises/{enterprise}/settings/billing/budgets/{budget_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingBudgetsBudgetIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=UpdateBudget,
            error_models={
                "400": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
                "500": BasicError,
                "503": BasicError,
            },
        )

    @overload
    async def async_update_budget(
        self,
        enterprise: str,
        budget_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseSettingsBillingBudgetsBudgetIdPatchBodyType,
    ) -> Response[UpdateBudget, UpdateBudgetTypeForResponse]: ...

    @overload
    async def async_update_budget(
        self,
        enterprise: str,
        budget_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        budget_amount: Missing[int] = UNSET,
        prevent_further_usage: Missing[bool] = UNSET,
        budget_alerting: Missing[
            EnterprisesEnterpriseSettingsBillingBudgetsBudgetIdPatchBodyPropBudgetAlertingType
        ] = UNSET,
        budget_scope: Missing[
            Literal["enterprise", "organization", "repository", "cost_center"]
        ] = UNSET,
        budget_entity_name: Missing[str] = UNSET,
        budget_type: Missing[Literal["ProductPricing", "SkuPricing"]] = UNSET,
        budget_product_sku: Missing[str] = UNSET,
    ) -> Response[UpdateBudget, UpdateBudgetTypeForResponse]: ...

    async def async_update_budget(
        self,
        enterprise: str,
        budget_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingBudgetsBudgetIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[UpdateBudget, UpdateBudgetTypeForResponse]:
        """billing/update-budget

        PATCH /enterprises/{enterprise}/settings/billing/budgets/{budget_id}

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Updates an existing budget for an enterprise. The authenticated user must be an enterprise admin, organization admin, or billing manager of the enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/budgets#update-a-budget
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseSettingsBillingBudgetsBudgetIdPatchBody,
            UpdateBudget,
            ValidationError,
        )

        url = f"/enterprises/{enterprise}/settings/billing/budgets/{budget_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingBudgetsBudgetIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=UpdateBudget,
            error_models={
                "400": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
                "500": BasicError,
                "503": BasicError,
            },
        )

    def get_all_cost_centers(
        self,
        enterprise: str,
        *,
        state: Missing[Literal["active", "deleted"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GetAllCostCenters, GetAllCostCentersTypeForResponse]:
        """billing/get-all-cost-centers

        GET /enterprises/{enterprise}/settings/billing/cost-centers

        Gets a list of all the cost centers for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/cost-centers#get-all-cost-centers-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            GetAllCostCenters,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers"

        params = {
            "state": state,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetAllCostCenters,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_all_cost_centers(
        self,
        enterprise: str,
        *,
        state: Missing[Literal["active", "deleted"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GetAllCostCenters, GetAllCostCentersTypeForResponse]:
        """billing/get-all-cost-centers

        GET /enterprises/{enterprise}/settings/billing/cost-centers

        Gets a list of all the cost centers for an enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/cost-centers#get-all-cost-centers-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            GetAllCostCenters,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers"

        params = {
            "state": state,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetAllCostCenters,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def create_cost_center(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseSettingsBillingCostCentersPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200TypeForResponse,
    ]: ...

    @overload
    def create_cost_center(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200TypeForResponse,
    ]: ...

    def create_cost_center(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingCostCentersPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200TypeForResponse,
    ]:
        """billing/create-cost-center

        POST /enterprises/{enterprise}/settings/billing/cost-centers

        Creates a new cost center for an enterprise. The authenticated user must be an enterprise admin.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/cost-centers#create-a-new-cost-center
        """

        from ..models import (
            EnterprisesEnterpriseSettingsBillingCostCentersPostBody,
            EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingCostCentersPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
            error_models={},
        )

    @overload
    async def async_create_cost_center(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseSettingsBillingCostCentersPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200TypeForResponse,
    ]: ...

    @overload
    async def async_create_cost_center(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200TypeForResponse,
    ]: ...

    async def async_create_cost_center(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingCostCentersPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200TypeForResponse,
    ]:
        """billing/create-cost-center

        POST /enterprises/{enterprise}/settings/billing/cost-centers

        Creates a new cost center for an enterprise. The authenticated user must be an enterprise admin.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/cost-centers#create-a-new-cost-center
        """

        from ..models import (
            EnterprisesEnterpriseSettingsBillingCostCentersPostBody,
            EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingCostCentersPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseSettingsBillingCostCentersPostResponse200,
            error_models={},
        )

    def get_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GetCostCenter, GetCostCenterTypeForResponse]:
        """billing/get-cost-center

        GET /enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}

        Gets a cost center by ID. The authenticated user must be an enterprise admin.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/cost-centers#get-a-cost-center-by-id
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            GetCostCenter,
        )

        url = (
            f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetCostCenter,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[GetCostCenter, GetCostCenterTypeForResponse]:
        """billing/get-cost-center

        GET /enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}

        Gets a cost center by ID. The authenticated user must be an enterprise admin.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/cost-centers#get-a-cost-center-by-id
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            GetCostCenter,
        )

        url = (
            f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetCostCenter,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def delete_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DeleteCostCenter, DeleteCostCenterTypeForResponse]:
        """billing/delete-cost-center

        DELETE /enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}

        Archieves a cost center by ID. The authenticated user must be an enterprise admin.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/cost-centers#delete-a-cost-center
        """

        from ..models import (
            BasicError,
            DeleteCostCenter,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = (
            f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeleteCostCenter,
            error_models={
                "400": BasicError,
                "404": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_delete_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DeleteCostCenter, DeleteCostCenterTypeForResponse]:
        """billing/delete-cost-center

        DELETE /enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}

        Archieves a cost center by ID. The authenticated user must be an enterprise admin.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/cost-centers#delete-a-cost-center
        """

        from ..models import (
            BasicError,
            DeleteCostCenter,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = (
            f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeleteCostCenter,
            error_models={
                "400": BasicError,
                "404": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def update_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdPatchBodyType,
    ) -> Response[GetCostCenter, GetCostCenterTypeForResponse]: ...

    @overload
    def update_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
    ) -> Response[GetCostCenter, GetCostCenterTypeForResponse]: ...

    def update_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[GetCostCenter, GetCostCenterTypeForResponse]:
        """billing/update-cost-center

        PATCH /enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}

        Updates an existing cost center name.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/cost-centers#update-a-cost-center-name
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdPatchBody,
            GetCostCenter,
        )

        url = (
            f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetCostCenter,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_update_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdPatchBodyType,
    ) -> Response[GetCostCenter, GetCostCenterTypeForResponse]: ...

    @overload
    async def async_update_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
    ) -> Response[GetCostCenter, GetCostCenterTypeForResponse]: ...

    async def async_update_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[GetCostCenter, GetCostCenterTypeForResponse]:
        """billing/update-cost-center

        PATCH /enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}

        Updates an existing cost center name.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/cost-centers#update-a-cost-center-name
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdPatchBody,
            GetCostCenter,
        )

        url = (
            f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=GetCostCenter,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def add_resource_to_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBodyType,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200TypeForResponse,
    ]: ...

    @overload
    def add_resource_to_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        users: Missing[list[str]] = UNSET,
        organizations: Missing[list[str]] = UNSET,
        repositories: Missing[list[str]] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200TypeForResponse,
    ]: ...

    def add_resource_to_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200TypeForResponse,
    ]:
        """billing/add-resource-to-cost-center

        POST /enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}/resource

        Adds resources to a cost center.

        The usage for the resources will be charged to the cost center's budget. The authenticated user must be an enterprise admin in order to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/cost-centers#add-resources-to-a-cost-center
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBody,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}/resource"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "409": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_add_resource_to_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBodyType,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200TypeForResponse,
    ]: ...

    @overload
    async def async_add_resource_to_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        users: Missing[list[str]] = UNSET,
        organizations: Missing[list[str]] = UNSET,
        repositories: Missing[list[str]] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200TypeForResponse,
    ]: ...

    async def async_add_resource_to_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200TypeForResponse,
    ]:
        """billing/add-resource-to-cost-center

        POST /enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}/resource

        Adds resources to a cost center.

        The usage for the resources will be charged to the cost center's budget. The authenticated user must be an enterprise admin in order to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/cost-centers#add-resources-to-a-cost-center
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBody,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}/resource"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "409": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def remove_resource_from_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBodyType,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200TypeForResponse,
    ]: ...

    @overload
    def remove_resource_from_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        users: Missing[list[str]] = UNSET,
        organizations: Missing[list[str]] = UNSET,
        repositories: Missing[list[str]] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200TypeForResponse,
    ]: ...

    def remove_resource_from_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200TypeForResponse,
    ]:
        """billing/remove-resource-from-cost-center

        DELETE /enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}/resource

        Remove resources from a cost center.

        The usage for the resources will no longer be charged to the cost center's budget. The authenticated user must be an enterprise admin in order to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/cost-centers#remove-resources-from-a-cost-center
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBody,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}/resource"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_remove_resource_from_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBodyType,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200TypeForResponse,
    ]: ...

    @overload
    async def async_remove_resource_from_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        users: Missing[list[str]] = UNSET,
        organizations: Missing[list[str]] = UNSET,
        repositories: Missing[list[str]] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200TypeForResponse,
    ]: ...

    async def async_remove_resource_from_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200TypeForResponse,
    ]:
        """billing/remove-resource-from-cost-center

        DELETE /enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}/resource

        Remove resources from a cost center.

        The usage for the resources will no longer be charged to the cost center's budget. The authenticated user must be an enterprise admin in order to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/cost-centers#remove-resources-from-a-cost-center
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBody,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}/resource"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_github_billing_premium_request_usage_report_ghe(
        self,
        enterprise: str,
        *,
        year: Missing[int] = UNSET,
        month: Missing[int] = UNSET,
        day: Missing[int] = UNSET,
        organization: Missing[str] = UNSET,
        user: Missing[str] = UNSET,
        model: Missing[str] = UNSET,
        product: Missing[str] = UNSET,
        cost_center_id: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        BillingPremiumRequestUsageReportGhe,
        BillingPremiumRequestUsageReportGheTypeForResponse,
    ]:
        """billing/get-github-billing-premium-request-usage-report-ghe

        GET /enterprises/{enterprise}/settings/billing/premium_request/usage

        Gets a report of premium request usage for an enterprise. To use this endpoint, you must be an administrator or billing manager of the enterprise.

        **Note:** Only data from the past 24 months is accessible via this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/usage#get-billing-premium-request-usage-report-for-an-enterprise
        """

        from ..models import (
            BasicError,
            BillingPremiumRequestUsageReportGhe,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/enterprises/{enterprise}/settings/billing/premium_request/usage"

        params = {
            "year": year,
            "month": month,
            "day": day,
            "organization": organization,
            "user": user,
            "model": model,
            "product": product,
            "cost_center_id": cost_center_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BillingPremiumRequestUsageReportGhe,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_github_billing_premium_request_usage_report_ghe(
        self,
        enterprise: str,
        *,
        year: Missing[int] = UNSET,
        month: Missing[int] = UNSET,
        day: Missing[int] = UNSET,
        organization: Missing[str] = UNSET,
        user: Missing[str] = UNSET,
        model: Missing[str] = UNSET,
        product: Missing[str] = UNSET,
        cost_center_id: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        BillingPremiumRequestUsageReportGhe,
        BillingPremiumRequestUsageReportGheTypeForResponse,
    ]:
        """billing/get-github-billing-premium-request-usage-report-ghe

        GET /enterprises/{enterprise}/settings/billing/premium_request/usage

        Gets a report of premium request usage for an enterprise. To use this endpoint, you must be an administrator or billing manager of the enterprise.

        **Note:** Only data from the past 24 months is accessible via this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/usage#get-billing-premium-request-usage-report-for-an-enterprise
        """

        from ..models import (
            BasicError,
            BillingPremiumRequestUsageReportGhe,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/enterprises/{enterprise}/settings/billing/premium_request/usage"

        params = {
            "year": year,
            "month": month,
            "day": day,
            "organization": organization,
            "user": user,
            "model": model,
            "product": product,
            "cost_center_id": cost_center_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BillingPremiumRequestUsageReportGhe,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_github_billing_usage_report_ghe(
        self,
        enterprise: str,
        *,
        year: Missing[int] = UNSET,
        month: Missing[int] = UNSET,
        day: Missing[int] = UNSET,
        cost_center_id: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[BillingUsageReport, BillingUsageReportTypeForResponse]:
        """billing/get-github-billing-usage-report-ghe

        GET /enterprises/{enterprise}/settings/billing/usage

        Gets a report of usage by cost center for an enterprise. To use this endpoint, you must be an administrator or billing manager of the enterprise. By default this endpoint will return usage that does not have a cost center.

        **Note:** This endpoint is only available to enterprises with access to the enhanced billing platform. For more information, see "[About the enhanced billing platform for enterprises](https://docs.github.com/enterprise-cloud@latest//billing/using-the-enhanced-billing-platform-for-enterprises/about-the-enhanced-billing-platform-for-enterprises#how-do-i-know-if-i-can-access-the-enhanced-billing-platform)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/usage#get-billing-usage-report-for-an-enterprise
        """

        from ..models import (
            BasicError,
            BillingUsageReport,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/enterprises/{enterprise}/settings/billing/usage"

        params = {
            "year": year,
            "month": month,
            "day": day,
            "cost_center_id": cost_center_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BillingUsageReport,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_github_billing_usage_report_ghe(
        self,
        enterprise: str,
        *,
        year: Missing[int] = UNSET,
        month: Missing[int] = UNSET,
        day: Missing[int] = UNSET,
        cost_center_id: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[BillingUsageReport, BillingUsageReportTypeForResponse]:
        """billing/get-github-billing-usage-report-ghe

        GET /enterprises/{enterprise}/settings/billing/usage

        Gets a report of usage by cost center for an enterprise. To use this endpoint, you must be an administrator or billing manager of the enterprise. By default this endpoint will return usage that does not have a cost center.

        **Note:** This endpoint is only available to enterprises with access to the enhanced billing platform. For more information, see "[About the enhanced billing platform for enterprises](https://docs.github.com/enterprise-cloud@latest//billing/using-the-enhanced-billing-platform-for-enterprises/about-the-enhanced-billing-platform-for-enterprises#how-do-i-know-if-i-can-access-the-enhanced-billing-platform)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/usage#get-billing-usage-report-for-an-enterprise
        """

        from ..models import (
            BasicError,
            BillingUsageReport,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/enterprises/{enterprise}/settings/billing/usage"

        params = {
            "year": year,
            "month": month,
            "day": day,
            "cost_center_id": cost_center_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BillingUsageReport,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_github_billing_usage_summary_report_ghe(
        self,
        enterprise: str,
        *,
        year: Missing[int] = UNSET,
        month: Missing[int] = UNSET,
        day: Missing[int] = UNSET,
        organization: Missing[str] = UNSET,
        repository: Missing[str] = UNSET,
        product: Missing[str] = UNSET,
        sku: Missing[str] = UNSET,
        cost_center_id: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        BillingUsageSummaryReportGhe, BillingUsageSummaryReportGheTypeForResponse
    ]:
        """billing/get-github-billing-usage-summary-report-ghe

        GET /enterprises/{enterprise}/settings/billing/usage/summary

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Gets a summary report of usage for an enterprise. To use this endpoint, you must be an administrator or billing manager of the enterprise. By default, this endpoint will return usage across all cost centers in the enterprise.

        **Note:** Only data from the past 24 months is accessible via this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/usage#get-billing-usage-summary-for-an-enterprise
        """

        from ..models import (
            BasicError,
            BillingUsageSummaryReportGhe,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/enterprises/{enterprise}/settings/billing/usage/summary"

        params = {
            "year": year,
            "month": month,
            "day": day,
            "organization": organization,
            "repository": repository,
            "product": product,
            "sku": sku,
            "cost_center_id": cost_center_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BillingUsageSummaryReportGhe,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_github_billing_usage_summary_report_ghe(
        self,
        enterprise: str,
        *,
        year: Missing[int] = UNSET,
        month: Missing[int] = UNSET,
        day: Missing[int] = UNSET,
        organization: Missing[str] = UNSET,
        repository: Missing[str] = UNSET,
        product: Missing[str] = UNSET,
        sku: Missing[str] = UNSET,
        cost_center_id: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        BillingUsageSummaryReportGhe, BillingUsageSummaryReportGheTypeForResponse
    ]:
        """billing/get-github-billing-usage-summary-report-ghe

        GET /enterprises/{enterprise}/settings/billing/usage/summary

        > [!NOTE]
        > This endpoint is in public preview and is subject to change.

        Gets a summary report of usage for an enterprise. To use this endpoint, you must be an administrator or billing manager of the enterprise. By default, this endpoint will return usage across all cost centers in the enterprise.

        **Note:** Only data from the past 24 months is accessible via this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/usage#get-billing-usage-summary-for-an-enterprise
        """

        from ..models import (
            BasicError,
            BillingUsageSummaryReportGhe,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/enterprises/{enterprise}/settings/billing/usage/summary"

        params = {
            "year": year,
            "month": month,
            "day": day,
            "organization": organization,
            "repository": repository,
            "product": product,
            "sku": sku,
            "cost_center_id": cost_center_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BillingUsageSummaryReportGhe,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_github_advanced_security_billing_org(
        self,
        org: str,
        *,
        advanced_security_product: Missing[
            Literal["code_security", "secret_protection"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        AdvancedSecurityActiveCommitters,
        AdvancedSecurityActiveCommittersTypeForResponse,
    ]:
        """billing/get-github-advanced-security-billing-org

        GET /orgs/{org}/settings/billing/advanced-security

        Gets the GitHub Advanced Security active committers for an organization per repository.

        Each distinct user login across all repositories is counted as a single Advanced Security seat, so the `total_advanced_security_committers` is not the sum of advanced_security_committers for each repository.

        If this organization defers to an enterprise for billing, the `total_advanced_security_committers` returned from the organization API may include some users that are in more than one organization, so they will only consume a single Advanced Security seat at the enterprise level.

        The total number of repositories with committer information is tracked by the `total_count` field.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-advanced-security-active-committers-for-an-organization
        """

        from ..models import AdvancedSecurityActiveCommitters

        url = f"/orgs/{org}/settings/billing/advanced-security"

        params = {
            "advanced_security_product": advanced_security_product,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AdvancedSecurityActiveCommitters,
        )

    async def async_get_github_advanced_security_billing_org(
        self,
        org: str,
        *,
        advanced_security_product: Missing[
            Literal["code_security", "secret_protection"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        AdvancedSecurityActiveCommitters,
        AdvancedSecurityActiveCommittersTypeForResponse,
    ]:
        """billing/get-github-advanced-security-billing-org

        GET /orgs/{org}/settings/billing/advanced-security

        Gets the GitHub Advanced Security active committers for an organization per repository.

        Each distinct user login across all repositories is counted as a single Advanced Security seat, so the `total_advanced_security_committers` is not the sum of advanced_security_committers for each repository.

        If this organization defers to an enterprise for billing, the `total_advanced_security_committers` returned from the organization API may include some users that are in more than one organization, so they will only consume a single Advanced Security seat at the enterprise level.

        The total number of repositories with committer information is tracked by the `total_count` field.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-advanced-security-active-committers-for-an-organization
        """

        from ..models import AdvancedSecurityActiveCommitters

        url = f"/orgs/{org}/settings/billing/advanced-security"

        params = {
            "advanced_security_product": advanced_security_product,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AdvancedSecurityActiveCommitters,
        )
