"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

import datetime as _dt
from typing import Literal, Union

from pydantic import Field

from githubkit.compat import GitHubModel, model_rebuild
from githubkit.typing import Missing
from githubkit.utils import UNSET


class DismissalRequestResponse(GitHubModel):
    """Dismissal request response

    A response made by a requester to dismiss the request.
    """

    id: Missing[int] = Field(
        default=UNSET, description="The ID of the response to the dismissal request."
    )
    reviewer: Missing[DismissalRequestResponsePropReviewer] = Field(
        default=UNSET, description="The user who reviewed the dismissal request."
    )
    message: Missing[Union[str, None]] = Field(
        default=UNSET, description="The response comment of the reviewer."
    )
    status: Missing[Literal["approved", "denied", "dismissed"]] = Field(
        default=UNSET,
        description="The response status to the dismissal request until dismissed.",
    )
    created_at: Missing[_dt.datetime] = Field(
        default=UNSET,
        description="The date and time the response to the dismissal request was created.",
    )


class DismissalRequestResponsePropReviewer(GitHubModel):
    """DismissalRequestResponsePropReviewer

    The user who reviewed the dismissal request.
    """

    actor_id: Missing[int] = Field(
        default=UNSET,
        description="The ID of the GitHub user who reviewed the dismissal request.",
    )
    actor_name: Missing[str] = Field(
        default=UNSET,
        description="The name of the GitHub user who reviewed the dismissal request.",
    )


model_rebuild(DismissalRequestResponse)
model_rebuild(DismissalRequestResponsePropReviewer)

__all__ = (
    "DismissalRequestResponse",
    "DismissalRequestResponsePropReviewer",
)
