"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

import datetime as _dt
from typing import Literal, Union

from pydantic import Field

from githubkit.compat import GitHubModel, model_rebuild
from githubkit.typing import Missing
from githubkit.utils import UNSET

from .group_0003 import SimpleUser


class ProjectsV2StatusUpdate(GitHubModel):
    """Projects v2 Status Update

    An status update belonging to a project
    """

    id: float = Field(description="The unique identifier of the status update.")
    node_id: str = Field(description="The node ID of the status update.")
    project_node_id: Missing[str] = Field(
        default=UNSET,
        description="The node ID of the project that this status update belongs to.",
    )
    creator: Missing[SimpleUser] = Field(
        default=UNSET, title="Simple User", description="A GitHub user."
    )
    created_at: _dt.datetime = Field(
        description="The time when the status update was created."
    )
    updated_at: _dt.datetime = Field(
        description="The time when the status update was last updated."
    )
    status: Missing[
        Union[None, Literal["INACTIVE", "ON_TRACK", "AT_RISK", "OFF_TRACK", "COMPLETE"]]
    ] = Field(default=UNSET, description="The current status.")
    start_date: Missing[_dt.date] = Field(
        default=UNSET, description="The start date of the period covered by the update."
    )
    target_date: Missing[_dt.date] = Field(
        default=UNSET, description="The target date associated with the update."
    )
    body: Missing[Union[str, None]] = Field(
        default=UNSET, description="Body of the status update"
    )


model_rebuild(ProjectsV2StatusUpdate)

__all__ = ("ProjectsV2StatusUpdate",)
