"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset, parse_query_params

if TYPE_CHECKING:
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import EnterpriseTeam
    from ..types import (
        EnterprisesEnterpriseTeamsPostBodyType,
        EnterprisesEnterpriseTeamsTeamSlugPatchBodyType,
        EnterpriseTeamTypeForResponse,
    )


class EnterpriseTeamsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list(
        self,
        enterprise: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[EnterpriseTeam], list[EnterpriseTeamTypeForResponse]]:
        """enterprise-teams/list

        GET /enterprises/{enterprise}/teams

        List all teams in the enterprise for the authenticated user

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-teams#list-enterprise-teams
        """

        from ..models import BasicError, EnterpriseTeam

        url = f"/enterprises/{enterprise}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[EnterpriseTeam],
            error_models={
                "403": BasicError,
            },
        )

    async def async_list(
        self,
        enterprise: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[EnterpriseTeam], list[EnterpriseTeamTypeForResponse]]:
        """enterprise-teams/list

        GET /enterprises/{enterprise}/teams

        List all teams in the enterprise for the authenticated user

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-teams#list-enterprise-teams
        """

        from ..models import BasicError, EnterpriseTeam

        url = f"/enterprises/{enterprise}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[EnterpriseTeam],
            error_models={
                "403": BasicError,
            },
        )

    @overload
    def create(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseTeamsPostBodyType,
    ) -> Response[EnterpriseTeam, EnterpriseTeamTypeForResponse]: ...

    @overload
    def create(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        description: Missing[Union[str, None]] = UNSET,
        sync_to_organizations: Missing[Literal["all", "disabled"]] = UNSET,
        organization_selection_type: Missing[
            Literal["disabled", "selected", "all"]
        ] = UNSET,
        group_id: Missing[Union[str, None]] = UNSET,
    ) -> Response[EnterpriseTeam, EnterpriseTeamTypeForResponse]: ...

    def create(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[EnterprisesEnterpriseTeamsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[EnterpriseTeam, EnterpriseTeamTypeForResponse]:
        """enterprise-teams/create

        POST /enterprises/{enterprise}/teams

        To create an enterprise team, the authenticated user must be an owner of the enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-teams#create-an-enterprise-team
        """

        from ..models import EnterprisesEnterpriseTeamsPostBody, EnterpriseTeam

        url = f"/enterprises/{enterprise}/teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(EnterprisesEnterpriseTeamsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterpriseTeam,
        )

    @overload
    async def async_create(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseTeamsPostBodyType,
    ) -> Response[EnterpriseTeam, EnterpriseTeamTypeForResponse]: ...

    @overload
    async def async_create(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        description: Missing[Union[str, None]] = UNSET,
        sync_to_organizations: Missing[Literal["all", "disabled"]] = UNSET,
        organization_selection_type: Missing[
            Literal["disabled", "selected", "all"]
        ] = UNSET,
        group_id: Missing[Union[str, None]] = UNSET,
    ) -> Response[EnterpriseTeam, EnterpriseTeamTypeForResponse]: ...

    async def async_create(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[EnterprisesEnterpriseTeamsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[EnterpriseTeam, EnterpriseTeamTypeForResponse]:
        """enterprise-teams/create

        POST /enterprises/{enterprise}/teams

        To create an enterprise team, the authenticated user must be an owner of the enterprise.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-teams#create-an-enterprise-team
        """

        from ..models import EnterprisesEnterpriseTeamsPostBody, EnterpriseTeam

        url = f"/enterprises/{enterprise}/teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(EnterprisesEnterpriseTeamsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterpriseTeam,
        )

    def get(
        self,
        enterprise: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[EnterpriseTeam, EnterpriseTeamTypeForResponse]:
        """enterprise-teams/get

        GET /enterprises/{enterprise}/teams/{team_slug}

        Gets a team using the team's slug. To create the slug, GitHub replaces special characters in the name string, changes all words to lowercase, and replaces spaces with a `-` separator and adds the "ent:" prefix. For example, "My TEam Näme" would become `ent:my-team-name`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-teams#get-an-enterprise-team
        """

        from ..models import BasicError, EnterpriseTeam

        url = f"/enterprises/{enterprise}/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterpriseTeam,
            error_models={
                "403": BasicError,
            },
        )

    async def async_get(
        self,
        enterprise: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[EnterpriseTeam, EnterpriseTeamTypeForResponse]:
        """enterprise-teams/get

        GET /enterprises/{enterprise}/teams/{team_slug}

        Gets a team using the team's slug. To create the slug, GitHub replaces special characters in the name string, changes all words to lowercase, and replaces spaces with a `-` separator and adds the "ent:" prefix. For example, "My TEam Näme" would become `ent:my-team-name`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-teams#get-an-enterprise-team
        """

        from ..models import BasicError, EnterpriseTeam

        url = f"/enterprises/{enterprise}/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterpriseTeam,
            error_models={
                "403": BasicError,
            },
        )

    def delete(
        self,
        enterprise: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-teams/delete

        DELETE /enterprises/{enterprise}/teams/{team_slug}

        To delete an enterprise team, the authenticated user must be an enterprise owner.

        If you are an enterprise owner, deleting an enterprise team will delete all of its IdP mappings as well.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-teams#delete-an-enterprise-team
        """

        from ..models import BasicError

        url = f"/enterprises/{enterprise}/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
            },
        )

    async def async_delete(
        self,
        enterprise: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """enterprise-teams/delete

        DELETE /enterprises/{enterprise}/teams/{team_slug}

        To delete an enterprise team, the authenticated user must be an enterprise owner.

        If you are an enterprise owner, deleting an enterprise team will delete all of its IdP mappings as well.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-teams#delete-an-enterprise-team
        """

        from ..models import BasicError

        url = f"/enterprises/{enterprise}/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    def update(
        self,
        enterprise: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseTeamsTeamSlugPatchBodyType,
    ) -> Response[EnterpriseTeam, EnterpriseTeamTypeForResponse]: ...

    @overload
    def update(
        self,
        enterprise: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[Union[str, None]] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        sync_to_organizations: Missing[Literal["all", "disabled"]] = UNSET,
        organization_selection_type: Missing[
            Literal["disabled", "selected", "all"]
        ] = UNSET,
        group_id: Missing[Union[str, None]] = UNSET,
    ) -> Response[EnterpriseTeam, EnterpriseTeamTypeForResponse]: ...

    def update(
        self,
        enterprise: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[EnterprisesEnterpriseTeamsTeamSlugPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[EnterpriseTeam, EnterpriseTeamTypeForResponse]:
        """enterprise-teams/update

        PATCH /enterprises/{enterprise}/teams/{team_slug}

        To edit a team, the authenticated user must be an enterprise owner.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-teams#update-an-enterprise-team
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseTeamsTeamSlugPatchBody,
            EnterpriseTeam,
        )

        url = f"/enterprises/{enterprise}/teams/{team_slug}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseTeamsTeamSlugPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterpriseTeam,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    async def async_update(
        self,
        enterprise: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: EnterprisesEnterpriseTeamsTeamSlugPatchBodyType,
    ) -> Response[EnterpriseTeam, EnterpriseTeamTypeForResponse]: ...

    @overload
    async def async_update(
        self,
        enterprise: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[Union[str, None]] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        sync_to_organizations: Missing[Literal["all", "disabled"]] = UNSET,
        organization_selection_type: Missing[
            Literal["disabled", "selected", "all"]
        ] = UNSET,
        group_id: Missing[Union[str, None]] = UNSET,
    ) -> Response[EnterpriseTeam, EnterpriseTeamTypeForResponse]: ...

    async def async_update(
        self,
        enterprise: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[EnterprisesEnterpriseTeamsTeamSlugPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[EnterpriseTeam, EnterpriseTeamTypeForResponse]:
        """enterprise-teams/update

        PATCH /enterprises/{enterprise}/teams/{team_slug}

        To edit a team, the authenticated user must be an enterprise owner.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-teams/enterprise-teams#update-an-enterprise-team
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseTeamsTeamSlugPatchBody,
            EnterpriseTeam,
        )

        url = f"/enterprises/{enterprise}/teams/{team_slug}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseTeamsTeamSlugPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EnterpriseTeam,
            error_models={
                "403": BasicError,
            },
        )
