"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

import datetime as _dt
from typing import Literal, Union

from pydantic import Field

from githubkit.compat import GitHubModel, model_rebuild
from githubkit.typing import Missing
from githubkit.utils import UNSET

from .group_0003 import SimpleUser
from .group_0472 import EnterpriseWebhooks
from .group_0473 import SimpleInstallation
from .group_0474 import OrganizationSimpleWebhooks
from .group_0475 import RepositoryWebhooks


class WebhookPullRequestReviewThreadResolved(GitHubModel):
    """pull_request_review_thread resolved event"""

    action: Literal["resolved"] = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    pull_request: WebhookPullRequestReviewThreadResolvedPropPullRequest = Field(
        title="Simple Pull Request"
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: Missing[SimpleUser] = Field(
        default=UNSET, title="Simple User", description="A GitHub user."
    )
    thread: WebhookPullRequestReviewThreadResolvedPropThread = Field()
    updated_at: Missing[Union[_dt.datetime, None]] = Field(default=UNSET)


class WebhookPullRequestReviewThreadResolvedPropPullRequest(GitHubModel):
    """Simple Pull Request"""

    links: WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinks = Field(
        alias="_links"
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field()
    assignee: Union[
        WebhookPullRequestReviewThreadResolvedPropPullRequestPropAssignee, None
    ] = Field(title="User")
    assignees: list[
        Union[
            WebhookPullRequestReviewThreadResolvedPropPullRequestPropAssigneesItems,
            None,
        ]
    ] = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    auto_merge: Union[
        WebhookPullRequestReviewThreadResolvedPropPullRequestPropAutoMerge, None
    ] = Field(
        title="PullRequestAutoMerge",
        description="The status of auto merging a pull request.",
    )
    base: WebhookPullRequestReviewThreadResolvedPropPullRequestPropBase = Field()
    body: Union[str, None] = Field()
    closed_at: Union[str, None] = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    created_at: str = Field()
    diff_url: str = Field()
    draft: bool = Field()
    head: WebhookPullRequestReviewThreadResolvedPropPullRequestPropHead = Field()
    html_url: str = Field()
    id: int = Field()
    issue_url: str = Field()
    labels: list[
        WebhookPullRequestReviewThreadResolvedPropPullRequestPropLabelsItems
    ] = Field()
    locked: bool = Field()
    merge_commit_sha: Union[str, None] = Field()
    merged_at: Union[str, None] = Field()
    milestone: Union[
        WebhookPullRequestReviewThreadResolvedPropPullRequestPropMilestone, None
    ] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
    )
    node_id: str = Field()
    number: int = Field()
    patch_url: str = Field()
    requested_reviewers: list[
        Union[
            WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedReviewersItemsOneof0,
            None,
            WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedReviewersItemsOneof1,
        ]
    ] = Field()
    requested_teams: list[
        WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedTeamsItems
    ] = Field()
    review_comment_url: str = Field()
    review_comments_url: str = Field()
    state: Literal["open", "closed"] = Field()
    statuses_url: str = Field()
    title: str = Field()
    updated_at: str = Field()
    url: str = Field()
    user: Union[WebhookPullRequestReviewThreadResolvedPropPullRequestPropUser, None] = (
        Field(title="User")
    )


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropAssignee(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    user_view_type: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropAssigneesItems(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropAutoMerge(GitHubModel):
    """PullRequestAutoMerge

    The status of auto merging a pull request.
    """

    commit_message: Union[str, None] = Field(
        description="Commit message for the merge commit."
    )
    commit_title: Union[str, None] = Field(
        description="Title for the merge commit message."
    )
    enabled_by: Union[
        WebhookPullRequestReviewThreadResolvedPropPullRequestPropAutoMergePropEnabledBy,
        None,
    ] = Field(title="User")
    merge_method: Literal["merge", "squash", "rebase"] = Field(
        description="The merge method to use."
    )


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropAutoMergePropEnabledBy(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    user_view_type: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropLabelsItems(GitHubModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color"
    )
    default: bool = Field()
    description: Union[str, None] = Field()
    id: int = Field()
    name: str = Field(description="The name of the label.")
    node_id: str = Field()
    url: str = Field(description="URL for the label")


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropMilestone(GitHubModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[_dt.datetime, None] = Field()
    closed_issues: int = Field()
    created_at: _dt.datetime = Field()
    creator: Union[
        WebhookPullRequestReviewThreadResolvedPropPullRequestPropMilestonePropCreator,
        None,
    ] = Field(title="User")
    description: Union[str, None] = Field()
    due_on: Union[_dt.datetime, None] = Field()
    html_url: str = Field()
    id: int = Field()
    labels_url: str = Field()
    node_id: str = Field()
    number: int = Field(description="The number of the milestone.")
    open_issues: int = Field()
    state: Literal["open", "closed"] = Field(description="The state of the milestone.")
    title: str = Field(description="The title of the milestone.")
    updated_at: _dt.datetime = Field()
    url: str = Field()


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropMilestonePropCreator(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    user_view_type: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedReviewersItemsOneof0(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)
    user_view_type: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)
    user_view_type: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinks(GitHubModel):
    """WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinks"""

    comments: WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropComments = Field(
        title="Link"
    )
    commits: WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropCommits = Field(
        title="Link"
    )
    html: WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropHtml = (
        Field(title="Link")
    )
    issue: WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropIssue = (
        Field(title="Link")
    )
    review_comment: WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropReviewComment = Field(
        title="Link"
    )
    review_comments: WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropReviewComments = Field(
        title="Link"
    )
    self_: WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropSelf = (
        Field(alias="self", title="Link")
    )
    statuses: WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropStatuses = Field(
        title="Link"
    )


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropComments(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropCommits(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropHtml(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropIssue(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropReviewComment(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropReviewComments(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropSelf(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropStatuses(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropBase(GitHubModel):
    """WebhookPullRequestReviewThreadResolvedPropPullRequestPropBase"""

    label: str = Field()
    ref: str = Field()
    repo: WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropRepo = Field(
        title="Repository", description="A git repository"
    )
    sha: str = Field()
    user: Union[
        WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropUser, None
    ] = Field(title="User")


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropUser(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    user_view_type: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropRepo(
    GitHubModel
):
    """Repository

    A git repository
    """

    allow_auto_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow auto-merge for pull requests."
    )
    allow_forking: Missing[bool] = Field(
        default=UNSET, description="Whether to allow private forks"
    )
    allow_merge_commit: Missing[bool] = Field(
        default=UNSET, description="Whether to allow merge commits for pull requests."
    )
    allow_rebase_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow rebase merges for pull requests."
    )
    allow_squash_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow squash merges for pull requests."
    )
    allow_update_branch: Missing[bool] = Field(default=UNSET)
    archive_url: str = Field()
    archived: bool = Field(
        default=False, description="Whether the repository is archived."
    )
    assignees_url: str = Field()
    blobs_url: str = Field()
    branches_url: str = Field()
    clone_url: str = Field()
    collaborators_url: str = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    compare_url: str = Field()
    contents_url: str = Field()
    contributors_url: str = Field()
    created_at: Union[int, _dt.datetime] = Field()
    default_branch: str = Field(description="The default branch of the repository.")
    delete_branch_on_merge: Missing[bool] = Field(
        default=UNSET,
        description="Whether to delete head branches when pull requests are merged",
    )
    deployments_url: str = Field()
    description: Union[str, None] = Field()
    disabled: Missing[bool] = Field(
        default=UNSET, description="Returns whether or not this repository is disabled."
    )
    downloads_url: str = Field()
    events_url: str = Field()
    fork: bool = Field()
    forks: int = Field()
    forks_count: int = Field()
    forks_url: str = Field()
    full_name: str = Field()
    git_commits_url: str = Field()
    git_refs_url: str = Field()
    git_tags_url: str = Field()
    git_url: str = Field()
    has_downloads: bool = Field(
        default=True, description="Whether downloads are enabled."
    )
    has_issues: bool = Field(default=True, description="Whether issues are enabled.")
    has_pages: bool = Field()
    has_projects: bool = Field(
        default=True, description="Whether projects are enabled."
    )
    has_wiki: bool = Field(default=True, description="Whether the wiki is enabled.")
    has_discussions: bool = Field(
        default=False, description="Whether discussions are enabled."
    )
    homepage: Union[str, None] = Field()
    hooks_url: str = Field()
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    is_template: Missing[bool] = Field(default=UNSET)
    issue_comment_url: str = Field()
    issue_events_url: str = Field()
    issues_url: str = Field()
    keys_url: str = Field()
    labels_url: str = Field()
    language: Union[str, None] = Field()
    languages_url: str = Field()
    license_: Union[
        WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropRepoPropLicense,
        None,
    ] = Field(alias="license", title="License")
    master_branch: Missing[str] = Field(default=UNSET)
    merges_url: str = Field()
    milestones_url: str = Field()
    mirror_url: Union[str, None] = Field()
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    notifications_url: str = Field()
    open_issues: int = Field()
    open_issues_count: int = Field()
    organization: Missing[str] = Field(default=UNSET)
    owner: Union[
        WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropRepoPropOwner,
        None,
    ] = Field(title="User")
    permissions: Missing[
        WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropRepoPropPermissions
    ] = Field(default=UNSET)
    private: bool = Field(description="Whether the repository is private or public.")
    public: Missing[bool] = Field(default=UNSET)
    pulls_url: str = Field()
    pushed_at: Union[int, _dt.datetime, None] = Field()
    releases_url: str = Field()
    role_name: Missing[Union[str, None]] = Field(default=UNSET)
    size: int = Field()
    ssh_url: str = Field()
    stargazers: Missing[int] = Field(default=UNSET)
    stargazers_count: int = Field()
    stargazers_url: str = Field()
    statuses_url: str = Field()
    subscribers_url: str = Field()
    subscription_url: str = Field()
    svn_url: str = Field()
    tags_url: str = Field()
    teams_url: str = Field()
    topics: list[str] = Field()
    trees_url: str = Field()
    updated_at: _dt.datetime = Field()
    url: str = Field()
    visibility: Literal["public", "private", "internal"] = Field()
    watchers: int = Field()
    watchers_count: int = Field()
    web_commit_signoff_required: Missing[bool] = Field(
        default=UNSET,
        description="Whether to require contributors to sign off on web-based commits",
    )


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropRepoPropLicense(
    GitHubModel
):
    """License"""

    key: str = Field()
    name: str = Field()
    node_id: str = Field()
    spdx_id: str = Field()
    url: Union[str, None] = Field()


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropRepoPropOwner(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    user_view_type: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropRepoPropPermissions(
    GitHubModel
):
    """WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropRepoPropPermiss
    ions
    """

    admin: bool = Field()
    maintain: Missing[bool] = Field(default=UNSET)
    pull: bool = Field()
    push: bool = Field()
    triage: Missing[bool] = Field(default=UNSET)


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropHead(GitHubModel):
    """WebhookPullRequestReviewThreadResolvedPropPullRequestPropHead"""

    label: Union[str, None] = Field()
    ref: str = Field()
    repo: Union[
        WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropRepo, None
    ] = Field(title="Repository", description="A git repository")
    sha: str = Field()
    user: Union[
        WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropUser, None
    ] = Field(title="User")


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropRepo(
    GitHubModel
):
    """Repository

    A git repository
    """

    allow_auto_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow auto-merge for pull requests."
    )
    allow_forking: Missing[bool] = Field(
        default=UNSET, description="Whether to allow private forks"
    )
    allow_merge_commit: Missing[bool] = Field(
        default=UNSET, description="Whether to allow merge commits for pull requests."
    )
    allow_rebase_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow rebase merges for pull requests."
    )
    allow_squash_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow squash merges for pull requests."
    )
    allow_update_branch: Missing[bool] = Field(default=UNSET)
    archive_url: str = Field()
    archived: bool = Field(
        default=False, description="Whether the repository is archived."
    )
    assignees_url: str = Field()
    blobs_url: str = Field()
    branches_url: str = Field()
    clone_url: str = Field()
    collaborators_url: str = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    compare_url: str = Field()
    contents_url: str = Field()
    contributors_url: str = Field()
    created_at: Union[int, _dt.datetime] = Field()
    default_branch: str = Field(description="The default branch of the repository.")
    delete_branch_on_merge: Missing[bool] = Field(
        default=UNSET,
        description="Whether to delete head branches when pull requests are merged",
    )
    deployments_url: str = Field()
    description: Union[str, None] = Field()
    disabled: Missing[bool] = Field(
        default=UNSET, description="Returns whether or not this repository is disabled."
    )
    downloads_url: str = Field()
    events_url: str = Field()
    fork: bool = Field()
    forks: int = Field()
    forks_count: int = Field()
    forks_url: str = Field()
    full_name: str = Field()
    git_commits_url: str = Field()
    git_refs_url: str = Field()
    git_tags_url: str = Field()
    git_url: str = Field()
    has_downloads: bool = Field(
        default=True, description="Whether downloads are enabled."
    )
    has_issues: bool = Field(default=True, description="Whether issues are enabled.")
    has_pages: bool = Field()
    has_projects: bool = Field(
        default=True, description="Whether projects are enabled."
    )
    has_wiki: bool = Field(default=True, description="Whether the wiki is enabled.")
    has_discussions: bool = Field(
        default=False, description="Whether discussions are enabled."
    )
    homepage: Union[str, None] = Field()
    hooks_url: str = Field()
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    is_template: Missing[bool] = Field(default=UNSET)
    issue_comment_url: str = Field()
    issue_events_url: str = Field()
    issues_url: str = Field()
    keys_url: str = Field()
    labels_url: str = Field()
    language: Union[str, None] = Field()
    languages_url: str = Field()
    license_: Union[
        WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropRepoPropLicense,
        None,
    ] = Field(alias="license", title="License")
    master_branch: Missing[str] = Field(default=UNSET)
    merges_url: str = Field()
    milestones_url: str = Field()
    mirror_url: Union[str, None] = Field()
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    notifications_url: str = Field()
    open_issues: int = Field()
    open_issues_count: int = Field()
    organization: Missing[str] = Field(default=UNSET)
    owner: Union[
        WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropRepoPropOwner,
        None,
    ] = Field(title="User")
    permissions: Missing[
        WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropRepoPropPermissions
    ] = Field(default=UNSET)
    private: bool = Field(description="Whether the repository is private or public.")
    public: Missing[bool] = Field(default=UNSET)
    pulls_url: str = Field()
    pushed_at: Union[int, _dt.datetime, None] = Field()
    releases_url: str = Field()
    role_name: Missing[Union[str, None]] = Field(default=UNSET)
    size: int = Field()
    ssh_url: str = Field()
    stargazers: Missing[int] = Field(default=UNSET)
    stargazers_count: int = Field()
    stargazers_url: str = Field()
    statuses_url: str = Field()
    subscribers_url: str = Field()
    subscription_url: str = Field()
    svn_url: str = Field()
    tags_url: str = Field()
    teams_url: str = Field()
    topics: list[str] = Field()
    trees_url: str = Field()
    updated_at: _dt.datetime = Field()
    url: str = Field()
    visibility: Literal["public", "private", "internal"] = Field()
    watchers: int = Field()
    watchers_count: int = Field()
    web_commit_signoff_required: Missing[bool] = Field(
        default=UNSET,
        description="Whether to require contributors to sign off on web-based commits",
    )


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropRepoPropLicense(
    GitHubModel
):
    """License"""

    key: str = Field()
    name: str = Field()
    node_id: str = Field()
    spdx_id: str = Field()
    url: Union[str, None] = Field()


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropRepoPropOwner(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    user_view_type: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropRepoPropPermissions(
    GitHubModel
):
    """WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropRepoPropPermiss
    ions
    """

    admin: bool = Field()
    maintain: Missing[bool] = Field(default=UNSET)
    pull: bool = Field()
    push: bool = Field()
    triage: Missing[bool] = Field(default=UNSET)


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropUser(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    user_view_type: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedReviewersItemsOneof1(
    GitHubModel
):
    """Team

    Groups of organization members that gives permissions on specified repositories.
    """

    deleted: Missing[bool] = Field(default=UNSET)
    description: Union[str, None] = Field(description="Description of the team")
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the team")
    members_url: str = Field()
    name: str = Field(description="Name of the team")
    node_id: str = Field()
    parent: Missing[
        Union[
            WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedReviewersItemsOneof1PropParent,
            None,
        ]
    ] = Field(default=UNSET)
    permission: str = Field(
        description="Permission that the team will have for its repositories"
    )
    privacy: Literal["open", "closed", "secret"] = Field()
    repositories_url: str = Field()
    slug: str = Field()
    url: str = Field(description="URL for the team")


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedReviewersItemsOneof1PropParent(
    GitHubModel
):
    """WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedReviewersItems
    Oneof1PropParent
    """

    description: Union[str, None] = Field(description="Description of the team")
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the team")
    members_url: str = Field()
    name: str = Field(description="Name of the team")
    node_id: str = Field()
    permission: str = Field(
        description="Permission that the team will have for its repositories"
    )
    privacy: Literal["open", "closed", "secret"] = Field()
    repositories_url: str = Field()
    slug: str = Field()
    url: str = Field(description="URL for the team")


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedTeamsItems(
    GitHubModel
):
    """Team

    Groups of organization members that gives permissions on specified repositories.
    """

    deleted: Missing[bool] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(
        default=UNSET, description="Description of the team"
    )
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field(description="Unique identifier of the team")
    members_url: Missing[str] = Field(default=UNSET)
    name: str = Field(description="Name of the team")
    node_id: Missing[str] = Field(default=UNSET)
    parent: Missing[
        Union[
            WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedTeamsItemsPropParent,
            None,
        ]
    ] = Field(default=UNSET)
    permission: Missing[str] = Field(
        default=UNSET,
        description="Permission that the team will have for its repositories",
    )
    privacy: Missing[Literal["open", "closed", "secret"]] = Field(default=UNSET)
    repositories_url: Missing[str] = Field(default=UNSET)
    slug: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET, description="URL for the team")


class WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedTeamsItemsPropParent(
    GitHubModel
):
    """WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedTeamsItemsProp
    Parent
    """

    description: Union[str, None] = Field(description="Description of the team")
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the team")
    members_url: str = Field()
    name: str = Field(description="Name of the team")
    node_id: str = Field()
    permission: str = Field(
        description="Permission that the team will have for its repositories"
    )
    privacy: Literal["open", "closed", "secret"] = Field()
    repositories_url: str = Field()
    slug: str = Field()
    url: str = Field(description="URL for the team")


class WebhookPullRequestReviewThreadResolvedPropThread(GitHubModel):
    """WebhookPullRequestReviewThreadResolvedPropThread"""

    comments: list[
        WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItems
    ] = Field()
    node_id: str = Field()


class WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItems(GitHubModel):
    """Pull Request Review Comment

    The [comment](https://docs.github.com/rest/pulls/comments#get-a-review-comment-
    for-a-pull-request) itself.
    """

    links: WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropLinks = Field(
        alias="_links"
    )
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    body: str = Field(description="The text of the comment.")
    commit_id: str = Field(
        description="The SHA of the commit to which the comment applies."
    )
    created_at: _dt.datetime = Field()
    diff_hunk: str = Field(
        description="The diff of the line that the comment refers to."
    )
    html_url: str = Field(description="HTML URL for the pull request review comment.")
    id: int = Field(description="The ID of the pull request review comment.")
    in_reply_to_id: Missing[int] = Field(
        default=UNSET, description="The comment ID to reply to."
    )
    line: Union[int, None] = Field(
        description="The line of the blob to which the comment applies. The last line of the range for a multi-line comment"
    )
    node_id: str = Field(description="The node ID of the pull request review comment.")
    original_commit_id: str = Field(
        description="The SHA of the original commit to which the comment applies."
    )
    original_line: Union[int, None] = Field(
        description="The line of the blob to which the comment applies. The last line of the range for a multi-line comment"
    )
    original_position: int = Field(
        description="The index of the original line in the diff to which the comment applies."
    )
    original_start_line: Union[int, None] = Field(
        description="The first line of the range for a multi-line comment."
    )
    path: str = Field(
        description="The relative path of the file to which the comment applies."
    )
    position: Union[int, None] = Field(
        description="The line index in the diff to which the comment applies."
    )
    pull_request_review_id: Union[int, None] = Field(
        description="The ID of the pull request review to which the comment belongs."
    )
    pull_request_url: str = Field(
        description="URL for the pull request that the review comment belongs to."
    )
    reactions: WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropReactions = Field(
        title="Reactions"
    )
    side: Literal["LEFT", "RIGHT"] = Field(
        description="The side of the first line of the range for a multi-line comment."
    )
    start_line: Union[int, None] = Field(
        description="The first line of the range for a multi-line comment."
    )
    start_side: Union[None, Literal["LEFT", "RIGHT"]] = Field(
        default="RIGHT",
        description="The side of the first line of the range for a multi-line comment.",
    )
    subject_type: Missing[Literal["line", "file"]] = Field(
        default=UNSET,
        description="The level at which the comment is targeted, can be a diff line or a file.",
    )
    updated_at: _dt.datetime = Field()
    url: str = Field(description="URL for the pull request review comment")
    user: Union[
        WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropUser, None
    ] = Field(title="User")


class WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropReactions(
    GitHubModel
):
    """Reactions"""

    plus_one: int = Field(alias="+1")
    minus_one: int = Field(alias="-1")
    confused: int = Field()
    eyes: int = Field()
    heart: int = Field()
    hooray: int = Field()
    laugh: int = Field()
    rocket: int = Field()
    total_count: int = Field()
    url: str = Field()


class WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropUser(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)
    user_view_type: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropLinks(
    GitHubModel
):
    """WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropLinks"""

    html: WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropLinksPropHtml = Field(
        title="Link"
    )
    pull_request: WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropLinksPropPullRequest = Field(
        title="Link"
    )
    self_: WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropLinksPropSelf = Field(
        alias="self", title="Link"
    )


class WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropLinksPropHtml(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropLinksPropPullRequest(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropLinksPropSelf(
    GitHubModel
):
    """Link"""

    href: str = Field()


model_rebuild(WebhookPullRequestReviewThreadResolved)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropPullRequest)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropPullRequestPropAssignee)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropPullRequestPropAssigneesItems)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropPullRequestPropAutoMerge)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropPullRequestPropAutoMergePropEnabledBy
)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropPullRequestPropLabelsItems)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropPullRequestPropMilestone)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropPullRequestPropMilestonePropCreator
)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedReviewersItemsOneof0
)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropPullRequestPropUser)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinks)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropComments
)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropCommits)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropHtml)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropIssue)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropReviewComment
)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropReviewComments
)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropSelf)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropStatuses
)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropPullRequestPropBase)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropUser)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropRepo)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropRepoPropLicense
)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropRepoPropOwner
)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropRepoPropPermissions
)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropPullRequestPropHead)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropRepo)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropRepoPropLicense
)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropRepoPropOwner
)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropRepoPropPermissions
)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropUser)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedReviewersItemsOneof1
)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedReviewersItemsOneof1PropParent
)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedTeamsItems
)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedTeamsItemsPropParent
)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropThread)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItems)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropReactions
)
model_rebuild(WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropUser)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropLinks
)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropLinksPropHtml
)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropLinksPropPullRequest
)
model_rebuild(
    WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropLinksPropSelf
)

__all__ = (
    "WebhookPullRequestReviewThreadResolved",
    "WebhookPullRequestReviewThreadResolvedPropPullRequest",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropAssignee",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropAssigneesItems",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropAutoMerge",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropAutoMergePropEnabledBy",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropBase",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropRepo",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropRepoPropLicense",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropRepoPropOwner",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropRepoPropPermissions",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropBasePropUser",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropHead",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropRepo",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropRepoPropLicense",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropRepoPropOwner",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropRepoPropPermissions",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropHeadPropUser",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropLabelsItems",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinks",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropComments",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropCommits",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropHtml",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropIssue",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropReviewComment",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropReviewComments",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropSelf",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropLinksPropStatuses",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropMilestone",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropMilestonePropCreator",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedReviewersItemsOneof0",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedReviewersItemsOneof1",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedReviewersItemsOneof1PropParent",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedTeamsItems",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropRequestedTeamsItemsPropParent",
    "WebhookPullRequestReviewThreadResolvedPropPullRequestPropUser",
    "WebhookPullRequestReviewThreadResolvedPropThread",
    "WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItems",
    "WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropLinks",
    "WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropLinksPropHtml",
    "WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropLinksPropPullRequest",
    "WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropLinksPropSelf",
    "WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropReactions",
    "WebhookPullRequestReviewThreadResolvedPropThreadPropCommentsItemsPropUser",
)
