"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset, parse_query_params

if TYPE_CHECKING:
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        OrganizationSecretScanningAlert,
        OrgsOrgSecretScanningPatternConfigurationsPatchResponse200,
        SecretScanningAlert,
        SecretScanningLocation,
        SecretScanningPatternConfiguration,
        SecretScanningPushProtectionBypass,
        SecretScanningScanHistory,
    )
    from ..types import (
        OrganizationSecretScanningAlertTypeForResponse,
        OrgsOrgSecretScanningPatternConfigurationsPatchBodyPropCustomPatternSettingsItemsType,
        OrgsOrgSecretScanningPatternConfigurationsPatchBodyPropProviderPatternSettingsItemsType,
        OrgsOrgSecretScanningPatternConfigurationsPatchBodyType,
        OrgsOrgSecretScanningPatternConfigurationsPatchResponse200TypeForResponse,
        ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyAnyof0Type,
        ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyAnyof1Type,
        ReposOwnerRepoSecretScanningPushProtectionBypassesPostBodyType,
        SecretScanningAlertTypeForResponse,
        SecretScanningLocationTypeForResponse,
        SecretScanningPatternConfigurationTypeForResponse,
        SecretScanningPushProtectionBypassTypeForResponse,
        SecretScanningScanHistoryTypeForResponse,
    )


class SecretScanningClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_alerts_for_org(
        self,
        org: str,
        *,
        state: Missing[Literal["open", "resolved"]] = UNSET,
        secret_type: Missing[str] = UNSET,
        resolution: Missing[str] = UNSET,
        assignee: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        validity: Missing[str] = UNSET,
        is_publicly_leaked: Missing[bool] = UNSET,
        is_multi_repo: Missing[bool] = UNSET,
        hide_secret: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[OrganizationSecretScanningAlert],
        list[OrganizationSecretScanningAlertTypeForResponse],
    ]:
        """secret-scanning/list-alerts-for-org

        GET /orgs/{org}/secret-scanning/alerts

        Lists secret scanning alerts for eligible repositories in an organization, from newest to oldest.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/rest/secret-scanning/secret-scanning#list-secret-scanning-alerts-for-an-organization
        """

        from ..models import (
            BasicError,
            EventsGetResponse503,
            OrganizationSecretScanningAlert,
        )

        url = f"/orgs/{org}/secret-scanning/alerts"

        params = {
            "state": state,
            "secret_type": secret_type,
            "resolution": resolution,
            "assignee": assignee,
            "sort": sort,
            "direction": direction,
            "page": page,
            "per_page": per_page,
            "before": before,
            "after": after,
            "validity": validity,
            "is_publicly_leaked": is_publicly_leaked,
            "is_multi_repo": is_multi_repo,
            "hide_secret": hide_secret,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrganizationSecretScanningAlert],
            error_models={
                "404": BasicError,
                "503": EventsGetResponse503,
            },
        )

    async def async_list_alerts_for_org(
        self,
        org: str,
        *,
        state: Missing[Literal["open", "resolved"]] = UNSET,
        secret_type: Missing[str] = UNSET,
        resolution: Missing[str] = UNSET,
        assignee: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        validity: Missing[str] = UNSET,
        is_publicly_leaked: Missing[bool] = UNSET,
        is_multi_repo: Missing[bool] = UNSET,
        hide_secret: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[OrganizationSecretScanningAlert],
        list[OrganizationSecretScanningAlertTypeForResponse],
    ]:
        """secret-scanning/list-alerts-for-org

        GET /orgs/{org}/secret-scanning/alerts

        Lists secret scanning alerts for eligible repositories in an organization, from newest to oldest.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/rest/secret-scanning/secret-scanning#list-secret-scanning-alerts-for-an-organization
        """

        from ..models import (
            BasicError,
            EventsGetResponse503,
            OrganizationSecretScanningAlert,
        )

        url = f"/orgs/{org}/secret-scanning/alerts"

        params = {
            "state": state,
            "secret_type": secret_type,
            "resolution": resolution,
            "assignee": assignee,
            "sort": sort,
            "direction": direction,
            "page": page,
            "per_page": per_page,
            "before": before,
            "after": after,
            "validity": validity,
            "is_publicly_leaked": is_publicly_leaked,
            "is_multi_repo": is_multi_repo,
            "hide_secret": hide_secret,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[OrganizationSecretScanningAlert],
            error_models={
                "404": BasicError,
                "503": EventsGetResponse503,
            },
        )

    def list_org_pattern_configs(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        SecretScanningPatternConfiguration,
        SecretScanningPatternConfigurationTypeForResponse,
    ]:
        """secret-scanning/list-org-pattern-configs

        GET /orgs/{org}/secret-scanning/pattern-configurations

        Lists the secret scanning pattern configurations for an organization.

        Personal access tokens (classic) need the `read:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/secret-scanning/push-protection#list-organization-pattern-configurations
        """

        from ..models import BasicError, SecretScanningPatternConfiguration

        url = f"/orgs/{org}/secret-scanning/pattern-configurations"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SecretScanningPatternConfiguration,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_org_pattern_configs(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        SecretScanningPatternConfiguration,
        SecretScanningPatternConfigurationTypeForResponse,
    ]:
        """secret-scanning/list-org-pattern-configs

        GET /orgs/{org}/secret-scanning/pattern-configurations

        Lists the secret scanning pattern configurations for an organization.

        Personal access tokens (classic) need the `read:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/secret-scanning/push-protection#list-organization-pattern-configurations
        """

        from ..models import BasicError, SecretScanningPatternConfiguration

        url = f"/orgs/{org}/secret-scanning/pattern-configurations"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SecretScanningPatternConfiguration,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update_org_pattern_configs(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgSecretScanningPatternConfigurationsPatchBodyType,
    ) -> Response[
        OrgsOrgSecretScanningPatternConfigurationsPatchResponse200,
        OrgsOrgSecretScanningPatternConfigurationsPatchResponse200TypeForResponse,
    ]: ...

    @overload
    def update_org_pattern_configs(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        pattern_config_version: Missing[Union[str, None]] = UNSET,
        provider_pattern_settings: Missing[
            list[
                OrgsOrgSecretScanningPatternConfigurationsPatchBodyPropProviderPatternSettingsItemsType
            ]
        ] = UNSET,
        custom_pattern_settings: Missing[
            list[
                OrgsOrgSecretScanningPatternConfigurationsPatchBodyPropCustomPatternSettingsItemsType
            ]
        ] = UNSET,
    ) -> Response[
        OrgsOrgSecretScanningPatternConfigurationsPatchResponse200,
        OrgsOrgSecretScanningPatternConfigurationsPatchResponse200TypeForResponse,
    ]: ...

    def update_org_pattern_configs(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgSecretScanningPatternConfigurationsPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        OrgsOrgSecretScanningPatternConfigurationsPatchResponse200,
        OrgsOrgSecretScanningPatternConfigurationsPatchResponse200TypeForResponse,
    ]:
        """secret-scanning/update-org-pattern-configs

        PATCH /orgs/{org}/secret-scanning/pattern-configurations

        Updates the secret scanning pattern configurations for an organization.

        Personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/secret-scanning/push-protection#update-organization-pattern-configurations
        """

        from ..models import (
            BasicError,
            OrgsOrgSecretScanningPatternConfigurationsPatchBody,
            OrgsOrgSecretScanningPatternConfigurationsPatchResponse200,
            ValidationError,
        )

        url = f"/orgs/{org}/secret-scanning/pattern-configurations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgSecretScanningPatternConfigurationsPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgSecretScanningPatternConfigurationsPatchResponse200,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_org_pattern_configs(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgSecretScanningPatternConfigurationsPatchBodyType,
    ) -> Response[
        OrgsOrgSecretScanningPatternConfigurationsPatchResponse200,
        OrgsOrgSecretScanningPatternConfigurationsPatchResponse200TypeForResponse,
    ]: ...

    @overload
    async def async_update_org_pattern_configs(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        pattern_config_version: Missing[Union[str, None]] = UNSET,
        provider_pattern_settings: Missing[
            list[
                OrgsOrgSecretScanningPatternConfigurationsPatchBodyPropProviderPatternSettingsItemsType
            ]
        ] = UNSET,
        custom_pattern_settings: Missing[
            list[
                OrgsOrgSecretScanningPatternConfigurationsPatchBodyPropCustomPatternSettingsItemsType
            ]
        ] = UNSET,
    ) -> Response[
        OrgsOrgSecretScanningPatternConfigurationsPatchResponse200,
        OrgsOrgSecretScanningPatternConfigurationsPatchResponse200TypeForResponse,
    ]: ...

    async def async_update_org_pattern_configs(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgSecretScanningPatternConfigurationsPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        OrgsOrgSecretScanningPatternConfigurationsPatchResponse200,
        OrgsOrgSecretScanningPatternConfigurationsPatchResponse200TypeForResponse,
    ]:
        """secret-scanning/update-org-pattern-configs

        PATCH /orgs/{org}/secret-scanning/pattern-configurations

        Updates the secret scanning pattern configurations for an organization.

        Personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/secret-scanning/push-protection#update-organization-pattern-configurations
        """

        from ..models import (
            BasicError,
            OrgsOrgSecretScanningPatternConfigurationsPatchBody,
            OrgsOrgSecretScanningPatternConfigurationsPatchResponse200,
            ValidationError,
        )

        url = f"/orgs/{org}/secret-scanning/pattern-configurations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgSecretScanningPatternConfigurationsPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgSecretScanningPatternConfigurationsPatchResponse200,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "422": ValidationError,
            },
        )

    def list_alerts_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        state: Missing[Literal["open", "resolved"]] = UNSET,
        secret_type: Missing[str] = UNSET,
        resolution: Missing[str] = UNSET,
        assignee: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        validity: Missing[str] = UNSET,
        is_publicly_leaked: Missing[bool] = UNSET,
        is_multi_repo: Missing[bool] = UNSET,
        hide_secret: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SecretScanningAlert], list[SecretScanningAlertTypeForResponse]]:
        """secret-scanning/list-alerts-for-repo

        GET /repos/{owner}/{repo}/secret-scanning/alerts

        Lists secret scanning alerts for an eligible repository, from newest to oldest.

        The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/rest/secret-scanning/secret-scanning#list-secret-scanning-alerts-for-a-repository
        """

        from ..models import EventsGetResponse503, SecretScanningAlert

        url = f"/repos/{owner}/{repo}/secret-scanning/alerts"

        params = {
            "state": state,
            "secret_type": secret_type,
            "resolution": resolution,
            "assignee": assignee,
            "sort": sort,
            "direction": direction,
            "page": page,
            "per_page": per_page,
            "before": before,
            "after": after,
            "validity": validity,
            "is_publicly_leaked": is_publicly_leaked,
            "is_multi_repo": is_multi_repo,
            "hide_secret": hide_secret,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SecretScanningAlert],
            error_models={
                "503": EventsGetResponse503,
            },
        )

    async def async_list_alerts_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        state: Missing[Literal["open", "resolved"]] = UNSET,
        secret_type: Missing[str] = UNSET,
        resolution: Missing[str] = UNSET,
        assignee: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        validity: Missing[str] = UNSET,
        is_publicly_leaked: Missing[bool] = UNSET,
        is_multi_repo: Missing[bool] = UNSET,
        hide_secret: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SecretScanningAlert], list[SecretScanningAlertTypeForResponse]]:
        """secret-scanning/list-alerts-for-repo

        GET /repos/{owner}/{repo}/secret-scanning/alerts

        Lists secret scanning alerts for an eligible repository, from newest to oldest.

        The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/rest/secret-scanning/secret-scanning#list-secret-scanning-alerts-for-a-repository
        """

        from ..models import EventsGetResponse503, SecretScanningAlert

        url = f"/repos/{owner}/{repo}/secret-scanning/alerts"

        params = {
            "state": state,
            "secret_type": secret_type,
            "resolution": resolution,
            "assignee": assignee,
            "sort": sort,
            "direction": direction,
            "page": page,
            "per_page": per_page,
            "before": before,
            "after": after,
            "validity": validity,
            "is_publicly_leaked": is_publicly_leaked,
            "is_multi_repo": is_multi_repo,
            "hide_secret": hide_secret,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SecretScanningAlert],
            error_models={
                "503": EventsGetResponse503,
            },
        )

    def get_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        hide_secret: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SecretScanningAlert, SecretScanningAlertTypeForResponse]:
        """secret-scanning/get-alert

        GET /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}

        Gets a single secret scanning alert detected in an eligible repository.

        The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/rest/secret-scanning/secret-scanning#get-a-secret-scanning-alert
        """

        from ..models import EventsGetResponse503, SecretScanningAlert

        url = f"/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}"

        params = {
            "hide_secret": hide_secret,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SecretScanningAlert,
            error_models={
                "503": EventsGetResponse503,
            },
        )

    async def async_get_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        hide_secret: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SecretScanningAlert, SecretScanningAlertTypeForResponse]:
        """secret-scanning/get-alert

        GET /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}

        Gets a single secret scanning alert detected in an eligible repository.

        The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/rest/secret-scanning/secret-scanning#get-a-secret-scanning-alert
        """

        from ..models import EventsGetResponse503, SecretScanningAlert

        url = f"/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}"

        params = {
            "hide_secret": hide_secret,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SecretScanningAlert,
            error_models={
                "503": EventsGetResponse503,
            },
        )

    @overload
    def update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyAnyof0Type,
            ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyAnyof1Type,
        ],
    ) -> Response[SecretScanningAlert, SecretScanningAlertTypeForResponse]: ...

    @overload
    def update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        state: Literal["open", "resolved"],
        resolution: Missing[
            Union[
                None, Literal["false_positive", "wont_fix", "revoked", "used_in_tests"]
            ]
        ] = UNSET,
        resolution_comment: Missing[Union[str, None]] = UNSET,
        assignee: Missing[Union[str, None]] = UNSET,
    ) -> Response[SecretScanningAlert, SecretScanningAlertTypeForResponse]: ...

    @overload
    def update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        state: Missing[Literal["open", "resolved"]] = UNSET,
        resolution: Missing[
            Union[
                None, Literal["false_positive", "wont_fix", "revoked", "used_in_tests"]
            ]
        ] = UNSET,
        resolution_comment: Missing[Union[str, None]] = UNSET,
        assignee: Union[str, None],
    ) -> Response[SecretScanningAlert, SecretScanningAlertTypeForResponse]: ...

    def update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyAnyof0Type,
                ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyAnyof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[SecretScanningAlert, SecretScanningAlertTypeForResponse]:
        """secret-scanning/update-alert

        PATCH /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}

        Updates the status of a secret scanning alert in an eligible repository.

        You can also use this endpoint to assign or unassign an alert to a user who has write access to the repository.

        The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/rest/secret-scanning/secret-scanning#update-a-secret-scanning-alert
        """

        from typing import Union

        from ..models import (
            EventsGetResponse503,
            ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyAnyof0,
            ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyAnyof1,
            SecretScanningAlert,
        )

        url = f"/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyAnyof0,
                    ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyAnyof1,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SecretScanningAlert,
            error_models={
                "503": EventsGetResponse503,
            },
        )

    @overload
    async def async_update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyAnyof0Type,
            ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyAnyof1Type,
        ],
    ) -> Response[SecretScanningAlert, SecretScanningAlertTypeForResponse]: ...

    @overload
    async def async_update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        state: Literal["open", "resolved"],
        resolution: Missing[
            Union[
                None, Literal["false_positive", "wont_fix", "revoked", "used_in_tests"]
            ]
        ] = UNSET,
        resolution_comment: Missing[Union[str, None]] = UNSET,
        assignee: Missing[Union[str, None]] = UNSET,
    ) -> Response[SecretScanningAlert, SecretScanningAlertTypeForResponse]: ...

    @overload
    async def async_update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        state: Missing[Literal["open", "resolved"]] = UNSET,
        resolution: Missing[
            Union[
                None, Literal["false_positive", "wont_fix", "revoked", "used_in_tests"]
            ]
        ] = UNSET,
        resolution_comment: Missing[Union[str, None]] = UNSET,
        assignee: Union[str, None],
    ) -> Response[SecretScanningAlert, SecretScanningAlertTypeForResponse]: ...

    async def async_update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyAnyof0Type,
                ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyAnyof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[SecretScanningAlert, SecretScanningAlertTypeForResponse]:
        """secret-scanning/update-alert

        PATCH /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}

        Updates the status of a secret scanning alert in an eligible repository.

        You can also use this endpoint to assign or unassign an alert to a user who has write access to the repository.

        The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/rest/secret-scanning/secret-scanning#update-a-secret-scanning-alert
        """

        from typing import Union

        from ..models import (
            EventsGetResponse503,
            ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyAnyof0,
            ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyAnyof1,
            SecretScanningAlert,
        )

        url = f"/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyAnyof0,
                    ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyAnyof1,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SecretScanningAlert,
            error_models={
                "503": EventsGetResponse503,
            },
        )

    def list_locations_for_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[SecretScanningLocation], list[SecretScanningLocationTypeForResponse]
    ]:
        """secret-scanning/list-locations-for-alert

        GET /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations

        Lists all locations for a given secret scanning alert for an eligible repository.

        The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/rest/secret-scanning/secret-scanning#list-locations-for-a-secret-scanning-alert
        """

        from ..models import EventsGetResponse503, SecretScanningLocation

        url = f"/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SecretScanningLocation],
            error_models={
                "503": EventsGetResponse503,
            },
        )

    async def async_list_locations_for_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[SecretScanningLocation], list[SecretScanningLocationTypeForResponse]
    ]:
        """secret-scanning/list-locations-for-alert

        GET /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations

        Lists all locations for a given secret scanning alert for an eligible repository.

        The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/rest/secret-scanning/secret-scanning#list-locations-for-a-secret-scanning-alert
        """

        from ..models import EventsGetResponse503, SecretScanningLocation

        url = f"/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SecretScanningLocation],
            error_models={
                "503": EventsGetResponse503,
            },
        )

    @overload
    def create_push_protection_bypass(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoSecretScanningPushProtectionBypassesPostBodyType,
    ) -> Response[
        SecretScanningPushProtectionBypass,
        SecretScanningPushProtectionBypassTypeForResponse,
    ]: ...

    @overload
    def create_push_protection_bypass(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        reason: Literal["false_positive", "used_in_tests", "will_fix_later"],
        placeholder_id: str,
    ) -> Response[
        SecretScanningPushProtectionBypass,
        SecretScanningPushProtectionBypassTypeForResponse,
    ]: ...

    def create_push_protection_bypass(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoSecretScanningPushProtectionBypassesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        SecretScanningPushProtectionBypass,
        SecretScanningPushProtectionBypassTypeForResponse,
    ]:
        """secret-scanning/create-push-protection-bypass

        POST /repos/{owner}/{repo}/secret-scanning/push-protection-bypasses

        Creates a bypass for a previously push protected secret.

        The authenticated user must be the original author of the committed secret.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/secret-scanning/secret-scanning#create-a-push-protection-bypass
        """

        from ..models import (
            EventsGetResponse503,
            ReposOwnerRepoSecretScanningPushProtectionBypassesPostBody,
            SecretScanningPushProtectionBypass,
        )

        url = f"/repos/{owner}/{repo}/secret-scanning/push-protection-bypasses"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoSecretScanningPushProtectionBypassesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SecretScanningPushProtectionBypass,
            error_models={
                "503": EventsGetResponse503,
            },
        )

    @overload
    async def async_create_push_protection_bypass(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoSecretScanningPushProtectionBypassesPostBodyType,
    ) -> Response[
        SecretScanningPushProtectionBypass,
        SecretScanningPushProtectionBypassTypeForResponse,
    ]: ...

    @overload
    async def async_create_push_protection_bypass(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        reason: Literal["false_positive", "used_in_tests", "will_fix_later"],
        placeholder_id: str,
    ) -> Response[
        SecretScanningPushProtectionBypass,
        SecretScanningPushProtectionBypassTypeForResponse,
    ]: ...

    async def async_create_push_protection_bypass(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoSecretScanningPushProtectionBypassesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        SecretScanningPushProtectionBypass,
        SecretScanningPushProtectionBypassTypeForResponse,
    ]:
        """secret-scanning/create-push-protection-bypass

        POST /repos/{owner}/{repo}/secret-scanning/push-protection-bypasses

        Creates a bypass for a previously push protected secret.

        The authenticated user must be the original author of the committed secret.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/secret-scanning/secret-scanning#create-a-push-protection-bypass
        """

        from ..models import (
            EventsGetResponse503,
            ReposOwnerRepoSecretScanningPushProtectionBypassesPostBody,
            SecretScanningPushProtectionBypass,
        )

        url = f"/repos/{owner}/{repo}/secret-scanning/push-protection-bypasses"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoSecretScanningPushProtectionBypassesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SecretScanningPushProtectionBypass,
            error_models={
                "503": EventsGetResponse503,
            },
        )

    def get_scan_history(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SecretScanningScanHistory, SecretScanningScanHistoryTypeForResponse]:
        """secret-scanning/get-scan-history

        GET /repos/{owner}/{repo}/secret-scanning/scan-history

        Lists the latest default incremental and backfill scans by type for a repository. Scans from Copilot Secret Scanning are not included.

        > [!NOTE]
        > This endpoint requires [GitHub Advanced Security](https://docs.github.com/get-started/learning-about-github/about-github-advanced-security)."

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/rest/secret-scanning/secret-scanning#get-secret-scanning-scan-history-for-a-repository
        """

        from ..models import EventsGetResponse503, SecretScanningScanHistory

        url = f"/repos/{owner}/{repo}/secret-scanning/scan-history"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SecretScanningScanHistory,
            error_models={
                "503": EventsGetResponse503,
            },
        )

    async def async_get_scan_history(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[SecretScanningScanHistory, SecretScanningScanHistoryTypeForResponse]:
        """secret-scanning/get-scan-history

        GET /repos/{owner}/{repo}/secret-scanning/scan-history

        Lists the latest default incremental and backfill scans by type for a repository. Scans from Copilot Secret Scanning are not included.

        > [!NOTE]
        > This endpoint requires [GitHub Advanced Security](https://docs.github.com/get-started/learning-about-github/about-github-advanced-security)."

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/rest/secret-scanning/secret-scanning#get-secret-scanning-scan-history-for-a-repository
        """

        from ..models import EventsGetResponse503, SecretScanningScanHistory

        url = f"/repos/{owner}/{repo}/secret-scanning/scan-history"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=SecretScanningScanHistory,
            error_models={
                "503": EventsGetResponse503,
            },
        )
