"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from typing import Literal, Union

from pydantic import Field

from githubkit.compat import GitHubModel, model_rebuild
from githubkit.typing import Missing
from githubkit.utils import UNSET


class OrgsOrgPrivateRegistriesPostBody(GitHubModel):
    """OrgsOrgPrivateRegistriesPostBody"""

    registry_type: Literal[
        "maven_repository",
        "nuget_feed",
        "goproxy_server",
        "npm_registry",
        "rubygems_server",
        "cargo_registry",
        "composer_repository",
        "docker_registry",
        "git_source",
        "helm_registry",
        "hex_organization",
        "hex_repository",
        "pub_repository",
        "python_index",
        "terraform_registry",
    ] = Field(description="The registry type.")
    url: str = Field(description="The URL of the private registry.")
    username: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="The username to use when authenticating with the private registry. This field should be omitted if the private registry does not require a username for authentication.",
    )
    replaces_base: Missing[bool] = Field(
        default=UNSET,
        description="Whether this private registry should replace the base registry (e.g., npmjs.org for npm, rubygems.org for rubygems). When set to `true`, Dependabot will only use this registry and will not fall back to the public registry. When set to `false` (default), Dependabot will use this registry for scoped packages but may fall back to the public registry for other packages.",
    )
    encrypted_value: str = Field(
        pattern="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$",
        description="The value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get private registries public key for an organization](https://docs.github.com/enterprise-cloud@latest//rest/private-registries/organization-configurations#get-private-registries-public-key-for-an-organization) endpoint.",
    )
    key_id: str = Field(description="The ID of the key you used to encrypt the secret.")
    visibility: Literal["all", "private", "selected"] = Field(
        description="Which type of organization repositories have access to the private registry. `selected` means only the repositories specified by `selected_repository_ids` can access the private registry."
    )
    selected_repository_ids: Missing[list[int]] = Field(
        default=UNSET,
        description="An array of repository IDs that can access the organization private registry. You can only provide a list of repository IDs when `visibility` is set to `selected`. You can manage the list of selected repositories using the [Update a private registry for an organization](https://docs.github.com/enterprise-cloud@latest//rest/private-registries/organization-configurations#update-a-private-registry-for-an-organization) endpoint. This field should be omitted if `visibility` is set to `all` or `private`.",
    )


model_rebuild(OrgsOrgPrivateRegistriesPostBody)

__all__ = ("OrgsOrgPrivateRegistriesPostBody",)
