"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset, parse_query_params

if TYPE_CHECKING:
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        ProjectsV2,
        ProjectsV2Field,
        ProjectsV2ItemSimple,
        ProjectsV2ItemWithContent,
        ProjectsV2View,
    )
    from ..types import (
        OrgsOrgProjectsV2ProjectNumberDraftsPostBodyType,
        OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof0Type,
        OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof1Type,
        OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof2Type,
        OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof3Type,
        OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBodyPropFieldsItemsType,
        OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBodyType,
        OrgsOrgProjectsV2ProjectNumberItemsPostBodyOneof0Type,
        OrgsOrgProjectsV2ProjectNumberItemsPostBodyOneof1Type,
        OrgsOrgProjectsV2ProjectNumberViewsPostBodyType,
        ProjectsV2FieldIterationConfigurationType,
        ProjectsV2FieldSingleSelectOptionType,
        ProjectsV2FieldTypeForResponse,
        ProjectsV2ItemSimpleTypeForResponse,
        ProjectsV2ItemWithContentTypeForResponse,
        ProjectsV2TypeForResponse,
        ProjectsV2ViewTypeForResponse,
        UsersUserIdProjectsV2ProjectNumberViewsPostBodyType,
        UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof0Type,
        UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof1Type,
        UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof2Type,
        UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBodyPropFieldsItemsType,
        UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBodyType,
        UsersUsernameProjectsV2ProjectNumberItemsPostBodyOneof0Type,
        UsersUsernameProjectsV2ProjectNumberItemsPostBodyOneof1Type,
        UserUserIdProjectsV2ProjectNumberDraftsPostBodyType,
    )


class ProjectsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_for_org(
        self,
        org: str,
        *,
        q: Missing[str] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectsV2], list[ProjectsV2TypeForResponse]]:
        """projects/list-for-org

        GET /orgs/{org}/projectsV2

        List all projects owned by a specific organization accessible by the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#list-projects-for-organization
        """

        from ..models import BasicError, ProjectsV2

        url = f"/orgs/{org}/projectsV2"

        params = {
            "q": q,
            "before": before,
            "after": after,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_for_org(
        self,
        org: str,
        *,
        q: Missing[str] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectsV2], list[ProjectsV2TypeForResponse]]:
        """projects/list-for-org

        GET /orgs/{org}/projectsV2

        List all projects owned by a specific organization accessible by the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#list-projects-for-organization
        """

        from ..models import BasicError, ProjectsV2

        url = f"/orgs/{org}/projectsV2"

        params = {
            "q": q,
            "before": before,
            "after": after,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_for_org(
        self,
        project_number: int,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2, ProjectsV2TypeForResponse]:
        """projects/get-for-org

        GET /orgs/{org}/projectsV2/{project_number}

        Get a specific organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#get-project-for-organization
        """

        from ..models import BasicError, ProjectsV2

        url = f"/orgs/{org}/projectsV2/{project_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_for_org(
        self,
        project_number: int,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2, ProjectsV2TypeForResponse]:
        """projects/get-for-org

        GET /orgs/{org}/projectsV2/{project_number}

        Get a specific organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#get-project-for-organization
        """

        from ..models import BasicError, ProjectsV2

        url = f"/orgs/{org}/projectsV2/{project_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_draft_item_for_org(
        self,
        org: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgProjectsV2ProjectNumberDraftsPostBodyType,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]: ...

    @overload
    def create_draft_item_for_org(
        self,
        org: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        title: str,
        body: Missing[str] = UNSET,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]: ...

    def create_draft_item_for_org(
        self,
        org: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgProjectsV2ProjectNumberDraftsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]:
        """projects/create-draft-item-for-org

        POST /orgs/{org}/projectsV2/{project_number}/drafts

        Create draft issue item for the specified organization owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/drafts#create-draft-item-for-organization-owned-project
        """

        from ..models import (
            BasicError,
            OrgsOrgProjectsV2ProjectNumberDraftsPostBody,
            ProjectsV2ItemSimple,
        )

        url = f"/orgs/{org}/projectsV2/{project_number}/drafts"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgProjectsV2ProjectNumberDraftsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemSimple,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_create_draft_item_for_org(
        self,
        org: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgProjectsV2ProjectNumberDraftsPostBodyType,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]: ...

    @overload
    async def async_create_draft_item_for_org(
        self,
        org: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        title: str,
        body: Missing[str] = UNSET,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]: ...

    async def async_create_draft_item_for_org(
        self,
        org: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgProjectsV2ProjectNumberDraftsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]:
        """projects/create-draft-item-for-org

        POST /orgs/{org}/projectsV2/{project_number}/drafts

        Create draft issue item for the specified organization owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/drafts#create-draft-item-for-organization-owned-project
        """

        from ..models import (
            BasicError,
            OrgsOrgProjectsV2ProjectNumberDraftsPostBody,
            ProjectsV2ItemSimple,
        )

        url = f"/orgs/{org}/projectsV2/{project_number}/drafts"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgProjectsV2ProjectNumberDraftsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemSimple,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_fields_for_org(
        self,
        project_number: int,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectsV2Field], list[ProjectsV2FieldTypeForResponse]]:
        """projects/list-fields-for-org

        GET /orgs/{org}/projectsV2/{project_number}/fields

        List all fields for a specific organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/fields#list-project-fields-for-organization
        """

        from ..models import BasicError, ProjectsV2Field

        url = f"/orgs/{org}/projectsV2/{project_number}/fields"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2Field],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_fields_for_org(
        self,
        project_number: int,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectsV2Field], list[ProjectsV2FieldTypeForResponse]]:
        """projects/list-fields-for-org

        GET /orgs/{org}/projectsV2/{project_number}/fields

        List all fields for a specific organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/fields#list-project-fields-for-organization
        """

        from ..models import BasicError, ProjectsV2Field

        url = f"/orgs/{org}/projectsV2/{project_number}/fields"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2Field],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def add_field_for_org(
        self,
        project_number: int,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof0Type,
            OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof1Type,
            OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof2Type,
            OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof3Type,
        ],
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]: ...

    @overload
    def add_field_for_org(
        self,
        project_number: int,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        issue_field_id: int,
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]: ...

    @overload
    def add_field_for_org(
        self,
        project_number: int,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        data_type: Literal["text", "number", "date"],
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]: ...

    @overload
    def add_field_for_org(
        self,
        project_number: int,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        data_type: Literal["single_select"],
        single_select_options: list[ProjectsV2FieldSingleSelectOptionType],
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]: ...

    @overload
    def add_field_for_org(
        self,
        project_number: int,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        data_type: Literal["iteration"],
        iteration_configuration: ProjectsV2FieldIterationConfigurationType,
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]: ...

    def add_field_for_org(
        self,
        project_number: int,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof0Type,
                OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof1Type,
                OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof2Type,
                OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof3Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]:
        """projects/add-field-for-org

        POST /orgs/{org}/projectsV2/{project_number}/fields

        Add a field to an organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/fields#add-a-field-to-an-organization-owned-project
        """

        from typing import Union

        from ..models import (
            BasicError,
            OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof0,
            OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof1,
            OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof2,
            OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof3,
            ProjectsV2Field,
            ValidationError,
        )

        url = f"/orgs/{org}/projectsV2/{project_number}/fields"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof0,
                    OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof1,
                    OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof2,
                    OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof3,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2Field,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_field_for_org(
        self,
        project_number: int,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof0Type,
            OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof1Type,
            OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof2Type,
            OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof3Type,
        ],
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]: ...

    @overload
    async def async_add_field_for_org(
        self,
        project_number: int,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        issue_field_id: int,
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]: ...

    @overload
    async def async_add_field_for_org(
        self,
        project_number: int,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        data_type: Literal["text", "number", "date"],
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]: ...

    @overload
    async def async_add_field_for_org(
        self,
        project_number: int,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        data_type: Literal["single_select"],
        single_select_options: list[ProjectsV2FieldSingleSelectOptionType],
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]: ...

    @overload
    async def async_add_field_for_org(
        self,
        project_number: int,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        data_type: Literal["iteration"],
        iteration_configuration: ProjectsV2FieldIterationConfigurationType,
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]: ...

    async def async_add_field_for_org(
        self,
        project_number: int,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof0Type,
                OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof1Type,
                OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof2Type,
                OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof3Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]:
        """projects/add-field-for-org

        POST /orgs/{org}/projectsV2/{project_number}/fields

        Add a field to an organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/fields#add-a-field-to-an-organization-owned-project
        """

        from typing import Union

        from ..models import (
            BasicError,
            OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof0,
            OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof1,
            OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof2,
            OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof3,
            ProjectsV2Field,
            ValidationError,
        )

        url = f"/orgs/{org}/projectsV2/{project_number}/fields"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof0,
                    OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof1,
                    OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof2,
                    OrgsOrgProjectsV2ProjectNumberFieldsPostBodyOneof3,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2Field,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def get_field_for_org(
        self,
        project_number: int,
        field_id: int,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]:
        """projects/get-field-for-org

        GET /orgs/{org}/projectsV2/{project_number}/fields/{field_id}

        Get a specific field for an organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/fields#get-project-field-for-organization
        """

        from ..models import BasicError, ProjectsV2Field

        url = f"/orgs/{org}/projectsV2/{project_number}/fields/{field_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2Field,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_field_for_org(
        self,
        project_number: int,
        field_id: int,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]:
        """projects/get-field-for-org

        GET /orgs/{org}/projectsV2/{project_number}/fields/{field_id}

        Get a specific field for an organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/fields#get-project-field-for-organization
        """

        from ..models import BasicError, ProjectsV2Field

        url = f"/orgs/{org}/projectsV2/{project_number}/fields/{field_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2Field,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_items_for_org(
        self,
        project_number: int,
        org: str,
        *,
        q: Missing[str] = UNSET,
        fields: Missing[Union[str, list[str]]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[ProjectsV2ItemWithContent], list[ProjectsV2ItemWithContentTypeForResponse]
    ]:
        """projects/list-items-for-org

        GET /orgs/{org}/projectsV2/{project_number}/items

        List all items for a specific organization-owned project accessible by the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#list-items-for-an-organization-owned-project
        """

        from ..models import BasicError, ProjectsV2ItemWithContent

        url = f"/orgs/{org}/projectsV2/{project_number}/items"

        params = {
            "q": q,
            "fields": fields,
            "before": before,
            "after": after,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2ItemWithContent],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_items_for_org(
        self,
        project_number: int,
        org: str,
        *,
        q: Missing[str] = UNSET,
        fields: Missing[Union[str, list[str]]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[ProjectsV2ItemWithContent], list[ProjectsV2ItemWithContentTypeForResponse]
    ]:
        """projects/list-items-for-org

        GET /orgs/{org}/projectsV2/{project_number}/items

        List all items for a specific organization-owned project accessible by the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#list-items-for-an-organization-owned-project
        """

        from ..models import BasicError, ProjectsV2ItemWithContent

        url = f"/orgs/{org}/projectsV2/{project_number}/items"

        params = {
            "q": q,
            "fields": fields,
            "before": before,
            "after": after,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2ItemWithContent],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def add_item_for_org(
        self,
        org: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            OrgsOrgProjectsV2ProjectNumberItemsPostBodyOneof0Type,
            OrgsOrgProjectsV2ProjectNumberItemsPostBodyOneof1Type,
        ],
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]: ...

    @overload
    def add_item_for_org(
        self,
        org: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        type: Literal["Issue", "PullRequest"],
        id: int,
        owner: Missing[str] = UNSET,
        repo: Missing[str] = UNSET,
        number: Missing[int] = UNSET,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]: ...

    @overload
    def add_item_for_org(
        self,
        org: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        type: Literal["Issue", "PullRequest"],
        id: Missing[int] = UNSET,
        owner: str,
        repo: str,
        number: int,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]: ...

    def add_item_for_org(
        self,
        org: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                OrgsOrgProjectsV2ProjectNumberItemsPostBodyOneof0Type,
                OrgsOrgProjectsV2ProjectNumberItemsPostBodyOneof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]:
        """projects/add-item-for-org

        POST /orgs/{org}/projectsV2/{project_number}/items

        Add an issue or pull request item to the specified organization owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#add-item-to-organization-owned-project
        """

        from typing import Union

        from ..models import (
            BasicError,
            OrgsOrgProjectsV2ProjectNumberItemsPostBodyOneof0,
            OrgsOrgProjectsV2ProjectNumberItemsPostBodyOneof1,
            ProjectsV2ItemSimple,
        )

        url = f"/orgs/{org}/projectsV2/{project_number}/items"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    OrgsOrgProjectsV2ProjectNumberItemsPostBodyOneof0,
                    OrgsOrgProjectsV2ProjectNumberItemsPostBodyOneof1,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemSimple,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_add_item_for_org(
        self,
        org: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            OrgsOrgProjectsV2ProjectNumberItemsPostBodyOneof0Type,
            OrgsOrgProjectsV2ProjectNumberItemsPostBodyOneof1Type,
        ],
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]: ...

    @overload
    async def async_add_item_for_org(
        self,
        org: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        type: Literal["Issue", "PullRequest"],
        id: int,
        owner: Missing[str] = UNSET,
        repo: Missing[str] = UNSET,
        number: Missing[int] = UNSET,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]: ...

    @overload
    async def async_add_item_for_org(
        self,
        org: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        type: Literal["Issue", "PullRequest"],
        id: Missing[int] = UNSET,
        owner: str,
        repo: str,
        number: int,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]: ...

    async def async_add_item_for_org(
        self,
        org: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                OrgsOrgProjectsV2ProjectNumberItemsPostBodyOneof0Type,
                OrgsOrgProjectsV2ProjectNumberItemsPostBodyOneof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]:
        """projects/add-item-for-org

        POST /orgs/{org}/projectsV2/{project_number}/items

        Add an issue or pull request item to the specified organization owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#add-item-to-organization-owned-project
        """

        from typing import Union

        from ..models import (
            BasicError,
            OrgsOrgProjectsV2ProjectNumberItemsPostBodyOneof0,
            OrgsOrgProjectsV2ProjectNumberItemsPostBodyOneof1,
            ProjectsV2ItemSimple,
        )

        url = f"/orgs/{org}/projectsV2/{project_number}/items"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    OrgsOrgProjectsV2ProjectNumberItemsPostBodyOneof0,
                    OrgsOrgProjectsV2ProjectNumberItemsPostBodyOneof1,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemSimple,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_org_item(
        self,
        project_number: int,
        org: str,
        item_id: int,
        *,
        fields: Missing[Union[str, list[str]]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentTypeForResponse]:
        """projects/get-org-item

        GET /orgs/{org}/projectsV2/{project_number}/items/{item_id}

        Get a specific item from an organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#get-an-item-for-an-organization-owned-project
        """

        from ..models import BasicError, ProjectsV2ItemWithContent

        url = f"/orgs/{org}/projectsV2/{project_number}/items/{item_id}"

        params = {
            "fields": fields,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemWithContent,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_org_item(
        self,
        project_number: int,
        org: str,
        item_id: int,
        *,
        fields: Missing[Union[str, list[str]]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentTypeForResponse]:
        """projects/get-org-item

        GET /orgs/{org}/projectsV2/{project_number}/items/{item_id}

        Get a specific item from an organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#get-an-item-for-an-organization-owned-project
        """

        from ..models import BasicError, ProjectsV2ItemWithContent

        url = f"/orgs/{org}/projectsV2/{project_number}/items/{item_id}"

        params = {
            "fields": fields,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemWithContent,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_item_for_org(
        self,
        project_number: int,
        org: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """projects/delete-item-for-org

        DELETE /orgs/{org}/projectsV2/{project_number}/items/{item_id}

        Delete a specific item from an organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#delete-project-item-for-organization
        """

        from ..models import BasicError

        url = f"/orgs/{org}/projectsV2/{project_number}/items/{item_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_item_for_org(
        self,
        project_number: int,
        org: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """projects/delete-item-for-org

        DELETE /orgs/{org}/projectsV2/{project_number}/items/{item_id}

        Delete a specific item from an organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#delete-project-item-for-organization
        """

        from ..models import BasicError

        url = f"/orgs/{org}/projectsV2/{project_number}/items/{item_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def update_item_for_org(
        self,
        project_number: int,
        org: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBodyType,
    ) -> Response[
        ProjectsV2ItemWithContent, ProjectsV2ItemWithContentTypeForResponse
    ]: ...

    @overload
    def update_item_for_org(
        self,
        project_number: int,
        org: str,
        item_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        fields: list[
            OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBodyPropFieldsItemsType
        ],
    ) -> Response[
        ProjectsV2ItemWithContent, ProjectsV2ItemWithContentTypeForResponse
    ]: ...

    def update_item_for_org(
        self,
        project_number: int,
        org: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentTypeForResponse]:
        """projects/update-item-for-org

        PATCH /orgs/{org}/projectsV2/{project_number}/items/{item_id}

        Update a specific item in an organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#update-project-item-for-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBody,
            ProjectsV2ItemWithContent,
            ValidationError,
        )

        url = f"/orgs/{org}/projectsV2/{project_number}/items/{item_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemWithContent,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_item_for_org(
        self,
        project_number: int,
        org: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBodyType,
    ) -> Response[
        ProjectsV2ItemWithContent, ProjectsV2ItemWithContentTypeForResponse
    ]: ...

    @overload
    async def async_update_item_for_org(
        self,
        project_number: int,
        org: str,
        item_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        fields: list[
            OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBodyPropFieldsItemsType
        ],
    ) -> Response[
        ProjectsV2ItemWithContent, ProjectsV2ItemWithContentTypeForResponse
    ]: ...

    async def async_update_item_for_org(
        self,
        project_number: int,
        org: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentTypeForResponse]:
        """projects/update-item-for-org

        PATCH /orgs/{org}/projectsV2/{project_number}/items/{item_id}

        Update a specific item in an organization-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#update-project-item-for-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBody,
            ProjectsV2ItemWithContent,
            ValidationError,
        )

        url = f"/orgs/{org}/projectsV2/{project_number}/items/{item_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgProjectsV2ProjectNumberItemsItemIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemWithContent,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    def create_view_for_org(
        self,
        org: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgProjectsV2ProjectNumberViewsPostBodyType,
    ) -> Response[ProjectsV2View, ProjectsV2ViewTypeForResponse]: ...

    @overload
    def create_view_for_org(
        self,
        org: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        layout: Literal["table", "board", "roadmap"],
        filter_: Missing[str] = UNSET,
        visible_fields: Missing[list[int]] = UNSET,
    ) -> Response[ProjectsV2View, ProjectsV2ViewTypeForResponse]: ...

    def create_view_for_org(
        self,
        org: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgProjectsV2ProjectNumberViewsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2View, ProjectsV2ViewTypeForResponse]:
        """projects/create-view-for-org

        POST /orgs/{org}/projectsV2/{project_number}/views

        Create a new view in an organization-owned project. Views allow you to customize how items in a project are displayed and filtered.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/views#create-a-view-for-an-organization-owned-project
        """

        from ..models import (
            BasicError,
            OrgsOrgProjectsV2ProjectNumberViewsPostBody,
            ProjectsV2View,
            ValidationError,
        )

        url = f"/orgs/{org}/projectsV2/{project_number}/views"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgProjectsV2ProjectNumberViewsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2View,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
                "422": ValidationError,
                "503": BasicError,
            },
        )

    @overload
    async def async_create_view_for_org(
        self,
        org: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgProjectsV2ProjectNumberViewsPostBodyType,
    ) -> Response[ProjectsV2View, ProjectsV2ViewTypeForResponse]: ...

    @overload
    async def async_create_view_for_org(
        self,
        org: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        layout: Literal["table", "board", "roadmap"],
        filter_: Missing[str] = UNSET,
        visible_fields: Missing[list[int]] = UNSET,
    ) -> Response[ProjectsV2View, ProjectsV2ViewTypeForResponse]: ...

    async def async_create_view_for_org(
        self,
        org: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgProjectsV2ProjectNumberViewsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2View, ProjectsV2ViewTypeForResponse]:
        """projects/create-view-for-org

        POST /orgs/{org}/projectsV2/{project_number}/views

        Create a new view in an organization-owned project. Views allow you to customize how items in a project are displayed and filtered.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/views#create-a-view-for-an-organization-owned-project
        """

        from ..models import (
            BasicError,
            OrgsOrgProjectsV2ProjectNumberViewsPostBody,
            ProjectsV2View,
            ValidationError,
        )

        url = f"/orgs/{org}/projectsV2/{project_number}/views"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgProjectsV2ProjectNumberViewsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2View,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
                "422": ValidationError,
                "503": BasicError,
            },
        )

    def list_view_items_for_org(
        self,
        project_number: int,
        org: str,
        view_number: int,
        *,
        fields: Missing[Union[str, list[str]]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[ProjectsV2ItemWithContent], list[ProjectsV2ItemWithContentTypeForResponse]
    ]:
        """projects/list-view-items-for-org

        GET /orgs/{org}/projectsV2/{project_number}/views/{view_number}/items

        List items in an organization project with the saved view's filter applied.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#list-items-for-an-organization-project-view
        """

        from ..models import BasicError, ProjectsV2ItemWithContent

        url = f"/orgs/{org}/projectsV2/{project_number}/views/{view_number}/items"

        params = {
            "fields": fields,
            "before": before,
            "after": after,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2ItemWithContent],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_view_items_for_org(
        self,
        project_number: int,
        org: str,
        view_number: int,
        *,
        fields: Missing[Union[str, list[str]]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[ProjectsV2ItemWithContent], list[ProjectsV2ItemWithContentTypeForResponse]
    ]:
        """projects/list-view-items-for-org

        GET /orgs/{org}/projectsV2/{project_number}/views/{view_number}/items

        List items in an organization project with the saved view's filter applied.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#list-items-for-an-organization-project-view
        """

        from ..models import BasicError, ProjectsV2ItemWithContent

        url = f"/orgs/{org}/projectsV2/{project_number}/views/{view_number}/items"

        params = {
            "fields": fields,
            "before": before,
            "after": after,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2ItemWithContent],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_draft_item_for_authenticated_user(
        self,
        user_id: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UserUserIdProjectsV2ProjectNumberDraftsPostBodyType,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]: ...

    @overload
    def create_draft_item_for_authenticated_user(
        self,
        user_id: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        title: str,
        body: Missing[str] = UNSET,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]: ...

    def create_draft_item_for_authenticated_user(
        self,
        user_id: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserUserIdProjectsV2ProjectNumberDraftsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]:
        """projects/create-draft-item-for-authenticated-user

        POST /user/{user_id}/projectsV2/{project_number}/drafts

        Create draft issue item for the specified user owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/drafts#create-draft-item-for-user-owned-project
        """

        from ..models import (
            BasicError,
            ProjectsV2ItemSimple,
            UserUserIdProjectsV2ProjectNumberDraftsPostBody,
        )

        url = f"/user/{user_id}/projectsV2/{project_number}/drafts"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                UserUserIdProjectsV2ProjectNumberDraftsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemSimple,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_create_draft_item_for_authenticated_user(
        self,
        user_id: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UserUserIdProjectsV2ProjectNumberDraftsPostBodyType,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]: ...

    @overload
    async def async_create_draft_item_for_authenticated_user(
        self,
        user_id: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        title: str,
        body: Missing[str] = UNSET,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]: ...

    async def async_create_draft_item_for_authenticated_user(
        self,
        user_id: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserUserIdProjectsV2ProjectNumberDraftsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]:
        """projects/create-draft-item-for-authenticated-user

        POST /user/{user_id}/projectsV2/{project_number}/drafts

        Create draft issue item for the specified user owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/drafts#create-draft-item-for-user-owned-project
        """

        from ..models import (
            BasicError,
            ProjectsV2ItemSimple,
            UserUserIdProjectsV2ProjectNumberDraftsPostBody,
        )

        url = f"/user/{user_id}/projectsV2/{project_number}/drafts"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                UserUserIdProjectsV2ProjectNumberDraftsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemSimple,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_view_for_user(
        self,
        user_id: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UsersUserIdProjectsV2ProjectNumberViewsPostBodyType,
    ) -> Response[ProjectsV2View, ProjectsV2ViewTypeForResponse]: ...

    @overload
    def create_view_for_user(
        self,
        user_id: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        layout: Literal["table", "board", "roadmap"],
        filter_: Missing[str] = UNSET,
        visible_fields: Missing[list[int]] = UNSET,
    ) -> Response[ProjectsV2View, ProjectsV2ViewTypeForResponse]: ...

    def create_view_for_user(
        self,
        user_id: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UsersUserIdProjectsV2ProjectNumberViewsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2View, ProjectsV2ViewTypeForResponse]:
        """projects/create-view-for-user

        POST /users/{user_id}/projectsV2/{project_number}/views

        Create a new view in a user-owned project. Views allow you to customize how items in a project are displayed and filtered.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/views#create-a-view-for-a-user-owned-project
        """

        from ..models import (
            BasicError,
            ProjectsV2View,
            UsersUserIdProjectsV2ProjectNumberViewsPostBody,
            ValidationError,
        )

        url = f"/users/{user_id}/projectsV2/{project_number}/views"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                UsersUserIdProjectsV2ProjectNumberViewsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2View,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
                "422": ValidationError,
                "503": BasicError,
            },
        )

    @overload
    async def async_create_view_for_user(
        self,
        user_id: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UsersUserIdProjectsV2ProjectNumberViewsPostBodyType,
    ) -> Response[ProjectsV2View, ProjectsV2ViewTypeForResponse]: ...

    @overload
    async def async_create_view_for_user(
        self,
        user_id: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        layout: Literal["table", "board", "roadmap"],
        filter_: Missing[str] = UNSET,
        visible_fields: Missing[list[int]] = UNSET,
    ) -> Response[ProjectsV2View, ProjectsV2ViewTypeForResponse]: ...

    async def async_create_view_for_user(
        self,
        user_id: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UsersUserIdProjectsV2ProjectNumberViewsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2View, ProjectsV2ViewTypeForResponse]:
        """projects/create-view-for-user

        POST /users/{user_id}/projectsV2/{project_number}/views

        Create a new view in a user-owned project. Views allow you to customize how items in a project are displayed and filtered.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/views#create-a-view-for-a-user-owned-project
        """

        from ..models import (
            BasicError,
            ProjectsV2View,
            UsersUserIdProjectsV2ProjectNumberViewsPostBody,
            ValidationError,
        )

        url = f"/users/{user_id}/projectsV2/{project_number}/views"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                UsersUserIdProjectsV2ProjectNumberViewsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2View,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
                "422": ValidationError,
                "503": BasicError,
            },
        )

    def list_for_user(
        self,
        username: str,
        *,
        q: Missing[str] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectsV2], list[ProjectsV2TypeForResponse]]:
        """projects/list-for-user

        GET /users/{username}/projectsV2

        List all projects owned by a specific user accessible by the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#list-projects-for-user
        """

        from ..models import BasicError, ProjectsV2

        url = f"/users/{username}/projectsV2"

        params = {
            "q": q,
            "before": before,
            "after": after,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_for_user(
        self,
        username: str,
        *,
        q: Missing[str] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectsV2], list[ProjectsV2TypeForResponse]]:
        """projects/list-for-user

        GET /users/{username}/projectsV2

        List all projects owned by a specific user accessible by the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#list-projects-for-user
        """

        from ..models import BasicError, ProjectsV2

        url = f"/users/{username}/projectsV2"

        params = {
            "q": q,
            "before": before,
            "after": after,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_for_user(
        self,
        project_number: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2, ProjectsV2TypeForResponse]:
        """projects/get-for-user

        GET /users/{username}/projectsV2/{project_number}

        Get a specific user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#get-project-for-user
        """

        from ..models import BasicError, ProjectsV2

        url = f"/users/{username}/projectsV2/{project_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_for_user(
        self,
        project_number: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2, ProjectsV2TypeForResponse]:
        """projects/get-for-user

        GET /users/{username}/projectsV2/{project_number}

        Get a specific user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#get-project-for-user
        """

        from ..models import BasicError, ProjectsV2

        url = f"/users/{username}/projectsV2/{project_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_fields_for_user(
        self,
        project_number: int,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectsV2Field], list[ProjectsV2FieldTypeForResponse]]:
        """projects/list-fields-for-user

        GET /users/{username}/projectsV2/{project_number}/fields

        List all fields for a specific user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/fields#list-project-fields-for-user
        """

        from ..models import BasicError, ProjectsV2Field

        url = f"/users/{username}/projectsV2/{project_number}/fields"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2Field],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_fields_for_user(
        self,
        project_number: int,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ProjectsV2Field], list[ProjectsV2FieldTypeForResponse]]:
        """projects/list-fields-for-user

        GET /users/{username}/projectsV2/{project_number}/fields

        List all fields for a specific user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/fields#list-project-fields-for-user
        """

        from ..models import BasicError, ProjectsV2Field

        url = f"/users/{username}/projectsV2/{project_number}/fields"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2Field],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def add_field_for_user(
        self,
        username: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof0Type,
            UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof1Type,
            UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof2Type,
        ],
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]: ...

    @overload
    def add_field_for_user(
        self,
        username: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        data_type: Literal["text", "number", "date"],
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]: ...

    @overload
    def add_field_for_user(
        self,
        username: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        data_type: Literal["single_select"],
        single_select_options: list[ProjectsV2FieldSingleSelectOptionType],
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]: ...

    @overload
    def add_field_for_user(
        self,
        username: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        data_type: Literal["iteration"],
        iteration_configuration: ProjectsV2FieldIterationConfigurationType,
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]: ...

    def add_field_for_user(
        self,
        username: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof0Type,
                UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof1Type,
                UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof2Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]:
        """projects/add-field-for-user

        POST /users/{username}/projectsV2/{project_number}/fields

        Add a field to a specified user owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/fields#add-field-to-user-owned-project
        """

        from typing import Union

        from ..models import (
            BasicError,
            ProjectsV2Field,
            UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof0,
            UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof1,
            UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof2,
            ValidationError,
        )

        url = f"/users/{username}/projectsV2/{project_number}/fields"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof0,
                    UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof1,
                    UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof2,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2Field,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_field_for_user(
        self,
        username: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof0Type,
            UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof1Type,
            UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof2Type,
        ],
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]: ...

    @overload
    async def async_add_field_for_user(
        self,
        username: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        data_type: Literal["text", "number", "date"],
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]: ...

    @overload
    async def async_add_field_for_user(
        self,
        username: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        data_type: Literal["single_select"],
        single_select_options: list[ProjectsV2FieldSingleSelectOptionType],
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]: ...

    @overload
    async def async_add_field_for_user(
        self,
        username: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        data_type: Literal["iteration"],
        iteration_configuration: ProjectsV2FieldIterationConfigurationType,
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]: ...

    async def async_add_field_for_user(
        self,
        username: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof0Type,
                UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof1Type,
                UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof2Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]:
        """projects/add-field-for-user

        POST /users/{username}/projectsV2/{project_number}/fields

        Add a field to a specified user owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/fields#add-field-to-user-owned-project
        """

        from typing import Union

        from ..models import (
            BasicError,
            ProjectsV2Field,
            UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof0,
            UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof1,
            UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof2,
            ValidationError,
        )

        url = f"/users/{username}/projectsV2/{project_number}/fields"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof0,
                    UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof1,
                    UsersUsernameProjectsV2ProjectNumberFieldsPostBodyOneof2,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2Field,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def get_field_for_user(
        self,
        project_number: int,
        field_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]:
        """projects/get-field-for-user

        GET /users/{username}/projectsV2/{project_number}/fields/{field_id}

        Get a specific field for a user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/fields#get-project-field-for-user
        """

        from ..models import BasicError, ProjectsV2Field

        url = f"/users/{username}/projectsV2/{project_number}/fields/{field_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2Field,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_field_for_user(
        self,
        project_number: int,
        field_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2Field, ProjectsV2FieldTypeForResponse]:
        """projects/get-field-for-user

        GET /users/{username}/projectsV2/{project_number}/fields/{field_id}

        Get a specific field for a user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/fields#get-project-field-for-user
        """

        from ..models import BasicError, ProjectsV2Field

        url = f"/users/{username}/projectsV2/{project_number}/fields/{field_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2Field,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_items_for_user(
        self,
        project_number: int,
        username: str,
        *,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        q: Missing[str] = UNSET,
        fields: Missing[Union[str, list[str]]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[ProjectsV2ItemWithContent], list[ProjectsV2ItemWithContentTypeForResponse]
    ]:
        """projects/list-items-for-user

        GET /users/{username}/projectsV2/{project_number}/items

        List all items for a specific user-owned project accessible by the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#list-items-for-a-user-owned-project
        """

        from ..models import BasicError, ProjectsV2ItemWithContent

        url = f"/users/{username}/projectsV2/{project_number}/items"

        params = {
            "before": before,
            "after": after,
            "per_page": per_page,
            "q": q,
            "fields": fields,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2ItemWithContent],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_items_for_user(
        self,
        project_number: int,
        username: str,
        *,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        q: Missing[str] = UNSET,
        fields: Missing[Union[str, list[str]]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[ProjectsV2ItemWithContent], list[ProjectsV2ItemWithContentTypeForResponse]
    ]:
        """projects/list-items-for-user

        GET /users/{username}/projectsV2/{project_number}/items

        List all items for a specific user-owned project accessible by the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#list-items-for-a-user-owned-project
        """

        from ..models import BasicError, ProjectsV2ItemWithContent

        url = f"/users/{username}/projectsV2/{project_number}/items"

        params = {
            "before": before,
            "after": after,
            "per_page": per_page,
            "q": q,
            "fields": fields,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2ItemWithContent],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def add_item_for_user(
        self,
        username: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            UsersUsernameProjectsV2ProjectNumberItemsPostBodyOneof0Type,
            UsersUsernameProjectsV2ProjectNumberItemsPostBodyOneof1Type,
        ],
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]: ...

    @overload
    def add_item_for_user(
        self,
        username: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        type: Literal["Issue", "PullRequest"],
        id: int,
        owner: Missing[str] = UNSET,
        repo: Missing[str] = UNSET,
        number: Missing[int] = UNSET,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]: ...

    @overload
    def add_item_for_user(
        self,
        username: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        type: Literal["Issue", "PullRequest"],
        id: Missing[int] = UNSET,
        owner: str,
        repo: str,
        number: int,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]: ...

    def add_item_for_user(
        self,
        username: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                UsersUsernameProjectsV2ProjectNumberItemsPostBodyOneof0Type,
                UsersUsernameProjectsV2ProjectNumberItemsPostBodyOneof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]:
        """projects/add-item-for-user

        POST /users/{username}/projectsV2/{project_number}/items

        Add an issue or pull request item to the specified user owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#add-item-to-user-owned-project
        """

        from typing import Union

        from ..models import (
            BasicError,
            ProjectsV2ItemSimple,
            UsersUsernameProjectsV2ProjectNumberItemsPostBodyOneof0,
            UsersUsernameProjectsV2ProjectNumberItemsPostBodyOneof1,
        )

        url = f"/users/{username}/projectsV2/{project_number}/items"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    UsersUsernameProjectsV2ProjectNumberItemsPostBodyOneof0,
                    UsersUsernameProjectsV2ProjectNumberItemsPostBodyOneof1,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemSimple,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_add_item_for_user(
        self,
        username: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            UsersUsernameProjectsV2ProjectNumberItemsPostBodyOneof0Type,
            UsersUsernameProjectsV2ProjectNumberItemsPostBodyOneof1Type,
        ],
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]: ...

    @overload
    async def async_add_item_for_user(
        self,
        username: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        type: Literal["Issue", "PullRequest"],
        id: int,
        owner: Missing[str] = UNSET,
        repo: Missing[str] = UNSET,
        number: Missing[int] = UNSET,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]: ...

    @overload
    async def async_add_item_for_user(
        self,
        username: str,
        project_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        type: Literal["Issue", "PullRequest"],
        id: Missing[int] = UNSET,
        owner: str,
        repo: str,
        number: int,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]: ...

    async def async_add_item_for_user(
        self,
        username: str,
        project_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                UsersUsernameProjectsV2ProjectNumberItemsPostBodyOneof0Type,
                UsersUsernameProjectsV2ProjectNumberItemsPostBodyOneof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2ItemSimple, ProjectsV2ItemSimpleTypeForResponse]:
        """projects/add-item-for-user

        POST /users/{username}/projectsV2/{project_number}/items

        Add an issue or pull request item to the specified user owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#add-item-to-user-owned-project
        """

        from typing import Union

        from ..models import (
            BasicError,
            ProjectsV2ItemSimple,
            UsersUsernameProjectsV2ProjectNumberItemsPostBodyOneof0,
            UsersUsernameProjectsV2ProjectNumberItemsPostBodyOneof1,
        )

        url = f"/users/{username}/projectsV2/{project_number}/items"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    UsersUsernameProjectsV2ProjectNumberItemsPostBodyOneof0,
                    UsersUsernameProjectsV2ProjectNumberItemsPostBodyOneof1,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemSimple,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_user_item(
        self,
        project_number: int,
        username: str,
        item_id: int,
        *,
        fields: Missing[Union[str, list[str]]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentTypeForResponse]:
        """projects/get-user-item

        GET /users/{username}/projectsV2/{project_number}/items/{item_id}

        Get a specific item from a user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#get-an-item-for-a-user-owned-project
        """

        from ..models import BasicError, ProjectsV2ItemWithContent

        url = f"/users/{username}/projectsV2/{project_number}/items/{item_id}"

        params = {
            "fields": fields,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemWithContent,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_user_item(
        self,
        project_number: int,
        username: str,
        item_id: int,
        *,
        fields: Missing[Union[str, list[str]]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentTypeForResponse]:
        """projects/get-user-item

        GET /users/{username}/projectsV2/{project_number}/items/{item_id}

        Get a specific item from a user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#get-an-item-for-a-user-owned-project
        """

        from ..models import BasicError, ProjectsV2ItemWithContent

        url = f"/users/{username}/projectsV2/{project_number}/items/{item_id}"

        params = {
            "fields": fields,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemWithContent,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_item_for_user(
        self,
        project_number: int,
        username: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """projects/delete-item-for-user

        DELETE /users/{username}/projectsV2/{project_number}/items/{item_id}

        Delete a specific item from a user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#delete-project-item-for-user
        """

        from ..models import BasicError

        url = f"/users/{username}/projectsV2/{project_number}/items/{item_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_item_for_user(
        self,
        project_number: int,
        username: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """projects/delete-item-for-user

        DELETE /users/{username}/projectsV2/{project_number}/items/{item_id}

        Delete a specific item from a user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#delete-project-item-for-user
        """

        from ..models import BasicError

        url = f"/users/{username}/projectsV2/{project_number}/items/{item_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def update_item_for_user(
        self,
        project_number: int,
        username: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBodyType,
    ) -> Response[
        ProjectsV2ItemWithContent, ProjectsV2ItemWithContentTypeForResponse
    ]: ...

    @overload
    def update_item_for_user(
        self,
        project_number: int,
        username: str,
        item_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        fields: list[
            UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBodyPropFieldsItemsType
        ],
    ) -> Response[
        ProjectsV2ItemWithContent, ProjectsV2ItemWithContentTypeForResponse
    ]: ...

    def update_item_for_user(
        self,
        project_number: int,
        username: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentTypeForResponse]:
        """projects/update-item-for-user

        PATCH /users/{username}/projectsV2/{project_number}/items/{item_id}

        Update a specific item in a user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#update-project-item-for-user
        """

        from ..models import (
            BasicError,
            ProjectsV2ItemWithContent,
            UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBody,
            ValidationError,
        )

        url = f"/users/{username}/projectsV2/{project_number}/items/{item_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemWithContent,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_item_for_user(
        self,
        project_number: int,
        username: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBodyType,
    ) -> Response[
        ProjectsV2ItemWithContent, ProjectsV2ItemWithContentTypeForResponse
    ]: ...

    @overload
    async def async_update_item_for_user(
        self,
        project_number: int,
        username: str,
        item_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        fields: list[
            UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBodyPropFieldsItemsType
        ],
    ) -> Response[
        ProjectsV2ItemWithContent, ProjectsV2ItemWithContentTypeForResponse
    ]: ...

    async def async_update_item_for_user(
        self,
        project_number: int,
        username: str,
        item_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[ProjectsV2ItemWithContent, ProjectsV2ItemWithContentTypeForResponse]:
        """projects/update-item-for-user

        PATCH /users/{username}/projectsV2/{project_number}/items/{item_id}

        Update a specific item in a user-owned project.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#update-project-item-for-user
        """

        from ..models import (
            BasicError,
            ProjectsV2ItemWithContent,
            UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBody,
            ValidationError,
        )

        url = f"/users/{username}/projectsV2/{project_number}/items/{item_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                UsersUsernameProjectsV2ProjectNumberItemsItemIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProjectsV2ItemWithContent,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_view_items_for_user(
        self,
        project_number: int,
        username: str,
        view_number: int,
        *,
        fields: Missing[Union[str, list[str]]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[ProjectsV2ItemWithContent], list[ProjectsV2ItemWithContentTypeForResponse]
    ]:
        """projects/list-view-items-for-user

        GET /users/{username}/projectsV2/{project_number}/views/{view_number}/items

        List items in a user project with the saved view's filter applied.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#list-items-for-a-user-project-view
        """

        from ..models import BasicError, ProjectsV2ItemWithContent

        url = f"/users/{username}/projectsV2/{project_number}/views/{view_number}/items"

        params = {
            "fields": fields,
            "before": before,
            "after": after,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2ItemWithContent],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_view_items_for_user(
        self,
        project_number: int,
        username: str,
        view_number: int,
        *,
        fields: Missing[Union[str, list[str]]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[ProjectsV2ItemWithContent], list[ProjectsV2ItemWithContentTypeForResponse]
    ]:
        """projects/list-view-items-for-user

        GET /users/{username}/projectsV2/{project_number}/views/{view_number}/items

        List items in a user project with the saved view's filter applied.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/items#list-items-for-a-user-project-view
        """

        from ..models import BasicError, ProjectsV2ItemWithContent

        url = f"/users/{username}/projectsV2/{project_number}/views/{view_number}/items"

        params = {
            "fields": fields,
            "before": before,
            "after": after,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ProjectsV2ItemWithContent],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )
