"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset, parse_query_params

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import ScimUser, ScimUserList
    from ..types import (
        ScimUserListTypeForResponse,
        ScimUserTypeForResponse,
        ScimV2OrganizationsOrgUsersPostBodyPropEmailsItemsType,
        ScimV2OrganizationsOrgUsersPostBodyPropNameType,
        ScimV2OrganizationsOrgUsersPostBodyType,
        ScimV2OrganizationsOrgUsersScimUserIdPatchBodyPropOperationsItemsType,
        ScimV2OrganizationsOrgUsersScimUserIdPatchBodyType,
        ScimV2OrganizationsOrgUsersScimUserIdPutBodyPropEmailsItemsType,
        ScimV2OrganizationsOrgUsersScimUserIdPutBodyPropNameType,
        ScimV2OrganizationsOrgUsersScimUserIdPutBodyType,
    )


class ScimClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_provisioned_identities(
        self,
        org: str,
        *,
        start_index: Missing[int] = UNSET,
        count: Missing[int] = UNSET,
        filter_: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ScimUserList, ScimUserListTypeForResponse]:
        """scim/list-provisioned-identities

        GET /scim/v2/organizations/{org}/Users

        Retrieves a paginated list of all provisioned organization members, including pending invitations. If you provide the `filter` parameter, the resources for all matching provisions members are returned.

        The returned list of SCIM provisioned identities from the GitHub Enterprise Cloud might not always match the organization or enterprise member list. Here is why that can occur:
          - When an organization invitation is generated by a SCIM integration, this creates an unlinked SCIM identity in the organization. When a user logs into their GitHub user account, visits the organization, and successfully authenticates via SAML, they get added as an organization member and linked to their SAML/SCIM identity in the organization. If the user does not do this, the SCIM identity will remain in the organization, not linked to any organization member.
          - A user's organization membership (inviting and removing a user to/from the organization) should only be managed by a SCIM integration when this is configured for a GitHub organization. If a GitHub user who has a linked SCIM identity is removed from the organization using the GitHub UI or non-SCIM API, as opposed to the SCIM integration, this can leave behind a stale SAML/SCIM identity in the organization for the user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/scim/scim#list-scim-provisioned-identities
        """

        from ..models import ScimError, ScimUserList

        url = f"/scim/v2/organizations/{org}/Users"

        params = {
            "startIndex": start_index,
            "count": count,
            "filter": filter_,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimUserList,
            error_models={
                "404": ScimError,
                "403": ScimError,
                "400": ScimError,
                "429": ScimError,
            },
        )

    async def async_list_provisioned_identities(
        self,
        org: str,
        *,
        start_index: Missing[int] = UNSET,
        count: Missing[int] = UNSET,
        filter_: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ScimUserList, ScimUserListTypeForResponse]:
        """scim/list-provisioned-identities

        GET /scim/v2/organizations/{org}/Users

        Retrieves a paginated list of all provisioned organization members, including pending invitations. If you provide the `filter` parameter, the resources for all matching provisions members are returned.

        The returned list of SCIM provisioned identities from the GitHub Enterprise Cloud might not always match the organization or enterprise member list. Here is why that can occur:
          - When an organization invitation is generated by a SCIM integration, this creates an unlinked SCIM identity in the organization. When a user logs into their GitHub user account, visits the organization, and successfully authenticates via SAML, they get added as an organization member and linked to their SAML/SCIM identity in the organization. If the user does not do this, the SCIM identity will remain in the organization, not linked to any organization member.
          - A user's organization membership (inviting and removing a user to/from the organization) should only be managed by a SCIM integration when this is configured for a GitHub organization. If a GitHub user who has a linked SCIM identity is removed from the organization using the GitHub UI or non-SCIM API, as opposed to the SCIM integration, this can leave behind a stale SAML/SCIM identity in the organization for the user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/scim/scim#list-scim-provisioned-identities
        """

        from ..models import ScimError, ScimUserList

        url = f"/scim/v2/organizations/{org}/Users"

        params = {
            "startIndex": start_index,
            "count": count,
            "filter": filter_,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimUserList,
            error_models={
                "404": ScimError,
                "403": ScimError,
                "400": ScimError,
                "429": ScimError,
            },
        )

    @overload
    def provision_and_invite_user(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ScimV2OrganizationsOrgUsersPostBodyType,
    ) -> Response[ScimUser, ScimUserTypeForResponse]: ...

    @overload
    def provision_and_invite_user(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        user_name: str,
        display_name: Missing[str] = UNSET,
        name: ScimV2OrganizationsOrgUsersPostBodyPropNameType,
        emails: list[ScimV2OrganizationsOrgUsersPostBodyPropEmailsItemsType],
        schemas: Missing[list[str]] = UNSET,
        external_id: Missing[str] = UNSET,
        groups: Missing[list[str]] = UNSET,
        active: Missing[bool] = UNSET,
    ) -> Response[ScimUser, ScimUserTypeForResponse]: ...

    def provision_and_invite_user(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ScimV2OrganizationsOrgUsersPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ScimUser, ScimUserTypeForResponse]:
        """scim/provision-and-invite-user

        POST /scim/v2/organizations/{org}/Users

        Provisions organization membership for a user, and sends an activation email to the email address. If the user was previously a member of the organization, the invitation will reinstate any former privileges that the user had. For more information about reinstating former members, see "[Reinstating a former member of your organization](https://docs.github.com/enterprise-cloud@latest//organizations/managing-membership-in-your-organization/reinstating-a-former-member-of-your-organization)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/scim/scim#provision-and-invite-a-scim-user
        """

        from ..models import ScimError, ScimUser, ScimV2OrganizationsOrgUsersPostBody

        url = f"/scim/v2/organizations/{org}/Users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ScimV2OrganizationsOrgUsersPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimUser,
            error_models={
                "404": ScimError,
                "403": ScimError,
                "500": ScimError,
                "409": ScimError,
                "400": ScimError,
            },
        )

    @overload
    async def async_provision_and_invite_user(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ScimV2OrganizationsOrgUsersPostBodyType,
    ) -> Response[ScimUser, ScimUserTypeForResponse]: ...

    @overload
    async def async_provision_and_invite_user(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        user_name: str,
        display_name: Missing[str] = UNSET,
        name: ScimV2OrganizationsOrgUsersPostBodyPropNameType,
        emails: list[ScimV2OrganizationsOrgUsersPostBodyPropEmailsItemsType],
        schemas: Missing[list[str]] = UNSET,
        external_id: Missing[str] = UNSET,
        groups: Missing[list[str]] = UNSET,
        active: Missing[bool] = UNSET,
    ) -> Response[ScimUser, ScimUserTypeForResponse]: ...

    async def async_provision_and_invite_user(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ScimV2OrganizationsOrgUsersPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ScimUser, ScimUserTypeForResponse]:
        """scim/provision-and-invite-user

        POST /scim/v2/organizations/{org}/Users

        Provisions organization membership for a user, and sends an activation email to the email address. If the user was previously a member of the organization, the invitation will reinstate any former privileges that the user had. For more information about reinstating former members, see "[Reinstating a former member of your organization](https://docs.github.com/enterprise-cloud@latest//organizations/managing-membership-in-your-organization/reinstating-a-former-member-of-your-organization)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/scim/scim#provision-and-invite-a-scim-user
        """

        from ..models import ScimError, ScimUser, ScimV2OrganizationsOrgUsersPostBody

        url = f"/scim/v2/organizations/{org}/Users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ScimV2OrganizationsOrgUsersPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimUser,
            error_models={
                "404": ScimError,
                "403": ScimError,
                "500": ScimError,
                "409": ScimError,
                "400": ScimError,
            },
        )

    def get_provisioning_information_for_user(
        self,
        org: str,
        scim_user_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ScimUser, ScimUserTypeForResponse]:
        """scim/get-provisioning-information-for-user

        GET /scim/v2/organizations/{org}/Users/{scim_user_id}

        Gets SCIM provisioning information for a user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/scim/scim#get-scim-provisioning-information-for-a-user
        """

        from ..models import ScimError, ScimUser

        url = f"/scim/v2/organizations/{org}/Users/{scim_user_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimUser,
            error_models={
                "404": ScimError,
                "403": ScimError,
            },
        )

    async def async_get_provisioning_information_for_user(
        self,
        org: str,
        scim_user_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ScimUser, ScimUserTypeForResponse]:
        """scim/get-provisioning-information-for-user

        GET /scim/v2/organizations/{org}/Users/{scim_user_id}

        Gets SCIM provisioning information for a user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/scim/scim#get-scim-provisioning-information-for-a-user
        """

        from ..models import ScimError, ScimUser

        url = f"/scim/v2/organizations/{org}/Users/{scim_user_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimUser,
            error_models={
                "404": ScimError,
                "403": ScimError,
            },
        )

    @overload
    def set_information_for_provisioned_user(
        self,
        org: str,
        scim_user_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ScimV2OrganizationsOrgUsersScimUserIdPutBodyType,
    ) -> Response[ScimUser, ScimUserTypeForResponse]: ...

    @overload
    def set_information_for_provisioned_user(
        self,
        org: str,
        scim_user_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        schemas: Missing[list[str]] = UNSET,
        display_name: Missing[str] = UNSET,
        external_id: Missing[str] = UNSET,
        groups: Missing[list[str]] = UNSET,
        active: Missing[bool] = UNSET,
        user_name: str,
        name: ScimV2OrganizationsOrgUsersScimUserIdPutBodyPropNameType,
        emails: list[ScimV2OrganizationsOrgUsersScimUserIdPutBodyPropEmailsItemsType],
    ) -> Response[ScimUser, ScimUserTypeForResponse]: ...

    def set_information_for_provisioned_user(
        self,
        org: str,
        scim_user_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ScimV2OrganizationsOrgUsersScimUserIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[ScimUser, ScimUserTypeForResponse]:
        """scim/set-information-for-provisioned-user

        PUT /scim/v2/organizations/{org}/Users/{scim_user_id}

        Replaces an existing provisioned user's information. You must provide all the information required for the user as if you were provisioning them for the first time. Any existing user information that you don't provide will be removed. If you want to only update a specific attribute, use the [Update an attribute for a SCIM user](https://docs.github.com/enterprise-cloud@latest//rest/scim/scim#update-an-attribute-for-a-scim-user) endpoint instead.

        You must at least provide the required values for the user: `userName`, `name`, and `emails`.

        > [!WARNING]
        > Setting `active: false` removes the user from the organization, deletes the external identity, and deletes the associated `{scim_user_id}`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/scim/scim#update-a-provisioned-organization-membership
        """

        from ..models import (
            ScimError,
            ScimUser,
            ScimV2OrganizationsOrgUsersScimUserIdPutBody,
        )

        url = f"/scim/v2/organizations/{org}/Users/{scim_user_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ScimV2OrganizationsOrgUsersScimUserIdPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimUser,
            error_models={
                "404": ScimError,
                "403": ScimError,
            },
        )

    @overload
    async def async_set_information_for_provisioned_user(
        self,
        org: str,
        scim_user_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ScimV2OrganizationsOrgUsersScimUserIdPutBodyType,
    ) -> Response[ScimUser, ScimUserTypeForResponse]: ...

    @overload
    async def async_set_information_for_provisioned_user(
        self,
        org: str,
        scim_user_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        schemas: Missing[list[str]] = UNSET,
        display_name: Missing[str] = UNSET,
        external_id: Missing[str] = UNSET,
        groups: Missing[list[str]] = UNSET,
        active: Missing[bool] = UNSET,
        user_name: str,
        name: ScimV2OrganizationsOrgUsersScimUserIdPutBodyPropNameType,
        emails: list[ScimV2OrganizationsOrgUsersScimUserIdPutBodyPropEmailsItemsType],
    ) -> Response[ScimUser, ScimUserTypeForResponse]: ...

    async def async_set_information_for_provisioned_user(
        self,
        org: str,
        scim_user_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ScimV2OrganizationsOrgUsersScimUserIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[ScimUser, ScimUserTypeForResponse]:
        """scim/set-information-for-provisioned-user

        PUT /scim/v2/organizations/{org}/Users/{scim_user_id}

        Replaces an existing provisioned user's information. You must provide all the information required for the user as if you were provisioning them for the first time. Any existing user information that you don't provide will be removed. If you want to only update a specific attribute, use the [Update an attribute for a SCIM user](https://docs.github.com/enterprise-cloud@latest//rest/scim/scim#update-an-attribute-for-a-scim-user) endpoint instead.

        You must at least provide the required values for the user: `userName`, `name`, and `emails`.

        > [!WARNING]
        > Setting `active: false` removes the user from the organization, deletes the external identity, and deletes the associated `{scim_user_id}`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/scim/scim#update-a-provisioned-organization-membership
        """

        from ..models import (
            ScimError,
            ScimUser,
            ScimV2OrganizationsOrgUsersScimUserIdPutBody,
        )

        url = f"/scim/v2/organizations/{org}/Users/{scim_user_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ScimV2OrganizationsOrgUsersScimUserIdPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimUser,
            error_models={
                "404": ScimError,
                "403": ScimError,
            },
        )

    def delete_user_from_org(
        self,
        org: str,
        scim_user_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """scim/delete-user-from-org

        DELETE /scim/v2/organizations/{org}/Users/{scim_user_id}

        Deletes a SCIM user from an organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/scim/scim#delete-a-scim-user-from-an-organization
        """

        from ..models import ScimError

        url = f"/scim/v2/organizations/{org}/Users/{scim_user_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": ScimError,
                "403": ScimError,
            },
        )

    async def async_delete_user_from_org(
        self,
        org: str,
        scim_user_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """scim/delete-user-from-org

        DELETE /scim/v2/organizations/{org}/Users/{scim_user_id}

        Deletes a SCIM user from an organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/scim/scim#delete-a-scim-user-from-an-organization
        """

        from ..models import ScimError

        url = f"/scim/v2/organizations/{org}/Users/{scim_user_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": ScimError,
                "403": ScimError,
            },
        )

    @overload
    def update_attribute_for_user(
        self,
        org: str,
        scim_user_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ScimV2OrganizationsOrgUsersScimUserIdPatchBodyType,
    ) -> Response[ScimUser, ScimUserTypeForResponse]: ...

    @overload
    def update_attribute_for_user(
        self,
        org: str,
        scim_user_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        schemas: Missing[list[str]] = UNSET,
        operations: list[
            ScimV2OrganizationsOrgUsersScimUserIdPatchBodyPropOperationsItemsType
        ],
    ) -> Response[ScimUser, ScimUserTypeForResponse]: ...

    def update_attribute_for_user(
        self,
        org: str,
        scim_user_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ScimV2OrganizationsOrgUsersScimUserIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ScimUser, ScimUserTypeForResponse]:
        """scim/update-attribute-for-user

        PATCH /scim/v2/organizations/{org}/Users/{scim_user_id}

        Allows you to change a provisioned user's individual attributes. To change a user's values, you must provide a specific `Operations` JSON format that contains at least one of the `add`, `remove`, or `replace` operations. For examples and more information on the SCIM operations format, see the [SCIM specification](https://tools.ietf.org/html/rfc7644#section-3.5.2).

        > [!NOTE]
        > Complicated SCIM `path` selectors that include filters are not supported. For example, a `path` selector defined as `"path": "emails[type eq \"work\"]"` will not work.

        > [!WARNING]
        > If you set `active:false` using the `replace` operation (as shown in the JSON example below), it removes the user from the organization, deletes the external identity, and deletes the associated `:scim_user_id`.
        > ```
        > {
        >   "Operations":[{
        >     "op":"replace",
        >     "value":{
        >       "active":false
        >     }
        >   }]
        > }
        > ```

        See also: https://docs.github.com/enterprise-cloud@latest//rest/scim/scim#update-an-attribute-for-a-scim-user
        """

        from ..models import (
            BasicError,
            ScimError,
            ScimUser,
            ScimV2OrganizationsOrgUsersScimUserIdPatchBody,
        )

        url = f"/scim/v2/organizations/{org}/Users/{scim_user_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ScimV2OrganizationsOrgUsersScimUserIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimUser,
            error_models={
                "404": ScimError,
                "403": ScimError,
                "400": ScimError,
                "429": BasicError,
            },
        )

    @overload
    async def async_update_attribute_for_user(
        self,
        org: str,
        scim_user_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ScimV2OrganizationsOrgUsersScimUserIdPatchBodyType,
    ) -> Response[ScimUser, ScimUserTypeForResponse]: ...

    @overload
    async def async_update_attribute_for_user(
        self,
        org: str,
        scim_user_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        schemas: Missing[list[str]] = UNSET,
        operations: list[
            ScimV2OrganizationsOrgUsersScimUserIdPatchBodyPropOperationsItemsType
        ],
    ) -> Response[ScimUser, ScimUserTypeForResponse]: ...

    async def async_update_attribute_for_user(
        self,
        org: str,
        scim_user_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ScimV2OrganizationsOrgUsersScimUserIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ScimUser, ScimUserTypeForResponse]:
        """scim/update-attribute-for-user

        PATCH /scim/v2/organizations/{org}/Users/{scim_user_id}

        Allows you to change a provisioned user's individual attributes. To change a user's values, you must provide a specific `Operations` JSON format that contains at least one of the `add`, `remove`, or `replace` operations. For examples and more information on the SCIM operations format, see the [SCIM specification](https://tools.ietf.org/html/rfc7644#section-3.5.2).

        > [!NOTE]
        > Complicated SCIM `path` selectors that include filters are not supported. For example, a `path` selector defined as `"path": "emails[type eq \"work\"]"` will not work.

        > [!WARNING]
        > If you set `active:false` using the `replace` operation (as shown in the JSON example below), it removes the user from the organization, deletes the external identity, and deletes the associated `:scim_user_id`.
        > ```
        > {
        >   "Operations":[{
        >     "op":"replace",
        >     "value":{
        >       "active":false
        >     }
        >   }]
        > }
        > ```

        See also: https://docs.github.com/enterprise-cloud@latest//rest/scim/scim#update-an-attribute-for-a-scim-user
        """

        from ..models import (
            BasicError,
            ScimError,
            ScimUser,
            ScimV2OrganizationsOrgUsersScimUserIdPatchBody,
        )

        url = f"/scim/v2/organizations/{org}/Users/{scim_user_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ScimV2OrganizationsOrgUsersScimUserIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ScimUser,
            error_models={
                "404": ScimError,
                "403": ScimError,
                "400": ScimError,
                "429": BasicError,
            },
        )
