"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

import datetime as _dt
from typing import Literal, Union

from pydantic import Field

from githubkit.compat import GitHubModel, model_rebuild
from githubkit.typing import Missing
from githubkit.utils import UNSET


class WebhooksProject(GitHubModel):
    """Project"""

    body: Union[str, None] = Field(description="Body of the project")
    columns_url: str = Field()
    created_at: _dt.datetime = Field()
    creator: Union[WebhooksProjectPropCreator, None] = Field(title="User")
    html_url: str = Field()
    id: int = Field()
    name: str = Field(description="Name of the project")
    node_id: str = Field()
    number: int = Field()
    owner_url: str = Field()
    state: Literal["open", "closed"] = Field(
        description="State of the project; either 'open' or 'closed'"
    )
    updated_at: _dt.datetime = Field()
    url: str = Field()


class WebhooksProjectPropCreator(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    user_view_type: Missing[str] = Field(default=UNSET)


model_rebuild(WebhooksProject)
model_rebuild(WebhooksProjectPropCreator)

__all__ = (
    "WebhooksProject",
    "WebhooksProjectPropCreator",
)
