"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from typing_extensions import deprecated
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset, parse_query_params

if TYPE_CHECKING:
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        Codespace,
        CodespaceExportDetails,
        CodespacesOrgSecret,
        CodespacesPermissionsCheckForDevcontainer,
        CodespacesPublicKey,
        CodespacesSecret,
        CodespacesUserPublicKey,
        CodespaceWithFullRepository,
        EmptyObject,
        OrgsOrgCodespacesGetResponse200,
        OrgsOrgCodespacesSecretsGetResponse200,
        OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200,
        OrgsOrgMembersUsernameCodespacesGetResponse200,
        RepoCodespacesSecret,
        ReposOwnerRepoCodespacesDevcontainersGetResponse200,
        ReposOwnerRepoCodespacesGetResponse200,
        ReposOwnerRepoCodespacesMachinesGetResponse200,
        ReposOwnerRepoCodespacesNewGetResponse200,
        ReposOwnerRepoCodespacesSecretsGetResponse200,
        UserCodespacesCodespaceNameMachinesGetResponse200,
        UserCodespacesGetResponse200,
        UserCodespacesSecretsGetResponse200,
        UserCodespacesSecretsSecretNameRepositoriesGetResponse200,
    )
    from ..types import (
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
        CodespaceExportDetailsTypeForResponse,
        CodespacesOrgSecretTypeForResponse,
        CodespacesPermissionsCheckForDevcontainerTypeForResponse,
        CodespacesPublicKeyTypeForResponse,
        CodespacesSecretTypeForResponse,
        CodespacesUserPublicKeyTypeForResponse,
        CodespaceTypeForResponse,
        CodespaceWithFullRepositoryTypeForResponse,
        EmptyObjectTypeForResponse,
        OrgsOrgCodespacesAccessPutBodyType,
        OrgsOrgCodespacesAccessSelectedUsersDeleteBodyType,
        OrgsOrgCodespacesAccessSelectedUsersPostBodyType,
        OrgsOrgCodespacesGetResponse200TypeForResponse,
        OrgsOrgCodespacesSecretsGetResponse200TypeForResponse,
        OrgsOrgCodespacesSecretsSecretNamePutBodyType,
        OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200TypeForResponse,
        OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBodyType,
        OrgsOrgMembersUsernameCodespacesGetResponse200TypeForResponse,
        RepoCodespacesSecretTypeForResponse,
        ReposOwnerRepoCodespacesDevcontainersGetResponse200TypeForResponse,
        ReposOwnerRepoCodespacesGetResponse200TypeForResponse,
        ReposOwnerRepoCodespacesMachinesGetResponse200TypeForResponse,
        ReposOwnerRepoCodespacesNewGetResponse200TypeForResponse,
        ReposOwnerRepoCodespacesPostBodyType,
        ReposOwnerRepoCodespacesSecretsGetResponse200TypeForResponse,
        ReposOwnerRepoCodespacesSecretsSecretNamePutBodyType,
        ReposOwnerRepoPullsPullNumberCodespacesPostBodyType,
        UserCodespacesCodespaceNameMachinesGetResponse200TypeForResponse,
        UserCodespacesCodespaceNamePatchBodyType,
        UserCodespacesCodespaceNamePublishPostBodyType,
        UserCodespacesGetResponse200TypeForResponse,
        UserCodespacesPostBodyOneof0Type,
        UserCodespacesPostBodyOneof1PropPullRequestType,
        UserCodespacesPostBodyOneof1Type,
        UserCodespacesSecretsGetResponse200TypeForResponse,
        UserCodespacesSecretsSecretNamePutBodyType,
        UserCodespacesSecretsSecretNameRepositoriesGetResponse200TypeForResponse,
        UserCodespacesSecretsSecretNameRepositoriesPutBodyType,
    )


class CodespacesClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_in_organization(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgCodespacesGetResponse200, OrgsOrgCodespacesGetResponse200TypeForResponse
    ]:
        """codespaces/list-in-organization

        GET /orgs/{org}/codespaces

        Lists the codespaces associated to a specified organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organizations#list-codespaces-for-the-organization
        """

        from ..models import BasicError, OrgsOrgCodespacesGetResponse200

        url = f"/orgs/{org}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_in_organization(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgCodespacesGetResponse200, OrgsOrgCodespacesGetResponse200TypeForResponse
    ]:
        """codespaces/list-in-organization

        GET /orgs/{org}/codespaces

        Lists the codespaces associated to a specified organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organizations#list-codespaces-for-the-organization
        """

        from ..models import BasicError, OrgsOrgCodespacesGetResponse200

        url = f"/orgs/{org}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def set_codespaces_access(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCodespacesAccessPutBodyType,
    ) -> Response: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def set_codespaces_access(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        visibility: Literal[
            "disabled",
            "selected_members",
            "all_members",
            "all_members_and_outside_collaborators",
        ],
        selected_usernames: Missing[list[str]] = UNSET,
    ) -> Response: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def set_codespaces_access(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgCodespacesAccessPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED codespaces/set-codespaces-access

        PUT /orgs/{org}/codespaces/access

        Sets which users can access codespaces in an organization. This is synonymous with granting or revoking codespaces access permissions for users according to the visibility.
        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organizations#manage-access-control-for-organization-codespaces
        """

        from ..models import BasicError, OrgsOrgCodespacesAccessPutBody, ValidationError

        url = f"/orgs/{org}/codespaces/access"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgCodespacesAccessPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_set_codespaces_access(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCodespacesAccessPutBodyType,
    ) -> Response: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_set_codespaces_access(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        visibility: Literal[
            "disabled",
            "selected_members",
            "all_members",
            "all_members_and_outside_collaborators",
        ],
        selected_usernames: Missing[list[str]] = UNSET,
    ) -> Response: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_set_codespaces_access(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgCodespacesAccessPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED codespaces/set-codespaces-access

        PUT /orgs/{org}/codespaces/access

        Sets which users can access codespaces in an organization. This is synonymous with granting or revoking codespaces access permissions for users according to the visibility.
        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organizations#manage-access-control-for-organization-codespaces
        """

        from ..models import BasicError, OrgsOrgCodespacesAccessPutBody, ValidationError

        url = f"/orgs/{org}/codespaces/access"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgCodespacesAccessPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def set_codespaces_access_users(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCodespacesAccessSelectedUsersPostBodyType,
    ) -> Response: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def set_codespaces_access_users(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_usernames: list[str],
    ) -> Response: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def set_codespaces_access_users(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgCodespacesAccessSelectedUsersPostBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED codespaces/set-codespaces-access-users

        POST /orgs/{org}/codespaces/access/selected_users

        Codespaces for the specified users will be billed to the organization.

        To use this endpoint, the access settings for the organization must be set to `selected_members`.
        For information on how to change this setting, see "[Manage access control for organization codespaces](https://docs.github.com/rest/codespaces/organizations#manage-access-control-for-organization-codespaces)."

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organizations#add-users-to-codespaces-access-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgCodespacesAccessSelectedUsersPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/codespaces/access/selected_users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCodespacesAccessSelectedUsersPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_set_codespaces_access_users(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCodespacesAccessSelectedUsersPostBodyType,
    ) -> Response: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_set_codespaces_access_users(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_usernames: list[str],
    ) -> Response: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_set_codespaces_access_users(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgCodespacesAccessSelectedUsersPostBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED codespaces/set-codespaces-access-users

        POST /orgs/{org}/codespaces/access/selected_users

        Codespaces for the specified users will be billed to the organization.

        To use this endpoint, the access settings for the organization must be set to `selected_members`.
        For information on how to change this setting, see "[Manage access control for organization codespaces](https://docs.github.com/rest/codespaces/organizations#manage-access-control-for-organization-codespaces)."

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organizations#add-users-to-codespaces-access-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgCodespacesAccessSelectedUsersPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/codespaces/access/selected_users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCodespacesAccessSelectedUsersPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def delete_codespaces_access_users(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCodespacesAccessSelectedUsersDeleteBodyType,
    ) -> Response: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def delete_codespaces_access_users(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_usernames: list[str],
    ) -> Response: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def delete_codespaces_access_users(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgCodespacesAccessSelectedUsersDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED codespaces/delete-codespaces-access-users

        DELETE /orgs/{org}/codespaces/access/selected_users

        Codespaces for the specified users will no longer be billed to the organization.

        To use this endpoint, the access settings for the organization must be set to `selected_members`.
        For information on how to change this setting, see "[Manage access control for organization codespaces](https://docs.github.com/rest/codespaces/organizations#manage-access-control-for-organization-codespaces)."

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organizations#remove-users-from-codespaces-access-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgCodespacesAccessSelectedUsersDeleteBody,
            ValidationError,
        )

        url = f"/orgs/{org}/codespaces/access/selected_users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCodespacesAccessSelectedUsersDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_delete_codespaces_access_users(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCodespacesAccessSelectedUsersDeleteBodyType,
    ) -> Response: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_delete_codespaces_access_users(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_usernames: list[str],
    ) -> Response: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_delete_codespaces_access_users(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgCodespacesAccessSelectedUsersDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED codespaces/delete-codespaces-access-users

        DELETE /orgs/{org}/codespaces/access/selected_users

        Codespaces for the specified users will no longer be billed to the organization.

        To use this endpoint, the access settings for the organization must be set to `selected_members`.
        For information on how to change this setting, see "[Manage access control for organization codespaces](https://docs.github.com/rest/codespaces/organizations#manage-access-control-for-organization-codespaces)."

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organizations#remove-users-from-codespaces-access-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgCodespacesAccessSelectedUsersDeleteBody,
            ValidationError,
        )

        url = f"/orgs/{org}/codespaces/access/selected_users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCodespacesAccessSelectedUsersDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    def list_org_secrets(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgCodespacesSecretsGetResponse200,
        OrgsOrgCodespacesSecretsGetResponse200TypeForResponse,
    ]:
        """codespaces/list-org-secrets

        GET /orgs/{org}/codespaces/secrets

        Lists all Codespaces development environment secrets available at the organization-level without revealing their encrypted
        values.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organization-secrets#list-organization-secrets
        """

        from ..models import OrgsOrgCodespacesSecretsGetResponse200

        url = f"/orgs/{org}/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgCodespacesSecretsGetResponse200,
        )

    async def async_list_org_secrets(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgCodespacesSecretsGetResponse200,
        OrgsOrgCodespacesSecretsGetResponse200TypeForResponse,
    ]:
        """codespaces/list-org-secrets

        GET /orgs/{org}/codespaces/secrets

        Lists all Codespaces development environment secrets available at the organization-level without revealing their encrypted
        values.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organization-secrets#list-organization-secrets
        """

        from ..models import OrgsOrgCodespacesSecretsGetResponse200

        url = f"/orgs/{org}/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgCodespacesSecretsGetResponse200,
        )

    def get_org_public_key(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CodespacesPublicKey, CodespacesPublicKeyTypeForResponse]:
        """codespaces/get-org-public-key

        GET /orgs/{org}/codespaces/secrets/public-key

        Gets a public key for an organization, which is required in order to encrypt secrets. You need to encrypt the value of a secret before you can create or update secrets.
        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organization-secrets#get-an-organization-public-key
        """

        from ..models import CodespacesPublicKey

        url = f"/orgs/{org}/codespaces/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CodespacesPublicKey,
        )

    async def async_get_org_public_key(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CodespacesPublicKey, CodespacesPublicKeyTypeForResponse]:
        """codespaces/get-org-public-key

        GET /orgs/{org}/codespaces/secrets/public-key

        Gets a public key for an organization, which is required in order to encrypt secrets. You need to encrypt the value of a secret before you can create or update secrets.
        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organization-secrets#get-an-organization-public-key
        """

        from ..models import CodespacesPublicKey

        url = f"/orgs/{org}/codespaces/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CodespacesPublicKey,
        )

    def get_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CodespacesOrgSecret, CodespacesOrgSecretTypeForResponse]:
        """codespaces/get-org-secret

        GET /orgs/{org}/codespaces/secrets/{secret_name}

        Gets an organization development environment secret without revealing its encrypted value.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organization-secrets#get-an-organization-secret
        """

        from ..models import CodespacesOrgSecret

        url = f"/orgs/{org}/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CodespacesOrgSecret,
        )

    async def async_get_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CodespacesOrgSecret, CodespacesOrgSecretTypeForResponse]:
        """codespaces/get-org-secret

        GET /orgs/{org}/codespaces/secrets/{secret_name}

        Gets an organization development environment secret without revealing its encrypted value.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organization-secrets#get-an-organization-secret
        """

        from ..models import CodespacesOrgSecret

        url = f"/orgs/{org}/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CodespacesOrgSecret,
        )

    @overload
    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCodespacesSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject, EmptyObjectTypeForResponse]: ...

    @overload
    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[list[int]] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectTypeForResponse]: ...

    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgCodespacesSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectTypeForResponse]:
        """codespaces/create-or-update-org-secret

        PUT /orgs/{org}/codespaces/secrets/{secret_name}

        Creates or updates an organization development environment secret with an encrypted value. Encrypt your secret using
        [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organization-secrets#create-or-update-an-organization-secret
        """

        from ..models import (
            BasicError,
            EmptyObject,
            OrgsOrgCodespacesSecretsSecretNamePutBody,
            ValidationError,
        )

        url = f"/orgs/{org}/codespaces/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgCodespacesSecretsSecretNamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCodespacesSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject, EmptyObjectTypeForResponse]: ...

    @overload
    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[list[int]] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectTypeForResponse]: ...

    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgCodespacesSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectTypeForResponse]:
        """codespaces/create-or-update-org-secret

        PUT /orgs/{org}/codespaces/secrets/{secret_name}

        Creates or updates an organization development environment secret with an encrypted value. Encrypt your secret using
        [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organization-secrets#create-or-update-an-organization-secret
        """

        from ..models import (
            BasicError,
            EmptyObject,
            OrgsOrgCodespacesSecretsSecretNamePutBody,
            ValidationError,
        )

        url = f"/orgs/{org}/codespaces/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgCodespacesSecretsSecretNamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def delete_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """codespaces/delete-org-secret

        DELETE /orgs/{org}/codespaces/secrets/{secret_name}

        Deletes an organization development environment secret using the secret name.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organization-secrets#delete-an-organization-secret
        """

        from ..models import BasicError

        url = f"/orgs/{org}/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """codespaces/delete-org-secret

        DELETE /orgs/{org}/codespaces/secrets/{secret_name}

        Deletes an organization development environment secret using the secret name.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organization-secrets#delete-an-organization-secret
        """

        from ..models import BasicError

        url = f"/orgs/{org}/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    def list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200,
        OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200TypeForResponse,
    ]:
        """codespaces/list-selected-repos-for-org-secret

        GET /orgs/{org}/codespaces/secrets/{secret_name}/repositories

        Lists all repositories that have been selected when the `visibility`
        for repository access to a secret is set to `selected`.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organization-secrets#list-selected-repositories-for-an-organization-secret
        """

        from ..models import (
            BasicError,
            OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200,
        )

        url = f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200,
        OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200TypeForResponse,
    ]:
        """codespaces/list-selected-repos-for-org-secret

        GET /orgs/{org}/codespaces/secrets/{secret_name}/repositories

        Lists all repositories that have been selected when the `visibility`
        for repository access to a secret is set to `selected`.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organization-secrets#list-selected-repositories-for-an-organization-secret
        """

        from ..models import (
            BasicError,
            OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200,
        )

        url = f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_repository_ids: list[int],
    ) -> Response: ...

    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """codespaces/set-selected-repos-for-org-secret

        PUT /orgs/{org}/codespaces/secrets/{secret_name}/repositories

        Replaces all repositories for an organization development environment secret when the `visibility`
        for repository access is set to `selected`. The visibility is set when you [Create
        or update an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#create-or-update-an-organization-secret).

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organization-secrets#set-selected-repositories-for-an-organization-secret
        """

        from ..models import (
            BasicError,
            OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBody,
        )

        url = f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_repository_ids: list[int],
    ) -> Response: ...

    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """codespaces/set-selected-repos-for-org-secret

        PUT /orgs/{org}/codespaces/secrets/{secret_name}/repositories

        Replaces all repositories for an organization development environment secret when the `visibility`
        for repository access is set to `selected`. The visibility is set when you [Create
        or update an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#create-or-update-an-organization-secret).

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organization-secrets#set-selected-repositories-for-an-organization-secret
        """

        from ..models import (
            BasicError,
            OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBody,
        )

        url = f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    def add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """codespaces/add-selected-repo-to-org-secret

        PUT /orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}

        Adds a repository to an organization development environment secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#create-or-update-an-organization-secret).
        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organization-secrets#add-selected-repository-to-an-organization-secret
        """

        from ..models import BasicError, ValidationError

        url = (
            f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """codespaces/add-selected-repo-to-org-secret

        PUT /orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}

        Adds a repository to an organization development environment secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#create-or-update-an-organization-secret).
        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organization-secrets#add-selected-repository-to-an-organization-secret
        """

        from ..models import BasicError, ValidationError

        url = (
            f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """codespaces/remove-selected-repo-from-org-secret

        DELETE /orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}

        Removes a repository from an organization development environment secret when the `visibility`
        for repository access is set to `selected`. The visibility is set when you [Create
        or update an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#create-or-update-an-organization-secret).

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organization-secrets#remove-selected-repository-from-an-organization-secret
        """

        from ..models import BasicError, ValidationError

        url = (
            f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """codespaces/remove-selected-repo-from-org-secret

        DELETE /orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}

        Removes a repository from an organization development environment secret when the `visibility`
        for repository access is set to `selected`. The visibility is set when you [Create
        or update an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#create-or-update-an-organization-secret).

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organization-secrets#remove-selected-repository-from-an-organization-secret
        """

        from ..models import BasicError, ValidationError

        url = (
            f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_codespaces_for_user_in_org(
        self,
        org: str,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgMembersUsernameCodespacesGetResponse200,
        OrgsOrgMembersUsernameCodespacesGetResponse200TypeForResponse,
    ]:
        """codespaces/get-codespaces-for-user-in-org

        GET /orgs/{org}/members/{username}/codespaces

        Lists the codespaces that a member of an organization has for repositories in that organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organizations#list-codespaces-for-a-user-in-organization
        """

        from ..models import BasicError, OrgsOrgMembersUsernameCodespacesGetResponse200

        url = f"/orgs/{org}/members/{username}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgMembersUsernameCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_codespaces_for_user_in_org(
        self,
        org: str,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgMembersUsernameCodespacesGetResponse200,
        OrgsOrgMembersUsernameCodespacesGetResponse200TypeForResponse,
    ]:
        """codespaces/get-codespaces-for-user-in-org

        GET /orgs/{org}/members/{username}/codespaces

        Lists the codespaces that a member of an organization has for repositories in that organization.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organizations#list-codespaces-for-a-user-in-organization
        """

        from ..models import BasicError, OrgsOrgMembersUsernameCodespacesGetResponse200

        url = f"/orgs/{org}/members/{username}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgMembersUsernameCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete_from_organization(
        self,
        org: str,
        username: str,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
    ]:
        """codespaces/delete-from-organization

        DELETE /orgs/{org}/members/{username}/codespaces/{codespace_name}

        Deletes a user's codespace.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organizations#delete-a-codespace-from-the-organization
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
        )

        url = f"/orgs/{org}/members/{username}/codespaces/{codespace_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_from_organization(
        self,
        org: str,
        username: str,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
    ]:
        """codespaces/delete-from-organization

        DELETE /orgs/{org}/members/{username}/codespaces/{codespace_name}

        Deletes a user's codespace.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organizations#delete-a-codespace-from-the-organization
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
        )

        url = f"/orgs/{org}/members/{username}/codespaces/{codespace_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def stop_in_organization(
        self,
        org: str,
        username: str,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Codespace, CodespaceTypeForResponse]:
        """codespaces/stop-in-organization

        POST /orgs/{org}/members/{username}/codespaces/{codespace_name}/stop

        Stops a user's codespace.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organizations#stop-a-codespace-for-an-organization-user
        """

        from ..models import BasicError, Codespace

        url = f"/orgs/{org}/members/{username}/codespaces/{codespace_name}/stop"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_stop_in_organization(
        self,
        org: str,
        username: str,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Codespace, CodespaceTypeForResponse]:
        """codespaces/stop-in-organization

        POST /orgs/{org}/members/{username}/codespaces/{codespace_name}/stop

        Stops a user's codespace.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/organizations#stop-a-codespace-for-an-organization-user
        """

        from ..models import BasicError, Codespace

        url = f"/orgs/{org}/members/{username}/codespaces/{codespace_name}/stop"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_in_repository_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoCodespacesGetResponse200,
        ReposOwnerRepoCodespacesGetResponse200TypeForResponse,
    ]:
        """codespaces/list-in-repository-for-authenticated-user

        GET /repos/{owner}/{repo}/codespaces

        Lists the codespaces associated to a specified repository and the authenticated user.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#list-codespaces-in-a-repository-for-the-authenticated-user
        """

        from ..models import BasicError, ReposOwnerRepoCodespacesGetResponse200

        url = f"/repos/{owner}/{repo}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_in_repository_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoCodespacesGetResponse200,
        ReposOwnerRepoCodespacesGetResponse200TypeForResponse,
    ]:
        """codespaces/list-in-repository-for-authenticated-user

        GET /repos/{owner}/{repo}/codespaces

        Lists the codespaces associated to a specified repository and the authenticated user.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#list-codespaces-in-a-repository-for-the-authenticated-user
        """

        from ..models import BasicError, ReposOwnerRepoCodespacesGetResponse200

        url = f"/repos/{owner}/{repo}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[ReposOwnerRepoCodespacesPostBodyType, None],
    ) -> Response[Codespace, CodespaceTypeForResponse]: ...

    @overload
    def create_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        ref: Missing[str] = UNSET,
        location: Missing[str] = UNSET,
        geo: Missing[
            Literal["EuropeWest", "SoutheastAsia", "UsEast", "UsWest"]
        ] = UNSET,
        client_ip: Missing[str] = UNSET,
        machine: Missing[str] = UNSET,
        devcontainer_path: Missing[str] = UNSET,
        multi_repo_permissions_opt_out: Missing[bool] = UNSET,
        working_directory: Missing[str] = UNSET,
        idle_timeout_minutes: Missing[int] = UNSET,
        display_name: Missing[str] = UNSET,
        retention_period_minutes: Missing[int] = UNSET,
    ) -> Response[Codespace, CodespaceTypeForResponse]: ...

    def create_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[Union[ReposOwnerRepoCodespacesPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[Codespace, CodespaceTypeForResponse]:
        """codespaces/create-with-repo-for-authenticated-user

        POST /repos/{owner}/{repo}/codespaces

        Creates a codespace owned by the authenticated user in the specified repository.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#create-a-codespace-in-a-repository
        """

        from typing import Union

        from ..models import (
            BasicError,
            Codespace,
            EventsGetResponse503,
            ReposOwnerRepoCodespacesPostBody,
        )

        url = f"/repos/{owner}/{repo}/codespaces"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoCodespacesPostBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Codespace,
            error_models={
                "400": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "503": EventsGetResponse503,
            },
        )

    @overload
    async def async_create_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[ReposOwnerRepoCodespacesPostBodyType, None],
    ) -> Response[Codespace, CodespaceTypeForResponse]: ...

    @overload
    async def async_create_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        ref: Missing[str] = UNSET,
        location: Missing[str] = UNSET,
        geo: Missing[
            Literal["EuropeWest", "SoutheastAsia", "UsEast", "UsWest"]
        ] = UNSET,
        client_ip: Missing[str] = UNSET,
        machine: Missing[str] = UNSET,
        devcontainer_path: Missing[str] = UNSET,
        multi_repo_permissions_opt_out: Missing[bool] = UNSET,
        working_directory: Missing[str] = UNSET,
        idle_timeout_minutes: Missing[int] = UNSET,
        display_name: Missing[str] = UNSET,
        retention_period_minutes: Missing[int] = UNSET,
    ) -> Response[Codespace, CodespaceTypeForResponse]: ...

    async def async_create_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[Union[ReposOwnerRepoCodespacesPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[Codespace, CodespaceTypeForResponse]:
        """codespaces/create-with-repo-for-authenticated-user

        POST /repos/{owner}/{repo}/codespaces

        Creates a codespace owned by the authenticated user in the specified repository.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#create-a-codespace-in-a-repository
        """

        from typing import Union

        from ..models import (
            BasicError,
            Codespace,
            EventsGetResponse503,
            ReposOwnerRepoCodespacesPostBody,
        )

        url = f"/repos/{owner}/{repo}/codespaces"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoCodespacesPostBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Codespace,
            error_models={
                "400": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "503": EventsGetResponse503,
            },
        )

    def list_devcontainers_in_repository_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoCodespacesDevcontainersGetResponse200,
        ReposOwnerRepoCodespacesDevcontainersGetResponse200TypeForResponse,
    ]:
        """codespaces/list-devcontainers-in-repository-for-authenticated-user

        GET /repos/{owner}/{repo}/codespaces/devcontainers

        Lists the devcontainer.json files associated with a specified repository and the authenticated user. These files
        specify launchpoint configurations for codespaces created within the repository.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#list-devcontainer-configurations-in-a-repository-for-the-authenticated-user
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoCodespacesDevcontainersGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/codespaces/devcontainers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoCodespacesDevcontainersGetResponse200,
            error_models={
                "500": BasicError,
                "400": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_devcontainers_in_repository_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoCodespacesDevcontainersGetResponse200,
        ReposOwnerRepoCodespacesDevcontainersGetResponse200TypeForResponse,
    ]:
        """codespaces/list-devcontainers-in-repository-for-authenticated-user

        GET /repos/{owner}/{repo}/codespaces/devcontainers

        Lists the devcontainer.json files associated with a specified repository and the authenticated user. These files
        specify launchpoint configurations for codespaces created within the repository.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#list-devcontainer-configurations-in-a-repository-for-the-authenticated-user
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoCodespacesDevcontainersGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/codespaces/devcontainers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoCodespacesDevcontainersGetResponse200,
            error_models={
                "500": BasicError,
                "400": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def repo_machines_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        location: Missing[str] = UNSET,
        client_ip: Missing[str] = UNSET,
        ref: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoCodespacesMachinesGetResponse200,
        ReposOwnerRepoCodespacesMachinesGetResponse200TypeForResponse,
    ]:
        """codespaces/repo-machines-for-authenticated-user

        GET /repos/{owner}/{repo}/codespaces/machines

        List the machine types available for a given repository based on its configuration.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/machines#list-available-machine-types-for-a-repository
        """

        from ..models import BasicError, ReposOwnerRepoCodespacesMachinesGetResponse200

        url = f"/repos/{owner}/{repo}/codespaces/machines"

        params = {
            "location": location,
            "client_ip": client_ip,
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoCodespacesMachinesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_repo_machines_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        location: Missing[str] = UNSET,
        client_ip: Missing[str] = UNSET,
        ref: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoCodespacesMachinesGetResponse200,
        ReposOwnerRepoCodespacesMachinesGetResponse200TypeForResponse,
    ]:
        """codespaces/repo-machines-for-authenticated-user

        GET /repos/{owner}/{repo}/codespaces/machines

        List the machine types available for a given repository based on its configuration.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/machines#list-available-machine-types-for-a-repository
        """

        from ..models import BasicError, ReposOwnerRepoCodespacesMachinesGetResponse200

        url = f"/repos/{owner}/{repo}/codespaces/machines"

        params = {
            "location": location,
            "client_ip": client_ip,
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoCodespacesMachinesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def pre_flight_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        ref: Missing[str] = UNSET,
        client_ip: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoCodespacesNewGetResponse200,
        ReposOwnerRepoCodespacesNewGetResponse200TypeForResponse,
    ]:
        """codespaces/pre-flight-with-repo-for-authenticated-user

        GET /repos/{owner}/{repo}/codespaces/new

        Gets the default attributes for codespaces created by the user with the repository.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#get-default-attributes-for-a-codespace
        """

        from ..models import BasicError, ReposOwnerRepoCodespacesNewGetResponse200

        url = f"/repos/{owner}/{repo}/codespaces/new"

        params = {
            "ref": ref,
            "client_ip": client_ip,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoCodespacesNewGetResponse200,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_pre_flight_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        ref: Missing[str] = UNSET,
        client_ip: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoCodespacesNewGetResponse200,
        ReposOwnerRepoCodespacesNewGetResponse200TypeForResponse,
    ]:
        """codespaces/pre-flight-with-repo-for-authenticated-user

        GET /repos/{owner}/{repo}/codespaces/new

        Gets the default attributes for codespaces created by the user with the repository.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#get-default-attributes-for-a-codespace
        """

        from ..models import BasicError, ReposOwnerRepoCodespacesNewGetResponse200

        url = f"/repos/{owner}/{repo}/codespaces/new"

        params = {
            "ref": ref,
            "client_ip": client_ip,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoCodespacesNewGetResponse200,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def check_permissions_for_devcontainer(
        self,
        owner: str,
        repo: str,
        *,
        ref: str,
        devcontainer_path: str,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        CodespacesPermissionsCheckForDevcontainer,
        CodespacesPermissionsCheckForDevcontainerTypeForResponse,
    ]:
        """codespaces/check-permissions-for-devcontainer

        GET /repos/{owner}/{repo}/codespaces/permissions_check

        Checks whether the permissions defined by a given devcontainer configuration have been accepted by the authenticated user.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#check-if-permissions-defined-by-a-devcontainer-have-been-accepted-by-the-authenticated-user
        """

        from ..models import (
            BasicError,
            CodespacesPermissionsCheckForDevcontainer,
            EventsGetResponse503,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/codespaces/permissions_check"

        params = {
            "ref": ref,
            "devcontainer_path": devcontainer_path,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CodespacesPermissionsCheckForDevcontainer,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
                "503": EventsGetResponse503,
            },
        )

    async def async_check_permissions_for_devcontainer(
        self,
        owner: str,
        repo: str,
        *,
        ref: str,
        devcontainer_path: str,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        CodespacesPermissionsCheckForDevcontainer,
        CodespacesPermissionsCheckForDevcontainerTypeForResponse,
    ]:
        """codespaces/check-permissions-for-devcontainer

        GET /repos/{owner}/{repo}/codespaces/permissions_check

        Checks whether the permissions defined by a given devcontainer configuration have been accepted by the authenticated user.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#check-if-permissions-defined-by-a-devcontainer-have-been-accepted-by-the-authenticated-user
        """

        from ..models import (
            BasicError,
            CodespacesPermissionsCheckForDevcontainer,
            EventsGetResponse503,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/codespaces/permissions_check"

        params = {
            "ref": ref,
            "devcontainer_path": devcontainer_path,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CodespacesPermissionsCheckForDevcontainer,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
                "503": EventsGetResponse503,
            },
        )

    def list_repo_secrets(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoCodespacesSecretsGetResponse200,
        ReposOwnerRepoCodespacesSecretsGetResponse200TypeForResponse,
    ]:
        """codespaces/list-repo-secrets

        GET /repos/{owner}/{repo}/codespaces/secrets

        Lists all development environment secrets available in a repository without revealing their encrypted
        values.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/repository-secrets#list-repository-secrets
        """

        from ..models import ReposOwnerRepoCodespacesSecretsGetResponse200

        url = f"/repos/{owner}/{repo}/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoCodespacesSecretsGetResponse200,
        )

    async def async_list_repo_secrets(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoCodespacesSecretsGetResponse200,
        ReposOwnerRepoCodespacesSecretsGetResponse200TypeForResponse,
    ]:
        """codespaces/list-repo-secrets

        GET /repos/{owner}/{repo}/codespaces/secrets

        Lists all development environment secrets available in a repository without revealing their encrypted
        values.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/repository-secrets#list-repository-secrets
        """

        from ..models import ReposOwnerRepoCodespacesSecretsGetResponse200

        url = f"/repos/{owner}/{repo}/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoCodespacesSecretsGetResponse200,
        )

    def get_repo_public_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CodespacesPublicKey, CodespacesPublicKeyTypeForResponse]:
        """codespaces/get-repo-public-key

        GET /repos/{owner}/{repo}/codespaces/secrets/public-key

        Gets your public key, which you need to encrypt secrets. You need to
        encrypt a secret before you can create or update secrets.

        If the repository is private, OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/repository-secrets#get-a-repository-public-key
        """

        from ..models import CodespacesPublicKey

        url = f"/repos/{owner}/{repo}/codespaces/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CodespacesPublicKey,
        )

    async def async_get_repo_public_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CodespacesPublicKey, CodespacesPublicKeyTypeForResponse]:
        """codespaces/get-repo-public-key

        GET /repos/{owner}/{repo}/codespaces/secrets/public-key

        Gets your public key, which you need to encrypt secrets. You need to
        encrypt a secret before you can create or update secrets.

        If the repository is private, OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/repository-secrets#get-a-repository-public-key
        """

        from ..models import CodespacesPublicKey

        url = f"/repos/{owner}/{repo}/codespaces/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CodespacesPublicKey,
        )

    def get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RepoCodespacesSecret, RepoCodespacesSecretTypeForResponse]:
        """codespaces/get-repo-secret

        GET /repos/{owner}/{repo}/codespaces/secrets/{secret_name}

        Gets a single repository development environment secret without revealing its encrypted value.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/repository-secrets#get-a-repository-secret
        """

        from ..models import RepoCodespacesSecret

        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepoCodespacesSecret,
        )

    async def async_get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RepoCodespacesSecret, RepoCodespacesSecretTypeForResponse]:
        """codespaces/get-repo-secret

        GET /repos/{owner}/{repo}/codespaces/secrets/{secret_name}

        Gets a single repository development environment secret without revealing its encrypted value.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/repository-secrets#get-a-repository-secret
        """

        from ..models import RepoCodespacesSecret

        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepoCodespacesSecret,
        )

    @overload
    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoCodespacesSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject, EmptyObjectTypeForResponse]: ...

    @overload
    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectTypeForResponse]: ...

    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoCodespacesSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectTypeForResponse]:
        """codespaces/create-or-update-repo-secret

        PUT /repos/{owner}/{repo}/codespaces/secrets/{secret_name}

        Creates or updates a repository development environment secret with an encrypted value. Encrypt your secret using
        [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint. The associated user must be a repository admin.

        See also: https://docs.github.com/rest/codespaces/repository-secrets#create-or-update-a-repository-secret
        """

        from ..models import (
            EmptyObject,
            ReposOwnerRepoCodespacesSecretsSecretNamePutBody,
        )

        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoCodespacesSecretsSecretNamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    @overload
    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoCodespacesSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject, EmptyObjectTypeForResponse]: ...

    @overload
    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectTypeForResponse]: ...

    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoCodespacesSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectTypeForResponse]:
        """codespaces/create-or-update-repo-secret

        PUT /repos/{owner}/{repo}/codespaces/secrets/{secret_name}

        Creates or updates a repository development environment secret with an encrypted value. Encrypt your secret using
        [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint. The associated user must be a repository admin.

        See also: https://docs.github.com/rest/codespaces/repository-secrets#create-or-update-a-repository-secret
        """

        from ..models import (
            EmptyObject,
            ReposOwnerRepoCodespacesSecretsSecretNamePutBody,
        )

        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoCodespacesSecretsSecretNamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
        )

    def delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """codespaces/delete-repo-secret

        DELETE /repos/{owner}/{repo}/codespaces/secrets/{secret_name}

        Deletes a development environment secret in a repository using the secret name.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint. The associated user must be a repository admin.

        See also: https://docs.github.com/rest/codespaces/repository-secrets#delete-a-repository-secret
        """

        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """codespaces/delete-repo-secret

        DELETE /repos/{owner}/{repo}/codespaces/secrets/{secret_name}

        Deletes a development environment secret in a repository using the secret name.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint. The associated user must be a repository admin.

        See also: https://docs.github.com/rest/codespaces/repository-secrets#delete-a-repository-secret
        """

        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    def create_with_pr_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[ReposOwnerRepoPullsPullNumberCodespacesPostBodyType, None],
    ) -> Response[Codespace, CodespaceTypeForResponse]: ...

    @overload
    def create_with_pr_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        location: Missing[str] = UNSET,
        geo: Missing[
            Literal["EuropeWest", "SoutheastAsia", "UsEast", "UsWest"]
        ] = UNSET,
        client_ip: Missing[str] = UNSET,
        machine: Missing[str] = UNSET,
        devcontainer_path: Missing[str] = UNSET,
        multi_repo_permissions_opt_out: Missing[bool] = UNSET,
        working_directory: Missing[str] = UNSET,
        idle_timeout_minutes: Missing[int] = UNSET,
        display_name: Missing[str] = UNSET,
        retention_period_minutes: Missing[int] = UNSET,
    ) -> Response[Codespace, CodespaceTypeForResponse]: ...

    def create_with_pr_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberCodespacesPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[Codespace, CodespaceTypeForResponse]:
        """codespaces/create-with-pr-for-authenticated-user

        POST /repos/{owner}/{repo}/pulls/{pull_number}/codespaces

        Creates a codespace owned by the authenticated user for the specified pull request.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#create-a-codespace-from-a-pull-request
        """

        from typing import Union

        from ..models import (
            BasicError,
            Codespace,
            EventsGetResponse503,
            ReposOwnerRepoPullsPullNumberCodespacesPostBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/codespaces"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoPullsPullNumberCodespacesPostBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "503": EventsGetResponse503,
            },
        )

    @overload
    async def async_create_with_pr_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[ReposOwnerRepoPullsPullNumberCodespacesPostBodyType, None],
    ) -> Response[Codespace, CodespaceTypeForResponse]: ...

    @overload
    async def async_create_with_pr_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        location: Missing[str] = UNSET,
        geo: Missing[
            Literal["EuropeWest", "SoutheastAsia", "UsEast", "UsWest"]
        ] = UNSET,
        client_ip: Missing[str] = UNSET,
        machine: Missing[str] = UNSET,
        devcontainer_path: Missing[str] = UNSET,
        multi_repo_permissions_opt_out: Missing[bool] = UNSET,
        working_directory: Missing[str] = UNSET,
        idle_timeout_minutes: Missing[int] = UNSET,
        display_name: Missing[str] = UNSET,
        retention_period_minutes: Missing[int] = UNSET,
    ) -> Response[Codespace, CodespaceTypeForResponse]: ...

    async def async_create_with_pr_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberCodespacesPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[Codespace, CodespaceTypeForResponse]:
        """codespaces/create-with-pr-for-authenticated-user

        POST /repos/{owner}/{repo}/pulls/{pull_number}/codespaces

        Creates a codespace owned by the authenticated user for the specified pull request.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#create-a-codespace-from-a-pull-request
        """

        from typing import Union

        from ..models import (
            BasicError,
            Codespace,
            EventsGetResponse503,
            ReposOwnerRepoPullsPullNumberCodespacesPostBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/codespaces"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoPullsPullNumberCodespacesPostBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "503": EventsGetResponse503,
            },
        )

    def list_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        repository_id: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        UserCodespacesGetResponse200, UserCodespacesGetResponse200TypeForResponse
    ]:
        """codespaces/list-for-authenticated-user

        GET /user/codespaces

        Lists the authenticated user's codespaces.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#list-codespaces-for-the-authenticated-user
        """

        from ..models import BasicError, UserCodespacesGetResponse200

        url = "/user/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
            "repository_id": repository_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=UserCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        repository_id: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        UserCodespacesGetResponse200, UserCodespacesGetResponse200TypeForResponse
    ]:
        """codespaces/list-for-authenticated-user

        GET /user/codespaces

        Lists the authenticated user's codespaces.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#list-codespaces-for-the-authenticated-user
        """

        from ..models import BasicError, UserCodespacesGetResponse200

        url = "/user/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
            "repository_id": repository_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=UserCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[UserCodespacesPostBodyOneof0Type, UserCodespacesPostBodyOneof1Type],
    ) -> Response[Codespace, CodespaceTypeForResponse]: ...

    @overload
    def create_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        repository_id: int,
        ref: Missing[str] = UNSET,
        location: Missing[str] = UNSET,
        geo: Missing[
            Literal["EuropeWest", "SoutheastAsia", "UsEast", "UsWest"]
        ] = UNSET,
        client_ip: Missing[str] = UNSET,
        machine: Missing[str] = UNSET,
        devcontainer_path: Missing[str] = UNSET,
        multi_repo_permissions_opt_out: Missing[bool] = UNSET,
        working_directory: Missing[str] = UNSET,
        idle_timeout_minutes: Missing[int] = UNSET,
        display_name: Missing[str] = UNSET,
        retention_period_minutes: Missing[int] = UNSET,
    ) -> Response[Codespace, CodespaceTypeForResponse]: ...

    @overload
    def create_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        pull_request: UserCodespacesPostBodyOneof1PropPullRequestType,
        location: Missing[str] = UNSET,
        geo: Missing[
            Literal["EuropeWest", "SoutheastAsia", "UsEast", "UsWest"]
        ] = UNSET,
        machine: Missing[str] = UNSET,
        devcontainer_path: Missing[str] = UNSET,
        working_directory: Missing[str] = UNSET,
        idle_timeout_minutes: Missing[int] = UNSET,
    ) -> Response[Codespace, CodespaceTypeForResponse]: ...

    def create_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[UserCodespacesPostBodyOneof0Type, UserCodespacesPostBodyOneof1Type]
        ] = UNSET,
        **kwargs,
    ) -> Response[Codespace, CodespaceTypeForResponse]:
        """codespaces/create-for-authenticated-user

        POST /user/codespaces

        Creates a new codespace, owned by the authenticated user.

        This endpoint requires either a `repository_id` OR a `pull_request` but not both.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#create-a-codespace-for-the-authenticated-user
        """

        from typing import Union

        from ..models import (
            BasicError,
            Codespace,
            EventsGetResponse503,
            UserCodespacesPostBodyOneof0,
            UserCodespacesPostBodyOneof1,
        )

        url = "/user/codespaces"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[UserCodespacesPostBodyOneof0, UserCodespacesPostBodyOneof1], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "503": EventsGetResponse503,
            },
        )

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[UserCodespacesPostBodyOneof0Type, UserCodespacesPostBodyOneof1Type],
    ) -> Response[Codespace, CodespaceTypeForResponse]: ...

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        repository_id: int,
        ref: Missing[str] = UNSET,
        location: Missing[str] = UNSET,
        geo: Missing[
            Literal["EuropeWest", "SoutheastAsia", "UsEast", "UsWest"]
        ] = UNSET,
        client_ip: Missing[str] = UNSET,
        machine: Missing[str] = UNSET,
        devcontainer_path: Missing[str] = UNSET,
        multi_repo_permissions_opt_out: Missing[bool] = UNSET,
        working_directory: Missing[str] = UNSET,
        idle_timeout_minutes: Missing[int] = UNSET,
        display_name: Missing[str] = UNSET,
        retention_period_minutes: Missing[int] = UNSET,
    ) -> Response[Codespace, CodespaceTypeForResponse]: ...

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        pull_request: UserCodespacesPostBodyOneof1PropPullRequestType,
        location: Missing[str] = UNSET,
        geo: Missing[
            Literal["EuropeWest", "SoutheastAsia", "UsEast", "UsWest"]
        ] = UNSET,
        machine: Missing[str] = UNSET,
        devcontainer_path: Missing[str] = UNSET,
        working_directory: Missing[str] = UNSET,
        idle_timeout_minutes: Missing[int] = UNSET,
    ) -> Response[Codespace, CodespaceTypeForResponse]: ...

    async def async_create_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[UserCodespacesPostBodyOneof0Type, UserCodespacesPostBodyOneof1Type]
        ] = UNSET,
        **kwargs,
    ) -> Response[Codespace, CodespaceTypeForResponse]:
        """codespaces/create-for-authenticated-user

        POST /user/codespaces

        Creates a new codespace, owned by the authenticated user.

        This endpoint requires either a `repository_id` OR a `pull_request` but not both.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#create-a-codespace-for-the-authenticated-user
        """

        from typing import Union

        from ..models import (
            BasicError,
            Codespace,
            EventsGetResponse503,
            UserCodespacesPostBodyOneof0,
            UserCodespacesPostBodyOneof1,
        )

        url = "/user/codespaces"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[UserCodespacesPostBodyOneof0, UserCodespacesPostBodyOneof1], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "503": EventsGetResponse503,
            },
        )

    def list_secrets_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        UserCodespacesSecretsGetResponse200,
        UserCodespacesSecretsGetResponse200TypeForResponse,
    ]:
        """codespaces/list-secrets-for-authenticated-user

        GET /user/codespaces/secrets

        Lists all development environment secrets available for a user's codespaces without revealing their
        encrypted values.

        The authenticated user must have Codespaces access to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/secrets#list-secrets-for-the-authenticated-user
        """

        from ..models import UserCodespacesSecretsGetResponse200

        url = "/user/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=UserCodespacesSecretsGetResponse200,
        )

    async def async_list_secrets_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        UserCodespacesSecretsGetResponse200,
        UserCodespacesSecretsGetResponse200TypeForResponse,
    ]:
        """codespaces/list-secrets-for-authenticated-user

        GET /user/codespaces/secrets

        Lists all development environment secrets available for a user's codespaces without revealing their
        encrypted values.

        The authenticated user must have Codespaces access to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/secrets#list-secrets-for-the-authenticated-user
        """

        from ..models import UserCodespacesSecretsGetResponse200

        url = "/user/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=UserCodespacesSecretsGetResponse200,
        )

    def get_public_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CodespacesUserPublicKey, CodespacesUserPublicKeyTypeForResponse]:
        """codespaces/get-public-key-for-authenticated-user

        GET /user/codespaces/secrets/public-key

        Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets.

        The authenticated user must have Codespaces access to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/secrets#get-public-key-for-the-authenticated-user
        """

        from ..models import CodespacesUserPublicKey

        url = "/user/codespaces/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CodespacesUserPublicKey,
        )

    async def async_get_public_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CodespacesUserPublicKey, CodespacesUserPublicKeyTypeForResponse]:
        """codespaces/get-public-key-for-authenticated-user

        GET /user/codespaces/secrets/public-key

        Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets.

        The authenticated user must have Codespaces access to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/secrets#get-public-key-for-the-authenticated-user
        """

        from ..models import CodespacesUserPublicKey

        url = "/user/codespaces/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CodespacesUserPublicKey,
        )

    def get_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CodespacesSecret, CodespacesSecretTypeForResponse]:
        """codespaces/get-secret-for-authenticated-user

        GET /user/codespaces/secrets/{secret_name}

        Gets a development environment secret available to a user's codespaces without revealing its encrypted value.

        The authenticated user must have Codespaces access to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/secrets#get-a-secret-for-the-authenticated-user
        """

        from ..models import CodespacesSecret

        url = f"/user/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CodespacesSecret,
        )

    async def async_get_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CodespacesSecret, CodespacesSecretTypeForResponse]:
        """codespaces/get-secret-for-authenticated-user

        GET /user/codespaces/secrets/{secret_name}

        Gets a development environment secret available to a user's codespaces without revealing its encrypted value.

        The authenticated user must have Codespaces access to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/secrets#get-a-secret-for-the-authenticated-user
        """

        from ..models import CodespacesSecret

        url = f"/user/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CodespacesSecret,
        )

    @overload
    def create_or_update_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UserCodespacesSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject, EmptyObjectTypeForResponse]: ...

    @overload
    def create_or_update_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        encrypted_value: Missing[str] = UNSET,
        key_id: str,
        selected_repository_ids: Missing[list[Union[int, str]]] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectTypeForResponse]: ...

    def create_or_update_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserCodespacesSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectTypeForResponse]:
        """codespaces/create-or-update-secret-for-authenticated-user

        PUT /user/codespaces/secrets/{secret_name}

        Creates or updates a development environment secret for a user's codespace with an encrypted value. Encrypt your secret using
        [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."

        The authenticated user must have Codespaces access to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/secrets#create-or-update-a-secret-for-the-authenticated-user
        """

        from ..models import (
            BasicError,
            EmptyObject,
            UserCodespacesSecretsSecretNamePutBody,
            ValidationError,
        )

        url = f"/user/codespaces/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserCodespacesSecretsSecretNamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_or_update_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UserCodespacesSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject, EmptyObjectTypeForResponse]: ...

    @overload
    async def async_create_or_update_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        encrypted_value: Missing[str] = UNSET,
        key_id: str,
        selected_repository_ids: Missing[list[Union[int, str]]] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectTypeForResponse]: ...

    async def async_create_or_update_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserCodespacesSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectTypeForResponse]:
        """codespaces/create-or-update-secret-for-authenticated-user

        PUT /user/codespaces/secrets/{secret_name}

        Creates or updates a development environment secret for a user's codespace with an encrypted value. Encrypt your secret using
        [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/rest/guides/encrypting-secrets-for-the-rest-api)."

        The authenticated user must have Codespaces access to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/secrets#create-or-update-a-secret-for-the-authenticated-user
        """

        from ..models import (
            BasicError,
            EmptyObject,
            UserCodespacesSecretsSecretNamePutBody,
            ValidationError,
        )

        url = f"/user/codespaces/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserCodespacesSecretsSecretNamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=EmptyObject,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def delete_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """codespaces/delete-secret-for-authenticated-user

        DELETE /user/codespaces/secrets/{secret_name}

        Deletes a development environment secret from a user's codespaces using the secret name. Deleting the secret will remove access from all codespaces that were allowed to access the secret.

        The authenticated user must have Codespaces access to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/secrets#delete-a-secret-for-the-authenticated-user
        """

        url = f"/user/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """codespaces/delete-secret-for-authenticated-user

        DELETE /user/codespaces/secrets/{secret_name}

        Deletes a development environment secret from a user's codespaces using the secret name. Deleting the secret will remove access from all codespaces that were allowed to access the secret.

        The authenticated user must have Codespaces access to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/secrets#delete-a-secret-for-the-authenticated-user
        """

        url = f"/user/codespaces/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        UserCodespacesSecretsSecretNameRepositoriesGetResponse200,
        UserCodespacesSecretsSecretNameRepositoriesGetResponse200TypeForResponse,
    ]:
        """codespaces/list-repositories-for-secret-for-authenticated-user

        GET /user/codespaces/secrets/{secret_name}/repositories

        List the repositories that have been granted the ability to use a user's development environment secret.

        The authenticated user must have Codespaces access to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/secrets#list-selected-repositories-for-a-user-secret
        """

        from ..models import (
            BasicError,
            UserCodespacesSecretsSecretNameRepositoriesGetResponse200,
        )

        url = f"/user/codespaces/secrets/{secret_name}/repositories"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=UserCodespacesSecretsSecretNameRepositoriesGetResponse200,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_list_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        UserCodespacesSecretsSecretNameRepositoriesGetResponse200,
        UserCodespacesSecretsSecretNameRepositoriesGetResponse200TypeForResponse,
    ]:
        """codespaces/list-repositories-for-secret-for-authenticated-user

        GET /user/codespaces/secrets/{secret_name}/repositories

        List the repositories that have been granted the ability to use a user's development environment secret.

        The authenticated user must have Codespaces access to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/secrets#list-selected-repositories-for-a-user-secret
        """

        from ..models import (
            BasicError,
            UserCodespacesSecretsSecretNameRepositoriesGetResponse200,
        )

        url = f"/user/codespaces/secrets/{secret_name}/repositories"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=UserCodespacesSecretsSecretNameRepositoriesGetResponse200,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def set_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UserCodespacesSecretsSecretNameRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    def set_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_repository_ids: list[int],
    ) -> Response: ...

    def set_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserCodespacesSecretsSecretNameRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """codespaces/set-repositories-for-secret-for-authenticated-user

        PUT /user/codespaces/secrets/{secret_name}/repositories

        Select the repositories that will use a user's development environment secret.

        The authenticated user must have Codespaces access to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/secrets#set-selected-repositories-for-a-user-secret
        """

        from ..models import (
            BasicError,
            UserCodespacesSecretsSecretNameRepositoriesPutBody,
        )

        url = f"/user/codespaces/secrets/{secret_name}/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                UserCodespacesSecretsSecretNameRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_set_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UserCodespacesSecretsSecretNameRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        selected_repository_ids: list[int],
    ) -> Response: ...

    async def async_set_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserCodespacesSecretsSecretNameRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """codespaces/set-repositories-for-secret-for-authenticated-user

        PUT /user/codespaces/secrets/{secret_name}/repositories

        Select the repositories that will use a user's development environment secret.

        The authenticated user must have Codespaces access to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/secrets#set-selected-repositories-for-a-user-secret
        """

        from ..models import (
            BasicError,
            UserCodespacesSecretsSecretNameRepositoriesPutBody,
        )

        url = f"/user/codespaces/secrets/{secret_name}/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                UserCodespacesSecretsSecretNameRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    def add_repository_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """codespaces/add-repository-for-secret-for-authenticated-user

        PUT /user/codespaces/secrets/{secret_name}/repositories/{repository_id}

        Adds a repository to the selected repositories for a user's development environment secret.

        The authenticated user must have Codespaces access to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/secrets#add-a-selected-repository-to-a-user-secret
        """

        from ..models import BasicError

        url = f"/user/codespaces/secrets/{secret_name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_add_repository_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """codespaces/add-repository-for-secret-for-authenticated-user

        PUT /user/codespaces/secrets/{secret_name}/repositories/{repository_id}

        Adds a repository to the selected repositories for a user's development environment secret.

        The authenticated user must have Codespaces access to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/secrets#add-a-selected-repository-to-a-user-secret
        """

        from ..models import BasicError

        url = f"/user/codespaces/secrets/{secret_name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    def remove_repository_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """codespaces/remove-repository-for-secret-for-authenticated-user

        DELETE /user/codespaces/secrets/{secret_name}/repositories/{repository_id}

        Removes a repository from the selected repositories for a user's development environment secret.

        The authenticated user must have Codespaces access to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/secrets#remove-a-selected-repository-from-a-user-secret
        """

        from ..models import BasicError

        url = f"/user/codespaces/secrets/{secret_name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_remove_repository_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """codespaces/remove-repository-for-secret-for-authenticated-user

        DELETE /user/codespaces/secrets/{secret_name}/repositories/{repository_id}

        Removes a repository from the selected repositories for a user's development environment secret.

        The authenticated user must have Codespaces access to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `codespace` or `codespace:secrets` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/secrets#remove-a-selected-repository-from-a-user-secret
        """

        from ..models import BasicError

        url = f"/user/codespaces/secrets/{secret_name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Codespace, CodespaceTypeForResponse]:
        """codespaces/get-for-authenticated-user

        GET /user/codespaces/{codespace_name}

        Gets information about a user's codespace.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#get-a-codespace-for-the-authenticated-user
        """

        from ..models import BasicError, Codespace

        url = f"/user/codespaces/{codespace_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Codespace, CodespaceTypeForResponse]:
        """codespaces/get-for-authenticated-user

        GET /user/codespaces/{codespace_name}

        Gets information about a user's codespace.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#get-a-codespace-for-the-authenticated-user
        """

        from ..models import BasicError, Codespace

        url = f"/user/codespaces/{codespace_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
    ]:
        """codespaces/delete-for-authenticated-user

        DELETE /user/codespaces/{codespace_name}

        Deletes a user's codespace.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#delete-a-codespace-for-the-authenticated-user
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
        )

        url = f"/user/codespaces/{codespace_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202TypeForResponse,
    ]:
        """codespaces/delete-for-authenticated-user

        DELETE /user/codespaces/{codespace_name}

        Deletes a user's codespace.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#delete-a-codespace-for-the-authenticated-user
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
        )

        url = f"/user/codespaces/{codespace_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserCodespacesCodespaceNamePatchBodyType] = UNSET,
    ) -> Response[Codespace, CodespaceTypeForResponse]: ...

    @overload
    def update_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        machine: Missing[str] = UNSET,
        display_name: Missing[str] = UNSET,
        recent_folders: Missing[list[str]] = UNSET,
    ) -> Response[Codespace, CodespaceTypeForResponse]: ...

    def update_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserCodespacesCodespaceNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Codespace, CodespaceTypeForResponse]:
        """codespaces/update-for-authenticated-user

        PATCH /user/codespaces/{codespace_name}

        Updates a codespace owned by the authenticated user. Currently only the codespace's machine type and recent folders can be modified using this endpoint.

        If you specify a new machine type it will be applied the next time your codespace is started.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#update-a-codespace-for-the-authenticated-user
        """

        from ..models import BasicError, Codespace, UserCodespacesCodespaceNamePatchBody

        url = f"/user/codespaces/{codespace_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserCodespacesCodespaceNamePatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserCodespacesCodespaceNamePatchBodyType] = UNSET,
    ) -> Response[Codespace, CodespaceTypeForResponse]: ...

    @overload
    async def async_update_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        machine: Missing[str] = UNSET,
        display_name: Missing[str] = UNSET,
        recent_folders: Missing[list[str]] = UNSET,
    ) -> Response[Codespace, CodespaceTypeForResponse]: ...

    async def async_update_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserCodespacesCodespaceNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Codespace, CodespaceTypeForResponse]:
        """codespaces/update-for-authenticated-user

        PATCH /user/codespaces/{codespace_name}

        Updates a codespace owned by the authenticated user. Currently only the codespace's machine type and recent folders can be modified using this endpoint.

        If you specify a new machine type it will be applied the next time your codespace is started.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#update-a-codespace-for-the-authenticated-user
        """

        from ..models import BasicError, Codespace, UserCodespacesCodespaceNamePatchBody

        url = f"/user/codespaces/{codespace_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserCodespacesCodespaceNamePatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def export_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CodespaceExportDetails, CodespaceExportDetailsTypeForResponse]:
        """codespaces/export-for-authenticated-user

        POST /user/codespaces/{codespace_name}/exports

        Triggers an export of the specified codespace and returns a URL and ID where the status of the export can be monitored.

        If changes cannot be pushed to the codespace's repository, they will be pushed to a new or previously-existing fork instead.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#export-a-codespace-for-the-authenticated-user
        """

        from ..models import BasicError, CodespaceExportDetails, ValidationError

        url = f"/user/codespaces/{codespace_name}/exports"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CodespaceExportDetails,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_export_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CodespaceExportDetails, CodespaceExportDetailsTypeForResponse]:
        """codespaces/export-for-authenticated-user

        POST /user/codespaces/{codespace_name}/exports

        Triggers an export of the specified codespace and returns a URL and ID where the status of the export can be monitored.

        If changes cannot be pushed to the codespace's repository, they will be pushed to a new or previously-existing fork instead.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#export-a-codespace-for-the-authenticated-user
        """

        from ..models import BasicError, CodespaceExportDetails, ValidationError

        url = f"/user/codespaces/{codespace_name}/exports"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CodespaceExportDetails,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_export_details_for_authenticated_user(
        self,
        codespace_name: str,
        export_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CodespaceExportDetails, CodespaceExportDetailsTypeForResponse]:
        """codespaces/get-export-details-for-authenticated-user

        GET /user/codespaces/{codespace_name}/exports/{export_id}

        Gets information about an export of a codespace.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#get-details-about-a-codespace-export
        """

        from ..models import BasicError, CodespaceExportDetails

        url = f"/user/codespaces/{codespace_name}/exports/{export_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CodespaceExportDetails,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_export_details_for_authenticated_user(
        self,
        codespace_name: str,
        export_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CodespaceExportDetails, CodespaceExportDetailsTypeForResponse]:
        """codespaces/get-export-details-for-authenticated-user

        GET /user/codespaces/{codespace_name}/exports/{export_id}

        Gets information about an export of a codespace.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#get-details-about-a-codespace-export
        """

        from ..models import BasicError, CodespaceExportDetails

        url = f"/user/codespaces/{codespace_name}/exports/{export_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CodespaceExportDetails,
            error_models={
                "404": BasicError,
            },
        )

    def codespace_machines_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        UserCodespacesCodespaceNameMachinesGetResponse200,
        UserCodespacesCodespaceNameMachinesGetResponse200TypeForResponse,
    ]:
        """codespaces/codespace-machines-for-authenticated-user

        GET /user/codespaces/{codespace_name}/machines

        List the machine types a codespace can transition to use.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/machines#list-machine-types-for-a-codespace
        """

        from ..models import (
            BasicError,
            UserCodespacesCodespaceNameMachinesGetResponse200,
        )

        url = f"/user/codespaces/{codespace_name}/machines"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=UserCodespacesCodespaceNameMachinesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_codespace_machines_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        UserCodespacesCodespaceNameMachinesGetResponse200,
        UserCodespacesCodespaceNameMachinesGetResponse200TypeForResponse,
    ]:
        """codespaces/codespace-machines-for-authenticated-user

        GET /user/codespaces/{codespace_name}/machines

        List the machine types a codespace can transition to use.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/machines#list-machine-types-for-a-codespace
        """

        from ..models import (
            BasicError,
            UserCodespacesCodespaceNameMachinesGetResponse200,
        )

        url = f"/user/codespaces/{codespace_name}/machines"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=UserCodespacesCodespaceNameMachinesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def publish_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UserCodespacesCodespaceNamePublishPostBodyType,
    ) -> Response[
        CodespaceWithFullRepository, CodespaceWithFullRepositoryTypeForResponse
    ]: ...

    @overload
    def publish_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        private: Missing[bool] = UNSET,
    ) -> Response[
        CodespaceWithFullRepository, CodespaceWithFullRepositoryTypeForResponse
    ]: ...

    def publish_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserCodespacesCodespaceNamePublishPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        CodespaceWithFullRepository, CodespaceWithFullRepositoryTypeForResponse
    ]:
        """codespaces/publish-for-authenticated-user

        POST /user/codespaces/{codespace_name}/publish

        Publishes an unpublished codespace, creating a new repository and assigning it to the codespace.

        The codespace's token is granted write permissions to the repository, allowing the user to push their changes.

        This will fail for a codespace that is already published, meaning it has an associated repository.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#create-a-repository-from-an-unpublished-codespace
        """

        from ..models import (
            BasicError,
            CodespaceWithFullRepository,
            UserCodespacesCodespaceNamePublishPostBody,
            ValidationError,
        )

        url = f"/user/codespaces/{codespace_name}/publish"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                UserCodespacesCodespaceNamePublishPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CodespaceWithFullRepository,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_publish_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UserCodespacesCodespaceNamePublishPostBodyType,
    ) -> Response[
        CodespaceWithFullRepository, CodespaceWithFullRepositoryTypeForResponse
    ]: ...

    @overload
    async def async_publish_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        private: Missing[bool] = UNSET,
    ) -> Response[
        CodespaceWithFullRepository, CodespaceWithFullRepositoryTypeForResponse
    ]: ...

    async def async_publish_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserCodespacesCodespaceNamePublishPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        CodespaceWithFullRepository, CodespaceWithFullRepositoryTypeForResponse
    ]:
        """codespaces/publish-for-authenticated-user

        POST /user/codespaces/{codespace_name}/publish

        Publishes an unpublished codespace, creating a new repository and assigning it to the codespace.

        The codespace's token is granted write permissions to the repository, allowing the user to push their changes.

        This will fail for a codespace that is already published, meaning it has an associated repository.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#create-a-repository-from-an-unpublished-codespace
        """

        from ..models import (
            BasicError,
            CodespaceWithFullRepository,
            UserCodespacesCodespaceNamePublishPostBody,
            ValidationError,
        )

        url = f"/user/codespaces/{codespace_name}/publish"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                UserCodespacesCodespaceNamePublishPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CodespaceWithFullRepository,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def start_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Codespace, CodespaceTypeForResponse]:
        """codespaces/start-for-authenticated-user

        POST /user/codespaces/{codespace_name}/start

        Starts a user's codespace.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#start-a-codespace-for-the-authenticated-user
        """

        from ..models import BasicError, Codespace

        url = f"/user/codespaces/{codespace_name}/start"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "400": BasicError,
                "401": BasicError,
                "402": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_start_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Codespace, CodespaceTypeForResponse]:
        """codespaces/start-for-authenticated-user

        POST /user/codespaces/{codespace_name}/start

        Starts a user's codespace.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#start-a-codespace-for-the-authenticated-user
        """

        from ..models import BasicError, Codespace

        url = f"/user/codespaces/{codespace_name}/start"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "400": BasicError,
                "401": BasicError,
                "402": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    def stop_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Codespace, CodespaceTypeForResponse]:
        """codespaces/stop-for-authenticated-user

        POST /user/codespaces/{codespace_name}/stop

        Stops a user's codespace.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#stop-a-codespace-for-the-authenticated-user
        """

        from ..models import BasicError, Codespace

        url = f"/user/codespaces/{codespace_name}/stop"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_stop_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Codespace, CodespaceTypeForResponse]:
        """codespaces/stop-for-authenticated-user

        POST /user/codespaces/{codespace_name}/stop

        Stops a user's codespace.

        OAuth app tokens and personal access tokens (classic) need the `codespace` scope to use this endpoint.

        See also: https://docs.github.com/rest/codespaces/codespaces#stop-a-codespace-for-the-authenticated-user
        """

        from ..models import BasicError, Codespace

        url = f"/user/codespaces/{codespace_name}/stop"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )
