"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        InteractionLimitResponse,
        OrgsOrgInteractionLimitsGetResponse200Anyof1,
        ReposOwnerRepoInteractionLimitsGetResponse200Anyof1,
        UserInteractionLimitsGetResponse200Anyof1,
    )
    from ..types import (
        InteractionLimitResponseTypeForResponse,
        InteractionLimitType,
        OrgsOrgInteractionLimitsGetResponse200Anyof1TypeForResponse,
        ReposOwnerRepoInteractionLimitsGetResponse200Anyof1TypeForResponse,
        UserInteractionLimitsGetResponse200Anyof1TypeForResponse,
    )


class InteractionsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def get_restrictions_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        Union[InteractionLimitResponse, OrgsOrgInteractionLimitsGetResponse200Anyof1],
        Union[
            InteractionLimitResponseTypeForResponse,
            OrgsOrgInteractionLimitsGetResponse200Anyof1TypeForResponse,
        ],
    ]:
        """interactions/get-restrictions-for-org

        GET /orgs/{org}/interaction-limits

        Shows which type of GitHub user can interact with this organization and when the restriction expires. If there is no restrictions, you will see an empty response.

        See also: https://docs.github.com/rest/interactions/orgs#get-interaction-restrictions-for-an-organization
        """

        from typing import Union

        from ..models import (
            InteractionLimitResponse,
            OrgsOrgInteractionLimitsGetResponse200Anyof1,
        )

        url = f"/orgs/{org}/interaction-limits"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Union[
                InteractionLimitResponse, OrgsOrgInteractionLimitsGetResponse200Anyof1
            ],
        )

    async def async_get_restrictions_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        Union[InteractionLimitResponse, OrgsOrgInteractionLimitsGetResponse200Anyof1],
        Union[
            InteractionLimitResponseTypeForResponse,
            OrgsOrgInteractionLimitsGetResponse200Anyof1TypeForResponse,
        ],
    ]:
        """interactions/get-restrictions-for-org

        GET /orgs/{org}/interaction-limits

        Shows which type of GitHub user can interact with this organization and when the restriction expires. If there is no restrictions, you will see an empty response.

        See also: https://docs.github.com/rest/interactions/orgs#get-interaction-restrictions-for-an-organization
        """

        from typing import Union

        from ..models import (
            InteractionLimitResponse,
            OrgsOrgInteractionLimitsGetResponse200Anyof1,
        )

        url = f"/orgs/{org}/interaction-limits"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Union[
                InteractionLimitResponse, OrgsOrgInteractionLimitsGetResponse200Anyof1
            ],
        )

    @overload
    def set_restrictions_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: InteractionLimitType,
    ) -> Response[
        InteractionLimitResponse, InteractionLimitResponseTypeForResponse
    ]: ...

    @overload
    def set_restrictions_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        limit: Literal["existing_users", "contributors_only", "collaborators_only"],
        expiry: Missing[
            Literal["one_day", "three_days", "one_week", "one_month", "six_months"]
        ] = UNSET,
    ) -> Response[
        InteractionLimitResponse, InteractionLimitResponseTypeForResponse
    ]: ...

    def set_restrictions_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[InteractionLimitType] = UNSET,
        **kwargs,
    ) -> Response[InteractionLimitResponse, InteractionLimitResponseTypeForResponse]:
        """interactions/set-restrictions-for-org

        PUT /orgs/{org}/interaction-limits

        Temporarily restricts interactions to a certain type of GitHub user in any public repository in the given organization. You must be an organization owner to set these restrictions. Setting the interaction limit at the organization level will overwrite any interaction limits that are set for individual repositories owned by the organization.

        See also: https://docs.github.com/rest/interactions/orgs#set-interaction-restrictions-for-an-organization
        """

        from ..models import InteractionLimit, InteractionLimitResponse, ValidationError

        url = f"/orgs/{org}/interaction-limits"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(InteractionLimit, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=InteractionLimitResponse,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_restrictions_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: InteractionLimitType,
    ) -> Response[
        InteractionLimitResponse, InteractionLimitResponseTypeForResponse
    ]: ...

    @overload
    async def async_set_restrictions_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        limit: Literal["existing_users", "contributors_only", "collaborators_only"],
        expiry: Missing[
            Literal["one_day", "three_days", "one_week", "one_month", "six_months"]
        ] = UNSET,
    ) -> Response[
        InteractionLimitResponse, InteractionLimitResponseTypeForResponse
    ]: ...

    async def async_set_restrictions_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[InteractionLimitType] = UNSET,
        **kwargs,
    ) -> Response[InteractionLimitResponse, InteractionLimitResponseTypeForResponse]:
        """interactions/set-restrictions-for-org

        PUT /orgs/{org}/interaction-limits

        Temporarily restricts interactions to a certain type of GitHub user in any public repository in the given organization. You must be an organization owner to set these restrictions. Setting the interaction limit at the organization level will overwrite any interaction limits that are set for individual repositories owned by the organization.

        See also: https://docs.github.com/rest/interactions/orgs#set-interaction-restrictions-for-an-organization
        """

        from ..models import InteractionLimit, InteractionLimitResponse, ValidationError

        url = f"/orgs/{org}/interaction-limits"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(InteractionLimit, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=InteractionLimitResponse,
            error_models={
                "422": ValidationError,
            },
        )

    def remove_restrictions_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """interactions/remove-restrictions-for-org

        DELETE /orgs/{org}/interaction-limits

        Removes all interaction restrictions from public repositories in the given organization. You must be an organization owner to remove restrictions.

        See also: https://docs.github.com/rest/interactions/orgs#remove-interaction-restrictions-for-an-organization
        """

        url = f"/orgs/{org}/interaction-limits"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_remove_restrictions_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """interactions/remove-restrictions-for-org

        DELETE /orgs/{org}/interaction-limits

        Removes all interaction restrictions from public repositories in the given organization. You must be an organization owner to remove restrictions.

        See also: https://docs.github.com/rest/interactions/orgs#remove-interaction-restrictions-for-an-organization
        """

        url = f"/orgs/{org}/interaction-limits"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def get_restrictions_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        Union[
            InteractionLimitResponse,
            ReposOwnerRepoInteractionLimitsGetResponse200Anyof1,
        ],
        Union[
            InteractionLimitResponseTypeForResponse,
            ReposOwnerRepoInteractionLimitsGetResponse200Anyof1TypeForResponse,
        ],
    ]:
        """interactions/get-restrictions-for-repo

        GET /repos/{owner}/{repo}/interaction-limits

        Shows which type of GitHub user can interact with this repository and when the restriction expires. If there are no restrictions, you will see an empty response.

        See also: https://docs.github.com/rest/interactions/repos#get-interaction-restrictions-for-a-repository
        """

        from typing import Union

        from ..models import (
            InteractionLimitResponse,
            ReposOwnerRepoInteractionLimitsGetResponse200Anyof1,
        )

        url = f"/repos/{owner}/{repo}/interaction-limits"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Union[
                InteractionLimitResponse,
                ReposOwnerRepoInteractionLimitsGetResponse200Anyof1,
            ],
        )

    async def async_get_restrictions_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        Union[
            InteractionLimitResponse,
            ReposOwnerRepoInteractionLimitsGetResponse200Anyof1,
        ],
        Union[
            InteractionLimitResponseTypeForResponse,
            ReposOwnerRepoInteractionLimitsGetResponse200Anyof1TypeForResponse,
        ],
    ]:
        """interactions/get-restrictions-for-repo

        GET /repos/{owner}/{repo}/interaction-limits

        Shows which type of GitHub user can interact with this repository and when the restriction expires. If there are no restrictions, you will see an empty response.

        See also: https://docs.github.com/rest/interactions/repos#get-interaction-restrictions-for-a-repository
        """

        from typing import Union

        from ..models import (
            InteractionLimitResponse,
            ReposOwnerRepoInteractionLimitsGetResponse200Anyof1,
        )

        url = f"/repos/{owner}/{repo}/interaction-limits"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Union[
                InteractionLimitResponse,
                ReposOwnerRepoInteractionLimitsGetResponse200Anyof1,
            ],
        )

    @overload
    def set_restrictions_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: InteractionLimitType,
    ) -> Response[
        InteractionLimitResponse, InteractionLimitResponseTypeForResponse
    ]: ...

    @overload
    def set_restrictions_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        limit: Literal["existing_users", "contributors_only", "collaborators_only"],
        expiry: Missing[
            Literal["one_day", "three_days", "one_week", "one_month", "six_months"]
        ] = UNSET,
    ) -> Response[
        InteractionLimitResponse, InteractionLimitResponseTypeForResponse
    ]: ...

    def set_restrictions_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[InteractionLimitType] = UNSET,
        **kwargs,
    ) -> Response[InteractionLimitResponse, InteractionLimitResponseTypeForResponse]:
        """interactions/set-restrictions-for-repo

        PUT /repos/{owner}/{repo}/interaction-limits

        Temporarily restricts interactions to a certain type of GitHub user within the given repository. You must have owner or admin access to set these restrictions. If an interaction limit is set for the user or organization that owns this repository, you will receive a `409 Conflict` response and will not be able to use this endpoint to change the interaction limit for a single repository.

        See also: https://docs.github.com/rest/interactions/repos#set-interaction-restrictions-for-a-repository
        """

        from ..models import InteractionLimit, InteractionLimitResponse

        url = f"/repos/{owner}/{repo}/interaction-limits"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(InteractionLimit, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=InteractionLimitResponse,
            error_models={},
        )

    @overload
    async def async_set_restrictions_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: InteractionLimitType,
    ) -> Response[
        InteractionLimitResponse, InteractionLimitResponseTypeForResponse
    ]: ...

    @overload
    async def async_set_restrictions_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        limit: Literal["existing_users", "contributors_only", "collaborators_only"],
        expiry: Missing[
            Literal["one_day", "three_days", "one_week", "one_month", "six_months"]
        ] = UNSET,
    ) -> Response[
        InteractionLimitResponse, InteractionLimitResponseTypeForResponse
    ]: ...

    async def async_set_restrictions_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[InteractionLimitType] = UNSET,
        **kwargs,
    ) -> Response[InteractionLimitResponse, InteractionLimitResponseTypeForResponse]:
        """interactions/set-restrictions-for-repo

        PUT /repos/{owner}/{repo}/interaction-limits

        Temporarily restricts interactions to a certain type of GitHub user within the given repository. You must have owner or admin access to set these restrictions. If an interaction limit is set for the user or organization that owns this repository, you will receive a `409 Conflict` response and will not be able to use this endpoint to change the interaction limit for a single repository.

        See also: https://docs.github.com/rest/interactions/repos#set-interaction-restrictions-for-a-repository
        """

        from ..models import InteractionLimit, InteractionLimitResponse

        url = f"/repos/{owner}/{repo}/interaction-limits"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(InteractionLimit, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=InteractionLimitResponse,
            error_models={},
        )

    def remove_restrictions_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """interactions/remove-restrictions-for-repo

        DELETE /repos/{owner}/{repo}/interaction-limits

        Removes all interaction restrictions from the given repository. You must have owner or admin access to remove restrictions. If the interaction limit is set for the user or organization that owns this repository, you will receive a `409 Conflict` response and will not be able to use this endpoint to change the interaction limit for a single repository.

        See also: https://docs.github.com/rest/interactions/repos#remove-interaction-restrictions-for-a-repository
        """

        url = f"/repos/{owner}/{repo}/interaction-limits"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    async def async_remove_restrictions_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """interactions/remove-restrictions-for-repo

        DELETE /repos/{owner}/{repo}/interaction-limits

        Removes all interaction restrictions from the given repository. You must have owner or admin access to remove restrictions. If the interaction limit is set for the user or organization that owns this repository, you will receive a `409 Conflict` response and will not be able to use this endpoint to change the interaction limit for a single repository.

        See also: https://docs.github.com/rest/interactions/repos#remove-interaction-restrictions-for-a-repository
        """

        url = f"/repos/{owner}/{repo}/interaction-limits"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    def get_restrictions_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        Union[InteractionLimitResponse, UserInteractionLimitsGetResponse200Anyof1],
        Union[
            InteractionLimitResponseTypeForResponse,
            UserInteractionLimitsGetResponse200Anyof1TypeForResponse,
        ],
    ]:
        """interactions/get-restrictions-for-authenticated-user

        GET /user/interaction-limits

        Shows which type of GitHub user can interact with your public repositories and when the restriction expires.

        See also: https://docs.github.com/rest/interactions/user#get-interaction-restrictions-for-your-public-repositories
        """

        from typing import Union

        from ..models import (
            InteractionLimitResponse,
            UserInteractionLimitsGetResponse200Anyof1,
        )

        url = "/user/interaction-limits"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Union[
                InteractionLimitResponse, UserInteractionLimitsGetResponse200Anyof1
            ],
        )

    async def async_get_restrictions_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        Union[InteractionLimitResponse, UserInteractionLimitsGetResponse200Anyof1],
        Union[
            InteractionLimitResponseTypeForResponse,
            UserInteractionLimitsGetResponse200Anyof1TypeForResponse,
        ],
    ]:
        """interactions/get-restrictions-for-authenticated-user

        GET /user/interaction-limits

        Shows which type of GitHub user can interact with your public repositories and when the restriction expires.

        See also: https://docs.github.com/rest/interactions/user#get-interaction-restrictions-for-your-public-repositories
        """

        from typing import Union

        from ..models import (
            InteractionLimitResponse,
            UserInteractionLimitsGetResponse200Anyof1,
        )

        url = "/user/interaction-limits"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Union[
                InteractionLimitResponse, UserInteractionLimitsGetResponse200Anyof1
            ],
        )

    @overload
    def set_restrictions_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: InteractionLimitType,
    ) -> Response[
        InteractionLimitResponse, InteractionLimitResponseTypeForResponse
    ]: ...

    @overload
    def set_restrictions_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        limit: Literal["existing_users", "contributors_only", "collaborators_only"],
        expiry: Missing[
            Literal["one_day", "three_days", "one_week", "one_month", "six_months"]
        ] = UNSET,
    ) -> Response[
        InteractionLimitResponse, InteractionLimitResponseTypeForResponse
    ]: ...

    def set_restrictions_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[InteractionLimitType] = UNSET,
        **kwargs,
    ) -> Response[InteractionLimitResponse, InteractionLimitResponseTypeForResponse]:
        """interactions/set-restrictions-for-authenticated-user

        PUT /user/interaction-limits

        Temporarily restricts which type of GitHub user can interact with your public repositories. Setting the interaction limit at the user level will overwrite any interaction limits that are set for individual repositories owned by the user.

        See also: https://docs.github.com/rest/interactions/user#set-interaction-restrictions-for-your-public-repositories
        """

        from ..models import InteractionLimit, InteractionLimitResponse, ValidationError

        url = "/user/interaction-limits"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(InteractionLimit, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=InteractionLimitResponse,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_restrictions_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: InteractionLimitType,
    ) -> Response[
        InteractionLimitResponse, InteractionLimitResponseTypeForResponse
    ]: ...

    @overload
    async def async_set_restrictions_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        limit: Literal["existing_users", "contributors_only", "collaborators_only"],
        expiry: Missing[
            Literal["one_day", "three_days", "one_week", "one_month", "six_months"]
        ] = UNSET,
    ) -> Response[
        InteractionLimitResponse, InteractionLimitResponseTypeForResponse
    ]: ...

    async def async_set_restrictions_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[InteractionLimitType] = UNSET,
        **kwargs,
    ) -> Response[InteractionLimitResponse, InteractionLimitResponseTypeForResponse]:
        """interactions/set-restrictions-for-authenticated-user

        PUT /user/interaction-limits

        Temporarily restricts which type of GitHub user can interact with your public repositories. Setting the interaction limit at the user level will overwrite any interaction limits that are set for individual repositories owned by the user.

        See also: https://docs.github.com/rest/interactions/user#set-interaction-restrictions-for-your-public-repositories
        """

        from ..models import InteractionLimit, InteractionLimitResponse, ValidationError

        url = "/user/interaction-limits"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(InteractionLimit, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=InteractionLimitResponse,
            error_models={
                "422": ValidationError,
            },
        )

    def remove_restrictions_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """interactions/remove-restrictions-for-authenticated-user

        DELETE /user/interaction-limits

        Removes any interaction restrictions from your public repositories.

        See also: https://docs.github.com/rest/interactions/user#remove-interaction-restrictions-from-your-public-repositories
        """

        url = "/user/interaction-limits"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_remove_restrictions_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """interactions/remove-restrictions-for-authenticated-user

        DELETE /user/interaction-limits

        Removes any interaction restrictions from your public repositories.

        See also: https://docs.github.com/rest/interactions/user#remove-interaction-restrictions-from-your-public-repositories
        """

        url = "/user/interaction-limits"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )
