"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from typing_extensions import deprecated
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset, parse_query_params

if TYPE_CHECKING:
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        Import,
        Migration,
        MinimalRepository,
        PorterAuthor,
        PorterLargeFile,
    )
    from ..types import (
        ImportTypeForResponse,
        MigrationTypeForResponse,
        MinimalRepositoryTypeForResponse,
        OrgsOrgMigrationsPostBodyType,
        PorterAuthorTypeForResponse,
        PorterLargeFileTypeForResponse,
        ReposOwnerRepoImportAuthorsAuthorIdPatchBodyType,
        ReposOwnerRepoImportLfsPatchBodyType,
        ReposOwnerRepoImportPatchBodyType,
        ReposOwnerRepoImportPutBodyType,
        UserMigrationsPostBodyType,
    )


class MigrationsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_for_org(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        exclude: Missing[list[Literal["repositories"]]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Migration], list[MigrationTypeForResponse]]:
        """migrations/list-for-org

        GET /orgs/{org}/migrations

        Lists the most recent migrations, including both exports (which can be started through the REST API) and imports (which cannot be started using the REST API).

        A list of `repositories` is only returned for export migrations.

        See also: https://docs.github.com/rest/migrations/orgs#list-organization-migrations
        """

        from ..models import Migration

        url = f"/orgs/{org}/migrations"

        params = {
            "per_page": per_page,
            "page": page,
            "exclude": exclude,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Migration],
        )

    async def async_list_for_org(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        exclude: Missing[list[Literal["repositories"]]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Migration], list[MigrationTypeForResponse]]:
        """migrations/list-for-org

        GET /orgs/{org}/migrations

        Lists the most recent migrations, including both exports (which can be started through the REST API) and imports (which cannot be started using the REST API).

        A list of `repositories` is only returned for export migrations.

        See also: https://docs.github.com/rest/migrations/orgs#list-organization-migrations
        """

        from ..models import Migration

        url = f"/orgs/{org}/migrations"

        params = {
            "per_page": per_page,
            "page": page,
            "exclude": exclude,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Migration],
        )

    @overload
    def start_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgMigrationsPostBodyType,
    ) -> Response[Migration, MigrationTypeForResponse]: ...

    @overload
    def start_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        repositories: list[str],
        lock_repositories: Missing[bool] = UNSET,
        exclude_metadata: Missing[bool] = UNSET,
        exclude_git_data: Missing[bool] = UNSET,
        exclude_attachments: Missing[bool] = UNSET,
        exclude_releases: Missing[bool] = UNSET,
        exclude_owner_projects: Missing[bool] = UNSET,
        org_metadata_only: Missing[bool] = UNSET,
        exclude: Missing[list[Literal["repositories"]]] = UNSET,
    ) -> Response[Migration, MigrationTypeForResponse]: ...

    def start_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgMigrationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Migration, MigrationTypeForResponse]:
        """migrations/start-for-org

        POST /orgs/{org}/migrations

        Initiates the generation of a migration archive.

        See also: https://docs.github.com/rest/migrations/orgs#start-an-organization-migration
        """

        from ..models import (
            BasicError,
            Migration,
            OrgsOrgMigrationsPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/migrations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgMigrationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Migration,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_start_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgMigrationsPostBodyType,
    ) -> Response[Migration, MigrationTypeForResponse]: ...

    @overload
    async def async_start_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        repositories: list[str],
        lock_repositories: Missing[bool] = UNSET,
        exclude_metadata: Missing[bool] = UNSET,
        exclude_git_data: Missing[bool] = UNSET,
        exclude_attachments: Missing[bool] = UNSET,
        exclude_releases: Missing[bool] = UNSET,
        exclude_owner_projects: Missing[bool] = UNSET,
        org_metadata_only: Missing[bool] = UNSET,
        exclude: Missing[list[Literal["repositories"]]] = UNSET,
    ) -> Response[Migration, MigrationTypeForResponse]: ...

    async def async_start_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgMigrationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Migration, MigrationTypeForResponse]:
        """migrations/start-for-org

        POST /orgs/{org}/migrations

        Initiates the generation of a migration archive.

        See also: https://docs.github.com/rest/migrations/orgs#start-an-organization-migration
        """

        from ..models import (
            BasicError,
            Migration,
            OrgsOrgMigrationsPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/migrations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgMigrationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Migration,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_status_for_org(
        self,
        org: str,
        migration_id: int,
        *,
        exclude: Missing[list[Literal["repositories"]]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Migration, MigrationTypeForResponse]:
        """migrations/get-status-for-org

        GET /orgs/{org}/migrations/{migration_id}

        Fetches the status of a migration.

        The `state` of a migration can be one of the following values:

        *   `pending`, which means the migration hasn't started yet.
        *   `exporting`, which means the migration is in progress.
        *   `exported`, which means the migration finished successfully.
        *   `failed`, which means the migration failed.

        See also: https://docs.github.com/rest/migrations/orgs#get-an-organization-migration-status
        """

        from ..models import BasicError, Migration

        url = f"/orgs/{org}/migrations/{migration_id}"

        params = {
            "exclude": exclude,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Migration,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_status_for_org(
        self,
        org: str,
        migration_id: int,
        *,
        exclude: Missing[list[Literal["repositories"]]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Migration, MigrationTypeForResponse]:
        """migrations/get-status-for-org

        GET /orgs/{org}/migrations/{migration_id}

        Fetches the status of a migration.

        The `state` of a migration can be one of the following values:

        *   `pending`, which means the migration hasn't started yet.
        *   `exporting`, which means the migration is in progress.
        *   `exported`, which means the migration finished successfully.
        *   `failed`, which means the migration failed.

        See also: https://docs.github.com/rest/migrations/orgs#get-an-organization-migration-status
        """

        from ..models import BasicError, Migration

        url = f"/orgs/{org}/migrations/{migration_id}"

        params = {
            "exclude": exclude,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Migration,
            error_models={
                "404": BasicError,
            },
        )

    def download_archive_for_org(
        self,
        org: str,
        migration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """migrations/download-archive-for-org

        GET /orgs/{org}/migrations/{migration_id}/archive

        Fetches the URL to a migration archive.

        See also: https://docs.github.com/rest/migrations/orgs#download-an-organization-migration-archive
        """

        from ..models import BasicError

        url = f"/orgs/{org}/migrations/{migration_id}/archive"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    async def async_download_archive_for_org(
        self,
        org: str,
        migration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """migrations/download-archive-for-org

        GET /orgs/{org}/migrations/{migration_id}/archive

        Fetches the URL to a migration archive.

        See also: https://docs.github.com/rest/migrations/orgs#download-an-organization-migration-archive
        """

        from ..models import BasicError

        url = f"/orgs/{org}/migrations/{migration_id}/archive"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    def delete_archive_for_org(
        self,
        org: str,
        migration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """migrations/delete-archive-for-org

        DELETE /orgs/{org}/migrations/{migration_id}/archive

        Deletes a previous migration archive. Migration archives are automatically deleted after seven days.

        See also: https://docs.github.com/rest/migrations/orgs#delete-an-organization-migration-archive
        """

        from ..models import BasicError

        url = f"/orgs/{org}/migrations/{migration_id}/archive"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_archive_for_org(
        self,
        org: str,
        migration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """migrations/delete-archive-for-org

        DELETE /orgs/{org}/migrations/{migration_id}/archive

        Deletes a previous migration archive. Migration archives are automatically deleted after seven days.

        See also: https://docs.github.com/rest/migrations/orgs#delete-an-organization-migration-archive
        """

        from ..models import BasicError

        url = f"/orgs/{org}/migrations/{migration_id}/archive"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    def unlock_repo_for_org(
        self,
        org: str,
        migration_id: int,
        repo_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """migrations/unlock-repo-for-org

        DELETE /orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock

        Unlocks a repository that was locked for migration. You should unlock each migrated repository and [delete them](https://docs.github.com/rest/repos/repos#delete-a-repository) when the migration is complete and you no longer need the source data.

        See also: https://docs.github.com/rest/migrations/orgs#unlock-an-organization-repository
        """

        from ..models import BasicError

        url = f"/orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    async def async_unlock_repo_for_org(
        self,
        org: str,
        migration_id: int,
        repo_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """migrations/unlock-repo-for-org

        DELETE /orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock

        Unlocks a repository that was locked for migration. You should unlock each migrated repository and [delete them](https://docs.github.com/rest/repos/repos#delete-a-repository) when the migration is complete and you no longer need the source data.

        See also: https://docs.github.com/rest/migrations/orgs#unlock-an-organization-repository
        """

        from ..models import BasicError

        url = f"/orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    def list_repos_for_org(
        self,
        org: str,
        migration_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryTypeForResponse]]:
        """migrations/list-repos-for-org

        GET /orgs/{org}/migrations/{migration_id}/repositories

        List all the repositories for this organization migration.

        See also: https://docs.github.com/rest/migrations/orgs#list-repositories-in-an-organization-migration
        """

        from ..models import BasicError, MinimalRepository

        url = f"/orgs/{org}/migrations/{migration_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_repos_for_org(
        self,
        org: str,
        migration_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryTypeForResponse]]:
        """migrations/list-repos-for-org

        GET /orgs/{org}/migrations/{migration_id}/repositories

        List all the repositories for this organization migration.

        See also: https://docs.github.com/rest/migrations/orgs#list-repositories-in-an-organization-migration
        """

        from ..models import BasicError, MinimalRepository

        url = f"/orgs/{org}/migrations/{migration_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def get_import_status(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Import, ImportTypeForResponse]:
        """DEPRECATED migrations/get-import-status

        GET /repos/{owner}/{repo}/import

        View the progress of an import.

        > [!WARNING]
        > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).

        **Import status**

        This section includes details about the possible values of the `status` field of the Import Progress response.

        An import that does not have errors will progress through these steps:

        *   `detecting` - the "detection" step of the import is in progress because the request did not include a `vcs` parameter. The import is identifying the type of source control present at the URL.
        *   `importing` - the "raw" step of the import is in progress. This is where commit data is fetched from the original repository. The import progress response will include `commit_count` (the total number of raw commits that will be imported) and `percent` (0 - 100, the current progress through the import).
        *   `mapping` - the "rewrite" step of the import is in progress. This is where SVN branches are converted to Git branches, and where author updates are applied. The import progress response does not include progress information.
        *   `pushing` - the "push" step of the import is in progress. This is where the importer updates the repository on GitHub. The import progress response will include `push_percent`, which is the percent value reported by `git push` when it is "Writing objects".
        *   `complete` - the import is complete, and the repository is ready on GitHub.

        If there are problems, you will see one of these in the `status` field:

        *   `auth_failed` - the import requires authentication in order to connect to the original repository. To update authentication for the import, please see the [Update an import](https://docs.github.com/rest/migrations/source-imports#update-an-import) section.
        *   `error` - the import encountered an error. The import progress response will include the `failed_step` and an error message. Contact [GitHub Support](https://support.github.com/contact?tags=dotcom-rest-api) for more information.
        *   `detection_needs_auth` - the importer requires authentication for the originating repository to continue detection. To update authentication for the import, please see the [Update an import](https://docs.github.com/rest/migrations/source-imports#update-an-import) section.
        *   `detection_found_nothing` - the importer didn't recognize any source control at the URL. To resolve, [Cancel the import](https://docs.github.com/rest/migrations/source-imports#cancel-an-import) and [retry](https://docs.github.com/rest/migrations/source-imports#start-an-import) with the correct URL.
        *   `detection_found_multiple` - the importer found several projects or repositories at the provided URL. When this is the case, the Import Progress response will also include a `project_choices` field with the possible project choices as values. To update project choice, please see the [Update an import](https://docs.github.com/rest/migrations/source-imports#update-an-import) section.

        **The project_choices field**

        When multiple projects are found at the provided URL, the response hash will include a `project_choices` field, the value of which is an array of hashes each representing a project choice. The exact key/value pairs of the project hashes will differ depending on the version control type.

        **Git LFS related fields**

        This section includes details about Git LFS related fields that may be present in the Import Progress response.

        *   `use_lfs` - describes whether the import has been opted in or out of using Git LFS. The value can be `opt_in`, `opt_out`, or `undecided` if no action has been taken.
        *   `has_large_files` - the boolean value describing whether files larger than 100MB were found during the `importing` step.
        *   `large_files_size` - the total size in gigabytes of files larger than 100MB found in the originating repository.
        *   `large_files_count` - the total number of files larger than 100MB found in the originating repository. To see a list of these files, make a "Get Large Files" request.

        See also: https://docs.github.com/rest/migrations/source-imports#get-an-import-status
        """

        from ..models import BasicError, Import

        url = f"/repos/{owner}/{repo}/import"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Import,
            error_models={
                "404": BasicError,
                "503": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_get_import_status(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Import, ImportTypeForResponse]:
        """DEPRECATED migrations/get-import-status

        GET /repos/{owner}/{repo}/import

        View the progress of an import.

        > [!WARNING]
        > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).

        **Import status**

        This section includes details about the possible values of the `status` field of the Import Progress response.

        An import that does not have errors will progress through these steps:

        *   `detecting` - the "detection" step of the import is in progress because the request did not include a `vcs` parameter. The import is identifying the type of source control present at the URL.
        *   `importing` - the "raw" step of the import is in progress. This is where commit data is fetched from the original repository. The import progress response will include `commit_count` (the total number of raw commits that will be imported) and `percent` (0 - 100, the current progress through the import).
        *   `mapping` - the "rewrite" step of the import is in progress. This is where SVN branches are converted to Git branches, and where author updates are applied. The import progress response does not include progress information.
        *   `pushing` - the "push" step of the import is in progress. This is where the importer updates the repository on GitHub. The import progress response will include `push_percent`, which is the percent value reported by `git push` when it is "Writing objects".
        *   `complete` - the import is complete, and the repository is ready on GitHub.

        If there are problems, you will see one of these in the `status` field:

        *   `auth_failed` - the import requires authentication in order to connect to the original repository. To update authentication for the import, please see the [Update an import](https://docs.github.com/rest/migrations/source-imports#update-an-import) section.
        *   `error` - the import encountered an error. The import progress response will include the `failed_step` and an error message. Contact [GitHub Support](https://support.github.com/contact?tags=dotcom-rest-api) for more information.
        *   `detection_needs_auth` - the importer requires authentication for the originating repository to continue detection. To update authentication for the import, please see the [Update an import](https://docs.github.com/rest/migrations/source-imports#update-an-import) section.
        *   `detection_found_nothing` - the importer didn't recognize any source control at the URL. To resolve, [Cancel the import](https://docs.github.com/rest/migrations/source-imports#cancel-an-import) and [retry](https://docs.github.com/rest/migrations/source-imports#start-an-import) with the correct URL.
        *   `detection_found_multiple` - the importer found several projects or repositories at the provided URL. When this is the case, the Import Progress response will also include a `project_choices` field with the possible project choices as values. To update project choice, please see the [Update an import](https://docs.github.com/rest/migrations/source-imports#update-an-import) section.

        **The project_choices field**

        When multiple projects are found at the provided URL, the response hash will include a `project_choices` field, the value of which is an array of hashes each representing a project choice. The exact key/value pairs of the project hashes will differ depending on the version control type.

        **Git LFS related fields**

        This section includes details about Git LFS related fields that may be present in the Import Progress response.

        *   `use_lfs` - describes whether the import has been opted in or out of using Git LFS. The value can be `opt_in`, `opt_out`, or `undecided` if no action has been taken.
        *   `has_large_files` - the boolean value describing whether files larger than 100MB were found during the `importing` step.
        *   `large_files_size` - the total size in gigabytes of files larger than 100MB found in the originating repository.
        *   `large_files_count` - the total number of files larger than 100MB found in the originating repository. To see a list of these files, make a "Get Large Files" request.

        See also: https://docs.github.com/rest/migrations/source-imports#get-an-import-status
        """

        from ..models import BasicError, Import

        url = f"/repos/{owner}/{repo}/import"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Import,
            error_models={
                "404": BasicError,
                "503": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def start_import(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoImportPutBodyType,
    ) -> Response[Import, ImportTypeForResponse]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def start_import(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        vcs_url: str,
        vcs: Missing[Literal["subversion", "git", "mercurial", "tfvc"]] = UNSET,
        vcs_username: Missing[str] = UNSET,
        vcs_password: Missing[str] = UNSET,
        tfvc_project: Missing[str] = UNSET,
    ) -> Response[Import, ImportTypeForResponse]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def start_import(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoImportPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[Import, ImportTypeForResponse]:
        """DEPRECATED migrations/start-import

        PUT /repos/{owner}/{repo}/import

        Start a source import to a GitHub repository using GitHub Importer.
        Importing into a GitHub repository with GitHub Actions enabled is not supported and will
        return a status `422 Unprocessable Entity` response.

        > [!WARNING]
        > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).

        See also: https://docs.github.com/rest/migrations/source-imports#start-an-import
        """

        from ..models import (
            BasicError,
            Import,
            ReposOwnerRepoImportPutBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/import"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoImportPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Import,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "503": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_start_import(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoImportPutBodyType,
    ) -> Response[Import, ImportTypeForResponse]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_start_import(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        vcs_url: str,
        vcs: Missing[Literal["subversion", "git", "mercurial", "tfvc"]] = UNSET,
        vcs_username: Missing[str] = UNSET,
        vcs_password: Missing[str] = UNSET,
        tfvc_project: Missing[str] = UNSET,
    ) -> Response[Import, ImportTypeForResponse]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_start_import(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoImportPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[Import, ImportTypeForResponse]:
        """DEPRECATED migrations/start-import

        PUT /repos/{owner}/{repo}/import

        Start a source import to a GitHub repository using GitHub Importer.
        Importing into a GitHub repository with GitHub Actions enabled is not supported and will
        return a status `422 Unprocessable Entity` response.

        > [!WARNING]
        > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).

        See also: https://docs.github.com/rest/migrations/source-imports#start-an-import
        """

        from ..models import (
            BasicError,
            Import,
            ReposOwnerRepoImportPutBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/import"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoImportPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Import,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "503": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def cancel_import(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED migrations/cancel-import

        DELETE /repos/{owner}/{repo}/import

        Stop an import for a repository.

        > [!WARNING]
        > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).

        See also: https://docs.github.com/rest/migrations/source-imports#cancel-an-import
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/import"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "503": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_cancel_import(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED migrations/cancel-import

        DELETE /repos/{owner}/{repo}/import

        Stop an import for a repository.

        > [!WARNING]
        > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).

        See also: https://docs.github.com/rest/migrations/source-imports#cancel-an-import
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/import"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "503": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def update_import(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[Union[ReposOwnerRepoImportPatchBodyType, None]] = UNSET,
    ) -> Response[Import, ImportTypeForResponse]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def update_import(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        vcs_username: Missing[str] = UNSET,
        vcs_password: Missing[str] = UNSET,
        vcs: Missing[Literal["subversion", "tfvc", "git", "mercurial"]] = UNSET,
        tfvc_project: Missing[str] = UNSET,
    ) -> Response[Import, ImportTypeForResponse]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def update_import(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[Union[ReposOwnerRepoImportPatchBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[Import, ImportTypeForResponse]:
        """DEPRECATED migrations/update-import

        PATCH /repos/{owner}/{repo}/import

        An import can be updated with credentials or a project choice by passing in the appropriate parameters in this API
        request. If no parameters are provided, the import will be restarted.

        Some servers (e.g. TFS servers) can have several projects at a single URL. In those cases the import progress will
        have the status `detection_found_multiple` and the Import Progress response will include a `project_choices` array.
        You can select the project to import by providing one of the objects in the `project_choices` array in the update request.

        > [!WARNING]
        > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).

        See also: https://docs.github.com/rest/migrations/source-imports#update-an-import
        """

        from typing import Union

        from ..models import BasicError, Import, ReposOwnerRepoImportPatchBody

        url = f"/repos/{owner}/{repo}/import"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoImportPatchBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Import,
            error_models={
                "503": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_update_import(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[Union[ReposOwnerRepoImportPatchBodyType, None]] = UNSET,
    ) -> Response[Import, ImportTypeForResponse]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_update_import(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        vcs_username: Missing[str] = UNSET,
        vcs_password: Missing[str] = UNSET,
        vcs: Missing[Literal["subversion", "tfvc", "git", "mercurial"]] = UNSET,
        tfvc_project: Missing[str] = UNSET,
    ) -> Response[Import, ImportTypeForResponse]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_update_import(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[Union[ReposOwnerRepoImportPatchBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[Import, ImportTypeForResponse]:
        """DEPRECATED migrations/update-import

        PATCH /repos/{owner}/{repo}/import

        An import can be updated with credentials or a project choice by passing in the appropriate parameters in this API
        request. If no parameters are provided, the import will be restarted.

        Some servers (e.g. TFS servers) can have several projects at a single URL. In those cases the import progress will
        have the status `detection_found_multiple` and the Import Progress response will include a `project_choices` array.
        You can select the project to import by providing one of the objects in the `project_choices` array in the update request.

        > [!WARNING]
        > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).

        See also: https://docs.github.com/rest/migrations/source-imports#update-an-import
        """

        from typing import Union

        from ..models import BasicError, Import, ReposOwnerRepoImportPatchBody

        url = f"/repos/{owner}/{repo}/import"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoImportPatchBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Import,
            error_models={
                "503": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def get_commit_authors(
        self,
        owner: str,
        repo: str,
        *,
        since: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[PorterAuthor], list[PorterAuthorTypeForResponse]]:
        """DEPRECATED migrations/get-commit-authors

        GET /repos/{owner}/{repo}/import/authors

        Each type of source control system represents authors in a different way. For example, a Git commit author has a display name and an email address, but a Subversion commit author just has a username. The GitHub Importer will make the author information valid, but the author might not be correct. For example, it will change the bare Subversion username `hubot` into something like `hubot <hubot@12341234-abab-fefe-8787-fedcba987654>`.

        This endpoint and the [Map a commit author](https://docs.github.com/rest/migrations/source-imports#map-a-commit-author) endpoint allow you to provide correct Git author information.

        > [!WARNING]
        > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).

        See also: https://docs.github.com/rest/migrations/source-imports#get-commit-authors
        """

        from ..models import BasicError, PorterAuthor

        url = f"/repos/{owner}/{repo}/import/authors"

        params = {
            "since": since,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[PorterAuthor],
            error_models={
                "404": BasicError,
                "503": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_get_commit_authors(
        self,
        owner: str,
        repo: str,
        *,
        since: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[PorterAuthor], list[PorterAuthorTypeForResponse]]:
        """DEPRECATED migrations/get-commit-authors

        GET /repos/{owner}/{repo}/import/authors

        Each type of source control system represents authors in a different way. For example, a Git commit author has a display name and an email address, but a Subversion commit author just has a username. The GitHub Importer will make the author information valid, but the author might not be correct. For example, it will change the bare Subversion username `hubot` into something like `hubot <hubot@12341234-abab-fefe-8787-fedcba987654>`.

        This endpoint and the [Map a commit author](https://docs.github.com/rest/migrations/source-imports#map-a-commit-author) endpoint allow you to provide correct Git author information.

        > [!WARNING]
        > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).

        See also: https://docs.github.com/rest/migrations/source-imports#get-commit-authors
        """

        from ..models import BasicError, PorterAuthor

        url = f"/repos/{owner}/{repo}/import/authors"

        params = {
            "since": since,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[PorterAuthor],
            error_models={
                "404": BasicError,
                "503": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def map_commit_author(
        self,
        owner: str,
        repo: str,
        author_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoImportAuthorsAuthorIdPatchBodyType] = UNSET,
    ) -> Response[PorterAuthor, PorterAuthorTypeForResponse]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def map_commit_author(
        self,
        owner: str,
        repo: str,
        author_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        email: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
    ) -> Response[PorterAuthor, PorterAuthorTypeForResponse]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def map_commit_author(
        self,
        owner: str,
        repo: str,
        author_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoImportAuthorsAuthorIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[PorterAuthor, PorterAuthorTypeForResponse]:
        """DEPRECATED migrations/map-commit-author

        PATCH /repos/{owner}/{repo}/import/authors/{author_id}

        Update an author's identity for the import. Your application can continue updating authors any time before you push
        new commits to the repository.

        > [!WARNING]
        > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).

        See also: https://docs.github.com/rest/migrations/source-imports#map-a-commit-author
        """

        from ..models import (
            BasicError,
            PorterAuthor,
            ReposOwnerRepoImportAuthorsAuthorIdPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/import/authors/{author_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoImportAuthorsAuthorIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PorterAuthor,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "503": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_map_commit_author(
        self,
        owner: str,
        repo: str,
        author_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoImportAuthorsAuthorIdPatchBodyType] = UNSET,
    ) -> Response[PorterAuthor, PorterAuthorTypeForResponse]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_map_commit_author(
        self,
        owner: str,
        repo: str,
        author_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        email: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
    ) -> Response[PorterAuthor, PorterAuthorTypeForResponse]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_map_commit_author(
        self,
        owner: str,
        repo: str,
        author_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoImportAuthorsAuthorIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[PorterAuthor, PorterAuthorTypeForResponse]:
        """DEPRECATED migrations/map-commit-author

        PATCH /repos/{owner}/{repo}/import/authors/{author_id}

        Update an author's identity for the import. Your application can continue updating authors any time before you push
        new commits to the repository.

        > [!WARNING]
        > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).

        See also: https://docs.github.com/rest/migrations/source-imports#map-a-commit-author
        """

        from ..models import (
            BasicError,
            PorterAuthor,
            ReposOwnerRepoImportAuthorsAuthorIdPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/import/authors/{author_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoImportAuthorsAuthorIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PorterAuthor,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "503": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def get_large_files(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[PorterLargeFile], list[PorterLargeFileTypeForResponse]]:
        """DEPRECATED migrations/get-large-files

        GET /repos/{owner}/{repo}/import/large_files

        List files larger than 100MB found during the import

        > [!WARNING]
        > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).

        See also: https://docs.github.com/rest/migrations/source-imports#get-large-files
        """

        from ..models import BasicError, PorterLargeFile

        url = f"/repos/{owner}/{repo}/import/large_files"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[PorterLargeFile],
            error_models={
                "503": BasicError,
            },
        )

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_get_large_files(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[PorterLargeFile], list[PorterLargeFileTypeForResponse]]:
        """DEPRECATED migrations/get-large-files

        GET /repos/{owner}/{repo}/import/large_files

        List files larger than 100MB found during the import

        > [!WARNING]
        > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).

        See also: https://docs.github.com/rest/migrations/source-imports#get-large-files
        """

        from ..models import BasicError, PorterLargeFile

        url = f"/repos/{owner}/{repo}/import/large_files"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[PorterLargeFile],
            error_models={
                "503": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def set_lfs_preference(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoImportLfsPatchBodyType,
    ) -> Response[Import, ImportTypeForResponse]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def set_lfs_preference(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        use_lfs: Literal["opt_in", "opt_out"],
    ) -> Response[Import, ImportTypeForResponse]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    def set_lfs_preference(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoImportLfsPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Import, ImportTypeForResponse]:
        """DEPRECATED migrations/set-lfs-preference

        PATCH /repos/{owner}/{repo}/import/lfs

        You can import repositories from Subversion, Mercurial, and TFS that include files larger than 100MB. This ability
        is powered by [Git LFS](https://git-lfs.com).

        You can learn more about our LFS feature and working with large files [on our help
        site](https://docs.github.com/repositories/working-with-files/managing-large-files).

        > [!WARNING]
        > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).

        See also: https://docs.github.com/rest/migrations/source-imports#update-git-lfs-preference
        """

        from ..models import (
            BasicError,
            Import,
            ReposOwnerRepoImportLfsPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/import/lfs"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoImportLfsPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Import,
            error_models={
                "422": ValidationError,
                "503": BasicError,
            },
        )

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_set_lfs_preference(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoImportLfsPatchBodyType,
    ) -> Response[Import, ImportTypeForResponse]: ...

    @overload
    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_set_lfs_preference(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        use_lfs: Literal["opt_in", "opt_out"],
    ) -> Response[Import, ImportTypeForResponse]: ...

    @deprecated("Deprecated API endpoint. See the docstring for more details.")
    async def async_set_lfs_preference(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoImportLfsPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Import, ImportTypeForResponse]:
        """DEPRECATED migrations/set-lfs-preference

        PATCH /repos/{owner}/{repo}/import/lfs

        You can import repositories from Subversion, Mercurial, and TFS that include files larger than 100MB. This ability
        is powered by [Git LFS](https://git-lfs.com).

        You can learn more about our LFS feature and working with large files [on our help
        site](https://docs.github.com/repositories/working-with-files/managing-large-files).

        > [!WARNING]
        > **Endpoint closing down notice:** Due to very low levels of usage and available alternatives, this endpoint is closing down and will no longer be available from 00:00 UTC on April 12, 2024. For more details and alternatives, see the [changelog](https://gh.io/source-imports-api-deprecation).

        See also: https://docs.github.com/rest/migrations/source-imports#update-git-lfs-preference
        """

        from ..models import (
            BasicError,
            Import,
            ReposOwnerRepoImportLfsPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/import/lfs"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoImportLfsPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Import,
            error_models={
                "422": ValidationError,
                "503": BasicError,
            },
        )

    def list_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Migration], list[MigrationTypeForResponse]]:
        """migrations/list-for-authenticated-user

        GET /user/migrations

        Lists all migrations a user has started.

        See also: https://docs.github.com/rest/migrations/users#list-user-migrations
        """

        from ..models import BasicError, Migration

        url = "/user/migrations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Migration],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Migration], list[MigrationTypeForResponse]]:
        """migrations/list-for-authenticated-user

        GET /user/migrations

        Lists all migrations a user has started.

        See also: https://docs.github.com/rest/migrations/users#list-user-migrations
        """

        from ..models import BasicError, Migration

        url = "/user/migrations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Migration],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def start_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UserMigrationsPostBodyType,
    ) -> Response[Migration, MigrationTypeForResponse]: ...

    @overload
    def start_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        lock_repositories: Missing[bool] = UNSET,
        exclude_metadata: Missing[bool] = UNSET,
        exclude_git_data: Missing[bool] = UNSET,
        exclude_attachments: Missing[bool] = UNSET,
        exclude_releases: Missing[bool] = UNSET,
        exclude_owner_projects: Missing[bool] = UNSET,
        org_metadata_only: Missing[bool] = UNSET,
        exclude: Missing[list[Literal["repositories"]]] = UNSET,
        repositories: list[str],
    ) -> Response[Migration, MigrationTypeForResponse]: ...

    def start_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserMigrationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Migration, MigrationTypeForResponse]:
        """migrations/start-for-authenticated-user

        POST /user/migrations

        Initiates the generation of a user migration archive.

        See also: https://docs.github.com/rest/migrations/users#start-a-user-migration
        """

        from ..models import (
            BasicError,
            Migration,
            UserMigrationsPostBody,
            ValidationError,
        )

        url = "/user/migrations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserMigrationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Migration,
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_start_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UserMigrationsPostBodyType,
    ) -> Response[Migration, MigrationTypeForResponse]: ...

    @overload
    async def async_start_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        lock_repositories: Missing[bool] = UNSET,
        exclude_metadata: Missing[bool] = UNSET,
        exclude_git_data: Missing[bool] = UNSET,
        exclude_attachments: Missing[bool] = UNSET,
        exclude_releases: Missing[bool] = UNSET,
        exclude_owner_projects: Missing[bool] = UNSET,
        org_metadata_only: Missing[bool] = UNSET,
        exclude: Missing[list[Literal["repositories"]]] = UNSET,
        repositories: list[str],
    ) -> Response[Migration, MigrationTypeForResponse]: ...

    async def async_start_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserMigrationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Migration, MigrationTypeForResponse]:
        """migrations/start-for-authenticated-user

        POST /user/migrations

        Initiates the generation of a user migration archive.

        See also: https://docs.github.com/rest/migrations/users#start-a-user-migration
        """

        from ..models import (
            BasicError,
            Migration,
            UserMigrationsPostBody,
            ValidationError,
        )

        url = "/user/migrations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserMigrationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Migration,
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_status_for_authenticated_user(
        self,
        migration_id: int,
        *,
        exclude: Missing[list[str]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Migration, MigrationTypeForResponse]:
        """migrations/get-status-for-authenticated-user

        GET /user/migrations/{migration_id}

        Fetches a single user migration. The response includes the `state` of the migration, which can be one of the following values:

        *   `pending` - the migration hasn't started yet.
        *   `exporting` - the migration is in progress.
        *   `exported` - the migration finished successfully.
        *   `failed` - the migration failed.

        Once the migration has been `exported` you can [download the migration archive](https://docs.github.com/rest/migrations/users#download-a-user-migration-archive).

        See also: https://docs.github.com/rest/migrations/users#get-a-user-migration-status
        """

        from ..models import BasicError, Migration

        url = f"/user/migrations/{migration_id}"

        params = {
            "exclude": exclude,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Migration,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_status_for_authenticated_user(
        self,
        migration_id: int,
        *,
        exclude: Missing[list[str]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Migration, MigrationTypeForResponse]:
        """migrations/get-status-for-authenticated-user

        GET /user/migrations/{migration_id}

        Fetches a single user migration. The response includes the `state` of the migration, which can be one of the following values:

        *   `pending` - the migration hasn't started yet.
        *   `exporting` - the migration is in progress.
        *   `exported` - the migration finished successfully.
        *   `failed` - the migration failed.

        Once the migration has been `exported` you can [download the migration archive](https://docs.github.com/rest/migrations/users#download-a-user-migration-archive).

        See also: https://docs.github.com/rest/migrations/users#get-a-user-migration-status
        """

        from ..models import BasicError, Migration

        url = f"/user/migrations/{migration_id}"

        params = {
            "exclude": exclude,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Migration,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_archive_for_authenticated_user(
        self,
        migration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        r"""migrations/get-archive-for-authenticated-user

        GET /user/migrations/{migration_id}/archive

        Fetches the URL to download the migration archive as a `tar.gz` file. Depending on the resources your repository uses, the migration archive can contain JSON files with data for these objects:

        *   attachments
        *   bases
        *   commit\_comments
        *   issue\_comments
        *   issue\_events
        *   issues
        *   milestones
        *   organizations
        *   projects
        *   protected\_branches
        *   pull\_request\_reviews
        *   pull\_requests
        *   releases
        *   repositories
        *   review\_comments
        *   schema
        *   users

        The archive will also contain an `attachments` directory that includes all attachment files uploaded to GitHub.com and a `repositories` directory that contains the repository's Git data.

        See also: https://docs.github.com/rest/migrations/users#download-a-user-migration-archive
        """

        from ..models import BasicError

        url = f"/user/migrations/{migration_id}/archive"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_archive_for_authenticated_user(
        self,
        migration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        r"""migrations/get-archive-for-authenticated-user

        GET /user/migrations/{migration_id}/archive

        Fetches the URL to download the migration archive as a `tar.gz` file. Depending on the resources your repository uses, the migration archive can contain JSON files with data for these objects:

        *   attachments
        *   bases
        *   commit\_comments
        *   issue\_comments
        *   issue\_events
        *   issues
        *   milestones
        *   organizations
        *   projects
        *   protected\_branches
        *   pull\_request\_reviews
        *   pull\_requests
        *   releases
        *   repositories
        *   review\_comments
        *   schema
        *   users

        The archive will also contain an `attachments` directory that includes all attachment files uploaded to GitHub.com and a `repositories` directory that contains the repository's Git data.

        See also: https://docs.github.com/rest/migrations/users#download-a-user-migration-archive
        """

        from ..models import BasicError

        url = f"/user/migrations/{migration_id}/archive"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_archive_for_authenticated_user(
        self,
        migration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """migrations/delete-archive-for-authenticated-user

        DELETE /user/migrations/{migration_id}/archive

        Deletes a previous migration archive. Downloadable migration archives are automatically deleted after seven days. Migration metadata, which is returned in the [List user migrations](https://docs.github.com/rest/migrations/users#list-user-migrations) and [Get a user migration status](https://docs.github.com/rest/migrations/users#get-a-user-migration-status) endpoints, will continue to be available even after an archive is deleted.

        See also: https://docs.github.com/rest/migrations/users#delete-a-user-migration-archive
        """

        from ..models import BasicError

        url = f"/user/migrations/{migration_id}/archive"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_archive_for_authenticated_user(
        self,
        migration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """migrations/delete-archive-for-authenticated-user

        DELETE /user/migrations/{migration_id}/archive

        Deletes a previous migration archive. Downloadable migration archives are automatically deleted after seven days. Migration metadata, which is returned in the [List user migrations](https://docs.github.com/rest/migrations/users#list-user-migrations) and [Get a user migration status](https://docs.github.com/rest/migrations/users#get-a-user-migration-status) endpoints, will continue to be available even after an archive is deleted.

        See also: https://docs.github.com/rest/migrations/users#delete-a-user-migration-archive
        """

        from ..models import BasicError

        url = f"/user/migrations/{migration_id}/archive"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def unlock_repo_for_authenticated_user(
        self,
        migration_id: int,
        repo_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """migrations/unlock-repo-for-authenticated-user

        DELETE /user/migrations/{migration_id}/repos/{repo_name}/lock

        Unlocks a repository. You can lock repositories when you [start a user migration](https://docs.github.com/rest/migrations/users#start-a-user-migration). Once the migration is complete you can unlock each repository to begin using it again or [delete the repository](https://docs.github.com/rest/repos/repos#delete-a-repository) if you no longer need the source data. Returns a status of `404 Not Found` if the repository is not locked.

        See also: https://docs.github.com/rest/migrations/users#unlock-a-user-repository
        """

        from ..models import BasicError

        url = f"/user/migrations/{migration_id}/repos/{repo_name}/lock"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_unlock_repo_for_authenticated_user(
        self,
        migration_id: int,
        repo_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """migrations/unlock-repo-for-authenticated-user

        DELETE /user/migrations/{migration_id}/repos/{repo_name}/lock

        Unlocks a repository. You can lock repositories when you [start a user migration](https://docs.github.com/rest/migrations/users#start-a-user-migration). Once the migration is complete you can unlock each repository to begin using it again or [delete the repository](https://docs.github.com/rest/repos/repos#delete-a-repository) if you no longer need the source data. Returns a status of `404 Not Found` if the repository is not locked.

        See also: https://docs.github.com/rest/migrations/users#unlock-a-user-repository
        """

        from ..models import BasicError

        url = f"/user/migrations/{migration_id}/repos/{repo_name}/lock"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_repos_for_authenticated_user(
        self,
        migration_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryTypeForResponse]]:
        """migrations/list-repos-for-authenticated-user

        GET /user/migrations/{migration_id}/repositories

        Lists all the repositories for this user migration.

        See also: https://docs.github.com/rest/migrations/users#list-repositories-for-a-user-migration
        """

        from ..models import BasicError, MinimalRepository

        url = f"/user/migrations/{migration_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_repos_for_authenticated_user(
        self,
        migration_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryTypeForResponse]]:
        """migrations/list-repos-for-authenticated-user

        GET /user/migrations/{migration_id}/repositories

        Lists all the repositories for this user migration.

        See also: https://docs.github.com/rest/migrations/users#list-repositories-for-a-user-migration
        """

        from ..models import BasicError, MinimalRepository

        url = f"/user/migrations/{migration_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(parse_query_params(params)),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )
