"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, List, Union, Literal, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    UserPatchBodyType,
    UserKeysPostBodyType,
    UserGpgKeysPostBodyType,
    UserEmailsPostBodyOneof0Type,
    UserEmailsDeleteBodyOneof0Type,
    UserSshSigningKeysPostBodyType,
    UserEmailVisibilityPatchBodyType,
)
from .models import (
    Key,
    Email,
    GpgKey,
    Hovercard,
    KeySimple,
    BasicError,
    PublicUser,
    SimpleUser,
    PrivateUser,
    SshSigningKey,
    UserPatchBody,
    ValidationError,
    UserKeysPostBody,
    UserGpgKeysPostBody,
    UserEmailsPostBodyOneof0,
    UserEmailsDeleteBodyOneof0,
    UserSshSigningKeysPostBody,
    UserEmailVisibilityPatchBody,
)

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class UsersClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def get_authenticated(
        self,
    ) -> "Response[Union[PrivateUser, PublicUser]]":
        url = "/user"

        return self._github.request(
            "GET",
            url,
            response_model=Union[PrivateUser, PublicUser],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_authenticated(
        self,
    ) -> "Response[Union[PrivateUser, PublicUser]]":
        url = "/user"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Union[PrivateUser, PublicUser],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def update_authenticated(
        self, *, data: Union[Unset, UserPatchBodyType] = UNSET
    ) -> "Response[PrivateUser]":
        ...

    @overload
    def update_authenticated(
        self,
        *,
        data: Unset = UNSET,
        name: Union[Unset, str] = UNSET,
        email: Union[Unset, str] = UNSET,
        blog: Union[Unset, str] = UNSET,
        twitter_username: Union[Unset, Union[str, None]] = UNSET,
        company: Union[Unset, str] = UNSET,
        location: Union[Unset, str] = UNSET,
        hireable: Union[Unset, bool] = UNSET,
        bio: Union[Unset, str] = UNSET,
    ) -> "Response[PrivateUser]":
        ...

    def update_authenticated(
        self, *, data: Union[Unset, UserPatchBodyType] = UNSET, **kwargs
    ) -> "Response[PrivateUser]":
        url = "/user"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=PrivateUser,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_authenticated(
        self, *, data: Union[Unset, UserPatchBodyType] = UNSET
    ) -> "Response[PrivateUser]":
        ...

    @overload
    async def async_update_authenticated(
        self,
        *,
        data: Unset = UNSET,
        name: Union[Unset, str] = UNSET,
        email: Union[Unset, str] = UNSET,
        blog: Union[Unset, str] = UNSET,
        twitter_username: Union[Unset, Union[str, None]] = UNSET,
        company: Union[Unset, str] = UNSET,
        location: Union[Unset, str] = UNSET,
        hireable: Union[Unset, bool] = UNSET,
        bio: Union[Unset, str] = UNSET,
    ) -> "Response[PrivateUser]":
        ...

    async def async_update_authenticated(
        self, *, data: Union[Unset, UserPatchBodyType] = UNSET, **kwargs
    ) -> "Response[PrivateUser]":
        url = "/user"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=PrivateUser,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def list_blocked_by_authenticated_user(
        self,
    ) -> "Response[List[SimpleUser]]":
        url = "/user/blocks"

        return self._github.request(
            "GET",
            url,
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_blocked_by_authenticated_user(
        self,
    ) -> "Response[List[SimpleUser]]":
        url = "/user/blocks"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def check_blocked(
        self,
        username: str,
    ) -> "Response":
        url = f"/user/blocks/{username}"

        return self._github.request(
            "GET",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_check_blocked(
        self,
        username: str,
    ) -> "Response":
        url = f"/user/blocks/{username}"

        return await self._github.arequest(
            "GET",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def block(
        self,
        username: str,
    ) -> "Response":
        url = f"/user/blocks/{username}"

        return self._github.request(
            "PUT",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    async def async_block(
        self,
        username: str,
    ) -> "Response":
        url = f"/user/blocks/{username}"

        return await self._github.arequest(
            "PUT",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def unblock(
        self,
        username: str,
    ) -> "Response":
        url = f"/user/blocks/{username}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    async def async_unblock(
        self,
        username: str,
    ) -> "Response":
        url = f"/user/blocks/{username}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def set_primary_email_visibility_for_authenticated_user(
        self, *, data: UserEmailVisibilityPatchBodyType
    ) -> "Response[List[Email]]":
        ...

    @overload
    def set_primary_email_visibility_for_authenticated_user(
        self,
        *,
        data: Unset = UNSET,
        visibility: Literal["public", "private"],
    ) -> "Response[List[Email]]":
        ...

    def set_primary_email_visibility_for_authenticated_user(
        self, *, data: Union[Unset, UserEmailVisibilityPatchBodyType] = UNSET, **kwargs
    ) -> "Response[List[Email]]":
        url = "/user/email/visibility"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserEmailVisibilityPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=List[Email],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_primary_email_visibility_for_authenticated_user(
        self, *, data: UserEmailVisibilityPatchBodyType
    ) -> "Response[List[Email]]":
        ...

    @overload
    async def async_set_primary_email_visibility_for_authenticated_user(
        self,
        *,
        data: Unset = UNSET,
        visibility: Literal["public", "private"],
    ) -> "Response[List[Email]]":
        ...

    async def async_set_primary_email_visibility_for_authenticated_user(
        self, *, data: Union[Unset, UserEmailVisibilityPatchBodyType] = UNSET, **kwargs
    ) -> "Response[List[Email]]":
        url = "/user/email/visibility"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserEmailVisibilityPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=List[Email],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def list_emails_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Email]]":
        url = "/user/emails"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Email],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_emails_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Email]]":
        url = "/user/emails"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Email],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def add_email_for_authenticated_user(
        self,
        *,
        data: Union[Unset, Union[UserEmailsPostBodyOneof0Type, List[str], str]] = UNSET,
    ) -> "Response[List[Email]]":
        ...

    @overload
    def add_email_for_authenticated_user(
        self,
        *,
        data: Unset = UNSET,
        emails: List[str],
    ) -> "Response[List[Email]]":
        ...

    def add_email_for_authenticated_user(
        self,
        *,
        data: Union[Unset, Union[UserEmailsPostBodyOneof0Type, List[str], str]] = UNSET,
        **kwargs,
    ) -> "Response[List[Email]]":
        url = "/user/emails"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Union[UserEmailsPostBodyOneof0, List[str], str], json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[Email],
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_add_email_for_authenticated_user(
        self,
        *,
        data: Union[Unset, Union[UserEmailsPostBodyOneof0Type, List[str], str]] = UNSET,
    ) -> "Response[List[Email]]":
        ...

    @overload
    async def async_add_email_for_authenticated_user(
        self,
        *,
        data: Unset = UNSET,
        emails: List[str],
    ) -> "Response[List[Email]]":
        ...

    async def async_add_email_for_authenticated_user(
        self,
        *,
        data: Union[Unset, Union[UserEmailsPostBodyOneof0Type, List[str], str]] = UNSET,
        **kwargs,
    ) -> "Response[List[Email]]":
        url = "/user/emails"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Union[UserEmailsPostBodyOneof0, List[str], str], json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[Email],
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def delete_email_for_authenticated_user(
        self,
        *,
        data: Union[
            Unset, Union[UserEmailsDeleteBodyOneof0Type, List[str], str]
        ] = UNSET,
    ) -> "Response":
        ...

    @overload
    def delete_email_for_authenticated_user(
        self,
        *,
        data: Unset = UNSET,
        emails: List[str],
    ) -> "Response":
        ...

    def delete_email_for_authenticated_user(
        self,
        *,
        data: Union[
            Unset, Union[UserEmailsDeleteBodyOneof0Type, List[str], str]
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = "/user/emails"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Union[UserEmailsDeleteBodyOneof0, List[str], str], json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_delete_email_for_authenticated_user(
        self,
        *,
        data: Union[
            Unset, Union[UserEmailsDeleteBodyOneof0Type, List[str], str]
        ] = UNSET,
    ) -> "Response":
        ...

    @overload
    async def async_delete_email_for_authenticated_user(
        self,
        *,
        data: Unset = UNSET,
        emails: List[str],
    ) -> "Response":
        ...

    async def async_delete_email_for_authenticated_user(
        self,
        *,
        data: Union[
            Unset, Union[UserEmailsDeleteBodyOneof0Type, List[str], str]
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = "/user/emails"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Union[UserEmailsDeleteBodyOneof0, List[str], str], json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def list_followers_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = "/user/followers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_followers_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = "/user/followers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_followed_by_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = "/user/following"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_followed_by_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = "/user/following"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def check_person_is_followed_by_authenticated(
        self,
        username: str,
    ) -> "Response":
        url = f"/user/following/{username}"

        return self._github.request(
            "GET",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_check_person_is_followed_by_authenticated(
        self,
        username: str,
    ) -> "Response":
        url = f"/user/following/{username}"

        return await self._github.arequest(
            "GET",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def follow(
        self,
        username: str,
    ) -> "Response":
        url = f"/user/following/{username}"

        return self._github.request(
            "PUT",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_follow(
        self,
        username: str,
    ) -> "Response":
        url = f"/user/following/{username}"

        return await self._github.arequest(
            "PUT",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def unfollow(
        self,
        username: str,
    ) -> "Response":
        url = f"/user/following/{username}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_unfollow(
        self,
        username: str,
    ) -> "Response":
        url = f"/user/following/{username}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_gpg_keys_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[GpgKey]]":
        url = "/user/gpg_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[GpgKey],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_gpg_keys_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[GpgKey]]":
        url = "/user/gpg_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[GpgKey],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_gpg_key_for_authenticated_user(
        self, *, data: UserGpgKeysPostBodyType
    ) -> "Response[GpgKey]":
        ...

    @overload
    def create_gpg_key_for_authenticated_user(
        self,
        *,
        data: Unset = UNSET,
        name: Union[Unset, str] = UNSET,
        armored_public_key: str,
    ) -> "Response[GpgKey]":
        ...

    def create_gpg_key_for_authenticated_user(
        self, *, data: Union[Unset, UserGpgKeysPostBodyType] = UNSET, **kwargs
    ) -> "Response[GpgKey]":
        url = "/user/gpg_keys"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserGpgKeysPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=GpgKey,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_create_gpg_key_for_authenticated_user(
        self, *, data: UserGpgKeysPostBodyType
    ) -> "Response[GpgKey]":
        ...

    @overload
    async def async_create_gpg_key_for_authenticated_user(
        self,
        *,
        data: Unset = UNSET,
        name: Union[Unset, str] = UNSET,
        armored_public_key: str,
    ) -> "Response[GpgKey]":
        ...

    async def async_create_gpg_key_for_authenticated_user(
        self, *, data: Union[Unset, UserGpgKeysPostBodyType] = UNSET, **kwargs
    ) -> "Response[GpgKey]":
        url = "/user/gpg_keys"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserGpgKeysPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=GpgKey,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_gpg_key_for_authenticated_user(
        self,
        gpg_key_id: int,
    ) -> "Response[GpgKey]":
        url = f"/user/gpg_keys/{gpg_key_id}"

        return self._github.request(
            "GET",
            url,
            response_model=GpgKey,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_gpg_key_for_authenticated_user(
        self,
        gpg_key_id: int,
    ) -> "Response[GpgKey]":
        url = f"/user/gpg_keys/{gpg_key_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=GpgKey,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_gpg_key_for_authenticated_user(
        self,
        gpg_key_id: int,
    ) -> "Response":
        url = f"/user/gpg_keys/{gpg_key_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_gpg_key_for_authenticated_user(
        self,
        gpg_key_id: int,
    ) -> "Response":
        url = f"/user/gpg_keys/{gpg_key_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_public_ssh_keys_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Key]]":
        url = "/user/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Key],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_public_ssh_keys_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Key]]":
        url = "/user/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Key],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_public_ssh_key_for_authenticated_user(
        self, *, data: UserKeysPostBodyType
    ) -> "Response[Key]":
        ...

    @overload
    def create_public_ssh_key_for_authenticated_user(
        self,
        *,
        data: Unset = UNSET,
        title: Union[Unset, str] = UNSET,
        key: str,
    ) -> "Response[Key]":
        ...

    def create_public_ssh_key_for_authenticated_user(
        self, *, data: Union[Unset, UserKeysPostBodyType] = UNSET, **kwargs
    ) -> "Response[Key]":
        url = "/user/keys"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserKeysPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Key,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_create_public_ssh_key_for_authenticated_user(
        self, *, data: UserKeysPostBodyType
    ) -> "Response[Key]":
        ...

    @overload
    async def async_create_public_ssh_key_for_authenticated_user(
        self,
        *,
        data: Unset = UNSET,
        title: Union[Unset, str] = UNSET,
        key: str,
    ) -> "Response[Key]":
        ...

    async def async_create_public_ssh_key_for_authenticated_user(
        self, *, data: Union[Unset, UserKeysPostBodyType] = UNSET, **kwargs
    ) -> "Response[Key]":
        url = "/user/keys"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserKeysPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Key,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_public_ssh_key_for_authenticated_user(
        self,
        key_id: int,
    ) -> "Response[Key]":
        url = f"/user/keys/{key_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Key,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_public_ssh_key_for_authenticated_user(
        self,
        key_id: int,
    ) -> "Response[Key]":
        url = f"/user/keys/{key_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Key,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_public_ssh_key_for_authenticated_user(
        self,
        key_id: int,
    ) -> "Response":
        url = f"/user/keys/{key_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_public_ssh_key_for_authenticated_user(
        self,
        key_id: int,
    ) -> "Response":
        url = f"/user/keys/{key_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_public_emails_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Email]]":
        url = "/user/public_emails"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Email],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_public_emails_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Email]]":
        url = "/user/public_emails"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Email],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_ssh_signing_keys_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SshSigningKey]]":
        url = "/user/ssh_signing_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SshSigningKey],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_ssh_signing_keys_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SshSigningKey]]":
        url = "/user/ssh_signing_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SshSigningKey],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_ssh_signing_key_for_authenticated_user(
        self, *, data: UserSshSigningKeysPostBodyType
    ) -> "Response[SshSigningKey]":
        ...

    @overload
    def create_ssh_signing_key_for_authenticated_user(
        self,
        *,
        data: Unset = UNSET,
        title: Union[Unset, str] = UNSET,
        key: str,
    ) -> "Response[SshSigningKey]":
        ...

    def create_ssh_signing_key_for_authenticated_user(
        self, *, data: Union[Unset, UserSshSigningKeysPostBodyType] = UNSET, **kwargs
    ) -> "Response[SshSigningKey]":
        url = "/user/ssh_signing_keys"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserSshSigningKeysPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=SshSigningKey,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_create_ssh_signing_key_for_authenticated_user(
        self, *, data: UserSshSigningKeysPostBodyType
    ) -> "Response[SshSigningKey]":
        ...

    @overload
    async def async_create_ssh_signing_key_for_authenticated_user(
        self,
        *,
        data: Unset = UNSET,
        title: Union[Unset, str] = UNSET,
        key: str,
    ) -> "Response[SshSigningKey]":
        ...

    async def async_create_ssh_signing_key_for_authenticated_user(
        self, *, data: Union[Unset, UserSshSigningKeysPostBodyType] = UNSET, **kwargs
    ) -> "Response[SshSigningKey]":
        url = "/user/ssh_signing_keys"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserSshSigningKeysPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=SshSigningKey,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_ssh_signing_key_for_authenticated_user(
        self,
        ssh_signing_key_id: int,
    ) -> "Response[SshSigningKey]":
        url = f"/user/ssh_signing_keys/{ssh_signing_key_id}"

        return self._github.request(
            "GET",
            url,
            response_model=SshSigningKey,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_ssh_signing_key_for_authenticated_user(
        self,
        ssh_signing_key_id: int,
    ) -> "Response[SshSigningKey]":
        url = f"/user/ssh_signing_keys/{ssh_signing_key_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=SshSigningKey,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_ssh_signing_key_for_authenticated_user(
        self,
        ssh_signing_key_id: int,
    ) -> "Response":
        url = f"/user/ssh_signing_keys/{ssh_signing_key_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_ssh_signing_key_for_authenticated_user(
        self,
        ssh_signing_key_id: int,
    ) -> "Response":
        url = f"/user/ssh_signing_keys/{ssh_signing_key_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list(
        self,
        since: Union[Unset, int] = UNSET,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[List[SimpleUser]]":
        url = "/users"

        params = {
            "since": since,
            "per_page": per_page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
        )

    async def async_list(
        self,
        since: Union[Unset, int] = UNSET,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[List[SimpleUser]]":
        url = "/users"

        params = {
            "since": since,
            "per_page": per_page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
        )

    def get_by_username(
        self,
        username: str,
    ) -> "Response[Union[PrivateUser, PublicUser]]":
        url = f"/users/{username}"

        return self._github.request(
            "GET",
            url,
            response_model=Union[PrivateUser, PublicUser],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_by_username(
        self,
        username: str,
    ) -> "Response[Union[PrivateUser, PublicUser]]":
        url = f"/users/{username}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Union[PrivateUser, PublicUser],
            error_models={
                "404": BasicError,
            },
        )

    def list_followers_for_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/users/{username}/followers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
        )

    async def async_list_followers_for_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/users/{username}/followers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
        )

    def list_following_for_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/users/{username}/following"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
        )

    async def async_list_following_for_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SimpleUser]]":
        url = f"/users/{username}/following"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SimpleUser],
        )

    def check_following_for_user(
        self,
        username: str,
        target_user: str,
    ) -> "Response":
        url = f"/users/{username}/following/{target_user}"

        return self._github.request(
            "GET",
            url,
            error_models={},
        )

    async def async_check_following_for_user(
        self,
        username: str,
        target_user: str,
    ) -> "Response":
        url = f"/users/{username}/following/{target_user}"

        return await self._github.arequest(
            "GET",
            url,
            error_models={},
        )

    def list_gpg_keys_for_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[GpgKey]]":
        url = f"/users/{username}/gpg_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[GpgKey],
        )

    async def async_list_gpg_keys_for_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[GpgKey]]":
        url = f"/users/{username}/gpg_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[GpgKey],
        )

    def get_context_for_user(
        self,
        username: str,
        subject_type: Union[
            Unset, Literal["organization", "repository", "issue", "pull_request"]
        ] = UNSET,
        subject_id: Union[Unset, str] = UNSET,
    ) -> "Response[Hovercard]":
        url = f"/users/{username}/hovercard"

        params = {
            "subject_type": subject_type,
            "subject_id": subject_id,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Hovercard,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_context_for_user(
        self,
        username: str,
        subject_type: Union[
            Unset, Literal["organization", "repository", "issue", "pull_request"]
        ] = UNSET,
        subject_id: Union[Unset, str] = UNSET,
    ) -> "Response[Hovercard]":
        url = f"/users/{username}/hovercard"

        params = {
            "subject_type": subject_type,
            "subject_id": subject_id,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Hovercard,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_public_keys_for_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[KeySimple]]":
        url = f"/users/{username}/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[KeySimple],
        )

    async def async_list_public_keys_for_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[KeySimple]]":
        url = f"/users/{username}/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[KeySimple],
        )

    def list_ssh_signing_keys_for_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SshSigningKey]]":
        url = f"/users/{username}/ssh_signing_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SshSigningKey],
        )

    async def async_list_ssh_signing_keys_for_user(
        self,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[SshSigningKey]]":
        url = f"/users/{username}/ssh_signing_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[SshSigningKey],
        )
