"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, List, Union, Literal, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    SelectedActionsType,
    EnterprisesEnterpriseActionsPermissionsPutBodyType,
    EnterprisesEnterpriseActionsRunnerGroupsPostBodyType,
    EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType,
    EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType,
    EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType,
)
from .models import (
    Runner,
    BasicError,
    SelectedActions,
    RunnerApplication,
    AuthenticationToken,
    ValidationErrorSimple,
    RunnerGroupsEnterprise,
    ActionsEnterprisePermissions,
    EnterprisesEnterpriseActionsPermissionsPutBody,
    EnterprisesEnterpriseActionsRunnerGroupsPostBody,
    EnterprisesEnterpriseActionsRunnersGetResponse200,
    EnterprisesEnterpriseActionsRunnerGroupsGetResponse200,
    EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBody,
    EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBody,
    EnterprisesEnterpriseActionsPermissionsOrganizationsPutBody,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBody,
    EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
    EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
    EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBody,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBody,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
    EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
)

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class EnterpriseAdminClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def get_github_actions_permissions_enterprise(
        self,
        enterprise: str,
    ) -> "Response[ActionsEnterprisePermissions]":
        url = f"/enterprises/{enterprise}/actions/permissions"

        return self._github.request(
            "GET",
            url,
            response_model=ActionsEnterprisePermissions,
        )

    async def async_get_github_actions_permissions_enterprise(
        self,
        enterprise: str,
    ) -> "Response[ActionsEnterprisePermissions]":
        url = f"/enterprises/{enterprise}/actions/permissions"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ActionsEnterprisePermissions,
        )

    @overload
    def set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        data: EnterprisesEnterpriseActionsPermissionsPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        data: Unset = UNSET,
        enabled_organizations: Literal["all", "none", "selected"],
        allowed_actions: Union[Unset, Literal["all", "local_only", "selected"]] = UNSET,
    ) -> "Response":
        ...

    def set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        data: Union[Unset, EnterprisesEnterpriseActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(EnterprisesEnterpriseActionsPermissionsPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        data: EnterprisesEnterpriseActionsPermissionsPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        data: Unset = UNSET,
        enabled_organizations: Literal["all", "none", "selected"],
        allowed_actions: Union[Unset, Literal["all", "local_only", "selected"]] = UNSET,
    ) -> "Response":
        ...

    async def async_set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        data: Union[Unset, EnterprisesEnterpriseActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(EnterprisesEnterpriseActionsPermissionsPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def list_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
        )

    async def async_list_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
        )

    @overload
    def set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: Unset = UNSET,
        selected_organization_ids: List[int],
    ) -> "Response":
        ...

    def set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsPermissionsOrganizationsPutBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: Unset = UNSET,
        selected_organization_ids: List[int],
    ) -> "Response":
        ...

    async def async_set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsPermissionsOrganizationsPutBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def enable_selected_organization_github_actions_enterprise(
        self,
        enterprise: str,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations/{org_id}"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_enable_selected_organization_github_actions_enterprise(
        self,
        enterprise: str,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations/{org_id}"

        return await self._github.arequest(
            "PUT",
            url,
        )

    def disable_selected_organization_github_actions_enterprise(
        self,
        enterprise: str,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations/{org_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_disable_selected_organization_github_actions_enterprise(
        self,
        enterprise: str,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/organizations/{org_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def get_allowed_actions_enterprise(
        self,
        enterprise: str,
    ) -> "Response[SelectedActions]":
        url = f"/enterprises/{enterprise}/actions/permissions/selected-actions"

        return self._github.request(
            "GET",
            url,
            response_model=SelectedActions,
        )

    async def async_get_allowed_actions_enterprise(
        self,
        enterprise: str,
    ) -> "Response[SelectedActions]":
        url = f"/enterprises/{enterprise}/actions/permissions/selected-actions"

        return await self._github.arequest(
            "GET",
            url,
            response_model=SelectedActions,
        )

    @overload
    def set_allowed_actions_enterprise(
        self, enterprise: str, *, data: SelectedActionsType
    ) -> "Response":
        ...

    @overload
    def set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: Unset = UNSET,
        github_owned_allowed: Union[Unset, bool] = UNSET,
        verified_allowed: Union[Unset, bool] = UNSET,
        patterns_allowed: Union[Unset, List[str]] = UNSET,
    ) -> "Response":
        ...

    def set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: Union[Unset, SelectedActionsType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/selected-actions"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(SelectedActions, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_set_allowed_actions_enterprise(
        self, enterprise: str, *, data: SelectedActionsType
    ) -> "Response":
        ...

    @overload
    async def async_set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: Unset = UNSET,
        github_owned_allowed: Union[Unset, bool] = UNSET,
        verified_allowed: Union[Unset, bool] = UNSET,
        patterns_allowed: Union[Unset, List[str]] = UNSET,
    ) -> "Response":
        ...

    async def async_set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: Union[Unset, SelectedActionsType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/permissions/selected-actions"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(SelectedActions, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def list_self_hosted_runner_groups_for_enterprise(
        self,
        enterprise: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        visible_to_organization: Union[Unset, str] = UNSET,
    ) -> "Response[EnterprisesEnterpriseActionsRunnerGroupsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runner-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "visible_to_organization": visible_to_organization,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsGetResponse200,
        )

    async def async_list_self_hosted_runner_groups_for_enterprise(
        self,
        enterprise: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        visible_to_organization: Union[Unset, str] = UNSET,
    ) -> "Response[EnterprisesEnterpriseActionsRunnerGroupsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runner-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "visible_to_organization": visible_to_organization,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsGetResponse200,
        )

    @overload
    def create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        data: EnterprisesEnterpriseActionsRunnerGroupsPostBodyType,
    ) -> "Response[RunnerGroupsEnterprise]":
        ...

    @overload
    def create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        data: Unset = UNSET,
        name: str,
        visibility: Union[Unset, Literal["selected", "all"]] = UNSET,
        selected_organization_ids: Union[Unset, List[int]] = UNSET,
        runners: Union[Unset, List[int]] = UNSET,
        allows_public_repositories: Union[Unset, bool] = False,
        restricted_to_workflows: Union[Unset, bool] = False,
        selected_workflows: Union[Unset, List[str]] = UNSET,
    ) -> "Response[RunnerGroupsEnterprise]":
        ...

    def create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsRunnerGroupsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[RunnerGroupsEnterprise]":
        url = f"/enterprises/{enterprise}/actions/runner-groups"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(EnterprisesEnterpriseActionsRunnerGroupsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=RunnerGroupsEnterprise,
        )

    @overload
    async def async_create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        data: EnterprisesEnterpriseActionsRunnerGroupsPostBodyType,
    ) -> "Response[RunnerGroupsEnterprise]":
        ...

    @overload
    async def async_create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        data: Unset = UNSET,
        name: str,
        visibility: Union[Unset, Literal["selected", "all"]] = UNSET,
        selected_organization_ids: Union[Unset, List[int]] = UNSET,
        runners: Union[Unset, List[int]] = UNSET,
        allows_public_repositories: Union[Unset, bool] = False,
        restricted_to_workflows: Union[Unset, bool] = False,
        selected_workflows: Union[Unset, List[str]] = UNSET,
    ) -> "Response[RunnerGroupsEnterprise]":
        ...

    async def async_create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsRunnerGroupsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[RunnerGroupsEnterprise]":
        url = f"/enterprises/{enterprise}/actions/runner-groups"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(EnterprisesEnterpriseActionsRunnerGroupsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=RunnerGroupsEnterprise,
        )

    def get_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
    ) -> "Response[RunnerGroupsEnterprise]":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        return self._github.request(
            "GET",
            url,
            response_model=RunnerGroupsEnterprise,
        )

    async def async_get_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
    ) -> "Response[RunnerGroupsEnterprise]":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=RunnerGroupsEnterprise,
        )

    def delete_self_hosted_runner_group_from_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_self_hosted_runner_group_from_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    @overload
    def update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType
        ] = UNSET,
    ) -> "Response[RunnerGroupsEnterprise]":
        ...

    @overload
    def update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Unset = UNSET,
        name: Union[Unset, str] = UNSET,
        visibility: Union[Unset, Literal["selected", "all"]] = "all",
        allows_public_repositories: Union[Unset, bool] = False,
        restricted_to_workflows: Union[Unset, bool] = False,
        selected_workflows: Union[Unset, List[str]] = UNSET,
    ) -> "Response[RunnerGroupsEnterprise]":
        ...

    def update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[RunnerGroupsEnterprise]":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=RunnerGroupsEnterprise,
        )

    @overload
    async def async_update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType
        ] = UNSET,
    ) -> "Response[RunnerGroupsEnterprise]":
        ...

    @overload
    async def async_update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Unset = UNSET,
        name: Union[Unset, str] = UNSET,
        visibility: Union[Unset, Literal["selected", "all"]] = "all",
        allows_public_repositories: Union[Unset, bool] = False,
        restricted_to_workflows: Union[Unset, bool] = False,
        selected_workflows: Union[Unset, List[str]] = UNSET,
    ) -> "Response[RunnerGroupsEnterprise]":
        ...

    async def async_update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[RunnerGroupsEnterprise]":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=RunnerGroupsEnterprise,
        )

    def list_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
        )

    async def async_list_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
        )

    @overload
    def set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Unset = UNSET,
        selected_organization_ids: List[int],
    ) -> "Response":
        ...

    def set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Union[
            Unset,
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType,
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBody,
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Unset = UNSET,
        selected_organization_ids: List[int],
    ) -> "Response":
        ...

    async def async_set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Union[
            Unset,
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType,
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBody,
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def add_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_add_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}"

        return await self._github.arequest(
            "PUT",
            url,
        )

    def remove_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_remove_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        org_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200]":
        url = (
            f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners"
        )

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200]":
        url = (
            f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners"
        )

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

    @overload
    def set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Unset = UNSET,
        runners: List[int],
    ) -> "Response":
        ...

    def set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Union[
            Unset,
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = (
            f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners"
        )

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    @overload
    async def async_set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Unset = UNSET,
        runners: List[int],
    ) -> "Response":
        ...

    async def async_set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: Union[
            Unset,
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = (
            f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners"
        )

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
        )

    def add_self_hosted_runner_to_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        runner_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_add_self_hosted_runner_to_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        runner_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        return await self._github.arequest(
            "PUT",
            url,
        )

    def remove_self_hosted_runner_from_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        runner_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_remove_self_hosted_runner_from_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        runner_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_self_hosted_runners_for_enterprise(
        self,
        enterprise: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_for_enterprise(
        self,
        enterprise: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=EnterprisesEnterpriseActionsRunnersGetResponse200,
        )

    def list_runner_applications_for_enterprise(
        self,
        enterprise: str,
    ) -> "Response[List[RunnerApplication]]":
        url = f"/enterprises/{enterprise}/actions/runners/downloads"

        return self._github.request(
            "GET",
            url,
            response_model=List[RunnerApplication],
        )

    async def async_list_runner_applications_for_enterprise(
        self,
        enterprise: str,
    ) -> "Response[List[RunnerApplication]]":
        url = f"/enterprises/{enterprise}/actions/runners/downloads"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[RunnerApplication],
        )

    def create_registration_token_for_enterprise(
        self,
        enterprise: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/enterprises/{enterprise}/actions/runners/registration-token"

        return self._github.request(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    async def async_create_registration_token_for_enterprise(
        self,
        enterprise: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/enterprises/{enterprise}/actions/runners/registration-token"

        return await self._github.arequest(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    def create_remove_token_for_enterprise(
        self,
        enterprise: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/enterprises/{enterprise}/actions/runners/remove-token"

        return self._github.request(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    async def async_create_remove_token_for_enterprise(
        self,
        enterprise: str,
    ) -> "Response[AuthenticationToken]":
        url = f"/enterprises/{enterprise}/actions/runners/remove-token"

        return await self._github.arequest(
            "POST",
            url,
            response_model=AuthenticationToken,
        )

    def get_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response[Runner]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Runner,
        )

    async def async_get_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response[Runner]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Runner,
        )

    def delete_self_hosted_runner_from_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_self_hosted_runner_from_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        return self._github.request(
            "GET",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        return await self._github.arequest(
            "GET",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    def set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: Unset = UNSET,
        labels: List[str],
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    def set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: Unset = UNSET,
        labels: List[str],
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    async def async_set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    def add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: Unset = UNSET,
        labels: List[str],
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    def add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: Unset = UNSET,
        labels: List[str],
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    async def async_add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: Union[
            Unset, EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def remove_all_custom_labels_from_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        return self._github.request(
            "DELETE",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_remove_all_custom_labels_from_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        return await self._github.arequest(
            "DELETE",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def remove_custom_label_from_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        name: str,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels/{name}"

        return self._github.request(
            "DELETE",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_remove_custom_label_from_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        name: str,
    ) -> "Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels/{name}"

        return await self._github.arequest(
            "DELETE",
            url,
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )
