"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api discription.
See https://github.com/github/rest-api-description for more information.
"""


from datetime import datetime
from typing import TYPE_CHECKING, List, Union, Literal, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    UserReposPostBodyType,
    OrgsOrgReposPostBodyType,
    ReposOwnerRepoPatchBodyType,
    ReposOwnerRepoKeysPostBodyType,
    ReposOwnerRepoForksPostBodyType,
    ReposOwnerRepoHooksPostBodyType,
    ReposOwnerRepoTopicsPutBodyType,
    ReposOwnerRepoMergesPostBodyType,
    DeploymentBranchPolicySettingsType,
    ReposOwnerRepoReleasesPostBodyType,
    ReposOwnerRepoTransferPostBodyType,
    ReposOwnerRepoAutolinksPostBodyType,
    ReposOwnerRepoDispatchesPostBodyType,
    ReposOwnerRepoPagesPutBodyAnyof0Type,
    ReposOwnerRepoPagesPutBodyAnyof1Type,
    ReposOwnerRepoPagesPutBodyAnyof2Type,
    ReposOwnerRepoPagesPutBodyAnyof3Type,
    ReposOwnerRepoPagesPutBodyAnyof4Type,
    DeploymentBranchPolicyNamePatternType,
    ReposOwnerRepoContentsPathPutBodyType,
    ReposOwnerRepoDeploymentsPostBodyType,
    ReposOwnerRepoPagesPostBodyAnyof0Type,
    ReposOwnerRepoPagesPostBodyAnyof1Type,
    ReposOwnerRepoStatusesShaPostBodyType,
    ReposOwnerRepoHooksHookIdPatchBodyType,
    ReposOwnerRepoMergeUpstreamPostBodyType,
    ReposOwnerRepoContentsPathDeleteBodyType,
    ReposOwnerRepoTagsProtectionPostBodyType,
    ReposOwnerRepoHooksPostBodyPropConfigType,
    ReposOwnerRepoPagesDeploymentPostBodyType,
    ReposOwnerRepoPagesPostBodyPropSourceType,
    ReposOwnerRepoCommentsCommentIdPatchBodyType,
    ReposOwnerRepoHooksHookIdConfigPatchBodyType,
    ReposOwnerRepoReleasesReleaseIdPatchBodyType,
    ReposOwnerRepoBranchesBranchRenamePostBodyType,
    ReposOwnerRepoCollaboratorsUsernamePutBodyType,
    ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
    ReposOwnerRepoContentsPathPutBodyPropAuthorType,
    ReposOwnerRepoReleasesGenerateNotesPostBodyType,
    ReposOwnerRepoHooksHookIdPatchBodyPropConfigType,
    ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType,
    ReposOwnerRepoBranchesBranchProtectionPutBodyType,
    ReposOwnerRepoCommitsCommitShaCommentsPostBodyType,
    ReposOwnerRepoContentsPathDeleteBodyPropAuthorType,
    ReposOwnerRepoContentsPathPutBodyPropCommitterType,
    ReposOwnerRepoInvitationsInvitationIdPatchBodyType,
    ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType,
    ReposTemplateOwnerTemplateRepoGeneratePostBodyType,
    ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType,
    ReposOwnerRepoContentsPathDeleteBodyPropCommitterType,
    ReposOwnerRepoDispatchesPostBodyPropClientPayloadType,
    ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type,
    ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType,
    ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType,
    ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItemsType,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType,
    ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType,
    ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType,
    ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType,
)
from .models import (
    Tag,
    Hook,
    Page,
    Team,
    Topic,
    Commit,
    Status,
    Release,
    Autolink,
    Language,
    DeployKey,
    PageBuild,
    BasicError,
    Deployment,
    FileCommit,
    Repository,
    SimpleUser,
    BranchShort,
    ContentFile,
    ContentTree,
    Contributor,
    Environment,
    Integration,
    ShortBranch,
    ViewTraffic,
    CloneTraffic,
    Collaborator,
    HookDelivery,
    ReleaseAsset,
    CommitComment,
    TagProtection,
    WebhookConfig,
    CommitActivity,
    ContentTraffic,
    FullRepository,
    MergedUpstream,
    PageDeployment,
    PageBuildStatus,
    ProtectedBranch,
    ReferrerTraffic,
    ValidationError,
    BranchProtection,
    CodeownersErrors,
    CommitComparison,
    CommunityProfile,
    DeploymentStatus,
    HookDeliveryItem,
    PagesHealthCheck,
    MinimalRepository,
    PullRequestSimple,
    StatusCheckPolicy,
    UserReposPostBody,
    ParticipationStats,
    ContributorActivity,
    ReleaseNotesContent,
    BranchWithProtection,
    CombinedCommitStatus,
    OrgsOrgReposPostBody,
    RepositoryInvitation,
    ValidationErrorSimple,
    DeploymentBranchPolicy,
    BranchRestrictionPolicy,
    ReposOwnerRepoPatchBody,
    ReposOwnerRepoKeysPostBody,
    ReposOwnerRepoForksPostBody,
    ReposOwnerRepoHooksPostBody,
    ReposOwnerRepoTopicsPutBody,
    ProtectedBranchAdminEnforced,
    ReposOwnerRepoMergesPostBody,
    ReposOwnerRepoReleasesPostBody,
    ReposOwnerRepoTransferPostBody,
    ReposOwnerRepoAutolinksPostBody,
    ReposOwnerRepoDeleteResponse403,
    ProtectedBranchPullRequestReview,
    RepositoryCollaboratorPermission,
    ReposOwnerRepoDispatchesPostBody,
    ReposOwnerRepoPagesPutBodyAnyof0,
    ReposOwnerRepoPagesPutBodyAnyof1,
    ReposOwnerRepoPagesPutBodyAnyof2,
    ReposOwnerRepoPagesPutBodyAnyof3,
    ReposOwnerRepoPagesPutBodyAnyof4,
    DeploymentBranchPolicyNamePattern,
    ReposOwnerRepoContentsPathPutBody,
    ReposOwnerRepoDeploymentsPostBody,
    ReposOwnerRepoPagesPostBodyAnyof0,
    ReposOwnerRepoPagesPostBodyAnyof1,
    ReposOwnerRepoStatusesShaPostBody,
    ReposOwnerRepoHooksHookIdPatchBody,
    ReposOwnerRepoMergeUpstreamPostBody,
    ReposOwnerRepoContentsPathDeleteBody,
    ReposOwnerRepoTagsProtectionPostBody,
    ReposOwnerRepoPagesDeploymentPostBody,
    ReposOwnerRepoCommentsCommentIdPatchBody,
    ReposOwnerRepoEnvironmentsGetResponse200,
    ReposOwnerRepoHooksHookIdConfigPatchBody,
    ReposOwnerRepoReleasesReleaseIdPatchBody,
    ReposOwnerRepoBranchesBranchRenamePostBody,
    ReposOwnerRepoCollaboratorsUsernamePutBody,
    ReposOwnerRepoReleasesGenerateNotesPostBody,
    ReposOwnerRepoReleasesAssetsAssetIdPatchBody,
    ReposOwnerRepoBranchesBranchProtectionPutBody,
    ReposOwnerRepoCommitsCommitShaCommentsPostBody,
    ReposOwnerRepoInvitationsInvitationIdPatchBody,
    ReposTemplateOwnerTemplateRepoGeneratePostBody,
    ReposOwnerRepoEnvironmentsEnvironmentNamePutBody,
    AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
    EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
    ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0,
    ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0,
    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0,
)

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class ReposClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list_for_org(
        self,
        org: str,
        type: Union[
            Unset,
            Literal[
                "all", "public", "private", "forks", "sources", "member", "internal"
            ],
        ] = UNSET,
        sort: Union[
            Unset, Literal["created", "updated", "pushed", "full_name"]
        ] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/orgs/{org}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
        )

    async def async_list_for_org(
        self,
        org: str,
        type: Union[
            Unset,
            Literal[
                "all", "public", "private", "forks", "sources", "member", "internal"
            ],
        ] = UNSET,
        sort: Union[
            Unset, Literal["created", "updated", "pushed", "full_name"]
        ] = "created",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/orgs/{org}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
        )

    @overload
    def create_in_org(
        self, org: str, *, data: OrgsOrgReposPostBodyType
    ) -> "Response[Repository]":
        ...

    @overload
    def create_in_org(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        name: str,
        description: Union[Unset, str] = UNSET,
        homepage: Union[Unset, str] = UNSET,
        private: Union[Unset, bool] = False,
        visibility: Union[Unset, Literal["public", "private", "internal"]] = UNSET,
        has_issues: Union[Unset, bool] = True,
        has_projects: Union[Unset, bool] = True,
        has_wiki: Union[Unset, bool] = True,
        is_template: Union[Unset, bool] = False,
        team_id: Union[Unset, int] = UNSET,
        auto_init: Union[Unset, bool] = False,
        gitignore_template: Union[Unset, str] = UNSET,
        license_template: Union[Unset, str] = UNSET,
        allow_squash_merge: Union[Unset, bool] = True,
        allow_merge_commit: Union[Unset, bool] = True,
        allow_rebase_merge: Union[Unset, bool] = True,
        allow_auto_merge: Union[Unset, bool] = False,
        delete_branch_on_merge: Union[Unset, bool] = False,
        use_squash_pr_title_as_default: Union[Unset, bool] = False,
        squash_merge_commit_title: Union[
            Unset, Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Union[
            Unset, Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Union[Unset, Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Union[
            Unset, Literal["PR_BODY", "PR_TITLE", "BLANK"]
        ] = UNSET,
    ) -> "Response[Repository]":
        ...

    def create_in_org(
        self,
        org: str,
        *,
        data: Union[Unset, OrgsOrgReposPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Repository]":
        url = f"/orgs/{org}/repos"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgReposPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Repository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_in_org(
        self, org: str, *, data: OrgsOrgReposPostBodyType
    ) -> "Response[Repository]":
        ...

    @overload
    async def async_create_in_org(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        name: str,
        description: Union[Unset, str] = UNSET,
        homepage: Union[Unset, str] = UNSET,
        private: Union[Unset, bool] = False,
        visibility: Union[Unset, Literal["public", "private", "internal"]] = UNSET,
        has_issues: Union[Unset, bool] = True,
        has_projects: Union[Unset, bool] = True,
        has_wiki: Union[Unset, bool] = True,
        is_template: Union[Unset, bool] = False,
        team_id: Union[Unset, int] = UNSET,
        auto_init: Union[Unset, bool] = False,
        gitignore_template: Union[Unset, str] = UNSET,
        license_template: Union[Unset, str] = UNSET,
        allow_squash_merge: Union[Unset, bool] = True,
        allow_merge_commit: Union[Unset, bool] = True,
        allow_rebase_merge: Union[Unset, bool] = True,
        allow_auto_merge: Union[Unset, bool] = False,
        delete_branch_on_merge: Union[Unset, bool] = False,
        use_squash_pr_title_as_default: Union[Unset, bool] = False,
        squash_merge_commit_title: Union[
            Unset, Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Union[
            Unset, Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Union[Unset, Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Union[
            Unset, Literal["PR_BODY", "PR_TITLE", "BLANK"]
        ] = UNSET,
    ) -> "Response[Repository]":
        ...

    async def async_create_in_org(
        self,
        org: str,
        *,
        data: Union[Unset, OrgsOrgReposPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Repository]":
        url = f"/orgs/{org}/repos"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgReposPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Repository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def get(
        self,
        owner: str,
        repo: str,
    ) -> "Response[FullRepository]":
        url = f"/repos/{owner}/{repo}"

        return self._github.request(
            "GET",
            url,
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get(
        self,
        owner: str,
        repo: str,
    ) -> "Response[FullRepository]":
        url = f"/repos/{owner}/{repo}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "403": ReposOwnerRepoDeleteResponse403,
                "404": BasicError,
            },
        )

    async def async_delete(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "403": ReposOwnerRepoDeleteResponse403,
                "404": BasicError,
            },
        )

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoPatchBodyType] = UNSET,
    ) -> "Response[FullRepository]":
        ...

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        name: Union[Unset, str] = UNSET,
        description: Union[Unset, str] = UNSET,
        homepage: Union[Unset, str] = UNSET,
        private: Union[Unset, bool] = False,
        visibility: Union[Unset, Literal["public", "private", "internal"]] = UNSET,
        security_and_analysis: Union[
            Unset, Union[ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType, None]
        ] = UNSET,
        has_issues: Union[Unset, bool] = True,
        has_projects: Union[Unset, bool] = True,
        has_wiki: Union[Unset, bool] = True,
        is_template: Union[Unset, bool] = False,
        default_branch: Union[Unset, str] = UNSET,
        allow_squash_merge: Union[Unset, bool] = True,
        allow_merge_commit: Union[Unset, bool] = True,
        allow_rebase_merge: Union[Unset, bool] = True,
        allow_auto_merge: Union[Unset, bool] = False,
        delete_branch_on_merge: Union[Unset, bool] = False,
        allow_update_branch: Union[Unset, bool] = False,
        use_squash_pr_title_as_default: Union[Unset, bool] = False,
        squash_merge_commit_title: Union[
            Unset, Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Union[
            Unset, Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Union[Unset, Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Union[
            Unset, Literal["PR_BODY", "PR_TITLE", "BLANK"]
        ] = UNSET,
        archived: Union[Unset, bool] = False,
        allow_forking: Union[Unset, bool] = False,
        web_commit_signoff_required: Union[Unset, bool] = False,
    ) -> "Response[FullRepository]":
        ...

    def update(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[FullRepository]":
        url = f"/repos/{owner}/{repo}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoPatchBodyType] = UNSET,
    ) -> "Response[FullRepository]":
        ...

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        name: Union[Unset, str] = UNSET,
        description: Union[Unset, str] = UNSET,
        homepage: Union[Unset, str] = UNSET,
        private: Union[Unset, bool] = False,
        visibility: Union[Unset, Literal["public", "private", "internal"]] = UNSET,
        security_and_analysis: Union[
            Unset, Union[ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType, None]
        ] = UNSET,
        has_issues: Union[Unset, bool] = True,
        has_projects: Union[Unset, bool] = True,
        has_wiki: Union[Unset, bool] = True,
        is_template: Union[Unset, bool] = False,
        default_branch: Union[Unset, str] = UNSET,
        allow_squash_merge: Union[Unset, bool] = True,
        allow_merge_commit: Union[Unset, bool] = True,
        allow_rebase_merge: Union[Unset, bool] = True,
        allow_auto_merge: Union[Unset, bool] = False,
        delete_branch_on_merge: Union[Unset, bool] = False,
        allow_update_branch: Union[Unset, bool] = False,
        use_squash_pr_title_as_default: Union[Unset, bool] = False,
        squash_merge_commit_title: Union[
            Unset, Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Union[
            Unset, Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Union[Unset, Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Union[
            Unset, Literal["PR_BODY", "PR_TITLE", "BLANK"]
        ] = UNSET,
        archived: Union[Unset, bool] = False,
        allow_forking: Union[Unset, bool] = False,
        web_commit_signoff_required: Union[Unset, bool] = False,
    ) -> "Response[FullRepository]":
        ...

    async def async_update(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[FullRepository]":
        url = f"/repos/{owner}/{repo}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_autolinks(
        self,
        owner: str,
        repo: str,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Autolink]]":
        url = f"/repos/{owner}/{repo}/autolinks"

        params = {
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Autolink],
        )

    async def async_list_autolinks(
        self,
        owner: str,
        repo: str,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Autolink]]":
        url = f"/repos/{owner}/{repo}/autolinks"

        params = {
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Autolink],
        )

    @overload
    def create_autolink(
        self, owner: str, repo: str, *, data: ReposOwnerRepoAutolinksPostBodyType
    ) -> "Response[Autolink]":
        ...

    @overload
    def create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        key_prefix: str,
        url_template: str,
        is_alphanumeric: Union[Unset, bool] = True,
    ) -> "Response[Autolink]":
        ...

    def create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoAutolinksPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Autolink]":
        url = f"/repos/{owner}/{repo}/autolinks"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoAutolinksPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Autolink,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_autolink(
        self, owner: str, repo: str, *, data: ReposOwnerRepoAutolinksPostBodyType
    ) -> "Response[Autolink]":
        ...

    @overload
    async def async_create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        key_prefix: str,
        url_template: str,
        is_alphanumeric: Union[Unset, bool] = True,
    ) -> "Response[Autolink]":
        ...

    async def async_create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoAutolinksPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Autolink]":
        url = f"/repos/{owner}/{repo}/autolinks"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoAutolinksPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Autolink,
            error_models={
                "422": ValidationError,
            },
        )

    def get_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
    ) -> "Response[Autolink]":
        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Autolink,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
    ) -> "Response[Autolink]":
        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Autolink,
            error_models={
                "404": BasicError,
            },
        )

    def delete_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def enable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_enable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        return await self._github.arequest(
            "PUT",
            url,
        )

    def disable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_disable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_branches(
        self,
        owner: str,
        repo: str,
        protected: Union[Unset, bool] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[ShortBranch]]":
        url = f"/repos/{owner}/{repo}/branches"

        params = {
            "protected": protected,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[ShortBranch],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_branches(
        self,
        owner: str,
        repo: str,
        protected: Union[Unset, bool] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[ShortBranch]]":
        url = f"/repos/{owner}/{repo}/branches"

        params = {
            "protected": protected,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[ShortBranch],
            error_models={
                "404": BasicError,
            },
        )

    def get_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[BranchWithProtection]":
        url = f"/repos/{owner}/{repo}/branches/{branch}"

        return self._github.request(
            "GET",
            url,
            response_model=BranchWithProtection,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[BranchWithProtection]":
        url = f"/repos/{owner}/{repo}/branches/{branch}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=BranchWithProtection,
            error_models={
                "404": BasicError,
            },
        )

    def get_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[BranchProtection]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        return self._github.request(
            "GET",
            url,
            response_model=BranchProtection,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[BranchProtection]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        return await self._github.arequest(
            "GET",
            url,
            response_model=BranchProtection,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: ReposOwnerRepoBranchesBranchProtectionPutBodyType,
    ) -> "Response[ProtectedBranch]":
        ...

    @overload
    def update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        required_status_checks: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType,
            None,
        ],
        enforce_admins: Union[bool, None],
        required_pull_request_reviews: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType,
            None,
        ],
        restrictions: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType, None
        ],
        required_linear_history: Union[Unset, bool] = UNSET,
        allow_force_pushes: Union[Unset, Union[bool, None]] = UNSET,
        allow_deletions: Union[Unset, bool] = UNSET,
        block_creations: Union[Unset, bool] = UNSET,
        required_conversation_resolution: Union[Unset, bool] = UNSET,
    ) -> "Response[ProtectedBranch]":
        ...

    def update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[Unset, ReposOwnerRepoBranchesBranchProtectionPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ProtectedBranch]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoBranchesBranchProtectionPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ProtectedBranch,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: ReposOwnerRepoBranchesBranchProtectionPutBodyType,
    ) -> "Response[ProtectedBranch]":
        ...

    @overload
    async def async_update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        required_status_checks: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType,
            None,
        ],
        enforce_admins: Union[bool, None],
        required_pull_request_reviews: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType,
            None,
        ],
        restrictions: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType, None
        ],
        required_linear_history: Union[Unset, bool] = UNSET,
        allow_force_pushes: Union[Unset, Union[bool, None]] = UNSET,
        allow_deletions: Union[Unset, bool] = UNSET,
        block_creations: Union[Unset, bool] = UNSET,
        required_conversation_resolution: Union[Unset, bool] = UNSET,
    ) -> "Response[ProtectedBranch]":
        ...

    async def async_update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[Unset, ReposOwnerRepoBranchesBranchProtectionPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ProtectedBranch]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoBranchesBranchProtectionPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ProtectedBranch,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    def delete_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
            },
        )

    async def async_delete_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
            },
        )

    def get_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        return self._github.request(
            "GET",
            url,
            response_model=ProtectedBranchAdminEnforced,
        )

    async def async_get_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ProtectedBranchAdminEnforced,
        )

    def set_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        return self._github.request(
            "POST",
            url,
            response_model=ProtectedBranchAdminEnforced,
        )

    async def async_set_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        return await self._github.arequest(
            "POST",
            url,
            response_model=ProtectedBranchAdminEnforced,
        )

    def delete_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def get_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[ProtectedBranchPullRequestReview]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        return self._github.request(
            "GET",
            url,
            response_model=ProtectedBranchPullRequestReview,
        )

    async def async_get_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[ProtectedBranchPullRequestReview]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ProtectedBranchPullRequestReview,
        )

    def delete_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType,
        ] = UNSET,
    ) -> "Response[ProtectedBranchPullRequestReview]":
        ...

    @overload
    def update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        dismissal_restrictions: Union[
            Unset,
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType,
        ] = UNSET,
        dismiss_stale_reviews: Union[Unset, bool] = UNSET,
        require_code_owner_reviews: Union[Unset, bool] = UNSET,
        required_approving_review_count: Union[Unset, int] = UNSET,
        bypass_pull_request_allowances: Union[
            Unset,
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType,
        ] = UNSET,
    ) -> "Response[ProtectedBranchPullRequestReview]":
        ...

    def update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType,
        ] = UNSET,
        **kwargs,
    ) -> "Response[ProtectedBranchPullRequestReview]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody,
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ProtectedBranchPullRequestReview,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType,
        ] = UNSET,
    ) -> "Response[ProtectedBranchPullRequestReview]":
        ...

    @overload
    async def async_update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        dismissal_restrictions: Union[
            Unset,
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType,
        ] = UNSET,
        dismiss_stale_reviews: Union[Unset, bool] = UNSET,
        require_code_owner_reviews: Union[Unset, bool] = UNSET,
        required_approving_review_count: Union[Unset, int] = UNSET,
        bypass_pull_request_allowances: Union[
            Unset,
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType,
        ] = UNSET,
    ) -> "Response[ProtectedBranchPullRequestReview]":
        ...

    async def async_update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType,
        ] = UNSET,
        **kwargs,
    ) -> "Response[ProtectedBranchPullRequestReview]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody,
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ProtectedBranchPullRequestReview,
            error_models={
                "422": ValidationError,
            },
        )

    def get_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        return self._github.request(
            "GET",
            url,
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    def create_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        return self._github.request(
            "POST",
            url,
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    async def async_create_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[ProtectedBranchAdminEnforced]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        return await self._github.arequest(
            "POST",
            url,
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    def delete_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def get_status_checks_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[StatusCheckPolicy]":
        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        return self._github.request(
            "GET",
            url,
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_status_checks_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[StatusCheckPolicy]":
        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        return await self._github.arequest(
            "GET",
            url,
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
            },
        )

    def remove_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_remove_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        return await self._github.arequest(
            "DELETE",
            url,
        )

    @overload
    def update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType,
        ] = UNSET,
    ) -> "Response[StatusCheckPolicy]":
        ...

    @overload
    def update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        strict: Union[Unset, bool] = UNSET,
        contexts: Union[Unset, List[str]] = UNSET,
        checks: Union[
            Unset,
            List[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType
            ],
        ] = UNSET,
    ) -> "Response[StatusCheckPolicy]":
        ...

    def update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType,
        ] = UNSET,
        **kwargs,
    ) -> "Response[StatusCheckPolicy]":
        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType,
        ] = UNSET,
    ) -> "Response[StatusCheckPolicy]":
        ...

    @overload
    async def async_update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        strict: Union[Unset, bool] = UNSET,
        contexts: Union[Unset, List[str]] = UNSET,
        checks: Union[
            Unset,
            List[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType
            ],
        ] = UNSET,
    ) -> "Response[StatusCheckPolicy]":
        ...

    async def async_update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType,
        ] = UNSET,
        **kwargs,
    ) -> "Response[StatusCheckPolicy]":
        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody, json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_all_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        return self._github.request(
            "GET",
            url,
            response_model=List[str],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_all_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[str],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[str]]":
        ...

    @overload
    def set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        contexts: List[str],
    ) -> "Response[List[str]]":
        ...

    def set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=List[str],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[str]]":
        ...

    @overload
    async def async_set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        contexts: List[str],
    ) -> "Response[List[str]]":
        ...

    async def async_set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=List[str],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    def add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[str]]":
        ...

    @overload
    def add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        contexts: List[str],
    ) -> "Response[List[str]]":
        ...

    def add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[str],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[str]]":
        ...

    @overload
    async def async_add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        contexts: List[str],
    ) -> "Response[List[str]]":
        ...

    async def async_add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[str],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[str]]":
        ...

    @overload
    def remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        contexts: List[str],
    ) -> "Response[List[str]]":
        ...

    def remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=List[str],
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[str]]":
        ...

    @overload
    async def async_remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        contexts: List[str],
    ) -> "Response[List[str]]":
        ...

    async def async_remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[str]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=List[str],
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[BranchRestrictionPolicy]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        return self._github.request(
            "GET",
            url,
            response_model=BranchRestrictionPolicy,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[BranchRestrictionPolicy]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        return await self._github.arequest(
            "GET",
            url,
            response_model=BranchRestrictionPolicy,
            error_models={
                "404": BasicError,
            },
        )

    def delete_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def get_apps_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        return self._github.request(
            "GET",
            url,
            response_model=List[Integration],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_apps_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[Integration],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Integration]]":
        ...

    @overload
    def set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        apps: List[str],
    ) -> "Response[List[Integration]]":
        ...

    def set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=List[Integration],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Integration]]":
        ...

    @overload
    async def async_set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        apps: List[str],
    ) -> "Response[List[Integration]]":
        ...

    async def async_set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=List[Integration],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Integration]]":
        ...

    @overload
    def add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        apps: List[str],
    ) -> "Response[List[Integration]]":
        ...

    def add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[Integration],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Integration]]":
        ...

    @overload
    async def async_add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        apps: List[str],
    ) -> "Response[List[Integration]]":
        ...

    async def async_add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[Integration],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Integration]]":
        ...

    @overload
    def remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        apps: List[str],
    ) -> "Response[List[Integration]]":
        ...

    def remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=List[Integration],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Integration]]":
        ...

    @overload
    async def async_remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        apps: List[str],
    ) -> "Response[List[Integration]]":
        ...

    async def async_remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Integration]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=List[Integration],
            error_models={
                "422": ValidationError,
            },
        )

    def get_teams_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        return self._github.request(
            "GET",
            url,
            response_model=List[Team],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_teams_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[Team],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Team]]":
        ...

    @overload
    def set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        teams: List[str],
    ) -> "Response[List[Team]]":
        ...

    def set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Team]]":
        ...

    @overload
    async def async_set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        teams: List[str],
    ) -> "Response[List[Team]]":
        ...

    async def async_set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Team]]":
        ...

    @overload
    def add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        teams: List[str],
    ) -> "Response[List[Team]]":
        ...

    def add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Team]]":
        ...

    @overload
    async def async_add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        teams: List[str],
    ) -> "Response[List[Team]]":
        ...

    async def async_add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Team]]":
        ...

    @overload
    def remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        teams: List[str],
    ) -> "Response[List[Team]]":
        ...

    def remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[Team]]":
        ...

    @overload
    async def async_remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        teams: List[str],
    ) -> "Response[List[Team]]":
        ...

    async def async_remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    def get_users_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        return self._github.request(
            "GET",
            url,
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_users_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[SimpleUser]]":
        ...

    @overload
    def set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        users: List[str],
    ) -> "Response[List[SimpleUser]]":
        ...

    def set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[SimpleUser]]":
        ...

    @overload
    async def async_set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        users: List[str],
    ) -> "Response[List[SimpleUser]]":
        ...

    async def async_set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[SimpleUser]]":
        ...

    @overload
    def add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        users: List[str],
    ) -> "Response[List[SimpleUser]]":
        ...

    def add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[SimpleUser]]":
        ...

    @overload
    async def async_add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        users: List[str],
    ) -> "Response[List[SimpleUser]]":
        ...

    async def async_add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[SimpleUser]]":
        ...

    @overload
    def remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        users: List[str],
    ) -> "Response[List[SimpleUser]]":
        ...

    def remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
    ) -> "Response[List[SimpleUser]]":
        ...

    @overload
    async def async_remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        users: List[str],
    ) -> "Response[List[SimpleUser]]":
        ...

    async def async_remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0Type,
                List[str],
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[SimpleUser]]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: ReposOwnerRepoBranchesBranchRenamePostBodyType,
    ) -> "Response[BranchWithProtection]":
        ...

    @overload
    def rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        new_name: str,
    ) -> "Response[BranchWithProtection]":
        ...

    def rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[Unset, ReposOwnerRepoBranchesBranchRenamePostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[BranchWithProtection]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/rename"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoBranchesBranchRenamePostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=BranchWithProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: ReposOwnerRepoBranchesBranchRenamePostBodyType,
    ) -> "Response[BranchWithProtection]":
        ...

    @overload
    async def async_rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Unset = UNSET,
        new_name: str,
    ) -> "Response[BranchWithProtection]":
        ...

    async def async_rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Union[Unset, ReposOwnerRepoBranchesBranchRenamePostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[BranchWithProtection]":
        url = f"/repos/{owner}/{repo}/branches/{branch}/rename"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoBranchesBranchRenamePostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=BranchWithProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def codeowners_errors(
        self,
        owner: str,
        repo: str,
        ref: Union[Unset, str] = UNSET,
    ) -> "Response[CodeownersErrors]":
        url = f"/repos/{owner}/{repo}/codeowners/errors"

        params = {
            "ref": ref,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=CodeownersErrors,
            error_models={},
        )

    async def async_codeowners_errors(
        self,
        owner: str,
        repo: str,
        ref: Union[Unset, str] = UNSET,
    ) -> "Response[CodeownersErrors]":
        url = f"/repos/{owner}/{repo}/codeowners/errors"

        params = {
            "ref": ref,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=CodeownersErrors,
            error_models={},
        )

    def list_collaborators(
        self,
        owner: str,
        repo: str,
        affiliation: Union[Unset, Literal["outside", "direct", "all"]] = "all",
        permission: Union[
            Unset, Literal["pull", "triage", "push", "maintain", "admin"]
        ] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Collaborator]]":
        url = f"/repos/{owner}/{repo}/collaborators"

        params = {
            "affiliation": affiliation,
            "permission": permission,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Collaborator],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_collaborators(
        self,
        owner: str,
        repo: str,
        affiliation: Union[Unset, Literal["outside", "direct", "all"]] = "all",
        permission: Union[
            Unset, Literal["pull", "triage", "push", "maintain", "admin"]
        ] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Collaborator]]":
        url = f"/repos/{owner}/{repo}/collaborators"

        params = {
            "affiliation": affiliation,
            "permission": permission,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Collaborator],
            error_models={
                "404": BasicError,
            },
        )

    def check_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        return self._github.request(
            "GET",
            url,
            error_models={},
        )

    async def async_check_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        return await self._github.arequest(
            "GET",
            url,
            error_models={},
        )

    @overload
    def add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        data: Union[Unset, ReposOwnerRepoCollaboratorsUsernamePutBodyType] = UNSET,
    ) -> "Response[RepositoryInvitation]":
        ...

    @overload
    def add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        data: Unset = UNSET,
        permission: Union[Unset, str] = "push",
    ) -> "Response[RepositoryInvitation]":
        ...

    def add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        data: Union[Unset, ReposOwnerRepoCollaboratorsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[RepositoryInvitation]":
        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoCollaboratorsUsernamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=RepositoryInvitation,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        data: Union[Unset, ReposOwnerRepoCollaboratorsUsernamePutBodyType] = UNSET,
    ) -> "Response[RepositoryInvitation]":
        ...

    @overload
    async def async_add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        data: Unset = UNSET,
        permission: Union[Unset, str] = "push",
    ) -> "Response[RepositoryInvitation]":
        ...

    async def async_add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        data: Union[Unset, ReposOwnerRepoCollaboratorsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[RepositoryInvitation]":
        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoCollaboratorsUsernamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=RepositoryInvitation,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def remove_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_remove_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def get_collaborator_permission_level(
        self,
        owner: str,
        repo: str,
        username: str,
    ) -> "Response[RepositoryCollaboratorPermission]":
        url = f"/repos/{owner}/{repo}/collaborators/{username}/permission"

        return self._github.request(
            "GET",
            url,
            response_model=RepositoryCollaboratorPermission,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_collaborator_permission_level(
        self,
        owner: str,
        repo: str,
        username: str,
    ) -> "Response[RepositoryCollaboratorPermission]":
        url = f"/repos/{owner}/{repo}/collaborators/{username}/permission"

        return await self._github.arequest(
            "GET",
            url,
            response_model=RepositoryCollaboratorPermission,
            error_models={
                "404": BasicError,
            },
        )

    def list_commit_comments_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[CommitComment]]":
        url = f"/repos/{owner}/{repo}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[CommitComment],
        )

    async def async_list_commit_comments_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[CommitComment]]":
        url = f"/repos/{owner}/{repo}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[CommitComment],
        )

    def get_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
    ) -> "Response[CommitComment]":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        return self._github.request(
            "GET",
            url,
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
    ) -> "Response[CommitComment]":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    def delete_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: ReposOwnerRepoCommentsCommentIdPatchBodyType,
    ) -> "Response[CommitComment]":
        ...

    @overload
    def update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Unset = UNSET,
        body: str,
    ) -> "Response[CommitComment]":
        ...

    def update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[CommitComment]":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoCommentsCommentIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: ReposOwnerRepoCommentsCommentIdPatchBodyType,
    ) -> "Response[CommitComment]":
        ...

    @overload
    async def async_update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Unset = UNSET,
        body: str,
    ) -> "Response[CommitComment]":
        ...

    async def async_update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[CommitComment]":
        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoCommentsCommentIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    def list_commits(
        self,
        owner: str,
        repo: str,
        sha: Union[Unset, str] = UNSET,
        path: Union[Unset, str] = UNSET,
        author: Union[Unset, str] = UNSET,
        since: Union[Unset, datetime] = UNSET,
        until: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Commit]]":
        url = f"/repos/{owner}/{repo}/commits"

        params = {
            "sha": sha,
            "path": path,
            "author": author,
            "since": since,
            "until": until,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Commit],
            error_models={
                "500": BasicError,
                "400": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_list_commits(
        self,
        owner: str,
        repo: str,
        sha: Union[Unset, str] = UNSET,
        path: Union[Unset, str] = UNSET,
        author: Union[Unset, str] = UNSET,
        since: Union[Unset, datetime] = UNSET,
        until: Union[Unset, datetime] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Commit]]":
        url = f"/repos/{owner}/{repo}/commits"

        params = {
            "sha": sha,
            "path": path,
            "author": author,
            "since": since,
            "until": until,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Commit],
            error_models={
                "500": BasicError,
                "400": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    def list_branches_for_head_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
    ) -> "Response[List[BranchShort]]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head"

        return self._github.request(
            "GET",
            url,
            response_model=List[BranchShort],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_branches_for_head_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
    ) -> "Response[List[BranchShort]]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[BranchShort],
            error_models={
                "422": ValidationError,
            },
        )

    def list_comments_for_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[CommitComment]]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[CommitComment],
        )

    async def async_list_comments_for_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[CommitComment]]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[CommitComment],
        )

    @overload
    def create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        data: ReposOwnerRepoCommitsCommitShaCommentsPostBodyType,
    ) -> "Response[CommitComment]":
        ...

    @overload
    def create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        data: Unset = UNSET,
        body: str,
        path: Union[Unset, str] = UNSET,
        position: Union[Unset, int] = UNSET,
        line: Union[Unset, int] = UNSET,
    ) -> "Response[CommitComment]":
        ...

    def create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        data: Union[Unset, ReposOwnerRepoCommitsCommitShaCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[CommitComment]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoCommitsCommitShaCommentsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=CommitComment,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        data: ReposOwnerRepoCommitsCommitShaCommentsPostBodyType,
    ) -> "Response[CommitComment]":
        ...

    @overload
    async def async_create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        data: Unset = UNSET,
        body: str,
        path: Union[Unset, str] = UNSET,
        position: Union[Unset, int] = UNSET,
        line: Union[Unset, int] = UNSET,
    ) -> "Response[CommitComment]":
        ...

    async def async_create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        data: Union[Unset, ReposOwnerRepoCommitsCommitShaCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[CommitComment]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoCommitsCommitShaCommentsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=CommitComment,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_pull_requests_associated_with_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[PullRequestSimple]]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/pulls"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[PullRequestSimple],
        )

    async def async_list_pull_requests_associated_with_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[PullRequestSimple]]":
        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/pulls"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[PullRequestSimple],
        )

    def get_commit(
        self,
        owner: str,
        repo: str,
        ref: str,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[Commit]":
        url = f"/repos/{owner}/{repo}/commits/{ref}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Commit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_commit(
        self,
        owner: str,
        repo: str,
        ref: str,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[Commit]":
        url = f"/repos/{owner}/{repo}/commits/{ref}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Commit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_combined_status_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[CombinedCommitStatus]":
        url = f"/repos/{owner}/{repo}/commits/{ref}/status"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=CombinedCommitStatus,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_combined_status_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[CombinedCommitStatus]":
        url = f"/repos/{owner}/{repo}/commits/{ref}/status"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=CombinedCommitStatus,
            error_models={
                "404": BasicError,
            },
        )

    def list_commit_statuses_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Status]]":
        url = f"/repos/{owner}/{repo}/commits/{ref}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Status],
        )

    async def async_list_commit_statuses_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Status]]":
        url = f"/repos/{owner}/{repo}/commits/{ref}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Status],
        )

    def get_community_profile_metrics(
        self,
        owner: str,
        repo: str,
    ) -> "Response[CommunityProfile]":
        url = f"/repos/{owner}/{repo}/community/profile"

        return self._github.request(
            "GET",
            url,
            response_model=CommunityProfile,
        )

    async def async_get_community_profile_metrics(
        self,
        owner: str,
        repo: str,
    ) -> "Response[CommunityProfile]":
        url = f"/repos/{owner}/{repo}/community/profile"

        return await self._github.arequest(
            "GET",
            url,
            response_model=CommunityProfile,
        )

    def compare_commits(
        self,
        owner: str,
        repo: str,
        basehead: str,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[CommitComparison]":
        url = f"/repos/{owner}/{repo}/compare/{basehead}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=CommitComparison,
            error_models={
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_compare_commits(
        self,
        owner: str,
        repo: str,
        basehead: str,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[CommitComparison]":
        url = f"/repos/{owner}/{repo}/compare/{basehead}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=CommitComparison,
            error_models={
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_content(
        self,
        owner: str,
        repo: str,
        path: str,
        ref: Union[Unset, str] = UNSET,
    ) -> "Response[ContentTree]":
        url = f"/repos/{owner}/{repo}/contents/{path}"

        params = {
            "ref": ref,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ContentTree,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_get_content(
        self,
        owner: str,
        repo: str,
        path: str,
        ref: Union[Unset, str] = UNSET,
    ) -> "Response[ContentTree]":
        url = f"/repos/{owner}/{repo}/contents/{path}"

        params = {
            "ref": ref,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ContentTree,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: ReposOwnerRepoContentsPathPutBodyType,
    ) -> "Response[FileCommit]":
        ...

    @overload
    def create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: Unset = UNSET,
        message: str,
        content: str,
        sha: Union[Unset, str] = UNSET,
        branch: Union[Unset, str] = UNSET,
        committer: Union[
            Unset, ReposOwnerRepoContentsPathPutBodyPropCommitterType
        ] = UNSET,
        author: Union[Unset, ReposOwnerRepoContentsPathPutBodyPropAuthorType] = UNSET,
    ) -> "Response[FileCommit]":
        ...

    def create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: Union[Unset, ReposOwnerRepoContentsPathPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[FileCommit]":
        url = f"/repos/{owner}/{repo}/contents/{path}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoContentsPathPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=FileCommit,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "409": BasicError,
            },
        )

    @overload
    async def async_create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: ReposOwnerRepoContentsPathPutBodyType,
    ) -> "Response[FileCommit]":
        ...

    @overload
    async def async_create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: Unset = UNSET,
        message: str,
        content: str,
        sha: Union[Unset, str] = UNSET,
        branch: Union[Unset, str] = UNSET,
        committer: Union[
            Unset, ReposOwnerRepoContentsPathPutBodyPropCommitterType
        ] = UNSET,
        author: Union[Unset, ReposOwnerRepoContentsPathPutBodyPropAuthorType] = UNSET,
    ) -> "Response[FileCommit]":
        ...

    async def async_create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: Union[Unset, ReposOwnerRepoContentsPathPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[FileCommit]":
        url = f"/repos/{owner}/{repo}/contents/{path}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoContentsPathPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=FileCommit,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "409": BasicError,
            },
        )

    @overload
    def delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: ReposOwnerRepoContentsPathDeleteBodyType,
    ) -> "Response[FileCommit]":
        ...

    @overload
    def delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: Unset = UNSET,
        message: str,
        sha: str,
        branch: Union[Unset, str] = UNSET,
        committer: Union[
            Unset, ReposOwnerRepoContentsPathDeleteBodyPropCommitterType
        ] = UNSET,
        author: Union[
            Unset, ReposOwnerRepoContentsPathDeleteBodyPropAuthorType
        ] = UNSET,
    ) -> "Response[FileCommit]":
        ...

    def delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: Union[Unset, ReposOwnerRepoContentsPathDeleteBodyType] = UNSET,
        **kwargs,
    ) -> "Response[FileCommit]":
        url = f"/repos/{owner}/{repo}/contents/{path}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoContentsPathDeleteBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=FileCommit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: ReposOwnerRepoContentsPathDeleteBodyType,
    ) -> "Response[FileCommit]":
        ...

    @overload
    async def async_delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: Unset = UNSET,
        message: str,
        sha: str,
        branch: Union[Unset, str] = UNSET,
        committer: Union[
            Unset, ReposOwnerRepoContentsPathDeleteBodyPropCommitterType
        ] = UNSET,
        author: Union[
            Unset, ReposOwnerRepoContentsPathDeleteBodyPropAuthorType
        ] = UNSET,
    ) -> "Response[FileCommit]":
        ...

    async def async_delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: Union[Unset, ReposOwnerRepoContentsPathDeleteBodyType] = UNSET,
        **kwargs,
    ) -> "Response[FileCommit]":
        url = f"/repos/{owner}/{repo}/contents/{path}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoContentsPathDeleteBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            response_model=FileCommit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def list_contributors(
        self,
        owner: str,
        repo: str,
        anon: Union[Unset, str] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Contributor]]":
        url = f"/repos/{owner}/{repo}/contributors"

        params = {
            "anon": anon,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Contributor],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_contributors(
        self,
        owner: str,
        repo: str,
        anon: Union[Unset, str] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Contributor]]":
        url = f"/repos/{owner}/{repo}/contributors"

        params = {
            "anon": anon,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Contributor],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_deployments(
        self,
        owner: str,
        repo: str,
        sha: Union[Unset, str] = "none",
        ref: Union[Unset, str] = "none",
        task: Union[Unset, str] = "none",
        environment: Union[Unset, Union[str, None]] = "none",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Deployment]]":
        url = f"/repos/{owner}/{repo}/deployments"

        params = {
            "sha": sha,
            "ref": ref,
            "task": task,
            "environment": environment,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Deployment],
        )

    async def async_list_deployments(
        self,
        owner: str,
        repo: str,
        sha: Union[Unset, str] = "none",
        ref: Union[Unset, str] = "none",
        task: Union[Unset, str] = "none",
        environment: Union[Unset, Union[str, None]] = "none",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Deployment]]":
        url = f"/repos/{owner}/{repo}/deployments"

        params = {
            "sha": sha,
            "ref": ref,
            "task": task,
            "environment": environment,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Deployment],
        )

    @overload
    def create_deployment(
        self, owner: str, repo: str, *, data: ReposOwnerRepoDeploymentsPostBodyType
    ) -> "Response[Deployment]":
        ...

    @overload
    def create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        ref: str,
        task: Union[Unset, str] = "deploy",
        auto_merge: Union[Unset, bool] = True,
        required_contexts: Union[Unset, List[str]] = UNSET,
        payload: Union[
            Unset, Union[ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type, str]
        ] = UNSET,
        environment: Union[Unset, str] = "production",
        description: Union[Unset, Union[str, None]] = "",
        transient_environment: Union[Unset, bool] = False,
        production_environment: Union[Unset, bool] = UNSET,
    ) -> "Response[Deployment]":
        ...

    def create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoDeploymentsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Deployment]":
        url = f"/repos/{owner}/{repo}/deployments"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoDeploymentsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Deployment,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_deployment(
        self, owner: str, repo: str, *, data: ReposOwnerRepoDeploymentsPostBodyType
    ) -> "Response[Deployment]":
        ...

    @overload
    async def async_create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        ref: str,
        task: Union[Unset, str] = "deploy",
        auto_merge: Union[Unset, bool] = True,
        required_contexts: Union[Unset, List[str]] = UNSET,
        payload: Union[
            Unset, Union[ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type, str]
        ] = UNSET,
        environment: Union[Unset, str] = "production",
        description: Union[Unset, Union[str, None]] = "",
        transient_environment: Union[Unset, bool] = False,
        production_environment: Union[Unset, bool] = UNSET,
    ) -> "Response[Deployment]":
        ...

    async def async_create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoDeploymentsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Deployment]":
        url = f"/repos/{owner}/{repo}/deployments"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoDeploymentsPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Deployment,
            error_models={
                "422": ValidationError,
            },
        )

    def get_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
    ) -> "Response[Deployment]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Deployment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
    ) -> "Response[Deployment]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Deployment,
            error_models={
                "404": BasicError,
            },
        )

    def delete_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_delete_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_deployment_statuses(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[DeploymentStatus]]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[DeploymentStatus],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_deployment_statuses(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[DeploymentStatus]]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[DeploymentStatus],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        data: ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType,
    ) -> "Response[DeploymentStatus]":
        ...

    @overload
    def create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        data: Unset = UNSET,
        state: Literal[
            "error",
            "failure",
            "inactive",
            "in_progress",
            "queued",
            "pending",
            "success",
        ],
        target_url: Union[Unset, str] = "",
        log_url: Union[Unset, str] = "",
        description: Union[Unset, str] = "",
        environment: Union[Unset, Literal["production", "staging", "qa"]] = UNSET,
        environment_url: Union[Unset, str] = "",
        auto_inactive: Union[Unset, bool] = UNSET,
    ) -> "Response[DeploymentStatus]":
        ...

    def create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        data: Union[
            Unset, ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[DeploymentStatus]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=DeploymentStatus,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        data: ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType,
    ) -> "Response[DeploymentStatus]":
        ...

    @overload
    async def async_create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        data: Unset = UNSET,
        state: Literal[
            "error",
            "failure",
            "inactive",
            "in_progress",
            "queued",
            "pending",
            "success",
        ],
        target_url: Union[Unset, str] = "",
        log_url: Union[Unset, str] = "",
        description: Union[Unset, str] = "",
        environment: Union[Unset, Literal["production", "staging", "qa"]] = UNSET,
        environment_url: Union[Unset, str] = "",
        auto_inactive: Union[Unset, bool] = UNSET,
    ) -> "Response[DeploymentStatus]":
        ...

    async def async_create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        data: Union[
            Unset, ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[DeploymentStatus]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=DeploymentStatus,
            error_models={
                "422": ValidationError,
            },
        )

    def get_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        status_id: int,
    ) -> "Response[DeploymentStatus]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}"

        return self._github.request(
            "GET",
            url,
            response_model=DeploymentStatus,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        status_id: int,
    ) -> "Response[DeploymentStatus]":
        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=DeploymentStatus,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_dispatch_event(
        self, owner: str, repo: str, *, data: ReposOwnerRepoDispatchesPostBodyType
    ) -> "Response":
        ...

    @overload
    def create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        event_type: str,
        client_payload: Union[
            Unset, ReposOwnerRepoDispatchesPostBodyPropClientPayloadType
        ] = UNSET,
    ) -> "Response":
        ...

    def create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoDispatchesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/dispatches"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoDispatchesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_dispatch_event(
        self, owner: str, repo: str, *, data: ReposOwnerRepoDispatchesPostBodyType
    ) -> "Response":
        ...

    @overload
    async def async_create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        event_type: str,
        client_payload: Union[
            Unset, ReposOwnerRepoDispatchesPostBodyPropClientPayloadType
        ] = UNSET,
    ) -> "Response":
        ...

    async def async_create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoDispatchesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/dispatches"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoDispatchesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            error_models={
                "422": ValidationError,
            },
        )

    def get_all_environments(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoEnvironmentsGetResponse200]":
        url = f"/repos/{owner}/{repo}/environments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoEnvironmentsGetResponse200,
        )

    async def async_get_all_environments(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoEnvironmentsGetResponse200]":
        url = f"/repos/{owner}/{repo}/environments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoEnvironmentsGetResponse200,
        )

    def get_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
    ) -> "Response[Environment]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        return self._github.request(
            "GET",
            url,
            response_model=Environment,
        )

    async def async_get_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
    ) -> "Response[Environment]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Environment,
        )

    @overload
    def create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: Union[
            Unset, Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
    ) -> "Response[Environment]":
        ...

    @overload
    def create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: Unset = UNSET,
        wait_timer: Union[Unset, int] = UNSET,
        reviewers: Union[
            Unset,
            Union[
                List[
                    ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItemsType
                ],
                None,
            ],
        ] = UNSET,
        deployment_branch_policy: Union[
            Unset, Union[DeploymentBranchPolicySettingsType, None]
        ] = UNSET,
    ) -> "Response[Environment]":
        ...

    def create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: Union[
            Unset, Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[Environment]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBody, None], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=Environment,
            error_models={
                "422": BasicError,
            },
        )

    @overload
    async def async_create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: Union[
            Unset, Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
    ) -> "Response[Environment]":
        ...

    @overload
    async def async_create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: Unset = UNSET,
        wait_timer: Union[Unset, int] = UNSET,
        reviewers: Union[
            Unset,
            Union[
                List[
                    ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItemsType
                ],
                None,
            ],
        ] = UNSET,
        deployment_branch_policy: Union[
            Unset, Union[DeploymentBranchPolicySettingsType, None]
        ] = UNSET,
    ) -> "Response[Environment]":
        ...

    async def async_create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: Union[
            Unset, Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[Environment]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBody, None], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=Environment,
            error_models={
                "422": BasicError,
            },
        )

    def delete_an_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_an_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_deployment_branch_policies(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        )

    async def async_list_deployment_branch_policies(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        )

    @overload
    def create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: DeploymentBranchPolicyNamePatternType,
    ) -> "Response[DeploymentBranchPolicy]":
        ...

    @overload
    def create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: Unset = UNSET,
        name: str,
    ) -> "Response[DeploymentBranchPolicy]":
        ...

    def create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: Union[Unset, DeploymentBranchPolicyNamePatternType] = UNSET,
        **kwargs,
    ) -> "Response[DeploymentBranchPolicy]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(DeploymentBranchPolicyNamePattern, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=DeploymentBranchPolicy,
            error_models={},
        )

    @overload
    async def async_create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: DeploymentBranchPolicyNamePatternType,
    ) -> "Response[DeploymentBranchPolicy]":
        ...

    @overload
    async def async_create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: Unset = UNSET,
        name: str,
    ) -> "Response[DeploymentBranchPolicy]":
        ...

    async def async_create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: Union[Unset, DeploymentBranchPolicyNamePatternType] = UNSET,
        **kwargs,
    ) -> "Response[DeploymentBranchPolicy]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(DeploymentBranchPolicyNamePattern, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=DeploymentBranchPolicy,
            error_models={},
        )

    def get_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
    ) -> "Response[DeploymentBranchPolicy]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        return self._github.request(
            "GET",
            url,
            response_model=DeploymentBranchPolicy,
        )

    async def async_get_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
    ) -> "Response[DeploymentBranchPolicy]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=DeploymentBranchPolicy,
        )

    @overload
    def update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        data: DeploymentBranchPolicyNamePatternType,
    ) -> "Response[DeploymentBranchPolicy]":
        ...

    @overload
    def update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        data: Unset = UNSET,
        name: str,
    ) -> "Response[DeploymentBranchPolicy]":
        ...

    def update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        data: Union[Unset, DeploymentBranchPolicyNamePatternType] = UNSET,
        **kwargs,
    ) -> "Response[DeploymentBranchPolicy]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(DeploymentBranchPolicyNamePattern, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=DeploymentBranchPolicy,
        )

    @overload
    async def async_update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        data: DeploymentBranchPolicyNamePatternType,
    ) -> "Response[DeploymentBranchPolicy]":
        ...

    @overload
    async def async_update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        data: Unset = UNSET,
        name: str,
    ) -> "Response[DeploymentBranchPolicy]":
        ...

    async def async_update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        data: Union[Unset, DeploymentBranchPolicyNamePatternType] = UNSET,
        **kwargs,
    ) -> "Response[DeploymentBranchPolicy]":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(DeploymentBranchPolicyNamePattern, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=DeploymentBranchPolicy,
        )

    def delete_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_forks(
        self,
        owner: str,
        repo: str,
        sort: Union[
            Unset, Literal["newest", "oldest", "stargazers", "watchers"]
        ] = "newest",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/repos/{owner}/{repo}/forks"

        params = {
            "sort": sort,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
            error_models={
                "400": BasicError,
            },
        )

    async def async_list_forks(
        self,
        owner: str,
        repo: str,
        sort: Union[
            Unset, Literal["newest", "oldest", "stargazers", "watchers"]
        ] = "newest",
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/repos/{owner}/{repo}/forks"

        params = {
            "sort": sort,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
            error_models={
                "400": BasicError,
            },
        )

    @overload
    def create_fork(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
    ) -> "Response[FullRepository]":
        ...

    @overload
    def create_fork(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        organization: Union[Unset, str] = UNSET,
        name: Union[Unset, str] = UNSET,
        default_branch_only: Union[Unset, bool] = UNSET,
    ) -> "Response[FullRepository]":
        ...

    def create_fork(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> "Response[FullRepository]":
        url = f"/repos/{owner}/{repo}/forks"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Union[ReposOwnerRepoForksPostBody, None], json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=FullRepository,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_fork(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
    ) -> "Response[FullRepository]":
        ...

    @overload
    async def async_create_fork(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        organization: Union[Unset, str] = UNSET,
        name: Union[Unset, str] = UNSET,
        default_branch_only: Union[Unset, bool] = UNSET,
    ) -> "Response[FullRepository]":
        ...

    async def async_create_fork(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> "Response[FullRepository]":
        url = f"/repos/{owner}/{repo}/forks"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Union[ReposOwnerRepoForksPostBody, None], json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=FullRepository,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_webhooks(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Hook]]":
        url = f"/repos/{owner}/{repo}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Hook],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_webhooks(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Hook]]":
        url = f"/repos/{owner}/{repo}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Hook],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
    ) -> "Response[Hook]":
        ...

    @overload
    def create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        name: Union[Unset, str] = UNSET,
        config: Union[Unset, ReposOwnerRepoHooksPostBodyPropConfigType] = UNSET,
        events: Union[Unset, List[str]] = ["push"],
        active: Union[Unset, bool] = True,
    ) -> "Response[Hook]":
        ...

    def create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> "Response[Hook]":
        url = f"/repos/{owner}/{repo}/hooks"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Union[ReposOwnerRepoHooksPostBody, None], json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Hook,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
    ) -> "Response[Hook]":
        ...

    @overload
    async def async_create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        name: Union[Unset, str] = UNSET,
        config: Union[Unset, ReposOwnerRepoHooksPostBodyPropConfigType] = UNSET,
        events: Union[Unset, List[str]] = ["push"],
        active: Union[Unset, bool] = True,
    ) -> "Response[Hook]":
        ...

    async def async_create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> "Response[Hook]":
        url = f"/repos/{owner}/{repo}/hooks"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Union[ReposOwnerRepoHooksPostBody, None], json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Hook,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def get_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
    ) -> "Response[Hook]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Hook,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
    ) -> "Response[Hook]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Hook,
            error_models={
                "404": BasicError,
            },
        )

    def delete_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: ReposOwnerRepoHooksHookIdPatchBodyType,
    ) -> "Response[Hook]":
        ...

    @overload
    def update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: Unset = UNSET,
        config: Union[Unset, ReposOwnerRepoHooksHookIdPatchBodyPropConfigType] = UNSET,
        events: Union[Unset, List[str]] = ["push"],
        add_events: Union[Unset, List[str]] = UNSET,
        remove_events: Union[Unset, List[str]] = UNSET,
        active: Union[Unset, bool] = True,
    ) -> "Response[Hook]":
        ...

    def update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoHooksHookIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Hook]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoHooksHookIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Hook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: ReposOwnerRepoHooksHookIdPatchBodyType,
    ) -> "Response[Hook]":
        ...

    @overload
    async def async_update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: Unset = UNSET,
        config: Union[Unset, ReposOwnerRepoHooksHookIdPatchBodyPropConfigType] = UNSET,
        events: Union[Unset, List[str]] = ["push"],
        add_events: Union[Unset, List[str]] = UNSET,
        remove_events: Union[Unset, List[str]] = UNSET,
        active: Union[Unset, bool] = True,
    ) -> "Response[Hook]":
        ...

    async def async_update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoHooksHookIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Hook]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoHooksHookIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Hook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
    ) -> "Response[WebhookConfig]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        return self._github.request(
            "GET",
            url,
            response_model=WebhookConfig,
        )

    async def async_get_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
    ) -> "Response[WebhookConfig]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        return await self._github.arequest(
            "GET",
            url,
            response_model=WebhookConfig,
        )

    @overload
    def update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoHooksHookIdConfigPatchBodyType] = UNSET,
    ) -> "Response[WebhookConfig]":
        ...

    @overload
    def update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: Unset = UNSET,
        url: Union[Unset, str] = UNSET,
        content_type: Union[Unset, str] = UNSET,
        secret: Union[Unset, str] = UNSET,
        insecure_ssl: Union[Unset, Union[str, float]] = UNSET,
    ) -> "Response[WebhookConfig]":
        ...

    def update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoHooksHookIdConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[WebhookConfig]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoHooksHookIdConfigPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=WebhookConfig,
        )

    @overload
    async def async_update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoHooksHookIdConfigPatchBodyType] = UNSET,
    ) -> "Response[WebhookConfig]":
        ...

    @overload
    async def async_update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: Unset = UNSET,
        url: Union[Unset, str] = UNSET,
        content_type: Union[Unset, str] = UNSET,
        secret: Union[Unset, str] = UNSET,
        insecure_ssl: Union[Unset, Union[str, float]] = UNSET,
    ) -> "Response[WebhookConfig]":
        ...

    async def async_update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoHooksHookIdConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[WebhookConfig]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoHooksHookIdConfigPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=WebhookConfig,
        )

    def list_webhook_deliveries(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        per_page: Union[Unset, int] = 30,
        cursor: Union[Unset, str] = UNSET,
    ) -> "Response[List[HookDeliveryItem]]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_webhook_deliveries(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        per_page: Union[Unset, int] = 30,
        cursor: Union[Unset, str] = UNSET,
    ) -> "Response[List[HookDeliveryItem]]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def get_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
    ) -> "Response[HookDelivery]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}"

        return self._github.request(
            "GET",
            url,
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
    ) -> "Response[HookDelivery]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def redeliver_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        return self._github.request(
            "POST",
            url,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_redeliver_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        return await self._github.arequest(
            "POST",
            url,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def ping_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/pings"

        return self._github.request(
            "POST",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_ping_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/pings"

        return await self._github.arequest(
            "POST",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def test_push_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/tests"

        return self._github.request(
            "POST",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_test_push_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/tests"

        return await self._github.arequest(
            "POST",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def list_invitations(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[RepositoryInvitation]]":
        url = f"/repos/{owner}/{repo}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[RepositoryInvitation],
        )

    async def async_list_invitations(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[RepositoryInvitation]]":
        url = f"/repos/{owner}/{repo}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[RepositoryInvitation],
        )

    def delete_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    @overload
    def update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoInvitationsInvitationIdPatchBodyType] = UNSET,
    ) -> "Response[RepositoryInvitation]":
        ...

    @overload
    def update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        data: Unset = UNSET,
        permissions: Union[
            Unset, Literal["read", "write", "maintain", "triage", "admin"]
        ] = UNSET,
    ) -> "Response[RepositoryInvitation]":
        ...

    def update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoInvitationsInvitationIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[RepositoryInvitation]":
        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoInvitationsInvitationIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=RepositoryInvitation,
        )

    @overload
    async def async_update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoInvitationsInvitationIdPatchBodyType] = UNSET,
    ) -> "Response[RepositoryInvitation]":
        ...

    @overload
    async def async_update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        data: Unset = UNSET,
        permissions: Union[
            Unset, Literal["read", "write", "maintain", "triage", "admin"]
        ] = UNSET,
    ) -> "Response[RepositoryInvitation]":
        ...

    async def async_update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoInvitationsInvitationIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[RepositoryInvitation]":
        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoInvitationsInvitationIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=RepositoryInvitation,
        )

    def list_deploy_keys(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[DeployKey]]":
        url = f"/repos/{owner}/{repo}/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[DeployKey],
        )

    async def async_list_deploy_keys(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[DeployKey]]":
        url = f"/repos/{owner}/{repo}/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[DeployKey],
        )

    @overload
    def create_deploy_key(
        self, owner: str, repo: str, *, data: ReposOwnerRepoKeysPostBodyType
    ) -> "Response[DeployKey]":
        ...

    @overload
    def create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        title: Union[Unset, str] = UNSET,
        key: str,
        read_only: Union[Unset, bool] = UNSET,
    ) -> "Response[DeployKey]":
        ...

    def create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[DeployKey]":
        url = f"/repos/{owner}/{repo}/keys"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoKeysPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=DeployKey,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_deploy_key(
        self, owner: str, repo: str, *, data: ReposOwnerRepoKeysPostBodyType
    ) -> "Response[DeployKey]":
        ...

    @overload
    async def async_create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        title: Union[Unset, str] = UNSET,
        key: str,
        read_only: Union[Unset, bool] = UNSET,
    ) -> "Response[DeployKey]":
        ...

    async def async_create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[DeployKey]":
        url = f"/repos/{owner}/{repo}/keys"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoKeysPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=DeployKey,
            error_models={
                "422": ValidationError,
            },
        )

    def get_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
    ) -> "Response[DeployKey]":
        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        return self._github.request(
            "GET",
            url,
            response_model=DeployKey,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
    ) -> "Response[DeployKey]":
        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=DeployKey,
            error_models={
                "404": BasicError,
            },
        )

    def delete_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_languages(
        self,
        owner: str,
        repo: str,
    ) -> "Response[Language]":
        url = f"/repos/{owner}/{repo}/languages"

        return self._github.request(
            "GET",
            url,
            response_model=Language,
        )

    async def async_list_languages(
        self,
        owner: str,
        repo: str,
    ) -> "Response[Language]":
        url = f"/repos/{owner}/{repo}/languages"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Language,
        )

    def enable_lfs_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/repos/{owner}/{repo}/lfs"

        return self._github.request(
            "PUT",
            url,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={},
        )

    async def async_enable_lfs_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/repos/{owner}/{repo}/lfs"

        return await self._github.arequest(
            "PUT",
            url,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={},
        )

    def disable_lfs_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/lfs"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_disable_lfs_for_repo(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/lfs"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    @overload
    def merge_upstream(
        self, owner: str, repo: str, *, data: ReposOwnerRepoMergeUpstreamPostBodyType
    ) -> "Response[MergedUpstream]":
        ...

    @overload
    def merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        branch: str,
    ) -> "Response[MergedUpstream]":
        ...

    def merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoMergeUpstreamPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[MergedUpstream]":
        url = f"/repos/{owner}/{repo}/merge-upstream"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoMergeUpstreamPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=MergedUpstream,
            error_models={},
        )

    @overload
    async def async_merge_upstream(
        self, owner: str, repo: str, *, data: ReposOwnerRepoMergeUpstreamPostBodyType
    ) -> "Response[MergedUpstream]":
        ...

    @overload
    async def async_merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        branch: str,
    ) -> "Response[MergedUpstream]":
        ...

    async def async_merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoMergeUpstreamPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[MergedUpstream]":
        url = f"/repos/{owner}/{repo}/merge-upstream"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoMergeUpstreamPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=MergedUpstream,
            error_models={},
        )

    @overload
    def merge(
        self, owner: str, repo: str, *, data: ReposOwnerRepoMergesPostBodyType
    ) -> "Response[Commit]":
        ...

    @overload
    def merge(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        base: str,
        head: str,
        commit_message: Union[Unset, str] = UNSET,
    ) -> "Response[Commit]":
        ...

    def merge(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoMergesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Commit]":
        url = f"/repos/{owner}/{repo}/merges"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoMergesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Commit,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_merge(
        self, owner: str, repo: str, *, data: ReposOwnerRepoMergesPostBodyType
    ) -> "Response[Commit]":
        ...

    @overload
    async def async_merge(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        base: str,
        head: str,
        commit_message: Union[Unset, str] = UNSET,
    ) -> "Response[Commit]":
        ...

    async def async_merge(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoMergesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Commit]":
        url = f"/repos/{owner}/{repo}/merges"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoMergesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Commit,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def get_pages(
        self,
        owner: str,
        repo: str,
    ) -> "Response[Page]":
        url = f"/repos/{owner}/{repo}/pages"

        return self._github.request(
            "GET",
            url,
            response_model=Page,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_pages(
        self,
        owner: str,
        repo: str,
    ) -> "Response[Page]":
        url = f"/repos/{owner}/{repo}/pages"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Page,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[
            ReposOwnerRepoPagesPutBodyAnyof0Type,
            ReposOwnerRepoPagesPutBodyAnyof1Type,
            ReposOwnerRepoPagesPutBodyAnyof2Type,
            ReposOwnerRepoPagesPutBodyAnyof3Type,
            ReposOwnerRepoPagesPutBodyAnyof4Type,
        ],
    ) -> "Response":
        ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        cname: Union[Unset, Union[str, None]] = UNSET,
        https_enforced: Union[Unset, bool] = UNSET,
        public: Union[Unset, bool] = UNSET,
        build_type: Literal["legacy", "workflow"],
        source: Union[
            Unset,
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ],
        ] = UNSET,
    ) -> "Response":
        ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        cname: Union[Unset, Union[str, None]] = UNSET,
        https_enforced: Union[Unset, bool] = UNSET,
        public: Union[Unset, bool] = UNSET,
        build_type: Union[Unset, Literal["legacy", "workflow"]] = UNSET,
        source: Union[
            Literal["gh-pages", "master", "master /docs"],
            ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
        ],
    ) -> "Response":
        ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        cname: Union[str, None],
        https_enforced: Union[Unset, bool] = UNSET,
        public: Union[Unset, bool] = UNSET,
        build_type: Union[Unset, Literal["legacy", "workflow"]] = UNSET,
        source: Union[
            Unset,
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ],
        ] = UNSET,
    ) -> "Response":
        ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        cname: Union[Unset, Union[str, None]] = UNSET,
        https_enforced: Union[Unset, bool] = UNSET,
        public: bool,
        build_type: Union[Unset, Literal["legacy", "workflow"]] = UNSET,
        source: Union[
            Unset,
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ],
        ] = UNSET,
    ) -> "Response":
        ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        cname: Union[Unset, Union[str, None]] = UNSET,
        https_enforced: bool,
        public: Union[Unset, bool] = UNSET,
        build_type: Union[Unset, Literal["legacy", "workflow"]] = UNSET,
        source: Union[
            Unset,
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ],
        ] = UNSET,
    ) -> "Response":
        ...

    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoPagesPutBodyAnyof0Type,
                ReposOwnerRepoPagesPutBodyAnyof1Type,
                ReposOwnerRepoPagesPutBodyAnyof2Type,
                ReposOwnerRepoPagesPutBodyAnyof3Type,
                ReposOwnerRepoPagesPutBodyAnyof4Type,
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/pages"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoPagesPutBodyAnyof0,
                ReposOwnerRepoPagesPutBodyAnyof1,
                ReposOwnerRepoPagesPutBodyAnyof2,
                ReposOwnerRepoPagesPutBodyAnyof3,
                ReposOwnerRepoPagesPutBodyAnyof4,
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "422": ValidationError,
                "400": BasicError,
                "409": BasicError,
            },
        )

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[
            ReposOwnerRepoPagesPutBodyAnyof0Type,
            ReposOwnerRepoPagesPutBodyAnyof1Type,
            ReposOwnerRepoPagesPutBodyAnyof2Type,
            ReposOwnerRepoPagesPutBodyAnyof3Type,
            ReposOwnerRepoPagesPutBodyAnyof4Type,
        ],
    ) -> "Response":
        ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        cname: Union[Unset, Union[str, None]] = UNSET,
        https_enforced: Union[Unset, bool] = UNSET,
        public: Union[Unset, bool] = UNSET,
        build_type: Literal["legacy", "workflow"],
        source: Union[
            Unset,
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ],
        ] = UNSET,
    ) -> "Response":
        ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        cname: Union[Unset, Union[str, None]] = UNSET,
        https_enforced: Union[Unset, bool] = UNSET,
        public: Union[Unset, bool] = UNSET,
        build_type: Union[Unset, Literal["legacy", "workflow"]] = UNSET,
        source: Union[
            Literal["gh-pages", "master", "master /docs"],
            ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
        ],
    ) -> "Response":
        ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        cname: Union[str, None],
        https_enforced: Union[Unset, bool] = UNSET,
        public: Union[Unset, bool] = UNSET,
        build_type: Union[Unset, Literal["legacy", "workflow"]] = UNSET,
        source: Union[
            Unset,
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ],
        ] = UNSET,
    ) -> "Response":
        ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        cname: Union[Unset, Union[str, None]] = UNSET,
        https_enforced: Union[Unset, bool] = UNSET,
        public: bool,
        build_type: Union[Unset, Literal["legacy", "workflow"]] = UNSET,
        source: Union[
            Unset,
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ],
        ] = UNSET,
    ) -> "Response":
        ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        cname: Union[Unset, Union[str, None]] = UNSET,
        https_enforced: bool,
        public: Union[Unset, bool] = UNSET,
        build_type: Union[Unset, Literal["legacy", "workflow"]] = UNSET,
        source: Union[
            Unset,
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ],
        ] = UNSET,
    ) -> "Response":
        ...

    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoPagesPutBodyAnyof0Type,
                ReposOwnerRepoPagesPutBodyAnyof1Type,
                ReposOwnerRepoPagesPutBodyAnyof2Type,
                ReposOwnerRepoPagesPutBodyAnyof3Type,
                ReposOwnerRepoPagesPutBodyAnyof4Type,
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/pages"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoPagesPutBodyAnyof0,
                ReposOwnerRepoPagesPutBodyAnyof1,
                ReposOwnerRepoPagesPutBodyAnyof2,
                ReposOwnerRepoPagesPutBodyAnyof3,
                ReposOwnerRepoPagesPutBodyAnyof4,
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "422": ValidationError,
                "400": BasicError,
                "409": BasicError,
            },
        )

    @overload
    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[
            ReposOwnerRepoPagesPostBodyAnyof0Type,
            None,
            ReposOwnerRepoPagesPostBodyAnyof1Type,
            None,
        ],
    ) -> "Response[Page]":
        ...

    @overload
    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        build_type: Union[Unset, Literal["legacy", "workflow"]] = UNSET,
        source: ReposOwnerRepoPagesPostBodyPropSourceType,
    ) -> "Response[Page]":
        ...

    @overload
    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        build_type: Literal["legacy", "workflow"],
        source: Union[Unset, ReposOwnerRepoPagesPostBodyPropSourceType] = UNSET,
    ) -> "Response[Page]":
        ...

    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoPagesPostBodyAnyof0Type,
                None,
                ReposOwnerRepoPagesPostBodyAnyof1Type,
                None,
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[Page]":
        url = f"/repos/{owner}/{repo}/pages"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoPagesPostBodyAnyof0,
                None,
                ReposOwnerRepoPagesPostBodyAnyof1,
                None,
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Page,
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    @overload
    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[
            ReposOwnerRepoPagesPostBodyAnyof0Type,
            None,
            ReposOwnerRepoPagesPostBodyAnyof1Type,
            None,
        ],
    ) -> "Response[Page]":
        ...

    @overload
    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        build_type: Union[Unset, Literal["legacy", "workflow"]] = UNSET,
        source: ReposOwnerRepoPagesPostBodyPropSourceType,
    ) -> "Response[Page]":
        ...

    @overload
    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        build_type: Literal["legacy", "workflow"],
        source: Union[Unset, ReposOwnerRepoPagesPostBodyPropSourceType] = UNSET,
    ) -> "Response[Page]":
        ...

    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[
            Unset,
            Union[
                ReposOwnerRepoPagesPostBodyAnyof0Type,
                None,
                ReposOwnerRepoPagesPostBodyAnyof1Type,
                None,
            ],
        ] = UNSET,
        **kwargs,
    ) -> "Response[Page]":
        url = f"/repos/{owner}/{repo}/pages"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[
                ReposOwnerRepoPagesPostBodyAnyof0,
                None,
                ReposOwnerRepoPagesPostBodyAnyof1,
                None,
            ],
            json,
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Page,
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    def delete_pages_site(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/pages"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_delete_pages_site(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/pages"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    def list_pages_builds(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[PageBuild]]":
        url = f"/repos/{owner}/{repo}/pages/builds"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[PageBuild],
        )

    async def async_list_pages_builds(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[PageBuild]]":
        url = f"/repos/{owner}/{repo}/pages/builds"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[PageBuild],
        )

    def request_pages_build(
        self,
        owner: str,
        repo: str,
    ) -> "Response[PageBuildStatus]":
        url = f"/repos/{owner}/{repo}/pages/builds"

        return self._github.request(
            "POST",
            url,
            response_model=PageBuildStatus,
        )

    async def async_request_pages_build(
        self,
        owner: str,
        repo: str,
    ) -> "Response[PageBuildStatus]":
        url = f"/repos/{owner}/{repo}/pages/builds"

        return await self._github.arequest(
            "POST",
            url,
            response_model=PageBuildStatus,
        )

    def get_latest_pages_build(
        self,
        owner: str,
        repo: str,
    ) -> "Response[PageBuild]":
        url = f"/repos/{owner}/{repo}/pages/builds/latest"

        return self._github.request(
            "GET",
            url,
            response_model=PageBuild,
        )

    async def async_get_latest_pages_build(
        self,
        owner: str,
        repo: str,
    ) -> "Response[PageBuild]":
        url = f"/repos/{owner}/{repo}/pages/builds/latest"

        return await self._github.arequest(
            "GET",
            url,
            response_model=PageBuild,
        )

    def get_pages_build(
        self,
        owner: str,
        repo: str,
        build_id: int,
    ) -> "Response[PageBuild]":
        url = f"/repos/{owner}/{repo}/pages/builds/{build_id}"

        return self._github.request(
            "GET",
            url,
            response_model=PageBuild,
        )

    async def async_get_pages_build(
        self,
        owner: str,
        repo: str,
        build_id: int,
    ) -> "Response[PageBuild]":
        url = f"/repos/{owner}/{repo}/pages/builds/{build_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=PageBuild,
        )

    @overload
    def create_pages_deployment(
        self, owner: str, repo: str, *, data: ReposOwnerRepoPagesDeploymentPostBodyType
    ) -> "Response[PageDeployment]":
        ...

    @overload
    def create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        artifact_url: str,
        environment: Union[Unset, str] = "github-pages",
        pages_build_version: str = "GITHUB_SHA",
        oidc_token: str,
    ) -> "Response[PageDeployment]":
        ...

    def create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoPagesDeploymentPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[PageDeployment]":
        url = f"/repos/{owner}/{repo}/pages/deployment"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoPagesDeploymentPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=PageDeployment,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_pages_deployment(
        self, owner: str, repo: str, *, data: ReposOwnerRepoPagesDeploymentPostBodyType
    ) -> "Response[PageDeployment]":
        ...

    @overload
    async def async_create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        artifact_url: str,
        environment: Union[Unset, str] = "github-pages",
        pages_build_version: str = "GITHUB_SHA",
        oidc_token: str,
    ) -> "Response[PageDeployment]":
        ...

    async def async_create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoPagesDeploymentPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[PageDeployment]":
        url = f"/repos/{owner}/{repo}/pages/deployment"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoPagesDeploymentPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=PageDeployment,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_pages_health_check(
        self,
        owner: str,
        repo: str,
    ) -> "Response[PagesHealthCheck]":
        url = f"/repos/{owner}/{repo}/pages/health"

        return self._github.request(
            "GET",
            url,
            response_model=PagesHealthCheck,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_pages_health_check(
        self,
        owner: str,
        repo: str,
    ) -> "Response[PagesHealthCheck]":
        url = f"/repos/{owner}/{repo}/pages/health"

        return await self._github.arequest(
            "GET",
            url,
            response_model=PagesHealthCheck,
            error_models={
                "404": BasicError,
            },
        )

    def get_readme(
        self,
        owner: str,
        repo: str,
        ref: Union[Unset, str] = UNSET,
    ) -> "Response[ContentFile]":
        url = f"/repos/{owner}/{repo}/readme"

        params = {
            "ref": ref,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_readme(
        self,
        owner: str,
        repo: str,
        ref: Union[Unset, str] = UNSET,
    ) -> "Response[ContentFile]":
        url = f"/repos/{owner}/{repo}/readme"

        params = {
            "ref": ref,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_readme_in_directory(
        self,
        owner: str,
        repo: str,
        dir_: str,
        ref: Union[Unset, str] = UNSET,
    ) -> "Response[ContentFile]":
        url = f"/repos/{owner}/{repo}/readme/{dir}"

        params = {
            "ref": ref,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_readme_in_directory(
        self,
        owner: str,
        repo: str,
        dir_: str,
        ref: Union[Unset, str] = UNSET,
    ) -> "Response[ContentFile]":
        url = f"/repos/{owner}/{repo}/readme/{dir}"

        params = {
            "ref": ref,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_releases(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Release]]":
        url = f"/repos/{owner}/{repo}/releases"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Release],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_releases(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Release]]":
        url = f"/repos/{owner}/{repo}/releases"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Release],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_release(
        self, owner: str, repo: str, *, data: ReposOwnerRepoReleasesPostBodyType
    ) -> "Response[Release]":
        ...

    @overload
    def create_release(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        tag_name: str,
        target_commitish: Union[Unset, str] = UNSET,
        name: Union[Unset, str] = UNSET,
        body: Union[Unset, str] = UNSET,
        draft: Union[Unset, bool] = False,
        prerelease: Union[Unset, bool] = False,
        discussion_category_name: Union[Unset, str] = UNSET,
        generate_release_notes: Union[Unset, bool] = False,
    ) -> "Response[Release]":
        ...

    def create_release(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoReleasesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoReleasesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Release,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_release(
        self, owner: str, repo: str, *, data: ReposOwnerRepoReleasesPostBodyType
    ) -> "Response[Release]":
        ...

    @overload
    async def async_create_release(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        tag_name: str,
        target_commitish: Union[Unset, str] = UNSET,
        name: Union[Unset, str] = UNSET,
        body: Union[Unset, str] = UNSET,
        draft: Union[Unset, bool] = False,
        prerelease: Union[Unset, bool] = False,
        discussion_category_name: Union[Unset, str] = UNSET,
        generate_release_notes: Union[Unset, bool] = False,
    ) -> "Response[Release]":
        ...

    async def async_create_release(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoReleasesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoReleasesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Release,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
    ) -> "Response[ReleaseAsset]":
        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        return self._github.request(
            "GET",
            url,
            response_model=ReleaseAsset,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
    ) -> "Response[ReleaseAsset]":
        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ReleaseAsset,
            error_models={
                "404": BasicError,
            },
        )

    def delete_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    @overload
    def update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType] = UNSET,
    ) -> "Response[ReleaseAsset]":
        ...

    @overload
    def update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        data: Unset = UNSET,
        name: Union[Unset, str] = UNSET,
        label: Union[Unset, str] = UNSET,
        state: Union[Unset, str] = UNSET,
    ) -> "Response[ReleaseAsset]":
        ...

    def update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ReleaseAsset]":
        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoReleasesAssetsAssetIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ReleaseAsset,
        )

    @overload
    async def async_update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType] = UNSET,
    ) -> "Response[ReleaseAsset]":
        ...

    @overload
    async def async_update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        data: Unset = UNSET,
        name: Union[Unset, str] = UNSET,
        label: Union[Unset, str] = UNSET,
        state: Union[Unset, str] = UNSET,
    ) -> "Response[ReleaseAsset]":
        ...

    async def async_update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ReleaseAsset]":
        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoReleasesAssetsAssetIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=ReleaseAsset,
        )

    @overload
    def generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        data: ReposOwnerRepoReleasesGenerateNotesPostBodyType,
    ) -> "Response[ReleaseNotesContent]":
        ...

    @overload
    def generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        tag_name: str,
        target_commitish: Union[Unset, str] = UNSET,
        previous_tag_name: Union[Unset, str] = UNSET,
        configuration_file_path: Union[Unset, str] = UNSET,
    ) -> "Response[ReleaseNotesContent]":
        ...

    def generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoReleasesGenerateNotesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ReleaseNotesContent]":
        url = f"/repos/{owner}/{repo}/releases/generate-notes"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoReleasesGenerateNotesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ReleaseNotesContent,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        data: ReposOwnerRepoReleasesGenerateNotesPostBodyType,
    ) -> "Response[ReleaseNotesContent]":
        ...

    @overload
    async def async_generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        tag_name: str,
        target_commitish: Union[Unset, str] = UNSET,
        previous_tag_name: Union[Unset, str] = UNSET,
        configuration_file_path: Union[Unset, str] = UNSET,
    ) -> "Response[ReleaseNotesContent]":
        ...

    async def async_generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoReleasesGenerateNotesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[ReleaseNotesContent]":
        url = f"/repos/{owner}/{repo}/releases/generate-notes"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoReleasesGenerateNotesPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=ReleaseNotesContent,
            error_models={
                "404": BasicError,
            },
        )

    def get_latest_release(
        self,
        owner: str,
        repo: str,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/latest"

        return self._github.request(
            "GET",
            url,
            response_model=Release,
        )

    async def async_get_latest_release(
        self,
        owner: str,
        repo: str,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/latest"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Release,
        )

    def get_release_by_tag(
        self,
        owner: str,
        repo: str,
        tag: str,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/tags/{tag}"

        return self._github.request(
            "GET",
            url,
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_release_by_tag(
        self,
        owner: str,
        repo: str,
        tag: str,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/tags/{tag}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    def get_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        return self._github.request(
            "GET",
            url,
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    def delete_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    @overload
    def update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoReleasesReleaseIdPatchBodyType] = UNSET,
    ) -> "Response[Release]":
        ...

    @overload
    def update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        data: Unset = UNSET,
        tag_name: Union[Unset, str] = UNSET,
        target_commitish: Union[Unset, str] = UNSET,
        name: Union[Unset, str] = UNSET,
        body: Union[Unset, str] = UNSET,
        draft: Union[Unset, bool] = UNSET,
        prerelease: Union[Unset, bool] = UNSET,
        discussion_category_name: Union[Unset, str] = UNSET,
    ) -> "Response[Release]":
        ...

    def update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoReleasesReleaseIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoReleasesReleaseIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoReleasesReleaseIdPatchBodyType] = UNSET,
    ) -> "Response[Release]":
        ...

    @overload
    async def async_update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        data: Unset = UNSET,
        tag_name: Union[Unset, str] = UNSET,
        target_commitish: Union[Unset, str] = UNSET,
        name: Union[Unset, str] = UNSET,
        body: Union[Unset, str] = UNSET,
        draft: Union[Unset, bool] = UNSET,
        prerelease: Union[Unset, bool] = UNSET,
        discussion_category_name: Union[Unset, str] = UNSET,
    ) -> "Response[Release]":
        ...

    async def async_update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        data: Union[Unset, ReposOwnerRepoReleasesReleaseIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Release]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoReleasesReleaseIdPatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    def list_release_assets(
        self,
        owner: str,
        repo: str,
        release_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[ReleaseAsset]]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[ReleaseAsset],
        )

    async def async_list_release_assets(
        self,
        owner: str,
        repo: str,
        release_id: int,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[ReleaseAsset]]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[ReleaseAsset],
        )

    def upload_release_asset(
        self,
        owner: str,
        repo: str,
        release_id: int,
        name: str,
        label: Union[Unset, str] = UNSET,
        *,
        data: str,
        **kwargs,
    ) -> "Response[ReleaseAsset]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "name": name,
            "label": label,
        }

        if not kwargs:
            kwargs = UNSET

        content = kwargs if data is UNSET else data
        content = parse_obj_as(str, content)
        content = (
            content.dict(by_alias=True) if isinstance(content, BaseModel) else content
        )

        return self._github.request(
            "POST",
            url,
            params=exclude_unset(params),
            content=exclude_unset(content),
            response_model=ReleaseAsset,
            error_models={},
        )

    async def async_upload_release_asset(
        self,
        owner: str,
        repo: str,
        release_id: int,
        name: str,
        label: Union[Unset, str] = UNSET,
        *,
        data: str,
        **kwargs,
    ) -> "Response[ReleaseAsset]":
        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "name": name,
            "label": label,
        }

        if not kwargs:
            kwargs = UNSET

        content = kwargs if data is UNSET else data
        content = parse_obj_as(str, content)
        content = (
            content.dict(by_alias=True) if isinstance(content, BaseModel) else content
        )

        return await self._github.arequest(
            "POST",
            url,
            params=exclude_unset(params),
            content=exclude_unset(content),
            response_model=ReleaseAsset,
            error_models={},
        )

    def get_code_frequency_stats(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[List[int]]]":
        url = f"/repos/{owner}/{repo}/stats/code_frequency"

        return self._github.request(
            "GET",
            url,
            response_model=List[List[int]],
        )

    async def async_get_code_frequency_stats(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[List[int]]]":
        url = f"/repos/{owner}/{repo}/stats/code_frequency"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[List[int]],
        )

    def get_commit_activity_stats(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[CommitActivity]]":
        url = f"/repos/{owner}/{repo}/stats/commit_activity"

        return self._github.request(
            "GET",
            url,
            response_model=List[CommitActivity],
        )

    async def async_get_commit_activity_stats(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[CommitActivity]]":
        url = f"/repos/{owner}/{repo}/stats/commit_activity"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[CommitActivity],
        )

    def get_contributors_stats(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[ContributorActivity]]":
        url = f"/repos/{owner}/{repo}/stats/contributors"

        return self._github.request(
            "GET",
            url,
            response_model=List[ContributorActivity],
        )

    async def async_get_contributors_stats(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[ContributorActivity]]":
        url = f"/repos/{owner}/{repo}/stats/contributors"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[ContributorActivity],
        )

    def get_participation_stats(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ParticipationStats]":
        url = f"/repos/{owner}/{repo}/stats/participation"

        return self._github.request(
            "GET",
            url,
            response_model=ParticipationStats,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_participation_stats(
        self,
        owner: str,
        repo: str,
    ) -> "Response[ParticipationStats]":
        url = f"/repos/{owner}/{repo}/stats/participation"

        return await self._github.arequest(
            "GET",
            url,
            response_model=ParticipationStats,
            error_models={
                "404": BasicError,
            },
        )

    def get_punch_card_stats(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[List[int]]]":
        url = f"/repos/{owner}/{repo}/stats/punch_card"

        return self._github.request(
            "GET",
            url,
            response_model=List[List[int]],
        )

    async def async_get_punch_card_stats(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[List[int]]]":
        url = f"/repos/{owner}/{repo}/stats/punch_card"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[List[int]],
        )

    @overload
    def create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        data: ReposOwnerRepoStatusesShaPostBodyType,
    ) -> "Response[Status]":
        ...

    @overload
    def create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        data: Unset = UNSET,
        state: Literal["error", "failure", "pending", "success"],
        target_url: Union[Unset, Union[str, None]] = UNSET,
        description: Union[Unset, Union[str, None]] = UNSET,
        context: Union[Unset, str] = "default",
    ) -> "Response[Status]":
        ...

    def create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        data: Union[Unset, ReposOwnerRepoStatusesShaPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Status]":
        url = f"/repos/{owner}/{repo}/statuses/{sha}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoStatusesShaPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Status,
        )

    @overload
    async def async_create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        data: ReposOwnerRepoStatusesShaPostBodyType,
    ) -> "Response[Status]":
        ...

    @overload
    async def async_create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        data: Unset = UNSET,
        state: Literal["error", "failure", "pending", "success"],
        target_url: Union[Unset, Union[str, None]] = UNSET,
        description: Union[Unset, Union[str, None]] = UNSET,
        context: Union[Unset, str] = "default",
    ) -> "Response[Status]":
        ...

    async def async_create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        data: Union[Unset, ReposOwnerRepoStatusesShaPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Status]":
        url = f"/repos/{owner}/{repo}/statuses/{sha}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoStatusesShaPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Status,
        )

    def list_tags(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Tag]]":
        url = f"/repos/{owner}/{repo}/tags"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Tag],
        )

    async def async_list_tags(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Tag]]":
        url = f"/repos/{owner}/{repo}/tags"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Tag],
        )

    def list_tag_protection(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[TagProtection]]":
        url = f"/repos/{owner}/{repo}/tags/protection"

        return self._github.request(
            "GET",
            url,
            response_model=List[TagProtection],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_tag_protection(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[TagProtection]]":
        url = f"/repos/{owner}/{repo}/tags/protection"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[TagProtection],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_tag_protection(
        self, owner: str, repo: str, *, data: ReposOwnerRepoTagsProtectionPostBodyType
    ) -> "Response[TagProtection]":
        ...

    @overload
    def create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        pattern: str,
    ) -> "Response[TagProtection]":
        ...

    def create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoTagsProtectionPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[TagProtection]":
        url = f"/repos/{owner}/{repo}/tags/protection"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoTagsProtectionPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=TagProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_tag_protection(
        self, owner: str, repo: str, *, data: ReposOwnerRepoTagsProtectionPostBodyType
    ) -> "Response[TagProtection]":
        ...

    @overload
    async def async_create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        pattern: str,
    ) -> "Response[TagProtection]":
        ...

    async def async_create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoTagsProtectionPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[TagProtection]":
        url = f"/repos/{owner}/{repo}/tags/protection"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoTagsProtectionPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=TagProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete_tag_protection(
        self,
        owner: str,
        repo: str,
        tag_protection_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/tags/protection/{tag_protection_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_tag_protection(
        self,
        owner: str,
        repo: str,
        tag_protection_id: int,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/tags/protection/{tag_protection_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def download_tarball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/tarball/{ref}"

        return self._github.request(
            "GET",
            url,
        )

    async def async_download_tarball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/tarball/{ref}"

        return await self._github.arequest(
            "GET",
            url,
        )

    def list_teams(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Team],
        )

    async def async_list_teams(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[Team]]":
        url = f"/repos/{owner}/{repo}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Team],
        )

    def get_all_topics(
        self,
        owner: str,
        repo: str,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[Topic]":
        url = f"/repos/{owner}/{repo}/topics"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Topic,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_all_topics(
        self,
        owner: str,
        repo: str,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[Topic]":
        url = f"/repos/{owner}/{repo}/topics"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=Topic,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def replace_all_topics(
        self, owner: str, repo: str, *, data: ReposOwnerRepoTopicsPutBodyType
    ) -> "Response[Topic]":
        ...

    @overload
    def replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        names: List[str],
    ) -> "Response[Topic]":
        ...

    def replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoTopicsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Topic]":
        url = f"/repos/{owner}/{repo}/topics"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoTopicsPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=Topic,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_replace_all_topics(
        self, owner: str, repo: str, *, data: ReposOwnerRepoTopicsPutBodyType
    ) -> "Response[Topic]":
        ...

    @overload
    async def async_replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        names: List[str],
    ) -> "Response[Topic]":
        ...

    async def async_replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoTopicsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Topic]":
        url = f"/repos/{owner}/{repo}/topics"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoTopicsPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=Topic,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_clones(
        self,
        owner: str,
        repo: str,
        per: Union[Unset, Literal["", "day", "week"]] = "day",
    ) -> "Response[CloneTraffic]":
        url = f"/repos/{owner}/{repo}/traffic/clones"

        params = {
            "per": per,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=CloneTraffic,
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_clones(
        self,
        owner: str,
        repo: str,
        per: Union[Unset, Literal["", "day", "week"]] = "day",
    ) -> "Response[CloneTraffic]":
        url = f"/repos/{owner}/{repo}/traffic/clones"

        params = {
            "per": per,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=CloneTraffic,
            error_models={
                "403": BasicError,
            },
        )

    def get_top_paths(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[ContentTraffic]]":
        url = f"/repos/{owner}/{repo}/traffic/popular/paths"

        return self._github.request(
            "GET",
            url,
            response_model=List[ContentTraffic],
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_top_paths(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[ContentTraffic]]":
        url = f"/repos/{owner}/{repo}/traffic/popular/paths"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[ContentTraffic],
            error_models={
                "403": BasicError,
            },
        )

    def get_top_referrers(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[ReferrerTraffic]]":
        url = f"/repos/{owner}/{repo}/traffic/popular/referrers"

        return self._github.request(
            "GET",
            url,
            response_model=List[ReferrerTraffic],
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_top_referrers(
        self,
        owner: str,
        repo: str,
    ) -> "Response[List[ReferrerTraffic]]":
        url = f"/repos/{owner}/{repo}/traffic/popular/referrers"

        return await self._github.arequest(
            "GET",
            url,
            response_model=List[ReferrerTraffic],
            error_models={
                "403": BasicError,
            },
        )

    def get_views(
        self,
        owner: str,
        repo: str,
        per: Union[Unset, Literal["", "day", "week"]] = "day",
    ) -> "Response[ViewTraffic]":
        url = f"/repos/{owner}/{repo}/traffic/views"

        params = {
            "per": per,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ViewTraffic,
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_views(
        self,
        owner: str,
        repo: str,
        per: Union[Unset, Literal["", "day", "week"]] = "day",
    ) -> "Response[ViewTraffic]":
        url = f"/repos/{owner}/{repo}/traffic/views"

        params = {
            "per": per,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ViewTraffic,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    def transfer(
        self, owner: str, repo: str, *, data: ReposOwnerRepoTransferPostBodyType
    ) -> "Response[MinimalRepository]":
        ...

    @overload
    def transfer(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        new_owner: str,
        team_ids: Union[Unset, List[int]] = UNSET,
    ) -> "Response[MinimalRepository]":
        ...

    def transfer(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoTransferPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[MinimalRepository]":
        url = f"/repos/{owner}/{repo}/transfer"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoTransferPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=MinimalRepository,
        )

    @overload
    async def async_transfer(
        self, owner: str, repo: str, *, data: ReposOwnerRepoTransferPostBodyType
    ) -> "Response[MinimalRepository]":
        ...

    @overload
    async def async_transfer(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        new_owner: str,
        team_ids: Union[Unset, List[int]] = UNSET,
    ) -> "Response[MinimalRepository]":
        ...

    async def async_transfer(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, ReposOwnerRepoTransferPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[MinimalRepository]":
        url = f"/repos/{owner}/{repo}/transfer"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoTransferPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=MinimalRepository,
        )

    def check_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        return self._github.request(
            "GET",
            url,
            error_models={},
        )

    async def async_check_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        return await self._github.arequest(
            "GET",
            url,
            error_models={},
        )

    def enable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        return self._github.request(
            "PUT",
            url,
        )

    async def async_enable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        return await self._github.arequest(
            "PUT",
            url,
        )

    def disable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_disable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def download_zipball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/zipball/{ref}"

        return self._github.request(
            "GET",
            url,
        )

    async def async_download_zipball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/zipball/{ref}"

        return await self._github.arequest(
            "GET",
            url,
        )

    @overload
    def create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        data: ReposTemplateOwnerTemplateRepoGeneratePostBodyType,
    ) -> "Response[Repository]":
        ...

    @overload
    def create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        data: Unset = UNSET,
        owner: Union[Unset, str] = UNSET,
        name: str,
        description: Union[Unset, str] = UNSET,
        include_all_branches: Union[Unset, bool] = False,
        private: Union[Unset, bool] = False,
    ) -> "Response[Repository]":
        ...

    def create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        data: Union[Unset, ReposTemplateOwnerTemplateRepoGeneratePostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Repository]":
        url = f"/repos/{template_owner}/{template_repo}/generate"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposTemplateOwnerTemplateRepoGeneratePostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Repository,
        )

    @overload
    async def async_create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        data: ReposTemplateOwnerTemplateRepoGeneratePostBodyType,
    ) -> "Response[Repository]":
        ...

    @overload
    async def async_create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        data: Unset = UNSET,
        owner: Union[Unset, str] = UNSET,
        name: str,
        description: Union[Unset, str] = UNSET,
        include_all_branches: Union[Unset, bool] = False,
        private: Union[Unset, bool] = False,
    ) -> "Response[Repository]":
        ...

    async def async_create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        data: Union[Unset, ReposTemplateOwnerTemplateRepoGeneratePostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Repository]":
        url = f"/repos/{template_owner}/{template_repo}/generate"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposTemplateOwnerTemplateRepoGeneratePostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Repository,
        )

    def list_public(
        self,
        since: Union[Unset, int] = UNSET,
    ) -> "Response[List[MinimalRepository]]":
        url = "/repositories"

        params = {
            "since": since,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_public(
        self,
        since: Union[Unset, int] = UNSET,
    ) -> "Response[List[MinimalRepository]]":
        url = "/repositories"

        params = {
            "since": since,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
            error_models={
                "422": ValidationError,
            },
        )

    def list_for_authenticated_user(
        self,
        visibility: Union[Unset, Literal["all", "public", "private"]] = "all",
        affiliation: Union[Unset, str] = "owner,collaborator,organization_member",
        type: Union[
            Unset, Literal["all", "owner", "public", "private", "member"]
        ] = "all",
        sort: Union[
            Unset, Literal["created", "updated", "pushed", "full_name"]
        ] = "full_name",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        since: Union[Unset, datetime] = UNSET,
        before: Union[Unset, datetime] = UNSET,
    ) -> "Response[List[Repository]]":
        url = "/user/repos"

        params = {
            "visibility": visibility,
            "affiliation": affiliation,
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "since": since,
            "before": before,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Repository],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        visibility: Union[Unset, Literal["all", "public", "private"]] = "all",
        affiliation: Union[Unset, str] = "owner,collaborator,organization_member",
        type: Union[
            Unset, Literal["all", "owner", "public", "private", "member"]
        ] = "all",
        sort: Union[
            Unset, Literal["created", "updated", "pushed", "full_name"]
        ] = "full_name",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        since: Union[Unset, datetime] = UNSET,
        before: Union[Unset, datetime] = UNSET,
    ) -> "Response[List[Repository]]":
        url = "/user/repos"

        params = {
            "visibility": visibility,
            "affiliation": affiliation,
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "since": since,
            "before": before,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[Repository],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_for_authenticated_user(
        self, *, data: UserReposPostBodyType
    ) -> "Response[Repository]":
        ...

    @overload
    def create_for_authenticated_user(
        self,
        *,
        data: Unset = UNSET,
        name: str,
        description: Union[Unset, str] = UNSET,
        homepage: Union[Unset, str] = UNSET,
        private: Union[Unset, bool] = False,
        has_issues: Union[Unset, bool] = True,
        has_projects: Union[Unset, bool] = True,
        has_wiki: Union[Unset, bool] = True,
        team_id: Union[Unset, int] = UNSET,
        auto_init: Union[Unset, bool] = False,
        gitignore_template: Union[Unset, str] = UNSET,
        license_template: Union[Unset, str] = UNSET,
        allow_squash_merge: Union[Unset, bool] = True,
        allow_merge_commit: Union[Unset, bool] = True,
        allow_rebase_merge: Union[Unset, bool] = True,
        allow_auto_merge: Union[Unset, bool] = False,
        delete_branch_on_merge: Union[Unset, bool] = False,
        squash_merge_commit_title: Union[
            Unset, Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Union[
            Unset, Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Union[Unset, Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Union[
            Unset, Literal["PR_BODY", "PR_TITLE", "BLANK"]
        ] = UNSET,
        has_downloads: Union[Unset, bool] = True,
        is_template: Union[Unset, bool] = False,
    ) -> "Response[Repository]":
        ...

    def create_for_authenticated_user(
        self, *, data: Union[Unset, UserReposPostBodyType] = UNSET, **kwargs
    ) -> "Response[Repository]":
        url = "/user/repos"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserReposPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Repository,
            error_models={
                "401": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "400": BasicError,
            },
        )

    @overload
    async def async_create_for_authenticated_user(
        self, *, data: UserReposPostBodyType
    ) -> "Response[Repository]":
        ...

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        data: Unset = UNSET,
        name: str,
        description: Union[Unset, str] = UNSET,
        homepage: Union[Unset, str] = UNSET,
        private: Union[Unset, bool] = False,
        has_issues: Union[Unset, bool] = True,
        has_projects: Union[Unset, bool] = True,
        has_wiki: Union[Unset, bool] = True,
        team_id: Union[Unset, int] = UNSET,
        auto_init: Union[Unset, bool] = False,
        gitignore_template: Union[Unset, str] = UNSET,
        license_template: Union[Unset, str] = UNSET,
        allow_squash_merge: Union[Unset, bool] = True,
        allow_merge_commit: Union[Unset, bool] = True,
        allow_rebase_merge: Union[Unset, bool] = True,
        allow_auto_merge: Union[Unset, bool] = False,
        delete_branch_on_merge: Union[Unset, bool] = False,
        squash_merge_commit_title: Union[
            Unset, Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Union[
            Unset, Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Union[Unset, Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Union[
            Unset, Literal["PR_BODY", "PR_TITLE", "BLANK"]
        ] = UNSET,
        has_downloads: Union[Unset, bool] = True,
        is_template: Union[Unset, bool] = False,
    ) -> "Response[Repository]":
        ...

    async def async_create_for_authenticated_user(
        self, *, data: Union[Unset, UserReposPostBodyType] = UNSET, **kwargs
    ) -> "Response[Repository]":
        url = "/user/repos"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserReposPostBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Repository,
            error_models={
                "401": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "400": BasicError,
            },
        )

    def list_invitations_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[RepositoryInvitation]]":
        url = "/user/repository_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[RepositoryInvitation],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_invitations_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[RepositoryInvitation]]":
        url = "/user/repository_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[RepositoryInvitation],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def decline_invitation_for_authenticated_user(
        self,
        invitation_id: int,
    ) -> "Response":
        url = f"/user/repository_invitations/{invitation_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "409": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_decline_invitation_for_authenticated_user(
        self,
        invitation_id: int,
    ) -> "Response":
        url = f"/user/repository_invitations/{invitation_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "409": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def accept_invitation_for_authenticated_user(
        self,
        invitation_id: int,
    ) -> "Response":
        url = f"/user/repository_invitations/{invitation_id}"

        return self._github.request(
            "PATCH",
            url,
            error_models={
                "403": BasicError,
                "409": BasicError,
                "404": BasicError,
            },
        )

    async def async_accept_invitation_for_authenticated_user(
        self,
        invitation_id: int,
    ) -> "Response":
        url = f"/user/repository_invitations/{invitation_id}"

        return await self._github.arequest(
            "PATCH",
            url,
            error_models={
                "403": BasicError,
                "409": BasicError,
                "404": BasicError,
            },
        )

    def list_for_user(
        self,
        username: str,
        type: Union[Unset, Literal["all", "owner", "member"]] = "owner",
        sort: Union[
            Unset, Literal["created", "updated", "pushed", "full_name"]
        ] = "full_name",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/users/{username}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
        )

    async def async_list_for_user(
        self,
        username: str,
        type: Union[Unset, Literal["all", "owner", "member"]] = "owner",
        sort: Union[
            Unset, Literal["created", "updated", "pushed", "full_name"]
        ] = "full_name",
        direction: Union[Unset, Literal["asc", "desc"]] = UNSET,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[List[MinimalRepository]]":
        url = f"/users/{username}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=List[MinimalRepository],
        )
