"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api description.
See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, List, Union, Literal, overload

from pydantic import BaseModel, parse_obj_as

from githubkit.utils import UNSET, Unset, exclude_unset

from .types import (
    UserCodespacesPostBodyOneof0Type,
    UserCodespacesPostBodyOneof1Type,
    OrgsOrgCodespacesBillingPutBodyType,
    ReposOwnerRepoCodespacesPostBodyType,
    UserCodespacesCodespaceNamePatchBodyType,
    UserCodespacesSecretsSecretNamePutBodyType,
    OrgsOrgCodespacesSecretsSecretNamePutBodyType,
    UserCodespacesPostBodyOneof1PropPullRequestType,
    ReposOwnerRepoPullsPullNumberCodespacesPostBodyType,
    ReposOwnerRepoCodespacesSecretsSecretNamePutBodyType,
    UserCodespacesSecretsSecretNameRepositoriesPutBodyType,
    OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBodyType,
)
from .models import (
    Codespace,
    BasicError,
    EmptyObject,
    ValidationError,
    CodespacesSecret,
    CodespacesOrgSecret,
    CodespacesPublicKey,
    RepoCodespacesSecret,
    CodespaceExportDetails,
    CodespacesUserPublicKey,
    UserCodespacesGetResponse200,
    UserCodespacesPostBodyOneof0,
    UserCodespacesPostBodyOneof1,
    OrgsOrgCodespacesBillingPutBody,
    OrgsOrgCodespacesGetResponse200,
    ReposOwnerRepoCodespacesPostBody,
    UserCodespacesSecretsGetResponse200,
    UserCodespacesCodespaceNamePatchBody,
    OrgsOrgCodespacesSecretsGetResponse200,
    ReposOwnerRepoCodespacesGetResponse200,
    UserCodespacesSecretsSecretNamePutBody,
    OrgsOrgCodespacesSecretsSecretNamePutBody,
    ReposOwnerRepoCodespacesNewGetResponse200,
    ReposOwnerRepoCodespacesSecretsGetResponse200,
    UserCodespacesSecretsSecretNamePutResponse201,
    OrgsOrgMembersUsernameCodespacesGetResponse200,
    ReposOwnerRepoCodespacesMachinesGetResponse200,
    ReposOwnerRepoPullsPullNumberCodespacesPostBody,
    ReposOwnerRepoCodespacesSecretsSecretNamePutBody,
    UserCodespacesCodespaceNameMachinesGetResponse200,
    AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
    UserCodespacesSecretsSecretNameRepositoriesPutBody,
    ReposOwnerRepoCodespacesDevcontainersGetResponse200,
    OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBody,
    ReposOwnerRepoCodespacesSecretsSecretNamePutResponse201,
    UserCodespacesSecretsSecretNameRepositoriesGetResponse200,
    OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200,
)

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class CodespacesClient:
    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list_in_organization(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgCodespacesGetResponse200]":
        url = f"/orgs/{org}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_in_organization(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgCodespacesGetResponse200]":
        url = f"/orgs/{org}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def set_codespaces_billing(
        self, org: str, *, data: OrgsOrgCodespacesBillingPutBodyType
    ) -> "Response":
        ...

    @overload
    def set_codespaces_billing(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        visibility: Literal[
            "disabled",
            "selected_members",
            "all_members",
            "all_members_and_outside_collaborators",
        ],
        selected_usernames: Union[Unset, List[str]] = UNSET,
    ) -> "Response":
        ...

    def set_codespaces_billing(
        self,
        org: str,
        *,
        data: Union[Unset, OrgsOrgCodespacesBillingPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/codespaces/billing"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgCodespacesBillingPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    @overload
    async def async_set_codespaces_billing(
        self, org: str, *, data: OrgsOrgCodespacesBillingPutBodyType
    ) -> "Response":
        ...

    @overload
    async def async_set_codespaces_billing(
        self,
        org: str,
        *,
        data: Unset = UNSET,
        visibility: Literal[
            "disabled",
            "selected_members",
            "all_members",
            "all_members_and_outside_collaborators",
        ],
        selected_usernames: Union[Unset, List[str]] = UNSET,
    ) -> "Response":
        ...

    async def async_set_codespaces_billing(
        self,
        org: str,
        *,
        data: Union[Unset, OrgsOrgCodespacesBillingPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/codespaces/billing"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgCodespacesBillingPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    def list_org_secrets(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgCodespacesSecretsGetResponse200]":
        url = f"/orgs/{org}/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgCodespacesSecretsGetResponse200,
        )

    async def async_list_org_secrets(
        self,
        org: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgCodespacesSecretsGetResponse200]":
        url = f"/orgs/{org}/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgCodespacesSecretsGetResponse200,
        )

    def get_org_public_key(
        self,
        org: str,
    ) -> "Response[CodespacesPublicKey]":
        url = f"/orgs/{org}/codespaces/secrets/public-key"

        return self._github.request(
            "GET",
            url,
            response_model=CodespacesPublicKey,
        )

    async def async_get_org_public_key(
        self,
        org: str,
    ) -> "Response[CodespacesPublicKey]":
        url = f"/orgs/{org}/codespaces/secrets/public-key"

        return await self._github.arequest(
            "GET",
            url,
            response_model=CodespacesPublicKey,
        )

    def get_org_secret(
        self,
        org: str,
        secret_name: str,
    ) -> "Response[CodespacesOrgSecret]":
        url = f"/orgs/{org}/codespaces/secrets/{secret_name}"

        return self._github.request(
            "GET",
            url,
            response_model=CodespacesOrgSecret,
        )

    async def async_get_org_secret(
        self,
        org: str,
        secret_name: str,
    ) -> "Response[CodespacesOrgSecret]":
        url = f"/orgs/{org}/codespaces/secrets/{secret_name}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=CodespacesOrgSecret,
        )

    @overload
    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: OrgsOrgCodespacesSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Unset = UNSET,
        encrypted_value: Union[Unset, str] = UNSET,
        key_id: Union[Unset, str] = UNSET,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Union[Unset, List[int]] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Union[Unset, OrgsOrgCodespacesSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/orgs/{org}/codespaces/secrets/{secret_name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgCodespacesSecretsSecretNamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: OrgsOrgCodespacesSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Unset = UNSET,
        encrypted_value: Union[Unset, str] = UNSET,
        key_id: Union[Unset, str] = UNSET,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Union[Unset, List[int]] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Union[Unset, OrgsOrgCodespacesSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/orgs/{org}/codespaces/secrets/{secret_name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgCodespacesSecretsSecretNamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def delete_org_secret(
        self,
        org: str,
        secret_name: str,
    ) -> "Response":
        url = f"/orgs/{org}/codespaces/secrets/{secret_name}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_org_secret(
        self,
        org: str,
        secret_name: str,
    ) -> "Response":
        url = f"/orgs/{org}/codespaces/secrets/{secret_name}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
            },
        )

    def list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200]":
        url = f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        page: Union[Unset, int] = 1,
        per_page: Union[Unset, int] = 30,
    ) -> "Response[OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200]":
        url = f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Unset = UNSET,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Union[
            Unset, OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Unset = UNSET,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Union[
            Unset, OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "404": BasicError,
            },
        )

    def add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
    ) -> "Response":
        url = (
            f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}"
        )

        return self._github.request(
            "PUT",
            url,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
    ) -> "Response":
        url = (
            f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}"
        )

        return await self._github.arequest(
            "PUT",
            url,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
    ) -> "Response":
        url = (
            f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}"
        )

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
    ) -> "Response":
        url = (
            f"/orgs/{org}/codespaces/secrets/{secret_name}/repositories/{repository_id}"
        )

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_codespaces_for_user_in_org(
        self,
        org: str,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgMembersUsernameCodespacesGetResponse200]":
        url = f"/orgs/{org}/members/{username}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgMembersUsernameCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_codespaces_for_user_in_org(
        self,
        org: str,
        username: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[OrgsOrgMembersUsernameCodespacesGetResponse200]":
        url = f"/orgs/{org}/members/{username}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=OrgsOrgMembersUsernameCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete_from_organization(
        self,
        org: str,
        username: str,
        codespace_name: str,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/orgs/{org}/members/{username}/codespaces/{codespace_name}"

        return self._github.request(
            "DELETE",
            url,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_from_organization(
        self,
        org: str,
        username: str,
        codespace_name: str,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/orgs/{org}/members/{username}/codespaces/{codespace_name}"

        return await self._github.arequest(
            "DELETE",
            url,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def stop_in_organization(
        self,
        org: str,
        username: str,
        codespace_name: str,
    ) -> "Response[Codespace]":
        url = f"/orgs/{org}/members/{username}/codespaces/{codespace_name}/stop"

        return self._github.request(
            "POST",
            url,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_stop_in_organization(
        self,
        org: str,
        username: str,
        codespace_name: str,
    ) -> "Response[Codespace]":
        url = f"/orgs/{org}/members/{username}/codespaces/{codespace_name}/stop"

        return await self._github.arequest(
            "POST",
            url,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_in_repository_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoCodespacesGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_in_repository_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoCodespacesGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[ReposOwnerRepoCodespacesPostBodyType, None],
    ) -> "Response[Codespace]":
        ...

    @overload
    def create_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        ref: Union[Unset, str] = UNSET,
        location: Union[Unset, str] = UNSET,
        client_ip: Union[Unset, str] = UNSET,
        machine: Union[Unset, str] = UNSET,
        devcontainer_path: Union[Unset, str] = UNSET,
        multi_repo_permissions_opt_out: Union[Unset, bool] = UNSET,
        working_directory: Union[Unset, str] = UNSET,
        idle_timeout_minutes: Union[Unset, int] = UNSET,
        display_name: Union[Unset, str] = UNSET,
        retention_period_minutes: Union[Unset, int] = UNSET,
    ) -> "Response[Codespace]":
        ...

    def create_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, Union[ReposOwnerRepoCodespacesPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> "Response[Codespace]":
        url = f"/repos/{owner}/{repo}/codespaces"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Union[ReposOwnerRepoCodespacesPostBody, None], json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Codespace,
            error_models={
                "400": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[ReposOwnerRepoCodespacesPostBodyType, None],
    ) -> "Response[Codespace]":
        ...

    @overload
    async def async_create_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        data: Unset = UNSET,
        ref: Union[Unset, str] = UNSET,
        location: Union[Unset, str] = UNSET,
        client_ip: Union[Unset, str] = UNSET,
        machine: Union[Unset, str] = UNSET,
        devcontainer_path: Union[Unset, str] = UNSET,
        multi_repo_permissions_opt_out: Union[Unset, bool] = UNSET,
        working_directory: Union[Unset, str] = UNSET,
        idle_timeout_minutes: Union[Unset, int] = UNSET,
        display_name: Union[Unset, str] = UNSET,
        retention_period_minutes: Union[Unset, int] = UNSET,
    ) -> "Response[Codespace]":
        ...

    async def async_create_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        data: Union[Unset, Union[ReposOwnerRepoCodespacesPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> "Response[Codespace]":
        url = f"/repos/{owner}/{repo}/codespaces"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(Union[ReposOwnerRepoCodespacesPostBody, None], json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Codespace,
            error_models={
                "400": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_devcontainers_in_repository_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoCodespacesDevcontainersGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/devcontainers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCodespacesDevcontainersGetResponse200,
            error_models={
                "500": BasicError,
                "400": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_devcontainers_in_repository_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoCodespacesDevcontainersGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/devcontainers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCodespacesDevcontainersGetResponse200,
            error_models={
                "500": BasicError,
                "400": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def repo_machines_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        location: Union[Unset, str] = UNSET,
        client_ip: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoCodespacesMachinesGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/machines"

        params = {
            "location": location,
            "client_ip": client_ip,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCodespacesMachinesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_repo_machines_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        location: Union[Unset, str] = UNSET,
        client_ip: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoCodespacesMachinesGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/machines"

        params = {
            "location": location,
            "client_ip": client_ip,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCodespacesMachinesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def pre_flight_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        ref: Union[Unset, str] = UNSET,
        client_ip: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoCodespacesNewGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/new"

        params = {
            "ref": ref,
            "client_ip": client_ip,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCodespacesNewGetResponse200,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_pre_flight_with_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        ref: Union[Unset, str] = UNSET,
        client_ip: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoCodespacesNewGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/new"

        params = {
            "ref": ref,
            "client_ip": client_ip,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCodespacesNewGetResponse200,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_repo_secrets(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoCodespacesSecretsGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCodespacesSecretsGetResponse200,
        )

    async def async_list_repo_secrets(
        self,
        owner: str,
        repo: str,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[ReposOwnerRepoCodespacesSecretsGetResponse200]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=ReposOwnerRepoCodespacesSecretsGetResponse200,
        )

    def get_repo_public_key(
        self,
        owner: str,
        repo: str,
    ) -> "Response[CodespacesPublicKey]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/public-key"

        return self._github.request(
            "GET",
            url,
            response_model=CodespacesPublicKey,
        )

    async def async_get_repo_public_key(
        self,
        owner: str,
        repo: str,
    ) -> "Response[CodespacesPublicKey]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/public-key"

        return await self._github.arequest(
            "GET",
            url,
            response_model=CodespacesPublicKey,
        )

    def get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
    ) -> "Response[RepoCodespacesSecret]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        return self._github.request(
            "GET",
            url,
            response_model=RepoCodespacesSecret,
        )

    async def async_get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
    ) -> "Response[RepoCodespacesSecret]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=RepoCodespacesSecret,
        )

    @overload
    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: ReposOwnerRepoCodespacesSecretsSecretNamePutBodyType,
    ) -> "Response[ReposOwnerRepoCodespacesSecretsSecretNamePutResponse201]":
        ...

    @overload
    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: Unset = UNSET,
        encrypted_value: Union[Unset, str] = UNSET,
        key_id: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoCodespacesSecretsSecretNamePutResponse201]":
        ...

    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: Union[
            Unset, ReposOwnerRepoCodespacesSecretsSecretNamePutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[ReposOwnerRepoCodespacesSecretsSecretNamePutResponse201]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoCodespacesSecretsSecretNamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ReposOwnerRepoCodespacesSecretsSecretNamePutResponse201,
        )

    @overload
    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: ReposOwnerRepoCodespacesSecretsSecretNamePutBodyType,
    ) -> "Response[ReposOwnerRepoCodespacesSecretsSecretNamePutResponse201]":
        ...

    @overload
    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: Unset = UNSET,
        encrypted_value: Union[Unset, str] = UNSET,
        key_id: Union[Unset, str] = UNSET,
    ) -> "Response[ReposOwnerRepoCodespacesSecretsSecretNamePutResponse201]":
        ...

    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: Union[
            Unset, ReposOwnerRepoCodespacesSecretsSecretNamePutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[ReposOwnerRepoCodespacesSecretsSecretNamePutResponse201]":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(ReposOwnerRepoCodespacesSecretsSecretNamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=ReposOwnerRepoCodespacesSecretsSecretNamePutResponse201,
        )

    def delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/codespaces/secrets/{secret_name}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    @overload
    def create_with_pr_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Union[ReposOwnerRepoPullsPullNumberCodespacesPostBodyType, None],
    ) -> "Response[Codespace]":
        ...

    @overload
    def create_with_pr_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Unset = UNSET,
        location: Union[Unset, str] = UNSET,
        client_ip: Union[Unset, str] = UNSET,
        machine: Union[Unset, str] = UNSET,
        devcontainer_path: Union[Unset, str] = UNSET,
        multi_repo_permissions_opt_out: Union[Unset, bool] = UNSET,
        working_directory: Union[Unset, str] = UNSET,
        idle_timeout_minutes: Union[Unset, int] = UNSET,
        display_name: Union[Unset, str] = UNSET,
        retention_period_minutes: Union[Unset, int] = UNSET,
    ) -> "Response[Codespace]":
        ...

    def create_with_pr_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Union[
            Unset, Union[ReposOwnerRepoPullsPullNumberCodespacesPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[Codespace]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/codespaces"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[ReposOwnerRepoPullsPullNumberCodespacesPostBody, None], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_with_pr_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Union[ReposOwnerRepoPullsPullNumberCodespacesPostBodyType, None],
    ) -> "Response[Codespace]":
        ...

    @overload
    async def async_create_with_pr_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Unset = UNSET,
        location: Union[Unset, str] = UNSET,
        client_ip: Union[Unset, str] = UNSET,
        machine: Union[Unset, str] = UNSET,
        devcontainer_path: Union[Unset, str] = UNSET,
        multi_repo_permissions_opt_out: Union[Unset, bool] = UNSET,
        working_directory: Union[Unset, str] = UNSET,
        idle_timeout_minutes: Union[Unset, int] = UNSET,
        display_name: Union[Unset, str] = UNSET,
        retention_period_minutes: Union[Unset, int] = UNSET,
    ) -> "Response[Codespace]":
        ...

    async def async_create_with_pr_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Union[
            Unset, Union[ReposOwnerRepoPullsPullNumberCodespacesPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[Codespace]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/codespaces"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[ReposOwnerRepoPullsPullNumberCodespacesPostBody, None], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        repository_id: Union[Unset, int] = UNSET,
    ) -> "Response[UserCodespacesGetResponse200]":
        url = "/user/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
            "repository_id": repository_id,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=UserCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
        repository_id: Union[Unset, int] = UNSET,
    ) -> "Response[UserCodespacesGetResponse200]":
        url = "/user/codespaces"

        params = {
            "per_page": per_page,
            "page": page,
            "repository_id": repository_id,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=UserCodespacesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_for_authenticated_user(
        self,
        *,
        data: Union[UserCodespacesPostBodyOneof0Type, UserCodespacesPostBodyOneof1Type],
    ) -> "Response[Codespace]":
        ...

    @overload
    def create_for_authenticated_user(
        self,
        *,
        data: Unset = UNSET,
        repository_id: int,
        ref: Union[Unset, str] = UNSET,
        location: Union[Unset, str] = UNSET,
        client_ip: Union[Unset, str] = UNSET,
        machine: Union[Unset, str] = UNSET,
        devcontainer_path: Union[Unset, str] = UNSET,
        multi_repo_permissions_opt_out: Union[Unset, bool] = UNSET,
        working_directory: Union[Unset, str] = UNSET,
        idle_timeout_minutes: Union[Unset, int] = UNSET,
        display_name: Union[Unset, str] = UNSET,
        retention_period_minutes: Union[Unset, int] = UNSET,
    ) -> "Response[Codespace]":
        ...

    @overload
    def create_for_authenticated_user(
        self,
        *,
        data: Unset = UNSET,
        pull_request: UserCodespacesPostBodyOneof1PropPullRequestType,
        location: Union[Unset, str] = UNSET,
        machine: Union[Unset, str] = UNSET,
        devcontainer_path: Union[Unset, str] = UNSET,
        working_directory: Union[Unset, str] = UNSET,
        idle_timeout_minutes: Union[Unset, int] = UNSET,
    ) -> "Response[Codespace]":
        ...

    def create_for_authenticated_user(
        self,
        *,
        data: Union[
            Unset,
            Union[UserCodespacesPostBodyOneof0Type, UserCodespacesPostBodyOneof1Type],
        ] = UNSET,
        **kwargs,
    ) -> "Response[Codespace]":
        url = "/user/codespaces"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[UserCodespacesPostBodyOneof0, UserCodespacesPostBodyOneof1], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        data: Union[UserCodespacesPostBodyOneof0Type, UserCodespacesPostBodyOneof1Type],
    ) -> "Response[Codespace]":
        ...

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        data: Unset = UNSET,
        repository_id: int,
        ref: Union[Unset, str] = UNSET,
        location: Union[Unset, str] = UNSET,
        client_ip: Union[Unset, str] = UNSET,
        machine: Union[Unset, str] = UNSET,
        devcontainer_path: Union[Unset, str] = UNSET,
        multi_repo_permissions_opt_out: Union[Unset, bool] = UNSET,
        working_directory: Union[Unset, str] = UNSET,
        idle_timeout_minutes: Union[Unset, int] = UNSET,
        display_name: Union[Unset, str] = UNSET,
        retention_period_minutes: Union[Unset, int] = UNSET,
    ) -> "Response[Codespace]":
        ...

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        data: Unset = UNSET,
        pull_request: UserCodespacesPostBodyOneof1PropPullRequestType,
        location: Union[Unset, str] = UNSET,
        machine: Union[Unset, str] = UNSET,
        devcontainer_path: Union[Unset, str] = UNSET,
        working_directory: Union[Unset, str] = UNSET,
        idle_timeout_minutes: Union[Unset, int] = UNSET,
    ) -> "Response[Codespace]":
        ...

    async def async_create_for_authenticated_user(
        self,
        *,
        data: Union[
            Unset,
            Union[UserCodespacesPostBodyOneof0Type, UserCodespacesPostBodyOneof1Type],
        ] = UNSET,
        **kwargs,
    ) -> "Response[Codespace]":
        url = "/user/codespaces"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(
            Union[UserCodespacesPostBodyOneof0, UserCodespacesPostBodyOneof1], json
        )
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_secrets_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[UserCodespacesSecretsGetResponse200]":
        url = "/user/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=UserCodespacesSecretsGetResponse200,
        )

    async def async_list_secrets_for_authenticated_user(
        self,
        per_page: Union[Unset, int] = 30,
        page: Union[Unset, int] = 1,
    ) -> "Response[UserCodespacesSecretsGetResponse200]":
        url = "/user/codespaces/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            response_model=UserCodespacesSecretsGetResponse200,
        )

    def get_public_key_for_authenticated_user(
        self,
    ) -> "Response[CodespacesUserPublicKey]":
        url = "/user/codespaces/secrets/public-key"

        return self._github.request(
            "GET",
            url,
            response_model=CodespacesUserPublicKey,
        )

    async def async_get_public_key_for_authenticated_user(
        self,
    ) -> "Response[CodespacesUserPublicKey]":
        url = "/user/codespaces/secrets/public-key"

        return await self._github.arequest(
            "GET",
            url,
            response_model=CodespacesUserPublicKey,
        )

    def get_secret_for_authenticated_user(
        self,
        secret_name: str,
    ) -> "Response[CodespacesSecret]":
        url = f"/user/codespaces/secrets/{secret_name}"

        return self._github.request(
            "GET",
            url,
            response_model=CodespacesSecret,
        )

    async def async_get_secret_for_authenticated_user(
        self,
        secret_name: str,
    ) -> "Response[CodespacesSecret]":
        url = f"/user/codespaces/secrets/{secret_name}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=CodespacesSecret,
        )

    @overload
    def create_or_update_secret_for_authenticated_user(
        self, secret_name: str, *, data: UserCodespacesSecretsSecretNamePutBodyType
    ) -> "Response[UserCodespacesSecretsSecretNamePutResponse201]":
        ...

    @overload
    def create_or_update_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        data: Unset = UNSET,
        encrypted_value: Union[Unset, str] = UNSET,
        key_id: str,
        selected_repository_ids: Union[Unset, List[str]] = UNSET,
    ) -> "Response[UserCodespacesSecretsSecretNamePutResponse201]":
        ...

    def create_or_update_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        data: Union[Unset, UserCodespacesSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[UserCodespacesSecretsSecretNamePutResponse201]":
        url = f"/user/codespaces/secrets/{secret_name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserCodespacesSecretsSecretNamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=UserCodespacesSecretsSecretNamePutResponse201,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_or_update_secret_for_authenticated_user(
        self, secret_name: str, *, data: UserCodespacesSecretsSecretNamePutBodyType
    ) -> "Response[UserCodespacesSecretsSecretNamePutResponse201]":
        ...

    @overload
    async def async_create_or_update_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        data: Unset = UNSET,
        encrypted_value: Union[Unset, str] = UNSET,
        key_id: str,
        selected_repository_ids: Union[Unset, List[str]] = UNSET,
    ) -> "Response[UserCodespacesSecretsSecretNamePutResponse201]":
        ...

    async def async_create_or_update_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        data: Union[Unset, UserCodespacesSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[UserCodespacesSecretsSecretNamePutResponse201]":
        url = f"/user/codespaces/secrets/{secret_name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserCodespacesSecretsSecretNamePutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            response_model=UserCodespacesSecretsSecretNamePutResponse201,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def delete_secret_for_authenticated_user(
        self,
        secret_name: str,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}"

        return self._github.request(
            "DELETE",
            url,
        )

    async def async_delete_secret_for_authenticated_user(
        self,
        secret_name: str,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}"

        return await self._github.arequest(
            "DELETE",
            url,
        )

    def list_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
    ) -> "Response[UserCodespacesSecretsSecretNameRepositoriesGetResponse200]":
        url = f"/user/codespaces/secrets/{secret_name}/repositories"

        return self._github.request(
            "GET",
            url,
            response_model=UserCodespacesSecretsSecretNameRepositoriesGetResponse200,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_list_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
    ) -> "Response[UserCodespacesSecretsSecretNameRepositoriesGetResponse200]":
        url = f"/user/codespaces/secrets/{secret_name}/repositories"

        return await self._github.arequest(
            "GET",
            url,
            response_model=UserCodespacesSecretsSecretNameRepositoriesGetResponse200,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def set_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        data: UserCodespacesSecretsSecretNameRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        data: Unset = UNSET,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    def set_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        data: Union[
            Unset, UserCodespacesSecretsSecretNameRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}/repositories"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserCodespacesSecretsSecretNameRepositoriesPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_set_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        data: UserCodespacesSecretsSecretNameRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        data: Unset = UNSET,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    async def async_set_repositories_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        *,
        data: Union[
            Unset, UserCodespacesSecretsSecretNameRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}/repositories"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserCodespacesSecretsSecretNameRepositoriesPutBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    def add_repository_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        repository_id: int,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}/repositories/{repository_id}"

        return self._github.request(
            "PUT",
            url,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_add_repository_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        repository_id: int,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}/repositories/{repository_id}"

        return await self._github.arequest(
            "PUT",
            url,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    def remove_repository_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        repository_id: int,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}/repositories/{repository_id}"

        return self._github.request(
            "DELETE",
            url,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_remove_repository_for_secret_for_authenticated_user(
        self,
        secret_name: str,
        repository_id: int,
    ) -> "Response":
        url = f"/user/codespaces/secrets/{secret_name}/repositories/{repository_id}"

        return await self._github.arequest(
            "DELETE",
            url,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}"

        return self._github.request(
            "GET",
            url,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/user/codespaces/{codespace_name}"

        return self._github.request(
            "DELETE",
            url,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/user/codespaces/{codespace_name}"

        return await self._github.arequest(
            "DELETE",
            url,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        data: Union[Unset, UserCodespacesCodespaceNamePatchBodyType] = UNSET,
    ) -> "Response[Codespace]":
        ...

    @overload
    def update_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        data: Unset = UNSET,
        machine: Union[Unset, str] = UNSET,
        display_name: Union[Unset, str] = UNSET,
        recent_folders: Union[Unset, List[str]] = UNSET,
    ) -> "Response[Codespace]":
        ...

    def update_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        data: Union[Unset, UserCodespacesCodespaceNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserCodespacesCodespaceNamePatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        data: Union[Unset, UserCodespacesCodespaceNamePatchBodyType] = UNSET,
    ) -> "Response[Codespace]":
        ...

    @overload
    async def async_update_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        data: Unset = UNSET,
        machine: Union[Unset, str] = UNSET,
        display_name: Union[Unset, str] = UNSET,
        recent_folders: Union[Unset, List[str]] = UNSET,
    ) -> "Response[Codespace]":
        ...

    async def async_update_for_authenticated_user(
        self,
        codespace_name: str,
        *,
        data: Union[Unset, UserCodespacesCodespaceNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}"

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = parse_obj_as(UserCodespacesCodespaceNamePatchBody, json)
        json = json.dict(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            response_model=Codespace,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def export_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[CodespaceExportDetails]":
        url = f"/user/codespaces/{codespace_name}/exports"

        return self._github.request(
            "POST",
            url,
            response_model=CodespaceExportDetails,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_export_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[CodespaceExportDetails]":
        url = f"/user/codespaces/{codespace_name}/exports"

        return await self._github.arequest(
            "POST",
            url,
            response_model=CodespaceExportDetails,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_export_details_for_authenticated_user(
        self,
        codespace_name: str,
        export_id: str,
    ) -> "Response[CodespaceExportDetails]":
        url = f"/user/codespaces/{codespace_name}/exports/{export_id}"

        return self._github.request(
            "GET",
            url,
            response_model=CodespaceExportDetails,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_export_details_for_authenticated_user(
        self,
        codespace_name: str,
        export_id: str,
    ) -> "Response[CodespaceExportDetails]":
        url = f"/user/codespaces/{codespace_name}/exports/{export_id}"

        return await self._github.arequest(
            "GET",
            url,
            response_model=CodespaceExportDetails,
            error_models={
                "404": BasicError,
            },
        )

    def codespace_machines_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[UserCodespacesCodespaceNameMachinesGetResponse200]":
        url = f"/user/codespaces/{codespace_name}/machines"

        return self._github.request(
            "GET",
            url,
            response_model=UserCodespacesCodespaceNameMachinesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_codespace_machines_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[UserCodespacesCodespaceNameMachinesGetResponse200]":
        url = f"/user/codespaces/{codespace_name}/machines"

        return await self._github.arequest(
            "GET",
            url,
            response_model=UserCodespacesCodespaceNameMachinesGetResponse200,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def start_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}/start"

        return self._github.request(
            "POST",
            url,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "400": BasicError,
                "401": BasicError,
                "402": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_start_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}/start"

        return await self._github.arequest(
            "POST",
            url,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "400": BasicError,
                "401": BasicError,
                "402": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    def stop_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}/stop"

        return self._github.request(
            "POST",
            url,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_stop_for_authenticated_user(
        self,
        codespace_name: str,
    ) -> "Response[Codespace]":
        url = f"/user/codespaces/{codespace_name}/stop"

        return await self._github.arequest(
            "POST",
            url,
            response_model=Codespace,
            error_models={
                "500": BasicError,
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )
