"""DO NOT EDIT THIS FILE!

This file is auto generated by github rest api description.
See https://github.com/github/rest-api-description for more information.
"""


from __future__ import annotations

from datetime import date, datetime
from typing import Any, List, Union, Literal

from pydantic import Extra, Field, BaseModel

from githubkit.utils import UNSET, Unset


class GitHubRestModel(
    BaseModel, extra=Extra.allow, allow_population_by_field_name=True
):
    ...


class Root(GitHubRestModel):
    """Root"""

    current_user_url: str = Field(default=...)
    current_user_authorizations_html_url: str = Field(default=...)
    authorizations_url: str = Field(default=...)
    code_search_url: str = Field(default=...)
    commit_search_url: str = Field(default=...)
    emails_url: str = Field(default=...)
    emojis_url: str = Field(default=...)
    events_url: str = Field(default=...)
    feeds_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    hub_url: str = Field(default=...)
    issue_search_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    keys_url: str = Field(default=...)
    label_search_url: str = Field(default=...)
    notifications_url: str = Field(default=...)
    organization_url: str = Field(default=...)
    organization_repositories_url: str = Field(default=...)
    organization_teams_url: str = Field(default=...)
    public_gists_url: str = Field(default=...)
    rate_limit_url: str = Field(default=...)
    repository_url: str = Field(default=...)
    repository_search_url: str = Field(default=...)
    current_user_repositories_url: str = Field(default=...)
    starred_url: str = Field(default=...)
    starred_gists_url: str = Field(default=...)
    topic_search_url: Union[Unset, str] = Field(default=UNSET)
    user_url: str = Field(default=...)
    user_organizations_url: str = Field(default=...)
    user_repositories_url: str = Field(default=...)
    user_search_url: str = Field(default=...)


class SimpleUser(GitHubRestModel):
    """Simple User

    Simple User
    """

    name: Union[Unset, Union[str, None]] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    login: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    avatar_url: str = Field(default=...)
    gravatar_id: Union[str, None] = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    organizations_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    type: str = Field(default=...)
    site_admin: bool = Field(default=...)
    starred_at: Union[Unset, str] = Field(default=UNSET)


class Integration(GitHubRestModel):
    """GitHub app

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    id: int = Field(description="Unique identifier of the GitHub app", default=...)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    node_id: str = Field(default=...)
    owner: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    description: Union[str, None] = Field(default=...)
    external_url: str = Field(default=...)
    html_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    permissions: IntegrationPropPermissions = Field(
        description="The set of permissions for the GitHub app", default=...
    )
    events: List[str] = Field(
        description="The list of events for the GitHub app", default=...
    )
    installations_count: Union[Unset, int] = Field(
        description="The number of installations associated with the GitHub app",
        default=UNSET,
    )
    client_id: Union[Unset, str] = Field(default=UNSET)
    client_secret: Union[Unset, str] = Field(default=UNSET)
    webhook_secret: Union[Unset, Union[str, None]] = Field(default=UNSET)
    pem: Union[Unset, str] = Field(default=UNSET)


class IntegrationPropPermissions(GitHubRestModel, extra=Extra.allow):
    """IntegrationPropPermissions

    The set of permissions for the GitHub app

    Examples:
        {'issues': 'read', 'deployments': 'write'}
    """

    issues: Union[Unset, str] = Field(default=UNSET)
    checks: Union[Unset, str] = Field(default=UNSET)
    metadata: Union[Unset, str] = Field(default=UNSET)
    contents: Union[Unset, str] = Field(default=UNSET)
    deployments: Union[Unset, str] = Field(default=UNSET)


class BasicError(GitHubRestModel):
    """Basic Error

    Basic Error
    """

    message: Union[Unset, str] = Field(default=UNSET)
    documentation_url: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    status: Union[Unset, str] = Field(default=UNSET)


class ValidationErrorSimple(GitHubRestModel):
    """Validation Error Simple

    Validation Error Simple
    """

    message: str = Field(default=...)
    documentation_url: str = Field(default=...)
    errors: Union[Unset, List[str]] = Field(default=UNSET)


class WebhookConfig(GitHubRestModel):
    """Webhook Configuration

    Configuration object of the webhook
    """

    url: Union[Unset, str] = Field(
        description="The URL to which the payloads will be delivered.", default=UNSET
    )
    content_type: Union[Unset, str] = Field(
        description="The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.",
        default=UNSET,
    )
    secret: Union[Unset, str] = Field(
        description="If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).",
        default=UNSET,
    )
    insecure_ssl: Union[Unset, Union[str, float]] = Field(
        description="Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**",
        default=UNSET,
    )


class HookDeliveryItem(GitHubRestModel):
    """Simple webhook delivery

    Delivery made by a webhook, without request and response information.
    """

    id: int = Field(
        description="Unique identifier of the webhook delivery.", default=...
    )
    guid: str = Field(
        description="Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).",
        default=...,
    )
    delivered_at: datetime = Field(
        description="Time when the webhook delivery occurred.", default=...
    )
    redelivery: bool = Field(
        description="Whether the webhook delivery is a redelivery.", default=...
    )
    duration: float = Field(description="Time spent delivering.", default=...)
    status: str = Field(
        description="Describes the response returned after attempting the delivery.",
        default=...,
    )
    status_code: int = Field(
        description="Status code received when delivery was made.", default=...
    )
    event: str = Field(
        description="The event that triggered the delivery.", default=...
    )
    action: Union[str, None] = Field(
        description="The type of activity for the event that triggered the delivery.",
        default=...,
    )
    installation_id: Union[int, None] = Field(
        description="The id of the GitHub App installation associated with this event.",
        default=...,
    )
    repository_id: Union[int, None] = Field(
        description="The id of the repository associated with this event.", default=...
    )


class ScimError(GitHubRestModel):
    """Scim Error

    Scim Error
    """

    message: Union[Unset, Union[str, None]] = Field(default=UNSET)
    documentation_url: Union[Unset, Union[str, None]] = Field(default=UNSET)
    detail: Union[Unset, Union[str, None]] = Field(default=UNSET)
    status: Union[Unset, int] = Field(default=UNSET)
    scim_type: Union[Unset, Union[str, None]] = Field(default=UNSET, alias="scimType")
    schemas: Union[Unset, List[str]] = Field(default=UNSET)


class ValidationError(GitHubRestModel):
    """Validation Error

    Validation Error
    """

    message: str = Field(default=...)
    documentation_url: str = Field(default=...)
    errors: Union[Unset, List[ValidationErrorPropErrorsItems]] = Field(default=UNSET)


class ValidationErrorPropErrorsItems(GitHubRestModel):
    """ValidationErrorPropErrorsItems"""

    resource: Union[Unset, str] = Field(default=UNSET)
    field: Union[Unset, str] = Field(default=UNSET)
    message: Union[Unset, str] = Field(default=UNSET)
    code: str = Field(default=...)
    index: Union[Unset, int] = Field(default=UNSET)
    value: Union[Unset, Union[str, None, int, None, List[str], None]] = Field(
        default=UNSET
    )


class HookDelivery(GitHubRestModel):
    """Webhook delivery

    Delivery made by a webhook.
    """

    id: int = Field(description="Unique identifier of the delivery.", default=...)
    guid: str = Field(
        description="Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).",
        default=...,
    )
    delivered_at: datetime = Field(
        description="Time when the delivery was delivered.", default=...
    )
    redelivery: bool = Field(
        description="Whether the delivery is a redelivery.", default=...
    )
    duration: float = Field(description="Time spent delivering.", default=...)
    status: str = Field(
        description="Description of the status of the attempted delivery", default=...
    )
    status_code: int = Field(
        description="Status code received when delivery was made.", default=...
    )
    event: str = Field(
        description="The event that triggered the delivery.", default=...
    )
    action: Union[str, None] = Field(
        description="The type of activity for the event that triggered the delivery.",
        default=...,
    )
    installation_id: Union[int, None] = Field(
        description="The id of the GitHub App installation associated with this event.",
        default=...,
    )
    repository_id: Union[int, None] = Field(
        description="The id of the repository associated with this event.", default=...
    )
    url: Union[Unset, str] = Field(
        description="The URL target of the delivery.", default=UNSET
    )
    request: HookDeliveryPropRequest = Field(default=...)
    response: HookDeliveryPropResponse = Field(default=...)


class HookDeliveryPropRequest(GitHubRestModel):
    """HookDeliveryPropRequest"""

    headers: Union[HookDeliveryPropRequestPropHeaders, None] = Field(
        description="The request headers sent with the webhook delivery.", default=...
    )
    payload: Union[HookDeliveryPropRequestPropPayload, None] = Field(
        description="The webhook payload.", default=...
    )


class HookDeliveryPropRequestPropHeaders(GitHubRestModel, extra=Extra.allow):
    """HookDeliveryPropRequestPropHeaders

    The request headers sent with the webhook delivery.
    """


class HookDeliveryPropRequestPropPayload(GitHubRestModel, extra=Extra.allow):
    """HookDeliveryPropRequestPropPayload

    The webhook payload.
    """


class HookDeliveryPropResponse(GitHubRestModel):
    """HookDeliveryPropResponse"""

    headers: Union[HookDeliveryPropResponsePropHeaders, None] = Field(
        description="The response headers received when the delivery was made.",
        default=...,
    )
    payload: Union[str, None] = Field(
        description="The response payload received.", default=...
    )


class HookDeliveryPropResponsePropHeaders(GitHubRestModel, extra=Extra.allow):
    """HookDeliveryPropResponsePropHeaders

    The response headers received when the delivery was made.
    """


class Enterprise(GitHubRestModel):
    """Enterprise

    An enterprise account
    """

    description: Union[Unset, Union[str, None]] = Field(
        description="A short description of the enterprise.", default=UNSET
    )
    html_url: str = Field(default=...)
    website_url: Union[Unset, Union[str, None]] = Field(
        description="The enterprise's website URL.", default=UNSET
    )
    id: int = Field(description="Unique identifier of the enterprise", default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the enterprise.", default=...)
    slug: str = Field(
        description="The slug url identifier for the enterprise.", default=...
    )
    created_at: Union[datetime, None] = Field(default=...)
    updated_at: Union[datetime, None] = Field(default=...)
    avatar_url: str = Field(default=...)


class AppPermissions(GitHubRestModel):
    """App Permissions

    The permissions granted to the user-to-server access token.

    Examples:
        {'contents': 'read', 'issues': 'read', 'deployments': 'write', 'single_file':
    'read'}
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts.",
        default=UNSET,
    )
    administration: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation.",
        default=UNSET,
    )
    checks: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for checks on code.",
        default=UNSET,
    )
    contents: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges.",
        default=UNSET,
    )
    deployments: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for deployments and deployment statuses.",
        default=UNSET,
    )
    environments: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for managing repository environments.",
        default=UNSET,
    )
    issues: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones.",
        default=UNSET,
    )
    metadata: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata.",
        default=UNSET,
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for packages published to GitHub Packages.",
        default=UNSET,
    )
    pages: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.",
        default=UNSET,
    )
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges.",
        default=UNSET,
    )
    repository_announcement_banners: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to view and manage announcement banners for a repository.",
        default=UNSET,
    )
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to manage the post-receive hooks for a repository.",
        default=UNSET,
    )
    repository_projects: Union[Unset, Literal["read", "write", "admin"]] = Field(
        description="The level of permission to grant the access token to manage repository projects, columns, and cards.",
        default=UNSET,
    )
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to view and manage secret scanning alerts.",
        default=UNSET,
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to manage repository secrets.",
        default=UNSET,
    )
    security_events: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to view and manage security events like code scanning alerts.",
        default=UNSET,
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to manage just a single file.",
        default=UNSET,
    )
    statuses: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for commit statuses.",
        default=UNSET,
    )
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to manage Dependabot alerts.",
        default=UNSET,
    )
    workflows: Union[Unset, Literal["write"]] = Field(
        description="The level of permission to grant the access token to update GitHub Actions workflow files.",
        default=UNSET,
    )
    members: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for organization teams and members.",
        default=UNSET,
    )
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to manage access to an organization.",
        default=UNSET,
    )
    organization_custom_roles: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for custom roles management. This property is in beta and is subject to change.",
        default=UNSET,
    )
    organization_announcement_banners: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to view and manage announcement banners for an organization.",
        default=UNSET,
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to manage the post-receive hooks for an organization.",
        default=UNSET,
    )
    organization_plan: Union[Unset, Literal["read"]] = Field(
        description="The level of permission to grant the access token for viewing an organization's plan.",
        default=UNSET,
    )
    organization_projects: Union[Unset, Literal["read", "write", "admin"]] = Field(
        description="The level of permission to grant the access token to manage organization projects and projects beta (where available).",
        default=UNSET,
    )
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for organization packages published to GitHub Packages.",
        default=UNSET,
    )
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to manage organization secrets.",
        default=UNSET,
    )
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization.",
        default=UNSET,
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to view and manage users blocked by the organization.",
        default=UNSET,
    )
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to manage team discussions and related comments.",
        default=UNSET,
    )


class Installation(GitHubRestModel):
    """Installation

    Installation
    """

    id: int = Field(description="The ID of the installation.", default=...)
    account: Union[SimpleUser, Enterprise, None] = Field(
        title="Enterprise", description="An enterprise account", default=...
    )
    repository_selection: Literal["all", "selected"] = Field(
        description="Describe whether all repositories have been selected or there's a selection involved",
        default=...,
    )
    access_tokens_url: str = Field(default=...)
    repositories_url: str = Field(default=...)
    html_url: str = Field(default=...)
    app_id: int = Field(default=...)
    target_id: int = Field(
        description="The ID of the user or organization this token is being scoped to.",
        default=...,
    )
    target_type: str = Field(default=...)
    permissions: AppPermissions = Field(
        title="App Permissions",
        description="The permissions granted to the user-to-server access token.",
        default=...,
    )
    events: List[str] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    single_file_name: Union[str, None] = Field(default=...)
    has_multiple_single_files: Union[Unset, bool] = Field(default=UNSET)
    single_file_paths: Union[Unset, List[str]] = Field(default=UNSET)
    app_slug: str = Field(default=...)
    suspended_by: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    suspended_at: Union[datetime, None] = Field(default=...)
    contact_email: Union[Unset, Union[str, None]] = Field(default=UNSET)


class LicenseSimple(GitHubRestModel):
    """License Simple

    License Simple
    """

    key: str = Field(default=...)
    name: str = Field(default=...)
    url: Union[str, None] = Field(default=...)
    spdx_id: Union[str, None] = Field(default=...)
    node_id: str = Field(default=...)
    html_url: Union[Unset, str] = Field(default=UNSET)


class Repository(GitHubRestModel):
    """Repository

    A git repository
    """

    id: int = Field(description="Unique identifier of the repository", default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(default=...)
    license_: Union[None, LicenseSimple] = Field(
        title="License Simple",
        description="License Simple",
        default=...,
        alias="license",
    )
    organization: Union[Unset, Union[None, SimpleUser]] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    forks: int = Field(default=...)
    permissions: Union[Unset, RepositoryPropPermissions] = Field(default=UNSET)
    owner: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    private: bool = Field(
        description="Whether the repository is private or public.", default=False
    )
    html_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    fork: bool = Field(default=...)
    url: str = Field(default=...)
    archive_url: str = Field(default=...)
    assignees_url: str = Field(default=...)
    blobs_url: str = Field(default=...)
    branches_url: str = Field(default=...)
    collaborators_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    compare_url: str = Field(default=...)
    contents_url: str = Field(default=...)
    contributors_url: str = Field(default=...)
    deployments_url: str = Field(default=...)
    downloads_url: str = Field(default=...)
    events_url: str = Field(default=...)
    forks_url: str = Field(default=...)
    git_commits_url: str = Field(default=...)
    git_refs_url: str = Field(default=...)
    git_tags_url: str = Field(default=...)
    git_url: str = Field(default=...)
    issue_comment_url: str = Field(default=...)
    issue_events_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    keys_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    languages_url: str = Field(default=...)
    merges_url: str = Field(default=...)
    milestones_url: str = Field(default=...)
    notifications_url: str = Field(default=...)
    pulls_url: str = Field(default=...)
    releases_url: str = Field(default=...)
    ssh_url: str = Field(default=...)
    stargazers_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    subscribers_url: str = Field(default=...)
    subscription_url: str = Field(default=...)
    tags_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    trees_url: str = Field(default=...)
    clone_url: str = Field(default=...)
    mirror_url: Union[str, None] = Field(default=...)
    hooks_url: str = Field(default=...)
    svn_url: str = Field(default=...)
    homepage: Union[str, None] = Field(default=...)
    language: Union[str, None] = Field(default=...)
    forks_count: int = Field(default=...)
    stargazers_count: int = Field(default=...)
    watchers_count: int = Field(default=...)
    size: int = Field(
        description="The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.",
        default=...,
    )
    default_branch: str = Field(
        description="The default branch of the repository.", default=...
    )
    open_issues_count: int = Field(default=...)
    is_template: Union[Unset, bool] = Field(
        description="Whether this repository acts as a template that can be used to generate new repositories.",
        default=False,
    )
    topics: Union[Unset, List[str]] = Field(default=UNSET)
    has_issues: bool = Field(description="Whether issues are enabled.", default=True)
    has_projects: bool = Field(
        description="Whether projects are enabled.", default=True
    )
    has_wiki: bool = Field(description="Whether the wiki is enabled.", default=True)
    has_pages: bool = Field(default=...)
    has_downloads: bool = Field(
        description="Whether downloads are enabled.", default=True
    )
    archived: bool = Field(
        description="Whether the repository is archived.", default=False
    )
    disabled: bool = Field(
        description="Returns whether or not this repository disabled.", default=...
    )
    visibility: Union[Unset, str] = Field(
        description="The repository visibility: public, private, or internal.",
        default="public",
    )
    pushed_at: Union[datetime, None] = Field(default=...)
    created_at: Union[datetime, None] = Field(default=...)
    updated_at: Union[datetime, None] = Field(default=...)
    allow_rebase_merge: Union[Unset, bool] = Field(
        description="Whether to allow rebase merges for pull requests.", default=True
    )
    template_repository: Union[
        Unset, Union[RepositoryPropTemplateRepository, None]
    ] = Field(default=UNSET)
    temp_clone_token: Union[Unset, str] = Field(default=UNSET)
    allow_squash_merge: Union[Unset, bool] = Field(
        description="Whether to allow squash merges for pull requests.", default=True
    )
    allow_auto_merge: Union[Unset, bool] = Field(
        description="Whether to allow Auto-merge to be used on pull requests.",
        default=False,
    )
    delete_branch_on_merge: Union[Unset, bool] = Field(
        description="Whether to delete head branches when pull requests are merged",
        default=False,
    )
    allow_update_branch: Union[Unset, bool] = Field(
        description="Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.",
        default=False,
    )
    use_squash_pr_title_as_default: Union[Unset, bool] = Field(
        description="Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.",
        default=False,
    )
    squash_merge_commit_title: Union[
        Unset, Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
    ] = Field(
        description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
        default=UNSET,
    )
    squash_merge_commit_message: Union[
        Unset, Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    merge_commit_title: Union[Unset, Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        description="The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request's title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
        default=UNSET,
    )
    merge_commit_message: Union[Unset, Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    allow_merge_commit: Union[Unset, bool] = Field(
        description="Whether to allow merge commits for pull requests.", default=True
    )
    allow_forking: Union[Unset, bool] = Field(
        description="Whether to allow forking this repo", default=UNSET
    )
    web_commit_signoff_required: Union[Unset, bool] = Field(
        description="Whether to require contributors to sign off on web-based commits",
        default=False,
    )
    subscribers_count: Union[Unset, int] = Field(default=UNSET)
    network_count: Union[Unset, int] = Field(default=UNSET)
    open_issues: int = Field(default=...)
    watchers: int = Field(default=...)
    master_branch: Union[Unset, str] = Field(default=UNSET)
    starred_at: Union[Unset, str] = Field(default=UNSET)
    anonymous_access_enabled: Union[Unset, bool] = Field(
        description="Whether anonymous git access is enabled for this repository",
        default=UNSET,
    )


class RepositoryPropPermissions(GitHubRestModel):
    """RepositoryPropPermissions"""

    admin: bool = Field(default=...)
    pull: bool = Field(default=...)
    triage: Union[Unset, bool] = Field(default=UNSET)
    push: bool = Field(default=...)
    maintain: Union[Unset, bool] = Field(default=UNSET)


class RepositoryPropTemplateRepositoryPropOwner(GitHubRestModel):
    """RepositoryPropTemplateRepositoryPropOwner"""

    login: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    avatar_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)


class RepositoryPropTemplateRepositoryPropPermissions(GitHubRestModel):
    """RepositoryPropTemplateRepositoryPropPermissions"""

    admin: Union[Unset, bool] = Field(default=UNSET)
    maintain: Union[Unset, bool] = Field(default=UNSET)
    push: Union[Unset, bool] = Field(default=UNSET)
    triage: Union[Unset, bool] = Field(default=UNSET)
    pull: Union[Unset, bool] = Field(default=UNSET)


class RepositoryPropTemplateRepository(GitHubRestModel):
    """RepositoryPropTemplateRepository"""

    id: Union[Unset, int] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    name: Union[Unset, str] = Field(default=UNSET)
    full_name: Union[Unset, str] = Field(default=UNSET)
    owner: Union[Unset, RepositoryPropTemplateRepositoryPropOwner] = Field(
        default=UNSET
    )
    private: Union[Unset, bool] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    description: Union[Unset, str] = Field(default=UNSET)
    fork: Union[Unset, bool] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    archive_url: Union[Unset, str] = Field(default=UNSET)
    assignees_url: Union[Unset, str] = Field(default=UNSET)
    blobs_url: Union[Unset, str] = Field(default=UNSET)
    branches_url: Union[Unset, str] = Field(default=UNSET)
    collaborators_url: Union[Unset, str] = Field(default=UNSET)
    comments_url: Union[Unset, str] = Field(default=UNSET)
    commits_url: Union[Unset, str] = Field(default=UNSET)
    compare_url: Union[Unset, str] = Field(default=UNSET)
    contents_url: Union[Unset, str] = Field(default=UNSET)
    contributors_url: Union[Unset, str] = Field(default=UNSET)
    deployments_url: Union[Unset, str] = Field(default=UNSET)
    downloads_url: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    forks_url: Union[Unset, str] = Field(default=UNSET)
    git_commits_url: Union[Unset, str] = Field(default=UNSET)
    git_refs_url: Union[Unset, str] = Field(default=UNSET)
    git_tags_url: Union[Unset, str] = Field(default=UNSET)
    git_url: Union[Unset, str] = Field(default=UNSET)
    issue_comment_url: Union[Unset, str] = Field(default=UNSET)
    issue_events_url: Union[Unset, str] = Field(default=UNSET)
    issues_url: Union[Unset, str] = Field(default=UNSET)
    keys_url: Union[Unset, str] = Field(default=UNSET)
    labels_url: Union[Unset, str] = Field(default=UNSET)
    languages_url: Union[Unset, str] = Field(default=UNSET)
    merges_url: Union[Unset, str] = Field(default=UNSET)
    milestones_url: Union[Unset, str] = Field(default=UNSET)
    notifications_url: Union[Unset, str] = Field(default=UNSET)
    pulls_url: Union[Unset, str] = Field(default=UNSET)
    releases_url: Union[Unset, str] = Field(default=UNSET)
    ssh_url: Union[Unset, str] = Field(default=UNSET)
    stargazers_url: Union[Unset, str] = Field(default=UNSET)
    statuses_url: Union[Unset, str] = Field(default=UNSET)
    subscribers_url: Union[Unset, str] = Field(default=UNSET)
    subscription_url: Union[Unset, str] = Field(default=UNSET)
    tags_url: Union[Unset, str] = Field(default=UNSET)
    teams_url: Union[Unset, str] = Field(default=UNSET)
    trees_url: Union[Unset, str] = Field(default=UNSET)
    clone_url: Union[Unset, str] = Field(default=UNSET)
    mirror_url: Union[Unset, str] = Field(default=UNSET)
    hooks_url: Union[Unset, str] = Field(default=UNSET)
    svn_url: Union[Unset, str] = Field(default=UNSET)
    homepage: Union[Unset, str] = Field(default=UNSET)
    language: Union[Unset, str] = Field(default=UNSET)
    forks_count: Union[Unset, int] = Field(default=UNSET)
    stargazers_count: Union[Unset, int] = Field(default=UNSET)
    watchers_count: Union[Unset, int] = Field(default=UNSET)
    size: Union[Unset, int] = Field(default=UNSET)
    default_branch: Union[Unset, str] = Field(default=UNSET)
    open_issues_count: Union[Unset, int] = Field(default=UNSET)
    is_template: Union[Unset, bool] = Field(default=UNSET)
    topics: Union[Unset, List[str]] = Field(default=UNSET)
    has_issues: Union[Unset, bool] = Field(default=UNSET)
    has_projects: Union[Unset, bool] = Field(default=UNSET)
    has_wiki: Union[Unset, bool] = Field(default=UNSET)
    has_pages: Union[Unset, bool] = Field(default=UNSET)
    has_downloads: Union[Unset, bool] = Field(default=UNSET)
    archived: Union[Unset, bool] = Field(default=UNSET)
    disabled: Union[Unset, bool] = Field(default=UNSET)
    visibility: Union[Unset, str] = Field(default=UNSET)
    pushed_at: Union[Unset, str] = Field(default=UNSET)
    created_at: Union[Unset, str] = Field(default=UNSET)
    updated_at: Union[Unset, str] = Field(default=UNSET)
    permissions: Union[Unset, RepositoryPropTemplateRepositoryPropPermissions] = Field(
        default=UNSET
    )
    allow_rebase_merge: Union[Unset, bool] = Field(default=UNSET)
    temp_clone_token: Union[Unset, str] = Field(default=UNSET)
    allow_squash_merge: Union[Unset, bool] = Field(default=UNSET)
    allow_auto_merge: Union[Unset, bool] = Field(default=UNSET)
    delete_branch_on_merge: Union[Unset, bool] = Field(default=UNSET)
    allow_update_branch: Union[Unset, bool] = Field(default=UNSET)
    use_squash_pr_title_as_default: Union[Unset, bool] = Field(default=UNSET)
    squash_merge_commit_title: Union[
        Unset, Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
    ] = Field(
        description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
        default=UNSET,
    )
    squash_merge_commit_message: Union[
        Unset, Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    merge_commit_title: Union[Unset, Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        description="The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request's title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
        default=UNSET,
    )
    merge_commit_message: Union[Unset, Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    allow_merge_commit: Union[Unset, bool] = Field(default=UNSET)
    subscribers_count: Union[Unset, int] = Field(default=UNSET)
    network_count: Union[Unset, int] = Field(default=UNSET)


class InstallationToken(GitHubRestModel):
    """Installation Token

    Authentication token for a GitHub App installed on a user or org.
    """

    token: str = Field(default=...)
    expires_at: str = Field(default=...)
    permissions: Union[Unset, AppPermissions] = Field(
        title="App Permissions",
        description="The permissions granted to the user-to-server access token.",
        default=UNSET,
    )
    repository_selection: Union[Unset, Literal["all", "selected"]] = Field(
        default=UNSET
    )
    repositories: Union[Unset, List[Repository]] = Field(default=UNSET)
    single_file: Union[Unset, str] = Field(default=UNSET)
    has_multiple_single_files: Union[Unset, bool] = Field(default=UNSET)
    single_file_paths: Union[Unset, List[str]] = Field(default=UNSET)


class ScopedInstallation(GitHubRestModel):
    """Scoped Installation"""

    permissions: AppPermissions = Field(
        title="App Permissions",
        description="The permissions granted to the user-to-server access token.",
        default=...,
    )
    repository_selection: Literal["all", "selected"] = Field(
        description="Describe whether all repositories have been selected or there's a selection involved",
        default=...,
    )
    single_file_name: Union[str, None] = Field(default=...)
    has_multiple_single_files: Union[Unset, bool] = Field(default=UNSET)
    single_file_paths: Union[Unset, List[str]] = Field(default=UNSET)
    repositories_url: str = Field(default=...)
    account: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class Authorization(GitHubRestModel):
    """Authorization

    The authorization for an OAuth app, GitHub App, or a Personal Access Token.
    """

    id: int = Field(default=...)
    url: str = Field(default=...)
    scopes: Union[List[str], None] = Field(
        description="A list of scopes that this authorization is in.", default=...
    )
    token: str = Field(default=...)
    token_last_eight: Union[str, None] = Field(default=...)
    hashed_token: Union[str, None] = Field(default=...)
    app: AuthorizationPropApp = Field(default=...)
    note: Union[str, None] = Field(default=...)
    note_url: Union[str, None] = Field(default=...)
    updated_at: datetime = Field(default=...)
    created_at: datetime = Field(default=...)
    fingerprint: Union[str, None] = Field(default=...)
    user: Union[Unset, Union[None, SimpleUser]] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    installation: Union[Unset, Union[None, ScopedInstallation]] = Field(
        title="Scoped Installation", default=UNSET
    )
    expires_at: Union[datetime, None] = Field(default=...)


class AuthorizationPropApp(GitHubRestModel):
    """AuthorizationPropApp"""

    client_id: str = Field(default=...)
    name: str = Field(default=...)
    url: str = Field(default=...)


class CodeOfConduct(GitHubRestModel):
    """Code Of Conduct

    Code Of Conduct
    """

    key: str = Field(default=...)
    name: str = Field(default=...)
    url: str = Field(default=...)
    body: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[str, None] = Field(default=...)


class ServerStatisticsItems(GitHubRestModel):
    """ServerStatisticsItems"""

    server_id: Union[Unset, str] = Field(default=UNSET)
    collection_date: Union[Unset, str] = Field(default=UNSET)
    schema_version: Union[Unset, str] = Field(default=UNSET)
    ghes_version: Union[Unset, str] = Field(default=UNSET)
    host_name: Union[Unset, str] = Field(default=UNSET)
    github_connect: Union[Unset, ServerStatisticsItemsPropGithubConnect] = Field(
        default=UNSET
    )
    ghe_stats: Union[Unset, ServerStatisticsItemsPropGheStats] = Field(default=UNSET)
    dormant_users: Union[Unset, ServerStatisticsItemsPropDormantUsers] = Field(
        default=UNSET
    )


class ServerStatisticsItemsPropGithubConnect(GitHubRestModel):
    """ServerStatisticsItemsPropGithubConnect"""

    features_enabled: Union[Unset, List[str]] = Field(default=UNSET)


class ServerStatisticsItemsPropGheStats(GitHubRestModel):
    """ServerStatisticsItemsPropGheStats"""

    comments: Union[Unset, ServerStatisticsItemsPropGheStatsPropComments] = Field(
        default=UNSET
    )
    gists: Union[Unset, ServerStatisticsItemsPropGheStatsPropGists] = Field(
        default=UNSET
    )
    hooks: Union[Unset, ServerStatisticsItemsPropGheStatsPropHooks] = Field(
        default=UNSET
    )
    issues: Union[Unset, ServerStatisticsItemsPropGheStatsPropIssues] = Field(
        default=UNSET
    )
    milestones: Union[Unset, ServerStatisticsItemsPropGheStatsPropMilestones] = Field(
        default=UNSET
    )
    orgs: Union[Unset, ServerStatisticsItemsPropGheStatsPropOrgs] = Field(default=UNSET)
    pages: Union[Unset, ServerStatisticsItemsPropGheStatsPropPages] = Field(
        default=UNSET
    )
    pulls: Union[Unset, ServerStatisticsItemsPropGheStatsPropPulls] = Field(
        default=UNSET
    )
    repos: Union[Unset, ServerStatisticsItemsPropGheStatsPropRepos] = Field(
        default=UNSET
    )
    users: Union[Unset, ServerStatisticsItemsPropGheStatsPropUsers] = Field(
        default=UNSET
    )


class ServerStatisticsItemsPropGheStatsPropComments(GitHubRestModel):
    """ServerStatisticsItemsPropGheStatsPropComments"""

    total_commit_comments: Union[Unset, int] = Field(default=UNSET)
    total_gist_comments: Union[Unset, int] = Field(default=UNSET)
    total_issue_comments: Union[Unset, int] = Field(default=UNSET)
    total_pull_request_comments: Union[Unset, int] = Field(default=UNSET)


class ServerStatisticsItemsPropGheStatsPropGists(GitHubRestModel):
    """ServerStatisticsItemsPropGheStatsPropGists"""

    total_gists: Union[Unset, int] = Field(default=UNSET)
    private_gists: Union[Unset, int] = Field(default=UNSET)
    public_gists: Union[Unset, int] = Field(default=UNSET)


class ServerStatisticsItemsPropGheStatsPropHooks(GitHubRestModel):
    """ServerStatisticsItemsPropGheStatsPropHooks"""

    total_hooks: Union[Unset, int] = Field(default=UNSET)
    active_hooks: Union[Unset, int] = Field(default=UNSET)
    inactive_hooks: Union[Unset, int] = Field(default=UNSET)


class ServerStatisticsItemsPropGheStatsPropIssues(GitHubRestModel):
    """ServerStatisticsItemsPropGheStatsPropIssues"""

    total_issues: Union[Unset, int] = Field(default=UNSET)
    open_issues: Union[Unset, int] = Field(default=UNSET)
    closed_issues: Union[Unset, int] = Field(default=UNSET)


class ServerStatisticsItemsPropGheStatsPropMilestones(GitHubRestModel):
    """ServerStatisticsItemsPropGheStatsPropMilestones"""

    total_milestones: Union[Unset, int] = Field(default=UNSET)
    open_milestones: Union[Unset, int] = Field(default=UNSET)
    closed_milestones: Union[Unset, int] = Field(default=UNSET)


class ServerStatisticsItemsPropGheStatsPropOrgs(GitHubRestModel):
    """ServerStatisticsItemsPropGheStatsPropOrgs"""

    total_orgs: Union[Unset, int] = Field(default=UNSET)
    disabled_orgs: Union[Unset, int] = Field(default=UNSET)
    total_teams: Union[Unset, int] = Field(default=UNSET)
    total_team_members: Union[Unset, int] = Field(default=UNSET)


class ServerStatisticsItemsPropGheStatsPropPages(GitHubRestModel):
    """ServerStatisticsItemsPropGheStatsPropPages"""

    total_pages: Union[Unset, int] = Field(default=UNSET)


class ServerStatisticsItemsPropGheStatsPropPulls(GitHubRestModel):
    """ServerStatisticsItemsPropGheStatsPropPulls"""

    total_pulls: Union[Unset, int] = Field(default=UNSET)
    merged_pulls: Union[Unset, int] = Field(default=UNSET)
    mergeable_pulls: Union[Unset, int] = Field(default=UNSET)
    unmergeable_pulls: Union[Unset, int] = Field(default=UNSET)


class ServerStatisticsItemsPropGheStatsPropRepos(GitHubRestModel):
    """ServerStatisticsItemsPropGheStatsPropRepos"""

    total_repos: Union[Unset, int] = Field(default=UNSET)
    root_repos: Union[Unset, int] = Field(default=UNSET)
    fork_repos: Union[Unset, int] = Field(default=UNSET)
    org_repos: Union[Unset, int] = Field(default=UNSET)
    total_pushes: Union[Unset, int] = Field(default=UNSET)
    total_wikis: Union[Unset, int] = Field(default=UNSET)


class ServerStatisticsItemsPropGheStatsPropUsers(GitHubRestModel):
    """ServerStatisticsItemsPropGheStatsPropUsers"""

    total_users: Union[Unset, int] = Field(default=UNSET)
    admin_users: Union[Unset, int] = Field(default=UNSET)
    suspended_users: Union[Unset, int] = Field(default=UNSET)


class ServerStatisticsItemsPropDormantUsers(GitHubRestModel):
    """ServerStatisticsItemsPropDormantUsers"""

    total_dormant_users: Union[Unset, int] = Field(default=UNSET)
    dormancy_threshold: Union[Unset, str] = Field(default=UNSET)


class ActionsCacheUsageOrgEnterprise(GitHubRestModel):
    """ActionsCacheUsageOrgEnterprise"""

    total_active_caches_count: int = Field(
        description="The count of active caches across all repositories of an enterprise or an organization.",
        default=...,
    )
    total_active_caches_size_in_bytes: int = Field(
        description="The total size in bytes of all active cache items across all repositories of an enterprise or an organization.",
        default=...,
    )


class ActionsEnterprisePermissions(GitHubRestModel):
    """ActionsEnterprisePermissions"""

    enabled_organizations: Literal["all", "none", "selected"] = Field(
        description="The policy that controls the organizations in the enterprise that are allowed to run GitHub Actions.",
        default=...,
    )
    selected_organizations_url: Union[Unset, str] = Field(
        description="The API URL to use to get or set the selected organizations that are allowed to run GitHub Actions, when `enabled_organizations` is set to `selected`.",
        default=UNSET,
    )
    allowed_actions: Union[Unset, Literal["all", "local_only", "selected"]] = Field(
        description="The permissions policy that controls the actions and reusable workflows that are allowed to run.",
        default=UNSET,
    )
    selected_actions_url: Union[Unset, str] = Field(
        description="The API URL to use to get or set the actions and reusable workflows that are allowed to run, when `allowed_actions` is set to `selected`.",
        default=UNSET,
    )


class OrganizationSimple(GitHubRestModel):
    """Organization Simple

    Organization Simple
    """

    login: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    hooks_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    members_url: str = Field(default=...)
    public_members_url: str = Field(default=...)
    avatar_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)


class SelectedActions(GitHubRestModel):
    """SelectedActions"""

    github_owned_allowed: Union[Unset, bool] = Field(
        description="Whether GitHub-owned actions are allowed. For example, this includes the actions in the `actions` organization.",
        default=UNSET,
    )
    verified_allowed: Union[Unset, bool] = Field(
        description="Whether actions from GitHub Marketplace verified creators are allowed. Set to `true` to allow all actions by GitHub Marketplace verified creators.",
        default=UNSET,
    )
    patterns_allowed: Union[Unset, List[str]] = Field(
        description='Specifies a list of string-matching patterns to allow specific action(s) and reusable workflow(s). Wildcards, tags, and SHAs are allowed. For example, `monalisa/octocat@*`, `monalisa/octocat@v2`, `monalisa/*`."',
        default=UNSET,
    )


class ActionsGetDefaultWorkflowPermissions(GitHubRestModel):
    """ActionsGetDefaultWorkflowPermissions"""

    default_workflow_permissions: Literal["read", "write"] = Field(
        description="The default workflow permissions granted to the GITHUB_TOKEN when running workflows.",
        default=...,
    )
    can_approve_pull_request_reviews: bool = Field(
        description="Whether GitHub Actions can approve pull requests. Enabling this can be a security risk.",
        default=...,
    )


class ActionsSetDefaultWorkflowPermissions(GitHubRestModel):
    """ActionsSetDefaultWorkflowPermissions"""

    default_workflow_permissions: Union[Unset, Literal["read", "write"]] = Field(
        description="The default workflow permissions granted to the GITHUB_TOKEN when running workflows.",
        default=UNSET,
    )
    can_approve_pull_request_reviews: Union[Unset, bool] = Field(
        description="Whether GitHub Actions can approve pull requests. Enabling this can be a security risk.",
        default=UNSET,
    )


class RunnerGroupsEnterprise(GitHubRestModel):
    """RunnerGroupsEnterprise"""

    id: float = Field(default=...)
    name: str = Field(default=...)
    visibility: str = Field(default=...)
    default: bool = Field(default=...)
    selected_organizations_url: Union[Unset, str] = Field(default=UNSET)
    runners_url: str = Field(default=...)
    allows_public_repositories: bool = Field(default=...)
    workflow_restrictions_read_only: Union[Unset, bool] = Field(
        description="If `true`, the `restricted_to_workflows` and `selected_workflows` fields cannot be modified.",
        default=False,
    )
    restricted_to_workflows: Union[Unset, bool] = Field(
        description="If `true`, the runner group will be restricted to running only the workflows specified in the `selected_workflows` array.",
        default=False,
    )
    selected_workflows: Union[Unset, List[str]] = Field(
        description="List of workflows the runner group should be allowed to run. This setting will be ignored unless `restricted_to_workflows` is set to `true`.",
        default=UNSET,
    )


class RunnerLabel(GitHubRestModel):
    """Self hosted runner label

    A label for a self hosted runner
    """

    id: Union[Unset, int] = Field(
        description="Unique identifier of the label.", default=UNSET
    )
    name: str = Field(description="Name of the label.", default=...)
    type: Union[Unset, Literal["read-only", "custom"]] = Field(
        description="The type of label. Read-only labels are applied automatically when the runner is configured.",
        default=UNSET,
    )


class Runner(GitHubRestModel):
    """Self hosted runners

    A self hosted runner
    """

    id: int = Field(description="The id of the runner.", default=...)
    name: str = Field(description="The name of the runner.", default=...)
    os: str = Field(description="The Operating System of the runner.", default=...)
    status: str = Field(description="The status of the runner.", default=...)
    busy: bool = Field(default=...)
    labels: List[RunnerLabel] = Field(default=...)


class RunnerApplication(GitHubRestModel):
    """Runner Application

    Runner Application
    """

    os: str = Field(default=...)
    architecture: str = Field(default=...)
    download_url: str = Field(default=...)
    filename: str = Field(default=...)
    temp_download_token: Union[Unset, str] = Field(
        description="A short lived bearer token used to download the runner, if needed.",
        default=UNSET,
    )
    sha256_checksum: Union[Unset, str] = Field(default=UNSET)


class AuthenticationToken(GitHubRestModel):
    """Authentication Token

    Authentication Token
    """

    token: str = Field(description="The token used for authentication", default=...)
    expires_at: datetime = Field(description="The time this token expires", default=...)
    permissions: Union[Unset, AuthenticationTokenPropPermissions] = Field(default=UNSET)
    repositories: Union[Unset, List[Repository]] = Field(
        description="The repositories this token has access to", default=UNSET
    )
    single_file: Union[Unset, Union[str, None]] = Field(default=UNSET)
    repository_selection: Union[Unset, Literal["all", "selected"]] = Field(
        description="Describe whether all repositories have been selected or there's a selection involved",
        default=UNSET,
    )


class AuthenticationTokenPropPermissions(GitHubRestModel):
    """AuthenticationTokenPropPermissions

    Examples:
        {'issues': 'read', 'deployments': 'write'}
    """


class CodeScanningAlertRule(GitHubRestModel):
    """CodeScanningAlertRule"""

    id: Union[Unset, Union[str, None]] = Field(
        description="A unique identifier for the rule used to detect the alert.",
        default=UNSET,
    )
    name: Union[Unset, str] = Field(
        description="The name of the rule used to detect the alert.", default=UNSET
    )
    severity: Union[
        Unset, Union[None, Literal["none", "note", "warning", "error"]]
    ] = Field(description="The severity of the alert.", default=UNSET)
    security_severity_level: Union[
        Unset, Union[None, Literal["low", "medium", "high", "critical"]]
    ] = Field(description="The security severity of the alert.", default=UNSET)
    description: Union[Unset, str] = Field(
        description="A short description of the rule used to detect the alert.",
        default=UNSET,
    )
    full_description: Union[Unset, str] = Field(
        description="description of the rule used to detect the alert.", default=UNSET
    )
    tags: Union[Unset, Union[List[str], None]] = Field(
        description="A set of tags applicable for the rule.", default=UNSET
    )
    help_: Union[Unset, Union[str, None]] = Field(
        description="Detailed documentation for the rule as GitHub Flavored Markdown.",
        default=UNSET,
        alias="help",
    )
    help_uri: Union[Unset, Union[str, None]] = Field(
        description="A link to the documentation for the rule used to detect the alert.",
        default=UNSET,
    )


class CodeScanningAnalysisTool(GitHubRestModel):
    """CodeScanningAnalysisTool"""

    name: Union[Unset, str] = Field(
        description="The name of the tool used to generate the code scanning analysis.",
        default=UNSET,
    )
    version: Union[Unset, Union[str, None]] = Field(
        description="The version of the tool used to generate the code scanning analysis.",
        default=UNSET,
    )
    guid: Union[Unset, Union[str, None]] = Field(
        description="The GUID of the tool used to generate the code scanning analysis, if provided in the uploaded SARIF data.",
        default=UNSET,
    )


class CodeScanningAlertLocation(GitHubRestModel):
    """CodeScanningAlertLocation

    Describe a region within a file for the alert.
    """

    path: Union[Unset, str] = Field(default=UNSET)
    start_line: Union[Unset, int] = Field(default=UNSET)
    end_line: Union[Unset, int] = Field(default=UNSET)
    start_column: Union[Unset, int] = Field(default=UNSET)
    end_column: Union[Unset, int] = Field(default=UNSET)


class CodeScanningAlertInstance(GitHubRestModel):
    """CodeScanningAlertInstance"""

    ref: Union[Unset, str] = Field(
        description="The full Git reference, formatted as `refs/heads/<branch name>`,\n`refs/pull/<number>/merge`, or `refs/pull/<number>/head`.",
        default=UNSET,
    )
    analysis_key: Union[Unset, str] = Field(
        description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.",
        default=UNSET,
    )
    environment: Union[Unset, str] = Field(
        description="Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.",
        default=UNSET,
    )
    category: Union[Unset, str] = Field(
        description="Identifies the configuration under which the analysis was executed. Used to distinguish between multiple analyses for the same tool and commit, but performed on different languages or different parts of the code.",
        default=UNSET,
    )
    state: Union[Unset, Literal["open", "closed", "dismissed", "fixed"]] = Field(
        description="State of a code scanning alert.", default=UNSET
    )
    commit_sha: Union[Unset, str] = Field(default=UNSET)
    message: Union[Unset, CodeScanningAlertInstancePropMessage] = Field(default=UNSET)
    location: Union[Unset, CodeScanningAlertLocation] = Field(
        description="Describe a region within a file for the alert.", default=UNSET
    )
    html_url: Union[Unset, str] = Field(default=UNSET)
    classifications: Union[
        Unset, List[Union[None, Literal["source", "generated", "test", "library"]]]
    ] = Field(
        description="Classifications that have been applied to the file that triggered the alert.\nFor example identifying it as documentation, or a generated file.",
        default=UNSET,
    )


class CodeScanningAlertInstancePropMessage(GitHubRestModel):
    """CodeScanningAlertInstancePropMessage"""

    text: Union[Unset, str] = Field(default=UNSET)


class SimpleRepository(GitHubRestModel):
    """Simple Repository

    Simple Repository
    """

    id: int = Field(description="A unique identifier of the repository.", default=...)
    node_id: str = Field(
        description="The GraphQL identifier of the repository.", default=...
    )
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(
        description="The full, globally unique, name of the repository.", default=...
    )
    owner: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    private: bool = Field(description="Whether the repository is private.", default=...)
    html_url: str = Field(
        description="The URL to view the repository on GitHub.com.", default=...
    )
    description: Union[str, None] = Field(
        description="The repository description.", default=...
    )
    fork: bool = Field(description="Whether the repository is a fork.", default=...)
    url: str = Field(
        description="The URL to get more information about the repository from the GitHub API.",
        default=...,
    )
    archive_url: str = Field(
        description="A template for the API URL to download the repository as an archive.",
        default=...,
    )
    assignees_url: str = Field(
        description="A template for the API URL to list the available assignees for issues in the repository.",
        default=...,
    )
    blobs_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git blob in the repository.",
        default=...,
    )
    branches_url: str = Field(
        description="A template for the API URL to get information about branches in the repository.",
        default=...,
    )
    collaborators_url: str = Field(
        description="A template for the API URL to get information about collaborators of the repository.",
        default=...,
    )
    comments_url: str = Field(
        description="A template for the API URL to get information about comments on the repository.",
        default=...,
    )
    commits_url: str = Field(
        description="A template for the API URL to get information about commits on the repository.",
        default=...,
    )
    compare_url: str = Field(
        description="A template for the API URL to compare two commits or refs.",
        default=...,
    )
    contents_url: str = Field(
        description="A template for the API URL to get the contents of the repository.",
        default=...,
    )
    contributors_url: str = Field(
        description="A template for the API URL to list the contributors to the repository.",
        default=...,
    )
    deployments_url: str = Field(
        description="The API URL to list the deployments of the repository.",
        default=...,
    )
    downloads_url: str = Field(
        description="The API URL to list the downloads on the repository.", default=...
    )
    events_url: str = Field(
        description="The API URL to list the events of the repository.", default=...
    )
    forks_url: str = Field(
        description="The API URL to list the forks of the repository.", default=...
    )
    git_commits_url: str = Field(
        description="A template for the API URL to get information about Git commits of the repository.",
        default=...,
    )
    git_refs_url: str = Field(
        description="A template for the API URL to get information about Git refs of the repository.",
        default=...,
    )
    git_tags_url: str = Field(
        description="A template for the API URL to get information about Git tags of the repository.",
        default=...,
    )
    issue_comment_url: str = Field(
        description="A template for the API URL to get information about issue comments on the repository.",
        default=...,
    )
    issue_events_url: str = Field(
        description="A template for the API URL to get information about issue events on the repository.",
        default=...,
    )
    issues_url: str = Field(
        description="A template for the API URL to get information about issues on the repository.",
        default=...,
    )
    keys_url: str = Field(
        description="A template for the API URL to get information about deploy keys on the repository.",
        default=...,
    )
    labels_url: str = Field(
        description="A template for the API URL to get information about labels of the repository.",
        default=...,
    )
    languages_url: str = Field(
        description="The API URL to get information about the languages of the repository.",
        default=...,
    )
    merges_url: str = Field(
        description="The API URL to merge branches in the repository.", default=...
    )
    milestones_url: str = Field(
        description="A template for the API URL to get information about milestones of the repository.",
        default=...,
    )
    notifications_url: str = Field(
        description="A template for the API URL to get information about notifications on the repository.",
        default=...,
    )
    pulls_url: str = Field(
        description="A template for the API URL to get information about pull requests on the repository.",
        default=...,
    )
    releases_url: str = Field(
        description="A template for the API URL to get information about releases on the repository.",
        default=...,
    )
    stargazers_url: str = Field(
        description="The API URL to list the stargazers on the repository.", default=...
    )
    statuses_url: str = Field(
        description="A template for the API URL to get information about statuses of a commit.",
        default=...,
    )
    subscribers_url: str = Field(
        description="The API URL to list the subscribers on the repository.",
        default=...,
    )
    subscription_url: str = Field(
        description="The API URL to subscribe to notifications for this repository.",
        default=...,
    )
    tags_url: str = Field(
        description="The API URL to get information about tags on the repository.",
        default=...,
    )
    teams_url: str = Field(
        description="The API URL to list the teams on the repository.", default=...
    )
    trees_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git tree of the repository.",
        default=...,
    )
    hooks_url: str = Field(
        description="The API URL to list the hooks on the repository.", default=...
    )


class CodeScanningOrganizationAlertItems(GitHubRestModel):
    """CodeScanningOrganizationAlertItems"""

    number: int = Field(description="The security alert number.", default=...)
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    updated_at: Union[Unset, datetime] = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    url: str = Field(description="The REST API URL of the alert resource.", default=...)
    html_url: str = Field(
        description="The GitHub URL of the alert resource.", default=...
    )
    instances_url: str = Field(
        description="The REST API URL for fetching the list of instances for an alert.",
        default=...,
    )
    state: Literal["open", "closed", "dismissed", "fixed"] = Field(
        description="State of a code scanning alert.", default=...
    )
    fixed_at: Union[Unset, Union[datetime, None]] = Field(
        description="The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    dismissed_by: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ] = Field(
        description="**Required when the state is dismissed.** The reason for dismissing or closing the alert.",
        default=...,
    )
    dismissed_comment: Union[Unset, Union[str, None]] = Field(
        description="The dismissal comment associated with the dismissal of the alert.",
        max_length=280,
        default=UNSET,
    )
    rule: CodeScanningAlertRule = Field(default=...)
    tool: CodeScanningAnalysisTool = Field(default=...)
    most_recent_instance: CodeScanningAlertInstance = Field(default=...)
    repository: SimpleRepository = Field(
        title="Simple Repository", description="Simple Repository", default=...
    )


class OrganizationSecretScanningAlert(GitHubRestModel):
    """OrganizationSecretScanningAlert"""

    number: Union[Unset, int] = Field(
        description="The security alert number.", default=UNSET
    )
    created_at: Union[Unset, datetime] = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    updated_at: Union[Unset, Union[None, datetime]] = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    url: Union[Unset, str] = Field(
        description="The REST API URL of the alert resource.", default=UNSET
    )
    html_url: Union[Unset, str] = Field(
        description="The GitHub URL of the alert resource.", default=UNSET
    )
    locations_url: Union[Unset, str] = Field(
        description="The REST API URL of the code locations for this alert.",
        default=UNSET,
    )
    state: Union[Unset, Literal["open", "resolved"]] = Field(
        description="Sets the state of the secret scanning alert. You must provide `resolution` when you set the state to `resolved`.",
        default=UNSET,
    )
    resolution: Union[
        Unset,
        Union[None, Literal["false_positive", "wont_fix", "revoked", "used_in_tests"]],
    ] = Field(
        description="**Required when the `state` is `resolved`.** The reason for resolving the alert.",
        default=UNSET,
    )
    resolved_at: Union[Unset, Union[datetime, None]] = Field(
        description="The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    resolved_by: Union[Unset, Union[None, SimpleUser]] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    secret_type: Union[Unset, str] = Field(
        description="The type of secret that secret scanning detected.", default=UNSET
    )
    secret_type_display_name: Union[Unset, str] = Field(
        description='User-friendly name for the detected secret, matching the `secret_type`.\nFor a list of built-in patterns, see "[Secret scanning patterns](https://docs.github.com/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)."',
        default=UNSET,
    )
    secret: Union[Unset, str] = Field(
        description="The secret that was detected.", default=UNSET
    )
    repository: Union[Unset, SimpleRepository] = Field(
        title="Simple Repository", description="Simple Repository", default=UNSET
    )
    push_protection_bypassed: Union[Unset, Union[bool, None]] = Field(
        description="Whether push protection was bypassed for the detected secret.",
        default=UNSET,
    )
    push_protection_bypassed_by: Union[Unset, Union[None, SimpleUser]] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    push_protection_bypassed_at: Union[Unset, Union[datetime, None]] = Field(
        description="The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    resolution_comment: Union[Unset, Union[str, None]] = Field(
        description="The comment that was optionally added when this alert was closed",
        default=UNSET,
    )


class AdvancedSecurityActiveCommittersUser(GitHubRestModel):
    """AdvancedSecurityActiveCommittersUser"""

    user_login: str = Field(default=...)
    last_pushed_date: str = Field(default=...)


class AdvancedSecurityActiveCommittersRepository(GitHubRestModel):
    """AdvancedSecurityActiveCommittersRepository"""

    name: str = Field(default=...)
    advanced_security_committers: int = Field(default=...)
    advanced_security_committers_breakdown: List[
        AdvancedSecurityActiveCommittersUser
    ] = Field(default=...)


class AdvancedSecurityActiveCommitters(GitHubRestModel):
    """AdvancedSecurityActiveCommitters"""

    total_advanced_security_committers: Union[Unset, int] = Field(default=UNSET)
    total_count: Union[Unset, int] = Field(default=UNSET)
    repositories: List[AdvancedSecurityActiveCommittersRepository] = Field(default=...)


class Actor(GitHubRestModel):
    """Actor

    Actor
    """

    id: int = Field(default=...)
    login: str = Field(default=...)
    display_login: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[str, None] = Field(default=...)
    url: str = Field(default=...)
    avatar_url: str = Field(default=...)


class Milestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    url: str = Field(default=...)
    html_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default="open"
    )
    title: str = Field(description="The title of the milestone.", default=...)
    description: Union[str, None] = Field(default=...)
    creator: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    open_issues: int = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)


class ReactionRollup(GitHubRestModel):
    """Reaction Rollup"""

    url: str = Field(default=...)
    total_count: int = Field(default=...)
    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    laugh: int = Field(default=...)
    confused: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    eyes: int = Field(default=...)
    rocket: int = Field(default=...)


class Issue(GitHubRestModel):
    """Issue

    Issues are a great way to keep track of tasks, enhancements, and bugs for your
    projects.
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    repository_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the issue within its repository",
        default=...,
    )
    state: str = Field(
        description="State of the issue; either 'open' or 'closed'", default=...
    )
    state_reason: Union[
        Unset, Union[None, Literal["completed", "reopened", "not_planned"]]
    ] = Field(description="The reason for the current state", default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    body: Union[Unset, Union[str, None]] = Field(
        description="Contents of the issue", default=UNSET
    )
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    labels: List[Union[str, IssuePropLabelsItemsOneof1]] = Field(
        description="Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository",
        default=...,
    )
    assignee: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    assignees: Union[Unset, Union[List[SimpleUser], None]] = Field(default=UNSET)
    milestone: Union[None, Milestone] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    locked: bool = Field(default=...)
    active_lock_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    comments: int = Field(default=...)
    pull_request: Union[Unset, IssuePropPullRequest] = Field(default=UNSET)
    closed_at: Union[datetime, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    closed_by: Union[Unset, Union[None, SimpleUser]] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    body_html: Union[Unset, Union[str, None]] = Field(default=UNSET)
    body_text: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    repository: Union[Unset, Repository] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    performed_via_github_app: Union[Unset, Union[None, Integration]] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )
    reactions: Union[Unset, ReactionRollup] = Field(
        title="Reaction Rollup", default=UNSET
    )


class IssuePropLabelsItemsOneof1(GitHubRestModel):
    """IssuePropLabelsItemsOneof1"""

    id: Union[Unset, int] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    name: Union[Unset, str] = Field(default=UNSET)
    description: Union[Unset, Union[str, None]] = Field(default=UNSET)
    color: Union[Unset, Union[str, None]] = Field(default=UNSET)
    default: Union[Unset, bool] = Field(default=UNSET)


class IssuePropPullRequest(GitHubRestModel):
    """IssuePropPullRequest"""

    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    diff_url: Union[str, None] = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    patch_url: Union[str, None] = Field(default=...)
    url: Union[str, None] = Field(default=...)


class IssueComment(GitHubRestModel):
    """Issue Comment

    Comments provide a way for people to collaborate on an issue.
    """

    id: int = Field(description="Unique identifier of the issue comment", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the issue comment", default=...)
    body: Union[Unset, str] = Field(
        description="Contents of the issue comment", default=UNSET
    )
    body_text: Union[Unset, str] = Field(default=UNSET)
    body_html: Union[Unset, str] = Field(default=UNSET)
    html_url: str = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    issue_url: str = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )
    performed_via_github_app: Union[Unset, Union[None, Integration]] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    reactions: Union[Unset, ReactionRollup] = Field(
        title="Reaction Rollup", default=UNSET
    )


class Event(GitHubRestModel):
    """Event

    Event
    """

    id: str = Field(default=...)
    type: Union[str, None] = Field(default=...)
    actor: Actor = Field(title="Actor", description="Actor", default=...)
    repo: EventPropRepo = Field(default=...)
    org: Union[Unset, Actor] = Field(title="Actor", description="Actor", default=UNSET)
    payload: EventPropPayload = Field(default=...)
    public: bool = Field(default=...)
    created_at: Union[datetime, None] = Field(default=...)


class EventPropRepo(GitHubRestModel):
    """EventPropRepo"""

    id: int = Field(default=...)
    name: str = Field(default=...)
    url: str = Field(default=...)


class EventPropPayload(GitHubRestModel):
    """EventPropPayload"""

    action: Union[Unset, str] = Field(default=UNSET)
    issue: Union[Unset, Issue] = Field(
        title="Issue",
        description="Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.",
        default=UNSET,
    )
    comment: Union[Unset, IssueComment] = Field(
        title="Issue Comment",
        description="Comments provide a way for people to collaborate on an issue.",
        default=UNSET,
    )
    pages: Union[Unset, List[EventPropPayloadPropPagesItems]] = Field(default=UNSET)


class EventPropPayloadPropPagesItems(GitHubRestModel):
    """EventPropPayloadPropPagesItems"""

    page_name: Union[Unset, str] = Field(default=UNSET)
    title: Union[Unset, str] = Field(default=UNSET)
    summary: Union[Unset, Union[str, None]] = Field(default=UNSET)
    action: Union[Unset, str] = Field(default=UNSET)
    sha: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)


class LinkWithType(GitHubRestModel):
    """Link With Type

    Hypermedia Link with Type
    """

    href: str = Field(default=...)
    type: str = Field(default=...)


class Feed(GitHubRestModel):
    """Feed

    Feed
    """

    timeline_url: str = Field(default=...)
    user_url: str = Field(default=...)
    current_user_public_url: Union[Unset, str] = Field(default=UNSET)
    current_user_url: Union[Unset, str] = Field(default=UNSET)
    current_user_actor_url: Union[Unset, str] = Field(default=UNSET)
    current_user_organization_url: Union[Unset, str] = Field(default=UNSET)
    current_user_organization_urls: Union[Unset, List[str]] = Field(default=UNSET)
    security_advisories_url: Union[Unset, str] = Field(default=UNSET)
    links: FeedPropLinks = Field(default=..., alias="_links")


class FeedPropLinks(GitHubRestModel):
    """FeedPropLinks"""

    timeline: LinkWithType = Field(
        title="Link With Type", description="Hypermedia Link with Type", default=...
    )
    user: LinkWithType = Field(
        title="Link With Type", description="Hypermedia Link with Type", default=...
    )
    security_advisories: Union[Unset, LinkWithType] = Field(
        title="Link With Type", description="Hypermedia Link with Type", default=UNSET
    )
    current_user: Union[Unset, LinkWithType] = Field(
        title="Link With Type", description="Hypermedia Link with Type", default=UNSET
    )
    current_user_public: Union[Unset, LinkWithType] = Field(
        title="Link With Type", description="Hypermedia Link with Type", default=UNSET
    )
    current_user_actor: Union[Unset, LinkWithType] = Field(
        title="Link With Type", description="Hypermedia Link with Type", default=UNSET
    )
    current_user_organization: Union[Unset, LinkWithType] = Field(
        title="Link With Type", description="Hypermedia Link with Type", default=UNSET
    )
    current_user_organizations: Union[Unset, List[LinkWithType]] = Field(default=UNSET)


class BaseGist(GitHubRestModel):
    """Base Gist

    Base Gist
    """

    url: str = Field(default=...)
    forks_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    id: str = Field(default=...)
    node_id: str = Field(default=...)
    git_pull_url: str = Field(default=...)
    git_push_url: str = Field(default=...)
    html_url: str = Field(default=...)
    files: BaseGistPropFiles = Field(default=...)
    public: bool = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    description: Union[str, None] = Field(default=...)
    comments: int = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    comments_url: str = Field(default=...)
    owner: Union[Unset, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    truncated: Union[Unset, bool] = Field(default=UNSET)
    forks: Union[Unset, List[Any]] = Field(default=UNSET)
    history: Union[Unset, List[Any]] = Field(default=UNSET)


class BaseGistPropFiles(GitHubRestModel, extra=Extra.allow):
    """BaseGistPropFiles"""


class PublicUser(GitHubRestModel):
    """Public User

    Public User
    """

    login: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    avatar_url: str = Field(default=...)
    gravatar_id: Union[str, None] = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    organizations_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    type: str = Field(default=...)
    site_admin: bool = Field(default=...)
    name: Union[str, None] = Field(default=...)
    company: Union[str, None] = Field(default=...)
    blog: Union[str, None] = Field(default=...)
    location: Union[str, None] = Field(default=...)
    email: Union[str, None] = Field(default=...)
    hireable: Union[bool, None] = Field(default=...)
    bio: Union[str, None] = Field(default=...)
    twitter_username: Union[Unset, Union[str, None]] = Field(default=UNSET)
    public_repos: int = Field(default=...)
    public_gists: int = Field(default=...)
    followers: int = Field(default=...)
    following: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    plan: Union[Unset, PublicUserPropPlan] = Field(default=UNSET)
    suspended_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    private_gists: Union[Unset, int] = Field(default=UNSET)
    total_private_repos: Union[Unset, int] = Field(default=UNSET)
    owned_private_repos: Union[Unset, int] = Field(default=UNSET)
    disk_usage: Union[Unset, int] = Field(default=UNSET)
    collaborators: Union[Unset, int] = Field(default=UNSET)


class PublicUserPropPlan(GitHubRestModel):
    """PublicUserPropPlan"""

    collaborators: int = Field(default=...)
    name: str = Field(default=...)
    space: int = Field(default=...)
    private_repos: int = Field(default=...)


class GistHistory(GitHubRestModel):
    """Gist History

    Gist History
    """

    user: Union[Unset, Union[None, SimpleUser]] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    version: Union[Unset, str] = Field(default=UNSET)
    committed_at: Union[Unset, datetime] = Field(default=UNSET)
    change_status: Union[Unset, GistHistoryPropChangeStatus] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class GistHistoryPropChangeStatus(GitHubRestModel):
    """GistHistoryPropChangeStatus"""

    total: Union[Unset, int] = Field(default=UNSET)
    additions: Union[Unset, int] = Field(default=UNSET)
    deletions: Union[Unset, int] = Field(default=UNSET)


class GistSimple(GitHubRestModel):
    """Gist Simple

    Gist Simple
    """

    forks: Union[Unset, Union[List[GistSimplePropForksItems], None]] = Field(
        default=UNSET
    )
    history: Union[Unset, Union[List[GistHistory], None]] = Field(default=UNSET)
    fork_of: Union[Unset, Union[GistSimplePropForkOf, None]] = Field(
        title="Gist", description="Gist", default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)
    forks_url: Union[Unset, str] = Field(default=UNSET)
    commits_url: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    git_pull_url: Union[Unset, str] = Field(default=UNSET)
    git_push_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    files: Union[Unset, GistSimplePropFiles] = Field(default=UNSET)
    public: Union[Unset, bool] = Field(default=UNSET)
    created_at: Union[Unset, str] = Field(default=UNSET)
    updated_at: Union[Unset, str] = Field(default=UNSET)
    description: Union[Unset, Union[str, None]] = Field(default=UNSET)
    comments: Union[Unset, int] = Field(default=UNSET)
    user: Union[Unset, Union[str, None]] = Field(default=UNSET)
    comments_url: Union[Unset, str] = Field(default=UNSET)
    owner: Union[Unset, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    truncated: Union[Unset, bool] = Field(default=UNSET)


class GistSimplePropForksItems(GitHubRestModel):
    """GistSimplePropForksItems"""

    id: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    user: Union[Unset, PublicUser] = Field(
        title="Public User", description="Public User", default=UNSET
    )
    created_at: Union[Unset, datetime] = Field(default=UNSET)
    updated_at: Union[Unset, datetime] = Field(default=UNSET)


class GistSimplePropForkOfPropFiles(GitHubRestModel, extra=Extra.allow):
    """GistSimplePropForkOfPropFiles"""


class GistSimplePropForkOf(GitHubRestModel):
    """Gist

    Gist
    """

    url: str = Field(default=...)
    forks_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    id: str = Field(default=...)
    node_id: str = Field(default=...)
    git_pull_url: str = Field(default=...)
    git_push_url: str = Field(default=...)
    html_url: str = Field(default=...)
    files: GistSimplePropForkOfPropFiles = Field(default=...)
    public: bool = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    description: Union[str, None] = Field(default=...)
    comments: int = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    comments_url: str = Field(default=...)
    owner: Union[Unset, Union[None, SimpleUser]] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    truncated: Union[Unset, bool] = Field(default=UNSET)
    forks: Union[Unset, List[Any]] = Field(default=UNSET)
    history: Union[Unset, List[Any]] = Field(default=UNSET)


class GistSimplePropFiles(GitHubRestModel, extra=Extra.allow):
    """GistSimplePropFiles"""


class GistComment(GitHubRestModel):
    """Gist Comment

    A comment made to a gist.
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    body: str = Field(description="The comment text.", max_length=65535, default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )


class GistCommit(GitHubRestModel):
    """Gist Commit

    Gist Commit
    """

    url: str = Field(default=...)
    version: str = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    change_status: GistCommitPropChangeStatus = Field(default=...)
    committed_at: datetime = Field(default=...)


class GistCommitPropChangeStatus(GitHubRestModel):
    """GistCommitPropChangeStatus"""

    total: Union[Unset, int] = Field(default=UNSET)
    additions: Union[Unset, int] = Field(default=UNSET)
    deletions: Union[Unset, int] = Field(default=UNSET)


class GitignoreTemplate(GitHubRestModel):
    """Gitignore Template

    Gitignore Template
    """

    name: str = Field(default=...)
    source: str = Field(default=...)


class License(GitHubRestModel):
    """License

    License
    """

    key: str = Field(default=...)
    name: str = Field(default=...)
    spdx_id: Union[str, None] = Field(default=...)
    url: Union[str, None] = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    description: str = Field(default=...)
    implementation: str = Field(default=...)
    permissions: List[str] = Field(default=...)
    conditions: List[str] = Field(default=...)
    limitations: List[str] = Field(default=...)
    body: str = Field(default=...)
    featured: bool = Field(default=...)


class MarketplaceListingPlan(GitHubRestModel):
    """Marketplace Listing Plan

    Marketplace Listing Plan
    """

    url: str = Field(default=...)
    accounts_url: str = Field(default=...)
    id: int = Field(default=...)
    number: int = Field(default=...)
    name: str = Field(default=...)
    description: str = Field(default=...)
    monthly_price_in_cents: int = Field(default=...)
    yearly_price_in_cents: int = Field(default=...)
    price_model: str = Field(default=...)
    has_free_trial: bool = Field(default=...)
    unit_name: Union[str, None] = Field(default=...)
    state: str = Field(default=...)
    bullets: List[str] = Field(default=...)


class MarketplacePurchase(GitHubRestModel):
    """Marketplace Purchase

    Marketplace Purchase
    """

    url: str = Field(default=...)
    type: str = Field(default=...)
    id: int = Field(default=...)
    login: str = Field(default=...)
    organization_billing_email: Union[Unset, str] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    marketplace_pending_change: Union[
        Unset, Union[MarketplacePurchasePropMarketplacePendingChange, None]
    ] = Field(default=UNSET)
    marketplace_purchase: MarketplacePurchasePropMarketplacePurchase = Field(
        default=...
    )


class MarketplacePurchasePropMarketplacePendingChange(GitHubRestModel):
    """MarketplacePurchasePropMarketplacePendingChange"""

    is_installed: Union[Unset, bool] = Field(default=UNSET)
    effective_date: Union[Unset, str] = Field(default=UNSET)
    unit_count: Union[Unset, Union[int, None]] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    plan: Union[Unset, MarketplaceListingPlan] = Field(
        title="Marketplace Listing Plan",
        description="Marketplace Listing Plan",
        default=UNSET,
    )


class MarketplacePurchasePropMarketplacePurchase(GitHubRestModel):
    """MarketplacePurchasePropMarketplacePurchase"""

    billing_cycle: Union[Unset, str] = Field(default=UNSET)
    next_billing_date: Union[Unset, Union[str, None]] = Field(default=UNSET)
    is_installed: Union[Unset, bool] = Field(default=UNSET)
    unit_count: Union[Unset, Union[int, None]] = Field(default=UNSET)
    on_free_trial: Union[Unset, bool] = Field(default=UNSET)
    free_trial_ends_on: Union[Unset, Union[str, None]] = Field(default=UNSET)
    updated_at: Union[Unset, str] = Field(default=UNSET)
    plan: Union[Unset, MarketplaceListingPlan] = Field(
        title="Marketplace Listing Plan",
        description="Marketplace Listing Plan",
        default=UNSET,
    )


class ApiOverview(GitHubRestModel):
    """Api Overview

    Api Overview
    """

    verifiable_password_authentication: bool = Field(default=...)
    ssh_key_fingerprints: Union[Unset, ApiOverviewPropSshKeyFingerprints] = Field(
        default=UNSET
    )
    ssh_keys: Union[Unset, List[str]] = Field(default=UNSET)
    hooks: Union[Unset, List[str]] = Field(default=UNSET)
    web: Union[Unset, List[str]] = Field(default=UNSET)
    api: Union[Unset, List[str]] = Field(default=UNSET)
    git: Union[Unset, List[str]] = Field(default=UNSET)
    packages: Union[Unset, List[str]] = Field(default=UNSET)
    pages: Union[Unset, List[str]] = Field(default=UNSET)
    importer: Union[Unset, List[str]] = Field(default=UNSET)
    actions: Union[Unset, List[str]] = Field(default=UNSET)
    dependabot: Union[Unset, List[str]] = Field(default=UNSET)


class ApiOverviewPropSshKeyFingerprints(GitHubRestModel):
    """ApiOverviewPropSshKeyFingerprints"""

    sha256_rsa: Union[Unset, str] = Field(default=UNSET, alias="SHA256_RSA")
    sha256_dsa: Union[Unset, str] = Field(default=UNSET, alias="SHA256_DSA")
    sha256_ecdsa: Union[Unset, str] = Field(default=UNSET, alias="SHA256_ECDSA")
    sha256_ed25519: Union[Unset, str] = Field(default=UNSET, alias="SHA256_ED25519")


class MinimalRepository(GitHubRestModel):
    """Minimal Repository

    Minimal Repository
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(default=...)
    full_name: str = Field(default=...)
    owner: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    private: bool = Field(default=...)
    html_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    fork: bool = Field(default=...)
    url: str = Field(default=...)
    archive_url: str = Field(default=...)
    assignees_url: str = Field(default=...)
    blobs_url: str = Field(default=...)
    branches_url: str = Field(default=...)
    collaborators_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    compare_url: str = Field(default=...)
    contents_url: str = Field(default=...)
    contributors_url: str = Field(default=...)
    deployments_url: str = Field(default=...)
    downloads_url: str = Field(default=...)
    events_url: str = Field(default=...)
    forks_url: str = Field(default=...)
    git_commits_url: str = Field(default=...)
    git_refs_url: str = Field(default=...)
    git_tags_url: str = Field(default=...)
    git_url: Union[Unset, str] = Field(default=UNSET)
    issue_comment_url: str = Field(default=...)
    issue_events_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    keys_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    languages_url: str = Field(default=...)
    merges_url: str = Field(default=...)
    milestones_url: str = Field(default=...)
    notifications_url: str = Field(default=...)
    pulls_url: str = Field(default=...)
    releases_url: str = Field(default=...)
    ssh_url: Union[Unset, str] = Field(default=UNSET)
    stargazers_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    subscribers_url: str = Field(default=...)
    subscription_url: str = Field(default=...)
    tags_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    trees_url: str = Field(default=...)
    clone_url: Union[Unset, str] = Field(default=UNSET)
    mirror_url: Union[Unset, Union[str, None]] = Field(default=UNSET)
    hooks_url: str = Field(default=...)
    svn_url: Union[Unset, str] = Field(default=UNSET)
    homepage: Union[Unset, Union[str, None]] = Field(default=UNSET)
    language: Union[Unset, Union[str, None]] = Field(default=UNSET)
    forks_count: Union[Unset, int] = Field(default=UNSET)
    stargazers_count: Union[Unset, int] = Field(default=UNSET)
    watchers_count: Union[Unset, int] = Field(default=UNSET)
    size: Union[Unset, int] = Field(
        description="The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.",
        default=UNSET,
    )
    default_branch: Union[Unset, str] = Field(default=UNSET)
    open_issues_count: Union[Unset, int] = Field(default=UNSET)
    is_template: Union[Unset, bool] = Field(default=UNSET)
    topics: Union[Unset, List[str]] = Field(default=UNSET)
    has_issues: Union[Unset, bool] = Field(default=UNSET)
    has_projects: Union[Unset, bool] = Field(default=UNSET)
    has_wiki: Union[Unset, bool] = Field(default=UNSET)
    has_pages: Union[Unset, bool] = Field(default=UNSET)
    has_downloads: Union[Unset, bool] = Field(default=UNSET)
    archived: Union[Unset, bool] = Field(default=UNSET)
    disabled: Union[Unset, bool] = Field(default=UNSET)
    visibility: Union[Unset, str] = Field(default=UNSET)
    pushed_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    created_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    updated_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    permissions: Union[Unset, MinimalRepositoryPropPermissions] = Field(default=UNSET)
    role_name: Union[Unset, str] = Field(default=UNSET)
    temp_clone_token: Union[Unset, str] = Field(default=UNSET)
    delete_branch_on_merge: Union[Unset, bool] = Field(default=UNSET)
    subscribers_count: Union[Unset, int] = Field(default=UNSET)
    network_count: Union[Unset, int] = Field(default=UNSET)
    code_of_conduct: Union[Unset, CodeOfConduct] = Field(
        title="Code Of Conduct", description="Code Of Conduct", default=UNSET
    )
    license_: Union[Unset, Union[MinimalRepositoryPropLicense, None]] = Field(
        default=UNSET, alias="license"
    )
    forks: Union[Unset, int] = Field(default=UNSET)
    open_issues: Union[Unset, int] = Field(default=UNSET)
    watchers: Union[Unset, int] = Field(default=UNSET)
    allow_forking: Union[Unset, bool] = Field(default=UNSET)
    web_commit_signoff_required: Union[Unset, bool] = Field(default=UNSET)


class MinimalRepositoryPropPermissions(GitHubRestModel):
    """MinimalRepositoryPropPermissions"""

    admin: Union[Unset, bool] = Field(default=UNSET)
    maintain: Union[Unset, bool] = Field(default=UNSET)
    push: Union[Unset, bool] = Field(default=UNSET)
    triage: Union[Unset, bool] = Field(default=UNSET)
    pull: Union[Unset, bool] = Field(default=UNSET)


class MinimalRepositoryPropLicense(GitHubRestModel):
    """MinimalRepositoryPropLicense"""

    key: Union[Unset, str] = Field(default=UNSET)
    name: Union[Unset, str] = Field(default=UNSET)
    spdx_id: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)


class Thread(GitHubRestModel):
    """Thread

    Thread
    """

    id: str = Field(default=...)
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository", default=...
    )
    subject: ThreadPropSubject = Field(default=...)
    reason: str = Field(default=...)
    unread: bool = Field(default=...)
    updated_at: str = Field(default=...)
    last_read_at: Union[str, None] = Field(default=...)
    url: str = Field(default=...)
    subscription_url: str = Field(default=...)


class ThreadPropSubject(GitHubRestModel):
    """ThreadPropSubject"""

    title: str = Field(default=...)
    url: str = Field(default=...)
    latest_comment_url: str = Field(default=...)
    type: str = Field(default=...)


class ThreadSubscription(GitHubRestModel):
    """Thread Subscription

    Thread Subscription
    """

    subscribed: bool = Field(default=...)
    ignored: bool = Field(default=...)
    reason: Union[str, None] = Field(default=...)
    created_at: Union[datetime, None] = Field(default=...)
    url: str = Field(default=...)
    thread_url: Union[Unset, str] = Field(default=UNSET)
    repository_url: Union[Unset, str] = Field(default=UNSET)


class OrganizationCustomRepositoryRole(GitHubRestModel):
    """Organization Custom Repository Role

    Custom repository roles created by organization administrators
    """

    id: int = Field(
        description="The unique identifier of the custom role.", default=...
    )
    name: str = Field(description="The name of the custom role.", default=...)
    description: Union[Unset, Union[str, None]] = Field(
        description="A short description about who this role is for or what permissions it grants.",
        default=UNSET,
    )
    base_role: Union[Unset, Literal["read", "triage", "write", "maintain"]] = Field(
        description="The system role from which this role inherits permissions.",
        default=UNSET,
    )
    permissions: Union[Unset, List[str]] = Field(
        description="A list of additional permissions included in this role.",
        default=UNSET,
    )
    organization: Union[Unset, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    created_at: Union[Unset, datetime] = Field(default=UNSET)
    updated_at: Union[Unset, datetime] = Field(default=UNSET)


class OrganizationFull(GitHubRestModel):
    """Organization Full

    Organization Full
    """

    login: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    hooks_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    members_url: str = Field(default=...)
    public_members_url: str = Field(default=...)
    avatar_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    company: Union[Unset, str] = Field(default=UNSET)
    blog: Union[Unset, str] = Field(default=UNSET)
    location: Union[Unset, str] = Field(default=UNSET)
    email: Union[Unset, str] = Field(default=UNSET)
    twitter_username: Union[Unset, Union[str, None]] = Field(default=UNSET)
    is_verified: Union[Unset, bool] = Field(default=UNSET)
    has_organization_projects: bool = Field(default=...)
    has_repository_projects: bool = Field(default=...)
    public_repos: int = Field(default=...)
    public_gists: int = Field(default=...)
    followers: int = Field(default=...)
    following: int = Field(default=...)
    html_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    type: str = Field(default=...)
    total_private_repos: Union[Unset, int] = Field(default=UNSET)
    owned_private_repos: Union[Unset, int] = Field(default=UNSET)
    private_gists: Union[Unset, Union[int, None]] = Field(default=UNSET)
    disk_usage: Union[Unset, Union[int, None]] = Field(default=UNSET)
    collaborators: Union[Unset, Union[int, None]] = Field(default=UNSET)
    billing_email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    plan: Union[Unset, OrganizationFullPropPlan] = Field(default=UNSET)
    default_repository_permission: Union[Unset, Union[str, None]] = Field(default=UNSET)
    members_can_create_repositories: Union[Unset, Union[bool, None]] = Field(
        default=UNSET
    )
    two_factor_requirement_enabled: Union[Unset, Union[bool, None]] = Field(
        default=UNSET
    )
    members_allowed_repository_creation_type: Union[Unset, str] = Field(default=UNSET)
    members_can_create_public_repositories: Union[Unset, bool] = Field(default=UNSET)
    members_can_create_private_repositories: Union[Unset, bool] = Field(default=UNSET)
    members_can_create_internal_repositories: Union[Unset, bool] = Field(default=UNSET)
    members_can_create_pages: Union[Unset, bool] = Field(default=UNSET)
    members_can_create_public_pages: Union[Unset, bool] = Field(default=UNSET)
    members_can_create_private_pages: Union[Unset, bool] = Field(default=UNSET)
    members_can_fork_private_repositories: Union[Unset, Union[bool, None]] = Field(
        default=UNSET
    )
    web_commit_signoff_required: Union[Unset, bool] = Field(default=UNSET)
    updated_at: datetime = Field(default=...)
    advanced_security_enabled_for_new_repositories: Union[Unset, bool] = Field(
        description="Whether GitHub Advanced Security is enabled for new repositories and repositories transferred to this organization.\n\nThis field is only visible to organization owners or members of a team with the security manager role.",
        default=UNSET,
    )
    dependabot_alerts_enabled_for_new_repositories: Union[Unset, bool] = Field(
        description="Whether GitHub Advanced Security is automatically enabled for new repositories and repositories transferred to\nthis organization.\n\nThis field is only visible to organization owners or members of a team with the security manager role.",
        default=UNSET,
    )
    dependabot_security_updates_enabled_for_new_repositories: Union[
        Unset, bool
    ] = Field(
        description="Whether dependabot security updates are automatically enabled for new repositories and repositories transferred\nto this organization.\n\nThis field is only visible to organization owners or members of a team with the security manager role.",
        default=UNSET,
    )
    dependency_graph_enabled_for_new_repositories: Union[Unset, bool] = Field(
        description="Whether dependency graph is automatically enabled for new repositories and repositories transferred to this\norganization.\n\nThis field is only visible to organization owners or members of a team with the security manager role.",
        default=UNSET,
    )
    secret_scanning_enabled_for_new_repositories: Union[Unset, bool] = Field(
        description="Whether secret scanning is automatically enabled for new repositories and repositories transferred to this\norganization.\n\nThis field is only visible to organization owners or members of a team with the security manager role.",
        default=UNSET,
    )
    secret_scanning_push_protection_enabled_for_new_repositories: Union[
        Unset, bool
    ] = Field(
        description="Whether secret scanning push protection is automatically enabled for new repositories and repositories\ntransferred to this organization.\n\nThis field is only visible to organization owners or members of a team with the security manager role.",
        default=UNSET,
    )


class OrganizationFullPropPlan(GitHubRestModel):
    """OrganizationFullPropPlan"""

    name: str = Field(default=...)
    space: int = Field(default=...)
    private_repos: int = Field(default=...)
    filled_seats: Union[Unset, int] = Field(default=UNSET)
    seats: Union[Unset, int] = Field(default=UNSET)


class ActionsCacheUsageByRepository(GitHubRestModel):
    """Actions Cache Usage by repository

    GitHub Actions Cache Usage by repository.
    """

    full_name: str = Field(
        description="The repository owner and name for the cache usage being shown.",
        default=...,
    )
    active_caches_size_in_bytes: int = Field(
        description="The sum of the size in bytes of all the active cache items in the repository.",
        default=...,
    )
    active_caches_count: int = Field(
        description="The number of active caches in the repository.", default=...
    )


class ActionsOrganizationPermissions(GitHubRestModel):
    """ActionsOrganizationPermissions"""

    enabled_repositories: Literal["all", "none", "selected"] = Field(
        description="The policy that controls the repositories in the organization that are allowed to run GitHub Actions.",
        default=...,
    )
    selected_repositories_url: Union[Unset, str] = Field(
        description="The API URL to use to get or set the selected repositories that are allowed to run GitHub Actions, when `enabled_repositories` is set to `selected`.",
        default=UNSET,
    )
    allowed_actions: Union[Unset, Literal["all", "local_only", "selected"]] = Field(
        description="The permissions policy that controls the actions and reusable workflows that are allowed to run.",
        default=UNSET,
    )
    selected_actions_url: Union[Unset, str] = Field(
        description="The API URL to use to get or set the actions and reusable workflows that are allowed to run, when `allowed_actions` is set to `selected`.",
        default=UNSET,
    )


class RunnerGroupsOrg(GitHubRestModel):
    """RunnerGroupsOrg"""

    id: float = Field(default=...)
    name: str = Field(default=...)
    visibility: str = Field(default=...)
    default: bool = Field(default=...)
    selected_repositories_url: Union[Unset, str] = Field(
        description="Link to the selected repositories resource for this runner group. Not present unless visibility was set to `selected`",
        default=UNSET,
    )
    runners_url: str = Field(default=...)
    inherited: bool = Field(default=...)
    inherited_allows_public_repositories: Union[Unset, bool] = Field(default=UNSET)
    allows_public_repositories: bool = Field(default=...)
    workflow_restrictions_read_only: Union[Unset, bool] = Field(
        description="If `true`, the `restricted_to_workflows` and `selected_workflows` fields cannot be modified.",
        default=False,
    )
    restricted_to_workflows: Union[Unset, bool] = Field(
        description="If `true`, the runner group will be restricted to running only the workflows specified in the `selected_workflows` array.",
        default=False,
    )
    selected_workflows: Union[Unset, List[str]] = Field(
        description="List of workflows the runner group should be allowed to run. This setting will be ignored unless `restricted_to_workflows` is set to `true`.",
        default=UNSET,
    )


class OrganizationActionsSecret(GitHubRestModel):
    """Actions Secret for an Organization

    Secrets for GitHub Actions for an organization.
    """

    name: str = Field(description="The name of the secret.", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    visibility: Literal["all", "private", "selected"] = Field(
        description="Visibility of a secret", default=...
    )
    selected_repositories_url: Union[Unset, str] = Field(default=UNSET)


class ActionsPublicKey(GitHubRestModel):
    """ActionsPublicKey

    The public key used for setting Actions Secrets.
    """

    key_id: str = Field(description="The identifier for the key.", default=...)
    key: str = Field(description="The Base64 encoded public key.", default=...)
    id: Union[Unset, int] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    title: Union[Unset, str] = Field(default=UNSET)
    created_at: Union[Unset, str] = Field(default=UNSET)


class EmptyObject(GitHubRestModel):
    """Empty Object

    An object without any properties.
    """


class CodespaceMachine(GitHubRestModel):
    """Codespace machine

    A description of the machine powering a codespace.
    """

    name: str = Field(description="The name of the machine.", default=...)
    display_name: str = Field(
        description="The display name of the machine includes cores, memory, and storage.",
        default=...,
    )
    operating_system: str = Field(
        description="The operating system of the machine.", default=...
    )
    storage_in_bytes: int = Field(
        description="How much storage is available to the codespace.", default=...
    )
    memory_in_bytes: int = Field(
        description="How much memory is available to the codespace.", default=...
    )
    cpus: int = Field(
        description="How many cores are available to the codespace.", default=...
    )
    prebuild_availability: Union[None, Literal["none", "ready", "in_progress"]] = Field(
        description='Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be "null" if prebuilds are not supported or prebuild availability could not be determined. Value will be "none" if no prebuild is available. Latest values "ready" and "in_progress" indicate the prebuild availability status.',
        default=...,
    )


class Codespace(GitHubRestModel):
    """Codespace

    A codespace.
    """

    id: int = Field(default=...)
    name: str = Field(
        description="Automatically generated name of this codespace.", default=...
    )
    display_name: Union[Unset, Union[str, None]] = Field(
        description="Display name for this codespace.", default=UNSET
    )
    environment_id: Union[str, None] = Field(
        description="UUID identifying this codespace's environment.", default=...
    )
    owner: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    billable_owner: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository", default=...
    )
    machine: Union[None, CodespaceMachine] = Field(
        title="Codespace machine",
        description="A description of the machine powering a codespace.",
        default=...,
    )
    devcontainer_path: Union[Unset, Union[str, None]] = Field(
        description="Path to devcontainer.json from repo root used to create Codespace.",
        default=UNSET,
    )
    prebuild: Union[bool, None] = Field(
        description="Whether the codespace was created from a prebuild.", default=...
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    last_used_at: datetime = Field(
        description="Last known time this codespace was started.", default=...
    )
    state: Literal[
        "Unknown",
        "Created",
        "Queued",
        "Provisioning",
        "Available",
        "Awaiting",
        "Unavailable",
        "Deleted",
        "Moved",
        "Shutdown",
        "Archived",
        "Starting",
        "ShuttingDown",
        "Failed",
        "Exporting",
        "Updating",
        "Rebuilding",
    ] = Field(description="State of this codespace.", default=...)
    url: str = Field(description="API URL for this codespace.", default=...)
    git_status: CodespacePropGitStatus = Field(
        description="Details about the codespace's git repository.", default=...
    )
    location: Literal["EastUs", "SouthEastAsia", "WestEurope", "WestUs2"] = Field(
        description="The Azure region where this codespace is located.", default=...
    )
    idle_timeout_minutes: Union[int, None] = Field(
        description="The number of minutes of inactivity after which this codespace will be automatically stopped.",
        default=...,
    )
    web_url: str = Field(
        description="URL to access this codespace on the web.", default=...
    )
    machines_url: str = Field(
        description="API URL to access available alternate machine types for this codespace.",
        default=...,
    )
    start_url: str = Field(description="API URL to start this codespace.", default=...)
    stop_url: str = Field(description="API URL to stop this codespace.", default=...)
    pulls_url: Union[str, None] = Field(
        description="API URL for the Pull Request associated with this codespace, if any.",
        default=...,
    )
    recent_folders: List[str] = Field(default=...)
    runtime_constraints: Union[Unset, CodespacePropRuntimeConstraints] = Field(
        default=UNSET
    )
    pending_operation: Union[Unset, Union[bool, None]] = Field(
        description="Whether or not a codespace has a pending async operation. This would mean that the codespace is temporarily unavailable. The only thing that you can do with a codespace in this state is delete it.",
        default=UNSET,
    )
    pending_operation_disabled_reason: Union[Unset, Union[str, None]] = Field(
        description="Text to show user when codespace is disabled by a pending operation",
        default=UNSET,
    )
    idle_timeout_notice: Union[Unset, Union[str, None]] = Field(
        description="Text to show user when codespace idle timeout minutes has been overriden by an organization policy",
        default=UNSET,
    )
    retention_period_minutes: Union[Unset, Union[int, None]] = Field(
        description="Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).",
        default=UNSET,
    )
    retention_expires_at: Union[Unset, Union[datetime, None]] = Field(
        description='When a codespace will be auto-deleted based on the "retention_period_minutes" and "last_used_at"',
        default=UNSET,
    )
    last_known_stop_notice: Union[Unset, Union[str, None]] = Field(
        description="The text to display to a user when a codespace has been stopped for a potentially actionable reason.",
        default=UNSET,
    )


class CodespacePropGitStatus(GitHubRestModel):
    """CodespacePropGitStatus

    Details about the codespace's git repository.
    """

    ahead: Union[Unset, int] = Field(
        description="The number of commits the local repository is ahead of the remote.",
        default=UNSET,
    )
    behind: Union[Unset, int] = Field(
        description="The number of commits the local repository is behind the remote.",
        default=UNSET,
    )
    has_unpushed_changes: Union[Unset, bool] = Field(
        description="Whether the local repository has unpushed changes.", default=UNSET
    )
    has_uncommitted_changes: Union[Unset, bool] = Field(
        description="Whether the local repository has uncommitted changes.",
        default=UNSET,
    )
    ref: Union[Unset, str] = Field(
        description="The current branch (or SHA if in detached HEAD state) of the local repository.",
        default=UNSET,
    )


class CodespacePropRuntimeConstraints(GitHubRestModel):
    """CodespacePropRuntimeConstraints"""

    allowed_port_privacy_settings: Union[Unset, Union[List[str], None]] = Field(
        description="The privacy settings a user can select from when forwarding a port.",
        default=UNSET,
    )


class CodespacesOrgSecret(GitHubRestModel):
    """Codespaces Secret

    Secrets for a GitHub Codespace.
    """

    name: str = Field(description="The name of the secret", default=...)
    created_at: datetime = Field(
        description="The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
        default=...,
    )
    visibility: Literal["all", "private", "selected"] = Field(
        description="The type of repositories in the organization that the secret is visible to",
        default=...,
    )
    selected_repositories_url: Union[Unset, str] = Field(
        description="The API URL at which the list of repositories this secret is visible to can be retrieved",
        default=UNSET,
    )


class CodespacesPublicKey(GitHubRestModel):
    """CodespacesPublicKey

    The public key used for setting Codespaces secrets.
    """

    key_id: str = Field(description="The identifier for the key.", default=...)
    key: str = Field(description="The Base64 encoded public key.", default=...)
    id: Union[Unset, int] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    title: Union[Unset, str] = Field(default=UNSET)
    created_at: Union[Unset, str] = Field(default=UNSET)


class DependabotAlertPackage(GitHubRestModel):
    """DependabotAlertPackage

    Details for the vulnerable package.
    """

    ecosystem: str = Field(
        description="The package's language or package management ecosystem.",
        default=...,
    )
    name: str = Field(
        description="The unique package name within its ecosystem.", default=...
    )


class DependabotAlertSecurityVulnerability(GitHubRestModel):
    """DependabotAlertSecurityVulnerability

    Details pertaining to one vulnerable version range for the advisory.
    """

    package: DependabotAlertPackage = Field(
        description="Details for the vulnerable package.", default=...
    )
    severity: Literal["low", "medium", "high", "critical"] = Field(
        description="The severity of the vulnerability.", default=...
    )
    vulnerable_version_range: str = Field(
        description="Conditions that identify vulnerable versions of this vulnerability's package.",
        default=...,
    )
    first_patched_version: Union[
        DependabotAlertSecurityVulnerabilityPropFirstPatchedVersion, None
    ] = Field(
        description="Details pertaining to the package version that patches this vulnerability.",
        default=...,
    )


class DependabotAlertSecurityVulnerabilityPropFirstPatchedVersion(GitHubRestModel):
    """DependabotAlertSecurityVulnerabilityPropFirstPatchedVersion

    Details pertaining to the package version that patches this vulnerability.
    """

    identifier: str = Field(
        description="The package version that patches this vulnerability.", default=...
    )


class DependabotAlertSecurityAdvisory(GitHubRestModel):
    """DependabotAlertSecurityAdvisory

    Details for the GitHub Security Advisory.
    """

    ghsa_id: str = Field(
        description="The unique GitHub Security Advisory ID assigned to the advisory.",
        default=...,
    )
    cve_id: Union[str, None] = Field(
        description="The unique CVE ID assigned to the advisory.", default=...
    )
    summary: str = Field(
        description="A short, plain text summary of the advisory.",
        max_length=1024,
        default=...,
    )
    description: str = Field(
        description="A long-form Markdown-supported description of the advisory.",
        default=...,
    )
    vulnerabilities: List[DependabotAlertSecurityVulnerability] = Field(
        description="Vulnerable version range information for the advisory.",
        default=...,
    )
    severity: Literal["low", "medium", "high", "critical"] = Field(
        description="The severity of the advisory.", default=...
    )
    cvss: DependabotAlertSecurityAdvisoryPropCvss = Field(
        description="Details for the advisory pertaining to the Common Vulnerability Scoring System.",
        default=...,
    )
    cwes: List[DependabotAlertSecurityAdvisoryPropCwesItems] = Field(
        description="Details for the advisory pertaining to Common Weakness Enumeration.",
        default=...,
    )
    identifiers: List[DependabotAlertSecurityAdvisoryPropIdentifiersItems] = Field(
        description="Values that identify this advisory among security information sources.",
        default=...,
    )
    references: List[DependabotAlertSecurityAdvisoryPropReferencesItems] = Field(
        description="Links to additional advisory information.", default=...
    )
    published_at: datetime = Field(
        description="The time that the advisory was published in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The time that the advisory was last modified in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    withdrawn_at: Union[datetime, None] = Field(
        description="The time that the advisory was withdrawn in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )


class DependabotAlertSecurityAdvisoryPropCvss(GitHubRestModel):
    """DependabotAlertSecurityAdvisoryPropCvss

    Details for the advisory pertaining to the Common Vulnerability Scoring System.
    """

    score: float = Field(
        description="The overall CVSS score of the advisory.", le=10.0, default=...
    )
    vector_string: Union[str, None] = Field(
        description="The full CVSS vector string for the advisory.", default=...
    )


class DependabotAlertSecurityAdvisoryPropCwesItems(GitHubRestModel):
    """DependabotAlertSecurityAdvisoryPropCwesItems

    A CWE weakness assigned to the advisory.
    """

    cwe_id: str = Field(description="The unique CWE ID.", default=...)
    name: str = Field(description="The short, plain text name of the CWE.", default=...)


class DependabotAlertSecurityAdvisoryPropIdentifiersItems(GitHubRestModel):
    """DependabotAlertSecurityAdvisoryPropIdentifiersItems

    An advisory identifier.
    """

    type: Literal["CVE", "GHSA"] = Field(
        description="The type of advisory identifier.", default=...
    )
    value: str = Field(description="The value of the advisory identifer.", default=...)


class DependabotAlertSecurityAdvisoryPropReferencesItems(GitHubRestModel):
    """DependabotAlertSecurityAdvisoryPropReferencesItems

    A link to additional advisory information.
    """

    url: str = Field(description="The URL of the reference.", default=...)


class DependabotAlertWithRepository(GitHubRestModel):
    """DependabotAlertWithRepository

    A Dependabot alert.
    """

    number: int = Field(description="The security alert number.", default=...)
    state: Literal["dismissed", "fixed", "open"] = Field(
        description="The state of the Dependabot alert.", default=...
    )
    dependency: DependabotAlertWithRepositoryPropDependency = Field(
        description="Details for the vulnerable dependency.", default=...
    )
    security_advisory: DependabotAlertSecurityAdvisory = Field(
        description="Details for the GitHub Security Advisory.", default=...
    )
    security_vulnerability: DependabotAlertSecurityVulnerability = Field(
        description="Details pertaining to one vulnerable version range for the advisory.",
        default=...,
    )
    url: str = Field(description="The REST API URL of the alert resource.", default=...)
    html_url: str = Field(
        description="The GitHub URL of the alert resource.", default=...
    )
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_by: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    dismissed_reason: Union[
        None,
        Literal[
            "fix_started", "inaccurate", "no_bandwidth", "not_used", "tolerable_risk"
        ],
    ] = Field(description="The reason that the alert was dismissed.", default=...)
    dismissed_comment: Union[str, None] = Field(
        description="An optional comment associated with the alert's dismissal.",
        max_length=280,
        default=...,
    )
    fixed_at: Union[datetime, None] = Field(
        description="The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    repository: SimpleRepository = Field(
        title="Simple Repository", description="Simple Repository", default=...
    )


class DependabotAlertWithRepositoryPropDependency(GitHubRestModel):
    """DependabotAlertWithRepositoryPropDependency

    Details for the vulnerable dependency.
    """

    package: Union[Unset, DependabotAlertPackage] = Field(
        description="Details for the vulnerable package.", default=UNSET
    )
    manifest_path: Union[Unset, str] = Field(
        description="The full path to the dependency manifest file, relative to the root of the repository.",
        default=UNSET,
    )
    scope: Union[Unset, Union[None, Literal["development", "runtime"]]] = Field(
        description="The execution scope of the vulnerable dependency.", default=UNSET
    )


class OrganizationDependabotSecret(GitHubRestModel):
    """Dependabot Secret for an Organization

    Secrets for GitHub Dependabot for an organization.
    """

    name: str = Field(description="The name of the secret.", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    visibility: Literal["all", "private", "selected"] = Field(
        description="Visibility of a secret", default=...
    )
    selected_repositories_url: Union[Unset, str] = Field(default=UNSET)


class DependabotPublicKey(GitHubRestModel):
    """DependabotPublicKey

    The public key used for setting Dependabot Secrets.
    """

    key_id: str = Field(description="The identifier for the key.", default=...)
    key: str = Field(description="The Base64 encoded public key.", default=...)


class OrganizationInvitation(GitHubRestModel):
    """Organization Invitation

    Organization Invitation
    """

    id: int = Field(default=...)
    login: Union[str, None] = Field(default=...)
    email: Union[str, None] = Field(default=...)
    role: str = Field(default=...)
    created_at: str = Field(default=...)
    failed_at: Union[Unset, Union[str, None]] = Field(default=UNSET)
    failed_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    inviter: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    team_count: int = Field(default=...)
    node_id: str = Field(default=...)
    invitation_teams_url: str = Field(default=...)


class OrganizationFineGrainedPermission(GitHubRestModel):
    """Organization Fine-Grained Permission

    Fine-grained permissions available for the organization
    """

    name: str = Field(default=...)
    description: str = Field(default=...)


class OrgHook(GitHubRestModel):
    """Org Hook

    Org Hook
    """

    id: int = Field(default=...)
    url: str = Field(default=...)
    ping_url: str = Field(default=...)
    deliveries_url: Union[Unset, str] = Field(default=UNSET)
    name: str = Field(default=...)
    events: List[str] = Field(default=...)
    active: bool = Field(default=...)
    config: OrgHookPropConfig = Field(default=...)
    updated_at: datetime = Field(default=...)
    created_at: datetime = Field(default=...)
    type: str = Field(default=...)


class OrgHookPropConfig(GitHubRestModel):
    """OrgHookPropConfig"""

    url: Union[Unset, str] = Field(default=UNSET)
    insecure_ssl: Union[Unset, str] = Field(default=UNSET)
    content_type: Union[Unset, str] = Field(default=UNSET)
    secret: Union[Unset, str] = Field(default=UNSET)


class InteractionLimitResponse(GitHubRestModel):
    """Interaction Limits

    Interaction limit settings.
    """

    limit: Literal["existing_users", "contributors_only", "collaborators_only"] = Field(
        description="The type of GitHub user that can comment, open issues, or create pull requests while the interaction limit is in effect.",
        default=...,
    )
    origin: str = Field(default=...)
    expires_at: datetime = Field(default=...)


class InteractionLimit(GitHubRestModel):
    """Interaction Restrictions

    Limit interactions to a specific type of user for a specified duration
    """

    limit: Literal["existing_users", "contributors_only", "collaborators_only"] = Field(
        description="The type of GitHub user that can comment, open issues, or create pull requests while the interaction limit is in effect.",
        default=...,
    )
    expiry: Union[
        Unset, Literal["one_day", "three_days", "one_week", "one_month", "six_months"]
    ] = Field(
        description="The duration of the interaction restriction. Default: `one_day`.",
        default=UNSET,
    )


class TeamSimple(GitHubRestModel):
    """Team Simple

    Groups of organization members that gives permissions on specified repositories.
    """

    id: int = Field(description="Unique identifier of the team", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the team", default=...)
    members_url: str = Field(default=...)
    name: str = Field(description="Name of the team", default=...)
    description: Union[str, None] = Field(
        description="Description of the team", default=...
    )
    permission: str = Field(
        description="Permission that the team will have for its repositories",
        default=...,
    )
    privacy: Union[Unset, str] = Field(
        description="The level of privacy this team should have", default=UNSET
    )
    html_url: str = Field(default=...)
    repositories_url: str = Field(default=...)
    slug: str = Field(default=...)
    ldap_dn: Union[Unset, str] = Field(
        description="Distinguished Name (DN) that team maps to within LDAP environment",
        default=UNSET,
    )


class Team(GitHubRestModel):
    """Team

    Groups of organization members that gives permissions on specified repositories.
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(default=...)
    slug: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    privacy: Union[Unset, str] = Field(default=UNSET)
    permission: str = Field(default=...)
    permissions: Union[Unset, TeamPropPermissions] = Field(default=UNSET)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    members_url: str = Field(default=...)
    repositories_url: str = Field(default=...)
    parent: Union[None, TeamSimple] = Field(
        title="Team Simple",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=...,
    )


class TeamPropPermissions(GitHubRestModel):
    """TeamPropPermissions"""

    pull: bool = Field(default=...)
    triage: bool = Field(default=...)
    push: bool = Field(default=...)
    maintain: bool = Field(default=...)
    admin: bool = Field(default=...)


class OrgMembership(GitHubRestModel):
    """Org Membership

    Org Membership
    """

    url: str = Field(default=...)
    state: Literal["active", "pending"] = Field(
        description="The state of the member in the organization. The `pending` state indicates the user has not yet accepted an invitation.",
        default=...,
    )
    role: Literal["admin", "member", "billing_manager"] = Field(
        description="The user's membership type in the organization.", default=...
    )
    organization_url: str = Field(default=...)
    organization: OrganizationSimple = Field(
        title="Organization Simple", description="Organization Simple", default=...
    )
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    permissions: Union[Unset, OrgMembershipPropPermissions] = Field(default=UNSET)


class OrgMembershipPropPermissions(GitHubRestModel):
    """OrgMembershipPropPermissions"""

    can_create_repository: bool = Field(default=...)


class Migration(GitHubRestModel):
    """Migration

    A migration.
    """

    id: int = Field(default=...)
    owner: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    guid: str = Field(default=...)
    state: str = Field(default=...)
    lock_repositories: bool = Field(default=...)
    exclude_metadata: bool = Field(default=...)
    exclude_git_data: bool = Field(default=...)
    exclude_attachments: bool = Field(default=...)
    exclude_releases: bool = Field(default=...)
    exclude_owner_projects: bool = Field(default=...)
    org_metadata_only: bool = Field(default=...)
    repositories: List[Repository] = Field(default=...)
    url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    node_id: str = Field(default=...)
    archive_url: Union[Unset, str] = Field(default=UNSET)
    exclude: Union[Unset, List[Any]] = Field(default=UNSET)


class Package(GitHubRestModel):
    """Package

    A software package
    """

    id: int = Field(description="Unique identifier of the package.", default=...)
    name: str = Field(description="The name of the package.", default=...)
    package_type: Literal[
        "npm", "maven", "rubygems", "docker", "nuget", "container"
    ] = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    version_count: int = Field(
        description="The number of versions of the package.", default=...
    )
    visibility: Literal["private", "public"] = Field(default=...)
    owner: Union[Unset, Union[None, SimpleUser]] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    repository: Union[Unset, Union[None, MinimalRepository]] = Field(
        title="Minimal Repository", description="Minimal Repository", default=UNSET
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class PackageVersion(GitHubRestModel):
    """Package Version

    A version of a software package
    """

    id: int = Field(
        description="Unique identifier of the package version.", default=...
    )
    name: str = Field(description="The name of the package version.", default=...)
    url: str = Field(default=...)
    package_html_url: str = Field(default=...)
    html_url: Union[Unset, str] = Field(default=UNSET)
    license_: Union[Unset, str] = Field(default=UNSET, alias="license")
    description: Union[Unset, str] = Field(default=UNSET)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    deleted_at: Union[Unset, datetime] = Field(default=UNSET)
    metadata: Union[Unset, PackageVersionPropMetadata] = Field(
        title="Package Version Metadata", default=UNSET
    )


class PackageVersionPropMetadata(GitHubRestModel):
    """Package Version Metadata"""

    package_type: Literal[
        "npm", "maven", "rubygems", "docker", "nuget", "container"
    ] = Field(default=...)
    container: Union[Unset, PackageVersionPropMetadataPropContainer] = Field(
        title="Container Metadata", default=UNSET
    )
    docker: Union[Unset, PackageVersionPropMetadataPropDocker] = Field(
        title="Docker Metadata", default=UNSET
    )


class PackageVersionPropMetadataPropContainer(GitHubRestModel):
    """Container Metadata"""

    tags: List[str] = Field(default=...)


class PackageVersionPropMetadataPropDocker(GitHubRestModel):
    """Docker Metadata"""

    tag: Union[Unset, List[str]] = Field(default=UNSET)


class Project(GitHubRestModel):
    """Project

    Projects are a way to organize columns and cards of work.
    """

    owner_url: str = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    columns_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="Name of the project", default=...)
    body: Union[str, None] = Field(description="Body of the project", default=...)
    number: int = Field(default=...)
    state: str = Field(
        description="State of the project; either 'open' or 'closed'", default=...
    )
    creator: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    organization_permission: Union[
        Unset, Literal["read", "write", "admin", "none"]
    ] = Field(
        description="The baseline permission that all organization members have on this project. Only present if owner is an organization.",
        default=UNSET,
    )
    private: Union[Unset, bool] = Field(
        description="Whether or not this project can be seen by everyone. Only present if owner is an organization.",
        default=UNSET,
    )


class ActionsBillingUsage(GitHubRestModel):
    """ActionsBillingUsage"""

    total_minutes_used: int = Field(
        description="The sum of the free and paid GitHub Actions minutes used.",
        default=...,
    )
    total_paid_minutes_used: int = Field(
        description="The total paid GitHub Actions minutes used.", default=...
    )
    included_minutes: int = Field(
        description="The amount of free GitHub Actions minutes available.", default=...
    )
    minutes_used_breakdown: ActionsBillingUsagePropMinutesUsedBreakdown = Field(
        default=...
    )


class ActionsBillingUsagePropMinutesUsedBreakdown(GitHubRestModel):
    """ActionsBillingUsagePropMinutesUsedBreakdown"""

    ubuntu: Union[Unset, int] = Field(
        description="Total minutes used on Ubuntu runner machines.",
        default=UNSET,
        alias="UBUNTU",
    )
    macos: Union[Unset, int] = Field(
        description="Total minutes used on macOS runner machines.",
        default=UNSET,
        alias="MACOS",
    )
    windows: Union[Unset, int] = Field(
        description="Total minutes used on Windows runner machines.",
        default=UNSET,
        alias="WINDOWS",
    )
    ubuntu_4_core: Union[Unset, int] = Field(
        description="Total minutes used on Ubuntu 4 core runner machines.",
        default=UNSET,
    )
    ubuntu_8_core: Union[Unset, int] = Field(
        description="Total minutes used on Ubuntu 8 core runner machines.",
        default=UNSET,
    )
    ubuntu_16_core: Union[Unset, int] = Field(
        description="Total minutes used on Ubuntu 16 core runner machines.",
        default=UNSET,
    )
    ubuntu_32_core: Union[Unset, int] = Field(
        description="Total minutes used on Ubuntu 32 core runner machines.",
        default=UNSET,
    )
    ubuntu_64_core: Union[Unset, int] = Field(
        description="Total minutes used on Ubuntu 64 core runner machines.",
        default=UNSET,
    )
    windows_4_core: Union[Unset, int] = Field(
        description="Total minutes used on Windows 4 core runner machines.",
        default=UNSET,
    )
    windows_8_core: Union[Unset, int] = Field(
        description="Total minutes used on Windows 8 core runner machines.",
        default=UNSET,
    )
    windows_16_core: Union[Unset, int] = Field(
        description="Total minutes used on Windows 16 core runner machines.",
        default=UNSET,
    )
    windows_32_core: Union[Unset, int] = Field(
        description="Total minutes used on Windows 32 core runner machines.",
        default=UNSET,
    )
    windows_64_core: Union[Unset, int] = Field(
        description="Total minutes used on Windows 64 core runner machines.",
        default=UNSET,
    )
    total: Union[Unset, int] = Field(
        description="Total minutes used on all runner machines.", default=UNSET
    )


class PackagesBillingUsage(GitHubRestModel):
    """PackagesBillingUsage"""

    total_gigabytes_bandwidth_used: int = Field(
        description="Sum of the free and paid storage space (GB) for GitHuub Packages.",
        default=...,
    )
    total_paid_gigabytes_bandwidth_used: int = Field(
        description="Total paid storage space (GB) for GitHuub Packages.", default=...
    )
    included_gigabytes_bandwidth: int = Field(
        description="Free storage space (GB) for GitHub Packages.", default=...
    )


class CombinedBillingUsage(GitHubRestModel):
    """CombinedBillingUsage"""

    days_left_in_billing_cycle: int = Field(
        description="Numbers of days left in billing cycle.", default=...
    )
    estimated_paid_storage_for_month: int = Field(
        description="Estimated storage space (GB) used in billing cycle.", default=...
    )
    estimated_storage_for_month: int = Field(
        description="Estimated sum of free and paid storage space (GB) used in billing cycle.",
        default=...,
    )


class TeamOrganization(GitHubRestModel):
    """Team Organization

    Team Organization
    """

    login: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    hooks_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    members_url: str = Field(default=...)
    public_members_url: str = Field(default=...)
    avatar_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    company: Union[Unset, str] = Field(default=UNSET)
    blog: Union[Unset, str] = Field(default=UNSET)
    location: Union[Unset, str] = Field(default=UNSET)
    email: Union[Unset, str] = Field(default=UNSET)
    twitter_username: Union[Unset, Union[str, None]] = Field(default=UNSET)
    is_verified: Union[Unset, bool] = Field(default=UNSET)
    has_organization_projects: bool = Field(default=...)
    has_repository_projects: bool = Field(default=...)
    public_repos: int = Field(default=...)
    public_gists: int = Field(default=...)
    followers: int = Field(default=...)
    following: int = Field(default=...)
    html_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    type: str = Field(default=...)
    total_private_repos: Union[Unset, int] = Field(default=UNSET)
    owned_private_repos: Union[Unset, int] = Field(default=UNSET)
    private_gists: Union[Unset, Union[int, None]] = Field(default=UNSET)
    disk_usage: Union[Unset, Union[int, None]] = Field(default=UNSET)
    collaborators: Union[Unset, Union[int, None]] = Field(default=UNSET)
    billing_email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    plan: Union[Unset, TeamOrganizationPropPlan] = Field(default=UNSET)
    default_repository_permission: Union[Unset, Union[str, None]] = Field(default=UNSET)
    members_can_create_repositories: Union[Unset, Union[bool, None]] = Field(
        default=UNSET
    )
    two_factor_requirement_enabled: Union[Unset, Union[bool, None]] = Field(
        default=UNSET
    )
    members_allowed_repository_creation_type: Union[Unset, str] = Field(default=UNSET)
    members_can_create_public_repositories: Union[Unset, bool] = Field(default=UNSET)
    members_can_create_private_repositories: Union[Unset, bool] = Field(default=UNSET)
    members_can_create_internal_repositories: Union[Unset, bool] = Field(default=UNSET)
    members_can_create_pages: Union[Unset, bool] = Field(default=UNSET)
    members_can_create_public_pages: Union[Unset, bool] = Field(default=UNSET)
    members_can_create_private_pages: Union[Unset, bool] = Field(default=UNSET)
    members_can_fork_private_repositories: Union[Unset, Union[bool, None]] = Field(
        default=UNSET
    )
    web_commit_signoff_required: Union[Unset, bool] = Field(default=UNSET)
    updated_at: datetime = Field(default=...)


class TeamOrganizationPropPlan(GitHubRestModel):
    """TeamOrganizationPropPlan"""

    name: str = Field(default=...)
    space: int = Field(default=...)
    private_repos: int = Field(default=...)
    filled_seats: Union[Unset, int] = Field(default=UNSET)
    seats: Union[Unset, int] = Field(default=UNSET)


class TeamFull(GitHubRestModel):
    """Full Team

    Groups of organization members that gives permissions on specified repositories.
    """

    id: int = Field(description="Unique identifier of the team", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the team", default=...)
    html_url: str = Field(default=...)
    name: str = Field(description="Name of the team", default=...)
    slug: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    privacy: Union[Unset, Literal["closed", "secret"]] = Field(
        description="The level of privacy this team should have", default=UNSET
    )
    permission: str = Field(
        description="Permission that the team will have for its repositories",
        default=...,
    )
    members_url: str = Field(default=...)
    repositories_url: str = Field(default=...)
    parent: Union[Unset, Union[None, TeamSimple]] = Field(
        title="Team Simple",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=UNSET,
    )
    members_count: int = Field(default=...)
    repos_count: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    organization: TeamOrganization = Field(
        title="Team Organization", description="Team Organization", default=...
    )
    ldap_dn: Union[Unset, str] = Field(
        description="Distinguished Name (DN) that team maps to within LDAP environment",
        default=UNSET,
    )


class TeamDiscussion(GitHubRestModel):
    """Team Discussion

    A team discussion is a persistent record of a free-form conversation within a
    team.
    """

    author: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    body: str = Field(description="The main text of the discussion.", default=...)
    body_html: str = Field(default=...)
    body_version: str = Field(
        description="The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.",
        default=...,
    )
    comments_count: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    last_edited_at: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(
        description="The unique sequence number of a team discussion.", default=...
    )
    pinned: bool = Field(
        description="Whether or not this discussion should be pinned for easy retrieval.",
        default=...,
    )
    private: bool = Field(
        description="Whether or not this discussion should be restricted to team members and organization administrators.",
        default=...,
    )
    team_url: str = Field(default=...)
    title: str = Field(description="The title of the discussion.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)
    reactions: Union[Unset, ReactionRollup] = Field(
        title="Reaction Rollup", default=UNSET
    )


class TeamDiscussionComment(GitHubRestModel):
    """Team Discussion Comment

    A reply to a discussion within a team.
    """

    author: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    body: str = Field(description="The main text of the comment.", default=...)
    body_html: str = Field(default=...)
    body_version: str = Field(
        description="The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.",
        default=...,
    )
    created_at: datetime = Field(default=...)
    last_edited_at: Union[datetime, None] = Field(default=...)
    discussion_url: str = Field(default=...)
    html_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(
        description="The unique sequence number of a team discussion comment.",
        default=...,
    )
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)
    reactions: Union[Unset, ReactionRollup] = Field(
        title="Reaction Rollup", default=UNSET
    )


class Reaction(GitHubRestModel):
    """Reaction

    Reactions to conversations provide a way to help people express their feelings
    more simply and effectively.
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ] = Field(description="The reaction to use", default=...)
    created_at: datetime = Field(default=...)


class TeamMembership(GitHubRestModel):
    """Team Membership

    Team Membership
    """

    url: str = Field(default=...)
    role: Literal["member", "maintainer"] = Field(
        description="The role of the user in the team.", default="member"
    )
    state: Literal["active", "pending"] = Field(
        description="The state of the user's membership in the team.", default=...
    )


class TeamProject(GitHubRestModel):
    """Team Project

    A team's access to a project.
    """

    owner_url: str = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    columns_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(default=...)
    body: Union[str, None] = Field(default=...)
    number: int = Field(default=...)
    state: str = Field(default=...)
    creator: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    created_at: str = Field(default=...)
    updated_at: str = Field(default=...)
    organization_permission: Union[Unset, str] = Field(
        description="The organization permission for this project. Only present when owner is an organization.",
        default=UNSET,
    )
    private: Union[Unset, bool] = Field(
        description="Whether the project is private or not. Only present when owner is an organization.",
        default=UNSET,
    )
    permissions: TeamProjectPropPermissions = Field(default=...)


class TeamProjectPropPermissions(GitHubRestModel):
    """TeamProjectPropPermissions"""

    read: bool = Field(default=...)
    write: bool = Field(default=...)
    admin: bool = Field(default=...)


class TeamRepository(GitHubRestModel):
    """Team Repository

    A team's access to a repository.
    """

    id: int = Field(description="Unique identifier of the repository", default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(default=...)
    license_: Union[None, LicenseSimple] = Field(
        title="License Simple",
        description="License Simple",
        default=...,
        alias="license",
    )
    forks: int = Field(default=...)
    permissions: Union[Unset, TeamRepositoryPropPermissions] = Field(default=UNSET)
    role_name: Union[Unset, str] = Field(default=UNSET)
    owner: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    private: bool = Field(
        description="Whether the repository is private or public.", default=False
    )
    html_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    fork: bool = Field(default=...)
    url: str = Field(default=...)
    archive_url: str = Field(default=...)
    assignees_url: str = Field(default=...)
    blobs_url: str = Field(default=...)
    branches_url: str = Field(default=...)
    collaborators_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    compare_url: str = Field(default=...)
    contents_url: str = Field(default=...)
    contributors_url: str = Field(default=...)
    deployments_url: str = Field(default=...)
    downloads_url: str = Field(default=...)
    events_url: str = Field(default=...)
    forks_url: str = Field(default=...)
    git_commits_url: str = Field(default=...)
    git_refs_url: str = Field(default=...)
    git_tags_url: str = Field(default=...)
    git_url: str = Field(default=...)
    issue_comment_url: str = Field(default=...)
    issue_events_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    keys_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    languages_url: str = Field(default=...)
    merges_url: str = Field(default=...)
    milestones_url: str = Field(default=...)
    notifications_url: str = Field(default=...)
    pulls_url: str = Field(default=...)
    releases_url: str = Field(default=...)
    ssh_url: str = Field(default=...)
    stargazers_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    subscribers_url: str = Field(default=...)
    subscription_url: str = Field(default=...)
    tags_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    trees_url: str = Field(default=...)
    clone_url: str = Field(default=...)
    mirror_url: Union[str, None] = Field(default=...)
    hooks_url: str = Field(default=...)
    svn_url: str = Field(default=...)
    homepage: Union[str, None] = Field(default=...)
    language: Union[str, None] = Field(default=...)
    forks_count: int = Field(default=...)
    stargazers_count: int = Field(default=...)
    watchers_count: int = Field(default=...)
    size: int = Field(default=...)
    default_branch: str = Field(
        description="The default branch of the repository.", default=...
    )
    open_issues_count: int = Field(default=...)
    is_template: Union[Unset, bool] = Field(
        description="Whether this repository acts as a template that can be used to generate new repositories.",
        default=False,
    )
    topics: Union[Unset, List[str]] = Field(default=UNSET)
    has_issues: bool = Field(description="Whether issues are enabled.", default=True)
    has_projects: bool = Field(
        description="Whether projects are enabled.", default=True
    )
    has_wiki: bool = Field(description="Whether the wiki is enabled.", default=True)
    has_pages: bool = Field(default=...)
    has_downloads: bool = Field(
        description="Whether downloads are enabled.", default=True
    )
    archived: bool = Field(
        description="Whether the repository is archived.", default=False
    )
    disabled: bool = Field(
        description="Returns whether or not this repository disabled.", default=...
    )
    visibility: Union[Unset, str] = Field(
        description="The repository visibility: public, private, or internal.",
        default="public",
    )
    pushed_at: Union[datetime, None] = Field(default=...)
    created_at: Union[datetime, None] = Field(default=...)
    updated_at: Union[datetime, None] = Field(default=...)
    allow_rebase_merge: Union[Unset, bool] = Field(
        description="Whether to allow rebase merges for pull requests.", default=True
    )
    template_repository: Union[Unset, Union[None, Repository]] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    temp_clone_token: Union[Unset, str] = Field(default=UNSET)
    allow_squash_merge: Union[Unset, bool] = Field(
        description="Whether to allow squash merges for pull requests.", default=True
    )
    allow_auto_merge: Union[Unset, bool] = Field(
        description="Whether to allow Auto-merge to be used on pull requests.",
        default=False,
    )
    delete_branch_on_merge: Union[Unset, bool] = Field(
        description="Whether to delete head branches when pull requests are merged",
        default=False,
    )
    allow_merge_commit: Union[Unset, bool] = Field(
        description="Whether to allow merge commits for pull requests.", default=True
    )
    allow_forking: Union[Unset, bool] = Field(
        description="Whether to allow forking this repo", default=False
    )
    web_commit_signoff_required: Union[Unset, bool] = Field(
        description="Whether to require contributors to sign off on web-based commits",
        default=False,
    )
    subscribers_count: Union[Unset, int] = Field(default=UNSET)
    network_count: Union[Unset, int] = Field(default=UNSET)
    open_issues: int = Field(default=...)
    watchers: int = Field(default=...)
    master_branch: Union[Unset, str] = Field(default=UNSET)


class TeamRepositoryPropPermissions(GitHubRestModel):
    """TeamRepositoryPropPermissions"""

    admin: bool = Field(default=...)
    pull: bool = Field(default=...)
    triage: Union[Unset, bool] = Field(default=UNSET)
    push: bool = Field(default=...)
    maintain: Union[Unset, bool] = Field(default=UNSET)


class ProjectCard(GitHubRestModel):
    """Project Card

    Project cards represent a scope of work.
    """

    url: str = Field(default=...)
    id: int = Field(description="The project card's ID", default=...)
    node_id: str = Field(default=...)
    note: Union[str, None] = Field(default=...)
    creator: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    archived: Union[Unset, bool] = Field(
        description="Whether or not the card is archived", default=UNSET
    )
    column_name: Union[Unset, str] = Field(default=UNSET)
    project_id: Union[Unset, str] = Field(default=UNSET)
    column_url: str = Field(default=...)
    content_url: Union[Unset, str] = Field(default=UNSET)
    project_url: str = Field(default=...)


class ProjectColumn(GitHubRestModel):
    """Project Column

    Project columns contain cards of work.
    """

    url: str = Field(default=...)
    project_url: str = Field(default=...)
    cards_url: str = Field(default=...)
    id: int = Field(
        description="The unique identifier of the project column", default=...
    )
    node_id: str = Field(default=...)
    name: str = Field(description="Name of the project column", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class ProjectCollaboratorPermission(GitHubRestModel):
    """Project Collaborator Permission

    Project Collaborator Permission
    """

    permission: str = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )


class RateLimit(GitHubRestModel):
    """Rate Limit"""

    limit: int = Field(default=...)
    remaining: int = Field(default=...)
    reset: int = Field(default=...)
    used: int = Field(default=...)


class RateLimitOverview(GitHubRestModel):
    """Rate Limit Overview

    Rate Limit Overview
    """

    resources: RateLimitOverviewPropResources = Field(default=...)
    rate: RateLimit = Field(title="Rate Limit", default=...)


class RateLimitOverviewPropResources(GitHubRestModel):
    """RateLimitOverviewPropResources"""

    core: RateLimit = Field(title="Rate Limit", default=...)
    graphql: Union[Unset, RateLimit] = Field(title="Rate Limit", default=UNSET)
    search: RateLimit = Field(title="Rate Limit", default=...)
    source_import: Union[Unset, RateLimit] = Field(title="Rate Limit", default=UNSET)
    integration_manifest: Union[Unset, RateLimit] = Field(
        title="Rate Limit", default=UNSET
    )
    code_scanning_upload: Union[Unset, RateLimit] = Field(
        title="Rate Limit", default=UNSET
    )
    actions_runner_registration: Union[Unset, RateLimit] = Field(
        title="Rate Limit", default=UNSET
    )
    scim: Union[Unset, RateLimit] = Field(title="Rate Limit", default=UNSET)
    dependency_snapshots: Union[Unset, RateLimit] = Field(
        title="Rate Limit", default=UNSET
    )


class CodeOfConductSimple(GitHubRestModel):
    """Code Of Conduct Simple

    Code of Conduct Simple
    """

    url: str = Field(default=...)
    key: str = Field(default=...)
    name: str = Field(default=...)
    html_url: Union[str, None] = Field(default=...)


class SecurityAndAnalysisPropAdvancedSecurity(GitHubRestModel):
    """SecurityAndAnalysisPropAdvancedSecurity"""

    status: Union[Unset, Literal["enabled", "disabled"]] = Field(default=UNSET)


class SecurityAndAnalysisPropSecretScanning(GitHubRestModel):
    """SecurityAndAnalysisPropSecretScanning"""

    status: Union[Unset, Literal["enabled", "disabled"]] = Field(default=UNSET)


class SecurityAndAnalysisPropSecretScanningPushProtection(GitHubRestModel):
    """SecurityAndAnalysisPropSecretScanningPushProtection"""

    status: Union[Unset, Literal["enabled", "disabled"]] = Field(default=UNSET)


class SecurityAndAnalysis(GitHubRestModel):
    """SecurityAndAnalysis"""

    advanced_security: Union[Unset, SecurityAndAnalysisPropAdvancedSecurity] = Field(
        default=UNSET
    )
    secret_scanning: Union[Unset, SecurityAndAnalysisPropSecretScanning] = Field(
        default=UNSET
    )
    secret_scanning_push_protection: Union[
        Unset, SecurityAndAnalysisPropSecretScanningPushProtection
    ] = Field(default=UNSET)


class FullRepository(GitHubRestModel):
    """Full Repository

    Full Repository
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(default=...)
    full_name: str = Field(default=...)
    owner: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    private: bool = Field(default=...)
    html_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    fork: bool = Field(default=...)
    url: str = Field(default=...)
    archive_url: str = Field(default=...)
    assignees_url: str = Field(default=...)
    blobs_url: str = Field(default=...)
    branches_url: str = Field(default=...)
    collaborators_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    compare_url: str = Field(default=...)
    contents_url: str = Field(default=...)
    contributors_url: str = Field(default=...)
    deployments_url: str = Field(default=...)
    downloads_url: str = Field(default=...)
    events_url: str = Field(default=...)
    forks_url: str = Field(default=...)
    git_commits_url: str = Field(default=...)
    git_refs_url: str = Field(default=...)
    git_tags_url: str = Field(default=...)
    git_url: str = Field(default=...)
    issue_comment_url: str = Field(default=...)
    issue_events_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    keys_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    languages_url: str = Field(default=...)
    merges_url: str = Field(default=...)
    milestones_url: str = Field(default=...)
    notifications_url: str = Field(default=...)
    pulls_url: str = Field(default=...)
    releases_url: str = Field(default=...)
    ssh_url: str = Field(default=...)
    stargazers_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    subscribers_url: str = Field(default=...)
    subscription_url: str = Field(default=...)
    tags_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    trees_url: str = Field(default=...)
    clone_url: str = Field(default=...)
    mirror_url: Union[str, None] = Field(default=...)
    hooks_url: str = Field(default=...)
    svn_url: str = Field(default=...)
    homepage: Union[str, None] = Field(default=...)
    language: Union[str, None] = Field(default=...)
    forks_count: int = Field(default=...)
    stargazers_count: int = Field(default=...)
    watchers_count: int = Field(default=...)
    size: int = Field(
        description="The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.",
        default=...,
    )
    default_branch: str = Field(default=...)
    open_issues_count: int = Field(default=...)
    is_template: Union[Unset, bool] = Field(default=UNSET)
    topics: Union[Unset, List[str]] = Field(default=UNSET)
    has_issues: bool = Field(default=...)
    has_projects: bool = Field(default=...)
    has_wiki: bool = Field(default=...)
    has_pages: bool = Field(default=...)
    has_downloads: bool = Field(default=...)
    archived: bool = Field(default=...)
    disabled: bool = Field(
        description="Returns whether or not this repository disabled.", default=...
    )
    visibility: Union[Unset, str] = Field(
        description="The repository visibility: public, private, or internal.",
        default=UNSET,
    )
    pushed_at: datetime = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    permissions: Union[Unset, FullRepositoryPropPermissions] = Field(default=UNSET)
    allow_rebase_merge: Union[Unset, bool] = Field(default=UNSET)
    template_repository: Union[Unset, Union[None, Repository]] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    temp_clone_token: Union[Unset, Union[str, None]] = Field(default=UNSET)
    allow_squash_merge: Union[Unset, bool] = Field(default=UNSET)
    allow_auto_merge: Union[Unset, bool] = Field(default=UNSET)
    delete_branch_on_merge: Union[Unset, bool] = Field(default=UNSET)
    allow_merge_commit: Union[Unset, bool] = Field(default=UNSET)
    allow_update_branch: Union[Unset, bool] = Field(default=UNSET)
    use_squash_pr_title_as_default: Union[Unset, bool] = Field(default=UNSET)
    squash_merge_commit_title: Union[
        Unset, Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
    ] = Field(
        description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
        default=UNSET,
    )
    squash_merge_commit_message: Union[
        Unset, Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    merge_commit_title: Union[Unset, Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        description="The default value for a merge commit title.\n\n  - `PR_TITLE` - default to the pull request's title.\n  - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
        default=UNSET,
    )
    merge_commit_message: Union[Unset, Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    allow_forking: Union[Unset, bool] = Field(default=UNSET)
    web_commit_signoff_required: Union[Unset, bool] = Field(default=UNSET)
    subscribers_count: int = Field(default=...)
    network_count: int = Field(default=...)
    license_: Union[None, LicenseSimple] = Field(
        title="License Simple",
        description="License Simple",
        default=...,
        alias="license",
    )
    organization: Union[Unset, Union[None, SimpleUser]] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    parent: Union[Unset, Repository] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    source: Union[Unset, Repository] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    forks: int = Field(default=...)
    master_branch: Union[Unset, str] = Field(default=UNSET)
    open_issues: int = Field(default=...)
    watchers: int = Field(default=...)
    anonymous_access_enabled: Union[Unset, bool] = Field(
        description="Whether anonymous git access is allowed.", default=True
    )
    code_of_conduct: Union[Unset, CodeOfConductSimple] = Field(
        title="Code Of Conduct Simple",
        description="Code of Conduct Simple",
        default=UNSET,
    )
    security_and_analysis: Union[Unset, Union[SecurityAndAnalysis, None]] = Field(
        default=UNSET
    )


class FullRepositoryPropPermissions(GitHubRestModel):
    """FullRepositoryPropPermissions"""

    admin: bool = Field(default=...)
    maintain: Union[Unset, bool] = Field(default=UNSET)
    push: bool = Field(default=...)
    triage: Union[Unset, bool] = Field(default=UNSET)
    pull: bool = Field(default=...)


class Artifact(GitHubRestModel):
    """Artifact

    An artifact
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the artifact.", default=...)
    size_in_bytes: int = Field(
        description="The size in bytes of the artifact.", default=...
    )
    url: str = Field(default=...)
    archive_download_url: str = Field(default=...)
    expired: bool = Field(
        description="Whether or not the artifact has expired.", default=...
    )
    created_at: Union[datetime, None] = Field(default=...)
    expires_at: Union[datetime, None] = Field(default=...)
    updated_at: Union[datetime, None] = Field(default=...)
    workflow_run: Union[Unset, Union[ArtifactPropWorkflowRun, None]] = Field(
        default=UNSET
    )


class ArtifactPropWorkflowRun(GitHubRestModel):
    """ArtifactPropWorkflowRun"""

    id: Union[Unset, int] = Field(default=UNSET)
    repository_id: Union[Unset, int] = Field(default=UNSET)
    head_repository_id: Union[Unset, int] = Field(default=UNSET)
    head_branch: Union[Unset, str] = Field(default=UNSET)
    head_sha: Union[Unset, str] = Field(default=UNSET)


class ActionsCacheList(GitHubRestModel):
    """Repository actions caches

    Repository actions caches
    """

    total_count: int = Field(description="Total number of caches", default=...)
    actions_caches: List[ActionsCacheListPropActionsCachesItems] = Field(
        description="Array of caches", default=...
    )


class ActionsCacheListPropActionsCachesItems(GitHubRestModel):
    """ActionsCacheListPropActionsCachesItems"""

    id: Union[Unset, int] = Field(default=UNSET)
    ref: Union[Unset, str] = Field(default=UNSET)
    key: Union[Unset, str] = Field(default=UNSET)
    version: Union[Unset, str] = Field(default=UNSET)
    last_accessed_at: Union[Unset, datetime] = Field(default=UNSET)
    created_at: Union[Unset, datetime] = Field(default=UNSET)
    size_in_bytes: Union[Unset, int] = Field(default=UNSET)


class Job(GitHubRestModel):
    """Job

    Information of a job execution in a workflow run
    """

    id: int = Field(description="The id of the job.", default=...)
    run_id: int = Field(
        description="The id of the associated workflow run.", default=...
    )
    run_url: str = Field(default=...)
    run_attempt: Union[Unset, int] = Field(
        description="Attempt number of the associated workflow run, 1 for first attempt and higher if the workflow was re-run.",
        default=UNSET,
    )
    node_id: str = Field(default=...)
    head_sha: str = Field(
        description="The SHA of the commit that is being run.", default=...
    )
    url: str = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    status: Literal["queued", "in_progress", "completed"] = Field(
        description="The phase of the lifecycle that the job is currently in.",
        default=...,
    )
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "skipped",
            "timed_out",
            "action_required",
        ],
    ] = Field(description="The outcome of the job.", default=...)
    started_at: datetime = Field(
        description="The time that the job started, in ISO 8601 format.", default=...
    )
    completed_at: Union[datetime, None] = Field(
        description="The time that the job finished, in ISO 8601 format.", default=...
    )
    name: str = Field(description="The name of the job.", default=...)
    steps: Union[Unset, List[JobPropStepsItems]] = Field(
        description="Steps in this job.", default=UNSET
    )
    check_run_url: str = Field(default=...)
    labels: List[str] = Field(
        description='Labels for the workflow job. Specified by the "runs_on" attribute in the action\'s workflow file.',
        default=...,
    )
    runner_id: Union[int, None] = Field(
        description="The ID of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)",
        default=...,
    )
    runner_name: Union[str, None] = Field(
        description="The name of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)",
        default=...,
    )
    runner_group_id: Union[int, None] = Field(
        description="The ID of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)",
        default=...,
    )
    runner_group_name: Union[str, None] = Field(
        description="The name of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)",
        default=...,
    )


class JobPropStepsItems(GitHubRestModel):
    """JobPropStepsItems"""

    status: Literal["queued", "in_progress", "completed"] = Field(
        description="The phase of the lifecycle that the job is currently in.",
        default=...,
    )
    conclusion: Union[str, None] = Field(
        description="The outcome of the job.", default=...
    )
    name: str = Field(description="The name of the job.", default=...)
    number: int = Field(default=...)
    started_at: Union[Unset, Union[datetime, None]] = Field(
        description="The time that the step started, in ISO 8601 format.", default=UNSET
    )
    completed_at: Union[Unset, Union[datetime, None]] = Field(
        description="The time that the job finished, in ISO 8601 format.", default=UNSET
    )


class ActionsRepositoryPermissions(GitHubRestModel):
    """ActionsRepositoryPermissions"""

    enabled: bool = Field(
        description="Whether GitHub Actions is enabled on the repository.", default=...
    )
    allowed_actions: Union[Unset, Literal["all", "local_only", "selected"]] = Field(
        description="The permissions policy that controls the actions and reusable workflows that are allowed to run.",
        default=UNSET,
    )
    selected_actions_url: Union[Unset, str] = Field(
        description="The API URL to use to get or set the actions and reusable workflows that are allowed to run, when `allowed_actions` is set to `selected`.",
        default=UNSET,
    )


class ActionsWorkflowAccessToRepository(GitHubRestModel):
    """ActionsWorkflowAccessToRepository"""

    access_level: Literal["none", "organization", "enterprise"] = Field(
        description="Defines the level of access that workflows outside of the repository have to actions and reusable workflows within the\nrepository. `none` means access is only possible from workflows in this repository.",
        default=...,
    )


class ReferencedWorkflow(GitHubRestModel):
    """Referenced workflow

    A workflow referenced/reused by the initial caller workflow
    """

    path: str = Field(default=...)
    sha: str = Field(default=...)
    ref: Union[Unset, str] = Field(default=UNSET)


class PullRequestMinimal(GitHubRestModel):
    """Pull Request Minimal"""

    id: int = Field(default=...)
    number: int = Field(default=...)
    url: str = Field(default=...)
    head: PullRequestMinimalPropHead = Field(default=...)
    base: PullRequestMinimalPropBase = Field(default=...)


class PullRequestMinimalPropHead(GitHubRestModel):
    """PullRequestMinimalPropHead"""

    ref: str = Field(default=...)
    sha: str = Field(default=...)
    repo: PullRequestMinimalPropHeadPropRepo = Field(default=...)


class PullRequestMinimalPropHeadPropRepo(GitHubRestModel):
    """PullRequestMinimalPropHeadPropRepo"""

    id: int = Field(default=...)
    url: str = Field(default=...)
    name: str = Field(default=...)


class PullRequestMinimalPropBase(GitHubRestModel):
    """PullRequestMinimalPropBase"""

    ref: str = Field(default=...)
    sha: str = Field(default=...)
    repo: PullRequestMinimalPropBasePropRepo = Field(default=...)


class PullRequestMinimalPropBasePropRepo(GitHubRestModel):
    """PullRequestMinimalPropBasePropRepo"""

    id: int = Field(default=...)
    url: str = Field(default=...)
    name: str = Field(default=...)


class SimpleCommit(GitHubRestModel):
    """Simple Commit

    Simple Commit
    """

    id: str = Field(default=...)
    tree_id: str = Field(default=...)
    message: str = Field(default=...)
    timestamp: datetime = Field(default=...)
    author: Union[SimpleCommitPropAuthor, None] = Field(default=...)
    committer: Union[SimpleCommitPropCommitter, None] = Field(default=...)


class SimpleCommitPropAuthor(GitHubRestModel):
    """SimpleCommitPropAuthor"""

    name: str = Field(default=...)
    email: str = Field(default=...)


class SimpleCommitPropCommitter(GitHubRestModel):
    """SimpleCommitPropCommitter"""

    name: str = Field(default=...)
    email: str = Field(default=...)


class WorkflowRun(GitHubRestModel):
    """Workflow Run

    An invocation of a workflow
    """

    id: int = Field(description="The ID of the workflow run.", default=...)
    name: Union[Unset, Union[str, None]] = Field(
        description="The name of the workflow run.", default=UNSET
    )
    node_id: str = Field(default=...)
    check_suite_id: Union[Unset, int] = Field(
        description="The ID of the associated check suite.", default=UNSET
    )
    check_suite_node_id: Union[Unset, str] = Field(
        description="The node ID of the associated check suite.", default=UNSET
    )
    head_branch: Union[str, None] = Field(default=...)
    head_sha: str = Field(
        description="The SHA of the head commit that points to the version of the workflow being run.",
        default=...,
    )
    path: str = Field(description="The full path of the workflow", default=...)
    run_number: int = Field(
        description="The auto incrementing run number for the workflow run.",
        default=...,
    )
    run_attempt: Union[Unset, int] = Field(
        description="Attempt number of the run, 1 for first attempt and higher if the workflow was re-run.",
        default=UNSET,
    )
    referenced_workflows: Union[Unset, Union[List[ReferencedWorkflow], None]] = Field(
        default=UNSET
    )
    event: str = Field(default=...)
    status: Union[str, None] = Field(default=...)
    conclusion: Union[str, None] = Field(default=...)
    workflow_id: int = Field(description="The ID of the parent workflow.", default=...)
    url: str = Field(description="The URL to the workflow run.", default=...)
    html_url: str = Field(default=...)
    pull_requests: Union[List[PullRequestMinimal], None] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    actor: Union[Unset, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    triggering_actor: Union[Unset, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    run_started_at: Union[Unset, datetime] = Field(
        description="The start time of the latest run. Resets on re-run.", default=UNSET
    )
    jobs_url: str = Field(
        description="The URL to the jobs for the workflow run.", default=...
    )
    logs_url: str = Field(
        description="The URL to download the logs for the workflow run.", default=...
    )
    check_suite_url: str = Field(
        description="The URL to the associated check suite.", default=...
    )
    artifacts_url: str = Field(
        description="The URL to the artifacts for the workflow run.", default=...
    )
    cancel_url: str = Field(
        description="The URL to cancel the workflow run.", default=...
    )
    rerun_url: str = Field(
        description="The URL to rerun the workflow run.", default=...
    )
    previous_attempt_url: Union[Unset, Union[str, None]] = Field(
        description="The URL to the previous attempted run of this workflow, if one exists.",
        default=UNSET,
    )
    workflow_url: str = Field(description="The URL to the workflow.", default=...)
    head_commit: Union[None, SimpleCommit] = Field(
        title="Simple Commit", description="Simple Commit", default=...
    )
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository", default=...
    )
    head_repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository", default=...
    )
    head_repository_id: Union[Unset, int] = Field(default=UNSET)
    display_title: str = Field(
        description="The event-specific title associated with the run or the run-name if set, or the value of `run-name` if it is set in the workflow.",
        default=...,
    )


class EnvironmentApprovals(GitHubRestModel):
    """Environment Approval

    An entry in the reviews log for environment deployments
    """

    environments: List[EnvironmentApprovalsPropEnvironmentsItems] = Field(
        description="The list of environments that were approved or rejected",
        default=...,
    )
    state: Literal["approved", "rejected"] = Field(
        description="Whether deployment to the environment(s) was approved or rejected",
        default=...,
    )
    user: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    comment: str = Field(
        description="The comment submitted with the deployment review", default=...
    )


class EnvironmentApprovalsPropEnvironmentsItems(GitHubRestModel):
    """EnvironmentApprovalsPropEnvironmentsItems"""

    id: Union[Unset, int] = Field(
        description="The id of the environment.", default=UNSET
    )
    node_id: Union[Unset, str] = Field(default=UNSET)
    name: Union[Unset, str] = Field(
        description="The name of the environment.", default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    created_at: Union[Unset, datetime] = Field(
        description="The time that the environment was created, in ISO 8601 format.",
        default=UNSET,
    )
    updated_at: Union[Unset, datetime] = Field(
        description="The time that the environment was last updated, in ISO 8601 format.",
        default=UNSET,
    )


class PendingDeployment(GitHubRestModel):
    """Pending Deployment

    Details of a deployment that is waiting for protection rules to pass
    """

    environment: PendingDeploymentPropEnvironment = Field(default=...)
    wait_timer: int = Field(
        description="The set duration of the wait timer", default=...
    )
    wait_timer_started_at: Union[datetime, None] = Field(
        description="The time that the wait timer began.", default=...
    )
    current_user_can_approve: bool = Field(
        description="Whether the currently authenticated user can approve the deployment",
        default=...,
    )
    reviewers: List[PendingDeploymentPropReviewersItems] = Field(
        description="The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.",
        default=...,
    )


class PendingDeploymentPropEnvironment(GitHubRestModel):
    """PendingDeploymentPropEnvironment"""

    id: Union[Unset, int] = Field(
        description="The id of the environment.", default=UNSET
    )
    node_id: Union[Unset, str] = Field(default=UNSET)
    name: Union[Unset, str] = Field(
        description="The name of the environment.", default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)


class PendingDeploymentPropReviewersItems(GitHubRestModel):
    """PendingDeploymentPropReviewersItems"""

    type: Union[Unset, Literal["User", "Team"]] = Field(
        description="The type of reviewer.", default=UNSET
    )
    reviewer: Union[Unset, Union[SimpleUser, Team]] = Field(
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=UNSET,
    )


class Deployment(GitHubRestModel):
    """Deployment

    A request for a specific ref(branch,sha,tag) to be deployed
    """

    url: str = Field(default=...)
    id: int = Field(description="Unique identifier of the deployment", default=...)
    node_id: str = Field(default=...)
    sha: str = Field(default=...)
    ref: str = Field(
        description="The ref to deploy. This can be a branch, tag, or sha.", default=...
    )
    task: str = Field(description="Parameter to specify a task to execute", default=...)
    payload: Union[DeploymentPropPayloadOneof0, str] = Field(default=...)
    original_environment: Union[Unset, str] = Field(default=UNSET)
    environment: str = Field(
        description="Name for the target deployment environment.", default=...
    )
    description: Union[str, None] = Field(default=...)
    creator: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    statuses_url: str = Field(default=...)
    repository_url: str = Field(default=...)
    transient_environment: Union[Unset, bool] = Field(
        description="Specifies if the given environment is will no longer exist at some point in the future. Default: false.",
        default=UNSET,
    )
    production_environment: Union[Unset, bool] = Field(
        description="Specifies if the given environment is one that end-users directly interact with. Default: false.",
        default=UNSET,
    )
    performed_via_github_app: Union[Unset, Union[None, Integration]] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )


class DeploymentPropPayloadOneof0(GitHubRestModel, extra=Extra.allow):
    """DeploymentPropPayloadOneof0"""


class WorkflowRunUsage(GitHubRestModel):
    """Workflow Run Usage

    Workflow Run Usage
    """

    billable: WorkflowRunUsagePropBillable = Field(default=...)
    run_duration_ms: Union[Unset, int] = Field(default=UNSET)


class WorkflowRunUsagePropBillable(GitHubRestModel):
    """WorkflowRunUsagePropBillable"""

    ubuntu: Union[Unset, WorkflowRunUsagePropBillablePropUbuntu] = Field(
        default=UNSET, alias="UBUNTU"
    )
    macos: Union[Unset, WorkflowRunUsagePropBillablePropMacos] = Field(
        default=UNSET, alias="MACOS"
    )
    windows: Union[Unset, WorkflowRunUsagePropBillablePropWindows] = Field(
        default=UNSET, alias="WINDOWS"
    )


class WorkflowRunUsagePropBillablePropUbuntu(GitHubRestModel):
    """WorkflowRunUsagePropBillablePropUbuntu"""

    total_ms: int = Field(default=...)
    jobs: int = Field(default=...)
    job_runs: Union[
        Unset, List[WorkflowRunUsagePropBillablePropUbuntuPropJobRunsItems]
    ] = Field(default=UNSET)


class WorkflowRunUsagePropBillablePropUbuntuPropJobRunsItems(GitHubRestModel):
    """WorkflowRunUsagePropBillablePropUbuntuPropJobRunsItems"""

    job_id: int = Field(default=...)
    duration_ms: int = Field(default=...)


class WorkflowRunUsagePropBillablePropMacos(GitHubRestModel):
    """WorkflowRunUsagePropBillablePropMacos"""

    total_ms: int = Field(default=...)
    jobs: int = Field(default=...)
    job_runs: Union[
        Unset, List[WorkflowRunUsagePropBillablePropMacosPropJobRunsItems]
    ] = Field(default=UNSET)


class WorkflowRunUsagePropBillablePropMacosPropJobRunsItems(GitHubRestModel):
    """WorkflowRunUsagePropBillablePropMacosPropJobRunsItems"""

    job_id: int = Field(default=...)
    duration_ms: int = Field(default=...)


class WorkflowRunUsagePropBillablePropWindows(GitHubRestModel):
    """WorkflowRunUsagePropBillablePropWindows"""

    total_ms: int = Field(default=...)
    jobs: int = Field(default=...)
    job_runs: Union[
        Unset, List[WorkflowRunUsagePropBillablePropWindowsPropJobRunsItems]
    ] = Field(default=UNSET)


class WorkflowRunUsagePropBillablePropWindowsPropJobRunsItems(GitHubRestModel):
    """WorkflowRunUsagePropBillablePropWindowsPropJobRunsItems"""

    job_id: int = Field(default=...)
    duration_ms: int = Field(default=...)


class ActionsSecret(GitHubRestModel):
    """Actions Secret

    Set secrets for GitHub Actions.
    """

    name: str = Field(description="The name of the secret.", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class Workflow(GitHubRestModel):
    """Workflow

    A GitHub Actions workflow
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(default=...)
    path: str = Field(default=...)
    state: Literal[
        "active", "deleted", "disabled_fork", "disabled_inactivity", "disabled_manually"
    ] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    badge_url: str = Field(default=...)
    deleted_at: Union[Unset, datetime] = Field(default=UNSET)


class WorkflowUsage(GitHubRestModel):
    """Workflow Usage

    Workflow Usage
    """

    billable: WorkflowUsagePropBillable = Field(default=...)


class WorkflowUsagePropBillable(GitHubRestModel):
    """WorkflowUsagePropBillable"""

    ubuntu: Union[Unset, WorkflowUsagePropBillablePropUbuntu] = Field(
        default=UNSET, alias="UBUNTU"
    )
    macos: Union[Unset, WorkflowUsagePropBillablePropMacos] = Field(
        default=UNSET, alias="MACOS"
    )
    windows: Union[Unset, WorkflowUsagePropBillablePropWindows] = Field(
        default=UNSET, alias="WINDOWS"
    )


class WorkflowUsagePropBillablePropUbuntu(GitHubRestModel):
    """WorkflowUsagePropBillablePropUbuntu"""

    total_ms: Union[Unset, int] = Field(default=UNSET)


class WorkflowUsagePropBillablePropMacos(GitHubRestModel):
    """WorkflowUsagePropBillablePropMacos"""

    total_ms: Union[Unset, int] = Field(default=UNSET)


class WorkflowUsagePropBillablePropWindows(GitHubRestModel):
    """WorkflowUsagePropBillablePropWindows"""

    total_ms: Union[Unset, int] = Field(default=UNSET)


class Autolink(GitHubRestModel):
    """Autolink reference

    An autolink reference.
    """

    id: int = Field(default=...)
    key_prefix: str = Field(
        description="The prefix of a key that is linkified.", default=...
    )
    url_template: str = Field(
        description="A template for the target URL that is generated if a key was found.",
        default=...,
    )
    is_alphanumeric: bool = Field(
        description="Whether this autolink reference matches alphanumeric characters. If false, this autolink reference only matches numeric characters.",
        default=...,
    )


class ProtectedBranchRequiredStatusCheck(GitHubRestModel):
    """Protected Branch Required Status Check

    Protected Branch Required Status Check
    """

    url: Union[Unset, str] = Field(default=UNSET)
    enforcement_level: Union[Unset, str] = Field(default=UNSET)
    contexts: List[str] = Field(default=...)
    checks: List[ProtectedBranchRequiredStatusCheckPropChecksItems] = Field(default=...)
    contexts_url: Union[Unset, str] = Field(default=UNSET)
    strict: Union[Unset, bool] = Field(default=UNSET)


class ProtectedBranchRequiredStatusCheckPropChecksItems(GitHubRestModel):
    """ProtectedBranchRequiredStatusCheckPropChecksItems"""

    context: str = Field(default=...)
    app_id: Union[int, None] = Field(default=...)


class ProtectedBranchAdminEnforced(GitHubRestModel):
    """Protected Branch Admin Enforced

    Protected Branch Admin Enforced
    """

    url: str = Field(default=...)
    enabled: bool = Field(default=...)


class ProtectedBranchPullRequestReview(GitHubRestModel):
    """Protected Branch Pull Request Review

    Protected Branch Pull Request Review
    """

    url: Union[Unset, str] = Field(default=UNSET)
    dismissal_restrictions: Union[
        Unset, ProtectedBranchPullRequestReviewPropDismissalRestrictions
    ] = Field(default=UNSET)
    bypass_pull_request_allowances: Union[
        Unset, ProtectedBranchPullRequestReviewPropBypassPullRequestAllowances
    ] = Field(
        description="Allow specific users, teams, or apps to bypass pull request requirements.",
        default=UNSET,
    )
    dismiss_stale_reviews: bool = Field(default=...)
    require_code_owner_reviews: bool = Field(default=...)
    required_approving_review_count: Union[Unset, int] = Field(le=6.0, default=UNSET)


class ProtectedBranchPullRequestReviewPropDismissalRestrictions(GitHubRestModel):
    """ProtectedBranchPullRequestReviewPropDismissalRestrictions"""

    users: Union[Unset, List[SimpleUser]] = Field(
        description="The list of users with review dismissal access.", default=UNSET
    )
    teams: Union[Unset, List[Team]] = Field(
        description="The list of teams with review dismissal access.", default=UNSET
    )
    apps: Union[Unset, List[Integration]] = Field(
        description="The list of apps with review dismissal access.", default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)
    users_url: Union[Unset, str] = Field(default=UNSET)
    teams_url: Union[Unset, str] = Field(default=UNSET)


class ProtectedBranchPullRequestReviewPropBypassPullRequestAllowances(GitHubRestModel):
    """ProtectedBranchPullRequestReviewPropBypassPullRequestAllowances

    Allow specific users, teams, or apps to bypass pull request requirements.
    """

    users: Union[Unset, List[SimpleUser]] = Field(
        description="The list of users allowed to bypass pull request requirements.",
        default=UNSET,
    )
    teams: Union[Unset, List[Team]] = Field(
        description="The list of teams allowed to bypass pull request requirements.",
        default=UNSET,
    )
    apps: Union[Unset, List[Integration]] = Field(
        description="The list of apps allowed to bypass pull request requirements.",
        default=UNSET,
    )


class BranchRestrictionPolicy(GitHubRestModel):
    """Branch Restriction Policy

    Branch Restriction Policy
    """

    url: str = Field(default=...)
    users_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    apps_url: str = Field(default=...)
    users: List[BranchRestrictionPolicyPropUsersItems] = Field(default=...)
    teams: List[BranchRestrictionPolicyPropTeamsItems] = Field(default=...)
    apps: List[BranchRestrictionPolicyPropAppsItems] = Field(default=...)


class BranchRestrictionPolicyPropUsersItems(GitHubRestModel):
    """BranchRestrictionPolicyPropUsersItems"""

    login: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    avatar_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)


class BranchRestrictionPolicyPropTeamsItems(GitHubRestModel):
    """BranchRestrictionPolicyPropTeamsItems"""

    id: Union[Unset, int] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    name: Union[Unset, str] = Field(default=UNSET)
    slug: Union[Unset, str] = Field(default=UNSET)
    description: Union[Unset, Union[str, None]] = Field(default=UNSET)
    privacy: Union[Unset, str] = Field(default=UNSET)
    permission: Union[Unset, str] = Field(default=UNSET)
    members_url: Union[Unset, str] = Field(default=UNSET)
    repositories_url: Union[Unset, str] = Field(default=UNSET)
    parent: Union[Unset, Union[str, None]] = Field(default=UNSET)


class BranchRestrictionPolicyPropAppsItems(GitHubRestModel):
    """BranchRestrictionPolicyPropAppsItems"""

    id: Union[Unset, int] = Field(default=UNSET)
    slug: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    owner: Union[Unset, BranchRestrictionPolicyPropAppsItemsPropOwner] = Field(
        default=UNSET
    )
    name: Union[Unset, str] = Field(default=UNSET)
    description: Union[Unset, str] = Field(default=UNSET)
    external_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    created_at: Union[Unset, str] = Field(default=UNSET)
    updated_at: Union[Unset, str] = Field(default=UNSET)
    permissions: Union[
        Unset, BranchRestrictionPolicyPropAppsItemsPropPermissions
    ] = Field(default=UNSET)
    events: Union[Unset, List[str]] = Field(default=UNSET)


class BranchRestrictionPolicyPropAppsItemsPropOwner(GitHubRestModel):
    """BranchRestrictionPolicyPropAppsItemsPropOwner"""

    login: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    hooks_url: Union[Unset, str] = Field(default=UNSET)
    issues_url: Union[Unset, str] = Field(default=UNSET)
    members_url: Union[Unset, str] = Field(default=UNSET)
    public_members_url: Union[Unset, str] = Field(default=UNSET)
    avatar_url: Union[Unset, str] = Field(default=UNSET)
    description: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)


class BranchRestrictionPolicyPropAppsItemsPropPermissions(GitHubRestModel):
    """BranchRestrictionPolicyPropAppsItemsPropPermissions"""

    metadata: Union[Unset, str] = Field(default=UNSET)
    contents: Union[Unset, str] = Field(default=UNSET)
    issues: Union[Unset, str] = Field(default=UNSET)
    single_file: Union[Unset, str] = Field(default=UNSET)


class BranchProtection(GitHubRestModel):
    """Branch Protection

    Branch Protection
    """

    url: Union[Unset, str] = Field(default=UNSET)
    enabled: Union[Unset, bool] = Field(default=UNSET)
    required_status_checks: Union[Unset, ProtectedBranchRequiredStatusCheck] = Field(
        title="Protected Branch Required Status Check",
        description="Protected Branch Required Status Check",
        default=UNSET,
    )
    enforce_admins: Union[Unset, ProtectedBranchAdminEnforced] = Field(
        title="Protected Branch Admin Enforced",
        description="Protected Branch Admin Enforced",
        default=UNSET,
    )
    required_pull_request_reviews: Union[
        Unset, ProtectedBranchPullRequestReview
    ] = Field(
        title="Protected Branch Pull Request Review",
        description="Protected Branch Pull Request Review",
        default=UNSET,
    )
    restrictions: Union[Unset, BranchRestrictionPolicy] = Field(
        title="Branch Restriction Policy",
        description="Branch Restriction Policy",
        default=UNSET,
    )
    required_linear_history: Union[
        Unset, BranchProtectionPropRequiredLinearHistory
    ] = Field(default=UNSET)
    allow_force_pushes: Union[Unset, BranchProtectionPropAllowForcePushes] = Field(
        default=UNSET
    )
    allow_deletions: Union[Unset, BranchProtectionPropAllowDeletions] = Field(
        default=UNSET
    )
    block_creations: Union[Unset, BranchProtectionPropBlockCreations] = Field(
        default=UNSET
    )
    required_conversation_resolution: Union[
        Unset, BranchProtectionPropRequiredConversationResolution
    ] = Field(default=UNSET)
    name: Union[Unset, str] = Field(default=UNSET)
    protection_url: Union[Unset, str] = Field(default=UNSET)
    required_signatures: Union[Unset, BranchProtectionPropRequiredSignatures] = Field(
        default=UNSET
    )


class BranchProtectionPropRequiredLinearHistory(GitHubRestModel):
    """BranchProtectionPropRequiredLinearHistory"""

    enabled: Union[Unset, bool] = Field(default=UNSET)


class BranchProtectionPropAllowForcePushes(GitHubRestModel):
    """BranchProtectionPropAllowForcePushes"""

    enabled: Union[Unset, bool] = Field(default=UNSET)


class BranchProtectionPropAllowDeletions(GitHubRestModel):
    """BranchProtectionPropAllowDeletions"""

    enabled: Union[Unset, bool] = Field(default=UNSET)


class BranchProtectionPropBlockCreations(GitHubRestModel):
    """BranchProtectionPropBlockCreations"""

    enabled: Union[Unset, bool] = Field(default=UNSET)


class BranchProtectionPropRequiredConversationResolution(GitHubRestModel):
    """BranchProtectionPropRequiredConversationResolution"""

    enabled: Union[Unset, bool] = Field(default=UNSET)


class BranchProtectionPropRequiredSignatures(GitHubRestModel):
    """BranchProtectionPropRequiredSignatures"""

    url: str = Field(default=...)
    enabled: bool = Field(default=...)


class ShortBranch(GitHubRestModel):
    """Short Branch

    Short Branch
    """

    name: str = Field(default=...)
    commit: ShortBranchPropCommit = Field(default=...)
    protected: bool = Field(default=...)
    protection: Union[Unset, BranchProtection] = Field(
        title="Branch Protection", description="Branch Protection", default=UNSET
    )
    protection_url: Union[Unset, str] = Field(default=UNSET)


class ShortBranchPropCommit(GitHubRestModel):
    """ShortBranchPropCommit"""

    sha: str = Field(default=...)
    url: str = Field(default=...)


class GitUser(GitHubRestModel):
    """Git User

    Metaproperties for Git author/committer information.
    """

    name: Union[Unset, str] = Field(default=UNSET)
    email: Union[Unset, str] = Field(default=UNSET)
    date: Union[Unset, str] = Field(default=UNSET)


class Verification(GitHubRestModel):
    """Verification"""

    verified: bool = Field(default=...)
    reason: str = Field(default=...)
    payload: Union[str, None] = Field(default=...)
    signature: Union[str, None] = Field(default=...)


class DiffEntry(GitHubRestModel):
    """Diff Entry

    Diff Entry
    """

    sha: str = Field(default=...)
    filename: str = Field(default=...)
    status: Literal[
        "added", "removed", "modified", "renamed", "copied", "changed", "unchanged"
    ] = Field(default=...)
    additions: int = Field(default=...)
    deletions: int = Field(default=...)
    changes: int = Field(default=...)
    blob_url: str = Field(default=...)
    raw_url: str = Field(default=...)
    contents_url: str = Field(default=...)
    patch: Union[Unset, str] = Field(default=UNSET)
    previous_filename: Union[Unset, str] = Field(default=UNSET)


class Commit(GitHubRestModel):
    """Commit

    Commit
    """

    url: str = Field(default=...)
    sha: str = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    commit: CommitPropCommit = Field(default=...)
    author: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    committer: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    parents: List[CommitPropParentsItems] = Field(default=...)
    stats: Union[Unset, CommitPropStats] = Field(default=UNSET)
    files: Union[Unset, List[DiffEntry]] = Field(default=UNSET)


class CommitPropCommit(GitHubRestModel):
    """CommitPropCommit"""

    url: str = Field(default=...)
    author: Union[None, GitUser] = Field(
        title="Git User",
        description="Metaproperties for Git author/committer information.",
        default=...,
    )
    committer: Union[None, GitUser] = Field(
        title="Git User",
        description="Metaproperties for Git author/committer information.",
        default=...,
    )
    message: str = Field(default=...)
    comment_count: int = Field(default=...)
    tree: CommitPropCommitPropTree = Field(default=...)
    verification: Union[Unset, Verification] = Field(
        title="Verification", default=UNSET
    )


class CommitPropCommitPropTree(GitHubRestModel):
    """CommitPropCommitPropTree"""

    sha: str = Field(default=...)
    url: str = Field(default=...)


class CommitPropParentsItems(GitHubRestModel):
    """CommitPropParentsItems"""

    sha: str = Field(default=...)
    url: str = Field(default=...)
    html_url: Union[Unset, str] = Field(default=UNSET)


class CommitPropStats(GitHubRestModel):
    """CommitPropStats"""

    additions: Union[Unset, int] = Field(default=UNSET)
    deletions: Union[Unset, int] = Field(default=UNSET)
    total: Union[Unset, int] = Field(default=UNSET)


class BranchWithProtection(GitHubRestModel):
    """Branch With Protection

    Branch With Protection
    """

    name: str = Field(default=...)
    commit: Commit = Field(title="Commit", description="Commit", default=...)
    links: BranchWithProtectionPropLinks = Field(default=..., alias="_links")
    protected: bool = Field(default=...)
    protection: BranchProtection = Field(
        title="Branch Protection", description="Branch Protection", default=...
    )
    protection_url: str = Field(default=...)
    pattern: Union[Unset, str] = Field(default=UNSET)
    required_approving_review_count: Union[Unset, int] = Field(default=UNSET)


class BranchWithProtectionPropLinks(GitHubRestModel):
    """BranchWithProtectionPropLinks"""

    html: str = Field(default=...)
    self_: str = Field(default=..., alias="self")


class StatusCheckPolicy(GitHubRestModel):
    """Status Check Policy

    Status Check Policy
    """

    url: str = Field(default=...)
    strict: bool = Field(default=...)
    contexts: List[str] = Field(default=...)
    checks: List[StatusCheckPolicyPropChecksItems] = Field(default=...)
    contexts_url: str = Field(default=...)


class StatusCheckPolicyPropChecksItems(GitHubRestModel):
    """StatusCheckPolicyPropChecksItems"""

    context: str = Field(default=...)
    app_id: Union[int, None] = Field(default=...)


class ProtectedBranch(GitHubRestModel):
    """Protected Branch

    Branch protections protect branches
    """

    url: str = Field(default=...)
    required_status_checks: Union[Unset, StatusCheckPolicy] = Field(
        title="Status Check Policy", description="Status Check Policy", default=UNSET
    )
    required_pull_request_reviews: Union[
        Unset, ProtectedBranchPropRequiredPullRequestReviews
    ] = Field(default=UNSET)
    required_signatures: Union[Unset, ProtectedBranchPropRequiredSignatures] = Field(
        default=UNSET
    )
    enforce_admins: Union[Unset, ProtectedBranchPropEnforceAdmins] = Field(
        default=UNSET
    )
    required_linear_history: Union[
        Unset, ProtectedBranchPropRequiredLinearHistory
    ] = Field(default=UNSET)
    allow_force_pushes: Union[Unset, ProtectedBranchPropAllowForcePushes] = Field(
        default=UNSET
    )
    allow_deletions: Union[Unset, ProtectedBranchPropAllowDeletions] = Field(
        default=UNSET
    )
    restrictions: Union[Unset, BranchRestrictionPolicy] = Field(
        title="Branch Restriction Policy",
        description="Branch Restriction Policy",
        default=UNSET,
    )
    required_conversation_resolution: Union[
        Unset, ProtectedBranchPropRequiredConversationResolution
    ] = Field(default=UNSET)
    block_creations: Union[Unset, ProtectedBranchPropBlockCreations] = Field(
        default=UNSET
    )


class ProtectedBranchPropRequiredPullRequestReviews(GitHubRestModel):
    """ProtectedBranchPropRequiredPullRequestReviews"""

    url: str = Field(default=...)
    dismiss_stale_reviews: Union[Unset, bool] = Field(default=UNSET)
    require_code_owner_reviews: Union[Unset, bool] = Field(default=UNSET)
    required_approving_review_count: Union[Unset, int] = Field(default=UNSET)
    dismissal_restrictions: Union[
        Unset, ProtectedBranchPropRequiredPullRequestReviewsPropDismissalRestrictions
    ] = Field(default=UNSET)
    bypass_pull_request_allowances: Union[
        Unset,
        ProtectedBranchPropRequiredPullRequestReviewsPropBypassPullRequestAllowances,
    ] = Field(default=UNSET)


class ProtectedBranchPropRequiredPullRequestReviewsPropDismissalRestrictions(
    GitHubRestModel
):
    """ProtectedBranchPropRequiredPullRequestReviewsPropDismissalRestrictions"""

    url: str = Field(default=...)
    users_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    users: List[SimpleUser] = Field(default=...)
    teams: List[Team] = Field(default=...)
    apps: Union[Unset, List[Integration]] = Field(default=UNSET)


class ProtectedBranchPropRequiredPullRequestReviewsPropBypassPullRequestAllowances(
    GitHubRestModel
):
    """ProtectedBranchPropRequiredPullRequestReviewsPropBypassPullRequestAllowances"""

    users: List[SimpleUser] = Field(default=...)
    teams: List[Team] = Field(default=...)
    apps: Union[Unset, List[Integration]] = Field(default=UNSET)


class ProtectedBranchPropRequiredSignatures(GitHubRestModel):
    """ProtectedBranchPropRequiredSignatures"""

    url: str = Field(default=...)
    enabled: bool = Field(default=...)


class ProtectedBranchPropEnforceAdmins(GitHubRestModel):
    """ProtectedBranchPropEnforceAdmins"""

    url: str = Field(default=...)
    enabled: bool = Field(default=...)


class ProtectedBranchPropRequiredLinearHistory(GitHubRestModel):
    """ProtectedBranchPropRequiredLinearHistory"""

    enabled: bool = Field(default=...)


class ProtectedBranchPropAllowForcePushes(GitHubRestModel):
    """ProtectedBranchPropAllowForcePushes"""

    enabled: bool = Field(default=...)


class ProtectedBranchPropAllowDeletions(GitHubRestModel):
    """ProtectedBranchPropAllowDeletions"""

    enabled: bool = Field(default=...)


class ProtectedBranchPropRequiredConversationResolution(GitHubRestModel):
    """ProtectedBranchPropRequiredConversationResolution"""

    enabled: Union[Unset, bool] = Field(default=UNSET)


class ProtectedBranchPropBlockCreations(GitHubRestModel):
    """ProtectedBranchPropBlockCreations"""

    enabled: bool = Field(default=...)


class DeploymentSimple(GitHubRestModel):
    """Deployment

    A deployment created as the result of an Actions check run from a workflow that
    references an environment
    """

    url: str = Field(default=...)
    id: int = Field(description="Unique identifier of the deployment", default=...)
    node_id: str = Field(default=...)
    task: str = Field(description="Parameter to specify a task to execute", default=...)
    original_environment: Union[Unset, str] = Field(default=UNSET)
    environment: str = Field(
        description="Name for the target deployment environment.", default=...
    )
    description: Union[str, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    statuses_url: str = Field(default=...)
    repository_url: str = Field(default=...)
    transient_environment: Union[Unset, bool] = Field(
        description="Specifies if the given environment is will no longer exist at some point in the future. Default: false.",
        default=UNSET,
    )
    production_environment: Union[Unset, bool] = Field(
        description="Specifies if the given environment is one that end-users directly interact with. Default: false.",
        default=UNSET,
    )
    performed_via_github_app: Union[Unset, Union[None, Integration]] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )


class CheckRun(GitHubRestModel):
    """CheckRun

    A check performed on the code of a given code change
    """

    id: int = Field(description="The id of the check.", default=...)
    head_sha: str = Field(
        description="The SHA of the commit that is being checked.", default=...
    )
    node_id: str = Field(default=...)
    external_id: Union[str, None] = Field(default=...)
    url: str = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    details_url: Union[str, None] = Field(default=...)
    status: Literal["queued", "in_progress", "completed"] = Field(
        description="The phase of the lifecycle that the check is currently in.",
        default=...,
    )
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "skipped",
            "timed_out",
            "action_required",
        ],
    ] = Field(default=...)
    started_at: Union[datetime, None] = Field(default=...)
    completed_at: Union[datetime, None] = Field(default=...)
    output: CheckRunPropOutput = Field(default=...)
    name: str = Field(description="The name of the check.", default=...)
    check_suite: Union[CheckRunPropCheckSuite, None] = Field(default=...)
    app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    pull_requests: List[PullRequestMinimal] = Field(default=...)
    deployment: Union[Unset, DeploymentSimple] = Field(
        title="Deployment",
        description="A deployment created as the result of an Actions check run from a workflow that references an environment",
        default=UNSET,
    )


class CheckRunPropOutput(GitHubRestModel):
    """CheckRunPropOutput"""

    title: Union[str, None] = Field(default=...)
    summary: Union[str, None] = Field(default=...)
    text: Union[str, None] = Field(default=...)
    annotations_count: int = Field(default=...)
    annotations_url: str = Field(default=...)


class CheckRunPropCheckSuite(GitHubRestModel):
    """CheckRunPropCheckSuite"""

    id: int = Field(default=...)


class CheckAnnotation(GitHubRestModel):
    """Check Annotation

    Check Annotation
    """

    path: str = Field(default=...)
    start_line: int = Field(default=...)
    end_line: int = Field(default=...)
    start_column: Union[int, None] = Field(default=...)
    end_column: Union[int, None] = Field(default=...)
    annotation_level: Union[str, None] = Field(default=...)
    title: Union[str, None] = Field(default=...)
    message: Union[str, None] = Field(default=...)
    raw_details: Union[str, None] = Field(default=...)
    blob_href: str = Field(default=...)


class CheckSuite(GitHubRestModel):
    """CheckSuite

    A suite of checks performed on the code of a given code change
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    head_branch: Union[str, None] = Field(default=...)
    head_sha: str = Field(
        description="The SHA of the head commit that is being checked.", default=...
    )
    status: Union[None, Literal["queued", "in_progress", "completed"]] = Field(
        default=...
    )
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "skipped",
            "timed_out",
            "action_required",
        ],
    ] = Field(default=...)
    url: Union[str, None] = Field(default=...)
    before: Union[str, None] = Field(default=...)
    after: Union[str, None] = Field(default=...)
    pull_requests: Union[List[PullRequestMinimal], None] = Field(default=...)
    app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository", default=...
    )
    created_at: Union[datetime, None] = Field(default=...)
    updated_at: Union[datetime, None] = Field(default=...)
    head_commit: SimpleCommit = Field(
        title="Simple Commit", description="Simple Commit", default=...
    )
    latest_check_runs_count: int = Field(default=...)
    check_runs_url: str = Field(default=...)
    rerequestable: Union[Unset, bool] = Field(default=UNSET)
    runs_rerequestable: Union[Unset, bool] = Field(default=UNSET)


class CheckSuitePreference(GitHubRestModel):
    """Check Suite Preference

    Check suite configuration preferences for a repository.
    """

    preferences: CheckSuitePreferencePropPreferences = Field(default=...)
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository", default=...
    )


class CheckSuitePreferencePropPreferences(GitHubRestModel):
    """CheckSuitePreferencePropPreferences"""

    auto_trigger_checks: Union[
        Unset, List[CheckSuitePreferencePropPreferencesPropAutoTriggerChecksItems]
    ] = Field(default=UNSET)


class CheckSuitePreferencePropPreferencesPropAutoTriggerChecksItems(GitHubRestModel):
    """CheckSuitePreferencePropPreferencesPropAutoTriggerChecksItems"""

    app_id: int = Field(default=...)
    setting: bool = Field(default=...)


class CodeScanningAlertRuleSummary(GitHubRestModel):
    """CodeScanningAlertRuleSummary"""

    id: Union[Unset, Union[str, None]] = Field(
        description="A unique identifier for the rule used to detect the alert.",
        default=UNSET,
    )
    name: Union[Unset, str] = Field(
        description="The name of the rule used to detect the alert.", default=UNSET
    )
    tags: Union[Unset, Union[List[str], None]] = Field(
        description="A set of tags applicable for the rule.", default=UNSET
    )
    severity: Union[
        Unset, Union[None, Literal["none", "note", "warning", "error"]]
    ] = Field(description="The severity of the alert.", default=UNSET)
    description: Union[Unset, str] = Field(
        description="A short description of the rule used to detect the alert.",
        default=UNSET,
    )


class CodeScanningAlertItems(GitHubRestModel):
    """CodeScanningAlertItems"""

    number: int = Field(description="The security alert number.", default=...)
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    updated_at: Union[Unset, datetime] = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    url: str = Field(description="The REST API URL of the alert resource.", default=...)
    html_url: str = Field(
        description="The GitHub URL of the alert resource.", default=...
    )
    instances_url: str = Field(
        description="The REST API URL for fetching the list of instances for an alert.",
        default=...,
    )
    state: Literal["open", "closed", "dismissed", "fixed"] = Field(
        description="State of a code scanning alert.", default=...
    )
    fixed_at: Union[Unset, Union[datetime, None]] = Field(
        description="The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    dismissed_by: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ] = Field(
        description="**Required when the state is dismissed.** The reason for dismissing or closing the alert.",
        default=...,
    )
    dismissed_comment: Union[Unset, Union[str, None]] = Field(
        description="The dismissal comment associated with the dismissal of the alert.",
        max_length=280,
        default=UNSET,
    )
    rule: CodeScanningAlertRuleSummary = Field(default=...)
    tool: CodeScanningAnalysisTool = Field(default=...)
    most_recent_instance: CodeScanningAlertInstance = Field(default=...)


class CodeScanningAlert(GitHubRestModel):
    """CodeScanningAlert"""

    number: int = Field(description="The security alert number.", default=...)
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    updated_at: Union[Unset, datetime] = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    url: str = Field(description="The REST API URL of the alert resource.", default=...)
    html_url: str = Field(
        description="The GitHub URL of the alert resource.", default=...
    )
    instances_url: str = Field(
        description="The REST API URL for fetching the list of instances for an alert.",
        default=...,
    )
    state: Literal["open", "closed", "dismissed", "fixed"] = Field(
        description="State of a code scanning alert.", default=...
    )
    fixed_at: Union[Unset, Union[datetime, None]] = Field(
        description="The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    dismissed_by: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ] = Field(
        description="**Required when the state is dismissed.** The reason for dismissing or closing the alert.",
        default=...,
    )
    dismissed_comment: Union[Unset, Union[str, None]] = Field(
        description="The dismissal comment associated with the dismissal of the alert.",
        max_length=280,
        default=UNSET,
    )
    rule: CodeScanningAlertRule = Field(default=...)
    tool: CodeScanningAnalysisTool = Field(default=...)
    most_recent_instance: CodeScanningAlertInstance = Field(default=...)


class CodeScanningAnalysis(GitHubRestModel):
    """CodeScanningAnalysis"""

    ref: str = Field(
        description="The full Git reference, formatted as `refs/heads/<branch name>`,\n`refs/pull/<number>/merge`, or `refs/pull/<number>/head`.",
        default=...,
    )
    commit_sha: str = Field(
        description="The SHA of the commit to which the analysis you are uploading relates.",
        min_length=40,
        max_length=40,
        regex="^[0-9a-fA-F]+$",
        default=...,
    )
    analysis_key: str = Field(
        description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.",
        default=...,
    )
    environment: str = Field(
        description="Identifies the variable values associated with the environment in which this analysis was performed.",
        default=...,
    )
    category: Union[Unset, str] = Field(
        description="Identifies the configuration under which the analysis was executed. Used to distinguish between multiple analyses for the same tool and commit, but performed on different languages or different parts of the code.",
        default=UNSET,
    )
    error: str = Field(default=...)
    created_at: datetime = Field(
        description="The time that the analysis was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    results_count: int = Field(
        description="The total number of results in the analysis.", default=...
    )
    rules_count: int = Field(
        description="The total number of rules used in the analysis.", default=...
    )
    id: int = Field(description="Unique identifier for this analysis.", default=...)
    url: str = Field(
        description="The REST API URL of the analysis resource.", default=...
    )
    sarif_id: str = Field(description="An identifier for the upload.", default=...)
    tool: CodeScanningAnalysisTool = Field(default=...)
    deletable: bool = Field(default=...)
    warning: str = Field(
        description="Warning generated when processing the analysis", default=...
    )


class CodeScanningAnalysisDeletion(GitHubRestModel):
    """Analysis deletion

    Successful deletion of a code scanning analysis
    """

    next_analysis_url: Union[str, None] = Field(
        description="Next deletable analysis in chain, without last analysis deletion confirmation",
        default=...,
    )
    confirm_delete_url: Union[str, None] = Field(
        description="Next deletable analysis in chain, with last analysis deletion confirmation",
        default=...,
    )


class CodeScanningCodeqlDatabase(GitHubRestModel):
    """CodeQL Database

    A CodeQL database.
    """

    id: int = Field(description="The ID of the CodeQL database.", default=...)
    name: str = Field(description="The name of the CodeQL database.", default=...)
    language: str = Field(
        description="The language of the CodeQL database.", default=...
    )
    uploader: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    content_type: str = Field(
        description="The MIME type of the CodeQL database file.", default=...
    )
    size: int = Field(
        description="The size of the CodeQL database file in bytes.", default=...
    )
    created_at: datetime = Field(
        description="The date and time at which the CodeQL database was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The date and time at which the CodeQL database was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
        default=...,
    )
    url: str = Field(
        description="The URL at which to download the CodeQL database. The `Accept` header must be set to the value of the `content_type` property.",
        default=...,
    )


class CodeScanningSarifsReceipt(GitHubRestModel):
    """CodeScanningSarifsReceipt"""

    id: Union[Unset, str] = Field(
        description="An identifier for the upload.", default=UNSET
    )
    url: Union[Unset, str] = Field(
        description="The REST API URL for checking the status of the upload.",
        default=UNSET,
    )


class CodeScanningSarifsStatus(GitHubRestModel):
    """CodeScanningSarifsStatus"""

    processing_status: Union[Unset, Literal["pending", "complete", "failed"]] = Field(
        description="`pending` files have not yet been processed, while `complete` means results from the SARIF have been stored. `failed` files have either not been processed at all, or could only be partially processed.",
        default=UNSET,
    )
    analyses_url: Union[Unset, Union[str, None]] = Field(
        description="The REST API URL for getting the analyses associated with the upload.",
        default=UNSET,
    )
    errors: Union[Unset, Union[List[str], None]] = Field(
        description="Any errors that ocurred during processing of the delivery.",
        default=UNSET,
    )


class CodeownersErrors(GitHubRestModel):
    """CODEOWNERS errors

    A list of errors found in a repo's CODEOWNERS file
    """

    errors: List[CodeownersErrorsPropErrorsItems] = Field(default=...)


class CodeownersErrorsPropErrorsItems(GitHubRestModel):
    """CodeownersErrorsPropErrorsItems"""

    line: int = Field(
        description="The line number where this errors occurs.", default=...
    )
    column: int = Field(
        description="The column number where this errors occurs.", default=...
    )
    source: Union[Unset, str] = Field(
        description="The contents of the line where the error occurs.", default=UNSET
    )
    kind: str = Field(description="The type of error.", default=...)
    suggestion: Union[Unset, Union[str, None]] = Field(
        description="Suggested action to fix the error. This will usually be `null`, but is provided for some common errors.",
        default=UNSET,
    )
    message: str = Field(
        description="A human-readable description of the error, combining information from multiple fields, laid out for display in a monospaced typeface (for example, a command-line setting).",
        default=...,
    )
    path: str = Field(
        description="The path of the file where the error occured.", default=...
    )


class RepoCodespacesSecret(GitHubRestModel):
    """Codespaces Secret

    Set repository secrets for GitHub Codespaces.
    """

    name: str = Field(description="The name of the secret.", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class Collaborator(GitHubRestModel):
    """Collaborator

    Collaborator
    """

    login: str = Field(default=...)
    id: int = Field(default=...)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    name: Union[Unset, Union[str, None]] = Field(default=UNSET)
    node_id: str = Field(default=...)
    avatar_url: str = Field(default=...)
    gravatar_id: Union[str, None] = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    organizations_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    type: str = Field(default=...)
    site_admin: bool = Field(default=...)
    permissions: Union[Unset, CollaboratorPropPermissions] = Field(default=UNSET)
    role_name: str = Field(default=...)


class CollaboratorPropPermissions(GitHubRestModel):
    """CollaboratorPropPermissions"""

    pull: bool = Field(default=...)
    triage: Union[Unset, bool] = Field(default=UNSET)
    push: bool = Field(default=...)
    maintain: Union[Unset, bool] = Field(default=UNSET)
    admin: bool = Field(default=...)


class RepositoryInvitation(GitHubRestModel):
    """Repository Invitation

    Repository invitations let you manage who you collaborate with.
    """

    id: int = Field(
        description="Unique identifier of the repository invitation.", default=...
    )
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository", default=...
    )
    invitee: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    inviter: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    permissions: Literal["read", "write", "admin", "triage", "maintain"] = Field(
        description="The permission associated with the invitation.", default=...
    )
    created_at: datetime = Field(default=...)
    expired: Union[Unset, bool] = Field(
        description="Whether or not the invitation has expired", default=UNSET
    )
    url: str = Field(description="URL for the repository invitation", default=...)
    html_url: str = Field(default=...)
    node_id: str = Field(default=...)


class RepositoryCollaboratorPermission(GitHubRestModel):
    """Repository Collaborator Permission

    Repository Collaborator Permission
    """

    permission: str = Field(default=...)
    role_name: str = Field(default=...)
    user: Union[None, Collaborator] = Field(
        title="Collaborator", description="Collaborator", default=...
    )


class CommitComment(GitHubRestModel):
    """Commit Comment

    Commit Comment
    """

    html_url: str = Field(default=...)
    url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    body: str = Field(default=...)
    path: Union[str, None] = Field(default=...)
    position: Union[int, None] = Field(default=...)
    line: Union[int, None] = Field(default=...)
    commit_id: str = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )
    reactions: Union[Unset, ReactionRollup] = Field(
        title="Reaction Rollup", default=UNSET
    )


class BranchShort(GitHubRestModel):
    """Branch Short

    Branch Short
    """

    name: str = Field(default=...)
    commit: BranchShortPropCommit = Field(default=...)
    protected: bool = Field(default=...)


class BranchShortPropCommit(GitHubRestModel):
    """BranchShortPropCommit"""

    sha: str = Field(default=...)
    url: str = Field(default=...)


class Link(GitHubRestModel):
    """Link

    Hypermedia Link
    """

    href: str = Field(default=...)


class AutoMerge(GitHubRestModel):
    """Auto merge

    The status of auto merging a pull request.
    """

    enabled_by: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    merge_method: Literal["merge", "squash", "rebase"] = Field(
        description="The merge method to use.", default=...
    )
    commit_title: str = Field(
        description="Title for the merge commit message.", default=...
    )
    commit_message: str = Field(
        description="Commit message for the merge commit.", default=...
    )


class PullRequestSimple(GitHubRestModel):
    """Pull Request Simple

    Pull Request Simple
    """

    url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    diff_url: str = Field(default=...)
    patch_url: str = Field(default=...)
    issue_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    review_comments_url: str = Field(default=...)
    review_comment_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    number: int = Field(default=...)
    state: str = Field(default=...)
    locked: bool = Field(default=...)
    title: str = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    body: Union[str, None] = Field(default=...)
    labels: List[PullRequestSimplePropLabelsItems] = Field(default=...)
    milestone: Union[None, Milestone] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    active_lock_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    merged_at: Union[datetime, None] = Field(default=...)
    merge_commit_sha: Union[str, None] = Field(default=...)
    assignee: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    assignees: Union[Unset, Union[List[SimpleUser], None]] = Field(default=UNSET)
    requested_reviewers: Union[Unset, Union[List[SimpleUser], None]] = Field(
        default=UNSET
    )
    requested_teams: Union[Unset, Union[List[Team], None]] = Field(default=UNSET)
    head: PullRequestSimplePropHead = Field(default=...)
    base: PullRequestSimplePropBase = Field(default=...)
    links: PullRequestSimplePropLinks = Field(default=..., alias="_links")
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )
    auto_merge: Union[AutoMerge, None] = Field(
        title="Auto merge",
        description="The status of auto merging a pull request.",
        default=...,
    )
    draft: Union[Unset, bool] = Field(
        description="Indicates whether or not the pull request is a draft.",
        default=UNSET,
    )


class PullRequestSimplePropLabelsItems(GitHubRestModel):
    """PullRequestSimplePropLabelsItems"""

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    name: str = Field(default=...)
    description: str = Field(default=...)
    color: str = Field(default=...)
    default: bool = Field(default=...)


class PullRequestSimplePropHead(GitHubRestModel):
    """PullRequestSimplePropHead"""

    label: str = Field(default=...)
    ref: str = Field(default=...)
    repo: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sha: str = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )


class PullRequestSimplePropBase(GitHubRestModel):
    """PullRequestSimplePropBase"""

    label: str = Field(default=...)
    ref: str = Field(default=...)
    repo: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sha: str = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )


class PullRequestSimplePropLinks(GitHubRestModel):
    """PullRequestSimplePropLinks"""

    comments: Link = Field(title="Link", description="Hypermedia Link", default=...)
    commits: Link = Field(title="Link", description="Hypermedia Link", default=...)
    statuses: Link = Field(title="Link", description="Hypermedia Link", default=...)
    html: Link = Field(title="Link", description="Hypermedia Link", default=...)
    issue: Link = Field(title="Link", description="Hypermedia Link", default=...)
    review_comments: Link = Field(
        title="Link", description="Hypermedia Link", default=...
    )
    review_comment: Link = Field(
        title="Link", description="Hypermedia Link", default=...
    )
    self_: Link = Field(
        title="Link", description="Hypermedia Link", default=..., alias="self"
    )


class SimpleCommitStatus(GitHubRestModel):
    """Simple Commit Status"""

    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    state: str = Field(default=...)
    context: str = Field(default=...)
    target_url: Union[str, None] = Field(default=...)
    required: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    avatar_url: Union[str, None] = Field(default=...)
    url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class CombinedCommitStatus(GitHubRestModel):
    """Combined Commit Status

    Combined Commit Status
    """

    state: str = Field(default=...)
    statuses: List[SimpleCommitStatus] = Field(default=...)
    sha: str = Field(default=...)
    total_count: int = Field(default=...)
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository", default=...
    )
    commit_url: str = Field(default=...)
    url: str = Field(default=...)


class Status(GitHubRestModel):
    """Status

    The status of a commit.
    """

    url: str = Field(default=...)
    avatar_url: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    state: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    target_url: Union[str, None] = Field(default=...)
    context: str = Field(default=...)
    created_at: str = Field(default=...)
    updated_at: str = Field(default=...)
    creator: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )


class CommunityHealthFile(GitHubRestModel):
    """Community Health File"""

    url: str = Field(default=...)
    html_url: str = Field(default=...)


class CommunityProfile(GitHubRestModel):
    """Community Profile

    Community Profile
    """

    health_percentage: int = Field(default=...)
    description: Union[str, None] = Field(default=...)
    documentation: Union[str, None] = Field(default=...)
    files: CommunityProfilePropFiles = Field(default=...)
    updated_at: Union[datetime, None] = Field(default=...)
    content_reports_enabled: Union[Unset, bool] = Field(default=UNSET)


class CommunityProfilePropFiles(GitHubRestModel):
    """CommunityProfilePropFiles"""

    code_of_conduct: Union[None, CodeOfConductSimple] = Field(
        title="Code Of Conduct Simple",
        description="Code of Conduct Simple",
        default=...,
    )
    code_of_conduct_file: Union[None, CommunityHealthFile] = Field(
        title="Community Health File", default=...
    )
    license_: Union[None, LicenseSimple] = Field(
        title="License Simple",
        description="License Simple",
        default=...,
        alias="license",
    )
    contributing: Union[None, CommunityHealthFile] = Field(
        title="Community Health File", default=...
    )
    readme: Union[None, CommunityHealthFile] = Field(
        title="Community Health File", default=...
    )
    issue_template: Union[None, CommunityHealthFile] = Field(
        title="Community Health File", default=...
    )
    pull_request_template: Union[None, CommunityHealthFile] = Field(
        title="Community Health File", default=...
    )


class CommitComparison(GitHubRestModel):
    """Commit Comparison

    Commit Comparison
    """

    url: str = Field(default=...)
    html_url: str = Field(default=...)
    permalink_url: str = Field(default=...)
    diff_url: str = Field(default=...)
    patch_url: str = Field(default=...)
    base_commit: Commit = Field(title="Commit", description="Commit", default=...)
    merge_base_commit: Commit = Field(title="Commit", description="Commit", default=...)
    status: Literal["diverged", "ahead", "behind", "identical"] = Field(default=...)
    ahead_by: int = Field(default=...)
    behind_by: int = Field(default=...)
    total_commits: int = Field(default=...)
    commits: List[Commit] = Field(default=...)
    files: Union[Unset, List[DiffEntry]] = Field(default=UNSET)


class ContentTree(GitHubRestModel):
    """Content Tree

    Content Tree
    """

    type: str = Field(default=...)
    size: int = Field(default=...)
    name: str = Field(default=...)
    path: str = Field(default=...)
    sha: str = Field(default=...)
    url: str = Field(default=...)
    git_url: Union[str, None] = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    download_url: Union[str, None] = Field(default=...)
    entries: Union[Unset, List[ContentTreePropEntriesItems]] = Field(default=UNSET)
    links: ContentTreePropLinks = Field(default=..., alias="_links")


class ContentTreePropEntriesItems(GitHubRestModel):
    """ContentTreePropEntriesItems"""

    type: str = Field(default=...)
    size: int = Field(default=...)
    name: str = Field(default=...)
    path: str = Field(default=...)
    content: Union[Unset, str] = Field(default=UNSET)
    sha: str = Field(default=...)
    url: str = Field(default=...)
    git_url: Union[str, None] = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    download_url: Union[str, None] = Field(default=...)
    links: ContentTreePropEntriesItemsPropLinks = Field(default=..., alias="_links")


class ContentTreePropEntriesItemsPropLinks(GitHubRestModel):
    """ContentTreePropEntriesItemsPropLinks"""

    git: Union[str, None] = Field(default=...)
    html: Union[str, None] = Field(default=...)
    self_: str = Field(default=..., alias="self")


class ContentTreePropLinks(GitHubRestModel):
    """ContentTreePropLinks"""

    git: Union[str, None] = Field(default=...)
    html: Union[str, None] = Field(default=...)
    self_: str = Field(default=..., alias="self")


class ContentDirectoryItems(GitHubRestModel):
    """ContentDirectoryItems"""

    type: Literal["dir", "file", "submodule", "symlink"] = Field(default=...)
    size: int = Field(default=...)
    name: str = Field(default=...)
    path: str = Field(default=...)
    content: Union[Unset, str] = Field(default=UNSET)
    sha: str = Field(default=...)
    url: str = Field(default=...)
    git_url: Union[str, None] = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    download_url: Union[str, None] = Field(default=...)
    links: ContentDirectoryItemsPropLinks = Field(default=..., alias="_links")


class ContentDirectoryItemsPropLinks(GitHubRestModel):
    """ContentDirectoryItemsPropLinks"""

    git: Union[str, None] = Field(default=...)
    html: Union[str, None] = Field(default=...)
    self_: str = Field(default=..., alias="self")


class ContentFile(GitHubRestModel):
    """Content File

    Content File
    """

    type: Literal["file"] = Field(default=...)
    encoding: str = Field(default=...)
    size: int = Field(default=...)
    name: str = Field(default=...)
    path: str = Field(default=...)
    content: str = Field(default=...)
    sha: str = Field(default=...)
    url: str = Field(default=...)
    git_url: Union[str, None] = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    download_url: Union[str, None] = Field(default=...)
    links: ContentFilePropLinks = Field(default=..., alias="_links")
    target: Union[Unset, str] = Field(default=UNSET)
    submodule_git_url: Union[Unset, str] = Field(default=UNSET)


class ContentFilePropLinks(GitHubRestModel):
    """ContentFilePropLinks"""

    git: Union[str, None] = Field(default=...)
    html: Union[str, None] = Field(default=...)
    self_: str = Field(default=..., alias="self")


class ContentSymlink(GitHubRestModel):
    """Symlink Content

    An object describing a symlink
    """

    type: Literal["symlink"] = Field(default=...)
    target: str = Field(default=...)
    size: int = Field(default=...)
    name: str = Field(default=...)
    path: str = Field(default=...)
    sha: str = Field(default=...)
    url: str = Field(default=...)
    git_url: Union[str, None] = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    download_url: Union[str, None] = Field(default=...)
    links: ContentSymlinkPropLinks = Field(default=..., alias="_links")


class ContentSymlinkPropLinks(GitHubRestModel):
    """ContentSymlinkPropLinks"""

    git: Union[str, None] = Field(default=...)
    html: Union[str, None] = Field(default=...)
    self_: str = Field(default=..., alias="self")


class ContentSubmodule(GitHubRestModel):
    """Submodule Content

    An object describing a submodule
    """

    type: Literal["submodule"] = Field(default=...)
    submodule_git_url: str = Field(default=...)
    size: int = Field(default=...)
    name: str = Field(default=...)
    path: str = Field(default=...)
    sha: str = Field(default=...)
    url: str = Field(default=...)
    git_url: Union[str, None] = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    download_url: Union[str, None] = Field(default=...)
    links: ContentSubmodulePropLinks = Field(default=..., alias="_links")


class ContentSubmodulePropLinks(GitHubRestModel):
    """ContentSubmodulePropLinks"""

    git: Union[str, None] = Field(default=...)
    html: Union[str, None] = Field(default=...)
    self_: str = Field(default=..., alias="self")


class FileCommit(GitHubRestModel):
    """File Commit

    File Commit
    """

    content: Union[FileCommitPropContent, None] = Field(default=...)
    commit: FileCommitPropCommit = Field(default=...)


class FileCommitPropContentPropLinks(GitHubRestModel):
    """FileCommitPropContentPropLinks"""

    self_: Union[Unset, str] = Field(default=UNSET, alias="self")
    git: Union[Unset, str] = Field(default=UNSET)
    html: Union[Unset, str] = Field(default=UNSET)


class FileCommitPropContent(GitHubRestModel):
    """FileCommitPropContent"""

    name: Union[Unset, str] = Field(default=UNSET)
    path: Union[Unset, str] = Field(default=UNSET)
    sha: Union[Unset, str] = Field(default=UNSET)
    size: Union[Unset, int] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    git_url: Union[Unset, str] = Field(default=UNSET)
    download_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, str] = Field(default=UNSET)
    links: Union[Unset, FileCommitPropContentPropLinks] = Field(
        default=UNSET, alias="_links"
    )


class FileCommitPropCommit(GitHubRestModel):
    """FileCommitPropCommit"""

    sha: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    author: Union[Unset, FileCommitPropCommitPropAuthor] = Field(default=UNSET)
    committer: Union[Unset, FileCommitPropCommitPropCommitter] = Field(default=UNSET)
    message: Union[Unset, str] = Field(default=UNSET)
    tree: Union[Unset, FileCommitPropCommitPropTree] = Field(default=UNSET)
    parents: Union[Unset, List[FileCommitPropCommitPropParentsItems]] = Field(
        default=UNSET
    )
    verification: Union[Unset, FileCommitPropCommitPropVerification] = Field(
        default=UNSET
    )


class FileCommitPropCommitPropAuthor(GitHubRestModel):
    """FileCommitPropCommitPropAuthor"""

    date: Union[Unset, str] = Field(default=UNSET)
    name: Union[Unset, str] = Field(default=UNSET)
    email: Union[Unset, str] = Field(default=UNSET)


class FileCommitPropCommitPropCommitter(GitHubRestModel):
    """FileCommitPropCommitPropCommitter"""

    date: Union[Unset, str] = Field(default=UNSET)
    name: Union[Unset, str] = Field(default=UNSET)
    email: Union[Unset, str] = Field(default=UNSET)


class FileCommitPropCommitPropTree(GitHubRestModel):
    """FileCommitPropCommitPropTree"""

    url: Union[Unset, str] = Field(default=UNSET)
    sha: Union[Unset, str] = Field(default=UNSET)


class FileCommitPropCommitPropParentsItems(GitHubRestModel):
    """FileCommitPropCommitPropParentsItems"""

    url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    sha: Union[Unset, str] = Field(default=UNSET)


class FileCommitPropCommitPropVerification(GitHubRestModel):
    """FileCommitPropCommitPropVerification"""

    verified: Union[Unset, bool] = Field(default=UNSET)
    reason: Union[Unset, str] = Field(default=UNSET)
    signature: Union[Unset, Union[str, None]] = Field(default=UNSET)
    payload: Union[Unset, Union[str, None]] = Field(default=UNSET)


class Contributor(GitHubRestModel):
    """Contributor

    Contributor
    """

    login: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    avatar_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, Union[str, None]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    type: str = Field(default=...)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    contributions: int = Field(default=...)
    email: Union[Unset, str] = Field(default=UNSET)
    name: Union[Unset, str] = Field(default=UNSET)


class DependabotAlert(GitHubRestModel):
    """DependabotAlert

    A Dependabot alert.
    """

    number: int = Field(description="The security alert number.", default=...)
    state: Literal["dismissed", "fixed", "open"] = Field(
        description="The state of the Dependabot alert.", default=...
    )
    dependency: DependabotAlertPropDependency = Field(
        description="Details for the vulnerable dependency.", default=...
    )
    security_advisory: DependabotAlertSecurityAdvisory = Field(
        description="Details for the GitHub Security Advisory.", default=...
    )
    security_vulnerability: DependabotAlertSecurityVulnerability = Field(
        description="Details pertaining to one vulnerable version range for the advisory.",
        default=...,
    )
    url: str = Field(description="The REST API URL of the alert resource.", default=...)
    html_url: str = Field(
        description="The GitHub URL of the alert resource.", default=...
    )
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_by: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    dismissed_reason: Union[
        None,
        Literal[
            "fix_started", "inaccurate", "no_bandwidth", "not_used", "tolerable_risk"
        ],
    ] = Field(description="The reason that the alert was dismissed.", default=...)
    dismissed_comment: Union[str, None] = Field(
        description="An optional comment associated with the alert's dismissal.",
        max_length=280,
        default=...,
    )
    fixed_at: Union[datetime, None] = Field(
        description="The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )


class DependabotAlertPropDependency(GitHubRestModel):
    """DependabotAlertPropDependency

    Details for the vulnerable dependency.
    """

    package: Union[Unset, DependabotAlertPackage] = Field(
        description="Details for the vulnerable package.", default=UNSET
    )
    manifest_path: Union[Unset, str] = Field(
        description="The full path to the dependency manifest file, relative to the root of the repository.",
        default=UNSET,
    )
    scope: Union[Unset, Union[None, Literal["development", "runtime"]]] = Field(
        description="The execution scope of the vulnerable dependency.", default=UNSET
    )


class DependabotSecret(GitHubRestModel):
    """Dependabot Secret

    Set secrets for Dependabot.
    """

    name: str = Field(description="The name of the secret.", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class DependencyGraphDiffItems(GitHubRestModel):
    """DependencyGraphDiffItems"""

    change_type: Literal["added", "removed"] = Field(default=...)
    manifest: str = Field(default=...)
    ecosystem: str = Field(default=...)
    name: str = Field(default=...)
    version: str = Field(default=...)
    package_url: Union[str, None] = Field(default=...)
    license_: Union[str, None] = Field(default=..., alias="license")
    source_repository_url: Union[str, None] = Field(default=...)
    vulnerabilities: List[DependencyGraphDiffItemsPropVulnerabilitiesItems] = Field(
        default=...
    )
    scope: Literal["unknown", "runtime", "development"] = Field(
        description="Where the dependency is utilized. `development` means that the dependency is only utilized in the development environment. `runtime` means that the dependency is utilized at runtime and in the development environment.",
        default=...,
    )


class DependencyGraphDiffItemsPropVulnerabilitiesItems(GitHubRestModel):
    """DependencyGraphDiffItemsPropVulnerabilitiesItems"""

    severity: str = Field(default=...)
    advisory_ghsa_id: str = Field(default=...)
    advisory_summary: str = Field(default=...)
    advisory_url: str = Field(default=...)


class Metadata(GitHubRestModel, extra=Extra.allow):
    """metadata

    User-defined metadata to store domain-specific information limited to 8 keys
    with scalar values.
    """


class Dependency(GitHubRestModel):
    """Dependency"""

    package_url: Union[Unset, str] = Field(
        description="Package-url (PURL) of dependency. See https://github.com/package-url/purl-spec for more details.",
        regex="^pkg",
        default=UNSET,
    )
    metadata: Union[Unset, Metadata] = Field(
        title="metadata",
        description="User-defined metadata to store domain-specific information limited to 8 keys with scalar values.",
        default=UNSET,
    )
    relationship: Union[Unset, Literal["direct", "indirect"]] = Field(
        description="A notation of whether a dependency is requested directly by this manifest or is a dependency of another dependency.",
        default=UNSET,
    )
    scope: Union[Unset, Literal["runtime", "development"]] = Field(
        description="A notation of whether the dependency is required for the primary build artifact (runtime) or is only used for development. Future versions of this specification may allow for more granular scopes.",
        default=UNSET,
    )
    dependencies: Union[Unset, List[str]] = Field(
        description="Array of package-url (PURLs) of direct child dependencies.",
        default=UNSET,
    )


class Manifest(GitHubRestModel):
    """Manifest"""

    name: str = Field(description="The name of the manifest.", default=...)
    file: Union[Unset, ManifestPropFile] = Field(default=UNSET)
    metadata: Union[Unset, Metadata] = Field(
        title="metadata",
        description="User-defined metadata to store domain-specific information limited to 8 keys with scalar values.",
        default=UNSET,
    )
    resolved: Union[Unset, ManifestPropResolved] = Field(
        description="A collection of resolved package dependencies.", default=UNSET
    )


class ManifestPropFile(GitHubRestModel):
    """ManifestPropFile"""

    source_location: Union[Unset, str] = Field(
        description="The path of the manifest file relative to the root of the Git repository.",
        default=UNSET,
    )


class ManifestPropResolved(GitHubRestModel, extra=Extra.allow):
    """ManifestPropResolved

    A collection of resolved package dependencies.
    """


class Snapshot(GitHubRestModel):
    """snapshot

    Create a new snapshot of a repository's dependencies.
    """

    version: int = Field(
        description="The version of the repository snapshot submission.", default=...
    )
    job: SnapshotPropJob = Field(default=...)
    sha: str = Field(
        description="The commit SHA associated with this dependency snapshot.",
        min_length=40,
        default=...,
    )
    ref: str = Field(
        description="The repository branch that triggered this snapshot.",
        regex="^refs/",
        default=...,
    )
    detector: SnapshotPropDetector = Field(
        description="A description of the detector used.", default=...
    )
    metadata: Union[Unset, Metadata] = Field(
        title="metadata",
        description="User-defined metadata to store domain-specific information limited to 8 keys with scalar values.",
        default=UNSET,
    )
    manifests: Union[Unset, SnapshotPropManifests] = Field(
        description="A collection of package manifests, which are a collection of related dependencies declared in a file or representing a logical group of dependencies.",
        default=UNSET,
    )
    scanned: datetime = Field(
        description="The time at which the snapshot was scanned.", default=...
    )


class SnapshotPropJob(GitHubRestModel):
    """SnapshotPropJob"""

    id: str = Field(description="The external ID of the job.", default=...)
    correlator: str = Field(
        description="Correlator provides a key that is used to group snapshots submitted over time. Only the \"latest\" submitted snapshot for a given combination of `job.correlator` and `detector.name` will be considered when calculating a repository's current dependencies. Correlator should be as unique as it takes to distinguish all detection runs for a given \"wave\" of CI workflow you run. If you're using GitHub Actions, a good default value for this could be the environment variables GITHUB_WORKFLOW and GITHUB_JOB concatenated together. If you're using a build matrix, then you'll also need to add additional key(s) to distinguish between each submission inside a matrix variation.",
        default=...,
    )
    html_url: Union[Unset, str] = Field(
        description="The url for the job.", default=UNSET
    )


class SnapshotPropDetector(GitHubRestModel):
    """SnapshotPropDetector

    A description of the detector used.
    """

    name: str = Field(description="The name of the detector used.", default=...)
    version: str = Field(description="The version of the detector used.", default=...)
    url: str = Field(description="The url of the detector used.", default=...)


class SnapshotPropManifests(GitHubRestModel, extra=Extra.allow):
    """SnapshotPropManifests

    A collection of package manifests, which are a collection of related
    dependencies declared in a file or representing a logical group of dependencies.
    """


class DeploymentStatus(GitHubRestModel):
    """Deployment Status

    The status of a deployment.
    """

    url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    state: Literal[
        "error", "failure", "inactive", "pending", "success", "queued", "in_progress"
    ] = Field(description="The state of the status.", default=...)
    creator: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    description: str = Field(
        description="A short description of the status.", default="", max_length=140
    )
    environment: Union[Unset, str] = Field(
        description="The environment of the deployment that the status is for.",
        default="",
    )
    target_url: str = Field(
        description="Deprecated: the URL to associate with this status.", default=""
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    deployment_url: str = Field(default=...)
    repository_url: str = Field(default=...)
    environment_url: Union[Unset, str] = Field(
        description="The URL for accessing your environment.", default=""
    )
    log_url: Union[Unset, str] = Field(
        description="The URL to associate with this status.", default=""
    )
    performed_via_github_app: Union[Unset, Union[None, Integration]] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )


class DeploymentBranchPolicySettings(GitHubRestModel):
    """DeploymentBranchPolicySettings

    The type of deployment branch policy for this environment. To allow all branches
    to deploy, set to `null`.
    """

    protected_branches: bool = Field(
        description="Whether only branches with branch protection rules can deploy to this environment. If `protected_branches` is `true`, `custom_branch_policies` must be `false`; if `protected_branches` is `false`, `custom_branch_policies` must be `true`.",
        default=...,
    )
    custom_branch_policies: bool = Field(
        description="Whether only branches that match the specified name patterns can deploy to this environment.  If `custom_branch_policies` is `true`, `protected_branches` must be `false`; if `custom_branch_policies` is `false`, `protected_branches` must be `true`.",
        default=...,
    )


class Environment(GitHubRestModel):
    """Environment

    Details of a deployment environment
    """

    id: int = Field(description="The id of the environment.", default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the environment.", default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    created_at: datetime = Field(
        description="The time that the environment was created, in ISO 8601 format.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The time that the environment was last updated, in ISO 8601 format.",
        default=...,
    )
    protection_rules: Union[
        Unset,
        List[
            Union[
                EnvironmentPropProtectionRulesItemsAnyof0,
                EnvironmentPropProtectionRulesItemsAnyof1,
                EnvironmentPropProtectionRulesItemsAnyof2,
            ]
        ],
    ] = Field(default=UNSET)
    deployment_branch_policy: Union[
        Unset, Union[DeploymentBranchPolicySettings, None]
    ] = Field(
        description="The type of deployment branch policy for this environment. To allow all branches to deploy, set to `null`.",
        default=UNSET,
    )


class EnvironmentPropProtectionRulesItemsAnyof0(GitHubRestModel):
    """EnvironmentPropProtectionRulesItemsAnyof0"""

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    type: str = Field(default=...)
    wait_timer: Union[Unset, int] = Field(
        description="The amount of time to delay a job after the job is initially triggered. The time (in minutes) must be an integer between 0 and 43,200 (30 days).",
        default=UNSET,
    )


class EnvironmentPropProtectionRulesItemsAnyof1(GitHubRestModel):
    """EnvironmentPropProtectionRulesItemsAnyof1"""

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    type: str = Field(default=...)
    reviewers: Union[
        Unset, List[EnvironmentPropProtectionRulesItemsAnyof1PropReviewersItems]
    ] = Field(
        description="The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.",
        default=UNSET,
    )


class EnvironmentPropProtectionRulesItemsAnyof1PropReviewersItems(GitHubRestModel):
    """EnvironmentPropProtectionRulesItemsAnyof1PropReviewersItems"""

    type: Union[Unset, Literal["User", "Team"]] = Field(
        description="The type of reviewer.", default=UNSET
    )
    reviewer: Union[Unset, Union[SimpleUser, Team]] = Field(
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=UNSET,
    )


class EnvironmentPropProtectionRulesItemsAnyof2(GitHubRestModel):
    """EnvironmentPropProtectionRulesItemsAnyof2"""

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    type: str = Field(default=...)


class DeploymentBranchPolicy(GitHubRestModel):
    """Deployment branch policy

    Details of a deployment branch policy.
    """

    id: Union[Unset, int] = Field(
        description="The unique identifier of the branch policy.", default=UNSET
    )
    node_id: Union[Unset, str] = Field(default=UNSET)
    name: Union[Unset, str] = Field(
        description="The name pattern that branches must match in order to deploy to the environment.",
        default=UNSET,
    )


class DeploymentBranchPolicyNamePattern(GitHubRestModel):
    """Deployment branch policy name pattern"""

    name: str = Field(
        description="The name pattern that branches must match in order to deploy to the environment.\n\nWildcard characters will not match `/`. For example, to match branches that begin with `release/` and contain an additional single slash, use `release/*/*`.\nFor more information about pattern matching syntax, see the [Ruby File.fnmatch documentation](https://ruby-doc.org/core-2.5.1/File.html#method-c-fnmatch).",
        default=...,
    )


class ShortBlob(GitHubRestModel):
    """Short Blob

    Short Blob
    """

    url: str = Field(default=...)
    sha: str = Field(default=...)


class Blob(GitHubRestModel):
    """Blob

    Blob
    """

    content: str = Field(default=...)
    encoding: str = Field(default=...)
    url: str = Field(default=...)
    sha: str = Field(default=...)
    size: Union[int, None] = Field(default=...)
    node_id: str = Field(default=...)
    highlighted_content: Union[Unset, str] = Field(default=UNSET)


class GitCommit(GitHubRestModel):
    """Git Commit

    Low-level Git commit operations within a repository
    """

    sha: str = Field(description="SHA for the commit", default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    author: GitCommitPropAuthor = Field(
        description="Identifying information for the git-user", default=...
    )
    committer: GitCommitPropCommitter = Field(
        description="Identifying information for the git-user", default=...
    )
    message: str = Field(
        description="Message describing the purpose of the commit", default=...
    )
    tree: GitCommitPropTree = Field(default=...)
    parents: List[GitCommitPropParentsItems] = Field(default=...)
    verification: GitCommitPropVerification = Field(default=...)
    html_url: str = Field(default=...)


class GitCommitPropAuthor(GitHubRestModel):
    """GitCommitPropAuthor

    Identifying information for the git-user
    """

    date: datetime = Field(description="Timestamp of the commit", default=...)
    email: str = Field(description="Git email address of the user", default=...)
    name: str = Field(description="Name of the git user", default=...)


class GitCommitPropCommitter(GitHubRestModel):
    """GitCommitPropCommitter

    Identifying information for the git-user
    """

    date: datetime = Field(description="Timestamp of the commit", default=...)
    email: str = Field(description="Git email address of the user", default=...)
    name: str = Field(description="Name of the git user", default=...)


class GitCommitPropTree(GitHubRestModel):
    """GitCommitPropTree"""

    sha: str = Field(description="SHA for the commit", default=...)
    url: str = Field(default=...)


class GitCommitPropParentsItems(GitHubRestModel):
    """GitCommitPropParentsItems"""

    sha: str = Field(description="SHA for the commit", default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)


class GitCommitPropVerification(GitHubRestModel):
    """GitCommitPropVerification"""

    verified: bool = Field(default=...)
    reason: str = Field(default=...)
    signature: Union[str, None] = Field(default=...)
    payload: Union[str, None] = Field(default=...)


class GitRef(GitHubRestModel):
    """Git Reference

    Git references within a repository
    """

    ref: str = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    object_: GitRefPropObject = Field(default=..., alias="object")


class GitRefPropObject(GitHubRestModel):
    """GitRefPropObject"""

    type: str = Field(default=...)
    sha: str = Field(
        description="SHA for the reference", min_length=40, max_length=40, default=...
    )
    url: str = Field(default=...)


class GitTag(GitHubRestModel):
    """Git Tag

    Metadata for a Git tag
    """

    node_id: str = Field(default=...)
    tag: str = Field(description="Name of the tag", default=...)
    sha: str = Field(default=...)
    url: str = Field(description="URL for the tag", default=...)
    message: str = Field(
        description="Message describing the purpose of the tag", default=...
    )
    tagger: GitTagPropTagger = Field(default=...)
    object_: GitTagPropObject = Field(default=..., alias="object")
    verification: Union[Unset, Verification] = Field(
        title="Verification", default=UNSET
    )


class GitTagPropTagger(GitHubRestModel):
    """GitTagPropTagger"""

    date: str = Field(default=...)
    email: str = Field(default=...)
    name: str = Field(default=...)


class GitTagPropObject(GitHubRestModel):
    """GitTagPropObject"""

    sha: str = Field(default=...)
    type: str = Field(default=...)
    url: str = Field(default=...)


class GitTree(GitHubRestModel):
    """Git Tree

    The hierarchy between files in a Git repository.
    """

    sha: str = Field(default=...)
    url: str = Field(default=...)
    truncated: bool = Field(default=...)
    tree: List[GitTreePropTreeItems] = Field(
        description="Objects specifying a tree structure", default=...
    )


class GitTreePropTreeItems(GitHubRestModel):
    """GitTreePropTreeItems"""

    path: Union[Unset, str] = Field(default=UNSET)
    mode: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, str] = Field(default=UNSET)
    sha: Union[Unset, str] = Field(default=UNSET)
    size: Union[Unset, int] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class HookResponse(GitHubRestModel):
    """Hook Response"""

    code: Union[int, None] = Field(default=...)
    status: Union[str, None] = Field(default=...)
    message: Union[str, None] = Field(default=...)


class Hook(GitHubRestModel):
    """Webhook

    Webhooks for repositories.
    """

    type: str = Field(default=...)
    id: int = Field(description="Unique identifier of the webhook.", default=...)
    name: str = Field(
        description="The name of a valid service, use 'web' for a webhook.", default=...
    )
    active: bool = Field(
        description="Determines whether the hook is actually triggered on pushes.",
        default=...,
    )
    events: List[str] = Field(
        description="Determines what events the hook is triggered for. Default: ['push'].",
        default=...,
    )
    config: HookPropConfig = Field(default=...)
    updated_at: datetime = Field(default=...)
    created_at: datetime = Field(default=...)
    url: str = Field(default=...)
    test_url: str = Field(default=...)
    ping_url: str = Field(default=...)
    deliveries_url: Union[Unset, str] = Field(default=UNSET)
    last_response: HookResponse = Field(title="Hook Response", default=...)


class HookPropConfig(GitHubRestModel):
    """HookPropConfig"""

    email: Union[Unset, str] = Field(default=UNSET)
    password: Union[Unset, str] = Field(default=UNSET)
    room: Union[Unset, str] = Field(default=UNSET)
    subdomain: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(
        description="The URL to which the payloads will be delivered.", default=UNSET
    )
    insecure_ssl: Union[Unset, Union[str, float]] = Field(
        description="Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**",
        default=UNSET,
    )
    content_type: Union[Unset, str] = Field(
        description="The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.",
        default=UNSET,
    )
    digest: Union[Unset, str] = Field(default=UNSET)
    secret: Union[Unset, str] = Field(
        description="If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).",
        default=UNSET,
    )
    token: Union[Unset, str] = Field(default=UNSET)


class Import(GitHubRestModel):
    """Import

    A repository import from an external source.
    """

    vcs: Union[str, None] = Field(default=...)
    use_lfs: Union[Unset, bool] = Field(default=UNSET)
    vcs_url: str = Field(
        description="The URL of the originating repository.", default=...
    )
    svc_root: Union[Unset, str] = Field(default=UNSET)
    tfvc_project: Union[Unset, str] = Field(default=UNSET)
    status: Literal[
        "auth",
        "error",
        "none",
        "detecting",
        "choose",
        "auth_failed",
        "importing",
        "mapping",
        "waiting_to_push",
        "pushing",
        "complete",
        "setup",
        "unknown",
        "detection_found_multiple",
        "detection_found_nothing",
        "detection_needs_auth",
    ] = Field(default=...)
    status_text: Union[Unset, Union[str, None]] = Field(default=UNSET)
    failed_step: Union[Unset, Union[str, None]] = Field(default=UNSET)
    error_message: Union[Unset, Union[str, None]] = Field(default=UNSET)
    import_percent: Union[Unset, Union[int, None]] = Field(default=UNSET)
    commit_count: Union[Unset, Union[int, None]] = Field(default=UNSET)
    push_percent: Union[Unset, Union[int, None]] = Field(default=UNSET)
    has_large_files: Union[Unset, bool] = Field(default=UNSET)
    large_files_size: Union[Unset, int] = Field(default=UNSET)
    large_files_count: Union[Unset, int] = Field(default=UNSET)
    project_choices: Union[Unset, List[ImportPropProjectChoicesItems]] = Field(
        default=UNSET
    )
    message: Union[Unset, str] = Field(default=UNSET)
    authors_count: Union[Unset, Union[int, None]] = Field(default=UNSET)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    authors_url: str = Field(default=...)
    repository_url: str = Field(default=...)
    svn_root: Union[Unset, str] = Field(default=UNSET)


class ImportPropProjectChoicesItems(GitHubRestModel):
    """ImportPropProjectChoicesItems"""

    vcs: Union[Unset, str] = Field(default=UNSET)
    tfvc_project: Union[Unset, str] = Field(default=UNSET)
    human_name: Union[Unset, str] = Field(default=UNSET)


class PorterAuthor(GitHubRestModel):
    """Porter Author

    Porter Author
    """

    id: int = Field(default=...)
    remote_id: str = Field(default=...)
    remote_name: str = Field(default=...)
    email: str = Field(default=...)
    name: str = Field(default=...)
    url: str = Field(default=...)
    import_url: str = Field(default=...)


class PorterLargeFile(GitHubRestModel):
    """Porter Large File

    Porter Large File
    """

    ref_name: str = Field(default=...)
    path: str = Field(default=...)
    oid: str = Field(default=...)
    size: int = Field(default=...)


class IssueEventLabel(GitHubRestModel):
    """Issue Event Label

    Issue Event Label
    """

    name: Union[str, None] = Field(default=...)
    color: Union[str, None] = Field(default=...)


class IssueEventDismissedReview(GitHubRestModel):
    """Issue Event Dismissed Review"""

    state: str = Field(default=...)
    review_id: int = Field(default=...)
    dismissal_message: Union[str, None] = Field(default=...)
    dismissal_commit_id: Union[Unset, Union[str, None]] = Field(default=UNSET)


class IssueEventMilestone(GitHubRestModel):
    """Issue Event Milestone

    Issue Event Milestone
    """

    title: str = Field(default=...)


class IssueEventProjectCard(GitHubRestModel):
    """Issue Event Project Card

    Issue Event Project Card
    """

    url: str = Field(default=...)
    id: int = Field(default=...)
    project_url: str = Field(default=...)
    project_id: int = Field(default=...)
    column_name: str = Field(default=...)
    previous_column_name: Union[Unset, str] = Field(default=UNSET)


class IssueEventRename(GitHubRestModel):
    """Issue Event Rename

    Issue Event Rename
    """

    from_: str = Field(default=..., alias="from")
    to: str = Field(default=...)


class IssueEvent(GitHubRestModel):
    """Issue Event

    Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    event: str = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    issue: Union[Unset, Union[None, Issue]] = Field(
        title="Issue",
        description="Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.",
        default=UNSET,
    )
    label: Union[Unset, IssueEventLabel] = Field(
        title="Issue Event Label", description="Issue Event Label", default=UNSET
    )
    assignee: Union[Unset, Union[None, SimpleUser]] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    assigner: Union[Unset, Union[None, SimpleUser]] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    review_requester: Union[Unset, Union[None, SimpleUser]] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    requested_reviewer: Union[Unset, Union[None, SimpleUser]] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    requested_team: Union[Unset, Team] = Field(
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=UNSET,
    )
    dismissed_review: Union[Unset, IssueEventDismissedReview] = Field(
        title="Issue Event Dismissed Review", default=UNSET
    )
    milestone: Union[Unset, IssueEventMilestone] = Field(
        title="Issue Event Milestone",
        description="Issue Event Milestone",
        default=UNSET,
    )
    project_card: Union[Unset, IssueEventProjectCard] = Field(
        title="Issue Event Project Card",
        description="Issue Event Project Card",
        default=UNSET,
    )
    rename: Union[Unset, IssueEventRename] = Field(
        title="Issue Event Rename", description="Issue Event Rename", default=UNSET
    )
    author_association: Union[
        Unset,
        Literal[
            "COLLABORATOR",
            "CONTRIBUTOR",
            "FIRST_TIMER",
            "FIRST_TIME_CONTRIBUTOR",
            "MANNEQUIN",
            "MEMBER",
            "NONE",
            "OWNER",
        ],
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=UNSET,
    )
    lock_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    performed_via_github_app: Union[Unset, Union[None, Integration]] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )


class LabeledIssueEvent(GitHubRestModel):
    """Labeled Issue Event

    Labeled Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    event: Literal["labeled"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    label: LabeledIssueEventPropLabel = Field(default=...)


class LabeledIssueEventPropLabel(GitHubRestModel):
    """LabeledIssueEventPropLabel"""

    name: str = Field(default=...)
    color: str = Field(default=...)


class UnlabeledIssueEvent(GitHubRestModel):
    """Unlabeled Issue Event

    Unlabeled Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    event: Literal["unlabeled"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    label: UnlabeledIssueEventPropLabel = Field(default=...)


class UnlabeledIssueEventPropLabel(GitHubRestModel):
    """UnlabeledIssueEventPropLabel"""

    name: str = Field(default=...)
    color: str = Field(default=...)


class AssignedIssueEvent(GitHubRestModel):
    """Assigned Issue Event

    Assigned Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    event: str = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Integration = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    assignee: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    assigner: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class UnassignedIssueEvent(GitHubRestModel):
    """Unassigned Issue Event

    Unassigned Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    event: str = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    assignee: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    assigner: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class MilestonedIssueEvent(GitHubRestModel):
    """Milestoned Issue Event

    Milestoned Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    event: Literal["milestoned"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    milestone: MilestonedIssueEventPropMilestone = Field(default=...)


class MilestonedIssueEventPropMilestone(GitHubRestModel):
    """MilestonedIssueEventPropMilestone"""

    title: str = Field(default=...)


class DemilestonedIssueEvent(GitHubRestModel):
    """Demilestoned Issue Event

    Demilestoned Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    event: Literal["demilestoned"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    milestone: DemilestonedIssueEventPropMilestone = Field(default=...)


class DemilestonedIssueEventPropMilestone(GitHubRestModel):
    """DemilestonedIssueEventPropMilestone"""

    title: str = Field(default=...)


class RenamedIssueEvent(GitHubRestModel):
    """Renamed Issue Event

    Renamed Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    event: Literal["renamed"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    rename: RenamedIssueEventPropRename = Field(default=...)


class RenamedIssueEventPropRename(GitHubRestModel):
    """RenamedIssueEventPropRename"""

    from_: str = Field(default=..., alias="from")
    to: str = Field(default=...)


class ReviewRequestedIssueEvent(GitHubRestModel):
    """Review Requested Issue Event

    Review Requested Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    event: Literal["review_requested"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    review_requester: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    requested_team: Union[Unset, Team] = Field(
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=UNSET,
    )
    requested_reviewer: Union[Unset, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )


class ReviewRequestRemovedIssueEvent(GitHubRestModel):
    """Review Request Removed Issue Event

    Review Request Removed Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    event: Literal["review_request_removed"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    review_requester: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    requested_team: Union[Unset, Team] = Field(
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=UNSET,
    )
    requested_reviewer: Union[Unset, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )


class ReviewDismissedIssueEvent(GitHubRestModel):
    """Review Dismissed Issue Event

    Review Dismissed Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    event: Literal["review_dismissed"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    dismissed_review: ReviewDismissedIssueEventPropDismissedReview = Field(default=...)


class ReviewDismissedIssueEventPropDismissedReview(GitHubRestModel):
    """ReviewDismissedIssueEventPropDismissedReview"""

    state: str = Field(default=...)
    review_id: int = Field(default=...)
    dismissal_message: Union[str, None] = Field(default=...)
    dismissal_commit_id: Union[Unset, str] = Field(default=UNSET)


class LockedIssueEvent(GitHubRestModel):
    """Locked Issue Event

    Locked Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    event: Literal["locked"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    lock_reason: Union[str, None] = Field(default=...)


class AddedToProjectIssueEvent(GitHubRestModel):
    """Added to Project Issue Event

    Added to Project Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    event: Literal["added_to_project"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    project_card: Union[Unset, AddedToProjectIssueEventPropProjectCard] = Field(
        default=UNSET
    )


class AddedToProjectIssueEventPropProjectCard(GitHubRestModel):
    """AddedToProjectIssueEventPropProjectCard"""

    id: int = Field(default=...)
    url: str = Field(default=...)
    project_id: int = Field(default=...)
    project_url: str = Field(default=...)
    column_name: str = Field(default=...)
    previous_column_name: Union[Unset, str] = Field(default=UNSET)


class MovedColumnInProjectIssueEvent(GitHubRestModel):
    """Moved Column in Project Issue Event

    Moved Column in Project Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    event: Literal["moved_columns_in_project"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    project_card: Union[Unset, MovedColumnInProjectIssueEventPropProjectCard] = Field(
        default=UNSET
    )


class MovedColumnInProjectIssueEventPropProjectCard(GitHubRestModel):
    """MovedColumnInProjectIssueEventPropProjectCard"""

    id: int = Field(default=...)
    url: str = Field(default=...)
    project_id: int = Field(default=...)
    project_url: str = Field(default=...)
    column_name: str = Field(default=...)
    previous_column_name: Union[Unset, str] = Field(default=UNSET)


class RemovedFromProjectIssueEvent(GitHubRestModel):
    """Removed from Project Issue Event

    Removed from Project Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    event: Literal["removed_from_project"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    project_card: Union[Unset, RemovedFromProjectIssueEventPropProjectCard] = Field(
        default=UNSET
    )


class RemovedFromProjectIssueEventPropProjectCard(GitHubRestModel):
    """RemovedFromProjectIssueEventPropProjectCard"""

    id: int = Field(default=...)
    url: str = Field(default=...)
    project_id: int = Field(default=...)
    project_url: str = Field(default=...)
    column_name: str = Field(default=...)
    previous_column_name: Union[Unset, str] = Field(default=UNSET)


class ConvertedNoteToIssueIssueEvent(GitHubRestModel):
    """Converted Note to Issue Issue Event

    Converted Note to Issue Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    event: Literal["converted_note_to_issue"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Integration = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    project_card: Union[Unset, ConvertedNoteToIssueIssueEventPropProjectCard] = Field(
        default=UNSET
    )


class ConvertedNoteToIssueIssueEventPropProjectCard(GitHubRestModel):
    """ConvertedNoteToIssueIssueEventPropProjectCard"""

    id: int = Field(default=...)
    url: str = Field(default=...)
    project_id: int = Field(default=...)
    project_url: str = Field(default=...)
    column_name: str = Field(default=...)
    previous_column_name: Union[Unset, str] = Field(default=UNSET)


class Label(GitHubRestModel):
    """Label

    Color-coded labels help you categorize and filter your issues (just like labels
    in Gmail).
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)
    name: str = Field(description="The name of the label.", default=...)
    description: Union[str, None] = Field(default=...)
    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)


class TimelineCommentEvent(GitHubRestModel):
    """Timeline Comment Event

    Timeline Comment Event
    """

    event: Literal["commented"] = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    id: int = Field(description="Unique identifier of the issue comment", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the issue comment", default=...)
    body: Union[Unset, str] = Field(
        description="Contents of the issue comment", default=UNSET
    )
    body_text: Union[Unset, str] = Field(default=UNSET)
    body_html: Union[Unset, str] = Field(default=UNSET)
    html_url: str = Field(default=...)
    user: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    issue_url: str = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )
    performed_via_github_app: Union[Unset, Union[None, Integration]] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    reactions: Union[Unset, ReactionRollup] = Field(
        title="Reaction Rollup", default=UNSET
    )


class TimelineCrossReferencedEvent(GitHubRestModel):
    """Timeline Cross Referenced Event

    Timeline Cross Referenced Event
    """

    event: Literal["cross-referenced"] = Field(default=...)
    actor: Union[Unset, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    source: TimelineCrossReferencedEventPropSource = Field(default=...)


class TimelineCrossReferencedEventPropSource(GitHubRestModel):
    """TimelineCrossReferencedEventPropSource"""

    type: Union[Unset, str] = Field(default=UNSET)
    issue: Union[Unset, Issue] = Field(
        title="Issue",
        description="Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.",
        default=UNSET,
    )


class TimelineCommittedEvent(GitHubRestModel):
    """Timeline Committed Event

    Timeline Committed Event
    """

    event: Union[Unset, Literal["committed"]] = Field(default=UNSET)
    sha: str = Field(description="SHA for the commit", default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    author: TimelineCommittedEventPropAuthor = Field(
        description="Identifying information for the git-user", default=...
    )
    committer: TimelineCommittedEventPropCommitter = Field(
        description="Identifying information for the git-user", default=...
    )
    message: str = Field(
        description="Message describing the purpose of the commit", default=...
    )
    tree: TimelineCommittedEventPropTree = Field(default=...)
    parents: List[TimelineCommittedEventPropParentsItems] = Field(default=...)
    verification: TimelineCommittedEventPropVerification = Field(default=...)
    html_url: str = Field(default=...)


class TimelineCommittedEventPropAuthor(GitHubRestModel):
    """TimelineCommittedEventPropAuthor

    Identifying information for the git-user
    """

    date: datetime = Field(description="Timestamp of the commit", default=...)
    email: str = Field(description="Git email address of the user", default=...)
    name: str = Field(description="Name of the git user", default=...)


class TimelineCommittedEventPropCommitter(GitHubRestModel):
    """TimelineCommittedEventPropCommitter

    Identifying information for the git-user
    """

    date: datetime = Field(description="Timestamp of the commit", default=...)
    email: str = Field(description="Git email address of the user", default=...)
    name: str = Field(description="Name of the git user", default=...)


class TimelineCommittedEventPropTree(GitHubRestModel):
    """TimelineCommittedEventPropTree"""

    sha: str = Field(description="SHA for the commit", default=...)
    url: str = Field(default=...)


class TimelineCommittedEventPropParentsItems(GitHubRestModel):
    """TimelineCommittedEventPropParentsItems"""

    sha: str = Field(description="SHA for the commit", default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)


class TimelineCommittedEventPropVerification(GitHubRestModel):
    """TimelineCommittedEventPropVerification"""

    verified: bool = Field(default=...)
    reason: str = Field(default=...)
    signature: Union[str, None] = Field(default=...)
    payload: Union[str, None] = Field(default=...)


class TimelineReviewedEvent(GitHubRestModel):
    """Timeline Reviewed Event

    Timeline Reviewed Event
    """

    event: Literal["reviewed"] = Field(default=...)
    id: int = Field(description="Unique identifier of the review", default=...)
    node_id: str = Field(default=...)
    user: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    body: Union[str, None] = Field(description="The text of the review.", default=...)
    state: str = Field(default=...)
    html_url: str = Field(default=...)
    pull_request_url: str = Field(default=...)
    links: TimelineReviewedEventPropLinks = Field(default=..., alias="_links")
    submitted_at: Union[Unset, datetime] = Field(default=UNSET)
    commit_id: str = Field(description="A commit SHA for the review.", default=...)
    body_html: Union[Unset, Union[str, None]] = Field(default=UNSET)
    body_text: Union[Unset, Union[str, None]] = Field(default=UNSET)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )


class TimelineReviewedEventPropLinks(GitHubRestModel):
    """TimelineReviewedEventPropLinks"""

    html: TimelineReviewedEventPropLinksPropHtml = Field(default=...)
    pull_request: TimelineReviewedEventPropLinksPropPullRequest = Field(default=...)


class TimelineReviewedEventPropLinksPropHtml(GitHubRestModel):
    """TimelineReviewedEventPropLinksPropHtml"""

    href: str = Field(default=...)


class TimelineReviewedEventPropLinksPropPullRequest(GitHubRestModel):
    """TimelineReviewedEventPropLinksPropPullRequest"""

    href: str = Field(default=...)


class PullRequestReviewComment(GitHubRestModel):
    """Pull Request Review Comment

    Pull Request Review Comments are comments on a portion of the Pull Request's
    diff.
    """

    url: str = Field(description="URL for the pull request review comment", default=...)
    pull_request_review_id: Union[int, None] = Field(
        description="The ID of the pull request review to which the comment belongs.",
        default=...,
    )
    id: int = Field(
        description="The ID of the pull request review comment.", default=...
    )
    node_id: str = Field(
        description="The node ID of the pull request review comment.", default=...
    )
    diff_hunk: str = Field(
        description="The diff of the line that the comment refers to.", default=...
    )
    path: str = Field(
        description="The relative path of the file to which the comment applies.",
        default=...,
    )
    position: int = Field(
        description="The line index in the diff to which the comment applies. This field is deprecated; use `line` instead.",
        default=...,
    )
    original_position: int = Field(
        description="The index of the original line in the diff to which the comment applies. This field is deprecated; use `original_line` instead.",
        default=...,
    )
    commit_id: str = Field(
        description="The SHA of the commit to which the comment applies.", default=...
    )
    original_commit_id: str = Field(
        description="The SHA of the original commit to which the comment applies.",
        default=...,
    )
    in_reply_to_id: Union[Unset, int] = Field(
        description="The comment ID to reply to.", default=UNSET
    )
    user: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    body: str = Field(description="The text of the comment.", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    html_url: str = Field(
        description="HTML URL for the pull request review comment.", default=...
    )
    pull_request_url: str = Field(
        description="URL for the pull request that the review comment belongs to.",
        default=...,
    )
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )
    links: PullRequestReviewCommentPropLinks = Field(default=..., alias="_links")
    start_line: Union[Unset, Union[int, None]] = Field(
        description="The first line of the range for a multi-line comment.",
        default=UNSET,
    )
    original_start_line: Union[Unset, Union[int, None]] = Field(
        description="The first line of the range for a multi-line comment.",
        default=UNSET,
    )
    start_side: Union[Unset, Union[None, Literal["LEFT", "RIGHT"]]] = Field(
        description="The side of the first line of the range for a multi-line comment.",
        default="RIGHT",
    )
    line: Union[Unset, int] = Field(
        description="The line of the blob to which the comment applies. The last line of the range for a multi-line comment",
        default=UNSET,
    )
    original_line: Union[Unset, int] = Field(
        description="The line of the blob to which the comment applies. The last line of the range for a multi-line comment",
        default=UNSET,
    )
    side: Union[Unset, Literal["LEFT", "RIGHT"]] = Field(
        description="The side of the diff to which the comment applies. The side of the last line of the range for a multi-line comment",
        default="RIGHT",
    )
    reactions: Union[Unset, ReactionRollup] = Field(
        title="Reaction Rollup", default=UNSET
    )
    body_html: Union[Unset, str] = Field(default=UNSET)
    body_text: Union[Unset, str] = Field(default=UNSET)


class PullRequestReviewCommentPropLinks(GitHubRestModel):
    """PullRequestReviewCommentPropLinks"""

    self_: PullRequestReviewCommentPropLinksPropSelf = Field(default=..., alias="self")
    html: PullRequestReviewCommentPropLinksPropHtml = Field(default=...)
    pull_request: PullRequestReviewCommentPropLinksPropPullRequest = Field(default=...)


class PullRequestReviewCommentPropLinksPropSelf(GitHubRestModel):
    """PullRequestReviewCommentPropLinksPropSelf"""

    href: str = Field(default=...)


class PullRequestReviewCommentPropLinksPropHtml(GitHubRestModel):
    """PullRequestReviewCommentPropLinksPropHtml"""

    href: str = Field(default=...)


class PullRequestReviewCommentPropLinksPropPullRequest(GitHubRestModel):
    """PullRequestReviewCommentPropLinksPropPullRequest"""

    href: str = Field(default=...)


class TimelineLineCommentedEvent(GitHubRestModel):
    """Timeline Line Commented Event

    Timeline Line Commented Event
    """

    event: Union[Unset, Literal["line_commented"]] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    comments: Union[Unset, List[PullRequestReviewComment]] = Field(default=UNSET)


class TimelineCommitCommentedEvent(GitHubRestModel):
    """Timeline Commit Commented Event

    Timeline Commit Commented Event
    """

    event: Union[Unset, Literal["commit_commented"]] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    commit_id: Union[Unset, str] = Field(default=UNSET)
    comments: Union[Unset, List[CommitComment]] = Field(default=UNSET)


class TimelineAssignedIssueEvent(GitHubRestModel):
    """Timeline Assigned Issue Event

    Timeline Assigned Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    event: Literal["assigned"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    assignee: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class TimelineUnassignedIssueEvent(GitHubRestModel):
    """Timeline Unassigned Issue Event

    Timeline Unassigned Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    event: Literal["unassigned"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    assignee: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class StateChangeIssueEvent(GitHubRestModel):
    """State Change Issue Event

    State Change Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    event: str = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)


class DeployKey(GitHubRestModel):
    """Deploy Key

    An SSH key granting access to a single repository.
    """

    id: int = Field(default=...)
    key: str = Field(default=...)
    url: str = Field(default=...)
    title: str = Field(default=...)
    verified: bool = Field(default=...)
    created_at: str = Field(default=...)
    read_only: bool = Field(default=...)
    added_by: Union[Unset, Union[str, None]] = Field(default=UNSET)
    last_used: Union[Unset, Union[str, None]] = Field(default=UNSET)


class Language(GitHubRestModel, extra=Extra.allow):
    """Language

    Language
    """


class LicenseContent(GitHubRestModel):
    """License Content

    License Content
    """

    name: str = Field(default=...)
    path: str = Field(default=...)
    sha: str = Field(default=...)
    size: int = Field(default=...)
    url: str = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    git_url: Union[str, None] = Field(default=...)
    download_url: Union[str, None] = Field(default=...)
    type: str = Field(default=...)
    content: str = Field(default=...)
    encoding: str = Field(default=...)
    links: LicenseContentPropLinks = Field(default=..., alias="_links")
    license_: Union[None, LicenseSimple] = Field(
        title="License Simple",
        description="License Simple",
        default=...,
        alias="license",
    )


class LicenseContentPropLinks(GitHubRestModel):
    """LicenseContentPropLinks"""

    git: Union[str, None] = Field(default=...)
    html: Union[str, None] = Field(default=...)
    self_: str = Field(default=..., alias="self")


class MergedUpstream(GitHubRestModel):
    """Merged upstream

    Results of a successful merge upstream request
    """

    message: Union[Unset, str] = Field(default=UNSET)
    merge_type: Union[Unset, Literal["merge", "fast-forward", "none"]] = Field(
        default=UNSET
    )
    base_branch: Union[Unset, str] = Field(default=UNSET)


class PagesSourceHash(GitHubRestModel):
    """Pages Source Hash"""

    branch: str = Field(default=...)
    path: str = Field(default=...)


class PagesHttpsCertificate(GitHubRestModel):
    """Pages Https Certificate"""

    state: Literal[
        "new",
        "authorization_created",
        "authorization_pending",
        "authorized",
        "authorization_revoked",
        "issued",
        "uploaded",
        "approved",
        "errored",
        "bad_authz",
        "destroy_pending",
        "dns_changed",
    ] = Field(default=...)
    description: str = Field(default=...)
    domains: List[str] = Field(
        description="Array of the domain set and its alternate name (if it is configured)",
        default=...,
    )
    expires_at: Union[Unset, date] = Field(default=UNSET)


class Page(GitHubRestModel):
    """GitHub Pages

    The configuration for GitHub Pages for a repository.
    """

    url: str = Field(
        description="The API address for accessing this Page resource.", default=...
    )
    status: Union[None, Literal["built", "building", "errored"]] = Field(
        description="The status of the most recent build of the Page.", default=...
    )
    cname: Union[str, None] = Field(
        description="The Pages site's custom domain", default=...
    )
    protected_domain_state: Union[
        Unset, Union[None, Literal["pending", "verified", "unverified"]]
    ] = Field(description="The state if the domain is verified", default=UNSET)
    pending_domain_unverified_at: Union[Unset, Union[datetime, None]] = Field(
        description="The timestamp when a pending domain becomes unverified.",
        default=UNSET,
    )
    custom_404: bool = Field(
        description="Whether the Page has a custom 404 page.", default=False
    )
    html_url: Union[Unset, str] = Field(
        description="The web address the Page can be accessed from.", default=UNSET
    )
    build_type: Union[Unset, Union[None, Literal["legacy", "workflow"]]] = Field(
        description="The process in which the Page will be built.", default=UNSET
    )
    source: Union[Unset, PagesSourceHash] = Field(
        title="Pages Source Hash", default=UNSET
    )
    public: bool = Field(
        description="Whether the GitHub Pages site is publicly visible. If set to `true`, the site is accessible to anyone on the internet. If set to `false`, the site will only be accessible to users who have at least `read` access to the repository that published the site.",
        default=...,
    )
    https_certificate: Union[Unset, PagesHttpsCertificate] = Field(
        title="Pages Https Certificate", default=UNSET
    )
    https_enforced: Union[Unset, bool] = Field(
        description="Whether https is enabled on the domain", default=UNSET
    )


class PageBuild(GitHubRestModel):
    """Page Build

    Page Build
    """

    url: str = Field(default=...)
    status: str = Field(default=...)
    error: PageBuildPropError = Field(default=...)
    pusher: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    commit: str = Field(default=...)
    duration: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class PageBuildPropError(GitHubRestModel):
    """PageBuildPropError"""

    message: Union[str, None] = Field(default=...)


class PageBuildStatus(GitHubRestModel):
    """Page Build Status

    Page Build Status
    """

    url: str = Field(default=...)
    status: str = Field(default=...)


class PageDeployment(GitHubRestModel):
    """GitHub Pages

    The GitHub Pages deployment status.
    """

    status_url: str = Field(
        description="The URI to monitor GitHub Pages deployment status.", default=...
    )
    page_url: str = Field(
        description="The URI to the deployed GitHub Pages.", default=...
    )
    preview_url: Union[Unset, str] = Field(
        description="The URI to the deployed GitHub Pages preview.", default=UNSET
    )


class PagesHealthCheck(GitHubRestModel):
    """Pages Health Check Status

    Pages Health Check Status
    """

    domain: Union[Unset, PagesHealthCheckPropDomain] = Field(default=UNSET)
    alt_domain: Union[Unset, Union[PagesHealthCheckPropAltDomain, None]] = Field(
        default=UNSET
    )


class PagesHealthCheckPropDomain(GitHubRestModel):
    """PagesHealthCheckPropDomain"""

    host: Union[Unset, str] = Field(default=UNSET)
    uri: Union[Unset, str] = Field(default=UNSET)
    nameservers: Union[Unset, str] = Field(default=UNSET)
    dns_resolves: Union[Unset, bool] = Field(default=UNSET)
    is_proxied: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    is_cloudflare_ip: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    is_fastly_ip: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    is_old_ip_address: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    is_a_record: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    has_cname_record: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    has_mx_records_present: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    is_valid_domain: Union[Unset, bool] = Field(default=UNSET)
    is_apex_domain: Union[Unset, bool] = Field(default=UNSET)
    should_be_a_record: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    is_cname_to_github_user_domain: Union[Unset, Union[bool, None]] = Field(
        default=UNSET
    )
    is_cname_to_pages_dot_github_dot_com: Union[Unset, Union[bool, None]] = Field(
        default=UNSET
    )
    is_cname_to_fastly: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    is_pointed_to_github_pages_ip: Union[Unset, Union[bool, None]] = Field(
        default=UNSET
    )
    is_non_github_pages_ip_present: Union[Unset, Union[bool, None]] = Field(
        default=UNSET
    )
    is_pages_domain: Union[Unset, bool] = Field(default=UNSET)
    is_served_by_pages: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    is_valid: Union[Unset, bool] = Field(default=UNSET)
    reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    responds_to_https: Union[Unset, bool] = Field(default=UNSET)
    enforces_https: Union[Unset, bool] = Field(default=UNSET)
    https_error: Union[Unset, Union[str, None]] = Field(default=UNSET)
    is_https_eligible: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    caa_error: Union[Unset, Union[str, None]] = Field(default=UNSET)


class PagesHealthCheckPropAltDomain(GitHubRestModel):
    """PagesHealthCheckPropAltDomain"""

    host: Union[Unset, str] = Field(default=UNSET)
    uri: Union[Unset, str] = Field(default=UNSET)
    nameservers: Union[Unset, str] = Field(default=UNSET)
    dns_resolves: Union[Unset, bool] = Field(default=UNSET)
    is_proxied: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    is_cloudflare_ip: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    is_fastly_ip: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    is_old_ip_address: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    is_a_record: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    has_cname_record: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    has_mx_records_present: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    is_valid_domain: Union[Unset, bool] = Field(default=UNSET)
    is_apex_domain: Union[Unset, bool] = Field(default=UNSET)
    should_be_a_record: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    is_cname_to_github_user_domain: Union[Unset, Union[bool, None]] = Field(
        default=UNSET
    )
    is_cname_to_pages_dot_github_dot_com: Union[Unset, Union[bool, None]] = Field(
        default=UNSET
    )
    is_cname_to_fastly: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    is_pointed_to_github_pages_ip: Union[Unset, Union[bool, None]] = Field(
        default=UNSET
    )
    is_non_github_pages_ip_present: Union[Unset, Union[bool, None]] = Field(
        default=UNSET
    )
    is_pages_domain: Union[Unset, bool] = Field(default=UNSET)
    is_served_by_pages: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    is_valid: Union[Unset, bool] = Field(default=UNSET)
    reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    responds_to_https: Union[Unset, bool] = Field(default=UNSET)
    enforces_https: Union[Unset, bool] = Field(default=UNSET)
    https_error: Union[Unset, Union[str, None]] = Field(default=UNSET)
    is_https_eligible: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    caa_error: Union[Unset, Union[str, None]] = Field(default=UNSET)


class PullRequest(GitHubRestModel):
    """Pull Request

    Pull requests let you tell others about changes you've pushed to a repository on
    GitHub. Once a pull request is sent, interested parties can review the set of
    changes, discuss potential modifications, and even push follow-up commits if
    necessary.
    """

    url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    diff_url: str = Field(default=...)
    patch_url: str = Field(default=...)
    issue_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    review_comments_url: str = Field(default=...)
    review_comment_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the pull request within its repository.",
        default=...,
    )
    state: Literal["open", "closed"] = Field(
        description="State of this Pull Request. Either `open` or `closed`.",
        default=...,
    )
    locked: bool = Field(default=...)
    title: str = Field(description="The title of the pull request.", default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    body: Union[str, None] = Field(default=...)
    labels: List[PullRequestPropLabelsItems] = Field(default=...)
    milestone: Union[None, Milestone] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    active_lock_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    merged_at: Union[datetime, None] = Field(default=...)
    merge_commit_sha: Union[str, None] = Field(default=...)
    assignee: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    assignees: Union[Unset, Union[List[SimpleUser], None]] = Field(default=UNSET)
    requested_reviewers: Union[Unset, Union[List[SimpleUser], None]] = Field(
        default=UNSET
    )
    requested_teams: Union[Unset, Union[List[TeamSimple], None]] = Field(default=UNSET)
    head: PullRequestPropHead = Field(default=...)
    base: PullRequestPropBase = Field(default=...)
    links: PullRequestPropLinks = Field(default=..., alias="_links")
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )
    auto_merge: Union[AutoMerge, None] = Field(
        title="Auto merge",
        description="The status of auto merging a pull request.",
        default=...,
    )
    draft: Union[Unset, bool] = Field(
        description="Indicates whether or not the pull request is a draft.",
        default=UNSET,
    )
    merged: bool = Field(default=...)
    mergeable: Union[bool, None] = Field(default=...)
    rebaseable: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    mergeable_state: str = Field(default=...)
    merged_by: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    comments: int = Field(default=...)
    review_comments: int = Field(default=...)
    maintainer_can_modify: bool = Field(
        description="Indicates whether maintainers can modify the pull request.",
        default=...,
    )
    commits: int = Field(default=...)
    additions: int = Field(default=...)
    deletions: int = Field(default=...)
    changed_files: int = Field(default=...)


class PullRequestPropLabelsItems(GitHubRestModel):
    """PullRequestPropLabelsItems"""

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    name: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    color: str = Field(default=...)
    default: bool = Field(default=...)


class PullRequestPropHead(GitHubRestModel):
    """PullRequestPropHead"""

    label: str = Field(default=...)
    ref: str = Field(default=...)
    repo: Union[PullRequestPropHeadPropRepo, None] = Field(default=...)
    sha: str = Field(default=...)
    user: PullRequestPropHeadPropUser = Field(default=...)


class PullRequestPropHeadPropRepoPropOwner(GitHubRestModel):
    """PullRequestPropHeadPropRepoPropOwner"""

    avatar_url: str = Field(default=...)
    events_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    gravatar_id: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    login: str = Field(default=...)
    organizations_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    site_admin: bool = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    type: str = Field(default=...)
    url: str = Field(default=...)


class PullRequestPropHeadPropRepoPropPermissions(GitHubRestModel):
    """PullRequestPropHeadPropRepoPropPermissions"""

    admin: bool = Field(default=...)
    maintain: Union[Unset, bool] = Field(default=UNSET)
    push: bool = Field(default=...)
    triage: Union[Unset, bool] = Field(default=UNSET)
    pull: bool = Field(default=...)


class PullRequestPropHeadPropRepoPropLicense(GitHubRestModel):
    """PullRequestPropHeadPropRepoPropLicense"""

    key: str = Field(default=...)
    name: str = Field(default=...)
    url: Union[str, None] = Field(default=...)
    spdx_id: Union[str, None] = Field(default=...)
    node_id: str = Field(default=...)


class PullRequestPropHeadPropRepo(GitHubRestModel):
    """PullRequestPropHeadPropRepo"""

    archive_url: str = Field(default=...)
    assignees_url: str = Field(default=...)
    blobs_url: str = Field(default=...)
    branches_url: str = Field(default=...)
    collaborators_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    compare_url: str = Field(default=...)
    contents_url: str = Field(default=...)
    contributors_url: str = Field(default=...)
    deployments_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    downloads_url: str = Field(default=...)
    events_url: str = Field(default=...)
    fork: bool = Field(default=...)
    forks_url: str = Field(default=...)
    full_name: str = Field(default=...)
    git_commits_url: str = Field(default=...)
    git_refs_url: str = Field(default=...)
    git_tags_url: str = Field(default=...)
    hooks_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    issue_comment_url: str = Field(default=...)
    issue_events_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    keys_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    languages_url: str = Field(default=...)
    merges_url: str = Field(default=...)
    milestones_url: str = Field(default=...)
    name: str = Field(default=...)
    notifications_url: str = Field(default=...)
    owner: PullRequestPropHeadPropRepoPropOwner = Field(default=...)
    private: bool = Field(default=...)
    pulls_url: str = Field(default=...)
    releases_url: str = Field(default=...)
    stargazers_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    subscribers_url: str = Field(default=...)
    subscription_url: str = Field(default=...)
    tags_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    trees_url: str = Field(default=...)
    url: str = Field(default=...)
    clone_url: str = Field(default=...)
    default_branch: str = Field(default=...)
    forks: int = Field(default=...)
    forks_count: int = Field(default=...)
    git_url: str = Field(default=...)
    has_downloads: bool = Field(default=...)
    has_issues: bool = Field(default=...)
    has_projects: bool = Field(default=...)
    has_wiki: bool = Field(default=...)
    has_pages: bool = Field(default=...)
    homepage: Union[str, None] = Field(default=...)
    language: Union[str, None] = Field(default=...)
    master_branch: Union[Unset, str] = Field(default=UNSET)
    archived: bool = Field(default=...)
    disabled: bool = Field(default=...)
    visibility: Union[Unset, str] = Field(
        description="The repository visibility: public, private, or internal.",
        default=UNSET,
    )
    mirror_url: Union[str, None] = Field(default=...)
    open_issues: int = Field(default=...)
    open_issues_count: int = Field(default=...)
    permissions: Union[Unset, PullRequestPropHeadPropRepoPropPermissions] = Field(
        default=UNSET
    )
    temp_clone_token: Union[Unset, str] = Field(default=UNSET)
    allow_merge_commit: Union[Unset, bool] = Field(default=UNSET)
    allow_squash_merge: Union[Unset, bool] = Field(default=UNSET)
    allow_rebase_merge: Union[Unset, bool] = Field(default=UNSET)
    license_: Union[PullRequestPropHeadPropRepoPropLicense, None] = Field(
        default=..., alias="license"
    )
    pushed_at: datetime = Field(default=...)
    size: int = Field(default=...)
    ssh_url: str = Field(default=...)
    stargazers_count: int = Field(default=...)
    svn_url: str = Field(default=...)
    topics: Union[Unset, List[str]] = Field(default=UNSET)
    watchers: int = Field(default=...)
    watchers_count: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    allow_forking: Union[Unset, bool] = Field(default=UNSET)
    is_template: Union[Unset, bool] = Field(default=UNSET)
    web_commit_signoff_required: Union[Unset, bool] = Field(default=UNSET)


class PullRequestPropHeadPropUser(GitHubRestModel):
    """PullRequestPropHeadPropUser"""

    avatar_url: str = Field(default=...)
    events_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    gravatar_id: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    login: str = Field(default=...)
    organizations_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    site_admin: bool = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    type: str = Field(default=...)
    url: str = Field(default=...)


class PullRequestPropBase(GitHubRestModel):
    """PullRequestPropBase"""

    label: str = Field(default=...)
    ref: str = Field(default=...)
    repo: PullRequestPropBasePropRepo = Field(default=...)
    sha: str = Field(default=...)
    user: PullRequestPropBasePropUser = Field(default=...)


class PullRequestPropBasePropRepo(GitHubRestModel):
    """PullRequestPropBasePropRepo"""

    archive_url: str = Field(default=...)
    assignees_url: str = Field(default=...)
    blobs_url: str = Field(default=...)
    branches_url: str = Field(default=...)
    collaborators_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    compare_url: str = Field(default=...)
    contents_url: str = Field(default=...)
    contributors_url: str = Field(default=...)
    deployments_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    downloads_url: str = Field(default=...)
    events_url: str = Field(default=...)
    fork: bool = Field(default=...)
    forks_url: str = Field(default=...)
    full_name: str = Field(default=...)
    git_commits_url: str = Field(default=...)
    git_refs_url: str = Field(default=...)
    git_tags_url: str = Field(default=...)
    hooks_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    is_template: Union[Unset, bool] = Field(default=UNSET)
    node_id: str = Field(default=...)
    issue_comment_url: str = Field(default=...)
    issue_events_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    keys_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    languages_url: str = Field(default=...)
    merges_url: str = Field(default=...)
    milestones_url: str = Field(default=...)
    name: str = Field(default=...)
    notifications_url: str = Field(default=...)
    owner: PullRequestPropBasePropRepoPropOwner = Field(default=...)
    private: bool = Field(default=...)
    pulls_url: str = Field(default=...)
    releases_url: str = Field(default=...)
    stargazers_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    subscribers_url: str = Field(default=...)
    subscription_url: str = Field(default=...)
    tags_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    trees_url: str = Field(default=...)
    url: str = Field(default=...)
    clone_url: str = Field(default=...)
    default_branch: str = Field(default=...)
    forks: int = Field(default=...)
    forks_count: int = Field(default=...)
    git_url: str = Field(default=...)
    has_downloads: bool = Field(default=...)
    has_issues: bool = Field(default=...)
    has_projects: bool = Field(default=...)
    has_wiki: bool = Field(default=...)
    has_pages: bool = Field(default=...)
    homepage: Union[str, None] = Field(default=...)
    language: Union[str, None] = Field(default=...)
    master_branch: Union[Unset, str] = Field(default=UNSET)
    archived: bool = Field(default=...)
    disabled: bool = Field(default=...)
    visibility: Union[Unset, str] = Field(
        description="The repository visibility: public, private, or internal.",
        default=UNSET,
    )
    mirror_url: Union[str, None] = Field(default=...)
    open_issues: int = Field(default=...)
    open_issues_count: int = Field(default=...)
    permissions: Union[Unset, PullRequestPropBasePropRepoPropPermissions] = Field(
        default=UNSET
    )
    temp_clone_token: Union[Unset, str] = Field(default=UNSET)
    allow_merge_commit: Union[Unset, bool] = Field(default=UNSET)
    allow_squash_merge: Union[Unset, bool] = Field(default=UNSET)
    allow_rebase_merge: Union[Unset, bool] = Field(default=UNSET)
    license_: Union[None, LicenseSimple] = Field(
        title="License Simple",
        description="License Simple",
        default=...,
        alias="license",
    )
    pushed_at: datetime = Field(default=...)
    size: int = Field(default=...)
    ssh_url: str = Field(default=...)
    stargazers_count: int = Field(default=...)
    svn_url: str = Field(default=...)
    topics: Union[Unset, List[str]] = Field(default=UNSET)
    watchers: int = Field(default=...)
    watchers_count: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    allow_forking: Union[Unset, bool] = Field(default=UNSET)
    web_commit_signoff_required: Union[Unset, bool] = Field(default=UNSET)


class PullRequestPropBasePropRepoPropOwner(GitHubRestModel):
    """PullRequestPropBasePropRepoPropOwner"""

    avatar_url: str = Field(default=...)
    events_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    gravatar_id: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    login: str = Field(default=...)
    organizations_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    site_admin: bool = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    type: str = Field(default=...)
    url: str = Field(default=...)


class PullRequestPropBasePropRepoPropPermissions(GitHubRestModel):
    """PullRequestPropBasePropRepoPropPermissions"""

    admin: bool = Field(default=...)
    maintain: Union[Unset, bool] = Field(default=UNSET)
    push: bool = Field(default=...)
    triage: Union[Unset, bool] = Field(default=UNSET)
    pull: bool = Field(default=...)


class PullRequestPropBasePropUser(GitHubRestModel):
    """PullRequestPropBasePropUser"""

    avatar_url: str = Field(default=...)
    events_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    gravatar_id: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    login: str = Field(default=...)
    organizations_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    site_admin: bool = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    type: str = Field(default=...)
    url: str = Field(default=...)


class PullRequestPropLinks(GitHubRestModel):
    """PullRequestPropLinks"""

    comments: Link = Field(title="Link", description="Hypermedia Link", default=...)
    commits: Link = Field(title="Link", description="Hypermedia Link", default=...)
    statuses: Link = Field(title="Link", description="Hypermedia Link", default=...)
    html: Link = Field(title="Link", description="Hypermedia Link", default=...)
    issue: Link = Field(title="Link", description="Hypermedia Link", default=...)
    review_comments: Link = Field(
        title="Link", description="Hypermedia Link", default=...
    )
    review_comment: Link = Field(
        title="Link", description="Hypermedia Link", default=...
    )
    self_: Link = Field(
        title="Link", description="Hypermedia Link", default=..., alias="self"
    )


class PullRequestMergeResult(GitHubRestModel):
    """Pull Request Merge Result

    Pull Request Merge Result
    """

    sha: str = Field(default=...)
    merged: bool = Field(default=...)
    message: str = Field(default=...)


class PullRequestReviewRequest(GitHubRestModel):
    """Pull Request Review Request

    Pull Request Review Request
    """

    users: List[SimpleUser] = Field(default=...)
    teams: List[Team] = Field(default=...)


class PullRequestReview(GitHubRestModel):
    """Pull Request Review

    Pull Request Reviews are reviews on pull requests.
    """

    id: int = Field(description="Unique identifier of the review", default=...)
    node_id: str = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    body: str = Field(description="The text of the review.", default=...)
    state: str = Field(default=...)
    html_url: str = Field(default=...)
    pull_request_url: str = Field(default=...)
    links: PullRequestReviewPropLinks = Field(default=..., alias="_links")
    submitted_at: Union[Unset, datetime] = Field(default=UNSET)
    commit_id: str = Field(description="A commit SHA for the review.", default=...)
    body_html: Union[Unset, str] = Field(default=UNSET)
    body_text: Union[Unset, str] = Field(default=UNSET)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )


class PullRequestReviewPropLinks(GitHubRestModel):
    """PullRequestReviewPropLinks"""

    html: PullRequestReviewPropLinksPropHtml = Field(default=...)
    pull_request: PullRequestReviewPropLinksPropPullRequest = Field(default=...)


class PullRequestReviewPropLinksPropHtml(GitHubRestModel):
    """PullRequestReviewPropLinksPropHtml"""

    href: str = Field(default=...)


class PullRequestReviewPropLinksPropPullRequest(GitHubRestModel):
    """PullRequestReviewPropLinksPropPullRequest"""

    href: str = Field(default=...)


class ReviewComment(GitHubRestModel):
    """Legacy Review Comment

    Legacy Review Comment
    """

    url: str = Field(default=...)
    pull_request_review_id: Union[int, None] = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    diff_hunk: str = Field(default=...)
    path: str = Field(default=...)
    position: Union[int, None] = Field(default=...)
    original_position: int = Field(default=...)
    commit_id: str = Field(default=...)
    original_commit_id: str = Field(default=...)
    in_reply_to_id: Union[Unset, int] = Field(default=UNSET)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    body: str = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    html_url: str = Field(default=...)
    pull_request_url: str = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )
    links: ReviewCommentPropLinks = Field(default=..., alias="_links")
    body_text: Union[Unset, str] = Field(default=UNSET)
    body_html: Union[Unset, str] = Field(default=UNSET)
    reactions: Union[Unset, ReactionRollup] = Field(
        title="Reaction Rollup", default=UNSET
    )
    side: Union[Unset, Literal["LEFT", "RIGHT"]] = Field(
        description="The side of the first line of the range for a multi-line comment.",
        default="RIGHT",
    )
    start_side: Union[Unset, Union[None, Literal["LEFT", "RIGHT"]]] = Field(
        description="The side of the first line of the range for a multi-line comment.",
        default="RIGHT",
    )
    line: Union[Unset, int] = Field(
        description="The line of the blob to which the comment applies. The last line of the range for a multi-line comment",
        default=UNSET,
    )
    original_line: Union[Unset, int] = Field(
        description="The original line of the blob to which the comment applies. The last line of the range for a multi-line comment",
        default=UNSET,
    )
    start_line: Union[Unset, Union[int, None]] = Field(
        description="The first line of the range for a multi-line comment.",
        default=UNSET,
    )
    original_start_line: Union[Unset, Union[int, None]] = Field(
        description="The original first line of the range for a multi-line comment.",
        default=UNSET,
    )


class ReviewCommentPropLinks(GitHubRestModel):
    """ReviewCommentPropLinks"""

    self_: Link = Field(
        title="Link", description="Hypermedia Link", default=..., alias="self"
    )
    html: Link = Field(title="Link", description="Hypermedia Link", default=...)
    pull_request: Link = Field(title="Link", description="Hypermedia Link", default=...)


class ReleaseAsset(GitHubRestModel):
    """Release Asset

    Data related to a release.
    """

    url: str = Field(default=...)
    browser_download_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The file name of the asset.", default=...)
    label: Union[str, None] = Field(default=...)
    state: Literal["uploaded", "open"] = Field(
        description="State of the release asset.", default=...
    )
    content_type: str = Field(default=...)
    size: int = Field(default=...)
    download_count: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    uploader: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )


class Release(GitHubRestModel):
    """Release

    A release.
    """

    url: str = Field(default=...)
    html_url: str = Field(default=...)
    assets_url: str = Field(default=...)
    upload_url: str = Field(default=...)
    tarball_url: Union[str, None] = Field(default=...)
    zipball_url: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    tag_name: str = Field(description="The name of the tag.", default=...)
    target_commitish: str = Field(
        description="Specifies the commitish value that determines where the Git tag is created from.",
        default=...,
    )
    name: Union[str, None] = Field(default=...)
    body: Union[Unset, Union[str, None]] = Field(default=UNSET)
    draft: bool = Field(
        description="true to create a draft (unpublished) release, false to create a published one.",
        default=...,
    )
    prerelease: bool = Field(
        description="Whether to identify the release as a prerelease or a full release.",
        default=...,
    )
    created_at: datetime = Field(default=...)
    published_at: Union[datetime, None] = Field(default=...)
    author: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )
    assets: List[ReleaseAsset] = Field(default=...)
    body_html: Union[Unset, Union[str, None]] = Field(default=UNSET)
    body_text: Union[Unset, Union[str, None]] = Field(default=UNSET)
    mentions_count: Union[Unset, int] = Field(default=UNSET)
    discussion_url: Union[Unset, str] = Field(
        description="The URL of the release discussion.", default=UNSET
    )
    reactions: Union[Unset, ReactionRollup] = Field(
        title="Reaction Rollup", default=UNSET
    )


class ReleaseNotesContent(GitHubRestModel):
    """Generated Release Notes Content

    Generated name and body describing a release
    """

    name: str = Field(description="The generated name of the release", default=...)
    body: str = Field(
        description="The generated body describing the contents of the release supporting markdown formatting",
        default=...,
    )


class SecretScanningAlert(GitHubRestModel):
    """SecretScanningAlert"""

    number: Union[Unset, int] = Field(
        description="The security alert number.", default=UNSET
    )
    created_at: Union[Unset, datetime] = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    updated_at: Union[Unset, datetime] = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    url: Union[Unset, str] = Field(
        description="The REST API URL of the alert resource.", default=UNSET
    )
    html_url: Union[Unset, str] = Field(
        description="The GitHub URL of the alert resource.", default=UNSET
    )
    locations_url: Union[Unset, str] = Field(
        description="The REST API URL of the code locations for this alert.",
        default=UNSET,
    )
    state: Union[Unset, Literal["open", "resolved"]] = Field(
        description="Sets the state of the secret scanning alert. You must provide `resolution` when you set the state to `resolved`.",
        default=UNSET,
    )
    resolution: Union[
        Unset,
        Union[None, Literal["false_positive", "wont_fix", "revoked", "used_in_tests"]],
    ] = Field(
        description="**Required when the `state` is `resolved`.** The reason for resolving the alert.",
        default=UNSET,
    )
    resolved_at: Union[Unset, Union[datetime, None]] = Field(
        description="The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    resolved_by: Union[Unset, Union[None, SimpleUser]] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    resolution_comment: Union[Unset, Union[str, None]] = Field(
        description="An optional comment to resolve an alert.", default=UNSET
    )
    secret_type: Union[Unset, str] = Field(
        description="The type of secret that secret scanning detected.", default=UNSET
    )
    secret_type_display_name: Union[Unset, str] = Field(
        description='User-friendly name for the detected secret, matching the `secret_type`.\nFor a list of built-in patterns, see "[Secret scanning patterns](https://docs.github.com/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)."',
        default=UNSET,
    )
    secret: Union[Unset, str] = Field(
        description="The secret that was detected.", default=UNSET
    )
    push_protection_bypassed: Union[Unset, Union[bool, None]] = Field(
        description="Whether push protection was bypassed for the detected secret.",
        default=UNSET,
    )
    push_protection_bypassed_by: Union[Unset, Union[None, SimpleUser]] = Field(
        title="Simple User", description="Simple User", default=UNSET
    )
    push_protection_bypassed_at: Union[Unset, Union[datetime, None]] = Field(
        description="The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )


class SecretScanningLocationCommit(GitHubRestModel):
    """SecretScanningLocationCommit

    Represents a 'commit' secret scanning location type. This location type shows
    that a secret was detected inside a commit to a repository.
    """

    path: str = Field(description="The file path in the repository", default=...)
    start_line: float = Field(
        description="Line number at which the secret starts in the file", default=...
    )
    end_line: float = Field(
        description="Line number at which the secret ends in the file", default=...
    )
    start_column: float = Field(
        description="The column at which the secret starts within the start line when the file is interpreted as 8BIT ASCII",
        default=...,
    )
    end_column: float = Field(
        description="The column at which the secret ends within the end line when the file is interpreted as 8BIT ASCII",
        default=...,
    )
    blob_sha: str = Field(
        description="SHA-1 hash ID of the associated blob", default=...
    )
    blob_url: str = Field(
        description="The API URL to get the associated blob resource", default=...
    )
    commit_sha: str = Field(
        description="SHA-1 hash ID of the associated commit", default=...
    )
    commit_url: str = Field(
        description="The API URL to get the associated commit resource", default=...
    )


class SecretScanningLocation(GitHubRestModel):
    """SecretScanningLocation"""

    type: Literal["commit"] = Field(
        description="The location type. Because secrets may be found in different types of resources (ie. code, comments, issues), this field identifies the type of resource where the secret was found.",
        default=...,
    )
    details: SecretScanningLocationCommit = Field(
        description="Represents a 'commit' secret scanning location type. This location type shows that a secret was detected inside a commit to a repository.",
        default=...,
    )


class Stargazer(GitHubRestModel):
    """Stargazer

    Stargazer
    """

    starred_at: datetime = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )


class CommitActivity(GitHubRestModel):
    """Commit Activity

    Commit Activity
    """

    days: List[int] = Field(default=...)
    total: int = Field(default=...)
    week: int = Field(default=...)


class ContributorActivity(GitHubRestModel):
    """Contributor Activity

    Contributor Activity
    """

    author: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    total: int = Field(default=...)
    weeks: List[ContributorActivityPropWeeksItems] = Field(default=...)


class ContributorActivityPropWeeksItems(GitHubRestModel):
    """ContributorActivityPropWeeksItems"""

    w: Union[Unset, int] = Field(default=UNSET)
    a: Union[Unset, int] = Field(default=UNSET)
    d: Union[Unset, int] = Field(default=UNSET)
    c: Union[Unset, int] = Field(default=UNSET)


class ParticipationStats(GitHubRestModel):
    """Participation Stats"""

    all_: List[int] = Field(default=..., alias="all")
    owner: List[int] = Field(default=...)


class RepositorySubscription(GitHubRestModel):
    """Repository Invitation

    Repository invitations let you manage who you collaborate with.
    """

    subscribed: bool = Field(
        description="Determines if notifications should be received from this repository.",
        default=...,
    )
    ignored: bool = Field(
        description="Determines if all notifications should be blocked from this repository.",
        default=...,
    )
    reason: Union[str, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    url: str = Field(default=...)
    repository_url: str = Field(default=...)


class Tag(GitHubRestModel):
    """Tag

    Tag
    """

    name: str = Field(default=...)
    commit: TagPropCommit = Field(default=...)
    zipball_url: str = Field(default=...)
    tarball_url: str = Field(default=...)
    node_id: str = Field(default=...)


class TagPropCommit(GitHubRestModel):
    """TagPropCommit"""

    sha: str = Field(default=...)
    url: str = Field(default=...)


class TagProtection(GitHubRestModel):
    """Tag protection

    Tag protection
    """

    id: Union[Unset, int] = Field(default=UNSET)
    created_at: Union[Unset, str] = Field(default=UNSET)
    updated_at: Union[Unset, str] = Field(default=UNSET)
    enabled: Union[Unset, bool] = Field(default=UNSET)
    pattern: str = Field(default=...)


class Topic(GitHubRestModel):
    """Topic

    A topic aggregates entities that are related to a subject.
    """

    names: List[str] = Field(default=...)


class Traffic(GitHubRestModel):
    """Traffic"""

    timestamp: datetime = Field(default=...)
    uniques: int = Field(default=...)
    count: int = Field(default=...)


class CloneTraffic(GitHubRestModel):
    """Clone Traffic

    Clone Traffic
    """

    count: int = Field(default=...)
    uniques: int = Field(default=...)
    clones: List[Traffic] = Field(default=...)


class ContentTraffic(GitHubRestModel):
    """Content Traffic

    Content Traffic
    """

    path: str = Field(default=...)
    title: str = Field(default=...)
    count: int = Field(default=...)
    uniques: int = Field(default=...)


class ReferrerTraffic(GitHubRestModel):
    """Referrer Traffic

    Referrer Traffic
    """

    referrer: str = Field(default=...)
    count: int = Field(default=...)
    uniques: int = Field(default=...)


class ViewTraffic(GitHubRestModel):
    """View Traffic

    View Traffic
    """

    count: int = Field(default=...)
    uniques: int = Field(default=...)
    views: List[Traffic] = Field(default=...)


class SearchResultTextMatchesItems(GitHubRestModel):
    """SearchResultTextMatchesItems"""

    object_url: Union[Unset, str] = Field(default=UNSET)
    object_type: Union[Unset, Union[str, None]] = Field(default=UNSET)
    property_: Union[Unset, str] = Field(default=UNSET, alias="property")
    fragment: Union[Unset, str] = Field(default=UNSET)
    matches: Union[Unset, List[SearchResultTextMatchesItemsPropMatchesItems]] = Field(
        default=UNSET
    )


class SearchResultTextMatchesItemsPropMatchesItems(GitHubRestModel):
    """SearchResultTextMatchesItemsPropMatchesItems"""

    text: Union[Unset, str] = Field(default=UNSET)
    indices: Union[Unset, List[int]] = Field(default=UNSET)


class CodeSearchResultItem(GitHubRestModel):
    """Code Search Result Item

    Code Search Result Item
    """

    name: str = Field(default=...)
    path: str = Field(default=...)
    sha: str = Field(default=...)
    url: str = Field(default=...)
    git_url: str = Field(default=...)
    html_url: str = Field(default=...)
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository", default=...
    )
    score: float = Field(default=...)
    file_size: Union[Unset, int] = Field(default=UNSET)
    language: Union[Unset, Union[str, None]] = Field(default=UNSET)
    last_modified_at: Union[Unset, datetime] = Field(default=UNSET)
    line_numbers: Union[Unset, List[str]] = Field(default=UNSET)
    text_matches: Union[Unset, List[SearchResultTextMatchesItems]] = Field(
        title="Search Result Text Matches", default=UNSET
    )


class CommitSearchResultItem(GitHubRestModel):
    """Commit Search Result Item

    Commit Search Result Item
    """

    url: str = Field(default=...)
    sha: str = Field(default=...)
    html_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    commit: CommitSearchResultItemPropCommit = Field(default=...)
    author: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    committer: Union[None, GitUser] = Field(
        title="Git User",
        description="Metaproperties for Git author/committer information.",
        default=...,
    )
    parents: List[CommitSearchResultItemPropParentsItems] = Field(default=...)
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository", default=...
    )
    score: float = Field(default=...)
    node_id: str = Field(default=...)
    text_matches: Union[Unset, List[SearchResultTextMatchesItems]] = Field(
        title="Search Result Text Matches", default=UNSET
    )


class CommitSearchResultItemPropCommit(GitHubRestModel):
    """CommitSearchResultItemPropCommit"""

    author: CommitSearchResultItemPropCommitPropAuthor = Field(default=...)
    committer: Union[None, GitUser] = Field(
        title="Git User",
        description="Metaproperties for Git author/committer information.",
        default=...,
    )
    comment_count: int = Field(default=...)
    message: str = Field(default=...)
    tree: CommitSearchResultItemPropCommitPropTree = Field(default=...)
    url: str = Field(default=...)
    verification: Union[Unset, Verification] = Field(
        title="Verification", default=UNSET
    )


class CommitSearchResultItemPropCommitPropAuthor(GitHubRestModel):
    """CommitSearchResultItemPropCommitPropAuthor"""

    name: str = Field(default=...)
    email: str = Field(default=...)
    date: datetime = Field(default=...)


class CommitSearchResultItemPropCommitPropTree(GitHubRestModel):
    """CommitSearchResultItemPropCommitPropTree"""

    sha: str = Field(default=...)
    url: str = Field(default=...)


class CommitSearchResultItemPropParentsItems(GitHubRestModel):
    """CommitSearchResultItemPropParentsItems"""

    url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    sha: Union[Unset, str] = Field(default=UNSET)


class IssueSearchResultItem(GitHubRestModel):
    """Issue Search Result Item

    Issue Search Result Item
    """

    url: str = Field(default=...)
    repository_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    title: str = Field(default=...)
    locked: bool = Field(default=...)
    active_lock_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    assignees: Union[Unset, Union[List[SimpleUser], None]] = Field(default=UNSET)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    labels: List[IssueSearchResultItemPropLabelsItems] = Field(default=...)
    state: str = Field(default=...)
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    assignee: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    milestone: Union[None, Milestone] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    comments: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    text_matches: Union[Unset, List[SearchResultTextMatchesItems]] = Field(
        title="Search Result Text Matches", default=UNSET
    )
    pull_request: Union[Unset, IssueSearchResultItemPropPullRequest] = Field(
        default=UNSET
    )
    body: Union[Unset, str] = Field(default=UNSET)
    score: float = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )
    draft: Union[Unset, bool] = Field(default=UNSET)
    repository: Union[Unset, Repository] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    body_html: Union[Unset, str] = Field(default=UNSET)
    body_text: Union[Unset, str] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    performed_via_github_app: Union[Unset, Union[None, Integration]] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    reactions: Union[Unset, ReactionRollup] = Field(
        title="Reaction Rollup", default=UNSET
    )


class IssueSearchResultItemPropLabelsItems(GitHubRestModel):
    """IssueSearchResultItemPropLabelsItems"""

    id: Union[Unset, int] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    name: Union[Unset, str] = Field(default=UNSET)
    color: Union[Unset, str] = Field(default=UNSET)
    default: Union[Unset, bool] = Field(default=UNSET)
    description: Union[Unset, Union[str, None]] = Field(default=UNSET)


class IssueSearchResultItemPropPullRequest(GitHubRestModel):
    """IssueSearchResultItemPropPullRequest"""

    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    diff_url: Union[str, None] = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    patch_url: Union[str, None] = Field(default=...)
    url: Union[str, None] = Field(default=...)


class LabelSearchResultItem(GitHubRestModel):
    """Label Search Result Item

    Label Search Result Item
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    name: str = Field(default=...)
    color: str = Field(default=...)
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    score: float = Field(default=...)
    text_matches: Union[Unset, List[SearchResultTextMatchesItems]] = Field(
        title="Search Result Text Matches", default=UNSET
    )


class RepoSearchResultItem(GitHubRestModel):
    """Repo Search Result Item

    Repo Search Result Item
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(default=...)
    full_name: str = Field(default=...)
    owner: Union[None, SimpleUser] = Field(
        title="Simple User", description="Simple User", default=...
    )
    private: bool = Field(default=...)
    html_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    fork: bool = Field(default=...)
    url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    pushed_at: datetime = Field(default=...)
    homepage: Union[str, None] = Field(default=...)
    size: int = Field(default=...)
    stargazers_count: int = Field(default=...)
    watchers_count: int = Field(default=...)
    language: Union[str, None] = Field(default=...)
    forks_count: int = Field(default=...)
    open_issues_count: int = Field(default=...)
    master_branch: Union[Unset, str] = Field(default=UNSET)
    default_branch: str = Field(default=...)
    score: float = Field(default=...)
    forks_url: str = Field(default=...)
    keys_url: str = Field(default=...)
    collaborators_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    hooks_url: str = Field(default=...)
    issue_events_url: str = Field(default=...)
    events_url: str = Field(default=...)
    assignees_url: str = Field(default=...)
    branches_url: str = Field(default=...)
    tags_url: str = Field(default=...)
    blobs_url: str = Field(default=...)
    git_tags_url: str = Field(default=...)
    git_refs_url: str = Field(default=...)
    trees_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    languages_url: str = Field(default=...)
    stargazers_url: str = Field(default=...)
    contributors_url: str = Field(default=...)
    subscribers_url: str = Field(default=...)
    subscription_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    git_commits_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    issue_comment_url: str = Field(default=...)
    contents_url: str = Field(default=...)
    compare_url: str = Field(default=...)
    merges_url: str = Field(default=...)
    archive_url: str = Field(default=...)
    downloads_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    pulls_url: str = Field(default=...)
    milestones_url: str = Field(default=...)
    notifications_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    releases_url: str = Field(default=...)
    deployments_url: str = Field(default=...)
    git_url: str = Field(default=...)
    ssh_url: str = Field(default=...)
    clone_url: str = Field(default=...)
    svn_url: str = Field(default=...)
    forks: int = Field(default=...)
    open_issues: int = Field(default=...)
    watchers: int = Field(default=...)
    topics: Union[Unset, List[str]] = Field(default=UNSET)
    mirror_url: Union[str, None] = Field(default=...)
    has_issues: bool = Field(default=...)
    has_projects: bool = Field(default=...)
    has_pages: bool = Field(default=...)
    has_wiki: bool = Field(default=...)
    has_downloads: bool = Field(default=...)
    archived: bool = Field(default=...)
    disabled: bool = Field(
        description="Returns whether or not this repository disabled.", default=...
    )
    visibility: Union[Unset, str] = Field(
        description="The repository visibility: public, private, or internal.",
        default=UNSET,
    )
    license_: Union[None, LicenseSimple] = Field(
        title="License Simple",
        description="License Simple",
        default=...,
        alias="license",
    )
    permissions: Union[Unset, RepoSearchResultItemPropPermissions] = Field(
        default=UNSET
    )
    text_matches: Union[Unset, List[SearchResultTextMatchesItems]] = Field(
        title="Search Result Text Matches", default=UNSET
    )
    temp_clone_token: Union[Unset, str] = Field(default=UNSET)
    allow_merge_commit: Union[Unset, bool] = Field(default=UNSET)
    allow_squash_merge: Union[Unset, bool] = Field(default=UNSET)
    allow_rebase_merge: Union[Unset, bool] = Field(default=UNSET)
    allow_auto_merge: Union[Unset, bool] = Field(default=UNSET)
    delete_branch_on_merge: Union[Unset, bool] = Field(default=UNSET)
    allow_forking: Union[Unset, bool] = Field(default=UNSET)
    is_template: Union[Unset, bool] = Field(default=UNSET)
    web_commit_signoff_required: Union[Unset, bool] = Field(default=UNSET)


class RepoSearchResultItemPropPermissions(GitHubRestModel):
    """RepoSearchResultItemPropPermissions"""

    admin: bool = Field(default=...)
    maintain: Union[Unset, bool] = Field(default=UNSET)
    push: bool = Field(default=...)
    triage: Union[Unset, bool] = Field(default=UNSET)
    pull: bool = Field(default=...)


class TopicSearchResultItem(GitHubRestModel):
    """Topic Search Result Item

    Topic Search Result Item
    """

    name: str = Field(default=...)
    display_name: Union[str, None] = Field(default=...)
    short_description: Union[str, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    created_by: Union[str, None] = Field(default=...)
    released: Union[str, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    featured: bool = Field(default=...)
    curated: bool = Field(default=...)
    score: float = Field(default=...)
    repository_count: Union[Unset, Union[int, None]] = Field(default=UNSET)
    logo_url: Union[Unset, Union[str, None]] = Field(default=UNSET)
    text_matches: Union[Unset, List[SearchResultTextMatchesItems]] = Field(
        title="Search Result Text Matches", default=UNSET
    )
    related: Union[
        Unset, Union[List[TopicSearchResultItemPropRelatedItems], None]
    ] = Field(default=UNSET)
    aliases: Union[
        Unset, Union[List[TopicSearchResultItemPropAliasesItems], None]
    ] = Field(default=UNSET)


class TopicSearchResultItemPropRelatedItems(GitHubRestModel):
    """TopicSearchResultItemPropRelatedItems"""

    topic_relation: Union[
        Unset, TopicSearchResultItemPropRelatedItemsPropTopicRelation
    ] = Field(default=UNSET)


class TopicSearchResultItemPropRelatedItemsPropTopicRelation(GitHubRestModel):
    """TopicSearchResultItemPropRelatedItemsPropTopicRelation"""

    id: Union[Unset, int] = Field(default=UNSET)
    name: Union[Unset, str] = Field(default=UNSET)
    topic_id: Union[Unset, int] = Field(default=UNSET)
    relation_type: Union[Unset, str] = Field(default=UNSET)


class TopicSearchResultItemPropAliasesItems(GitHubRestModel):
    """TopicSearchResultItemPropAliasesItems"""

    topic_relation: Union[
        Unset, TopicSearchResultItemPropAliasesItemsPropTopicRelation
    ] = Field(default=UNSET)


class TopicSearchResultItemPropAliasesItemsPropTopicRelation(GitHubRestModel):
    """TopicSearchResultItemPropAliasesItemsPropTopicRelation"""

    id: Union[Unset, int] = Field(default=UNSET)
    name: Union[Unset, str] = Field(default=UNSET)
    topic_id: Union[Unset, int] = Field(default=UNSET)
    relation_type: Union[Unset, str] = Field(default=UNSET)


class UserSearchResultItem(GitHubRestModel):
    """User Search Result Item

    User Search Result Item
    """

    login: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    avatar_url: str = Field(default=...)
    gravatar_id: Union[str, None] = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    organizations_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    type: str = Field(default=...)
    score: float = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    starred_url: str = Field(default=...)
    events_url: str = Field(default=...)
    public_repos: Union[Unset, int] = Field(default=UNSET)
    public_gists: Union[Unset, int] = Field(default=UNSET)
    followers: Union[Unset, int] = Field(default=UNSET)
    following: Union[Unset, int] = Field(default=UNSET)
    created_at: Union[Unset, datetime] = Field(default=UNSET)
    updated_at: Union[Unset, datetime] = Field(default=UNSET)
    name: Union[Unset, Union[str, None]] = Field(default=UNSET)
    bio: Union[Unset, Union[str, None]] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    location: Union[Unset, Union[str, None]] = Field(default=UNSET)
    site_admin: bool = Field(default=...)
    hireable: Union[Unset, Union[bool, None]] = Field(default=UNSET)
    text_matches: Union[Unset, List[SearchResultTextMatchesItems]] = Field(
        title="Search Result Text Matches", default=UNSET
    )
    blog: Union[Unset, Union[str, None]] = Field(default=UNSET)
    company: Union[Unset, Union[str, None]] = Field(default=UNSET)
    suspended_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)


class PrivateUser(GitHubRestModel):
    """Private User

    Private User
    """

    login: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    avatar_url: str = Field(default=...)
    gravatar_id: Union[str, None] = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    organizations_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    type: str = Field(default=...)
    site_admin: bool = Field(default=...)
    name: Union[str, None] = Field(default=...)
    company: Union[str, None] = Field(default=...)
    blog: Union[str, None] = Field(default=...)
    location: Union[str, None] = Field(default=...)
    email: Union[str, None] = Field(default=...)
    hireable: Union[bool, None] = Field(default=...)
    bio: Union[str, None] = Field(default=...)
    twitter_username: Union[Unset, Union[str, None]] = Field(default=UNSET)
    public_repos: int = Field(default=...)
    public_gists: int = Field(default=...)
    followers: int = Field(default=...)
    following: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    private_gists: int = Field(default=...)
    total_private_repos: int = Field(default=...)
    owned_private_repos: int = Field(default=...)
    disk_usage: int = Field(default=...)
    collaborators: int = Field(default=...)
    two_factor_authentication: bool = Field(default=...)
    plan: Union[Unset, PrivateUserPropPlan] = Field(default=UNSET)
    suspended_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    business_plus: Union[Unset, bool] = Field(default=UNSET)
    ldap_dn: Union[Unset, str] = Field(default=UNSET)


class PrivateUserPropPlan(GitHubRestModel):
    """PrivateUserPropPlan"""

    collaborators: int = Field(default=...)
    name: str = Field(default=...)
    space: int = Field(default=...)
    private_repos: int = Field(default=...)


class CodespacesSecret(GitHubRestModel):
    """Codespaces Secret

    Secrets for a GitHub Codespace.
    """

    name: str = Field(description="The name of the secret", default=...)
    created_at: datetime = Field(
        description="The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The date and time at which the secret was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
        default=...,
    )
    visibility: Literal["all", "private", "selected"] = Field(
        description="The type of repositories in the organization that the secret is visible to",
        default=...,
    )
    selected_repositories_url: str = Field(
        description="The API URL at which the list of repositories this secret is visible to can be retrieved",
        default=...,
    )


class CodespacesUserPublicKey(GitHubRestModel):
    """CodespacesUserPublicKey

    The public key used for setting user Codespaces' Secrets.
    """

    key_id: str = Field(description="The identifier for the key.", default=...)
    key: str = Field(description="The Base64 encoded public key.", default=...)


class CodespaceExportDetails(GitHubRestModel):
    """Fetches information about an export of a codespace.

    An export of a codespace. Also, latest export details for a codespace can be
    fetched with id = latest
    """

    state: Union[Unset, Union[str, None]] = Field(
        description="State of the latest export", default=UNSET
    )
    completed_at: Union[Unset, Union[datetime, None]] = Field(
        description="Completion time of the last export operation", default=UNSET
    )
    branch: Union[Unset, Union[str, None]] = Field(
        description="Name of the exported branch", default=UNSET
    )
    sha: Union[Unset, Union[str, None]] = Field(
        description="Git commit SHA of the exported branch", default=UNSET
    )
    id: Union[Unset, str] = Field(
        description="Id for the export details", default=UNSET
    )
    export_url: Union[Unset, str] = Field(
        description="Url for fetching export details", default=UNSET
    )
    html_url: Union[Unset, Union[str, None]] = Field(
        description="Web url for the exported branch", default=UNSET
    )


class Email(GitHubRestModel):
    """Email

    Email
    """

    email: str = Field(default=...)
    primary: bool = Field(default=...)
    verified: bool = Field(default=...)
    visibility: Union[str, None] = Field(default=...)


class GpgKey(GitHubRestModel):
    """GPG Key

    A unique encryption key
    """

    id: int = Field(default=...)
    name: Union[Unset, Union[str, None]] = Field(default=UNSET)
    primary_key_id: Union[int, None] = Field(default=...)
    key_id: str = Field(default=...)
    public_key: str = Field(default=...)
    emails: List[GpgKeyPropEmailsItems] = Field(default=...)
    subkeys: List[GpgKeyPropSubkeysItems] = Field(default=...)
    can_sign: bool = Field(default=...)
    can_encrypt_comms: bool = Field(default=...)
    can_encrypt_storage: bool = Field(default=...)
    can_certify: bool = Field(default=...)
    created_at: datetime = Field(default=...)
    expires_at: Union[datetime, None] = Field(default=...)
    revoked: bool = Field(default=...)
    raw_key: Union[str, None] = Field(default=...)


class GpgKeyPropEmailsItems(GitHubRestModel):
    """GpgKeyPropEmailsItems"""

    email: Union[Unset, str] = Field(default=UNSET)
    verified: Union[Unset, bool] = Field(default=UNSET)


class GpgKeyPropSubkeysItems(GitHubRestModel):
    """GpgKeyPropSubkeysItems"""

    id: Union[Unset, int] = Field(default=UNSET)
    primary_key_id: Union[Unset, int] = Field(default=UNSET)
    key_id: Union[Unset, str] = Field(default=UNSET)
    public_key: Union[Unset, str] = Field(default=UNSET)
    emails: Union[Unset, List[Any]] = Field(default=UNSET)
    subkeys: Union[Unset, List[Any]] = Field(default=UNSET)
    can_sign: Union[Unset, bool] = Field(default=UNSET)
    can_encrypt_comms: Union[Unset, bool] = Field(default=UNSET)
    can_encrypt_storage: Union[Unset, bool] = Field(default=UNSET)
    can_certify: Union[Unset, bool] = Field(default=UNSET)
    created_at: Union[Unset, str] = Field(default=UNSET)
    expires_at: Union[Unset, Union[str, None]] = Field(default=UNSET)
    raw_key: Union[Unset, Union[str, None]] = Field(default=UNSET)
    revoked: Union[Unset, bool] = Field(default=UNSET)


class Key(GitHubRestModel):
    """Key

    Key
    """

    key: str = Field(default=...)
    id: int = Field(default=...)
    url: str = Field(default=...)
    title: str = Field(default=...)
    created_at: datetime = Field(default=...)
    verified: bool = Field(default=...)
    read_only: bool = Field(default=...)


class MarketplaceAccount(GitHubRestModel):
    """Marketplace Account"""

    url: str = Field(default=...)
    id: int = Field(default=...)
    type: str = Field(default=...)
    node_id: Union[Unset, str] = Field(default=UNSET)
    login: str = Field(default=...)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    organization_billing_email: Union[Unset, Union[str, None]] = Field(default=UNSET)


class UserMarketplacePurchase(GitHubRestModel):
    """User Marketplace Purchase

    User Marketplace Purchase
    """

    billing_cycle: str = Field(default=...)
    next_billing_date: Union[datetime, None] = Field(default=...)
    unit_count: Union[int, None] = Field(default=...)
    on_free_trial: bool = Field(default=...)
    free_trial_ends_on: Union[datetime, None] = Field(default=...)
    updated_at: Union[datetime, None] = Field(default=...)
    account: MarketplaceAccount = Field(title="Marketplace Account", default=...)
    plan: MarketplaceListingPlan = Field(
        title="Marketplace Listing Plan",
        description="Marketplace Listing Plan",
        default=...,
    )


class SshSigningKey(GitHubRestModel):
    """SSH Signing Key

    A public SSH key used to sign Git commits
    """

    key: str = Field(default=...)
    id: int = Field(default=...)
    title: str = Field(default=...)
    created_at: datetime = Field(default=...)


class StarredRepository(GitHubRestModel):
    """Starred Repository

    Starred Repository
    """

    starred_at: datetime = Field(default=...)
    repo: Repository = Field(
        title="Repository", description="A git repository", default=...
    )


class Hovercard(GitHubRestModel):
    """Hovercard

    Hovercard
    """

    contexts: List[HovercardPropContextsItems] = Field(default=...)


class HovercardPropContextsItems(GitHubRestModel):
    """HovercardPropContextsItems"""

    message: str = Field(default=...)
    octicon: str = Field(default=...)


class KeySimple(GitHubRestModel):
    """Key Simple

    Key Simple
    """

    id: int = Field(default=...)
    key: str = Field(default=...)


class SimpleInstallation(GitHubRestModel):
    """Simple Installation

    Simple Installation
    """

    id: int = Field(description="The ID of the installation.", default=...)
    node_id: str = Field(
        description="The global node ID of the installation.", default=...
    )


class WebhookBranchProtectionRuleCreated(GitHubRestModel):
    """branch protection rule created event"""

    action: Literal["created"] = Field(default=...)
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    rule: WebhookBranchProtectionRuleCreatedPropRule = Field(
        title="branch protection rule",
        description="The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/en/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.",
        default=...,
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookBranchProtectionRuleCreatedPropRule(GitHubRestModel):
    """branch protection rule

    The branch protection rule. Includes a `name` and all the [branch protection
    settings](https://docs.github.com/en/github/administering-a-repository/defining-
    the-mergeability-of-pull-requests/about-protected-branches#about-branch-
    protection-settings) applied to branches that match the name. Binary settings
    are boolean. Multi-level configurations are one of `off`, `non_admins`, or
    `everyone`. Actor and build lists are arrays of strings.
    """

    admin_enforced: bool = Field(default=...)
    allow_deletions_enforcement_level: Literal["off", "non_admins", "everyone"] = Field(
        default=...
    )
    allow_force_pushes_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    authorized_actor_names: List[str] = Field(default=...)
    authorized_actors_only: bool = Field(default=...)
    authorized_dismissal_actors_only: bool = Field(default=...)
    create_protected: Union[Unset, bool] = Field(default=UNSET)
    created_at: datetime = Field(default=...)
    dismiss_stale_reviews_on_push: bool = Field(default=...)
    id: int = Field(default=...)
    ignore_approvals_from_contributors: bool = Field(default=...)
    linear_history_requirement_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    merge_queue_enforcement_level: Literal["off", "non_admins", "everyone"] = Field(
        default=...
    )
    name: str = Field(default=...)
    pull_request_reviews_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    repository_id: int = Field(default=...)
    require_code_owner_review: bool = Field(default=...)
    required_approving_review_count: int = Field(default=...)
    required_conversation_resolution_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    required_deployments_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    required_status_checks: List[str] = Field(default=...)
    required_status_checks_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    signature_requirement_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    strict_required_status_checks_policy: bool = Field(default=...)
    updated_at: datetime = Field(default=...)


class WebhookBranchProtectionRuleDeleted(GitHubRestModel):
    """branch protection rule deleted event"""

    action: Literal["deleted"] = Field(default=...)
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    rule: WebhookBranchProtectionRuleDeletedPropRule = Field(
        title="branch protection rule",
        description="The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/en/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.",
        default=...,
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookBranchProtectionRuleDeletedPropRule(GitHubRestModel):
    """branch protection rule

    The branch protection rule. Includes a `name` and all the [branch protection
    settings](https://docs.github.com/en/github/administering-a-repository/defining-
    the-mergeability-of-pull-requests/about-protected-branches#about-branch-
    protection-settings) applied to branches that match the name. Binary settings
    are boolean. Multi-level configurations are one of `off`, `non_admins`, or
    `everyone`. Actor and build lists are arrays of strings.
    """

    admin_enforced: bool = Field(default=...)
    allow_deletions_enforcement_level: Literal["off", "non_admins", "everyone"] = Field(
        default=...
    )
    allow_force_pushes_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    authorized_actor_names: List[str] = Field(default=...)
    authorized_actors_only: bool = Field(default=...)
    authorized_dismissal_actors_only: bool = Field(default=...)
    create_protected: Union[Unset, bool] = Field(default=UNSET)
    created_at: datetime = Field(default=...)
    dismiss_stale_reviews_on_push: bool = Field(default=...)
    id: int = Field(default=...)
    ignore_approvals_from_contributors: bool = Field(default=...)
    linear_history_requirement_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    merge_queue_enforcement_level: Literal["off", "non_admins", "everyone"] = Field(
        default=...
    )
    name: str = Field(default=...)
    pull_request_reviews_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    repository_id: int = Field(default=...)
    require_code_owner_review: bool = Field(default=...)
    required_approving_review_count: int = Field(default=...)
    required_conversation_resolution_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    required_deployments_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    required_status_checks: List[str] = Field(default=...)
    required_status_checks_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    signature_requirement_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    strict_required_status_checks_policy: bool = Field(default=...)
    updated_at: datetime = Field(default=...)


class WebhookBranchProtectionRuleEdited(GitHubRestModel):
    """branch protection rule edited event"""

    action: Literal["edited"] = Field(default=...)
    changes: Union[Unset, WebhookBranchProtectionRuleEditedPropChanges] = Field(
        description="If the action was `edited`, the changes to the rule.",
        default=UNSET,
    )
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    rule: WebhookBranchProtectionRuleEditedPropRule = Field(
        title="branch protection rule",
        description="The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/en/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.",
        default=...,
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookBranchProtectionRuleEditedPropChanges(GitHubRestModel):
    """WebhookBranchProtectionRuleEditedPropChanges

    If the action was `edited`, the changes to the rule.
    """

    admin_enforced: Union[
        Unset, WebhookBranchProtectionRuleEditedPropChangesPropAdminEnforced
    ] = Field(default=UNSET)
    authorized_actor_names: Union[
        Unset, WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedActorNames
    ] = Field(default=UNSET)
    authorized_actors_only: Union[
        Unset, WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedActorsOnly
    ] = Field(default=UNSET)
    authorized_dismissal_actors_only: Union[
        Unset,
        WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedDismissalActorsOnly,
    ] = Field(default=UNSET)
    linear_history_requirement_enforcement_level: Union[
        Unset,
        WebhookBranchProtectionRuleEditedPropChangesPropLinearHistoryRequirementEnforcementLevel,
    ] = Field(default=UNSET)
    required_status_checks: Union[
        Unset, WebhookBranchProtectionRuleEditedPropChangesPropRequiredStatusChecks
    ] = Field(default=UNSET)
    required_status_checks_enforcement_level: Union[
        Unset,
        WebhookBranchProtectionRuleEditedPropChangesPropRequiredStatusChecksEnforcementLevel,
    ] = Field(default=UNSET)


class WebhookBranchProtectionRuleEditedPropChangesPropAdminEnforced(GitHubRestModel):
    """WebhookBranchProtectionRuleEditedPropChangesPropAdminEnforced"""

    from_: Union[bool, None] = Field(default=..., alias="from")


class WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedActorNames(
    GitHubRestModel
):
    """WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedActorNames"""

    from_: List[str] = Field(default=..., alias="from")


class WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedActorsOnly(
    GitHubRestModel
):
    """WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedActorsOnly"""

    from_: Union[bool, None] = Field(default=..., alias="from")


class WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedDismissalActorsOnly(
    GitHubRestModel
):
    """WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedDismissalActorsOnly"""

    from_: Union[bool, None] = Field(default=..., alias="from")


class WebhookBranchProtectionRuleEditedPropChangesPropLinearHistoryRequirementEnforcementLevel(
    GitHubRestModel
):
    """WebhookBranchProtectionRuleEditedPropChangesPropLinearHistoryRequirementEnforcem
    entLevel
    """

    from_: Literal["off", "non_admins", "everyone"] = Field(default=..., alias="from")


class WebhookBranchProtectionRuleEditedPropChangesPropRequiredStatusChecks(
    GitHubRestModel
):
    """WebhookBranchProtectionRuleEditedPropChangesPropRequiredStatusChecks"""

    from_: List[str] = Field(default=..., alias="from")


class WebhookBranchProtectionRuleEditedPropChangesPropRequiredStatusChecksEnforcementLevel(
    GitHubRestModel
):
    """WebhookBranchProtectionRuleEditedPropChangesPropRequiredStatusChecksEnforcementL
    evel
    """

    from_: Literal["off", "non_admins", "everyone"] = Field(default=..., alias="from")


class WebhookBranchProtectionRuleEditedPropRule(GitHubRestModel):
    """branch protection rule

    The branch protection rule. Includes a `name` and all the [branch protection
    settings](https://docs.github.com/en/github/administering-a-repository/defining-
    the-mergeability-of-pull-requests/about-protected-branches#about-branch-
    protection-settings) applied to branches that match the name. Binary settings
    are boolean. Multi-level configurations are one of `off`, `non_admins`, or
    `everyone`. Actor and build lists are arrays of strings.
    """

    admin_enforced: bool = Field(default=...)
    allow_deletions_enforcement_level: Literal["off", "non_admins", "everyone"] = Field(
        default=...
    )
    allow_force_pushes_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    authorized_actor_names: List[str] = Field(default=...)
    authorized_actors_only: bool = Field(default=...)
    authorized_dismissal_actors_only: bool = Field(default=...)
    create_protected: Union[Unset, bool] = Field(default=UNSET)
    created_at: datetime = Field(default=...)
    dismiss_stale_reviews_on_push: bool = Field(default=...)
    id: int = Field(default=...)
    ignore_approvals_from_contributors: bool = Field(default=...)
    linear_history_requirement_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    merge_queue_enforcement_level: Literal["off", "non_admins", "everyone"] = Field(
        default=...
    )
    name: str = Field(default=...)
    pull_request_reviews_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    repository_id: int = Field(default=...)
    require_code_owner_review: bool = Field(default=...)
    required_approving_review_count: int = Field(default=...)
    required_conversation_resolution_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    required_deployments_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    required_status_checks: List[str] = Field(default=...)
    required_status_checks_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    signature_requirement_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(default=...)
    strict_required_status_checks_policy: bool = Field(default=...)
    updated_at: datetime = Field(default=...)


class WebhookDependabotAlertCreated(GitHubRestModel):
    """Dependabot alert created event"""

    action: Literal["created"] = Field(default=...)
    alert: DependabotAlert = Field(description="A Dependabot alert.", default=...)
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookDependabotAlertDismissed(GitHubRestModel):
    """Dependabot alert dismissed event"""

    action: Literal["dismissed"] = Field(default=...)
    alert: DependabotAlert = Field(description="A Dependabot alert.", default=...)
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookDependabotAlertFixed(GitHubRestModel):
    """Dependabot alert fixed event"""

    action: Literal["fixed"] = Field(default=...)
    alert: DependabotAlert = Field(description="A Dependabot alert.", default=...)
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookDependabotAlertReintroduced(GitHubRestModel):
    """Dependabot alert reintroduced event"""

    action: Literal["reintroduced"] = Field(default=...)
    alert: DependabotAlert = Field(description="A Dependabot alert.", default=...)
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookDependabotAlertReopened(GitHubRestModel):
    """Dependabot alert reopened event"""

    action: Literal["reopened"] = Field(default=...)
    alert: DependabotAlert = Field(description="A Dependabot alert.", default=...)
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookGollum(GitHubRestModel):
    """gollum event

    A wiki page is created or updated.
    """

    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    pages: List[WebhookGollumPropPagesItems] = Field(
        description="The pages that were updated.", default=...
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookGollumPropPagesItems(GitHubRestModel):
    """WebhookGollumPropPagesItems"""

    action: Literal["created", "edited"] = Field(
        description="The action that was performed on the page. Can be `created` or `edited`.",
        default=...,
    )
    html_url: str = Field(description="Points to the HTML wiki page.", default=...)
    page_name: str = Field(description="The name of the page.", default=...)
    sha: str = Field(description="The latest commit SHA of the page.", default=...)
    summary: Union[str, None] = Field(default=...)
    title: str = Field(description="The current page title.", default=...)


class WebhookIssueCommentCreated(GitHubRestModel):
    """issue_comment created event"""

    action: Literal["created"] = Field(default=...)
    comment: WebhookIssueCommentCreatedPropComment = Field(
        title="issue comment",
        description="The [comment](https://docs.github.com/en/rest/reference/issues#comments) itself.",
        default=...,
    )
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    issue: WebhookIssueCommentCreatedPropIssue = Field(
        description="The [issue](https://docs.github.com/en/rest/reference/issues) the comment belongs to.",
        default=...,
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookIssueCommentCreatedPropComment(GitHubRestModel):
    """issue comment

    The [comment](https://docs.github.com/en/rest/reference/issues#comments) itself.
    """

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: str = Field(description="Contents of the issue comment", default=...)
    created_at: datetime = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(description="Unique identifier of the issue comment", default=...)
    issue_url: str = Field(default=...)
    node_id: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    reactions: WebhookIssueCommentCreatedPropCommentPropReactions = Field(
        title="Reactions", default=...
    )
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue comment", default=...)
    user: Union[WebhookIssueCommentCreatedPropCommentPropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssueCommentCreatedPropCommentPropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssueCommentCreatedPropCommentPropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssue(GitHubRestModel):
    """WebhookIssueCommentCreatedPropIssue

    The [issue](https://docs.github.com/en/rest/reference/issues) the comment
    belongs to.
    """

    active_lock_reason: Union[
        Literal["resolved", "off-topic", "too heated", "spam"], None
    ] = Field(default=...)
    assignee: Union[
        Union[WebhookIssueCommentCreatedPropIssueAllof0PropAssignee, None], None
    ] = Field(title="User", default=...)
    assignees: List[WebhookIssueCommentCreatedPropIssueMergedAssignees] = Field(
        default=...
    )
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[Union[str, None], None] = Field(
        description="Contents of the issue", default=...
    )
    closed_at: Union[Union[datetime, None], None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: List[WebhookIssueCommentCreatedPropIssueAllof0PropLabelsItems] = Field(
        default=...
    )
    labels_url: str = Field(default=...)
    locked: bool = Field(default=...)
    milestone: Union[WebhookIssueCommentCreatedPropIssueMergedMilestone, None] = Field(
        default=...
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset,
        Union[WebhookIssueCommentCreatedPropIssueMergedPerformedViaGithubApp, None],
    ] = Field(default=UNSET)
    pull_request: Union[
        Unset, WebhookIssueCommentCreatedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssueCommentCreatedPropIssueMergedReactions = Field(default=...)
    repository_url: str = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'", default=...
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: WebhookIssueCommentCreatedPropIssueMergedUser = Field(default=...)


class WebhookIssueCommentCreatedPropIssueAllof0(GitHubRestModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssueCommentCreatedPropIssueAllof0PropAssignee, None]
    ] = Field(title="User", default=UNSET)
    assignees: List[
        Union[WebhookIssueCommentCreatedPropIssueAllof0PropAssigneesItems, None]
    ] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[
        Unset, List[WebhookIssueCommentCreatedPropIssueAllof0PropLabelsItems]
    ] = Field(default=UNSET)
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[
        WebhookIssueCommentCreatedPropIssueAllof0PropMilestone, None
    ] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset,
        Union[WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubApp, None],
    ] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[
        Unset, WebhookIssueCommentCreatedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssueCommentCreatedPropIssueAllof0PropReactions = Field(
        title="Reactions", default=...
    )
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: Union[WebhookIssueCommentCreatedPropIssueAllof0PropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssueCommentCreatedPropIssueAllof0PropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueAllof0PropAssigneesItems(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueAllof0PropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssueCommentCreatedPropIssueAllof0PropMilestonePropCreator(
    GitHubRestModel
):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueAllof0PropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssueCommentCreatedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropOwner(
    GitHubRestModel
):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropPermissions(
    GitHubRestModel
):
    """WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropPermission
    s

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubApp(
    GitHubRestModel
):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "pull_request_review_thread",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropOwner,
        None,
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset,
        WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropPermissions,
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssueCommentCreatedPropIssueAllof0PropPullRequest(GitHubRestModel):
    """WebhookIssueCommentCreatedPropIssueAllof0PropPullRequest"""

    diff_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    patch_url: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueAllof0PropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssueCommentCreatedPropIssueAllof0PropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueAllof1(GitHubRestModel):
    """WebhookIssueCommentCreatedPropIssueAllof1"""

    active_lock_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    assignee: Union[
        WebhookIssueCommentCreatedPropIssueAllof1PropAssignee, None
    ] = Field(title="User", default=...)
    assignees: Union[
        Unset,
        List[Union[WebhookIssueCommentCreatedPropIssueAllof1PropAssigneesItems, None]],
    ] = Field(default=UNSET)
    author_association: Union[Unset, str] = Field(default=UNSET)
    body: Union[Unset, Union[str, None]] = Field(default=UNSET)
    closed_at: Union[Unset, Union[str, None]] = Field(default=UNSET)
    comments: Union[Unset, int] = Field(default=UNSET)
    comments_url: Union[Unset, str] = Field(default=UNSET)
    created_at: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    labels: List[WebhookIssueCommentCreatedPropIssueAllof1PropLabelsItems] = Field(
        default=...
    )
    labels_url: Union[Unset, str] = Field(default=UNSET)
    locked: bool = Field(default=...)
    milestone: Union[
        Unset, Union[WebhookIssueCommentCreatedPropIssueAllof1PropMilestone, None]
    ] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    number: Union[Unset, int] = Field(default=UNSET)
    performed_via_github_app: Union[
        Unset,
        Union[WebhookIssueCommentCreatedPropIssueAllof1PropPerformedViaGithubApp, None],
    ] = Field(default=UNSET)
    reactions: Union[
        Unset, WebhookIssueCommentCreatedPropIssueAllof1PropReactions
    ] = Field(default=UNSET)
    repository_url: Union[Unset, str] = Field(default=UNSET)
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'", default=...
    )
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: Union[Unset, str] = Field(default=UNSET)
    updated_at: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    user: Union[Unset, WebhookIssueCommentCreatedPropIssueAllof1PropUser] = Field(
        default=UNSET
    )


class WebhookIssueCommentCreatedPropIssueAllof1PropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueAllof1PropAssigneesItems(GitHubRestModel):
    """WebhookIssueCommentCreatedPropIssueAllof1PropAssigneesItems"""


class WebhookIssueCommentCreatedPropIssueAllof1PropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssueCommentCreatedPropIssueAllof1PropMilestone(GitHubRestModel):
    """WebhookIssueCommentCreatedPropIssueAllof1PropMilestone"""


class WebhookIssueCommentCreatedPropIssueAllof1PropPerformedViaGithubApp(
    GitHubRestModel
):
    """WebhookIssueCommentCreatedPropIssueAllof1PropPerformedViaGithubApp"""


class WebhookIssueCommentCreatedPropIssueAllof1PropReactions(GitHubRestModel):
    """WebhookIssueCommentCreatedPropIssueAllof1PropReactions"""

    plus_one: Union[Unset, int] = Field(default=UNSET, alias="+1")
    minus_one: Union[Unset, int] = Field(default=UNSET, alias="-1")
    confused: Union[Unset, int] = Field(default=UNSET)
    eyes: Union[Unset, int] = Field(default=UNSET)
    heart: Union[Unset, int] = Field(default=UNSET)
    hooray: Union[Unset, int] = Field(default=UNSET)
    laugh: Union[Unset, int] = Field(default=UNSET)
    rocket: Union[Unset, int] = Field(default=UNSET)
    total_count: Union[Unset, int] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueAllof1PropUser(GitHubRestModel):
    """WebhookIssueCommentCreatedPropIssueAllof1PropUser"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    login: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueMergedAssignees(GitHubRestModel):
    """WebhookIssueCommentCreatedPropIssueMergedAssignees"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueMergedMilestone(GitHubRestModel):
    """WebhookIssueCommentCreatedPropIssueMergedMilestone"""

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssueCommentCreatedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssueCommentCreatedPropIssueMergedPerformedViaGithubApp(GitHubRestModel):
    """WebhookIssueCommentCreatedPropIssueMergedPerformedViaGithubApp"""

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "pull_request_review_thread",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropOwner,
        None,
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset,
        WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropPermissions,
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssueCommentCreatedPropIssueMergedReactions(GitHubRestModel):
    """WebhookIssueCommentCreatedPropIssueMergedReactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssueCommentCreatedPropIssueMergedUser(GitHubRestModel):
    """WebhookIssueCommentCreatedPropIssueMergedUser"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentDeleted(GitHubRestModel):
    """issue_comment deleted event"""

    action: Literal["deleted"] = Field(default=...)
    comment: WebhookIssueCommentDeletedPropComment = Field(
        title="issue comment",
        description="The [comment](https://docs.github.com/en/rest/reference/issues#comments) itself.",
        default=...,
    )
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    issue: WebhookIssueCommentDeletedPropIssue = Field(
        description="The [issue](https://docs.github.com/en/rest/reference/issues) the comment belongs to.",
        default=...,
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookIssueCommentDeletedPropComment(GitHubRestModel):
    """issue comment

    The [comment](https://docs.github.com/en/rest/reference/issues#comments) itself.
    """

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: str = Field(description="Contents of the issue comment", default=...)
    created_at: datetime = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(description="Unique identifier of the issue comment", default=...)
    issue_url: str = Field(default=...)
    node_id: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    reactions: WebhookIssueCommentDeletedPropCommentPropReactions = Field(
        title="Reactions", default=...
    )
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue comment", default=...)
    user: Union[WebhookIssueCommentDeletedPropCommentPropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssueCommentDeletedPropCommentPropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssueCommentDeletedPropCommentPropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssue(GitHubRestModel):
    """WebhookIssueCommentDeletedPropIssue

    The [issue](https://docs.github.com/en/rest/reference/issues) the comment
    belongs to.
    """

    active_lock_reason: Union[
        Literal["resolved", "off-topic", "too heated", "spam"], None
    ] = Field(default=...)
    assignee: Union[
        Union[WebhookIssueCommentDeletedPropIssueAllof0PropAssignee, None], None
    ] = Field(title="User", default=...)
    assignees: List[WebhookIssueCommentDeletedPropIssueMergedAssignees] = Field(
        default=...
    )
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[Union[str, None], None] = Field(
        description="Contents of the issue", default=...
    )
    closed_at: Union[Union[datetime, None], None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: List[WebhookIssueCommentDeletedPropIssueAllof0PropLabelsItems] = Field(
        default=...
    )
    labels_url: str = Field(default=...)
    locked: bool = Field(default=...)
    milestone: Union[WebhookIssueCommentDeletedPropIssueMergedMilestone, None] = Field(
        default=...
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset,
        Union[WebhookIssueCommentDeletedPropIssueMergedPerformedViaGithubApp, None],
    ] = Field(default=UNSET)
    pull_request: Union[
        Unset, WebhookIssueCommentDeletedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssueCommentDeletedPropIssueMergedReactions = Field(default=...)
    repository_url: str = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'", default=...
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: WebhookIssueCommentDeletedPropIssueMergedUser = Field(default=...)


class WebhookIssueCommentDeletedPropIssueAllof0(GitHubRestModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssueCommentDeletedPropIssueAllof0PropAssignee, None]
    ] = Field(title="User", default=UNSET)
    assignees: List[
        Union[WebhookIssueCommentDeletedPropIssueAllof0PropAssigneesItems, None]
    ] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[
        Unset, List[WebhookIssueCommentDeletedPropIssueAllof0PropLabelsItems]
    ] = Field(default=UNSET)
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[
        WebhookIssueCommentDeletedPropIssueAllof0PropMilestone, None
    ] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset,
        Union[WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubApp, None],
    ] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[
        Unset, WebhookIssueCommentDeletedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssueCommentDeletedPropIssueAllof0PropReactions = Field(
        title="Reactions", default=...
    )
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: Union[WebhookIssueCommentDeletedPropIssueAllof0PropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssueCommentDeletedPropIssueAllof0PropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueAllof0PropAssigneesItems(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueAllof0PropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssueCommentDeletedPropIssueAllof0PropMilestonePropCreator(
    GitHubRestModel
):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueAllof0PropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssueCommentDeletedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropOwner(
    GitHubRestModel
):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropPermissions(
    GitHubRestModel
):
    """WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropPermission
    s

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubApp(
    GitHubRestModel
):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropOwner,
        None,
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset,
        WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropPermissions,
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssueCommentDeletedPropIssueAllof0PropPullRequest(GitHubRestModel):
    """WebhookIssueCommentDeletedPropIssueAllof0PropPullRequest"""

    diff_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    patch_url: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueAllof0PropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssueCommentDeletedPropIssueAllof0PropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueAllof1(GitHubRestModel):
    """WebhookIssueCommentDeletedPropIssueAllof1"""

    active_lock_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    assignee: Union[
        WebhookIssueCommentDeletedPropIssueAllof1PropAssignee, None
    ] = Field(title="User", default=...)
    assignees: Union[
        Unset,
        List[Union[WebhookIssueCommentDeletedPropIssueAllof1PropAssigneesItems, None]],
    ] = Field(default=UNSET)
    author_association: Union[Unset, str] = Field(default=UNSET)
    body: Union[Unset, Union[str, None]] = Field(default=UNSET)
    closed_at: Union[Unset, Union[str, None]] = Field(default=UNSET)
    comments: Union[Unset, int] = Field(default=UNSET)
    comments_url: Union[Unset, str] = Field(default=UNSET)
    created_at: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    labels: List[WebhookIssueCommentDeletedPropIssueAllof1PropLabelsItems] = Field(
        default=...
    )
    labels_url: Union[Unset, str] = Field(default=UNSET)
    locked: bool = Field(default=...)
    milestone: Union[
        Unset, Union[WebhookIssueCommentDeletedPropIssueAllof1PropMilestone, None]
    ] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    number: Union[Unset, int] = Field(default=UNSET)
    performed_via_github_app: Union[
        Unset,
        Union[WebhookIssueCommentDeletedPropIssueAllof1PropPerformedViaGithubApp, None],
    ] = Field(default=UNSET)
    reactions: Union[
        Unset, WebhookIssueCommentDeletedPropIssueAllof1PropReactions
    ] = Field(default=UNSET)
    repository_url: Union[Unset, str] = Field(default=UNSET)
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'", default=...
    )
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: Union[Unset, str] = Field(default=UNSET)
    updated_at: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    user: Union[Unset, WebhookIssueCommentDeletedPropIssueAllof1PropUser] = Field(
        default=UNSET
    )


class WebhookIssueCommentDeletedPropIssueAllof1PropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueAllof1PropAssigneesItems(GitHubRestModel):
    """WebhookIssueCommentDeletedPropIssueAllof1PropAssigneesItems"""


class WebhookIssueCommentDeletedPropIssueAllof1PropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssueCommentDeletedPropIssueAllof1PropMilestone(GitHubRestModel):
    """WebhookIssueCommentDeletedPropIssueAllof1PropMilestone"""


class WebhookIssueCommentDeletedPropIssueAllof1PropPerformedViaGithubApp(
    GitHubRestModel
):
    """WebhookIssueCommentDeletedPropIssueAllof1PropPerformedViaGithubApp"""


class WebhookIssueCommentDeletedPropIssueAllof1PropReactions(GitHubRestModel):
    """WebhookIssueCommentDeletedPropIssueAllof1PropReactions"""

    plus_one: Union[Unset, int] = Field(default=UNSET, alias="+1")
    minus_one: Union[Unset, int] = Field(default=UNSET, alias="-1")
    confused: Union[Unset, int] = Field(default=UNSET)
    eyes: Union[Unset, int] = Field(default=UNSET)
    heart: Union[Unset, int] = Field(default=UNSET)
    hooray: Union[Unset, int] = Field(default=UNSET)
    laugh: Union[Unset, int] = Field(default=UNSET)
    rocket: Union[Unset, int] = Field(default=UNSET)
    total_count: Union[Unset, int] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueAllof1PropUser(GitHubRestModel):
    """WebhookIssueCommentDeletedPropIssueAllof1PropUser"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    login: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueMergedAssignees(GitHubRestModel):
    """WebhookIssueCommentDeletedPropIssueMergedAssignees"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueMergedMilestone(GitHubRestModel):
    """WebhookIssueCommentDeletedPropIssueMergedMilestone"""

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssueCommentDeletedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssueCommentDeletedPropIssueMergedPerformedViaGithubApp(GitHubRestModel):
    """WebhookIssueCommentDeletedPropIssueMergedPerformedViaGithubApp"""

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropOwner,
        None,
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset,
        WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropPermissions,
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssueCommentDeletedPropIssueMergedReactions(GitHubRestModel):
    """WebhookIssueCommentDeletedPropIssueMergedReactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssueCommentDeletedPropIssueMergedUser(GitHubRestModel):
    """WebhookIssueCommentDeletedPropIssueMergedUser"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentEdited(GitHubRestModel):
    """issue_comment edited event"""

    action: Literal["edited"] = Field(default=...)
    changes: WebhookIssueCommentEditedPropChanges = Field(
        description="The changes to the comment.", default=...
    )
    comment: WebhookIssueCommentEditedPropComment = Field(
        title="issue comment",
        description="The [comment](https://docs.github.com/en/rest/reference/issues#comments) itself.",
        default=...,
    )
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    issue: WebhookIssueCommentEditedPropIssue = Field(
        description="The [issue](https://docs.github.com/en/rest/reference/issues) the comment belongs to.",
        default=...,
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookIssueCommentEditedPropChanges(GitHubRestModel):
    """WebhookIssueCommentEditedPropChanges

    The changes to the comment.
    """

    body: Union[Unset, WebhookIssueCommentEditedPropChangesPropBody] = Field(
        default=UNSET
    )


class WebhookIssueCommentEditedPropChangesPropBody(GitHubRestModel):
    """WebhookIssueCommentEditedPropChangesPropBody"""

    from_: str = Field(
        description="The previous version of the body.", default=..., alias="from"
    )


class WebhookIssueCommentEditedPropComment(GitHubRestModel):
    """issue comment

    The [comment](https://docs.github.com/en/rest/reference/issues#comments) itself.
    """

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: str = Field(description="Contents of the issue comment", default=...)
    created_at: datetime = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(description="Unique identifier of the issue comment", default=...)
    issue_url: str = Field(default=...)
    node_id: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    reactions: WebhookIssueCommentEditedPropCommentPropReactions = Field(
        title="Reactions", default=...
    )
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue comment", default=...)
    user: Union[WebhookIssueCommentEditedPropCommentPropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssueCommentEditedPropCommentPropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssueCommentEditedPropCommentPropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssue(GitHubRestModel):
    """WebhookIssueCommentEditedPropIssue

    The [issue](https://docs.github.com/en/rest/reference/issues) the comment
    belongs to.
    """

    active_lock_reason: Union[
        Literal["resolved", "off-topic", "too heated", "spam"], None
    ] = Field(default=...)
    assignee: Union[
        Union[WebhookIssueCommentEditedPropIssueAllof0PropAssignee, None], None
    ] = Field(title="User", default=...)
    assignees: List[WebhookIssueCommentEditedPropIssueMergedAssignees] = Field(
        default=...
    )
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[Union[str, None], None] = Field(
        description="Contents of the issue", default=...
    )
    closed_at: Union[Union[datetime, None], None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: List[WebhookIssueCommentEditedPropIssueAllof0PropLabelsItems] = Field(
        default=...
    )
    labels_url: str = Field(default=...)
    locked: bool = Field(default=...)
    milestone: Union[WebhookIssueCommentEditedPropIssueMergedMilestone, None] = Field(
        default=...
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset,
        Union[WebhookIssueCommentEditedPropIssueMergedPerformedViaGithubApp, None],
    ] = Field(default=UNSET)
    pull_request: Union[
        Unset, WebhookIssueCommentEditedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssueCommentEditedPropIssueMergedReactions = Field(default=...)
    repository_url: str = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'", default=...
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: WebhookIssueCommentEditedPropIssueMergedUser = Field(default=...)


class WebhookIssueCommentEditedPropIssueAllof0(GitHubRestModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssueCommentEditedPropIssueAllof0PropAssignee, None]
    ] = Field(title="User", default=UNSET)
    assignees: List[
        Union[WebhookIssueCommentEditedPropIssueAllof0PropAssigneesItems, None]
    ] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[
        Unset, List[WebhookIssueCommentEditedPropIssueAllof0PropLabelsItems]
    ] = Field(default=UNSET)
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[
        WebhookIssueCommentEditedPropIssueAllof0PropMilestone, None
    ] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset,
        Union[WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubApp, None],
    ] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[
        Unset, WebhookIssueCommentEditedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssueCommentEditedPropIssueAllof0PropReactions = Field(
        title="Reactions", default=...
    )
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: Union[WebhookIssueCommentEditedPropIssueAllof0PropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssueCommentEditedPropIssueAllof0PropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueAllof0PropAssigneesItems(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueAllof0PropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssueCommentEditedPropIssueAllof0PropMilestonePropCreator(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueAllof0PropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssueCommentEditedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropOwner(
    GitHubRestModel
):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropPermissions(
    GitHubRestModel
):
    """WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubApp(
    GitHubRestModel
):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "pull_request_review_thread",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset,
        WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropPermissions,
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssueCommentEditedPropIssueAllof0PropPullRequest(GitHubRestModel):
    """WebhookIssueCommentEditedPropIssueAllof0PropPullRequest"""

    diff_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    patch_url: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueAllof0PropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssueCommentEditedPropIssueAllof0PropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueAllof1(GitHubRestModel):
    """WebhookIssueCommentEditedPropIssueAllof1"""

    active_lock_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    assignee: Union[WebhookIssueCommentEditedPropIssueAllof1PropAssignee, None] = Field(
        title="User", default=...
    )
    assignees: Union[
        Unset,
        List[Union[WebhookIssueCommentEditedPropIssueAllof1PropAssigneesItems, None]],
    ] = Field(default=UNSET)
    author_association: Union[Unset, str] = Field(default=UNSET)
    body: Union[Unset, Union[str, None]] = Field(default=UNSET)
    closed_at: Union[Unset, Union[str, None]] = Field(default=UNSET)
    comments: Union[Unset, int] = Field(default=UNSET)
    comments_url: Union[Unset, str] = Field(default=UNSET)
    created_at: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    labels: List[WebhookIssueCommentEditedPropIssueAllof1PropLabelsItems] = Field(
        default=...
    )
    labels_url: Union[Unset, str] = Field(default=UNSET)
    locked: bool = Field(default=...)
    milestone: Union[
        Unset, Union[WebhookIssueCommentEditedPropIssueAllof1PropMilestone, None]
    ] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    number: Union[Unset, int] = Field(default=UNSET)
    performed_via_github_app: Union[
        Unset,
        Union[WebhookIssueCommentEditedPropIssueAllof1PropPerformedViaGithubApp, None],
    ] = Field(default=UNSET)
    reactions: Union[
        Unset, WebhookIssueCommentEditedPropIssueAllof1PropReactions
    ] = Field(default=UNSET)
    repository_url: Union[Unset, str] = Field(default=UNSET)
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'", default=...
    )
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: Union[Unset, str] = Field(default=UNSET)
    updated_at: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    user: Union[Unset, WebhookIssueCommentEditedPropIssueAllof1PropUser] = Field(
        default=UNSET
    )


class WebhookIssueCommentEditedPropIssueAllof1PropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueAllof1PropAssigneesItems(GitHubRestModel):
    """WebhookIssueCommentEditedPropIssueAllof1PropAssigneesItems"""


class WebhookIssueCommentEditedPropIssueAllof1PropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssueCommentEditedPropIssueAllof1PropMilestone(GitHubRestModel):
    """WebhookIssueCommentEditedPropIssueAllof1PropMilestone"""


class WebhookIssueCommentEditedPropIssueAllof1PropPerformedViaGithubApp(
    GitHubRestModel
):
    """WebhookIssueCommentEditedPropIssueAllof1PropPerformedViaGithubApp"""


class WebhookIssueCommentEditedPropIssueAllof1PropReactions(GitHubRestModel):
    """WebhookIssueCommentEditedPropIssueAllof1PropReactions"""

    plus_one: Union[Unset, int] = Field(default=UNSET, alias="+1")
    minus_one: Union[Unset, int] = Field(default=UNSET, alias="-1")
    confused: Union[Unset, int] = Field(default=UNSET)
    eyes: Union[Unset, int] = Field(default=UNSET)
    heart: Union[Unset, int] = Field(default=UNSET)
    hooray: Union[Unset, int] = Field(default=UNSET)
    laugh: Union[Unset, int] = Field(default=UNSET)
    rocket: Union[Unset, int] = Field(default=UNSET)
    total_count: Union[Unset, int] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueAllof1PropUser(GitHubRestModel):
    """WebhookIssueCommentEditedPropIssueAllof1PropUser"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    login: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueMergedAssignees(GitHubRestModel):
    """WebhookIssueCommentEditedPropIssueMergedAssignees"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueMergedMilestone(GitHubRestModel):
    """WebhookIssueCommentEditedPropIssueMergedMilestone"""

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssueCommentEditedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssueCommentEditedPropIssueMergedPerformedViaGithubApp(GitHubRestModel):
    """WebhookIssueCommentEditedPropIssueMergedPerformedViaGithubApp"""

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "pull_request_review_thread",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset,
        WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropPermissions,
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssueCommentEditedPropIssueMergedReactions(GitHubRestModel):
    """WebhookIssueCommentEditedPropIssueMergedReactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssueCommentEditedPropIssueMergedUser(GitHubRestModel):
    """WebhookIssueCommentEditedPropIssueMergedUser"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesAssigned(GitHubRestModel):
    """issues assigned event"""

    action: Literal["assigned"] = Field(
        description="The action that was performed.", default=...
    )
    assignee: Union[Unset, Union[WebhookIssuesAssignedPropAssignee, None]] = Field(
        title="User", default=UNSET
    )
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    issue: WebhookIssuesAssignedPropIssue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookIssuesAssignedPropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesAssignedPropIssue(GitHubRestModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesAssignedPropIssuePropAssignee, None]
    ] = Field(title="User", default=UNSET)
    assignees: List[
        Union[WebhookIssuesAssignedPropIssuePropAssigneesItems, None]
    ] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[Unset, List[WebhookIssuesAssignedPropIssuePropLabelsItems]] = Field(
        default=UNSET
    )
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[WebhookIssuesAssignedPropIssuePropMilestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset, Union[WebhookIssuesAssignedPropIssuePropPerformedViaGithubApp, None]
    ] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[Unset, WebhookIssuesAssignedPropIssuePropPullRequest] = Field(
        default=UNSET
    )
    reactions: WebhookIssuesAssignedPropIssuePropReactions = Field(
        title="Reactions", default=...
    )
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: Union[WebhookIssuesAssignedPropIssuePropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssuesAssignedPropIssuePropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesAssignedPropIssuePropAssigneesItems(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesAssignedPropIssuePropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesAssignedPropIssuePropMilestonePropCreator(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesAssignedPropIssuePropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssuesAssignedPropIssuePropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesAssignedPropIssuePropPerformedViaGithubAppPropOwner(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesAssignedPropIssuePropPerformedViaGithubAppPropPermissions(
    GitHubRestModel
):
    """WebhookIssuesAssignedPropIssuePropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssuesAssignedPropIssuePropPerformedViaGithubApp(GitHubRestModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "pull_request_review_thread",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesAssignedPropIssuePropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset, WebhookIssuesAssignedPropIssuePropPerformedViaGithubAppPropPermissions
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesAssignedPropIssuePropPullRequest(GitHubRestModel):
    """WebhookIssuesAssignedPropIssuePropPullRequest"""

    diff_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    patch_url: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesAssignedPropIssuePropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesAssignedPropIssuePropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesClosed(GitHubRestModel):
    """issues closed event"""

    action: Literal["closed"] = Field(
        description="The action that was performed.", default=...
    )
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    issue: WebhookIssuesClosedPropIssue = Field(
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookIssuesClosedPropIssue(GitHubRestModel):
    """WebhookIssuesClosedPropIssue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        Literal["resolved", "off-topic", "too heated", "spam"], None
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesClosedPropIssueMergedAssignee, None]
    ] = Field(default=UNSET)
    assignees: List[WebhookIssuesClosedPropIssueMergedAssignees] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[Union[str, None], None] = Field(
        description="Contents of the issue", default=...
    )
    closed_at: Union[Union[datetime, None], None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[Unset, List[WebhookIssuesClosedPropIssueMergedLabels]] = Field(
        default=UNSET
    )
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[WebhookIssuesClosedPropIssueMergedMilestone, None] = Field(
        default=...
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset, Union[WebhookIssuesClosedPropIssueMergedPerformedViaGithubApp, None]
    ] = Field(default=UNSET)
    pull_request: Union[
        Unset, WebhookIssuesClosedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssuesClosedPropIssueMergedReactions = Field(default=...)
    repository_url: str = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'", default=...
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: WebhookIssuesClosedPropIssueMergedUser = Field(default=...)


class WebhookIssuesClosedPropIssueAllof0(GitHubRestModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesClosedPropIssueAllof0PropAssignee, None]
    ] = Field(title="User", default=UNSET)
    assignees: List[
        Union[WebhookIssuesClosedPropIssueAllof0PropAssigneesItems, None]
    ] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[
        Unset, List[WebhookIssuesClosedPropIssueAllof0PropLabelsItems]
    ] = Field(default=UNSET)
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[WebhookIssuesClosedPropIssueAllof0PropMilestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset, Union[WebhookIssuesClosedPropIssueAllof0PropPerformedViaGithubApp, None]
    ] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[
        Unset, WebhookIssuesClosedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssuesClosedPropIssueAllof0PropReactions = Field(
        title="Reactions", default=...
    )
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: Union[WebhookIssuesClosedPropIssueAllof0PropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssuesClosedPropIssueAllof0PropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesClosedPropIssueAllof0PropAssigneesItems(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesClosedPropIssueAllof0PropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesClosedPropIssueAllof0PropMilestonePropCreator(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesClosedPropIssueAllof0PropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssuesClosedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesClosedPropIssueAllof0PropPerformedViaGithubAppPropOwner(
    GitHubRestModel
):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesClosedPropIssueAllof0PropPerformedViaGithubAppPropPermissions(
    GitHubRestModel
):
    """WebhookIssuesClosedPropIssueAllof0PropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssuesClosedPropIssueAllof0PropPerformedViaGithubApp(GitHubRestModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "security_and_analysis",
                "reminder",
                "pull_request_review_thread",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesClosedPropIssueAllof0PropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset,
        WebhookIssuesClosedPropIssueAllof0PropPerformedViaGithubAppPropPermissions,
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesClosedPropIssueAllof0PropPullRequest(GitHubRestModel):
    """WebhookIssuesClosedPropIssueAllof0PropPullRequest"""

    diff_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    patch_url: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesClosedPropIssueAllof0PropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesClosedPropIssueAllof0PropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesClosedPropIssueAllof1(GitHubRestModel):
    """WebhookIssuesClosedPropIssueAllof1"""

    active_lock_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    assignee: Union[
        Unset, Union[WebhookIssuesClosedPropIssueAllof1PropAssignee, None]
    ] = Field(default=UNSET)
    assignees: Union[
        Unset, List[Union[WebhookIssuesClosedPropIssueAllof1PropAssigneesItems, None]]
    ] = Field(default=UNSET)
    author_association: Union[Unset, str] = Field(default=UNSET)
    body: Union[Unset, Union[str, None]] = Field(default=UNSET)
    closed_at: Union[str, None] = Field(default=...)
    comments: Union[Unset, int] = Field(default=UNSET)
    comments_url: Union[Unset, str] = Field(default=UNSET)
    created_at: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    labels: Union[
        Unset, List[Union[WebhookIssuesClosedPropIssueAllof1PropLabelsItems, None]]
    ] = Field(default=UNSET)
    labels_url: Union[Unset, str] = Field(default=UNSET)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[
        Unset, Union[WebhookIssuesClosedPropIssueAllof1PropMilestone, None]
    ] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    number: Union[Unset, int] = Field(default=UNSET)
    performed_via_github_app: Union[
        Unset, Union[WebhookIssuesClosedPropIssueAllof1PropPerformedViaGithubApp, None]
    ] = Field(default=UNSET)
    reactions: Union[Unset, WebhookIssuesClosedPropIssueAllof1PropReactions] = Field(
        default=UNSET
    )
    repository_url: Union[Unset, str] = Field(default=UNSET)
    state: Literal["closed", "open"] = Field(default=...)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: Union[Unset, str] = Field(default=UNSET)
    updated_at: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    user: Union[Unset, WebhookIssuesClosedPropIssueAllof1PropUser] = Field(
        default=UNSET
    )


class WebhookIssuesClosedPropIssueAllof1PropAssignee(GitHubRestModel):
    """WebhookIssuesClosedPropIssueAllof1PropAssignee"""


class WebhookIssuesClosedPropIssueAllof1PropAssigneesItems(GitHubRestModel):
    """WebhookIssuesClosedPropIssueAllof1PropAssigneesItems"""


class WebhookIssuesClosedPropIssueAllof1PropLabelsItems(GitHubRestModel):
    """WebhookIssuesClosedPropIssueAllof1PropLabelsItems"""


class WebhookIssuesClosedPropIssueAllof1PropMilestone(GitHubRestModel):
    """WebhookIssuesClosedPropIssueAllof1PropMilestone"""


class WebhookIssuesClosedPropIssueAllof1PropPerformedViaGithubApp(GitHubRestModel):
    """WebhookIssuesClosedPropIssueAllof1PropPerformedViaGithubApp"""


class WebhookIssuesClosedPropIssueAllof1PropReactions(GitHubRestModel):
    """WebhookIssuesClosedPropIssueAllof1PropReactions"""

    plus_one: Union[Unset, int] = Field(default=UNSET, alias="+1")
    minus_one: Union[Unset, int] = Field(default=UNSET, alias="-1")
    confused: Union[Unset, int] = Field(default=UNSET)
    eyes: Union[Unset, int] = Field(default=UNSET)
    heart: Union[Unset, int] = Field(default=UNSET)
    hooray: Union[Unset, int] = Field(default=UNSET)
    laugh: Union[Unset, int] = Field(default=UNSET)
    rocket: Union[Unset, int] = Field(default=UNSET)
    total_count: Union[Unset, int] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesClosedPropIssueAllof1PropUser(GitHubRestModel):
    """WebhookIssuesClosedPropIssueAllof1PropUser"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    login: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesClosedPropIssueMergedAssignee(GitHubRestModel):
    """WebhookIssuesClosedPropIssueMergedAssignee"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesClosedPropIssueMergedAssignees(GitHubRestModel):
    """WebhookIssuesClosedPropIssueMergedAssignees"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesClosedPropIssueMergedLabels(GitHubRestModel):
    """WebhookIssuesClosedPropIssueMergedLabels"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesClosedPropIssueMergedMilestone(GitHubRestModel):
    """WebhookIssuesClosedPropIssueMergedMilestone"""

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssuesClosedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesClosedPropIssueMergedPerformedViaGithubApp(GitHubRestModel):
    """WebhookIssuesClosedPropIssueMergedPerformedViaGithubApp"""

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "security_and_analysis",
                "reminder",
                "pull_request_review_thread",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesClosedPropIssueAllof0PropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset,
        WebhookIssuesClosedPropIssueAllof0PropPerformedViaGithubAppPropPermissions,
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesClosedPropIssueMergedReactions(GitHubRestModel):
    """WebhookIssuesClosedPropIssueMergedReactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesClosedPropIssueMergedUser(GitHubRestModel):
    """WebhookIssuesClosedPropIssueMergedUser"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesDeleted(GitHubRestModel):
    """issues deleted event"""

    action: Literal["deleted"] = Field(default=...)
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    issue: WebhookIssuesDeletedPropIssue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookIssuesDeletedPropIssue(GitHubRestModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesDeletedPropIssuePropAssignee, None]
    ] = Field(title="User", default=UNSET)
    assignees: List[
        Union[WebhookIssuesDeletedPropIssuePropAssigneesItems, None]
    ] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[Unset, List[WebhookIssuesDeletedPropIssuePropLabelsItems]] = Field(
        default=UNSET
    )
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[WebhookIssuesDeletedPropIssuePropMilestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset, Union[WebhookIssuesDeletedPropIssuePropPerformedViaGithubApp, None]
    ] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[Unset, WebhookIssuesDeletedPropIssuePropPullRequest] = Field(
        default=UNSET
    )
    reactions: WebhookIssuesDeletedPropIssuePropReactions = Field(
        title="Reactions", default=...
    )
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: Union[WebhookIssuesDeletedPropIssuePropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssuesDeletedPropIssuePropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesDeletedPropIssuePropAssigneesItems(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesDeletedPropIssuePropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesDeletedPropIssuePropMilestonePropCreator(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesDeletedPropIssuePropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[WebhookIssuesDeletedPropIssuePropMilestonePropCreator, None] = Field(
        title="User", default=...
    )
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesDeletedPropIssuePropPerformedViaGithubAppPropOwner(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesDeletedPropIssuePropPerformedViaGithubAppPropPermissions(
    GitHubRestModel
):
    """WebhookIssuesDeletedPropIssuePropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssuesDeletedPropIssuePropPerformedViaGithubApp(GitHubRestModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesDeletedPropIssuePropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset, WebhookIssuesDeletedPropIssuePropPerformedViaGithubAppPropPermissions
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesDeletedPropIssuePropPullRequest(GitHubRestModel):
    """WebhookIssuesDeletedPropIssuePropPullRequest"""

    diff_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    patch_url: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesDeletedPropIssuePropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesDeletedPropIssuePropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesDemilestoned(GitHubRestModel):
    """issues demilestoned event"""

    action: Literal["demilestoned"] = Field(default=...)
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    issue: WebhookIssuesDemilestonedPropIssue = Field(default=...)
    milestone: Union[Unset, WebhookIssuesDemilestonedPropMilestone] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=UNSET,
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookIssuesDemilestonedPropIssue(GitHubRestModel):
    """WebhookIssuesDemilestonedPropIssue"""

    active_lock_reason: Union[
        Literal["resolved", "off-topic", "too heated", "spam"], None
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesDemilestonedPropIssueMergedAssignee, None]
    ] = Field(default=UNSET)
    assignees: List[WebhookIssuesDemilestonedPropIssueMergedAssignees] = Field(
        default=...
    )
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[Union[str, None], None] = Field(
        description="Contents of the issue", default=...
    )
    closed_at: Union[Union[datetime, None], None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[Unset, List[WebhookIssuesDemilestonedPropIssueMergedLabels]] = Field(
        default=UNSET
    )
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[
        Union[WebhookIssuesDemilestonedPropIssueAllof0PropMilestone, None], None
    ] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset,
        Union[WebhookIssuesDemilestonedPropIssueMergedPerformedViaGithubApp, None],
    ] = Field(default=UNSET)
    pull_request: Union[
        Unset, WebhookIssuesDemilestonedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssuesDemilestonedPropIssueMergedReactions = Field(default=...)
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: WebhookIssuesDemilestonedPropIssueMergedUser = Field(default=...)


class WebhookIssuesDemilestonedPropIssueAllof0(GitHubRestModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesDemilestonedPropIssueAllof0PropAssignee, None]
    ] = Field(title="User", default=UNSET)
    assignees: List[
        Union[WebhookIssuesDemilestonedPropIssueAllof0PropAssigneesItems, None]
    ] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[
        Unset, List[WebhookIssuesDemilestonedPropIssueAllof0PropLabelsItems]
    ] = Field(default=UNSET)
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[
        WebhookIssuesDemilestonedPropIssueAllof0PropMilestone, None
    ] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset,
        Union[WebhookIssuesDemilestonedPropIssueAllof0PropPerformedViaGithubApp, None],
    ] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[
        Unset, WebhookIssuesDemilestonedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssuesDemilestonedPropIssueAllof0PropReactions = Field(
        title="Reactions", default=...
    )
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: Union[WebhookIssuesDemilestonedPropIssueAllof0PropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssuesDemilestonedPropIssueAllof0PropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesDemilestonedPropIssueAllof0PropAssigneesItems(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesDemilestonedPropIssueAllof0PropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesDemilestonedPropIssueAllof0PropMilestonePropCreator(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesDemilestonedPropIssueAllof0PropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssuesDemilestonedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesDemilestonedPropIssueAllof0PropPerformedViaGithubAppPropOwner(
    GitHubRestModel
):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesDemilestonedPropIssueAllof0PropPerformedViaGithubAppPropPermissions(
    GitHubRestModel
):
    """WebhookIssuesDemilestonedPropIssueAllof0PropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssuesDemilestonedPropIssueAllof0PropPerformedViaGithubApp(
    GitHubRestModel
):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesDemilestonedPropIssueAllof0PropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset,
        WebhookIssuesDemilestonedPropIssueAllof0PropPerformedViaGithubAppPropPermissions,
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesDemilestonedPropIssueAllof0PropPullRequest(GitHubRestModel):
    """WebhookIssuesDemilestonedPropIssueAllof0PropPullRequest"""

    diff_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    patch_url: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesDemilestonedPropIssueAllof0PropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesDemilestonedPropIssueAllof0PropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesDemilestonedPropIssueAllof1(GitHubRestModel):
    """WebhookIssuesDemilestonedPropIssueAllof1"""

    active_lock_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    assignee: Union[
        Unset, Union[WebhookIssuesDemilestonedPropIssueAllof1PropAssignee, None]
    ] = Field(default=UNSET)
    assignees: Union[
        Unset,
        List[Union[WebhookIssuesDemilestonedPropIssueAllof1PropAssigneesItems, None]],
    ] = Field(default=UNSET)
    author_association: Union[Unset, str] = Field(default=UNSET)
    body: Union[Unset, Union[str, None]] = Field(default=UNSET)
    closed_at: Union[Unset, Union[str, None]] = Field(default=UNSET)
    comments: Union[Unset, int] = Field(default=UNSET)
    comments_url: Union[Unset, str] = Field(default=UNSET)
    created_at: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    labels: Union[
        Unset,
        List[Union[WebhookIssuesDemilestonedPropIssueAllof1PropLabelsItems, None]],
    ] = Field(default=UNSET)
    labels_url: Union[Unset, str] = Field(default=UNSET)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[
        WebhookIssuesDemilestonedPropIssueAllof1PropMilestone, None
    ] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: Union[Unset, str] = Field(default=UNSET)
    number: Union[Unset, int] = Field(default=UNSET)
    performed_via_github_app: Union[
        Unset,
        Union[WebhookIssuesDemilestonedPropIssueAllof1PropPerformedViaGithubApp, None],
    ] = Field(default=UNSET)
    reactions: Union[
        Unset, WebhookIssuesDemilestonedPropIssueAllof1PropReactions
    ] = Field(default=UNSET)
    repository_url: Union[Unset, str] = Field(default=UNSET)
    state: Union[Unset, str] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: Union[Unset, str] = Field(default=UNSET)
    updated_at: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    user: Union[Unset, WebhookIssuesDemilestonedPropIssueAllof1PropUser] = Field(
        default=UNSET
    )


class WebhookIssuesDemilestonedPropIssueAllof1PropAssignee(GitHubRestModel):
    """WebhookIssuesDemilestonedPropIssueAllof1PropAssignee"""


class WebhookIssuesDemilestonedPropIssueAllof1PropAssigneesItems(GitHubRestModel):
    """WebhookIssuesDemilestonedPropIssueAllof1PropAssigneesItems"""


class WebhookIssuesDemilestonedPropIssueAllof1PropLabelsItems(GitHubRestModel):
    """WebhookIssuesDemilestonedPropIssueAllof1PropLabelsItems"""


class WebhookIssuesDemilestonedPropIssueAllof1PropMilestonePropCreator(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesDemilestonedPropIssueAllof1PropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssuesDemilestonedPropIssueAllof1PropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesDemilestonedPropIssueAllof1PropPerformedViaGithubApp(
    GitHubRestModel
):
    """WebhookIssuesDemilestonedPropIssueAllof1PropPerformedViaGithubApp"""


class WebhookIssuesDemilestonedPropIssueAllof1PropReactions(GitHubRestModel):
    """WebhookIssuesDemilestonedPropIssueAllof1PropReactions"""

    plus_one: Union[Unset, int] = Field(default=UNSET, alias="+1")
    minus_one: Union[Unset, int] = Field(default=UNSET, alias="-1")
    confused: Union[Unset, int] = Field(default=UNSET)
    eyes: Union[Unset, int] = Field(default=UNSET)
    heart: Union[Unset, int] = Field(default=UNSET)
    hooray: Union[Unset, int] = Field(default=UNSET)
    laugh: Union[Unset, int] = Field(default=UNSET)
    rocket: Union[Unset, int] = Field(default=UNSET)
    total_count: Union[Unset, int] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesDemilestonedPropIssueAllof1PropUser(GitHubRestModel):
    """WebhookIssuesDemilestonedPropIssueAllof1PropUser"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    login: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesDemilestonedPropIssueMergedAssignee(GitHubRestModel):
    """WebhookIssuesDemilestonedPropIssueMergedAssignee"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesDemilestonedPropIssueMergedAssignees(GitHubRestModel):
    """WebhookIssuesDemilestonedPropIssueMergedAssignees"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesDemilestonedPropIssueMergedLabels(GitHubRestModel):
    """WebhookIssuesDemilestonedPropIssueMergedLabels"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesDemilestonedPropIssueMergedPerformedViaGithubApp(GitHubRestModel):
    """WebhookIssuesDemilestonedPropIssueMergedPerformedViaGithubApp"""

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesDemilestonedPropIssueAllof0PropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset,
        WebhookIssuesDemilestonedPropIssueAllof0PropPerformedViaGithubAppPropPermissions,
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesDemilestonedPropIssueMergedReactions(GitHubRestModel):
    """WebhookIssuesDemilestonedPropIssueMergedReactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesDemilestonedPropIssueMergedUser(GitHubRestModel):
    """WebhookIssuesDemilestonedPropIssueMergedUser"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesDemilestonedPropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[WebhookIssuesDemilestonedPropMilestonePropCreator, None] = Field(
        title="User", default=...
    )
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesDemilestonedPropMilestonePropCreator(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesEdited(GitHubRestModel):
    """issues edited event"""

    action: Literal["edited"] = Field(default=...)
    changes: WebhookIssuesEditedPropChanges = Field(
        description="The changes to the issue.", default=...
    )
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    issue: WebhookIssuesEditedPropIssue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    label: Union[Unset, WebhookIssuesEditedPropLabel] = Field(
        title="Label", default=UNSET
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookIssuesEditedPropChanges(GitHubRestModel):
    """WebhookIssuesEditedPropChanges

    The changes to the issue.
    """

    body: Union[Unset, WebhookIssuesEditedPropChangesPropBody] = Field(default=UNSET)
    title: Union[Unset, WebhookIssuesEditedPropChangesPropTitle] = Field(default=UNSET)


class WebhookIssuesEditedPropChangesPropBody(GitHubRestModel):
    """WebhookIssuesEditedPropChangesPropBody"""

    from_: str = Field(
        description="The previous version of the body.", default=..., alias="from"
    )


class WebhookIssuesEditedPropChangesPropTitle(GitHubRestModel):
    """WebhookIssuesEditedPropChangesPropTitle"""

    from_: str = Field(
        description="The previous version of the title.", default=..., alias="from"
    )


class WebhookIssuesEditedPropIssue(GitHubRestModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesEditedPropIssuePropAssignee, None]
    ] = Field(title="User", default=UNSET)
    assignees: List[
        Union[WebhookIssuesEditedPropIssuePropAssigneesItems, None]
    ] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[Unset, List[WebhookIssuesEditedPropIssuePropLabelsItems]] = Field(
        default=UNSET
    )
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[WebhookIssuesEditedPropIssuePropMilestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset, Union[WebhookIssuesEditedPropIssuePropPerformedViaGithubApp, None]
    ] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[Unset, WebhookIssuesEditedPropIssuePropPullRequest] = Field(
        default=UNSET
    )
    reactions: WebhookIssuesEditedPropIssuePropReactions = Field(
        title="Reactions", default=...
    )
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: Union[WebhookIssuesEditedPropIssuePropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssuesEditedPropIssuePropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesEditedPropIssuePropAssigneesItems(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesEditedPropIssuePropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesEditedPropIssuePropMilestonePropCreator(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesEditedPropIssuePropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[WebhookIssuesEditedPropIssuePropMilestonePropCreator, None] = Field(
        title="User", default=...
    )
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesEditedPropIssuePropPerformedViaGithubAppPropOwner(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesEditedPropIssuePropPerformedViaGithubAppPropPermissions(
    GitHubRestModel
):
    """WebhookIssuesEditedPropIssuePropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssuesEditedPropIssuePropPerformedViaGithubApp(GitHubRestModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "security_and_analysis",
                "pull_request_review_thread",
                "reminder",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesEditedPropIssuePropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset, WebhookIssuesEditedPropIssuePropPerformedViaGithubAppPropPermissions
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesEditedPropIssuePropPullRequest(GitHubRestModel):
    """WebhookIssuesEditedPropIssuePropPullRequest"""

    diff_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    patch_url: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesEditedPropIssuePropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesEditedPropIssuePropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesEditedPropLabel(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesLabeled(GitHubRestModel):
    """issues labeled event"""

    action: Literal["labeled"] = Field(default=...)
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    issue: WebhookIssuesLabeledPropIssue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    label: Union[Unset, WebhookIssuesLabeledPropLabel] = Field(
        title="Label", default=UNSET
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookIssuesLabeledPropIssue(GitHubRestModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesLabeledPropIssuePropAssignee, None]
    ] = Field(title="User", default=UNSET)
    assignees: List[
        Union[WebhookIssuesLabeledPropIssuePropAssigneesItems, None]
    ] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[Unset, List[WebhookIssuesLabeledPropIssuePropLabelsItems]] = Field(
        default=UNSET
    )
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[WebhookIssuesLabeledPropIssuePropMilestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset, Union[WebhookIssuesLabeledPropIssuePropPerformedViaGithubApp, None]
    ] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[Unset, WebhookIssuesLabeledPropIssuePropPullRequest] = Field(
        default=UNSET
    )
    reactions: WebhookIssuesLabeledPropIssuePropReactions = Field(
        title="Reactions", default=...
    )
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: Union[WebhookIssuesLabeledPropIssuePropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssuesLabeledPropIssuePropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesLabeledPropIssuePropAssigneesItems(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesLabeledPropIssuePropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesLabeledPropIssuePropMilestonePropCreator(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesLabeledPropIssuePropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[WebhookIssuesLabeledPropIssuePropMilestonePropCreator, None] = Field(
        title="User", default=...
    )
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesLabeledPropIssuePropPerformedViaGithubAppPropOwner(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesLabeledPropIssuePropPerformedViaGithubAppPropPermissions(
    GitHubRestModel
):
    """WebhookIssuesLabeledPropIssuePropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssuesLabeledPropIssuePropPerformedViaGithubApp(GitHubRestModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "pull_request_review_thread",
                "reminder",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesLabeledPropIssuePropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset, WebhookIssuesLabeledPropIssuePropPerformedViaGithubAppPropPermissions
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesLabeledPropIssuePropPullRequest(GitHubRestModel):
    """WebhookIssuesLabeledPropIssuePropPullRequest"""

    diff_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    patch_url: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesLabeledPropIssuePropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesLabeledPropIssuePropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesLabeledPropLabel(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesLocked(GitHubRestModel):
    """issues locked event"""

    action: Literal["locked"] = Field(default=...)
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    issue: WebhookIssuesLockedPropIssue = Field(default=...)
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookIssuesLockedPropIssue(GitHubRestModel):
    """WebhookIssuesLockedPropIssue"""

    active_lock_reason: Union[
        Union[None, Literal["resolved", "off-topic", "too heated", "spam"]], None
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesLockedPropIssueMergedAssignee, None]
    ] = Field(default=UNSET)
    assignees: List[WebhookIssuesLockedPropIssueMergedAssignees] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[Union[str, None], None] = Field(
        description="Contents of the issue", default=...
    )
    closed_at: Union[Union[datetime, None], None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[Unset, List[WebhookIssuesLockedPropIssueMergedLabels]] = Field(
        default=UNSET
    )
    labels_url: str = Field(default=...)
    locked: Literal[True] = Field(default=...)
    milestone: Union[WebhookIssuesLockedPropIssueMergedMilestone, None] = Field(
        default=...
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset, Union[WebhookIssuesLockedPropIssueMergedPerformedViaGithubApp, None]
    ] = Field(default=UNSET)
    pull_request: Union[
        Unset, WebhookIssuesLockedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssuesLockedPropIssueMergedReactions = Field(default=...)
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: WebhookIssuesLockedPropIssueMergedUser = Field(default=...)


class WebhookIssuesLockedPropIssueAllof0(GitHubRestModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesLockedPropIssueAllof0PropAssignee, None]
    ] = Field(title="User", default=UNSET)
    assignees: List[
        Union[WebhookIssuesLockedPropIssueAllof0PropAssigneesItems, None]
    ] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[
        Unset, List[WebhookIssuesLockedPropIssueAllof0PropLabelsItems]
    ] = Field(default=UNSET)
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[WebhookIssuesLockedPropIssueAllof0PropMilestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset, Union[WebhookIssuesLockedPropIssueAllof0PropPerformedViaGithubApp, None]
    ] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[
        Unset, WebhookIssuesLockedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssuesLockedPropIssueAllof0PropReactions = Field(
        title="Reactions", default=...
    )
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: Union[WebhookIssuesLockedPropIssueAllof0PropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssuesLockedPropIssueAllof0PropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesLockedPropIssueAllof0PropAssigneesItems(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesLockedPropIssueAllof0PropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesLockedPropIssueAllof0PropMilestonePropCreator(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesLockedPropIssueAllof0PropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssuesLockedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesLockedPropIssueAllof0PropPerformedViaGithubAppPropOwner(
    GitHubRestModel
):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesLockedPropIssueAllof0PropPerformedViaGithubAppPropPermissions(
    GitHubRestModel
):
    """WebhookIssuesLockedPropIssueAllof0PropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssuesLockedPropIssueAllof0PropPerformedViaGithubApp(GitHubRestModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "security_and_analysis",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesLockedPropIssueAllof0PropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset,
        WebhookIssuesLockedPropIssueAllof0PropPerformedViaGithubAppPropPermissions,
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesLockedPropIssueAllof0PropPullRequest(GitHubRestModel):
    """WebhookIssuesLockedPropIssueAllof0PropPullRequest"""

    diff_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    patch_url: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesLockedPropIssueAllof0PropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesLockedPropIssueAllof0PropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesLockedPropIssueAllof1(GitHubRestModel):
    """WebhookIssuesLockedPropIssueAllof1"""

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesLockedPropIssueAllof1PropAssignee, None]
    ] = Field(default=UNSET)
    assignees: Union[
        Unset, List[Union[WebhookIssuesLockedPropIssueAllof1PropAssigneesItems, None]]
    ] = Field(default=UNSET)
    author_association: Union[Unset, str] = Field(default=UNSET)
    body: Union[Unset, Union[str, None]] = Field(default=UNSET)
    closed_at: Union[Unset, Union[str, None]] = Field(default=UNSET)
    comments: Union[Unset, int] = Field(default=UNSET)
    comments_url: Union[Unset, str] = Field(default=UNSET)
    created_at: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    labels: Union[
        Unset, List[Union[WebhookIssuesLockedPropIssueAllof1PropLabelsItems, None]]
    ] = Field(default=UNSET)
    labels_url: Union[Unset, str] = Field(default=UNSET)
    locked: Literal[True] = Field(default=...)
    milestone: Union[
        Unset, Union[WebhookIssuesLockedPropIssueAllof1PropMilestone, None]
    ] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    number: Union[Unset, int] = Field(default=UNSET)
    performed_via_github_app: Union[
        Unset, Union[WebhookIssuesLockedPropIssueAllof1PropPerformedViaGithubApp, None]
    ] = Field(default=UNSET)
    reactions: Union[Unset, WebhookIssuesLockedPropIssueAllof1PropReactions] = Field(
        default=UNSET
    )
    repository_url: Union[Unset, str] = Field(default=UNSET)
    state: Union[Unset, str] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: Union[Unset, str] = Field(default=UNSET)
    updated_at: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    user: Union[Unset, WebhookIssuesLockedPropIssueAllof1PropUser] = Field(
        default=UNSET
    )


class WebhookIssuesLockedPropIssueAllof1PropAssignee(GitHubRestModel):
    """WebhookIssuesLockedPropIssueAllof1PropAssignee"""


class WebhookIssuesLockedPropIssueAllof1PropAssigneesItems(GitHubRestModel):
    """WebhookIssuesLockedPropIssueAllof1PropAssigneesItems"""


class WebhookIssuesLockedPropIssueAllof1PropLabelsItems(GitHubRestModel):
    """WebhookIssuesLockedPropIssueAllof1PropLabelsItems"""


class WebhookIssuesLockedPropIssueAllof1PropMilestone(GitHubRestModel):
    """WebhookIssuesLockedPropIssueAllof1PropMilestone"""


class WebhookIssuesLockedPropIssueAllof1PropPerformedViaGithubApp(GitHubRestModel):
    """WebhookIssuesLockedPropIssueAllof1PropPerformedViaGithubApp"""


class WebhookIssuesLockedPropIssueAllof1PropReactions(GitHubRestModel):
    """WebhookIssuesLockedPropIssueAllof1PropReactions"""

    plus_one: Union[Unset, int] = Field(default=UNSET, alias="+1")
    minus_one: Union[Unset, int] = Field(default=UNSET, alias="-1")
    confused: Union[Unset, int] = Field(default=UNSET)
    eyes: Union[Unset, int] = Field(default=UNSET)
    heart: Union[Unset, int] = Field(default=UNSET)
    hooray: Union[Unset, int] = Field(default=UNSET)
    laugh: Union[Unset, int] = Field(default=UNSET)
    rocket: Union[Unset, int] = Field(default=UNSET)
    total_count: Union[Unset, int] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesLockedPropIssueAllof1PropUser(GitHubRestModel):
    """WebhookIssuesLockedPropIssueAllof1PropUser"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    login: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesLockedPropIssueMergedAssignee(GitHubRestModel):
    """WebhookIssuesLockedPropIssueMergedAssignee"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesLockedPropIssueMergedAssignees(GitHubRestModel):
    """WebhookIssuesLockedPropIssueMergedAssignees"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesLockedPropIssueMergedLabels(GitHubRestModel):
    """WebhookIssuesLockedPropIssueMergedLabels"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesLockedPropIssueMergedMilestone(GitHubRestModel):
    """WebhookIssuesLockedPropIssueMergedMilestone"""

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssuesLockedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesLockedPropIssueMergedPerformedViaGithubApp(GitHubRestModel):
    """WebhookIssuesLockedPropIssueMergedPerformedViaGithubApp"""

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "security_and_analysis",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesLockedPropIssueAllof0PropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset,
        WebhookIssuesLockedPropIssueAllof0PropPerformedViaGithubAppPropPermissions,
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesLockedPropIssueMergedReactions(GitHubRestModel):
    """WebhookIssuesLockedPropIssueMergedReactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesLockedPropIssueMergedUser(GitHubRestModel):
    """WebhookIssuesLockedPropIssueMergedUser"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesMilestoned(GitHubRestModel):
    """issues milestoned event"""

    action: Literal["milestoned"] = Field(default=...)
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    issue: WebhookIssuesMilestonedPropIssue = Field(default=...)
    milestone: WebhookIssuesMilestonedPropMilestone = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookIssuesMilestonedPropIssue(GitHubRestModel):
    """WebhookIssuesMilestonedPropIssue"""

    active_lock_reason: Union[
        Literal["resolved", "off-topic", "too heated", "spam"], None
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesMilestonedPropIssueMergedAssignee, None]
    ] = Field(default=UNSET)
    assignees: List[WebhookIssuesMilestonedPropIssueMergedAssignees] = Field(
        default=...
    )
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[Union[str, None], None] = Field(
        description="Contents of the issue", default=...
    )
    closed_at: Union[Union[datetime, None], None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[Unset, List[WebhookIssuesMilestonedPropIssueMergedLabels]] = Field(
        default=UNSET
    )
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: WebhookIssuesMilestonedPropIssueAllof1PropMilestone = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset, Union[WebhookIssuesMilestonedPropIssueMergedPerformedViaGithubApp, None]
    ] = Field(default=UNSET)
    pull_request: Union[
        Unset, WebhookIssuesMilestonedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssuesMilestonedPropIssueMergedReactions = Field(default=...)
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: WebhookIssuesMilestonedPropIssueMergedUser = Field(default=...)


class WebhookIssuesMilestonedPropIssueAllof0(GitHubRestModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesMilestonedPropIssueAllof0PropAssignee, None]
    ] = Field(title="User", default=UNSET)
    assignees: List[
        Union[WebhookIssuesMilestonedPropIssueAllof0PropAssigneesItems, None]
    ] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[
        Unset, List[WebhookIssuesMilestonedPropIssueAllof0PropLabelsItems]
    ] = Field(default=UNSET)
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[WebhookIssuesMilestonedPropIssueAllof0PropMilestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset,
        Union[WebhookIssuesMilestonedPropIssueAllof0PropPerformedViaGithubApp, None],
    ] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[
        Unset, WebhookIssuesMilestonedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssuesMilestonedPropIssueAllof0PropReactions = Field(
        title="Reactions", default=...
    )
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: Union[WebhookIssuesMilestonedPropIssueAllof0PropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssuesMilestonedPropIssueAllof0PropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesMilestonedPropIssueAllof0PropAssigneesItems(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesMilestonedPropIssueAllof0PropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesMilestonedPropIssueAllof0PropMilestonePropCreator(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesMilestonedPropIssueAllof0PropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssuesMilestonedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesMilestonedPropIssueAllof0PropPerformedViaGithubAppPropOwner(
    GitHubRestModel
):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesMilestonedPropIssueAllof0PropPerformedViaGithubAppPropPermissions(
    GitHubRestModel
):
    """WebhookIssuesMilestonedPropIssueAllof0PropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssuesMilestonedPropIssueAllof0PropPerformedViaGithubApp(GitHubRestModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesMilestonedPropIssueAllof0PropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset,
        WebhookIssuesMilestonedPropIssueAllof0PropPerformedViaGithubAppPropPermissions,
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesMilestonedPropIssueAllof0PropPullRequest(GitHubRestModel):
    """WebhookIssuesMilestonedPropIssueAllof0PropPullRequest"""

    diff_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    patch_url: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesMilestonedPropIssueAllof0PropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesMilestonedPropIssueAllof0PropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesMilestonedPropIssueAllof1(GitHubRestModel):
    """WebhookIssuesMilestonedPropIssueAllof1"""

    active_lock_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    assignee: Union[
        Unset, Union[WebhookIssuesMilestonedPropIssueAllof1PropAssignee, None]
    ] = Field(default=UNSET)
    assignees: Union[
        Unset,
        List[Union[WebhookIssuesMilestonedPropIssueAllof1PropAssigneesItems, None]],
    ] = Field(default=UNSET)
    author_association: Union[Unset, str] = Field(default=UNSET)
    body: Union[Unset, Union[str, None]] = Field(default=UNSET)
    closed_at: Union[Unset, Union[str, None]] = Field(default=UNSET)
    comments: Union[Unset, int] = Field(default=UNSET)
    comments_url: Union[Unset, str] = Field(default=UNSET)
    created_at: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    labels: Union[
        Unset, List[Union[WebhookIssuesMilestonedPropIssueAllof1PropLabelsItems, None]]
    ] = Field(default=UNSET)
    labels_url: Union[Unset, str] = Field(default=UNSET)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: WebhookIssuesMilestonedPropIssueAllof1PropMilestone = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: Union[Unset, str] = Field(default=UNSET)
    number: Union[Unset, int] = Field(default=UNSET)
    performed_via_github_app: Union[
        Unset,
        Union[WebhookIssuesMilestonedPropIssueAllof1PropPerformedViaGithubApp, None],
    ] = Field(default=UNSET)
    reactions: Union[
        Unset, WebhookIssuesMilestonedPropIssueAllof1PropReactions
    ] = Field(default=UNSET)
    repository_url: Union[Unset, str] = Field(default=UNSET)
    state: Union[Unset, str] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: Union[Unset, str] = Field(default=UNSET)
    updated_at: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    user: Union[Unset, WebhookIssuesMilestonedPropIssueAllof1PropUser] = Field(
        default=UNSET
    )


class WebhookIssuesMilestonedPropIssueAllof1PropAssignee(GitHubRestModel):
    """WebhookIssuesMilestonedPropIssueAllof1PropAssignee"""


class WebhookIssuesMilestonedPropIssueAllof1PropAssigneesItems(GitHubRestModel):
    """WebhookIssuesMilestonedPropIssueAllof1PropAssigneesItems"""


class WebhookIssuesMilestonedPropIssueAllof1PropLabelsItems(GitHubRestModel):
    """WebhookIssuesMilestonedPropIssueAllof1PropLabelsItems"""


class WebhookIssuesMilestonedPropIssueAllof1PropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssuesMilestonedPropIssueAllof1PropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesMilestonedPropIssueAllof1PropMilestonePropCreator(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesMilestonedPropIssueAllof1PropPerformedViaGithubApp(GitHubRestModel):
    """WebhookIssuesMilestonedPropIssueAllof1PropPerformedViaGithubApp"""


class WebhookIssuesMilestonedPropIssueAllof1PropReactions(GitHubRestModel):
    """WebhookIssuesMilestonedPropIssueAllof1PropReactions"""

    plus_one: Union[Unset, int] = Field(default=UNSET, alias="+1")
    minus_one: Union[Unset, int] = Field(default=UNSET, alias="-1")
    confused: Union[Unset, int] = Field(default=UNSET)
    eyes: Union[Unset, int] = Field(default=UNSET)
    heart: Union[Unset, int] = Field(default=UNSET)
    hooray: Union[Unset, int] = Field(default=UNSET)
    laugh: Union[Unset, int] = Field(default=UNSET)
    rocket: Union[Unset, int] = Field(default=UNSET)
    total_count: Union[Unset, int] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesMilestonedPropIssueAllof1PropUser(GitHubRestModel):
    """WebhookIssuesMilestonedPropIssueAllof1PropUser"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    login: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesMilestonedPropIssueMergedAssignee(GitHubRestModel):
    """WebhookIssuesMilestonedPropIssueMergedAssignee"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesMilestonedPropIssueMergedAssignees(GitHubRestModel):
    """WebhookIssuesMilestonedPropIssueMergedAssignees"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesMilestonedPropIssueMergedLabels(GitHubRestModel):
    """WebhookIssuesMilestonedPropIssueMergedLabels"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesMilestonedPropIssueMergedPerformedViaGithubApp(GitHubRestModel):
    """WebhookIssuesMilestonedPropIssueMergedPerformedViaGithubApp"""

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesMilestonedPropIssueAllof0PropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset,
        WebhookIssuesMilestonedPropIssueAllof0PropPerformedViaGithubAppPropPermissions,
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesMilestonedPropIssueMergedReactions(GitHubRestModel):
    """WebhookIssuesMilestonedPropIssueMergedReactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesMilestonedPropIssueMergedUser(GitHubRestModel):
    """WebhookIssuesMilestonedPropIssueMergedUser"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesMilestonedPropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[WebhookIssuesMilestonedPropMilestonePropCreator, None] = Field(
        title="User", default=...
    )
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesMilestonedPropMilestonePropCreator(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesOpened(GitHubRestModel):
    """issues opened event"""

    action: Literal["opened"] = Field(default=...)
    changes: Union[Unset, WebhookIssuesOpenedPropChanges] = Field(default=UNSET)
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    issue: WebhookIssuesOpenedPropIssue = Field(default=...)
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookIssuesOpenedPropChanges(GitHubRestModel):
    """WebhookIssuesOpenedPropChanges"""

    old_issue: Union[WebhookIssuesOpenedPropChangesPropOldIssue, None] = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    old_repository: WebhookIssuesOpenedPropChangesPropOldRepository = Field(
        title="Repository", description="A git repository", default=...
    )


class WebhookIssuesOpenedPropChangesPropOldIssuePropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesOpenedPropChangesPropOldIssuePropAssigneesItems(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesOpenedPropChangesPropOldIssuePropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesOpenedPropChangesPropOldIssuePropMilestonePropCreator(
    GitHubRestModel
):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesOpenedPropChangesPropOldIssuePropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssuesOpenedPropChangesPropOldIssuePropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesOpenedPropChangesPropOldIssuePropPerformedViaGithubAppPropOwner(
    GitHubRestModel
):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesOpenedPropChangesPropOldIssuePropPerformedViaGithubAppPropPermissions(
    GitHubRestModel
):
    """WebhookIssuesOpenedPropChangesPropOldIssuePropPerformedViaGithubAppPropPermissio
    ns

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssuesOpenedPropChangesPropOldIssuePropPerformedViaGithubApp(
    GitHubRestModel
):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesOpenedPropChangesPropOldIssuePropPerformedViaGithubAppPropOwner,
        None,
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset,
        WebhookIssuesOpenedPropChangesPropOldIssuePropPerformedViaGithubAppPropPermissions,
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesOpenedPropChangesPropOldIssuePropPullRequest(GitHubRestModel):
    """WebhookIssuesOpenedPropChangesPropOldIssuePropPullRequest"""

    diff_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    patch_url: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesOpenedPropChangesPropOldIssuePropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesOpenedPropChangesPropOldIssuePropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesOpenedPropChangesPropOldIssue(GitHubRestModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesOpenedPropChangesPropOldIssuePropAssignee, None]
    ] = Field(title="User", default=UNSET)
    assignees: List[
        Union[WebhookIssuesOpenedPropChangesPropOldIssuePropAssigneesItems, None]
    ] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[
        Unset, List[WebhookIssuesOpenedPropChangesPropOldIssuePropLabelsItems]
    ] = Field(default=UNSET)
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[
        WebhookIssuesOpenedPropChangesPropOldIssuePropMilestone, None
    ] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset,
        Union[
            WebhookIssuesOpenedPropChangesPropOldIssuePropPerformedViaGithubApp, None
        ],
    ] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[
        Unset, WebhookIssuesOpenedPropChangesPropOldIssuePropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssuesOpenedPropChangesPropOldIssuePropReactions = Field(
        title="Reactions", default=...
    )
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: Union[WebhookIssuesOpenedPropChangesPropOldIssuePropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssuesOpenedPropChangesPropOldRepository(GitHubRestModel):
    """Repository

    A git repository
    """

    allow_auto_merge: Union[Unset, bool] = Field(
        description="Whether to allow auto-merge for pull requests.", default=False
    )
    allow_forking: Union[Unset, bool] = Field(
        description="Whether to allow private forks", default=UNSET
    )
    allow_merge_commit: Union[Unset, bool] = Field(
        description="Whether to allow merge commits for pull requests.", default=True
    )
    allow_rebase_merge: Union[Unset, bool] = Field(
        description="Whether to allow rebase merges for pull requests.", default=True
    )
    allow_squash_merge: Union[Unset, bool] = Field(
        description="Whether to allow squash merges for pull requests.", default=True
    )
    allow_update_branch: Union[Unset, bool] = Field(default=UNSET)
    archive_url: str = Field(default=...)
    archived: bool = Field(
        description="Whether the repository is archived.", default=False
    )
    assignees_url: str = Field(default=...)
    blobs_url: str = Field(default=...)
    branches_url: str = Field(default=...)
    clone_url: str = Field(default=...)
    collaborators_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    compare_url: str = Field(default=...)
    contents_url: str = Field(default=...)
    contributors_url: str = Field(default=...)
    created_at: Union[int, datetime] = Field(default=...)
    default_branch: str = Field(
        description="The default branch of the repository.", default=...
    )
    delete_branch_on_merge: Union[Unset, bool] = Field(
        description="Whether to delete head branches when pull requests are merged",
        default=False,
    )
    deployments_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    disabled: Union[Unset, bool] = Field(
        description="Returns whether or not this repository is disabled.", default=UNSET
    )
    downloads_url: str = Field(default=...)
    events_url: str = Field(default=...)
    fork: bool = Field(default=...)
    forks: int = Field(default=...)
    forks_count: int = Field(default=...)
    forks_url: str = Field(default=...)
    full_name: str = Field(default=...)
    git_commits_url: str = Field(default=...)
    git_refs_url: str = Field(default=...)
    git_tags_url: str = Field(default=...)
    git_url: str = Field(default=...)
    has_downloads: bool = Field(
        description="Whether downloads are enabled.", default=True
    )
    has_issues: bool = Field(description="Whether issues are enabled.", default=True)
    has_pages: bool = Field(default=...)
    has_projects: bool = Field(
        description="Whether projects are enabled.", default=True
    )
    has_wiki: bool = Field(description="Whether the wiki is enabled.", default=True)
    homepage: Union[str, None] = Field(default=...)
    hooks_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(description="Unique identifier of the repository", default=...)
    is_template: Union[Unset, bool] = Field(default=UNSET)
    issue_comment_url: str = Field(default=...)
    issue_events_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    keys_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    language: Union[str, None] = Field(default=...)
    languages_url: str = Field(default=...)
    license_: Union[
        WebhookIssuesOpenedPropChangesPropOldRepositoryPropLicense, None
    ] = Field(title="License", default=..., alias="license")
    master_branch: Union[Unset, str] = Field(default=UNSET)
    merges_url: str = Field(default=...)
    milestones_url: str = Field(default=...)
    mirror_url: Union[str, None] = Field(default=...)
    name: str = Field(description="The name of the repository.", default=...)
    node_id: str = Field(default=...)
    notifications_url: str = Field(default=...)
    open_issues: int = Field(default=...)
    open_issues_count: int = Field(default=...)
    organization: Union[Unset, str] = Field(default=UNSET)
    owner: Union[
        WebhookIssuesOpenedPropChangesPropOldRepositoryPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset, WebhookIssuesOpenedPropChangesPropOldRepositoryPropPermissions
    ] = Field(default=UNSET)
    private: bool = Field(
        description="Whether the repository is private or public.", default=...
    )
    public: Union[Unset, bool] = Field(default=UNSET)
    pulls_url: str = Field(default=...)
    pushed_at: Union[int, datetime, None] = Field(default=...)
    releases_url: str = Field(default=...)
    role_name: Union[Unset, Union[str, None]] = Field(default=UNSET)
    size: int = Field(default=...)
    ssh_url: str = Field(default=...)
    stargazers: Union[Unset, int] = Field(default=UNSET)
    stargazers_count: int = Field(default=...)
    stargazers_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    subscribers_url: str = Field(default=...)
    subscription_url: str = Field(default=...)
    svn_url: str = Field(default=...)
    tags_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    topics: List[str] = Field(default=...)
    trees_url: str = Field(default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)
    visibility: Literal["public", "private", "internal"] = Field(default=...)
    watchers: int = Field(default=...)
    watchers_count: int = Field(default=...)


class WebhookIssuesOpenedPropChangesPropOldRepositoryPropLicense(GitHubRestModel):
    """License"""

    key: str = Field(default=...)
    name: str = Field(default=...)
    node_id: str = Field(default=...)
    spdx_id: str = Field(default=...)
    url: Union[str, None] = Field(default=...)


class WebhookIssuesOpenedPropChangesPropOldRepositoryPropOwner(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesOpenedPropChangesPropOldRepositoryPropPermissions(GitHubRestModel):
    """WebhookIssuesOpenedPropChangesPropOldRepositoryPropPermissions"""

    admin: bool = Field(default=...)
    maintain: Union[Unset, bool] = Field(default=UNSET)
    pull: bool = Field(default=...)
    push: bool = Field(default=...)
    triage: Union[Unset, bool] = Field(default=UNSET)


class WebhookIssuesOpenedPropIssue(GitHubRestModel):
    """WebhookIssuesOpenedPropIssue"""

    active_lock_reason: Union[
        Literal["resolved", "off-topic", "too heated", "spam"], None
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesOpenedPropIssueMergedAssignee, None]
    ] = Field(default=UNSET)
    assignees: List[WebhookIssuesOpenedPropIssueMergedAssignees] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[Union[str, None], None] = Field(
        description="Contents of the issue", default=...
    )
    closed_at: Union[Union[datetime, None], None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[Unset, List[WebhookIssuesOpenedPropIssueMergedLabels]] = Field(
        default=UNSET
    )
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[WebhookIssuesOpenedPropIssueMergedMilestone, None] = Field(
        default=...
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset, Union[WebhookIssuesOpenedPropIssueMergedPerformedViaGithubApp, None]
    ] = Field(default=UNSET)
    pull_request: Union[
        Unset, WebhookIssuesOpenedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssuesOpenedPropIssueMergedReactions = Field(default=...)
    repository_url: str = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'", default=...
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: WebhookIssuesOpenedPropIssueMergedUser = Field(default=...)


class WebhookIssuesOpenedPropIssueAllof0(GitHubRestModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesOpenedPropIssueAllof0PropAssignee, None]
    ] = Field(title="User", default=UNSET)
    assignees: List[
        Union[WebhookIssuesOpenedPropIssueAllof0PropAssigneesItems, None]
    ] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[
        Unset, List[WebhookIssuesOpenedPropIssueAllof0PropLabelsItems]
    ] = Field(default=UNSET)
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[WebhookIssuesOpenedPropIssueAllof0PropMilestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset, Union[WebhookIssuesOpenedPropIssueAllof0PropPerformedViaGithubApp, None]
    ] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[
        Unset, WebhookIssuesOpenedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssuesOpenedPropIssueAllof0PropReactions = Field(
        title="Reactions", default=...
    )
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: Union[WebhookIssuesOpenedPropIssueAllof0PropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssuesOpenedPropIssueAllof0PropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesOpenedPropIssueAllof0PropAssigneesItems(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesOpenedPropIssueAllof0PropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesOpenedPropIssueAllof0PropMilestonePropCreator(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesOpenedPropIssueAllof0PropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssuesOpenedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesOpenedPropIssueAllof0PropPerformedViaGithubAppPropOwner(
    GitHubRestModel
):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesOpenedPropIssueAllof0PropPerformedViaGithubAppPropPermissions(
    GitHubRestModel
):
    """WebhookIssuesOpenedPropIssueAllof0PropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssuesOpenedPropIssueAllof0PropPerformedViaGithubApp(GitHubRestModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "security_and_analysis",
                "pull_request_review_thread",
                "reminder",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesOpenedPropIssueAllof0PropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset,
        WebhookIssuesOpenedPropIssueAllof0PropPerformedViaGithubAppPropPermissions,
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesOpenedPropIssueAllof0PropPullRequest(GitHubRestModel):
    """WebhookIssuesOpenedPropIssueAllof0PropPullRequest"""

    diff_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    patch_url: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesOpenedPropIssueAllof0PropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesOpenedPropIssueAllof0PropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesOpenedPropIssueAllof1(GitHubRestModel):
    """WebhookIssuesOpenedPropIssueAllof1"""

    active_lock_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    assignee: Union[
        Unset, Union[WebhookIssuesOpenedPropIssueAllof1PropAssignee, None]
    ] = Field(default=UNSET)
    assignees: Union[
        Unset, List[Union[WebhookIssuesOpenedPropIssueAllof1PropAssigneesItems, None]]
    ] = Field(default=UNSET)
    author_association: Union[Unset, str] = Field(default=UNSET)
    body: Union[Unset, Union[str, None]] = Field(default=UNSET)
    closed_at: Union[str, None] = Field(default=...)
    comments: Union[Unset, int] = Field(default=UNSET)
    comments_url: Union[Unset, str] = Field(default=UNSET)
    created_at: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    labels: Union[
        Unset, List[Union[WebhookIssuesOpenedPropIssueAllof1PropLabelsItems, None]]
    ] = Field(default=UNSET)
    labels_url: Union[Unset, str] = Field(default=UNSET)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[
        Unset, Union[WebhookIssuesOpenedPropIssueAllof1PropMilestone, None]
    ] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    number: Union[Unset, int] = Field(default=UNSET)
    performed_via_github_app: Union[
        Unset, Union[WebhookIssuesOpenedPropIssueAllof1PropPerformedViaGithubApp, None]
    ] = Field(default=UNSET)
    reactions: Union[Unset, WebhookIssuesOpenedPropIssueAllof1PropReactions] = Field(
        default=UNSET
    )
    repository_url: Union[Unset, str] = Field(default=UNSET)
    state: Literal["open", "closed"] = Field(default=...)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: Union[Unset, str] = Field(default=UNSET)
    updated_at: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    user: Union[Unset, WebhookIssuesOpenedPropIssueAllof1PropUser] = Field(
        default=UNSET
    )


class WebhookIssuesOpenedPropIssueAllof1PropAssignee(GitHubRestModel):
    """WebhookIssuesOpenedPropIssueAllof1PropAssignee"""


class WebhookIssuesOpenedPropIssueAllof1PropAssigneesItems(GitHubRestModel):
    """WebhookIssuesOpenedPropIssueAllof1PropAssigneesItems"""


class WebhookIssuesOpenedPropIssueAllof1PropLabelsItems(GitHubRestModel):
    """WebhookIssuesOpenedPropIssueAllof1PropLabelsItems"""


class WebhookIssuesOpenedPropIssueAllof1PropMilestone(GitHubRestModel):
    """WebhookIssuesOpenedPropIssueAllof1PropMilestone"""


class WebhookIssuesOpenedPropIssueAllof1PropPerformedViaGithubApp(GitHubRestModel):
    """WebhookIssuesOpenedPropIssueAllof1PropPerformedViaGithubApp"""


class WebhookIssuesOpenedPropIssueAllof1PropReactions(GitHubRestModel):
    """WebhookIssuesOpenedPropIssueAllof1PropReactions"""

    plus_one: Union[Unset, int] = Field(default=UNSET, alias="+1")
    minus_one: Union[Unset, int] = Field(default=UNSET, alias="-1")
    confused: Union[Unset, int] = Field(default=UNSET)
    eyes: Union[Unset, int] = Field(default=UNSET)
    heart: Union[Unset, int] = Field(default=UNSET)
    hooray: Union[Unset, int] = Field(default=UNSET)
    laugh: Union[Unset, int] = Field(default=UNSET)
    rocket: Union[Unset, int] = Field(default=UNSET)
    total_count: Union[Unset, int] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesOpenedPropIssueAllof1PropUser(GitHubRestModel):
    """WebhookIssuesOpenedPropIssueAllof1PropUser"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    login: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesOpenedPropIssueMergedAssignee(GitHubRestModel):
    """WebhookIssuesOpenedPropIssueMergedAssignee"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesOpenedPropIssueMergedAssignees(GitHubRestModel):
    """WebhookIssuesOpenedPropIssueMergedAssignees"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesOpenedPropIssueMergedLabels(GitHubRestModel):
    """WebhookIssuesOpenedPropIssueMergedLabels"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesOpenedPropIssueMergedMilestone(GitHubRestModel):
    """WebhookIssuesOpenedPropIssueMergedMilestone"""

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssuesOpenedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesOpenedPropIssueMergedPerformedViaGithubApp(GitHubRestModel):
    """WebhookIssuesOpenedPropIssueMergedPerformedViaGithubApp"""

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "security_and_analysis",
                "pull_request_review_thread",
                "reminder",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesOpenedPropIssueAllof0PropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset,
        WebhookIssuesOpenedPropIssueAllof0PropPerformedViaGithubAppPropPermissions,
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesOpenedPropIssueMergedReactions(GitHubRestModel):
    """WebhookIssuesOpenedPropIssueMergedReactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesOpenedPropIssueMergedUser(GitHubRestModel):
    """WebhookIssuesOpenedPropIssueMergedUser"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesPinned(GitHubRestModel):
    """issues pinned event"""

    action: Literal["pinned"] = Field(default=...)
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    issue: WebhookIssuesPinnedPropIssue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookIssuesPinnedPropIssue(GitHubRestModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesPinnedPropIssuePropAssignee, None]
    ] = Field(title="User", default=UNSET)
    assignees: List[
        Union[WebhookIssuesPinnedPropIssuePropAssigneesItems, None]
    ] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[Unset, List[WebhookIssuesPinnedPropIssuePropLabelsItems]] = Field(
        default=UNSET
    )
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[WebhookIssuesPinnedPropIssuePropMilestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset, Union[WebhookIssuesPinnedPropIssuePropPerformedViaGithubApp, None]
    ] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[Unset, WebhookIssuesPinnedPropIssuePropPullRequest] = Field(
        default=UNSET
    )
    reactions: WebhookIssuesPinnedPropIssuePropReactions = Field(
        title="Reactions", default=...
    )
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: Union[WebhookIssuesPinnedPropIssuePropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssuesPinnedPropIssuePropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesPinnedPropIssuePropAssigneesItems(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesPinnedPropIssuePropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesPinnedPropIssuePropMilestonePropCreator(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesPinnedPropIssuePropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[WebhookIssuesPinnedPropIssuePropMilestonePropCreator, None] = Field(
        title="User", default=...
    )
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesPinnedPropIssuePropPerformedViaGithubAppPropOwner(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesPinnedPropIssuePropPerformedViaGithubAppPropPermissions(
    GitHubRestModel
):
    """WebhookIssuesPinnedPropIssuePropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssuesPinnedPropIssuePropPerformedViaGithubApp(GitHubRestModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesPinnedPropIssuePropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset, WebhookIssuesPinnedPropIssuePropPerformedViaGithubAppPropPermissions
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesPinnedPropIssuePropPullRequest(GitHubRestModel):
    """WebhookIssuesPinnedPropIssuePropPullRequest"""

    diff_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    patch_url: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesPinnedPropIssuePropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesPinnedPropIssuePropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesReopened(GitHubRestModel):
    """issues reopened event"""

    action: Literal["reopened"] = Field(default=...)
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    issue: WebhookIssuesReopenedPropIssue = Field(default=...)
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookIssuesReopenedPropIssue(GitHubRestModel):
    """WebhookIssuesReopenedPropIssue"""

    active_lock_reason: Union[
        Literal["resolved", "off-topic", "too heated", "spam"], None
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesReopenedPropIssueMergedAssignee, None]
    ] = Field(default=UNSET)
    assignees: List[WebhookIssuesReopenedPropIssueMergedAssignees] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[Union[str, None], None] = Field(
        description="Contents of the issue", default=...
    )
    closed_at: Union[Union[datetime, None], None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[Unset, List[WebhookIssuesReopenedPropIssueMergedLabels]] = Field(
        default=UNSET
    )
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[WebhookIssuesReopenedPropIssueMergedMilestone, None] = Field(
        default=...
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset, Union[WebhookIssuesReopenedPropIssueMergedPerformedViaGithubApp, None]
    ] = Field(default=UNSET)
    pull_request: Union[
        Unset, WebhookIssuesReopenedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssuesReopenedPropIssueMergedReactions = Field(default=...)
    repository_url: str = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'", default=...
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: WebhookIssuesReopenedPropIssueMergedUser = Field(default=...)


class WebhookIssuesReopenedPropIssueAllof0(GitHubRestModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesReopenedPropIssueAllof0PropAssignee, None]
    ] = Field(title="User", default=UNSET)
    assignees: List[
        Union[WebhookIssuesReopenedPropIssueAllof0PropAssigneesItems, None]
    ] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[
        Unset, List[WebhookIssuesReopenedPropIssueAllof0PropLabelsItems]
    ] = Field(default=UNSET)
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[WebhookIssuesReopenedPropIssueAllof0PropMilestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset,
        Union[WebhookIssuesReopenedPropIssueAllof0PropPerformedViaGithubApp, None],
    ] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[
        Unset, WebhookIssuesReopenedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssuesReopenedPropIssueAllof0PropReactions = Field(
        title="Reactions", default=...
    )
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: Union[WebhookIssuesReopenedPropIssueAllof0PropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssuesReopenedPropIssueAllof0PropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesReopenedPropIssueAllof0PropAssigneesItems(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesReopenedPropIssueAllof0PropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesReopenedPropIssueAllof0PropMilestonePropCreator(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesReopenedPropIssueAllof0PropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssuesReopenedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesReopenedPropIssueAllof0PropPerformedViaGithubAppPropOwner(
    GitHubRestModel
):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesReopenedPropIssueAllof0PropPerformedViaGithubAppPropPermissions(
    GitHubRestModel
):
    """WebhookIssuesReopenedPropIssueAllof0PropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssuesReopenedPropIssueAllof0PropPerformedViaGithubApp(GitHubRestModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "pull_request_review_thread",
                "reminder",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesReopenedPropIssueAllof0PropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset,
        WebhookIssuesReopenedPropIssueAllof0PropPerformedViaGithubAppPropPermissions,
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesReopenedPropIssueAllof0PropPullRequest(GitHubRestModel):
    """WebhookIssuesReopenedPropIssueAllof0PropPullRequest"""

    diff_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    patch_url: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesReopenedPropIssueAllof0PropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesReopenedPropIssueAllof0PropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesReopenedPropIssueAllof1(GitHubRestModel):
    """WebhookIssuesReopenedPropIssueAllof1"""

    active_lock_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    assignee: Union[
        Unset, Union[WebhookIssuesReopenedPropIssueAllof1PropAssignee, None]
    ] = Field(default=UNSET)
    assignees: Union[
        Unset, List[Union[WebhookIssuesReopenedPropIssueAllof1PropAssigneesItems, None]]
    ] = Field(default=UNSET)
    author_association: Union[Unset, str] = Field(default=UNSET)
    body: Union[Unset, Union[str, None]] = Field(default=UNSET)
    closed_at: Union[Unset, Union[str, None]] = Field(default=UNSET)
    comments: Union[Unset, int] = Field(default=UNSET)
    comments_url: Union[Unset, str] = Field(default=UNSET)
    created_at: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    labels: Union[
        Unset, List[Union[WebhookIssuesReopenedPropIssueAllof1PropLabelsItems, None]]
    ] = Field(default=UNSET)
    labels_url: Union[Unset, str] = Field(default=UNSET)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[
        Unset, Union[WebhookIssuesReopenedPropIssueAllof1PropMilestone, None]
    ] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    number: Union[Unset, int] = Field(default=UNSET)
    performed_via_github_app: Union[
        Unset,
        Union[WebhookIssuesReopenedPropIssueAllof1PropPerformedViaGithubApp, None],
    ] = Field(default=UNSET)
    reactions: Union[Unset, WebhookIssuesReopenedPropIssueAllof1PropReactions] = Field(
        default=UNSET
    )
    repository_url: Union[Unset, str] = Field(default=UNSET)
    state: Literal["open", "closed"] = Field(default=...)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: Union[Unset, str] = Field(default=UNSET)
    updated_at: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)
    user: Union[Unset, WebhookIssuesReopenedPropIssueAllof1PropUser] = Field(
        default=UNSET
    )


class WebhookIssuesReopenedPropIssueAllof1PropAssignee(GitHubRestModel):
    """WebhookIssuesReopenedPropIssueAllof1PropAssignee"""


class WebhookIssuesReopenedPropIssueAllof1PropAssigneesItems(GitHubRestModel):
    """WebhookIssuesReopenedPropIssueAllof1PropAssigneesItems"""


class WebhookIssuesReopenedPropIssueAllof1PropLabelsItems(GitHubRestModel):
    """WebhookIssuesReopenedPropIssueAllof1PropLabelsItems"""


class WebhookIssuesReopenedPropIssueAllof1PropMilestone(GitHubRestModel):
    """WebhookIssuesReopenedPropIssueAllof1PropMilestone"""


class WebhookIssuesReopenedPropIssueAllof1PropPerformedViaGithubApp(GitHubRestModel):
    """WebhookIssuesReopenedPropIssueAllof1PropPerformedViaGithubApp"""


class WebhookIssuesReopenedPropIssueAllof1PropReactions(GitHubRestModel):
    """WebhookIssuesReopenedPropIssueAllof1PropReactions"""

    plus_one: Union[Unset, int] = Field(default=UNSET, alias="+1")
    minus_one: Union[Unset, int] = Field(default=UNSET, alias="-1")
    confused: Union[Unset, int] = Field(default=UNSET)
    eyes: Union[Unset, int] = Field(default=UNSET)
    heart: Union[Unset, int] = Field(default=UNSET)
    hooray: Union[Unset, int] = Field(default=UNSET)
    laugh: Union[Unset, int] = Field(default=UNSET)
    rocket: Union[Unset, int] = Field(default=UNSET)
    total_count: Union[Unset, int] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesReopenedPropIssueAllof1PropUser(GitHubRestModel):
    """WebhookIssuesReopenedPropIssueAllof1PropUser"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: Union[Unset, int] = Field(default=UNSET)
    login: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesReopenedPropIssueMergedAssignee(GitHubRestModel):
    """WebhookIssuesReopenedPropIssueMergedAssignee"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesReopenedPropIssueMergedAssignees(GitHubRestModel):
    """WebhookIssuesReopenedPropIssueMergedAssignees"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesReopenedPropIssueMergedLabels(GitHubRestModel):
    """WebhookIssuesReopenedPropIssueMergedLabels"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesReopenedPropIssueMergedMilestone(GitHubRestModel):
    """WebhookIssuesReopenedPropIssueMergedMilestone"""

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssuesReopenedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesReopenedPropIssueMergedPerformedViaGithubApp(GitHubRestModel):
    """WebhookIssuesReopenedPropIssueMergedPerformedViaGithubApp"""

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "pull_request_review_thread",
                "reminder",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesReopenedPropIssueAllof0PropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset,
        WebhookIssuesReopenedPropIssueAllof0PropPerformedViaGithubAppPropPermissions,
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesReopenedPropIssueMergedReactions(GitHubRestModel):
    """WebhookIssuesReopenedPropIssueMergedReactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesReopenedPropIssueMergedUser(GitHubRestModel):
    """WebhookIssuesReopenedPropIssueMergedUser"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesTransferred(GitHubRestModel):
    """issues transferred event"""

    action: Literal["transferred"] = Field(default=...)
    changes: WebhookIssuesTransferredPropChanges = Field(default=...)
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    issue: WebhookIssuesTransferredPropIssue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookIssuesTransferredPropChanges(GitHubRestModel):
    """WebhookIssuesTransferredPropChanges"""

    new_issue: WebhookIssuesTransferredPropChangesPropNewIssue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    new_repository: WebhookIssuesTransferredPropChangesPropNewRepository = Field(
        title="Repository", description="A git repository", default=...
    )


class WebhookIssuesTransferredPropChangesPropNewIssue(GitHubRestModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesTransferredPropChangesPropNewIssuePropAssignee, None]
    ] = Field(title="User", default=UNSET)
    assignees: List[
        Union[WebhookIssuesTransferredPropChangesPropNewIssuePropAssigneesItems, None]
    ] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[
        Unset, List[WebhookIssuesTransferredPropChangesPropNewIssuePropLabelsItems]
    ] = Field(default=UNSET)
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[
        WebhookIssuesTransferredPropChangesPropNewIssuePropMilestone, None
    ] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset,
        Union[
            WebhookIssuesTransferredPropChangesPropNewIssuePropPerformedViaGithubApp,
            None,
        ],
    ] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[
        Unset, WebhookIssuesTransferredPropChangesPropNewIssuePropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssuesTransferredPropChangesPropNewIssuePropReactions = Field(
        title="Reactions", default=...
    )
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: Union[WebhookIssuesTransferredPropChangesPropNewIssuePropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssuesTransferredPropChangesPropNewIssuePropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesTransferredPropChangesPropNewIssuePropAssigneesItems(
    GitHubRestModel
):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesTransferredPropChangesPropNewIssuePropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesTransferredPropChangesPropNewIssuePropMilestonePropCreator(
    GitHubRestModel
):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesTransferredPropChangesPropNewIssuePropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssuesTransferredPropChangesPropNewIssuePropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesTransferredPropChangesPropNewIssuePropPerformedViaGithubAppPropOwner(
    GitHubRestModel
):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesTransferredPropChangesPropNewIssuePropPerformedViaGithubAppPropPermissions(
    GitHubRestModel
):
    """WebhookIssuesTransferredPropChangesPropNewIssuePropPerformedViaGithubAppPropPerm
    issions

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssuesTransferredPropChangesPropNewIssuePropPerformedViaGithubApp(
    GitHubRestModel
):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesTransferredPropChangesPropNewIssuePropPerformedViaGithubAppPropOwner,
        None,
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset,
        WebhookIssuesTransferredPropChangesPropNewIssuePropPerformedViaGithubAppPropPermissions,
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesTransferredPropChangesPropNewIssuePropPullRequest(GitHubRestModel):
    """WebhookIssuesTransferredPropChangesPropNewIssuePropPullRequest"""

    diff_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    patch_url: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesTransferredPropChangesPropNewIssuePropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesTransferredPropChangesPropNewIssuePropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesTransferredPropChangesPropNewRepository(GitHubRestModel):
    """Repository

    A git repository
    """

    allow_auto_merge: Union[Unset, bool] = Field(
        description="Whether to allow auto-merge for pull requests.", default=False
    )
    allow_forking: Union[Unset, bool] = Field(
        description="Whether to allow private forks", default=UNSET
    )
    allow_merge_commit: Union[Unset, bool] = Field(
        description="Whether to allow merge commits for pull requests.", default=True
    )
    allow_rebase_merge: Union[Unset, bool] = Field(
        description="Whether to allow rebase merges for pull requests.", default=True
    )
    allow_squash_merge: Union[Unset, bool] = Field(
        description="Whether to allow squash merges for pull requests.", default=True
    )
    allow_update_branch: Union[Unset, bool] = Field(default=UNSET)
    archive_url: str = Field(default=...)
    archived: bool = Field(
        description="Whether the repository is archived.", default=False
    )
    assignees_url: str = Field(default=...)
    blobs_url: str = Field(default=...)
    branches_url: str = Field(default=...)
    clone_url: str = Field(default=...)
    collaborators_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    compare_url: str = Field(default=...)
    contents_url: str = Field(default=...)
    contributors_url: str = Field(default=...)
    created_at: Union[int, datetime] = Field(default=...)
    default_branch: str = Field(
        description="The default branch of the repository.", default=...
    )
    delete_branch_on_merge: Union[Unset, bool] = Field(
        description="Whether to delete head branches when pull requests are merged",
        default=False,
    )
    deployments_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    disabled: Union[Unset, bool] = Field(
        description="Returns whether or not this repository is disabled.", default=UNSET
    )
    downloads_url: str = Field(default=...)
    events_url: str = Field(default=...)
    fork: bool = Field(default=...)
    forks: int = Field(default=...)
    forks_count: int = Field(default=...)
    forks_url: str = Field(default=...)
    full_name: str = Field(default=...)
    git_commits_url: str = Field(default=...)
    git_refs_url: str = Field(default=...)
    git_tags_url: str = Field(default=...)
    git_url: str = Field(default=...)
    has_downloads: bool = Field(
        description="Whether downloads are enabled.", default=True
    )
    has_issues: bool = Field(description="Whether issues are enabled.", default=True)
    has_pages: bool = Field(default=...)
    has_projects: bool = Field(
        description="Whether projects are enabled.", default=True
    )
    has_wiki: bool = Field(description="Whether the wiki is enabled.", default=True)
    homepage: Union[str, None] = Field(default=...)
    hooks_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(description="Unique identifier of the repository", default=...)
    is_template: Union[Unset, bool] = Field(default=UNSET)
    issue_comment_url: str = Field(default=...)
    issue_events_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    keys_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    language: Union[str, None] = Field(default=...)
    languages_url: str = Field(default=...)
    license_: Union[
        WebhookIssuesTransferredPropChangesPropNewRepositoryPropLicense, None
    ] = Field(title="License", default=..., alias="license")
    master_branch: Union[Unset, str] = Field(default=UNSET)
    merges_url: str = Field(default=...)
    milestones_url: str = Field(default=...)
    mirror_url: Union[str, None] = Field(default=...)
    name: str = Field(description="The name of the repository.", default=...)
    node_id: str = Field(default=...)
    notifications_url: str = Field(default=...)
    open_issues: int = Field(default=...)
    open_issues_count: int = Field(default=...)
    organization: Union[Unset, str] = Field(default=UNSET)
    owner: Union[
        WebhookIssuesTransferredPropChangesPropNewRepositoryPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset, WebhookIssuesTransferredPropChangesPropNewRepositoryPropPermissions
    ] = Field(default=UNSET)
    private: bool = Field(
        description="Whether the repository is private or public.", default=...
    )
    public: Union[Unset, bool] = Field(default=UNSET)
    pulls_url: str = Field(default=...)
    pushed_at: Union[int, datetime, None] = Field(default=...)
    releases_url: str = Field(default=...)
    role_name: Union[Unset, Union[str, None]] = Field(default=UNSET)
    size: int = Field(default=...)
    ssh_url: str = Field(default=...)
    stargazers: Union[Unset, int] = Field(default=UNSET)
    stargazers_count: int = Field(default=...)
    stargazers_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    subscribers_url: str = Field(default=...)
    subscription_url: str = Field(default=...)
    svn_url: str = Field(default=...)
    tags_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    topics: List[str] = Field(default=...)
    trees_url: str = Field(default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)
    visibility: Literal["public", "private", "internal"] = Field(default=...)
    watchers: int = Field(default=...)
    watchers_count: int = Field(default=...)
    web_commit_signoff_required: Union[Unset, bool] = Field(
        description="Whether to require contributors to sign off on web-based commits",
        default=UNSET,
    )


class WebhookIssuesTransferredPropChangesPropNewRepositoryPropLicense(GitHubRestModel):
    """License"""

    key: str = Field(default=...)
    name: str = Field(default=...)
    node_id: str = Field(default=...)
    spdx_id: str = Field(default=...)
    url: Union[str, None] = Field(default=...)


class WebhookIssuesTransferredPropChangesPropNewRepositoryPropOwner(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesTransferredPropChangesPropNewRepositoryPropPermissions(
    GitHubRestModel
):
    """WebhookIssuesTransferredPropChangesPropNewRepositoryPropPermissions"""

    admin: bool = Field(default=...)
    maintain: Union[Unset, bool] = Field(default=UNSET)
    pull: bool = Field(default=...)
    push: bool = Field(default=...)
    triage: Union[Unset, bool] = Field(default=UNSET)


class WebhookIssuesTransferredPropIssue(GitHubRestModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesTransferredPropIssuePropAssignee, None]
    ] = Field(title="User", default=UNSET)
    assignees: List[
        Union[WebhookIssuesTransferredPropIssuePropAssigneesItems, None]
    ] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[
        Unset, List[WebhookIssuesTransferredPropIssuePropLabelsItems]
    ] = Field(default=UNSET)
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[WebhookIssuesTransferredPropIssuePropMilestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset, Union[WebhookIssuesTransferredPropIssuePropPerformedViaGithubApp, None]
    ] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[
        Unset, WebhookIssuesTransferredPropIssuePropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssuesTransferredPropIssuePropReactions = Field(
        title="Reactions", default=...
    )
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: Union[WebhookIssuesTransferredPropIssuePropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssuesTransferredPropIssuePropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesTransferredPropIssuePropAssigneesItems(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesTransferredPropIssuePropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesTransferredPropIssuePropMilestonePropCreator(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesTransferredPropIssuePropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssuesTransferredPropIssuePropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesTransferredPropIssuePropPerformedViaGithubAppPropOwner(
    GitHubRestModel
):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesTransferredPropIssuePropPerformedViaGithubAppPropPermissions(
    GitHubRestModel
):
    """WebhookIssuesTransferredPropIssuePropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssuesTransferredPropIssuePropPerformedViaGithubApp(GitHubRestModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesTransferredPropIssuePropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset, WebhookIssuesTransferredPropIssuePropPerformedViaGithubAppPropPermissions
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesTransferredPropIssuePropPullRequest(GitHubRestModel):
    """WebhookIssuesTransferredPropIssuePropPullRequest"""

    diff_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    patch_url: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesTransferredPropIssuePropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesTransferredPropIssuePropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesUnassigned(GitHubRestModel):
    """issues unassigned event"""

    action: Literal["unassigned"] = Field(
        description="The action that was performed.", default=...
    )
    assignee: Union[Unset, Union[WebhookIssuesUnassignedPropAssignee, None]] = Field(
        title="User", default=UNSET
    )
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    issue: WebhookIssuesUnassignedPropIssue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookIssuesUnassignedPropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesUnassignedPropIssue(GitHubRestModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesUnassignedPropIssuePropAssignee, None]
    ] = Field(title="User", default=UNSET)
    assignees: List[
        Union[WebhookIssuesUnassignedPropIssuePropAssigneesItems, None]
    ] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[Unset, List[WebhookIssuesUnassignedPropIssuePropLabelsItems]] = Field(
        default=UNSET
    )
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[WebhookIssuesUnassignedPropIssuePropMilestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset, Union[WebhookIssuesUnassignedPropIssuePropPerformedViaGithubApp, None]
    ] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[Unset, WebhookIssuesUnassignedPropIssuePropPullRequest] = Field(
        default=UNSET
    )
    reactions: WebhookIssuesUnassignedPropIssuePropReactions = Field(
        title="Reactions", default=...
    )
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: Union[WebhookIssuesUnassignedPropIssuePropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssuesUnassignedPropIssuePropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesUnassignedPropIssuePropAssigneesItems(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesUnassignedPropIssuePropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesUnassignedPropIssuePropMilestonePropCreator(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesUnassignedPropIssuePropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssuesUnassignedPropIssuePropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesUnassignedPropIssuePropPerformedViaGithubAppPropOwner(
    GitHubRestModel
):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesUnassignedPropIssuePropPerformedViaGithubAppPropPermissions(
    GitHubRestModel
):
    """WebhookIssuesUnassignedPropIssuePropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssuesUnassignedPropIssuePropPerformedViaGithubApp(GitHubRestModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "pull_request_review_thread",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesUnassignedPropIssuePropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset, WebhookIssuesUnassignedPropIssuePropPerformedViaGithubAppPropPermissions
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesUnassignedPropIssuePropPullRequest(GitHubRestModel):
    """WebhookIssuesUnassignedPropIssuePropPullRequest"""

    diff_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    patch_url: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesUnassignedPropIssuePropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesUnassignedPropIssuePropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesUnlabeled(GitHubRestModel):
    """issues unlabeled event"""

    action: Literal["unlabeled"] = Field(default=...)
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    issue: WebhookIssuesUnlabeledPropIssue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    label: Union[Unset, WebhookIssuesUnlabeledPropLabel] = Field(
        title="Label", default=UNSET
    )
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookIssuesUnlabeledPropIssue(GitHubRestModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesUnlabeledPropIssuePropAssignee, None]
    ] = Field(title="User", default=UNSET)
    assignees: List[
        Union[WebhookIssuesUnlabeledPropIssuePropAssigneesItems, None]
    ] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[Unset, List[WebhookIssuesUnlabeledPropIssuePropLabelsItems]] = Field(
        default=UNSET
    )
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[WebhookIssuesUnlabeledPropIssuePropMilestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset, Union[WebhookIssuesUnlabeledPropIssuePropPerformedViaGithubApp, None]
    ] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[Unset, WebhookIssuesUnlabeledPropIssuePropPullRequest] = Field(
        default=UNSET
    )
    reactions: WebhookIssuesUnlabeledPropIssuePropReactions = Field(
        title="Reactions", default=...
    )
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: Union[WebhookIssuesUnlabeledPropIssuePropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssuesUnlabeledPropIssuePropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesUnlabeledPropIssuePropAssigneesItems(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesUnlabeledPropIssuePropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesUnlabeledPropIssuePropMilestonePropCreator(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesUnlabeledPropIssuePropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssuesUnlabeledPropIssuePropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesUnlabeledPropIssuePropPerformedViaGithubAppPropOwner(
    GitHubRestModel
):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesUnlabeledPropIssuePropPerformedViaGithubAppPropPermissions(
    GitHubRestModel
):
    """WebhookIssuesUnlabeledPropIssuePropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssuesUnlabeledPropIssuePropPerformedViaGithubApp(GitHubRestModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "pull_request_review_thread",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)
    external_url: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: Union[int, None] = Field(
        description="Unique identifier of the GitHub app", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    node_id: str = Field(default=...)
    owner: Union[
        WebhookIssuesUnlabeledPropIssuePropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User", default=...)
    permissions: Union[
        Unset, WebhookIssuesUnlabeledPropIssuePropPerformedViaGithubAppPropPermissions
    ] = Field(description="The set of permissions for the GitHub app", default=UNSET)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    updated_at: Union[datetime, None] = Field(default=...)


class WebhookIssuesUnlabeledPropIssuePropPullRequest(GitHubRestModel):
    """WebhookIssuesUnlabeledPropIssuePropPullRequest"""

    diff_url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)
    patch_url: Union[Unset, str] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesUnlabeledPropIssuePropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesUnlabeledPropIssuePropUser(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesUnlabeledPropLabel(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesUnlocked(GitHubRestModel):
    """issues unlocked event"""

    action: Literal["unlocked"] = Field(default=...)
    enterprise: Union[Unset, Enterprise] = Field(
        title="Enterprise", description="An enterprise account", default=UNSET
    )
    installation: Union[Unset, SimpleInstallation] = Field(
        title="Simple Installation", description="Simple Installation", default=UNSET
    )
    issue: WebhookIssuesUnlockedPropIssue = Field(default=...)
    organization: Union[Unset, OrganizationSimple] = Field(
        title="Organization Simple", description="Organization Simple", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: SimpleUser = Field(
        title="Simple User", description="Simple User", default=...
    )


class WebhookIssuesUnlockedPropIssue(GitHubRestModel):
    """WebhookIssuesUnlockedPropIssue"""

    active_lock_reason: Union[None, None] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesUnlockedPropIssueMergedAssignee, None]
    ] = Field(default=UNSET)
    assignees: List[WebhookIssuesUnlockedPropIssueMergedAssignees] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[Union[str, None], None] = Field(
        description="Contents of the issue", default=...
    )
    closed_at: Union[Union[datetime, None], None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[Unset, List[WebhookIssuesUnlockedPropIssueMergedLabels]] = Field(
        default=UNSET
    )
    labels_url: str = Field(default=...)
    locked: Literal[False] = Field(default=...)
    milestone: Union[WebhookIssuesUnlockedPropIssueMergedMilestone, None] = Field(
        default=...
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[Unset, Union[None, None]] = Field(default=UNSET)
    pull_request: Union[
        Unset, WebhookIssuesUnlockedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssuesUnlockedPropIssueMergedReactions = Field(default=...)
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: WebhookIssuesUnlockedPropIssueMergedUser = Field(default=...)


class WebhookIssuesUnlockedPropIssueAllof0(GitHubRestModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    assignee: Union[
        Unset, Union[WebhookIssuesUnlockedPropIssueAllof0PropAssignee, None]
    ] = Field(title="User", default=UNSET)
    assignees: List[
        Union[WebhookIssuesUnlockedPropIssueAllof0PropAssigneesItems, None]
    ] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    comments: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels: Union[
        Unset, List[WebhookIssuesUnlockedPropIssueAllof0PropLabelsItems]
    ] = Field(default=UNSET)
    labels_url: str = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    milestone: Union[WebhookIssuesUnlockedPropIssueAllof0PropMilestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    performed_via_github_app: Union[
        Unset,
        Union[WebhookIssuesUnlockedPropIssueAllof0PropPerformedViaGithubApp, None],
    ] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[
        Unset, WebhookIssuesUnlockedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssuesUnlockedPropIssueAllof0PropReactions = Field(
        title="Reactions", default=...
    )
    repository_url: str = Field(default=...)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    state_reason: Union[Unset, Union[str, None]] = Field(default=UNSET)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    user: Union[WebhookIssuesUnlockedPropIssueAllof0PropUser, None] = Field(
        title="User", default=...
    )


class WebhookIssuesUnlockedPropIssueAllof0PropAssignee(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesUnlockedPropIssueAllof0PropAssigneesItems(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesUnlockedPropIssueAllof0PropLabelsItems(GitHubRestModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(description="The name of the label.", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)


class WebhookIssuesUnlockedPropIssueAllof0PropMilestonePropCreator(GitHubRestModel):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesUnlockedPropIssueAllof0PropMilestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    creator: Union[
        WebhookIssuesUnlockedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User", default=...)
    description: Union[str, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    labels_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    open_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    title: str = Field(description="The title of the milestone.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class WebhookIssuesUnlockedPropIssueAllof0PropPerformedViaGithubAppPropOwner(
    GitHubRestModel
):
    """User"""

    avatar_url: Union[Unset, str] = Field(default=UNSET)
    deleted: Union[Unset, bool] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    events_url: Union[Unset, str] = Field(default=UNSET)
    followers_url: Union[Unset, str] = Field(default=UNSET)
    following_url: Union[Unset, str] = Field(default=UNSET)
    gists_url: Union[Unset, str] = Field(default=UNSET)
    gravatar_id: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    node_id: Union[Unset, str] = Field(default=UNSET)
    organizations_url: Union[Unset, str] = Field(default=UNSET)
    received_events_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: Union[Unset, str] = Field(default=UNSET)
    site_admin: Union[Unset, bool] = Field(default=UNSET)
    starred_url: Union[Unset, str] = Field(default=UNSET)
    subscriptions_url: Union[Unset, str] = Field(default=UNSET)
    type: Union[Unset, Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Union[Unset, str] = Field(default=UNSET)


class WebhookIssuesUnlockedPropIssueAllof0PropPerformedViaGithubAppPropPermissions(
    GitHubRestModel
):
    """WebhookIssuesUnlockedPropIssueAllof0PropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssuesUnlockedPropIssueAllof0PropPerformedViaGithubApp(GitHubRestModel):
    """App

    GitHub apps a