"""DO NOT EDIT THIS FILE!

This file is auto generated by github webhook schema.
See https://github.com/octokit/webhooks for more information.
"""


from __future__ import annotations

from datetime import datetime
from typing import Any, List, Union, Literal

from pydantic import Extra, Field, BaseModel

from githubkit.utils import UNSET, Unset


class GitHubWebhookModel(BaseModel, allow_population_by_field_name=True):
    ...


class BranchProtectionRuleCreated(GitHubWebhookModel):
    """branch protection rule created event

    Activity related to a branch protection rule. For more information, see "[About
    branch protection rules](https://docs.github.com/en/github/administering-a-
    repository/defining-the-mergeability-of-pull-requests/about-protected-
    branches#about-branch-protection-rules)."
    """

    action: Literal["created"] = Field(default=...)
    rule: BranchProtectionRule = Field(
        title="branch protection rule",
        description="The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/en/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class BranchProtectionRule(GitHubWebhookModel):
    """branch protection rule

    The branch protection rule. Includes a `name` and all the [branch protection
    settings](https://docs.github.com/en/github/administering-a-repository/defining-
    the-mergeability-of-pull-requests/about-protected-branches#about-branch-
    protection-settings) applied to branches that match the name. Binary settings
    are boolean. Multi-level configurations are one of `off`, `non_admins`, or
    `everyone`. Actor and build lists are arrays of strings.
    """

    id: int = Field(default=...)
    repository_id: int = Field(default=...)
    name: str = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    pull_request_reviews_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(title="Branch protection rule enforcement level", default=...)
    required_approving_review_count: int = Field(
        title="Branch protection rule number", default=...
    )
    dismiss_stale_reviews_on_push: bool = Field(
        title="Branch protection rule boolean", default=...
    )
    require_code_owner_review: bool = Field(
        title="Branch protection rule boolean", default=...
    )
    authorized_dismissal_actors_only: bool = Field(
        title="Branch protection rule boolean", default=...
    )
    ignore_approvals_from_contributors: bool = Field(
        title="Branch protection rule boolean", default=...
    )
    required_status_checks: List[str] = Field(
        title="Branch Protection Rule Array", default=...
    )
    required_status_checks_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(title="Branch protection rule enforcement level", default=...)
    strict_required_status_checks_policy: bool = Field(
        title="Branch protection rule boolean", default=...
    )
    signature_requirement_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(title="Branch protection rule enforcement level", default=...)
    linear_history_requirement_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(title="Branch protection rule enforcement level", default=...)
    admin_enforced: bool = Field(title="Branch protection rule boolean", default=...)
    create_protected: Union[Unset, bool] = Field(
        title="Branch protection rule boolean", default=UNSET
    )
    allow_force_pushes_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(title="Branch protection rule enforcement level", default=...)
    allow_deletions_enforcement_level: Literal["off", "non_admins", "everyone"] = Field(
        title="Branch protection rule enforcement level", default=...
    )
    merge_queue_enforcement_level: Literal["off", "non_admins", "everyone"] = Field(
        title="Branch protection rule enforcement level", default=...
    )
    required_deployments_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(title="Branch protection rule enforcement level", default=...)
    required_conversation_resolution_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field(title="Branch protection rule enforcement level", default=...)
    authorized_actors_only: bool = Field(
        title="Branch protection rule boolean", default=...
    )
    authorized_actor_names: List[str] = Field(
        title="Branch Protection Rule Array", default=...
    )


class Repository(GitHubWebhookModel):
    """Repository

    A git repository
    """

    id: int = Field(description="Unique identifier of the repository", default=...)
    node_id: str = Field(
        description="The GraphQL identifier of the repository.", default=...
    )
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(
        description="The full, globally unique, name of the repository.", default=...
    )
    private: bool = Field(
        description="Whether the repository is private or public.", default=...
    )
    owner: User = Field(title="User", default=...)
    html_url: str = Field(
        description="The URL to view the repository on GitHub.com.", default=...
    )
    description: Union[str, None] = Field(
        description="The repository description.", default=...
    )
    fork: bool = Field(description="Whether the repository is a fork.", default=...)
    url: str = Field(
        description="The URL to get more information about the repository from the GitHub API.",
        default=...,
    )
    forks_url: str = Field(
        description="The API URL to list the forks of the repository.", default=...
    )
    keys_url: str = Field(
        description="A template for the API URL to get information about deploy keys on the repository.",
        default=...,
    )
    collaborators_url: str = Field(
        description="A template for the API URL to get information about collaborators of the repository.",
        default=...,
    )
    teams_url: str = Field(
        description="The API URL to list the teams on the repository.", default=...
    )
    hooks_url: str = Field(
        description="The API URL to list the hooks on the repository.", default=...
    )
    issue_events_url: str = Field(
        description="A template for the API URL to get information about issue events on the repository.",
        default=...,
    )
    events_url: str = Field(
        description="The API URL to list the events of the repository.", default=...
    )
    assignees_url: str = Field(
        description="A template for the API URL to list the available assignees for issues in the repository.",
        default=...,
    )
    branches_url: str = Field(
        description="A template for the API URL to get information about branches in the repository.",
        default=...,
    )
    tags_url: str = Field(
        description="The API URL to get information about tags on the repository.",
        default=...,
    )
    blobs_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git blob in the repository.",
        default=...,
    )
    git_tags_url: str = Field(
        description="A template for the API URL to get information about Git tags of the repository.",
        default=...,
    )
    git_refs_url: str = Field(
        description="A template for the API URL to get information about Git refs of the repository.",
        default=...,
    )
    trees_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git tree of the repository.",
        default=...,
    )
    statuses_url: str = Field(
        description="A template for the API URL to get information about statuses of a commit.",
        default=...,
    )
    languages_url: str = Field(
        description="The API URL to get information about the languages of the repository.",
        default=...,
    )
    stargazers_url: str = Field(
        description="The API URL to list the stargazers on the repository.", default=...
    )
    contributors_url: str = Field(
        description="A template for the API URL to list the contributors to the repository.",
        default=...,
    )
    subscribers_url: str = Field(
        description="The API URL to list the subscribers on the repository.",
        default=...,
    )
    subscription_url: str = Field(
        description="The API URL to subscribe to notifications for this repository.",
        default=...,
    )
    commits_url: str = Field(
        description="A template for the API URL to get information about commits on the repository.",
        default=...,
    )
    git_commits_url: str = Field(
        description="A template for the API URL to get information about Git commits of the repository.",
        default=...,
    )
    comments_url: str = Field(
        description="A template for the API URL to get information about comments on the repository.",
        default=...,
    )
    issue_comment_url: str = Field(
        description="A template for the API URL to get information about issue comments on the repository.",
        default=...,
    )
    contents_url: str = Field(
        description="A template for the API URL to get the contents of the repository.",
        default=...,
    )
    compare_url: str = Field(
        description="A template for the API URL to compare two commits or refs.",
        default=...,
    )
    merges_url: str = Field(
        description="The API URL to merge branches in the repository.", default=...
    )
    archive_url: str = Field(
        description="A template for the API URL to download the repository as an archive.",
        default=...,
    )
    downloads_url: str = Field(
        description="The API URL to list the downloads on the repository.", default=...
    )
    issues_url: str = Field(
        description="A template for the API URL to get information about issues on the repository.",
        default=...,
    )
    pulls_url: str = Field(
        description="A template for the API URL to get information about pull requests on the repository.",
        default=...,
    )
    milestones_url: str = Field(
        description="A template for the API URL to get information about milestones of the repository.",
        default=...,
    )
    notifications_url: str = Field(
        description="A template for the API URL to get information about notifications on the repository.",
        default=...,
    )
    labels_url: str = Field(
        description="A template for the API URL to get information about labels of the repository.",
        default=...,
    )
    releases_url: str = Field(
        description="A template for the API URL to get information about releases on the repository.",
        default=...,
    )
    deployments_url: str = Field(
        description="The API URL to list the deployments of the repository.",
        default=...,
    )
    created_at: Union[int, datetime] = Field(default=...)
    updated_at: datetime = Field(default=...)
    pushed_at: Union[int, datetime, None] = Field(default=...)
    git_url: str = Field(default=...)
    ssh_url: str = Field(default=...)
    clone_url: str = Field(default=...)
    svn_url: str = Field(default=...)
    homepage: Union[str, None] = Field(default=...)
    size: int = Field(default=...)
    stargazers_count: int = Field(default=...)
    watchers_count: int = Field(default=...)
    language: Union[str, None] = Field(default=...)
    has_issues: bool = Field(description="Whether issues are enabled.", default=True)
    has_projects: bool = Field(
        description="Whether projects are enabled.", default=True
    )
    has_downloads: bool = Field(
        description="Whether downloads are enabled.", default=True
    )
    has_wiki: bool = Field(description="Whether the wiki is enabled.", default=True)
    has_pages: bool = Field(default=...)
    forks_count: int = Field(default=...)
    mirror_url: Union[str, None] = Field(default=...)
    archived: bool = Field(
        description="Whether the repository is archived.", default=False
    )
    disabled: Union[Unset, bool] = Field(
        description="Returns whether or not this repository is disabled.", default=UNSET
    )
    open_issues_count: int = Field(default=...)
    license_: Union[License, None] = Field(
        title="License", default=..., alias="license"
    )
    forks: int = Field(default=...)
    open_issues: int = Field(default=...)
    watchers: int = Field(default=...)
    stargazers: Union[Unset, int] = Field(default=UNSET)
    default_branch: str = Field(
        description="The default branch of the repository.", default=...
    )
    allow_squash_merge: Union[Unset, bool] = Field(
        description="Whether to allow squash merges for pull requests.", default=True
    )
    allow_merge_commit: Union[Unset, bool] = Field(
        description="Whether to allow merge commits for pull requests.", default=True
    )
    allow_rebase_merge: Union[Unset, bool] = Field(
        description="Whether to allow rebase merges for pull requests.", default=True
    )
    allow_auto_merge: Union[Unset, bool] = Field(
        description="Whether to allow auto-merge for pull requests.", default=False
    )
    allow_forking: Union[Unset, bool] = Field(
        description="Whether to allow private forks", default=UNSET
    )
    allow_update_branch: Union[Unset, bool] = Field(default=UNSET)
    use_squash_pr_title_as_default: Union[Unset, bool] = Field(default=UNSET)
    squash_merge_commit_message: Union[Unset, str] = Field(default=UNSET)
    squash_merge_commit_title: Union[Unset, str] = Field(default=UNSET)
    merge_commit_message: Union[Unset, str] = Field(default=UNSET)
    merge_commit_title: Union[Unset, str] = Field(default=UNSET)
    is_template: bool = Field(default=...)
    web_commit_signoff_required: bool = Field(default=...)
    topics: List[str] = Field(default=...)
    visibility: Literal["public", "private", "internal"] = Field(default=...)
    delete_branch_on_merge: Union[Unset, bool] = Field(
        description="Whether to delete head branches when pull requests are merged",
        default=False,
    )
    master_branch: Union[Unset, str] = Field(default=UNSET)
    permissions: Union[Unset, RepositoryPropPermissions] = Field(default=UNSET)
    public: Union[Unset, bool] = Field(default=UNSET)
    organization: Union[Unset, str] = Field(default=UNSET)


class User(GitHubWebhookModel):
    """User"""

    login: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: Union[Unset, str] = Field(default=UNSET)
    email: Union[Unset, Union[str, None]] = Field(default=UNSET)
    avatar_url: str = Field(default=...)
    gravatar_id: str = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    organizations_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    type: Literal["Bot", "User", "Organization"] = Field(default=...)
    site_admin: bool = Field(default=...)


class License(GitHubWebhookModel):
    """License"""

    key: str = Field(default=...)
    name: str = Field(default=...)
    spdx_id: str = Field(default=...)
    url: Union[str, None] = Field(default=...)
    node_id: str = Field(default=...)


class RepositoryPropPermissions(GitHubWebhookModel):
    """RepositoryPropPermissions"""

    pull: bool = Field(default=...)
    push: bool = Field(default=...)
    admin: bool = Field(default=...)
    maintain: Union[Unset, bool] = Field(default=UNSET)
    triage: Union[Unset, bool] = Field(default=UNSET)


class InstallationLite(GitHubWebhookModel):
    """InstallationLite

    Installation
    """

    id: int = Field(description="The ID of the installation.", default=...)
    node_id: str = Field(default=...)


class Organization(GitHubWebhookModel):
    """Organization"""

    login: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    html_url: Union[Unset, str] = Field(default=UNSET)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    hooks_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    members_url: str = Field(default=...)
    public_members_url: str = Field(default=...)
    avatar_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)


class BranchProtectionRuleDeleted(GitHubWebhookModel):
    """branch protection rule deleted event

    Activity related to a branch protection rule. For more information, see "[About
    branch protection rules](https://docs.github.com/en/github/administering-a-
    repository/defining-the-mergeability-of-pull-requests/about-protected-
    branches#about-branch-protection-rules)."
    """

    action: Literal["deleted"] = Field(default=...)
    rule: BranchProtectionRule = Field(
        title="branch protection rule",
        description="The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/en/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class BranchProtectionRuleEdited(GitHubWebhookModel):
    """branch protection rule edited event

    Activity related to a branch protection rule. For more information, see "[About
    branch protection rules](https://docs.github.com/en/github/administering-a-
    repository/defining-the-mergeability-of-pull-requests/about-protected-
    branches#about-branch-protection-rules)."
    """

    action: Literal["edited"] = Field(default=...)
    rule: BranchProtectionRule = Field(
        title="branch protection rule",
        description="The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/en/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.",
        default=...,
    )
    changes: Union[Unset, BranchProtectionRuleEditedPropChanges] = Field(
        description="If the action was `edited`, the changes to the rule.",
        default=UNSET,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class BranchProtectionRuleEditedPropChanges(GitHubWebhookModel):
    """BranchProtectionRuleEditedPropChanges

    If the action was `edited`, the changes to the rule.
    """

    admin_enforced: Union[
        Unset, BranchProtectionRuleEditedPropChangesPropAdminEnforced
    ] = Field(default=UNSET)
    allow_deletions_enforcement_level: Union[
        Unset, BranchProtectionRuleEditedPropChangesPropAllowDeletionsEnforcementLevel
    ] = Field(default=UNSET)
    allow_force_pushes_enforcement_level: Union[
        Unset, BranchProtectionRuleEditedPropChangesPropAllowForcePushesEnforcementLevel
    ] = Field(default=UNSET)
    authorized_actors_only: Union[
        Unset, BranchProtectionRuleEditedPropChangesPropAuthorizedActorsOnly
    ] = Field(default=UNSET)
    authorized_actor_names: Union[
        Unset, BranchProtectionRuleEditedPropChangesPropAuthorizedActorNames
    ] = Field(default=UNSET)
    authorized_dismissal_actors_only: Union[
        Unset, BranchProtectionRuleEditedPropChangesPropAuthorizedDismissalActorsOnly
    ] = Field(default=UNSET)
    dismiss_stale_reviews_on_push: Union[
        Unset, BranchProtectionRuleEditedPropChangesPropDismissStaleReviewsOnPush
    ] = Field(default=UNSET)
    pull_request_reviews_enforcement_level: Union[
        Unset,
        BranchProtectionRuleEditedPropChangesPropPullRequestReviewsEnforcementLevel,
    ] = Field(default=UNSET)
    require_code_owner_review: Union[
        Unset, BranchProtectionRuleEditedPropChangesPropRequireCodeOwnerReview
    ] = Field(default=UNSET)
    required_approving_review_count: Union[
        Unset, BranchProtectionRuleEditedPropChangesPropRequiredApprovingReviewCount
    ] = Field(default=UNSET)
    required_conversation_resolution_level: Union[
        Unset,
        BranchProtectionRuleEditedPropChangesPropRequiredConversationResolutionLevel,
    ] = Field(default=UNSET)
    required_deployments_enforcement_level: Union[
        Unset,
        BranchProtectionRuleEditedPropChangesPropRequiredDeploymentsEnforcementLevel,
    ] = Field(default=UNSET)
    required_status_checks: Union[
        Unset, BranchProtectionRuleEditedPropChangesPropRequiredStatusChecks
    ] = Field(default=UNSET)
    required_status_checks_enforcement_level: Union[
        Unset,
        BranchProtectionRuleEditedPropChangesPropRequiredStatusChecksEnforcementLevel,
    ] = Field(default=UNSET)
    signature_requirement_enforcement_level: Union[
        Unset,
        BranchProtectionRuleEditedPropChangesPropSignatureRequirementEnforcementLevel,
    ] = Field(default=UNSET)
    linear_history_requirement_enforcement_level: Union[
        Unset,
        BranchProtectionRuleEditedPropChangesPropLinearHistoryRequirementEnforcementLevel,
    ] = Field(default=UNSET)


class BranchProtectionRuleEditedPropChangesPropAdminEnforced(GitHubWebhookModel):
    """BranchProtectionRuleEditedPropChangesPropAdminEnforced"""

    from_: bool = Field(
        title="Branch protection rule boolean", default=..., alias="from"
    )


class BranchProtectionRuleEditedPropChangesPropAllowDeletionsEnforcementLevel(
    GitHubWebhookModel
):
    """BranchProtectionRuleEditedPropChangesPropAllowDeletionsEnforcementLevel"""

    from_: Union[Literal["off", "non_admins", "everyone"], None] = Field(
        title="Branch protection rule enforcement level", default=..., alias="from"
    )


class BranchProtectionRuleEditedPropChangesPropAllowForcePushesEnforcementLevel(
    GitHubWebhookModel
):
    """BranchProtectionRuleEditedPropChangesPropAllowForcePushesEnforcementLevel"""

    from_: Literal["off", "non_admins", "everyone"] = Field(
        title="Branch protection rule enforcement level", default=..., alias="from"
    )


class BranchProtectionRuleEditedPropChangesPropAuthorizedActorsOnly(GitHubWebhookModel):
    """BranchProtectionRuleEditedPropChangesPropAuthorizedActorsOnly"""

    from_: bool = Field(
        title="Branch protection rule boolean", default=..., alias="from"
    )


class BranchProtectionRuleEditedPropChangesPropAuthorizedActorNames(GitHubWebhookModel):
    """BranchProtectionRuleEditedPropChangesPropAuthorizedActorNames"""

    from_: List[str] = Field(
        title="Branch Protection Rule Array", default=..., alias="from"
    )


class BranchProtectionRuleEditedPropChangesPropAuthorizedDismissalActorsOnly(
    GitHubWebhookModel
):
    """BranchProtectionRuleEditedPropChangesPropAuthorizedDismissalActorsOnly"""

    from_: Union[bool, None] = Field(
        title="Branch protection rule boolean", default=..., alias="from"
    )


class BranchProtectionRuleEditedPropChangesPropDismissStaleReviewsOnPush(
    GitHubWebhookModel
):
    """BranchProtectionRuleEditedPropChangesPropDismissStaleReviewsOnPush"""

    from_: bool = Field(
        title="Branch protection rule boolean", default=..., alias="from"
    )


class BranchProtectionRuleEditedPropChangesPropPullRequestReviewsEnforcementLevel(
    GitHubWebhookModel
):
    """BranchProtectionRuleEditedPropChangesPropPullRequestReviewsEnforcementLevel"""

    from_: Literal["off", "non_admins", "everyone"] = Field(
        title="Branch protection rule enforcement level", default=..., alias="from"
    )


class BranchProtectionRuleEditedPropChangesPropRequireCodeOwnerReview(
    GitHubWebhookModel
):
    """BranchProtectionRuleEditedPropChangesPropRequireCodeOwnerReview"""

    from_: bool = Field(
        title="Branch protection rule boolean", default=..., alias="from"
    )


class BranchProtectionRuleEditedPropChangesPropRequiredApprovingReviewCount(
    GitHubWebhookModel
):
    """BranchProtectionRuleEditedPropChangesPropRequiredApprovingReviewCount"""

    from_: int = Field(title="Branch protection rule number", default=..., alias="from")


class BranchProtectionRuleEditedPropChangesPropRequiredConversationResolutionLevel(
    GitHubWebhookModel
):
    """BranchProtectionRuleEditedPropChangesPropRequiredConversationResolutionLevel"""

    from_: Literal["off", "non_admins", "everyone"] = Field(
        title="Branch protection rule enforcement level", default=..., alias="from"
    )


class BranchProtectionRuleEditedPropChangesPropRequiredDeploymentsEnforcementLevel(
    GitHubWebhookModel
):
    """BranchProtectionRuleEditedPropChangesPropRequiredDeploymentsEnforcementLevel"""

    from_: Literal["off", "non_admins", "everyone"] = Field(
        title="Branch protection rule enforcement level", default=..., alias="from"
    )


class BranchProtectionRuleEditedPropChangesPropRequiredStatusChecks(GitHubWebhookModel):
    """BranchProtectionRuleEditedPropChangesPropRequiredStatusChecks"""

    from_: List[str] = Field(
        title="Branch Protection Rule Array", default=..., alias="from"
    )


class BranchProtectionRuleEditedPropChangesPropRequiredStatusChecksEnforcementLevel(
    GitHubWebhookModel
):
    """BranchProtectionRuleEditedPropChangesPropRequiredStatusChecksEnforcementLevel"""

    from_: Literal["off", "non_admins", "everyone"] = Field(
        title="Branch protection rule enforcement level", default=..., alias="from"
    )


class BranchProtectionRuleEditedPropChangesPropSignatureRequirementEnforcementLevel(
    GitHubWebhookModel
):
    """BranchProtectionRuleEditedPropChangesPropSignatureRequirementEnforcementLevel"""

    from_: Literal["off", "non_admins", "everyone"] = Field(
        title="Branch protection rule enforcement level", default=..., alias="from"
    )


class BranchProtectionRuleEditedPropChangesPropLinearHistoryRequirementEnforcementLevel(
    GitHubWebhookModel
):
    """BranchProtectionRuleEditedPropChangesPropLinearHistoryRequirementEnforcementLeve
    l
    """

    from_: Literal["off", "non_admins", "everyone"] = Field(
        title="Branch protection rule enforcement level", default=..., alias="from"
    )


class CheckRunCompleted(GitHubWebhookModel):
    """check_run completed event"""

    action: Literal["completed"] = Field(default=...)
    check_run: CheckRunCompletedPropCheckRun = Field(
        description="The [check_run](https://docs.github.com/en/rest/reference/checks#get-a-check-run).",
        default=...,
    )
    requested_action: Union[
        Unset, Union[CheckRunCompletedPropRequestedAction, None]
    ] = Field(description="The action requested by the user.", default=UNSET)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class CheckRunCompletedPropCheckRun(GitHubWebhookModel):
    """CheckRunCompletedPropCheckRun

    The [check_run](https://docs.github.com/en/rest/reference/checks#get-a-check-
    run).
    """

    id: int = Field(description="The id of the check.", default=...)
    node_id: Union[Unset, str] = Field(default=UNSET)
    head_sha: str = Field(
        description="The SHA of the commit that is being checked.", default=...
    )
    external_id: str = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    details_url: Union[Unset, str] = Field(default=UNSET)
    status: Literal["completed"] = Field(
        description="The current status of the check run. Can be `queued`, `in_progress`, or `completed`.",
        default=...,
    )
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
            "skipped",
        ],
    ] = Field(
        description="The result of the completed check run. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.",
        default=...,
    )
    started_at: datetime = Field(
        description="The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    completed_at: datetime = Field(
        description="The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    output: CheckRunCompletedPropCheckRunPropOutput = Field(default=...)
    name: str = Field(description="The name of the check run.", default=...)
    check_suite: CheckRunCompletedPropCheckRunPropCheckSuite = Field(default=...)
    app: App = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    pull_requests: List[CheckRunPullRequest] = Field(default=...)
    deployment: Union[Unset, CheckRunDeployment] = Field(
        title="Check Run Deployment",
        description="A deployment to a repository environment. This will only be populated if the check run was created by a GitHub Actions workflow job that references an environment.",
        default=UNSET,
    )


class CheckRunCompletedPropCheckRunPropOutput(GitHubWebhookModel):
    """CheckRunCompletedPropCheckRunPropOutput"""

    title: Union[Unset, Union[str, None]] = Field(default=UNSET)
    summary: Union[str, None] = Field(default=...)
    text: Union[str, None] = Field(default=...)
    annotations_count: int = Field(default=...)
    annotations_url: str = Field(default=...)


class CheckRunCompletedPropCheckRunPropCheckSuite(GitHubWebhookModel):
    """CheckRunCompletedPropCheckRunPropCheckSuite"""

    id: int = Field(
        description="The id of the check suite that this check run is part of.",
        default=...,
    )
    node_id: Union[Unset, str] = Field(default=UNSET)
    head_branch: Union[str, None] = Field(default=...)
    head_sha: str = Field(
        description="The SHA of the head commit that is being checked.", default=...
    )
    status: Literal["in_progress", "completed", "queued"] = Field(default=...)
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
        ],
    ] = Field(default=...)
    url: str = Field(default=...)
    before: Union[str, None] = Field(default=...)
    after: Union[str, None] = Field(default=...)
    pull_requests: List[CheckRunPullRequest] = Field(
        description="An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_branch`.  \n  \n**Note:**\n\n*   The `head_sha` of the check suite can differ from the `sha` of the pull request if subsequent pushes are made into the PR.\n*   When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.",
        default=...,
    )
    deployment: Union[Unset, CheckRunDeployment] = Field(
        title="Check Run Deployment",
        description="A deployment to a repository environment. This will only be populated if the check run was created by a GitHub Actions workflow job that references an environment.",
        default=UNSET,
    )
    app: App = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class CheckRunPullRequest(GitHubWebhookModel):
    """Check Run Pull Request"""

    url: str = Field(default=...)
    id: int = Field(default=...)
    number: int = Field(default=...)
    head: CheckRunPullRequestPropHead = Field(default=...)
    base: CheckRunPullRequestPropBase = Field(default=...)


class CheckRunPullRequestPropHead(GitHubWebhookModel):
    """CheckRunPullRequestPropHead"""

    ref: str = Field(default=...)
    sha: str = Field(default=...)
    repo: RepoRef = Field(title="Repo Ref", default=...)


class RepoRef(GitHubWebhookModel):
    """Repo Ref"""

    id: int = Field(default=...)
    url: str = Field(default=...)
    name: str = Field(default=...)


class CheckRunPullRequestPropBase(GitHubWebhookModel):
    """CheckRunPullRequestPropBase"""

    ref: str = Field(default=...)
    sha: str = Field(default=...)
    repo: RepoRef = Field(title="Repo Ref", default=...)


class CheckRunDeployment(GitHubWebhookModel):
    """Check Run Deployment

    A deployment to a repository environment. This will only be populated if the
    check run was created by a GitHub Actions workflow job that references an
    environment.
    """

    url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    task: str = Field(default=...)
    original_environment: str = Field(default=...)
    environment: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    statuses_url: str = Field(default=...)
    repository_url: str = Field(default=...)


class App(GitHubWebhookModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    id: int = Field(description="Unique identifier of the GitHub app", default=...)
    slug: Union[Unset, str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    node_id: str = Field(default=...)
    owner: User = Field(title="User", default=...)
    name: str = Field(description="The name of the GitHub app", default=...)
    description: Union[str, None] = Field(default=...)
    external_url: str = Field(default=...)
    html_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    permissions: Union[Unset, AppPropPermissions] = Field(
        description="The set of permissions for the GitHub app", default=UNSET
    )
    events: Union[
        Unset,
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "merge_group",
                "merge_queue_entry",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "projects_v2_item",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "secret_scanning_alert_location",
                "security_and_analysis",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "workflow_job",
            ]
        ],
    ] = Field(description="The list of events for the GitHub app", default=UNSET)


class AppPropPermissions(GitHubWebhookModel):
    """AppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    administration: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    blocking: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    deployments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    issues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    keys: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    members: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    merge_queues: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    metadata: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pages: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    statuses: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    workflows: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)


class CheckRunCompletedPropRequestedAction(GitHubWebhookModel):
    """CheckRunCompletedPropRequestedAction

    The action requested by the user.
    """

    identifier: Union[Unset, str] = Field(
        description="The integrator reference of the action requested by the user.",
        default=UNSET,
    )


class CheckRunCreated(GitHubWebhookModel):
    """check_run created event"""

    action: Literal["created"] = Field(default=...)
    check_run: CheckRunCreatedPropCheckRun = Field(
        description="The [check_run](https://docs.github.com/en/rest/reference/checks#get-a-check-run).",
        default=...,
    )
    requested_action: Union[
        Unset, Union[CheckRunCreatedPropRequestedAction, None]
    ] = Field(description="The action requested by the user.", default=UNSET)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class CheckRunCreatedPropCheckRun(GitHubWebhookModel):
    """CheckRunCreatedPropCheckRun

    The [check_run](https://docs.github.com/en/rest/reference/checks#get-a-check-
    run).
    """

    id: int = Field(description="The id of the check.", default=...)
    node_id: Union[Unset, str] = Field(default=UNSET)
    head_sha: str = Field(
        description="The SHA of the commit that is being checked.", default=...
    )
    external_id: str = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    details_url: Union[Unset, str] = Field(default=UNSET)
    status: Literal["queued", "in_progress", "completed", "waiting"] = Field(
        description="The current status of the check run. Can be `queued`, `in_progress`, or `completed`.",
        default=...,
    )
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
            "skipped",
        ],
    ] = Field(
        description="The result of the completed check run. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.",
        default=...,
    )
    started_at: datetime = Field(
        description="The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    completed_at: Union[datetime, None] = Field(
        description="The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    output: CheckRunCreatedPropCheckRunPropOutput = Field(default=...)
    name: str = Field(description="The name of the check run.", default=...)
    check_suite: CheckRunCreatedPropCheckRunPropCheckSuite = Field(default=...)
    app: App = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    pull_requests: List[CheckRunPullRequest] = Field(default=...)
    deployment: Union[Unset, CheckRunDeployment] = Field(
        title="Check Run Deployment",
        description="A deployment to a repository environment. This will only be populated if the check run was created by a GitHub Actions workflow job that references an environment.",
        default=UNSET,
    )


class CheckRunCreatedPropCheckRunPropOutput(GitHubWebhookModel):
    """CheckRunCreatedPropCheckRunPropOutput"""

    title: Union[Unset, Union[str, None]] = Field(default=UNSET)
    summary: Union[str, None] = Field(default=...)
    text: Union[str, None] = Field(default=...)
    annotations_count: int = Field(default=...)
    annotations_url: str = Field(default=...)


class CheckRunCreatedPropCheckRunPropCheckSuite(GitHubWebhookModel):
    """CheckRunCreatedPropCheckRunPropCheckSuite"""

    id: int = Field(
        description="The id of the check suite that this check run is part of.",
        default=...,
    )
    node_id: Union[Unset, str] = Field(default=UNSET)
    head_branch: Union[str, None] = Field(default=...)
    head_sha: str = Field(
        description="The SHA of the head commit that is being checked.", default=...
    )
    status: Literal["queued", "in_progress", "completed"] = Field(default=...)
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
        ],
    ] = Field(default=...)
    url: str = Field(default=...)
    before: Union[str, None] = Field(default=...)
    after: Union[str, None] = Field(default=...)
    pull_requests: List[CheckRunPullRequest] = Field(
        description="An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_branch`.  \n  \n**Note:**\n\n*   The `head_sha` of the check suite can differ from the `sha` of the pull request if subsequent pushes are made into the PR.\n*   When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.",
        default=...,
    )
    deployment: Union[Unset, CheckRunDeployment] = Field(
        title="Check Run Deployment",
        description="A deployment to a repository environment. This will only be populated if the check run was created by a GitHub Actions workflow job that references an environment.",
        default=UNSET,
    )
    app: App = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class CheckRunCreatedPropRequestedAction(GitHubWebhookModel):
    """CheckRunCreatedPropRequestedAction

    The action requested by the user.
    """

    identifier: Union[Unset, str] = Field(
        description="The integrator reference of the action requested by the user.",
        default=UNSET,
    )


class CheckRunRequestedAction(GitHubWebhookModel):
    """check_run requested_action event"""

    action: Literal["requested_action"] = Field(default=...)
    check_run: CheckRunRequestedActionPropCheckRun = Field(
        description="The [check_run](https://docs.github.com/en/rest/reference/checks#get-a-check-run).",
        default=...,
    )
    requested_action: CheckRunRequestedActionPropRequestedAction = Field(
        description="The action requested by the user.", default=...
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class CheckRunRequestedActionPropCheckRun(GitHubWebhookModel):
    """CheckRunRequestedActionPropCheckRun

    The [check_run](https://docs.github.com/en/rest/reference/checks#get-a-check-
    run).
    """

    id: int = Field(description="The id of the check.", default=...)
    node_id: Union[Unset, str] = Field(default=UNSET)
    head_sha: str = Field(
        description="The SHA of the commit that is being checked.", default=...
    )
    external_id: str = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    details_url: Union[Unset, str] = Field(default=UNSET)
    status: Literal["queued", "in_progress", "completed"] = Field(
        description="The current status of the check run. Can be `queued`, `in_progress`, or `completed`.",
        default=...,
    )
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
            "skipped",
        ],
    ] = Field(
        description="The result of the completed check run. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.",
        default=...,
    )
    started_at: datetime = Field(
        description="The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    completed_at: Union[datetime, None] = Field(
        description="The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    output: CheckRunRequestedActionPropCheckRunPropOutput = Field(default=...)
    name: str = Field(description="The name of the check run.", default=...)
    check_suite: CheckRunRequestedActionPropCheckRunPropCheckSuite = Field(default=...)
    app: App = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    pull_requests: List[CheckRunPullRequest] = Field(default=...)
    deployment: Union[Unset, CheckRunDeployment] = Field(
        title="Check Run Deployment",
        description="A deployment to a repository environment. This will only be populated if the check run was created by a GitHub Actions workflow job that references an environment.",
        default=UNSET,
    )


class CheckRunRequestedActionPropCheckRunPropOutput(GitHubWebhookModel):
    """CheckRunRequestedActionPropCheckRunPropOutput"""

    title: Union[Unset, Union[str, None]] = Field(default=UNSET)
    summary: Union[str, None] = Field(default=...)
    text: Union[str, None] = Field(default=...)
    annotations_count: int = Field(default=...)
    annotations_url: str = Field(default=...)


class CheckRunRequestedActionPropCheckRunPropCheckSuite(GitHubWebhookModel):
    """CheckRunRequestedActionPropCheckRunPropCheckSuite"""

    id: int = Field(
        description="The id of the check suite that this check run is part of.",
        default=...,
    )
    node_id: Union[Unset, str] = Field(default=UNSET)
    head_branch: Union[str, None] = Field(default=...)
    head_sha: str = Field(
        description="The SHA of the head commit that is being checked.", default=...
    )
    status: Literal["queued", "in_progress", "completed", "waiting"] = Field(
        default=...
    )
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
        ],
    ] = Field(default=...)
    url: str = Field(default=...)
    before: Union[str, None] = Field(default=...)
    after: Union[str, None] = Field(default=...)
    pull_requests: List[CheckRunPullRequest] = Field(
        description="An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_branch`.  \n  \n**Note:**\n\n*   The `head_sha` of the check suite can differ from the `sha` of the pull request if subsequent pushes are made into the PR.\n*   When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.",
        default=...,
    )
    deployment: Union[Unset, CheckRunDeployment] = Field(
        title="Check Run Deployment",
        description="A deployment to a repository environment. This will only be populated if the check run was created by a GitHub Actions workflow job that references an environment.",
        default=UNSET,
    )
    app: App = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class CheckRunRequestedActionPropRequestedAction(GitHubWebhookModel):
    """CheckRunRequestedActionPropRequestedAction

    The action requested by the user.
    """

    identifier: Union[Unset, str] = Field(
        description="The integrator reference of the action requested by the user.",
        default=UNSET,
    )


class CheckRunRerequested(GitHubWebhookModel):
    """check_run rerequested event"""

    action: Literal["rerequested"] = Field(default=...)
    check_run: CheckRunRerequestedPropCheckRun = Field(
        description="The [check_run](https://docs.github.com/en/rest/reference/checks#get-a-check-run).",
        default=...,
    )
    requested_action: Union[
        Unset, Union[CheckRunRerequestedPropRequestedAction, None]
    ] = Field(description="The action requested by the user.", default=UNSET)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class CheckRunRerequestedPropCheckRun(GitHubWebhookModel):
    """CheckRunRerequestedPropCheckRun

    The [check_run](https://docs.github.com/en/rest/reference/checks#get-a-check-
    run).
    """

    id: int = Field(description="The id of the check.", default=...)
    node_id: Union[Unset, str] = Field(default=UNSET)
    head_sha: str = Field(
        description="The SHA of the commit that is being checked.", default=...
    )
    external_id: str = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    details_url: Union[Unset, str] = Field(default=UNSET)
    status: Literal["completed"] = Field(
        description="The phase of the lifecycle that the check is currently in.",
        default=...,
    )
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
            "skipped",
        ],
    ] = Field(
        description="The result of the completed check run. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has `completed`.",
        default=...,
    )
    started_at: datetime = Field(
        description="The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    completed_at: datetime = Field(
        description="The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    output: CheckRunRerequestedPropCheckRunPropOutput = Field(default=...)
    name: str = Field(description="The name of the check.", default=...)
    check_suite: CheckRunRerequestedPropCheckRunPropCheckSuite = Field(default=...)
    app: App = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    pull_requests: List[CheckRunPullRequest] = Field(default=...)
    deployment: Union[Unset, CheckRunDeployment] = Field(
        title="Check Run Deployment",
        description="A deployment to a repository environment. This will only be populated if the check run was created by a GitHub Actions workflow job that references an environment.",
        default=UNSET,
    )


class CheckRunRerequestedPropCheckRunPropOutput(GitHubWebhookModel):
    """CheckRunRerequestedPropCheckRunPropOutput"""

    title: Union[Unset, Union[str, None]] = Field(default=UNSET)
    summary: Union[str, None] = Field(default=...)
    text: Union[str, None] = Field(default=...)
    annotations_count: int = Field(default=...)
    annotations_url: str = Field(default=...)


class CheckRunRerequestedPropCheckRunPropCheckSuite(GitHubWebhookModel):
    """CheckRunRerequestedPropCheckRunPropCheckSuite"""

    id: int = Field(
        description="The id of the check suite that this check run is part of.",
        default=...,
    )
    node_id: Union[Unset, str] = Field(default=UNSET)
    head_branch: Union[str, None] = Field(default=...)
    head_sha: str = Field(
        description="The SHA of the head commit that is being checked.", default=...
    )
    status: Literal["completed"] = Field(default=...)
    conclusion: Literal[
        "success",
        "failure",
        "neutral",
        "cancelled",
        "timed_out",
        "action_required",
        "stale",
    ] = Field(default=...)
    url: str = Field(default=...)
    before: Union[str, None] = Field(default=...)
    after: Union[str, None] = Field(default=...)
    pull_requests: List[CheckRunPullRequest] = Field(
        description="An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_branch`.  \n  \n**Note:**\n\n*   The `head_sha` of the check suite can differ from the `sha` of the pull request if subsequent pushes are made into the PR.\n*   When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.",
        default=...,
    )
    deployment: Union[Unset, CheckRunDeployment] = Field(
        title="Check Run Deployment",
        description="A deployment to a repository environment. This will only be populated if the check run was created by a GitHub Actions workflow job that references an environment.",
        default=UNSET,
    )
    app: App = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class CheckRunRerequestedPropRequestedAction(GitHubWebhookModel):
    """CheckRunRerequestedPropRequestedAction

    The action requested by the user.
    """

    identifier: Union[Unset, str] = Field(
        description="The integrator reference of the action requested by the user.",
        default=UNSET,
    )


class CheckSuiteCompleted(GitHubWebhookModel):
    """check_suite completed event"""

    action: Literal["completed"] = Field(default=...)
    check_suite: CheckSuiteCompletedPropCheckSuite = Field(
        description="The [check_suite](https://docs.github.com/en/rest/reference/checks#suites).",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class CheckSuiteCompletedPropCheckSuite(GitHubWebhookModel):
    """CheckSuiteCompletedPropCheckSuite

    The [check_suite](https://docs.github.com/en/rest/reference/checks#suites).
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    head_branch: Union[str, None] = Field(
        description="The head branch name the changes are on.", default=...
    )
    head_sha: str = Field(
        description="The SHA of the head commit that is being checked.", default=...
    )
    status: Union[
        None, Literal["requested", "in_progress", "completed", "queued"]
    ] = Field(
        description="The summary status for all check runs that are part of the check suite. Can be `queued`, `requested`, `in_progress`, or `completed`.",
        default=...,
    )
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
        ],
    ] = Field(
        description="The summary conclusion for all check runs that are part of the check suite. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has `completed`.",
        default=...,
    )
    url: str = Field(
        description="URL that points to the check suite API resource.", default=...
    )
    before: Union[str, None] = Field(default=...)
    after: Union[str, None] = Field(default=...)
    pull_requests: List[CheckRunPullRequest] = Field(
        description="An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.",
        default=...,
    )
    app: App = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    runs_rerequestable: Union[Unset, bool] = Field(default=UNSET)
    rerequestable: Union[Unset, bool] = Field(default=UNSET)
    latest_check_runs_count: int = Field(default=...)
    check_runs_url: str = Field(default=...)
    head_commit: CommitSimple = Field(title="SimpleCommit", default=...)


class CommitSimple(GitHubWebhookModel):
    """SimpleCommit"""

    id: str = Field(default=...)
    tree_id: str = Field(default=...)
    message: str = Field(default=...)
    timestamp: str = Field(default=...)
    author: Committer = Field(
        title="Committer",
        description="Metaproperties for Git author/committer information.",
        default=...,
    )
    committer: Committer = Field(
        title="Committer",
        description="Metaproperties for Git author/committer information.",
        default=...,
    )


class Committer(GitHubWebhookModel):
    """Committer

    Metaproperties for Git author/committer information.
    """

    name: str = Field(description="The git author's name.", default=...)
    email: Union[str, None] = Field(
        description="The git author's email address.", default=...
    )
    date: Union[Unset, datetime] = Field(default=UNSET)
    username: Union[Unset, str] = Field(default=UNSET)


class CheckSuiteRequested(GitHubWebhookModel):
    """check_suite requested event"""

    action: Literal["requested"] = Field(default=...)
    check_suite: CheckSuiteRequestedPropCheckSuite = Field(
        description="The [check_suite](https://docs.github.com/en/rest/reference/checks#suites).",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class CheckSuiteRequestedPropCheckSuite(GitHubWebhookModel):
    """CheckSuiteRequestedPropCheckSuite

    The [check_suite](https://docs.github.com/en/rest/reference/checks#suites).
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    head_branch: Union[str, None] = Field(
        description="The head branch name the changes are on.", default=...
    )
    head_sha: str = Field(
        description="The SHA of the head commit that is being checked.", default=...
    )
    status: Union[
        None, Literal["requested", "in_progress", "completed", "queued"]
    ] = Field(
        description="The summary status for all check runs that are part of the check suite. Can be `queued`, `requested`, `in_progress`, or `completed`.",
        default=...,
    )
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
        ],
    ] = Field(
        description="The summary conclusion for all check runs that are part of the check suite. Can be one of `success`, `failure`,` neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.",
        default=...,
    )
    url: str = Field(
        description="URL that points to the check suite API resource.", default=...
    )
    before: Union[str, None] = Field(default=...)
    after: Union[str, None] = Field(default=...)
    pull_requests: List[CheckRunPullRequest] = Field(
        description="An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.",
        default=...,
    )
    app: App = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    runs_rerequestable: Union[Unset, bool] = Field(default=UNSET)
    rerequestable: Union[Unset, bool] = Field(default=UNSET)
    latest_check_runs_count: int = Field(default=...)
    check_runs_url: str = Field(default=...)
    head_commit: CommitSimple = Field(title="SimpleCommit", default=...)


class CheckSuiteRerequested(GitHubWebhookModel):
    """check_suite rerequested event"""

    action: Literal["rerequested"] = Field(default=...)
    check_suite: CheckSuiteRerequestedPropCheckSuite = Field(
        description="The [check_suite](https://docs.github.com/en/rest/reference/checks#suites).",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class CheckSuiteRerequestedPropCheckSuite(GitHubWebhookModel):
    """CheckSuiteRerequestedPropCheckSuite

    The [check_suite](https://docs.github.com/en/rest/reference/checks#suites).
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    head_branch: Union[str, None] = Field(
        description="The head branch name the changes are on.", default=...
    )
    head_sha: str = Field(
        description="The SHA of the head commit that is being checked.", default=...
    )
    status: Union[
        None, Literal["requested", "in_progress", "completed", "queued"]
    ] = Field(
        description="The summary status for all check runs that are part of the check suite. Can be `queued`, `requested`, `in_progress`, or `completed`.",
        default=...,
    )
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
        ],
    ] = Field(
        description="The summary conclusion for all check runs that are part of the check suite. Can be one of `success`, `failure`,` neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.",
        default=...,
    )
    url: str = Field(
        description="URL that points to the check suite API resource.", default=...
    )
    before: Union[str, None] = Field(default=...)
    after: Union[str, None] = Field(default=...)
    pull_requests: List[CheckRunPullRequest] = Field(
        description="An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.",
        default=...,
    )
    app: App = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    latest_check_runs_count: int = Field(default=...)
    check_runs_url: str = Field(default=...)
    head_commit: CommitSimple = Field(title="SimpleCommit", default=...)


class CodeScanningAlertAppearedInBranch(GitHubWebhookModel):
    """code_scanning_alert appeared_in_branch event"""

    action: Literal["appeared_in_branch"] = Field(default=...)
    alert: CodeScanningAlertAppearedInBranchPropAlert = Field(
        description="The code scanning alert involved in the event.", default=...
    )
    ref: str = Field(
        description="The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
        default=...,
    )
    commit_oid: str = Field(
        description="The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: GithubOrg = Field(title="GitHub Org", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class CodeScanningAlertAppearedInBranchPropAlert(GitHubWebhookModel):
    """CodeScanningAlertAppearedInBranchPropAlert

    The code scanning alert involved in the event.
    """

    number: int = Field(description="The code scanning alert number.", default=...)
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`",
        default=...,
    )
    url: str = Field(description="The REST API URL of the alert resource.", default=...)
    html_url: str = Field(
        description="The GitHub URL of the alert resource.", default=...
    )
    instances: List[AlertInstance] = Field(default=...)
    most_recent_instance: Union[Unset, AlertInstance] = Field(
        title="Alert Instance", default=UNSET
    )
    state: Literal["open", "dismissed", "fixed"] = Field(
        description="State of a code scanning alert.", default=...
    )
    dismissed_by: Union[User, None] = Field(title="User", default=...)
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ] = Field(
        description="The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.",
        default=...,
    )
    rule: CodeScanningAlertAppearedInBranchPropAlertPropRule = Field(default=...)
    tool: CodeScanningAlertAppearedInBranchPropAlertPropTool = Field(default=...)


class AlertInstance(GitHubWebhookModel):
    """Alert Instance"""

    ref: str = Field(
        description="The full Git reference, formatted as `refs/heads/<branch name>`.",
        default=...,
    )
    analysis_key: str = Field(
        description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.",
        default=...,
    )
    environment: str = Field(
        description="Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.",
        default=...,
    )
    state: Literal["open", "dismissed", "fixed"] = Field(
        description="State of a code scanning alert.", default=...
    )
    commit_sha: Union[Unset, str] = Field(default=UNSET)
    message: Union[Unset, AlertInstancePropMessage] = Field(default=UNSET)
    location: Union[Unset, AlertInstancePropLocation] = Field(default=UNSET)
    classifications: Union[Unset, List[str]] = Field(default=UNSET)


class AlertInstancePropMessage(GitHubWebhookModel):
    """AlertInstancePropMessage"""

    text: Union[Unset, str] = Field(default=UNSET)


class AlertInstancePropLocation(GitHubWebhookModel):
    """AlertInstancePropLocation"""

    path: Union[Unset, str] = Field(default=UNSET)
    start_line: Union[Unset, int] = Field(default=UNSET)
    end_line: Union[Unset, int] = Field(default=UNSET)
    start_column: Union[Unset, int] = Field(default=UNSET)
    end_column: Union[Unset, int] = Field(default=UNSET)


class CodeScanningAlertAppearedInBranchPropAlertPropRule(GitHubWebhookModel):
    """CodeScanningAlertAppearedInBranchPropAlertPropRule"""

    id: str = Field(
        description="A unique identifier for the rule used to detect the alert.",
        default=...,
    )
    severity: Union[None, Literal["none", "note", "warning", "error"]] = Field(
        description="The severity of the alert.", default=...
    )
    description: str = Field(
        description="A short description of the rule used to detect the alert.",
        default=...,
    )


class CodeScanningAlertAppearedInBranchPropAlertPropTool(GitHubWebhookModel):
    """CodeScanningAlertAppearedInBranchPropAlertPropTool"""

    name: str = Field(
        description="The name of the tool used to generate the code scanning analysis alert.",
        default=...,
    )
    version: Union[str, None] = Field(
        description="The version of the tool used to detect the alert.", default=...
    )


class GithubOrg(GitHubWebhookModel):
    """GitHub Org"""

    login: Literal["github"] = Field(default=...)
    id: Literal[9919] = Field(default=...)
    node_id: Literal["MDEyOk9yZ2FuaXphdGlvbjk5MTk="] = Field(default=...)
    name: Union[Unset, Literal["GitHub"]] = Field(default=UNSET)
    email: Union[Unset, None] = Field(default=UNSET)
    avatar_url: Literal["https://avatars.githubusercontent.com/u/9919?v=4"] = Field(
        default=...
    )
    gravatar_id: Literal[""] = Field(default=...)
    url: Literal["https://api.github.com/users/github"] = Field(default=...)
    html_url: Literal["https://github.com/github"] = Field(default=...)
    followers_url: Literal["https://api.github.com/users/github/followers"] = Field(
        default=...
    )
    following_url: Literal[
        "https://api.github.com/users/github/following{/other_user}"
    ] = Field(default=...)
    gists_url: Literal["https://api.github.com/users/github/gists{/gist_id}"] = Field(
        default=...
    )
    starred_url: Literal[
        "https://api.github.com/users/github/starred{/owner}{/repo}"
    ] = Field(default=...)
    subscriptions_url: Literal[
        "https://api.github.com/users/github/subscriptions"
    ] = Field(default=...)
    organizations_url: Literal["https://api.github.com/users/github/orgs"] = Field(
        default=...
    )
    repos_url: Literal["https://api.github.com/users/github/repos"] = Field(default=...)
    events_url: Literal["https://api.github.com/users/github/events{/privacy}"] = Field(
        default=...
    )
    received_events_url: Literal[
        "https://api.github.com/users/github/received_events"
    ] = Field(default=...)
    type: Literal["Organization"] = Field(default=...)
    site_admin: Literal[False] = Field(default=...)


class CodeScanningAlertClosedByUser(GitHubWebhookModel):
    """code_scanning_alert closed_by_user event"""

    action: Literal["closed_by_user"] = Field(default=...)
    alert: CodeScanningAlertClosedByUserPropAlert = Field(
        description="The code scanning alert involved in the event.", default=...
    )
    ref: str = Field(
        description="The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
        default=...,
    )
    commit_oid: str = Field(
        description="The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class CodeScanningAlertClosedByUserPropAlert(GitHubWebhookModel):
    """CodeScanningAlertClosedByUserPropAlert

    The code scanning alert involved in the event.
    """

    number: int = Field(description="The code scanning alert number.", default=...)
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`",
        default=...,
    )
    url: str = Field(description="The REST API URL of the alert resource.", default=...)
    html_url: str = Field(
        description="The GitHub URL of the alert resource.", default=...
    )
    instances: List[CodeScanningAlertClosedByUserPropAlertPropInstancesItems] = Field(
        default=...
    )
    most_recent_instance: Union[Unset, AlertInstance] = Field(
        title="Alert Instance", default=UNSET
    )
    state: Literal["dismissed"] = Field(
        description="State of a code scanning alert.", default=...
    )
    dismissed_by: User = Field(title="User", default=...)
    dismissed_at: datetime = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ] = Field(
        description="The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.",
        default=...,
    )
    rule: CodeScanningAlertClosedByUserPropAlertPropRule = Field(default=...)
    tool: CodeScanningAlertClosedByUserPropAlertPropTool = Field(default=...)


class CodeScanningAlertClosedByUserPropAlertPropInstancesItems(GitHubWebhookModel):
    """CodeScanningAlertClosedByUserPropAlertPropInstancesItems"""

    ref: str = Field(
        description="The full Git reference, formatted as `refs/heads/<branch name>`.",
        default=...,
    )
    analysis_key: str = Field(
        description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.",
        default=...,
    )
    environment: str = Field(
        description="Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.",
        default=...,
    )
    state: Literal["dismissed"] = Field(default=...)
    commit_sha: Union[Unset, str] = Field(default=UNSET)
    message: Union[Unset, AlertInstancePropMessage] = Field(default=UNSET)
    location: Union[Unset, AlertInstancePropLocation] = Field(default=UNSET)
    classifications: Union[Unset, List[str]] = Field(default=UNSET)


class CodeScanningAlertClosedByUserPropAlertPropInstancesItemsAllof1(
    GitHubWebhookModel
):
    """CodeScanningAlertClosedByUserPropAlertPropInstancesItemsAllof1"""

    state: Literal["dismissed"] = Field(default=...)


class CodeScanningAlertClosedByUserPropAlertPropRule(GitHubWebhookModel):
    """CodeScanningAlertClosedByUserPropAlertPropRule"""

    id: str = Field(
        description="A unique identifier for the rule used to detect the alert.",
        default=...,
    )
    severity: Union[None, Literal["none", "note", "warning", "error"]] = Field(
        description="The severity of the alert.", default=...
    )
    description: str = Field(
        description="A short description of the rule used to detect the alert.",
        default=...,
    )
    name: Union[Unset, str] = Field(default=UNSET)
    full_description: Union[Unset, str] = Field(default=UNSET)
    tags: Union[Unset, None] = Field(default=UNSET)
    help_: Union[Unset, None] = Field(default=UNSET, alias="help")


class CodeScanningAlertClosedByUserPropAlertPropTool(GitHubWebhookModel):
    """CodeScanningAlertClosedByUserPropAlertPropTool"""

    name: str = Field(
        description="The name of the tool used to generate the code scanning analysis alert.",
        default=...,
    )
    version: Union[str, None] = Field(
        description="The version of the tool used to detect the alert.", default=...
    )
    guid: Union[Unset, Union[str, None]] = Field(default=UNSET)


class CodeScanningAlertCreated(GitHubWebhookModel):
    """code_scanning_alert created event"""

    action: Literal["created"] = Field(default=...)
    alert: CodeScanningAlertCreatedPropAlert = Field(
        description="The code scanning alert involved in the event.", default=...
    )
    ref: str = Field(
        description="The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
        default=...,
    )
    commit_oid: str = Field(
        description="The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: GithubOrg = Field(title="GitHub Org", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class CodeScanningAlertCreatedPropAlert(GitHubWebhookModel):
    """CodeScanningAlertCreatedPropAlert

    The code scanning alert involved in the event.
    """

    number: int = Field(description="The code scanning alert number.", default=...)
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`",
        default=...,
    )
    url: str = Field(description="The REST API URL of the alert resource.", default=...)
    html_url: str = Field(
        description="The GitHub URL of the alert resource.", default=...
    )
    instances: List[CodeScanningAlertCreatedPropAlertPropInstancesItems] = Field(
        default=...
    )
    most_recent_instance: Union[Unset, AlertInstance] = Field(
        title="Alert Instance", default=UNSET
    )
    state: Literal["open", "dismissed"] = Field(
        description="State of a code scanning alert.", default=...
    )
    dismissed_by: None = Field(default=...)
    dismissed_at: None = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_reason: None = Field(
        description="The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.",
        default=...,
    )
    rule: CodeScanningAlertCreatedPropAlertPropRule = Field(default=...)
    tool: CodeScanningAlertCreatedPropAlertPropTool = Field(default=...)


class CodeScanningAlertCreatedPropAlertPropInstancesItems(GitHubWebhookModel):
    """CodeScanningAlertCreatedPropAlertPropInstancesItems"""

    ref: str = Field(
        description="The full Git reference, formatted as `refs/heads/<branch name>`.",
        default=...,
    )
    analysis_key: str = Field(
        description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.",
        default=...,
    )
    environment: str = Field(
        description="Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.",
        default=...,
    )
    state: Literal["open", "dismissed"] = Field(default=...)
    commit_sha: Union[Unset, str] = Field(default=UNSET)
    message: Union[Unset, AlertInstancePropMessage] = Field(default=UNSET)
    location: Union[Unset, AlertInstancePropLocation] = Field(default=UNSET)
    classifications: Union[Unset, List[str]] = Field(default=UNSET)


class CodeScanningAlertCreatedPropAlertPropInstancesItemsAllof1(GitHubWebhookModel):
    """CodeScanningAlertCreatedPropAlertPropInstancesItemsAllof1"""

    state: Literal["open", "dismissed"] = Field(default=...)


class CodeScanningAlertCreatedPropAlertPropRule(GitHubWebhookModel):
    """CodeScanningAlertCreatedPropAlertPropRule"""

    id: str = Field(
        description="A unique identifier for the rule used to detect the alert.",
        default=...,
    )
    severity: Union[None, Literal["none", "note", "warning", "error"]] = Field(
        description="The severity of the alert.", default=...
    )
    description: str = Field(
        description="A short description of the rule used to detect the alert.",
        default=...,
    )
    name: Union[Unset, str] = Field(default=UNSET)
    full_description: Union[Unset, str] = Field(default=UNSET)
    tags: Union[Unset, None] = Field(default=UNSET)
    help_: Union[Unset, None] = Field(default=UNSET, alias="help")


class CodeScanningAlertCreatedPropAlertPropTool(GitHubWebhookModel):
    """CodeScanningAlertCreatedPropAlertPropTool"""

    name: str = Field(
        description="The name of the tool used to generate the code scanning analysis alert.",
        default=...,
    )
    version: Union[str, None] = Field(
        description="The version of the tool used to detect the alert.", default=...
    )
    guid: Union[Unset, Union[str, None]] = Field(default=UNSET)


class CodeScanningAlertFixed(GitHubWebhookModel):
    """code_scanning_alert fixed event"""

    action: Literal["fixed"] = Field(default=...)
    alert: CodeScanningAlertFixedPropAlert = Field(
        description="The code scanning alert involved in the event.", default=...
    )
    ref: str = Field(
        description="The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
        default=...,
    )
    commit_oid: str = Field(
        description="The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: GithubOrg = Field(title="GitHub Org", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class CodeScanningAlertFixedPropAlert(GitHubWebhookModel):
    """CodeScanningAlertFixedPropAlert

    The code scanning alert involved in the event.
    """

    number: int = Field(description="The code scanning alert number.", default=...)
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`",
        default=...,
    )
    url: str = Field(description="The REST API URL of the alert resource.", default=...)
    html_url: str = Field(
        description="The GitHub URL of the alert resource.", default=...
    )
    instances: List[CodeScanningAlertFixedPropAlertPropInstancesItems] = Field(
        default=...
    )
    state: Literal["fixed"] = Field(
        description="State of a code scanning alert.", default=...
    )
    dismissed_by: Union[User, None] = Field(title="User", default=...)
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ] = Field(
        description="The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.",
        default=...,
    )
    rule: CodeScanningAlertFixedPropAlertPropRule = Field(default=...)
    tool: CodeScanningAlertFixedPropAlertPropTool = Field(default=...)
    most_recent_instance: Union[Unset, AlertInstance] = Field(
        title="Alert Instance", default=UNSET
    )
    instances_url: Union[Unset, str] = Field(default=UNSET)


class CodeScanningAlertFixedPropAlertPropInstancesItems(GitHubWebhookModel):
    """CodeScanningAlertFixedPropAlertPropInstancesItems"""

    ref: str = Field(
        description="The full Git reference, formatted as `refs/heads/<branch name>`.",
        default=...,
    )
    analysis_key: str = Field(
        description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.",
        default=...,
    )
    environment: str = Field(
        description="Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.",
        default=...,
    )
    state: Literal["fixed"] = Field(default=...)
    commit_sha: Union[Unset, str] = Field(default=UNSET)
    message: Union[Unset, AlertInstancePropMessage] = Field(default=UNSET)
    location: Union[Unset, AlertInstancePropLocation] = Field(default=UNSET)
    classifications: Union[Unset, List[str]] = Field(default=UNSET)


class CodeScanningAlertFixedPropAlertPropInstancesItemsAllof1(GitHubWebhookModel):
    """CodeScanningAlertFixedPropAlertPropInstancesItemsAllof1"""

    state: Literal["fixed"] = Field(default=...)


class CodeScanningAlertFixedPropAlertPropRule(GitHubWebhookModel):
    """CodeScanningAlertFixedPropAlertPropRule"""

    id: str = Field(
        description="A unique identifier for the rule used to detect the alert.",
        default=...,
    )
    severity: Union[None, Literal["none", "note", "warning", "error"]] = Field(
        description="The severity of the alert.", default=...
    )
    description: str = Field(
        description="A short description of the rule used to detect the alert.",
        default=...,
    )
    name: Union[Unset, str] = Field(default=UNSET)
    full_description: Union[Unset, str] = Field(default=UNSET)
    tags: Union[Unset, None] = Field(default=UNSET)
    help_: Union[Unset, None] = Field(default=UNSET, alias="help")


class CodeScanningAlertFixedPropAlertPropTool(GitHubWebhookModel):
    """CodeScanningAlertFixedPropAlertPropTool"""

    name: str = Field(
        description="The name of the tool used to generate the code scanning analysis alert.",
        default=...,
    )
    version: Union[str, None] = Field(
        description="The version of the tool used to detect the alert.", default=...
    )
    guid: Union[Unset, Union[str, None]] = Field(default=UNSET)


class CodeScanningAlertReopened(GitHubWebhookModel):
    """code_scanning_alert reopened event"""

    action: Literal["reopened"] = Field(default=...)
    alert: CodeScanningAlertReopenedPropAlert = Field(
        description="The code scanning alert involved in the event.", default=...
    )
    ref: str = Field(
        description="The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
        default=...,
    )
    commit_oid: str = Field(
        description="The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: GithubOrg = Field(title="GitHub Org", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class CodeScanningAlertReopenedPropAlert(GitHubWebhookModel):
    """CodeScanningAlertReopenedPropAlert

    The code scanning alert involved in the event.
    """

    number: int = Field(description="The code scanning alert number.", default=...)
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`",
        default=...,
    )
    url: str = Field(description="The REST API URL of the alert resource.", default=...)
    html_url: str = Field(
        description="The GitHub URL of the alert resource.", default=...
    )
    instances: List[CodeScanningAlertReopenedPropAlertPropInstancesItems] = Field(
        default=...
    )
    most_recent_instance: Union[Unset, AlertInstance] = Field(
        title="Alert Instance", default=UNSET
    )
    state: Literal["open", "dismissed", "fixed"] = Field(
        description="State of a code scanning alert.", default=...
    )
    dismissed_by: None = Field(default=...)
    dismissed_at: None = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_reason: None = Field(
        description="The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.",
        default=...,
    )
    rule: CodeScanningAlertReopenedPropAlertPropRule = Field(default=...)
    tool: CodeScanningAlertReopenedPropAlertPropTool = Field(default=...)


class CodeScanningAlertReopenedPropAlertPropInstancesItems(GitHubWebhookModel):
    """CodeScanningAlertReopenedPropAlertPropInstancesItems"""

    ref: str = Field(
        description="The full Git reference, formatted as `refs/heads/<branch name>`.",
        default=...,
    )
    analysis_key: str = Field(
        description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.",
        default=...,
    )
    environment: str = Field(
        description="Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.",
        default=...,
    )
    state: Literal["open"] = Field(default=...)
    commit_sha: Union[Unset, str] = Field(default=UNSET)
    message: Union[Unset, AlertInstancePropMessage] = Field(default=UNSET)
    location: Union[Unset, AlertInstancePropLocation] = Field(default=UNSET)
    classifications: Union[Unset, List[str]] = Field(default=UNSET)


class CodeScanningAlertReopenedPropAlertPropInstancesItemsAllof1(GitHubWebhookModel):
    """CodeScanningAlertReopenedPropAlertPropInstancesItemsAllof1"""

    state: Literal["open"] = Field(default=...)


class CodeScanningAlertReopenedPropAlertPropRule(GitHubWebhookModel):
    """CodeScanningAlertReopenedPropAlertPropRule"""

    id: str = Field(
        description="A unique identifier for the rule used to detect the alert.",
        default=...,
    )
    severity: Union[None, Literal["none", "note", "warning", "error"]] = Field(
        description="The severity of the alert.", default=...
    )
    description: str = Field(
        description="A short description of the rule used to detect the alert.",
        default=...,
    )
    name: Union[Unset, str] = Field(default=UNSET)
    full_description: Union[Unset, str] = Field(default=UNSET)
    tags: Union[Unset, None] = Field(default=UNSET)
    help_: Union[Unset, None] = Field(default=UNSET, alias="help")


class CodeScanningAlertReopenedPropAlertPropTool(GitHubWebhookModel):
    """CodeScanningAlertReopenedPropAlertPropTool"""

    name: str = Field(
        description="The name of the tool used to generate the code scanning analysis alert.",
        default=...,
    )
    version: Union[str, None] = Field(
        description="The version of the tool used to detect the alert.", default=...
    )
    guid: Union[Unset, Union[str, None]] = Field(default=UNSET)


class CodeScanningAlertReopenedByUser(GitHubWebhookModel):
    """code_scanning_alert reopened_by_user event"""

    action: Literal["reopened_by_user"] = Field(default=...)
    alert: CodeScanningAlertReopenedByUserPropAlert = Field(
        description="The code scanning alert involved in the event.", default=...
    )
    ref: str = Field(
        description="The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
        default=...,
    )
    commit_oid: str = Field(
        description="The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class CodeScanningAlertReopenedByUserPropAlert(GitHubWebhookModel):
    """CodeScanningAlertReopenedByUserPropAlert

    The code scanning alert involved in the event.
    """

    number: int = Field(description="The code scanning alert number.", default=...)
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`",
        default=...,
    )
    url: str = Field(description="The REST API URL of the alert resource.", default=...)
    html_url: str = Field(
        description="The GitHub URL of the alert resource.", default=...
    )
    instances: List[CodeScanningAlertReopenedByUserPropAlertPropInstancesItems] = Field(
        default=...
    )
    most_recent_instance: Union[Unset, AlertInstance] = Field(
        title="Alert Instance", default=UNSET
    )
    state: Literal["open"] = Field(
        description="State of a code scanning alert.", default=...
    )
    dismissed_by: None = Field(default=...)
    dismissed_at: None = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_reason: None = Field(
        description="The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.",
        default=...,
    )
    rule: CodeScanningAlertReopenedByUserPropAlertPropRule = Field(default=...)
    tool: CodeScanningAlertReopenedByUserPropAlertPropTool = Field(default=...)


class CodeScanningAlertReopenedByUserPropAlertPropInstancesItems(GitHubWebhookModel):
    """CodeScanningAlertReopenedByUserPropAlertPropInstancesItems"""

    ref: str = Field(
        description="The full Git reference, formatted as `refs/heads/<branch name>`.",
        default=...,
    )
    analysis_key: str = Field(
        description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.",
        default=...,
    )
    environment: str = Field(
        description="Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.",
        default=...,
    )
    state: Literal["open"] = Field(default=...)
    commit_sha: Union[Unset, str] = Field(default=UNSET)
    message: Union[Unset, AlertInstancePropMessage] = Field(default=UNSET)
    location: Union[Unset, AlertInstancePropLocation] = Field(default=UNSET)
    classifications: Union[Unset, List[str]] = Field(default=UNSET)


class CodeScanningAlertReopenedByUserPropAlertPropInstancesItemsAllof1(
    GitHubWebhookModel
):
    """CodeScanningAlertReopenedByUserPropAlertPropInstancesItemsAllof1"""

    state: Literal["open"] = Field(default=...)


class CodeScanningAlertReopenedByUserPropAlertPropRule(GitHubWebhookModel):
    """CodeScanningAlertReopenedByUserPropAlertPropRule"""

    id: str = Field(
        description="A unique identifier for the rule used to detect the alert.",
        default=...,
    )
    severity: Union[None, Literal["none", "note", "warning", "error"]] = Field(
        description="The severity of the alert.", default=...
    )
    description: str = Field(
        description="A short description of the rule used to detect the alert.",
        default=...,
    )


class CodeScanningAlertReopenedByUserPropAlertPropTool(GitHubWebhookModel):
    """CodeScanningAlertReopenedByUserPropAlertPropTool"""

    name: str = Field(
        description="The name of the tool used to generate the code scanning analysis alert.",
        default=...,
    )
    version: Union[str, None] = Field(
        description="The version of the tool used to detect the alert.", default=...
    )


class CommitCommentCreated(GitHubWebhookModel):
    """commit_comment created event

    A commit comment is created. The type of activity is specified in the `action`
    property.
    """

    action: Literal["created"] = Field(
        description="The action performed. Can be `created`.", default=...
    )
    comment: CommitCommentCreatedPropComment = Field(
        description="The [commit comment](https://docs.github.com/en/rest/reference/repos#get-a-commit-comment) resource.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class CommitCommentCreatedPropComment(GitHubWebhookModel):
    """CommitCommentCreatedPropComment

    The [commit comment](https://docs.github.com/en/rest/reference/repos#get-a-
    commit-comment) resource.
    """

    url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(description="The ID of the commit comment.", default=...)
    node_id: str = Field(description="The node ID of the commit comment.", default=...)
    user: User = Field(title="User", default=...)
    position: Union[int, None] = Field(
        description="The line index in the diff to which the comment applies.",
        default=...,
    )
    line: Union[int, None] = Field(
        description="The line of the blob to which the comment applies. The last line of the range for a multi-line comment",
        default=...,
    )
    path: Union[str, None] = Field(
        description="The relative path of the file to which the comment applies.",
        default=...,
    )
    commit_id: str = Field(
        description="The SHA of the commit to which the comment applies.", default=...
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: str = Field(description="The text of the comment.", default=...)


class CreateEvent(GitHubWebhookModel):
    """create event

    A Git branch or tag is created.
    """

    ref: str = Field(
        description="The [`git ref`](https://docs.github.com/en/rest/reference/git#get-a-reference) resource.",
        default=...,
    )
    ref_type: Literal["tag", "branch"] = Field(
        description="The type of Git ref object created in the repository. Can be either `branch` or `tag`.",
        default=...,
    )
    master_branch: str = Field(
        description="The name of the repository's default branch (usually `main`).",
        default=...,
    )
    description: Union[str, None] = Field(
        description="The repository's current description.", default=...
    )
    pusher_type: str = Field(
        description="The pusher type for the event. Can be either `user` or a deploy key.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DeleteEvent(GitHubWebhookModel):
    """delete event

    A Git branch or tag is deleted.
    """

    ref: str = Field(
        description="The [`git ref`](https://docs.github.com/en/rest/reference/git#get-a-reference) resource.",
        default=...,
    )
    ref_type: Literal["tag", "branch"] = Field(
        description="The type of Git ref object deleted in the repository. Can be either `branch` or `tag`.",
        default=...,
    )
    pusher_type: str = Field(
        description="The pusher type for the event. Can be either `user` or a deploy key.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DependabotAlertCreated(GitHubWebhookModel):
    """dependabot_alert created event"""

    action: Literal["created"] = Field(default=...)
    alert: DependabotAlertCreatedPropAlert = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: GithubOrg = Field(title="GitHub Org", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DependabotAlertCreatedPropAlert(GitHubWebhookModel):
    """DependabotAlertCreatedPropAlert"""

    number: int = Field(description="The security alert number.", default=...)
    state: Literal["open"] = Field(default=...)
    dependency: DependabotAlertPropDependency = Field(
        description="Details for the vulnerable dependency.", default=...
    )
    security_advisory: DependabotAlertPropSecurityAdvisory = Field(
        description="Details for the GitHub Security Advisory.", default=...
    )
    security_vulnerability: DependabotAlertPropSecurityVulnerability = Field(
        description="Details pertaining to one vulnerable version range for the advisory.",
        default=...,
    )
    url: str = Field(description="The REST API URL of the alert resource.", default=...)
    html_url: str = Field(
        description="The GitHub URL of the alert resource.", default=...
    )
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_at: Union[None, None] = Field(default=...)
    dismissed_by: Union[None, None] = Field(default=...)
    dismissed_reason: Union[None, None] = Field(default=...)
    dismissed_comment: Union[None, None] = Field(default=...)
    fixed_at: Union[None, None] = Field(default=...)


class DependabotAlert(GitHubWebhookModel):
    """dependabot alert

    A Dependabot alert.
    """

    number: int = Field(description="The security alert number.", default=...)
    state: Literal["dismissed", "fixed", "open"] = Field(
        description="The state of the Dependabot alert.", default=...
    )
    dependency: DependabotAlertPropDependency = Field(
        description="Details for the vulnerable dependency.", default=...
    )
    security_advisory: DependabotAlertPropSecurityAdvisory = Field(
        description="Details for the GitHub Security Advisory.", default=...
    )
    security_vulnerability: DependabotAlertPropSecurityVulnerability = Field(
        description="Details pertaining to one vulnerable version range for the advisory.",
        default=...,
    )
    url: str = Field(description="The REST API URL of the alert resource.", default=...)
    html_url: str = Field(
        description="The GitHub URL of the alert resource.", default=...
    )
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_by: Union[User, None] = Field(title="User", default=...)
    dismissed_reason: Union[
        None,
        Literal[
            "fix_started", "inaccurate", "no_bandwidth", "not_used", "tolerable_risk"
        ],
    ] = Field(description="The reason that the alert was dismissed.", default=...)
    dismissed_comment: Union[str, None] = Field(
        description="An optional comment associated with the alert's dismissal.",
        default=...,
    )
    fixed_at: Union[datetime, None] = Field(
        description="The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )


class DependabotAlertPropDependency(GitHubWebhookModel):
    """DependabotAlertPropDependency

    Details for the vulnerable dependency.
    """

    package: DependabotAlertPackage = Field(
        title="dependabot_alert package",
        description="Details for the vulnerable package.",
        default=...,
    )
    manifest_path: str = Field(
        description="The full path to the dependency manifest file, relative to the root of the repository.",
        default=...,
    )
    scope: Union[None, Literal["development", "runtime"]] = Field(
        description="The execution scope of the vulnerable dependency.", default=...
    )


class DependabotAlertPackage(GitHubWebhookModel):
    """dependabot_alert package

    Details for the vulnerable package.
    """

    name: str = Field(
        description="The unique package name within its ecosystem.", default=...
    )
    ecosystem: str = Field(
        description="The package's language or package management ecosystem.",
        default=...,
    )


class DependabotAlertPropSecurityAdvisory(GitHubWebhookModel):
    """DependabotAlertPropSecurityAdvisory

    Details for the GitHub Security Advisory.
    """

    ghsa_id: str = Field(
        description="Details for the GitHub Security Advisory.", default=...
    )
    cve_id: Union[str, None] = Field(
        description="The unique CVE ID assigned to the advisory.", default=...
    )
    summary: str = Field(
        description="A short, plain text summary of the advisory.", default=...
    )
    description: str = Field(
        description="A long-form Markdown-supported description of the advisory.",
        default=...,
    )
    vulnerabilities: List[
        DependabotAlertPropSecurityAdvisoryPropVulnerabilitiesItems
    ] = Field(
        description="Vulnerable version range information for the advisory.",
        default=...,
    )
    severity: Literal["low", "medium", "high", "critical"] = Field(
        description="The severity of the advisory.", default=...
    )
    cvss: SecurityAdvisoryCvss = Field(
        title="security_advisory cvss",
        description="Details for the advisory pertaining to the Common Vulnerability Scoring System.",
        default=...,
    )
    cwes: List[SecurityAdvisoryCwes] = Field(
        description="Details for the advisory pertaining to Common Weakness Enumeration.",
        default=...,
    )
    identifiers: List[DependabotAlertPropSecurityAdvisoryPropIdentifiersItems] = Field(
        description="Values that identify this advisory among security information sources.",
        default=...,
    )
    references: List[DependabotAlertPropSecurityAdvisoryPropReferencesItems] = Field(
        description="Links to additional advisory information.", default=...
    )
    published_at: datetime = Field(
        description="The time that the advisory was published in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The time that the advisory was last modified in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    withdrawn_at: Union[datetime, None] = Field(
        description="The time that the advisory was withdrawn in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )


class DependabotAlertPropSecurityAdvisoryPropVulnerabilitiesItems(GitHubWebhookModel):
    """DependabotAlertPropSecurityAdvisoryPropVulnerabilitiesItems

    Details pertaining to one vulnerable version range for the advisory.
    """

    package: DependabotAlertPackage = Field(
        title="dependabot_alert package",
        description="Details for the vulnerable package.",
        default=...,
    )
    severity: Literal["low", "medium", "high", "critical"] = Field(
        description="The severity of the vulnerability.", default=...
    )
    vulnerable_version_range: str = Field(
        description="Conditions that identify vulnerable versions of this vulnerability's package.",
        default=...,
    )
    first_patched_version: DependabotAlertPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersion = Field(
        description="Details pertaining to the package version that patches this vulnerability.",
        default=...,
    )


class DependabotAlertPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersion(
    GitHubWebhookModel
):
    """DependabotAlertPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersi
    on

    Details pertaining to the package version that patches this vulnerability.
    """

    identifier: str = Field(
        description="The package version that patches this vulnerability.", default=...
    )


class SecurityAdvisoryCvss(GitHubWebhookModel):
    """security_advisory cvss

    Details for the advisory pertaining to the Common Vulnerability Scoring System.
    """

    score: float = Field(
        description="The overall CVSS score of the advisory.", le=10.0, default=...
    )
    vector_string: Union[str, None] = Field(
        description="The full CVSS vector string for the advisory.", default=...
    )


class SecurityAdvisoryCwes(GitHubWebhookModel):
    """security_advisory cwes

    A CWE weakness assigned to the advisory.
    """

    cwe_id: str = Field(description="The unique CWE ID.", default=...)
    name: str = Field(description="The short, plain text name of the CWE.", default=...)


class DependabotAlertPropSecurityAdvisoryPropIdentifiersItems(GitHubWebhookModel):
    """DependabotAlertPropSecurityAdvisoryPropIdentifiersItems

    An advisory identifier.
    """

    type: Literal["CVE", "GHSA"] = Field(
        description="The type of advisory identifier.", default=...
    )
    value: str = Field(description="The value of the advisory identifer.", default=...)


class DependabotAlertPropSecurityAdvisoryPropReferencesItems(GitHubWebhookModel):
    """DependabotAlertPropSecurityAdvisoryPropReferencesItems"""

    url: str = Field(description="The URL of the reference.", default=...)


class DependabotAlertPropSecurityVulnerability(GitHubWebhookModel):
    """DependabotAlertPropSecurityVulnerability

    Details pertaining to one vulnerable version range for the advisory.
    """

    package: DependabotAlertPackage = Field(
        title="dependabot_alert package",
        description="Details for the vulnerable package.",
        default=...,
    )
    severity: Literal["low", "medium", "high", "critical"] = Field(
        description="The severity of the vulnerability.", default=...
    )
    vulnerable_version_range: str = Field(
        description="Conditions that identify vulnerable versions of this vulnerability's package.",
        default=...,
    )
    first_patched_version: DependabotAlertPropSecurityVulnerabilityPropFirstPatchedVersion = Field(
        description="Details pertaining to the package version that patches this vulnerability.",
        default=...,
    )


class DependabotAlertPropSecurityVulnerabilityPropFirstPatchedVersion(
    GitHubWebhookModel
):
    """DependabotAlertPropSecurityVulnerabilityPropFirstPatchedVersion

    Details pertaining to the package version that patches this vulnerability.
    """

    identifier: str = Field(
        description="The package version that patches this vulnerability.", default=...
    )


class DependabotAlertCreatedPropAlertAllof1(GitHubWebhookModel):
    """DependabotAlertCreatedPropAlertAllof1"""

    state: Literal["open"] = Field(default=...)
    fixed_at: None = Field(default=...)
    dismissed_at: None = Field(default=...)
    dismissed_by: None = Field(default=...)
    dismissed_reason: None = Field(default=...)
    dismissed_comment: None = Field(default=...)


class DependabotAlertDismissed(GitHubWebhookModel):
    """dependabot_alert dismissed event"""

    action: Literal["dismissed"] = Field(default=...)
    alert: DependabotAlertDismissedPropAlert = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DependabotAlertDismissedPropAlert(GitHubWebhookModel):
    """DependabotAlertDismissedPropAlert"""

    number: int = Field(description="The security alert number.", default=...)
    state: Literal["dismissed"] = Field(default=...)
    dependency: DependabotAlertPropDependency = Field(
        description="Details for the vulnerable dependency.", default=...
    )
    security_advisory: DependabotAlertPropSecurityAdvisory = Field(
        description="Details for the GitHub Security Advisory.", default=...
    )
    security_vulnerability: DependabotAlertPropSecurityVulnerability = Field(
        description="Details pertaining to one vulnerable version range for the advisory.",
        default=...,
    )
    url: str = Field(description="The REST API URL of the alert resource.", default=...)
    html_url: str = Field(
        description="The GitHub URL of the alert resource.", default=...
    )
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_at: datetime = Field(default=...)
    dismissed_by: User = Field(title="User", default=...)
    dismissed_reason: Literal[
        "fix_started", "inaccurate", "no_bandwidth", "not_used", "tolerable_risk"
    ] = Field(default=...)
    dismissed_comment: Union[str, None] = Field(
        description="An optional comment associated with the alert's dismissal.",
        default=...,
    )
    fixed_at: Union[datetime, None] = Field(
        description="The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )


class DependabotAlertDismissedPropAlertAllof1(GitHubWebhookModel):
    """DependabotAlertDismissedPropAlertAllof1"""

    state: Literal["dismissed"] = Field(default=...)
    dismissed_at: datetime = Field(default=...)
    dismissed_by: User = Field(title="User", default=...)
    dismissed_reason: Literal[
        "fix_started", "inaccurate", "no_bandwidth", "not_used", "tolerable_risk"
    ] = Field(default=...)


class DependabotAlertFixed(GitHubWebhookModel):
    """dependabot_alert fixed event"""

    action: Literal["fixed"] = Field(default=...)
    alert: DependabotAlertFixedPropAlert = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: GithubOrg = Field(title="GitHub Org", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DependabotAlertFixedPropAlert(GitHubWebhookModel):
    """DependabotAlertFixedPropAlert"""

    number: int = Field(description="The security alert number.", default=...)
    state: Literal["fixed"] = Field(default=...)
    dependency: DependabotAlertPropDependency = Field(
        description="Details for the vulnerable dependency.", default=...
    )
    security_advisory: DependabotAlertPropSecurityAdvisory = Field(
        description="Details for the GitHub Security Advisory.", default=...
    )
    security_vulnerability: DependabotAlertPropSecurityVulnerability = Field(
        description="Details pertaining to one vulnerable version range for the advisory.",
        default=...,
    )
    url: str = Field(description="The REST API URL of the alert resource.", default=...)
    html_url: str = Field(
        description="The GitHub URL of the alert resource.", default=...
    )
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_by: Union[User, None] = Field(title="User", default=...)
    dismissed_reason: Union[
        None,
        Literal[
            "fix_started", "inaccurate", "no_bandwidth", "not_used", "tolerable_risk"
        ],
    ] = Field(description="The reason that the alert was dismissed.", default=...)
    dismissed_comment: Union[str, None] = Field(
        description="An optional comment associated with the alert's dismissal.",
        default=...,
    )
    fixed_at: datetime = Field(default=...)


class DependabotAlertFixedPropAlertAllof1(GitHubWebhookModel):
    """DependabotAlertFixedPropAlertAllof1"""

    state: Literal["fixed"] = Field(default=...)
    fixed_at: datetime = Field(default=...)


class DependabotAlertReintroduced(GitHubWebhookModel):
    """dependabot_alert reintroduced event"""

    action: Literal["reintroduced"] = Field(default=...)
    alert: DependabotAlert = Field(
        title="dependabot alert", description="A Dependabot alert.", default=...
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: GithubOrg = Field(title="GitHub Org", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DependabotAlertReopened(GitHubWebhookModel):
    """dependabot_alert reopened event"""

    action: Literal["reopened"] = Field(default=...)
    alert: DependabotAlert = Field(
        title="dependabot alert", description="A Dependabot alert.", default=...
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DeployKeyCreated(GitHubWebhookModel):
    """deploy_key created event"""

    action: Literal["created"] = Field(default=...)
    key: DeployKeyCreatedPropKey = Field(
        description="The [`deploy key`](https://docs.github.com/en/rest/reference/deployments#get-a-deploy-key) resource.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DeployKeyCreatedPropKey(GitHubWebhookModel):
    """DeployKeyCreatedPropKey

    The [`deploy key`](https://docs.github.com/en/rest/reference/deployments#get-a-
    deploy-key) resource.
    """

    id: int = Field(default=...)
    key: str = Field(default=...)
    url: str = Field(default=...)
    title: str = Field(default=...)
    verified: bool = Field(default=...)
    created_at: datetime = Field(default=...)
    read_only: bool = Field(default=...)


class DeployKeyDeleted(GitHubWebhookModel):
    """deploy_key deleted event"""

    action: Literal["deleted"] = Field(default=...)
    key: DeployKeyDeletedPropKey = Field(
        description="The [`deploy key`](https://docs.github.com/en/rest/reference/deployments#get-a-deploy-key) resource.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DeployKeyDeletedPropKey(GitHubWebhookModel):
    """DeployKeyDeletedPropKey

    The [`deploy key`](https://docs.github.com/en/rest/reference/deployments#get-a-
    deploy-key) resource.
    """

    id: int = Field(default=...)
    key: str = Field(default=...)
    url: str = Field(default=...)
    title: str = Field(default=...)
    verified: bool = Field(default=...)
    created_at: datetime = Field(default=...)
    read_only: bool = Field(default=...)


class DeploymentCreated(GitHubWebhookModel):
    """deployment created event"""

    action: Literal["created"] = Field(default=...)
    deployment: Deployment = Field(
        title="Deployment",
        description="The [deployment](https://docs.github.com/en/rest/reference/deployments#list-deployments).",
        default=...,
    )
    workflow: Union[Workflow, None] = Field(title="Workflow", default=...)
    workflow_run: Union[DeploymentWorkflowRun, None] = Field(
        title="Deployment Workflow Run", default=...
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class Deployment(GitHubWebhookModel):
    """Deployment

    The [deployment](https://docs.github.com/en/rest/reference/deployments#list-
    deployments).
    """

    url: str = Field(default=...)
    id: int = Field(description="Unique identifier of the deployment", default=...)
    node_id: str = Field(default=...)
    sha: str = Field(default=...)
    ref: str = Field(
        description="The ref to deploy. This can be a branch, tag, or sha.", default=...
    )
    task: str = Field(description="Parameter to specify a task to execute", default=...)
    payload: DeploymentPropPayload = Field(default=...)
    original_environment: str = Field(default=...)
    environment: str = Field(
        description="Name of the target deployment environment.", default=...
    )
    transient_environment: Union[Unset, bool] = Field(
        description="Specifies if the given environment will no longer exist at some point in the future. Default: false.",
        default=UNSET,
    )
    production_environment: Union[Unset, bool] = Field(
        description="Specifies if the given environment is one that end-users directly interact with. Default: false.",
        default=UNSET,
    )
    description: Union[str, None] = Field(default=...)
    creator: User = Field(title="User", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    statuses_url: str = Field(default=...)
    repository_url: str = Field(default=...)
    performed_via_github_app: Union[Unset, Union[App, None]] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )


class DeploymentPropPayload(GitHubWebhookModel, extra=Extra.allow):
    """DeploymentPropPayload"""


class Workflow(GitHubWebhookModel):
    """Workflow"""

    badge_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(default=...)
    node_id: str = Field(default=...)
    path: str = Field(default=...)
    state: str = Field(default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)


class DeploymentWorkflowRun(GitHubWebhookModel):
    """Deployment Workflow Run"""

    id: int = Field(default=...)
    name: str = Field(default=...)
    path: Union[Unset, str] = Field(default=UNSET)
    display_title: Union[Unset, str] = Field(default=UNSET)
    node_id: str = Field(default=...)
    head_branch: str = Field(default=...)
    head_sha: str = Field(default=...)
    run_number: int = Field(default=...)
    event: str = Field(default=...)
    status: Literal["requested", "in_progress", "completed", "queued"] = Field(
        default=...
    )
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
        ],
    ] = Field(default=...)
    workflow_id: int = Field(default=...)
    check_suite_id: int = Field(default=...)
    check_suite_node_id: str = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    pull_requests: List[CheckRunPullRequest] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    actor: User = Field(title="User", default=...)
    triggering_actor: User = Field(title="User", default=...)
    run_attempt: int = Field(default=...)
    run_started_at: datetime = Field(default=...)
    referenced_workflows: Union[Unset, List[ReferencedWorkflow]] = Field(default=UNSET)


class ReferencedWorkflow(GitHubWebhookModel):
    """Referenced workflow

    A workflow referenced/reused by the initial caller workflow
    """

    path: str = Field(default=...)
    sha: str = Field(default=...)
    ref: Union[Unset, str] = Field(default=UNSET)


class DeploymentStatusCreated(GitHubWebhookModel):
    """deployment_status created event"""

    action: Literal["created"] = Field(default=...)
    deployment_status: DeploymentStatusCreatedPropDeploymentStatus = Field(
        description="The [deployment status](https://docs.github.com/en/rest/reference/deployments#list-deployment-statuses).",
        default=...,
    )
    deployment: Deployment = Field(
        title="Deployment",
        description="The [deployment](https://docs.github.com/en/rest/reference/deployments#list-deployments).",
        default=...,
    )
    check_run: Union[Unset, DeploymentStatusCreatedPropCheckRun] = Field(default=UNSET)
    workflow_run: Union[Unset, DeploymentWorkflowRun] = Field(
        title="Deployment Workflow Run", default=UNSET
    )
    workflow: Union[Unset, Workflow] = Field(title="Workflow", default=UNSET)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DeploymentStatusCreatedPropDeploymentStatus(GitHubWebhookModel):
    """DeploymentStatusCreatedPropDeploymentStatus

    The [deployment
    status](https://docs.github.com/en/rest/reference/deployments#list-deployment-
    statuses).
    """

    url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    state: str = Field(
        description="The new state. Can be `pending`, `success`, `failure`, or `error`.",
        default=...,
    )
    creator: User = Field(title="User", default=...)
    description: str = Field(
        description="The optional human-readable description added to the status.",
        default=...,
    )
    environment: str = Field(default=...)
    environment_url: Union[Unset, Union[str, Literal[""]]] = Field(default=UNSET)
    log_url: Union[Unset, str] = Field(default=UNSET)
    target_url: str = Field(
        description="The optional link added to the status.", default=...
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    deployment_url: str = Field(default=...)
    repository_url: str = Field(default=...)
    performed_via_github_app: Union[Unset, Union[App, None]] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )


class DeploymentStatusCreatedPropCheckRun(GitHubWebhookModel):
    """DeploymentStatusCreatedPropCheckRun"""

    id: int = Field(description="The id of the check.", default=...)
    name: str = Field(description="The name of the check run.", default=...)
    node_id: str = Field(default=...)
    head_sha: str = Field(
        description="The SHA of the commit that is being checked.", default=...
    )
    external_id: str = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    details_url: str = Field(default=...)
    status: Literal["queued", "in_progress", "completed", "waiting"] = Field(
        description="The current status of the check run. Can be `queued`, `in_progress`, or `completed`.",
        default=...,
    )
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
            "skipped",
        ],
    ] = Field(
        description="The result of the completed check run. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.",
        default=...,
    )
    started_at: datetime = Field(default=...)
    completed_at: Union[datetime, None] = Field(default=...)


class DiscussionAnswered(GitHubWebhookModel):
    """discussion answered event"""

    action: Literal["answered"] = Field(default=...)
    discussion: DiscussionAnsweredPropDiscussion = Field(default=...)
    answer: DiscussionAnsweredPropAnswer = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DiscussionAnsweredPropDiscussion(GitHubWebhookModel):
    """DiscussionAnsweredPropDiscussion"""

    repository_url: str = Field(default=...)
    category: DiscussionAnsweredPropDiscussionMergedCategory = Field(default=...)
    answer_html_url: str = Field(default=...)
    answer_chosen_at: datetime = Field(default=...)
    answer_chosen_by: User = Field(title="User", default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    title: str = Field(description="The discussion post's title.", default=...)
    user: User = Field(title="User", default=...)
    state: Literal["open", "locked", "converting"] = Field(default=...)
    locked: bool = Field(default=...)
    comments: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    active_lock_reason: Union[str, None] = Field(default=...)
    body: str = Field(description="The discussion post's body text.", default=...)
    reactions: Union[Unset, Reactions] = Field(title="Reactions", default=UNSET)


class Discussion(GitHubWebhookModel):
    """Discussion"""

    repository_url: str = Field(default=...)
    category: DiscussionPropCategory = Field(default=...)
    answer_html_url: Union[str, None] = Field(default=...)
    answer_chosen_at: Union[datetime, None] = Field(default=...)
    answer_chosen_by: Union[User, None] = Field(title="User", default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    title: str = Field(description="The discussion post's title.", default=...)
    user: User = Field(title="User", default=...)
    state: Literal["open", "locked", "converting"] = Field(default=...)
    locked: bool = Field(default=...)
    comments: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    active_lock_reason: Union[str, None] = Field(default=...)
    body: str = Field(description="The discussion post's body text.", default=...)
    reactions: Union[Unset, Reactions] = Field(title="Reactions", default=UNSET)


class DiscussionPropCategory(GitHubWebhookModel):
    """DiscussionPropCategory"""

    id: int = Field(default=...)
    repository_id: int = Field(default=...)
    emoji: str = Field(default=...)
    name: str = Field(default=...)
    description: str = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    slug: str = Field(default=...)
    is_answerable: bool = Field(default=...)


class Reactions(GitHubWebhookModel):
    """Reactions"""

    url: str = Field(default=...)
    total_count: int = Field(default=...)
    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    laugh: int = Field(default=...)
    hooray: int = Field(default=...)
    confused: int = Field(default=...)
    heart: int = Field(default=...)
    rocket: int = Field(default=...)
    eyes: int = Field(default=...)


class DiscussionAnsweredPropDiscussionAllof1(GitHubWebhookModel):
    """DiscussionAnsweredPropDiscussionAllof1"""

    category: DiscussionAnsweredPropDiscussionAllof1PropCategory = Field(default=...)
    answer_html_url: str = Field(default=...)
    answer_chosen_at: datetime = Field(default=...)
    answer_chosen_by: User = Field(title="User", default=...)


class DiscussionAnsweredPropDiscussionAllof1PropCategory(GitHubWebhookModel):
    """DiscussionAnsweredPropDiscussionAllof1PropCategory"""

    is_answerable: Literal[True] = Field(default=...)


class DiscussionAnsweredPropDiscussionMergedCategory(GitHubWebhookModel):
    """DiscussionAnsweredPropDiscussionMergedCategory"""

    id: int = Field(default=...)
    repository_id: int = Field(default=...)
    emoji: str = Field(default=...)
    name: str = Field(default=...)
    description: str = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    slug: str = Field(default=...)
    is_answerable: Literal[True] = Field(default=...)


class DiscussionAnsweredPropAnswer(GitHubWebhookModel):
    """DiscussionAnsweredPropAnswer"""

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    parent_id: None = Field(default=...)
    child_comment_count: int = Field(default=...)
    repository_url: str = Field(default=...)
    discussion_id: int = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    user: User = Field(title="User", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    body: str = Field(default=...)


class DiscussionCategoryChanged(GitHubWebhookModel):
    """discussion category changed event"""

    changes: DiscussionCategoryChangedPropChanges = Field(default=...)
    action: Literal["category_changed"] = Field(default=...)
    discussion: Discussion = Field(title="Discussion", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DiscussionCategoryChangedPropChanges(GitHubWebhookModel):
    """DiscussionCategoryChangedPropChanges"""

    category: DiscussionCategoryChangedPropChangesPropCategory = Field(default=...)


class DiscussionCategoryChangedPropChangesPropCategory(GitHubWebhookModel):
    """DiscussionCategoryChangedPropChangesPropCategory"""

    from_: DiscussionCategoryChangedPropChangesPropCategoryPropFrom = Field(
        default=..., alias="from"
    )


class DiscussionCategoryChangedPropChangesPropCategoryPropFrom(GitHubWebhookModel):
    """DiscussionCategoryChangedPropChangesPropCategoryPropFrom"""

    id: int = Field(default=...)
    repository_id: int = Field(default=...)
    emoji: str = Field(default=...)
    name: str = Field(default=...)
    description: str = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    slug: str = Field(default=...)
    is_answerable: bool = Field(default=...)


class DiscussionCreated(GitHubWebhookModel):
    """discussion created event"""

    action: Literal["created"] = Field(default=...)
    discussion: DiscussionCreatedPropDiscussion = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DiscussionCreatedPropDiscussion(GitHubWebhookModel):
    """DiscussionCreatedPropDiscussion"""

    repository_url: str = Field(default=...)
    category: DiscussionPropCategory = Field(default=...)
    answer_html_url: Union[None, None] = Field(default=...)
    answer_chosen_at: Union[None, None] = Field(default=...)
    answer_chosen_by: Union[None, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    title: str = Field(description="The discussion post's title.", default=...)
    user: User = Field(title="User", default=...)
    state: Literal["open", "converting"] = Field(default=...)
    locked: Literal[False] = Field(default=...)
    comments: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    active_lock_reason: Union[str, None] = Field(default=...)
    body: str = Field(description="The discussion post's body text.", default=...)
    reactions: Union[Unset, Reactions] = Field(title="Reactions", default=UNSET)


class DiscussionCreatedPropDiscussionAllof1(GitHubWebhookModel):
    """DiscussionCreatedPropDiscussionAllof1"""

    state: Literal["open", "converting"] = Field(default=...)
    locked: Literal[False] = Field(default=...)
    answer_html_url: None = Field(default=...)
    answer_chosen_at: None = Field(default=...)
    answer_chosen_by: None = Field(default=...)


class DiscussionDeleted(GitHubWebhookModel):
    """discussion deleted event"""

    action: Literal["deleted"] = Field(default=...)
    discussion: Discussion = Field(title="Discussion", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DiscussionEdited(GitHubWebhookModel):
    """discussion edited event"""

    changes: Union[Unset, DiscussionEditedPropChanges] = Field(default=UNSET)
    action: Literal["edited"] = Field(default=...)
    discussion: Discussion = Field(title="Discussion", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DiscussionEditedPropChanges(GitHubWebhookModel):
    """DiscussionEditedPropChanges"""

    title: Union[Unset, DiscussionEditedPropChangesPropTitle] = Field(default=UNSET)
    body: Union[Unset, DiscussionEditedPropChangesPropBody] = Field(default=UNSET)


class DiscussionEditedPropChangesPropTitle(GitHubWebhookModel):
    """DiscussionEditedPropChangesPropTitle"""

    from_: str = Field(default=..., alias="from")


class DiscussionEditedPropChangesPropBody(GitHubWebhookModel):
    """DiscussionEditedPropChangesPropBody"""

    from_: str = Field(default=..., alias="from")


class DiscussionLabeled(GitHubWebhookModel):
    """discussion labeled event"""

    action: Literal["labeled"] = Field(default=...)
    discussion: Discussion = Field(title="Discussion", default=...)
    label: Label = Field(title="Label", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class Label(GitHubWebhookModel):
    """Label"""

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)
    name: str = Field(description="The name of the label.", default=...)
    description: Union[str, None] = Field(default=...)
    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)


class DiscussionLocked(GitHubWebhookModel):
    """discussion locked event"""

    action: Literal["locked"] = Field(default=...)
    discussion: DiscussionLockedPropDiscussion = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DiscussionLockedPropDiscussion(GitHubWebhookModel):
    """DiscussionLockedPropDiscussion"""

    repository_url: str = Field(default=...)
    category: DiscussionPropCategory = Field(default=...)
    answer_html_url: Union[str, None] = Field(default=...)
    answer_chosen_at: Union[datetime, None] = Field(default=...)
    answer_chosen_by: Union[User, None] = Field(title="User", default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    title: str = Field(description="The discussion post's title.", default=...)
    user: User = Field(title="User", default=...)
    state: Literal["locked"] = Field(default=...)
    locked: Literal[True] = Field(default=...)
    comments: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    active_lock_reason: Union[str, None] = Field(default=...)
    body: str = Field(description="The discussion post's body text.", default=...)
    reactions: Union[Unset, Reactions] = Field(title="Reactions", default=UNSET)


class DiscussionLockedPropDiscussionAllof1(GitHubWebhookModel):
    """DiscussionLockedPropDiscussionAllof1"""

    state: Literal["locked"] = Field(default=...)
    locked: Literal[True] = Field(default=...)


class DiscussionPinned(GitHubWebhookModel):
    """discussion pinned event"""

    action: Literal["pinned"] = Field(default=...)
    discussion: Discussion = Field(title="Discussion", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DiscussionTransferred(GitHubWebhookModel):
    """discussion transferred event"""

    changes: DiscussionTransferredPropChanges = Field(default=...)
    action: Literal["transferred"] = Field(default=...)
    discussion: Discussion = Field(title="Discussion", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DiscussionTransferredPropChanges(GitHubWebhookModel):
    """DiscussionTransferredPropChanges"""

    new_discussion: Discussion = Field(title="Discussion", default=...)
    new_repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )


class DiscussionUnanswered(GitHubWebhookModel):
    """discussion unanswered event"""

    action: Literal["unanswered"] = Field(default=...)
    discussion: DiscussionUnansweredPropDiscussion = Field(default=...)
    old_answer: DiscussionUnansweredPropOldAnswer = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DiscussionUnansweredPropDiscussion(GitHubWebhookModel):
    """DiscussionUnansweredPropDiscussion"""

    repository_url: str = Field(default=...)
    category: DiscussionUnansweredPropDiscussionMergedCategory = Field(default=...)
    answer_html_url: Union[None, None] = Field(default=...)
    answer_chosen_at: Union[None, None] = Field(default=...)
    answer_chosen_by: Union[None, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    title: str = Field(description="The discussion post's title.", default=...)
    user: User = Field(title="User", default=...)
    state: Literal["open", "locked", "converting"] = Field(default=...)
    locked: bool = Field(default=...)
    comments: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    active_lock_reason: Union[str, None] = Field(default=...)
    body: str = Field(description="The discussion post's body text.", default=...)
    reactions: Union[Unset, Reactions] = Field(title="Reactions", default=UNSET)


class DiscussionUnansweredPropDiscussionAllof1(GitHubWebhookModel):
    """DiscussionUnansweredPropDiscussionAllof1"""

    category: DiscussionUnansweredPropDiscussionAllof1PropCategory = Field(default=...)
    answer_html_url: None = Field(default=...)
    answer_chosen_at: None = Field(default=...)
    answer_chosen_by: None = Field(default=...)


class DiscussionUnansweredPropDiscussionAllof1PropCategory(GitHubWebhookModel):
    """DiscussionUnansweredPropDiscussionAllof1PropCategory"""

    is_answerable: Literal[True] = Field(default=...)


class DiscussionUnansweredPropDiscussionMergedCategory(GitHubWebhookModel):
    """DiscussionUnansweredPropDiscussionMergedCategory"""

    id: int = Field(default=...)
    repository_id: int = Field(default=...)
    emoji: str = Field(default=...)
    name: str = Field(default=...)
    description: str = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    slug: str = Field(default=...)
    is_answerable: Literal[True] = Field(default=...)


class DiscussionUnansweredPropOldAnswer(GitHubWebhookModel):
    """DiscussionUnansweredPropOldAnswer"""

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    parent_id: None = Field(default=...)
    child_comment_count: int = Field(default=...)
    repository_url: str = Field(default=...)
    discussion_id: int = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    user: User = Field(title="User", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    body: str = Field(default=...)


class DiscussionUnlabeled(GitHubWebhookModel):
    """discussion unlabeled event"""

    action: Literal["unlabeled"] = Field(default=...)
    discussion: Discussion = Field(title="Discussion", default=...)
    label: Label = Field(title="Label", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DiscussionUnlocked(GitHubWebhookModel):
    """discussion unlocked event"""

    action: Literal["unlocked"] = Field(default=...)
    discussion: DiscussionUnlockedPropDiscussion = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DiscussionUnlockedPropDiscussion(GitHubWebhookModel):
    """DiscussionUnlockedPropDiscussion"""

    repository_url: str = Field(default=...)
    category: DiscussionPropCategory = Field(default=...)
    answer_html_url: Union[str, None] = Field(default=...)
    answer_chosen_at: Union[datetime, None] = Field(default=...)
    answer_chosen_by: Union[User, None] = Field(title="User", default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    title: str = Field(description="The discussion post's title.", default=...)
    user: User = Field(title="User", default=...)
    state: Literal["open"] = Field(default=...)
    locked: Literal[False] = Field(default=...)
    comments: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    active_lock_reason: Union[str, None] = Field(default=...)
    body: str = Field(description="The discussion post's body text.", default=...)
    reactions: Union[Unset, Reactions] = Field(title="Reactions", default=UNSET)


class DiscussionUnlockedPropDiscussionAllof1(GitHubWebhookModel):
    """DiscussionUnlockedPropDiscussionAllof1"""

    state: Literal["open"] = Field(default=...)
    locked: Literal[False] = Field(default=...)


class DiscussionUnpinned(GitHubWebhookModel):
    """discussion unpinned event"""

    action: Literal["unpinned"] = Field(default=...)
    discussion: Discussion = Field(title="Discussion", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DiscussionCommentCreated(GitHubWebhookModel):
    """discussion_comment created event"""

    action: Literal["created"] = Field(default=...)
    comment: DiscussionCommentCreatedPropComment = Field(default=...)
    discussion: Discussion = Field(title="Discussion", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: InstallationLite = Field(
        title="InstallationLite", description="Installation", default=...
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DiscussionCommentCreatedPropComment(GitHubWebhookModel):
    """DiscussionCommentCreatedPropComment"""

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    parent_id: Union[int, None] = Field(default=...)
    child_comment_count: int = Field(default=...)
    repository_url: str = Field(default=...)
    discussion_id: int = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    user: User = Field(title="User", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    body: str = Field(description="The main text of the comment.", default=...)
    reactions: Reactions = Field(title="Reactions", default=...)


class DiscussionCommentDeleted(GitHubWebhookModel):
    """discussion_comment deleted event"""

    action: Literal["deleted"] = Field(default=...)
    comment: DiscussionCommentDeletedPropComment = Field(default=...)
    discussion: Discussion = Field(title="Discussion", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: InstallationLite = Field(
        title="InstallationLite", description="Installation", default=...
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DiscussionCommentDeletedPropComment(GitHubWebhookModel):
    """DiscussionCommentDeletedPropComment"""

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    parent_id: Union[int, None] = Field(default=...)
    child_comment_count: int = Field(default=...)
    repository_url: str = Field(default=...)
    discussion_id: int = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    user: User = Field(title="User", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    body: str = Field(description="The main text of the comment.", default=...)
    reactions: Reactions = Field(title="Reactions", default=...)


class DiscussionCommentEdited(GitHubWebhookModel):
    """discussion_comment edited event"""

    changes: DiscussionCommentEditedPropChanges = Field(default=...)
    action: Literal["edited"] = Field(default=...)
    comment: DiscussionCommentEditedPropComment = Field(default=...)
    discussion: Discussion = Field(title="Discussion", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: InstallationLite = Field(
        title="InstallationLite", description="Installation", default=...
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class DiscussionCommentEditedPropChanges(GitHubWebhookModel):
    """DiscussionCommentEditedPropChanges"""

    body: DiscussionCommentEditedPropChangesPropBody = Field(default=...)


class DiscussionCommentEditedPropChangesPropBody(GitHubWebhookModel):
    """DiscussionCommentEditedPropChangesPropBody"""

    from_: str = Field(default=..., alias="from")


class DiscussionCommentEditedPropComment(GitHubWebhookModel):
    """DiscussionCommentEditedPropComment"""

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    parent_id: Union[int, None] = Field(default=...)
    child_comment_count: int = Field(default=...)
    repository_url: str = Field(default=...)
    discussion_id: int = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    user: User = Field(title="User", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    body: str = Field(description="The main text of the comment.", default=...)
    reactions: Reactions = Field(title="Reactions", default=...)


class ForkEvent(GitHubWebhookModel):
    """fork event

    A user forks a repository.
    """

    forkee: ForkEventPropForkee = Field(
        description="The created [`repository`](https://docs.github.com/en/rest/reference/repos#get-a-repository) resource.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class ForkEventPropForkee(GitHubWebhookModel):
    """ForkEventPropForkee

    The created [`repository`](https://docs.github.com/en/rest/reference/repos#get-
    a-repository) resource.
    """

    id: int = Field(description="Unique identifier of the repository", default=...)
    node_id: str = Field(
        description="The GraphQL identifier of the repository.", default=...
    )
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(
        description="The full, globally unique, name of the repository.", default=...
    )
    private: bool = Field(
        description="Whether the repository is private or public.", default=...
    )
    owner: User = Field(title="User", default=...)
    html_url: str = Field(
        description="The URL to view the repository on GitHub.com.", default=...
    )
    description: Union[str, None] = Field(
        description="The repository description.", default=...
    )
    fork: Literal[True] = Field(default=...)
    url: str = Field(
        description="The URL to get more information about the repository from the GitHub API.",
        default=...,
    )
    forks_url: str = Field(
        description="The API URL to list the forks of the repository.", default=...
    )
    keys_url: str = Field(
        description="A template for the API URL to get information about deploy keys on the repository.",
        default=...,
    )
    collaborators_url: str = Field(
        description="A template for the API URL to get information about collaborators of the repository.",
        default=...,
    )
    teams_url: str = Field(
        description="The API URL to list the teams on the repository.", default=...
    )
    hooks_url: str = Field(
        description="The API URL to list the hooks on the repository.", default=...
    )
    issue_events_url: str = Field(
        description="A template for the API URL to get information about issue events on the repository.",
        default=...,
    )
    events_url: str = Field(
        description="The API URL to list the events of the repository.", default=...
    )
    assignees_url: str = Field(
        description="A template for the API URL to list the available assignees for issues in the repository.",
        default=...,
    )
    branches_url: str = Field(
        description="A template for the API URL to get information about branches in the repository.",
        default=...,
    )
    tags_url: str = Field(
        description="The API URL to get information about tags on the repository.",
        default=...,
    )
    blobs_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git blob in the repository.",
        default=...,
    )
    git_tags_url: str = Field(
        description="A template for the API URL to get information about Git tags of the repository.",
        default=...,
    )
    git_refs_url: str = Field(
        description="A template for the API URL to get information about Git refs of the repository.",
        default=...,
    )
    trees_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git tree of the repository.",
        default=...,
    )
    statuses_url: str = Field(
        description="A template for the API URL to get information about statuses of a commit.",
        default=...,
    )
    languages_url: str = Field(
        description="The API URL to get information about the languages of the repository.",
        default=...,
    )
    stargazers_url: str = Field(
        description="The API URL to list the stargazers on the repository.", default=...
    )
    contributors_url: str = Field(
        description="A template for the API URL to list the contributors to the repository.",
        default=...,
    )
    subscribers_url: str = Field(
        description="The API URL to list the subscribers on the repository.",
        default=...,
    )
    subscription_url: str = Field(
        description="The API URL to subscribe to notifications for this repository.",
        default=...,
    )
    commits_url: str = Field(
        description="A template for the API URL to get information about commits on the repository.",
        default=...,
    )
    git_commits_url: str = Field(
        description="A template for the API URL to get information about Git commits of the repository.",
        default=...,
    )
    comments_url: str = Field(
        description="A template for the API URL to get information about comments on the repository.",
        default=...,
    )
    issue_comment_url: str = Field(
        description="A template for the API URL to get information about issue comments on the repository.",
        default=...,
    )
    contents_url: str = Field(
        description="A template for the API URL to get the contents of the repository.",
        default=...,
    )
    compare_url: str = Field(
        description="A template for the API URL to compare two commits or refs.",
        default=...,
    )
    merges_url: str = Field(
        description="The API URL to merge branches in the repository.", default=...
    )
    archive_url: str = Field(
        description="A template for the API URL to download the repository as an archive.",
        default=...,
    )
    downloads_url: str = Field(
        description="The API URL to list the downloads on the repository.", default=...
    )
    issues_url: str = Field(
        description="A template for the API URL to get information about issues on the repository.",
        default=...,
    )
    pulls_url: str = Field(
        description="A template for the API URL to get information about pull requests on the repository.",
        default=...,
    )
    milestones_url: str = Field(
        description="A template for the API URL to get information about milestones of the repository.",
        default=...,
    )
    notifications_url: str = Field(
        description="A template for the API URL to get information about notifications on the repository.",
        default=...,
    )
    labels_url: str = Field(
        description="A template for the API URL to get information about labels of the repository.",
        default=...,
    )
    releases_url: str = Field(
        description="A template for the API URL to get information about releases on the repository.",
        default=...,
    )
    deployments_url: str = Field(
        description="The API URL to list the deployments of the repository.",
        default=...,
    )
    created_at: Union[int, datetime] = Field(default=...)
    updated_at: datetime = Field(default=...)
    pushed_at: Union[int, datetime, None] = Field(default=...)
    git_url: str = Field(default=...)
    ssh_url: str = Field(default=...)
    clone_url: str = Field(default=...)
    svn_url: str = Field(default=...)
    homepage: Union[str, None] = Field(default=...)
    size: int = Field(default=...)
    stargazers_count: int = Field(default=...)
    watchers_count: int = Field(default=...)
    language: Union[str, None] = Field(default=...)
    has_issues: bool = Field(description="Whether issues are enabled.", default=True)
    has_projects: bool = Field(
        description="Whether projects are enabled.", default=True
    )
    has_downloads: bool = Field(
        description="Whether downloads are enabled.", default=True
    )
    has_wiki: bool = Field(description="Whether the wiki is enabled.", default=True)
    has_pages: bool = Field(default=...)
    forks_count: int = Field(default=...)
    mirror_url: Union[str, None] = Field(default=...)
    archived: bool = Field(
        description="Whether the repository is archived.", default=False
    )
    disabled: Union[Unset, bool] = Field(
        description="Returns whether or not this repository is disabled.", default=UNSET
    )
    open_issues_count: int = Field(default=...)
    license_: Union[License, None] = Field(
        title="License", default=..., alias="license"
    )
    forks: int = Field(default=...)
    open_issues: int = Field(default=...)
    watchers: int = Field(default=...)
    stargazers: Union[Unset, int] = Field(default=UNSET)
    default_branch: str = Field(
        description="The default branch of the repository.", default=...
    )
    allow_squash_merge: Union[Unset, bool] = Field(
        description="Whether to allow squash merges for pull requests.", default=True
    )
    allow_merge_commit: Union[Unset, bool] = Field(
        description="Whether to allow merge commits for pull requests.", default=True
    )
    allow_rebase_merge: Union[Unset, bool] = Field(
        description="Whether to allow rebase merges for pull requests.", default=True
    )
    allow_auto_merge: Union[Unset, bool] = Field(
        description="Whether to allow auto-merge for pull requests.", default=False
    )
    allow_forking: Union[Unset, bool] = Field(
        description="Whether to allow private forks", default=UNSET
    )
    allow_update_branch: Union[Unset, bool] = Field(default=UNSET)
    use_squash_pr_title_as_default: Union[Unset, bool] = Field(default=UNSET)
    squash_merge_commit_message: Union[Unset, str] = Field(default=UNSET)
    squash_merge_commit_title: Union[Unset, str] = Field(default=UNSET)
    merge_commit_message: Union[Unset, str] = Field(default=UNSET)
    merge_commit_title: Union[Unset, str] = Field(default=UNSET)
    is_template: bool = Field(default=...)
    web_commit_signoff_required: bool = Field(default=...)
    topics: List[str] = Field(default=...)
    visibility: Literal["public", "private", "internal"] = Field(default=...)
    delete_branch_on_merge: Union[Unset, bool] = Field(
        description="Whether to delete head branches when pull requests are merged",
        default=False,
    )
    master_branch: Union[Unset, str] = Field(default=UNSET)
    permissions: Union[Unset, RepositoryPropPermissions] = Field(default=UNSET)
    public: Union[Unset, bool] = Field(default=UNSET)
    organization: Union[Unset, str] = Field(default=UNSET)


class ForkEventPropForkeeAllof1(GitHubWebhookModel):
    """ForkEventPropForkeeAllof1"""

    fork: Union[Unset, Literal[True]] = Field(default=UNSET)


class GithubAppAuthorizationRevoked(GitHubWebhookModel):
    """github_app_authorization revoked event"""

    action: Literal["revoked"] = Field(default=...)
    sender: User = Field(title="User", default=...)


class GollumEvent(GitHubWebhookModel):
    """gollum event

    A wiki page is created or updated.
    """

    pages: List[GollumEventPropPagesItems] = Field(
        description="The pages that were updated.", default=...
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class GollumEventPropPagesItems(GitHubWebhookModel):
    """GollumEventPropPagesItems"""

    page_name: str = Field(description="The name of the page.", default=...)
    title: str = Field(description="The current page title.", default=...)
    summary: None = Field(default=...)
    action: Literal["created", "edited"] = Field(
        description="The action that was performed on the page. Can be `created` or `edited`.",
        default=...,
    )
    sha: str = Field(description="The latest commit SHA of the page.", default=...)
    html_url: str = Field(description="Points to the HTML wiki page.", default=...)


class InstallationCreated(GitHubWebhookModel):
    """installation created event"""

    action: Literal["created"] = Field(default=...)
    installation: Installation = Field(
        title="Installation", description="The GitHub App installation.", default=...
    )
    repositories: Union[Unset, List[InstallationCreatedPropRepositoriesItems]] = Field(
        description="An array of repository objects that the installation can access.",
        default=UNSET,
    )
    requester: Union[Unset, User] = Field(title="User", default=UNSET)
    sender: User = Field(title="User", default=...)


class Installation(GitHubWebhookModel):
    """Installation

    The GitHub App installation.
    """

    id: int = Field(description="The ID of the installation.", default=...)
    account: User = Field(title="User", default=...)
    repository_selection: Literal["all", "selected"] = Field(
        description="Describe whether all repositories have been selected or there's a selection involved",
        default=...,
    )
    access_tokens_url: str = Field(default=...)
    repositories_url: str = Field(default=...)
    html_url: str = Field(default=...)
    app_id: int = Field(default=...)
    app_slug: Union[Unset, str] = Field(default=UNSET)
    target_id: int = Field(
        description="The ID of the user or organization this token is being scoped to.",
        default=...,
    )
    target_type: Literal["User", "Organization"] = Field(default=...)
    permissions: InstallationPropPermissions = Field(default=...)
    events: List[
        Literal[
            "branch_protection_rule",
            "check_run",
            "check_suite",
            "code_scanning_alert",
            "commit_comment",
            "content_reference",
            "create",
            "delete",
            "deployment",
            "deployment_review",
            "deployment_status",
            "deploy_key",
            "discussion",
            "discussion_comment",
            "fork",
            "gollum",
            "issues",
            "issue_comment",
            "label",
            "member",
            "membership",
            "merge_queue_entry",
            "milestone",
            "organization",
            "org_block",
            "page_build",
            "project",
            "projects_v2_item",
            "project_card",
            "project_column",
            "public",
            "pull_request",
            "pull_request_review",
            "pull_request_review_comment",
            "pull_request_review_thread",
            "push",
            "registry_package",
            "release",
            "repository",
            "repository_dispatch",
            "secret_scanning_alert",
            "secret_scanning_alert_location",
            "star",
            "status",
            "team",
            "team_add",
            "watch",
            "workflow_dispatch",
            "workflow_job",
            "workflow_run",
        ]
    ] = Field(default=...)
    created_at: Union[datetime, int] = Field(default=...)
    updated_at: Union[datetime, int] = Field(default=...)
    single_file_name: Union[str, None] = Field(default=...)
    has_multiple_single_files: Union[Unset, bool] = Field(default=UNSET)
    single_file_paths: Union[Unset, List[str]] = Field(default=UNSET)
    suspended_by: Union[User, None] = Field(title="User", default=...)
    suspended_at: Union[datetime, None] = Field(default=...)


class InstallationPropPermissions(GitHubWebhookModel):
    """InstallationPropPermissions"""

    actions: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token for GitHub Actions workflows, workflow runs, and artifacts.",
        default=UNSET,
    )
    administration: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token for repository creation, deletion, settings, teams, and collaborators creation.",
        default=UNSET,
    )
    blocking: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    checks: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token for checks on code.",
        default=UNSET,
    )
    content_references: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    contents: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token for repository contents, commits, branches, downloads, releases, and merges.",
        default=UNSET,
    )
    deployments: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token for deployments and deployment statuses.",
        default=UNSET,
    )
    discussions: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    emails: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    environments: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token for managing repository environments.",
        default=UNSET,
    )
    issues: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token for issues and related comments, assignees, labels, and milestones.",
        default=UNSET,
    )
    members: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token for organization teams and members.",
        default=UNSET,
    )
    metadata: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token to search repositories, list collaborators, and access repository metadata.",
        default=UNSET,
    )
    organization_administration: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token to manage access to an organization.",
        default=UNSET,
    )
    organization_events: Union[Unset, Literal["read", "write"]] = Field(default=UNSET)
    organization_hooks: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token to manage the post-receive hooks for an organization.",
        default=UNSET,
    )
    organization_packages: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token for organization packages published to GitHub Packages.",
        default=UNSET,
    )
    organization_plan: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token for viewing an organization's plan.",
        default=UNSET,
    )
    organization_projects: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token to manage organization projects and projects beta (where available).",
        default=UNSET,
    )
    organization_secrets: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token to manage organization secrets.",
        default=UNSET,
    )
    organization_self_hosted_runners: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token to view and manage GitHub Actions self-hosted runners available to an organization.",
        default=UNSET,
    )
    organization_user_blocking: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token to view and manage users blocked by the organization.",
        default=UNSET,
    )
    packages: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token for packages published to GitHub Packages.",
        default=UNSET,
    )
    pages: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.",
        default=UNSET,
    )
    pull_requests: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token for pull requests and related comments, assignees, labels, milestones, and merges.",
        default=UNSET,
    )
    repository_hooks: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token to manage the post-receive hooks for a repository.",
        default=UNSET,
    )
    repository_projects: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token to manage repository projects, columns, and cards.",
        default=UNSET,
    )
    secret_scanning_alerts: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token to view and manage secret scanning alerts.",
        default=UNSET,
    )
    secrets: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token to manage repository secrets.",
        default=UNSET,
    )
    security_events: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token to view and manage security events like code scanning alerts.",
        default=UNSET,
    )
    security_scanning_alert: Union[Unset, Literal["read", "write"]] = Field(
        default=UNSET
    )
    single_file: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token to manage just a single file.",
        default=UNSET,
    )
    statuses: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token for commit statuses.",
        default=UNSET,
    )
    team_discussions: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token to manage team discussions and related comments.",
        default=UNSET,
    )
    vulnerability_alerts: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token to manage Dependabot alerts.",
        default=UNSET,
    )
    workflows: Union[Unset, Literal["read", "write"]] = Field(
        description="The level of permission granted to the access token to update GitHub Actions workflow files.",
        default=UNSET,
    )


class InstallationCreatedPropRepositoriesItems(GitHubWebhookModel):
    """InstallationCreatedPropRepositoriesItems"""

    id: int = Field(description="Unique identifier of the repository", default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(default=...)
    private: bool = Field(
        description="Whether the repository is private or public.", default=...
    )


class InstallationDeleted(GitHubWebhookModel):
    """installation deleted event"""

    action: Literal["deleted"] = Field(default=...)
    installation: Installation = Field(
        title="Installation", description="The GitHub App installation.", default=...
    )
    repositories: Union[Unset, List[InstallationDeletedPropRepositoriesItems]] = Field(
        description="An array of repository objects that the installation can access.",
        default=UNSET,
    )
    requester: Union[Unset, None] = Field(default=UNSET)
    sender: User = Field(title="User", default=...)


class InstallationDeletedPropRepositoriesItems(GitHubWebhookModel):
    """InstallationDeletedPropRepositoriesItems"""

    id: int = Field(description="Unique identifier of the repository", default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(default=...)
    private: bool = Field(
        description="Whether the repository is private or public.", default=...
    )


class InstallationNewPermissionsAccepted(GitHubWebhookModel):
    """installation new_permissions_accepted event"""

    action: Literal["new_permissions_accepted"] = Field(default=...)
    installation: Installation = Field(
        title="Installation", description="The GitHub App installation.", default=...
    )
    repositories: Union[
        Unset, List[InstallationNewPermissionsAcceptedPropRepositoriesItems]
    ] = Field(
        description="An array of repository objects that the installation can access.",
        default=UNSET,
    )
    requester: Union[Unset, None] = Field(default=UNSET)
    sender: User = Field(title="User", default=...)


class InstallationNewPermissionsAcceptedPropRepositoriesItems(GitHubWebhookModel):
    """InstallationNewPermissionsAcceptedPropRepositoriesItems"""

    id: int = Field(description="Unique identifier of the repository", default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(default=...)
    private: bool = Field(
        description="Whether the repository is private or public.", default=...
    )


class InstallationSuspend(GitHubWebhookModel):
    """installation suspend event"""

    action: Literal["suspend"] = Field(default=...)
    installation: InstallationSuspendPropInstallation = Field(default=...)
    repositories: Union[Unset, List[InstallationSuspendPropRepositoriesItems]] = Field(
        description="An array of repository objects that the installation can access.",
        default=UNSET,
    )
    requester: Union[Unset, None] = Field(default=UNSET)
    sender: User = Field(title="User", default=...)


class InstallationSuspendPropInstallation(GitHubWebhookModel):
    """InstallationSuspendPropInstallation"""

    id: int = Field(description="The ID of the installation.", default=...)
    account: User = Field(title="User", default=...)
    repository_selection: Literal["all", "selected"] = Field(
        description="Describe whether all repositories have been selected or there's a selection involved",
        default=...,
    )
    access_tokens_url: str = Field(default=...)
    repositories_url: str = Field(default=...)
    html_url: str = Field(default=...)
    app_id: int = Field(default=...)
    app_slug: Union[Unset, str] = Field(default=UNSET)
    target_id: int = Field(
        description="The ID of the user or organization this token is being scoped to.",
        default=...,
    )
    target_type: Literal["User", "Organization"] = Field(default=...)
    permissions: InstallationPropPermissions = Field(default=...)
    events: List[
        Literal[
            "branch_protection_rule",
            "check_run",
            "check_suite",
            "code_scanning_alert",
            "commit_comment",
            "content_reference",
            "create",
            "delete",
            "deployment",
            "deployment_review",
            "deployment_status",
            "deploy_key",
            "discussion",
            "discussion_comment",
            "fork",
            "gollum",
            "issues",
            "issue_comment",
            "label",
            "member",
            "membership",
            "merge_queue_entry",
            "milestone",
            "organization",
            "org_block",
            "page_build",
            "project",
            "projects_v2_item",
            "project_card",
            "project_column",
            "public",
            "pull_request",
            "pull_request_review",
            "pull_request_review_comment",
            "pull_request_review_thread",
            "push",
            "registry_package",
            "release",
            "repository",
            "repository_dispatch",
            "secret_scanning_alert",
            "secret_scanning_alert_location",
            "star",
            "status",
            "team",
            "team_add",
            "watch",
            "workflow_dispatch",
            "workflow_job",
            "workflow_run",
        ]
    ] = Field(default=...)
    created_at: Union[datetime, int] = Field(default=...)
    updated_at: Union[datetime, int] = Field(default=...)
    single_file_name: Union[str, None] = Field(default=...)
    has_multiple_single_files: Union[Unset, bool] = Field(default=UNSET)
    single_file_paths: Union[Unset, List[str]] = Field(default=UNSET)
    suspended_by: User = Field(title="User", default=...)
    suspended_at: datetime = Field(default=...)


class InstallationSuspendPropInstallationAllof1(GitHubWebhookModel):
    """InstallationSuspendPropInstallationAllof1"""

    suspended_by: User = Field(title="User", default=...)
    suspended_at: datetime = Field(default=...)


class InstallationSuspendPropRepositoriesItems(GitHubWebhookModel):
    """InstallationSuspendPropRepositoriesItems"""

    id: int = Field(description="Unique identifier of the repository", default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(default=...)
    private: bool = Field(
        description="Whether the repository is private or public.", default=...
    )


class InstallationUnsuspend(GitHubWebhookModel):
    """installation unsuspend event"""

    action: Literal["unsuspend"] = Field(default=...)
    installation: InstallationUnsuspendPropInstallation = Field(default=...)
    repositories: Union[
        Unset, List[InstallationUnsuspendPropRepositoriesItems]
    ] = Field(
        description="An array of repository objects that the installation can access.",
        default=UNSET,
    )
    requester: Union[Unset, None] = Field(default=UNSET)
    sender: User = Field(title="User", default=...)


class InstallationUnsuspendPropInstallation(GitHubWebhookModel):
    """InstallationUnsuspendPropInstallation"""

    id: int = Field(description="The ID of the installation.", default=...)
    account: User = Field(title="User", default=...)
    repository_selection: Literal["all", "selected"] = Field(
        description="Describe whether all repositories have been selected or there's a selection involved",
        default=...,
    )
    access_tokens_url: str = Field(default=...)
    repositories_url: str = Field(default=...)
    html_url: str = Field(default=...)
    app_id: int = Field(default=...)
    app_slug: Union[Unset, str] = Field(default=UNSET)
    target_id: int = Field(
        description="The ID of the user or organization this token is being scoped to.",
        default=...,
    )
    target_type: Literal["User", "Organization"] = Field(default=...)
    permissions: InstallationPropPermissions = Field(default=...)
    events: List[
        Literal[
            "branch_protection_rule",
            "check_run",
            "check_suite",
            "code_scanning_alert",
            "commit_comment",
            "content_reference",
            "create",
            "delete",
            "deployment",
            "deployment_review",
            "deployment_status",
            "deploy_key",
            "discussion",
            "discussion_comment",
            "fork",
            "gollum",
            "issues",
            "issue_comment",
            "label",
            "member",
            "membership",
            "merge_queue_entry",
            "milestone",
            "organization",
            "org_block",
            "page_build",
            "project",
            "projects_v2_item",
            "project_card",
            "project_column",
            "public",
            "pull_request",
            "pull_request_review",
            "pull_request_review_comment",
            "pull_request_review_thread",
            "push",
            "registry_package",
            "release",
            "repository",
            "repository_dispatch",
            "secret_scanning_alert",
            "secret_scanning_alert_location",
            "star",
            "status",
            "team",
            "team_add",
            "watch",
            "workflow_dispatch",
            "workflow_job",
            "workflow_run",
        ]
    ] = Field(default=...)
    created_at: Union[datetime, int] = Field(default=...)
    updated_at: Union[datetime, int] = Field(default=...)
    single_file_name: Union[str, None] = Field(default=...)
    has_multiple_single_files: Union[Unset, bool] = Field(default=UNSET)
    single_file_paths: Union[Unset, List[str]] = Field(default=UNSET)
    suspended_by: Union[None, None] = Field(default=...)
    suspended_at: Union[None, None] = Field(default=...)


class InstallationUnsuspendPropInstallationAllof1(GitHubWebhookModel):
    """InstallationUnsuspendPropInstallationAllof1"""

    suspended_by: None = Field(default=...)
    suspended_at: None = Field(default=...)


class InstallationUnsuspendPropRepositoriesItems(GitHubWebhookModel):
    """InstallationUnsuspendPropRepositoriesItems"""

    id: int = Field(description="Unique identifier of the repository", default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(default=...)
    private: bool = Field(
        description="Whether the repository is private or public.", default=...
    )


class InstallationRepositoriesAdded(GitHubWebhookModel):
    """installation_repositories added event"""

    action: Literal["added"] = Field(default=...)
    installation: Installation = Field(
        title="Installation", description="The GitHub App installation.", default=...
    )
    repository_selection: Literal["all", "selected"] = Field(
        description="Describe whether all repositories have been selected or there's a selection involved",
        default=...,
    )
    repositories_added: List[
        InstallationRepositoriesAddedPropRepositoriesAddedItems
    ] = Field(
        description="An array of repository objects, which were added to the installation.",
        default=...,
    )
    repositories_removed: List[
        InstallationRepositoriesAddedPropRepositoriesRemovedItems
    ] = Field(
        description="An array of repository objects, which were removed from the installation.",
        default=...,
    )
    requester: Union[User, None] = Field(title="User", default=...)
    sender: User = Field(title="User", default=...)


class InstallationRepositoriesAddedPropRepositoriesAddedItems(GitHubWebhookModel):
    """InstallationRepositoriesAddedPropRepositoriesAddedItems"""

    id: int = Field(description="Unique identifier of the repository", default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(default=...)
    private: bool = Field(
        description="Whether the repository is private or public.", default=...
    )


class InstallationRepositoriesAddedPropRepositoriesRemovedItems(GitHubWebhookModel):
    """InstallationRepositoriesAddedPropRepositoriesRemovedItems"""

    id: Union[Unset, int] = Field(
        description="Unique identifier of the repository", default=UNSET
    )
    node_id: Union[Unset, str] = Field(default=UNSET)
    name: Union[Unset, str] = Field(
        description="The name of the repository.", default=UNSET
    )
    full_name: Union[Unset, str] = Field(default=UNSET)
    private: Union[Unset, bool] = Field(
        description="Whether the repository is private or public.", default=UNSET
    )


class InstallationRepositoriesRemoved(GitHubWebhookModel):
    """installation_repositories removed event"""

    action: Literal["removed"] = Field(default=...)
    installation: Installation = Field(
        title="Installation", description="The GitHub App installation.", default=...
    )
    repository_selection: Literal["all", "selected"] = Field(
        description="Describe whether all repositories have been selected or there's a selection involved",
        default=...,
    )
    repositories_added: List[
        InstallationRepositoriesRemovedPropRepositoriesAddedItems
    ] = Field(
        description="An array of repository objects, which were added to the installation.",
        default=...,
    )
    repositories_removed: List[
        InstallationRepositoriesRemovedPropRepositoriesRemovedItems
    ] = Field(
        description="An array of repository objects, which were removed from the installation.",
        default=...,
    )
    requester: Union[User, None] = Field(title="User", default=...)
    sender: User = Field(title="User", default=...)


class InstallationRepositoriesRemovedPropRepositoriesAddedItems(GitHubWebhookModel):
    """InstallationRepositoriesRemovedPropRepositoriesAddedItems"""

    id: int = Field(description="Unique identifier of the repository", default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(default=...)
    private: bool = Field(
        description="Whether the repository is private or public.", default=...
    )


class InstallationRepositoriesRemovedPropRepositoriesRemovedItems(GitHubWebhookModel):
    """InstallationRepositoriesRemovedPropRepositoriesRemovedItems"""

    id: int = Field(description="Unique identifier of the repository", default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(default=...)
    private: bool = Field(
        description="Whether the repository is private or public.", default=...
    )


class IssueCommentCreated(GitHubWebhookModel):
    """issue_comment created event"""

    action: Literal["created"] = Field(default=...)
    issue: IssueCommentCreatedPropIssue = Field(
        description="The [issue](https://docs.github.com/en/rest/reference/issues) the comment belongs to.",
        default=...,
    )
    comment: IssueComment = Field(
        title="issue comment",
        description="The [comment](https://docs.github.com/en/rest/reference/issues#comments) itself.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class IssueCommentCreatedPropIssue(GitHubWebhookModel):
    """IssueCommentCreatedPropIssue

    The [issue](https://docs.github.com/en/rest/reference/issues) the comment
    belongs to.
    """

    url: str = Field(description="URL for the issue", default=...)
    repository_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the issue within its repository",
        default=...,
    )
    title: str = Field(description="Title of the issue", default=...)
    user: User = Field(title="User", default=...)
    labels: List[Label] = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'", default=...
    )
    locked: bool = Field(default=...)
    assignee: Union[Union[User, None], None] = Field(title="User", default=...)
    assignees: List[User] = Field(default=...)
    milestone: Union[Milestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    comments: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    performed_via_github_app: Union[Unset, Union[App, None]] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[Unset, IssuePropPullRequest] = Field(default=UNSET)
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    reactions: Reactions = Field(title="Reactions", default=...)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    state_reason: Union[Unset, Union[str, None]] = Field(
        description="The reason for the current state", default=UNSET
    )


class Issue(GitHubWebhookModel):
    """Issue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    url: str = Field(description="URL for the issue", default=...)
    repository_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the issue within its repository",
        default=...,
    )
    title: str = Field(description="Title of the issue", default=...)
    user: User = Field(title="User", default=...)
    labels: Union[Unset, List[Label]] = Field(default=UNSET)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    locked: Union[Unset, bool] = Field(default=UNSET)
    assignee: Union[Unset, Union[User, None]] = Field(title="User", default=UNSET)
    assignees: List[User] = Field(default=...)
    milestone: Union[Milestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    comments: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    performed_via_github_app: Union[Unset, Union[App, None]] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[Unset, IssuePropPullRequest] = Field(default=UNSET)
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    reactions: Reactions = Field(title="Reactions", default=...)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    state_reason: Union[Unset, Union[str, None]] = Field(
        description="The reason for the current state", default=UNSET
    )


class Milestone(GitHubWebhookModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    url: str = Field(default=...)
    html_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    title: str = Field(description="The title of the milestone.", default=...)
    description: Union[str, None] = Field(default=...)
    creator: User = Field(title="User", default=...)
    open_issues: int = Field(default=...)
    closed_issues: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default=...
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)


class IssuePropPullRequest(GitHubWebhookModel):
    """IssuePropPullRequest"""

    url: Union[Unset, str] = Field(default=UNSET)
    html_url: Union[Unset, str] = Field(default=UNSET)
    diff_url: Union[Unset, str] = Field(default=UNSET)
    patch_url: Union[Unset, str] = Field(default=UNSET)
    merged_at: Union[Unset, Union[datetime, None]] = Field(default=UNSET)


class IssueCommentCreatedPropIssueAllof1(GitHubWebhookModel):
    """IssueCommentCreatedPropIssueAllof1"""

    assignee: Union[User, None] = Field(title="User", default=...)
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'", default=...
    )
    locked: bool = Field(default=...)
    labels: List[Label] = Field(default=...)


class IssueComment(GitHubWebhookModel):
    """issue comment

    The [comment](https://docs.github.com/en/rest/reference/issues#comments) itself.
    """

    url: str = Field(description="URL for the issue comment", default=...)
    html_url: str = Field(default=...)
    issue_url: str = Field(default=...)
    id: int = Field(description="Unique identifier of the issue comment", default=...)
    node_id: str = Field(default=...)
    user: User = Field(title="User", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: str = Field(description="Contents of the issue comment", default=...)
    reactions: Reactions = Field(title="Reactions", default=...)
    performed_via_github_app: Union[App, None] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )


class IssueCommentDeleted(GitHubWebhookModel):
    """issue_comment deleted event"""

    action: Literal["deleted"] = Field(default=...)
    issue: IssueCommentDeletedPropIssue = Field(
        description="The [issue](https://docs.github.com/en/rest/reference/issues) the comment belongs to.",
        default=...,
    )
    comment: IssueComment = Field(
        title="issue comment",
        description="The [comment](https://docs.github.com/en/rest/reference/issues#comments) itself.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class IssueCommentDeletedPropIssue(GitHubWebhookModel):
    """IssueCommentDeletedPropIssue

    The [issue](https://docs.github.com/en/rest/reference/issues) the comment
    belongs to.
    """

    url: str = Field(description="URL for the issue", default=...)
    repository_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the issue within its repository",
        default=...,
    )
    title: str = Field(description="Title of the issue", default=...)
    user: User = Field(title="User", default=...)
    labels: List[Label] = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'", default=...
    )
    locked: bool = Field(default=...)
    assignee: Union[Union[User, None], None] = Field(title="User", default=...)
    assignees: List[User] = Field(default=...)
    milestone: Union[Milestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    comments: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    performed_via_github_app: Union[Unset, Union[App, None]] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[Unset, IssuePropPullRequest] = Field(default=UNSET)
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    reactions: Reactions = Field(title="Reactions", default=...)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    state_reason: Union[Unset, Union[str, None]] = Field(
        description="The reason for the current state", default=UNSET
    )


class IssueCommentDeletedPropIssueAllof1(GitHubWebhookModel):
    """IssueCommentDeletedPropIssueAllof1"""

    assignee: Union[User, None] = Field(title="User", default=...)
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'", default=...
    )
    locked: bool = Field(default=...)
    labels: List[Label] = Field(default=...)


class IssueCommentEdited(GitHubWebhookModel):
    """issue_comment edited event"""

    action: Literal["edited"] = Field(default=...)
    changes: IssueCommentEditedPropChanges = Field(
        description="The changes to the comment.", default=...
    )
    issue: IssueCommentEditedPropIssue = Field(
        description="The [issue](https://docs.github.com/en/rest/reference/issues) the comment belongs to.",
        default=...,
    )
    comment: IssueComment = Field(
        title="issue comment",
        description="The [comment](https://docs.github.com/en/rest/reference/issues#comments) itself.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class IssueCommentEditedPropChanges(GitHubWebhookModel):
    """IssueCommentEditedPropChanges

    The changes to the comment.
    """

    body: Union[Unset, IssueCommentEditedPropChangesPropBody] = Field(default=UNSET)


class IssueCommentEditedPropChangesPropBody(GitHubWebhookModel):
    """IssueCommentEditedPropChangesPropBody"""

    from_: str = Field(
        description="The previous version of the body.", default=..., alias="from"
    )


class IssueCommentEditedPropIssue(GitHubWebhookModel):
    """IssueCommentEditedPropIssue

    The [issue](https://docs.github.com/en/rest/reference/issues) the comment
    belongs to.
    """

    url: str = Field(description="URL for the issue", default=...)
    repository_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the issue within its repository",
        default=...,
    )
    title: str = Field(description="Title of the issue", default=...)
    user: User = Field(title="User", default=...)
    labels: List[Label] = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'", default=...
    )
    locked: bool = Field(default=...)
    assignee: Union[Union[User, None], None] = Field(title="User", default=...)
    assignees: List[User] = Field(default=...)
    milestone: Union[Milestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    comments: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    performed_via_github_app: Union[Unset, Union[App, None]] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[Unset, IssuePropPullRequest] = Field(default=UNSET)
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    reactions: Reactions = Field(title="Reactions", default=...)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    state_reason: Union[Unset, Union[str, None]] = Field(
        description="The reason for the current state", default=UNSET
    )


class IssueCommentEditedPropIssueAllof1(GitHubWebhookModel):
    """IssueCommentEditedPropIssueAllof1"""

    assignee: Union[User, None] = Field(title="User", default=...)
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'", default=...
    )
    locked: bool = Field(default=...)
    labels: List[Label] = Field(default=...)


class IssuesAssigned(GitHubWebhookModel):
    """issues assigned event

    Activity related to an issue. The type of activity is specified in the action
    property.
    """

    action: Literal["assigned"] = Field(
        description="The action that was performed.", default=...
    )
    issue: Issue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    assignee: Union[Unset, Union[User, None]] = Field(
        title="User",
        description="The optional user who was assigned or unassigned from the issue.",
        default=UNSET,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class IssuesClosed(GitHubWebhookModel):
    """issues closed event"""

    action: Literal["closed"] = Field(
        description="The action that was performed.", default=...
    )
    issue: IssuesClosedPropIssue = Field(
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class IssuesClosedPropIssue(GitHubWebhookModel):
    """IssuesClosedPropIssue

    The [issue](https://docs.github.com/en/rest/reference/issues) itself.
    """

    url: str = Field(description="URL for the issue", default=...)
    repository_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the issue within its repository",
        default=...,
    )
    title: str = Field(description="Title of the issue", default=...)
    user: User = Field(title="User", default=...)
    labels: Union[Unset, List[Label]] = Field(default=UNSET)
    state: Literal["closed"] = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    assignee: Union[Unset, Union[User, None]] = Field(title="User", default=UNSET)
    assignees: List[User] = Field(default=...)
    milestone: Union[Milestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    comments: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: datetime = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    performed_via_github_app: Union[Unset, Union[App, None]] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[Unset, IssuePropPullRequest] = Field(default=UNSET)
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    reactions: Reactions = Field(title="Reactions", default=...)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    state_reason: Union[Unset, Union[str, None]] = Field(
        description="The reason for the current state", default=UNSET
    )


class IssuesClosedPropIssueAllof1(GitHubWebhookModel):
    """IssuesClosedPropIssueAllof1"""

    state: Literal["closed"] = Field(default=...)
    closed_at: str = Field(default=...)


class IssuesDeleted(GitHubWebhookModel):
    """issues deleted event"""

    action: Literal["deleted"] = Field(default=...)
    issue: Issue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class IssuesDemilestoned(GitHubWebhookModel):
    """issues demilestoned event"""

    action: Literal["demilestoned"] = Field(default=...)
    issue: IssuesDemilestonedPropIssue = Field(default=...)
    milestone: Milestone = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class IssuesDemilestonedPropIssue(GitHubWebhookModel):
    """IssuesDemilestonedPropIssue"""

    url: str = Field(description="URL for the issue", default=...)
    repository_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the issue within its repository",
        default=...,
    )
    title: str = Field(description="Title of the issue", default=...)
    user: User = Field(title="User", default=...)
    labels: Union[Unset, List[Label]] = Field(default=UNSET)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    locked: Union[Unset, bool] = Field(default=UNSET)
    assignee: Union[Unset, Union[User, None]] = Field(title="User", default=UNSET)
    assignees: List[User] = Field(default=...)
    milestone: Union[None, None] = Field(default=...)
    comments: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    performed_via_github_app: Union[Unset, Union[App, None]] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[Unset, IssuePropPullRequest] = Field(default=UNSET)
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    reactions: Reactions = Field(title="Reactions", default=...)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    state_reason: Union[Unset, Union[str, None]] = Field(
        description="The reason for the current state", default=UNSET
    )


class IssuesDemilestonedPropIssueAllof1(GitHubWebhookModel):
    """IssuesDemilestonedPropIssueAllof1"""

    milestone: None = Field(default=...)


class IssuesEdited(GitHubWebhookModel):
    """issues edited event"""

    action: Literal["edited"] = Field(default=...)
    issue: Issue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    label: Union[Unset, Label] = Field(title="Label", default=UNSET)
    changes: IssuesEditedPropChanges = Field(
        description="The changes to the issue.", default=...
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class IssuesEditedPropChanges(GitHubWebhookModel):
    """IssuesEditedPropChanges

    The changes to the issue.
    """

    body: Union[Unset, IssuesEditedPropChangesPropBody] = Field(default=UNSET)
    title: Union[Unset, IssuesEditedPropChangesPropTitle] = Field(default=UNSET)


class IssuesEditedPropChangesPropBody(GitHubWebhookModel):
    """IssuesEditedPropChangesPropBody"""

    from_: str = Field(
        description="The previous version of the body.", default=..., alias="from"
    )


class IssuesEditedPropChangesPropTitle(GitHubWebhookModel):
    """IssuesEditedPropChangesPropTitle"""

    from_: str = Field(
        description="The previous version of the title.", default=..., alias="from"
    )


class IssuesLabeled(GitHubWebhookModel):
    """issues labeled event"""

    action: Literal["labeled"] = Field(default=...)
    issue: Issue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    label: Union[Unset, Label] = Field(title="Label", default=UNSET)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class IssuesLocked(GitHubWebhookModel):
    """issues locked event"""

    action: Literal["locked"] = Field(default=...)
    issue: IssuesLockedPropIssue = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class IssuesLockedPropIssue(GitHubWebhookModel):
    """IssuesLockedPropIssue"""

    url: str = Field(description="URL for the issue", default=...)
    repository_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the issue within its repository",
        default=...,
    )
    title: str = Field(description="Title of the issue", default=...)
    user: User = Field(title="User", default=...)
    labels: Union[Unset, List[Label]] = Field(default=UNSET)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    locked: Literal[True] = Field(default=...)
    assignee: Union[Unset, Union[User, None]] = Field(title="User", default=UNSET)
    assignees: List[User] = Field(default=...)
    milestone: Union[Milestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    comments: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    active_lock_reason: Union[
        Union[None, Literal["resolved", "off-topic", "too heated", "spam"]], None
    ] = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    performed_via_github_app: Union[Unset, Union[App, None]] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[Unset, IssuePropPullRequest] = Field(default=UNSET)
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    reactions: Reactions = Field(title="Reactions", default=...)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    state_reason: Union[Unset, Union[str, None]] = Field(
        description="The reason for the current state", default=UNSET
    )


class IssuesLockedPropIssueAllof1(GitHubWebhookModel):
    """IssuesLockedPropIssueAllof1"""

    locked: Literal[True] = Field(default=...)
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)


class IssuesMilestoned(GitHubWebhookModel):
    """issues milestoned event"""

    action: Literal["milestoned"] = Field(default=...)
    issue: IssuesMilestonedPropIssue = Field(default=...)
    milestone: Milestone = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class IssuesMilestonedPropIssue(GitHubWebhookModel):
    """IssuesMilestonedPropIssue"""

    url: str = Field(description="URL for the issue", default=...)
    repository_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the issue within its repository",
        default=...,
    )
    title: str = Field(description="Title of the issue", default=...)
    user: User = Field(title="User", default=...)
    labels: Union[Unset, List[Label]] = Field(default=UNSET)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    locked: Union[Unset, bool] = Field(default=UNSET)
    assignee: Union[Unset, Union[User, None]] = Field(title="User", default=UNSET)
    assignees: List[User] = Field(default=...)
    milestone: Milestone = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    comments: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    performed_via_github_app: Union[Unset, Union[App, None]] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[Unset, IssuePropPullRequest] = Field(default=UNSET)
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    reactions: Reactions = Field(title="Reactions", default=...)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    state_reason: Union[Unset, Union[str, None]] = Field(
        description="The reason for the current state", default=UNSET
    )


class IssuesMilestonedPropIssueAllof1(GitHubWebhookModel):
    """IssuesMilestonedPropIssueAllof1"""

    milestone: Milestone = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )


class IssuesOpened(GitHubWebhookModel):
    """issues opened event"""

    action: Literal["opened"] = Field(default=...)
    changes: Union[Unset, IssuesOpenedPropChanges] = Field(default=UNSET)
    issue: IssuesOpenedPropIssue = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class IssuesOpenedPropChanges(GitHubWebhookModel):
    """IssuesOpenedPropChanges"""

    old_issue: Issue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    old_repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )


class IssuesOpenedPropIssue(GitHubWebhookModel):
    """IssuesOpenedPropIssue"""

    url: str = Field(description="URL for the issue", default=...)
    repository_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the issue within its repository",
        default=...,
    )
    title: str = Field(description="Title of the issue", default=...)
    user: User = Field(title="User", default=...)
    labels: Union[Unset, List[Label]] = Field(default=UNSET)
    state: Literal["open"] = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    assignee: Union[Unset, Union[User, None]] = Field(title="User", default=UNSET)
    assignees: List[User] = Field(default=...)
    milestone: Union[Milestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    comments: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[None, None] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    performed_via_github_app: Union[Unset, Union[App, None]] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[Unset, IssuePropPullRequest] = Field(default=UNSET)
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    reactions: Reactions = Field(title="Reactions", default=...)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    state_reason: Union[Unset, Union[str, None]] = Field(
        description="The reason for the current state", default=UNSET
    )


class IssuesOpenedPropIssueAllof1(GitHubWebhookModel):
    """IssuesOpenedPropIssueAllof1"""

    state: Literal["open"] = Field(default=...)
    closed_at: None = Field(default=...)


class IssuesPinned(GitHubWebhookModel):
    """issues pinned event"""

    action: Literal["pinned"] = Field(default=...)
    issue: Issue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class IssuesReopened(GitHubWebhookModel):
    """issues reopened event"""

    action: Literal["reopened"] = Field(default=...)
    issue: IssuesReopenedPropIssue = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class IssuesReopenedPropIssue(GitHubWebhookModel):
    """IssuesReopenedPropIssue"""

    url: str = Field(description="URL for the issue", default=...)
    repository_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the issue within its repository",
        default=...,
    )
    title: str = Field(description="Title of the issue", default=...)
    user: User = Field(title="User", default=...)
    labels: Union[Unset, List[Label]] = Field(default=UNSET)
    state: Literal["open"] = Field(default=...)
    locked: Union[Unset, bool] = Field(default=UNSET)
    assignee: Union[Unset, Union[User, None]] = Field(title="User", default=UNSET)
    assignees: List[User] = Field(default=...)
    milestone: Union[Milestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    comments: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    performed_via_github_app: Union[Unset, Union[App, None]] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[Unset, IssuePropPullRequest] = Field(default=UNSET)
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    reactions: Reactions = Field(title="Reactions", default=...)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    state_reason: Union[Unset, Union[str, None]] = Field(
        description="The reason for the current state", default=UNSET
    )


class IssuesReopenedPropIssueAllof1(GitHubWebhookModel):
    """IssuesReopenedPropIssueAllof1"""

    state: Literal["open"] = Field(default=...)


class IssuesTransferred(GitHubWebhookModel):
    """issues transferred event"""

    action: Literal["transferred"] = Field(default=...)
    changes: IssuesTransferredPropChanges = Field(default=...)
    issue: Issue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class IssuesTransferredPropChanges(GitHubWebhookModel):
    """IssuesTransferredPropChanges"""

    new_issue: Issue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    new_repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )


class IssuesUnassigned(GitHubWebhookModel):
    """issues unassigned event"""

    action: Literal["unassigned"] = Field(
        description="The action that was performed.", default=...
    )
    issue: Issue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    assignee: Union[Unset, Union[User, None]] = Field(
        title="User",
        description="The optional user who was assigned or unassigned from the issue.",
        default=UNSET,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class IssuesUnlabeled(GitHubWebhookModel):
    """issues unlabeled event"""

    action: Literal["unlabeled"] = Field(default=...)
    issue: Issue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    label: Union[Unset, Label] = Field(title="Label", default=UNSET)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class IssuesUnlocked(GitHubWebhookModel):
    """issues unlocked event"""

    action: Literal["unlocked"] = Field(default=...)
    issue: IssuesUnlockedPropIssue = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class IssuesUnlockedPropIssue(GitHubWebhookModel):
    """IssuesUnlockedPropIssue"""

    url: str = Field(description="URL for the issue", default=...)
    repository_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the issue within its repository",
        default=...,
    )
    title: str = Field(description="Title of the issue", default=...)
    user: User = Field(title="User", default=...)
    labels: Union[Unset, List[Label]] = Field(default=UNSET)
    state: Union[Unset, Literal["open", "closed"]] = Field(
        description="State of the issue; either 'open' or 'closed'", default=UNSET
    )
    locked: Literal[False] = Field(default=...)
    assignee: Union[Unset, Union[User, None]] = Field(title="User", default=UNSET)
    assignees: List[User] = Field(default=...)
    milestone: Union[Milestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    comments: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    active_lock_reason: Union[None, None] = Field(default=...)
    draft: Union[Unset, bool] = Field(default=UNSET)
    performed_via_github_app: Union[Unset, Union[App, None]] = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    pull_request: Union[Unset, IssuePropPullRequest] = Field(default=UNSET)
    body: Union[str, None] = Field(description="Contents of the issue", default=...)
    reactions: Reactions = Field(title="Reactions", default=...)
    timeline_url: Union[Unset, str] = Field(default=UNSET)
    state_reason: Union[Unset, Union[str, None]] = Field(
        description="The reason for the current state", default=UNSET
    )


class IssuesUnlockedPropIssueAllof1(GitHubWebhookModel):
    """IssuesUnlockedPropIssueAllof1"""

    locked: Literal[False] = Field(default=...)
    active_lock_reason: None = Field(default=...)


class IssuesUnpinned(GitHubWebhookModel):
    """issues unpinned event"""

    action: Literal["unpinned"] = Field(default=...)
    issue: Issue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/en/rest/reference/issues) itself.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class LabelCreated(GitHubWebhookModel):
    """label created event"""

    action: Literal["created"] = Field(default=...)
    label: Label = Field(title="Label", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class LabelDeleted(GitHubWebhookModel):
    """label deleted event"""

    action: Literal["deleted"] = Field(default=...)
    label: Label = Field(title="Label", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class LabelEdited(GitHubWebhookModel):
    """label edited event"""

    action: Literal["edited"] = Field(default=...)
    label: Label = Field(title="Label", default=...)
    changes: Union[Unset, LabelEditedPropChanges] = Field(
        description="The changes to the label if the action was `edited`.",
        default=UNSET,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class LabelEditedPropChanges(GitHubWebhookModel):
    """LabelEditedPropChanges

    The changes to the label if the action was `edited`.
    """

    color: Union[Unset, LabelEditedPropChangesPropColor] = Field(default=UNSET)
    name: Union[Unset, LabelEditedPropChangesPropName] = Field(default=UNSET)
    description: Union[Unset, LabelEditedPropChangesPropDescription] = Field(
        default=UNSET
    )


class LabelEditedPropChangesPropColor(GitHubWebhookModel):
    """LabelEditedPropChangesPropColor"""

    from_: str = Field(
        description="The previous version of the color if the action was `edited`.",
        default=...,
        alias="from",
    )


class LabelEditedPropChangesPropName(GitHubWebhookModel):
    """LabelEditedPropChangesPropName"""

    from_: str = Field(
        description="The previous version of the name if the action was `edited`.",
        default=...,
        alias="from",
    )


class LabelEditedPropChangesPropDescription(GitHubWebhookModel):
    """LabelEditedPropChangesPropDescription"""

    from_: str = Field(
        description="The previous version of the description if the action was `edited`.",
        default=...,
        alias="from",
    )


class MarketplacePurchaseCancelled(GitHubWebhookModel):
    """marketplace_purchase cancelled event"""

    action: Literal["cancelled"] = Field(default=...)
    effective_date: datetime = Field(default=...)
    sender: MarketplacePurchaseCancelledPropSender = Field(default=...)
    marketplace_purchase: MarketplacePurchaseCancelledPropMarketplacePurchase = Field(
        default=...
    )
    previous_marketplace_purchase: Union[Unset, MarketplacePurchase] = Field(
        title="Marketplace Purchase", default=UNSET
    )


class MarketplacePurchaseCancelledPropSender(GitHubWebhookModel):
    """MarketplacePurchaseCancelledPropSender"""

    login: str = Field(default=...)
    id: int = Field(default=...)
    avatar_url: str = Field(default=...)
    gravatar_id: str = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    organizations_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    type: str = Field(default=...)
    site_admin: bool = Field(default=...)
    email: str = Field(default=...)


class MarketplacePurchaseCancelledPropMarketplacePurchase(GitHubWebhookModel):
    """MarketplacePurchaseCancelledPropMarketplacePurchase"""

    account: MarketplacePurchasePropAccount = Field(default=...)
    billing_cycle: str = Field(default=...)
    unit_count: int = Field(default=...)
    on_free_trial: bool = Field(default=...)
    free_trial_ends_on: Union[datetime, None] = Field(default=...)
    next_billing_date: datetime = Field(default=...)
    plan: MarketplacePurchasePropPlan = Field(default=...)


class MarketplacePurchase(GitHubWebhookModel):
    """Marketplace Purchase"""

    account: MarketplacePurchasePropAccount = Field(default=...)
    billing_cycle: str = Field(default=...)
    unit_count: int = Field(default=...)
    on_free_trial: bool = Field(default=...)
    free_trial_ends_on: Union[datetime, None] = Field(default=...)
    next_billing_date: Union[Unset, str] = Field(default=UNSET)
    plan: MarketplacePurchasePropPlan = Field(default=...)


class MarketplacePurchasePropAccount(GitHubWebhookModel):
    """MarketplacePurchasePropAccount"""

    type: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    login: str = Field(default=...)
    organization_billing_email: str = Field(default=...)


class MarketplacePurchasePropPlan(GitHubWebhookModel):
    """MarketplacePurchasePropPlan"""

    id: int = Field(default=...)
    name: str = Field(default=...)
    description: str = Field(default=...)
    monthly_price_in_cents: int = Field(default=...)
    yearly_price_in_cents: int = Field(default=...)
    price_model: str = Field(default=...)
    has_free_trial: bool = Field(default=...)
    unit_name: Union[str, None] = Field(default=...)
    bullets: List[str] = Field(default=...)


class MarketplacePurchaseCancelledPropMarketplacePurchaseAllof1(GitHubWebhookModel):
    """MarketplacePurchaseCancelledPropMarketplacePurchaseAllof1"""

    next_billing_date: datetime = Field(default=...)


class MarketplacePurchaseChanged(GitHubWebhookModel):
    """marketplace_purchase changed event"""

    action: Literal["changed"] = Field(default=...)
    effective_date: datetime = Field(default=...)
    sender: MarketplacePurchaseChangedPropSender = Field(default=...)
    marketplace_purchase: MarketplacePurchaseChangedPropMarketplacePurchase = Field(
        default=...
    )
    previous_marketplace_purchase: Union[Unset, MarketplacePurchase] = Field(
        title="Marketplace Purchase", default=UNSET
    )


class MarketplacePurchaseChangedPropSender(GitHubWebhookModel):
    """MarketplacePurchaseChangedPropSender"""

    login: str = Field(default=...)
    id: int = Field(default=...)
    avatar_url: str = Field(default=...)
    gravatar_id: str = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    organizations_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    type: str = Field(default=...)
    site_admin: bool = Field(default=...)
    email: str = Field(default=...)


class MarketplacePurchaseChangedPropMarketplacePurchase(GitHubWebhookModel):
    """MarketplacePurchaseChangedPropMarketplacePurchase"""

    account: MarketplacePurchasePropAccount = Field(default=...)
    billing_cycle: str = Field(default=...)
    unit_count: int = Field(default=...)
    on_free_trial: bool = Field(default=...)
    free_trial_ends_on: Union[datetime, None] = Field(default=...)
    next_billing_date: datetime = Field(default=...)
    plan: MarketplacePurchasePropPlan = Field(default=...)


class MarketplacePurchaseChangedPropMarketplacePurchaseAllof1(GitHubWebhookModel):
    """MarketplacePurchaseChangedPropMarketplacePurchaseAllof1"""

    next_billing_date: datetime = Field(default=...)


class MarketplacePurchasePendingChange(GitHubWebhookModel):
    """marketplace_purchase pending_change event"""

    action: Literal["pending_change"] = Field(default=...)
    effective_date: datetime = Field(default=...)
    sender: MarketplacePurchasePendingChangePropSender = Field(default=...)
    marketplace_purchase: MarketplacePurchasePendingChangePropMarketplacePurchase = (
        Field(default=...)
    )
    previous_marketplace_purchase: Union[Unset, MarketplacePurchase] = Field(
        title="Marketplace Purchase", default=UNSET
    )


class MarketplacePurchasePendingChangePropSender(GitHubWebhookModel):
    """MarketplacePurchasePendingChangePropSender"""

    login: str = Field(default=...)
    id: int = Field(default=...)
    avatar_url: str = Field(default=...)
    gravatar_id: str = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    organizations_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    type: str = Field(default=...)
    site_admin: bool = Field(default=...)
    email: str = Field(default=...)


class MarketplacePurchasePendingChangePropMarketplacePurchase(GitHubWebhookModel):
    """MarketplacePurchasePendingChangePropMarketplacePurchase"""

    account: MarketplacePurchasePropAccount = Field(default=...)
    billing_cycle: str = Field(default=...)
    unit_count: int = Field(default=...)
    on_free_trial: bool = Field(default=...)
    free_trial_ends_on: Union[datetime, None] = Field(default=...)
    next_billing_date: datetime = Field(default=...)
    plan: MarketplacePurchasePropPlan = Field(default=...)


class MarketplacePurchasePendingChangePropMarketplacePurchaseAllof1(GitHubWebhookModel):
    """MarketplacePurchasePendingChangePropMarketplacePurchaseAllof1"""

    next_billing_date: datetime = Field(default=...)


class MarketplacePurchasePendingChangeCancelled(GitHubWebhookModel):
    """marketplace_purchase pending_change_cancelled event"""

    action: Literal["pending_change_cancelled"] = Field(default=...)
    effective_date: datetime = Field(default=...)
    sender: MarketplacePurchasePendingChangeCancelledPropSender = Field(default=...)
    marketplace_purchase: MarketplacePurchasePendingChangeCancelledPropMarketplacePurchase = Field(
        default=...
    )
    previous_marketplace_purchase: Union[Unset, MarketplacePurchase] = Field(
        title="Marketplace Purchase", default=UNSET
    )


class MarketplacePurchasePendingChangeCancelledPropSender(GitHubWebhookModel):
    """MarketplacePurchasePendingChangeCancelledPropSender"""

    login: str = Field(default=...)
    id: int = Field(default=...)
    avatar_url: str = Field(default=...)
    gravatar_id: str = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    organizations_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    type: str = Field(default=...)
    site_admin: bool = Field(default=...)
    email: str = Field(default=...)


class MarketplacePurchasePendingChangeCancelledPropMarketplacePurchase(
    GitHubWebhookModel
):
    """MarketplacePurchasePendingChangeCancelledPropMarketplacePurchase"""

    account: MarketplacePurchasePropAccount = Field(default=...)
    billing_cycle: str = Field(default=...)
    unit_count: int = Field(default=...)
    on_free_trial: bool = Field(default=...)
    free_trial_ends_on: Union[datetime, None] = Field(default=...)
    next_billing_date: datetime = Field(default=...)
    plan: MarketplacePurchasePropPlan = Field(default=...)


class MarketplacePurchasePendingChangeCancelledPropMarketplacePurchaseAllof1(
    GitHubWebhookModel
):
    """MarketplacePurchasePendingChangeCancelledPropMarketplacePurchaseAllof1"""

    next_billing_date: datetime = Field(default=...)


class MarketplacePurchasePurchased(GitHubWebhookModel):
    """marketplace_purchase purchased event"""

    action: Literal["purchased"] = Field(default=...)
    effective_date: datetime = Field(default=...)
    sender: MarketplacePurchasePurchasedPropSender = Field(default=...)
    marketplace_purchase: MarketplacePurchasePurchasedPropMarketplacePurchase = Field(
        default=...
    )
    previous_marketplace_purchase: Union[Unset, MarketplacePurchase] = Field(
        title="Marketplace Purchase", default=UNSET
    )


class MarketplacePurchasePurchasedPropSender(GitHubWebhookModel):
    """MarketplacePurchasePurchasedPropSender"""

    login: str = Field(default=...)
    id: int = Field(default=...)
    avatar_url: str = Field(default=...)
    gravatar_id: str = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    organizations_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    type: str = Field(default=...)
    site_admin: bool = Field(default=...)
    email: str = Field(default=...)


class MarketplacePurchasePurchasedPropMarketplacePurchase(GitHubWebhookModel):
    """MarketplacePurchasePurchasedPropMarketplacePurchase"""

    account: MarketplacePurchasePropAccount = Field(default=...)
    billing_cycle: str = Field(default=...)
    unit_count: int = Field(default=...)
    on_free_trial: bool = Field(default=...)
    free_trial_ends_on: Union[datetime, None] = Field(default=...)
    next_billing_date: datetime = Field(default=...)
    plan: MarketplacePurchasePropPlan = Field(default=...)


class MarketplacePurchasePurchasedPropMarketplacePurchaseAllof1(GitHubWebhookModel):
    """MarketplacePurchasePurchasedPropMarketplacePurchaseAllof1"""

    next_billing_date: datetime = Field(default=...)


class MemberAdded(GitHubWebhookModel):
    """member added event

    Activity related to repository collaborators. The type of activity is specified
    in the action property.
    """

    action: Literal["added"] = Field(default=...)
    changes: Union[Unset, MemberAddedPropChanges] = Field(default=UNSET)
    member: User = Field(title="User", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class MemberAddedPropChanges(GitHubWebhookModel):
    """MemberAddedPropChanges"""

    permission: Union[Unset, MemberAddedPropChangesPropPermission] = Field(
        default=UNSET
    )


class MemberAddedPropChangesPropPermission(GitHubWebhookModel):
    """MemberAddedPropChangesPropPermission"""

    to: Literal["write", "admin"] = Field(default=...)


class MemberEdited(GitHubWebhookModel):
    """member edited event"""

    action: Literal["edited"] = Field(default=...)
    member: User = Field(title="User", default=...)
    changes: MemberEditedPropChanges = Field(
        description="The changes to the collaborator permissions", default=...
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class MemberEditedPropChanges(GitHubWebhookModel):
    """MemberEditedPropChanges

    The changes to the collaborator permissions
    """

    old_permission: MemberEditedPropChangesPropOldPermission = Field(default=...)


class MemberEditedPropChangesPropOldPermission(GitHubWebhookModel):
    """MemberEditedPropChangesPropOldPermission"""

    from_: str = Field(
        description="The previous permissions of the collaborator if the action was edited.",
        default=...,
        alias="from",
    )


class MemberRemoved(GitHubWebhookModel):
    """member removed event"""

    action: Literal["removed"] = Field(default=...)
    member: User = Field(title="User", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class MembershipAdded(GitHubWebhookModel):
    """membership added event"""

    action: Literal["added"] = Field(default=...)
    scope: Literal["team"] = Field(
        description="The scope of the membership. Currently, can only be `team`.",
        default=...,
    )
    member: User = Field(title="User", default=...)
    sender: User = Field(title="User", default=...)
    team: Team = Field(
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=...,
    )
    organization: Organization = Field(title="Organization", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class Team(GitHubWebhookModel):
    """Team

    Groups of organization members that gives permissions on specified repositories.
    """

    name: str = Field(description="Name of the team", default=...)
    id: int = Field(description="Unique identifier of the team", default=...)
    node_id: str = Field(default=...)
    slug: str = Field(default=...)
    description: Union[str, None] = Field(
        description="Description of the team", default=...
    )
    privacy: Literal["open", "closed", "secret"] = Field(default=...)
    url: str = Field(description="URL for the team", default=...)
    html_url: str = Field(default=...)
    members_url: str = Field(default=...)
    repositories_url: str = Field(default=...)
    permission: str = Field(
        description="Permission that the team will have for its repositories",
        default=...,
    )
    parent: Union[Unset, Union[TeamPropParent, None]] = Field(default=UNSET)


class TeamPropParent(GitHubWebhookModel):
    """TeamPropParent"""

    name: str = Field(description="Name of the team", default=...)
    id: int = Field(description="Unique identifier of the team", default=...)
    node_id: str = Field(default=...)
    slug: str = Field(default=...)
    description: Union[str, None] = Field(
        description="Description of the team", default=...
    )
    privacy: Literal["open", "closed", "secret"] = Field(default=...)
    url: str = Field(description="URL for the team", default=...)
    html_url: str = Field(default=...)
    members_url: str = Field(default=...)
    repositories_url: str = Field(default=...)
    permission: str = Field(
        description="Permission that the team will have for its repositories",
        default=...,
    )


class MembershipRemoved(GitHubWebhookModel):
    """membership removed event"""

    action: Literal["removed"] = Field(default=...)
    scope: Literal["team", "organization"] = Field(
        description="The scope of the membership. Currently, can only be `team`.",
        default=...,
    )
    member: User = Field(title="User", default=...)
    sender: User = Field(title="User", default=...)
    team: Union[Team, MembershipRemovedPropTeamOneof1] = Field(
        title="Team",
        description="The [team](https://docs.github.com/en/rest/reference/teams) for the membership.",
        default=...,
    )
    organization: Organization = Field(title="Organization", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class MembershipRemovedPropTeamOneof1(GitHubWebhookModel):
    """MembershipRemovedPropTeamOneof1"""

    id: int = Field(default=...)
    name: str = Field(default=...)
    deleted: Union[Unset, bool] = Field(default=UNSET)


class MergeGroupChecksRequested(GitHubWebhookModel):
    """merge group checks requested event"""

    action: Literal["checks_requested"] = Field(default=...)
    merge_group: MergeGroupChecksRequestedPropMergeGroup = Field(
        description="The merge group.", default=...
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class MergeGroupChecksRequestedPropMergeGroup(GitHubWebhookModel):
    """MergeGroupChecksRequestedPropMergeGroup

    The merge group.
    """

    head_sha: str = Field(description="The SHA of the merge group.", default=...)
    head_ref: str = Field(description="The full ref of the merge group.", default=...)
    base_ref: str = Field(
        description="The full ref of the branch the merge group will be merged into.",
        default=...,
    )


class MetaDeleted(GitHubWebhookModel):
    """meta deleted event"""

    action: Literal["deleted"] = Field(default=...)
    hook_id: int = Field(description="The id of the modified webhook.", default=...)
    hook: MetaDeletedPropHook = Field(
        description="The modified webhook. This will contain different keys based on the type of webhook it is: repository, organization, business, app, or GitHub Marketplace.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)


class MetaDeletedPropHook(GitHubWebhookModel):
    """MetaDeletedPropHook

    The modified webhook. This will contain different keys based on the type of
    webhook it is: repository, organization, business, app, or GitHub Marketplace.
    """

    type: str = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(default=...)
    active: bool = Field(default=...)
    events: Union[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "create",
                "delete",
                "deployment",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "meta",
                "milestone",
                "organization",
                "org_block",
                "package",
                "page_build",
                "project",
                "projects_v2_item",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "pull_request_review_thread",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_import",
                "repository_vulnerability_alert",
                "secret_scanning_alert",
                "secret_scanning_alert_location",
                "security_and_analysis",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_job",
                "workflow_run",
            ]
        ],
        List[Literal["*"]],
    ] = Field(max_items=1, min_items=1, title="Webhook Events", default=...)
    config: MetaDeletedPropHookPropConfig = Field(
        description="Configuration object of the webhook", default=...
    )
    updated_at: datetime = Field(default=...)
    created_at: datetime = Field(default=...)


class MetaDeletedPropHookPropConfig(GitHubWebhookModel):
    """MetaDeletedPropHookPropConfig

    Configuration object of the webhook
    """

    content_type: Literal["json", "form"] = Field(
        description="The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.",
        default=...,
    )
    secret: Union[Unset, str] = Field(
        description="If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).",
        default=UNSET,
    )
    url: str = Field(
        description="The URL to which the payloads will be delivered.", default=...
    )
    insecure_ssl: Literal["0", "1"] = Field(
        description="Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`.",
        default=...,
    )


class MilestoneClosed(GitHubWebhookModel):
    """milestone closed event"""

    action: Literal["closed"] = Field(default=...)
    milestone: MilestoneClosedPropMilestone = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class MilestoneClosedPropMilestone(GitHubWebhookModel):
    """MilestoneClosedPropMilestone"""

    url: str = Field(default=...)
    html_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    title: str = Field(description="The title of the milestone.", default=...)
    description: Union[str, None] = Field(default=...)
    creator: User = Field(title="User", default=...)
    open_issues: int = Field(default=...)
    closed_issues: int = Field(default=...)
    state: Literal["closed"] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    closed_at: datetime = Field(default=...)


class MilestoneClosedPropMilestoneAllof1(GitHubWebhookModel):
    """MilestoneClosedPropMilestoneAllof1"""

    state: Literal["closed"] = Field(default=...)
    closed_at: str = Field(default=...)


class MilestoneCreated(GitHubWebhookModel):
    """milestone created event"""

    action: Literal["created"] = Field(default=...)
    milestone: MilestoneCreatedPropMilestone = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class MilestoneCreatedPropMilestone(GitHubWebhookModel):
    """MilestoneCreatedPropMilestone"""

    url: str = Field(default=...)
    html_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    title: str = Field(description="The title of the milestone.", default=...)
    description: Union[str, None] = Field(default=...)
    creator: User = Field(title="User", default=...)
    open_issues: int = Field(default=...)
    closed_issues: int = Field(default=...)
    state: Literal["open"] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    closed_at: Union[None, None] = Field(default=...)


class MilestoneCreatedPropMilestoneAllof1(GitHubWebhookModel):
    """MilestoneCreatedPropMilestoneAllof1"""

    state: Literal["open"] = Field(default=...)
    closed_at: None = Field(default=...)


class MilestoneDeleted(GitHubWebhookModel):
    """milestone deleted event"""

    action: Literal["deleted"] = Field(default=...)
    milestone: Milestone = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class MilestoneEdited(GitHubWebhookModel):
    """milestone edited event"""

    action: Literal["edited"] = Field(default=...)
    changes: MilestoneEditedPropChanges = Field(
        description="The changes to the milestone if the action was `edited`.",
        default=...,
    )
    milestone: Milestone = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class MilestoneEditedPropChanges(GitHubWebhookModel):
    """MilestoneEditedPropChanges

    The changes to the milestone if the action was `edited`.
    """

    description: Union[Unset, MilestoneEditedPropChangesPropDescription] = Field(
        default=UNSET
    )
    due_on: Union[Unset, MilestoneEditedPropChangesPropDueOn] = Field(default=UNSET)
    title: Union[Unset, MilestoneEditedPropChangesPropTitle] = Field(default=UNSET)


class MilestoneEditedPropChangesPropDescription(GitHubWebhookModel):
    """MilestoneEditedPropChangesPropDescription"""

    from_: str = Field(
        description="The previous version of the description if the action was `edited`.",
        default=...,
        alias="from",
    )


class MilestoneEditedPropChangesPropDueOn(GitHubWebhookModel):
    """MilestoneEditedPropChangesPropDueOn"""

    from_: str = Field(
        description="The previous version of the due date if the action was `edited`.",
        default=...,
        alias="from",
    )


class MilestoneEditedPropChangesPropTitle(GitHubWebhookModel):
    """MilestoneEditedPropChangesPropTitle"""

    from_: str = Field(
        description="The previous version of the title if the action was `edited`.",
        default=...,
        alias="from",
    )


class MilestoneOpened(GitHubWebhookModel):
    """milestone opened event"""

    action: Literal["opened"] = Field(default=...)
    milestone: MilestoneOpenedPropMilestone = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class MilestoneOpenedPropMilestone(GitHubWebhookModel):
    """MilestoneOpenedPropMilestone"""

    url: str = Field(default=...)
    html_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    title: str = Field(description="The title of the milestone.", default=...)
    description: Union[str, None] = Field(default=...)
    creator: User = Field(title="User", default=...)
    open_issues: int = Field(default=...)
    closed_issues: int = Field(default=...)
    state: Literal["open"] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)
    closed_at: Union[None, None] = Field(default=...)


class MilestoneOpenedPropMilestoneAllof1(GitHubWebhookModel):
    """MilestoneOpenedPropMilestoneAllof1"""

    state: Literal["open"] = Field(default=...)
    closed_at: None = Field(default=...)


class OrgBlockBlocked(GitHubWebhookModel):
    """org_block blocked event"""

    action: Literal["blocked"] = Field(default=...)
    blocked_user: User = Field(title="User", default=...)
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Organization = Field(title="Organization", default=...)


class OrgBlockUnblocked(GitHubWebhookModel):
    """org_block unblocked event"""

    action: Literal["unblocked"] = Field(default=...)
    blocked_user: User = Field(title="User", default=...)
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Organization = Field(title="Organization", default=...)


class OrganizationDeleted(GitHubWebhookModel):
    """organization deleted event"""

    action: Literal["deleted"] = Field(default=...)
    membership: Union[Unset, Membership] = Field(
        title="Membership",
        description="The membership between the user and the organization. Not present when the action is `member_invited`.",
        default=UNSET,
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Organization = Field(title="Organization", default=...)


class Membership(GitHubWebhookModel):
    """Membership

    The membership between the user and the organization. Not present when the
    action is `member_invited`.
    """

    url: str = Field(default=...)
    state: str = Field(
        description="The state of the user's membership in the team.", default=...
    )
    role: str = Field(description="The role of the user in the team.", default=...)
    organization_url: str = Field(default=...)
    user: User = Field(title="User", default=...)


class OrganizationMemberAdded(GitHubWebhookModel):
    """organization member_added event"""

    action: Literal["member_added"] = Field(default=...)
    membership: Membership = Field(
        title="Membership",
        description="The membership between the user and the organization. Not present when the action is `member_invited`.",
        default=...,
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Organization = Field(title="Organization", default=...)


class OrganizationMemberInvited(GitHubWebhookModel):
    """organization member_invited event"""

    action: Literal["member_invited"] = Field(default=...)
    invitation: OrganizationMemberInvitedPropInvitation = Field(
        description="The invitation for the user or email if the action is `member_invited`.",
        default=...,
    )
    user: User = Field(title="User", default=...)
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Organization = Field(title="Organization", default=...)


class OrganizationMemberInvitedPropInvitation(GitHubWebhookModel):
    """OrganizationMemberInvitedPropInvitation

    The invitation for the user or email if the action is `member_invited`.
    """

    id: float = Field(default=...)
    node_id: str = Field(default=...)
    login: str = Field(default=...)
    email: Union[str, None] = Field(default=...)
    role: str = Field(default=...)
    created_at: datetime = Field(default=...)
    failed_at: Union[datetime, None] = Field(default=...)
    failed_reason: Union[str, None] = Field(default=...)
    inviter: User = Field(title="User", default=...)
    team_count: float = Field(default=...)
    invitation_teams_url: str = Field(default=...)


class OrganizationMemberRemoved(GitHubWebhookModel):
    """organization member_removed event"""

    action: Literal["member_removed"] = Field(default=...)
    membership: Membership = Field(
        title="Membership",
        description="The membership between the user and the organization. Not present when the action is `member_invited`.",
        default=...,
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Organization = Field(title="Organization", default=...)


class OrganizationRenamed(GitHubWebhookModel):
    """organization renamed event"""

    action: Literal["renamed"] = Field(default=...)
    membership: Membership = Field(
        title="Membership",
        description="The membership between the user and the organization. Not present when the action is `member_invited`.",
        default=...,
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Organization = Field(title="Organization", default=...)


class PackagePublished(GitHubWebhookModel):
    """package published event"""

    action: Literal["published"] = Field(default=...)
    package: PackagePublishedPropPackage = Field(
        description="Information about the package.", default=...
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class PackagePublishedPropPackage(GitHubWebhookModel):
    """PackagePublishedPropPackage

    Information about the package.
    """

    id: int = Field(description="Unique identifier of the package.", default=...)
    name: str = Field(description="The name of the package.", default=...)
    namespace: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    ecosystem: str = Field(default=...)
    package_type: Literal[
        "npm", "maven", "rubygems", "docker", "nuget", "container"
    ] = Field(
        description="The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.",
        default=...,
    )
    html_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    owner: User = Field(title="User", default=...)
    package_version: PackagePublishedPropPackagePropPackageVersion = Field(
        description="A version of a software package", default=...
    )
    registry: PackagePublishedPropPackagePropRegistry = Field(default=...)


class PackagePublishedPropPackagePropPackageVersion(GitHubWebhookModel):
    """PackagePublishedPropPackagePropPackageVersion

    A version of a software package
    """

    id: int = Field(
        description="Unique identifier of the package version.", default=...
    )
    version: str = Field(default=...)
    summary: str = Field(default=...)
    name: str = Field(description="The name of the package version.", default=...)
    description: str = Field(default=...)
    body: str = Field(default=...)
    body_html: str = Field(default=...)
    release: PackagePublishedPropPackagePropPackageVersionPropRelease = Field(
        default=...
    )
    manifest: str = Field(default=...)
    html_url: str = Field(default=...)
    tag_name: str = Field(default=...)
    target_commitish: str = Field(default=...)
    target_oid: str = Field(default=...)
    draft: bool = Field(default=...)
    prerelease: bool = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    metadata: List[Any] = Field(description="Package Version Metadata", default=...)
    docker_metadata: List[Any] = Field(default=...)
    package_files: List[
        PackagePublishedPropPackagePropPackageVersionPropPackageFilesItems
    ] = Field(default=...)
    author: User = Field(title="User", default=...)
    source_url: str = Field(default=...)
    installation_command: str = Field(default=...)


class PackagePublishedPropPackagePropPackageVersionPropRelease(GitHubWebhookModel):
    """PackagePublishedPropPackagePropPackageVersionPropRelease"""

    url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    tag_name: str = Field(default=...)
    target_commitish: str = Field(default=...)
    name: str = Field(default=...)
    draft: bool = Field(default=...)
    author: User = Field(title="User", default=...)
    prerelease: bool = Field(default=...)
    created_at: datetime = Field(default=...)
    published_at: datetime = Field(default=...)


class PackagePublishedPropPackagePropPackageVersionPropPackageFilesItems(
    GitHubWebhookModel
):
    """PackagePublishedPropPackagePropPackageVersionPropPackageFilesItems"""

    download_url: str = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(default=...)
    sha256: str = Field(default=...)
    sha1: str = Field(default=...)
    md5: str = Field(default=...)
    content_type: str = Field(default=...)
    state: str = Field(default=...)
    size: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class PackagePublishedPropPackagePropRegistry(GitHubWebhookModel):
    """PackagePublishedPropPackagePropRegistry"""

    about_url: str = Field(default=...)
    name: str = Field(default=...)
    type: str = Field(default=...)
    url: str = Field(default=...)
    vendor: str = Field(default=...)


class PackageUpdated(GitHubWebhookModel):
    """package updated event"""

    action: Literal["updated"] = Field(default=...)
    package: PackageUpdatedPropPackage = Field(
        description="Information about the package.", default=...
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class PackageUpdatedPropPackage(GitHubWebhookModel):
    """PackageUpdatedPropPackage

    Information about the package.
    """

    id: int = Field(description="Unique identifier of the package.", default=...)
    name: str = Field(description="The name of the package.", default=...)
    namespace: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    ecosystem: str = Field(default=...)
    package_type: Literal[
        "npm", "maven", "rubygems", "docker", "nuget", "container"
    ] = Field(default=...)
    html_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    owner: User = Field(title="User", default=...)
    package_version: PackageUpdatedPropPackagePropPackageVersion = Field(
        description="A version of a software package", default=...
    )
    registry: PackageUpdatedPropPackagePropRegistry = Field(default=...)


class PackageUpdatedPropPackagePropPackageVersion(GitHubWebhookModel):
    """PackageUpdatedPropPackagePropPackageVersion

    A version of a software package
    """

    id: int = Field(
        description="Unique identifier of the package version.", default=...
    )
    version: str = Field(default=...)
    summary: str = Field(default=...)
    name: str = Field(description="The name of the package version.", default=...)
    description: str = Field(default=...)
    body: str = Field(default=...)
    body_html: str = Field(default=...)
    release: PackageUpdatedPropPackagePropPackageVersionPropRelease = Field(default=...)
    manifest: str = Field(default=...)
    html_url: str = Field(default=...)
    tag_name: str = Field(default=...)
    target_commitish: str = Field(default=...)
    target_oid: str = Field(default=...)
    draft: bool = Field(default=...)
    prerelease: bool = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    metadata: List[Any] = Field(description="Package Version Metadata", default=...)
    docker_metadata: List[Any] = Field(default=...)
    package_files: List[
        PackageUpdatedPropPackagePropPackageVersionPropPackageFilesItems
    ] = Field(default=...)
    author: User = Field(title="User", default=...)
    source_url: str = Field(default=...)
    installation_command: str = Field(default=...)


class PackageUpdatedPropPackagePropPackageVersionPropRelease(GitHubWebhookModel):
    """PackageUpdatedPropPackagePropPackageVersionPropRelease"""

    url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    tag_name: str = Field(default=...)
    target_commitish: str = Field(default=...)
    name: str = Field(default=...)
    draft: bool = Field(default=...)
    author: User = Field(title="User", default=...)
    prerelease: bool = Field(default=...)
    created_at: datetime = Field(default=...)
    published_at: datetime = Field(default=...)


class PackageUpdatedPropPackagePropPackageVersionPropPackageFilesItems(
    GitHubWebhookModel
):
    """PackageUpdatedPropPackagePropPackageVersionPropPackageFilesItems"""

    download_url: str = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(default=...)
    sha256: str = Field(default=...)
    sha1: str = Field(default=...)
    md5: str = Field(default=...)
    content_type: str = Field(default=...)
    state: str = Field(default=...)
    size: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class PackageUpdatedPropPackagePropRegistry(GitHubWebhookModel):
    """PackageUpdatedPropPackagePropRegistry"""

    about_url: str = Field(default=...)
    name: str = Field(default=...)
    type: str = Field(default=...)
    url: str = Field(default=...)
    vendor: str = Field(default=...)


class PageBuildEvent(GitHubWebhookModel):
    """page_build event

    Page Build
    """

    id: int = Field(default=...)
    build: PageBuildEventPropBuild = Field(
        description="The [List GitHub Pages builds](https://docs.github.com/en/rest/reference/repos#list-github-pages-builds) itself.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class PageBuildEventPropBuild(GitHubWebhookModel):
    """PageBuildEventPropBuild

    The [List GitHub Pages
    builds](https://docs.github.com/en/rest/reference/repos#list-github-pages-
    builds) itself.
    """

    url: str = Field(default=...)
    status: str = Field(default=...)
    error: PageBuildEventPropBuildPropError = Field(default=...)
    pusher: User = Field(title="User", default=...)
    commit: str = Field(default=...)
    duration: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class PageBuildEventPropBuildPropError(GitHubWebhookModel):
    """PageBuildEventPropBuildPropError"""

    message: Union[str, None] = Field(default=...)


class PingEvent(GitHubWebhookModel):
    """ping event"""

    zen: str = Field(default=...)
    hook_id: int = Field(
        description="The ID of the webhook that triggered the ping.", default=...
    )
    hook: PingEventPropHook = Field(
        description="The [webhook configuration](https://docs.github.com/en/rest/reference/repos#get-a-repository-webhook).",
        default=...,
    )
    repository: Union[Unset, Repository] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    sender: Union[Unset, User] = Field(title="User", default=UNSET)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class PingEventPropHook(GitHubWebhookModel):
    """PingEventPropHook

    The [webhook configuration](https://docs.github.com/en/rest/reference/repos#get-
    a-repository-webhook).
    """

    type: Literal["Repository", "Organization", "App"] = Field(default=...)
    id: int = Field(default=...)
    name: str = Field(default=...)
    active: bool = Field(default=...)
    app_id: Union[Unset, int] = Field(
        description="When you register a new GitHub App, GitHub sends a ping event to the **webhook URL** you specified during registration. The event contains the `app_id`, which is required for [authenticating](https://docs.github.com/en/apps/building-integrations/setting-up-and-registering-github-apps/about-authentication-options-for-github-apps) an app.",
        default=UNSET,
    )
    events: Union[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "create",
                "delete",
                "deployment",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "meta",
                "milestone",
                "organization",
                "org_block",
                "package",
                "page_build",
                "project",
                "projects_v2_item",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "pull_request_review_thread",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_import",
                "repository_vulnerability_alert",
                "secret_scanning_alert",
                "secret_scanning_alert_location",
                "security_and_analysis",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_job",
                "workflow_run",
            ]
        ],
        List[Literal["*"]],
    ] = Field(max_items=1, min_items=1, title="Webhook Events", default=...)
    config: PingEventPropHookPropConfig = Field(
        description="Configuration object of the webhook", default=...
    )
    updated_at: datetime = Field(default=...)
    created_at: datetime = Field(default=...)
    url: str = Field(default=...)
    test_url: Union[Unset, str] = Field(default=UNSET)
    ping_url: str = Field(default=...)
    deliveries_url: str = Field(default=...)
    last_response: Union[Unset, PingEventPropHookPropLastResponse] = Field(
        default=UNSET
    )


class PingEventPropHookPropConfig(GitHubWebhookModel):
    """PingEventPropHookPropConfig

    Configuration object of the webhook
    """

    content_type: Literal["json", "form"] = Field(
        description="The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.",
        default=...,
    )
    secret: Union[Unset, str] = Field(
        description="If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).",
        default=UNSET,
    )
    url: str = Field(
        description="The URL to which the payloads will be delivered.", default=...
    )
    insecure_ssl: Literal["0", "1"] = Field(
        description="Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`.",
        default=...,
    )


class PingEventPropHookPropLastResponse(GitHubWebhookModel):
    """PingEventPropHookPropLastResponse"""

    code: None = Field(default=...)
    status: str = Field(default=...)
    message: None = Field(default=...)


class ProjectClosed(GitHubWebhookModel):
    """project closed event"""

    action: Literal["closed"] = Field(default=...)
    project: Project = Field(title="Project", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class Project(GitHubWebhookModel):
    """Project"""

    owner_url: str = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    columns_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="Name of the project", default=...)
    body: Union[str, None] = Field(description="Body of the project", default=...)
    number: int = Field(default=...)
    state: Literal["open", "closed"] = Field(
        description="State of the project; either 'open' or 'closed'", default=...
    )
    creator: User = Field(title="User", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class ProjectCreated(GitHubWebhookModel):
    """project created event"""

    action: Literal["created"] = Field(default=...)
    project: Project = Field(title="Project", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class ProjectDeleted(GitHubWebhookModel):
    """project deleted event"""

    action: Literal["deleted"] = Field(default=...)
    project: Project = Field(title="Project", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class ProjectEdited(GitHubWebhookModel):
    """project edited event"""

    action: Literal["edited"] = Field(default=...)
    changes: Union[Unset, ProjectEditedPropChanges] = Field(
        description="The changes to the project if the action was `edited`.",
        default=UNSET,
    )
    project: Project = Field(title="Project", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class ProjectEditedPropChanges(GitHubWebhookModel):
    """ProjectEditedPropChanges

    The changes to the project if the action was `edited`.
    """

    name: Union[Unset, ProjectEditedPropChangesPropName] = Field(default=UNSET)
    body: Union[Unset, ProjectEditedPropChangesPropBody] = Field(default=UNSET)


class ProjectEditedPropChangesPropName(GitHubWebhookModel):
    """ProjectEditedPropChangesPropName"""

    from_: str = Field(
        description="The changes to the project if the action was `edited`.",
        default=...,
        alias="from",
    )


class ProjectEditedPropChangesPropBody(GitHubWebhookModel):
    """ProjectEditedPropChangesPropBody"""

    from_: str = Field(
        description="The previous version of the body if the action was `edited`.",
        default=...,
        alias="from",
    )


class ProjectReopened(GitHubWebhookModel):
    """project reopened event"""

    action: Literal["reopened"] = Field(default=...)
    project: Project = Field(title="Project", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class ProjectCardConverted(GitHubWebhookModel):
    """project_card converted event"""

    action: Literal["converted"] = Field(default=...)
    changes: ProjectCardConvertedPropChanges = Field(default=...)
    project_card: ProjectCard = Field(title="Project Card", default=...)
    repository: Union[Unset, Repository] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    sender: User = Field(title="User", default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class ProjectCardConvertedPropChanges(GitHubWebhookModel):
    """ProjectCardConvertedPropChanges"""

    note: ProjectCardConvertedPropChangesPropNote = Field(default=...)


class ProjectCardConvertedPropChangesPropNote(GitHubWebhookModel):
    """ProjectCardConvertedPropChangesPropNote"""

    from_: str = Field(default=..., alias="from")


class ProjectCard(GitHubWebhookModel):
    """Project Card"""

    url: str = Field(default=...)
    project_url: str = Field(default=...)
    column_url: str = Field(default=...)
    column_id: int = Field(default=...)
    id: int = Field(description="The project card's ID", default=...)
    node_id: str = Field(default=...)
    note: Union[str, None] = Field(default=...)
    archived: bool = Field(
        description="Whether or not the card is archived", default=...
    )
    creator: User = Field(title="User", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    content_url: Union[Unset, str] = Field(default=UNSET)
    after_id: Union[Unset, Union[str, float, None]] = Field(default=UNSET)


class ProjectCardCreated(GitHubWebhookModel):
    """project_card created event"""

    action: Literal["created"] = Field(default=...)
    project_card: ProjectCard = Field(title="Project Card", default=...)
    repository: Union[Unset, Repository] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    sender: User = Field(title="User", default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class ProjectCardDeleted(GitHubWebhookModel):
    """project_card deleted event"""

    action: Literal["deleted"] = Field(default=...)
    project_card: ProjectCard = Field(title="Project Card", default=...)
    repository: Union[Unset, Repository] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    sender: User = Field(title="User", default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class ProjectCardEdited(GitHubWebhookModel):
    """project_card edited event"""

    action: Literal["edited"] = Field(default=...)
    changes: ProjectCardEditedPropChanges = Field(default=...)
    project_card: ProjectCard = Field(title="Project Card", default=...)
    repository: Union[Unset, Repository] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    sender: User = Field(title="User", default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class ProjectCardEditedPropChanges(GitHubWebhookModel):
    """ProjectCardEditedPropChanges"""

    note: ProjectCardEditedPropChangesPropNote = Field(default=...)


class ProjectCardEditedPropChangesPropNote(GitHubWebhookModel):
    """ProjectCardEditedPropChangesPropNote"""

    from_: str = Field(default=..., alias="from")


class ProjectCardMoved(GitHubWebhookModel):
    """project_card moved event"""

    action: Literal["moved"] = Field(default=...)
    changes: Union[Unset, ProjectCardMovedPropChanges] = Field(default=UNSET)
    project_card: ProjectCardMovedPropProjectCard = Field(default=...)
    repository: Union[Unset, Repository] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    sender: User = Field(title="User", default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class ProjectCardMovedPropChanges(GitHubWebhookModel):
    """ProjectCardMovedPropChanges"""

    column_id: ProjectCardMovedPropChangesPropColumnId = Field(default=...)


class ProjectCardMovedPropChangesPropColumnId(GitHubWebhookModel):
    """ProjectCardMovedPropChangesPropColumnId"""

    from_: int = Field(default=..., alias="from")


class ProjectCardMovedPropProjectCard(GitHubWebhookModel):
    """ProjectCardMovedPropProjectCard"""

    url: str = Field(default=...)
    project_url: str = Field(default=...)
    column_url: str = Field(default=...)
    column_id: int = Field(default=...)
    id: int = Field(description="The project card's ID", default=...)
    node_id: str = Field(default=...)
    note: Union[str, None] = Field(default=...)
    archived: bool = Field(
        description="Whether or not the card is archived", default=...
    )
    creator: User = Field(title="User", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    content_url: Union[Unset, str] = Field(default=UNSET)
    after_id: Union[Union[float, None], None] = Field(default=...)


class ProjectCardMovedPropProjectCardAllof1(GitHubWebhookModel):
    """ProjectCardMovedPropProjectCardAllof1"""

    after_id: Union[float, None] = Field(default=...)


class ProjectColumnCreated(GitHubWebhookModel):
    """project_column created event"""

    action: Literal["created"] = Field(default=...)
    project_column: ProjectColumn = Field(title="Project Column", default=...)
    repository: Union[Unset, Repository] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class ProjectColumn(GitHubWebhookModel):
    """Project Column"""

    url: str = Field(default=...)
    project_url: str = Field(default=...)
    cards_url: str = Field(default=...)
    id: int = Field(
        description="The unique identifier of the project column", default=...
    )
    node_id: str = Field(default=...)
    name: str = Field(description="Name of the project column", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class ProjectColumnDeleted(GitHubWebhookModel):
    """project_column deleted event"""

    action: Literal["deleted"] = Field(default=...)
    project_column: ProjectColumn = Field(title="Project Column", default=...)
    repository: Union[Unset, Repository] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class ProjectColumnEdited(GitHubWebhookModel):
    """project_column edited event"""

    action: Literal["edited"] = Field(default=...)
    changes: ProjectColumnEditedPropChanges = Field(default=...)
    project_column: ProjectColumn = Field(title="Project Column", default=...)
    repository: Union[Unset, Repository] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class ProjectColumnEditedPropChanges(GitHubWebhookModel):
    """ProjectColumnEditedPropChanges"""

    name: Union[Unset, ProjectColumnEditedPropChangesPropName] = Field(default=UNSET)


class ProjectColumnEditedPropChangesPropName(GitHubWebhookModel):
    """ProjectColumnEditedPropChangesPropName"""

    from_: str = Field(default=..., alias="from")


class ProjectColumnMoved(GitHubWebhookModel):
    """project_column moved event"""

    action: Literal["moved"] = Field(default=...)
    project_column: ProjectColumn = Field(title="Project Column", default=...)
    repository: Union[Unset, Repository] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class ProjectsV2ItemArchived(GitHubWebhookModel):
    """projects_v2_item archived event"""

    changes: ProjectsV2ItemArchivedPropChanges = Field(default=...)
    action: Literal["archived"] = Field(default=...)
    projects_v2_item: ProjectsV2ItemArchivedPropProjectsV2Item = Field(default=...)
    sender: User = Field(title="User", default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class ProjectsV2ItemArchivedPropChanges(GitHubWebhookModel):
    """ProjectsV2ItemArchivedPropChanges"""

    archived_at: ProjectsV2ItemArchivedPropChangesPropArchivedAt = Field(default=...)


class ProjectsV2ItemArchivedPropChangesPropArchivedAt(GitHubWebhookModel):
    """ProjectsV2ItemArchivedPropChangesPropArchivedAt"""

    from_: None = Field(default=..., alias="from")
    to: datetime = Field(default=...)


class ProjectsV2ItemArchivedPropProjectsV2Item(GitHubWebhookModel):
    """ProjectsV2ItemArchivedPropProjectsV2Item"""

    id: float = Field(default=...)
    node_id: str = Field(default=...)
    project_node_id: str = Field(default=...)
    content_node_id: str = Field(default=...)
    content_type: Literal["DraftIssue", "Issue", "PullRequest"] = Field(default=...)
    creator: User = Field(title="User", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    archived_at: datetime = Field(default=...)


class ProjectsV2Item(GitHubWebhookModel):
    """Projects v2 Item

    The project item itself. To find more information about the project item, you
    can use `node_id` (the node ID of the project item) and `project_node_id` (the
    node ID of the project) to query information in the GraphQL API. For more
    information, see "[Using the API to manage
    projects](https://docs.github.com/en/issues/trying-out-the-new-projects-
    experience/using-the-api-to-manage-projects)."
    """

    id: float = Field(default=...)
    node_id: str = Field(default=...)
    project_node_id: str = Field(default=...)
    content_node_id: str = Field(default=...)
    content_type: Literal["DraftIssue", "Issue", "PullRequest"] = Field(default=...)
    creator: User = Field(title="User", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    archived_at: Union[datetime, None] = Field(default=...)


class ProjectsV2ItemArchivedPropProjectsV2ItemAllof1(GitHubWebhookModel):
    """ProjectsV2ItemArchivedPropProjectsV2ItemAllof1"""

    archived_at: datetime = Field(default=...)


class ProjectsV2ItemConverted(GitHubWebhookModel):
    """projects_v2_item converted event"""

    changes: ProjectsV2ItemConvertedPropChanges = Field(default=...)
    action: Literal["converted"] = Field(default=...)
    projects_v2_item: ProjectsV2ItemConvertedPropProjectsV2Item = Field(default=...)
    sender: User = Field(title="User", default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class ProjectsV2ItemConvertedPropChanges(GitHubWebhookModel):
    """ProjectsV2ItemConvertedPropChanges"""

    content_type: ProjectsV2ItemConvertedPropChangesPropContentType = Field(default=...)


class ProjectsV2ItemConvertedPropChangesPropContentType(GitHubWebhookModel):
    """ProjectsV2ItemConvertedPropChangesPropContentType"""

    from_: Literal["DraftIssue"] = Field(default=..., alias="from")
    to: Literal["Issue"] = Field(default=...)


class ProjectsV2ItemConvertedPropProjectsV2Item(GitHubWebhookModel):
    """ProjectsV2ItemConvertedPropProjectsV2Item"""

    id: float = Field(default=...)
    node_id: str = Field(default=...)
    project_node_id: str = Field(default=...)
    content_node_id: str = Field(default=...)
    content_type: Literal["Issue"] = Field(default=...)
    creator: User = Field(title="User", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    archived_at: Union[datetime, None] = Field(default=...)


class ProjectsV2ItemConvertedPropProjectsV2ItemAllof1(GitHubWebhookModel):
    """ProjectsV2ItemConvertedPropProjectsV2ItemAllof1"""

    content_type: Literal["Issue"] = Field(default=...)


class ProjectsV2ItemCreated(GitHubWebhookModel):
    """projects_v2_item created event"""

    action: Literal["created"] = Field(default=...)
    projects_v2_item: ProjectsV2ItemCreatedPropProjectsV2Item = Field(default=...)
    sender: User = Field(title="User", default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class ProjectsV2ItemCreatedPropProjectsV2Item(GitHubWebhookModel):
    """ProjectsV2ItemCreatedPropProjectsV2Item"""

    id: float = Field(default=...)
    node_id: str = Field(default=...)
    project_node_id: str = Field(default=...)
    content_node_id: str = Field(default=...)
    content_type: Literal["DraftIssue", "Issue", "PullRequest"] = Field(default=...)
    creator: User = Field(title="User", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    archived_at: Union[None, None] = Field(default=...)


class ProjectsV2ItemCreatedPropProjectsV2ItemAllof1(GitHubWebhookModel):
    """ProjectsV2ItemCreatedPropProjectsV2ItemAllof1"""

    archived_at: None = Field(default=...)


class ProjectsV2ItemDeleted(GitHubWebhookModel):
    """projects_v2_item deleted event"""

    action: Literal["deleted"] = Field(default=...)
    projects_v2_item: ProjectsV2Item = Field(
        title="Projects v2 Item",
        description='The project item itself. To find more information about the project item, you can use `node_id` (the node ID of the project item) and `project_node_id` (the node ID of the project) to query information in the GraphQL API. For more information, see "[Using the API to manage projects](https://docs.github.com/en/issues/trying-out-the-new-projects-experience/using-the-api-to-manage-projects)."',
        default=...,
    )
    sender: User = Field(title="User", default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class ProjectsV2ItemEdited(GitHubWebhookModel):
    """projects_v2_item edited event"""

    changes: ProjectsV2ItemEditedPropChanges = Field(default=...)
    action: Literal["edited"] = Field(default=...)
    projects_v2_item: ProjectsV2Item = Field(
        title="Projects v2 Item",
        description='The project item itself. To find more information about the project item, you can use `node_id` (the node ID of the project item) and `project_node_id` (the node ID of the project) to query information in the GraphQL API. For more information, see "[Using the API to manage projects](https://docs.github.com/en/issues/trying-out-the-new-projects-experience/using-the-api-to-manage-projects)."',
        default=...,
    )
    sender: User = Field(title="User", default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class ProjectsV2ItemEditedPropChanges(GitHubWebhookModel):
    """ProjectsV2ItemEditedPropChanges"""

    field_value: ProjectsV2ItemEditedPropChangesPropFieldValue = Field(default=...)


class ProjectsV2ItemEditedPropChangesPropFieldValue(GitHubWebhookModel):
    """ProjectsV2ItemEditedPropChangesPropFieldValue"""

    field_type: Literal["single_select", "date", "number", "text", "iteration"] = Field(
        default=...
    )
    field_node_id: str = Field(default=...)


class ProjectsV2ItemReordered(GitHubWebhookModel):
    """projects_v2_item reordered event"""

    changes: ProjectsV2ItemReorderedPropChanges = Field(default=...)
    action: Literal["reordered"] = Field(default=...)
    projects_v2_item: ProjectsV2Item = Field(
        title="Projects v2 Item",
        description='The project item itself. To find more information about the project item, you can use `node_id` (the node ID of the project item) and `project_node_id` (the node ID of the project) to query information in the GraphQL API. For more information, see "[Using the API to manage projects](https://docs.github.com/en/issues/trying-out-the-new-projects-experience/using-the-api-to-manage-projects)."',
        default=...,
    )
    sender: User = Field(title="User", default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class ProjectsV2ItemReorderedPropChanges(GitHubWebhookModel):
    """ProjectsV2ItemReorderedPropChanges"""

    previous_projects_v2_item_node_id: ProjectsV2ItemReorderedPropChangesPropPreviousProjectsV2ItemNodeId = Field(
        default=...
    )


class ProjectsV2ItemReorderedPropChangesPropPreviousProjectsV2ItemNodeId(
    GitHubWebhookModel
):
    """ProjectsV2ItemReorderedPropChangesPropPreviousProjectsV2ItemNodeId"""

    from_: str = Field(default=..., alias="from")
    to: Union[str, None] = Field(default=...)


class ProjectsV2ItemRestored(GitHubWebhookModel):
    """projects_v2_item restored event"""

    changes: ProjectsV2ItemRestoredPropChanges = Field(default=...)
    action: Literal["restored"] = Field(default=...)
    projects_v2_item: ProjectsV2ItemRestoredPropProjectsV2Item = Field(default=...)
    sender: User = Field(title="User", default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class ProjectsV2ItemRestoredPropChanges(GitHubWebhookModel):
    """ProjectsV2ItemRestoredPropChanges"""

    archived_at: ProjectsV2ItemRestoredPropChangesPropArchivedAt = Field(default=...)


class ProjectsV2ItemRestoredPropChangesPropArchivedAt(GitHubWebhookModel):
    """ProjectsV2ItemRestoredPropChangesPropArchivedAt"""

    from_: datetime = Field(default=..., alias="from")
    to: None = Field(default=...)


class ProjectsV2ItemRestoredPropProjectsV2Item(GitHubWebhookModel):
    """ProjectsV2ItemRestoredPropProjectsV2Item"""

    id: float = Field(default=...)
    node_id: str = Field(default=...)
    project_node_id: str = Field(default=...)
    content_node_id: str = Field(default=...)
    content_type: Literal["DraftIssue", "Issue", "PullRequest"] = Field(default=...)
    creator: User = Field(title="User", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    archived_at: Union[None, None] = Field(default=...)


class ProjectsV2ItemRestoredPropProjectsV2ItemAllof1(GitHubWebhookModel):
    """ProjectsV2ItemRestoredPropProjectsV2ItemAllof1"""

    archived_at: None = Field(default=...)


class PublicEvent(GitHubWebhookModel):
    """public event

    When a private repository is made public.
    """

    repository: PublicEventPropRepository = Field(default=...)
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class PublicEventPropRepository(GitHubWebhookModel):
    """PublicEventPropRepository"""

    id: int = Field(description="Unique identifier of the repository", default=...)
    node_id: str = Field(
        description="The GraphQL identifier of the repository.", default=...
    )
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(
        description="The full, globally unique, name of the repository.", default=...
    )
    private: Literal[False] = Field(default=...)
    owner: User = Field(title="User", default=...)
    html_url: str = Field(
        description="The URL to view the repository on GitHub.com.", default=...
    )
    description: Union[str, None] = Field(
        description="The repository description.", default=...
    )
    fork: bool = Field(description="Whether the repository is a fork.", default=...)
    url: str = Field(
        description="The URL to get more information about the repository from the GitHub API.",
        default=...,
    )
    forks_url: str = Field(
        description="The API URL to list the forks of the repository.", default=...
    )
    keys_url: str = Field(
        description="A template for the API URL to get information about deploy keys on the repository.",
        default=...,
    )
    collaborators_url: str = Field(
        description="A template for the API URL to get information about collaborators of the repository.",
        default=...,
    )
    teams_url: str = Field(
        description="The API URL to list the teams on the repository.", default=...
    )
    hooks_url: str = Field(
        description="The API URL to list the hooks on the repository.", default=...
    )
    issue_events_url: str = Field(
        description="A template for the API URL to get information about issue events on the repository.",
        default=...,
    )
    events_url: str = Field(
        description="The API URL to list the events of the repository.", default=...
    )
    assignees_url: str = Field(
        description="A template for the API URL to list the available assignees for issues in the repository.",
        default=...,
    )
    branches_url: str = Field(
        description="A template for the API URL to get information about branches in the repository.",
        default=...,
    )
    tags_url: str = Field(
        description="The API URL to get information about tags on the repository.",
        default=...,
    )
    blobs_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git blob in the repository.",
        default=...,
    )
    git_tags_url: str = Field(
        description="A template for the API URL to get information about Git tags of the repository.",
        default=...,
    )
    git_refs_url: str = Field(
        description="A template for the API URL to get information about Git refs of the repository.",
        default=...,
    )
    trees_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git tree of the repository.",
        default=...,
    )
    statuses_url: str = Field(
        description="A template for the API URL to get information about statuses of a commit.",
        default=...,
    )
    languages_url: str = Field(
        description="The API URL to get information about the languages of the repository.",
        default=...,
    )
    stargazers_url: str = Field(
        description="The API URL to list the stargazers on the repository.", default=...
    )
    contributors_url: str = Field(
        description="A template for the API URL to list the contributors to the repository.",
        default=...,
    )
    subscribers_url: str = Field(
        description="The API URL to list the subscribers on the repository.",
        default=...,
    )
    subscription_url: str = Field(
        description="The API URL to subscribe to notifications for this repository.",
        default=...,
    )
    commits_url: str = Field(
        description="A template for the API URL to get information about commits on the repository.",
        default=...,
    )
    git_commits_url: str = Field(
        description="A template for the API URL to get information about Git commits of the repository.",
        default=...,
    )
    comments_url: str = Field(
        description="A template for the API URL to get information about comments on the repository.",
        default=...,
    )
    issue_comment_url: str = Field(
        description="A template for the API URL to get information about issue comments on the repository.",
        default=...,
    )
    contents_url: str = Field(
        description="A template for the API URL to get the contents of the repository.",
        default=...,
    )
    compare_url: str = Field(
        description="A template for the API URL to compare two commits or refs.",
        default=...,
    )
    merges_url: str = Field(
        description="The API URL to merge branches in the repository.", default=...
    )
    archive_url: str = Field(
        description="A template for the API URL to download the repository as an archive.",
        default=...,
    )
    downloads_url: str = Field(
        description="The API URL to list the downloads on the repository.", default=...
    )
    issues_url: str = Field(
        description="A template for the API URL to get information about issues on the repository.",
        default=...,
    )
    pulls_url: str = Field(
        description="A template for the API URL to get information about pull requests on the repository.",
        default=...,
    )
    milestones_url: str = Field(
        description="A template for the API URL to get information about milestones of the repository.",
        default=...,
    )
    notifications_url: str = Field(
        description="A template for the API URL to get information about notifications on the repository.",
        default=...,
    )
    labels_url: str = Field(
        description="A template for the API URL to get information about labels of the repository.",
        default=...,
    )
    releases_url: str = Field(
        description="A template for the API URL to get information about releases on the repository.",
        default=...,
    )
    deployments_url: str = Field(
        description="The API URL to list the deployments of the repository.",
        default=...,
    )
    created_at: Union[int, datetime] = Field(default=...)
    updated_at: datetime = Field(default=...)
    pushed_at: Union[int, datetime, None] = Field(default=...)
    git_url: str = Field(default=...)
    ssh_url: str = Field(default=...)
    clone_url: str = Field(default=...)
    svn_url: str = Field(default=...)
    homepage: Union[str, None] = Field(default=...)
    size: int = Field(default=...)
    stargazers_count: int = Field(default=...)
    watchers_count: int = Field(default=...)
    language: Union[str, None] = Field(default=...)
    has_issues: bool = Field(description="Whether issues are enabled.", default=True)
    has_projects: bool = Field(
        description="Whether projects are enabled.", default=True
    )
    has_downloads: bool = Field(
        description="Whether downloads are enabled.", default=True
    )
    has_wiki: bool = Field(description="Whether the wiki is enabled.", default=True)
    has_pages: bool = Field(default=...)
    forks_count: int = Field(default=...)
    mirror_url: Union[str, None] = Field(default=...)
    archived: bool = Field(
        description="Whether the repository is archived.", default=False
    )
    disabled: Union[Unset, bool] = Field(
        description="Returns whether or not this repository is disabled.", default=UNSET
    )
    open_issues_count: int = Field(default=...)
    license_: Union[License, None] = Field(
        title="License", default=..., alias="license"
    )
    forks: int = Field(default=...)
    open_issues: int = Field(default=...)
    watchers: int = Field(default=...)
    stargazers: Union[Unset, int] = Field(default=UNSET)
    default_branch: str = Field(
        description="The default branch of the repository.", default=...
    )
    allow_squash_merge: Union[Unset, bool] = Field(
        description="Whether to allow squash merges for pull requests.", default=True
    )
    allow_merge_commit: Union[Unset, bool] = Field(
        description="Whether to allow merge commits for pull requests.", default=True
    )
    allow_rebase_merge: Union[Unset, bool] = Field(
        description="Whether to allow rebase merges for pull requests.", default=True
    )
    allow_auto_merge: Union[Unset, bool] = Field(
        description="Whether to allow auto-merge for pull requests.", default=False
    )
    allow_forking: Union[Unset, bool] = Field(
        description="Whether to allow private forks", default=UNSET
    )
    allow_update_branch: Union[Unset, bool] = Field(default=UNSET)
    use_squash_pr_title_as_default: Union[Unset, bool] = Field(default=UNSET)
    squash_merge_commit_message: Union[Unset, str] = Field(default=UNSET)
    squash_merge_commit_title: Union[Unset, str] = Field(default=UNSET)
    merge_commit_message: Union[Unset, str] = Field(default=UNSET)
    merge_commit_title: Union[Unset, str] = Field(default=UNSET)
    is_template: bool = Field(default=...)
    web_commit_signoff_required: bool = Field(default=...)
    topics: List[str] = Field(default=...)
    visibility: Literal["public", "private", "internal"] = Field(default=...)
    delete_branch_on_merge: Union[Unset, bool] = Field(
        description="Whether to delete head branches when pull requests are merged",
        default=False,
    )
    master_branch: Union[Unset, str] = Field(default=UNSET)
    permissions: Union[Unset, RepositoryPropPermissions] = Field(default=UNSET)
    public: Union[Unset, bool] = Field(default=UNSET)
    organization: Union[Unset, str] = Field(default=UNSET)


class PublicEventPropRepositoryAllof1(GitHubWebhookModel):
    """PublicEventPropRepositoryAllof1"""

    private: Literal[False] = Field(default=...)


class PullRequestAssigned(GitHubWebhookModel):
    """pull_request assigned event"""

    action: Literal["assigned"] = Field(default=...)
    number: int = Field(description="The pull request number.", default=...)
    pull_request: PullRequest = Field(title="Pull Request", default=...)
    assignee: User = Field(title="User", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequest(GitHubWebhookModel):
    """Pull Request"""

    url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    diff_url: str = Field(default=...)
    patch_url: str = Field(default=...)
    issue_url: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the pull request within its repository.",
        default=...,
    )
    state: Literal["open", "closed"] = Field(
        description="State of this Pull Request. Either `open` or `closed`.",
        default=...,
    )
    locked: bool = Field(default=...)
    title: str = Field(description="The title of the pull request.", default=...)
    user: User = Field(title="User", default=...)
    body: Union[str, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    merged_at: Union[datetime, None] = Field(default=...)
    merge_commit_sha: Union[str, None] = Field(default=...)
    assignee: Union[User, None] = Field(title="User", default=...)
    assignees: List[User] = Field(default=...)
    requested_reviewers: List[Union[User, Team]] = Field(default=...)
    requested_teams: List[Team] = Field(default=...)
    labels: List[Label] = Field(default=...)
    milestone: Union[Milestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    commits_url: str = Field(default=...)
    review_comments_url: str = Field(default=...)
    review_comment_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    head: PullRequestPropHead = Field(default=...)
    base: PullRequestPropBase = Field(default=...)
    links: PullRequestPropLinks = Field(default=..., alias="_links")
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    auto_merge: Union[AutoMerge, None] = Field(
        title="PullRequestAutoMerge",
        description="The status of auto merging a pull request.",
        default=...,
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    draft: bool = Field(
        description="Indicates whether or not the pull request is a draft.", default=...
    )
    merged: Union[bool, None] = Field(default=...)
    mergeable: Union[bool, None] = Field(default=...)
    rebaseable: Union[bool, None] = Field(default=...)
    mergeable_state: str = Field(default=...)
    merged_by: Union[User, None] = Field(title="User", default=...)
    comments: int = Field(default=...)
    review_comments: int = Field(default=...)
    maintainer_can_modify: bool = Field(
        description="Indicates whether maintainers can modify the pull request.",
        default=...,
    )
    commits: int = Field(default=...)
    additions: int = Field(default=...)
    deletions: int = Field(default=...)
    changed_files: int = Field(default=...)


class PullRequestPropHead(GitHubWebhookModel):
    """PullRequestPropHead"""

    label: str = Field(default=...)
    ref: str = Field(default=...)
    sha: str = Field(default=...)
    user: User = Field(title="User", default=...)
    repo: Repository = Field(
        title="Repository", description="A git repository", default=...
    )


class PullRequestPropBase(GitHubWebhookModel):
    """PullRequestPropBase"""

    label: str = Field(default=...)
    ref: str = Field(default=...)
    sha: str = Field(default=...)
    user: User = Field(title="User", default=...)
    repo: Repository = Field(
        title="Repository", description="A git repository", default=...
    )


class PullRequestPropLinks(GitHubWebhookModel):
    """PullRequestPropLinks"""

    self_: Link = Field(title="Link", default=..., alias="self")
    html: Link = Field(title="Link", default=...)
    issue: Link = Field(title="Link", default=...)
    comments: Link = Field(title="Link", default=...)
    review_comments: Link = Field(title="Link", default=...)
    review_comment: Link = Field(title="Link", default=...)
    commits: Link = Field(title="Link", default=...)
    statuses: Link = Field(title="Link", default=...)


class Link(GitHubWebhookModel):
    """Link"""

    href: str = Field(default=...)


class AutoMerge(GitHubWebhookModel):
    """PullRequestAutoMerge

    The status of auto merging a pull request.
    """

    enabled_by: User = Field(title="User", default=...)
    merge_method: Literal["merge", "squash", "rebase"] = Field(
        description="The merge method to use.", default=...
    )
    commit_title: str = Field(
        description="Title for the merge commit message.", default=...
    )
    commit_message: str = Field(
        description="Commit message for the merge commit.", default=...
    )


class PullRequestAutoMergeDisabled(GitHubWebhookModel):
    """pull_request auto_merge_disabled event"""

    action: Literal["auto_merge_disabled"] = Field(default=...)
    number: int = Field(default=...)
    pull_request: PullRequest = Field(title="Pull Request", default=...)
    reason: str = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestAutoMergeEnabled(GitHubWebhookModel):
    """pull_request auto_merge_enabled event"""

    action: Literal["auto_merge_enabled"] = Field(default=...)
    number: int = Field(default=...)
    pull_request: PullRequest = Field(title="Pull Request", default=...)
    reason: str = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestClosed(GitHubWebhookModel):
    """pull_request closed event"""

    action: Literal["closed"] = Field(default=...)
    number: int = Field(description="The pull request number.", default=...)
    pull_request: PullRequestClosedPropPullRequest = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestClosedPropPullRequest(GitHubWebhookModel):
    """PullRequestClosedPropPullRequest"""

    url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    diff_url: str = Field(default=...)
    patch_url: str = Field(default=...)
    issue_url: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the pull request within its repository.",
        default=...,
    )
    state: Literal["closed"] = Field(
        description="State of this Pull Request. Either `open` or `closed`.",
        default=...,
    )
    locked: bool = Field(default=...)
    title: str = Field(description="The title of the pull request.", default=...)
    user: User = Field(title="User", default=...)
    body: Union[str, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: datetime = Field(default=...)
    merged_at: Union[datetime, None] = Field(default=...)
    merge_commit_sha: Union[str, None] = Field(default=...)
    assignee: Union[User, None] = Field(title="User", default=...)
    assignees: List[User] = Field(default=...)
    requested_reviewers: List[Union[User, Team]] = Field(default=...)
    requested_teams: List[Team] = Field(default=...)
    labels: List[Label] = Field(default=...)
    milestone: Union[Milestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    commits_url: str = Field(default=...)
    review_comments_url: str = Field(default=...)
    review_comment_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    head: PullRequestPropHead = Field(default=...)
    base: PullRequestPropBase = Field(default=...)
    links: PullRequestPropLinks = Field(default=..., alias="_links")
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    auto_merge: Union[AutoMerge, None] = Field(
        title="PullRequestAutoMerge",
        description="The status of auto merging a pull request.",
        default=...,
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    draft: bool = Field(
        description="Indicates whether or not the pull request is a draft.", default=...
    )
    merged: bool = Field(default=...)
    mergeable: Union[bool, None] = Field(default=...)
    rebaseable: Union[bool, None] = Field(default=...)
    mergeable_state: str = Field(default=...)
    merged_by: Union[User, None] = Field(title="User", default=...)
    comments: int = Field(default=...)
    review_comments: int = Field(default=...)
    maintainer_can_modify: bool = Field(
        description="Indicates whether maintainers can modify the pull request.",
        default=...,
    )
    commits: int = Field(default=...)
    additions: int = Field(default=...)
    deletions: int = Field(default=...)
    changed_files: int = Field(default=...)


class PullRequestClosedPropPullRequestAllof1(GitHubWebhookModel):
    """PullRequestClosedPropPullRequestAllof1"""

    state: Literal["closed"] = Field(
        description="State of this Pull Request. Either `open` or `closed`.",
        default=...,
    )
    closed_at: datetime = Field(default=...)
    merged: bool = Field(default=...)


class PullRequestConvertedToDraft(GitHubWebhookModel):
    """pull_request converted_to_draft event"""

    action: Literal["converted_to_draft"] = Field(default=...)
    number: int = Field(description="The pull request number.", default=...)
    pull_request: PullRequestConvertedToDraftPropPullRequest = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestConvertedToDraftPropPullRequest(GitHubWebhookModel):
    """PullRequestConvertedToDraftPropPullRequest"""

    url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    diff_url: str = Field(default=...)
    patch_url: str = Field(default=...)
    issue_url: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the pull request within its repository.",
        default=...,
    )
    state: Literal["open", "closed"] = Field(
        description="State of this Pull Request. Either `open` or `closed`.",
        default=...,
    )
    locked: bool = Field(default=...)
    title: str = Field(description="The title of the pull request.", default=...)
    user: User = Field(title="User", default=...)
    body: Union[str, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[None, None] = Field(default=...)
    merged_at: Union[None, None] = Field(default=...)
    merge_commit_sha: Union[str, None] = Field(default=...)
    assignee: Union[User, None] = Field(title="User", default=...)
    assignees: List[User] = Field(default=...)
    requested_reviewers: List[Union[User, Team]] = Field(default=...)
    requested_teams: List[Team] = Field(default=...)
    labels: List[Label] = Field(default=...)
    milestone: Union[Milestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    commits_url: str = Field(default=...)
    review_comments_url: str = Field(default=...)
    review_comment_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    head: PullRequestPropHead = Field(default=...)
    base: PullRequestPropBase = Field(default=...)
    links: PullRequestPropLinks = Field(default=..., alias="_links")
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    auto_merge: Union[AutoMerge, None] = Field(
        title="PullRequestAutoMerge",
        description="The status of auto merging a pull request.",
        default=...,
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    draft: Literal[True] = Field(
        description="Indicates whether or not the pull request is a draft.", default=...
    )
    merged: Literal[False] = Field(default=...)
    mergeable: Union[bool, None] = Field(default=...)
    rebaseable: Union[bool, None] = Field(default=...)
    mergeable_state: str = Field(default=...)
    merged_by: Union[None, None] = Field(default=...)
    comments: int = Field(default=...)
    review_comments: int = Field(default=...)
    maintainer_can_modify: bool = Field(
        description="Indicates whether maintainers can modify the pull request.",
        default=...,
    )
    commits: int = Field(default=...)
    additions: int = Field(default=...)
    deletions: int = Field(default=...)
    changed_files: int = Field(default=...)


class PullRequestConvertedToDraftPropPullRequestAllof1(GitHubWebhookModel):
    """PullRequestConvertedToDraftPropPullRequestAllof1"""

    closed_at: None = Field(default=...)
    merged_at: None = Field(default=...)
    draft: Literal[True] = Field(
        description="Indicates whether or not the pull request is a draft.", default=...
    )
    merged: Literal[False] = Field(default=...)
    merged_by: None = Field(default=...)


class PullRequestDequeued(GitHubWebhookModel):
    """pull_request dequeued event"""

    action: Literal["dequeued"] = Field(default=...)
    number: int = Field(description="The pull request number.", default=...)
    reason: str = Field(
        description="The reason the pull request was removed from a merge queue.",
        default=...,
    )
    pull_request: PullRequest = Field(title="Pull Request", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestEdited(GitHubWebhookModel):
    """pull_request edited event"""

    action: Literal["edited"] = Field(default=...)
    number: int = Field(description="The pull request number.", default=...)
    changes: PullRequestEditedPropChanges = Field(
        description="The changes to the comment if the action was `edited`.",
        default=...,
    )
    pull_request: PullRequest = Field(title="Pull Request", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestEditedPropChanges(GitHubWebhookModel):
    """PullRequestEditedPropChanges

    The changes to the comment if the action was `edited`.
    """

    body: Union[Unset, PullRequestEditedPropChangesPropBody] = Field(default=UNSET)
    title: Union[Unset, PullRequestEditedPropChangesPropTitle] = Field(default=UNSET)
    base: Union[Unset, PullRequestEditedPropChangesPropBase] = Field(default=UNSET)


class PullRequestEditedPropChangesPropBody(GitHubWebhookModel):
    """PullRequestEditedPropChangesPropBody"""

    from_: str = Field(
        description="The previous version of the body if the action was `edited`.",
        default=...,
        alias="from",
    )


class PullRequestEditedPropChangesPropTitle(GitHubWebhookModel):
    """PullRequestEditedPropChangesPropTitle"""

    from_: str = Field(
        description="The previous version of the title if the action was `edited`.",
        default=...,
        alias="from",
    )


class PullRequestEditedPropChangesPropBase(GitHubWebhookModel):
    """PullRequestEditedPropChangesPropBase"""

    ref: PullRequestEditedPropChangesPropBasePropRef = Field(default=...)
    sha: PullRequestEditedPropChangesPropBasePropSha = Field(default=...)


class PullRequestEditedPropChangesPropBasePropRef(GitHubWebhookModel):
    """PullRequestEditedPropChangesPropBasePropRef"""

    from_: str = Field(default=..., alias="from")


class PullRequestEditedPropChangesPropBasePropSha(GitHubWebhookModel):
    """PullRequestEditedPropChangesPropBasePropSha"""

    from_: str = Field(default=..., alias="from")


class PullRequestLabeled(GitHubWebhookModel):
    """pull_request labeled event"""

    action: Literal["labeled"] = Field(default=...)
    number: int = Field(description="The pull request number.", default=...)
    pull_request: PullRequest = Field(title="Pull Request", default=...)
    label: Label = Field(title="Label", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestLocked(GitHubWebhookModel):
    """pull_request locked event"""

    action: Literal["locked"] = Field(default=...)
    number: int = Field(description="The pull request number.", default=...)
    pull_request: PullRequest = Field(title="Pull Request", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestOpened(GitHubWebhookModel):
    """pull_request opened event"""

    action: Literal["opened"] = Field(default=...)
    number: int = Field(description="The pull request number.", default=...)
    pull_request: PullRequestOpenedPropPullRequest = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestOpenedPropPullRequest(GitHubWebhookModel):
    """PullRequestOpenedPropPullRequest"""

    url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    diff_url: str = Field(default=...)
    patch_url: str = Field(default=...)
    issue_url: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the pull request within its repository.",
        default=...,
    )
    state: Literal["open"] = Field(default=...)
    locked: bool = Field(default=...)
    title: str = Field(description="The title of the pull request.", default=...)
    user: User = Field(title="User", default=...)
    body: Union[str, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[None, None] = Field(default=...)
    merged_at: Union[None, None] = Field(default=...)
    merge_commit_sha: Union[str, None] = Field(default=...)
    assignee: Union[User, None] = Field(title="User", default=...)
    assignees: List[User] = Field(default=...)
    requested_reviewers: List[Union[User, Team]] = Field(default=...)
    requested_teams: List[Team] = Field(default=...)
    labels: List[Label] = Field(default=...)
    milestone: Union[Milestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    commits_url: str = Field(default=...)
    review_comments_url: str = Field(default=...)
    review_comment_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    head: PullRequestPropHead = Field(default=...)
    base: PullRequestPropBase = Field(default=...)
    links: PullRequestPropLinks = Field(default=..., alias="_links")
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    auto_merge: Union[AutoMerge, None] = Field(
        title="PullRequestAutoMerge",
        description="The status of auto merging a pull request.",
        default=...,
    )
    active_lock_reason: Union[None, None] = Field(default=...)
    draft: bool = Field(
        description="Indicates whether or not the pull request is a draft.", default=...
    )
    merged: Union[bool, None] = Field(default=...)
    mergeable: Union[bool, None] = Field(default=...)
    rebaseable: Union[bool, None] = Field(default=...)
    mergeable_state: str = Field(default=...)
    merged_by: Union[None, None] = Field(default=...)
    comments: int = Field(default=...)
    review_comments: int = Field(default=...)
    maintainer_can_modify: bool = Field(
        description="Indicates whether maintainers can modify the pull request.",
        default=...,
    )
    commits: int = Field(default=...)
    additions: int = Field(default=...)
    deletions: int = Field(default=...)
    changed_files: int = Field(default=...)


class PullRequestOpenedPropPullRequestAllof1(GitHubWebhookModel):
    """PullRequestOpenedPropPullRequestAllof1"""

    state: Literal["open"] = Field(default=...)
    closed_at: None = Field(default=...)
    merged_at: None = Field(default=...)
    active_lock_reason: None = Field(default=...)
    merged_by: None = Field(default=...)


class PullRequestQueued(GitHubWebhookModel):
    """pull_request queued event"""

    action: Literal["queued"] = Field(default=...)
    number: int = Field(description="The pull request number.", default=...)
    pull_request: PullRequest = Field(title="Pull Request", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestReadyForReview(GitHubWebhookModel):
    """pull_request ready_for_review event"""

    action: Literal["ready_for_review"] = Field(default=...)
    number: int = Field(description="The pull request number.", default=...)
    pull_request: PullRequestReadyForReviewPropPullRequest = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestReadyForReviewPropPullRequest(GitHubWebhookModel):
    """PullRequestReadyForReviewPropPullRequest"""

    url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    diff_url: str = Field(default=...)
    patch_url: str = Field(default=...)
    issue_url: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the pull request within its repository.",
        default=...,
    )
    state: Literal["open"] = Field(default=...)
    locked: bool = Field(default=...)
    title: str = Field(description="The title of the pull request.", default=...)
    user: User = Field(title="User", default=...)
    body: Union[str, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[None, None] = Field(default=...)
    merged_at: Union[None, None] = Field(default=...)
    merge_commit_sha: Union[str, None] = Field(default=...)
    assignee: Union[User, None] = Field(title="User", default=...)
    assignees: List[User] = Field(default=...)
    requested_reviewers: List[Union[User, Team]] = Field(default=...)
    requested_teams: List[Team] = Field(default=...)
    labels: List[Label] = Field(default=...)
    milestone: Union[Milestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    commits_url: str = Field(default=...)
    review_comments_url: str = Field(default=...)
    review_comment_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    head: PullRequestPropHead = Field(default=...)
    base: PullRequestPropBase = Field(default=...)
    links: PullRequestPropLinks = Field(default=..., alias="_links")
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    auto_merge: Union[AutoMerge, None] = Field(
        title="PullRequestAutoMerge",
        description="The status of auto merging a pull request.",
        default=...,
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    draft: Literal[False] = Field(
        description="Indicates whether or not the pull request is a draft.", default=...
    )
    merged: bool = Field(default=...)
    mergeable: Union[bool, None] = Field(default=...)
    rebaseable: Union[bool, None] = Field(default=...)
    mergeable_state: str = Field(default=...)
    merged_by: Union[None, None] = Field(default=...)
    comments: int = Field(default=...)
    review_comments: int = Field(default=...)
    maintainer_can_modify: bool = Field(
        description="Indicates whether maintainers can modify the pull request.",
        default=...,
    )
    commits: int = Field(default=...)
    additions: int = Field(default=...)
    deletions: int = Field(default=...)
    changed_files: int = Field(default=...)


class PullRequestReadyForReviewPropPullRequestAllof1(GitHubWebhookModel):
    """PullRequestReadyForReviewPropPullRequestAllof1"""

    state: Literal["open"] = Field(default=...)
    closed_at: None = Field(default=...)
    merged_at: None = Field(default=...)
    draft: Literal[False] = Field(
        description="Indicates whether or not the pull request is a draft.", default=...
    )
    merged: bool = Field(default=...)
    merged_by: None = Field(default=...)


class PullRequestReopened(GitHubWebhookModel):
    """pull_request reopened event"""

    action: Literal["reopened"] = Field(default=...)
    number: int = Field(description="The pull request number.", default=...)
    pull_request: PullRequestReopenedPropPullRequest = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestReopenedPropPullRequest(GitHubWebhookModel):
    """PullRequestReopenedPropPullRequest"""

    url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    diff_url: str = Field(default=...)
    patch_url: str = Field(default=...)
    issue_url: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the pull request within its repository.",
        default=...,
    )
    state: Literal["open"] = Field(default=...)
    locked: bool = Field(default=...)
    title: str = Field(description="The title of the pull request.", default=...)
    user: User = Field(title="User", default=...)
    body: Union[str, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[None, None] = Field(default=...)
    merged_at: Union[None, None] = Field(default=...)
    merge_commit_sha: Union[str, None] = Field(default=...)
    assignee: Union[User, None] = Field(title="User", default=...)
    assignees: List[User] = Field(default=...)
    requested_reviewers: List[Union[User, Team]] = Field(default=...)
    requested_teams: List[Team] = Field(default=...)
    labels: List[Label] = Field(default=...)
    milestone: Union[Milestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    commits_url: str = Field(default=...)
    review_comments_url: str = Field(default=...)
    review_comment_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    head: PullRequestPropHead = Field(default=...)
    base: PullRequestPropBase = Field(default=...)
    links: PullRequestPropLinks = Field(default=..., alias="_links")
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    auto_merge: Union[AutoMerge, None] = Field(
        title="PullRequestAutoMerge",
        description="The status of auto merging a pull request.",
        default=...,
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)
    draft: bool = Field(
        description="Indicates whether or not the pull request is a draft.", default=...
    )
    merged: bool = Field(default=...)
    mergeable: Union[bool, None] = Field(default=...)
    rebaseable: Union[bool, None] = Field(default=...)
    mergeable_state: str = Field(default=...)
    merged_by: Union[None, None] = Field(default=...)
    comments: int = Field(default=...)
    review_comments: int = Field(default=...)
    maintainer_can_modify: bool = Field(
        description="Indicates whether maintainers can modify the pull request.",
        default=...,
    )
    commits: int = Field(default=...)
    additions: int = Field(default=...)
    deletions: int = Field(default=...)
    changed_files: int = Field(default=...)


class PullRequestReopenedPropPullRequestAllof1(GitHubWebhookModel):
    """PullRequestReopenedPropPullRequestAllof1"""

    state: Literal["open"] = Field(default=...)
    closed_at: None = Field(default=...)
    merged_at: None = Field(default=...)
    merged: bool = Field(default=...)
    merged_by: None = Field(default=...)


class PullRequestReviewRequestRemovedOneof0(GitHubWebhookModel):
    """PullRequestReviewRequestRemovedOneof0"""

    action: Literal["review_request_removed"] = Field(default=...)
    number: int = Field(description="The pull request number.", default=...)
    pull_request: PullRequest = Field(title="Pull Request", default=...)
    requested_reviewer: User = Field(title="User", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestReviewRequestRemovedOneof1(GitHubWebhookModel):
    """PullRequestReviewRequestRemovedOneof1"""

    action: Literal["review_request_removed"] = Field(default=...)
    number: int = Field(description="The pull request number.", default=...)
    pull_request: PullRequest = Field(title="Pull Request", default=...)
    requested_team: Team = Field(
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestReviewRequestedOneof0(GitHubWebhookModel):
    """PullRequestReviewRequestedOneof0"""

    action: Literal["review_requested"] = Field(default=...)
    number: int = Field(description="The pull request number.", default=...)
    pull_request: PullRequest = Field(title="Pull Request", default=...)
    requested_reviewer: User = Field(title="User", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestReviewRequestedOneof1(GitHubWebhookModel):
    """PullRequestReviewRequestedOneof1"""

    action: Literal["review_requested"] = Field(default=...)
    number: int = Field(description="The pull request number.", default=...)
    pull_request: PullRequest = Field(title="Pull Request", default=...)
    requested_team: Team = Field(
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestSynchronize(GitHubWebhookModel):
    """pull_request synchronize event"""

    action: Literal["synchronize"] = Field(default=...)
    number: int = Field(description="The pull request number.", default=...)
    before: str = Field(default=...)
    after: str = Field(default=...)
    pull_request: PullRequest = Field(title="Pull Request", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestUnassigned(GitHubWebhookModel):
    """pull_request unassigned event"""

    action: Literal["unassigned"] = Field(default=...)
    number: int = Field(description="The pull request number.", default=...)
    pull_request: PullRequest = Field(title="Pull Request", default=...)
    assignee: User = Field(title="User", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestUnlabeled(GitHubWebhookModel):
    """pull_request unlabeled event"""

    action: Literal["unlabeled"] = Field(default=...)
    number: int = Field(description="The pull request number.", default=...)
    pull_request: PullRequest = Field(title="Pull Request", default=...)
    label: Label = Field(title="Label", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestUnlocked(GitHubWebhookModel):
    """pull_request unlocked event"""

    action: Literal["unlocked"] = Field(default=...)
    number: int = Field(description="The pull request number.", default=...)
    pull_request: PullRequest = Field(title="Pull Request", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestReviewDismissed(GitHubWebhookModel):
    """pull_request_review dismissed event"""

    action: Literal["dismissed"] = Field(default=...)
    review: PullRequestReviewDismissedPropReview = Field(default=...)
    pull_request: SimplePullRequest = Field(title="Simple Pull Request", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestReviewDismissedPropReview(GitHubWebhookModel):
    """PullRequestReviewDismissedPropReview"""

    id: int = Field(description="Unique identifier of the review", default=...)
    node_id: str = Field(default=...)
    user: User = Field(title="User", default=...)
    body: Union[str, None] = Field(description="The text of the review.", default=...)
    commit_id: str = Field(description="A commit SHA for the review.", default=...)
    submitted_at: Union[datetime, None] = Field(default=...)
    state: Literal["dismissed"] = Field(default=...)
    html_url: str = Field(default=...)
    pull_request_url: str = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    links: PullRequestReviewPropLinks = Field(default=..., alias="_links")


class PullRequestReview(GitHubWebhookModel):
    """Pull Request Review

    The review that was affected.
    """

    id: int = Field(description="Unique identifier of the review", default=...)
    node_id: str = Field(default=...)
    user: User = Field(title="User", default=...)
    body: Union[str, None] = Field(description="The text of the review.", default=...)
    commit_id: str = Field(description="A commit SHA for the review.", default=...)
    submitted_at: Union[datetime, None] = Field(default=...)
    state: Literal["commented", "changes_requested", "approved", "dismissed"] = Field(
        default=...
    )
    html_url: str = Field(default=...)
    pull_request_url: str = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    links: PullRequestReviewPropLinks = Field(default=..., alias="_links")


class PullRequestReviewPropLinks(GitHubWebhookModel):
    """PullRequestReviewPropLinks"""

    html: Link = Field(title="Link", default=...)
    pull_request: Link = Field(title="Link", default=...)


class PullRequestReviewDismissedPropReviewAllof1(GitHubWebhookModel):
    """PullRequestReviewDismissedPropReviewAllof1"""

    state: Literal["dismissed"] = Field(default=...)


class SimplePullRequest(GitHubWebhookModel):
    """Simple Pull Request"""

    url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    diff_url: str = Field(default=...)
    patch_url: str = Field(default=...)
    issue_url: str = Field(default=...)
    number: int = Field(default=...)
    state: Literal["open", "closed"] = Field(default=...)
    locked: bool = Field(default=...)
    title: str = Field(default=...)
    user: User = Field(title="User", default=...)
    body: Union[str, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    merged_at: Union[datetime, None] = Field(default=...)
    merge_commit_sha: Union[str, None] = Field(default=...)
    assignee: Union[User, None] = Field(title="User", default=...)
    assignees: List[User] = Field(default=...)
    requested_reviewers: List[Union[User, Team]] = Field(default=...)
    requested_teams: List[Team] = Field(default=...)
    labels: List[Label] = Field(default=...)
    milestone: Union[Milestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    draft: bool = Field(default=...)
    commits_url: str = Field(default=...)
    review_comments_url: str = Field(default=...)
    review_comment_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    head: SimplePullRequestPropHead = Field(default=...)
    base: SimplePullRequestPropBase = Field(default=...)
    links: SimplePullRequestPropLinks = Field(default=..., alias="_links")
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    auto_merge: Union[AutoMerge, None] = Field(
        title="PullRequestAutoMerge",
        description="The status of auto merging a pull request.",
        default=...,
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)


class SimplePullRequestPropHead(GitHubWebhookModel):
    """SimplePullRequestPropHead"""

    label: str = Field(default=...)
    ref: str = Field(default=...)
    sha: str = Field(default=...)
    user: User = Field(title="User", default=...)
    repo: Repository = Field(
        title="Repository", description="A git repository", default=...
    )


class SimplePullRequestPropBase(GitHubWebhookModel):
    """SimplePullRequestPropBase"""

    label: str = Field(default=...)
    ref: str = Field(default=...)
    sha: str = Field(default=...)
    user: User = Field(title="User", default=...)
    repo: Repository = Field(
        title="Repository", description="A git repository", default=...
    )


class SimplePullRequestPropLinks(GitHubWebhookModel):
    """SimplePullRequestPropLinks"""

    self_: Link = Field(title="Link", default=..., alias="self")
    html: Link = Field(title="Link", default=...)
    issue: Link = Field(title="Link", default=...)
    comments: Link = Field(title="Link", default=...)
    review_comments: Link = Field(title="Link", default=...)
    review_comment: Link = Field(title="Link", default=...)
    commits: Link = Field(title="Link", default=...)
    statuses: Link = Field(title="Link", default=...)


class PullRequestReviewEdited(GitHubWebhookModel):
    """pull_request_review edited event"""

    action: Literal["edited"] = Field(default=...)
    changes: PullRequestReviewEditedPropChanges = Field(default=...)
    review: PullRequestReview = Field(
        title="Pull Request Review",
        description="The review that was affected.",
        default=...,
    )
    pull_request: SimplePullRequest = Field(title="Simple Pull Request", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestReviewEditedPropChanges(GitHubWebhookModel):
    """PullRequestReviewEditedPropChanges"""

    body: Union[Unset, PullRequestReviewEditedPropChangesPropBody] = Field(
        default=UNSET
    )


class PullRequestReviewEditedPropChangesPropBody(GitHubWebhookModel):
    """PullRequestReviewEditedPropChangesPropBody"""

    from_: str = Field(
        description="The previous version of the body if the action was `edited`.",
        default=...,
        alias="from",
    )


class PullRequestReviewSubmitted(GitHubWebhookModel):
    """pull_request_review submitted event"""

    action: Literal["submitted"] = Field(default=...)
    review: PullRequestReview = Field(
        title="Pull Request Review",
        description="The review that was affected.",
        default=...,
    )
    pull_request: SimplePullRequest = Field(title="Simple Pull Request", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestReviewCommentCreated(GitHubWebhookModel):
    """pull_request_review_comment created event"""

    action: Literal["created"] = Field(default=...)
    comment: PullRequestReviewComment = Field(
        title="Pull Request Review Comment",
        description="The [comment](https://docs.github.com/en/rest/reference/pulls#comments) itself.",
        default=...,
    )
    pull_request: PullRequestReviewCommentCreatedPropPullRequest = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestReviewComment(GitHubWebhookModel):
    """Pull Request Review Comment

    The [comment](https://docs.github.com/en/rest/reference/pulls#comments) itself.
    """

    url: str = Field(description="URL for the pull request review comment", default=...)
    pull_request_review_id: int = Field(
        description="The ID of the pull request review to which the comment belongs.",
        default=...,
    )
    id: int = Field(
        description="The ID of the pull request review comment.", default=...
    )
    node_id: str = Field(
        description="The node ID of the pull request review comment.", default=...
    )
    diff_hunk: str = Field(
        description="The diff of the line that the comment refers to.", default=...
    )
    path: str = Field(
        description="The relative path of the file to which the comment applies.",
        default=...,
    )
    position: Union[int, None] = Field(
        description="The line index in the diff to which the comment applies.",
        default=...,
    )
    original_position: int = Field(
        description="The index of the original line in the diff to which the comment applies.",
        default=...,
    )
    commit_id: str = Field(
        description="The SHA of the commit to which the comment applies.", default=...
    )
    original_commit_id: str = Field(
        description="The SHA of the original commit to which the comment applies.",
        default=...,
    )
    user: User = Field(title="User", default=...)
    body: str = Field(description="The text of the comment.", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    html_url: str = Field(
        description="HTML URL for the pull request review comment.", default=...
    )
    pull_request_url: str = Field(
        description="URL for the pull request that the review comment belongs to.",
        default=...,
    )
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    links: PullRequestReviewCommentPropLinks = Field(default=..., alias="_links")
    reactions: Reactions = Field(title="Reactions", default=...)
    start_line: Union[int, None] = Field(
        description="The first line of the range for a multi-line comment.", default=...
    )
    original_start_line: Union[int, None] = Field(
        description="The first line of the range for a multi-line comment.", default=...
    )
    start_side: Union[None, Literal["LEFT", "RIGHT"]] = Field(
        description="The side of the first line of the range for a multi-line comment.",
        default="RIGHT",
    )
    line: Union[int, None] = Field(
        description="The line of the blob to which the comment applies. The last line of the range for a multi-line comment",
        default=...,
    )
    original_line: int = Field(
        description="The line of the blob to which the comment applies. The last line of the range for a multi-line comment",
        default=...,
    )
    side: Literal["LEFT", "RIGHT"] = Field(
        description="The side of the first line of the range for a multi-line comment.",
        default=...,
    )
    in_reply_to_id: Union[Unset, int] = Field(
        description="The comment ID to reply to.", default=UNSET
    )


class PullRequestReviewCommentPropLinks(GitHubWebhookModel):
    """PullRequestReviewCommentPropLinks"""

    self_: Link = Field(title="Link", default=..., alias="self")
    html: Link = Field(title="Link", default=...)
    pull_request: Link = Field(title="Link", default=...)


class PullRequestReviewCommentCreatedPropPullRequest(GitHubWebhookModel):
    """PullRequestReviewCommentCreatedPropPullRequest"""

    url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    diff_url: str = Field(default=...)
    patch_url: str = Field(default=...)
    issue_url: str = Field(default=...)
    number: int = Field(default=...)
    state: Literal["open", "closed"] = Field(default=...)
    locked: bool = Field(default=...)
    title: str = Field(default=...)
    user: User = Field(title="User", default=...)
    body: Union[str, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    merged_at: Union[datetime, None] = Field(default=...)
    merge_commit_sha: Union[str, None] = Field(default=...)
    assignee: Union[User, None] = Field(title="User", default=...)
    assignees: List[User] = Field(default=...)
    requested_reviewers: List[Union[User, Team]] = Field(default=...)
    requested_teams: List[Team] = Field(default=...)
    labels: List[Label] = Field(default=...)
    milestone: Union[Milestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    draft: Union[Unset, bool] = Field(default=UNSET)
    commits_url: str = Field(default=...)
    review_comments_url: str = Field(default=...)
    review_comment_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    head: PullRequestReviewCommentCreatedPropPullRequestPropHead = Field(default=...)
    base: PullRequestReviewCommentCreatedPropPullRequestPropBase = Field(default=...)
    links: PullRequestReviewCommentCreatedPropPullRequestPropLinks = Field(
        default=..., alias="_links"
    )
    auto_merge: Union[Unset, Union[AutoMerge, None]] = Field(
        title="PullRequestAutoMerge",
        description="The status of auto merging a pull request.",
        default=UNSET,
    )
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)


class PullRequestReviewCommentCreatedPropPullRequestPropHead(GitHubWebhookModel):
    """PullRequestReviewCommentCreatedPropPullRequestPropHead"""

    label: str = Field(default=...)
    ref: str = Field(default=...)
    sha: str = Field(default=...)
    user: User = Field(title="User", default=...)
    repo: Repository = Field(
        title="Repository", description="A git repository", default=...
    )


class PullRequestReviewCommentCreatedPropPullRequestPropBase(GitHubWebhookModel):
    """PullRequestReviewCommentCreatedPropPullRequestPropBase"""

    label: str = Field(default=...)
    ref: str = Field(default=...)
    sha: str = Field(default=...)
    user: User = Field(title="User", default=...)
    repo: Repository = Field(
        title="Repository", description="A git repository", default=...
    )


class PullRequestReviewCommentCreatedPropPullRequestPropLinks(GitHubWebhookModel):
    """PullRequestReviewCommentCreatedPropPullRequestPropLinks"""

    self_: Link = Field(title="Link", default=..., alias="self")
    html: Link = Field(title="Link", default=...)
    issue: Link = Field(title="Link", default=...)
    comments: Link = Field(title="Link", default=...)
    review_comments: Link = Field(title="Link", default=...)
    review_comment: Link = Field(title="Link", default=...)
    commits: Link = Field(title="Link", default=...)
    statuses: Link = Field(title="Link", default=...)


class PullRequestReviewCommentDeleted(GitHubWebhookModel):
    """pull_request_review_comment deleted event"""

    action: Literal["deleted"] = Field(default=...)
    comment: PullRequestReviewComment = Field(
        title="Pull Request Review Comment",
        description="The [comment](https://docs.github.com/en/rest/reference/pulls#comments) itself.",
        default=...,
    )
    pull_request: PullRequestReviewCommentDeletedPropPullRequest = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestReviewCommentDeletedPropPullRequest(GitHubWebhookModel):
    """PullRequestReviewCommentDeletedPropPullRequest"""

    url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    diff_url: str = Field(default=...)
    patch_url: str = Field(default=...)
    issue_url: str = Field(default=...)
    number: int = Field(default=...)
    state: Literal["open", "closed"] = Field(default=...)
    locked: bool = Field(default=...)
    title: str = Field(default=...)
    user: User = Field(title="User", default=...)
    body: Union[str, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    merged_at: Union[datetime, None] = Field(default=...)
    merge_commit_sha: Union[str, None] = Field(default=...)
    assignee: Union[User, None] = Field(title="User", default=...)
    assignees: List[User] = Field(default=...)
    requested_reviewers: List[Union[User, Team]] = Field(default=...)
    requested_teams: List[Team] = Field(default=...)
    labels: List[Label] = Field(default=...)
    milestone: Union[Milestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    draft: Union[Unset, bool] = Field(default=UNSET)
    commits_url: str = Field(default=...)
    review_comments_url: str = Field(default=...)
    review_comment_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    head: PullRequestReviewCommentDeletedPropPullRequestPropHead = Field(default=...)
    base: PullRequestReviewCommentDeletedPropPullRequestPropBase = Field(default=...)
    links: PullRequestReviewCommentDeletedPropPullRequestPropLinks = Field(
        default=..., alias="_links"
    )
    auto_merge: Union[Unset, Union[AutoMerge, None]] = Field(
        title="PullRequestAutoMerge",
        description="The status of auto merging a pull request.",
        default=UNSET,
    )
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)


class PullRequestReviewCommentDeletedPropPullRequestPropHead(GitHubWebhookModel):
    """PullRequestReviewCommentDeletedPropPullRequestPropHead"""

    label: str = Field(default=...)
    ref: str = Field(default=...)
    sha: str = Field(default=...)
    user: User = Field(title="User", default=...)
    repo: Repository = Field(
        title="Repository", description="A git repository", default=...
    )


class PullRequestReviewCommentDeletedPropPullRequestPropBase(GitHubWebhookModel):
    """PullRequestReviewCommentDeletedPropPullRequestPropBase"""

    label: str = Field(default=...)
    ref: str = Field(default=...)
    sha: str = Field(default=...)
    user: User = Field(title="User", default=...)
    repo: Repository = Field(
        title="Repository", description="A git repository", default=...
    )


class PullRequestReviewCommentDeletedPropPullRequestPropLinks(GitHubWebhookModel):
    """PullRequestReviewCommentDeletedPropPullRequestPropLinks"""

    self_: Link = Field(title="Link", default=..., alias="self")
    html: Link = Field(title="Link", default=...)
    issue: Link = Field(title="Link", default=...)
    comments: Link = Field(title="Link", default=...)
    review_comments: Link = Field(title="Link", default=...)
    review_comment: Link = Field(title="Link", default=...)
    commits: Link = Field(title="Link", default=...)
    statuses: Link = Field(title="Link", default=...)


class PullRequestReviewCommentEdited(GitHubWebhookModel):
    """pull_request_review_comment edited event"""

    action: Literal["edited"] = Field(default=...)
    changes: PullRequestReviewCommentEditedPropChanges = Field(
        description="The changes to the comment.", default=...
    )
    comment: PullRequestReviewComment = Field(
        title="Pull Request Review Comment",
        description="The [comment](https://docs.github.com/en/rest/reference/pulls#comments) itself.",
        default=...,
    )
    pull_request: PullRequestReviewCommentEditedPropPullRequest = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestReviewCommentEditedPropChanges(GitHubWebhookModel):
    """PullRequestReviewCommentEditedPropChanges

    The changes to the comment.
    """

    body: Union[Unset, PullRequestReviewCommentEditedPropChangesPropBody] = Field(
        default=UNSET
    )


class PullRequestReviewCommentEditedPropChangesPropBody(GitHubWebhookModel):
    """PullRequestReviewCommentEditedPropChangesPropBody"""

    from_: str = Field(
        description="The previous version of the body.", default=..., alias="from"
    )


class PullRequestReviewCommentEditedPropPullRequest(GitHubWebhookModel):
    """PullRequestReviewCommentEditedPropPullRequest"""

    url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    diff_url: str = Field(default=...)
    patch_url: str = Field(default=...)
    issue_url: str = Field(default=...)
    number: int = Field(default=...)
    state: Literal["open", "closed"] = Field(default=...)
    locked: bool = Field(default=...)
    title: str = Field(default=...)
    user: User = Field(title="User", default=...)
    body: Union[str, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    merged_at: Union[datetime, None] = Field(default=...)
    merge_commit_sha: Union[str, None] = Field(default=...)
    assignee: Union[User, None] = Field(title="User", default=...)
    assignees: List[User] = Field(default=...)
    requested_reviewers: List[Union[User, Team]] = Field(default=...)
    requested_teams: List[Team] = Field(default=...)
    labels: List[Label] = Field(default=...)
    milestone: Union[Milestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    draft: Union[Unset, bool] = Field(default=UNSET)
    commits_url: str = Field(default=...)
    review_comments_url: str = Field(default=...)
    review_comment_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    head: PullRequestReviewCommentEditedPropPullRequestPropHead = Field(default=...)
    base: PullRequestReviewCommentEditedPropPullRequestPropBase = Field(default=...)
    links: PullRequestReviewCommentEditedPropPullRequestPropLinks = Field(
        default=..., alias="_links"
    )
    auto_merge: Union[Unset, Union[AutoMerge, None]] = Field(
        title="PullRequestAutoMerge",
        description="The status of auto merging a pull request.",
        default=UNSET,
    )
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field(default=...)


class PullRequestReviewCommentEditedPropPullRequestPropHead(GitHubWebhookModel):
    """PullRequestReviewCommentEditedPropPullRequestPropHead"""

    label: str = Field(default=...)
    ref: str = Field(default=...)
    sha: str = Field(default=...)
    user: User = Field(title="User", default=...)
    repo: Repository = Field(
        title="Repository", description="A git repository", default=...
    )


class PullRequestReviewCommentEditedPropPullRequestPropBase(GitHubWebhookModel):
    """PullRequestReviewCommentEditedPropPullRequestPropBase"""

    label: str = Field(default=...)
    ref: str = Field(default=...)
    sha: str = Field(default=...)
    user: User = Field(title="User", default=...)
    repo: Repository = Field(
        title="Repository", description="A git repository", default=...
    )


class PullRequestReviewCommentEditedPropPullRequestPropLinks(GitHubWebhookModel):
    """PullRequestReviewCommentEditedPropPullRequestPropLinks"""

    self_: Link = Field(title="Link", default=..., alias="self")
    html: Link = Field(title="Link", default=...)
    issue: Link = Field(title="Link", default=...)
    comments: Link = Field(title="Link", default=...)
    review_comments: Link = Field(title="Link", default=...)
    review_comment: Link = Field(title="Link", default=...)
    commits: Link = Field(title="Link", default=...)
    statuses: Link = Field(title="Link", default=...)


class PullRequestReviewThreadResolved(GitHubWebhookModel):
    """pull_request_review_thread resolved event"""

    action: Literal["resolved"] = Field(default=...)
    thread: PullRequestReviewThreadResolvedPropThread = Field(default=...)
    pull_request: SimplePullRequest = Field(title="Simple Pull Request", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestReviewThreadResolvedPropThread(GitHubWebhookModel):
    """PullRequestReviewThreadResolvedPropThread"""

    node_id: str = Field(default=...)
    comments: List[PullRequestReviewComment] = Field(default=...)


class PullRequestReviewThreadUnresolved(GitHubWebhookModel):
    """pull_request_review_thread unresolved event"""

    action: Literal["unresolved"] = Field(default=...)
    thread: PullRequestReviewThreadUnresolvedPropThread = Field(default=...)
    pull_request: SimplePullRequest = Field(title="Simple Pull Request", default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class PullRequestReviewThreadUnresolvedPropThread(GitHubWebhookModel):
    """PullRequestReviewThreadUnresolvedPropThread"""

    node_id: str = Field(default=...)
    comments: List[PullRequestReviewComment] = Field(default=...)


class PushEvent(GitHubWebhookModel):
    """push event"""

    ref: str = Field(
        description="The full git ref that was pushed. Example: `refs/heads/main` or `refs/tags/v3.14.1`.",
        default=...,
    )
    before: str = Field(
        description="The SHA of the most recent commit on `ref` before the push.",
        default=...,
    )
    after: str = Field(
        description="The SHA of the most recent commit on `ref` after the push.",
        default=...,
    )
    created: bool = Field(
        description="Whether this push created the `ref`.", default=...
    )
    deleted: bool = Field(
        description="Whether this push deleted the `ref`.", default=...
    )
    forced: bool = Field(
        description="Whether this push was a force push of the `ref`.", default=...
    )
    base_ref: Union[str, None] = Field(default=...)
    compare: str = Field(
        description="URL that shows the changes in this `ref` update, from the `before` commit to the `after` commit. For a newly created `ref` that is directly based on the default branch, this is the comparison between the head of the default branch and the `after` commit. Otherwise, this shows all commits until the `after` commit.",
        default=...,
    )
    commits: List[Commit] = Field(
        description="An array of commit objects describing the pushed commits. (Pushed commits are all commits that are included in the `compare` between the `before` commit and the `after` commit.) The array includes a maximum of 20 commits. If necessary, you can use the [Commits API](https://docs.github.com/en/rest/reference/repos#commits) to fetch additional commits. This limit is applied to timeline events only and isn't applied to webhook deliveries.",
        default=...,
    )
    head_commit: Union[Commit, None] = Field(
        title="Commit",
        description="For pushes where `after` is or points to a commit object, an expanded representation of that commit. For pushes where `after` refers to an annotated tag object, an expanded representation of the commit pointed to by the annotated tag.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    pusher: Committer = Field(
        title="Committer",
        description="Metaproperties for Git author/committer information.",
        default=...,
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class Commit(GitHubWebhookModel):
    """Commit"""

    id: str = Field(default=...)
    tree_id: str = Field(default=...)
    distinct: bool = Field(
        description="Whether this commit is distinct from any that have been pushed before.",
        default=...,
    )
    message: str = Field(description="The commit message.", default=...)
    timestamp: datetime = Field(
        description="The ISO 8601 timestamp of the commit.", default=...
    )
    url: str = Field(
        description="URL that points to the commit API resource.", default=...
    )
    author: Committer = Field(
        title="Committer",
        description="Metaproperties for Git author/committer information.",
        default=...,
    )
    committer: Committer = Field(
        title="Committer",
        description="Metaproperties for Git author/committer information.",
        default=...,
    )
    added: List[str] = Field(
        description="An array of files added in the commit. For extremely large commits where GitHub is unable to calculate this list in a timely manner, this may be empty even if files were added.",
        default=...,
    )
    modified: List[str] = Field(
        description="An array of files modified by the commit. For extremely large commits where GitHub is unable to calculate this list in a timely manner, this may be empty even if files were modified.",
        default=...,
    )
    removed: List[str] = Field(
        description="An array of files removed in the commit. For extremely large commits where GitHub is unable to calculate this list in a timely manner, this may be empty even if files were removed.",
        default=...,
    )


class ReleaseCreated(GitHubWebhookModel):
    """release created event"""

    action: Literal["created"] = Field(default=...)
    release: Release = Field(
        title="Release",
        description="The [release](https://docs.github.com/en/rest/reference/repos/#get-a-release) object.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class Release(GitHubWebhookModel):
    """Release

    The [release](https://docs.github.com/en/rest/reference/repos/#get-a-release)
    object.
    """

    url: str = Field(default=...)
    assets_url: str = Field(default=...)
    upload_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    tag_name: str = Field(description="The name of the tag.", default=...)
    target_commitish: str = Field(
        description="Specifies the commitish value that determines where the Git tag is created from.",
        default=...,
    )
    name: str = Field(default=...)
    draft: bool = Field(
        description="Wether the release is a draft or published", default=...
    )
    author: User = Field(title="User", default=...)
    prerelease: bool = Field(
        description="Whether the release is identified as a prerelease or a full release.",
        default=...,
    )
    created_at: Union[datetime, None] = Field(default=...)
    published_at: Union[datetime, None] = Field(default=...)
    assets: List[ReleaseAsset] = Field(default=...)
    tarball_url: Union[str, None] = Field(default=...)
    zipball_url: Union[str, None] = Field(default=...)
    body: str = Field(default=...)
    mentions_count: Union[Unset, int] = Field(default=UNSET)
    reactions: Union[Unset, Reactions] = Field(title="Reactions", default=UNSET)
    discussion_url: Union[Unset, str] = Field(default=UNSET)


class ReleaseAsset(GitHubWebhookModel):
    """Release Asset

    Data related to a release.
    """

    url: str = Field(default=...)
    browser_download_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The file name of the asset.", default=...)
    label: Union[str, None] = Field(default=...)
    state: Literal["uploaded"] = Field(
        description="State of the release asset.", default=...
    )
    content_type: str = Field(default=...)
    size: int = Field(default=...)
    download_count: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    uploader: Union[Unset, User] = Field(title="User", default=UNSET)


class ReleaseDeleted(GitHubWebhookModel):
    """release deleted event"""

    action: Literal["deleted"] = Field(default=...)
    release: Release = Field(
        title="Release",
        description="The [release](https://docs.github.com/en/rest/reference/repos/#get-a-release) object.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class ReleaseEdited(GitHubWebhookModel):
    """release edited event"""

    action: Literal["edited"] = Field(default=...)
    changes: ReleaseEditedPropChanges = Field(default=...)
    release: Release = Field(
        title="Release",
        description="The [release](https://docs.github.com/en/rest/reference/repos/#get-a-release) object.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class ReleaseEditedPropChanges(GitHubWebhookModel):
    """ReleaseEditedPropChanges"""

    body: Union[Unset, ReleaseEditedPropChangesPropBody] = Field(default=UNSET)
    name: Union[Unset, ReleaseEditedPropChangesPropName] = Field(default=UNSET)


class ReleaseEditedPropChangesPropBody(GitHubWebhookModel):
    """ReleaseEditedPropChangesPropBody"""

    from_: str = Field(
        description="The previous version of the body if the action was `edited`.",
        default=...,
        alias="from",
    )


class ReleaseEditedPropChangesPropName(GitHubWebhookModel):
    """ReleaseEditedPropChangesPropName"""

    from_: str = Field(
        description="The previous version of the name if the action was `edited`.",
        default=...,
        alias="from",
    )


class ReleasePrereleased(GitHubWebhookModel):
    """release prereleased event"""

    action: Literal["prereleased"] = Field(default=...)
    release: ReleasePrereleasedPropRelease = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class ReleasePrereleasedPropRelease(GitHubWebhookModel):
    """ReleasePrereleasedPropRelease"""

    url: str = Field(default=...)
    assets_url: str = Field(default=...)
    upload_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    tag_name: str = Field(description="The name of the tag.", default=...)
    target_commitish: str = Field(
        description="Specifies the commitish value that determines where the Git tag is created from.",
        default=...,
    )
    name: str = Field(default=...)
    draft: bool = Field(
        description="Wether the release is a draft or published", default=...
    )
    author: User = Field(title="User", default=...)
    prerelease: Literal[True] = Field(
        description="Whether the release is identified as a prerelease or a full release.",
        default=...,
    )
    created_at: Union[datetime, None] = Field(default=...)
    published_at: Union[datetime, None] = Field(default=...)
    assets: List[ReleaseAsset] = Field(default=...)
    tarball_url: Union[str, None] = Field(default=...)
    zipball_url: Union[str, None] = Field(default=...)
    body: str = Field(default=...)
    mentions_count: Union[Unset, int] = Field(default=UNSET)
    reactions: Union[Unset, Reactions] = Field(title="Reactions", default=UNSET)
    discussion_url: Union[Unset, str] = Field(default=UNSET)


class ReleasePrereleasedPropReleaseAllof1(GitHubWebhookModel):
    """ReleasePrereleasedPropReleaseAllof1"""

    prerelease: Literal[True] = Field(
        description="Whether the release is identified as a prerelease or a full release.",
        default=...,
    )


class ReleasePublished(GitHubWebhookModel):
    """release published event"""

    action: Literal["published"] = Field(default=...)
    release: ReleasePublishedPropRelease = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class ReleasePublishedPropRelease(GitHubWebhookModel):
    """ReleasePublishedPropRelease"""

    url: str = Field(default=...)
    assets_url: str = Field(default=...)
    upload_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    tag_name: str = Field(description="The name of the tag.", default=...)
    target_commitish: str = Field(
        description="Specifies the commitish value that determines where the Git tag is created from.",
        default=...,
    )
    name: str = Field(default=...)
    draft: bool = Field(
        description="Wether the release is a draft or published", default=...
    )
    author: User = Field(title="User", default=...)
    prerelease: bool = Field(
        description="Whether the release is identified as a prerelease or a full release.",
        default=...,
    )
    created_at: Union[datetime, None] = Field(default=...)
    published_at: datetime = Field(default=...)
    assets: List[ReleaseAsset] = Field(default=...)
    tarball_url: Union[str, None] = Field(default=...)
    zipball_url: Union[str, None] = Field(default=...)
    body: str = Field(default=...)
    mentions_count: Union[Unset, int] = Field(default=UNSET)
    reactions: Union[Unset, Reactions] = Field(title="Reactions", default=UNSET)
    discussion_url: Union[Unset, str] = Field(default=UNSET)


class ReleasePublishedPropReleaseAllof1(GitHubWebhookModel):
    """ReleasePublishedPropReleaseAllof1"""

    published_at: datetime = Field(default=...)


class ReleaseReleased(GitHubWebhookModel):
    """release released event"""

    action: Literal["released"] = Field(default=...)
    release: Release = Field(
        title="Release",
        description="The [release](https://docs.github.com/en/rest/reference/repos/#get-a-release) object.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class ReleaseUnpublished(GitHubWebhookModel):
    """release unpublished event"""

    action: Literal["unpublished"] = Field(default=...)
    release: ReleaseUnpublishedPropRelease = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class ReleaseUnpublishedPropRelease(GitHubWebhookModel):
    """ReleaseUnpublishedPropRelease"""

    url: str = Field(default=...)
    assets_url: str = Field(default=...)
    upload_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    tag_name: str = Field(description="The name of the tag.", default=...)
    target_commitish: str = Field(
        description="Specifies the commitish value that determines where the Git tag is created from.",
        default=...,
    )
    name: str = Field(default=...)
    draft: bool = Field(
        description="Wether the release is a draft or published", default=...
    )
    author: User = Field(title="User", default=...)
    prerelease: bool = Field(
        description="Whether the release is identified as a prerelease or a full release.",
        default=...,
    )
    created_at: Union[datetime, None] = Field(default=...)
    published_at: Union[None, None] = Field(default=...)
    assets: List[ReleaseAsset] = Field(default=...)
    tarball_url: Union[str, None] = Field(default=...)
    zipball_url: Union[str, None] = Field(default=...)
    body: str = Field(default=...)
    mentions_count: Union[Unset, int] = Field(default=UNSET)
    reactions: Union[Unset, Reactions] = Field(title="Reactions", default=UNSET)
    discussion_url: Union[Unset, str] = Field(default=UNSET)


class ReleaseUnpublishedPropReleaseAllof1(GitHubWebhookModel):
    """ReleaseUnpublishedPropReleaseAllof1"""

    published_at: None = Field(default=...)


class RepositoryArchived(GitHubWebhookModel):
    """repository archived event"""

    action: Literal["archived"] = Field(default=...)
    repository: RepositoryArchivedPropRepository = Field(default=...)
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class RepositoryArchivedPropRepository(GitHubWebhookModel):
    """RepositoryArchivedPropRepository"""

    id: int = Field(description="Unique identifier of the repository", default=...)
    node_id: str = Field(
        description="The GraphQL identifier of the repository.", default=...
    )
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(
        description="The full, globally unique, name of the repository.", default=...
    )
    private: bool = Field(
        description="Whether the repository is private or public.", default=...
    )
    owner: User = Field(title="User", default=...)
    html_url: str = Field(
        description="The URL to view the repository on GitHub.com.", default=...
    )
    description: Union[str, None] = Field(
        description="The repository description.", default=...
    )
    fork: bool = Field(description="Whether the repository is a fork.", default=...)
    url: str = Field(
        description="The URL to get more information about the repository from the GitHub API.",
        default=...,
    )
    forks_url: str = Field(
        description="The API URL to list the forks of the repository.", default=...
    )
    keys_url: str = Field(
        description="A template for the API URL to get information about deploy keys on the repository.",
        default=...,
    )
    collaborators_url: str = Field(
        description="A template for the API URL to get information about collaborators of the repository.",
        default=...,
    )
    teams_url: str = Field(
        description="The API URL to list the teams on the repository.", default=...
    )
    hooks_url: str = Field(
        description="The API URL to list the hooks on the repository.", default=...
    )
    issue_events_url: str = Field(
        description="A template for the API URL to get information about issue events on the repository.",
        default=...,
    )
    events_url: str = Field(
        description="The API URL to list the events of the repository.", default=...
    )
    assignees_url: str = Field(
        description="A template for the API URL to list the available assignees for issues in the repository.",
        default=...,
    )
    branches_url: str = Field(
        description="A template for the API URL to get information about branches in the repository.",
        default=...,
    )
    tags_url: str = Field(
        description="The API URL to get information about tags on the repository.",
        default=...,
    )
    blobs_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git blob in the repository.",
        default=...,
    )
    git_tags_url: str = Field(
        description="A template for the API URL to get information about Git tags of the repository.",
        default=...,
    )
    git_refs_url: str = Field(
        description="A template for the API URL to get information about Git refs of the repository.",
        default=...,
    )
    trees_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git tree of the repository.",
        default=...,
    )
    statuses_url: str = Field(
        description="A template for the API URL to get information about statuses of a commit.",
        default=...,
    )
    languages_url: str = Field(
        description="The API URL to get information about the languages of the repository.",
        default=...,
    )
    stargazers_url: str = Field(
        description="The API URL to list the stargazers on the repository.", default=...
    )
    contributors_url: str = Field(
        description="A template for the API URL to list the contributors to the repository.",
        default=...,
    )
    subscribers_url: str = Field(
        description="The API URL to list the subscribers on the repository.",
        default=...,
    )
    subscription_url: str = Field(
        description="The API URL to subscribe to notifications for this repository.",
        default=...,
    )
    commits_url: str = Field(
        description="A template for the API URL to get information about commits on the repository.",
        default=...,
    )
    git_commits_url: str = Field(
        description="A template for the API URL to get information about Git commits of the repository.",
        default=...,
    )
    comments_url: str = Field(
        description="A template for the API URL to get information about comments on the repository.",
        default=...,
    )
    issue_comment_url: str = Field(
        description="A template for the API URL to get information about issue comments on the repository.",
        default=...,
    )
    contents_url: str = Field(
        description="A template for the API URL to get the contents of the repository.",
        default=...,
    )
    compare_url: str = Field(
        description="A template for the API URL to compare two commits or refs.",
        default=...,
    )
    merges_url: str = Field(
        description="The API URL to merge branches in the repository.", default=...
    )
    archive_url: str = Field(
        description="A template for the API URL to download the repository as an archive.",
        default=...,
    )
    downloads_url: str = Field(
        description="The API URL to list the downloads on the repository.", default=...
    )
    issues_url: str = Field(
        description="A template for the API URL to get information about issues on the repository.",
        default=...,
    )
    pulls_url: str = Field(
        description="A template for the API URL to get information about pull requests on the repository.",
        default=...,
    )
    milestones_url: str = Field(
        description="A template for the API URL to get information about milestones of the repository.",
        default=...,
    )
    notifications_url: str = Field(
        description="A template for the API URL to get information about notifications on the repository.",
        default=...,
    )
    labels_url: str = Field(
        description="A template for the API URL to get information about labels of the repository.",
        default=...,
    )
    releases_url: str = Field(
        description="A template for the API URL to get information about releases on the repository.",
        default=...,
    )
    deployments_url: str = Field(
        description="The API URL to list the deployments of the repository.",
        default=...,
    )
    created_at: Union[int, datetime] = Field(default=...)
    updated_at: datetime = Field(default=...)
    pushed_at: Union[int, datetime, None] = Field(default=...)
    git_url: str = Field(default=...)
    ssh_url: str = Field(default=...)
    clone_url: str = Field(default=...)
    svn_url: str = Field(default=...)
    homepage: Union[str, None] = Field(default=...)
    size: int = Field(default=...)
    stargazers_count: int = Field(default=...)
    watchers_count: int = Field(default=...)
    language: Union[str, None] = Field(default=...)
    has_issues: bool = Field(description="Whether issues are enabled.", default=True)
    has_projects: bool = Field(
        description="Whether projects are enabled.", default=True
    )
    has_downloads: bool = Field(
        description="Whether downloads are enabled.", default=True
    )
    has_wiki: bool = Field(description="Whether the wiki is enabled.", default=True)
    has_pages: bool = Field(default=...)
    forks_count: int = Field(default=...)
    mirror_url: Union[str, None] = Field(default=...)
    archived: Literal[True] = Field(
        description="Whether the repository is archived.", default=False
    )
    disabled: Union[Unset, bool] = Field(
        description="Returns whether or not this repository is disabled.", default=UNSET
    )
    open_issues_count: int = Field(default=...)
    license_: Union[License, None] = Field(
        title="License", default=..., alias="license"
    )
    forks: int = Field(default=...)
    open_issues: int = Field(default=...)
    watchers: int = Field(default=...)
    stargazers: Union[Unset, int] = Field(default=UNSET)
    default_branch: str = Field(
        description="The default branch of the repository.", default=...
    )
    allow_squash_merge: Union[Unset, bool] = Field(
        description="Whether to allow squash merges for pull requests.", default=True
    )
    allow_merge_commit: Union[Unset, bool] = Field(
        description="Whether to allow merge commits for pull requests.", default=True
    )
    allow_rebase_merge: Union[Unset, bool] = Field(
        description="Whether to allow rebase merges for pull requests.", default=True
    )
    allow_auto_merge: Union[Unset, bool] = Field(
        description="Whether to allow auto-merge for pull requests.", default=False
    )
    allow_forking: Union[Unset, bool] = Field(
        description="Whether to allow private forks", default=UNSET
    )
    allow_update_branch: Union[Unset, bool] = Field(default=UNSET)
    use_squash_pr_title_as_default: Union[Unset, bool] = Field(default=UNSET)
    squash_merge_commit_message: Union[Unset, str] = Field(default=UNSET)
    squash_merge_commit_title: Union[Unset, str] = Field(default=UNSET)
    merge_commit_message: Union[Unset, str] = Field(default=UNSET)
    merge_commit_title: Union[Unset, str] = Field(default=UNSET)
    is_template: bool = Field(default=...)
    web_commit_signoff_required: bool = Field(default=...)
    topics: List[str] = Field(default=...)
    visibility: Literal["public", "private", "internal"] = Field(default=...)
    delete_branch_on_merge: Union[Unset, bool] = Field(
        description="Whether to delete head branches when pull requests are merged",
        default=False,
    )
    master_branch: Union[Unset, str] = Field(default=UNSET)
    permissions: Union[Unset, RepositoryPropPermissions] = Field(default=UNSET)
    public: Union[Unset, bool] = Field(default=UNSET)
    organization: Union[Unset, str] = Field(default=UNSET)


class RepositoryArchivedPropRepositoryAllof1(GitHubWebhookModel):
    """RepositoryArchivedPropRepositoryAllof1"""

    archived: Literal[True] = Field(
        description="Whether the repository is archived.", default=False
    )


class RepositoryCreated(GitHubWebhookModel):
    """repository created event"""

    action: Literal["created"] = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class RepositoryDeleted(GitHubWebhookModel):
    """repository deleted event"""

    action: Literal["deleted"] = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class RepositoryEdited(GitHubWebhookModel):
    """repository edited event"""

    action: Literal["edited"] = Field(default=...)
    changes: RepositoryEditedPropChanges = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class RepositoryEditedPropChanges(GitHubWebhookModel):
    """RepositoryEditedPropChanges"""

    description: Union[Unset, RepositoryEditedPropChangesPropDescription] = Field(
        default=UNSET
    )
    default_branch: Union[Unset, RepositoryEditedPropChangesPropDefaultBranch] = Field(
        default=UNSET
    )
    homepage: Union[Unset, RepositoryEditedPropChangesPropHomepage] = Field(
        default=UNSET
    )


class RepositoryEditedPropChangesPropDescription(GitHubWebhookModel):
    """RepositoryEditedPropChangesPropDescription"""

    from_: Union[str, None] = Field(default=..., alias="from")


class RepositoryEditedPropChangesPropDefaultBranch(GitHubWebhookModel):
    """RepositoryEditedPropChangesPropDefaultBranch"""

    from_: str = Field(default=..., alias="from")


class RepositoryEditedPropChangesPropHomepage(GitHubWebhookModel):
    """RepositoryEditedPropChangesPropHomepage"""

    from_: Union[str, None] = Field(default=..., alias="from")


class RepositoryPrivatized(GitHubWebhookModel):
    """repository privatized event"""

    action: Literal["privatized"] = Field(default=...)
    repository: RepositoryPrivatizedPropRepository = Field(default=...)
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class RepositoryPrivatizedPropRepository(GitHubWebhookModel):
    """RepositoryPrivatizedPropRepository"""

    id: int = Field(description="Unique identifier of the repository", default=...)
    node_id: str = Field(
        description="The GraphQL identifier of the repository.", default=...
    )
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(
        description="The full, globally unique, name of the repository.", default=...
    )
    private: Literal[True] = Field(
        description="Whether the repository is private or public.", default=...
    )
    owner: User = Field(title="User", default=...)
    html_url: str = Field(
        description="The URL to view the repository on GitHub.com.", default=...
    )
    description: Union[str, None] = Field(
        description="The repository description.", default=...
    )
    fork: bool = Field(description="Whether the repository is a fork.", default=...)
    url: str = Field(
        description="The URL to get more information about the repository from the GitHub API.",
        default=...,
    )
    forks_url: str = Field(
        description="The API URL to list the forks of the repository.", default=...
    )
    keys_url: str = Field(
        description="A template for the API URL to get information about deploy keys on the repository.",
        default=...,
    )
    collaborators_url: str = Field(
        description="A template for the API URL to get information about collaborators of the repository.",
        default=...,
    )
    teams_url: str = Field(
        description="The API URL to list the teams on the repository.", default=...
    )
    hooks_url: str = Field(
        description="The API URL to list the hooks on the repository.", default=...
    )
    issue_events_url: str = Field(
        description="A template for the API URL to get information about issue events on the repository.",
        default=...,
    )
    events_url: str = Field(
        description="The API URL to list the events of the repository.", default=...
    )
    assignees_url: str = Field(
        description="A template for the API URL to list the available assignees for issues in the repository.",
        default=...,
    )
    branches_url: str = Field(
        description="A template for the API URL to get information about branches in the repository.",
        default=...,
    )
    tags_url: str = Field(
        description="The API URL to get information about tags on the repository.",
        default=...,
    )
    blobs_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git blob in the repository.",
        default=...,
    )
    git_tags_url: str = Field(
        description="A template for the API URL to get information about Git tags of the repository.",
        default=...,
    )
    git_refs_url: str = Field(
        description="A template for the API URL to get information about Git refs of the repository.",
        default=...,
    )
    trees_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git tree of the repository.",
        default=...,
    )
    statuses_url: str = Field(
        description="A template for the API URL to get information about statuses of a commit.",
        default=...,
    )
    languages_url: str = Field(
        description="The API URL to get information about the languages of the repository.",
        default=...,
    )
    stargazers_url: str = Field(
        description="The API URL to list the stargazers on the repository.", default=...
    )
    contributors_url: str = Field(
        description="A template for the API URL to list the contributors to the repository.",
        default=...,
    )
    subscribers_url: str = Field(
        description="The API URL to list the subscribers on the repository.",
        default=...,
    )
    subscription_url: str = Field(
        description="The API URL to subscribe to notifications for this repository.",
        default=...,
    )
    commits_url: str = Field(
        description="A template for the API URL to get information about commits on the repository.",
        default=...,
    )
    git_commits_url: str = Field(
        description="A template for the API URL to get information about Git commits of the repository.",
        default=...,
    )
    comments_url: str = Field(
        description="A template for the API URL to get information about comments on the repository.",
        default=...,
    )
    issue_comment_url: str = Field(
        description="A template for the API URL to get information about issue comments on the repository.",
        default=...,
    )
    contents_url: str = Field(
        description="A template for the API URL to get the contents of the repository.",
        default=...,
    )
    compare_url: str = Field(
        description="A template for the API URL to compare two commits or refs.",
        default=...,
    )
    merges_url: str = Field(
        description="The API URL to merge branches in the repository.", default=...
    )
    archive_url: str = Field(
        description="A template for the API URL to download the repository as an archive.",
        default=...,
    )
    downloads_url: str = Field(
        description="The API URL to list the downloads on the repository.", default=...
    )
    issues_url: str = Field(
        description="A template for the API URL to get information about issues on the repository.",
        default=...,
    )
    pulls_url: str = Field(
        description="A template for the API URL to get information about pull requests on the repository.",
        default=...,
    )
    milestones_url: str = Field(
        description="A template for the API URL to get information about milestones of the repository.",
        default=...,
    )
    notifications_url: str = Field(
        description="A template for the API URL to get information about notifications on the repository.",
        default=...,
    )
    labels_url: str = Field(
        description="A template for the API URL to get information about labels of the repository.",
        default=...,
    )
    releases_url: str = Field(
        description="A template for the API URL to get information about releases on the repository.",
        default=...,
    )
    deployments_url: str = Field(
        description="The API URL to list the deployments of the repository.",
        default=...,
    )
    created_at: Union[int, datetime] = Field(default=...)
    updated_at: datetime = Field(default=...)
    pushed_at: Union[int, datetime, None] = Field(default=...)
    git_url: str = Field(default=...)
    ssh_url: str = Field(default=...)
    clone_url: str = Field(default=...)
    svn_url: str = Field(default=...)
    homepage: Union[str, None] = Field(default=...)
    size: int = Field(default=...)
    stargazers_count: int = Field(default=...)
    watchers_count: int = Field(default=...)
    language: Union[str, None] = Field(default=...)
    has_issues: bool = Field(description="Whether issues are enabled.", default=True)
    has_projects: bool = Field(
        description="Whether projects are enabled.", default=True
    )
    has_downloads: bool = Field(
        description="Whether downloads are enabled.", default=True
    )
    has_wiki: bool = Field(description="Whether the wiki is enabled.", default=True)
    has_pages: bool = Field(default=...)
    forks_count: int = Field(default=...)
    mirror_url: Union[str, None] = Field(default=...)
    archived: bool = Field(
        description="Whether the repository is archived.", default=False
    )
    disabled: Union[Unset, bool] = Field(
        description="Returns whether or not this repository is disabled.", default=UNSET
    )
    open_issues_count: int = Field(default=...)
    license_: Union[License, None] = Field(
        title="License", default=..., alias="license"
    )
    forks: int = Field(default=...)
    open_issues: int = Field(default=...)
    watchers: int = Field(default=...)
    stargazers: Union[Unset, int] = Field(default=UNSET)
    default_branch: str = Field(
        description="The default branch of the repository.", default=...
    )
    allow_squash_merge: Union[Unset, bool] = Field(
        description="Whether to allow squash merges for pull requests.", default=True
    )
    allow_merge_commit: Union[Unset, bool] = Field(
        description="Whether to allow merge commits for pull requests.", default=True
    )
    allow_rebase_merge: Union[Unset, bool] = Field(
        description="Whether to allow rebase merges for pull requests.", default=True
    )
    allow_auto_merge: Union[Unset, bool] = Field(
        description="Whether to allow auto-merge for pull requests.", default=False
    )
    allow_forking: Union[Unset, bool] = Field(
        description="Whether to allow private forks", default=UNSET
    )
    allow_update_branch: Union[Unset, bool] = Field(default=UNSET)
    use_squash_pr_title_as_default: Union[Unset, bool] = Field(default=UNSET)
    squash_merge_commit_message: Union[Unset, str] = Field(default=UNSET)
    squash_merge_commit_title: Union[Unset, str] = Field(default=UNSET)
    merge_commit_message: Union[Unset, str] = Field(default=UNSET)
    merge_commit_title: Union[Unset, str] = Field(default=UNSET)
    is_template: bool = Field(default=...)
    web_commit_signoff_required: bool = Field(default=...)
    topics: List[str] = Field(default=...)
    visibility: Literal["public", "private", "internal"] = Field(default=...)
    delete_branch_on_merge: Union[Unset, bool] = Field(
        description="Whether to delete head branches when pull requests are merged",
        default=False,
    )
    master_branch: Union[Unset, str] = Field(default=UNSET)
    permissions: Union[Unset, RepositoryPropPermissions] = Field(default=UNSET)
    public: Union[Unset, bool] = Field(default=UNSET)
    organization: Union[Unset, str] = Field(default=UNSET)


class RepositoryPrivatizedPropRepositoryAllof1(GitHubWebhookModel):
    """RepositoryPrivatizedPropRepositoryAllof1"""

    private: Literal[True] = Field(
        description="Whether the repository is private or public.", default=...
    )


class RepositoryPublicized(GitHubWebhookModel):
    """repository publicized event"""

    action: Literal["publicized"] = Field(default=...)
    repository: RepositoryPublicizedPropRepository = Field(default=...)
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class RepositoryPublicizedPropRepository(GitHubWebhookModel):
    """RepositoryPublicizedPropRepository"""

    id: int = Field(description="Unique identifier of the repository", default=...)
    node_id: str = Field(
        description="The GraphQL identifier of the repository.", default=...
    )
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(
        description="The full, globally unique, name of the repository.", default=...
    )
    private: Literal[False] = Field(
        description="Whether the repository is private or public.", default=...
    )
    owner: User = Field(title="User", default=...)
    html_url: str = Field(
        description="The URL to view the repository on GitHub.com.", default=...
    )
    description: Union[str, None] = Field(
        description="The repository description.", default=...
    )
    fork: bool = Field(description="Whether the repository is a fork.", default=...)
    url: str = Field(
        description="The URL to get more information about the repository from the GitHub API.",
        default=...,
    )
    forks_url: str = Field(
        description="The API URL to list the forks of the repository.", default=...
    )
    keys_url: str = Field(
        description="A template for the API URL to get information about deploy keys on the repository.",
        default=...,
    )
    collaborators_url: str = Field(
        description="A template for the API URL to get information about collaborators of the repository.",
        default=...,
    )
    teams_url: str = Field(
        description="The API URL to list the teams on the repository.", default=...
    )
    hooks_url: str = Field(
        description="The API URL to list the hooks on the repository.", default=...
    )
    issue_events_url: str = Field(
        description="A template for the API URL to get information about issue events on the repository.",
        default=...,
    )
    events_url: str = Field(
        description="The API URL to list the events of the repository.", default=...
    )
    assignees_url: str = Field(
        description="A template for the API URL to list the available assignees for issues in the repository.",
        default=...,
    )
    branches_url: str = Field(
        description="A template for the API URL to get information about branches in the repository.",
        default=...,
    )
    tags_url: str = Field(
        description="The API URL to get information about tags on the repository.",
        default=...,
    )
    blobs_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git blob in the repository.",
        default=...,
    )
    git_tags_url: str = Field(
        description="A template for the API URL to get information about Git tags of the repository.",
        default=...,
    )
    git_refs_url: str = Field(
        description="A template for the API URL to get information about Git refs of the repository.",
        default=...,
    )
    trees_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git tree of the repository.",
        default=...,
    )
    statuses_url: str = Field(
        description="A template for the API URL to get information about statuses of a commit.",
        default=...,
    )
    languages_url: str = Field(
        description="The API URL to get information about the languages of the repository.",
        default=...,
    )
    stargazers_url: str = Field(
        description="The API URL to list the stargazers on the repository.", default=...
    )
    contributors_url: str = Field(
        description="A template for the API URL to list the contributors to the repository.",
        default=...,
    )
    subscribers_url: str = Field(
        description="The API URL to list the subscribers on the repository.",
        default=...,
    )
    subscription_url: str = Field(
        description="The API URL to subscribe to notifications for this repository.",
        default=...,
    )
    commits_url: str = Field(
        description="A template for the API URL to get information about commits on the repository.",
        default=...,
    )
    git_commits_url: str = Field(
        description="A template for the API URL to get information about Git commits of the repository.",
        default=...,
    )
    comments_url: str = Field(
        description="A template for the API URL to get information about comments on the repository.",
        default=...,
    )
    issue_comment_url: str = Field(
        description="A template for the API URL to get information about issue comments on the repository.",
        default=...,
    )
    contents_url: str = Field(
        description="A template for the API URL to get the contents of the repository.",
        default=...,
    )
    compare_url: str = Field(
        description="A template for the API URL to compare two commits or refs.",
        default=...,
    )
    merges_url: str = Field(
        description="The API URL to merge branches in the repository.", default=...
    )
    archive_url: str = Field(
        description="A template for the API URL to download the repository as an archive.",
        default=...,
    )
    downloads_url: str = Field(
        description="The API URL to list the downloads on the repository.", default=...
    )
    issues_url: str = Field(
        description="A template for the API URL to get information about issues on the repository.",
        default=...,
    )
    pulls_url: str = Field(
        description="A template for the API URL to get information about pull requests on the repository.",
        default=...,
    )
    milestones_url: str = Field(
        description="A template for the API URL to get information about milestones of the repository.",
        default=...,
    )
    notifications_url: str = Field(
        description="A template for the API URL to get information about notifications on the repository.",
        default=...,
    )
    labels_url: str = Field(
        description="A template for the API URL to get information about labels of the repository.",
        default=...,
    )
    releases_url: str = Field(
        description="A template for the API URL to get information about releases on the repository.",
        default=...,
    )
    deployments_url: str = Field(
        description="The API URL to list the deployments of the repository.",
        default=...,
    )
    created_at: Union[int, datetime] = Field(default=...)
    updated_at: datetime = Field(default=...)
    pushed_at: Union[int, datetime, None] = Field(default=...)
    git_url: str = Field(default=...)
    ssh_url: str = Field(default=...)
    clone_url: str = Field(default=...)
    svn_url: str = Field(default=...)
    homepage: Union[str, None] = Field(default=...)
    size: int = Field(default=...)
    stargazers_count: int = Field(default=...)
    watchers_count: int = Field(default=...)
    language: Union[str, None] = Field(default=...)
    has_issues: bool = Field(description="Whether issues are enabled.", default=True)
    has_projects: bool = Field(
        description="Whether projects are enabled.", default=True
    )
    has_downloads: bool = Field(
        description="Whether downloads are enabled.", default=True
    )
    has_wiki: bool = Field(description="Whether the wiki is enabled.", default=True)
    has_pages: bool = Field(default=...)
    forks_count: int = Field(default=...)
    mirror_url: Union[str, None] = Field(default=...)
    archived: bool = Field(
        description="Whether the repository is archived.", default=False
    )
    disabled: Union[Unset, bool] = Field(
        description="Returns whether or not this repository is disabled.", default=UNSET
    )
    open_issues_count: int = Field(default=...)
    license_: Union[License, None] = Field(
        title="License", default=..., alias="license"
    )
    forks: int = Field(default=...)
    open_issues: int = Field(default=...)
    watchers: int = Field(default=...)
    stargazers: Union[Unset, int] = Field(default=UNSET)
    default_branch: str = Field(
        description="The default branch of the repository.", default=...
    )
    allow_squash_merge: Union[Unset, bool] = Field(
        description="Whether to allow squash merges for pull requests.", default=True
    )
    allow_merge_commit: Union[Unset, bool] = Field(
        description="Whether to allow merge commits for pull requests.", default=True
    )
    allow_rebase_merge: Union[Unset, bool] = Field(
        description="Whether to allow rebase merges for pull requests.", default=True
    )
    allow_auto_merge: Union[Unset, bool] = Field(
        description="Whether to allow auto-merge for pull requests.", default=False
    )
    allow_forking: Union[Unset, bool] = Field(
        description="Whether to allow private forks", default=UNSET
    )
    allow_update_branch: Union[Unset, bool] = Field(default=UNSET)
    use_squash_pr_title_as_default: Union[Unset, bool] = Field(default=UNSET)
    squash_merge_commit_message: Union[Unset, str] = Field(default=UNSET)
    squash_merge_commit_title: Union[Unset, str] = Field(default=UNSET)
    merge_commit_message: Union[Unset, str] = Field(default=UNSET)
    merge_commit_title: Union[Unset, str] = Field(default=UNSET)
    is_template: bool = Field(default=...)
    web_commit_signoff_required: bool = Field(default=...)
    topics: List[str] = Field(default=...)
    visibility: Literal["public", "private", "internal"] = Field(default=...)
    delete_branch_on_merge: Union[Unset, bool] = Field(
        description="Whether to delete head branches when pull requests are merged",
        default=False,
    )
    master_branch: Union[Unset, str] = Field(default=UNSET)
    permissions: Union[Unset, RepositoryPropPermissions] = Field(default=UNSET)
    public: Union[Unset, bool] = Field(default=UNSET)
    organization: Union[Unset, str] = Field(default=UNSET)


class RepositoryPublicizedPropRepositoryAllof1(GitHubWebhookModel):
    """RepositoryPublicizedPropRepositoryAllof1"""

    private: Literal[False] = Field(
        description="Whether the repository is private or public.", default=...
    )


class RepositoryRenamed(GitHubWebhookModel):
    """repository renamed event"""

    action: Literal["renamed"] = Field(default=...)
    changes: RepositoryRenamedPropChanges = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class RepositoryRenamedPropChanges(GitHubWebhookModel):
    """RepositoryRenamedPropChanges"""

    repository: RepositoryRenamedPropChangesPropRepository = Field(default=...)


class RepositoryRenamedPropChangesPropRepository(GitHubWebhookModel):
    """RepositoryRenamedPropChangesPropRepository"""

    name: RepositoryRenamedPropChangesPropRepositoryPropName = Field(default=...)


class RepositoryRenamedPropChangesPropRepositoryPropName(GitHubWebhookModel):
    """RepositoryRenamedPropChangesPropRepositoryPropName"""

    from_: str = Field(default=..., alias="from")


class RepositoryTransferred(GitHubWebhookModel):
    """repository transferred event"""

    action: Literal["transferred"] = Field(default=...)
    changes: RepositoryTransferredPropChanges = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class RepositoryTransferredPropChanges(GitHubWebhookModel):
    """RepositoryTransferredPropChanges"""

    owner: RepositoryTransferredPropChangesPropOwner = Field(default=...)


class RepositoryTransferredPropChangesPropOwner(GitHubWebhookModel):
    """RepositoryTransferredPropChangesPropOwner"""

    from_: RepositoryTransferredPropChangesPropOwnerPropFrom = Field(
        default=..., alias="from"
    )


class RepositoryTransferredPropChangesPropOwnerPropFrom(GitHubWebhookModel):
    """RepositoryTransferredPropChangesPropOwnerPropFrom"""

    user: Union[Unset, User] = Field(title="User", default=UNSET)


class RepositoryUnarchived(GitHubWebhookModel):
    """repository unarchived event"""

    action: Literal["unarchived"] = Field(default=...)
    repository: RepositoryUnarchivedPropRepository = Field(default=...)
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class RepositoryUnarchivedPropRepository(GitHubWebhookModel):
    """RepositoryUnarchivedPropRepository"""

    id: int = Field(description="Unique identifier of the repository", default=...)
    node_id: str = Field(
        description="The GraphQL identifier of the repository.", default=...
    )
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(
        description="The full, globally unique, name of the repository.", default=...
    )
    private: bool = Field(
        description="Whether the repository is private or public.", default=...
    )
    owner: User = Field(title="User", default=...)
    html_url: str = Field(
        description="The URL to view the repository on GitHub.com.", default=...
    )
    description: Union[str, None] = Field(
        description="The repository description.", default=...
    )
    fork: bool = Field(description="Whether the repository is a fork.", default=...)
    url: str = Field(
        description="The URL to get more information about the repository from the GitHub API.",
        default=...,
    )
    forks_url: str = Field(
        description="The API URL to list the forks of the repository.", default=...
    )
    keys_url: str = Field(
        description="A template for the API URL to get information about deploy keys on the repository.",
        default=...,
    )
    collaborators_url: str = Field(
        description="A template for the API URL to get information about collaborators of the repository.",
        default=...,
    )
    teams_url: str = Field(
        description="The API URL to list the teams on the repository.", default=...
    )
    hooks_url: str = Field(
        description="The API URL to list the hooks on the repository.", default=...
    )
    issue_events_url: str = Field(
        description="A template for the API URL to get information about issue events on the repository.",
        default=...,
    )
    events_url: str = Field(
        description="The API URL to list the events of the repository.", default=...
    )
    assignees_url: str = Field(
        description="A template for the API URL to list the available assignees for issues in the repository.",
        default=...,
    )
    branches_url: str = Field(
        description="A template for the API URL to get information about branches in the repository.",
        default=...,
    )
    tags_url: str = Field(
        description="The API URL to get information about tags on the repository.",
        default=...,
    )
    blobs_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git blob in the repository.",
        default=...,
    )
    git_tags_url: str = Field(
        description="A template for the API URL to get information about Git tags of the repository.",
        default=...,
    )
    git_refs_url: str = Field(
        description="A template for the API URL to get information about Git refs of the repository.",
        default=...,
    )
    trees_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git tree of the repository.",
        default=...,
    )
    statuses_url: str = Field(
        description="A template for the API URL to get information about statuses of a commit.",
        default=...,
    )
    languages_url: str = Field(
        description="The API URL to get information about the languages of the repository.",
        default=...,
    )
    stargazers_url: str = Field(
        description="The API URL to list the stargazers on the repository.", default=...
    )
    contributors_url: str = Field(
        description="A template for the API URL to list the contributors to the repository.",
        default=...,
    )
    subscribers_url: str = Field(
        description="The API URL to list the subscribers on the repository.",
        default=...,
    )
    subscription_url: str = Field(
        description="The API URL to subscribe to notifications for this repository.",
        default=...,
    )
    commits_url: str = Field(
        description="A template for the API URL to get information about commits on the repository.",
        default=...,
    )
    git_commits_url: str = Field(
        description="A template for the API URL to get information about Git commits of the repository.",
        default=...,
    )
    comments_url: str = Field(
        description="A template for the API URL to get information about comments on the repository.",
        default=...,
    )
    issue_comment_url: str = Field(
        description="A template for the API URL to get information about issue comments on the repository.",
        default=...,
    )
    contents_url: str = Field(
        description="A template for the API URL to get the contents of the repository.",
        default=...,
    )
    compare_url: str = Field(
        description="A template for the API URL to compare two commits or refs.",
        default=...,
    )
    merges_url: str = Field(
        description="The API URL to merge branches in the repository.", default=...
    )
    archive_url: str = Field(
        description="A template for the API URL to download the repository as an archive.",
        default=...,
    )
    downloads_url: str = Field(
        description="The API URL to list the downloads on the repository.", default=...
    )
    issues_url: str = Field(
        description="A template for the API URL to get information about issues on the repository.",
        default=...,
    )
    pulls_url: str = Field(
        description="A template for the API URL to get information about pull requests on the repository.",
        default=...,
    )
    milestones_url: str = Field(
        description="A template for the API URL to get information about milestones of the repository.",
        default=...,
    )
    notifications_url: str = Field(
        description="A template for the API URL to get information about notifications on the repository.",
        default=...,
    )
    labels_url: str = Field(
        description="A template for the API URL to get information about labels of the repository.",
        default=...,
    )
    releases_url: str = Field(
        description="A template for the API URL to get information about releases on the repository.",
        default=...,
    )
    deployments_url: str = Field(
        description="The API URL to list the deployments of the repository.",
        default=...,
    )
    created_at: Union[int, datetime] = Field(default=...)
    updated_at: datetime = Field(default=...)
    pushed_at: Union[int, datetime, None] = Field(default=...)
    git_url: str = Field(default=...)
    ssh_url: str = Field(default=...)
    clone_url: str = Field(default=...)
    svn_url: str = Field(default=...)
    homepage: Union[str, None] = Field(default=...)
    size: int = Field(default=...)
    stargazers_count: int = Field(default=...)
    watchers_count: int = Field(default=...)
    language: Union[str, None] = Field(default=...)
    has_issues: bool = Field(description="Whether issues are enabled.", default=True)
    has_projects: bool = Field(
        description="Whether projects are enabled.", default=True
    )
    has_downloads: bool = Field(
        description="Whether downloads are enabled.", default=True
    )
    has_wiki: bool = Field(description="Whether the wiki is enabled.", default=True)
    has_pages: bool = Field(default=...)
    forks_count: int = Field(default=...)
    mirror_url: Union[str, None] = Field(default=...)
    archived: Literal[False] = Field(
        description="Whether the repository is archived.", default=False
    )
    disabled: Union[Unset, bool] = Field(
        description="Returns whether or not this repository is disabled.", default=UNSET
    )
    open_issues_count: int = Field(default=...)
    license_: Union[License, None] = Field(
        title="License", default=..., alias="license"
    )
    forks: int = Field(default=...)
    open_issues: int = Field(default=...)
    watchers: int = Field(default=...)
    stargazers: Union[Unset, int] = Field(default=UNSET)
    default_branch: str = Field(
        description="The default branch of the repository.", default=...
    )
    allow_squash_merge: Union[Unset, bool] = Field(
        description="Whether to allow squash merges for pull requests.", default=True
    )
    allow_merge_commit: Union[Unset, bool] = Field(
        description="Whether to allow merge commits for pull requests.", default=True
    )
    allow_rebase_merge: Union[Unset, bool] = Field(
        description="Whether to allow rebase merges for pull requests.", default=True
    )
    allow_auto_merge: Union[Unset, bool] = Field(
        description="Whether to allow auto-merge for pull requests.", default=False
    )
    allow_forking: Union[Unset, bool] = Field(
        description="Whether to allow private forks", default=UNSET
    )
    allow_update_branch: Union[Unset, bool] = Field(default=UNSET)
    use_squash_pr_title_as_default: Union[Unset, bool] = Field(default=UNSET)
    squash_merge_commit_message: Union[Unset, str] = Field(default=UNSET)
    squash_merge_commit_title: Union[Unset, str] = Field(default=UNSET)
    merge_commit_message: Union[Unset, str] = Field(default=UNSET)
    merge_commit_title: Union[Unset, str] = Field(default=UNSET)
    is_template: bool = Field(default=...)
    web_commit_signoff_required: bool = Field(default=...)
    topics: List[str] = Field(default=...)
    visibility: Literal["public", "private", "internal"] = Field(default=...)
    delete_branch_on_merge: Union[Unset, bool] = Field(
        description="Whether to delete head branches when pull requests are merged",
        default=False,
    )
    master_branch: Union[Unset, str] = Field(default=UNSET)
    permissions: Union[Unset, RepositoryPropPermissions] = Field(default=UNSET)
    public: Union[Unset, bool] = Field(default=UNSET)
    organization: Union[Unset, str] = Field(default=UNSET)


class RepositoryUnarchivedPropRepositoryAllof1(GitHubWebhookModel):
    """RepositoryUnarchivedPropRepositoryAllof1"""

    archived: Literal[False] = Field(
        description="Whether the repository is archived.", default=False
    )


class RepositoryDispatchEvent(GitHubWebhookModel):
    """repository_dispatch event"""

    action: str = Field(default=...)
    branch: str = Field(default=...)
    client_payload: RepositoryDispatchEventPropClientPayload = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: InstallationLite = Field(
        title="InstallationLite", description="Installation", default=...
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class RepositoryDispatchEventPropClientPayload(GitHubWebhookModel, extra=Extra.allow):
    """RepositoryDispatchEventPropClientPayload"""


class RepositoryImportEvent(GitHubWebhookModel):
    """repository_import event"""

    status: Literal["success", "cancelled", "failure"] = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class RepositoryVulnerabilityAlertCreate(GitHubWebhookModel):
    """repository_vulnerability_alert create event"""

    action: Literal["create"] = Field(default=...)
    alert: RepositoryVulnerabilityAlertCreatePropAlert = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: GithubOrg = Field(title="GitHub Org", default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class RepositoryVulnerabilityAlertCreatePropAlert(GitHubWebhookModel):
    """RepositoryVulnerabilityAlertCreatePropAlert"""

    id: int = Field(default=...)
    number: int = Field(default=...)
    node_id: str = Field(default=...)
    state: Literal["open"] = Field(default=...)
    affected_range: str = Field(default=...)
    affected_package_name: str = Field(default=...)
    dismisser: Union[Unset, User] = Field(title="User", default=UNSET)
    dismiss_reason: Union[Unset, str] = Field(default=UNSET)
    dismissed_at: Union[Unset, datetime] = Field(default=UNSET)
    severity: str = Field(default=...)
    ghsa_id: str = Field(default=...)
    external_reference: str = Field(default=...)
    external_identifier: str = Field(default=...)
    fixed_in: str = Field(default=...)
    fixed_at: Union[Unset, datetime] = Field(default=UNSET)
    fix_reason: Union[Unset, str] = Field(default=UNSET)
    created_at: datetime = Field(default=...)


class RepositoryVulnerabilityAlertAlert(GitHubWebhookModel):
    """Repository Vulnerability Alert Alert

    The security alert of the vulnerable dependency.
    """

    id: int = Field(default=...)
    number: int = Field(default=...)
    node_id: str = Field(default=...)
    state: Literal["open", "dismissed", "fixed"] = Field(default=...)
    affected_range: str = Field(default=...)
    affected_package_name: str = Field(default=...)
    dismisser: Union[Unset, User] = Field(title="User", default=UNSET)
    dismiss_reason: Union[Unset, str] = Field(default=UNSET)
    dismissed_at: Union[Unset, datetime] = Field(default=UNSET)
    severity: str = Field(default=...)
    ghsa_id: str = Field(default=...)
    external_reference: str = Field(default=...)
    external_identifier: str = Field(default=...)
    fixed_in: str = Field(default=...)
    fixed_at: Union[Unset, datetime] = Field(default=UNSET)
    fix_reason: Union[Unset, str] = Field(default=UNSET)
    created_at: datetime = Field(default=...)


class RepositoryVulnerabilityAlertCreatePropAlertAllof1(GitHubWebhookModel):
    """RepositoryVulnerabilityAlertCreatePropAlertAllof1"""

    state: Literal["open"] = Field(default=...)


class RepositoryVulnerabilityAlertDismiss(GitHubWebhookModel):
    """repository_vulnerability_alert dismiss event"""

    action: Literal["dismiss"] = Field(default=...)
    alert: RepositoryVulnerabilityAlertDismissPropAlert = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: GithubOrg = Field(title="GitHub Org", default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class RepositoryVulnerabilityAlertDismissPropAlert(GitHubWebhookModel):
    """RepositoryVulnerabilityAlertDismissPropAlert"""

    id: int = Field(default=...)
    number: int = Field(default=...)
    node_id: str = Field(default=...)
    state: Literal["dismissed"] = Field(default=...)
    affected_range: str = Field(default=...)
    affected_package_name: str = Field(default=...)
    dismisser: User = Field(title="User", default=...)
    dismiss_reason: str = Field(default=...)
    dismissed_at: datetime = Field(default=...)
    severity: str = Field(default=...)
    ghsa_id: str = Field(default=...)
    external_reference: str = Field(default=...)
    external_identifier: str = Field(default=...)
    fixed_in: str = Field(default=...)
    fixed_at: Union[Unset, datetime] = Field(default=UNSET)
    fix_reason: Union[Unset, str] = Field(default=UNSET)
    created_at: datetime = Field(default=...)


class RepositoryVulnerabilityAlertDismissPropAlertAllof1(GitHubWebhookModel):
    """RepositoryVulnerabilityAlertDismissPropAlertAllof1"""

    dismisser: User = Field(title="User", default=...)
    dismiss_reason: str = Field(default=...)
    dismissed_at: str = Field(default=...)
    state: Literal["dismissed"] = Field(default=...)


class RepositoryVulnerabilityAlertReopen(GitHubWebhookModel):
    """repository_vulnerability_alert reopen event"""

    action: Literal["reopen"] = Field(default=...)
    alert: RepositoryVulnerabilityAlertReopenPropAlert = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: GithubOrg = Field(title="GitHub Org", default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class RepositoryVulnerabilityAlertReopenPropAlert(GitHubWebhookModel):
    """RepositoryVulnerabilityAlertReopenPropAlert"""

    id: int = Field(default=...)
    number: int = Field(default=...)
    node_id: str = Field(default=...)
    state: Literal["open"] = Field(default=...)
    affected_range: str = Field(default=...)
    affected_package_name: str = Field(default=...)
    dismisser: Union[Unset, User] = Field(title="User", default=UNSET)
    dismiss_reason: Union[Unset, str] = Field(default=UNSET)
    dismissed_at: Union[Unset, datetime] = Field(default=UNSET)
    severity: str = Field(default=...)
    ghsa_id: str = Field(default=...)
    external_reference: str = Field(default=...)
    external_identifier: str = Field(default=...)
    fixed_in: str = Field(default=...)
    fixed_at: Union[Unset, datetime] = Field(default=UNSET)
    fix_reason: Union[Unset, str] = Field(default=UNSET)
    created_at: datetime = Field(default=...)


class RepositoryVulnerabilityAlertReopenPropAlertAllof1(GitHubWebhookModel):
    """RepositoryVulnerabilityAlertReopenPropAlertAllof1"""

    state: Literal["open"] = Field(default=...)


class RepositoryVulnerabilityAlertResolve(GitHubWebhookModel):
    """repository_vulnerability_alert resolve event"""

    action: Literal["resolve"] = Field(default=...)
    alert: RepositoryVulnerabilityAlertResolvePropAlert = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: GithubOrg = Field(title="GitHub Org", default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class RepositoryVulnerabilityAlertResolvePropAlert(GitHubWebhookModel):
    """RepositoryVulnerabilityAlertResolvePropAlert"""

    id: int = Field(default=...)
    number: int = Field(default=...)
    node_id: str = Field(default=...)
    state: Literal["fixed"] = Field(default=...)
    affected_range: str = Field(default=...)
    affected_package_name: str = Field(default=...)
    dismisser: Union[Unset, User] = Field(title="User", default=UNSET)
    dismiss_reason: Union[Unset, str] = Field(default=UNSET)
    dismissed_at: Union[Unset, datetime] = Field(default=UNSET)
    severity: str = Field(default=...)
    ghsa_id: str = Field(default=...)
    external_reference: str = Field(default=...)
    external_identifier: str = Field(default=...)
    fixed_in: str = Field(default=...)
    fixed_at: datetime = Field(default=...)
    fix_reason: str = Field(default=...)
    created_at: datetime = Field(default=...)


class RepositoryVulnerabilityAlertResolvePropAlertAllof1(GitHubWebhookModel):
    """RepositoryVulnerabilityAlertResolvePropAlertAllof1"""

    state: Literal["fixed"] = Field(default=...)
    fixed_at: datetime = Field(default=...)
    fix_reason: str = Field(default=...)


class SecretScanningAlertCreated(GitHubWebhookModel):
    """secret_scanning_alert created event"""

    action: Literal["created"] = Field(default=...)
    alert: SecretScanningAlertCreatedPropAlert = Field(
        description="The secret scanning alert involved in the event.", default=...
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class SecretScanningAlertCreatedPropAlert(GitHubWebhookModel):
    """SecretScanningAlertCreatedPropAlert

    The secret scanning alert involved in the event.
    """

    number: int = Field(default=...)
    secret_type: str = Field(default=...)
    resolution: None = Field(default=...)
    resolved_by: None = Field(default=...)
    resolved_at: None = Field(default=...)


class SecretScanningAlertReopened(GitHubWebhookModel):
    """secret_scanning_alert reopened event"""

    action: Literal["reopened"] = Field(default=...)
    alert: SecretScanningAlertReopenedPropAlert = Field(
        description="The secret scanning alert involved in the event.", default=...
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class SecretScanningAlertReopenedPropAlert(GitHubWebhookModel):
    """SecretScanningAlertReopenedPropAlert

    The secret scanning alert involved in the event.
    """

    number: int = Field(default=...)
    secret_type: str = Field(default=...)
    resolution: None = Field(default=...)
    resolved_by: None = Field(default=...)
    resolved_at: None = Field(default=...)


class SecretScanningAlertResolved(GitHubWebhookModel):
    """secret_scanning_alert resolved event"""

    action: Literal["resolved"] = Field(default=...)
    alert: SecretScanningAlertResolvedPropAlert = Field(
        description="The secret scanning alert involved in the event.", default=...
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    sender: User = Field(title="User", default=...)


class SecretScanningAlertResolvedPropAlert(GitHubWebhookModel):
    """SecretScanningAlertResolvedPropAlert

    The secret scanning alert involved in the event.
    """

    number: int = Field(default=...)
    secret_type: str = Field(default=...)
    resolution: Literal[
        "false_positive", "wontfix", "revoked", "used_in_tests"
    ] = Field(default=...)
    resolved_by: User = Field(title="User", default=...)
    resolved_at: datetime = Field(default=...)


class SecurityAdvisoryPerformed(GitHubWebhookModel):
    """security_advisory performed event"""

    action: Literal["performed"] = Field(default=...)
    security_advisory: SecurityAdvisoryPerformedPropSecurityAdvisory = Field(
        description="The details of the security advisory, including summary, description, and severity.",
        default=...,
    )


class SecurityAdvisoryPerformedPropSecurityAdvisory(GitHubWebhookModel):
    """SecurityAdvisoryPerformedPropSecurityAdvisory

    The details of the security advisory, including summary, description, and
    severity.
    """

    cvss: SecurityAdvisoryPerformedPropSecurityAdvisoryPropCvss = Field(default=...)
    cwes: List[SecurityAdvisoryPerformedPropSecurityAdvisoryPropCwesItems] = Field(
        default=...
    )
    ghsa_id: str = Field(default=...)
    cve_id: Union[str, None] = Field(default=...)
    summary: str = Field(default=...)
    description: str = Field(default=...)
    severity: str = Field(default=...)
    identifiers: List[
        SecurityAdvisoryPerformedPropSecurityAdvisoryPropIdentifiersItems
    ] = Field(default=...)
    references: List[
        SecurityAdvisoryPerformedPropSecurityAdvisoryPropReferencesItems
    ] = Field(default=...)
    published_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    withdrawn_at: Union[datetime, None] = Field(default=...)
    vulnerabilities: List[
        SecurityAdvisoryPerformedPropSecurityAdvisoryPropVulnerabilitiesItems
    ] = Field(default=...)


class SecurityAdvisoryPerformedPropSecurityAdvisoryPropCvss(GitHubWebhookModel):
    """SecurityAdvisoryPerformedPropSecurityAdvisoryPropCvss"""

    vector_string: Union[str, None] = Field(default=...)
    score: float = Field(default=...)


class SecurityAdvisoryPerformedPropSecurityAdvisoryPropCwesItems(GitHubWebhookModel):
    """SecurityAdvisoryPerformedPropSecurityAdvisoryPropCwesItems"""

    cwe_id: str = Field(default=...)
    name: str = Field(default=...)


class SecurityAdvisoryPerformedPropSecurityAdvisoryPropIdentifiersItems(
    GitHubWebhookModel
):
    """SecurityAdvisoryPerformedPropSecurityAdvisoryPropIdentifiersItems"""

    value: str = Field(default=...)
    type: str = Field(default=...)


class SecurityAdvisoryPerformedPropSecurityAdvisoryPropReferencesItems(
    GitHubWebhookModel
):
    """SecurityAdvisoryPerformedPropSecurityAdvisoryPropReferencesItems"""

    url: str = Field(default=...)


class SecurityAdvisoryPerformedPropSecurityAdvisoryPropVulnerabilitiesItems(
    GitHubWebhookModel
):
    """SecurityAdvisoryPerformedPropSecurityAdvisoryPropVulnerabilitiesItems"""

    package: SecurityAdvisoryPerformedPropSecurityAdvisoryPropVulnerabilitiesItemsPropPackage = Field(
        default=...
    )
    severity: str = Field(default=...)
    vulnerable_version_range: str = Field(default=...)
    first_patched_version: Union[
        SecurityAdvisoryPerformedPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersion,
        None,
    ] = Field(default=...)


class SecurityAdvisoryPerformedPropSecurityAdvisoryPropVulnerabilitiesItemsPropPackage(
    GitHubWebhookModel
):
    """SecurityAdvisoryPerformedPropSecurityAdvisoryPropVulnerabilitiesItemsPropPackage"""

    ecosystem: str = Field(default=...)
    name: str = Field(default=...)


class SecurityAdvisoryPerformedPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersion(
    GitHubWebhookModel
):
    """SecurityAdvisoryPerformedPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPa
    tchedVersion
    """

    identifier: str = Field(default=...)


class SecurityAdvisoryPublished(GitHubWebhookModel):
    """security_advisory published event"""

    action: Literal["published"] = Field(default=...)
    security_advisory: SecurityAdvisoryPublishedPropSecurityAdvisory = Field(
        description="The details of the security advisory, including summary, description, and severity.",
        default=...,
    )


class SecurityAdvisoryPublishedPropSecurityAdvisory(GitHubWebhookModel):
    """SecurityAdvisoryPublishedPropSecurityAdvisory

    The details of the security advisory, including summary, description, and
    severity.
    """

    cvss: SecurityAdvisoryPublishedPropSecurityAdvisoryPropCvss = Field(default=...)
    cwes: List[SecurityAdvisoryPublishedPropSecurityAdvisoryPropCwesItems] = Field(
        default=...
    )
    ghsa_id: str = Field(default=...)
    cve_id: Union[str, None] = Field(default=...)
    summary: str = Field(default=...)
    description: str = Field(default=...)
    severity: str = Field(default=...)
    identifiers: List[
        SecurityAdvisoryPublishedPropSecurityAdvisoryPropIdentifiersItems
    ] = Field(default=...)
    references: List[
        SecurityAdvisoryPublishedPropSecurityAdvisoryPropReferencesItems
    ] = Field(default=...)
    published_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    withdrawn_at: Union[datetime, None] = Field(default=...)
    vulnerabilities: List[
        SecurityAdvisoryPublishedPropSecurityAdvisoryPropVulnerabilitiesItems
    ] = Field(default=...)


class SecurityAdvisoryPublishedPropSecurityAdvisoryPropCvss(GitHubWebhookModel):
    """SecurityAdvisoryPublishedPropSecurityAdvisoryPropCvss"""

    vector_string: Union[str, None] = Field(default=...)
    score: float = Field(default=...)


class SecurityAdvisoryPublishedPropSecurityAdvisoryPropCwesItems(GitHubWebhookModel):
    """SecurityAdvisoryPublishedPropSecurityAdvisoryPropCwesItems"""

    cwe_id: str = Field(default=...)
    name: str = Field(default=...)


class SecurityAdvisoryPublishedPropSecurityAdvisoryPropIdentifiersItems(
    GitHubWebhookModel
):
    """SecurityAdvisoryPublishedPropSecurityAdvisoryPropIdentifiersItems"""

    value: str = Field(default=...)
    type: str = Field(default=...)


class SecurityAdvisoryPublishedPropSecurityAdvisoryPropReferencesItems(
    GitHubWebhookModel
):
    """SecurityAdvisoryPublishedPropSecurityAdvisoryPropReferencesItems"""

    url: str = Field(default=...)


class SecurityAdvisoryPublishedPropSecurityAdvisoryPropVulnerabilitiesItems(
    GitHubWebhookModel
):
    """SecurityAdvisoryPublishedPropSecurityAdvisoryPropVulnerabilitiesItems"""

    package: SecurityAdvisoryPublishedPropSecurityAdvisoryPropVulnerabilitiesItemsPropPackage = Field(
        default=...
    )
    severity: str = Field(default=...)
    vulnerable_version_range: str = Field(default=...)
    first_patched_version: Union[
        SecurityAdvisoryPublishedPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersion,
        None,
    ] = Field(default=...)


class SecurityAdvisoryPublishedPropSecurityAdvisoryPropVulnerabilitiesItemsPropPackage(
    GitHubWebhookModel
):
    """SecurityAdvisoryPublishedPropSecurityAdvisoryPropVulnerabilitiesItemsPropPackage"""

    ecosystem: str = Field(default=...)
    name: str = Field(default=...)


class SecurityAdvisoryPublishedPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersion(
    GitHubWebhookModel
):
    """SecurityAdvisoryPublishedPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPa
    tchedVersion
    """

    identifier: str = Field(default=...)


class SecurityAdvisoryUpdated(GitHubWebhookModel):
    """security_advisory updated event"""

    action: Literal["updated"] = Field(default=...)
    security_advisory: SecurityAdvisoryUpdatedPropSecurityAdvisory = Field(
        description="The details of the security advisory, including summary, description, and severity.",
        default=...,
    )


class SecurityAdvisoryUpdatedPropSecurityAdvisory(GitHubWebhookModel):
    """SecurityAdvisoryUpdatedPropSecurityAdvisory

    The details of the security advisory, including summary, description, and
    severity.
    """

    cvss: SecurityAdvisoryUpdatedPropSecurityAdvisoryPropCvss = Field(default=...)
    cwes: List[SecurityAdvisoryUpdatedPropSecurityAdvisoryPropCwesItems] = Field(
        default=...
    )
    ghsa_id: str = Field(default=...)
    cve_id: Union[str, None] = Field(default=...)
    summary: str = Field(default=...)
    description: str = Field(default=...)
    severity: str = Field(default=...)
    identifiers: List[
        SecurityAdvisoryUpdatedPropSecurityAdvisoryPropIdentifiersItems
    ] = Field(default=...)
    references: List[
        SecurityAdvisoryUpdatedPropSecurityAdvisoryPropReferencesItems
    ] = Field(default=...)
    published_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    withdrawn_at: Union[datetime, None] = Field(default=...)
    vulnerabilities: List[
        SecurityAdvisoryUpdatedPropSecurityAdvisoryPropVulnerabilitiesItems
    ] = Field(default=...)


class SecurityAdvisoryUpdatedPropSecurityAdvisoryPropCvss(GitHubWebhookModel):
    """SecurityAdvisoryUpdatedPropSecurityAdvisoryPropCvss"""

    vector_string: Union[str, None] = Field(default=...)
    score: float = Field(default=...)


class SecurityAdvisoryUpdatedPropSecurityAdvisoryPropCwesItems(GitHubWebhookModel):
    """SecurityAdvisoryUpdatedPropSecurityAdvisoryPropCwesItems"""

    cwe_id: str = Field(default=...)
    name: str = Field(default=...)


class SecurityAdvisoryUpdatedPropSecurityAdvisoryPropIdentifiersItems(
    GitHubWebhookModel
):
    """SecurityAdvisoryUpdatedPropSecurityAdvisoryPropIdentifiersItems"""

    value: str = Field(default=...)
    type: str = Field(default=...)


class SecurityAdvisoryUpdatedPropSecurityAdvisoryPropReferencesItems(
    GitHubWebhookModel
):
    """SecurityAdvisoryUpdatedPropSecurityAdvisoryPropReferencesItems"""

    url: str = Field(default=...)


class SecurityAdvisoryUpdatedPropSecurityAdvisoryPropVulnerabilitiesItems(
    GitHubWebhookModel
):
    """SecurityAdvisoryUpdatedPropSecurityAdvisoryPropVulnerabilitiesItems"""

    package: SecurityAdvisoryUpdatedPropSecurityAdvisoryPropVulnerabilitiesItemsPropPackage = Field(
        default=...
    )
    severity: str = Field(default=...)
    vulnerable_version_range: str = Field(default=...)
    first_patched_version: Union[
        SecurityAdvisoryUpdatedPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersion,
        None,
    ] = Field(default=...)


class SecurityAdvisoryUpdatedPropSecurityAdvisoryPropVulnerabilitiesItemsPropPackage(
    GitHubWebhookModel
):
    """SecurityAdvisoryUpdatedPropSecurityAdvisoryPropVulnerabilitiesItemsPropPackage"""

    ecosystem: str = Field(default=...)
    name: str = Field(default=...)


class SecurityAdvisoryUpdatedPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersion(
    GitHubWebhookModel
):
    """SecurityAdvisoryUpdatedPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatc
    hedVersion
    """

    identifier: str = Field(default=...)


class SecurityAdvisoryWithdrawn(GitHubWebhookModel):
    """security_advisory withdrawn event"""

    action: Literal["withdrawn"] = Field(default=...)
    security_advisory: SecurityAdvisoryWithdrawnPropSecurityAdvisory = Field(
        description="The details of the security advisory, including summary, description, and severity.",
        default=...,
    )


class SecurityAdvisoryWithdrawnPropSecurityAdvisory(GitHubWebhookModel):
    """SecurityAdvisoryWithdrawnPropSecurityAdvisory

    The details of the security advisory, including summary, description, and
    severity.
    """

    cvss: SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropCvss = Field(default=...)
    cwes: List[SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropCwesItems] = Field(
        default=...
    )
    ghsa_id: str = Field(default=...)
    cve_id: Union[str, None] = Field(default=...)
    summary: str = Field(default=...)
    description: str = Field(default=...)
    severity: str = Field(default=...)
    identifiers: List[
        SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropIdentifiersItems
    ] = Field(default=...)
    references: List[
        SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropReferencesItems
    ] = Field(default=...)
    published_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    withdrawn_at: datetime = Field(default=...)
    vulnerabilities: List[
        SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropVulnerabilitiesItems
    ] = Field(default=...)


class SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropCvss(GitHubWebhookModel):
    """SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropCvss"""

    vector_string: Union[str, None] = Field(default=...)
    score: float = Field(default=...)


class SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropCwesItems(GitHubWebhookModel):
    """SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropCwesItems"""

    cwe_id: str = Field(default=...)
    name: str = Field(default=...)


class SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropIdentifiersItems(
    GitHubWebhookModel
):
    """SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropIdentifiersItems"""

    value: str = Field(default=...)
    type: str = Field(default=...)


class SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropReferencesItems(
    GitHubWebhookModel
):
    """SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropReferencesItems"""

    url: str = Field(default=...)


class SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropVulnerabilitiesItems(
    GitHubWebhookModel
):
    """SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropVulnerabilitiesItems"""

    package: SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropVulnerabilitiesItemsPropPackage = Field(
        default=...
    )
    severity: str = Field(default=...)
    vulnerable_version_range: str = Field(default=...)
    first_patched_version: Union[
        SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersion,
        None,
    ] = Field(default=...)


class SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropVulnerabilitiesItemsPropPackage(
    GitHubWebhookModel
):
    """SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropVulnerabilitiesItemsPropPackage"""

    ecosystem: str = Field(default=...)
    name: str = Field(default=...)


class SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersion(
    GitHubWebhookModel
):
    """SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPa
    tchedVersion
    """

    identifier: str = Field(default=...)


class SponsorshipCancelled(GitHubWebhookModel):
    """sponsorship cancelled event"""

    action: Literal["cancelled"] = Field(default=...)
    sponsorship: SponsorshipCancelledPropSponsorship = Field(default=...)
    sender: User = Field(title="User", default=...)


class SponsorshipCancelledPropSponsorship(GitHubWebhookModel):
    """SponsorshipCancelledPropSponsorship"""

    node_id: str = Field(default=...)
    created_at: datetime = Field(default=...)
    sponsorable: User = Field(title="User", default=...)
    sponsor: User = Field(title="User", default=...)
    privacy_level: str = Field(default=...)
    tier: SponsorshipTier = Field(
        title="Sponsorship Tier",
        description="The `tier_changed` and `pending_tier_change` will include the original tier before the change or pending change. For more information, see the pending tier change payload.",
        default=...,
    )


class SponsorshipTier(GitHubWebhookModel):
    """Sponsorship Tier

    The `tier_changed` and `pending_tier_change` will include the original tier
    before the change or pending change. For more information, see the pending tier
    change payload.
    """

    node_id: str = Field(default=...)
    created_at: datetime = Field(default=...)
    description: str = Field(default=...)
    monthly_price_in_cents: int = Field(default=...)
    monthly_price_in_dollars: int = Field(default=...)
    name: str = Field(default=...)
    is_one_time: bool = Field(default=...)
    is_custom_ammount: bool = Field(default=...)


class SponsorshipCreated(GitHubWebhookModel):
    """sponsorship created event"""

    action: Literal["created"] = Field(default=...)
    sponsorship: SponsorshipCreatedPropSponsorship = Field(default=...)
    sender: User = Field(title="User", default=...)


class SponsorshipCreatedPropSponsorship(GitHubWebhookModel):
    """SponsorshipCreatedPropSponsorship"""

    node_id: str = Field(default=...)
    created_at: datetime = Field(default=...)
    sponsorable: User = Field(title="User", default=...)
    sponsor: User = Field(title="User", default=...)
    privacy_level: str = Field(default=...)
    tier: SponsorshipTier = Field(
        title="Sponsorship Tier",
        description="The `tier_changed` and `pending_tier_change` will include the original tier before the change or pending change. For more information, see the pending tier change payload.",
        default=...,
    )


class SponsorshipEdited(GitHubWebhookModel):
    """sponsorship edited event"""

    action: Literal["edited"] = Field(default=...)
    sponsorship: SponsorshipEditedPropSponsorship = Field(default=...)
    changes: SponsorshipEditedPropChanges = Field(default=...)
    sender: User = Field(title="User", default=...)


class SponsorshipEditedPropSponsorship(GitHubWebhookModel):
    """SponsorshipEditedPropSponsorship"""

    node_id: str = Field(default=...)
    created_at: datetime = Field(default=...)
    sponsorable: User = Field(title="User", default=...)
    sponsor: User = Field(title="User", default=...)
    privacy_level: str = Field(default=...)
    tier: SponsorshipTier = Field(
        title="Sponsorship Tier",
        description="The `tier_changed` and `pending_tier_change` will include the original tier before the change or pending change. For more information, see the pending tier change payload.",
        default=...,
    )


class SponsorshipEditedPropChanges(GitHubWebhookModel):
    """SponsorshipEditedPropChanges"""

    privacy_level: Union[Unset, SponsorshipEditedPropChangesPropPrivacyLevel] = Field(
        default=UNSET
    )


class SponsorshipEditedPropChangesPropPrivacyLevel(GitHubWebhookModel):
    """SponsorshipEditedPropChangesPropPrivacyLevel"""

    from_: str = Field(
        description="The `edited` event types include the details about the change when someone edits a sponsorship to change the privacy.",
        default=...,
        alias="from",
    )


class SponsorshipPendingCancellation(GitHubWebhookModel):
    """sponsorship pending_cancellation event"""

    action: Literal["pending_cancellation"] = Field(default=...)
    sponsorship: SponsorshipPendingCancellationPropSponsorship = Field(default=...)
    effective_date: Union[Unset, str] = Field(
        description="The `pending_cancellation` and `pending_tier_change` event types will include the date the cancellation or tier change will take effect.",
        default=UNSET,
    )
    sender: User = Field(title="User", default=...)


class SponsorshipPendingCancellationPropSponsorship(GitHubWebhookModel):
    """SponsorshipPendingCancellationPropSponsorship"""

    node_id: str = Field(default=...)
    created_at: datetime = Field(default=...)
    sponsorable: User = Field(title="User", default=...)
    sponsor: User = Field(title="User", default=...)
    privacy_level: str = Field(default=...)
    tier: SponsorshipTier = Field(
        title="Sponsorship Tier",
        description="The `tier_changed` and `pending_tier_change` will include the original tier before the change or pending change. For more information, see the pending tier change payload.",
        default=...,
    )


class SponsorshipPendingTierChange(GitHubWebhookModel):
    """sponsorship pending_tier_change event"""

    action: Literal["pending_tier_change"] = Field(default=...)
    sponsorship: SponsorshipPendingTierChangePropSponsorship = Field(default=...)
    effective_date: Union[Unset, str] = Field(
        description="The `pending_cancellation` and `pending_tier_change` event types will include the date the cancellation or tier change will take effect.",
        default=UNSET,
    )
    changes: SponsorshipPendingTierChangePropChanges = Field(default=...)
    sender: User = Field(title="User", default=...)


class SponsorshipPendingTierChangePropSponsorship(GitHubWebhookModel):
    """SponsorshipPendingTierChangePropSponsorship"""

    node_id: str = Field(default=...)
    created_at: datetime = Field(default=...)
    sponsorable: User = Field(title="User", default=...)
    sponsor: User = Field(title="User", default=...)
    privacy_level: str = Field(default=...)
    tier: SponsorshipTier = Field(
        title="Sponsorship Tier",
        description="The `tier_changed` and `pending_tier_change` will include the original tier before the change or pending change. For more information, see the pending tier change payload.",
        default=...,
    )


class SponsorshipPendingTierChangePropChanges(GitHubWebhookModel):
    """SponsorshipPendingTierChangePropChanges"""

    tier: SponsorshipPendingTierChangePropChangesPropTier = Field(default=...)


class SponsorshipPendingTierChangePropChangesPropTier(GitHubWebhookModel):
    """SponsorshipPendingTierChangePropChangesPropTier"""

    from_: SponsorshipTier = Field(
        title="Sponsorship Tier",
        description="The `tier_changed` and `pending_tier_change` will include the original tier before the change or pending change. For more information, see the pending tier change payload.",
        default=...,
        alias="from",
    )


class SponsorshipTierChanged(GitHubWebhookModel):
    """sponsorship tier_changed event"""

    action: Literal["tier_changed"] = Field(default=...)
    sponsorship: SponsorshipTierChangedPropSponsorship = Field(default=...)
    changes: SponsorshipTierChangedPropChanges = Field(default=...)
    sender: User = Field(title="User", default=...)


class SponsorshipTierChangedPropSponsorship(GitHubWebhookModel):
    """SponsorshipTierChangedPropSponsorship"""

    node_id: str = Field(default=...)
    created_at: datetime = Field(default=...)
    sponsorable: User = Field(title="User", default=...)
    sponsor: User = Field(title="User", default=...)
    privacy_level: str = Field(default=...)
    tier: SponsorshipTier = Field(
        title="Sponsorship Tier",
        description="The `tier_changed` and `pending_tier_change` will include the original tier before the change or pending change. For more information, see the pending tier change payload.",
        default=...,
    )


class SponsorshipTierChangedPropChanges(GitHubWebhookModel):
    """SponsorshipTierChangedPropChanges"""

    tier: SponsorshipTierChangedPropChangesPropTier = Field(default=...)


class SponsorshipTierChangedPropChangesPropTier(GitHubWebhookModel):
    """SponsorshipTierChangedPropChangesPropTier"""

    from_: SponsorshipTier = Field(
        title="Sponsorship Tier",
        description="The `tier_changed` and `pending_tier_change` will include the original tier before the change or pending change. For more information, see the pending tier change payload.",
        default=...,
        alias="from",
    )


class StarCreated(GitHubWebhookModel):
    """star created event"""

    action: Literal["created"] = Field(default=...)
    starred_at: datetime = Field(
        description="The time the star was created. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. Will be `null` for the `deleted` action.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class StarDeleted(GitHubWebhookModel):
    """star deleted event"""

    action: Literal["deleted"] = Field(default=...)
    starred_at: None = Field(
        description="The time the star was created. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. Will be `null` for the `deleted` action.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class StatusEvent(GitHubWebhookModel):
    """status event"""

    id: int = Field(description="The unique identifier of the status.", default=...)
    sha: str = Field(description="The Commit SHA.", default=...)
    name: str = Field(default=...)
    avatar_url: Union[Unset, Union[str, None]] = Field(default=UNSET)
    target_url: Union[str, None] = Field(
        description="The optional link added to the status.", default=...
    )
    context: str = Field(default=...)
    description: Union[str, None] = Field(
        description="The optional human-readable description added to the status.",
        default=...,
    )
    state: Literal["pending", "success", "failure", "error"] = Field(
        description="The new state. Can be `pending`, `success`, `failure`, or `error`.",
        default=...,
    )
    commit: StatusEventPropCommit = Field(default=...)
    branches: List[StatusEventPropBranchesItems] = Field(
        description="An array of branch objects containing the status' SHA. Each branch contains the given SHA, but the SHA may or may not be the head of the branch. The array includes a maximum of 10 branches.",
        default=...,
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class StatusEventPropCommit(GitHubWebhookModel):
    """StatusEventPropCommit"""

    sha: str = Field(default=...)
    node_id: str = Field(default=...)
    commit: StatusEventPropCommitPropCommit = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    author: Union[User, None] = Field(title="User", default=...)
    committer: Union[User, None] = Field(title="User", default=...)
    parents: List[StatusEventPropCommitPropParentsItems] = Field(default=...)


class StatusEventPropCommitPropCommit(GitHubWebhookModel):
    """StatusEventPropCommitPropCommit"""

    author: StatusEventPropCommitPropCommitPropAuthor = Field(default=...)
    committer: StatusEventPropCommitPropCommitPropCommitter = Field(default=...)
    message: str = Field(default=...)
    tree: StatusEventPropCommitPropCommitPropTree = Field(default=...)
    url: str = Field(default=...)
    comment_count: int = Field(default=...)
    verification: StatusEventPropCommitPropCommitPropVerification = Field(default=...)


class StatusEventPropCommitPropCommitPropAuthor(GitHubWebhookModel):
    """StatusEventPropCommitPropCommitPropAuthor"""

    name: str = Field(description="The git author's name.", default=...)
    email: Union[str, None] = Field(
        description="The git author's email address.", default=...
    )
    date: datetime = Field(default=...)
    username: Union[Unset, str] = Field(default=UNSET)


class StatusEventPropCommitPropCommitPropAuthorAllof1(GitHubWebhookModel):
    """StatusEventPropCommitPropCommitPropAuthorAllof1"""

    date: str = Field(default=...)


class StatusEventPropCommitPropCommitPropCommitter(GitHubWebhookModel):
    """StatusEventPropCommitPropCommitPropCommitter"""

    name: str = Field(description="The git author's name.", default=...)
    email: Union[str, None] = Field(
        description="The git author's email address.", default=...
    )
    date: datetime = Field(default=...)
    username: Union[Unset, str] = Field(default=UNSET)


class StatusEventPropCommitPropCommitPropCommitterAllof1(GitHubWebhookModel):
    """StatusEventPropCommitPropCommitPropCommitterAllof1"""

    date: str = Field(default=...)


class StatusEventPropCommitPropCommitPropTree(GitHubWebhookModel):
    """StatusEventPropCommitPropCommitPropTree"""

    sha: str = Field(default=...)
    url: str = Field(default=...)


class StatusEventPropCommitPropCommitPropVerification(GitHubWebhookModel):
    """StatusEventPropCommitPropCommitPropVerification"""

    verified: bool = Field(default=...)
    reason: Literal[
        "expired_key",
        "not_signing_key",
        "gpgverify_error",
        "gpgverify_unavailable",
        "unsigned",
        "unknown_signature_type",
        "no_user",
        "unverified_email",
        "bad_email",
        "unknown_key",
        "malformed_signature",
        "invalid",
        "valid",
    ] = Field(default=...)
    signature: Union[str, None] = Field(default=...)
    payload: Union[str, None] = Field(default=...)


class StatusEventPropCommitPropParentsItems(GitHubWebhookModel):
    """StatusEventPropCommitPropParentsItems"""

    sha: str = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)


class StatusEventPropBranchesItems(GitHubWebhookModel):
    """StatusEventPropBranchesItems"""

    name: str = Field(default=...)
    commit: StatusEventPropBranchesItemsPropCommit = Field(default=...)
    protected: bool = Field(default=...)


class StatusEventPropBranchesItemsPropCommit(GitHubWebhookModel):
    """StatusEventPropBranchesItemsPropCommit"""

    sha: str = Field(default=...)
    url: str = Field(default=...)


class TeamAddedToRepository(GitHubWebhookModel):
    """team added_to_repository event"""

    action: Literal["added_to_repository"] = Field(default=...)
    team: Team = Field(
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=...,
    )
    repository: Union[Unset, Repository] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    sender: User = Field(title="User", default=...)
    organization: Organization = Field(title="Organization", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class TeamCreated(GitHubWebhookModel):
    """team created event"""

    action: Literal["created"] = Field(default=...)
    team: Team = Field(
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=...,
    )
    repository: Union[Unset, Repository] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    sender: User = Field(title="User", default=...)
    organization: Organization = Field(title="Organization", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class TeamDeleted(GitHubWebhookModel):
    """team deleted event"""

    action: Literal["deleted"] = Field(default=...)
    team: Team = Field(
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=...,
    )
    repository: Union[Unset, Repository] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    sender: User = Field(title="User", default=...)
    organization: Organization = Field(title="Organization", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class TeamEdited(GitHubWebhookModel):
    """team edited event"""

    action: Literal["edited"] = Field(default=...)
    changes: TeamEditedPropChanges = Field(
        description="The changes to the team if the action was `edited`.", default=...
    )
    team: Team = Field(
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=...,
    )
    repository: Union[Unset, Repository] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    sender: User = Field(title="User", default=...)
    organization: Organization = Field(title="Organization", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class TeamEditedPropChanges(GitHubWebhookModel):
    """TeamEditedPropChanges

    The changes to the team if the action was `edited`.
    """

    description: Union[Unset, TeamEditedPropChangesPropDescription] = Field(
        default=UNSET
    )
    name: Union[Unset, TeamEditedPropChangesPropName] = Field(default=UNSET)
    privacy: Union[Unset, TeamEditedPropChangesPropPrivacy] = Field(default=UNSET)
    repository: Union[Unset, TeamEditedPropChangesPropRepository] = Field(default=UNSET)


class TeamEditedPropChangesPropDescription(GitHubWebhookModel):
    """TeamEditedPropChangesPropDescription"""

    from_: str = Field(
        description="The previous version of the description if the action was `edited`.",
        default=...,
        alias="from",
    )


class TeamEditedPropChangesPropName(GitHubWebhookModel):
    """TeamEditedPropChangesPropName"""

    from_: str = Field(
        description="The previous version of the name if the action was `edited`.",
        default=...,
        alias="from",
    )


class TeamEditedPropChangesPropPrivacy(GitHubWebhookModel):
    """TeamEditedPropChangesPropPrivacy"""

    from_: str = Field(
        description="The previous version of the team's privacy if the action was `edited`.",
        default=...,
        alias="from",
    )


class TeamEditedPropChangesPropRepository(GitHubWebhookModel):
    """TeamEditedPropChangesPropRepository"""

    permissions: TeamEditedPropChangesPropRepositoryPropPermissions = Field(default=...)


class TeamEditedPropChangesPropRepositoryPropPermissions(GitHubWebhookModel):
    """TeamEditedPropChangesPropRepositoryPropPermissions"""

    from_: TeamEditedPropChangesPropRepositoryPropPermissionsPropFrom = Field(
        default=..., alias="from"
    )


class TeamEditedPropChangesPropRepositoryPropPermissionsPropFrom(GitHubWebhookModel):
    """TeamEditedPropChangesPropRepositoryPropPermissionsPropFrom"""

    admin: Union[Unset, bool] = Field(
        description="The previous version of the team member's `admin` permission on a repository, if the action was `edited`.",
        default=UNSET,
    )
    pull: Union[Unset, bool] = Field(
        description="The previous version of the team member's `pull` permission on a repository, if the action was `edited`.",
        default=UNSET,
    )
    push: Union[Unset, bool] = Field(
        description="The previous version of the team member's `push` permission on a repository, if the action was `edited`.",
        default=UNSET,
    )


class TeamRemovedFromRepository(GitHubWebhookModel):
    """team removed_from_repository event"""

    action: Literal["removed_from_repository"] = Field(default=...)
    team: Team = Field(
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=...,
    )
    repository: Union[Unset, Repository] = Field(
        title="Repository", description="A git repository", default=UNSET
    )
    sender: User = Field(title="User", default=...)
    organization: Organization = Field(title="Organization", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class TeamAddEvent(GitHubWebhookModel):
    """team_add event"""

    team: Team = Field(
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=...,
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Organization = Field(title="Organization", default=...)


class WatchStarted(GitHubWebhookModel):
    """watch started event"""

    action: Literal["started"] = Field(default=...)
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )


class WorkflowDispatchEvent(GitHubWebhookModel):
    """workflow_dispatch event"""

    inputs: Union[WorkflowDispatchEventPropInputsOneof0, None] = Field(
        description="Inputs to the workflow. Each key represents the name of the input while it's value represents the value of that input.",
        default=...,
    )
    ref: str = Field(
        description="The branch ref from which the workflow was run.", default=...
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    workflow: str = Field(
        description="Relative path to the workflow file which contains the workflow.",
        default=...,
    )


class WorkflowDispatchEventPropInputsOneof0(GitHubWebhookModel, extra=Extra.allow):
    """WorkflowDispatchEventPropInputsOneof0"""


class WorkflowJobCompleted(GitHubWebhookModel):
    """workflow_job completed event"""

    action: Literal["completed"] = Field(default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    workflow_job: WorkflowJobCompletedPropWorkflowJob = Field(default=...)


class WorkflowJobCompletedPropWorkflowJob(GitHubWebhookModel):
    """WorkflowJobCompletedPropWorkflowJob"""

    id: int = Field(default=...)
    run_id: float = Field(default=...)
    run_attempt: int = Field(default=...)
    run_url: str = Field(default=...)
    head_sha: str = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(default=...)
    check_run_url: str = Field(default=...)
    html_url: str = Field(default=...)
    url: str = Field(default=...)
    status: Literal["queued", "in_progress", "completed"] = Field(
        description="The current status of the job. Can be `queued`, `in_progress`, or `completed`.",
        default=...,
    )
    steps: List[Union[WorkflowStepInProgress, WorkflowStepCompleted]] = Field(
        default=...
    )
    conclusion: Literal["success", "failure", "cancelled", "skipped"] = Field(
        default=...
    )
    labels: List[str] = Field(
        description='Custom labels for the job. Specified by the [`"runs-on"` attribute](https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions#jobsjob_idruns-on) in the workflow YAML.',
        default=...,
    )
    runner_id: Union[int, None] = Field(
        description="The ID of the runner that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.",
        default=...,
    )
    runner_name: Union[str, None] = Field(
        description="The name of the runner that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.",
        default=...,
    )
    runner_group_id: Union[int, None] = Field(
        description="The ID of the runner group that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.",
        default=...,
    )
    runner_group_name: Union[str, None] = Field(
        description="The name of the runner group that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.",
        default=...,
    )
    started_at: datetime = Field(default=...)
    completed_at: Union[datetime, None] = Field(default=...)


class WorkflowJob(GitHubWebhookModel):
    """Workflow Job

    The workflow job. Many `workflow_job` keys, such as `head_sha`, `conclusion`,
    and `started_at` are the same as those in a [`check_run`](#check_run) object.
    """

    id: int = Field(default=...)
    run_id: float = Field(default=...)
    run_attempt: int = Field(default=...)
    run_url: str = Field(default=...)
    head_sha: str = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(default=...)
    check_run_url: str = Field(default=...)
    html_url: str = Field(default=...)
    url: str = Field(default=...)
    status: Literal["queued", "in_progress", "completed"] = Field(
        description="The current status of the job. Can be `queued`, `in_progress`, or `completed`.",
        default=...,
    )
    steps: List[Union[WorkflowStepInProgress, WorkflowStepCompleted]] = Field(
        default=...
    )
    conclusion: Union[
        None, Literal["success", "failure", "cancelled", "skipped"]
    ] = Field(default=...)
    labels: List[str] = Field(
        description='Custom labels for the job. Specified by the [`"runs-on"` attribute](https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions#jobsjob_idruns-on) in the workflow YAML.',
        default=...,
    )
    runner_id: Union[int, None] = Field(
        description="The ID of the runner that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.",
        default=...,
    )
    runner_name: Union[str, None] = Field(
        description="The name of the runner that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.",
        default=...,
    )
    runner_group_id: Union[int, None] = Field(
        description="The ID of the runner group that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.",
        default=...,
    )
    runner_group_name: Union[str, None] = Field(
        description="The name of the runner group that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.",
        default=...,
    )
    started_at: datetime = Field(default=...)
    completed_at: Union[datetime, None] = Field(default=...)


class WorkflowStepInProgress(GitHubWebhookModel):
    """Workflow Step (In Progress)"""

    name: str = Field(default=...)
    status: Literal["in_progress"] = Field(default=...)
    conclusion: None = Field(default=...)
    number: int = Field(default=...)
    started_at: datetime = Field(default=...)
    completed_at: None = Field(default=...)


class WorkflowStepCompleted(GitHubWebhookModel):
    """Workflow Step (Completed)"""

    name: str = Field(default=...)
    status: Literal["completed"] = Field(default=...)
    conclusion: Literal["failure", "skipped", "success"] = Field(default=...)
    number: int = Field(default=...)
    started_at: datetime = Field(default=...)
    completed_at: datetime = Field(default=...)


class WorkflowJobCompletedPropWorkflowJobAllof1(GitHubWebhookModel):
    """WorkflowJobCompletedPropWorkflowJobAllof1"""

    conclusion: Literal["success", "failure", "cancelled", "skipped"] = Field(
        default=...
    )


class WorkflowJobInProgress(GitHubWebhookModel):
    """workflow_job in_progress event"""

    action: Literal["in_progress"] = Field(default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    workflow_job: WorkflowJobInProgressPropWorkflowJob = Field(default=...)


class WorkflowJobInProgressPropWorkflowJob(GitHubWebhookModel):
    """WorkflowJobInProgressPropWorkflowJob"""

    id: int = Field(default=...)
    run_id: float = Field(default=...)
    run_attempt: int = Field(default=...)
    run_url: str = Field(default=...)
    head_sha: str = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(default=...)
    check_run_url: str = Field(default=...)
    html_url: str = Field(default=...)
    url: str = Field(default=...)
    status: Literal["in_progress"] = Field(default=...)
    steps: List[Union[WorkflowStepInProgress, WorkflowStepCompleted]] = Field(
        default=...
    )
    conclusion: Union[
        None, Literal["success", "failure", "cancelled", "skipped"]
    ] = Field(default=...)
    labels: List[str] = Field(
        description='Custom labels for the job. Specified by the [`"runs-on"` attribute](https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions#jobsjob_idruns-on) in the workflow YAML.',
        default=...,
    )
    runner_id: Union[int, None] = Field(
        description="The ID of the runner that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.",
        default=...,
    )
    runner_name: Union[str, None] = Field(
        description="The name of the runner that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.",
        default=...,
    )
    runner_group_id: Union[int, None] = Field(
        description="The ID of the runner group that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.",
        default=...,
    )
    runner_group_name: Union[str, None] = Field(
        description="The name of the runner group that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.",
        default=...,
    )
    started_at: datetime = Field(default=...)
    completed_at: Union[datetime, None] = Field(default=...)


class WorkflowJobInProgressPropWorkflowJobAllof1(GitHubWebhookModel):
    """WorkflowJobInProgressPropWorkflowJobAllof1"""

    status: Literal["in_progress"] = Field(default=...)


class WorkflowJobQueued(GitHubWebhookModel):
    """workflow_job queued event"""

    action: Literal["queued"] = Field(default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    workflow_job: WorkflowJobQueuedPropWorkflowJob = Field(default=...)


class WorkflowJobQueuedPropWorkflowJob(GitHubWebhookModel):
    """WorkflowJobQueuedPropWorkflowJob"""

    id: int = Field(default=...)
    run_id: float = Field(default=...)
    run_attempt: int = Field(default=...)
    run_url: str = Field(default=...)
    head_sha: str = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(default=...)
    check_run_url: str = Field(default=...)
    html_url: str = Field(default=...)
    url: str = Field(default=...)
    status: Literal["queued"] = Field(default=...)
    steps: List[Union[WorkflowStepInProgress, WorkflowStepCompleted]] = Field(
        default=...
    )
    conclusion: Union[
        None, Literal["success", "failure", "cancelled", "skipped"]
    ] = Field(default=...)
    labels: List[str] = Field(
        description='Custom labels for the job. Specified by the [`"runs-on"` attribute](https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions#jobsjob_idruns-on) in the workflow YAML.',
        default=...,
    )
    runner_id: Union[int, None] = Field(
        description="The ID of the runner that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.",
        default=...,
    )
    runner_name: Union[str, None] = Field(
        description="The name of the runner that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.",
        default=...,
    )
    runner_group_id: Union[int, None] = Field(
        description="The ID of the runner group that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.",
        default=...,
    )
    runner_group_name: Union[str, None] = Field(
        description="The name of the runner group that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.",
        default=...,
    )
    started_at: datetime = Field(default=...)
    completed_at: Union[datetime, None] = Field(default=...)


class WorkflowJobQueuedPropWorkflowJobAllof1(GitHubWebhookModel):
    """WorkflowJobQueuedPropWorkflowJobAllof1"""

    status: Literal["queued"] = Field(default=...)


class WorkflowRunCompleted(GitHubWebhookModel):
    """workflow_run completed event"""

    action: Literal["completed"] = Field(default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    workflow: Workflow = Field(title="Workflow", default=...)
    workflow_run: WorkflowRunCompletedPropWorkflowRun = Field(default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class WorkflowRunCompletedPropWorkflowRun(GitHubWebhookModel):
    """WorkflowRunCompletedPropWorkflowRun"""

    artifacts_url: str = Field(
        description="The URL to the artifacts for the workflow run.", default=...
    )
    cancel_url: str = Field(
        description="The URL to cancel the workflow run.", default=...
    )
    check_suite_url: str = Field(
        description="The URL to the associated check suite.", default=...
    )
    check_suite_id: int = Field(
        description="The ID of the associated check suite.", default=...
    )
    check_suite_node_id: str = Field(
        description="The node ID of the associated check suite.", default=...
    )
    conclusion: Literal[
        "success",
        "failure",
        "neutral",
        "cancelled",
        "timed_out",
        "action_required",
        "stale",
        "skipped",
    ] = Field(default=...)
    created_at: datetime = Field(default=...)
    event: str = Field(default=...)
    head_branch: str = Field(default=...)
    head_commit: CommitSimple = Field(title="SimpleCommit", default=...)
    head_repository: RepositoryLite = Field(title="Repository Lite", default=...)
    head_sha: str = Field(
        description="The SHA of the head commit that points to the version of the workflow being run.",
        default=...,
    )
    path: str = Field(description="The full path of the workflow", default=...)
    display_title: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(description="The ID of the workflow run.", default=...)
    jobs_url: str = Field(
        description="The URL to the jobs for the workflow run.", default=...
    )
    logs_url: str = Field(
        description="The URL to download the logs for the workflow run.", default=...
    )
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the workflow run.", default=...)
    pull_requests: List[WorkflowRunPropPullRequestsItems] = Field(default=...)
    repository: RepositoryLite = Field(title="Repository Lite", default=...)
    rerun_url: str = Field(
        description="The URL to rerun the workflow run.", default=...
    )
    run_number: int = Field(
        description="The auto incrementing run number for the workflow run.",
        default=...,
    )
    status: Literal[
        "requested", "in_progress", "completed", "queued", "waiting"
    ] = Field(default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="The URL to the workflow run.", default=...)
    workflow_id: int = Field(description="The ID of the parent workflow.", default=...)
    workflow_url: str = Field(description="The URL to the workflow.", default=...)
    run_attempt: int = Field(
        description="Attempt number of the run, 1 for first attempt and higher if the workflow was re-run.",
        default=...,
    )
    referenced_workflows: Union[Unset, List[ReferencedWorkflow]] = Field(default=UNSET)
    run_started_at: datetime = Field(
        description="The start time of the latest run. Resets on re-run.", default=...
    )
    previous_attempt_url: Union[str, None] = Field(
        description="The URL to the previous attempted run of this workflow, if one exists.",
        default=...,
    )
    actor: User = Field(title="User", default=...)
    triggering_actor: User = Field(title="User", default=...)


class WorkflowRun(GitHubWebhookModel):
    """Workflow Run"""

    artifacts_url: str = Field(
        description="The URL to the artifacts for the workflow run.", default=...
    )
    cancel_url: str = Field(
        description="The URL to cancel the workflow run.", default=...
    )
    check_suite_url: str = Field(
        description="The URL to the associated check suite.", default=...
    )
    check_suite_id: int = Field(
        description="The ID of the associated check suite.", default=...
    )
    check_suite_node_id: str = Field(
        description="The node ID of the associated check suite.", default=...
    )
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
            "skipped",
        ],
    ] = Field(default=...)
    created_at: datetime = Field(default=...)
    event: str = Field(default=...)
    head_branch: str = Field(default=...)
    head_commit: CommitSimple = Field(title="SimpleCommit", default=...)
    head_repository: RepositoryLite = Field(title="Repository Lite", default=...)
    head_sha: str = Field(
        description="The SHA of the head commit that points to the version of the workflow being run.",
        default=...,
    )
    path: str = Field(description="The full path of the workflow", default=...)
    display_title: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(description="The ID of the workflow run.", default=...)
    jobs_url: str = Field(
        description="The URL to the jobs for the workflow run.", default=...
    )
    logs_url: str = Field(
        description="The URL to download the logs for the workflow run.", default=...
    )
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the workflow run.", default=...)
    pull_requests: List[WorkflowRunPropPullRequestsItems] = Field(default=...)
    repository: RepositoryLite = Field(title="Repository Lite", default=...)
    rerun_url: str = Field(
        description="The URL to rerun the workflow run.", default=...
    )
    run_number: int = Field(
        description="The auto incrementing run number for the workflow run.",
        default=...,
    )
    status: Literal[
        "requested", "in_progress", "completed", "queued", "waiting"
    ] = Field(default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(description="The URL to the workflow run.", default=...)
    workflow_id: int = Field(description="The ID of the parent workflow.", default=...)
    workflow_url: str = Field(description="The URL to the workflow.", default=...)
    run_attempt: int = Field(
        description="Attempt number of the run, 1 for first attempt and higher if the workflow was re-run.",
        default=...,
    )
    referenced_workflows: Union[Unset, List[ReferencedWorkflow]] = Field(default=UNSET)
    run_started_at: datetime = Field(
        description="The start time of the latest run. Resets on re-run.", default=...
    )
    previous_attempt_url: Union[str, None] = Field(
        description="The URL to the previous attempted run of this workflow, if one exists.",
        default=...,
    )
    actor: User = Field(title="User", default=...)
    triggering_actor: User = Field(title="User", default=...)


class RepositoryLite(GitHubWebhookModel):
    """Repository Lite"""

    archive_url: str = Field(
        description="A template for the API URL to download the repository as an archive.",
        default=...,
    )
    assignees_url: str = Field(
        description="A template for the API URL to list the available assignees for issues in the repository.",
        default=...,
    )
    blobs_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git blob in the repository.",
        default=...,
    )
    branches_url: str = Field(
        description="A template for the API URL to get information about branches in the repository.",
        default=...,
    )
    collaborators_url: str = Field(
        description="A template for the API URL to get information about collaborators of the repository.",
        default=...,
    )
    comments_url: str = Field(
        description="A template for the API URL to get information about comments on the repository.",
        default=...,
    )
    commits_url: str = Field(
        description="A template for the API URL to get information about commits on the repository.",
        default=...,
    )
    compare_url: str = Field(
        description="A template for the API URL to compare two commits or refs.",
        default=...,
    )
    contents_url: str = Field(
        description="A template for the API URL to get the contents of the repository.",
        default=...,
    )
    contributors_url: str = Field(
        description="A template for the API URL to list the contributors to the repository.",
        default=...,
    )
    deployments_url: str = Field(
        description="The API URL to list the deployments of the repository.",
        default=...,
    )
    description: Union[str, None] = Field(
        description="The repository description.", default=...
    )
    downloads_url: str = Field(
        description="The API URL to list the downloads on the repository.", default=...
    )
    events_url: str = Field(
        description="The API URL to list the events of the repository.", default=...
    )
    fork: bool = Field(description="Whether the repository is a fork.", default=...)
    forks_url: str = Field(
        description="The API URL to list the forks of the repository.", default=...
    )
    full_name: str = Field(
        description="The full, globally unique, name of the repository.", default=...
    )
    git_commits_url: str = Field(
        description="A template for the API URL to get information about Git commits of the repository.",
        default=...,
    )
    git_refs_url: str = Field(
        description="A template for the API URL to get information about Git refs of the repository.",
        default=...,
    )
    git_tags_url: str = Field(
        description="A template for the API URL to get information about Git tags of the repository.",
        default=...,
    )
    hooks_url: str = Field(
        description="The API URL to list the hooks on the repository.", default=...
    )
    html_url: str = Field(
        description="The URL to view the repository on GitHub.com.", default=...
    )
    id: int = Field(description="Unique identifier of the repository", default=...)
    issue_comment_url: str = Field(
        description="A template for the API URL to get information about issue comments on the repository.",
        default=...,
    )
    issue_events_url: str = Field(
        description="A template for the API URL to get information about issue events on the repository.",
        default=...,
    )
    issues_url: str = Field(
        description="A template for the API URL to get information about issues on the repository.",
        default=...,
    )
    keys_url: str = Field(
        description="A template for the API URL to get information about deploy keys on the repository.",
        default=...,
    )
    labels_url: str = Field(
        description="A template for the API URL to get information about labels of the repository.",
        default=...,
    )
    languages_url: str = Field(
        description="The API URL to get information about the languages of the repository.",
        default=...,
    )
    merges_url: str = Field(
        description="The API URL to merge branches in the repository.", default=...
    )
    milestones_url: str = Field(
        description="A template for the API URL to get information about milestones of the repository.",
        default=...,
    )
    name: str = Field(description="The name of the repository.", default=...)
    node_id: str = Field(
        description="The GraphQL identifier of the repository.", default=...
    )
    notifications_url: str = Field(
        description="A template for the API URL to get information about notifications on the repository.",
        default=...,
    )
    owner: User = Field(title="User", default=...)
    private: bool = Field(
        description="Whether the repository is private or public.", default=...
    )
    pulls_url: str = Field(
        description="A template for the API URL to get information about pull requests on the repository.",
        default=...,
    )
    releases_url: str = Field(
        description="A template for the API URL to get information about releases on the repository.",
        default=...,
    )
    stargazers_url: str = Field(
        description="The API URL to list the stargazers on the repository.", default=...
    )
    statuses_url: str = Field(
        description="A template for the API URL to get information about statuses of a commit.",
        default=...,
    )
    subscribers_url: str = Field(
        description="The API URL to list the subscribers on the repository.",
        default=...,
    )
    subscription_url: str = Field(
        description="The API URL to subscribe to notifications for this repository.",
        default=...,
    )
    tags_url: str = Field(
        description="The API URL to get information about tags on the repository.",
        default=...,
    )
    teams_url: str = Field(
        description="The API URL to list the teams on the repository.", default=...
    )
    trees_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git tree of the repository.",
        default=...,
    )
    url: str = Field(
        description="The URL to get more information about the repository from the GitHub API.",
        default=...,
    )


class WorkflowRunPropPullRequestsItems(GitHubWebhookModel):
    """WorkflowRunPropPullRequestsItems"""

    url: str = Field(default=...)
    id: float = Field(default=...)
    number: float = Field(default=...)
    head: WorkflowRunPropPullRequestsItemsPropHead = Field(default=...)
    base: WorkflowRunPropPullRequestsItemsPropBase = Field(default=...)


class WorkflowRunPropPullRequestsItemsPropHead(GitHubWebhookModel):
    """WorkflowRunPropPullRequestsItemsPropHead"""

    ref: str = Field(default=...)
    sha: str = Field(default=...)
    repo: RepoRef = Field(title="Repo Ref", default=...)


class WorkflowRunPropPullRequestsItemsPropBase(GitHubWebhookModel):
    """WorkflowRunPropPullRequestsItemsPropBase"""

    ref: str = Field(default=...)
    sha: str = Field(default=...)
    repo: RepoRef = Field(title="Repo Ref", default=...)


class WorkflowRunCompletedPropWorkflowRunAllof1(GitHubWebhookModel):
    """WorkflowRunCompletedPropWorkflowRunAllof1"""

    conclusion: Literal[
        "success",
        "failure",
        "neutral",
        "cancelled",
        "timed_out",
        "action_required",
        "stale",
        "skipped",
    ] = Field(default=...)


class WorkflowRunInProgress(GitHubWebhookModel):
    """workflow_run in_progress event"""

    action: Literal["in_progress"] = Field(default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    workflow: Workflow = Field(title="Workflow", default=...)
    workflow_run: WorkflowRun = Field(title="Workflow Run", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


class WorkflowRunRequested(GitHubWebhookModel):
    """workflow_run requested event"""

    action: Literal["requested"] = Field(default=...)
    organization: Union[Unset, Organization] = Field(
        title="Organization", default=UNSET
    )
    repository: Repository = Field(
        title="Repository", description="A git repository", default=...
    )
    sender: User = Field(title="User", default=...)
    workflow: Workflow = Field(title="Workflow", default=...)
    workflow_run: WorkflowRun = Field(title="Workflow Run", default=...)
    installation: Union[Unset, InstallationLite] = Field(
        title="InstallationLite", description="Installation", default=UNSET
    )


BranchProtectionRuleCreated.update_forward_refs()
BranchProtectionRule.update_forward_refs()
Repository.update_forward_refs()
User.update_forward_refs()
License.update_forward_refs()
RepositoryPropPermissions.update_forward_refs()
InstallationLite.update_forward_refs()
Organization.update_forward_refs()
BranchProtectionRuleDeleted.update_forward_refs()
BranchProtectionRuleEdited.update_forward_refs()
BranchProtectionRuleEditedPropChanges.update_forward_refs()
BranchProtectionRuleEditedPropChangesPropAdminEnforced.update_forward_refs()
BranchProtectionRuleEditedPropChangesPropAllowDeletionsEnforcementLevel.update_forward_refs()
BranchProtectionRuleEditedPropChangesPropAllowForcePushesEnforcementLevel.update_forward_refs()
BranchProtectionRuleEditedPropChangesPropAuthorizedActorsOnly.update_forward_refs()
BranchProtectionRuleEditedPropChangesPropAuthorizedActorNames.update_forward_refs()
BranchProtectionRuleEditedPropChangesPropAuthorizedDismissalActorsOnly.update_forward_refs()
BranchProtectionRuleEditedPropChangesPropDismissStaleReviewsOnPush.update_forward_refs()
BranchProtectionRuleEditedPropChangesPropPullRequestReviewsEnforcementLevel.update_forward_refs()
BranchProtectionRuleEditedPropChangesPropRequireCodeOwnerReview.update_forward_refs()
BranchProtectionRuleEditedPropChangesPropRequiredApprovingReviewCount.update_forward_refs()
BranchProtectionRuleEditedPropChangesPropRequiredConversationResolutionLevel.update_forward_refs()
BranchProtectionRuleEditedPropChangesPropRequiredDeploymentsEnforcementLevel.update_forward_refs()
BranchProtectionRuleEditedPropChangesPropRequiredStatusChecks.update_forward_refs()
BranchProtectionRuleEditedPropChangesPropRequiredStatusChecksEnforcementLevel.update_forward_refs()
BranchProtectionRuleEditedPropChangesPropSignatureRequirementEnforcementLevel.update_forward_refs()
BranchProtectionRuleEditedPropChangesPropLinearHistoryRequirementEnforcementLevel.update_forward_refs()
CheckRunCompleted.update_forward_refs()
CheckRunCompletedPropCheckRun.update_forward_refs()
CheckRunCompletedPropCheckRunPropOutput.update_forward_refs()
CheckRunCompletedPropCheckRunPropCheckSuite.update_forward_refs()
CheckRunPullRequest.update_forward_refs()
CheckRunPullRequestPropHead.update_forward_refs()
RepoRef.update_forward_refs()
CheckRunPullRequestPropBase.update_forward_refs()
CheckRunDeployment.update_forward_refs()
App.update_forward_refs()
AppPropPermissions.update_forward_refs()
CheckRunCompletedPropRequestedAction.update_forward_refs()
CheckRunCreated.update_forward_refs()
CheckRunCreatedPropCheckRun.update_forward_refs()
CheckRunCreatedPropCheckRunPropOutput.update_forward_refs()
CheckRunCreatedPropCheckRunPropCheckSuite.update_forward_refs()
CheckRunCreatedPropRequestedAction.update_forward_refs()
CheckRunRequestedAction.update_forward_refs()
CheckRunRequestedActionPropCheckRun.update_forward_refs()
CheckRunRequestedActionPropCheckRunPropOutput.update_forward_refs()
CheckRunRequestedActionPropCheckRunPropCheckSuite.update_forward_refs()
CheckRunRequestedActionPropRequestedAction.update_forward_refs()
CheckRunRerequested.update_forward_refs()
CheckRunRerequestedPropCheckRun.update_forward_refs()
CheckRunRerequestedPropCheckRunPropOutput.update_forward_refs()
CheckRunRerequestedPropCheckRunPropCheckSuite.update_forward_refs()
CheckRunRerequestedPropRequestedAction.update_forward_refs()
CheckSuiteCompleted.update_forward_refs()
CheckSuiteCompletedPropCheckSuite.update_forward_refs()
CommitSimple.update_forward_refs()
Committer.update_forward_refs()
CheckSuiteRequested.update_forward_refs()
CheckSuiteRequestedPropCheckSuite.update_forward_refs()
CheckSuiteRerequested.update_forward_refs()
CheckSuiteRerequestedPropCheckSuite.update_forward_refs()
CodeScanningAlertAppearedInBranch.update_forward_refs()
CodeScanningAlertAppearedInBranchPropAlert.update_forward_refs()
AlertInstance.update_forward_refs()
AlertInstancePropMessage.update_forward_refs()
AlertInstancePropLocation.update_forward_refs()
CodeScanningAlertAppearedInBranchPropAlertPropRule.update_forward_refs()
CodeScanningAlertAppearedInBranchPropAlertPropTool.update_forward_refs()
GithubOrg.update_forward_refs()
CodeScanningAlertClosedByUser.update_forward_refs()
CodeScanningAlertClosedByUserPropAlert.update_forward_refs()
CodeScanningAlertClosedByUserPropAlertPropInstancesItems.update_forward_refs()
CodeScanningAlertClosedByUserPropAlertPropInstancesItemsAllof1.update_forward_refs()
CodeScanningAlertClosedByUserPropAlertPropRule.update_forward_refs()
CodeScanningAlertClosedByUserPropAlertPropTool.update_forward_refs()
CodeScanningAlertCreated.update_forward_refs()
CodeScanningAlertCreatedPropAlert.update_forward_refs()
CodeScanningAlertCreatedPropAlertPropInstancesItems.update_forward_refs()
CodeScanningAlertCreatedPropAlertPropInstancesItemsAllof1.update_forward_refs()
CodeScanningAlertCreatedPropAlertPropRule.update_forward_refs()
CodeScanningAlertCreatedPropAlertPropTool.update_forward_refs()
CodeScanningAlertFixed.update_forward_refs()
CodeScanningAlertFixedPropAlert.update_forward_refs()
CodeScanningAlertFixedPropAlertPropInstancesItems.update_forward_refs()
CodeScanningAlertFixedPropAlertPropInstancesItemsAllof1.update_forward_refs()
CodeScanningAlertFixedPropAlertPropRule.update_forward_refs()
CodeScanningAlertFixedPropAlertPropTool.update_forward_refs()
CodeScanningAlertReopened.update_forward_refs()
CodeScanningAlertReopenedPropAlert.update_forward_refs()
CodeScanningAlertReopenedPropAlertPropInstancesItems.update_forward_refs()
CodeScanningAlertReopenedPropAlertPropInstancesItemsAllof1.update_forward_refs()
CodeScanningAlertReopenedPropAlertPropRule.update_forward_refs()
CodeScanningAlertReopenedPropAlertPropTool.update_forward_refs()
CodeScanningAlertReopenedByUser.update_forward_refs()
CodeScanningAlertReopenedByUserPropAlert.update_forward_refs()
CodeScanningAlertReopenedByUserPropAlertPropInstancesItems.update_forward_refs()
CodeScanningAlertReopenedByUserPropAlertPropInstancesItemsAllof1.update_forward_refs()
CodeScanningAlertReopenedByUserPropAlertPropRule.update_forward_refs()
CodeScanningAlertReopenedByUserPropAlertPropTool.update_forward_refs()
CommitCommentCreated.update_forward_refs()
CommitCommentCreatedPropComment.update_forward_refs()
CreateEvent.update_forward_refs()
DeleteEvent.update_forward_refs()
DependabotAlertCreated.update_forward_refs()
DependabotAlertCreatedPropAlert.update_forward_refs()
DependabotAlert.update_forward_refs()
DependabotAlertPropDependency.update_forward_refs()
DependabotAlertPackage.update_forward_refs()
DependabotAlertPropSecurityAdvisory.update_forward_refs()
DependabotAlertPropSecurityAdvisoryPropVulnerabilitiesItems.update_forward_refs()
DependabotAlertPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersion.update_forward_refs()
SecurityAdvisoryCvss.update_forward_refs()
SecurityAdvisoryCwes.update_forward_refs()
DependabotAlertPropSecurityAdvisoryPropIdentifiersItems.update_forward_refs()
DependabotAlertPropSecurityAdvisoryPropReferencesItems.update_forward_refs()
DependabotAlertPropSecurityVulnerability.update_forward_refs()
DependabotAlertPropSecurityVulnerabilityPropFirstPatchedVersion.update_forward_refs()
DependabotAlertCreatedPropAlertAllof1.update_forward_refs()
DependabotAlertDismissed.update_forward_refs()
DependabotAlertDismissedPropAlert.update_forward_refs()
DependabotAlertDismissedPropAlertAllof1.update_forward_refs()
DependabotAlertFixed.update_forward_refs()
DependabotAlertFixedPropAlert.update_forward_refs()
DependabotAlertFixedPropAlertAllof1.update_forward_refs()
DependabotAlertReintroduced.update_forward_refs()
DependabotAlertReopened.update_forward_refs()
DeployKeyCreated.update_forward_refs()
DeployKeyCreatedPropKey.update_forward_refs()
DeployKeyDeleted.update_forward_refs()
DeployKeyDeletedPropKey.update_forward_refs()
DeploymentCreated.update_forward_refs()
Deployment.update_forward_refs()
DeploymentPropPayload.update_forward_refs()
Workflow.update_forward_refs()
DeploymentWorkflowRun.update_forward_refs()
ReferencedWorkflow.update_forward_refs()
DeploymentStatusCreated.update_forward_refs()
DeploymentStatusCreatedPropDeploymentStatus.update_forward_refs()
DeploymentStatusCreatedPropCheckRun.update_forward_refs()
DiscussionAnswered.update_forward_refs()
DiscussionAnsweredPropDiscussion.update_forward_refs()
Discussion.update_forward_refs()
DiscussionPropCategory.update_forward_refs()
Reactions.update_forward_refs()
DiscussionAnsweredPropDiscussionAllof1.update_forward_refs()
DiscussionAnsweredPropDiscussionAllof1PropCategory.update_forward_refs()
DiscussionAnsweredPropDiscussionMergedCategory.update_forward_refs()
DiscussionAnsweredPropAnswer.update_forward_refs()
DiscussionCategoryChanged.update_forward_refs()
DiscussionCategoryChangedPropChanges.update_forward_refs()
DiscussionCategoryChangedPropChangesPropCategory.update_forward_refs()
DiscussionCategoryChangedPropChangesPropCategoryPropFrom.update_forward_refs()
DiscussionCreated.update_forward_refs()
DiscussionCreatedPropDiscussion.update_forward_refs()
DiscussionCreatedPropDiscussionAllof1.update_forward_refs()
DiscussionDeleted.update_forward_refs()
DiscussionEdited.update_forward_refs()
DiscussionEditedPropChanges.update_forward_refs()
DiscussionEditedPropChangesPropTitle.update_forward_refs()
DiscussionEditedPropChangesPropBody.update_forward_refs()
DiscussionLabeled.update_forward_refs()
Label.update_forward_refs()
DiscussionLocked.update_forward_refs()
DiscussionLockedPropDiscussion.update_forward_refs()
DiscussionLockedPropDiscussionAllof1.update_forward_refs()
DiscussionPinned.update_forward_refs()
DiscussionTransferred.update_forward_refs()
DiscussionTransferredPropChanges.update_forward_refs()
DiscussionUnanswered.update_forward_refs()
DiscussionUnansweredPropDiscussion.update_forward_refs()
DiscussionUnansweredPropDiscussionAllof1.update_forward_refs()
DiscussionUnansweredPropDiscussionAllof1PropCategory.update_forward_refs()
DiscussionUnansweredPropDiscussionMergedCategory.update_forward_refs()
DiscussionUnansweredPropOldAnswer.update_forward_refs()
DiscussionUnlabeled.update_forward_refs()
DiscussionUnlocked.update_forward_refs()
DiscussionUnlockedPropDiscussion.update_forward_refs()
DiscussionUnlockedPropDiscussionAllof1.update_forward_refs()
DiscussionUnpinned.update_forward_refs()
DiscussionCommentCreated.update_forward_refs()
DiscussionCommentCreatedPropComment.update_forward_refs()
DiscussionCommentDeleted.update_forward_refs()
DiscussionCommentDeletedPropComment.update_forward_refs()
DiscussionCommentEdited.update_forward_refs()
DiscussionCommentEditedPropChanges.update_forward_refs()
DiscussionCommentEditedPropChangesPropBody.update_forward_refs()
DiscussionCommentEditedPropComment.update_forward_refs()
ForkEvent.update_forward_refs()
ForkEventPropForkee.update_forward_refs()
ForkEventPropForkeeAllof1.update_forward_refs()
GithubAppAuthorizationRevoked.update_forward_refs()
GollumEvent.update_forward_refs()
GollumEventPropPagesItems.update_forward_refs()
InstallationCreated.update_forward_refs()
Installation.update_forward_refs()
InstallationPropPermissions.update_forward_refs()
InstallationCreatedPropRepositoriesItems.update_forward_refs()
InstallationDeleted.update_forward_refs()
InstallationDeletedPropRepositoriesItems.update_forward_refs()
InstallationNewPermissionsAccepted.update_forward_refs()
InstallationNewPermissionsAcceptedPropRepositoriesItems.update_forward_refs()
InstallationSuspend.update_forward_refs()
InstallationSuspendPropInstallation.update_forward_refs()
InstallationSuspendPropInstallationAllof1.update_forward_refs()
InstallationSuspendPropRepositoriesItems.update_forward_refs()
InstallationUnsuspend.update_forward_refs()
InstallationUnsuspendPropInstallation.update_forward_refs()
InstallationUnsuspendPropInstallationAllof1.update_forward_refs()
InstallationUnsuspendPropRepositoriesItems.update_forward_refs()
InstallationRepositoriesAdded.update_forward_refs()
InstallationRepositoriesAddedPropRepositoriesAddedItems.update_forward_refs()
InstallationRepositoriesAddedPropRepositoriesRemovedItems.update_forward_refs()
InstallationRepositoriesRemoved.update_forward_refs()
InstallationRepositoriesRemovedPropRepositoriesAddedItems.update_forward_refs()
InstallationRepositoriesRemovedPropRepositoriesRemovedItems.update_forward_refs()
IssueCommentCreated.update_forward_refs()
IssueCommentCreatedPropIssue.update_forward_refs()
Issue.update_forward_refs()
Milestone.update_forward_refs()
IssuePropPullRequest.update_forward_refs()
IssueCommentCreatedPropIssueAllof1.update_forward_refs()
IssueComment.update_forward_refs()
IssueCommentDeleted.update_forward_refs()
IssueCommentDeletedPropIssue.update_forward_refs()
IssueCommentDeletedPropIssueAllof1.update_forward_refs()
IssueCommentEdited.update_forward_refs()
IssueCommentEditedPropChanges.update_forward_refs()
IssueCommentEditedPropChangesPropBody.update_forward_refs()
IssueCommentEditedPropIssue.update_forward_refs()
IssueCommentEditedPropIssueAllof1.update_forward_refs()
IssuesAssigned.update_forward_refs()
IssuesClosed.update_forward_refs()
IssuesClosedPropIssue.update_forward_refs()
IssuesClosedPropIssueAllof1.update_forward_refs()
IssuesDeleted.update_forward_refs()
IssuesDemilestoned.update_forward_refs()
IssuesDemilestonedPropIssue.update_forward_refs()
IssuesDemilestonedPropIssueAllof1.update_forward_refs()
IssuesEdited.update_forward_refs()
IssuesEditedPropChanges.update_forward_refs()
IssuesEditedPropChangesPropBody.update_forward_refs()
IssuesEditedPropChangesPropTitle.update_forward_refs()
IssuesLabeled.update_forward_refs()
IssuesLocked.update_forward_refs()
IssuesLockedPropIssue.update_forward_refs()
IssuesLockedPropIssueAllof1.update_forward_refs()
IssuesMilestoned.update_forward_refs()
IssuesMilestonedPropIssue.update_forward_refs()
IssuesMilestonedPropIssueAllof1.update_forward_refs()
IssuesOpened.update_forward_refs()
IssuesOpenedPropChanges.update_forward_refs()
IssuesOpenedPropIssue.update_forward_refs()
IssuesOpenedPropIssueAllof1.update_forward_refs()
IssuesPinned.update_forward_refs()
IssuesReopened.update_forward_refs()
IssuesReopenedPropIssue.update_forward_refs()
IssuesReopenedPropIssueAllof1.update_forward_refs()
IssuesTransferred.update_forward_refs()
IssuesTransferredPropChanges.update_forward_refs()
IssuesUnassigned.update_forward_refs()
IssuesUnlabeled.update_forward_refs()
IssuesUnlocked.update_forward_refs()
IssuesUnlockedPropIssue.update_forward_refs()
IssuesUnlockedPropIssueAllof1.update_forward_refs()
IssuesUnpinned.update_forward_refs()
LabelCreated.update_forward_refs()
LabelDeleted.update_forward_refs()
LabelEdited.update_forward_refs()
LabelEditedPropChanges.update_forward_refs()
LabelEditedPropChangesPropColor.update_forward_refs()
LabelEditedPropChangesPropName.update_forward_refs()
LabelEditedPropChangesPropDescription.update_forward_refs()
MarketplacePurchaseCancelled.update_forward_refs()
MarketplacePurchaseCancelledPropSender.update_forward_refs()
MarketplacePurchaseCancelledPropMarketplacePurchase.update_forward_refs()
MarketplacePurchase.update_forward_refs()
MarketplacePurchasePropAccount.update_forward_refs()
MarketplacePurchasePropPlan.update_forward_refs()
MarketplacePurchaseCancelledPropMarketplacePurchaseAllof1.update_forward_refs()
MarketplacePurchaseChanged.update_forward_refs()
MarketplacePurchaseChangedPropSender.update_forward_refs()
MarketplacePurchaseChangedPropMarketplacePurchase.update_forward_refs()
MarketplacePurchaseChangedPropMarketplacePurchaseAllof1.update_forward_refs()
MarketplacePurchasePendingChange.update_forward_refs()
MarketplacePurchasePendingChangePropSender.update_forward_refs()
MarketplacePurchasePendingChangePropMarketplacePurchase.update_forward_refs()
MarketplacePurchasePendingChangePropMarketplacePurchaseAllof1.update_forward_refs()
MarketplacePurchasePendingChangeCancelled.update_forward_refs()
MarketplacePurchasePendingChangeCancelledPropSender.update_forward_refs()
MarketplacePurchasePendingChangeCancelledPropMarketplacePurchase.update_forward_refs()
MarketplacePurchasePendingChangeCancelledPropMarketplacePurchaseAllof1.update_forward_refs()
MarketplacePurchasePurchased.update_forward_refs()
MarketplacePurchasePurchasedPropSender.update_forward_refs()
MarketplacePurchasePurchasedPropMarketplacePurchase.update_forward_refs()
MarketplacePurchasePurchasedPropMarketplacePurchaseAllof1.update_forward_refs()
MemberAdded.update_forward_refs()
MemberAddedPropChanges.update_forward_refs()
MemberAddedPropChangesPropPermission.update_forward_refs()
MemberEdited.update_forward_refs()
MemberEditedPropChanges.update_forward_refs()
MemberEditedPropChangesPropOldPermission.update_forward_refs()
MemberRemoved.update_forward_refs()
MembershipAdded.update_forward_refs()
Team.update_forward_refs()
TeamPropParent.update_forward_refs()
MembershipRemoved.update_forward_refs()
MembershipRemovedPropTeamOneof1.update_forward_refs()
MergeGroupChecksRequested.update_forward_refs()
MergeGroupChecksRequestedPropMergeGroup.update_forward_refs()
MetaDeleted.update_forward_refs()
MetaDeletedPropHook.update_forward_refs()
MetaDeletedPropHookPropConfig.update_forward_refs()
MilestoneClosed.update_forward_refs()
MilestoneClosedPropMilestone.update_forward_refs()
MilestoneClosedPropMilestoneAllof1.update_forward_refs()
MilestoneCreated.update_forward_refs()
MilestoneCreatedPropMilestone.update_forward_refs()
MilestoneCreatedPropMilestoneAllof1.update_forward_refs()
MilestoneDeleted.update_forward_refs()
MilestoneEdited.update_forward_refs()
MilestoneEditedPropChanges.update_forward_refs()
MilestoneEditedPropChangesPropDescription.update_forward_refs()
MilestoneEditedPropChangesPropDueOn.update_forward_refs()
MilestoneEditedPropChangesPropTitle.update_forward_refs()
MilestoneOpened.update_forward_refs()
MilestoneOpenedPropMilestone.update_forward_refs()
MilestoneOpenedPropMilestoneAllof1.update_forward_refs()
OrgBlockBlocked.update_forward_refs()
OrgBlockUnblocked.update_forward_refs()
OrganizationDeleted.update_forward_refs()
Membership.update_forward_refs()
OrganizationMemberAdded.update_forward_refs()
OrganizationMemberInvited.update_forward_refs()
OrganizationMemberInvitedPropInvitation.update_forward_refs()
OrganizationMemberRemoved.update_forward_refs()
OrganizationRenamed.update_forward_refs()
PackagePublished.update_forward_refs()
PackagePublishedPropPackage.update_forward_refs()
PackagePublishedPropPackagePropPackageVersion.update_forward_refs()
PackagePublishedPropPackagePropPackageVersionPropRelease.update_forward_refs()
PackagePublishedPropPackagePropPackageVersionPropPackageFilesItems.update_forward_refs()
PackagePublishedPropPackagePropRegistry.update_forward_refs()
PackageUpdated.update_forward_refs()
PackageUpdatedPropPackage.update_forward_refs()
PackageUpdatedPropPackagePropPackageVersion.update_forward_refs()
PackageUpdatedPropPackagePropPackageVersionPropRelease.update_forward_refs()
PackageUpdatedPropPackagePropPackageVersionPropPackageFilesItems.update_forward_refs()
PackageUpdatedPropPackagePropRegistry.update_forward_refs()
PageBuildEvent.update_forward_refs()
PageBuildEventPropBuild.update_forward_refs()
PageBuildEventPropBuildPropError.update_forward_refs()
PingEvent.update_forward_refs()
PingEventPropHook.update_forward_refs()
PingEventPropHookPropConfig.update_forward_refs()
PingEventPropHookPropLastResponse.update_forward_refs()
ProjectClosed.update_forward_refs()
Project.update_forward_refs()
ProjectCreated.update_forward_refs()
ProjectDeleted.update_forward_refs()
ProjectEdited.update_forward_refs()
ProjectEditedPropChanges.update_forward_refs()
ProjectEditedPropChangesPropName.update_forward_refs()
ProjectEditedPropChangesPropBody.update_forward_refs()
ProjectReopened.update_forward_refs()
ProjectCardConverted.update_forward_refs()
ProjectCardConvertedPropChanges.update_forward_refs()
ProjectCardConvertedPropChangesPropNote.update_forward_refs()
ProjectCard.update_forward_refs()
ProjectCardCreated.update_forward_refs()
ProjectCardDeleted.update_forward_refs()
ProjectCardEdited.update_forward_refs()
ProjectCardEditedPropChanges.update_forward_refs()
ProjectCardEditedPropChangesPropNote.update_forward_refs()
ProjectCardMoved.update_forward_refs()
ProjectCardMovedPropChanges.update_forward_refs()
ProjectCardMovedPropChangesPropColumnId.update_forward_refs()
ProjectCardMovedPropProjectCard.update_forward_refs()
ProjectCardMovedPropProjectCardAllof1.update_forward_refs()
ProjectColumnCreated.update_forward_refs()
ProjectColumn.update_forward_refs()
ProjectColumnDeleted.update_forward_refs()
ProjectColumnEdited.update_forward_refs()
ProjectColumnEditedPropChanges.update_forward_refs()
ProjectColumnEditedPropChangesPropName.update_forward_refs()
ProjectColumnMoved.update_forward_refs()
ProjectsV2ItemArchived.update_forward_refs()
ProjectsV2ItemArchivedPropChanges.update_forward_refs()
ProjectsV2ItemArchivedPropChangesPropArchivedAt.update_forward_refs()
ProjectsV2ItemArchivedPropProjectsV2Item.update_forward_refs()
ProjectsV2Item.update_forward_refs()
ProjectsV2ItemArchivedPropProjectsV2ItemAllof1.update_forward_refs()
ProjectsV2ItemConverted.update_forward_refs()
ProjectsV2ItemConvertedPropChanges.update_forward_refs()
ProjectsV2ItemConvertedPropChangesPropContentType.update_forward_refs()
ProjectsV2ItemConvertedPropProjectsV2Item.update_forward_refs()
ProjectsV2ItemConvertedPropProjectsV2ItemAllof1.update_forward_refs()
ProjectsV2ItemCreated.update_forward_refs()
ProjectsV2ItemCreatedPropProjectsV2Item.update_forward_refs()
ProjectsV2ItemCreatedPropProjectsV2ItemAllof1.update_forward_refs()
ProjectsV2ItemDeleted.update_forward_refs()
ProjectsV2ItemEdited.update_forward_refs()
ProjectsV2ItemEditedPropChanges.update_forward_refs()
ProjectsV2ItemEditedPropChangesPropFieldValue.update_forward_refs()
ProjectsV2ItemReordered.update_forward_refs()
ProjectsV2ItemReorderedPropChanges.update_forward_refs()
ProjectsV2ItemReorderedPropChangesPropPreviousProjectsV2ItemNodeId.update_forward_refs()
ProjectsV2ItemRestored.update_forward_refs()
ProjectsV2ItemRestoredPropChanges.update_forward_refs()
ProjectsV2ItemRestoredPropChangesPropArchivedAt.update_forward_refs()
ProjectsV2ItemRestoredPropProjectsV2Item.update_forward_refs()
ProjectsV2ItemRestoredPropProjectsV2ItemAllof1.update_forward_refs()
PublicEvent.update_forward_refs()
PublicEventPropRepository.update_forward_refs()
PublicEventPropRepositoryAllof1.update_forward_refs()
PullRequestAssigned.update_forward_refs()
PullRequest.update_forward_refs()
PullRequestPropHead.update_forward_refs()
PullRequestPropBase.update_forward_refs()
PullRequestPropLinks.update_forward_refs()
Link.update_forward_refs()
AutoMerge.update_forward_refs()
PullRequestAutoMergeDisabled.update_forward_refs()
PullRequestAutoMergeEnabled.update_forward_refs()
PullRequestClosed.update_forward_refs()
PullRequestClosedPropPullRequest.update_forward_refs()
PullRequestClosedPropPullRequestAllof1.update_forward_refs()
PullRequestConvertedToDraft.update_forward_refs()
PullRequestConvertedToDraftPropPullRequest.update_forward_refs()
PullRequestConvertedToDraftPropPullRequestAllof1.update_forward_refs()
PullRequestDequeued.update_forward_refs()
PullRequestEdited.update_forward_refs()
PullRequestEditedPropChanges.update_forward_refs()
PullRequestEditedPropChangesPropBody.update_forward_refs()
PullRequestEditedPropChangesPropTitle.update_forward_refs()
PullRequestEditedPropChangesPropBase.update_forward_refs()
PullRequestEditedPropChangesPropBasePropRef.update_forward_refs()
PullRequestEditedPropChangesPropBasePropSha.update_forward_refs()
PullRequestLabeled.update_forward_refs()
PullRequestLocked.update_forward_refs()
PullRequestOpened.update_forward_refs()
PullRequestOpenedPropPullRequest.update_forward_refs()
PullRequestOpenedPropPullRequestAllof1.update_forward_refs()
PullRequestQueued.update_forward_refs()
PullRequestReadyForReview.update_forward_refs()
PullRequestReadyForReviewPropPullRequest.update_forward_refs()
PullRequestReadyForReviewPropPullRequestAllof1.update_forward_refs()
PullRequestReopened.update_forward_refs()
PullRequestReopenedPropPullRequest.update_forward_refs()
PullRequestReopenedPropPullRequestAllof1.update_forward_refs()
PullRequestReviewRequestRemovedOneof0.update_forward_refs()
PullRequestReviewRequestRemovedOneof1.update_forward_refs()
PullRequestReviewRequestedOneof0.update_forward_refs()
PullRequestReviewRequestedOneof1.update_forward_refs()
PullRequestSynchronize.update_forward_refs()
PullRequestUnassigned.update_forward_refs()
PullRequestUnlabeled.update_forward_refs()
PullRequestUnlocked.update_forward_refs()
PullRequestReviewDismissed.update_forward_refs()
PullRequestReviewDismissedPropReview.update_forward_refs()
PullRequestReview.update_forward_refs()
PullRequestReviewPropLinks.update_forward_refs()
PullRequestReviewDismissedPropReviewAllof1.update_forward_refs()
SimplePullRequest.update_forward_refs()
SimplePullRequestPropHead.update_forward_refs()
SimplePullRequestPropBase.update_forward_refs()
SimplePullRequestPropLinks.update_forward_refs()
PullRequestReviewEdited.update_forward_refs()
PullRequestReviewEditedPropChanges.update_forward_refs()
PullRequestReviewEditedPropChangesPropBody.update_forward_refs()
PullRequestReviewSubmitted.update_forward_refs()
PullRequestReviewCommentCreated.update_forward_refs()
PullRequestReviewComment.update_forward_refs()
PullRequestReviewCommentPropLinks.update_forward_refs()
PullRequestReviewCommentCreatedPropPullRequest.update_forward_refs()
PullRequestReviewCommentCreatedPropPullRequestPropHead.update_forward_refs()
PullRequestReviewCommentCreatedPropPullRequestPropBase.update_forward_refs()
PullRequestReviewCommentCreatedPropPullRequestPropLinks.update_forward_refs()
PullRequestReviewCommentDeleted.update_forward_refs()
PullRequestReviewCommentDeletedPropPullRequest.update_forward_refs()
PullRequestReviewCommentDeletedPropPullRequestPropHead.update_forward_refs()
PullRequestReviewCommentDeletedPropPullRequestPropBase.update_forward_refs()
PullRequestReviewCommentDeletedPropPullRequestPropLinks.update_forward_refs()
PullRequestReviewCommentEdited.update_forward_refs()
PullRequestReviewCommentEditedPropChanges.update_forward_refs()
PullRequestReviewCommentEditedPropChangesPropBody.update_forward_refs()
PullRequestReviewCommentEditedPropPullRequest.update_forward_refs()
PullRequestReviewCommentEditedPropPullRequestPropHead.update_forward_refs()
PullRequestReviewCommentEditedPropPullRequestPropBase.update_forward_refs()
PullRequestReviewCommentEditedPropPullRequestPropLinks.update_forward_refs()
PullRequestReviewThreadResolved.update_forward_refs()
PullRequestReviewThreadResolvedPropThread.update_forward_refs()
PullRequestReviewThreadUnresolved.update_forward_refs()
PullRequestReviewThreadUnresolvedPropThread.update_forward_refs()
PushEvent.update_forward_refs()
Commit.update_forward_refs()
ReleaseCreated.update_forward_refs()
Release.update_forward_refs()
ReleaseAsset.update_forward_refs()
ReleaseDeleted.update_forward_refs()
ReleaseEdited.update_forward_refs()
ReleaseEditedPropChanges.update_forward_refs()
ReleaseEditedPropChangesPropBody.update_forward_refs()
ReleaseEditedPropChangesPropName.update_forward_refs()
ReleasePrereleased.update_forward_refs()
ReleasePrereleasedPropRelease.update_forward_refs()
ReleasePrereleasedPropReleaseAllof1.update_forward_refs()
ReleasePublished.update_forward_refs()
ReleasePublishedPropRelease.update_forward_refs()
ReleasePublishedPropReleaseAllof1.update_forward_refs()
ReleaseReleased.update_forward_refs()
ReleaseUnpublished.update_forward_refs()
ReleaseUnpublishedPropRelease.update_forward_refs()
ReleaseUnpublishedPropReleaseAllof1.update_forward_refs()
RepositoryArchived.update_forward_refs()
RepositoryArchivedPropRepository.update_forward_refs()
RepositoryArchivedPropRepositoryAllof1.update_forward_refs()
RepositoryCreated.update_forward_refs()
RepositoryDeleted.update_forward_refs()
RepositoryEdited.update_forward_refs()
RepositoryEditedPropChanges.update_forward_refs()
RepositoryEditedPropChangesPropDescription.update_forward_refs()
RepositoryEditedPropChangesPropDefaultBranch.update_forward_refs()
RepositoryEditedPropChangesPropHomepage.update_forward_refs()
RepositoryPrivatized.update_forward_refs()
RepositoryPrivatizedPropRepository.update_forward_refs()
RepositoryPrivatizedPropRepositoryAllof1.update_forward_refs()
RepositoryPublicized.update_forward_refs()
RepositoryPublicizedPropRepository.update_forward_refs()
RepositoryPublicizedPropRepositoryAllof1.update_forward_refs()
RepositoryRenamed.update_forward_refs()
RepositoryRenamedPropChanges.update_forward_refs()
RepositoryRenamedPropChangesPropRepository.update_forward_refs()
RepositoryRenamedPropChangesPropRepositoryPropName.update_forward_refs()
RepositoryTransferred.update_forward_refs()
RepositoryTransferredPropChanges.update_forward_refs()
RepositoryTransferredPropChangesPropOwner.update_forward_refs()
RepositoryTransferredPropChangesPropOwnerPropFrom.update_forward_refs()
RepositoryUnarchived.update_forward_refs()
RepositoryUnarchivedPropRepository.update_forward_refs()
RepositoryUnarchivedPropRepositoryAllof1.update_forward_refs()
RepositoryDispatchEvent.update_forward_refs()
RepositoryDispatchEventPropClientPayload.update_forward_refs()
RepositoryImportEvent.update_forward_refs()
RepositoryVulnerabilityAlertCreate.update_forward_refs()
RepositoryVulnerabilityAlertCreatePropAlert.update_forward_refs()
RepositoryVulnerabilityAlertAlert.update_forward_refs()
RepositoryVulnerabilityAlertCreatePropAlertAllof1.update_forward_refs()
RepositoryVulnerabilityAlertDismiss.update_forward_refs()
RepositoryVulnerabilityAlertDismissPropAlert.update_forward_refs()
RepositoryVulnerabilityAlertDismissPropAlertAllof1.update_forward_refs()
RepositoryVulnerabilityAlertReopen.update_forward_refs()
RepositoryVulnerabilityAlertReopenPropAlert.update_forward_refs()
RepositoryVulnerabilityAlertReopenPropAlertAllof1.update_forward_refs()
RepositoryVulnerabilityAlertResolve.update_forward_refs()
RepositoryVulnerabilityAlertResolvePropAlert.update_forward_refs()
RepositoryVulnerabilityAlertResolvePropAlertAllof1.update_forward_refs()
SecretScanningAlertCreated.update_forward_refs()
SecretScanningAlertCreatedPropAlert.update_forward_refs()
SecretScanningAlertReopened.update_forward_refs()
SecretScanningAlertReopenedPropAlert.update_forward_refs()
SecretScanningAlertResolved.update_forward_refs()
SecretScanningAlertResolvedPropAlert.update_forward_refs()
SecurityAdvisoryPerformed.update_forward_refs()
SecurityAdvisoryPerformedPropSecurityAdvisory.update_forward_refs()
SecurityAdvisoryPerformedPropSecurityAdvisoryPropCvss.update_forward_refs()
SecurityAdvisoryPerformedPropSecurityAdvisoryPropCwesItems.update_forward_refs()
SecurityAdvisoryPerformedPropSecurityAdvisoryPropIdentifiersItems.update_forward_refs()
SecurityAdvisoryPerformedPropSecurityAdvisoryPropReferencesItems.update_forward_refs()
SecurityAdvisoryPerformedPropSecurityAdvisoryPropVulnerabilitiesItems.update_forward_refs()
SecurityAdvisoryPerformedPropSecurityAdvisoryPropVulnerabilitiesItemsPropPackage.update_forward_refs()
SecurityAdvisoryPerformedPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersion.update_forward_refs()
SecurityAdvisoryPublished.update_forward_refs()
SecurityAdvisoryPublishedPropSecurityAdvisory.update_forward_refs()
SecurityAdvisoryPublishedPropSecurityAdvisoryPropCvss.update_forward_refs()
SecurityAdvisoryPublishedPropSecurityAdvisoryPropCwesItems.update_forward_refs()
SecurityAdvisoryPublishedPropSecurityAdvisoryPropIdentifiersItems.update_forward_refs()
SecurityAdvisoryPublishedPropSecurityAdvisoryPropReferencesItems.update_forward_refs()
SecurityAdvisoryPublishedPropSecurityAdvisoryPropVulnerabilitiesItems.update_forward_refs()
SecurityAdvisoryPublishedPropSecurityAdvisoryPropVulnerabilitiesItemsPropPackage.update_forward_refs()
SecurityAdvisoryPublishedPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersion.update_forward_refs()
SecurityAdvisoryUpdated.update_forward_refs()
SecurityAdvisoryUpdatedPropSecurityAdvisory.update_forward_refs()
SecurityAdvisoryUpdatedPropSecurityAdvisoryPropCvss.update_forward_refs()
SecurityAdvisoryUpdatedPropSecurityAdvisoryPropCwesItems.update_forward_refs()
SecurityAdvisoryUpdatedPropSecurityAdvisoryPropIdentifiersItems.update_forward_refs()
SecurityAdvisoryUpdatedPropSecurityAdvisoryPropReferencesItems.update_forward_refs()
SecurityAdvisoryUpdatedPropSecurityAdvisoryPropVulnerabilitiesItems.update_forward_refs()
SecurityAdvisoryUpdatedPropSecurityAdvisoryPropVulnerabilitiesItemsPropPackage.update_forward_refs()
SecurityAdvisoryUpdatedPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersion.update_forward_refs()
SecurityAdvisoryWithdrawn.update_forward_refs()
SecurityAdvisoryWithdrawnPropSecurityAdvisory.update_forward_refs()
SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropCvss.update_forward_refs()
SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropCwesItems.update_forward_refs()
SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropIdentifiersItems.update_forward_refs()
SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropReferencesItems.update_forward_refs()
SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropVulnerabilitiesItems.update_forward_refs()
SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropVulnerabilitiesItemsPropPackage.update_forward_refs()
SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersion.update_forward_refs()
SponsorshipCancelled.update_forward_refs()
SponsorshipCancelledPropSponsorship.update_forward_refs()
SponsorshipTier.update_forward_refs()
SponsorshipCreated.update_forward_refs()
SponsorshipCreatedPropSponsorship.update_forward_refs()
SponsorshipEdited.update_forward_refs()
SponsorshipEditedPropSponsorship.update_forward_refs()
SponsorshipEditedPropChanges.update_forward_refs()
SponsorshipEditedPropChangesPropPrivacyLevel.update_forward_refs()
SponsorshipPendingCancellation.update_forward_refs()
SponsorshipPendingCancellationPropSponsorship.update_forward_refs()
SponsorshipPendingTierChange.update_forward_refs()
SponsorshipPendingTierChangePropSponsorship.update_forward_refs()
SponsorshipPendingTierChangePropChanges.update_forward_refs()
SponsorshipPendingTierChangePropChangesPropTier.update_forward_refs()
SponsorshipTierChanged.update_forward_refs()
SponsorshipTierChangedPropSponsorship.update_forward_refs()
SponsorshipTierChangedPropChanges.update_forward_refs()
SponsorshipTierChangedPropChangesPropTier.update_forward_refs()
StarCreated.update_forward_refs()
StarDeleted.update_forward_refs()
StatusEvent.update_forward_refs()
StatusEventPropCommit.update_forward_refs()
StatusEventPropCommitPropCommit.update_forward_refs()
StatusEventPropCommitPropCommitPropAuthor.update_forward_refs()
StatusEventPropCommitPropCommitPropAuthorAllof1.update_forward_refs()
StatusEventPropCommitPropCommitPropCommitter.update_forward_refs()
StatusEventPropCommitPropCommitPropCommitterAllof1.update_forward_refs()
StatusEventPropCommitPropCommitPropTree.update_forward_refs()
StatusEventPropCommitPropCommitPropVerification.update_forward_refs()
StatusEventPropCommitPropParentsItems.update_forward_refs()
StatusEventPropBranchesItems.update_forward_refs()
StatusEventPropBranchesItemsPropCommit.update_forward_refs()
TeamAddedToRepository.update_forward_refs()
TeamCreated.update_forward_refs()
TeamDeleted.update_forward_refs()
TeamEdited.update_forward_refs()
TeamEditedPropChanges.update_forward_refs()
TeamEditedPropChangesPropDescription.update_forward_refs()
TeamEditedPropChangesPropName.update_forward_refs()
TeamEditedPropChangesPropPrivacy.update_forward_refs()
TeamEditedPropChangesPropRepository.update_forward_refs()
TeamEditedPropChangesPropRepositoryPropPermissions.update_forward_refs()
TeamEditedPropChangesPropRepositoryPropPermissionsPropFrom.update_forward_refs()
TeamRemovedFromRepository.update_forward_refs()
TeamAddEvent.update_forward_refs()
WatchStarted.update_forward_refs()
WorkflowDispatchEvent.update_forward_refs()
WorkflowDispatchEventPropInputsOneof0.update_forward_refs()
WorkflowJobCompleted.update_forward_refs()
WorkflowJobCompletedPropWorkflowJob.update_forward_refs()
WorkflowJob.update_forward_refs()
WorkflowStepInProgress.update_forward_refs()
WorkflowStepCompleted.update_forward_refs()
WorkflowJobCompletedPropWorkflowJobAllof1.update_forward_refs()
WorkflowJobInProgress.update_forward_refs()
WorkflowJobInProgressPropWorkflowJob.update_forward_refs()
WorkflowJobInProgressPropWorkflowJobAllof1.update_forward_refs()
WorkflowJobQueued.update_forward_refs()
WorkflowJobQueuedPropWorkflowJob.update_forward_refs()
WorkflowJobQueuedPropWorkflowJobAllof1.update_forward_refs()
WorkflowRunCompleted.update_forward_refs()
WorkflowRunCompletedPropWorkflowRun.update_forward_refs()
WorkflowRun.update_forward_refs()
RepositoryLite.update_forward_refs()
WorkflowRunPropPullRequestsItems.update_forward_refs()
WorkflowRunPropPullRequestsItemsPropHead.update_forward_refs()
WorkflowRunPropPullRequestsItemsPropBase.update_forward_refs()
WorkflowRunCompletedPropWorkflowRunAllof1.update_forward_refs()
WorkflowRunInProgress.update_forward_refs()
WorkflowRunRequested.update_forward_refs()

__all__ = [
    "GitHubWebhookModel",
    "BranchProtectionRuleCreated",
    "BranchProtectionRule",
    "Repository",
    "User",
    "License",
    "RepositoryPropPermissions",
    "InstallationLite",
    "Organization",
    "BranchProtectionRuleDeleted",
    "BranchProtectionRuleEdited",
    "BranchProtectionRuleEditedPropChanges",
    "BranchProtectionRuleEditedPropChangesPropAdminEnforced",
    "BranchProtectionRuleEditedPropChangesPropAllowDeletionsEnforcementLevel",
    "BranchProtectionRuleEditedPropChangesPropAllowForcePushesEnforcementLevel",
    "BranchProtectionRuleEditedPropChangesPropAuthorizedActorsOnly",
    "BranchProtectionRuleEditedPropChangesPropAuthorizedActorNames",
    "BranchProtectionRuleEditedPropChangesPropAuthorizedDismissalActorsOnly",
    "BranchProtectionRuleEditedPropChangesPropDismissStaleReviewsOnPush",
    "BranchProtectionRuleEditedPropChangesPropPullRequestReviewsEnforcementLevel",
    "BranchProtectionRuleEditedPropChangesPropRequireCodeOwnerReview",
    "BranchProtectionRuleEditedPropChangesPropRequiredApprovingReviewCount",
    "BranchProtectionRuleEditedPropChangesPropRequiredConversationResolutionLevel",
    "BranchProtectionRuleEditedPropChangesPropRequiredDeploymentsEnforcementLevel",
    "BranchProtectionRuleEditedPropChangesPropRequiredStatusChecks",
    "BranchProtectionRuleEditedPropChangesPropRequiredStatusChecksEnforcementLevel",
    "BranchProtectionRuleEditedPropChangesPropSignatureRequirementEnforcementLevel",
    "BranchProtectionRuleEditedPropChangesPropLinearHistoryRequirementEnforcementLevel",
    "CheckRunCompleted",
    "CheckRunCompletedPropCheckRun",
    "CheckRunCompletedPropCheckRunPropOutput",
    "CheckRunCompletedPropCheckRunPropCheckSuite",
    "CheckRunPullRequest",
    "CheckRunPullRequestPropHead",
    "RepoRef",
    "CheckRunPullRequestPropBase",
    "CheckRunDeployment",
    "App",
    "AppPropPermissions",
    "CheckRunCompletedPropRequestedAction",
    "CheckRunCreated",
    "CheckRunCreatedPropCheckRun",
    "CheckRunCreatedPropCheckRunPropOutput",
    "CheckRunCreatedPropCheckRunPropCheckSuite",
    "CheckRunCreatedPropRequestedAction",
    "CheckRunRequestedAction",
    "CheckRunRequestedActionPropCheckRun",
    "CheckRunRequestedActionPropCheckRunPropOutput",
    "CheckRunRequestedActionPropCheckRunPropCheckSuite",
    "CheckRunRequestedActionPropRequestedAction",
    "CheckRunRerequested",
    "CheckRunRerequestedPropCheckRun",
    "CheckRunRerequestedPropCheckRunPropOutput",
    "CheckRunRerequestedPropCheckRunPropCheckSuite",
    "CheckRunRerequestedPropRequestedAction",
    "CheckSuiteCompleted",
    "CheckSuiteCompletedPropCheckSuite",
    "CommitSimple",
    "Committer",
    "CheckSuiteRequested",
    "CheckSuiteRequestedPropCheckSuite",
    "CheckSuiteRerequested",
    "CheckSuiteRerequestedPropCheckSuite",
    "CodeScanningAlertAppearedInBranch",
    "CodeScanningAlertAppearedInBranchPropAlert",
    "AlertInstance",
    "AlertInstancePropMessage",
    "AlertInstancePropLocation",
    "CodeScanningAlertAppearedInBranchPropAlertPropRule",
    "CodeScanningAlertAppearedInBranchPropAlertPropTool",
    "GithubOrg",
    "CodeScanningAlertClosedByUser",
    "CodeScanningAlertClosedByUserPropAlert",
    "CodeScanningAlertClosedByUserPropAlertPropInstancesItems",
    "CodeScanningAlertClosedByUserPropAlertPropInstancesItemsAllof1",
    "CodeScanningAlertClosedByUserPropAlertPropRule",
    "CodeScanningAlertClosedByUserPropAlertPropTool",
    "CodeScanningAlertCreated",
    "CodeScanningAlertCreatedPropAlert",
    "CodeScanningAlertCreatedPropAlertPropInstancesItems",
    "CodeScanningAlertCreatedPropAlertPropInstancesItemsAllof1",
    "CodeScanningAlertCreatedPropAlertPropRule",
    "CodeScanningAlertCreatedPropAlertPropTool",
    "CodeScanningAlertFixed",
    "CodeScanningAlertFixedPropAlert",
    "CodeScanningAlertFixedPropAlertPropInstancesItems",
    "CodeScanningAlertFixedPropAlertPropInstancesItemsAllof1",
    "CodeScanningAlertFixedPropAlertPropRule",
    "CodeScanningAlertFixedPropAlertPropTool",
    "CodeScanningAlertReopened",
    "CodeScanningAlertReopenedPropAlert",
    "CodeScanningAlertReopenedPropAlertPropInstancesItems",
    "CodeScanningAlertReopenedPropAlertPropInstancesItemsAllof1",
    "CodeScanningAlertReopenedPropAlertPropRule",
    "CodeScanningAlertReopenedPropAlertPropTool",
    "CodeScanningAlertReopenedByUser",
    "CodeScanningAlertReopenedByUserPropAlert",
    "CodeScanningAlertReopenedByUserPropAlertPropInstancesItems",
    "CodeScanningAlertReopenedByUserPropAlertPropInstancesItemsAllof1",
    "CodeScanningAlertReopenedByUserPropAlertPropRule",
    "CodeScanningAlertReopenedByUserPropAlertPropTool",
    "CommitCommentCreated",
    "CommitCommentCreatedPropComment",
    "CreateEvent",
    "DeleteEvent",
    "DependabotAlertCreated",
    "DependabotAlertCreatedPropAlert",
    "DependabotAlert",
    "DependabotAlertPropDependency",
    "DependabotAlertPackage",
    "DependabotAlertPropSecurityAdvisory",
    "DependabotAlertPropSecurityAdvisoryPropVulnerabilitiesItems",
    "DependabotAlertPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersion",
    "SecurityAdvisoryCvss",
    "SecurityAdvisoryCwes",
    "DependabotAlertPropSecurityAdvisoryPropIdentifiersItems",
    "DependabotAlertPropSecurityAdvisoryPropReferencesItems",
    "DependabotAlertPropSecurityVulnerability",
    "DependabotAlertPropSecurityVulnerabilityPropFirstPatchedVersion",
    "DependabotAlertCreatedPropAlertAllof1",
    "DependabotAlertDismissed",
    "DependabotAlertDismissedPropAlert",
    "DependabotAlertDismissedPropAlertAllof1",
    "DependabotAlertFixed",
    "DependabotAlertFixedPropAlert",
    "DependabotAlertFixedPropAlertAllof1",
    "DependabotAlertReintroduced",
    "DependabotAlertReopened",
    "DeployKeyCreated",
    "DeployKeyCreatedPropKey",
    "DeployKeyDeleted",
    "DeployKeyDeletedPropKey",
    "DeploymentCreated",
    "Deployment",
    "DeploymentPropPayload",
    "Workflow",
    "DeploymentWorkflowRun",
    "ReferencedWorkflow",
    "DeploymentStatusCreated",
    "DeploymentStatusCreatedPropDeploymentStatus",
    "DeploymentStatusCreatedPropCheckRun",
    "DiscussionAnswered",
    "DiscussionAnsweredPropDiscussion",
    "Discussion",
    "DiscussionPropCategory",
    "Reactions",
    "DiscussionAnsweredPropDiscussionAllof1",
    "DiscussionAnsweredPropDiscussionAllof1PropCategory",
    "DiscussionAnsweredPropDiscussionMergedCategory",
    "DiscussionAnsweredPropAnswer",
    "DiscussionCategoryChanged",
    "DiscussionCategoryChangedPropChanges",
    "DiscussionCategoryChangedPropChangesPropCategory",
    "DiscussionCategoryChangedPropChangesPropCategoryPropFrom",
    "DiscussionCreated",
    "DiscussionCreatedPropDiscussion",
    "DiscussionCreatedPropDiscussionAllof1",
    "DiscussionDeleted",
    "DiscussionEdited",
    "DiscussionEditedPropChanges",
    "DiscussionEditedPropChangesPropTitle",
    "DiscussionEditedPropChangesPropBody",
    "DiscussionLabeled",
    "Label",
    "DiscussionLocked",
    "DiscussionLockedPropDiscussion",
    "DiscussionLockedPropDiscussionAllof1",
    "DiscussionPinned",
    "DiscussionTransferred",
    "DiscussionTransferredPropChanges",
    "DiscussionUnanswered",
    "DiscussionUnansweredPropDiscussion",
    "DiscussionUnansweredPropDiscussionAllof1",
    "DiscussionUnansweredPropDiscussionAllof1PropCategory",
    "DiscussionUnansweredPropDiscussionMergedCategory",
    "DiscussionUnansweredPropOldAnswer",
    "DiscussionUnlabeled",
    "DiscussionUnlocked",
    "DiscussionUnlockedPropDiscussion",
    "DiscussionUnlockedPropDiscussionAllof1",
    "DiscussionUnpinned",
    "DiscussionCommentCreated",
    "DiscussionCommentCreatedPropComment",
    "DiscussionCommentDeleted",
    "DiscussionCommentDeletedPropComment",
    "DiscussionCommentEdited",
    "DiscussionCommentEditedPropChanges",
    "DiscussionCommentEditedPropChangesPropBody",
    "DiscussionCommentEditedPropComment",
    "ForkEvent",
    "ForkEventPropForkee",
    "ForkEventPropForkeeAllof1",
    "GithubAppAuthorizationRevoked",
    "GollumEvent",
    "GollumEventPropPagesItems",
    "InstallationCreated",
    "Installation",
    "InstallationPropPermissions",
    "InstallationCreatedPropRepositoriesItems",
    "InstallationDeleted",
    "InstallationDeletedPropRepositoriesItems",
    "InstallationNewPermissionsAccepted",
    "InstallationNewPermissionsAcceptedPropRepositoriesItems",
    "InstallationSuspend",
    "InstallationSuspendPropInstallation",
    "InstallationSuspendPropInstallationAllof1",
    "InstallationSuspendPropRepositoriesItems",
    "InstallationUnsuspend",
    "InstallationUnsuspendPropInstallation",
    "InstallationUnsuspendPropInstallationAllof1",
    "InstallationUnsuspendPropRepositoriesItems",
    "InstallationRepositoriesAdded",
    "InstallationRepositoriesAddedPropRepositoriesAddedItems",
    "InstallationRepositoriesAddedPropRepositoriesRemovedItems",
    "InstallationRepositoriesRemoved",
    "InstallationRepositoriesRemovedPropRepositoriesAddedItems",
    "InstallationRepositoriesRemovedPropRepositoriesRemovedItems",
    "IssueCommentCreated",
    "IssueCommentCreatedPropIssue",
    "Issue",
    "Milestone",
    "IssuePropPullRequest",
    "IssueCommentCreatedPropIssueAllof1",
    "IssueComment",
    "IssueCommentDeleted",
    "IssueCommentDeletedPropIssue",
    "IssueCommentDeletedPropIssueAllof1",
    "IssueCommentEdited",
    "IssueCommentEditedPropChanges",
    "IssueCommentEditedPropChangesPropBody",
    "IssueCommentEditedPropIssue",
    "IssueCommentEditedPropIssueAllof1",
    "IssuesAssigned",
    "IssuesClosed",
    "IssuesClosedPropIssue",
    "IssuesClosedPropIssueAllof1",
    "IssuesDeleted",
    "IssuesDemilestoned",
    "IssuesDemilestonedPropIssue",
    "IssuesDemilestonedPropIssueAllof1",
    "IssuesEdited",
    "IssuesEditedPropChanges",
    "IssuesEditedPropChangesPropBody",
    "IssuesEditedPropChangesPropTitle",
    "IssuesLabeled",
    "IssuesLocked",
    "IssuesLockedPropIssue",
    "IssuesLockedPropIssueAllof1",
    "IssuesMilestoned",
    "IssuesMilestonedPropIssue",
    "IssuesMilestonedPropIssueAllof1",
    "IssuesOpened",
    "IssuesOpenedPropChanges",
    "IssuesOpenedPropIssue",
    "IssuesOpenedPropIssueAllof1",
    "IssuesPinned",
    "IssuesReopened",
    "IssuesReopenedPropIssue",
    "IssuesReopenedPropIssueAllof1",
    "IssuesTransferred",
    "IssuesTransferredPropChanges",
    "IssuesUnassigned",
    "IssuesUnlabeled",
    "IssuesUnlocked",
    "IssuesUnlockedPropIssue",
    "IssuesUnlockedPropIssueAllof1",
    "IssuesUnpinned",
    "LabelCreated",
    "LabelDeleted",
    "LabelEdited",
    "LabelEditedPropChanges",
    "LabelEditedPropChangesPropColor",
    "LabelEditedPropChangesPropName",
    "LabelEditedPropChangesPropDescription",
    "MarketplacePurchaseCancelled",
    "MarketplacePurchaseCancelledPropSender",
    "MarketplacePurchaseCancelledPropMarketplacePurchase",
    "MarketplacePurchase",
    "MarketplacePurchasePropAccount",
    "MarketplacePurchasePropPlan",
    "MarketplacePurchaseCancelledPropMarketplacePurchaseAllof1",
    "MarketplacePurchaseChanged",
    "MarketplacePurchaseChangedPropSender",
    "MarketplacePurchaseChangedPropMarketplacePurchase",
    "MarketplacePurchaseChangedPropMarketplacePurchaseAllof1",
    "MarketplacePurchasePendingChange",
    "MarketplacePurchasePendingChangePropSender",
    "MarketplacePurchasePendingChangePropMarketplacePurchase",
    "MarketplacePurchasePendingChangePropMarketplacePurchaseAllof1",
    "MarketplacePurchasePendingChangeCancelled",
    "MarketplacePurchasePendingChangeCancelledPropSender",
    "MarketplacePurchasePendingChangeCancelledPropMarketplacePurchase",
    "MarketplacePurchasePendingChangeCancelledPropMarketplacePurchaseAllof1",
    "MarketplacePurchasePurchased",
    "MarketplacePurchasePurchasedPropSender",
    "MarketplacePurchasePurchasedPropMarketplacePurchase",
    "MarketplacePurchasePurchasedPropMarketplacePurchaseAllof1",
    "MemberAdded",
    "MemberAddedPropChanges",
    "MemberAddedPropChangesPropPermission",
    "MemberEdited",
    "MemberEditedPropChanges",
    "MemberEditedPropChangesPropOldPermission",
    "MemberRemoved",
    "MembershipAdded",
    "Team",
    "TeamPropParent",
    "MembershipRemoved",
    "MembershipRemovedPropTeamOneof1",
    "MergeGroupChecksRequested",
    "MergeGroupChecksRequestedPropMergeGroup",
    "MetaDeleted",
    "MetaDeletedPropHook",
    "MetaDeletedPropHookPropConfig",
    "MilestoneClosed",
    "MilestoneClosedPropMilestone",
    "MilestoneClosedPropMilestoneAllof1",
    "MilestoneCreated",
    "MilestoneCreatedPropMilestone",
    "MilestoneCreatedPropMilestoneAllof1",
    "MilestoneDeleted",
    "MilestoneEdited",
    "MilestoneEditedPropChanges",
    "MilestoneEditedPropChangesPropDescription",
    "MilestoneEditedPropChangesPropDueOn",
    "MilestoneEditedPropChangesPropTitle",
    "MilestoneOpened",
    "MilestoneOpenedPropMilestone",
    "MilestoneOpenedPropMilestoneAllof1",
    "OrgBlockBlocked",
    "OrgBlockUnblocked",
    "OrganizationDeleted",
    "Membership",
    "OrganizationMemberAdded",
    "OrganizationMemberInvited",
    "OrganizationMemberInvitedPropInvitation",
    "OrganizationMemberRemoved",
    "OrganizationRenamed",
    "PackagePublished",
    "PackagePublishedPropPackage",
    "PackagePublishedPropPackagePropPackageVersion",
    "PackagePublishedPropPackagePropPackageVersionPropRelease",
    "PackagePublishedPropPackagePropPackageVersionPropPackageFilesItems",
    "PackagePublishedPropPackagePropRegistry",
    "PackageUpdated",
    "PackageUpdatedPropPackage",
    "PackageUpdatedPropPackagePropPackageVersion",
    "PackageUpdatedPropPackagePropPackageVersionPropRelease",
    "PackageUpdatedPropPackagePropPackageVersionPropPackageFilesItems",
    "PackageUpdatedPropPackagePropRegistry",
    "PageBuildEvent",
    "PageBuildEventPropBuild",
    "PageBuildEventPropBuildPropError",
    "PingEvent",
    "PingEventPropHook",
    "PingEventPropHookPropConfig",
    "PingEventPropHookPropLastResponse",
    "ProjectClosed",
    "Project",
    "ProjectCreated",
    "ProjectDeleted",
    "ProjectEdited",
    "ProjectEditedPropChanges",
    "ProjectEditedPropChangesPropName",
    "ProjectEditedPropChangesPropBody",
    "ProjectReopened",
    "ProjectCardConverted",
    "ProjectCardConvertedPropChanges",
    "ProjectCardConvertedPropChangesPropNote",
    "ProjectCard",
    "ProjectCardCreated",
    "ProjectCardDeleted",
    "ProjectCardEdited",
    "ProjectCardEditedPropChanges",
    "ProjectCardEditedPropChangesPropNote",
    "ProjectCardMoved",
    "ProjectCardMovedPropChanges",
    "ProjectCardMovedPropChangesPropColumnId",
    "ProjectCardMovedPropProjectCard",
    "ProjectCardMovedPropProjectCardAllof1",
    "ProjectColumnCreated",
    "ProjectColumn",
    "ProjectColumnDeleted",
    "ProjectColumnEdited",
    "ProjectColumnEditedPropChanges",
    "ProjectColumnEditedPropChangesPropName",
    "ProjectColumnMoved",
    "ProjectsV2ItemArchived",
    "ProjectsV2ItemArchivedPropChanges",
    "ProjectsV2ItemArchivedPropChangesPropArchivedAt",
    "ProjectsV2ItemArchivedPropProjectsV2Item",
    "ProjectsV2Item",
    "ProjectsV2ItemArchivedPropProjectsV2ItemAllof1",
    "ProjectsV2ItemConverted",
    "ProjectsV2ItemConvertedPropChanges",
    "ProjectsV2ItemConvertedPropChangesPropContentType",
    "ProjectsV2ItemConvertedPropProjectsV2Item",
    "ProjectsV2ItemConvertedPropProjectsV2ItemAllof1",
    "ProjectsV2ItemCreated",
    "ProjectsV2ItemCreatedPropProjectsV2Item",
    "ProjectsV2ItemCreatedPropProjectsV2ItemAllof1",
    "ProjectsV2ItemDeleted",
    "ProjectsV2ItemEdited",
    "ProjectsV2ItemEditedPropChanges",
    "ProjectsV2ItemEditedPropChangesPropFieldValue",
    "ProjectsV2ItemReordered",
    "ProjectsV2ItemReorderedPropChanges",
    "ProjectsV2ItemReorderedPropChangesPropPreviousProjectsV2ItemNodeId",
    "ProjectsV2ItemRestored",
    "ProjectsV2ItemRestoredPropChanges",
    "ProjectsV2ItemRestoredPropChangesPropArchivedAt",
    "ProjectsV2ItemRestoredPropProjectsV2Item",
    "ProjectsV2ItemRestoredPropProjectsV2ItemAllof1",
    "PublicEvent",
    "PublicEventPropRepository",
    "PublicEventPropRepositoryAllof1",
    "PullRequestAssigned",
    "PullRequest",
    "PullRequestPropHead",
    "PullRequestPropBase",
    "PullRequestPropLinks",
    "Link",
    "AutoMerge",
    "PullRequestAutoMergeDisabled",
    "PullRequestAutoMergeEnabled",
    "PullRequestClosed",
    "PullRequestClosedPropPullRequest",
    "PullRequestClosedPropPullRequestAllof1",
    "PullRequestConvertedToDraft",
    "PullRequestConvertedToDraftPropPullRequest",
    "PullRequestConvertedToDraftPropPullRequestAllof1",
    "PullRequestDequeued",
    "PullRequestEdited",
    "PullRequestEditedPropChanges",
    "PullRequestEditedPropChangesPropBody",
    "PullRequestEditedPropChangesPropTitle",
    "PullRequestEditedPropChangesPropBase",
    "PullRequestEditedPropChangesPropBasePropRef",
    "PullRequestEditedPropChangesPropBasePropSha",
    "PullRequestLabeled",
    "PullRequestLocked",
    "PullRequestOpened",
    "PullRequestOpenedPropPullRequest",
    "PullRequestOpenedPropPullRequestAllof1",
    "PullRequestQueued",
    "PullRequestReadyForReview",
    "PullRequestReadyForReviewPropPullRequest",
    "PullRequestReadyForReviewPropPullRequestAllof1",
    "PullRequestReopened",
    "PullRequestReopenedPropPullRequest",
    "PullRequestReopenedPropPullRequestAllof1",
    "PullRequestReviewRequestRemovedOneof0",
    "PullRequestReviewRequestRemovedOneof1",
    "PullRequestReviewRequestedOneof0",
    "PullRequestReviewRequestedOneof1",
    "PullRequestSynchronize",
    "PullRequestUnassigned",
    "PullRequestUnlabeled",
    "PullRequestUnlocked",
    "PullRequestReviewDismissed",
    "PullRequestReviewDismissedPropReview",
    "PullRequestReview",
    "PullRequestReviewPropLinks",
    "PullRequestReviewDismissedPropReviewAllof1",
    "SimplePullRequest",
    "SimplePullRequestPropHead",
    "SimplePullRequestPropBase",
    "SimplePullRequestPropLinks",
    "PullRequestReviewEdited",
    "PullRequestReviewEditedPropChanges",
    "PullRequestReviewEditedPropChangesPropBody",
    "PullRequestReviewSubmitted",
    "PullRequestReviewCommentCreated",
    "PullRequestReviewComment",
    "PullRequestReviewCommentPropLinks",
    "PullRequestReviewCommentCreatedPropPullRequest",
    "PullRequestReviewCommentCreatedPropPullRequestPropHead",
    "PullRequestReviewCommentCreatedPropPullRequestPropBase",
    "PullRequestReviewCommentCreatedPropPullRequestPropLinks",
    "PullRequestReviewCommentDeleted",
    "PullRequestReviewCommentDeletedPropPullRequest",
    "PullRequestReviewCommentDeletedPropPullRequestPropHead",
    "PullRequestReviewCommentDeletedPropPullRequestPropBase",
    "PullRequestReviewCommentDeletedPropPullRequestPropLinks",
    "PullRequestReviewCommentEdited",
    "PullRequestReviewCommentEditedPropChanges",
    "PullRequestReviewCommentEditedPropChangesPropBody",
    "PullRequestReviewCommentEditedPropPullRequest",
    "PullRequestReviewCommentEditedPropPullRequestPropHead",
    "PullRequestReviewCommentEditedPropPullRequestPropBase",
    "PullRequestReviewCommentEditedPropPullRequestPropLinks",
    "PullRequestReviewThreadResolved",
    "PullRequestReviewThreadResolvedPropThread",
    "PullRequestReviewThreadUnresolved",
    "PullRequestReviewThreadUnresolvedPropThread",
    "PushEvent",
    "Commit",
    "ReleaseCreated",
    "Release",
    "ReleaseAsset",
    "ReleaseDeleted",
    "ReleaseEdited",
    "ReleaseEditedPropChanges",
    "ReleaseEditedPropChangesPropBody",
    "ReleaseEditedPropChangesPropName",
    "ReleasePrereleased",
    "ReleasePrereleasedPropRelease",
    "ReleasePrereleasedPropReleaseAllof1",
    "ReleasePublished",
    "ReleasePublishedPropRelease",
    "ReleasePublishedPropReleaseAllof1",
    "ReleaseReleased",
    "ReleaseUnpublished",
    "ReleaseUnpublishedPropRelease",
    "ReleaseUnpublishedPropReleaseAllof1",
    "RepositoryArchived",
    "RepositoryArchivedPropRepository",
    "RepositoryArchivedPropRepositoryAllof1",
    "RepositoryCreated",
    "RepositoryDeleted",
    "RepositoryEdited",
    "RepositoryEditedPropChanges",
    "RepositoryEditedPropChangesPropDescription",
    "RepositoryEditedPropChangesPropDefaultBranch",
    "RepositoryEditedPropChangesPropHomepage",
    "RepositoryPrivatized",
    "RepositoryPrivatizedPropRepository",
    "RepositoryPrivatizedPropRepositoryAllof1",
    "RepositoryPublicized",
    "RepositoryPublicizedPropRepository",
    "RepositoryPublicizedPropRepositoryAllof1",
    "RepositoryRenamed",
    "RepositoryRenamedPropChanges",
    "RepositoryRenamedPropChangesPropRepository",
    "RepositoryRenamedPropChangesPropRepositoryPropName",
    "RepositoryTransferred",
    "RepositoryTransferredPropChanges",
    "RepositoryTransferredPropChangesPropOwner",
    "RepositoryTransferredPropChangesPropOwnerPropFrom",
    "RepositoryUnarchived",
    "RepositoryUnarchivedPropRepository",
    "RepositoryUnarchivedPropRepositoryAllof1",
    "RepositoryDispatchEvent",
    "RepositoryDispatchEventPropClientPayload",
    "RepositoryImportEvent",
    "RepositoryVulnerabilityAlertCreate",
    "RepositoryVulnerabilityAlertCreatePropAlert",
    "RepositoryVulnerabilityAlertAlert",
    "RepositoryVulnerabilityAlertCreatePropAlertAllof1",
    "RepositoryVulnerabilityAlertDismiss",
    "RepositoryVulnerabilityAlertDismissPropAlert",
    "RepositoryVulnerabilityAlertDismissPropAlertAllof1",
    "RepositoryVulnerabilityAlertReopen",
    "RepositoryVulnerabilityAlertReopenPropAlert",
    "RepositoryVulnerabilityAlertReopenPropAlertAllof1",
    "RepositoryVulnerabilityAlertResolve",
    "RepositoryVulnerabilityAlertResolvePropAlert",
    "RepositoryVulnerabilityAlertResolvePropAlertAllof1",
    "SecretScanningAlertCreated",
    "SecretScanningAlertCreatedPropAlert",
    "SecretScanningAlertReopened",
    "SecretScanningAlertReopenedPropAlert",
    "SecretScanningAlertResolved",
    "SecretScanningAlertResolvedPropAlert",
    "SecurityAdvisoryPerformed",
    "SecurityAdvisoryPerformedPropSecurityAdvisory",
    "SecurityAdvisoryPerformedPropSecurityAdvisoryPropCvss",
    "SecurityAdvisoryPerformedPropSecurityAdvisoryPropCwesItems",
    "SecurityAdvisoryPerformedPropSecurityAdvisoryPropIdentifiersItems",
    "SecurityAdvisoryPerformedPropSecurityAdvisoryPropReferencesItems",
    "SecurityAdvisoryPerformedPropSecurityAdvisoryPropVulnerabilitiesItems",
    "SecurityAdvisoryPerformedPropSecurityAdvisoryPropVulnerabilitiesItemsPropPackage",
    "SecurityAdvisoryPerformedPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersion",
    "SecurityAdvisoryPublished",
    "SecurityAdvisoryPublishedPropSecurityAdvisory",
    "SecurityAdvisoryPublishedPropSecurityAdvisoryPropCvss",
    "SecurityAdvisoryPublishedPropSecurityAdvisoryPropCwesItems",
    "SecurityAdvisoryPublishedPropSecurityAdvisoryPropIdentifiersItems",
    "SecurityAdvisoryPublishedPropSecurityAdvisoryPropReferencesItems",
    "SecurityAdvisoryPublishedPropSecurityAdvisoryPropVulnerabilitiesItems",
    "SecurityAdvisoryPublishedPropSecurityAdvisoryPropVulnerabilitiesItemsPropPackage",
    "SecurityAdvisoryPublishedPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersion",
    "SecurityAdvisoryUpdated",
    "SecurityAdvisoryUpdatedPropSecurityAdvisory",
    "SecurityAdvisoryUpdatedPropSecurityAdvisoryPropCvss",
    "SecurityAdvisoryUpdatedPropSecurityAdvisoryPropCwesItems",
    "SecurityAdvisoryUpdatedPropSecurityAdvisoryPropIdentifiersItems",
    "SecurityAdvisoryUpdatedPropSecurityAdvisoryPropReferencesItems",
    "SecurityAdvisoryUpdatedPropSecurityAdvisoryPropVulnerabilitiesItems",
    "SecurityAdvisoryUpdatedPropSecurityAdvisoryPropVulnerabilitiesItemsPropPackage",
    "SecurityAdvisoryUpdatedPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersion",
    "SecurityAdvisoryWithdrawn",
    "SecurityAdvisoryWithdrawnPropSecurityAdvisory",
    "SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropCvss",
    "SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropCwesItems",
    "SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropIdentifiersItems",
    "SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropReferencesItems",
    "SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropVulnerabilitiesItems",
    "SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropVulnerabilitiesItemsPropPackage",
    "SecurityAdvisoryWithdrawnPropSecurityAdvisoryPropVulnerabilitiesItemsPropFirstPatchedVersion",
    "SponsorshipCancelled",
    "SponsorshipCancelledPropSponsorship",
    "SponsorshipTier",
    "SponsorshipCreated",
    "SponsorshipCreatedPropSponsorship",
    "SponsorshipEdited",
    "SponsorshipEditedPropSponsorship",
    "SponsorshipEditedPropChanges",
    "SponsorshipEditedPropChangesPropPrivacyLevel",
    "SponsorshipPendingCancellation",
    "SponsorshipPendingCancellationPropSponsorship",
    "SponsorshipPendingTierChange",
    "SponsorshipPendingTierChangePropSponsorship",
    "SponsorshipPendingTierChangePropChanges",
    "SponsorshipPendingTierChangePropChangesPropTier",
    "SponsorshipTierChanged",
    "SponsorshipTierChangedPropSponsorship",
    "SponsorshipTierChangedPropChanges",
    "SponsorshipTierChangedPropChangesPropTier",
    "StarCreated",
    "StarDeleted",
    "StatusEvent",
    "StatusEventPropCommit",
    "StatusEventPropCommitPropCommit",
    "StatusEventPropCommitPropCommitPropAuthor",
    "StatusEventPropCommitPropCommitPropAuthorAllof1",
    "StatusEventPropCommitPropCommitPropCommitter",
    "StatusEventPropCommitPropCommitPropCommitterAllof1",
    "StatusEventPropCommitPropCommitPropTree",
    "StatusEventPropCommitPropCommitPropVerification",
    "StatusEventPropCommitPropParentsItems",
    "StatusEventPropBranchesItems",
    "StatusEventPropBranchesItemsPropCommit",
    "TeamAddedToRepository",
    "TeamCreated",
    "TeamDeleted",
    "TeamEdited",
    "TeamEditedPropChanges",
    "TeamEditedPropChangesPropDescription",
    "TeamEditedPropChangesPropName",
    "TeamEditedPropChangesPropPrivacy",
    "TeamEditedPropChangesPropRepository",
    "TeamEditedPropChangesPropRepositoryPropPermissions",
    "TeamEditedPropChangesPropRepositoryPropPermissionsPropFrom",
    "TeamRemovedFromRepository",
    "TeamAddEvent",
    "WatchStarted",
    "WorkflowDispatchEvent",
    "WorkflowDispatchEventPropInputsOneof0",
    "WorkflowJobCompleted",
    "WorkflowJobCompletedPropWorkflowJob",
    "WorkflowJob",
    "WorkflowStepInProgress",
    "WorkflowStepCompleted",
    "WorkflowJobCompletedPropWorkflowJobAllof1",
    "WorkflowJobInProgress",
    "WorkflowJobInProgressPropWorkflowJob",
    "WorkflowJobInProgressPropWorkflowJobAllof1",
    "WorkflowJobQueued",
    "WorkflowJobQueuedPropWorkflowJob",
    "WorkflowJobQueuedPropWorkflowJobAllof1",
    "WorkflowRunCompleted",
    "WorkflowRunCompletedPropWorkflowRun",
    "WorkflowRun",
    "RepositoryLite",
    "WorkflowRunPropPullRequestsItems",
    "WorkflowRunPropPullRequestsItemsPropHead",
    "WorkflowRunPropPullRequestsItemsPropBase",
    "WorkflowRunCompletedPropWorkflowRunAllof1",
    "WorkflowRunInProgress",
    "WorkflowRunRequested",
]
