## About

To Learn more, visit https://developer.gladefinance.co/docs

## Getting Started 
You need a Merchant ID and Key to authenticate against the API, please contact support@gladefinance.co to setup a demo account.

## Installation
You include the class in your project or you can add the repo in your files as in the example below:



## Set environment

```` 
from src.glade_functions import Glade

merchantId = "YOUR_MERCHANT_ID"
merchantKey = "YOUR_MERCHANT_KEY"
````

For Production environment
```` 
api = Glade(merchantId, merchantKey, True)
````

For Sandbox environment
```` 
api = Glade(merchantId, merchantKey, False)
````

## Methods
BVN Verification
```` 
api.bvnValidation(bvnNumber); 
````


Get Chargeable Banks
```` 
api.supportedChargeableBanks(); 
````

Get Bank List
```` 
api.bankList(); 
````

Verify Account Name
```` 
api.verifyAccountName(accountNumber, bankCode, bankName); 
````

Get Personalized Account Info
```` 
api.personalizedAccount( accountName, accountEmail, accountBvn, reference, channel = "providus"); 
````

Create Customer
```` 
api.createCustomer(name, email, phoneNumber, address); 
````

Get All Customers
```` 
api.getCustomers(); 
````

Get A Single Customer's Details
```` 
api.getCustomerDetail(customerId); 
````

Get All Bill Categories
```` 
api.getBillCategory(category = None); 
````

Get Bill ID
```` 
api.getBillById(billId); 
````

Resolve Bill
```` 
api.resolveBill(payCode, reference); 
````

Purchase Bill
```` 
api.purchaseBill(payCode, amount, reference, orderReference = None); 
````

Verify Bill Purchase
```` 
api.verifyBillPurchase(transactionReference); 
````

Make A Single Transfer
```` 
api.transfer(amount, receiverAccountNumber, receiverBankCode, senderName, reference, narration);
````

Verify Single Transfer
```` 
api.verifySingleTransfer(reference); 
````

Make Bulk Transfer
```` 
api.bulkTransfer(transferObjects); 
````

Create Payment Link
````
 api.createPaymentLink(title, description, amount, type, payerBearsFees, acceptNumber, notificationEmail, customLink = None, redirectUrl = None, customMessage = None, frequency = None); 
 ````

Create Ticket
````  
api.createTicket(title, description, amount, type, payerBearsFees, acceptNumber, notificationEmail, ticketData, customLink = None,  redirectUrl = None, customMessage = None, frequency = None); 
````

Create Invoice
```` 
api.invoice(customerId, chargeUser, shipping, vat, dueDate, allowedDiscount, invoiceItems, note, discountType = None, invoiceId = None); 
````


## Return Values
All methods return an array.
