import json


from com.alipay.ams.api.request.alipay_request import AlipayRequest


class AlipayPayCancelRequest(AlipayRequest):
    def __init__(self):
        super(AlipayPayCancelRequest, self).__init__("/ams/api/v1/payments/cancel")

        self.__payment_id = None  # type: str
        self.__payment_request_id = None  # type: str
        self.__merchant_account_id = None  # type: str

    @property
    def payment_id(self):
        """
        The original payment ID of the payment request to be canceled, generated by Antom to uniquely identify the payment when the merchant initiates the original payment. paymentId and paymentRequestId cannot both be null. A one-to-one correspondence between paymentId and paymentRequestId exists.  More information:  Maximum length: 64 characters
        """
        return self.__payment_id

    @payment_id.setter
    def payment_id(self, value):
        self.__payment_id = value

    @property
    def payment_request_id(self):
        """
        The original payment request ID of the payment request to be canceled, generated by the merchant to uniquely identify a payment request. paymentRequestId and paymentId cannot both be null. If both paymentRequestId and paymentId are provided, paymentId takes precedence.  More information:  Maximum length: 64 characters
        """
        return self.__payment_request_id

    @payment_request_id.setter
    def payment_request_id(self, value):
        self.__payment_request_id = value

    @property
    def merchant_account_id(self):
        """
        The unique ID to identify a merchant account.  Note: Specify this parameter when you use a single client ID across multiple locations.  More information:  Maximum length: 32 characters
        """
        return self.__merchant_account_id

    @merchant_account_id.setter
    def merchant_account_id(self, value):
        self.__merchant_account_id = value

    def to_ams_json(self):
        json_str = json.dumps(
            obj=self.to_ams_dict(), default=lambda o: o.to_ams_dict(), indent=3
        )
        return json_str

    def to_ams_dict(self):
        params = dict()
        if hasattr(self, "payment_id") and self.payment_id is not None:
            params["paymentId"] = self.payment_id
        if hasattr(self, "payment_request_id") and self.payment_request_id is not None:
            params["paymentRequestId"] = self.payment_request_id
        if (
            hasattr(self, "merchant_account_id")
            and self.merchant_account_id is not None
        ):
            params["merchantAccountId"] = self.merchant_account_id
        return params

    def parse_rsp_body(self, response_body):
        if isinstance(response_body, str):
            response_body = json.loads(response_body)
        if "paymentId" in response_body:
            self.__payment_id = response_body["paymentId"]
        if "paymentRequestId" in response_body:
            self.__payment_request_id = response_body["paymentRequestId"]
        if "merchantAccountId" in response_body:
            self.__merchant_account_id = response_body["merchantAccountId"]
