import json
from com.alipay.ams.api.model.result import Result


from com.alipay.ams.api.response.alipay_response import AlipayResponse


class AlipaySubscriptionUpdateResponse(AlipayResponse):
    def __init__(self, rsp_body):
        super(AlipayResponse, self).__init__()

        self.__result = None  # type: Result
        self.parse_rsp_body(rsp_body)

    @property
    def result(self):
        """Gets the result of this AlipaySubscriptionUpdateResponse."""
        return self.__result

    @result.setter
    def result(self, value):
        self.__result = value

    def to_ams_dict(self):
        params = dict()
        if hasattr(self, "result") and self.result is not None:
            params["result"] = self.result
        return params

    def parse_rsp_body(self, response_body):
        response_body = super(AlipaySubscriptionUpdateResponse, self).parse_rsp_body(
            response_body
        )
        if "result" in response_body:
            self.__result = Result()
            self.__result.parse_rsp_body(response_body["result"])
