# coding: utf-8

"""
    gnomock

    `gnomock` is an HTTP wrapper for [Gnomock](https://github.com/orlangure/gnomock) integration and end-to-end testing toolkit. It allows to use Gnomock outside of Go ecosystem. Not all Gnomock features exist in this wrapper, but official presets, as well as basic general configuration, are supported.   # noqa: E501

    The version of the OpenAPI document: 1.6.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from gnomock.configuration import Configuration


class Kafka(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'messages': 'list[KafkaMessages]',
        'messages_files': 'list[str]',
        'topics': 'list[str]',
        'version': 'str'
    }

    attribute_map = {
        'messages': 'messages',
        'messages_files': 'messages_files',
        'topics': 'topics',
        'version': 'version'
    }

    def __init__(self, messages=None, messages_files=None, topics=None, version='2.5.1-L0', local_vars_configuration=None):  # noqa: E501
        """Kafka - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._messages = None
        self._messages_files = None
        self._topics = None
        self._version = None
        self.discriminator = None

        if messages is not None:
            self.messages = messages
        if messages_files is not None:
            self.messages_files = messages_files
        if topics is not None:
            self.topics = topics
        if version is not None:
            self.version = version

    @property
    def messages(self):
        """Gets the messages of this Kafka.  # noqa: E501

        A list of messages to send to Kafka.  # noqa: E501

        :return: The messages of this Kafka.  # noqa: E501
        :rtype: list[KafkaMessages]
        """
        return self._messages

    @messages.setter
    def messages(self, messages):
        """Sets the messages of this Kafka.

        A list of messages to send to Kafka.  # noqa: E501

        :param messages: The messages of this Kafka.  # noqa: E501
        :type: list[KafkaMessages]
        """

        self._messages = messages

    @property
    def messages_files(self):
        """Gets the messages_files of this Kafka.  # noqa: E501


        :return: The messages_files of this Kafka.  # noqa: E501
        :rtype: list[str]
        """
        return self._messages_files

    @messages_files.setter
    def messages_files(self, messages_files):
        """Sets the messages_files of this Kafka.


        :param messages_files: The messages_files of this Kafka.  # noqa: E501
        :type: list[str]
        """

        self._messages_files = messages_files

    @property
    def topics(self):
        """Gets the topics of this Kafka.  # noqa: E501

        Topic names to create in Kafka.  # noqa: E501

        :return: The topics of this Kafka.  # noqa: E501
        :rtype: list[str]
        """
        return self._topics

    @topics.setter
    def topics(self, topics):
        """Sets the topics of this Kafka.

        Topic names to create in Kafka.  # noqa: E501

        :param topics: The topics of this Kafka.  # noqa: E501
        :type: list[str]
        """

        self._topics = topics

    @property
    def version(self):
        """Gets the version of this Kafka.  # noqa: E501

        Kafka version.  # noqa: E501

        :return: The version of this Kafka.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this Kafka.

        Kafka version.  # noqa: E501

        :param version: The version of this Kafka.  # noqa: E501
        :type: str
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Kafka):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Kafka):
            return True

        return self.to_dict() != other.to_dict()
