import typing

import httplib2  # type: ignore
import typing_extensions

import googleapiclient.discovery
import googleapiclient.http  # type: ignore

from .schemas import *

class BloggerResource(googleapiclient.discovery.Resource):
    class PostsResource(googleapiclient.discovery.Resource):
        def list(
            self,
            *,
            blogId: str,
            fetchBodies: bool = ...,
            startDate: str = ...,
            maxResults: int = ...,
            pageToken: str = ...,
            **kwargs: typing.Any
        ) -> PostListHttpRequest: ...
        def get(
            self, *, blogId: str, postId: str, **kwargs: typing.Any
        ) -> PostHttpRequest: ...
    class CommentsResource(googleapiclient.discovery.Resource):
        def list(
            self,
            *,
            blogId: str,
            postId: str,
            maxResults: int = ...,
            fetchBodies: bool = ...,
            pageToken: str = ...,
            startDate: str = ...,
            **kwargs: typing.Any
        ) -> CommentListHttpRequest: ...
        def get(
            self, *, blogId: str, postId: str, commentId: str, **kwargs: typing.Any
        ) -> CommentHttpRequest: ...
    class PagesResource(googleapiclient.discovery.Resource):
        def list(
            self, *, blogId: str, fetchBodies: bool = ..., **kwargs: typing.Any
        ) -> PageListHttpRequest: ...
        def get(
            self, *, blogId: str, pageId: str, **kwargs: typing.Any
        ) -> PageHttpRequest: ...
    class BlogsResource(googleapiclient.discovery.Resource):
        def list(self, *, userId: str, **kwargs: typing.Any) -> BlogListHttpRequest: ...
        def get(self, *, blogId: str, **kwargs: typing.Any) -> BlogHttpRequest: ...
    class UsersResource(googleapiclient.discovery.Resource):
        def get(self, *, userId: str, **kwargs: typing.Any) -> UserHttpRequest: ...
    def posts(self) -> PostsResource: ...
    def comments(self) -> CommentsResource: ...
    def pages(self) -> PagesResource: ...
    def blogs(self) -> BlogsResource: ...
    def users(self) -> UsersResource: ...

class BlogListHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> BlogList: ...

class PostHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> Post: ...

class PostListHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> PostList: ...

class PageHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> Page: ...

class PageListHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> PageList: ...

class CommentListHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> CommentList: ...

class BlogHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> Blog: ...

class UserHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> User: ...

class CommentHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> Comment: ...
