import typing

import httplib2  # type: ignore
import typing_extensions

import googleapiclient.discovery
import googleapiclient.http  # type: ignore

from .schemas import *

class SearchConsoleResource(googleapiclient.discovery.Resource):
    class SitemapsResource(googleapiclient.discovery.Resource):
        def get(
            self, *, siteUrl: str, feedpath: str, **kwargs: typing.Any
        ) -> WmxSitemapHttpRequest: ...
        def submit(
            self, *, siteUrl: str, feedpath: str, **kwargs: typing.Any
        ) -> googleapiclient.http.HttpRequest: ...
        def delete(
            self, *, siteUrl: str, feedpath: str, **kwargs: typing.Any
        ) -> googleapiclient.http.HttpRequest: ...
        def list(
            self, *, siteUrl: str, sitemapIndex: str = ..., **kwargs: typing.Any
        ) -> SitemapsListResponseHttpRequest: ...
    class SitesResource(googleapiclient.discovery.Resource):
        def get(self, *, siteUrl: str, **kwargs: typing.Any) -> WmxSiteHttpRequest: ...
        def add(
            self, *, siteUrl: str, **kwargs: typing.Any
        ) -> googleapiclient.http.HttpRequest: ...
        def list(self, **kwargs: typing.Any) -> SitesListResponseHttpRequest: ...
        def delete(
            self, *, siteUrl: str, **kwargs: typing.Any
        ) -> googleapiclient.http.HttpRequest: ...
    class SearchanalyticsResource(googleapiclient.discovery.Resource):
        def query(
            self,
            *,
            siteUrl: str,
            body: SearchAnalyticsQueryRequest = ...,
            **kwargs: typing.Any
        ) -> SearchAnalyticsQueryResponseHttpRequest: ...
    class UrlTestingToolsResource(googleapiclient.discovery.Resource):
        class MobileFriendlyTestResource(googleapiclient.discovery.Resource):
            def run(
                self, *, body: RunMobileFriendlyTestRequest = ..., **kwargs: typing.Any
            ) -> RunMobileFriendlyTestResponseHttpRequest: ...
        def mobileFriendlyTest(self) -> MobileFriendlyTestResource: ...
    def sitemaps(self) -> SitemapsResource: ...
    def sites(self) -> SitesResource: ...
    def searchanalytics(self) -> SearchanalyticsResource: ...
    def urlTestingTools(self) -> UrlTestingToolsResource: ...

class RunMobileFriendlyTestResponseHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> RunMobileFriendlyTestResponse: ...

class WmxSiteHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> WmxSite: ...

class SearchAnalyticsQueryResponseHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> SearchAnalyticsQueryResponse: ...

class SitesListResponseHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> SitesListResponse: ...

class SitemapsListResponseHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> SitemapsListResponse: ...

class WmxSitemapHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> WmxSitemap: ...
